import{s as st,n as ot,o as it}from"../chunks/scheduler.00bde567.js";import{S as ct,i as rt,g as o,s as n,r as d,A as dt,h as i,f as l,c as s,j as at,u as M,x as c,k as nt,y as Mt,a,v as y,d as p,t as w,w as h}from"../chunks/index.752e2ff6.js";import{C as K}from"../chunks/CodeBlock.e62cd1dc.js";import{H as _e}from"../chunks/Heading.476d3364.js";function yt(Ze){let r,D,E,q,m,O,u,xe=`PyTorch’s distributed module operates by communicating back and forth between all of the GPUs in your system.
This communication takes time, and ensuring all processes know the states of each other happens at particular triggerpoints
when using the <code>ddp</code> module.`,ee,U,ze=`These triggerpoints are added to the PyTorch model, specifically their <code>forward()</code> and <code>backward()</code> methods.
This happens when the model is wrapped with <code>DistributedDataParallel</code>:`,te,T,le,J,We='In 🤗 Accelerate this conversion happens automatically when calling <a href="/docs/accelerate/v0.25.0/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> and passing in your model.',ae,C,ne,j,se,b,$e=`You now understand that PyTorch adds hooks to the <code>forward</code> and <code>backward</code> method of your PyTorch model when
training in a distributed setup. But how does this risk slowing down your code?`,oe,f,Ve=`In DDP (distributed data parallel), the specific order in which processes are performed and ran are expected
at specific points and these must also occur at roughly the same time before moving on.`,ie,I,Re=`The most direct example is when you update model parameters through
<code>optimizer.step()</code>.
Without gradient accumulation, all instances of the model need to have updated
their gradients computed, collated, and updated before moving on to the next
batch of data.
When performing gradient accumulation, you accumulate <code>n</code> loss gradients and
skip <code>optimizer.step()</code> until <code>n</code> batches have been reached. As all training
processes only need to synchronize by the time <code>optimizer.step()</code> is called,
without any modification to your training step, this needless inter-process
communication can cause a significant slowdown.`,ce,G,He="How can you avoid this overhead?",re,g,de,v,Xe=`Since you are skipping model parameter updates when training on these batches, their gradients do not need to be synchronized until the point where <code>optimizer.step()</code> is actually called.
PyTorch cannot automagically tell when you need to do this, but they do provide a tool to help through the <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html#torch.nn.parallel.DistributedDataParallel.no_sync" rel="nofollow"><code>no_sync</code></a> context manager
that is added to your model after converting it to DDP.`,Me,A,Ye=`Under this context manager, PyTorch will skip synchronizing the gradients when
<code>.backward()</code> is called, and the first call to <code>.backward()</code> outside this
context manager will trigger the synchronization. See an example below:`,ye,k,pe,B,Se=`In 🤗 Accelerate to make this an API that can be called no matter the training device (though it may not do anything if you are not in a distributed system!),
<code>ddp_model.no_sync</code> gets replaced with <a href="/docs/accelerate/v0.25.0/en/package_reference/accelerator#accelerate.Accelerator.no_sync">no_sync()</a> and operates the same way:`,we,_,he,Z,Le=`As you may expect, the <a href="/docs/accelerate/v0.25.0/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> function wraps around this conditional check by keeping track of the current batch number, leaving you with the final
gradient accumulation API:`,me,x,ue,z,Qe="As a result, you should either use <em><code>accelerator.accumulate</code> or <code>accelerator.no_sync</code></em> when it comes to API choice.",Ue,W,Te,$,Pe="To set up a realistic example, consider the following setup:",Je,V,Fe='<li>Two single-GPU T4 nodes and one node with two GPUs</li> <li>Each GPU is a T4, and are hosted on GCP</li> <li>The script used is a modification of the <a href="https://github.com/muellerzr/timing_experiments/blob/main/baseline.py" rel="nofollow">NLP Example</a> script</li> <li>Batch size per GPU is 16, and gradients are accumulated every 4 steps</li>',Ce,R,Ee='All scripts are available in <a href="https://github.com/muellerzr/timing_experiments" rel="nofollow">this repository</a>.',je,H,Ne=`If not careful about gradient synchronization and GPU communication, a <em>large</em> amount of time can be wasted
from when these GPUs communicate to each other during unnecessary periods.`,be,X,Ke="By how much?",fe,Y,De="Reference:",Ie,S,qe='<li>Baseline: uses no synchronization practices discussed here</li> <li><code>no_sync</code> improperly: <code>no_sync</code> only around the <code>backward</code> call, not the <code>forward</code></li> <li><code>no_sync</code>: using the <code>no_sync</code> pattern properly</li> <li><code>accumulate</code>: using <a href="/docs/accelerate/v0.25.0/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> properly</li>',Ge,L,Oe="Below are the average seconds per batch iterating over 29 batches of data for each setup on both a single node and on the dual-node setup:",ge,Q,et='<thead><tr><th align="center"></th> <th align="center">Baseline</th> <th align="center"><code>no_sync</code> improperly</th> <th align="center"><code>no_sync</code></th> <th align="center"><code>accumulate</code></th></tr></thead> <tbody><tr><td align="center">Multi-Node</td> <td align="center">2±0.01s</td> <td align="center">2.13±0.08s</td> <td align="center"><strong>0.91±0.11s</strong></td> <td align="center"><strong>0.91±0.11s</strong></td></tr> <tr><td align="center">Single Node</td> <td align="center">0.50±0.01s</td> <td align="center">0.50±0.01s</td> <td align="center"><strong>0.41±0.015s</strong></td> <td align="center"><strong>0.41±0.015s</strong></td></tr></tbody>',ve,P,tt="As you can see, if you are not careful about how you set up your gradient synchronization, you can get upwards of more than a 2x slowdown during training!",Ae,F,lt=`If you are worried about making sure everything is done properly, we highly recommend utilizing the <a href="/docs/accelerate/v0.25.0/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> function and passing in
<code>gradient_accumulation_steps</code> or <code>gradient_accumulation_plugin</code> to the <a href="/docs/accelerate/v0.25.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object so Accelerate can handle this for you.`,ke,N,Be;return m=new _e({props:{title:"Gradient Synchronization",local:"gradient-synchronization",headingTag:"h1"}}),T=new K({props:{code:"aW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBZnJvbSUyMHRvcmNoLm5uLnBhcmFsbGVsJTIwaW1wb3J0JTIwRGlzdHJpYnV0ZWREYXRhUGFyYWxsZWwlMEElMEFtb2RlbCUyMCUzRCUyMG5uLkxpbmVhcigxMCUyQyUyMDEwKSUwQWRkcF9tb2RlbCUyMCUzRCUyMERpc3RyaWJ1dGVkRGF0YVBhcmFsbGVsKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> torch.nn.parallel <span class="hljs-keyword">import</span> DistributedDataParallel

model = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
ddp_model = DistributedDataParallel(model)`,wrap:!1}}),C=new K({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMCUyMGltcG9ydCUyMHRvcmNoLm5uJTIwYXMlMjBubiUwQS0lMjBmcm9tJTIwdG9yY2gubm4ucGFyYWxsZWwlMjBpbXBvcnQlMjBEaXN0cmlidXRlZERhdGFQYXJhbGxlbCUwQSUwQSUyMCUyMG1vZGVsJTIwJTNEJTIwbm4uTGluZWFyKDEwJTJDMTApJTBBJTJCJTIwbW9kZWwlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsKQ==",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
<span class="hljs-addition">+ accelerator = Accelerator()</span>
  import torch.nn as nn
<span class="hljs-deletion">- from torch.nn.parallel import DistributedDataParallel</span>

  model = nn.Linear(10,10)
<span class="hljs-addition">+ model = accelerator.prepare(model)</span>`,wrap:!1}}),j=new _e({props:{title:"The slowdown in gradient accumulation",local:"the-slowdown-in-gradient-accumulation",headingTag:"h2"}}),g=new _e({props:{title:"Solving the slowdown problem",local:"solving-the-slowdown-problem",headingTag:"h2"}}),k=new K({props:{code:"ZGRwX21vZGVsJTJDJTIwZGF0YWxvYWRlciUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBkYXRhbG9hZGVyJTJDJTIwb3B0aW1pemVyKSUwQSUwQWZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZShkYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBncmFkaWVudCUyMHN5bmNocm9uaXphdGlvbiUyMG9uJTIwdGhlJTIwbGFzdCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwaWYlMjBpbmRleCUyMCElM0QlMjAobGVuKGRhdGFsb2FkZXIpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGRkcF9tb2RlbC5ub19zeW5jKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHcmFkaWVudHMlMjBvbmx5JTIwYWNjdW11bGF0ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBkZHBfbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmMob3V0cHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHcmFkaWVudHMlMjBmaW5hbGx5JTIwc3luYyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBkZHBfbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmMob3V0cHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCk=",highlighted:`ddp_model, dataloader, optimizer = accelerator.prepare(model, dataloader, optimizer)

<span class="hljs-keyword">for</span> index, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader):
    inputs, targets = batch
    <span class="hljs-comment"># Trigger gradient synchronization on the last batch</span>
    <span class="hljs-keyword">if</span> index != (<span class="hljs-built_in">len</span>(dataloader) - <span class="hljs-number">1</span>):
        <span class="hljs-keyword">with</span> ddp_model.no_sync():
            <span class="hljs-comment"># Gradients only accumulate</span>
            outputs = ddp_model(inputs)
            loss = loss_func(outputs)
            accelerator.backward(loss)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Gradients finally sync</span>
        outputs = ddp_model(inputs)
        loss = loss_func(outputs)
        accelerator.backward(loss)
        optimizer.step()`,wrap:!1}}),_=new K({props:{code:"JTIwJTIwZGRwX21vZGVsJTJDJTIwZGF0YWxvYWRlciUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBkYXRhbG9hZGVyJTJDJTIwb3B0aW1pemVyKSUwQSUwQSUyMCUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZShkYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBncmFkaWVudCUyMHN5bmNocm9uaXphdGlvbiUyMG9uJTIwdGhlJTIwbGFzdCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpbmRleCUyMCElM0QlMjAobGVuKGRhdGFsb2FkZXIpLTEpJTNBJTBBLSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBkZHBfbW9kZWwubm9fc3luYygpJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGFjY2VsZXJhdG9yLm5vX3N5bmMobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR3JhZGllbnRzJTIwb25seSUyMGFjY3VtdWxhdGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwZGRwX21vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEdyYWRpZW50cyUyMGZpbmFsbHklMjBzeW5jJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMGRkcF9tb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuYyhvdXRwdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`  ddp_model, dataloader, optimizer = accelerator.prepare(model, dataloader, optimizer)

  for index, batch in enumerate(dataloader):
      inputs, targets = batch
      # Trigger gradient synchronization on the last batch
      if index != (len(dataloader)-1):
<span class="hljs-deletion">-         with ddp_model.no_sync():</span>
<span class="hljs-addition">+         with accelerator.no_sync(model):</span>
              # Gradients only accumulate
              outputs = ddp_model(inputs)
              loss = loss_func(outputs, targets)
              accelerator.backward(loss)
      else:
          # Gradients finally sync
          outputs = ddp_model(inputs)
          loss = loss_func(outputs)
          accelerator.backward(loss)
          optimizer.step()
          optimizer.zero_grad()`,wrap:!1}}),x=new K({props:{code:"ZGRwX21vZGVsJTJDJTIwZGF0YWxvYWRlciUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBkYXRhbG9hZGVyJTJDJTIwb3B0aW1pemVyKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjBkYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGFjY2VsZXJhdG9yLmFjY3VtdWxhdGUobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCk=",highlighted:`ddp_model, dataloader, optimizer = accelerator.prepare(model, dataloader, optimizer)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        optimizer.zero_grad()
        inputs, targets = batch
        outputs = model(inputs)
        loss = loss_function(outputs, targets)
        accelerator.backward(loss)
        optimizer.step()
        optimizer.zero_grad()`,wrap:!1}}),W=new _e({props:{title:"Just how much of a slowdown is there, and easy mistakes you can make",local:"just-how-much-of-a-slowdown-is-there-and-easy-mistakes-you-can-make",headingTag:"h2"}}),{c(){r=o("meta"),D=n(),E=o("p"),q=n(),d(m.$$.fragment),O=n(),u=o("p"),u.innerHTML=xe,ee=n(),U=o("p"),U.innerHTML=ze,te=n(),d(T.$$.fragment),le=n(),J=o("p"),J.innerHTML=We,ae=n(),d(C.$$.fragment),ne=n(),d(j.$$.fragment),se=n(),b=o("p"),b.innerHTML=$e,oe=n(),f=o("p"),f.textContent=Ve,ie=n(),I=o("p"),I.innerHTML=Re,ce=n(),G=o("p"),G.textContent=He,re=n(),d(g.$$.fragment),de=n(),v=o("p"),v.innerHTML=Xe,Me=n(),A=o("p"),A.innerHTML=Ye,ye=n(),d(k.$$.fragment),pe=n(),B=o("p"),B.innerHTML=Se,we=n(),d(_.$$.fragment),he=n(),Z=o("p"),Z.innerHTML=Le,me=n(),d(x.$$.fragment),ue=n(),z=o("p"),z.innerHTML=Qe,Ue=n(),d(W.$$.fragment),Te=n(),$=o("p"),$.textContent=Pe,Je=n(),V=o("ul"),V.innerHTML=Fe,Ce=n(),R=o("p"),R.innerHTML=Ee,je=n(),H=o("p"),H.innerHTML=Ne,be=n(),X=o("p"),X.textContent=Ke,fe=n(),Y=o("p"),Y.textContent=De,Ie=n(),S=o("ul"),S.innerHTML=qe,Ge=n(),L=o("p"),L.textContent=Oe,ge=n(),Q=o("table"),Q.innerHTML=et,ve=n(),P=o("p"),P.textContent=tt,Ae=n(),F=o("p"),F.innerHTML=lt,ke=n(),N=o("p"),this.h()},l(e){const t=dt("svelte-u9bgzb",document.head);r=i(t,"META",{name:!0,content:!0}),t.forEach(l),D=s(e),E=i(e,"P",{}),at(E).forEach(l),q=s(e),M(m.$$.fragment,e),O=s(e),u=i(e,"P",{"data-svelte-h":!0}),c(u)!=="svelte-1bq702f"&&(u.innerHTML=xe),ee=s(e),U=i(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-fqoolu"&&(U.innerHTML=ze),te=s(e),M(T.$$.fragment,e),le=s(e),J=i(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-194e964"&&(J.innerHTML=We),ae=s(e),M(C.$$.fragment,e),ne=s(e),M(j.$$.fragment,e),se=s(e),b=i(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-byuygg"&&(b.innerHTML=$e),oe=s(e),f=i(e,"P",{"data-svelte-h":!0}),c(f)!=="svelte-w9p09z"&&(f.textContent=Ve),ie=s(e),I=i(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1qb001k"&&(I.innerHTML=Re),ce=s(e),G=i(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-14tkwrb"&&(G.textContent=He),re=s(e),M(g.$$.fragment,e),de=s(e),v=i(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-olrkxe"&&(v.innerHTML=Xe),Me=s(e),A=i(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-cn8x56"&&(A.innerHTML=Ye),ye=s(e),M(k.$$.fragment,e),pe=s(e),B=i(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-14ihp9k"&&(B.innerHTML=Se),we=s(e),M(_.$$.fragment,e),he=s(e),Z=i(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-e6xkuy"&&(Z.innerHTML=Le),me=s(e),M(x.$$.fragment,e),ue=s(e),z=i(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1b3vx79"&&(z.innerHTML=Qe),Ue=s(e),M(W.$$.fragment,e),Te=s(e),$=i(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1hdyapv"&&($.textContent=Pe),Je=s(e),V=i(e,"UL",{"data-svelte-h":!0}),c(V)!=="svelte-1d218dd"&&(V.innerHTML=Fe),Ce=s(e),R=i(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-5qwyq6"&&(R.innerHTML=Ee),je=s(e),H=i(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1yxh0lm"&&(H.innerHTML=Ne),be=s(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1n0bzbn"&&(X.textContent=Ke),fe=s(e),Y=i(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1i6grvn"&&(Y.textContent=De),Ie=s(e),S=i(e,"UL",{"data-svelte-h":!0}),c(S)!=="svelte-sdntgs"&&(S.innerHTML=qe),Ge=s(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-vdaq6p"&&(L.textContent=Oe),ge=s(e),Q=i(e,"TABLE",{"data-svelte-h":!0}),c(Q)!=="svelte-sjfg3j"&&(Q.innerHTML=et),ve=s(e),P=i(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-yk2mxh"&&(P.textContent=tt),Ae=s(e),F=i(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-11b4gf4"&&(F.innerHTML=lt),ke=s(e),N=i(e,"P",{}),at(N).forEach(l),this.h()},h(){nt(r,"name","hf:doc:metadata"),nt(r,"content",pt)},m(e,t){Mt(document.head,r),a(e,D,t),a(e,E,t),a(e,q,t),y(m,e,t),a(e,O,t),a(e,u,t),a(e,ee,t),a(e,U,t),a(e,te,t),y(T,e,t),a(e,le,t),a(e,J,t),a(e,ae,t),y(C,e,t),a(e,ne,t),y(j,e,t),a(e,se,t),a(e,b,t),a(e,oe,t),a(e,f,t),a(e,ie,t),a(e,I,t),a(e,ce,t),a(e,G,t),a(e,re,t),y(g,e,t),a(e,de,t),a(e,v,t),a(e,Me,t),a(e,A,t),a(e,ye,t),y(k,e,t),a(e,pe,t),a(e,B,t),a(e,we,t),y(_,e,t),a(e,he,t),a(e,Z,t),a(e,me,t),y(x,e,t),a(e,ue,t),a(e,z,t),a(e,Ue,t),y(W,e,t),a(e,Te,t),a(e,$,t),a(e,Je,t),a(e,V,t),a(e,Ce,t),a(e,R,t),a(e,je,t),a(e,H,t),a(e,be,t),a(e,X,t),a(e,fe,t),a(e,Y,t),a(e,Ie,t),a(e,S,t),a(e,Ge,t),a(e,L,t),a(e,ge,t),a(e,Q,t),a(e,ve,t),a(e,P,t),a(e,Ae,t),a(e,F,t),a(e,ke,t),a(e,N,t),Be=!0},p:ot,i(e){Be||(p(m.$$.fragment,e),p(T.$$.fragment,e),p(C.$$.fragment,e),p(j.$$.fragment,e),p(g.$$.fragment,e),p(k.$$.fragment,e),p(_.$$.fragment,e),p(x.$$.fragment,e),p(W.$$.fragment,e),Be=!0)},o(e){w(m.$$.fragment,e),w(T.$$.fragment,e),w(C.$$.fragment,e),w(j.$$.fragment,e),w(g.$$.fragment,e),w(k.$$.fragment,e),w(_.$$.fragment,e),w(x.$$.fragment,e),w(W.$$.fragment,e),Be=!1},d(e){e&&(l(D),l(E),l(q),l(O),l(u),l(ee),l(U),l(te),l(le),l(J),l(ae),l(ne),l(se),l(b),l(oe),l(f),l(ie),l(I),l(ce),l(G),l(re),l(de),l(v),l(Me),l(A),l(ye),l(pe),l(B),l(we),l(he),l(Z),l(me),l(ue),l(z),l(Ue),l(Te),l($),l(Je),l(V),l(Ce),l(R),l(je),l(H),l(be),l(X),l(fe),l(Y),l(Ie),l(S),l(Ge),l(L),l(ge),l(Q),l(ve),l(P),l(Ae),l(F),l(ke),l(N)),l(r),h(m,e),h(T,e),h(C,e),h(j,e),h(g,e),h(k,e),h(_,e),h(x,e),h(W,e)}}}const pt='{"title":"Gradient Synchronization","local":"gradient-synchronization","sections":[{"title":"The slowdown in gradient accumulation","local":"the-slowdown-in-gradient-accumulation","sections":[],"depth":2},{"title":"Solving the slowdown problem","local":"solving-the-slowdown-problem","sections":[],"depth":2},{"title":"Just how much of a slowdown is there, and easy mistakes you can make","local":"just-how-much-of-a-slowdown-is-there-and-easy-mistakes-you-can-make","sections":[],"depth":2}],"depth":1}';function wt(Ze){return it(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tt extends ct{constructor(r){super(),rt(this,r,wt,yt,st,{})}}export{Tt as component};
