import{s as sr,o as rr,n as cn}from"../chunks/scheduler.9bc65507.js";import{S as or,i as pr,g as s,s as a,r as m,A as mr,h as r,f as n,c as l,j as ar,u as d,x as o,k as lr,y as dr,a as i,v as c,d as f,t as h,w as u}from"../chunks/index.707bf1b6.js";import{T as dn}from"../chunks/Tip.c2ecdbf4.js";import{C as v}from"../chunks/CodeBlock.54a9f38d.js";import{H as y}from"../chunks/Heading.342b1fa6.js";function cr(T){let p,b='If you have access to a machine with multiple GPUs, these approaches are still valid, plus you can leverage additional methods outlined in the <a href="perf_train_gpu_many">multi-GPU section</a>.';return{c(){p=s("p"),p.innerHTML=b},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-198lgun"&&(p.innerHTML=b)},m(g,w){i(g,p,w)},p:cn,d(g){g&&n(p)}}}function fr(T){let p,b=`Note: when using mixed precision with a small model and a large batch size, there will be some memory savings but with a
large model and a small batch size, the memory use will be larger.`;return{c(){p=s("p"),p.textContent=b},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-e8wqm0"&&(p.textContent=b)},m(g,w){i(g,p,w)},p:cn,d(g){g&&n(p)}}}function hr(T){let p,b="While gradient checkpointing may improve memory efficiency, it slows training by approximately 20%.";return{c(){p=s("p"),p.textContent=b},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1rw5pua"&&(p.textContent=b)},m(g,w){i(g,p,w)},p:cn,d(g){g&&n(p)}}}function ur(T){let p,b="tf32 can’t be accessed directly via <code>tensor.to(dtype=torch.tf32)</code> because it is an internal CUDA data type. You need <code>torch&gt;=1.7</code> to use tf32 data types.";return{c(){p=s("p"),p.innerHTML=b},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-lagf4l"&&(p.innerHTML=b)},m(g,w){i(g,p,w)},p:cn,d(g){g&&n(p)}}}function gr(T){let p,b="The PyTorch-native <code>scaled_dot_product_attention</code> operator can only dispatch to Flash Attention if no <code>attention_mask</code> is provided.",g,w,$="By default, in training mode, the BetterTransformer integration <strong>drops the mask support and can only be used for training that does not require a padding mask for batched training</strong>. This is the case, for example, during masked language modeling or causal language modeling. BetterTransformer is not suited for fine-tuning models on tasks that require a padding mask.";return{c(){p=s("p"),p.innerHTML=b,g=a(),w=s("p"),w.innerHTML=$},l(M){p=r(M,"P",{"data-svelte-h":!0}),o(p)!=="svelte-3mpetc"&&(p.innerHTML=b),g=l(M),w=r(M,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1sd6oaz"&&(w.innerHTML=$)},m(M,_){i(M,p,_),i(M,g,_),i(M,w,_)},p:cn,d(M){M&&(n(p),n(g),n(w))}}}function yr(T){let p,b,g,w,$,M,_,Oa=`This guide demonstrates practical techniques that you can use to increase the efficiency of your model’s training by
optimizing memory utilization, speeding up the training, or both. If you’d like to understand how GPU is utilized during
training, please refer to the <a href="model_memory_anatomy">Model training anatomy</a> conceptual guide first. This guide
focuses on practical techniques.`,fn,x,hn,H,el="When training large models, there are two aspects that should be considered at the same time:",un,j,tl="<li>Data throughput/training time</li> <li>Model performance</li>",gn,z,nl=`Maximizing the throughput (samples/second) leads to lower training cost. This is generally achieved by utilizing the GPU
as much as possible and thus filling GPU memory to its limit. If the desired batch size exceeds the limits of the GPU memory,
the memory optimization techniques, such as gradient accumulation, can help.`,yn,A,il=`However, if the preferred batch size fits into memory, there’s no reason to apply memory-optimizing techniques because they can
slow down the training. Just because one can use a large batch size, does not necessarily mean they should. As part of
hyperparameter tuning, you should determine which batch size yields the best results and then optimize resources accordingly.`,wn,L,al="The methods and tools covered in this guide can be classified based on the effect they have on the training process:",bn,P,ll='<thead><tr><th align="left">Method/tool</th> <th align="left">Improves training speed</th> <th align="left">Optimizes memory utilization</th></tr></thead> <tbody><tr><td align="left"><a href="#batch-size-choice">Batch size choice</a></td> <td align="left">Yes</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#gradient-accumulation">Gradient accumulation</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#gradient-checkpointing">Gradient checkpointing</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#mixed-precision-training">Mixed precision training</a></td> <td align="left">Yes</td> <td align="left">(No)</td></tr> <tr><td align="left"><a href="#optimizer-choice">Optimizer choice</a></td> <td align="left">Yes</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#data-preloading">Data preloading</a></td> <td align="left">Yes</td> <td align="left">No</td></tr> <tr><td align="left"><a href="#deepspeed-zero">DeepSpeed Zero</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#using-torchcompile">torch.compile</a></td> <td align="left">Yes</td> <td align="left">No</td></tr> <tr><td align="left"><a href="#peft">Parameter-Efficient Fine Tuning (PEFT)</a></td> <td align="left">No</td> <td align="left">Yes</td></tr></tbody>',Mn,C,vn,W,sl=`You can combine the above methods to get a cumulative effect. These techniques are available to you whether you are
training your model with <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer">Trainer</a> or writing a pure PyTorch loop, in which case you can <a href="#using-accelerate">configure these optimizations
with 🤗 Accelerate</a>.`,Tn,G,rl="If these methods do not result in sufficient gains, you can explore the following options:",_n,F,ol='<li><a href="#efficient-software-prebuilds">Look into building your own custom Docker container with efficient softare prebuilds</a></li> <li><a href="#mixture-of-experts">Consider a model that uses Mixture of Experts (MoE)</a></li> <li><a href="#using-pytorch-native-attention">Convert your model to BetterTransformer to leverage PyTorch native attention</a></li>',$n,R,pl=`Finally, if all of the above is still not enough, even after switching to a server-grade GPU like A100, consider moving
to a multi-GPU setup. All these approaches are still valid in a multi-GPU setup, plus you can leverage additional parallelism
techniques outlined in the <a href="perf_train_gpu_many">multi-GPU section</a>.`,xn,I,Cn,Y,ml=`To achieve optimal performance, start by identifying the appropriate batch size. It is recommended to use batch sizes and
input/output neuron counts that are of size 2^N. Often it’s a multiple of 8, but it can be
higher depending on the hardware being used and the model’s dtype.`,Jn,Z,dl=`For reference, check out NVIDIA’s recommendation for <a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-fully-connected/index.html#input-features" rel="nofollow">input/output neuron counts</a> and
<a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-fully-connected/index.html#batch-size" rel="nofollow">batch size</a> for
fully connected layers (which are involved in GEMMs (General Matrix Multiplications)).`,Un,B,cl=`<a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-matrix-multiplication/index.html#requirements-tc" rel="nofollow">Tensor Core Requirements</a>
define the multiplier based on the dtype and the hardware. For instance, for fp16 data type a multiple of 8 is recommended, unless
it’s an A100 GPU, in which case use multiples of 64.`,kn,X,fl=`For parameters that are small, consider also <a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-matrix-multiplication/index.html#dim-quantization" rel="nofollow">Dimension Quantization Effects</a>.
This is where tiling happens and the right multiplier can have a significant speedup.`,Hn,q,jn,E,hl=`The <strong>gradient accumulation</strong> method aims to calculate gradients in smaller increments instead of computing them for the
entire batch at once. This approach involves iteratively calculating gradients in smaller batches by performing forward
and backward passes through the model and accumulating the gradients during the process. Once a sufficient number of
gradients have been accumulated, the model’s optimization step is executed. By employing gradient accumulation, it
becomes possible to increase the <strong>effective batch size</strong> beyond the limitations imposed by the GPU’s memory capacity.
However, it is important to note that the additional forward and backward passes introduced by gradient accumulation can
slow down the training process.`,zn,V,ul='You can enable gradient accumulation by adding the <code>gradient_accumulation_steps</code> argument to  <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',An,N,Ln,D,gl="In the above example, your effective batch size becomes 4.",Pn,S,yl=`Alternatively, use 🤗 Accelerate to gain full control over the training loop. Find the 🤗 Accelerate example
<a href="#using-accelerate">further down in this guide</a>.`,Wn,Q,wl=`While it is advised to max out GPU usage as much as possible, a high number of gradient accumulation steps can
result in a more pronounced training slowdown. Consider the following example. Let’s say, the <code>per_device_train_batch_size=4</code>
without gradient accumulation hits the GPU’s limit. If you would like to train with batches of size 64, do not set the
<code>per_device_train_batch_size</code> to 1 and <code>gradient_accumulation_steps</code> to 64. Instead, keep <code>per_device_train_batch_size=4</code>
and set <code>gradient_accumulation_steps=16</code>. This results in the same effective batch size while making better use of
the available GPU resources.`,Gn,K,bl=`For additional information, please refer to batch size and gradient accumulation benchmarks for <a href="https://github.com/huggingface/transformers/issues/14608#issuecomment-1004392537" rel="nofollow">RTX-3090</a>
and <a href="https://github.com/huggingface/transformers/issues/15026#issuecomment-1005033957" rel="nofollow">A100</a>.`,Fn,O,Rn,ee,Ml=`Some large models may still face memory issues even when the batch size is set to 1 and gradient accumulation is used.
This is because there are other components that also require memory storage.`,In,te,vl=`Saving all activations from the forward pass in order to compute the gradients during the backward pass can result in
significant memory overhead. The alternative approach of discarding the activations and recalculating them when needed
during the backward pass, would introduce a considerable computational overhead and slow down the training process.`,Yn,ne,Tl=`<strong>Gradient checkpointing</strong> offers a compromise between these two approaches and saves strategically selected activations
throughout the computational graph so only a fraction of the activations need to be re-computed for the gradients. For
an in-depth explanation of gradient checkpointing, refer to <a href="https://medium.com/tensorflow/fitting-larger-networks-into-memory-583e3c758ff9" rel="nofollow">this great article</a>.`,Zn,ie,_l='To enable gradient checkpointing in the <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer">Trainer</a>, pass the corresponding a flag to <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Bn,ae,Xn,le,$l='Alternatively, use 🤗 Accelerate - find the 🤗 Accelerate example <a href="#using-accelerate">further in this guide</a>.',qn,J,En,se,Vn,re,xl=`<strong>Mixed precision training</strong> is a technique that aims to optimize the computational efficiency of training models by
utilizing lower-precision numerical formats for certain variables. Traditionally, most models use 32-bit floating point
precision (fp32 or float32) to represent and process variables. However, not all variables require this high precision
level to achieve accurate results. By reducing the precision of certain variables to lower numerical formats like 16-bit
floating point (fp16 or float16), we can speed up the computations. Because in this approach some computations are performed
in half-precision, while some are still in full precision, the approach is called mixed precision training.`,Nn,oe,Cl=`Most commonly mixed precision training is achieved by using fp16 (float16) data types, however, some GPU architectures
(such as the Ampere architecture) offer bf16 and tf32 (CUDA internal data type) data types. Check
out the <a href="https://developer.nvidia.com/blog/accelerating-ai-training-with-tf32-tensor-cores/" rel="nofollow">NVIDIA Blog</a> to learn more about
the differences between these data types.`,Dn,pe,Sn,me,Jl=`The main advantage of mixed precision training comes from saving the activations in half precision (fp16).
Although the gradients are also computed in half precision they are converted back to full precision for the optimization
step so no memory is saved here.
While mixed precision training results in faster computations, it can also lead to more GPU memory being utilized, especially for small batch sizes.
This is because the model is now present on the GPU in both 16-bit and 32-bit precision (1.5x the original model on the GPU).`,Qn,de,Ul="To enable mixed precision training, set the <code>fp16</code> flag to <code>True</code>:",Kn,ce,On,fe,kl='If you prefer to use 🤗 Accelerate, find the 🤗 Accelerate example <a href="#using-accelerate">further in this guide</a>.',ei,he,ti,ue,Hl=`If you have access to an Ampere or newer hardware you can use bf16 for mixed precision training and evaluation. While
bf16 has a worse precision than fp16, it has a much bigger dynamic range. In fp16 the biggest number you can have
is <code>65535</code> and any number above that will result in an overflow. A bf16 number can be as large as <code>3.39e+38</code> (!) which
is about the same as fp32 - because both have 8-bits used for the numerical range.`,ni,ge,jl="You can enable BF16 in the 🤗 Trainer with:",ii,ye,ai,we,li,be,zl=`The Ampere hardware uses a magical data type called tf32. It has the same numerical range as fp32 (8-bits), but instead
of 23 bits precision it has only 10 bits (same as fp16) and uses only 19 bits in total. It’s “magical” in the sense that
you can use the normal fp32 training and/or inference code and by enabling tf32 support you can get up to 3x throughput
improvement. All you need to do is to add the following to your code:`,si,Me,ri,ve,Al="CUDA will automatically switch to using tf32 instead of fp32 where possible, assuming that the used GPU is from the Ampere series.",oi,Te,Ll=`According to <a href="https://developer.nvidia.com/blog/accelerating-ai-training-with-tf32-tensor-cores/" rel="nofollow">NVIDIA research</a>, the
majority of machine learning training workloads show the same perplexity and convergence with tf32 training as with fp32.
If you’re already using fp16 or bf16 mixed precision it may help with the throughput as well.`,pi,_e,Pl="You can enable this mode in the 🤗 Trainer:",mi,$e,di,U,ci,xe,Wl=`For additional information on tf32 vs other precisions, please refer to the following benchmarks:
<a href="https://github.com/huggingface/transformers/issues/14608#issuecomment-1004390803" rel="nofollow">RTX-3090</a> and
<a href="https://github.com/huggingface/transformers/issues/15026#issuecomment-1004543189" rel="nofollow">A100</a>.`,fi,Ce,hi,Je,Gl='You can speedup the training throughput by using Flash Attention 2 integration in transformers. Check out the appropriate section in the <a href="./perf_infer_gpu_one#Flash-Attention-2">single GPU section</a> to learn more about how to load a model with Flash Attention 2 modules.',ui,Ue,gi,ke,Fl=`The most common optimizer used to train transformer models is Adam or AdamW (Adam with weight decay). Adam achieves
good convergence by storing the rolling average of the previous gradients; however, it adds an additional memory
footprint of the order of the number of model parameters. To remedy this, you can use an alternative optimizer.
For example if you have <a href="https://github.com/NVIDIA/apex" rel="nofollow">NVIDIA/apex</a> installed for NVIDIA GPUs, or <a href="https://github.com/ROCmSoftwarePlatform/apex" rel="nofollow">ROCmSoftwarePlatform/apex</a> for AMD GPUs, <code>adamw_apex_fused</code> will give you the
fastest training experience among all supported AdamW optimizers.`,yi,He,Rl=`<a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer">Trainer</a> integrates a variety of optimizers that can be used out of box: <code>adamw_hf</code>, <code>adamw_torch</code>, <code>adamw_torch_fused</code>,
<code>adamw_apex_fused</code>, <code>adamw_anyprecision</code>, <code>adafactor</code>, or <code>adamw_bnb_8bit</code>. More optimizers can be plugged in via a third-party implementation.`,wi,je,Il="Let’s take a closer look at two alternatives to AdamW optimizer:",bi,ze,Yl='<li><code>adafactor</code> which is available in <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer">Trainer</a></li> <li><code>adamw_bnb_8bit</code> is also available in Trainer, but a third-party integration is provided below for demonstration.</li>',Mi,Ae,Zl="For comparison, for a 3B-parameter model, like “t5-3b”:",vi,Le,Bl="<li>A standard AdamW optimizer will need 24GB of GPU memory because it uses 8 bytes for each parameter (8*3 =&gt; 24GB)</li> <li>Adafactor optimizer will need more than 12GB. It uses slightly more than 4 bytes for each parameter, so 4*3 and then some extra.</li> <li>8bit BNB quantized optimizer will use only (2*3) 6GB if all optimizer states are quantized.</li>",Ti,Pe,_i,We,Xl=`Adafactor doesn’t store rolling averages for each element in weight matrices. Instead, it keeps aggregated information
(sums of rolling averages row- and column-wise), significantly reducing its footprint. However, compared to Adam,
Adafactor may have slower convergence in certain cases.`,$i,Ge,ql='You can switch to Adafactor by setting <code>optim=&quot;adafactor&quot;</code> in <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',xi,Fe,Ci,Re,El=`Combined with other approaches (gradient accumulation, gradient checkpointing, and mixed precision training)
you can notice up to 3x improvement while maintaining the throughput! However, as mentioned before, the convergence of
Adafactor can be worse than Adam.`,Ji,Ie,Ui,Ye,Vl=`Instead of aggregating optimizer states like Adafactor, 8-bit Adam keeps the full state and quantizes it. Quantization
means that it stores the state with lower precision and dequantizes it only for the optimization. This is similar to the
idea behind mixed precision training.`,ki,Ze,Nl='To use <code>adamw_bnb_8bit</code>, you simply need to set <code>optim=&quot;adamw_bnb_8bit&quot;</code> in <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Hi,Be,ji,Xe,Dl="However, we can also use a third-party implementation of the 8-bit optimizer for demonstration purposes to see how that can be integrated.",zi,qe,Sl=`First, follow the installation guide in the GitHub <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">repo</a> to install the <code>bitsandbytes</code> library
that implements the 8-bit Adam optimizer.`,Ai,Ee,Ql="Next you need to initialize the optimizer. This involves two steps:",Li,Ve,Kl="<li>First, group the model’s parameters into two groups - one where weight decay should be applied, and the other one where it should not. Usually, biases and layer norm parameters are not weight decayed.</li> <li>Then do some argument housekeeping to use the same parameters as the previously used AdamW optimizer.</li>",Pi,Ne,Wi,De,Ol="Finally, pass the custom optimizer as an argument to the <code>Trainer</code>:",Gi,Se,Fi,Qe,es=`Combined with other approaches (gradient accumulation, gradient checkpointing, and mixed precision training),
you can expect to get about a 3x memory improvement and even slightly higher throughput as using Adafactor.`,Ri,Ke,Ii,Oe,ts=`pytorch-nightly introduced <code>torch.optim._multi_tensor</code> which should significantly speed up the optimizers for situations
with lots of small feature tensors. It should eventually become the default, but if you want to experiment with it sooner, take a look at this GitHub <a href="https://github.com/huggingface/transformers/issues/9965" rel="nofollow">issue</a>.`,Yi,et,Zi,tt,ns=`One of the important requirements to reach great training speed is the ability to feed the GPU at the maximum speed it
can handle. By default, everything happens in the main process, and it might not be able to read the data from disk fast
enough, and thus create a bottleneck, leading to GPU under-utilization. Configure the following arguments to reduce the bottleneck:`,Bi,nt,is="<li><code>DataLoader(pin_memory=True, ...)</code> - ensures the data gets preloaded into the pinned memory on CPU and typically leads to much faster transfers from CPU to GPU memory.</li> <li><code>DataLoader(num_workers=4, ...)</code> - spawn several workers to preload data faster. During training, watch the GPU utilization stats; if it’s far from 100%, experiment with increasing the number of workers. Of course, the problem could be elsewhere, so many workers won’t necessarily lead to better performance.</li>",Xi,it,as='When using <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer">Trainer</a>, the corresponding <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> are: <code>dataloader_pin_memory</code> (<code>True</code> by default), and <code>dataloader_num_workers</code> (defaults to <code>0</code>).',qi,at,Ei,lt,ls=`DeepSpeed is an open-source deep learning optimization library that is integrated with 🤗 Transformers and 🤗 Accelerate.
It provides a wide range of features and optimizations designed to improve the efficiency and scalability of large-scale
deep learning training.`,Vi,st,ss=`If your model fits onto a single GPU and you have enough space to fit a small batch size, you don’t need to use DeepSpeed
as it’ll only slow things down. However, if the model doesn’t fit onto a single GPU or you can’t fit a small batch, you can
leverage DeepSpeed ZeRO + CPU Offload, or NVMe Offload for much larger models. In this case, you need to separately
<a href="main_classes/deepspeed#installation">install the library</a>, then follow one of the guides to create a configuration file
and launch DeepSpeed:`,Ni,rt,rs=`<li>For an in-depth guide on DeepSpeed integration with <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer">Trainer</a>, review <a href="main_classes/deepspeed">the corresponding documentation</a>, specifically the
<a href="main_classes/deepspeed#deployment-with-one-gpu">section for a single GPU</a>. Some adjustments are required to use DeepSpeed in a notebook; please take a look at the <a href="main_classes/deepspeed#deployment-in-notebooks">corresponding guide</a>.</li> <li>If you prefer to use 🤗 Accelerate, refer to <a href="https://huggingface.co/docs/accelerate/en/usage_guides/deepspeed" rel="nofollow">🤗 Accelerate DeepSpeed guide</a>.</li>`,Di,ot,Si,pt,os=`PyTorch 2.0 introduced a new compile function that doesn’t require any modification to existing PyTorch code but can
optimize your code by adding a single line of code: <code>model = torch.compile(model)</code>.`,Qi,mt,ps='If using <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer">Trainer</a>, you only need <code>to</code> pass the <code>torch_compile</code> option in the <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Ki,dt,Oi,ct,ms=`<code>torch.compile</code> uses Python’s frame evaluation API to automatically create a graph from existing PyTorch programs. After
capturing the graph, different backends can be deployed to lower the graph to an optimized engine.
You can find more details and benchmarks in <a href="https://pytorch.org/get-started/pytorch-2.0/" rel="nofollow">PyTorch documentation</a>.`,ea,ft,ds="<code>torch.compile</code> has a growing list of backends, which can be found in by calling <code>torchdynamo.list_backends()</code>, each of which with its optional dependencies.",ta,ht,cs='Choose which backend to use by specifying it via <code>torch_compile_backend</code> in the <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.  Some of the most commonly used backends are:',na,ut,fs="<strong>Debugging backends</strong>:",ia,gt,hs="<li><code>dynamo.optimize(&quot;eager&quot;)</code> - Uses PyTorch to run the extracted GraphModule. This is quite useful in debugging TorchDynamo issues.</li> <li><code>dynamo.optimize(&quot;aot_eager&quot;)</code> - Uses AotAutograd with no compiler, i.e, just using PyTorch eager for the AotAutograd’s extracted forward and backward graphs. This is useful for debugging, and unlikely to give speedups.</li>",aa,yt,us="<strong>Training &amp; inference backends</strong>:",la,wt,gs='<li><code>dynamo.optimize(&quot;inductor&quot;)</code> - Uses TorchInductor backend with AotAutograd and cudagraphs by leveraging codegened Triton kernels  <a href="https://dev-discuss.pytorch.org/t/torchinductor-a-pytorch-native-compiler-with-define-by-run-ir-and-symbolic-shapes/747" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;nvfuser&quot;)</code> -  nvFuser with TorchScript. <a href="https://dev-discuss.pytorch.org/t/tracing-with-primitives-update-1-nvfuser-and-its-primitives/593" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;aot_nvfuser&quot;)</code> -  nvFuser with AotAutograd. <a href="https://dev-discuss.pytorch.org/t/tracing-with-primitives-update-1-nvfuser-and-its-primitives/593" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;aot_cudagraphs&quot;)</code> - cudagraphs with AotAutograd. <a href="https://github.com/pytorch/torchdynamo/pull/757" rel="nofollow">Read more</a></li>',sa,bt,ys="<strong>Inference-only backend</strong>s:",ra,Mt,ws='<li><code>dynamo.optimize(&quot;ofi&quot;)</code> -  Uses Torchscript optimize_for_inference.  <a href="https://pytorch.org/docs/stable/generated/torch.jit.optimize_for_inference.html" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;fx2trt&quot;)</code> -  Uses NVIDIA TensorRT for inference optimizations.  <a href="https://pytorch.org/TensorRT/tutorials/getting_started_with_fx_path.html" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;onnxrt&quot;)</code> -  Uses ONNXRT for inference on CPU/GPU.  <a href="https://onnxruntime.ai/" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;ipex&quot;)</code> -  Uses IPEX for inference on CPU.  <a href="https://github.com/intel/intel-extension-for-pytorch" rel="nofollow">Read more</a></li>',oa,vt,bs='For an example of using <code>torch.compile</code> with 🤗 Transformers, check out this <a href="https://www.philschmid.de/getting-started-pytorch-2-0-transformers" rel="nofollow">blog post on fine-tuning a BERT model for Text Classification using the newest PyTorch 2.0 features</a>',pa,Tt,ma,_t,Ms='<a href="https://huggingface.co/blog/peft" rel="nofollow">Parameter-Efficient Fine Tuning (PEFT)</a> methods freeze the pretrained model parameters during fine-tuning and add a small number of trainable parameters (the adapters) on top of it.',da,$t,vs='As a result the <a href="https://huggingface.co/docs/transformers/model_memory_anatomy#anatomy-of-models-memory" rel="nofollow">memory associated to the optimizer states and gradients</a> are greatly reduced.',ca,xt,Ts="For example with a vanilla AdamW, the memory requirement for the optimizer state would be:",fa,Ct,_s="<li>fp32 copy of parameters: 4 bytes/param</li> <li>Momentum: 4 bytes/param</li> <li>Variance: 4 bytes/param</li>",ha,Jt,$s='Suppose a model with 7B parameters and 200 millions parameters injected with <a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">Low Rank Adapters</a>.',ua,Ut,xs="The memory requirement for the optimizer state of the plain model would be 12 * 7 = 84 GB (assuming 7B trainable parameters).",ga,kt,Cs="Adding Lora increases slightly the memory associated to the model weights and substantially decreases memory requirement for the optimizer state to 12 * 0.2 = 2.4GB.",ya,Ht,Js='Read more about PEFT and its detailed usage in <a href="https://huggingface.co/docs/peft/" rel="nofollow">the PEFT documentation</a> or <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT repository</a>.',wa,jt,ba,zt,Us=`With <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate</a> you can use the above methods while gaining full
control over the training loop and can essentially write the loop in pure PyTorch with some minor modifications.`,Ma,At,ks='Suppose you have combined the methods in the <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> like so:',va,Lt,Ta,Pt,Hs="The full example training loop with 🤗 Accelerate is only a handful of lines of code long:",_a,Wt,$a,Gt,js=`First we wrap the dataset in a <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>.
Then we can enable gradient checkpointing by calling the model’s <a href="/docs/transformers/v4.37.2/en/main_classes/model#transformers.PreTrainedModel.gradient_checkpointing_enable">gradient_checkpointing_enable()</a> method.
When we initialize the <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator" rel="nofollow"><code>Accelerator</code></a>
we can specify if we want to use mixed precision training and it will take care of it for us in the <code>prepare</code> call.
During the <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator.prepare" rel="nofollow"><code>prepare</code></a>
call the dataloader will also be distributed across workers should we use multiple GPUs. We use the same <a href="#8-bit-adam">8-bit optimizer</a> from the earlier example.`,xa,Ft,zs=`Finally, we can add the main training loop. Note that the <code>backward</code> call is handled by 🤗 Accelerate. We can also see
how gradient accumulation works: we normalize the loss, so we get the average at the end of accumulation and once we have
enough steps we run the optimization.`,Ca,Rt,As=`Implementing these optimization techniques with 🤗 Accelerate only takes a handful of lines of code and comes with the
benefit of more flexibility in the training loop. For a full documentation of all features have a look at the
<a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate documentation</a>.`,Ja,It,Ua,Yt,Ls=`PyTorch’s <a href="https://pytorch.org/get-started/locally/#start-locally" rel="nofollow">pip and conda builds</a> come prebuilt with the cuda toolkit
which is enough to run PyTorch, but it is insufficient if you need to build cuda extensions.`,ka,Zt,Ps=`At times, additional efforts may be required to pre-build some components. For instance, if you’re using libraries like <code>apex</code> that
don’t come pre-compiled. In other situations figuring out how to install the right cuda toolkit system-wide can be complicated.
To address these scenarios PyTorch and NVIDIA released a new version of NGC docker container which already comes with
everything prebuilt. You just need to install your programs on it, and it will run out of the box.`,Ha,Bt,Ws=`This approach is also useful if you want to tweak the pytorch source and/or make a new customized build.
To find the docker image version you want start <a href="https://docs.nvidia.com/deeplearning/frameworks/pytorch-release-notes/" rel="nofollow">with PyTorch release notes</a>,
choose one of the latest monthly releases. Go into the release’s notes for the desired release, check that the environment’s
components are matching your needs (including NVIDIA Driver requirements!) and then at the very top of that document go
to the corresponding NGC page. If for some reason you get lost, here is <a href="https://ngc.nvidia.com/catalog/containers/nvidia:pytorch" rel="nofollow">the index of all PyTorch NGC images</a>.`,ja,Xt,Gs="Next follow the instructions to download and deploy the docker image.",za,qt,Aa,Et,Fs=`Some recent papers reported a 4-5x training speedup and a faster inference by integrating
Mixture of Experts (MoE) into the Transformer models.`,La,Vt,Rs=`Since it has been discovered that more parameters lead to better performance, this technique allows to increase the
number of parameters by an order of magnitude without increasing training costs.`,Pa,Nt,Is=`In this approach every other FFN layer is replaced with a MoE Layer which consists of many experts, with a gated function
that trains each expert in a balanced way depending on the input token’s position in a sequence.`,Wa,Dt,Ys='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perf-moe-transformer.png" alt="MoE Transformer 2x block"/>',Ga,St,Zs='(source: <a href="https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html" rel="nofollow">GLAM</a>)',Fa,Qt,Bs="You can find exhaustive details and comparison tables in the papers listed at the end of this section.",Ra,Kt,Xs=`The main drawback of this approach is that it requires staggering amounts of GPU memory - almost an order of magnitude
larger than its dense equivalent. Various distillation and approaches are proposed to how to overcome the much higher memory requirements.`,Ia,Ot,qs=`There is direct trade-off though, you can use just a few experts with a 2-3x smaller base model instead of dozens or
hundreds experts leading to a 5x smaller model and thus increase the training speed moderately while increasing the
memory requirements moderately as well.`,Ya,en,Es="Most related papers and implementations are built around Tensorflow/TPUs:",Za,tn,Vs='<li><a href="https://arxiv.org/abs/2006.16668" rel="nofollow">GShard: Scaling Giant Models with Conditional Computation and Automatic Sharding</a></li> <li><a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with Simple and Efficient Sparsity</a></li> <li><a href="https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html" rel="nofollow">GLaM: Generalist Language Model (GLaM)</a></li>',Ba,nn,Ns='And for Pytorch DeepSpeed has built one as well: <a href="https://arxiv.org/abs/2201.05596" rel="nofollow">DeepSpeed-MoE: Advancing Mixture-of-Experts Inference and Training to Power Next-Generation AI Scale</a>, <a href="https://www.deepspeed.ai/tutorials/mixture-of-experts/" rel="nofollow">Mixture of Experts</a> - blog posts:  <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-powers-8x-larger-moe-model-training-with-high-performance/" rel="nofollow">1</a>, <a href="https://www.microsoft.com/en-us/research/publication/scalable-and-efficient-moe-training-for-multitask-multilingual-models/" rel="nofollow">2</a> and specific deployment with large transformer-based natural language generation models: <a href="https://www.deepspeed.ai/2021/12/09/deepspeed-moe-nlg.html" rel="nofollow">blog post</a>, <a href="https://github.com/microsoft/Megatron-DeepSpeed/tree/moe-training" rel="nofollow">Megatron-Deepspeed branch</a>.',Xa,an,qa,ln,Ds=`PyTorch 2.0 released a native <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a> (SDPA),
that allows using fused GPU kernels such as <a href="https://arxiv.org/abs/2112.05682" rel="nofollow">memory-efficient attention</a> and <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">flash attention</a>.`,Ea,sn,Ss=`After installing the <a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a> package, the relevant internal modules can be
replaced to use PyTorch’s native attention with:`,Va,rn,Na,on,Qs="Once converted, train the model as usual.",Da,k,Sa,pn,Ks='Check out this <a href="https://pytorch.org/blog/out-of-the-box-acceleration/" rel="nofollow">blogpost</a> to learn more about acceleration and memory-savings with SDPA.',Qa,mn,Ka;return $=new y({props:{title:"Methods and tools for efficient training on a single GPU",local:"methods-and-tools-for-efficient-training-on-a-single-gpu",headingTag:"h1"}}),x=new dn({props:{$$slots:{default:[cr]},$$scope:{ctx:T}}}),C=new dn({props:{$$slots:{default:[fr]},$$scope:{ctx:T}}}),I=new y({props:{title:"Batch size choice",local:"batch-size-choice",headingTag:"h2"}}),q=new y({props:{title:"Gradient Accumulation",local:"gradient-accumulation",headingTag:"h2"}}),N=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">1</span>, gradient_accumulation_steps=<span class="hljs-number">4</span>, **default_args)',wrap:!1}}),O=new y({props:{title:"Gradient Checkpointing",local:"gradient-checkpointing",headingTag:"h2"}}),ae=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMjAqKmRlZmF1bHRfYXJncyUwQSk=",highlighted:`training_args = TrainingArguments(
    per_device_train_batch_size=<span class="hljs-number">1</span>, gradient_accumulation_steps=<span class="hljs-number">4</span>, gradient_checkpointing=<span class="hljs-literal">True</span>, **default_args
)`,wrap:!1}}),J=new dn({props:{$$slots:{default:[hr]},$$scope:{ctx:T}}}),se=new y({props:{title:"Mixed precision training",local:"mixed-precision-training",headingTag:"h2"}}),pe=new y({props:{title:"fp16",local:"fp16",headingTag:"h3"}}),ce=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBmcDE2JTNEVHJ1ZSUyQyUyMCoqZGVmYXVsdF9hcmdzKQ==",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, fp16=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),he=new y({props:{title:"BF16",local:"bf16",headingTag:"h3"}}),ye=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKGJmMTYlM0RUcnVlJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(bf16=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),we=new y({props:{title:"TF32",local:"tf32",headingTag:"h3"}}),Me=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF0b3JjaC5iYWNrZW5kcy5jdWRhLm1hdG11bC5hbGxvd190ZjMyJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLmJhY2tlbmRzLmN1ZG5uLmFsbG93X3RmMzIlMjAlM0QlMjBUcnVl",highlighted:`import torch
torch<span class="hljs-selector-class">.backends</span><span class="hljs-selector-class">.cuda</span><span class="hljs-selector-class">.matmul</span><span class="hljs-selector-class">.allow_tf32</span> = True
torch<span class="hljs-selector-class">.backends</span><span class="hljs-selector-class">.cudnn</span><span class="hljs-selector-class">.allow_tf32</span> = True`,wrap:!1}}),$e=new v({props:{code:"VHJhaW5pbmdBcmd1bWVudHModGYzMiUzRFRydWUlMkMlMjAqKmRlZmF1bHRfYXJncyk=",highlighted:'TrainingArguments(tf32=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),U=new dn({props:{$$slots:{default:[ur]},$$scope:{ctx:T}}}),Ce=new y({props:{title:"Flash Attention 2",local:"flash-attention-2",headingTag:"h2"}}),Ue=new y({props:{title:"Optimizer choice",local:"optimizer-choice",headingTag:"h2"}}),Pe=new y({props:{title:"Adafactor",local:"adafactor",headingTag:"h3"}}),Fe=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBvcHRpbSUzRCUyMmFkYWZhY3RvciUyMiUyQyUyMCoqZGVmYXVsdF9hcmdzKQ==",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, optim=<span class="hljs-string">&quot;adafactor&quot;</span>, **default_args)',wrap:!1}}),Ie=new y({props:{title:"8-bit Adam",local:"8-bit-adam",headingTag:"h3"}}),Be=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBvcHRpbSUzRCUyMmFkYW13X2JuYl84Yml0JTIyJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, optim=<span class="hljs-string">&quot;adamw_bnb_8bit&quot;</span>, **default_args)',wrap:!1}}),Ne=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> transformers.trainer_pt_utils <span class="hljs-keyword">import</span> get_parameter_names

training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, **default_args)

decay_parameters = get_parameter_names(model, [nn.LayerNorm])
decay_parameters = [name <span class="hljs-keyword">for</span> name <span class="hljs-keyword">in</span> decay_parameters <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;bias&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> name]
optimizer_grouped_parameters = [
    {
        <span class="hljs-string">&quot;params&quot;</span>: [p <span class="hljs-keyword">for</span> n, p <span class="hljs-keyword">in</span> model.named_parameters() <span class="hljs-keyword">if</span> n <span class="hljs-keyword">in</span> decay_parameters],
        <span class="hljs-string">&quot;weight_decay&quot;</span>: training_args.weight_decay,
    },
    {
        <span class="hljs-string">&quot;params&quot;</span>: [p <span class="hljs-keyword">for</span> n, p <span class="hljs-keyword">in</span> model.named_parameters() <span class="hljs-keyword">if</span> n <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> decay_parameters],
        <span class="hljs-string">&quot;weight_decay&quot;</span>: <span class="hljs-number">0.0</span>,
    },
]

optimizer_kwargs = {
    <span class="hljs-string">&quot;betas&quot;</span>: (training_args.adam_beta1, training_args.adam_beta2),
    <span class="hljs-string">&quot;eps&quot;</span>: training_args.adam_epsilon,
}
optimizer_kwargs[<span class="hljs-string">&quot;lr&quot;</span>] = training_args.learning_rate
adam_bnb_optim = bnb.optim.Adam8bit(
    optimizer_grouped_parameters,
    betas=(training_args.adam_beta1, training_args.adam_beta2),
    eps=training_args.adam_epsilon,
    lr=training_args.learning_rate,
)`,wrap:!1}}),Se=new v({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCUzRGRzJTJDJTIwb3B0aW1pemVycyUzRChhZGFtX2JuYl9vcHRpbSUyQyUyME5vbmUpKQ==",highlighted:'trainer = Trainer(model=model, args=training_args, train_dataset=ds, optimizers=(adam_bnb_optim, <span class="hljs-literal">None</span>))',wrap:!1}}),Ke=new y({props:{title:"multi_tensor",local:"multitensor",headingTag:"h3"}}),et=new y({props:{title:"Data preloading",local:"data-preloading",headingTag:"h2"}}),at=new y({props:{title:"DeepSpeed ZeRO",local:"deepspeed-zero",headingTag:"h2"}}),ot=new y({props:{title:"Using torch.compile",local:"using-torchcompile",headingTag:"h2"}}),dt=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHRvcmNoX2NvbXBpbGUlM0RUcnVlJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(torch_compile=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),Tt=new y({props:{title:"Using 🤗 PEFT",local:"using--peft",headingTag:"h2"}}),jt=new y({props:{title:"Using 🤗 Accelerate",local:"using--accelerate",headingTag:"h2"}}),Lt=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCoqZGVmYXVsdF9hcmdzJTJDJTBBKQ==",highlighted:`training_args = TrainingArguments(
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    **default_args,
)`,wrap:!1}}),Wt=new v({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhLmRhdGFsb2FkZXIlMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZHMlMkMlMjBiYXRjaF9zaXplJTNEdHJhaW5pbmdfYXJncy5wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUpJTBBJTBBaWYlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0ElMEElMjAlMjAlMjAlMjBtb2RlbC5ncmFkaWVudF9jaGVja3BvaW50aW5nX2VuYWJsZSgpJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihmcDE2JTNEdHJhaW5pbmdfYXJncy5mcDE2KSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBhZGFtX2JuYl9vcHRpbSUyQyUyMGRhdGFsb2FkZXIpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMHN0ZXAlMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKGRhdGFsb2FkZXIlMkMlMjBzdGFydCUzRDEpJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpLmxvc3MlMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMHRyYWluaW5nX2FyZ3MuZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjBpZiUyMHN0ZXAlMjAlMjUlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.utils.data.dataloader <span class="hljs-keyword">import</span> DataLoader

dataloader = DataLoader(ds, batch_size=training_args.per_device_train_batch_size)

<span class="hljs-keyword">if</span> training_args.gradient_checkpointing:
    model.gradient_checkpointing_enable()

accelerator = Accelerator(fp16=training_args.fp16)
model, optimizer, dataloader = accelerator.prepare(model, adam_bnb_optim, dataloader)

model.train()
<span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader, start=<span class="hljs-number">1</span>):
    loss = model(**batch).loss
    loss = loss / training_args.gradient_accumulation_steps
    accelerator.backward(loss)
    <span class="hljs-keyword">if</span> step % training_args.gradient_accumulation_steps == <span class="hljs-number">0</span>:
        optimizer.step()
        optimizer.zero_grad()`,wrap:!1}}),It=new y({props:{title:"Efficient Software Prebuilds",local:"efficient-software-prebuilds",headingTag:"h2"}}),qt=new y({props:{title:"Mixture of Experts",local:"mixture-of-experts",headingTag:"h2"}}),an=new y({props:{title:"Using PyTorch native attention and Flash Attention",local:"using-pytorch-native-attention-and-flash-attention",headingTag:"h2"}}),rn=new v({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC50b19iZXR0ZXJ0cmFuc2Zvcm1lcigp",highlighted:"model = model.to_bettertransformer()",wrap:!1}}),k=new dn({props:{warning:!0,$$slots:{default:[gr]},$$scope:{ctx:T}}}),{c(){p=s("meta"),b=a(),g=s("p"),w=a(),m($.$$.fragment),M=a(),_=s("p"),_.innerHTML=Oa,fn=a(),m(x.$$.fragment),hn=a(),H=s("p"),H.textContent=el,un=a(),j=s("ul"),j.innerHTML=tl,gn=a(),z=s("p"),z.textContent=nl,yn=a(),A=s("p"),A.textContent=il,wn=a(),L=s("p"),L.textContent=al,bn=a(),P=s("table"),P.innerHTML=ll,Mn=a(),m(C.$$.fragment),vn=a(),W=s("p"),W.innerHTML=sl,Tn=a(),G=s("p"),G.textContent=rl,_n=a(),F=s("ul"),F.innerHTML=ol,$n=a(),R=s("p"),R.innerHTML=pl,xn=a(),m(I.$$.fragment),Cn=a(),Y=s("p"),Y.textContent=ml,Jn=a(),Z=s("p"),Z.innerHTML=dl,Un=a(),B=s("p"),B.innerHTML=cl,kn=a(),X=s("p"),X.innerHTML=fl,Hn=a(),m(q.$$.fragment),jn=a(),E=s("p"),E.innerHTML=hl,zn=a(),V=s("p"),V.innerHTML=ul,An=a(),m(N.$$.fragment),Ln=a(),D=s("p"),D.textContent=gl,Pn=a(),S=s("p"),S.innerHTML=yl,Wn=a(),Q=s("p"),Q.innerHTML=wl,Gn=a(),K=s("p"),K.innerHTML=bl,Fn=a(),m(O.$$.fragment),Rn=a(),ee=s("p"),ee.textContent=Ml,In=a(),te=s("p"),te.textContent=vl,Yn=a(),ne=s("p"),ne.innerHTML=Tl,Zn=a(),ie=s("p"),ie.innerHTML=_l,Bn=a(),m(ae.$$.fragment),Xn=a(),le=s("p"),le.innerHTML=$l,qn=a(),m(J.$$.fragment),En=a(),m(se.$$.fragment),Vn=a(),re=s("p"),re.innerHTML=xl,Nn=a(),oe=s("p"),oe.innerHTML=Cl,Dn=a(),m(pe.$$.fragment),Sn=a(),me=s("p"),me.textContent=Jl,Qn=a(),de=s("p"),de.innerHTML=Ul,Kn=a(),m(ce.$$.fragment),On=a(),fe=s("p"),fe.innerHTML=kl,ei=a(),m(he.$$.fragment),ti=a(),ue=s("p"),ue.innerHTML=Hl,ni=a(),ge=s("p"),ge.textContent=jl,ii=a(),m(ye.$$.fragment),ai=a(),m(we.$$.fragment),li=a(),be=s("p"),be.textContent=zl,si=a(),m(Me.$$.fragment),ri=a(),ve=s("p"),ve.textContent=Al,oi=a(),Te=s("p"),Te.innerHTML=Ll,pi=a(),_e=s("p"),_e.textContent=Pl,mi=a(),m($e.$$.fragment),di=a(),m(U.$$.fragment),ci=a(),xe=s("p"),xe.innerHTML=Wl,fi=a(),m(Ce.$$.fragment),hi=a(),Je=s("p"),Je.innerHTML=Gl,ui=a(),m(Ue.$$.fragment),gi=a(),ke=s("p"),ke.innerHTML=Fl,yi=a(),He=s("p"),He.innerHTML=Rl,wi=a(),je=s("p"),je.textContent=Il,bi=a(),ze=s("ol"),ze.innerHTML=Yl,Mi=a(),Ae=s("p"),Ae.textContent=Zl,vi=a(),Le=s("ul"),Le.innerHTML=Bl,Ti=a(),m(Pe.$$.fragment),_i=a(),We=s("p"),We.textContent=Xl,$i=a(),Ge=s("p"),Ge.innerHTML=ql,xi=a(),m(Fe.$$.fragment),Ci=a(),Re=s("p"),Re.textContent=El,Ji=a(),m(Ie.$$.fragment),Ui=a(),Ye=s("p"),Ye.textContent=Vl,ki=a(),Ze=s("p"),Ze.innerHTML=Nl,Hi=a(),m(Be.$$.fragment),ji=a(),Xe=s("p"),Xe.textContent=Dl,zi=a(),qe=s("p"),qe.innerHTML=Sl,Ai=a(),Ee=s("p"),Ee.textContent=Ql,Li=a(),Ve=s("ul"),Ve.innerHTML=Kl,Pi=a(),m(Ne.$$.fragment),Wi=a(),De=s("p"),De.innerHTML=Ol,Gi=a(),m(Se.$$.fragment),Fi=a(),Qe=s("p"),Qe.textContent=es,Ri=a(),m(Ke.$$.fragment),Ii=a(),Oe=s("p"),Oe.innerHTML=ts,Yi=a(),m(et.$$.fragment),Zi=a(),tt=s("p"),tt.textContent=ns,Bi=a(),nt=s("ul"),nt.innerHTML=is,Xi=a(),it=s("p"),it.innerHTML=as,qi=a(),m(at.$$.fragment),Ei=a(),lt=s("p"),lt.textContent=ls,Vi=a(),st=s("p"),st.innerHTML=ss,Ni=a(),rt=s("ul"),rt.innerHTML=rs,Di=a(),m(ot.$$.fragment),Si=a(),pt=s("p"),pt.innerHTML=os,Qi=a(),mt=s("p"),mt.innerHTML=ps,Ki=a(),m(dt.$$.fragment),Oi=a(),ct=s("p"),ct.innerHTML=ms,ea=a(),ft=s("p"),ft.innerHTML=ds,ta=a(),ht=s("p"),ht.innerHTML=cs,na=a(),ut=s("p"),ut.innerHTML=fs,ia=a(),gt=s("ul"),gt.innerHTML=hs,aa=a(),yt=s("p"),yt.innerHTML=us,la=a(),wt=s("ul"),wt.innerHTML=gs,sa=a(),bt=s("p"),bt.innerHTML=ys,ra=a(),Mt=s("ul"),Mt.innerHTML=ws,oa=a(),vt=s("p"),vt.innerHTML=bs,pa=a(),m(Tt.$$.fragment),ma=a(),_t=s("p"),_t.innerHTML=Ms,da=a(),$t=s("p"),$t.innerHTML=vs,ca=a(),xt=s("p"),xt.textContent=Ts,fa=a(),Ct=s("ul"),Ct.innerHTML=_s,ha=a(),Jt=s("p"),Jt.innerHTML=$s,ua=a(),Ut=s("p"),Ut.textContent=xs,ga=a(),kt=s("p"),kt.textContent=Cs,ya=a(),Ht=s("p"),Ht.innerHTML=Js,wa=a(),m(jt.$$.fragment),ba=a(),zt=s("p"),zt.innerHTML=Us,Ma=a(),At=s("p"),At.innerHTML=ks,va=a(),m(Lt.$$.fragment),Ta=a(),Pt=s("p"),Pt.textContent=Hs,_a=a(),m(Wt.$$.fragment),$a=a(),Gt=s("p"),Gt.innerHTML=js,xa=a(),Ft=s("p"),Ft.innerHTML=zs,Ca=a(),Rt=s("p"),Rt.innerHTML=As,Ja=a(),m(It.$$.fragment),Ua=a(),Yt=s("p"),Yt.innerHTML=Ls,ka=a(),Zt=s("p"),Zt.innerHTML=Ps,Ha=a(),Bt=s("p"),Bt.innerHTML=Ws,ja=a(),Xt=s("p"),Xt.textContent=Gs,za=a(),m(qt.$$.fragment),Aa=a(),Et=s("p"),Et.textContent=Fs,La=a(),Vt=s("p"),Vt.textContent=Rs,Pa=a(),Nt=s("p"),Nt.textContent=Is,Wa=a(),Dt=s("p"),Dt.innerHTML=Ys,Ga=a(),St=s("p"),St.innerHTML=Zs,Fa=a(),Qt=s("p"),Qt.textContent=Bs,Ra=a(),Kt=s("p"),Kt.textContent=Xs,Ia=a(),Ot=s("p"),Ot.textContent=qs,Ya=a(),en=s("p"),en.textContent=Es,Za=a(),tn=s("ul"),tn.innerHTML=Vs,Ba=a(),nn=s("p"),nn.innerHTML=Ns,Xa=a(),m(an.$$.fragment),qa=a(),ln=s("p"),ln.innerHTML=Ds,Ea=a(),sn=s("p"),sn.innerHTML=Ss,Va=a(),m(rn.$$.fragment),Na=a(),on=s("p"),on.textContent=Qs,Da=a(),m(k.$$.fragment),Sa=a(),pn=s("p"),pn.innerHTML=Ks,Qa=a(),mn=s("p"),this.h()},l(e){const t=mr("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(n),b=l(e),g=r(e,"P",{}),ar(g).forEach(n),w=l(e),d($.$$.fragment,e),M=l(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-tqdu0u"&&(_.innerHTML=Oa),fn=l(e),d(x.$$.fragment,e),hn=l(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-4s75i8"&&(H.textContent=el),un=l(e),j=r(e,"UL",{"data-svelte-h":!0}),o(j)!=="svelte-djgcn1"&&(j.innerHTML=tl),gn=l(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-uf18r4"&&(z.textContent=nl),yn=l(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-b3xmwb"&&(A.textContent=il),wn=l(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1qbc4zp"&&(L.textContent=al),bn=l(e),P=r(e,"TABLE",{"data-svelte-h":!0}),o(P)!=="svelte-9y74pp"&&(P.innerHTML=ll),Mn=l(e),d(C.$$.fragment,e),vn=l(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-ob76zn"&&(W.innerHTML=sl),Tn=l(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1thjxg4"&&(G.textContent=rl),_n=l(e),F=r(e,"UL",{"data-svelte-h":!0}),o(F)!=="svelte-18kwup6"&&(F.innerHTML=ol),$n=l(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1uvbmrd"&&(R.innerHTML=pl),xn=l(e),d(I.$$.fragment,e),Cn=l(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1f9wkzb"&&(Y.textContent=ml),Jn=l(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-h1ek0g"&&(Z.innerHTML=dl),Un=l(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-sfn5k1"&&(B.innerHTML=cl),kn=l(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-wvp8kx"&&(X.innerHTML=fl),Hn=l(e),d(q.$$.fragment,e),jn=l(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1l7rfkq"&&(E.innerHTML=hl),zn=l(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-agkey2"&&(V.innerHTML=ul),An=l(e),d(N.$$.fragment,e),Ln=l(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-18ky75y"&&(D.textContent=gl),Pn=l(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-khctnv"&&(S.innerHTML=yl),Wn=l(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1bitspm"&&(Q.innerHTML=wl),Gn=l(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-nbfonf"&&(K.innerHTML=bl),Fn=l(e),d(O.$$.fragment,e),Rn=l(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-n1qbw"&&(ee.textContent=Ml),In=l(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1419dmv"&&(te.textContent=vl),Yn=l(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-nfo3gu"&&(ne.innerHTML=Tl),Zn=l(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-182h4w5"&&(ie.innerHTML=_l),Bn=l(e),d(ae.$$.fragment,e),Xn=l(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1wwrmcl"&&(le.innerHTML=$l),qn=l(e),d(J.$$.fragment,e),En=l(e),d(se.$$.fragment,e),Vn=l(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-7pqnv0"&&(re.innerHTML=xl),Nn=l(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1ttanpy"&&(oe.innerHTML=Cl),Dn=l(e),d(pe.$$.fragment,e),Sn=l(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-h2t8go"&&(me.textContent=Jl),Qn=l(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-wwg09w"&&(de.innerHTML=Ul),Kn=l(e),d(ce.$$.fragment,e),On=l(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-11fsu6r"&&(fe.innerHTML=kl),ei=l(e),d(he.$$.fragment,e),ti=l(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1p48z2n"&&(ue.innerHTML=Hl),ni=l(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-vq639r"&&(ge.textContent=jl),ii=l(e),d(ye.$$.fragment,e),ai=l(e),d(we.$$.fragment,e),li=l(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-7szee7"&&(be.textContent=zl),si=l(e),d(Me.$$.fragment,e),ri=l(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1kvnj8w"&&(ve.textContent=Al),oi=l(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-alc3bu"&&(Te.innerHTML=Ll),pi=l(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-d0keh1"&&(_e.textContent=Pl),mi=l(e),d($e.$$.fragment,e),di=l(e),d(U.$$.fragment,e),ci=l(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-dzrbtx"&&(xe.innerHTML=Wl),fi=l(e),d(Ce.$$.fragment,e),hi=l(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-4gzx8m"&&(Je.innerHTML=Gl),ui=l(e),d(Ue.$$.fragment,e),gi=l(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-15ts99c"&&(ke.innerHTML=Fl),yi=l(e),He=r(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1pakc4v"&&(He.innerHTML=Rl),wi=l(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1qfw41"&&(je.textContent=Il),bi=l(e),ze=r(e,"OL",{"data-svelte-h":!0}),o(ze)!=="svelte-8hwzvq"&&(ze.innerHTML=Yl),Mi=l(e),Ae=r(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-2mb823"&&(Ae.textContent=Zl),vi=l(e),Le=r(e,"UL",{"data-svelte-h":!0}),o(Le)!=="svelte-ajuctj"&&(Le.innerHTML=Bl),Ti=l(e),d(Pe.$$.fragment,e),_i=l(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-19jpav8"&&(We.textContent=Xl),$i=l(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1ojigge"&&(Ge.innerHTML=ql),xi=l(e),d(Fe.$$.fragment,e),Ci=l(e),Re=r(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1850zf2"&&(Re.textContent=El),Ji=l(e),d(Ie.$$.fragment,e),Ui=l(e),Ye=r(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1ld1y8t"&&(Ye.textContent=Vl),ki=l(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-2nvieg"&&(Ze.innerHTML=Nl),Hi=l(e),d(Be.$$.fragment,e),ji=l(e),Xe=r(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-czmcu6"&&(Xe.textContent=Dl),zi=l(e),qe=r(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1av8920"&&(qe.innerHTML=Sl),Ai=l(e),Ee=r(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-19nyc4u"&&(Ee.textContent=Ql),Li=l(e),Ve=r(e,"UL",{"data-svelte-h":!0}),o(Ve)!=="svelte-8z8ok2"&&(Ve.innerHTML=Kl),Pi=l(e),d(Ne.$$.fragment,e),Wi=l(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-n8bkwf"&&(De.innerHTML=Ol),Gi=l(e),d(Se.$$.fragment,e),Fi=l(e),Qe=r(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1egi1g7"&&(Qe.textContent=es),Ri=l(e),d(Ke.$$.fragment,e),Ii=l(e),Oe=r(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-1cvgqaq"&&(Oe.innerHTML=ts),Yi=l(e),d(et.$$.fragment,e),Zi=l(e),tt=r(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-16tninz"&&(tt.textContent=ns),Bi=l(e),nt=r(e,"UL",{"data-svelte-h":!0}),o(nt)!=="svelte-1i85v8g"&&(nt.innerHTML=is),Xi=l(e),it=r(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1ggicox"&&(it.innerHTML=as),qi=l(e),d(at.$$.fragment,e),Ei=l(e),lt=r(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1onp6io"&&(lt.textContent=ls),Vi=l(e),st=r(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-18hg7g"&&(st.innerHTML=ss),Ni=l(e),rt=r(e,"UL",{"data-svelte-h":!0}),o(rt)!=="svelte-vzjnzn"&&(rt.innerHTML=rs),Di=l(e),d(ot.$$.fragment,e),Si=l(e),pt=r(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-5qw0v5"&&(pt.innerHTML=os),Qi=l(e),mt=r(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-epkhf8"&&(mt.innerHTML=ps),Ki=l(e),d(dt.$$.fragment,e),Oi=l(e),ct=r(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-1y4s25e"&&(ct.innerHTML=ms),ea=l(e),ft=r(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-jluuok"&&(ft.innerHTML=ds),ta=l(e),ht=r(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-j3v8wj"&&(ht.innerHTML=cs),na=l(e),ut=r(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-v82kng"&&(ut.innerHTML=fs),ia=l(e),gt=r(e,"UL",{"data-svelte-h":!0}),o(gt)!=="svelte-1dbgjs7"&&(gt.innerHTML=hs),aa=l(e),yt=r(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-m2qf5f"&&(yt.innerHTML=us),la=l(e),wt=r(e,"UL",{"data-svelte-h":!0}),o(wt)!=="svelte-x9b2wm"&&(wt.innerHTML=gs),sa=l(e),bt=r(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-78l3h4"&&(bt.innerHTML=ys),ra=l(e),Mt=r(e,"UL",{"data-svelte-h":!0}),o(Mt)!=="svelte-1bce63b"&&(Mt.innerHTML=ws),oa=l(e),vt=r(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1prqm7s"&&(vt.innerHTML=bs),pa=l(e),d(Tt.$$.fragment,e),ma=l(e),_t=r(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-8pfmhp"&&(_t.innerHTML=Ms),da=l(e),$t=r(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-vtpr6t"&&($t.innerHTML=vs),ca=l(e),xt=r(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-10pzmck"&&(xt.textContent=Ts),fa=l(e),Ct=r(e,"UL",{"data-svelte-h":!0}),o(Ct)!=="svelte-1c6ggig"&&(Ct.innerHTML=_s),ha=l(e),Jt=r(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1grqw5q"&&(Jt.innerHTML=$s),ua=l(e),Ut=r(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-13ydqxp"&&(Ut.textContent=xs),ga=l(e),kt=r(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-16ojy37"&&(kt.textContent=Cs),ya=l(e),Ht=r(e,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-1bqs6c8"&&(Ht.innerHTML=Js),wa=l(e),d(jt.$$.fragment,e),ba=l(e),zt=r(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-d91a9c"&&(zt.innerHTML=Us),Ma=l(e),At=r(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1pc5obg"&&(At.innerHTML=ks),va=l(e),d(Lt.$$.fragment,e),Ta=l(e),Pt=r(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-eja69v"&&(Pt.textContent=Hs),_a=l(e),d(Wt.$$.fragment,e),$a=l(e),Gt=r(e,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1dw6c9g"&&(Gt.innerHTML=js),xa=l(e),Ft=r(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-i5733s"&&(Ft.innerHTML=zs),Ca=l(e),Rt=r(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1caz98g"&&(Rt.innerHTML=As),Ja=l(e),d(It.$$.fragment,e),Ua=l(e),Yt=r(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-nmhpgl"&&(Yt.innerHTML=Ls),ka=l(e),Zt=r(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-kxuhyz"&&(Zt.innerHTML=Ps),Ha=l(e),Bt=r(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-qkuwkx"&&(Bt.innerHTML=Ws),ja=l(e),Xt=r(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-16g8p4x"&&(Xt.textContent=Gs),za=l(e),d(qt.$$.fragment,e),Aa=l(e),Et=r(e,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-1aawf57"&&(Et.textContent=Fs),La=l(e),Vt=r(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-ln9ugc"&&(Vt.textContent=Rs),Pa=l(e),Nt=r(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-1ett6yb"&&(Nt.textContent=Is),Wa=l(e),Dt=r(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-tdgts9"&&(Dt.innerHTML=Ys),Ga=l(e),St=r(e,"P",{"data-svelte-h":!0}),o(St)!=="svelte-z2dori"&&(St.innerHTML=Zs),Fa=l(e),Qt=r(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1gc8znk"&&(Qt.textContent=Bs),Ra=l(e),Kt=r(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-13sa7m0"&&(Kt.textContent=Xs),Ia=l(e),Ot=r(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-dxh8d5"&&(Ot.textContent=qs),Ya=l(e),en=r(e,"P",{"data-svelte-h":!0}),o(en)!=="svelte-1jfhyzg"&&(en.textContent=Es),Za=l(e),tn=r(e,"UL",{"data-svelte-h":!0}),o(tn)!=="svelte-1fjc55v"&&(tn.innerHTML=Vs),Ba=l(e),nn=r(e,"P",{"data-svelte-h":!0}),o(nn)!=="svelte-1nxcmqe"&&(nn.innerHTML=Ns),Xa=l(e),d(an.$$.fragment,e),qa=l(e),ln=r(e,"P",{"data-svelte-h":!0}),o(ln)!=="svelte-10jsqxr"&&(ln.innerHTML=Ds),Ea=l(e),sn=r(e,"P",{"data-svelte-h":!0}),o(sn)!=="svelte-mg6n76"&&(sn.innerHTML=Ss),Va=l(e),d(rn.$$.fragment,e),Na=l(e),on=r(e,"P",{"data-svelte-h":!0}),o(on)!=="svelte-wfi44p"&&(on.textContent=Qs),Da=l(e),d(k.$$.fragment,e),Sa=l(e),pn=r(e,"P",{"data-svelte-h":!0}),o(pn)!=="svelte-1r3sioy"&&(pn.innerHTML=Ks),Qa=l(e),mn=r(e,"P",{}),ar(mn).forEach(n),this.h()},h(){lr(p,"name","hf:doc:metadata"),lr(p,"content",wr)},m(e,t){dr(document.head,p),i(e,b,t),i(e,g,t),i(e,w,t),c($,e,t),i(e,M,t),i(e,_,t),i(e,fn,t),c(x,e,t),i(e,hn,t),i(e,H,t),i(e,un,t),i(e,j,t),i(e,gn,t),i(e,z,t),i(e,yn,t),i(e,A,t),i(e,wn,t),i(e,L,t),i(e,bn,t),i(e,P,t),i(e,Mn,t),c(C,e,t),i(e,vn,t),i(e,W,t),i(e,Tn,t),i(e,G,t),i(e,_n,t),i(e,F,t),i(e,$n,t),i(e,R,t),i(e,xn,t),c(I,e,t),i(e,Cn,t),i(e,Y,t),i(e,Jn,t),i(e,Z,t),i(e,Un,t),i(e,B,t),i(e,kn,t),i(e,X,t),i(e,Hn,t),c(q,e,t),i(e,jn,t),i(e,E,t),i(e,zn,t),i(e,V,t),i(e,An,t),c(N,e,t),i(e,Ln,t),i(e,D,t),i(e,Pn,t),i(e,S,t),i(e,Wn,t),i(e,Q,t),i(e,Gn,t),i(e,K,t),i(e,Fn,t),c(O,e,t),i(e,Rn,t),i(e,ee,t),i(e,In,t),i(e,te,t),i(e,Yn,t),i(e,ne,t),i(e,Zn,t),i(e,ie,t),i(e,Bn,t),c(ae,e,t),i(e,Xn,t),i(e,le,t),i(e,qn,t),c(J,e,t),i(e,En,t),c(se,e,t),i(e,Vn,t),i(e,re,t),i(e,Nn,t),i(e,oe,t),i(e,Dn,t),c(pe,e,t),i(e,Sn,t),i(e,me,t),i(e,Qn,t),i(e,de,t),i(e,Kn,t),c(ce,e,t),i(e,On,t),i(e,fe,t),i(e,ei,t),c(he,e,t),i(e,ti,t),i(e,ue,t),i(e,ni,t),i(e,ge,t),i(e,ii,t),c(ye,e,t),i(e,ai,t),c(we,e,t),i(e,li,t),i(e,be,t),i(e,si,t),c(Me,e,t),i(e,ri,t),i(e,ve,t),i(e,oi,t),i(e,Te,t),i(e,pi,t),i(e,_e,t),i(e,mi,t),c($e,e,t),i(e,di,t),c(U,e,t),i(e,ci,t),i(e,xe,t),i(e,fi,t),c(Ce,e,t),i(e,hi,t),i(e,Je,t),i(e,ui,t),c(Ue,e,t),i(e,gi,t),i(e,ke,t),i(e,yi,t),i(e,He,t),i(e,wi,t),i(e,je,t),i(e,bi,t),i(e,ze,t),i(e,Mi,t),i(e,Ae,t),i(e,vi,t),i(e,Le,t),i(e,Ti,t),c(Pe,e,t),i(e,_i,t),i(e,We,t),i(e,$i,t),i(e,Ge,t),i(e,xi,t),c(Fe,e,t),i(e,Ci,t),i(e,Re,t),i(e,Ji,t),c(Ie,e,t),i(e,Ui,t),i(e,Ye,t),i(e,ki,t),i(e,Ze,t),i(e,Hi,t),c(Be,e,t),i(e,ji,t),i(e,Xe,t),i(e,zi,t),i(e,qe,t),i(e,Ai,t),i(e,Ee,t),i(e,Li,t),i(e,Ve,t),i(e,Pi,t),c(Ne,e,t),i(e,Wi,t),i(e,De,t),i(e,Gi,t),c(Se,e,t),i(e,Fi,t),i(e,Qe,t),i(e,Ri,t),c(Ke,e,t),i(e,Ii,t),i(e,Oe,t),i(e,Yi,t),c(et,e,t),i(e,Zi,t),i(e,tt,t),i(e,Bi,t),i(e,nt,t),i(e,Xi,t),i(e,it,t),i(e,qi,t),c(at,e,t),i(e,Ei,t),i(e,lt,t),i(e,Vi,t),i(e,st,t),i(e,Ni,t),i(e,rt,t),i(e,Di,t),c(ot,e,t),i(e,Si,t),i(e,pt,t),i(e,Qi,t),i(e,mt,t),i(e,Ki,t),c(dt,e,t),i(e,Oi,t),i(e,ct,t),i(e,ea,t),i(e,ft,t),i(e,ta,t),i(e,ht,t),i(e,na,t),i(e,ut,t),i(e,ia,t),i(e,gt,t),i(e,aa,t),i(e,yt,t),i(e,la,t),i(e,wt,t),i(e,sa,t),i(e,bt,t),i(e,ra,t),i(e,Mt,t),i(e,oa,t),i(e,vt,t),i(e,pa,t),c(Tt,e,t),i(e,ma,t),i(e,_t,t),i(e,da,t),i(e,$t,t),i(e,ca,t),i(e,xt,t),i(e,fa,t),i(e,Ct,t),i(e,ha,t),i(e,Jt,t),i(e,ua,t),i(e,Ut,t),i(e,ga,t),i(e,kt,t),i(e,ya,t),i(e,Ht,t),i(e,wa,t),c(jt,e,t),i(e,ba,t),i(e,zt,t),i(e,Ma,t),i(e,At,t),i(e,va,t),c(Lt,e,t),i(e,Ta,t),i(e,Pt,t),i(e,_a,t),c(Wt,e,t),i(e,$a,t),i(e,Gt,t),i(e,xa,t),i(e,Ft,t),i(e,Ca,t),i(e,Rt,t),i(e,Ja,t),c(It,e,t),i(e,Ua,t),i(e,Yt,t),i(e,ka,t),i(e,Zt,t),i(e,Ha,t),i(e,Bt,t),i(e,ja,t),i(e,Xt,t),i(e,za,t),c(qt,e,t),i(e,Aa,t),i(e,Et,t),i(e,La,t),i(e,Vt,t),i(e,Pa,t),i(e,Nt,t),i(e,Wa,t),i(e,Dt,t),i(e,Ga,t),i(e,St,t),i(e,Fa,t),i(e,Qt,t),i(e,Ra,t),i(e,Kt,t),i(e,Ia,t),i(e,Ot,t),i(e,Ya,t),i(e,en,t),i(e,Za,t),i(e,tn,t),i(e,Ba,t),i(e,nn,t),i(e,Xa,t),c(an,e,t),i(e,qa,t),i(e,ln,t),i(e,Ea,t),i(e,sn,t),i(e,Va,t),c(rn,e,t),i(e,Na,t),i(e,on,t),i(e,Da,t),c(k,e,t),i(e,Sa,t),i(e,pn,t),i(e,Qa,t),i(e,mn,t),Ka=!0},p(e,[t]){const Os={};t&2&&(Os.$$scope={dirty:t,ctx:e}),x.$set(Os);const er={};t&2&&(er.$$scope={dirty:t,ctx:e}),C.$set(er);const tr={};t&2&&(tr.$$scope={dirty:t,ctx:e}),J.$set(tr);const nr={};t&2&&(nr.$$scope={dirty:t,ctx:e}),U.$set(nr);const ir={};t&2&&(ir.$$scope={dirty:t,ctx:e}),k.$set(ir)},i(e){Ka||(f($.$$.fragment,e),f(x.$$.fragment,e),f(C.$$.fragment,e),f(I.$$.fragment,e),f(q.$$.fragment,e),f(N.$$.fragment,e),f(O.$$.fragment,e),f(ae.$$.fragment,e),f(J.$$.fragment,e),f(se.$$.fragment,e),f(pe.$$.fragment,e),f(ce.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(Me.$$.fragment,e),f($e.$$.fragment,e),f(U.$$.fragment,e),f(Ce.$$.fragment,e),f(Ue.$$.fragment,e),f(Pe.$$.fragment,e),f(Fe.$$.fragment,e),f(Ie.$$.fragment,e),f(Be.$$.fragment,e),f(Ne.$$.fragment,e),f(Se.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(at.$$.fragment,e),f(ot.$$.fragment,e),f(dt.$$.fragment,e),f(Tt.$$.fragment,e),f(jt.$$.fragment,e),f(Lt.$$.fragment,e),f(Wt.$$.fragment,e),f(It.$$.fragment,e),f(qt.$$.fragment,e),f(an.$$.fragment,e),f(rn.$$.fragment,e),f(k.$$.fragment,e),Ka=!0)},o(e){h($.$$.fragment,e),h(x.$$.fragment,e),h(C.$$.fragment,e),h(I.$$.fragment,e),h(q.$$.fragment,e),h(N.$$.fragment,e),h(O.$$.fragment,e),h(ae.$$.fragment,e),h(J.$$.fragment,e),h(se.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h($e.$$.fragment,e),h(U.$$.fragment,e),h(Ce.$$.fragment,e),h(Ue.$$.fragment,e),h(Pe.$$.fragment,e),h(Fe.$$.fragment,e),h(Ie.$$.fragment,e),h(Be.$$.fragment,e),h(Ne.$$.fragment,e),h(Se.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(at.$$.fragment,e),h(ot.$$.fragment,e),h(dt.$$.fragment,e),h(Tt.$$.fragment,e),h(jt.$$.fragment,e),h(Lt.$$.fragment,e),h(Wt.$$.fragment,e),h(It.$$.fragment,e),h(qt.$$.fragment,e),h(an.$$.fragment,e),h(rn.$$.fragment,e),h(k.$$.fragment,e),Ka=!1},d(e){e&&(n(b),n(g),n(w),n(M),n(_),n(fn),n(hn),n(H),n(un),n(j),n(gn),n(z),n(yn),n(A),n(wn),n(L),n(bn),n(P),n(Mn),n(vn),n(W),n(Tn),n(G),n(_n),n(F),n($n),n(R),n(xn),n(Cn),n(Y),n(Jn),n(Z),n(Un),n(B),n(kn),n(X),n(Hn),n(jn),n(E),n(zn),n(V),n(An),n(Ln),n(D),n(Pn),n(S),n(Wn),n(Q),n(Gn),n(K),n(Fn),n(Rn),n(ee),n(In),n(te),n(Yn),n(ne),n(Zn),n(ie),n(Bn),n(Xn),n(le),n(qn),n(En),n(Vn),n(re),n(Nn),n(oe),n(Dn),n(Sn),n(me),n(Qn),n(de),n(Kn),n(On),n(fe),n(ei),n(ti),n(ue),n(ni),n(ge),n(ii),n(ai),n(li),n(be),n(si),n(ri),n(ve),n(oi),n(Te),n(pi),n(_e),n(mi),n(di),n(ci),n(xe),n(fi),n(hi),n(Je),n(ui),n(gi),n(ke),n(yi),n(He),n(wi),n(je),n(bi),n(ze),n(Mi),n(Ae),n(vi),n(Le),n(Ti),n(_i),n(We),n($i),n(Ge),n(xi),n(Ci),n(Re),n(Ji),n(Ui),n(Ye),n(ki),n(Ze),n(Hi),n(ji),n(Xe),n(zi),n(qe),n(Ai),n(Ee),n(Li),n(Ve),n(Pi),n(Wi),n(De),n(Gi),n(Fi),n(Qe),n(Ri),n(Ii),n(Oe),n(Yi),n(Zi),n(tt),n(Bi),n(nt),n(Xi),n(it),n(qi),n(Ei),n(lt),n(Vi),n(st),n(Ni),n(rt),n(Di),n(Si),n(pt),n(Qi),n(mt),n(Ki),n(Oi),n(ct),n(ea),n(ft),n(ta),n(ht),n(na),n(ut),n(ia),n(gt),n(aa),n(yt),n(la),n(wt),n(sa),n(bt),n(ra),n(Mt),n(oa),n(vt),n(pa),n(ma),n(_t),n(da),n($t),n(ca),n(xt),n(fa),n(Ct),n(ha),n(Jt),n(ua),n(Ut),n(ga),n(kt),n(ya),n(Ht),n(wa),n(ba),n(zt),n(Ma),n(At),n(va),n(Ta),n(Pt),n(_a),n($a),n(Gt),n(xa),n(Ft),n(Ca),n(Rt),n(Ja),n(Ua),n(Yt),n(ka),n(Zt),n(Ha),n(Bt),n(ja),n(Xt),n(za),n(Aa),n(Et),n(La),n(Vt),n(Pa),n(Nt),n(Wa),n(Dt),n(Ga),n(St),n(Fa),n(Qt),n(Ra),n(Kt),n(Ia),n(Ot),n(Ya),n(en),n(Za),n(tn),n(Ba),n(nn),n(Xa),n(qa),n(ln),n(Ea),n(sn),n(Va),n(Na),n(on),n(Da),n(Sa),n(pn),n(Qa),n(mn)),n(p),u($,e),u(x,e),u(C,e),u(I,e),u(q,e),u(N,e),u(O,e),u(ae,e),u(J,e),u(se,e),u(pe,e),u(ce,e),u(he,e),u(ye,e),u(we,e),u(Me,e),u($e,e),u(U,e),u(Ce,e),u(Ue,e),u(Pe,e),u(Fe,e),u(Ie,e),u(Be,e),u(Ne,e),u(Se,e),u(Ke,e),u(et,e),u(at,e),u(ot,e),u(dt,e),u(Tt,e),u(jt,e),u(Lt,e),u(Wt,e),u(It,e),u(qt,e),u(an,e),u(rn,e),u(k,e)}}}const wr='{"title":"Methods and tools for efficient training on a single GPU","local":"methods-and-tools-for-efficient-training-on-a-single-gpu","sections":[{"title":"Batch size choice","local":"batch-size-choice","sections":[],"depth":2},{"title":"Gradient Accumulation","local":"gradient-accumulation","sections":[],"depth":2},{"title":"Gradient Checkpointing","local":"gradient-checkpointing","sections":[],"depth":2},{"title":"Mixed precision training","local":"mixed-precision-training","sections":[{"title":"fp16","local":"fp16","sections":[],"depth":3},{"title":"BF16","local":"bf16","sections":[],"depth":3},{"title":"TF32","local":"tf32","sections":[],"depth":3}],"depth":2},{"title":"Flash Attention 2","local":"flash-attention-2","sections":[],"depth":2},{"title":"Optimizer choice","local":"optimizer-choice","sections":[{"title":"Adafactor","local":"adafactor","sections":[],"depth":3},{"title":"8-bit Adam","local":"8-bit-adam","sections":[],"depth":3},{"title":"multi_tensor","local":"multitensor","sections":[],"depth":3}],"depth":2},{"title":"Data preloading","local":"data-preloading","sections":[],"depth":2},{"title":"DeepSpeed ZeRO","local":"deepspeed-zero","sections":[],"depth":2},{"title":"Using torch.compile","local":"using-torchcompile","sections":[],"depth":2},{"title":"Using 🤗 PEFT","local":"using--peft","sections":[],"depth":2},{"title":"Using 🤗 Accelerate","local":"using--accelerate","sections":[],"depth":2},{"title":"Efficient Software Prebuilds","local":"efficient-software-prebuilds","sections":[],"depth":2},{"title":"Mixture of Experts","local":"mixture-of-experts","sections":[],"depth":2},{"title":"Using PyTorch native attention and Flash Attention","local":"using-pytorch-native-attention-and-flash-attention","sections":[],"depth":2}],"depth":1}';function br(T){return rr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xr extends or{constructor(p){super(),pr(this,p,br,yr,sr,{})}}export{xr as component};
