import{s as Ps,n as Ds,o as Ks}from"../chunks/scheduler.9bc65507.js";import{S as Os,i as ea,g as p,s as l,r,A as ta,h as i,f as s,c as n,j as Ls,u as m,x as o,k as Ys,y as sa,a,v as h,d as c,t as d,w as M}from"../chunks/index.707bf1b6.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{H as g}from"../chunks/Heading.342b1fa6.js";function aa(ns){let u,ze,Ge,We,j,Be,T,Ve,J,ps=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong> as well as message text.`,Re,f,is=`Most commonly, these roles are “user” for messages sent by the user, and “assistant” for messages sent by the model.
Some models also support a “system” role. System messages are usually sent at the beginning of the conversation
and include directives about how the model should behave in the subsequent chat.`,qe,U,os=`All language models, including models fine-tuned for chat, operate on linear sequences of tokens and do not intrinsically
have special handling for roles. This means that role information is usually injected by adding control tokens
between messages, to indicate both the message boundary and the relevant roles.`,He,w,rs=`Unfortunately, there isn’t (yet!) a standard for which tokens to use, and so different models have been trained
with wildly different formatting and control tokens for chat. This can be a real problem for users - if you use the
wrong format, then the model will be confused by your input, and your performance will be a lot worse than it should be.
This is the problem that <strong>chat templates</strong> aim to resolve.`,Ee,I,ms=`Chat conversations are typically represented as a list of dictionaries, where each dictionary contains <code>role</code>
and <code>content</code> keys, and represents a single chat message. Chat templates are strings containing a Jinja template that
specifies how to format a conversation for a given model into a single tokenizable sequence. By storing this information
with the tokenizer, we can ensure that models get input data in the format they expect.`,Xe,b,hs=`Let’s make this concrete with a quick example using the <code>BlenderBot</code> model. BlenderBot has an extremely simple default
template, which mostly just adds whitespace between rounds of dialogue:`,Fe,x,Le,C,cs=`Notice how the entire chat is condensed into a single string. If we use <code>tokenize=True</code>, which is the default setting,
that string will also be tokenized for us. To see a more complex template in action, though, let’s use the
<code>meta-llama/Llama-2-7b-chat-hf</code> model. Note that this model has gated access, so you will have to
<a href="https://huggingface.co/meta-llama/Llama-2-7b-chat-hf" rel="nofollow">request access on the repo</a> if you want to run this code yourself:`,Ye,N,Pe,k,ds=`Note that this time, the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!)`,De,$,Ke,v,Ms=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at the template for <code>BlenderBot</code>:`,Oe,Q,et,Z,ys=`That’s kind of intimidating. Let’s add some newlines and indentation to make it more readable. Note that the first
newline after each block as well as any preceding whitespace before a block are ignored by default, using the
Jinja <code>trim_blocks</code> and <code>lstrip_blocks</code> flags. However, be cautious - although leading whitespace on each
line is stripped, spaces between blocks on the same line are not. We strongly recommend checking that your template
isn’t printing extra spaces where it shouldn’t be!`,tt,_,st,A,gs=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,at,G,lt,S,us="Effectively, the template does three things:",nt,z,js="<li>For each message, if the message is a user message, add a blank space before it, otherwise print nothing.</li> <li>Add the message content</li> <li>If the message is not the last message, add two spaces after it. After the final message, print the EOS token.</li>",pt,W,Ts=`This is a pretty simple template - it doesn’t add any control tokens, and it doesn’t support “system” messages, which
are a common way to give the model directives about how it should behave in the subsequent conversation.
But Jinja gives you a lot of flexibility to do those things! Let’s see a Jinja template that can format inputs
similarly to the way LLaMA formats them (note that the real LLaMA template includes handling for default system
messages and slightly different system message handling in general - don’t use this one in your actual code!)`,it,B,ot,V,Js=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens based
on the “role” of each message, which represents who sent it. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,rt,R,mt,q,fs=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,ht,H,ct,E,Us=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/v4.35.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/v4.35.0/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,dt,X,Mt,F,ws=`The method <a href="/docs/transformers/v4.35.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/v4.35.0/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/v4.35.0/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>.`,yt,L,gt,Y,Is=`Before the introduction of chat templates, chat handling was hardcoded at the model class level. For backwards
compatibility, we have retained this class-specific handling as default templates, also set at the class level. If a
model does not have a chat template set, but there is a default template for its model class, the <code>ConversationalPipeline</code>
class and methods like <code>apply_chat_template</code> will use the class template instead. You can find out what the default
template for your tokenizer is by checking the <code>tokenizer.default_chat_template</code> attribute.`,ut,P,bs=`This is something we do purely for backward compatibility reasons, to avoid breaking any existing workflows. Even when
the class template is appropriate for your model, we strongly recommend overriding the default template by
setting the <code>chat_template</code> attribute explicitly to make it clear to users that your model has been correctly configured
for chat, and to future-proof in case the default templates are ever altered or deprecated.`,jt,D,Tt,K,xs=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,Jt,O,Cs=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. Our default template for models that don’t have a class-specific template follows the
<a href="https://github.com/openai/openai-python/blob/main/chatml.md" rel="nofollow">ChatML format</a>, and this is a good, flexible choice for many use-cases. It looks like this:`,ft,ee,Ut,te,Ns=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for “generation prompts” - see the next section for more!`,wt,se,It,ae,ks=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,bt,le,xt,ne,$s=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/v4.35.0/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,Ct,pe,Nt,ie,vs=`You may notice that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,kt,oe,$t,re,Qs="Here’s what this will look like without a generation prompt, using the ChatML template we described above:",vt,me,Qt,he,Zs="And here’s what it looks like <strong>with</strong> a generation prompt:",Zt,ce,_t,de,_s=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with the appropriate control tokens so they know what they’re
supposed to be doing.`,At,Me,As=`Not all models require generation prompts. Some models, like BlenderBot and LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,Gt,ye,St,ge,Gs=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/v4.35.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.apply_chat_template">apply_chat_template()</a>. This applies even if you’re not the model owner - if you’re using a model
with an empty chat template, or one that’s still using the default class template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to
the model repository so that this attribute can be set properly!`,zt,ue,Ss=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>ConversationalPipeline</code>!`,Wt,je,zs=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,Bt,Te,Vt,Je,Ws=`If you’re unfamiliar with Jinja, we generally find that the easiest way to write a chat template is to first
write a short Python script that formats messages the way you want, and then convert that script into a template.`,Rt,fe,Bs=`Remember that the template handler will receive the conversation history as a variable called <code>messages</code>. Each
message is a dictionary with two keys, <code>role</code> and <code>content</code>. You will be able to access <code>messages</code> in your template
just like you can in Python, which means you can loop over it with <code>{% for message in messages %}</code> or access
individual messages with, for example, <code>{{ messages[0] }}</code>.`,qt,Ue,Vs="You can also use the following tips to convert your code to Jinja:",Ht,we,Et,Ie,Rs="For loops in Jinja look like this:",Xt,be,Ft,xe,qs=`Note that whatever’s inside the {{ expression block }} will be printed to the output. You can use operators like
<code>+</code> to combine strings inside expression blocks.`,Lt,Ce,Yt,Ne,Hs="If statements in Jinja look like this:",Pt,ke,Dt,$e,Es=`Note how where Python uses whitespace to mark the beginnings and ends of <code>for</code> and <code>if</code> blocks, Jinja requires you
to explicitly end them with <code>{% endfor %}</code> and <code>{% endif %}</code>.`,Kt,ve,Ot,Qe,Xs=`Inside your template, you will have access to the list of <code>messages</code>, but you can also access several other special
variables. These include special tokens like <code>bos_token</code> and <code>eos_token</code>, as well as the <code>add_generation_prompt</code>
variable that we discussed above. You can also use the <code>loop</code> variable to access information about the current loop
iteration, for example  using <code>{% if loop.last %}</code> to check if the current message is the last message in the
conversation. Here’s an example that puts these ideas together to add a generation prompt at the end of the
conversation if add_generation_prompt is <code>True</code>:`,es,Ze,ts,_e,ss,Ae,Fs=`As much as possible, we’ve tried to get Jinja to ignore whitespace outside of {{ expressions }}. However, be aware
that Jinja is a general-purpose templating engine, and it may treat whitespace between blocks on the same line
as significant and print it to the output. We <strong>strongly</strong> recommend checking that your template isn’t printing extra
spaces where it shouldn’t be before you upload it!`,as,Se,ls;return j=new g({props:{title:"Templates for Chat Models",local:"templates-for-chat-models",headingTag:"h1"}}),T=new g({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),x=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),N=new y({props:{code:"JTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGVsbG8lMkMlMjBob3clMjBhcmUlMjB5b3UlM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknZCUyMGxpa2UlMjB0byUyMHNob3clMjBvZmYlMjBob3clMjBjaGF0JTIwdGVtcGxhdGluZyUyMHdvcmtzISUyMiU3RCUyQyUwQSU1RCUwQQ==",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

&gt;&gt; chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

&gt;&gt; tokenizer.use_default_system_prompt = <span class="hljs-literal">False</span>
&gt;&gt; tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST] I&#x27;m doing great. How can I help you today? &lt;/s&gt;&lt;s&gt;[INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),$=new g({props:{title:"How do chat templates work?",local:"how-do-chat-templates-work",headingTag:"h2"}}),Q=new y({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),_=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),G=new y({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),B=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),R=new g({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h2"}}),H=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),X=new y({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),L=new g({props:{title:"What are “default” templates?",local:"what-are-default-templates",headingTag:"h2"}}),D=new g({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h2"}}),ee=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),se=new y({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'<span class="language-xml">tokenizer.chat_template = &quot;</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not add_generation_prompt is defined <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">set</span> add_generation_prompt = false <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> add_generation_prompt <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;|im_start|&gt;assistant\\n&#x27;</span> }}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">&quot;</span>',wrap:!1}}),le=new y({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|<span class="hljs-type">im_start</span>|<span class="hljs-type">&gt;system</span>
You are a helpful chatbot that will <span class="hljs-built_in">do</span> its best not to say anything so stupid that people tweet about it.&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;user</span>
How are you?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>
I&#x27;m doing great!&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),pe=new g({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),oe=new y({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),me=new y({props:{code:"JTNFJTNFJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`&gt;&gt; tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),ce=new y({props:{code:"JTNFJTNFJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`&gt;&gt; tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),ye=new g({props:{title:"I want to use chat templates! How should I get started?",local:"i-want-to-use-chat-templates-how-should-i-get-started",headingTag:"h2"}}),Te=new g({props:{title:"Template writing tips",local:"template-writing-tips",headingTag:"h2"}}),we=new g({props:{title:"For loops",local:"for-loops",headingTag:"h3"}}),be=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElN0IlN0IlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),Ce=new g({props:{title:"If statements",local:"if-statements",headingTag:"h3"}}),ke=new y({props:{code:"JTdCJTI1JTIwaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3VzZXInJTIwJTI1JTdEJTBBJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),ve=new g({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),Ze=new y({props:{code:"JTdCJTI1JTIwaWYlMjBsb29wLmxhc3QlMjBhbmQlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnQXNzaXN0YW50JTNBJTVDbiclMjAlN0QlN0QlMEElN0IlMjUlMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> loop.last and add_generation_prompt %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ bos_token + &#x27;Assistant:\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),_e=new g({props:{title:"Notes on whitespace",local:"notes-on-whitespace",headingTag:"h3"}}),{c(){u=p("meta"),ze=l(),Ge=p("p"),We=l(),r(j.$$.fragment),Be=l(),r(T.$$.fragment),Ve=l(),J=p("p"),J.innerHTML=ps,Re=l(),f=p("p"),f.textContent=is,qe=l(),U=p("p"),U.textContent=os,He=l(),w=p("p"),w.innerHTML=rs,Ee=l(),I=p("p"),I.innerHTML=ms,Xe=l(),b=p("p"),b.innerHTML=hs,Fe=l(),r(x.$$.fragment),Le=l(),C=p("p"),C.innerHTML=cs,Ye=l(),r(N.$$.fragment),Pe=l(),k=p("p"),k.textContent=ds,De=l(),r($.$$.fragment),Ke=l(),v=p("p"),v.innerHTML=Ms,Oe=l(),r(Q.$$.fragment),et=l(),Z=p("p"),Z.innerHTML=ys,tt=l(),r(_.$$.fragment),st=l(),A=p("p"),A.innerHTML=gs,at=l(),r(G.$$.fragment),lt=l(),S=p("p"),S.textContent=us,nt=l(),z=p("ol"),z.innerHTML=js,pt=l(),W=p("p"),W.textContent=Ts,it=l(),r(B.$$.fragment),ot=l(),V=p("p"),V.textContent=Js,rt=l(),r(R.$$.fragment),mt=l(),q=p("p"),q.innerHTML=fs,ht=l(),r(H.$$.fragment),ct=l(),E=p("p"),E.innerHTML=Us,dt=l(),r(X.$$.fragment),Mt=l(),F=p("p"),F.innerHTML=ws,yt=l(),r(L.$$.fragment),gt=l(),Y=p("p"),Y.innerHTML=Is,ut=l(),P=p("p"),P.innerHTML=bs,jt=l(),r(D.$$.fragment),Tt=l(),K=p("p"),K.textContent=xs,Jt=l(),O=p("p"),O.innerHTML=Cs,ft=l(),r(ee.$$.fragment),Ut=l(),te=p("p"),te.textContent=Ns,wt=l(),r(se.$$.fragment),It=l(),ae=p("p"),ae.innerHTML=ks,bt=l(),r(le.$$.fragment),xt=l(),ne=p("p"),ne.innerHTML=$s,Ct=l(),r(pe.$$.fragment),Nt=l(),ie=p("p"),ie.innerHTML=vs,kt=l(),r(oe.$$.fragment),$t=l(),re=p("p"),re.textContent=Qs,vt=l(),r(me.$$.fragment),Qt=l(),he=p("p"),he.innerHTML=Zs,Zt=l(),r(ce.$$.fragment),_t=l(),de=p("p"),de.textContent=_s,At=l(),Me=p("p"),Me.innerHTML=As,Gt=l(),r(ye.$$.fragment),St=l(),ge=p("p"),ge.innerHTML=Gs,zt=l(),ue=p("p"),ue.innerHTML=Ss,Wt=l(),je=p("p"),je.textContent=zs,Bt=l(),r(Te.$$.fragment),Vt=l(),Je=p("p"),Je.textContent=Ws,Rt=l(),fe=p("p"),fe.innerHTML=Bs,qt=l(),Ue=p("p"),Ue.textContent=Vs,Ht=l(),r(we.$$.fragment),Et=l(),Ie=p("p"),Ie.textContent=Rs,Xt=l(),r(be.$$.fragment),Ft=l(),xe=p("p"),xe.innerHTML=qs,Lt=l(),r(Ce.$$.fragment),Yt=l(),Ne=p("p"),Ne.textContent=Hs,Pt=l(),r(ke.$$.fragment),Dt=l(),$e=p("p"),$e.innerHTML=Es,Kt=l(),r(ve.$$.fragment),Ot=l(),Qe=p("p"),Qe.innerHTML=Xs,es=l(),r(Ze.$$.fragment),ts=l(),r(_e.$$.fragment),ss=l(),Ae=p("p"),Ae.innerHTML=Fs,as=l(),Se=p("p"),this.h()},l(e){const t=ta("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(s),ze=n(e),Ge=i(e,"P",{}),Ls(Ge).forEach(s),We=n(e),m(j.$$.fragment,e),Be=n(e),m(T.$$.fragment,e),Ve=n(e),J=i(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1ktexn3"&&(J.innerHTML=ps),Re=n(e),f=i(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1xlggqv"&&(f.textContent=is),qe=n(e),U=i(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-pmlzkx"&&(U.textContent=os),He=n(e),w=i(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-17e4zh4"&&(w.innerHTML=rs),Ee=n(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1bgzjn5"&&(I.innerHTML=ms),Xe=n(e),b=i(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1n6wf0k"&&(b.innerHTML=hs),Fe=n(e),m(x.$$.fragment,e),Le=n(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1ensusj"&&(C.innerHTML=cs),Ye=n(e),m(N.$$.fragment,e),Pe=n(e),k=i(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-7ppdar"&&(k.textContent=ds),De=n(e),m($.$$.fragment,e),Ke=n(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-9hx4bd"&&(v.innerHTML=Ms),Oe=n(e),m(Q.$$.fragment,e),et=n(e),Z=i(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-gucfz7"&&(Z.innerHTML=ys),tt=n(e),m(_.$$.fragment,e),st=n(e),A=i(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-zet1qo"&&(A.innerHTML=gs),at=n(e),m(G.$$.fragment,e),lt=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-9bdwn1"&&(S.textContent=us),nt=n(e),z=i(e,"OL",{"data-svelte-h":!0}),o(z)!=="svelte-yy2gop"&&(z.innerHTML=js),pt=n(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-jxu6rq"&&(W.textContent=Ts),it=n(e),m(B.$$.fragment,e),ot=n(e),V=i(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-dqaxjt"&&(V.textContent=Js),rt=n(e),m(R.$$.fragment,e),mt=n(e),q=i(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1ubxgh9"&&(q.innerHTML=fs),ht=n(e),m(H.$$.fragment,e),ct=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-a8woyx"&&(E.innerHTML=Us),dt=n(e),m(X.$$.fragment,e),Mt=n(e),F=i(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1djyp39"&&(F.innerHTML=ws),yt=n(e),m(L.$$.fragment,e),gt=n(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-fwloaj"&&(Y.innerHTML=Is),ut=n(e),P=i(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-118w8i2"&&(P.innerHTML=bs),jt=n(e),m(D.$$.fragment,e),Tt=n(e),K=i(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-5u6sqi"&&(K.textContent=xs),Jt=n(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-u7dsj6"&&(O.innerHTML=Cs),ft=n(e),m(ee.$$.fragment,e),Ut=n(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-kumxzd"&&(te.textContent=Ns),wt=n(e),m(se.$$.fragment,e),It=n(e),ae=i(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-soh9qu"&&(ae.innerHTML=ks),bt=n(e),m(le.$$.fragment,e),xt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-10pgdjl"&&(ne.innerHTML=$s),Ct=n(e),m(pe.$$.fragment,e),Nt=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1jrs4or"&&(ie.innerHTML=vs),kt=n(e),m(oe.$$.fragment,e),$t=n(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-ku5b4p"&&(re.textContent=Qs),vt=n(e),m(me.$$.fragment,e),Qt=n(e),he=i(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-61bp3d"&&(he.innerHTML=Zs),Zt=n(e),m(ce.$$.fragment,e),_t=n(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1h8j73s"&&(de.textContent=_s),At=n(e),Me=i(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-76qw2e"&&(Me.innerHTML=As),Gt=n(e),m(ye.$$.fragment,e),St=n(e),ge=i(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1jz2aan"&&(ge.innerHTML=Gs),zt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1dmaop5"&&(ue.innerHTML=Ss),Wt=n(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-197jyne"&&(je.textContent=zs),Bt=n(e),m(Te.$$.fragment,e),Vt=n(e),Je=i(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-64od1c"&&(Je.textContent=Ws),Rt=n(e),fe=i(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-155y3gc"&&(fe.innerHTML=Bs),qt=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1hxm0m6"&&(Ue.textContent=Vs),Ht=n(e),m(we.$$.fragment,e),Et=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1mepej5"&&(Ie.textContent=Rs),Xt=n(e),m(be.$$.fragment,e),Ft=n(e),xe=i(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-rw0syz"&&(xe.innerHTML=qs),Lt=n(e),m(Ce.$$.fragment,e),Yt=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-audzqy"&&(Ne.textContent=Hs),Pt=n(e),m(ke.$$.fragment,e),Dt=n(e),$e=i(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-gc7ich"&&($e.innerHTML=Es),Kt=n(e),m(ve.$$.fragment,e),Ot=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1ky9l6m"&&(Qe.innerHTML=Xs),es=n(e),m(Ze.$$.fragment,e),ts=n(e),m(_e.$$.fragment,e),ss=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-qra3hk"&&(Ae.innerHTML=Fs),as=n(e),Se=i(e,"P",{}),Ls(Se).forEach(s),this.h()},h(){Ys(u,"name","hf:doc:metadata"),Ys(u,"content",la)},m(e,t){sa(document.head,u),a(e,ze,t),a(e,Ge,t),a(e,We,t),h(j,e,t),a(e,Be,t),h(T,e,t),a(e,Ve,t),a(e,J,t),a(e,Re,t),a(e,f,t),a(e,qe,t),a(e,U,t),a(e,He,t),a(e,w,t),a(e,Ee,t),a(e,I,t),a(e,Xe,t),a(e,b,t),a(e,Fe,t),h(x,e,t),a(e,Le,t),a(e,C,t),a(e,Ye,t),h(N,e,t),a(e,Pe,t),a(e,k,t),a(e,De,t),h($,e,t),a(e,Ke,t),a(e,v,t),a(e,Oe,t),h(Q,e,t),a(e,et,t),a(e,Z,t),a(e,tt,t),h(_,e,t),a(e,st,t),a(e,A,t),a(e,at,t),h(G,e,t),a(e,lt,t),a(e,S,t),a(e,nt,t),a(e,z,t),a(e,pt,t),a(e,W,t),a(e,it,t),h(B,e,t),a(e,ot,t),a(e,V,t),a(e,rt,t),h(R,e,t),a(e,mt,t),a(e,q,t),a(e,ht,t),h(H,e,t),a(e,ct,t),a(e,E,t),a(e,dt,t),h(X,e,t),a(e,Mt,t),a(e,F,t),a(e,yt,t),h(L,e,t),a(e,gt,t),a(e,Y,t),a(e,ut,t),a(e,P,t),a(e,jt,t),h(D,e,t),a(e,Tt,t),a(e,K,t),a(e,Jt,t),a(e,O,t),a(e,ft,t),h(ee,e,t),a(e,Ut,t),a(e,te,t),a(e,wt,t),h(se,e,t),a(e,It,t),a(e,ae,t),a(e,bt,t),h(le,e,t),a(e,xt,t),a(e,ne,t),a(e,Ct,t),h(pe,e,t),a(e,Nt,t),a(e,ie,t),a(e,kt,t),h(oe,e,t),a(e,$t,t),a(e,re,t),a(e,vt,t),h(me,e,t),a(e,Qt,t),a(e,he,t),a(e,Zt,t),h(ce,e,t),a(e,_t,t),a(e,de,t),a(e,At,t),a(e,Me,t),a(e,Gt,t),h(ye,e,t),a(e,St,t),a(e,ge,t),a(e,zt,t),a(e,ue,t),a(e,Wt,t),a(e,je,t),a(e,Bt,t),h(Te,e,t),a(e,Vt,t),a(e,Je,t),a(e,Rt,t),a(e,fe,t),a(e,qt,t),a(e,Ue,t),a(e,Ht,t),h(we,e,t),a(e,Et,t),a(e,Ie,t),a(e,Xt,t),h(be,e,t),a(e,Ft,t),a(e,xe,t),a(e,Lt,t),h(Ce,e,t),a(e,Yt,t),a(e,Ne,t),a(e,Pt,t),h(ke,e,t),a(e,Dt,t),a(e,$e,t),a(e,Kt,t),h(ve,e,t),a(e,Ot,t),a(e,Qe,t),a(e,es,t),h(Ze,e,t),a(e,ts,t),h(_e,e,t),a(e,ss,t),a(e,Ae,t),a(e,as,t),a(e,Se,t),ls=!0},p:Ds,i(e){ls||(c(j.$$.fragment,e),c(T.$$.fragment,e),c(x.$$.fragment,e),c(N.$$.fragment,e),c($.$$.fragment,e),c(Q.$$.fragment,e),c(_.$$.fragment,e),c(G.$$.fragment,e),c(B.$$.fragment,e),c(R.$$.fragment,e),c(H.$$.fragment,e),c(X.$$.fragment,e),c(L.$$.fragment,e),c(D.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(pe.$$.fragment,e),c(oe.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),c(Te.$$.fragment,e),c(we.$$.fragment,e),c(be.$$.fragment,e),c(Ce.$$.fragment,e),c(ke.$$.fragment,e),c(ve.$$.fragment,e),c(Ze.$$.fragment,e),c(_e.$$.fragment,e),ls=!0)},o(e){d(j.$$.fragment,e),d(T.$$.fragment,e),d(x.$$.fragment,e),d(N.$$.fragment,e),d($.$$.fragment,e),d(Q.$$.fragment,e),d(_.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(R.$$.fragment,e),d(H.$$.fragment,e),d(X.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(pe.$$.fragment,e),d(oe.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(ye.$$.fragment,e),d(Te.$$.fragment,e),d(we.$$.fragment,e),d(be.$$.fragment,e),d(Ce.$$.fragment,e),d(ke.$$.fragment,e),d(ve.$$.fragment,e),d(Ze.$$.fragment,e),d(_e.$$.fragment,e),ls=!1},d(e){e&&(s(ze),s(Ge),s(We),s(Be),s(Ve),s(J),s(Re),s(f),s(qe),s(U),s(He),s(w),s(Ee),s(I),s(Xe),s(b),s(Fe),s(Le),s(C),s(Ye),s(Pe),s(k),s(De),s(Ke),s(v),s(Oe),s(et),s(Z),s(tt),s(st),s(A),s(at),s(lt),s(S),s(nt),s(z),s(pt),s(W),s(it),s(ot),s(V),s(rt),s(mt),s(q),s(ht),s(ct),s(E),s(dt),s(Mt),s(F),s(yt),s(gt),s(Y),s(ut),s(P),s(jt),s(Tt),s(K),s(Jt),s(O),s(ft),s(Ut),s(te),s(wt),s(It),s(ae),s(bt),s(xt),s(ne),s(Ct),s(Nt),s(ie),s(kt),s($t),s(re),s(vt),s(Qt),s(he),s(Zt),s(_t),s(de),s(At),s(Me),s(Gt),s(St),s(ge),s(zt),s(ue),s(Wt),s(je),s(Bt),s(Vt),s(Je),s(Rt),s(fe),s(qt),s(Ue),s(Ht),s(Et),s(Ie),s(Xt),s(Ft),s(xe),s(Lt),s(Yt),s(Ne),s(Pt),s(Dt),s($e),s(Kt),s(Ot),s(Qe),s(es),s(ts),s(ss),s(Ae),s(as),s(Se)),s(u),M(j,e),M(T,e),M(x,e),M(N,e),M($,e),M(Q,e),M(_,e),M(G,e),M(B,e),M(R,e),M(H,e),M(X,e),M(L,e),M(D,e),M(ee,e),M(se,e),M(le,e),M(pe,e),M(oe,e),M(me,e),M(ce,e),M(ye,e),M(Te,e),M(we,e),M(be,e),M(Ce,e),M(ke,e),M(ve,e),M(Ze,e),M(_e,e)}}}const la='{"title":"Templates for Chat Models","local":"templates-for-chat-models","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do chat templates work?","local":"how-do-chat-templates-work","sections":[],"depth":2},{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":2},{"title":"What are “default” templates?","local":"what-are-default-templates","sections":[],"depth":2},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"I want to use chat templates! How should I get started?","local":"i-want-to-use-chat-templates-how-should-i-get-started","sections":[],"depth":2},{"title":"Template writing tips","local":"template-writing-tips","sections":[{"title":"For loops","local":"for-loops","sections":[],"depth":3},{"title":"If statements","local":"if-statements","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Notes on whitespace","local":"notes-on-whitespace","sections":[],"depth":3}],"depth":2}],"depth":1}';function na(ns){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ma extends Os{constructor(u){super(),ea(this,u,na,aa,Ps,{})}}export{ma as component};
