import{s as ya,o as ba,n as pn}from"../chunks/scheduler.182ea377.js";import{S as _a,i as wa,g as l,s as i,r as c,A as Ja,h as o,f as n,c as s,j as k,u as m,x as r,k as C,y as d,a,v as f,d as u,t as h,w as M}from"../chunks/index.abf12888.js";import{T as Gn}from"../chunks/Tip.230e2334.js";import{D as Qe}from"../chunks/Docstring.93f6f462.js";import{C as x}from"../chunks/CodeBlock.57fe6e13.js";import{E as Ta}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as j}from"../chunks/Heading.16916d63.js";function Ua(W){let p,U="AnimateDiff tends to work better with finetuned Stable Diffusion models. If you plan on using a scheduler that can clip samples, make sure to disable it by setting <code>clip_sample=False</code> in the scheduler as this can also have an adverse effect on generated samples. Additionally, the AnimateDiff checkpoints can be sensitive to the beta schedule of the scheduler. We recommend setting this to <code>linear</code>.";return{c(){p=l("p"),p.innerHTML=U},l(g){p=o(g,"P",{"data-svelte-h":!0}),r(p)!=="svelte-vnv4xn"&&(p.innerHTML=U)},m(g,w){a(g,p,w)},p:pn,d(g){g&&n(p)}}}function ja(W){let p,U="FreeInit is not really free - the improved quality comes at the cost of extra computation. It requires sampling a few extra times depending on the <code>num_iters</code> parameter that is set when enabling it. Setting the <code>use_fast_sampling</code> parameter to <code>True</code> can improve the overall performance (at the cost of lower quality compared to when <code>use_fast_sampling=False</code> but still better results than vanilla video generation models).";return{c(){p=l("p"),p.innerHTML=U},l(g){p=o(g,"P",{"data-svelte-h":!0}),r(p)!=="svelte-xxwpr5"&&(p.innerHTML=U)},m(g,w){a(g,p,w)},p:pn,d(g){g&&n(p)}}}function Za(W){let p,U='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){p=l("p"),p.innerHTML=U},l(g){p=o(g,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1wmc0l4"&&(p.innerHTML=U)},m(g,w){a(g,p,w)},p:pn,d(g){g&&n(p)}}}function Ia(W){let p,U="Examples:",g,w,Z;return w=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW90aW9uQWRhcHRlciUyQyUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZ3VveXd3JTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItdjEtNS0yJTIyKSUwQXBpcGUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJmcmFua2pvc2h1YSUyRnRvb255b3VfYmV0YTYlMjIlMkMlMjBtb3Rpb25fYWRhcHRlciUzRGFkYXB0ZXIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyKGJldGFfc2NoZWR1bGUlM0QlMjJsaW5lYXIlMjIlMkMlMjBzdGVwc19vZmZzZXQlM0QxJTJDJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSklMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCUyMkElMjBjb3JnaSUyMHdhbGtpbmclMjBpbiUyMHRoZSUyMHBhcmslMjIpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-meta">&gt;&gt;&gt; </span>adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;frankjoshua/toonyou_beta6&quot;</span>, motion_adapter=adapter)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler(beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>, steps_offset=<span class="hljs-number">1</span>, clip_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(prompt=<span class="hljs-string">&quot;A corgi walking in the park&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = output.frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),{c(){p=l("p"),p.textContent=U,g=i(),c(w.$$.fragment)},l(y){p=o(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-kvfsh7"&&(p.textContent=U),g=s(y),m(w.$$.fragment,y)},m(y,I){a(y,p,I),a(y,g,I),f(w,y,I),Z=!0},p:pn,i(y){Z||(u(w.$$.fragment,y),Z=!0)},o(y){h(w.$$.fragment,y),Z=!1},d(y){y&&(n(p),n(g)),M(w,y)}}}function va(W){let p,U,g,w,Z,y,I,ot,Q,Bn='<a href="https://arxiv.org/abs/2307.04725" rel="nofollow">AnimateDiff: Animate Your Personalized Text-to-Image Diffusion Models without Specific Tuning</a> by Yuwei Guo, Ceyuan Yang, Anyi Rao, Yaohui Wang, Yu Qiao, Dahua Lin, Bo Dai.',rt,N,Vn="The abstract of the paper is the following:",pt,Y,kn='<em>With the advance of text-to-image models (e.g., Stable Diffusion) and corresponding personalization techniques such as DreamBooth and LoRA, everyone can manifest their imagination into high-quality images at an affordable cost. Subsequently, there is a great demand for image animation techniques to further combine generated static images with motion dynamics. In this report, we propose a practical framework to animate most of the existing personalized text-to-image models once and for all, saving efforts in model-specific tuning. At the core of the proposed framework is to insert a newly initialized motion modeling module into the frozen text-to-image model and train it on video clips to distill reasonable motion priors. Once trained, by simply injecting this motion modeling module, all personalized versions derived from the same base T2I readily become text-driven models that produce diverse and personalized animated images. We conduct our evaluation on several public representative personalized text-to-image models across anime pictures and realistic photographs, and demonstrate that our proposed framework helps these models generate temporally smooth animation clips while preserving the domain and diversity of their outputs. Code and pre-trained weights will be publicly available at <a href="https://animatediff.github.io/" rel="nofollow">this https URL</a>.</em>',dt,S,ct,$,Cn='<thead><tr><th>Pipeline</th> <th>Tasks</th> <th align="center">Demo</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py" rel="nofollow">AnimateDiffPipeline</a></td> <td><em>Text-to-Video Generation with AnimateDiff</em></td> <td align="center"></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py" rel="nofollow">AnimateDiffVideoToVideoPipeline</a></td> <td><em>Video-to-Video Generation with AnimateDiff</em></td> <td align="center"></td></tr></tbody>',mt,H,ft,P,xn='Motion Adapter checkpoints can be found under <a href="https://huggingface.co/guoyww/" rel="nofollow">guoyww</a>. These checkpoints are meant to work with any model based on Stable Diffusion 1.4/1.5.',ut,q,ht,z,Mt,L,An="AnimateDiff works with a MotionAdapter checkpoint and a Stable Diffusion model checkpoint. The MotionAdapter is a collection of Motion Modules that are responsible for adding coherent motion across image frames. These modules are applied after the Resnet and Attention blocks in Stable Diffusion UNet.",gt,K,Xn="The following example demonstrates how to use a <em>MotionAdapter</em> checkpoint with Diffusers for inference based on StableDiffusion-1.4/1.5.",yt,O,bt,ee,Rn="Here are some sample outputs:",_t,te,En=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-realistic-doc.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,wt,A,Jt,ne,Tt,ae,Fn="AnimateDiff can also be used to generate visually similar videos or enable style/character/background or other edits starting from an initial video, allowing you to seamlessly explore creative possibilities.",Ut,ie,jt,se,Dn="Here are some sample outputs:",Zt,le,Qn=`<tbody><tr><th align="center">Source Video</th> <th align="center">Output Video</th></tr> <tr><td align="center">raccoon playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-1.gif" alt="racoon playing a guitar" style="width: 300px;"/></td> <td align="center">panda playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-output-1.gif" alt="panda playing a guitar" style="width: 300px;"/></td></tr> <tr><td align="center">closeup of margot robbie, fireworks in the background, high quality
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-2.gif" alt="closeup of margot robbie, fireworks in the background, high quality" style="width: 300px;"/></td> <td align="center">closeup of tony stark, robert downey jr, fireworks
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-output-2.gif" alt="closeup of tony stark, robert downey jr, fireworks" style="width: 300px;"/></td></tr></tbody>`,It,oe,vt,re,Nn="Motion LoRAs are a collection of LoRAs that work with the <code>guoyww/animatediff-motion-adapter-v1-5-2</code> checkpoint. These LoRAs are responsible for adding specific types of motion to the animations.",Wt,pe,Gt,de,Yn=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,Bt,ce,Vt,me,Sn='You can also leverage the <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> backend to combine Motion LoRA’s and create more complex animations.',kt,fe,$n="First install PEFT with",Ct,ue,xt,he,Hn="Then you can use the following code to combine Motion LoRAs.",At,Me,Xt,ge,Pn=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-pan-left-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,Rt,ye,Et,be,qn='<a href="https://arxiv.org/abs/2312.07537" rel="nofollow">FreeInit: Bridging Initialization Gap in Video Diffusion Models</a> by Tianxing Wu, Chenyang Si, Yuming Jiang, Ziqi Huang, Ziwei Liu.',Ft,_e,zn="FreeInit is an effective method that improves temporal consistency and overall quality of videos generated using video-diffusion-models without any addition training. It can be applied to AnimateDiff, ModelScope, VideoCrafter and various other video generation models seamlessly at inference time, and works by iteratively refining the latent-initialization noise. More details can be found it the paper.",Dt,we,Ln="The following example demonstrates the usage of FreeInit.",Qt,Je,Nt,X,Yt,R,St,Te,Kn=`<tbody><tr><th align="center">Without FreeInit enabled</th> <th align="center">With FreeInit enabled</th></tr> <tr><td align="center">panda playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-no-freeinit.gif" alt="panda playing a guitar" style="width: 300px;"/></td> <td align="center">panda playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-freeinit.gif" alt="panda playing a guitar" style="width: 300px;"/></td></tr></tbody>`,$t,Ue,Ht,je,On='<a href="https://animatelcm.github.io/" rel="nofollow">AnimateLCM</a> is a motion module checkpoint and an <a href="https://huggingface.co/docs/diffusers/using-diffusers/inference_with_lcm_lora" rel="nofollow">LCM LoRA</a> that have been created using a consistency learning strategy that decouples the distillation of the image generation priors and the motion generation priors.',Pt,Ze,qt,Ie,ea=`<tbody><tr><td><center>A space rocket, 4K.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatelcm-output.gif" alt="A space rocket, 4K" style="width: 300px;"/></center></td></tr></tbody>`,zt,ve,ta='AnimateLCM is also compatible with existing <a href="https://huggingface.co/collections/dn6/animatediff-motion-loras-654cb8ad732b9e3cf4d3c17e" rel="nofollow">Motion LoRAs</a>.',Lt,We,Kt,Ge,na=`<tbody><tr><td><center>A space rocket, 4K.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatelcm-motion-lora.gif" alt="A space rocket, 4K" style="width: 300px;"/></center></td></tr></tbody>`,Ot,Be,en,b,Ve,dn,Ne,aa="Pipeline for text-to-video generation.",cn,Ye,ia=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,mn,Se,sa="The pipeline also inherits the following loading methods:",fn,$e,la='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',un,G,ke,hn,He,oa="The call function to the pipeline for generation.",Mn,E,gn,F,Ce,yn,Pe,ra="Encodes the prompt into text encoder hidden states.",tn,xe,nn,_,Ae,bn,qe,pa="Pipeline for video-to-video generation.",_n,ze,da=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,wn,Le,ca="The pipeline also inherits the following loading methods:",Jn,Ke,ma='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Tn,B,Xe,Un,Oe,fa="The call function to the pipeline for generation.",jn,et,ua="Examples:",Zn,D,Re,In,tt,ha="Encodes the prompt into text encoder hidden states.",an,Ee,sn,v,Fe,vn,nt,Ma="Output class for AnimateDiff pipelines.",Wn,at,ga=`PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>`,ln,lt,on;return Z=new j({props:{title:"Text-to-Video Generation with AnimateDiff",local:"text-to-video-generation-with-animatediff",headingTag:"h1"}}),I=new j({props:{title:"Overview",local:"overview",headingTag:"h2"}}),S=new j({props:{title:"Available Pipelines",local:"available-pipelines",headingTag:"h2"}}),H=new j({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),q=new j({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),z=new j({props:{title:"AnimateDiffPipeline",local:"animatediffpipeline",headingTag:"h3"}}),O=new x({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`,wrap:!1}}),A=new Gn({props:{$$slots:{default:[Ua]},$$scope:{ctx:W}}}),ne=new j({props:{title:"AnimateDiffVideoToVideoPipeline",local:"animatediffvideotovideopipeline",headingTag:"h3"}}),ie=new x({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> imageio
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffVideoToVideoPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffVideoToVideoPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># helper function to load videos</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_video</span>(<span class="hljs-params">file_path: <span class="hljs-built_in">str</span></span>):
    images = []

    <span class="hljs-keyword">if</span> file_path.startswith((<span class="hljs-string">&#x27;http://&#x27;</span>, <span class="hljs-string">&#x27;https://&#x27;</span>)):
        <span class="hljs-comment"># If the file_path is a URL</span>
        response = requests.get(file_path)
        response.raise_for_status()
        content = BytesIO(response.content)
        vid = imageio.get_reader(content)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Assuming it&#x27;s a local file path</span>
        vid = imageio.get_reader(file_path)

    <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> vid:
        pil_image = Image.fromarray(frame)
        images.append(pil_image)

    <span class="hljs-keyword">return</span> images

video = load_video(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-1.gif&quot;</span>)

output = pipe(
    video = video,
    prompt=<span class="hljs-string">&quot;panda playing a guitar, on a boat, in the ocean, high quality&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    strength=<span class="hljs-number">0.5</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),oe=new j({props:{title:"Using Motion LoRAs",local:"using-motion-loras",headingTag:"h2"}}),pe=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMkMlMjBNb3Rpb25BZGFwdGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwbW90aW9uJTIwYWRhcHRlciUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBJTIzJTIwbG9hZCUyMFNEJTIwMS41JTIwYmFzZWQlMjBmaW5ldHVuZWQlMjBtb2RlbCUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyU0cxNjEyMjIlMkZSZWFsaXN0aWNfVmlzaW9uX1Y1LjFfbm9WQUUlMjIlMEFwaXBlJTIwJTNEJTIwQW5pbWF0ZURpZmZQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBtb3Rpb25fYWRhcHRlciUzRGFkYXB0ZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyglMEElMjAlMjAlMjAlMjAlMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tbG9yYS16b29tLW91dCUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnpvb20tb3V0JTIyJTBBKSUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMERESU1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGJldGFfc2NoZWR1bGUlM0QlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIybGluc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzdGVwc19vZmZzZXQlM0QxJTJDJTBBKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwc2NoZWR1bGVyJTBBJTBBJTIzJTIwZW5hYmxlJTIwbWVtb3J5JTIwc2F2aW5ncyUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWFzdGVycGllY2UlMkMlMjBiZXN0cXVhbGl0eSUyQyUyMGhpZ2hseWRldGFpbGVkJTJDJTIwdWx0cmFkZXRhaWxlZCUyQyUyMHN1bnNldCUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9yYW5nZSUyMHNreSUyQyUyMHdhcm0lMjBsaWdodGluZyUyQyUyMGZpc2hpbmclMjBib2F0cyUyQyUyMG9jZWFuJTIwd2F2ZXMlMjBzZWFndWxscyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJpcHBsaW5nJTIwd2F0ZXIlMkMlMjB3aGFyZiUyQyUyMHNpbGhvdWV0dGUlMkMlMjBzZXJlbmUlMjBhdG1vc3BoZXJlJTJDJTIwZHVzayUyQyUyMGV2ZW5pbmclMjBnbG93JTJDJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZ29sZGVuJTIwaG91ciUyQyUyMGNvYXN0YWwlMjBsYW5kc2NhcGUlMkMlMjBzZWFzaWRlJTIwc2NlbmVyeSUyMiUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJiYWQlMjBxdWFsaXR5JTJDJTIwd29yc2UlMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCg0MiklMkMlMEEpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIpJTBB",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>
)

scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`,wrap:!1}}),ce=new j({props:{title:"Using Motion LoRAs with PEFT",local:"using-motion-loras-with-peft",headingTag:"h2"}}),ue=new x({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft",wrap:!1}}),Me=new x({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)

pipe.load_lora_weights(
    <span class="hljs-string">&quot;diffusers/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>,
)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;diffusers/animatediff-motion-lora-pan-left&quot;</span>, adapter_name=<span class="hljs-string">&quot;pan-left&quot;</span>,
)
pipe.set_adapters([<span class="hljs-string">&quot;zoom-out&quot;</span>, <span class="hljs-string">&quot;pan-left&quot;</span>], adapter_weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>])

scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`,wrap:!1}}),ye=new j({props:{title:"Using FreeInit",local:"using-freeinit",headingTag:"h2"}}),Je=new x({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>
)

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_vae_tiling()

<span class="hljs-comment"># enable FreeInit</span>
<span class="hljs-comment"># Refer to the enable_free_init documentation for a full list of configurable parameters</span>
pipe.enable_free_init(method=<span class="hljs-string">&quot;butterworth&quot;</span>, use_fast_sampling=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># run inference</span>
output = pipe(
    prompt=<span class="hljs-string">&quot;a panda playing a guitar, on a boat, in the ocean, high quality&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">666</span>),
)

<span class="hljs-comment"># disable FreeInit</span>
pipe.disable_free_init()

frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),X=new Gn({props:{warning:!0,$$slots:{default:[ja]},$$scope:{ctx:W}}}),R=new Gn({props:{$$slots:{default:[Za]},$$scope:{ctx:W}}}),Ue=new j({props:{title:"Using AnimateLCM",local:"using-animatelcm",headingTag:"h2"}}),Ze=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMExDTVNjaGVkdWxlciUyQyUyME1vdGlvbkFkYXB0ZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX2dpZiUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJ3YW5nZnV5dW4lMkZBbmltYXRlTENNJTIyKSUwQXBpcGUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWclMkMlMjBiZXRhX3NjaGVkdWxlJTNEJTIybGluZWFyJTIyKSUwQSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIyd2FuZ2Z1eXVuJTJGQW5pbWF0ZUxDTSUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyc2QxNV9sb3JhX2JldGEuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJsY20tbG9yYSUyMiklMEElMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyQSUyMHNwYWNlJTIwcm9ja2V0JTIwd2l0aCUyMHRyYWlscyUyMG9mJTIwc21va2UlMjBiZWhpbmQlMjBpdCUyMGxhdW5jaGluZyUyMGludG8lMjBzcGFjZSUyMGZyb20lMjB0aGUlMjBkZXNlcnQlMkMlMjA0ayUyQyUyMGhpZ2glMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyYmFkJTIwcXVhbGl0eSUyQyUyMHdvcnNlJTIwcXVhbGl0eSUyQyUyMGxvdyUyMHJlc29sdXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q2JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMkMlMEEpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGVsY20uZ2lmJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, LCMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>)
pipe = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>)

pipe.load_lora_weights(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>, weight_name=<span class="hljs-string">&quot;sd15_lora_beta.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm-lora&quot;</span>)

pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=<span class="hljs-string">&quot;A space rocket with trails of smoke behind it launching into space from the desert, 4k, high resolution&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">1.5</span>,
    num_inference_steps=<span class="hljs-number">6</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animatelcm.gif&quot;</span>)`,wrap:!1}}),We=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMExDTVNjaGVkdWxlciUyQyUyME1vdGlvbkFkYXB0ZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX2dpZiUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJ3YW5nZnV5dW4lMkZBbmltYXRlTENNJTIyKSUwQXBpcGUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWclMkMlMjBiZXRhX3NjaGVkdWxlJTNEJTIybGluZWFyJTIyKSUwQSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIyd2FuZ2Z1eXVuJTJGQW5pbWF0ZUxDTSUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyc2QxNV9sb3JhX2JldGEuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJsY20tbG9yYSUyMiklMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmd1b3l3dyUyRmFuaW1hdGVkaWZmLW1vdGlvbi1sb3JhLXRpbHQtdXAlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJ0aWx0LXVwJTIyKSUwQSUwQXBpcGUuc2V0X2FkYXB0ZXJzKCU1QiUyMmxjbS1sb3JhJTIyJTJDJTIwJTIydGlsdC11cCUyMiU1RCUyQyUyMCU1QjEuMCUyQyUyMDAuOCU1RCklMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyQSUyMHNwYWNlJTIwcm9ja2V0JTIwd2l0aCUyMHRyYWlscyUyMG9mJTIwc21va2UlMjBiZWhpbmQlMjBpdCUyMGxhdW5jaGluZyUyMGludG8lMjBzcGFjZSUyMGZyb20lMjB0aGUlMjBkZXNlcnQlMkMlMjA0ayUyQyUyMGhpZ2glMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyYmFkJTIwcXVhbGl0eSUyQyUyMHdvcnNlJTIwcXVhbGl0eSUyQyUyMGxvdyUyMHJlc29sdXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q2JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMkMlMEEpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGVsY20tbW90aW9uLWxvcmEuZ2lmJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, LCMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>)
pipe = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>)

pipe.load_lora_weights(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>, weight_name=<span class="hljs-string">&quot;sd15_lora_beta.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm-lora&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-tilt-up&quot;</span>, adapter_name=<span class="hljs-string">&quot;tilt-up&quot;</span>)

pipe.set_adapters([<span class="hljs-string">&quot;lcm-lora&quot;</span>, <span class="hljs-string">&quot;tilt-up&quot;</span>], [<span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>])
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=<span class="hljs-string">&quot;A space rocket with trails of smoke behind it launching into space from the desert, 4k, high resolution&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">1.5</span>,
    num_inference_steps=<span class="hljs-number">6</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animatelcm-motion-lora.gif&quot;</span>)`,wrap:!1}}),Be=new j({props:{title:"AnimateDiffPipeline",local:"diffusers.AnimateDiffPipeline",headingTag:"h2"}}),Ve=new Qe({props:{name:"class diffusers.AnimateDiffPipeline",anchor:"diffusers.AnimateDiffPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": Union"},{name:"motion_adapter",val:": MotionAdapter"},{name:"scheduler",val:": Union"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L89"}}),ke=new Qe({props:{name:"__call__",anchor:"diffusers.AnimateDiffPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"num_frames",val:": Optional = 16"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of IP-adapters.
Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding
if <code>do_classifier_free_guidance</code> is set to <code>True</code>.
If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code>, <code>PIL.Image</code> or
<code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L573",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> or <code>tuple</code></p>
`}}),E=new Ta({props:{anchor:"diffusers.AnimateDiffPipeline.__call__.example",$$slots:{default:[Ia]},$$scope:{ctx:W}}}),Ce=new Qe({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L165"}}),xe=new j({props:{title:"AnimateDiffVideoToVideoPipeline",local:"diffusers.AnimateDiffVideoToVideoPipeline",headingTag:"h2"}}),Ae=new Qe({props:{name:"class diffusers.AnimateDiffVideoToVideoPipeline",anchor:"diffusers.AnimateDiffVideoToVideoPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"motion_adapter",val:": MotionAdapter"},{name:"scheduler",val:": Union"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L167"}}),Xe=new Qe({props:{name:"__call__",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__",parameters:[{name:"video",val:": List = None"},{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": Optional = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"strength",val:": float = 0.8"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PipelineImageInput]</code>) &#x2014;
The input video to condition the generation on. Must be a list of images/frames of the video.`,name:"video"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Higher strength leads to more differences between original video and generated video.`,name:"strength"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of IP-adapters.
Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding
if <code>do_classifier_free_guidance</code> is set to <code>True</code>.
If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code>, <code>PIL.Image</code> or
<code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>AnimateDiffPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L732",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>pipelines.animatediff.pipeline_output.AnimateDiffPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>pipelines.animatediff.pipeline_output.AnimateDiffPipelineOutput</a> or <code>tuple</code></p>
`}}),Re=new Qe({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L243"}}),Ee=new j({props:{title:"AnimateDiffPipelineOutput",local:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",headingTag:"h2"}}),Fe=new Qe({props:{name:"class diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",anchor:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing denoised`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_output.py#L11"}}),{c(){p=l("meta"),U=i(),g=l("p"),w=i(),c(Z.$$.fragment),y=i(),c(I.$$.fragment),ot=i(),Q=l("p"),Q.innerHTML=Bn,rt=i(),N=l("p"),N.textContent=Vn,pt=i(),Y=l("p"),Y.innerHTML=kn,dt=i(),c(S.$$.fragment),ct=i(),$=l("table"),$.innerHTML=Cn,mt=i(),c(H.$$.fragment),ft=i(),P=l("p"),P.innerHTML=xn,ut=i(),c(q.$$.fragment),ht=i(),c(z.$$.fragment),Mt=i(),L=l("p"),L.textContent=An,gt=i(),K=l("p"),K.innerHTML=Xn,yt=i(),c(O.$$.fragment),bt=i(),ee=l("p"),ee.textContent=Rn,_t=i(),te=l("table"),te.innerHTML=En,wt=i(),c(A.$$.fragment),Jt=i(),c(ne.$$.fragment),Tt=i(),ae=l("p"),ae.textContent=Fn,Ut=i(),c(ie.$$.fragment),jt=i(),se=l("p"),se.textContent=Dn,Zt=i(),le=l("table"),le.innerHTML=Qn,It=i(),c(oe.$$.fragment),vt=i(),re=l("p"),re.innerHTML=Nn,Wt=i(),c(pe.$$.fragment),Gt=i(),de=l("table"),de.innerHTML=Yn,Bt=i(),c(ce.$$.fragment),Vt=i(),me=l("p"),me.innerHTML=Sn,kt=i(),fe=l("p"),fe.textContent=$n,Ct=i(),c(ue.$$.fragment),xt=i(),he=l("p"),he.textContent=Hn,At=i(),c(Me.$$.fragment),Xt=i(),ge=l("table"),ge.innerHTML=Pn,Rt=i(),c(ye.$$.fragment),Et=i(),be=l("p"),be.innerHTML=qn,Ft=i(),_e=l("p"),_e.textContent=zn,Dt=i(),we=l("p"),we.textContent=Ln,Qt=i(),c(Je.$$.fragment),Nt=i(),c(X.$$.fragment),Yt=i(),c(R.$$.fragment),St=i(),Te=l("table"),Te.innerHTML=Kn,$t=i(),c(Ue.$$.fragment),Ht=i(),je=l("p"),je.innerHTML=On,Pt=i(),c(Ze.$$.fragment),qt=i(),Ie=l("table"),Ie.innerHTML=ea,zt=i(),ve=l("p"),ve.innerHTML=ta,Lt=i(),c(We.$$.fragment),Kt=i(),Ge=l("table"),Ge.innerHTML=na,Ot=i(),c(Be.$$.fragment),en=i(),b=l("div"),c(Ve.$$.fragment),dn=i(),Ne=l("p"),Ne.textContent=aa,cn=i(),Ye=l("p"),Ye.innerHTML=ia,mn=i(),Se=l("p"),Se.textContent=sa,fn=i(),$e=l("ul"),$e.innerHTML=la,un=i(),G=l("div"),c(ke.$$.fragment),hn=i(),He=l("p"),He.textContent=oa,Mn=i(),c(E.$$.fragment),gn=i(),F=l("div"),c(Ce.$$.fragment),yn=i(),Pe=l("p"),Pe.textContent=ra,tn=i(),c(xe.$$.fragment),nn=i(),_=l("div"),c(Ae.$$.fragment),bn=i(),qe=l("p"),qe.textContent=pa,_n=i(),ze=l("p"),ze.innerHTML=da,wn=i(),Le=l("p"),Le.textContent=ca,Jn=i(),Ke=l("ul"),Ke.innerHTML=ma,Tn=i(),B=l("div"),c(Xe.$$.fragment),Un=i(),Oe=l("p"),Oe.textContent=fa,jn=i(),et=l("p"),et.textContent=ua,Zn=i(),D=l("div"),c(Re.$$.fragment),In=i(),tt=l("p"),tt.textContent=ha,an=i(),c(Ee.$$.fragment),sn=i(),v=l("div"),c(Fe.$$.fragment),vn=i(),nt=l("p"),nt.textContent=Ma,Wn=i(),at=l("p"),at.innerHTML=ga,ln=i(),lt=l("p"),this.h()},l(e){const t=Ja("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(n),U=s(e),g=o(e,"P",{}),k(g).forEach(n),w=s(e),m(Z.$$.fragment,e),y=s(e),m(I.$$.fragment,e),ot=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1heixsu"&&(Q.innerHTML=Bn),rt=s(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-wu27l3"&&(N.textContent=Vn),pt=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-17654bv"&&(Y.innerHTML=kn),dt=s(e),m(S.$$.fragment,e),ct=s(e),$=o(e,"TABLE",{"data-svelte-h":!0}),r($)!=="svelte-2pawus"&&($.innerHTML=Cn),mt=s(e),m(H.$$.fragment,e),ft=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1eu5pwh"&&(P.innerHTML=xn),ut=s(e),m(q.$$.fragment,e),ht=s(e),m(z.$$.fragment,e),Mt=s(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-q9bvzo"&&(L.textContent=An),gt=s(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-o3l8n4"&&(K.innerHTML=Xn),yt=s(e),m(O.$$.fragment,e),bt=s(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1pxzje"&&(ee.textContent=Rn),_t=s(e),te=o(e,"TABLE",{"data-svelte-h":!0}),r(te)!=="svelte-5250wa"&&(te.innerHTML=En),wt=s(e),m(A.$$.fragment,e),Jt=s(e),m(ne.$$.fragment,e),Tt=s(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-v5wx3"&&(ae.textContent=Fn),Ut=s(e),m(ie.$$.fragment,e),jt=s(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1pxzje"&&(se.textContent=Dn),Zt=s(e),le=o(e,"TABLE",{"data-svelte-h":!0}),r(le)!=="svelte-1hj8351"&&(le.innerHTML=Qn),It=s(e),m(oe.$$.fragment,e),vt=s(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-u1dwwg"&&(re.innerHTML=Nn),Wt=s(e),m(pe.$$.fragment,e),Gt=s(e),de=o(e,"TABLE",{"data-svelte-h":!0}),r(de)!=="svelte-16prig"&&(de.innerHTML=Yn),Bt=s(e),m(ce.$$.fragment,e),Vt=s(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1gecok3"&&(me.innerHTML=Sn),kt=s(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-26fcye"&&(fe.textContent=$n),Ct=s(e),m(ue.$$.fragment,e),xt=s(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1e37vkb"&&(he.textContent=Hn),At=s(e),m(Me.$$.fragment,e),Xt=s(e),ge=o(e,"TABLE",{"data-svelte-h":!0}),r(ge)!=="svelte-3p6096"&&(ge.innerHTML=Pn),Rt=s(e),m(ye.$$.fragment,e),Et=s(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-a52po1"&&(be.innerHTML=qn),Ft=s(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-i9hpov"&&(_e.textContent=zn),Dt=s(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1qq4ux4"&&(we.textContent=Ln),Qt=s(e),m(Je.$$.fragment,e),Nt=s(e),m(X.$$.fragment,e),Yt=s(e),m(R.$$.fragment,e),St=s(e),Te=o(e,"TABLE",{"data-svelte-h":!0}),r(Te)!=="svelte-178x3s7"&&(Te.innerHTML=Kn),$t=s(e),m(Ue.$$.fragment,e),Ht=s(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-10musd5"&&(je.innerHTML=On),Pt=s(e),m(Ze.$$.fragment,e),qt=s(e),Ie=o(e,"TABLE",{"data-svelte-h":!0}),r(Ie)!=="svelte-1rjpilt"&&(Ie.innerHTML=ea),zt=s(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1q8gfh6"&&(ve.innerHTML=ta),Lt=s(e),m(We.$$.fragment,e),Kt=s(e),Ge=o(e,"TABLE",{"data-svelte-h":!0}),r(Ge)!=="svelte-17fpusd"&&(Ge.innerHTML=na),Ot=s(e),m(Be.$$.fragment,e),en=s(e),b=o(e,"DIV",{class:!0});var J=k(b);m(Ve.$$.fragment,J),dn=s(J),Ne=o(J,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-19ipoo4"&&(Ne.textContent=aa),cn=s(J),Ye=o(J,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-496sm0"&&(Ye.innerHTML=ia),mn=s(J),Se=o(J,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-14s6m4u"&&(Se.textContent=sa),fn=s(J),$e=o(J,"UL",{"data-svelte-h":!0}),r($e)!=="svelte-12zn0nk"&&($e.innerHTML=la),un=s(J),G=o(J,"DIV",{class:!0});var V=k(G);m(ke.$$.fragment,V),hn=s(V),He=o(V,"P",{"data-svelte-h":!0}),r(He)!=="svelte-50j04k"&&(He.textContent=oa),Mn=s(V),m(E.$$.fragment,V),V.forEach(n),gn=s(J),F=o(J,"DIV",{class:!0});var De=k(F);m(Ce.$$.fragment,De),yn=s(De),Pe=o(De,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-16q0ax1"&&(Pe.textContent=ra),De.forEach(n),J.forEach(n),tn=s(e),m(xe.$$.fragment,e),nn=s(e),_=o(e,"DIV",{class:!0});var T=k(_);m(Ae.$$.fragment,T),bn=s(T),qe=o(T,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-19djzsa"&&(qe.textContent=pa),_n=s(T),ze=o(T,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-496sm0"&&(ze.innerHTML=da),wn=s(T),Le=o(T,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-14s6m4u"&&(Le.textContent=ca),Jn=s(T),Ke=o(T,"UL",{"data-svelte-h":!0}),r(Ke)!=="svelte-12zn0nk"&&(Ke.innerHTML=ma),Tn=s(T),B=o(T,"DIV",{class:!0});var it=k(B);m(Xe.$$.fragment,it),Un=s(it),Oe=o(it,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-50j04k"&&(Oe.textContent=fa),jn=s(it),et=o(it,"P",{"data-svelte-h":!0}),r(et)!=="svelte-kvfsh7"&&(et.textContent=ua),it.forEach(n),Zn=s(T),D=o(T,"DIV",{class:!0});var rn=k(D);m(Re.$$.fragment,rn),In=s(rn),tt=o(rn,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-16q0ax1"&&(tt.textContent=ha),rn.forEach(n),T.forEach(n),an=s(e),m(Ee.$$.fragment,e),sn=s(e),v=o(e,"DIV",{class:!0});var st=k(v);m(Fe.$$.fragment,st),vn=s(st),nt=o(st,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-8gpkil"&&(nt.textContent=Ma),Wn=s(st),at=o(st,"P",{"data-svelte-h":!0}),r(at)!=="svelte-gk6g69"&&(at.innerHTML=ga),st.forEach(n),ln=s(e),lt=o(e,"P",{}),k(lt).forEach(n),this.h()},h(){C(p,"name","hf:doc:metadata"),C(p,"content",Wa),C(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,p),a(e,U,t),a(e,g,t),a(e,w,t),f(Z,e,t),a(e,y,t),f(I,e,t),a(e,ot,t),a(e,Q,t),a(e,rt,t),a(e,N,t),a(e,pt,t),a(e,Y,t),a(e,dt,t),f(S,e,t),a(e,ct,t),a(e,$,t),a(e,mt,t),f(H,e,t),a(e,ft,t),a(e,P,t),a(e,ut,t),f(q,e,t),a(e,ht,t),f(z,e,t),a(e,Mt,t),a(e,L,t),a(e,gt,t),a(e,K,t),a(e,yt,t),f(O,e,t),a(e,bt,t),a(e,ee,t),a(e,_t,t),a(e,te,t),a(e,wt,t),f(A,e,t),a(e,Jt,t),f(ne,e,t),a(e,Tt,t),a(e,ae,t),a(e,Ut,t),f(ie,e,t),a(e,jt,t),a(e,se,t),a(e,Zt,t),a(e,le,t),a(e,It,t),f(oe,e,t),a(e,vt,t),a(e,re,t),a(e,Wt,t),f(pe,e,t),a(e,Gt,t),a(e,de,t),a(e,Bt,t),f(ce,e,t),a(e,Vt,t),a(e,me,t),a(e,kt,t),a(e,fe,t),a(e,Ct,t),f(ue,e,t),a(e,xt,t),a(e,he,t),a(e,At,t),f(Me,e,t),a(e,Xt,t),a(e,ge,t),a(e,Rt,t),f(ye,e,t),a(e,Et,t),a(e,be,t),a(e,Ft,t),a(e,_e,t),a(e,Dt,t),a(e,we,t),a(e,Qt,t),f(Je,e,t),a(e,Nt,t),f(X,e,t),a(e,Yt,t),f(R,e,t),a(e,St,t),a(e,Te,t),a(e,$t,t),f(Ue,e,t),a(e,Ht,t),a(e,je,t),a(e,Pt,t),f(Ze,e,t),a(e,qt,t),a(e,Ie,t),a(e,zt,t),a(e,ve,t),a(e,Lt,t),f(We,e,t),a(e,Kt,t),a(e,Ge,t),a(e,Ot,t),f(Be,e,t),a(e,en,t),a(e,b,t),f(Ve,b,null),d(b,dn),d(b,Ne),d(b,cn),d(b,Ye),d(b,mn),d(b,Se),d(b,fn),d(b,$e),d(b,un),d(b,G),f(ke,G,null),d(G,hn),d(G,He),d(G,Mn),f(E,G,null),d(b,gn),d(b,F),f(Ce,F,null),d(F,yn),d(F,Pe),a(e,tn,t),f(xe,e,t),a(e,nn,t),a(e,_,t),f(Ae,_,null),d(_,bn),d(_,qe),d(_,_n),d(_,ze),d(_,wn),d(_,Le),d(_,Jn),d(_,Ke),d(_,Tn),d(_,B),f(Xe,B,null),d(B,Un),d(B,Oe),d(B,jn),d(B,et),d(_,Zn),d(_,D),f(Re,D,null),d(D,In),d(D,tt),a(e,an,t),f(Ee,e,t),a(e,sn,t),a(e,v,t),f(Fe,v,null),d(v,vn),d(v,nt),d(v,Wn),d(v,at),a(e,ln,t),a(e,lt,t),on=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),A.$set(J);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),X.$set(V);const De={};t&2&&(De.$$scope={dirty:t,ctx:e}),R.$set(De);const T={};t&2&&(T.$$scope={dirty:t,ctx:e}),E.$set(T)},i(e){on||(u(Z.$$.fragment,e),u(I.$$.fragment,e),u(S.$$.fragment,e),u(H.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(O.$$.fragment,e),u(A.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(Je.$$.fragment,e),u(X.$$.fragment,e),u(R.$$.fragment,e),u(Ue.$$.fragment,e),u(Ze.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u(Ve.$$.fragment,e),u(ke.$$.fragment,e),u(E.$$.fragment,e),u(Ce.$$.fragment,e),u(xe.$$.fragment,e),u(Ae.$$.fragment,e),u(Xe.$$.fragment,e),u(Re.$$.fragment,e),u(Ee.$$.fragment,e),u(Fe.$$.fragment,e),on=!0)},o(e){h(Z.$$.fragment,e),h(I.$$.fragment,e),h(S.$$.fragment,e),h(H.$$.fragment,e),h(q.$$.fragment,e),h(z.$$.fragment,e),h(O.$$.fragment,e),h(A.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(Je.$$.fragment,e),h(X.$$.fragment,e),h(R.$$.fragment,e),h(Ue.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(ke.$$.fragment,e),h(E.$$.fragment,e),h(Ce.$$.fragment,e),h(xe.$$.fragment,e),h(Ae.$$.fragment,e),h(Xe.$$.fragment,e),h(Re.$$.fragment,e),h(Ee.$$.fragment,e),h(Fe.$$.fragment,e),on=!1},d(e){e&&(n(U),n(g),n(w),n(y),n(ot),n(Q),n(rt),n(N),n(pt),n(Y),n(dt),n(ct),n($),n(mt),n(ft),n(P),n(ut),n(ht),n(Mt),n(L),n(gt),n(K),n(yt),n(bt),n(ee),n(_t),n(te),n(wt),n(Jt),n(Tt),n(ae),n(Ut),n(jt),n(se),n(Zt),n(le),n(It),n(vt),n(re),n(Wt),n(Gt),n(de),n(Bt),n(Vt),n(me),n(kt),n(fe),n(Ct),n(xt),n(he),n(At),n(Xt),n(ge),n(Rt),n(Et),n(be),n(Ft),n(_e),n(Dt),n(we),n(Qt),n(Nt),n(Yt),n(St),n(Te),n($t),n(Ht),n(je),n(Pt),n(qt),n(Ie),n(zt),n(ve),n(Lt),n(Kt),n(Ge),n(Ot),n(en),n(b),n(tn),n(nn),n(_),n(an),n(sn),n(v),n(ln),n(lt)),n(p),M(Z,e),M(I,e),M(S,e),M(H,e),M(q,e),M(z,e),M(O,e),M(A,e),M(ne,e),M(ie,e),M(oe,e),M(pe,e),M(ce,e),M(ue,e),M(Me,e),M(ye,e),M(Je,e),M(X,e),M(R,e),M(Ue,e),M(Ze,e),M(We,e),M(Be,e),M(Ve),M(ke),M(E),M(Ce),M(xe,e),M(Ae),M(Xe),M(Re),M(Ee,e),M(Fe)}}}const Wa='{"title":"Text-to-Video Generation with AnimateDiff","local":"text-to-video-generation-with-animatediff","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Available Pipelines","local":"available-pipelines","sections":[],"depth":2},{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"AnimateDiffPipeline","local":"animatediffpipeline","sections":[],"depth":3},{"title":"AnimateDiffVideoToVideoPipeline","local":"animatediffvideotovideopipeline","sections":[],"depth":3}],"depth":2},{"title":"Using Motion LoRAs","local":"using-motion-loras","sections":[],"depth":2},{"title":"Using Motion LoRAs with PEFT","local":"using-motion-loras-with-peft","sections":[],"depth":2},{"title":"Using FreeInit","local":"using-freeinit","sections":[],"depth":2},{"title":"Using AnimateLCM","local":"using-animatelcm","sections":[],"depth":2},{"title":"AnimateDiffPipeline","local":"diffusers.AnimateDiffPipeline","sections":[],"depth":2},{"title":"AnimateDiffVideoToVideoPipeline","local":"diffusers.AnimateDiffVideoToVideoPipeline","sections":[],"depth":2},{"title":"AnimateDiffPipelineOutput","local":"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput","sections":[],"depth":2}],"depth":1}';function Ga(W){return ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ra extends _a{constructor(p){super(),wa(this,p,Ga,va,ya,{})}}export{Ra as component};
