import{s as Mi,o as mi,n as fi}from"../chunks/scheduler.182ea377.js";import{S as yi,i as hi,g as a,s as n,r,A as Ji,h as p,f as s,c as i,j as ui,u as c,x as o,k as T,y as Ui,a as t,v as u,d,t as f,w as M}from"../chunks/index.abf12888.js";import{T as di}from"../chunks/Tip.230e2334.js";import{C as m}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ti}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as J}from"../chunks/Heading.16916d63.js";function wi(Bl){let y,U='💡 Skip to the <a href="#diffusionpipeline-explained">DiffusionPipeline explained</a> section if you are interested in learning in more detail about how the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class works.';return{c(){y=a("p"),y.innerHTML=U},l(h){y=p(h,"P",{"data-svelte-h":!0}),o(y)!=="svelte-164e214"&&(y.innerHTML=U)},m(h,w){t(h,y,w)},p:fi,d(h){h&&s(y)}}}function bi(Bl){let y,U="💡 When the checkpoints have identical model structures, but they were trained on different datasets and with a different training setup, they should be stored in separate repositories instead of variations (for example, <code>stable-diffusion-v1-4</code> and <code>stable-diffusion-v1-5</code>).";return{c(){y=a("p"),y.innerHTML=U},l(h){y=p(h,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1bx6mv6"&&(y.innerHTML=U)},m(h,w){t(h,y,w)},p:fi,d(h){h&&s(y)}}}function Zi(Bl){let y,U,h,w,_,Rl,G,Xl,B,qt='Having an easy way to use a diffusion system for inference is essential to 🧨 Diffusers. Diffusion systems often consist of multiple components like parameterized models, tokenizers, and schedulers that interact in complex ways. That is why we designed the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to wrap the complexity of the entire diffusion system into an easy-to-use API, while remaining flexible enough to be adapted for other use cases, such as loading each component individually as building blocks to assemble your own diffusion system.',Nl,k,Dt="Everything you need for inference or training is accessible with the <code>from_pretrained()</code> method.",$l,R,At="This guide will show you how to load:",Ql,X,Lt="<li>pipelines from the Hub and locally</li> <li>different components into a pipeline</li> <li>checkpoint variants such as different floating point types or non-exponential mean averaged (EMA) weights</li> <li>models and schedulers</li>",Yl,N,xl,b,El,$,Pt='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class is the simplest and most generic way to load the latest trending diffusion model from the <a href="https://huggingface.co/models?library=diffusers&amp;sort=trending" rel="nofollow">Hub</a>. The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> method automatically detects the correct pipeline class from the checkpoint, downloads, and caches all the required configuration and weight files, and returns a pipeline instance ready for inference.',Sl,Q,zl,Y,Ot='You can also load a checkpoint with its specific pipeline class. The example above loaded a Stable Diffusion model; to get the same result, use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> class:',Hl,x,Fl,E,Kt='A checkpoint (such as <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow"><code>CompVis/stable-diffusion-v1-4</code></a> or <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>) may also be used for more than one task, like text-to-image or image-to-image. To differentiate what task you want to use the checkpoint for, you have to load it directly with its corresponding task-specific pipeline class:',ql,S,Dl,z,en="You can use the Space below to gauge the memory requirements of a pipeline you want to load beforehand without downloading the pipeline checkpoints:",Al,Z,ln='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=light" width="850" height="1600"></iframe>',Ll,j,sn='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=dark" width="850" height="1600"></iframe>',Pl,H,Ol,F,tn='To load a diffusion pipeline locally, use <a href="https://git-lfs.github.com/" rel="nofollow"><code>git-lfs</code></a> to manually download the checkpoint (in this case, <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>) to your local disk. This creates a local folder, <code>./stable-diffusion-v1-5</code>, on your disk:',Kl,q,es,D,nn='Then pass the local path to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>:',ls,A,ss,L,an='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download any files from the Hub when it detects a local path, but this also means it won’t download and cache the latest changes to a checkpoint.',ts,P,ns,O,pn="You can customize the default components of any pipeline with another compatible component. Customization is important because:",is,K,on="<li>Changing the scheduler is important for exploring the trade-off between generation speed and quality.</li> <li>Different components of a model are typically trained independently and you can swap out a component with a better-performing one.</li> <li>During finetuning, usually only some components - like the UNet or text encoder - are trained.</li>",as,ee,rn="To find out which schedulers are compatible for customization, you can use the <code>compatibles</code> method:",ps,le,os,se,cn='Let’s use the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">SchedulerMixin.from_pretrained()</a> method to replace the default <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> with a more performant scheduler, <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a>. The <code>subfolder=&quot;scheduler&quot;</code> argument is required to load the scheduler configuration from the correct <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/scheduler" rel="nofollow">subfolder</a> of the pipeline repository.',rs,te,un='Then you can pass the new <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> instance to the <code>scheduler</code> argument in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',cs,ne,us,ie,ds,ae,dn='Diffusion models like Stable Diffusion can generate harmful content, which is why 🧨 Diffusers has a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> to check generated outputs against known hardcoded NSFW content. If you’d like to disable the safety checker for whatever reason, pass <code>None</code> to the <code>safety_checker</code> argument:',fs,pe,Ms,oe,ms,re,fn='You can also reuse the same components in multiple pipelines to avoid loading the weights into RAM twice. Use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.components">components</a> method to save the components:',ys,ce,hs,ue,Mn="Then you can pass the <code>components</code> to another pipeline without reloading the weights into RAM:",Js,de,Us,fe,mn="You can also pass the components individually to the pipeline if you want more flexibility over which components to reuse or disable. For example, to reuse the same components in the text-to-image pipeline, except for the safety checker and feature extractor, in the image-to-image pipeline:",Ts,Me,ws,me,bs,ye,yn='There are many diffuser pipelines that use the same pre-trained model as <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>, but they implement specific features to help you achieve better generation results. This guide will show you how to use the <code>from_pipe</code> API to create multiple pipelines without increasing memory usage. By using this approach, you can easily switch between pipelines to use different features.',Zs,he,hn='Let’s take an example where we first create a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and then reuse the already loaded model components to create a <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> to enhance generation quality.',js,Je,Jn="we will generate an image of a bear eating pizza using Stable Diffusion with the IP-Adapter",gs,Ue,Cs,Te,Un="let’s take a look at the image and also print out the memory used",Is,g,Tn='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_sd_0.png"/>',Vs,we,vs,be,Ws,Ze,wn="Now, we can use <code>from_pipe</code> to switch to the SAG pipeline.",_s,je,Gs,ge,bn="It already has IP-Adapter loaded so that you can pass the same bear image as <code>ip_adapter_image</code>",Bs,Ce,ks,Ie,Zn="You can see a pretty nice improvement in the output",Rs,C,jn='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_sag_1.png"/>',Xs,Ve,gn="Now we have both <code>stableDiffusionPipeline</code> and <code>StableDiffusionSAGPipeline</code> co-existing with the same loaded model components;  You can use them interchangeably without additional memory.",Ns,ve,$s,We,Qs,_e,Cn="Let’s unload the IP adapter from the SAG pipeline. It’s important to note that methods like <code>load_ip_adapter</code> and <code>unload_ip_adapter</code> modify the state of the model components. Therefore, when you use these methods on one pipeline, it will affect all other pipelines that share the same model components.",Ys,Ge,xs,Be,In="If you try to use the Stable Diffusion pipeline with IP adapter again, it will fail",Es,ke,Ss,Re,zs,Xe,Vn="Please note that the pipeline methods may not function properly on a new pipeline created using the <code>from_pipe</code> method. For instance, the <code>enable_model_cpu_offload</code> method installs hooks to the model components based on a unique offloading sequence for each pipeline. Therefore, if the models are executed in a different order in the new pipeline, the CPU offloading may not work correctly.",Hs,Ne,vn="To ensure proper functionality, we recommend re-applying the pipeline methods on the new pipeline created using the <code>from_pipe</code> method.",Fs,$e,Wn="You can also add or subtract model components when you create new pipelines. Let’s now create a AnimateDiff pipeline with an additional <code>MotionAdapter</code> module",qs,Qe,Ds,I,_n='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_animate_3.gif"/>',As,Ye,Gn="When creating multiple pipelines using the <code>from_pipe</code> method, it is important to note that the memory requirement will be determined by the pipeline with the highest memory usage. This means that regardless of the number of pipelines you create, the total memory requirement will always be the same as the highest memory requirement among the pipelines.",Ls,xe,Bn="For example, we have created three pipelines - <code>stableDiffusionPipeline</code>, <code>StableDiffusionSAGPipeline</code>, and <code>AnimateDiffPipeline</code> - and the <code>AnimateDiffPipeline</code> has the highest memory requirement, then the total memory usage will be based on the memory requirement of the <code>AnimateDiffPipeline</code>.",Ps,Ee,kn="Therefore, creating additional pipelines will not add up to the total memory requirement. Each pipeline can be used interchangeably without any additional memory overhead.",Os,Se,Rn="Did you know that you can use <code>from_pipe</code> with a community pipeline? Let me show you an example of using long negative prompt and prompt weighting!",Ks,ze,et,V,Xn='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_lpw_4.png"/>',lt,He,Nn="let’s run StableDiffusionPipeline with the same inputs to compare:  the result from the long prompt weighting pipeline is more aligned with the text prompt.",st,Fe,tt,v,$n='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_sd_5.png"/>',nt,qe,Qn='You can easily switch between different pipelines using the <code>from_pipe</code> method, similar to turning on and off a feature on your pipeline. To switch between tasks, you can use the <code>from_pipe</code> method with <code>AutoPipeline</code>, which automatically identifies the pipeline class based on the task. You can find more information about this feature at the <a href="https://huggingface.co/docs/diffusers/tutorials/autopipeline" rel="nofollow">AutoPipe Guide</a>.',it,De,at,Ae,Yn="A checkpoint variant is usually a checkpoint whose weights are:",pt,Le,xn='<li>Stored in a different floating point type for lower precision and lower storage, such as <a href="https://pytorch.org/docs/stable/tensors.html#data-types" rel="nofollow"><code>torch.float16</code></a>, because it only requires half the bandwidth and storage to download. You can’t use this variant if you’re continuing training or using a CPU.</li> <li>Non-exponential mean averaged (EMA) weights, which shouldn’t be used for inference. You should use these to continue fine-tuning a model.</li>',ot,W,rt,Pe,En='Otherwise, a variant is <strong>identical</strong> to the original checkpoint. They have exactly the same serialization format (like <a href="./using_safetensors">Safetensors</a>), model structure, and weights that have identical tensor shapes.',ct,Oe,Sn="<thead><tr><th><strong>checkpoint type</strong></th> <th><strong>weight name</strong></th> <th><strong>argument for loading weights</strong></th></tr></thead> <tbody><tr><td>original</td> <td>diffusion_pytorch_model.bin</td> <td></td></tr> <tr><td>floating point</td> <td>diffusion_pytorch_model.fp16.bin</td> <td><code>variant</code>, <code>torch_dtype</code></td></tr> <tr><td>non-EMA</td> <td>diffusion_pytorch_model.non_ema.bin</td> <td><code>variant</code></td></tr></tbody>",ut,Ke,zn="There are two important arguments to know for loading variants:",dt,el,Hn='<li><p><code>torch_dtype</code> defines the floating point precision of the loaded checkpoints. For example, if you want to save bandwidth by loading a <code>fp16</code> variant, you should specify <code>torch_dtype=torch.float16</code> to <em>convert the weights</em> to <code>fp16</code>. Otherwise, the <code>fp16</code> weights are converted to the default <code>fp32</code> precision. You can also load the original checkpoint without defining the <code>variant</code> argument, and convert it to <code>fp16</code> with <code>torch_dtype=torch.float16</code>. In this case, the default <code>fp32</code> weights are downloaded first, and then they’re converted to <code>fp16</code> after loading.</p></li> <li><p><code>variant</code> defines which files should be loaded from the repository. For example, if you want to load a <code>non_ema</code> variant from the <a href="https://huggingface.co/diffusers/stable-diffusion-variants/tree/main/unet" rel="nofollow"><code>diffusers/stable-diffusion-variants</code></a> repository, you should specify <code>variant=&quot;non_ema&quot;</code> to download the <code>non_ema</code> files.</p></li>',ft,ll,Mt,sl,Fn='To save a checkpoint stored in a different floating-point type or as a non-EMA variant, use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">DiffusionPipeline.save_pretrained()</a> method and specify the <code>variant</code> argument. You should try and save a variant to the same folder as the original checkpoint, so you can load both from the same folder:',mt,tl,yt,nl,qn="If you don’t save the variant to an existing folder, you must specify the <code>variant</code> argument otherwise it’ll throw an <code>Exception</code> because it can’t find the original checkpoint:",ht,il,Jt,al,Ut,pl,Dn='Models are loaded from the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">ModelMixin.from_pretrained()</a> method, which downloads and caches the latest version of the model weights and configurations. If the latest files are available in the local cache, <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> reuses files in the cache instead of re-downloading them.',Tt,ol,An='Models can be loaded from a subfolder with the <code>subfolder</code> argument. For example, the model weights for <code>runwayml/stable-diffusion-v1-5</code> are stored in the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/unet" rel="nofollow"><code>unet</code></a> subfolder:',wt,rl,bt,cl,Ln='Or directly from a repository’s <a href="https://huggingface.co/google/ddpm-cifar10-32/tree/main" rel="nofollow">directory</a>:',Zt,ul,jt,dl,Pn='You can also load and save model variants by specifying the <code>variant</code> argument in <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">ModelMixin.from_pretrained()</a> and <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>:',gt,fl,Ct,Ml,It,ml,On='Schedulers are loaded from the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">SchedulerMixin.from_pretrained()</a> method, and unlike models, schedulers are <strong>not parameterized</strong> or <strong>trained</strong>; they are defined by a configuration file.',Vt,yl,Kn=`Loading schedulers does not consume any significant amount of memory and the same configuration file can be used for a variety of different schedulers.
For example, the following schedulers are compatible with <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which means you can load the same scheduler configuration file in any of these classes:`,vt,hl,Wt,Jl,_t,Ul,ei='As a class method, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> is responsible for two things:',Gt,Tl,li='<li>Download the latest version of the folder structure required for inference and cache it. If the latest folder structure is available in the local cache, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> reuses the cache and won’t redownload the files.</li> <li>Load the cached weights into the correct pipeline <a href="../api/pipelines/overview#diffusers-summary">class</a> - retrieved from the <code>model_index.json</code> file - and return an instance of it.</li>',Bt,wl,si='The pipelines’ underlying folder structure corresponds directly with their class instances. For example, the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> corresponds to the folder structure in <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>.',kt,bl,Rt,Zl,ti='You’ll see pipeline is an instance of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which consists of seven components:',Xt,jl,ni='<li><code>&quot;feature_extractor&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> from 🤗 Transformers.</li> <li><code>&quot;safety_checker&quot;</code>: a <a href="https://github.com/huggingface/diffusers/blob/e55687e1e15407f60f32242027b7bb8170e58266/src/diffusers/pipelines/stable_diffusion/safety_checker.py#L32" rel="nofollow">component</a> for screening against harmful content.</li> <li><code>&quot;scheduler&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.</li> <li><code>&quot;text_encoder&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> from 🤗 Transformers.</li> <li><code>&quot;tokenizer&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> from 🤗 Transformers.</li> <li><code>&quot;unet&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>.</li> <li><code>&quot;vae&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.</li>',Nt,gl,$t,Cl,ii='Compare the components of the pipeline instance to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> folder structure, and you’ll see there is a separate folder for each of the components in the repository:',Qt,Il,Yt,Vl,ai="You can access each of the components of the pipeline as an attribute to view its configuration:",xt,vl,Et,Wl,pi='Every pipeline expects a <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> file that tells the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',St,_l,oi="<li>which pipeline class to load from <code>_class_name</code></li> <li>which version of 🧨 Diffusers was used to create the model in <code>_diffusers_version</code></li> <li>what components from which library are stored in the subfolders (<code>name</code> corresponds to the component and subfolder name, <code>library</code> corresponds to the name of the library to load the class from, and <code>class</code> corresponds to the class name)</li>",zt,Gl,Ht,kl,Ft;return _=new J({props:{title:"Load pipelines, models, and schedulers",local:"load-pipelines-models-and-schedulers",headingTag:"h1"}}),G=new Ti({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),N=new J({props:{title:"Diffusion Pipeline",local:"diffusion-pipeline",headingTag:"h2"}}),b=new di({props:{$$slots:{default:[wi]},$$scope:{ctx:Bl}}}),Q=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),x=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),S=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionImg2ImgPipeline.from_pretrained(repo_id)`,wrap:!1}}),H=new J({props:{title:"Local pipeline",local:"local-pipeline",headingTag:"h3"}}),q=new m({props:{code:"Z2l0LWxmcyUyMGluc3RhbGwlMEFnaXQlMjBjbG9uZSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNQ==",highlighted:`git-lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/runwayml/stable-diffusion-v1-5`,wrap:!1}}),A=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),P=new J({props:{title:"Swap components in a pipeline",local:"swap-components-in-a-pipeline",headingTag:"h3"}}),le=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFzdGFibGVfZGlmZnVzaW9uLnNjaGVkdWxlci5jb21wYXRpYmxlcw==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
stable_diffusion.scheduler.compatibles`,wrap:!1}}),ne=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlciUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXNjaGVkdWxlciUyMCUzRCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, EulerDiscreteScheduler

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
scheduler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, scheduler=scheduler, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),ie=new J({props:{title:"Safety checker",local:"safety-checker",headingTag:"h3"}}),pe=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEElMjIlMjIlMjIlMEFZb3UlMjBoYXZlJTIwZGlzYWJsZWQlMjB0aGUlMjBzYWZldHklMjBjaGVja2VyJTIwZm9yJTIwJTNDY2xhc3MlMjAnZGlmZnVzZXJzLnBpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uLnBpcGVsaW5lX3N0YWJsZV9kaWZmdXNpb24uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUnJTNFJTIwYnklMjBwYXNzaW5nJTIwJTYwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTYwLiUyMEVuc3VyZSUyMHRoYXQlMjB5b3UlMjBhYmlkZSUyMGJ5JTIwdGhlJTIwY29uZGl0aW9ucyUyMG9mJTIwdGhlJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTIwbGljZW5zZSUyMGFuZCUyMGRvJTIwbm90JTIwZXhwb3NlJTIwdW5maWx0ZXJlZCUyMHJlc3VsdHMlMjBpbiUyMHNlcnZpY2VzJTIwb3IlMjBhcHBsaWNhdGlvbnMlMjBvcGVuJTIwdG8lMjB0aGUlMjBwdWJsaWMuJTIwQm90aCUyMHRoZSUyMGRpZmZ1c2VycyUyMHRlYW0lMjBhbmQlMjBIdWdnaW5nJTIwRmFjZSUyMHN0cm9uZ2x5JTIwcmVjb21tZW5kJTIwa2VlcGluZyUyMHRoZSUyMHNhZmV0eSUyMGZpbHRlciUyMGVuYWJsZWQlMjBpbiUyMGFsbCUyMHB1YmxpYy1mYWNpbmclMjBjaXJjdW1zdGFuY2VzJTJDJTIwZGlzYWJsaW5nJTIwaXQlMjBvbmx5JTIwZm9yJTIwdXNlJTIwY2FzZXMlMjB0aGF0JTIwaW52b2x2ZSUyMGFuYWx5emluZyUyMG5ldHdvcmslMjBiZWhhdmlvciUyMG9yJTIwYXVkaXRpbmclMjBpdHMlMjByZXN1bHRzLiUyMEZvciUyMG1vcmUlMjBpbmZvcm1hdGlvbiUyQyUyMHBsZWFzZSUyMGhhdmUlMjBhJTIwbG9vayUyMGF0JTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNlcnMlMkZwdWxsJTJGMjU0JTIwLiUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, safety_checker=<span class="hljs-literal">None</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;
You have disabled the safety checker for &lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt; by passing \`safety_checker=None\`. Ensure that you abide by the conditions of the Stable Diffusion license and do not expose unfiltered results in services or applications open to the public. Both the diffusers team and Hugging Face strongly recommend keeping the safety filter enabled in all public-facing circumstances, disabling it only for use cases that involve analyzing network behavior or auditing its results. For more information, please have a look at https://github.com/huggingface/diffusers/pull/254 .
&quot;&quot;&quot;</span>`,wrap:!1}}),oe=new J({props:{title:"Reuse components across pipelines",local:"reuse-components-across-pipelines",headingTag:"h3"}}),ce=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBJTBBY29tcG9uZW50cyUyMCUzRCUyMHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5jb21wb25lbnRz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)

components = stable_diffusion_txt2img.components`,wrap:!1}}),de=new m({props:{code:"c3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqY29tcG9uZW50cyk=",highlighted:"stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(**components)",wrap:!1}}),Me=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBc3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHZhZSUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy52YWUlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEc3RhYmxlX2RpZmZ1c2lvbl90eHQyaW1nLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHVuZXQlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudW5ldCUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5zY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBzYWZldHlfY2hlY2tlciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBmZWF0dXJlX2V4dHJhY3RvciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjByZXF1aXJlc19zYWZldHlfY2hlY2tlciUzREZhbHNlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)
stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(
    vae=stable_diffusion_txt2img.vae,
    text_encoder=stable_diffusion_txt2img.text_encoder,
    tokenizer=stable_diffusion_txt2img.tokenizer,
    unet=stable_diffusion_txt2img.unet,
    scheduler=stable_diffusion_txt2img.scheduler,
    safety_checker=<span class="hljs-literal">None</span>,
    feature_extractor=<span class="hljs-literal">None</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),me=new J({props:{title:"Switch loaded pippelines",local:"switch-loaded-pippelines",headingTag:"h3"}}),Ue=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMGdjJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMGNvbXB1dGVfbW9kdWxlX3NpemVzJTBBJTBBYmFzZV9yZXBvJTIwJTNEJTIwJTIyU0cxNjEyMjIlMkZSZWFsaXN0aWNfVmlzaW9uX1Y2LjBfQjFfbm9WQUUlMjIlMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwNTAlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGbG9hZF9uZWdfZW1iZWQucG5nJTIyKSUwQXByb21wdCUzRCUyMmJlYXIlMjBlYXRzJTIwcGl6emElMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJ3cm9uZyUyMHdoaXRlJTIwYmFsYW5jZSUyQyUyMGRhcmslMkMlMjBza2V0Y2hlcyUyQ3dvcnN0JTIwcXVhbGl0eSUyQ2xvdyUyMHF1YWxpdHklMjIlMEElMEFwaXBlX3NkJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKGJhc2VfcmVwbyUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlX3NkLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVfc2Quc2V0X2lwX2FkYXB0ZXJfc2NhbGUoMC42KSUwQXBpcGVfc2QudG8oJTIyY3VkYSUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgzMyklMEFvdXRfc2QlMjAlM0QlMjBwaXBlX3NkKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, StableDiffusionSAGPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gc
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> compute_module_sizes

base_repo = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>
num_inference_steps = <span class="hljs-number">50</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/load_neg_embed.png&quot;</span>)
prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>
negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>

pipe_sd = DiffusionPipeline.from_pretrained(base_repo, torch_dtype=torch.float16)
pipe_sd.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipe_sd.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)
pipe_sd.to(<span class="hljs-string">&quot;cuda&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sd = pipe_sd(
    prompt=prompt,
    negative_prompt=negative_prompt, 
    ip_adapter_image=image,
    num_inference_steps=num_inference_steps,
    generator=generator,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),we=new m({props:{code:"ZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJNYXglMjBtZW1vcnklMjBhbGxvY2F0ZWQlM0ElMjAlN0JieXRlc190b19naWdhX2J5dGVzKHRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSklN0QlMjBHQiUyMiUwQSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">bytes_to_giga_bytes</span>(<span class="hljs-params"><span class="hljs-built_in">bytes</span></span>):
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">bytes</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span>
<span class="hljs-built_in">print</span>(
    <span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>
)`,wrap:!1}}),be=new m({props:{code:"TWF4JTIwbWVtb3J5JTIwYWxsb2NhdGVkJTNBJTIwNC40MDYyMTMyODM1Mzg4MTglMjBHQg==",highlighted:"Max memory allocated: 4.406213283538818 GB",wrap:!1}}),je=new m({props:{code:"cGlwZV9zYWclMjAlM0QlMjBTdGFibGVEaWZmdXNpb25TQUdQaXBlbGluZS5mcm9tX3BpcGUoJTBBJTIwJTIwJTIwJTIwcGlwZV9zZCUyQyUwQSk=",highlighted:`pipe_sag = StableDiffusionSAGPipeline.from_pipe(
    pipe_sd,
)`,wrap:!1}}),Ce=new m({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBb3V0X3NhZyUyMCUzRCUyMHBpcGVfc2FnKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMHByb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjAlMkMlMEElMjAlMjAlMjAlMjBzYWdfc2NhbGUlM0QwLjc1KS5pbWFnZXMlNUIwJTVE",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sag = pipe_sag(
    prompt = prompt, 
    negative_prompt=negative_prompt, 
    ip_adapter_image=image,
    num_inference_steps=num_inference_steps,
    generator=generator,
    guidance_scale=<span class="hljs-number">1.0</span>,
    sag_scale=<span class="hljs-number">0.75</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ve=new m({props:{code:"cHJpbnQoJTBBJTIwJTIwJTIwJTIwZiUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMCU3QmJ5dGVzX3RvX2dpZ2FfYnl0ZXModG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpKSU3RCUyMEdCJTIyJTBBKQ==",highlighted:`<span class="hljs-function"><span class="hljs-title">print</span>(
    <span class="hljs-variable">f</span><span class="hljs-string">&quot;Max memory allocated: {bytes_to_giga_bytes(torch.cuda.max_memory_allocated())} GB&quot;</span>
)</span>`,wrap:!1}}),We=new m({props:{code:"TWF4JTIwbWVtb3J5JTIwYWxsb2NhdGVkJTNBJTIwNC40MDYyMTMyODM1Mzg4MTglMjBHQg==",highlighted:"Max memory allocated: 4.406213283538818 GB",wrap:!1}}),Ge=new m({props:{code:"cGlwZV9zYWcudW5sb2FkX2lwX2FkYXB0ZXIoKQ==",highlighted:"pipe_sag.unload_ip_adapter()",wrap:!1}}),ke=new m({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBb3V0X3NkJTIwJTNEJTIwcGlwZV9zZCglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMjAlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEbnVtX2luZmVyZW5jZV9zdGVwcyUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(33)
out_sd = pipe_sd(
    prompt=prompt,
    negative_prompt=negative_prompt, 
    ip_adapter_image=image,
    num_inference_steps=num_inference_steps,
    generator=generator,
).images[0]`,wrap:!1}}),Re=new m({props:{code:"QXR0cmlidXRlRXJyb3IlM0ElMjAnTm9uZVR5cGUnJTIwb2JqZWN0JTIwaGFzJTIwbm8lMjBhdHRyaWJ1dGUlMjAnaW1hZ2VfcHJvamVjdGlvbl9sYXllcnMn",highlighted:'AttributeError: <span class="hljs-string">&#x27;NoneType&#x27;</span> object has no attribute <span class="hljs-string">&#x27;image_projection_layers&#x27;</span>',wrap:!1}}),Qe=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBNb3Rpb25BZGFwdGVyJTJDJTIwRERJTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fZ2lmJTBBJTBBYWRhcHRlciUyMCUzRCUyME1vdGlvbkFkYXB0ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmd1b3l3dyUyRmFuaW1hdGVkaWZmLW1vdGlvbi1hZGFwdGVyLXYxLTUtMiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMEFwaXBlX2FuaW1hdGUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcGlwZShwaXBlX3NkJTJDJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyKSUwQXBpcGVfYW5pbWF0ZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVfYW5pbWF0ZS5zY2hlZHVsZXIuY29uZmlnJTJDJTIwYmV0YV9zY2hlZHVsZSUzRCUyMmxpbmVhciUyMiklMEElMjMlMjBsb2FkJTIwaXBfYWRhcHRlciUyMGFnYWluJTIwYW5kJTIwbG9hZCUyMGxvcmElMjB3ZWlnaHRzJTBBcGlwZV9hbmltYXRlLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVfYW5pbWF0ZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tbG9yYS16b29tLW91dCUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnpvb20tb3V0JTIyKSUwQXBpcGVfYW5pbWF0ZS50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQXBpcGVfYW5pbWF0ZS5zZXRfYWRhcHRlcnMoJTIyem9vbS1vdXQlMjIlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QwLjc1KSUwQW91dCUyMCUzRCUyMHBpcGVfYW5pbWF0ZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEbnVtX2luZmVyZW5jZV9zdGVwcyUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlMjAlM0QlMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b19naWYob3V0JTJDJTIwJTIyb3V0X2FuaW1hdGUuZ2lmJTIyKQ==",highlighted:`from diffusers import AnimateDiffPipeline, MotionAdapter, DDIMScheduler
from diffusers.utils import export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)

pipe_animate = AnimateDiffPipeline.from_pipe(pipe_sd, motion_adapter=adapter)
pipe_animate.scheduler = DDIMScheduler.from_config(pipe_animate.scheduler.config, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>)
<span class="hljs-comment"># load ip_adapter again and load lora weights</span>
pipe_animate.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipe_animate.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>)
pipe_animate.to(<span class="hljs-string">&quot;cuda&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(33)
pipe_animate.set_adapters(<span class="hljs-string">&quot;zoom-out&quot;</span>, adapter_weights=0.75)
out = pipe_animate(
    prompt= prompt,
    num_frames=16,
    num_inference_steps=num_inference_steps,
    ip_adapter_image = image,
    generator=generator,
).frames[0]
export_to_gif(out, <span class="hljs-string">&quot;out_animate.gif&quot;</span>)`,wrap:!1}}),ze=new m({props:{code:"cGlwZV9scHclMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3BpcGUoJTBBJTIwJTIwJTIwJTIwcGlwZV9zZCUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUzRCUyMmxwd19zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmJlc3RfcXVhbGl0eSUyMCgxZ2lybCUzQTEuMyklMjBib3clMjBicmlkZSUyMGJyb3duX2hhaXIlMjBjbG9zZWRfbW91dGglMjBmcmlsbGVkX2JvdyUyMGZyaWxsZWRfaGFpcl90dWJlcyUyMGZyaWxscyUyMChmdWxsX2JvZHklM0ExLjMpJTIwZm94X2VhciUyMGhhaXJfYm93JTIwaGFpcl90dWJlcyUyMGhhcHB5JTIwaG9vZCUyMGphcGFuZXNlX2Nsb3RoZXMlMjBraW1vbm8lMjBsb25nX3NsZWV2ZXMlMjByZWRfYm93JTIwc21pbGUlMjBzb2xvJTIwdGFiaSUyMHVjaGlrYWtlJTIwd2hpdGVfa2ltb25vJTIwd2lkZV9zbGVldmVzJTIwY2hlcnJ5X2Jsb3Nzb21zJTIyJTBBbmVnX3Byb21wdCUyMCUzRCUyMCUyMmxvd3JlcyUyQyUyMGJhZF9hbmF0b215JTJDJTIwZXJyb3JfYm9keSUyQyUyMGVycm9yX2hhaXIlMkMlMjBlcnJvcl9hcm0lMkMlMjBlcnJvcl9oYW5kcyUyQyUyMGJhZF9oYW5kcyUyQyUyMGVycm9yX2ZpbmdlcnMlMkMlMjBiYWRfZmluZ2VycyUyQyUyMG1pc3NpbmdfZmluZ2VycyUyQyUyMGVycm9yX2xlZ3MlMkMlMjBiYWRfbGVncyUyQyUyMG11bHRpcGxlX2xlZ3MlMkMlMjBtaXNzaW5nX2xlZ3MlMkMlMjBlcnJvcl9saWdodGluZyUyQyUyMGVycm9yX3NoYWRvdyUyQyUyMGVycm9yX3JlZmxlY3Rpb24lMkMlMjB0ZXh0JTJDJTIwZXJyb3IlMkMlMjBleHRyYV9kaWdpdCUyQyUyMGZld2VyX2RpZ2l0cyUyQyUyMGNyb3BwZWQlMkMlMjB3b3JzdF9xdWFsaXR5JTJDJTIwbG93X3F1YWxpdHklMkMlMjBub3JtYWxfcXVhbGl0eSUyQyUyMGpwZWdfYXJ0aWZhY3RzJTJDJTIwc2lnbmF0dXJlJTJDJTIwd2F0ZXJtYXJrJTJDJTIwdXNlcm5hbWUlMkMlMjBibHVycnklMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgzMyklMEFvdXRfbHB3JTIwJTNEJTIwcGlwZV9scHcudGV4dDJpbWcoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTIwJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnX3Byb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENTEyJTJDaGVpZ2h0JTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2VtYmVkZGluZ3NfbXVsdGlwbGVzJTNEMyUyQyUyMCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe_lpw = DiffusionPipeline.from_pipe(
    pipe_sd,
    custom_pipeline=<span class="hljs-string">&quot;lpw_stable_diffusion&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;best_quality (1girl:1.3) bow bride brown_hair closed_mouth frilled_bow frilled_hair_tubes frills (full_body:1.3) fox_ear hair_bow hair_tubes happy hood japanese_clothes kimono long_sleeves red_bow smile solo tabi uchikake white_kimono wide_sleeves cherry_blossoms&quot;</span>
neg_prompt = <span class="hljs-string">&quot;lowres, bad_anatomy, error_body, error_hair, error_arm, error_hands, bad_hands, error_fingers, bad_fingers, missing_fingers, error_legs, bad_legs, multiple_legs, missing_legs, error_lighting, error_shadow, error_reflection, text, error, extra_digit, fewer_digits, cropped, worst_quality, low_quality, normal_quality, jpeg_artifacts, signature, watermark, username, blurry&quot;</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(33)
out_lpw = pipe_lpw.text2img(
    prompt, 
    negative_prompt=neg_prompt, 
    width=512,height=512,
    max_embeddings_multiples=3, 
    num_inference_steps=num_inference_steps,
    generator=generator,
    ).images[0]`,wrap:!1}}),Fe=new m({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBb3V0X3NkJTIwJTNEJTIwcGlwZV9zZCglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEbnVtX2luZmVyZW5jZV9zdGVwcyUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW91dF9zZA==",highlighted:`generator = torch.Generator(<span class="hljs-attribute">device</span>=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(33)
out_sd = pipe_sd(
    <span class="hljs-attribute">prompt</span>=prompt,
    <span class="hljs-attribute">negative_prompt</span>=negative_prompt,
    <span class="hljs-attribute">generator</span>=generator,
    <span class="hljs-attribute">num_inference_steps</span>=num_inference_steps,
).images[0]
out_sd`,wrap:!1}}),De=new J({props:{title:"Checkpoint variants",local:"checkpoint-variants",headingTag:"h2"}}),W=new di({props:{$$slots:{default:[bi]},$$scope:{ctx:Bl}}}),ll=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBsb2FkJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQSUyMyUyMGxvYWQlMjBub25fZW1hJTIwdmFyaWFudCUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># load fp16 variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># load non_ema variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),tl=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwc2F2ZSUyMGFzJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQSUyMyUyMHNhdmUlMjBhcyUyMG5vbi1lbWElMjB2YXJpYW50JTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-comment"># save as fp16 variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
<span class="hljs-comment"># save as non-ema variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`,wrap:!1}}),il=new m({props:{code:"JTIzJTIwJUYwJTlGJTkxJThFJTIwdGhpcyUyMHdvbid0JTIwd29yayUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTIzJTIwJUYwJTlGJTkxJThEJTIwdGhpcyUyMHdvcmtzJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-comment"># 👎 this won&#x27;t work</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># 👍 this works</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),al=new J({props:{title:"Models",local:"models",headingTag:"h2"}}),rl=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
model = UNet2DConditionModel.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),ul=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2lmYXIxMC0zMiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

repo_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>
model = UNet2DModel.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),fl=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdmFyaWFudCUzRCUyMm5vbl9lbWElMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGbG9jYWwtdW5ldCUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub25fZW1hJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
model.save_pretrained(<span class="hljs-string">&quot;./local-unet&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`,wrap:!1}}),Ml=new J({props:{title:"Schedulers",local:"schedulers",headingTag:"h2"}}),hl=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRERJTVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMFBORE1TY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBKSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQWRkcG0lMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRkaW0lMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQXBuZG0lMjAlM0QlMjBQTkRNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWxtcyUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWV1bGVyX2FuYyUyMCUzRCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBZXVsZXIlMjAlM0QlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRwbSUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEElMEElMjMlMjByZXBsYWNlJTIwJTYwZHBtJTYwJTIwd2l0aCUyMGFueSUyMG9mJTIwJTYwZGRwbSU2MCUyQyUyMCU2MGRkaW0lNjAlMkMlMjAlNjBwbmRtJTYwJTJDJTIwJTYwbG1zJTYwJTJDJTIwJTYwZXVsZXJfYW5jJTYwJTJDJTIwJTYwZXVsZXIlNjAlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEZHBtJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDPMScheduler,
    DDIMScheduler,
    PNDMScheduler,
    LMSDiscreteScheduler,
    EulerAncestralDiscreteScheduler,
    EulerDiscreteScheduler,
    DPMSolverMultistepScheduler,
)

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

ddpm = DDPMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
ddim = DDIMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
pndm = PNDMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
lms = LMSDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler_anc = EulerAncestralDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
dpm = DPMSolverMultistepScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

<span class="hljs-comment"># replace \`dpm\` with any of \`ddpm\`, \`ddim\`, \`pndm\`, \`lms\`, \`euler_anc\`, \`euler\`</span>
pipeline = StableDiffusionPipeline.from_pretrained(repo_id, scheduler=dpm, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),Jl=new J({props:{title:"DiffusionPipeline explained",local:"diffusionpipeline-explained",headingTag:"h2"}}),bl=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcHJpbnQocGlwZWxpbmUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(pipeline)`,wrap:!1}}),gl=new m({props:{code:"U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjAlMjJmZWF0dXJlX2V4dHJhY3RvciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBJbWFnZVByb2Nlc3NvciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnNhZmV0eV9jaGVja2VyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlN0YWJsZURpZmZ1c2lvblNhZmV0eUNoZWNrZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJQTkRNU2NoZWR1bGVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRva2VuaXplciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUb2tlbml6ZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVU5ldDJEQ29uZGl0aW9uTW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ2YWUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBdXRvZW5jb2RlcktMJTIyJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`StableDiffusionPipeline <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Il=new m({props:{code:"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",highlighted:`.
├── feature_extractor
│   └── preprocessor_config.json
├── model_index.json
├── safety_checker
│   ├── config.json
|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   ├── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── scheduler
│   └── scheduler_config.json
├── text_encoder
│   ├── config.json
</span>|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   </span>|<span class="hljs-string">── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── tokenizer
│   ├── merges.txt
│   ├── special_tokens_map.json
│   ├── tokenizer_config.json
│   └── vocab.json
├── unet
│   ├── config.json
│   ├── diffusion_pytorch_model.bin
</span>|<span class="hljs-string">   </span>|<span class="hljs-string">── diffusion_pytorch_model.fp16.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.f16.safetensors
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.safetensors
│   └── diffusion_pytorch_model.safetensors
</span>|<span class="hljs-string">── vae
.   ├── config.json
.   ├── diffusion_pytorch_model.bin
    ├── diffusion_pytorch_model.fp16.bin
    ├── diffusion_pytorch_model.fp16.safetensors
    └── diffusion_pytorch_model.safetensors</span>`,wrap:!1}}),vl=new m({props:{code:"cGlwZWxpbmUudG9rZW5pemVyJTBBQ0xJUFRva2VuaXplciglMEElMjAlMjAlMjAlMjBuYW1lX29yX3BhdGglM0QlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXJ1bndheW1sLS1zdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzbmFwc2hvdHMlMkYzOTU5M2Q1NjUwMTEyYjRjYzU4MDQzM2Y2YjA0MzUzODU4ODJkODE5JTJGdG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDQ5NDA4JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDc3JTJDJTBBJTIwJTIwJTIwJTIwaXNfZmFzdCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNEJTIycmlnaHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX3NpZGUlM0QlMjJyaWdodCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWNpYWxfdG9rZW5zJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NzdGFydG9mdGV4dCU3QyUzRSUyMiUyQyUyMHJzdHJpcCUzREZhbHNlJTJDJTIwbHN0cmlwJTNERmFsc2UlMkMlMjBzaW5nbGVfd29yZCUzREZhbHNlJTJDJTIwbm9ybWFsaXplZCUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMjByc3RyaXAlM0RGYWxzZSUyQyUyMGxzdHJpcCUzREZhbHNlJTJDJTIwc2luZ2xlX3dvcmQlM0RGYWxzZSUyQyUyMG5vcm1hbGl6ZWQlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVua190b2tlbiUyMiUzQSUyMEFkZGVkVG9rZW4oJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTIwcnN0cmlwJTNERmFsc2UlMkMlMjBsc3RyaXAlM0RGYWxzZSUyQyUyMHNpbmdsZV93b3JkJTNERmFsc2UlMkMlMjBub3JtYWxpemVkJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRfdG9rZW4lMjIlM0ElMjAlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNEVHJ1ZSUwQSk=",highlighted:`pipeline.tokenizer
CLIPTokenizer(
    name_or_path=<span class="hljs-string">&quot;/root/.cache/huggingface/hub/models--runwayml--stable-diffusion-v1-5/snapshots/39593d5650112b4cc580433f6b0435385882d819/tokenizer&quot;</span>,
    vocab_size=<span class="hljs-number">49408</span>,
    model_max_length=<span class="hljs-number">77</span>,
    is_fast=<span class="hljs-literal">False</span>,
    padding_side=<span class="hljs-string">&quot;right&quot;</span>,
    truncation_side=<span class="hljs-string">&quot;right&quot;</span>,
    special_tokens={
        <span class="hljs-string">&quot;bos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|startoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;eos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;unk_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    },
    clean_up_tokenization_spaces=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Gl=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuNi4wJTIyJTJDJTBBJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQSW1hZ2VQcm9jZXNzb3IlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzYWZldHlfY2hlY2tlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdGFibGVEaWZmdXNpb25TYWZldHlDaGVja2VyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRleHRfZW5jb2RlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUZXh0TW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ0b2tlbml6ZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQVG9rZW5pemVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydW5ldCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlVOZXQyRENvbmRpdGlvbk1vZGVsJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydmFlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b2VuY29kZXJLTCUyMiUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;_diffusers_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.6.0&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),{c(){y=a("meta"),U=n(),h=a("p"),w=n(),r(_.$$.fragment),Rl=n(),r(G.$$.fragment),Xl=n(),B=a("p"),B.innerHTML=qt,Nl=n(),k=a("p"),k.innerHTML=Dt,$l=n(),R=a("p"),R.textContent=At,Ql=n(),X=a("ul"),X.innerHTML=Lt,Yl=n(),r(N.$$.fragment),xl=n(),r(b.$$.fragment),El=n(),$=a("p"),$.innerHTML=Pt,Sl=n(),r(Q.$$.fragment),zl=n(),Y=a("p"),Y.innerHTML=Ot,Hl=n(),r(x.$$.fragment),Fl=n(),E=a("p"),E.innerHTML=Kt,ql=n(),r(S.$$.fragment),Dl=n(),z=a("p"),z.textContent=en,Al=n(),Z=a("div"),Z.innerHTML=ln,Ll=n(),j=a("div"),j.innerHTML=sn,Pl=n(),r(H.$$.fragment),Ol=n(),F=a("p"),F.innerHTML=tn,Kl=n(),r(q.$$.fragment),es=n(),D=a("p"),D.innerHTML=nn,ls=n(),r(A.$$.fragment),ss=n(),L=a("p"),L.innerHTML=an,ts=n(),r(P.$$.fragment),ns=n(),O=a("p"),O.textContent=pn,is=n(),K=a("ul"),K.innerHTML=on,as=n(),ee=a("p"),ee.innerHTML=rn,ps=n(),r(le.$$.fragment),os=n(),se=a("p"),se.innerHTML=cn,rs=n(),te=a("p"),te.innerHTML=un,cs=n(),r(ne.$$.fragment),us=n(),r(ie.$$.fragment),ds=n(),ae=a("p"),ae.innerHTML=dn,fs=n(),r(pe.$$.fragment),Ms=n(),r(oe.$$.fragment),ms=n(),re=a("p"),re.innerHTML=fn,ys=n(),r(ce.$$.fragment),hs=n(),ue=a("p"),ue.innerHTML=Mn,Js=n(),r(de.$$.fragment),Us=n(),fe=a("p"),fe.textContent=mn,Ts=n(),r(Me.$$.fragment),ws=n(),r(me.$$.fragment),bs=n(),ye=a("p"),ye.innerHTML=yn,Zs=n(),he=a("p"),he.innerHTML=hn,js=n(),Je=a("p"),Je.textContent=Jn,gs=n(),r(Ue.$$.fragment),Cs=n(),Te=a("p"),Te.textContent=Un,Is=n(),g=a("div"),g.innerHTML=Tn,Vs=n(),r(we.$$.fragment),vs=n(),r(be.$$.fragment),Ws=n(),Ze=a("p"),Ze.innerHTML=wn,_s=n(),r(je.$$.fragment),Gs=n(),ge=a("p"),ge.innerHTML=bn,Bs=n(),r(Ce.$$.fragment),ks=n(),Ie=a("p"),Ie.textContent=Zn,Rs=n(),C=a("div"),C.innerHTML=jn,Xs=n(),Ve=a("p"),Ve.innerHTML=gn,Ns=n(),r(ve.$$.fragment),$s=n(),r(We.$$.fragment),Qs=n(),_e=a("p"),_e.innerHTML=Cn,Ys=n(),r(Ge.$$.fragment),xs=n(),Be=a("p"),Be.textContent=In,Es=n(),r(ke.$$.fragment),Ss=n(),r(Re.$$.fragment),zs=n(),Xe=a("p"),Xe.innerHTML=Vn,Hs=n(),Ne=a("p"),Ne.innerHTML=vn,Fs=n(),$e=a("p"),$e.innerHTML=Wn,qs=n(),r(Qe.$$.fragment),Ds=n(),I=a("div"),I.innerHTML=_n,As=n(),Ye=a("p"),Ye.innerHTML=Gn,Ls=n(),xe=a("p"),xe.innerHTML=Bn,Ps=n(),Ee=a("p"),Ee.textContent=kn,Os=n(),Se=a("p"),Se.innerHTML=Rn,Ks=n(),r(ze.$$.fragment),et=n(),V=a("div"),V.innerHTML=Xn,lt=n(),He=a("p"),He.textContent=Nn,st=n(),r(Fe.$$.fragment),tt=n(),v=a("div"),v.innerHTML=$n,nt=n(),qe=a("p"),qe.innerHTML=Qn,it=n(),r(De.$$.fragment),at=n(),Ae=a("p"),Ae.textContent=Yn,pt=n(),Le=a("ul"),Le.innerHTML=xn,ot=n(),r(W.$$.fragment),rt=n(),Pe=a("p"),Pe.innerHTML=En,ct=n(),Oe=a("table"),Oe.innerHTML=Sn,ut=n(),Ke=a("p"),Ke.textContent=zn,dt=n(),el=a("ul"),el.innerHTML=Hn,ft=n(),r(ll.$$.fragment),Mt=n(),sl=a("p"),sl.innerHTML=Fn,mt=n(),r(tl.$$.fragment),yt=n(),nl=a("p"),nl.innerHTML=qn,ht=n(),r(il.$$.fragment),Jt=n(),r(al.$$.fragment),Ut=n(),pl=a("p"),pl.innerHTML=Dn,Tt=n(),ol=a("p"),ol.innerHTML=An,wt=n(),r(rl.$$.fragment),bt=n(),cl=a("p"),cl.innerHTML=Ln,Zt=n(),r(ul.$$.fragment),jt=n(),dl=a("p"),dl.innerHTML=Pn,gt=n(),r(fl.$$.fragment),Ct=n(),r(Ml.$$.fragment),It=n(),ml=a("p"),ml.innerHTML=On,Vt=n(),yl=a("p"),yl.innerHTML=Kn,vt=n(),r(hl.$$.fragment),Wt=n(),r(Jl.$$.fragment),_t=n(),Ul=a("p"),Ul.innerHTML=ei,Gt=n(),Tl=a("ul"),Tl.innerHTML=li,Bt=n(),wl=a("p"),wl.innerHTML=si,kt=n(),r(bl.$$.fragment),Rt=n(),Zl=a("p"),Zl.innerHTML=ti,Xt=n(),jl=a("ul"),jl.innerHTML=ni,Nt=n(),r(gl.$$.fragment),$t=n(),Cl=a("p"),Cl.innerHTML=ii,Qt=n(),r(Il.$$.fragment),Yt=n(),Vl=a("p"),Vl.textContent=ai,xt=n(),r(vl.$$.fragment),Et=n(),Wl=a("p"),Wl.innerHTML=pi,St=n(),_l=a("ul"),_l.innerHTML=oi,zt=n(),r(Gl.$$.fragment),Ht=n(),kl=a("p"),this.h()},l(e){const l=Ji("svelte-u9bgzb",document.head);y=p(l,"META",{name:!0,content:!0}),l.forEach(s),U=i(e),h=p(e,"P",{}),ui(h).forEach(s),w=i(e),c(_.$$.fragment,e),Rl=i(e),c(G.$$.fragment,e),Xl=i(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-b825yc"&&(B.innerHTML=qt),Nl=i(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1let6ok"&&(k.innerHTML=Dt),$l=i(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-b6mpdv"&&(R.textContent=At),Ql=i(e),X=p(e,"UL",{"data-svelte-h":!0}),o(X)!=="svelte-19eqgr5"&&(X.innerHTML=Lt),Yl=i(e),c(N.$$.fragment,e),xl=i(e),c(b.$$.fragment,e),El=i(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1een31v"&&($.innerHTML=Pt),Sl=i(e),c(Q.$$.fragment,e),zl=i(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-87p7"&&(Y.innerHTML=Ot),Hl=i(e),c(x.$$.fragment,e),Fl=i(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1dc1tjj"&&(E.innerHTML=Kt),ql=i(e),c(S.$$.fragment,e),Dl=i(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1gn1gle"&&(z.textContent=en),Al=i(e),Z=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(Z)!=="svelte-1eacg44"&&(Z.innerHTML=ln),Ll=i(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-1scmarz"&&(j.innerHTML=sn),Pl=i(e),c(H.$$.fragment,e),Ol=i(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-zzamd0"&&(F.innerHTML=tn),Kl=i(e),c(q.$$.fragment,e),es=i(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-14lmk7e"&&(D.innerHTML=nn),ls=i(e),c(A.$$.fragment,e),ss=i(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-i8rr5s"&&(L.innerHTML=an),ts=i(e),c(P.$$.fragment,e),ns=i(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1b4jg3u"&&(O.textContent=pn),is=i(e),K=p(e,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-vp14rw"&&(K.innerHTML=on),as=i(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-s7xu2t"&&(ee.innerHTML=rn),ps=i(e),c(le.$$.fragment,e),os=i(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1llio5t"&&(se.innerHTML=cn),rs=i(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1cym4i4"&&(te.innerHTML=un),cs=i(e),c(ne.$$.fragment,e),us=i(e),c(ie.$$.fragment,e),ds=i(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-181junk"&&(ae.innerHTML=dn),fs=i(e),c(pe.$$.fragment,e),Ms=i(e),c(oe.$$.fragment,e),ms=i(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-12c191q"&&(re.innerHTML=fn),ys=i(e),c(ce.$$.fragment,e),hs=i(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-jytaak"&&(ue.innerHTML=Mn),Js=i(e),c(de.$$.fragment,e),Us=i(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1o7di1p"&&(fe.textContent=mn),Ts=i(e),c(Me.$$.fragment,e),ws=i(e),c(me.$$.fragment,e),bs=i(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-nu3g8z"&&(ye.innerHTML=yn),Zs=i(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-9nrzm2"&&(he.innerHTML=hn),js=i(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-18asyn1"&&(Je.textContent=Jn),gs=i(e),c(Ue.$$.fragment,e),Cs=i(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-4ko6n7"&&(Te.textContent=Un),Is=i(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-ye42mk"&&(g.innerHTML=Tn),Vs=i(e),c(we.$$.fragment,e),vs=i(e),c(be.$$.fragment,e),Ws=i(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-ys2vgz"&&(Ze.innerHTML=wn),_s=i(e),c(je.$$.fragment,e),Gs=i(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-wnksjy"&&(ge.innerHTML=bn),Bs=i(e),c(Ce.$$.fragment,e),ks=i(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-mme3cd"&&(Ie.textContent=Zn),Rs=i(e),C=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-5lltp7"&&(C.innerHTML=jn),Xs=i(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-dn3a03"&&(Ve.innerHTML=gn),Ns=i(e),c(ve.$$.fragment,e),$s=i(e),c(We.$$.fragment,e),Qs=i(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-zm1pog"&&(_e.innerHTML=Cn),Ys=i(e),c(Ge.$$.fragment,e),xs=i(e),Be=p(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-khqivn"&&(Be.textContent=In),Es=i(e),c(ke.$$.fragment,e),Ss=i(e),c(Re.$$.fragment,e),zs=i(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1kwztbh"&&(Xe.innerHTML=Vn),Hs=i(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-wok7nr"&&(Ne.innerHTML=vn),Fs=i(e),$e=p(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-z58kgj"&&($e.innerHTML=Wn),qs=i(e),c(Qe.$$.fragment,e),Ds=i(e),I=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-cbprhg"&&(I.innerHTML=_n),As=i(e),Ye=p(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-mk14rn"&&(Ye.innerHTML=Gn),Ls=i(e),xe=p(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1psv2tu"&&(xe.innerHTML=Bn),Ps=i(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-pc16ip"&&(Ee.textContent=kn),Os=i(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-kwmvyp"&&(Se.innerHTML=Rn),Ks=i(e),c(ze.$$.fragment,e),et=i(e),V=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(V)!=="svelte-v4nddi"&&(V.innerHTML=Xn),lt=i(e),He=p(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1kb2wqk"&&(He.textContent=Nn),st=i(e),c(Fe.$$.fragment,e),tt=i(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(v)!=="svelte-kttbo3"&&(v.innerHTML=$n),nt=i(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-sf01qi"&&(qe.innerHTML=Qn),it=i(e),c(De.$$.fragment,e),at=i(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-144ljdh"&&(Ae.textContent=Yn),pt=i(e),Le=p(e,"UL",{"data-svelte-h":!0}),o(Le)!=="svelte-1j7sdrg"&&(Le.innerHTML=xn),ot=i(e),c(W.$$.fragment,e),rt=i(e),Pe=p(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-q0e9bt"&&(Pe.innerHTML=En),ct=i(e),Oe=p(e,"TABLE",{"data-svelte-h":!0}),o(Oe)!=="svelte-1e3wdtx"&&(Oe.innerHTML=Sn),ut=i(e),Ke=p(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-16brnlv"&&(Ke.textContent=zn),dt=i(e),el=p(e,"UL",{"data-svelte-h":!0}),o(el)!=="svelte-11239e9"&&(el.innerHTML=Hn),ft=i(e),c(ll.$$.fragment,e),Mt=i(e),sl=p(e,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-utq62g"&&(sl.innerHTML=Fn),mt=i(e),c(tl.$$.fragment,e),yt=i(e),nl=p(e,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-ydb193"&&(nl.innerHTML=qn),ht=i(e),c(il.$$.fragment,e),Jt=i(e),c(al.$$.fragment,e),Ut=i(e),pl=p(e,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-1cl76mo"&&(pl.innerHTML=Dn),Tt=i(e),ol=p(e,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-1y53na1"&&(ol.innerHTML=An),wt=i(e),c(rl.$$.fragment,e),bt=i(e),cl=p(e,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-7x7c45"&&(cl.innerHTML=Ln),Zt=i(e),c(ul.$$.fragment,e),jt=i(e),dl=p(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-h4z70l"&&(dl.innerHTML=Pn),gt=i(e),c(fl.$$.fragment,e),Ct=i(e),c(Ml.$$.fragment,e),It=i(e),ml=p(e,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-1xjd8d0"&&(ml.innerHTML=On),Vt=i(e),yl=p(e,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-ubdfig"&&(yl.innerHTML=Kn),vt=i(e),c(hl.$$.fragment,e),Wt=i(e),c(Jl.$$.fragment,e),_t=i(e),Ul=p(e,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-nr77qh"&&(Ul.innerHTML=ei),Gt=i(e),Tl=p(e,"UL",{"data-svelte-h":!0}),o(Tl)!=="svelte-17dcgvz"&&(Tl.innerHTML=li),Bt=i(e),wl=p(e,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-jme5sm"&&(wl.innerHTML=si),kt=i(e),c(bl.$$.fragment,e),Rt=i(e),Zl=p(e,"P",{"data-svelte-h":!0}),o(Zl)!=="svelte-102ytrs"&&(Zl.innerHTML=ti),Xt=i(e),jl=p(e,"UL",{"data-svelte-h":!0}),o(jl)!=="svelte-1e5gxzy"&&(jl.innerHTML=ni),Nt=i(e),c(gl.$$.fragment,e),$t=i(e),Cl=p(e,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-173hqz7"&&(Cl.innerHTML=ii),Qt=i(e),c(Il.$$.fragment,e),Yt=i(e),Vl=p(e,"P",{"data-svelte-h":!0}),o(Vl)!=="svelte-5jik9b"&&(Vl.textContent=ai),xt=i(e),c(vl.$$.fragment,e),Et=i(e),Wl=p(e,"P",{"data-svelte-h":!0}),o(Wl)!=="svelte-1uoxyh2"&&(Wl.innerHTML=pi),St=i(e),_l=p(e,"UL",{"data-svelte-h":!0}),o(_l)!=="svelte-hr84vt"&&(_l.innerHTML=oi),zt=i(e),c(Gl.$$.fragment,e),Ht=i(e),kl=p(e,"P",{}),ui(kl).forEach(s),this.h()},h(){T(y,"name","hf:doc:metadata"),T(y,"content",ji),T(Z,"class","block dark:hidden"),T(j,"class","hidden dark:block"),T(g,"class","flex justify-center"),T(C,"class","flex justify-center"),T(I,"class","flex justify-center"),T(V,"class","flex justify-center"),T(v,"class","flex justify-center")},m(e,l){Ui(document.head,y),t(e,U,l),t(e,h,l),t(e,w,l),u(_,e,l),t(e,Rl,l),u(G,e,l),t(e,Xl,l),t(e,B,l),t(e,Nl,l),t(e,k,l),t(e,$l,l),t(e,R,l),t(e,Ql,l),t(e,X,l),t(e,Yl,l),u(N,e,l),t(e,xl,l),u(b,e,l),t(e,El,l),t(e,$,l),t(e,Sl,l),u(Q,e,l),t(e,zl,l),t(e,Y,l),t(e,Hl,l),u(x,e,l),t(e,Fl,l),t(e,E,l),t(e,ql,l),u(S,e,l),t(e,Dl,l),t(e,z,l),t(e,Al,l),t(e,Z,l),t(e,Ll,l),t(e,j,l),t(e,Pl,l),u(H,e,l),t(e,Ol,l),t(e,F,l),t(e,Kl,l),u(q,e,l),t(e,es,l),t(e,D,l),t(e,ls,l),u(A,e,l),t(e,ss,l),t(e,L,l),t(e,ts,l),u(P,e,l),t(e,ns,l),t(e,O,l),t(e,is,l),t(e,K,l),t(e,as,l),t(e,ee,l),t(e,ps,l),u(le,e,l),t(e,os,l),t(e,se,l),t(e,rs,l),t(e,te,l),t(e,cs,l),u(ne,e,l),t(e,us,l),u(ie,e,l),t(e,ds,l),t(e,ae,l),t(e,fs,l),u(pe,e,l),t(e,Ms,l),u(oe,e,l),t(e,ms,l),t(e,re,l),t(e,ys,l),u(ce,e,l),t(e,hs,l),t(e,ue,l),t(e,Js,l),u(de,e,l),t(e,Us,l),t(e,fe,l),t(e,Ts,l),u(Me,e,l),t(e,ws,l),u(me,e,l),t(e,bs,l),t(e,ye,l),t(e,Zs,l),t(e,he,l),t(e,js,l),t(e,Je,l),t(e,gs,l),u(Ue,e,l),t(e,Cs,l),t(e,Te,l),t(e,Is,l),t(e,g,l),t(e,Vs,l),u(we,e,l),t(e,vs,l),u(be,e,l),t(e,Ws,l),t(e,Ze,l),t(e,_s,l),u(je,e,l),t(e,Gs,l),t(e,ge,l),t(e,Bs,l),u(Ce,e,l),t(e,ks,l),t(e,Ie,l),t(e,Rs,l),t(e,C,l),t(e,Xs,l),t(e,Ve,l),t(e,Ns,l),u(ve,e,l),t(e,$s,l),u(We,e,l),t(e,Qs,l),t(e,_e,l),t(e,Ys,l),u(Ge,e,l),t(e,xs,l),t(e,Be,l),t(e,Es,l),u(ke,e,l),t(e,Ss,l),u(Re,e,l),t(e,zs,l),t(e,Xe,l),t(e,Hs,l),t(e,Ne,l),t(e,Fs,l),t(e,$e,l),t(e,qs,l),u(Qe,e,l),t(e,Ds,l),t(e,I,l),t(e,As,l),t(e,Ye,l),t(e,Ls,l),t(e,xe,l),t(e,Ps,l),t(e,Ee,l),t(e,Os,l),t(e,Se,l),t(e,Ks,l),u(ze,e,l),t(e,et,l),t(e,V,l),t(e,lt,l),t(e,He,l),t(e,st,l),u(Fe,e,l),t(e,tt,l),t(e,v,l),t(e,nt,l),t(e,qe,l),t(e,it,l),u(De,e,l),t(e,at,l),t(e,Ae,l),t(e,pt,l),t(e,Le,l),t(e,ot,l),u(W,e,l),t(e,rt,l),t(e,Pe,l),t(e,ct,l),t(e,Oe,l),t(e,ut,l),t(e,Ke,l),t(e,dt,l),t(e,el,l),t(e,ft,l),u(ll,e,l),t(e,Mt,l),t(e,sl,l),t(e,mt,l),u(tl,e,l),t(e,yt,l),t(e,nl,l),t(e,ht,l),u(il,e,l),t(e,Jt,l),u(al,e,l),t(e,Ut,l),t(e,pl,l),t(e,Tt,l),t(e,ol,l),t(e,wt,l),u(rl,e,l),t(e,bt,l),t(e,cl,l),t(e,Zt,l),u(ul,e,l),t(e,jt,l),t(e,dl,l),t(e,gt,l),u(fl,e,l),t(e,Ct,l),u(Ml,e,l),t(e,It,l),t(e,ml,l),t(e,Vt,l),t(e,yl,l),t(e,vt,l),u(hl,e,l),t(e,Wt,l),u(Jl,e,l),t(e,_t,l),t(e,Ul,l),t(e,Gt,l),t(e,Tl,l),t(e,Bt,l),t(e,wl,l),t(e,kt,l),u(bl,e,l),t(e,Rt,l),t(e,Zl,l),t(e,Xt,l),t(e,jl,l),t(e,Nt,l),u(gl,e,l),t(e,$t,l),t(e,Cl,l),t(e,Qt,l),u(Il,e,l),t(e,Yt,l),t(e,Vl,l),t(e,xt,l),u(vl,e,l),t(e,Et,l),t(e,Wl,l),t(e,St,l),t(e,_l,l),t(e,zt,l),u(Gl,e,l),t(e,Ht,l),t(e,kl,l),Ft=!0},p(e,[l]){const ri={};l&2&&(ri.$$scope={dirty:l,ctx:e}),b.$set(ri);const ci={};l&2&&(ci.$$scope={dirty:l,ctx:e}),W.$set(ci)},i(e){Ft||(d(_.$$.fragment,e),d(G.$$.fragment,e),d(N.$$.fragment,e),d(b.$$.fragment,e),d(Q.$$.fragment,e),d(x.$$.fragment,e),d(S.$$.fragment,e),d(H.$$.fragment,e),d(q.$$.fragment,e),d(A.$$.fragment,e),d(P.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(oe.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(Me.$$.fragment,e),d(me.$$.fragment,e),d(Ue.$$.fragment,e),d(we.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(Ce.$$.fragment,e),d(ve.$$.fragment,e),d(We.$$.fragment,e),d(Ge.$$.fragment,e),d(ke.$$.fragment,e),d(Re.$$.fragment,e),d(Qe.$$.fragment,e),d(ze.$$.fragment,e),d(Fe.$$.fragment,e),d(De.$$.fragment,e),d(W.$$.fragment,e),d(ll.$$.fragment,e),d(tl.$$.fragment,e),d(il.$$.fragment,e),d(al.$$.fragment,e),d(rl.$$.fragment,e),d(ul.$$.fragment,e),d(fl.$$.fragment,e),d(Ml.$$.fragment,e),d(hl.$$.fragment,e),d(Jl.$$.fragment,e),d(bl.$$.fragment,e),d(gl.$$.fragment,e),d(Il.$$.fragment,e),d(vl.$$.fragment,e),d(Gl.$$.fragment,e),Ft=!0)},o(e){f(_.$$.fragment,e),f(G.$$.fragment,e),f(N.$$.fragment,e),f(b.$$.fragment,e),f(Q.$$.fragment,e),f(x.$$.fragment,e),f(S.$$.fragment,e),f(H.$$.fragment,e),f(q.$$.fragment,e),f(A.$$.fragment,e),f(P.$$.fragment,e),f(le.$$.fragment,e),f(ne.$$.fragment,e),f(ie.$$.fragment,e),f(pe.$$.fragment,e),f(oe.$$.fragment,e),f(ce.$$.fragment,e),f(de.$$.fragment,e),f(Me.$$.fragment,e),f(me.$$.fragment,e),f(Ue.$$.fragment,e),f(we.$$.fragment,e),f(be.$$.fragment,e),f(je.$$.fragment,e),f(Ce.$$.fragment,e),f(ve.$$.fragment,e),f(We.$$.fragment,e),f(Ge.$$.fragment,e),f(ke.$$.fragment,e),f(Re.$$.fragment,e),f(Qe.$$.fragment,e),f(ze.$$.fragment,e),f(Fe.$$.fragment,e),f(De.$$.fragment,e),f(W.$$.fragment,e),f(ll.$$.fragment,e),f(tl.$$.fragment,e),f(il.$$.fragment,e),f(al.$$.fragment,e),f(rl.$$.fragment,e),f(ul.$$.fragment,e),f(fl.$$.fragment,e),f(Ml.$$.fragment,e),f(hl.$$.fragment,e),f(Jl.$$.fragment,e),f(bl.$$.fragment,e),f(gl.$$.fragment,e),f(Il.$$.fragment,e),f(vl.$$.fragment,e),f(Gl.$$.fragment,e),Ft=!1},d(e){e&&(s(U),s(h),s(w),s(Rl),s(Xl),s(B),s(Nl),s(k),s($l),s(R),s(Ql),s(X),s(Yl),s(xl),s(El),s($),s(Sl),s(zl),s(Y),s(Hl),s(Fl),s(E),s(ql),s(Dl),s(z),s(Al),s(Z),s(Ll),s(j),s(Pl),s(Ol),s(F),s(Kl),s(es),s(D),s(ls),s(ss),s(L),s(ts),s(ns),s(O),s(is),s(K),s(as),s(ee),s(ps),s(os),s(se),s(rs),s(te),s(cs),s(us),s(ds),s(ae),s(fs),s(Ms),s(ms),s(re),s(ys),s(hs),s(ue),s(Js),s(Us),s(fe),s(Ts),s(ws),s(bs),s(ye),s(Zs),s(he),s(js),s(Je),s(gs),s(Cs),s(Te),s(Is),s(g),s(Vs),s(vs),s(Ws),s(Ze),s(_s),s(Gs),s(ge),s(Bs),s(ks),s(Ie),s(Rs),s(C),s(Xs),s(Ve),s(Ns),s($s),s(Qs),s(_e),s(Ys),s(xs),s(Be),s(Es),s(Ss),s(zs),s(Xe),s(Hs),s(Ne),s(Fs),s($e),s(qs),s(Ds),s(I),s(As),s(Ye),s(Ls),s(xe),s(Ps),s(Ee),s(Os),s(Se),s(Ks),s(et),s(V),s(lt),s(He),s(st),s(tt),s(v),s(nt),s(qe),s(it),s(at),s(Ae),s(pt),s(Le),s(ot),s(rt),s(Pe),s(ct),s(Oe),s(ut),s(Ke),s(dt),s(el),s(ft),s(Mt),s(sl),s(mt),s(yt),s(nl),s(ht),s(Jt),s(Ut),s(pl),s(Tt),s(ol),s(wt),s(bt),s(cl),s(Zt),s(jt),s(dl),s(gt),s(Ct),s(It),s(ml),s(Vt),s(yl),s(vt),s(Wt),s(_t),s(Ul),s(Gt),s(Tl),s(Bt),s(wl),s(kt),s(Rt),s(Zl),s(Xt),s(jl),s(Nt),s($t),s(Cl),s(Qt),s(Yt),s(Vl),s(xt),s(Et),s(Wl),s(St),s(_l),s(zt),s(Ht),s(kl)),s(y),M(_,e),M(G,e),M(N,e),M(b,e),M(Q,e),M(x,e),M(S,e),M(H,e),M(q,e),M(A,e),M(P,e),M(le,e),M(ne,e),M(ie,e),M(pe,e),M(oe,e),M(ce,e),M(de,e),M(Me,e),M(me,e),M(Ue,e),M(we,e),M(be,e),M(je,e),M(Ce,e),M(ve,e),M(We,e),M(Ge,e),M(ke,e),M(Re,e),M(Qe,e),M(ze,e),M(Fe,e),M(De,e),M(W,e),M(ll,e),M(tl,e),M(il,e),M(al,e),M(rl,e),M(ul,e),M(fl,e),M(Ml,e),M(hl,e),M(Jl,e),M(bl,e),M(gl,e),M(Il,e),M(vl,e),M(Gl,e)}}}const ji='{"title":"Load pipelines, models, and schedulers","local":"load-pipelines-models-and-schedulers","sections":[{"title":"Diffusion Pipeline","local":"diffusion-pipeline","sections":[{"title":"Local pipeline","local":"local-pipeline","sections":[],"depth":3},{"title":"Swap components in a pipeline","local":"swap-components-in-a-pipeline","sections":[],"depth":3},{"title":"Safety checker","local":"safety-checker","sections":[],"depth":3},{"title":"Reuse components across pipelines","local":"reuse-components-across-pipelines","sections":[],"depth":3},{"title":"Switch loaded pippelines","local":"switch-loaded-pippelines","sections":[],"depth":3}],"depth":2},{"title":"Checkpoint variants","local":"checkpoint-variants","sections":[],"depth":2},{"title":"Models","local":"models","sections":[],"depth":2},{"title":"Schedulers","local":"schedulers","sections":[],"depth":2},{"title":"DiffusionPipeline explained","local":"diffusionpipeline-explained","sections":[],"depth":2}],"depth":1}';function gi(Bl){return mi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gi extends yi{constructor(y){super(),hi(this,y,gi,Zi,Mi,{})}}export{Gi as component};
