import{s as Se,o as Ae,n as Pe}from"../chunks/scheduler.56730f09.js";import{S as Ke,i as De,g as p,s as a,r as m,A as Oe,h as i,f as l,c as n,j as Ye,u as r,x as o,k as ye,y as tl,a as s,v as c,d as g,t as M,w as u}from"../chunks/index.1f144517.js";import{T as el}from"../chunks/Tip.41e845e5.js";import{C as T}from"../chunks/CodeBlock.738eeccb.js";import{D as ll}from"../chunks/DocNotebookDropdown.b2e82107.js";import{H as h}from"../chunks/Heading.57d46534.js";function sl(ft){let d,J='기본 LLM 사용에 관심이 있다면, 우리의 <a href="pipeline_tutorial"><code>Pipeline</code></a> 인터페이스로 시작하는 것을 추천합니다. 그러나 LLM은 양자화나 토큰 선택 단계에서의 미세한 제어와 같은 고급 기능들을 종종 필요로 합니다. 이러한 작업은 <code>generate()</code>를 통해 가장 잘 수행될 수 있습니다. LLM을 이용한 자기회귀 생성은 자원을 많이 소모하므로, 적절한 처리량을 위해 GPU에서 실행되어야 합니다.';return{c(){d=p("p"),d.innerHTML=J},l(y){d=i(y,"P",{"data-svelte-h":!0}),o(d)!=="svelte-1ygdj4"&&(d.innerHTML=J)},m(y,yt){s(y,d,yt)},p:Pe,d(y){y&&l(d)}}}function al(ft){let d,J,y,yt,w,bt,U,jt,k,he="LLM 또는 대규모 언어 모델은 텍스트 생성의 핵심 구성 요소입니다. 간단히 말하면, 주어진 입력 텍스트에 대한 다음 단어(정확하게는 토큰)를 예측하기 위해 훈련된 대규모 사전 훈련 변환기 모델로 구성됩니다. 토큰을 한 번에 하나씩 예측하기 때문에 새로운 문장을 생성하려면 모델을 호출하는 것 외에 더 복잡한 작업을 수행해야 합니다. 즉, 자기회귀 생성을 수행해야 합니다.",Tt,Z,fe="자기회귀 생성은 몇 개의 초기 입력값을 제공한 후, 그 출력을 다시 모델에 입력으로 사용하여 반복적으로 호출하는 추론 과정입니다. 🤗 Transformers에서는 <code>generate()</code> 메소드가 이 역할을 하며, 이는 생성 기능을 가진 모든 모델에서 사용 가능합니다.",Jt,$,be="이 튜토리얼에서는 다음 내용을 다루게 됩니다:",wt,_,je="<li>LLM으로 텍스트 생성</li> <li>일반적으로 발생하는 문제 해결</li> <li>LLM을 최대한 활용하기 위한 다음 단계</li>",Ut,v,Te="시작하기 전에 필요한 모든 라이브러리가 설치되어 있는지 확인하세요:",kt,W,Zt,C,$t,I,Je='<a href="tasks/language_modeling">인과적 언어 모델링(causal language modeling)</a>을 목적으로 학습된 언어 모델은 일련의 텍스트 토큰을 입력으로 사용하고, 그 결과로 다음 토큰이 나올 확률 분포를 제공합니다.',_t,f,we='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_1_1080p.mov"></video> <figcaption>&quot;LLM의 전방 패스&quot;</figcaption>',vt,R,Ue="LLM과 자기회귀 생성을 함께 사용할 때 핵심적인 부분은 이 확률 분포로부터 다음 토큰을 어떻게 고를 것인지입니다. 다음 반복 과정에 사용될 토큰을 결정하는 한, 어떠한 방법도 가능합니다. 확률 분포에서 가장 가능성이 높은 토큰을 선택하는 것처럼 간단할 수도 있고, 결과 분포에서 샘플링하기 전에 수십 가지 변환을 적용하는 것처럼 복잡할 수도 있습니다.",Wt,b,ke='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_2_1080p.mov"></video> <figcaption>&quot;자기회귀 생성은 확률 분포에서 다음 토큰을 반복적으로 선택하여 텍스트를 생성합니다.&quot;</figcaption>',Ct,X,Ze="위에서 설명한 과정은 어떤 종료 조건이 충족될 때까지 반복적으로 수행됩니다. 모델이 시퀀스의 끝(EOS 토큰)을 출력할 때까지를 종료 조건으로 하는 것이 이상적입니다. 그렇지 않은 경우에는 미리 정의된 최대 길이에 도달했을 때 생성이 중단됩니다.",It,G,$e="모델이 예상대로 동작하기 위해선 토큰 선택 단계와 정지 조건을 올바르게 설정하는 것이 중요합니다. 이러한 이유로, 각 모델에는 기본 생성 설정이 잘 정의된 <code>GenerationConfig</code> 파일이 함께 제공됩니다.",Rt,V,_e="코드를 확인해봅시다!",Xt,j,Gt,x,ve="먼저, 모델을 불러오세요.",Vt,B,xt,z,We="<code>from_pretrained</code> 함수를 호출할 때 2개의 플래그를 주목하세요:",Bt,L,Ce='<li><code>device_map</code>은 모델이 GPU로 이동되도록 합니다.</li> <li><code>load_in_4bit</code>는 리소스 요구 사항을 크게 줄이기 위해 <a href="main_classes/quantization">4비트 동적 양자화</a>를 적용합니다.</li>',zt,H,Ie="이 외에도 모델을 초기화하는 다양한 방법이 있지만, LLM을 처음 시작할 때 이 설정을 추천합니다.",Lt,F,Re='이어서 텍스트 입력을 <a href="tokenizer_summary">토크나이저</a>으로 전처리하세요.',Ht,Q,Ft,q,Xe="<code>model_inputs</code> 변수에는 토큰화된 텍스트 입력과 함께 어텐션 마스크가 들어 있습니다. <code>generate()</code>는 어텐션 마스크가 제공되지 않았을 경우에도 이를 추론하려고 노력하지만, 최상의 성능을 위해서는 가능하면 어텐션 마스크를 전달하는 것을 권장합니다.",Qt,E,Ge="마지막으로 <code>generate()</code> 메소드를 호출해 생성된 토큰을 얻은 후, 이를 출력하기 전에 텍스트 형태로 변환하세요.",qt,N,Et,Y,Ve="이게 전부입니다! 몇 줄의 코드만으로 LLM의 능력을 활용할 수 있게 되었습니다.",Nt,S,Yt,A,xe='<a href="generation_strategies">생성 전략</a>이 많고, 기본값이 항상 사용 사례에 적합하지 않을 수 있습니다. 출력이 예상과 다를 때 흔히 발생하는 문제와 이를 해결하는 방법에 대한 목록을 만들었습니다.',St,P,At,K,Pt,D,Be='<code>GenerationConfig</code> 파일에서 별도로 지정하지 않으면, <code>generate</code>는 기본적으로 최대 20개의 토큰을 반환합니다. <code>generate</code> 호출에서 <code>max_new_tokens</code>을 수동으로 설정하여 반환할 수 있는 새 토큰의 최대 수를 설정하는 것이 좋습니다. LLM(정확하게는 <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">디코더 전용 모델</a>)은 입력 프롬프트도 출력의 일부로 반환합니다.',Kt,O,Dt,tt,Ot,et,ze='기본적으로 <code>GenerationConfig</code> 파일에서 별도로 지정하지 않으면, <code>generate</code>는 각 반복에서 가장 확률이 높은 토큰을 선택합니다(그리디 디코딩). 하려는 작업에 따라 이 방법은 바람직하지 않을 수 있습니다. 예를 들어, 챗봇이나 에세이 작성과 같은 창의적인 작업은 샘플링이 적합할 수 있습니다. 반면, 오디오를 텍스트로 변환하거나 번역과 같은 입력 기반 작업은 그리디 디코딩이 더 적합할 수 있습니다. <code>do_sample=True</code>로 샘플링을 활성화할 수 있으며, 이 주제에 대한 자세한 내용은 이 <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">블로그 포스트</a>에서 볼 수 있습니다.',te,lt,ee,st,le,at,Le='LLM은 <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">디코더 전용</a> 구조를 가지고 있어, 입력 프롬프트에 대해 지속적으로 반복 처리를 합니다. 입력 데이터의 길이가 다르면 패딩 작업이 필요합니다. LLM은 패딩 토큰에서 작동을 이어가도록 설계되지 않았기 때문에, 입력 왼쪽에 패딩이 추가 되어야 합니다. 그리고 어텐션 마스크도 꼭 <code>generate</code> 함수에 전달되어야 합니다!',se,nt,ae,pt,ne,it,He="자기회귀 생성 프로세스는 상대적으로 단순한 편이지만, LLM을 최대한 활용하려면 여러 가지 요소를 고려해야 하므로 쉽지 않을 수 있습니다. LLM에 대한 더 깊은 이해와 활용을 위한 다음 단계는 아래와 같습니다:",pe,ot,ie,mt,Fe='<li><a href="generation_strategies">가이드</a>는 다양한 생성 방법을 제어하는 방법, 생성 설정 파일을 설정하는 방법, 출력을 스트리밍하는 방법에 대해 설명합니다.</li> <li><code>GenerationConfig</code>와 <code>generate()</code>, <a href="internal/generation_utils">generate-related classes</a>를 참조해보세요.</li>',oe,rt,me,ct,Qe='<li><a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open LLM Leaderboard</a>는 오픈 소스 모델의 품질에 중점을 둡니다.</li> <li><a href="https://huggingface.co/spaces/optimum/llm-perf-leaderboard" rel="nofollow">Open LLM-Perf Leaderboard</a>는 LLM 처리량에 중점을 둡니다.</li>',re,gt,ce,Mt,qe='<li>메모리 요구 사항을 줄이려면, 동적 양자화에 대한 <a href="main_classes/quantization">가이드</a>를 참조하세요.</li>',ge,ut,Me,dt,Ee='<li><a href="https://github.com/huggingface/text-generation-inference" rel="nofollow"><code>text-generation-inference</code></a>는 LLM을 위한 실제 운영 환경에 적합한 서버입니다.</li> <li><a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a>은 특정 하드웨어 장치에서 LLM을 최적화하기 위해 🤗 Transformers를 확장한 것입니다.</li>',ue,ht,de;return w=new h({props:{title:"대규모 언어 모델로 생성하기",local:"generation-with-llms",headingTag:"h1"}}),U=new ll({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/llm_tutorial.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/llm_tutorial.ipynb"}]}}),W=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUyMC1x",highlighted:"pip install transformers bitsandbytes&gt;=0.39.0 -q",wrap:!1}}),C=new h({props:{title:"텍스트 생성",local:"generate-text",headingTag:"h2"}}),j=new el({props:{$$slots:{default:[sl]},$$scope:{ctx:ft}}}),B=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Q=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)`,wrap:!1}}),N=new T({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, black, white, and brown&#x27;</span>`,wrap:!1}}),S=new h({props:{title:"일반적으로 발생하는 문제",local:"common-pitfalls",headingTag:"h2"}}),P=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbiUyMCUyMCUyMyUyME1pc3RyYWwlMjBoYXMlMjBubyUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Mistral has no pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),K=new h({props:{title:"생성된 출력이 너무 짧거나 길다",local:"generated-output-is-too-shortlong",headingTag:"h3"}}),O=new T({props:{code:"bW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBzZXF1ZW5jZSUyMG9mJTIwbnVtYmVycyUzQSUyMDElMkMlMjAyJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBvdXRwdXQlMjB3aWxsJTIwY29udGFpbiUyMHVwJTIwdG8lMjAyMCUyMHRva2VucyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMHBhZF90b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMFNldHRpbmclMjAlNjBtYXhfbmV3X3Rva2VucyU2MCUyMGFsbG93cyUyMHlvdSUyMHRvJTIwY29udHJvbCUyMHRoZSUyMG1heGltdW0lMjBsZW5ndGglMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMlMkMlMjBwYWRfdG9rZW5faWQlM0R0b2tlbml6ZXIuZW9zX3Rva2VuX2lkJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A sequence of numbers: 1, 2&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the output will contain up to 20 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Setting \`max_new_tokens\` allows you to control the maximum length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, pad_token_id=tokenizer.eos_token_id, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,&#x27;</span>`,wrap:!1}}),tt=new h({props:{title:"잘못된 생성 모드",local:"incorrect-generation-mode",headingTag:"h3"}}),lt=new T({props:{code:"JTIzJTIwU2V0JTIwc2VlZCUyMG9yJTIwcmVwcm9kdWNpYmlsaXR5JTIwLS0lMjB5b3UlMjBkb24ndCUyMG5lZWQlMjB0aGlzJTIwdW5sZXNzJTIweW91JTIwd2FudCUyMGZ1bGwlMjByZXByb2R1Y2liaWxpdHklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwc2V0X3NlZWQlMEFzZXRfc2VlZCgwKSUwQSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJJJTIwYW0lMjBhJTIwY2F0LiUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwTExNJTIwJTJCJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjAlM0QlMjByZXBldGl0aXZlJTJDJTIwYm9yaW5nJTIwb3V0cHV0JTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBiZWNvbWVzJTIwbW9yZSUyMGNyZWF0aXZlISUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set seed or reproducibility -- you don&#x27;t need this unless you want full reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;I am a cat.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># LLM + greedy decoding = repetitive, boring output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat. I am a cat. I am a cat. I am a cat&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output becomes more creative!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat.\\nI just need to be. I am always.\\nEvery time&#x27;</span>`,wrap:!1}}),st=new h({props:{title:"잘못된 패딩",local:"wrong-padding-side",headingTag:"h3"}}),nt=new T({props:{code:"JTIzJTIwVGhlJTIwdG9rZW5pemVyJTIwaW5pdGlhbGl6ZWQlMjBhYm92ZSUyMGhhcyUyMHJpZ2h0LXBhZGRpbmclMjBhY3RpdmUlMjBieSUyMGRlZmF1bHQlM0ElMjB0aGUlMjAxc3QlMjBzZXF1ZW5jZSUyQyUwQSUyMyUyMHdoaWNoJTIwaXMlMjBzaG9ydGVyJTJDJTIwaGFzJTIwcGFkZGluZyUyMG9uJTIwdGhlJTIwcmlnaHQlMjBzaWRlLiUyMEdlbmVyYXRpb24lMjBmYWlscy4lMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwJTIyQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyQyUyMEUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwV2l0aCUyMGxlZnQtcGFkZGluZyUyQyUyMGl0JTIwd29ya3MlMjBhcyUyMGV4cGVjdGVkISUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5sbS1yZXNlYXJjaCUyRm9wZW5fbGxhbWFfN2IlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTIwJTIwJTIzJTIwTGxhbWElMjBoYXMlMjBubyUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUyMjElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMCUyMkElMkMlMjBCJTJDJTIwQyUyQyUyMEQlMkMlMjBFJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The tokenizer initialized above has right-padding active by default: the 1st sequence,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># which is shorter, has padding on the right side. Generation fails.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With left-padding, it works as expected!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Llama has no pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 3, 4, 5, 6,&#x27;</span>`,wrap:!1}}),pt=new h({props:{title:"추가 자료",local:"further-resources",headingTag:"h2"}}),ot=new h({props:{title:"고급 생성 사용",local:"advanced-generate-usage",headingTag:"h3"}}),rt=new h({props:{title:"LLM 리더보드",local:"llm-leaderboards",headingTag:"h3"}}),gt=new h({props:{title:"지연 시간 및 처리량",local:"latency-and-throughput",headingTag:"h3"}}),ut=new h({props:{title:"관련 라이브러리",local:"related-libraries",headingTag:"h3"}}),{c(){d=p("meta"),J=a(),y=p("p"),yt=a(),m(w.$$.fragment),bt=a(),m(U.$$.fragment),jt=a(),k=p("p"),k.textContent=he,Tt=a(),Z=p("p"),Z.innerHTML=fe,Jt=a(),$=p("p"),$.textContent=be,wt=a(),_=p("ul"),_.innerHTML=je,Ut=a(),v=p("p"),v.textContent=Te,kt=a(),m(W.$$.fragment),Zt=a(),m(C.$$.fragment),$t=a(),I=p("p"),I.innerHTML=Je,_t=a(),f=p("figure"),f.innerHTML=we,vt=a(),R=p("p"),R.textContent=Ue,Wt=a(),b=p("figure"),b.innerHTML=ke,Ct=a(),X=p("p"),X.textContent=Ze,It=a(),G=p("p"),G.innerHTML=$e,Rt=a(),V=p("p"),V.textContent=_e,Xt=a(),m(j.$$.fragment),Gt=a(),x=p("p"),x.textContent=ve,Vt=a(),m(B.$$.fragment),xt=a(),z=p("p"),z.innerHTML=We,Bt=a(),L=p("ul"),L.innerHTML=Ce,zt=a(),H=p("p"),H.textContent=Ie,Lt=a(),F=p("p"),F.innerHTML=Re,Ht=a(),m(Q.$$.fragment),Ft=a(),q=p("p"),q.innerHTML=Xe,Qt=a(),E=p("p"),E.innerHTML=Ge,qt=a(),m(N.$$.fragment),Et=a(),Y=p("p"),Y.textContent=Ve,Nt=a(),m(S.$$.fragment),Yt=a(),A=p("p"),A.innerHTML=xe,St=a(),m(P.$$.fragment),At=a(),m(K.$$.fragment),Pt=a(),D=p("p"),D.innerHTML=Be,Kt=a(),m(O.$$.fragment),Dt=a(),m(tt.$$.fragment),Ot=a(),et=p("p"),et.innerHTML=ze,te=a(),m(lt.$$.fragment),ee=a(),m(st.$$.fragment),le=a(),at=p("p"),at.innerHTML=Le,se=a(),m(nt.$$.fragment),ae=a(),m(pt.$$.fragment),ne=a(),it=p("p"),it.textContent=He,pe=a(),m(ot.$$.fragment),ie=a(),mt=p("ol"),mt.innerHTML=Fe,oe=a(),m(rt.$$.fragment),me=a(),ct=p("ol"),ct.innerHTML=Qe,re=a(),m(gt.$$.fragment),ce=a(),Mt=p("ol"),Mt.innerHTML=qe,ge=a(),m(ut.$$.fragment),Me=a(),dt=p("ol"),dt.innerHTML=Ee,ue=a(),ht=p("p"),this.h()},l(t){const e=Oe("svelte-u9bgzb",document.head);d=i(e,"META",{name:!0,content:!0}),e.forEach(l),J=n(t),y=i(t,"P",{}),Ye(y).forEach(l),yt=n(t),r(w.$$.fragment,t),bt=n(t),r(U.$$.fragment,t),jt=n(t),k=i(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1mqsb83"&&(k.textContent=he),Tt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-pz4xfn"&&(Z.innerHTML=fe),Jt=n(t),$=i(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-bstddc"&&($.textContent=be),wt=n(t),_=i(t,"UL",{"data-svelte-h":!0}),o(_)!=="svelte-n39m57"&&(_.innerHTML=je),Ut=n(t),v=i(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-18iigii"&&(v.textContent=Te),kt=n(t),r(W.$$.fragment,t),Zt=n(t),r(C.$$.fragment,t),$t=n(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1knuq7u"&&(I.innerHTML=Je),_t=n(t),f=i(t,"FIGURE",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-1e5pfoq"&&(f.innerHTML=we),vt=n(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1paz2ao"&&(R.textContent=Ue),Wt=n(t),b=i(t,"FIGURE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-e8zgh"&&(b.innerHTML=ke),Ct=n(t),X=i(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1jyajpb"&&(X.textContent=Ze),It=n(t),G=i(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1mz5903"&&(G.innerHTML=$e),Rt=n(t),V=i(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-139gs6l"&&(V.textContent=_e),Xt=n(t),r(j.$$.fragment,t),Gt=n(t),x=i(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1jlhxga"&&(x.textContent=ve),Vt=n(t),r(B.$$.fragment,t),xt=n(t),z=i(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-3pz7gp"&&(z.innerHTML=We),Bt=n(t),L=i(t,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-1b3d22e"&&(L.innerHTML=Ce),zt=n(t),H=i(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-r6qxit"&&(H.textContent=Ie),Lt=n(t),F=i(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-y9vwcs"&&(F.innerHTML=Re),Ht=n(t),r(Q.$$.fragment,t),Ft=n(t),q=i(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-128stuf"&&(q.innerHTML=Xe),Qt=n(t),E=i(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-t9jh1g"&&(E.innerHTML=Ge),qt=n(t),r(N.$$.fragment,t),Et=n(t),Y=i(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-uhj5p6"&&(Y.textContent=Ve),Nt=n(t),r(S.$$.fragment,t),Yt=n(t),A=i(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1efv58y"&&(A.innerHTML=xe),St=n(t),r(P.$$.fragment,t),At=n(t),r(K.$$.fragment,t),Pt=n(t),D=i(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-sc73j"&&(D.innerHTML=Be),Kt=n(t),r(O.$$.fragment,t),Dt=n(t),r(tt.$$.fragment,t),Ot=n(t),et=i(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-j4osa7"&&(et.innerHTML=ze),te=n(t),r(lt.$$.fragment,t),ee=n(t),r(st.$$.fragment,t),le=n(t),at=i(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1xvggc8"&&(at.innerHTML=Le),se=n(t),r(nt.$$.fragment,t),ae=n(t),r(pt.$$.fragment,t),ne=n(t),it=i(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1gtwjq2"&&(it.textContent=He),pe=n(t),r(ot.$$.fragment,t),ie=n(t),mt=i(t,"OL",{"data-svelte-h":!0}),o(mt)!=="svelte-5tvhf0"&&(mt.innerHTML=Fe),oe=n(t),r(rt.$$.fragment,t),me=n(t),ct=i(t,"OL",{"data-svelte-h":!0}),o(ct)!=="svelte-hea1r2"&&(ct.innerHTML=Qe),re=n(t),r(gt.$$.fragment,t),ce=n(t),Mt=i(t,"OL",{"data-svelte-h":!0}),o(Mt)!=="svelte-9s5g32"&&(Mt.innerHTML=qe),ge=n(t),r(ut.$$.fragment,t),Me=n(t),dt=i(t,"OL",{"data-svelte-h":!0}),o(dt)!=="svelte-st1yc"&&(dt.innerHTML=Ee),ue=n(t),ht=i(t,"P",{}),Ye(ht).forEach(l),this.h()},h(){ye(d,"name","hf:doc:metadata"),ye(d,"content",nl),ye(f,"class","image table text-center m-0 w-full"),ye(b,"class","image table text-center m-0 w-full")},m(t,e){tl(document.head,d),s(t,J,e),s(t,y,e),s(t,yt,e),c(w,t,e),s(t,bt,e),c(U,t,e),s(t,jt,e),s(t,k,e),s(t,Tt,e),s(t,Z,e),s(t,Jt,e),s(t,$,e),s(t,wt,e),s(t,_,e),s(t,Ut,e),s(t,v,e),s(t,kt,e),c(W,t,e),s(t,Zt,e),c(C,t,e),s(t,$t,e),s(t,I,e),s(t,_t,e),s(t,f,e),s(t,vt,e),s(t,R,e),s(t,Wt,e),s(t,b,e),s(t,Ct,e),s(t,X,e),s(t,It,e),s(t,G,e),s(t,Rt,e),s(t,V,e),s(t,Xt,e),c(j,t,e),s(t,Gt,e),s(t,x,e),s(t,Vt,e),c(B,t,e),s(t,xt,e),s(t,z,e),s(t,Bt,e),s(t,L,e),s(t,zt,e),s(t,H,e),s(t,Lt,e),s(t,F,e),s(t,Ht,e),c(Q,t,e),s(t,Ft,e),s(t,q,e),s(t,Qt,e),s(t,E,e),s(t,qt,e),c(N,t,e),s(t,Et,e),s(t,Y,e),s(t,Nt,e),c(S,t,e),s(t,Yt,e),s(t,A,e),s(t,St,e),c(P,t,e),s(t,At,e),c(K,t,e),s(t,Pt,e),s(t,D,e),s(t,Kt,e),c(O,t,e),s(t,Dt,e),c(tt,t,e),s(t,Ot,e),s(t,et,e),s(t,te,e),c(lt,t,e),s(t,ee,e),c(st,t,e),s(t,le,e),s(t,at,e),s(t,se,e),c(nt,t,e),s(t,ae,e),c(pt,t,e),s(t,ne,e),s(t,it,e),s(t,pe,e),c(ot,t,e),s(t,ie,e),s(t,mt,e),s(t,oe,e),c(rt,t,e),s(t,me,e),s(t,ct,e),s(t,re,e),c(gt,t,e),s(t,ce,e),s(t,Mt,e),s(t,ge,e),c(ut,t,e),s(t,Me,e),s(t,dt,e),s(t,ue,e),s(t,ht,e),de=!0},p(t,[e]){const Ne={};e&2&&(Ne.$$scope={dirty:e,ctx:t}),j.$set(Ne)},i(t){de||(g(w.$$.fragment,t),g(U.$$.fragment,t),g(W.$$.fragment,t),g(C.$$.fragment,t),g(j.$$.fragment,t),g(B.$$.fragment,t),g(Q.$$.fragment,t),g(N.$$.fragment,t),g(S.$$.fragment,t),g(P.$$.fragment,t),g(K.$$.fragment,t),g(O.$$.fragment,t),g(tt.$$.fragment,t),g(lt.$$.fragment,t),g(st.$$.fragment,t),g(nt.$$.fragment,t),g(pt.$$.fragment,t),g(ot.$$.fragment,t),g(rt.$$.fragment,t),g(gt.$$.fragment,t),g(ut.$$.fragment,t),de=!0)},o(t){M(w.$$.fragment,t),M(U.$$.fragment,t),M(W.$$.fragment,t),M(C.$$.fragment,t),M(j.$$.fragment,t),M(B.$$.fragment,t),M(Q.$$.fragment,t),M(N.$$.fragment,t),M(S.$$.fragment,t),M(P.$$.fragment,t),M(K.$$.fragment,t),M(O.$$.fragment,t),M(tt.$$.fragment,t),M(lt.$$.fragment,t),M(st.$$.fragment,t),M(nt.$$.fragment,t),M(pt.$$.fragment,t),M(ot.$$.fragment,t),M(rt.$$.fragment,t),M(gt.$$.fragment,t),M(ut.$$.fragment,t),de=!1},d(t){t&&(l(J),l(y),l(yt),l(bt),l(jt),l(k),l(Tt),l(Z),l(Jt),l($),l(wt),l(_),l(Ut),l(v),l(kt),l(Zt),l($t),l(I),l(_t),l(f),l(vt),l(R),l(Wt),l(b),l(Ct),l(X),l(It),l(G),l(Rt),l(V),l(Xt),l(Gt),l(x),l(Vt),l(xt),l(z),l(Bt),l(L),l(zt),l(H),l(Lt),l(F),l(Ht),l(Ft),l(q),l(Qt),l(E),l(qt),l(Et),l(Y),l(Nt),l(Yt),l(A),l(St),l(At),l(Pt),l(D),l(Kt),l(Dt),l(Ot),l(et),l(te),l(ee),l(le),l(at),l(se),l(ae),l(ne),l(it),l(pe),l(ie),l(mt),l(oe),l(me),l(ct),l(re),l(ce),l(Mt),l(ge),l(Me),l(dt),l(ue),l(ht)),l(d),u(w,t),u(U,t),u(W,t),u(C,t),u(j,t),u(B,t),u(Q,t),u(N,t),u(S,t),u(P,t),u(K,t),u(O,t),u(tt,t),u(lt,t),u(st,t),u(nt,t),u(pt,t),u(ot,t),u(rt,t),u(gt,t),u(ut,t)}}}const nl='{"title":"대규모 언어 모델로 생성하기","local":"generation-with-llms","sections":[{"title":"텍스트 생성","local":"generate-text","sections":[],"depth":2},{"title":"일반적으로 발생하는 문제","local":"common-pitfalls","sections":[{"title":"생성된 출력이 너무 짧거나 길다","local":"generated-output-is-too-shortlong","sections":[],"depth":3},{"title":"잘못된 생성 모드","local":"incorrect-generation-mode","sections":[],"depth":3},{"title":"잘못된 패딩","local":"wrong-padding-side","sections":[],"depth":3}],"depth":2},{"title":"추가 자료","local":"further-resources","sections":[{"title":"고급 생성 사용","local":"advanced-generate-usage","sections":[],"depth":3},{"title":"LLM 리더보드","local":"llm-leaderboards","sections":[],"depth":3},{"title":"지연 시간 및 처리량","local":"latency-and-throughput","sections":[],"depth":3},{"title":"관련 라이브러리","local":"related-libraries","sections":[],"depth":3}],"depth":2}],"depth":1}';function pl(ft){return Ae(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ml extends Ke{constructor(d){super(),De(this,d,pl,al,Se,{})}}export{Ml as component};
