import{s as Fs,n as Qs,o as Ps}from"../chunks/scheduler.9bc65507.js";import{S as qs,i as Ks,g as p,s as a,r as m,A as As,h as J,f as t,c as n,j as Xs,u as T,x as i,k as vs,y as Os,a as l,v as w,d as o,t as c,w as r}from"../chunks/index.707bf1b6.js";import{C as u}from"../chunks/CodeBlock.54a9f38d.js";import{D as se}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as ee}from"../chunks/Heading.342b1fa6.js";function te(Vs){let M,P,F,q,b,K,g,A,y,ks="Image-to-Image タスクは、アプリケーションが画像を受信し、別の画像を出力するタスクです。これには、画像強化 (超解像度、低光量強化、ディレインなど)、画像修復などを含むさまざまなサブタスクがあります。",O,d,Zs="このガイドでは、次の方法を説明します。",ss,f,Ws="<li>超解像度タスクに画像間のパイプラインを使用します。</li> <li>パイプラインを使用せずに、同じタスクに対してイメージ間モデルを実行します。</li>",es,j,xs="このガイドがリリースされた時点では、<code>image-to-image</code>パイプラインは超解像度タスクのみをサポートしていることに注意してください。",ts,$,Ds="必要なライブラリをインストールすることから始めましょう。",ls,C,as,U,Ns='<a href="https://huggingface.co/caidas/swin2SR-lightweight-x2-64" rel="nofollow">Swin2SR モデル</a> を使用してパイプラインを初期化できるようになりました。次に、イメージを使用してパイプラインを呼び出すことで、パイプラインを推論できます。現時点では、<a href="https://huggingface.co/models?sort=trending&amp;search=swin2sr" rel="nofollow">Swin2SR モデル</a> のみがこのパイプラインでサポートされています。',ns,v,ps,V,_s="では、画像を読み込みましょう。",Js,k,is,Z,ms,I,Gs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg" alt="Photo of a cat"/>',Ts,W,Ss="これで、パイプラインを使用して推論を実行できるようになりました。猫の画像の拡大バージョンを取得します。",ws,x,os,D,cs,N,zs="パイプラインを使用せずに自分で推論を実行したい場合は、トランスフォーマーの <code>Swin2SRForImageSuperResolution</code> クラスと <code>Swin2SRImageProcessor</code> クラスを使用できます。これには同じモデルのチェックポイントを使用します。モデルとプロセッサを初期化しましょう。",rs,_,us,G,Bs="<code>pipeline</code>」は、自分で行う必要がある前処理と後処理のステップを抽象化するので、画像を前処理しましょう。画像をプロセッサに渡してから、ピクセル値を GPU に移動します。",Ms,S,Is,z,Hs="これで、ピクセル値をモデルに渡すことで画像を推測できるようになりました。",hs,B,bs,H,Rs="出力は、以下のような <code>ImageSuperResolutionOutput</code> タイプのオブジェクトです 👇",gs,R,ys,Y,Ys="<code>reconstruction</code>を取得し、それを視覚化するために後処理する必要があります。どのように見えるか見てみましょう。",ds,E,fs,L,Es="出力を圧縮して軸 0 を削除し、値をクリップしてから、それを numpy float に変換する必要があります。次に、軸を [1072, 880] の形状になるように配置し、最後に出力を範囲 [0, 255] に戻します。",js,X,$s,h,Ls='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat_upscaled.png" alt="Upscaled photo of a cat"/>',Cs,Q,Us;return b=new ee({props:{title:"Image-to-Image Task Guide",local:"image-to-image-task-guide",headingTag:"h1"}}),g=new se({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/image_to_image.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/image_to_image.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/image_to_image.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/image_to_image.ipynb"}]}}),C=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),v=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCdjdWRhJyUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAnY3B1JyklMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXRvLWltYWdlJTIyJTJDJTIwbW9kZWwlM0QlMjJjYWlkYXMlMkZzd2luMlNSLWxpZ2h0d2VpZ2h0LXgyLTY0JTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)
pipe = pipeline(task=<span class="hljs-string">&quot;image-to-image&quot;</span>, model=<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>, device=device)`,wrap:!1}}),k=new u({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmNhdC5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmludChpbWFnZS5zaXplKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-built_in">print</span>(image.size)`,wrap:!1}}),Z=new u({props:{code:"JTIzJTIwKDUzMiUyQyUyMDQzMik=",highlighted:'<span class="hljs-comment"># (532, 432)</span>',wrap:!1}}),x=new u({props:{code:"dXBzY2FsZWQlMjAlM0QlMjBwaXBlKGltYWdlKSUwQXByaW50KHVwc2NhbGVkLnNpemUp",highlighted:`upscaled = pipe(image)
<span class="hljs-built_in">print</span>(upscaled.size)`,wrap:!1}}),D=new u({props:{code:"JTIzJTIwKDEwNzIlMkMlMjA4ODAp",highlighted:'<span class="hljs-comment"># (1072, 880)</span>',wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW4yU1JGb3JJbWFnZVN1cGVyUmVzb2x1dGlvbiUyQyUyMFN3aW4yU1JJbWFnZVByb2Nlc3NvciUyMCUwQSUwQW1vZGVsJTIwJTNEJTIwU3dpbjJTUkZvckltYWdlU3VwZXJSZXNvbHV0aW9uLmZyb21fcHJldHJhaW5lZCglMjJjYWlkYXMlMkZzd2luMlNSLWxpZ2h0d2VpZ2h0LXgyLTY0JTIyKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwU3dpbjJTUkltYWdlUHJvY2Vzc29yKCUyMmNhaWRhcyUyRnN3aW4yU1ItbGlnaHR3ZWlnaHQteDItNjQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Swin2SRForImageSuperResolution, Swin2SRImageProcessor 

model = Swin2SRForImageSuperResolution.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>).to(device)
processor = Swin2SRImageProcessor(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>)`,wrap:!1}}),S=new u({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVzJTBBcHJpbnQocGl4ZWxfdmFsdWVzLnNoYXBlKSUwQSUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMHBpeGVsX3ZhbHVlcy50byhkZXZpY2Up",highlighted:`pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-built_in">print</span>(pixel_values.shape)

pixel_values = pixel_values.to(device)`,wrap:!1}}),B=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">with</span> torch.no_grad():
  outputs = model(pixel_values)`,wrap:!1}}),R=new u({props:{code:"KGxvc3MlM0ROb25lJTJDJTIwcmVjb25zdHJ1Y3Rpb24lM0R0ZW5zb3IoJTVCJTVCJTVCJTVCMC44MjcwJTJDJTIwMC44MjY5JTJDJTIwMC44Mjc1JTJDJTIwJTIwLi4uJTJDJTIwMC43NDYzJTJDJTIwMC43NDQ2JTJDJTIwMC43NDUzJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44Mjg3JTJDJTIwMC44Mjc4JTJDJTIwMC44MjgzJTJDJTIwJTIwLi4uJTJDJTIwMC43NDUxJTJDJTIwMC43NDQ4JTJDJTIwMC43NDU3JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44MjgwJTJDJTIwMC44MjczJTJDJTIwMC44MjY5JTJDJTIwJTIwLi4uJTJDJTIwMC43NDQ3JTJDJTIwMC43NDQ2JTJDJTIwMC43NDUyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTIzJTJDJTIwMC41OTMzJTJDJTIwMC41OTI0JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjk3JTJDJTIwMC4wNjk1JTJDJTIwMC4wNzA2JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI2JTJDJTIwMC41OTMyJTJDJTIwMC41OTI2JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjczJTJDJTIwMC4wNjg3JTJDJTIwMC4wNzA1JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI3JTJDJTIwMC41OTE0JTJDJTIwMC41OTIyJTJDJTIwJTIwLi4uJTJDJTIwMC4wNjY0JTJDJTIwMC4wNjk0JTJDJTIwMC4wNzE4JTVEJTVEJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGV2aWNlJTNEJ2N1ZGElM0EwJyklMkMlMjBoaWRkZW5fc3RhdGVzJTNETm9uZSUyQyUyMGF0dGVudGlvbnMlM0ROb25lKQ==",highlighted:`(<span class="hljs-name">loss=None</span>, reconstruction=tensor([[[[<span class="hljs-name">0.8270</span>, <span class="hljs-number">0.8269</span>, <span class="hljs-number">0.8275</span>,  ..., <span class="hljs-number">0.7463</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7453</span>],
          [<span class="hljs-name">0.8287</span>, <span class="hljs-number">0.8278</span>, <span class="hljs-number">0.8283</span>,  ..., <span class="hljs-number">0.7451</span>, <span class="hljs-number">0.7448</span>, <span class="hljs-number">0.7457</span>],
          [<span class="hljs-name">0.8280</span>, <span class="hljs-number">0.8273</span>, <span class="hljs-number">0.8269</span>,  ..., <span class="hljs-number">0.7447</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7452</span>],
          ...,
          [<span class="hljs-name">0.5923</span>, <span class="hljs-number">0.5933</span>, <span class="hljs-number">0.5924</span>,  ..., <span class="hljs-number">0.0697</span>, <span class="hljs-number">0.0695</span>, <span class="hljs-number">0.0706</span>],
          [<span class="hljs-name">0.5926</span>, <span class="hljs-number">0.5932</span>, <span class="hljs-number">0.5926</span>,  ..., <span class="hljs-number">0.0673</span>, <span class="hljs-number">0.0687</span>, <span class="hljs-number">0.0705</span>],
          [<span class="hljs-name">0.5927</span>, <span class="hljs-number">0.5914</span>, <span class="hljs-number">0.5922</span>,  ..., <span class="hljs-number">0.0664</span>, <span class="hljs-number">0.0694</span>, <span class="hljs-number">0.0718</span>]]]],
       device=<span class="hljs-symbol">&#x27;cuda:0</span>&#x27;), hidden_states=None, attentions=None)`,wrap:!1}}),E=new u({props:{code:"b3V0cHV0cy5yZWNvbnN0cnVjdGlvbi5kYXRhLnNoYXBlJTBBJTIzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwMyUyQyUyMDg4MCUyQyUyMDEwNzIlNUQp",highlighted:`outputs.reconstruction.data.shape
<span class="hljs-comment"># torch.Size([1, 3, 880, 1072])</span>`,wrap:!1}}),X=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTIzJTIwc3F1ZWV6ZSUyQyUyMHRha2UlMjB0byUyMENQVSUyMGFuZCUyMGNsaXAlMjB0aGUlMjB2YWx1ZXMlMEFvdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnJlY29uc3RydWN0aW9uLmRhdGEuc3F1ZWV6ZSgpLmNwdSgpLmNsYW1wXygwJTJDJTIwMSkubnVtcHkoKSUwQSUyMyUyMHJlYXJyYW5nZSUyMHRoZSUyMGF4ZXMlMEFvdXRwdXQlMjAlM0QlMjBucC5tb3ZlYXhpcyhvdXRwdXQlMkMlMjBzb3VyY2UlM0QwJTJDJTIwZGVzdGluYXRpb24lM0QtMSklMEElMjMlMjBicmluZyUyMHZhbHVlcyUyMGJhY2slMjB0byUyMHBpeGVsJTIwdmFsdWVzJTIwcmFuZ2UlMEFvdXRwdXQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NS4wKS5yb3VuZCgpLmFzdHlwZShucC51aW50OCklMEFJbWFnZS5mcm9tYXJyYXkob3V0cHV0KQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-comment"># squeeze, take to CPU and clip the values</span>
output = outputs.reconstruction.data.squeeze().cpu().clamp_(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).numpy()
<span class="hljs-comment"># rearrange the axes</span>
output = np.moveaxis(output, source=<span class="hljs-number">0</span>, destination=-<span class="hljs-number">1</span>)
<span class="hljs-comment"># bring values back to pixel values range</span>
output = (output * <span class="hljs-number">255.0</span>).<span class="hljs-built_in">round</span>().astype(np.uint8)
Image.fromarray(output)`,wrap:!1}}),{c(){M=p("meta"),P=a(),F=p("p"),q=a(),m(b.$$.fragment),K=a(),m(g.$$.fragment),A=a(),y=p("p"),y.textContent=ks,O=a(),d=p("p"),d.textContent=Zs,ss=a(),f=p("ul"),f.innerHTML=Ws,es=a(),j=p("p"),j.innerHTML=xs,ts=a(),$=p("p"),$.textContent=Ds,ls=a(),m(C.$$.fragment),as=a(),U=p("p"),U.innerHTML=Ns,ns=a(),m(v.$$.fragment),ps=a(),V=p("p"),V.textContent=_s,Js=a(),m(k.$$.fragment),is=a(),m(Z.$$.fragment),ms=a(),I=p("div"),I.innerHTML=Gs,Ts=a(),W=p("p"),W.textContent=Ss,ws=a(),m(x.$$.fragment),os=a(),m(D.$$.fragment),cs=a(),N=p("p"),N.innerHTML=zs,rs=a(),m(_.$$.fragment),us=a(),G=p("p"),G.innerHTML=Bs,Ms=a(),m(S.$$.fragment),Is=a(),z=p("p"),z.textContent=Hs,hs=a(),m(B.$$.fragment),bs=a(),H=p("p"),H.innerHTML=Rs,gs=a(),m(R.$$.fragment),ys=a(),Y=p("p"),Y.innerHTML=Ys,ds=a(),m(E.$$.fragment),fs=a(),L=p("p"),L.textContent=Es,js=a(),m(X.$$.fragment),$s=a(),h=p("div"),h.innerHTML=Ls,Cs=a(),Q=p("p"),this.h()},l(s){const e=As("svelte-u9bgzb",document.head);M=J(e,"META",{name:!0,content:!0}),e.forEach(t),P=n(s),F=J(s,"P",{}),Xs(F).forEach(t),q=n(s),T(b.$$.fragment,s),K=n(s),T(g.$$.fragment,s),A=n(s),y=J(s,"P",{"data-svelte-h":!0}),i(y)!=="svelte-14nol8g"&&(y.textContent=ks),O=n(s),d=J(s,"P",{"data-svelte-h":!0}),i(d)!=="svelte-w5jzhi"&&(d.textContent=Zs),ss=n(s),f=J(s,"UL",{"data-svelte-h":!0}),i(f)!=="svelte-52qlo5"&&(f.innerHTML=Ws),es=n(s),j=J(s,"P",{"data-svelte-h":!0}),i(j)!=="svelte-1f09j1d"&&(j.innerHTML=xs),ts=n(s),$=J(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-bi939q"&&($.textContent=Ds),ls=n(s),T(C.$$.fragment,s),as=n(s),U=J(s,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1nmdbbs"&&(U.innerHTML=Ns),ns=n(s),T(v.$$.fragment,s),ps=n(s),V=J(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1ruqgai"&&(V.textContent=_s),Js=n(s),T(k.$$.fragment,s),is=n(s),T(Z.$$.fragment,s),ms=n(s),I=J(s,"DIV",{class:!0,"data-svelte-h":!0}),i(I)!=="svelte-muvbux"&&(I.innerHTML=Gs),Ts=n(s),W=J(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1l1e3c8"&&(W.textContent=Ss),ws=n(s),T(x.$$.fragment,s),os=n(s),T(D.$$.fragment,s),cs=n(s),N=J(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-12xsaja"&&(N.innerHTML=zs),rs=n(s),T(_.$$.fragment,s),us=n(s),G=J(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-au1zpx"&&(G.innerHTML=Bs),Ms=n(s),T(S.$$.fragment,s),Is=n(s),z=J(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1h8u7p9"&&(z.textContent=Hs),hs=n(s),T(B.$$.fragment,s),bs=n(s),H=J(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-8f2hg7"&&(H.innerHTML=Rs),gs=n(s),T(R.$$.fragment,s),ys=n(s),Y=J(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-15tky0s"&&(Y.innerHTML=Ys),ds=n(s),T(E.$$.fragment,s),fs=n(s),L=J(s,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1o03zk3"&&(L.textContent=Es),js=n(s),T(X.$$.fragment,s),$s=n(s),h=J(s,"DIV",{class:!0,"data-svelte-h":!0}),i(h)!=="svelte-1u1oaeg"&&(h.innerHTML=Ls),Cs=n(s),Q=J(s,"P",{}),Xs(Q).forEach(t),this.h()},h(){vs(M,"name","hf:doc:metadata"),vs(M,"content",le),vs(I,"class","flex justify-center"),vs(h,"class","flex justify-center")},m(s,e){Os(document.head,M),l(s,P,e),l(s,F,e),l(s,q,e),w(b,s,e),l(s,K,e),w(g,s,e),l(s,A,e),l(s,y,e),l(s,O,e),l(s,d,e),l(s,ss,e),l(s,f,e),l(s,es,e),l(s,j,e),l(s,ts,e),l(s,$,e),l(s,ls,e),w(C,s,e),l(s,as,e),l(s,U,e),l(s,ns,e),w(v,s,e),l(s,ps,e),l(s,V,e),l(s,Js,e),w(k,s,e),l(s,is,e),w(Z,s,e),l(s,ms,e),l(s,I,e),l(s,Ts,e),l(s,W,e),l(s,ws,e),w(x,s,e),l(s,os,e),w(D,s,e),l(s,cs,e),l(s,N,e),l(s,rs,e),w(_,s,e),l(s,us,e),l(s,G,e),l(s,Ms,e),w(S,s,e),l(s,Is,e),l(s,z,e),l(s,hs,e),w(B,s,e),l(s,bs,e),l(s,H,e),l(s,gs,e),w(R,s,e),l(s,ys,e),l(s,Y,e),l(s,ds,e),w(E,s,e),l(s,fs,e),l(s,L,e),l(s,js,e),w(X,s,e),l(s,$s,e),l(s,h,e),l(s,Cs,e),l(s,Q,e),Us=!0},p:Qs,i(s){Us||(o(b.$$.fragment,s),o(g.$$.fragment,s),o(C.$$.fragment,s),o(v.$$.fragment,s),o(k.$$.fragment,s),o(Z.$$.fragment,s),o(x.$$.fragment,s),o(D.$$.fragment,s),o(_.$$.fragment,s),o(S.$$.fragment,s),o(B.$$.fragment,s),o(R.$$.fragment,s),o(E.$$.fragment,s),o(X.$$.fragment,s),Us=!0)},o(s){c(b.$$.fragment,s),c(g.$$.fragment,s),c(C.$$.fragment,s),c(v.$$.fragment,s),c(k.$$.fragment,s),c(Z.$$.fragment,s),c(x.$$.fragment,s),c(D.$$.fragment,s),c(_.$$.fragment,s),c(S.$$.fragment,s),c(B.$$.fragment,s),c(R.$$.fragment,s),c(E.$$.fragment,s),c(X.$$.fragment,s),Us=!1},d(s){s&&(t(P),t(F),t(q),t(K),t(A),t(y),t(O),t(d),t(ss),t(f),t(es),t(j),t(ts),t($),t(ls),t(as),t(U),t(ns),t(ps),t(V),t(Js),t(is),t(ms),t(I),t(Ts),t(W),t(ws),t(os),t(cs),t(N),t(rs),t(us),t(G),t(Ms),t(Is),t(z),t(hs),t(bs),t(H),t(gs),t(ys),t(Y),t(ds),t(fs),t(L),t(js),t($s),t(h),t(Cs),t(Q)),t(M),r(b,s),r(g,s),r(C,s),r(v,s),r(k,s),r(Z,s),r(x,s),r(D,s),r(_,s),r(S,s),r(B,s),r(R,s),r(E,s),r(X,s)}}}const le='{"title":"Image-to-Image Task Guide","local":"image-to-image-task-guide","sections":[],"depth":1}';function ae(Vs){return Ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Te extends qs{constructor(M){super(),Ks(this,M,ae,te,Fs,{})}}export{Te as component};
