import{s as k1,o as A1,n as R1}from"../chunks/scheduler.9bc65507.js";import{S as V1,i as X1,g as p,s as n,r as f,A as z1,h as a,f as l,c as i,j as B1,u as M,x as P,k as Z1,y as F1,a as s,v as u,d as x,t as r,w as T}from"../chunks/index.707bf1b6.js";import{T as O1}from"../chunks/Tip.c2ecdbf4.js";import{C as Hl}from"../chunks/CodeBlock.54a9f38d.js";import{H as C}from"../chunks/Heading.342b1fa6.js";function W1(gl){let v,h='<strong>注意</strong>: <a href="perf_train_gpu_one">単一GPUセクション</a> で紹介された多くの戦略（混合精度トレーニングや勾配蓄積など）は一般的であり、モデルのトレーニングに一般的に適用されます。したがって、マルチGPUやCPUトレーニングなどの次のセクションに入る前に、それを確認してください。';return{c(){v=p("p"),v.innerHTML=h},l(m){v=a(m,"P",{"data-svelte-h":!0}),P(v)!=="svelte-178vvsa"&&(v.innerHTML=h)},m(m,Gl){s(m,v,Gl)},p:R1,d(m){m&&l(v)}}}function Y1(gl){let v,h,m,Gl,U,$l,_,zi="単一のGPUでのトレーニングが遅すぎる場合や、モデルの重みが単一のGPUのメモリに収まらない場合、複数のGPUを使用したセットアップが必要となります。単一のGPUから複数のGPUへの切り替えには、ワークロードを分散するためのある種の並列処理が必要です。データ、テンソル、またはパイプラインの並列処理など、さまざまな並列処理技術があります。ただし、すべてに適した一つの解決策は存在せず、最適な設定は使用するハードウェアに依存します。この記事は、おそらく他のフレームワークにも適用される主要な概念に焦点を当てつつ、PyTorchベースの実装に焦点を当てています。",Sl,o,Nl,j,Fi="まず、さまざまな1D並列処理技術とその利点および欠点について詳しく説明し、それらを2Dおよび3D並列処理に組み合わせてさらに高速なトレーニングを実現し、より大きなモデルをサポートする方法を検討します。さまざまな他の強力な代替手法も紹介されます。",Il,w,El,L,Oi="以下は、この文書で後で詳しく説明される主要な概念の簡単な説明です。",Ql,c,Wi="<li><strong>DataParallel (DP)</strong> - 同じセットアップが複数回複製され、各セットアップにデータのスライスが供給されます。処理は並行して行われ、各セットアップはトレーニングステップの最後に同期されます。</li> <li><strong>TensorParallel (TP)</strong> - 各テンソルは複数のチャンクに分割され、単一のGPUにテンソル全体が存在するのではなく、テンソルの各シャードが指定されたGPUに存在します。処理中に、各シャードは別々に並行して処理され、異なるGPUで同期され、ステップの最後に結果が同期されます。これは水平並列処理と呼ばれるもので、分割は水平レベルで行われます。</li> <li><strong>PipelineParallel (PP)</strong> - モデルは垂直（レイヤーレベル）に複数のGPUに分割され、モデルの単一または複数のレイヤーが単一のGPUに配置されます。各GPUはパイプラインの異なるステージを並行して処理し、バッチの小さなチャンクで作業します。</li> <li><strong>Zero Redundancy Optimizer (ZeRO)</strong> - TPといくらか似たようなテンソルのシャーディングを実行しますが、前向きまたは後向きの計算のためにテンソル全体が再構築されるため、モデルを変更する必要はありません。また、GPUメモリが制限されている場合に補償するためのさまざまなオフロード技術をサポートします。</li> <li><strong>Sharded DDP</strong> - Sharded DDPは、さまざまなZeRO実装で使用される基本的なZeROコンセプトの別名です。</li>",Bl,d,Yi="各コンセプトの詳細に深入りする前に、大規模なインフラストラクチャで大規模なモデルをトレーニングする際の大まかな決定プロセスを見てみましょう。",Zl,b,kl,y,qi="<strong>⇨ シングルノード / マルチGPU</strong>",Al,D,Ki="<li><p>モデルが単一のGPUに収まる場合：</p> <ol><li>DDP - 分散データ並列</li> <li>ZeRO - 状況と使用される構成に応じて速いかどうかが異なります</li></ol></li> <li><p>モデルが単一のGPUに収まらない場合：</p> <ol><li><p>PP</p></li> <li><p>ZeRO</p></li> <li><p>TP</p> <p>非常に高速なノード内接続（NVLINKまたはNVSwitchなど）があれば、これらの3つはほぼ同じ速度になるはずで、これらがない場合、PPはTPまたはZeROよりも速くなります。TPの程度も差を生じるかもしれません。特定のセットアップでの勝者を見つけるために実験することが最善です。</p> <p>TPはほとんどの場合、単一ノード内で使用されます。つまり、TPサイズ &lt;= ノードごとのGPU数です。</p></li></ol></li> <li><p>最大のレイヤーが単一のGPUに収まらない場合：</p> <ol><li>ZeROを使用しない場合 - TPを使用する必要があります。PP単独では収まらないでしょう。</li> <li>ZeROを使用する場合 - “シングルGPU”のエントリと同じものを参照してください</li></ol></li>",Rl,G,tp="<strong>⇨ マルチノード / マルチGPU</strong>",Vl,J,ep="<li><p>ノード間の高速接続がある場合：</p> <ol><li>ZeRO - モデルへのほとんどの変更が不要です</li> <li>PP+TP+DP - 通信が少なく、モデルへの大規模な変更が必要です</li></ol></li> <li><p>ノード間の接続が遅く、GPUメモリがまだ不足している場合：</p> <ol><li>DP+PP+TP+ZeRO-1</li></ol></li>",Xl,H,zl,g,lp='2つのGPUを持つほとんどのユーザーは、<code>DataParallel</code>（DP）と<code>DistributedDataParallel</code>（DDP）によって提供されるトレーニング速度の向上をすでに享受しています。これらはほぼ自明に使用できるPyTorchの組み込み機能です。一般的に、すべてのモデルで動作するDDPを使用することをお勧めします。DPは一部のモデルで失敗する可能性があるためです。<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">PyTorchのドキュメンテーション</a>自体もDDPの使用を推奨しています。',Fl,$,Ol,S,sp="<code>DistributedDataParallel</code>（DDP）は通常、<code>DataParallel</code>（DP）よりも高速ですが、常にそうとは限りません：",Wl,N,np="<li>DPはPythonスレッドベースですが、DDPはマルチプロセスベースです。そのため、GIL（Global Interpreter Lock）などのPythonスレッドの制約がないためです。</li> <li>一方、GPUカード間の遅い相互接続性は、DDPの場合に実際には遅い結果をもたらす可能性があります。</li>",Yl,I,ip="以下は、2つのモード間のGPU間通信の主な違いです：",ql,E,pp='<a href="https://pytorch.org/docs/master/notes/ddp.html" rel="nofollow">DDP</a>:',Kl,Q,ap="<li>開始時、メインプロセスはモデルをGPU 0から他のGPUに複製します。</li> <li>それから各バッチごとに:<ol><li>各GPUは各自のミニバッチのデータを直接消費します。</li> <li><code>backward</code>中、ローカル勾配が準備できると、それらはすべてのプロセスで平均化されます。</li></ol></li>",ts,B,Pp='<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">DP</a>:',es,Z,fp="各バッチごとに:",ls,k,Mp="<li>GPU 0はデータバッチを読み取り、それから各GPUにミニバッチを送信します。</li> <li>GPU 0から各GPUに最新のモデルを複製します。</li> <li><code>forward</code>を実行し、各GPUからGPU 0に出力を送信し、損失を計算します。</li> <li>GPU 0からすべてのGPUに損失を分散し、<code>backward</code>を実行します。</li> <li>各GPUからGPU 0に勾配を送信し、それらを平均化します。</li>",ss,A,up="DDPはバッチごとに行う通信は勾配の送信のみであり、一方、DPはバッチごとに5つの異なるデータ交換を行います。",ns,R,xp='DPはプロセス内でデータをPythonスレッドを介してコピーしますが、DDPは<a href="https://pytorch.org/docs/master/distributed.html" rel="nofollow">torch.distributed</a>を介してデータをコピーします。',is,V,rp="DPではGPU 0は他のGPUよりもはるかに多くの作業を行うため、GPUの未使用率が高くなります。",ps,X,Tp="DDPは複数のマシン間で使用できますが、DPの場合はそうではありません。",as,z,vp="DPとDDPの他にも違いがありますが、この議論には関係ありません。",Ps,F,Cp='これら2つのモードを深く理解したい場合、この<a href="https://www.telesens.co/2019/04/04/distributed-data-parallel-training-using-pytorch-on-aws/" rel="nofollow">記事</a>を強くお勧めします。素晴らしいダイアグラムを含み、さまざまなハードウェアでの複数のベンチマークとプロファイラの出力を示し、知っておく必要があるすべての微妙なニュアンスを説明しています。',fs,O,mp="実際のベンチマークを見てみましょう：",Ms,W,op='<thead><tr><th align="left">Type</th> <th>NVlink</th> <th align="right">Time</th></tr></thead> <tbody><tr><td align="left">2:DP</td> <td>Y</td> <td align="right">110s</td></tr> <tr><td align="left">2:DDP</td> <td>Y</td> <td align="right">101s</td></tr> <tr><td align="left">2:DDP</td> <td>N</td> <td align="right">131s</td></tr></tbody>',us,Y,hp="解析：",xs,q,Up="ここで、DPはNVlinkを使用したDDPに比べて約10％遅く、NVlinkを使用しないDDPに比べて約15％高速であることが示されています。",rs,K,_p="実際の違いは、各GPUが他のGPUと同期する必要があるデータの量に依存します。同期するデータが多いほど、遅いリンクが合計の実行時間を遅くする可能性が高くなります。",Ts,tt,jp="以下は完全なベンチマークコードと出力です：",vs,et,wp="<code>NCCL_P2P_DISABLE=1</code>を使用して、対応するベンチマークでNVLink機能を無効にしました。",Cs,lt,ms,st,Lp="ハードウェア: 2x TITAN RTX、各24GB + 2つのNVLink（<code>nvidia-smi topo -m</code>で <code>NV2</code>）",os,nt,cp="ソフトウェア: <code>pytorch-1.8-to-be</code> + <code>cuda-11.0</code> / <code>transformers==4.3.0.dev0</code>",hs,it,Us,pt,dp=`ZeROパワードデータ並列処理（ZeRO-DP）は、次の<a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">ブログ投稿</a>のダイアグラムで説明されています。
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="DeepSpeed-Image-1"/>`,_s,at,bp="これは理解が難しいかもしれませんが、実際にはこの概念は非常にシンプルです。これは通常の<code>DataParallel</code>（DP）ですが、完全なモデルパラメータ、勾配、およびオプティマイザの状態を複製する代わりに、各GPUはそれぞれのスライスのみを保存します。そして、実行時に、特定のレイヤーに必要な完全なレイヤーパラメータが必要な場合、すべてのGPUが同期して、お互いに不足している部分を提供します。それがすべてです。",js,Pt,yp="3つのレイヤーからなる単純なモデルを考えてみましょう。各レイヤーには3つのパラメータがあります：",ws,ft,Ls,Mt,Dp="レイヤーLaには、重みa0、a1、およびa2があります。",cs,ut,Gp="3つのGPUがある場合、Sharded DDP（= Zero-DP）はモデルを3つのGPUに次のように分割します：",ds,xt,bs,rt,Jp="これは、典型的なディープニューラルネットワーク（DNN）のダイアグラムを想像すると、テンソル並列処理と同様の水平スライスであるようなものです。垂直スライスは、異なるGPUに完全な層グループを配置する方法です。しかし、これは単なる出発点に過ぎません。",ys,Tt,Hp="これから、各GPUは通常のデータ並列処理（DP）と同様に、通常のミニバッチを受け取ります：",Ds,vt,Gs,Ct,gp="最初に、入力データはレイヤーLaに適用されます。",Js,mt,$p="GPU0に焦点を当てましょう：x0は、その前向きパスを実行するためにa0、a1、a2のパラメータが必要ですが、GPU0にはa0しかありません。GPU1からa1を、GPU2からa2を受け取り、モデルの各部分をまとめます。",Hs,ot,Sp="同様に、GPU1はミニバッチx1を受け取り、a1しか持っていませんが、a0とa2のパラメータが必要です。これらはGPU0とGPU2から取得します。",gs,ht,Np="GPU2もx2を受け取ります。a0とa1はGPU0とGPU1から受け取り、a2とともに完全なテンソルを再構築します。",$s,Ut,Ip="3つのGPUは完全なテンソルを再構築し、前向き計算が行われます。",Ss,_t,Ep="計算が完了すると、不要になったデータは削除されます。計算中だけ使用され、再構築は事前にフェッチを使用して効率的に行われます。",Ns,jt,Qp="そして、このプロセス全体がレイヤーLb、次に前向きでLc、そして逆方向でLc -> Lb -> Laに対して繰り返されます。",Is,wt,Bp="私にとって、これは効率的なグループでの重みの分散戦略のように聞こえます：",Es,Lt,Zp="<li>人Aはテントを持っています。</li> <li>人Bはストーブを持っています。</li> <li>人Cは斧を持っています。</li>",Qs,ct,kp="今、彼らは毎晩持っているものを共有し、他の人から持っていないものをもらい、朝には割り当てられたタイプのギアを詰めて旅を続けます。これがSharded DDP / Zero DPです。",Bs,dt,Ap="この戦略を、各人が独自のテント、ストーブ、斧を持って運ばなければならないシンプルな戦略と比較してみてください。これがPyTorchのDataParallel（DPおよびDDP）です。",Zs,bt,Rp="このトピックの文献を読む際に、以下の類義語に出会うかもしれません：Sharded、Partitioned。",ks,yt,Vp="ZeROがモデルの重みを分割する方法に注意を払うと、これはテンソルパラレリズムと非常に似ているように見えます。これは後で議論される垂直モデルパラレリズムとは異なり、各レイヤーの重みをパーティション/シャーディングします。",As,Dt,Xp="Implementations:",Rs,Gt,zp='<li><a href="https://www.deepspeed.ai/tutorials/zero/" rel="nofollow">DeepSpeed</a> ZeRO-DP stages 1+2+3</li> <li><a href="main_classes/trainer#trainer-integrations"><code>transformers</code> integration</a></li>',Vs,Jt,Xs,Ht,Fp="ナイーブモデルパラレリズム（MP）は、モデルの層を複数のGPUに分散させる方法です。このメカニズムは比較的単純で、希望する層を<code>.to()</code>メソッドを使用して特定のデバイスに切り替えるだけです。これにより、データがこれらの層を通過するたびに、データも層と同じデバイスに切り替えられ、残りの部分は変更されません。",zs,gt,Op="私たちはこれを「垂直MP」と呼びます。なぜなら、ほとんどのモデルがどのように描かれるかを思い出すと、層を垂直にスライスするからです。たとえば、以下の図は8層のモデルを示しています：",Fs,$t,Os,St,Wp="我々は、モデルを垂直に2つに分割し、レイヤー0から3をGPU0に配置し、レイヤー4から7をGPU1に配置しました。",Ws,Nt,Yp="データがレイヤー0から1、1から2、2から3に移動する間は通常のモデルと同じです。しかし、データがレイヤー3からレイヤー4に移動する必要がある場合、GPU0からGPU1への移動が発生し、通信のオーバーヘッドが発生します。参加しているGPUが同じコンピュートノード（例：同じ物理マシン）にある場合、このコピーは非常に高速ですが、異なるコンピュートノード（例：複数のマシン）にある場合、通信のオーバーヘッドは大幅に増加する可能性があります。",Ys,It,qp="その後、レイヤー4から5、6から7までは通常のモデルと同様に動作し、7番目のレイヤーが完了すると、データをしばしばレイヤー0に戻す必要があります（またはラベルを最後のレイヤーに送信します）。これで損失を計算し、オプティマイザが作業を開始できます。",qs,Et,Kp="問題点：",Ks,Qt,ta="<li>主な欠点、およびなぜこれを「単純な」MPと呼ぶのかは、1つを除いてすべてのGPUがどんな瞬間でもアイドル状態であることです。したがって、4つのGPUを使用する場合、単純なMPは、1つのGPUのメモリ容量を4倍にするのとほぼ同じであり、ハードウェアの残りを無視します。さらに、データのコピーのオーバーヘッドがあることを忘れてはいけません。したがって、4枚の6GBのカードは、データのコピーのオーバーヘッドがない1枚の24GBのカードと同じサイズを収容できるでしょうが、後者はトレーニングをより迅速に完了します。ただし、たとえば40GBのカードがあり、45GBのモデルを収める必要がある場合、勾配とオプティマイザの状態のためにほとんど収めることができません。</li> <li>共有の埋め込みは、GPU間でコピーする必要があるかもしれません。</li>",tn,Bt,ea="パイプライン並列処理（PP）は、ほぼ単純なMPと同じですが、GPUがアイドル状態になる問題を解決し、入力バッチをマイクロバッチに分割し、パイプラインを人工的に作成することにより、異なるGPUが計算プロセスに同時に参加できるようにします。",en,Zt,la='以下は、<a href="https://ai.googleblog.com/2019/03/introducing-gpipe-open-source-library.html" rel="nofollow">GPipe論文</a>からの図で、上部には単純なMP、下部にはPPが示されています：',ln,kt,sa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-gpipe-bubble.png" alt="mp-pp"/>',sn,At,na="この図から、PPがGPUがアイドル状態の領域である「バブル」を少なく持つことがわかります。アイドル状態の部分は「バブル」と呼ばれます。",nn,Rt,ia="図の両方の部分は、4つのGPUがパイプラインに参加している4の次元の並列性を示しています。つまり、4つのパイプステージF0、F1、F2、F3のフォワードパスがあり、逆順のバックワードパスB3、B2、B1、B0があります。",pn,Vt,pa="PPは調整する新しいハイパーパラメータを導入します。それは <code>chunks</code> で、同じパイプステージを通じて連続して送信されるデータのチャンクの数を定義します。たとえば、下の図では <code>chunks=4</code> が表示されています。GPU0はチャンク0、1、2、3（F0,0、F0,1、F0,2、F0,3）で同じフォワードパスを実行し、他のGPUが作業を開始し始めるのを待ってから、GPU0はチャンク3、2、1、0（B0,3、B0,2、B0,1、B0,0）で逆順パスを実行します。",an,Xt,aa="注意すべきは、概念的にはこれが勾配蓄積ステップ（GAS）と同じコンセプトであることです。PyTorchは <code>chunks</code> を使用し、DeepSpeedは同じハイパーパラメータをGASと呼びます。",Pn,zt,Pa="<code>chunks</code> の導入により、PPはマイクロバッチ（MBS）の概念を導入します。DPはグローバルデータバッチサイズをミニバッチに分割します。したがって、DPの次数が4で、グローバルバッチサイズが1024の場合、4つのミニバッチ（それぞれ256）に分割されます（1024/4）。そして、<code>chunks</code>（またはGAS）の数が32である場合、マイクロバッチサイズは8になります（256/32）。各パイプラインステージは1つのマイクロバッチで作業します。",fn,Ft,fa="DP + PPセットアップのグローバルバッチサイズを計算するには、<code>mbs*chunks*dp_degree</code>（<code>8*32*4=1024</code>）を行います。",Mn,Ot,Ma="図に戻りましょう。",un,Wt,ua="<code>chunks=1</code> であれば、非効率な単純なMPになります。非常に大きな <code>chunks</code> 値を使用すると、非常に小さなマイクロバッチサイズになり、効率があまり高くないかもしれません。したがって、GPUの効率的な利用を最大化する値を見つけるために実験する必要があります。これは、バブルのサイズを最小限にすることに対応する、すべての参加GPUにわたる高い並行GPU利用を可能にするためです。",xn,Yt,xa="2つのソリューショングループがあります。従来のパイプラインAPIソリューションと、ユーザーのモデルを大幅に変更する必要があるより現代的なソリューションです。",rn,qt,ra="従来のパイプラインAPIソリューション：",Tn,Kt,Ta="<li>PyTorch</li> <li>DeepSpeed</li> <li>Megatron-LM</li>",vn,te,va="現代的なソリューション：",Cn,ee,Ca="<li>Varuna</li> <li>Sagemaker</li>",mn,le,ma="従来のパイプラインAPIソリューションの問題点：",on,se,oa='<li>モデルをかなり変更する必要があるため、Pipelineはモジュールの通常のフローを<code>nn.Sequential</code>シーケンスに再書き込む必要があり、モデルの設計を変更することが必要です。</li> <li>現在、Pipeline APIは非常に制限的です。最初のパイプラインステージに渡されるPython変数のセットがある場合、回避策を見つける必要があります。現在、パイプラインインターフェースでは、唯一のテンソルまたはテンソルのタプルを入力と出力として要求しています。これらのテンソルはバッチサイズを最初の次元として持っている必要があります。パイプラインはミニバッチをマイクロバッチに分割します。可能な改善点については、こちらの議論が行われています：<a href="https://github.com/pytorch/pytorch/pull/50693" rel="nofollow">https://github.com/pytorch/pytorch/pull/50693</a></li> <li>パイプステージのレベルでの条件付き制御フローは不可能です。例えば、T5のようなエンコーダーデコーダーモデルは、条件付きエンコーダーステージを処理するために特別な回避策が必要です。</li> <li>各レイヤーを配置する必要があるため、1つのモデルの出力が他のモデルの入力になるようにします。</li>',hn,ne,ha="VarunaとSageMakerとの実験はまだ行っていませんが、彼らの論文によれば、上記で述べた問題のリストを克服し、ユーザーのモデルにははるかに小さな変更しか必要としないと報告されています。",Un,ie,Ua="実装：",_n,pe,_a='<li><a href="https://pytorch.org/docs/stable/pipeline.html" rel="nofollow">Pytorch</a> (initial support in pytorch-1.8, and progressively getting improved in 1.9 and more so in 1.10). Some <a href="https://github.com/pytorch/pytorch/blob/master/benchmarks/distributed/pipeline/pipe.py" rel="nofollow">examples</a></li> <li><a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation - no API.</li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> - この実装は、Hugging Face Transformersに基づいています。</li>',jn,ae,ja="🤗 Transformersのステータス: この執筆時点では、いずれのモデルも完全なPP（パイプライン並列処理）をサポートしていません。GPT2モデルとT5モデルは単純なMP（モデル並列処理）サポートを持っています。主な障害は、モデルを<code>nn.Sequential</code>に変換できず、すべての入力がテンソルである必要があることです。現在のモデルには、変換を非常に複雑にする多くの機能が含まれており、これらを削除する必要があります。",wn,Pe,wa="他のアプローチ：",Ln,fe,La='DeepSpeed、Varuna、およびSageMakerは、<a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-parallel-core-features.html" rel="nofollow">交互にパイプラインを実行</a>するコンセプトを使用しています。ここでは、バックワードパスを優先させてバブル（アイドル時間）をさらに最小限に抑えます。',cn,Me,ca="Varunaは、最適なスケジュールを発見するためにシミュレーションを使用してスケジュールをさらに改善しようとします。",dn,ue,da="OSLOは、<code>nn.Sequential</code>の変換なしでTransformersに基づくパイプライン並列処理を実装しています。",bn,xe,yn,re,ba="テンソル並列処理では、各GPUがテンソルのスライスのみを処理し、全体が必要な操作のためにのみ完全なテンソルを集約します。",Dn,Te,ya='このセクションでは、<a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a>論文からのコンセプトと図を使用します：<a href="https://arxiv.org/abs/2104.04473" rel="nofollow">GPUクラスタでの効率的な大規模言語モデルトレーニング</a>。',Gn,ve,Da="どのトランスフォーマの主要な構築要素は、完全に接続された<code>nn.Linear</code>に続く非線形アクティベーション<code>GeLU</code>です。",Jn,Ce,Ga="Megatronの論文の表記法に従って、行列の乗算部分を<code>Y = GeLU(XA)</code>と書くことができます。ここで、<code>X</code>と<code>Y</code>は入力ベクトルと出力ベクトルで、<code>A</code>は重み行列です。",Hn,me,Ja=`行列の計算を行列形式で見ると、行列乗算を複数のGPUで分割できる方法が簡単に理解できます：
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_gemm.png" alt="Parallel GEMM"/>`,gn,oe,Ha=`重み行列<code>A</code>を<code>N</code>個のGPUに対して列ごとに分割し、並列で行列乗算<code>XA_1</code>から<code>XA_n</code>を実行すると、<code>N</code>個の出力ベクトル<code>Y_1、Y_2、...、Y_n</code>が得られ、それらを独立して<code>GeLU</code>に供給できます：
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-independent-gelu.png" alt="独立したGeLU"/>`,$n,he,ga=`この原理を使用して、最後まで同期が必要ないまま、任意の深さのMLPを更新できます。Megatron-LMの著者はそのための有用なイラストを提供しています：
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_shard_processing.png" alt="並列シャード処理"/>`,Sn,Ue,$a=`マルチヘッドアテンションレイヤーを並列化することはさらに簡単です。それらは既に複数の独立したヘッドを持っているため、本質的に並列です！
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_self_attention.png" alt="並列セルフアテンション"/>`,Nn,_e,Sa="特別な考慮事項：TPには非常に高速なネットワークが必要であり、したがって1つのノードを超えてTPを実行しないことがお勧めされません。実際には、1つのノードに4つのGPUがある場合、最大のTP度数は4です。TP度数8が必要な場合は、少なくとも8つのGPUを持つノードを使用する必要があります。",In,je,Na=`このセクションは、元のより詳細な<a href="https://github.com/huggingface/transformers/issues/10321#issuecomment-783543530" rel="nofollow">TPの概要</a>に基づいています。
by <a href="https://github.com/anton-l" rel="nofollow">@anton-l</a>。`,En,we,Ia="SageMakerは、より効率的な処理のためにTPとDPを組み合わせて使用します。",Qn,Le,Ea="代替名：",Bn,ce,Qa='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a>はこれを「テンソルスライシング」と呼びます。詳細は<a href="https://www.deepspeed.ai/training/#model-parallelism" rel="nofollow">DeepSpeedの特徴</a>をご覧ください。</li>',Zn,de,Ba="実装例:",kn,be,Za='<li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a>には、モデル固有の内部実装があります。</li> <li><a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a>（現時点では推論のみ）。</li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - これはAWSでのみ使用できるプロプライエタリなソリューションです。</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a>には、Transformersに基づいたテンソル並列実装があります。</li>',An,ye,ka="🤗 Transformersの状況:",Rn,De,Aa='<li>コア: まだコアには実装されていません。</li> <li>ただし、推論が必要な場合、<a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a>はほとんどのモデルに対してサポートを提供します。これがコアに実装されるまで、これを使用できます。そして、トレーニングモードもサポートされることを期待しています。</li> <li>Deepspeed-Inferenceでは、BERT、GPT-2、およびGPT-NeoモデルをCUDAカーネルベースの高速推論モードでサポートしています。詳細は<a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">こちら</a>をご覧ください。</li>',Vn,Ge,Xn,Je,Ra='DeepSpeedの<a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">パイプラインチュートリアル</a>からの次の図は、DPをPPと組み合わせる方法を示しています。',zn,He,Va='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero-dp-pp.png" alt="dp-pp-2d"/>',Fn,ge,Xa="ここで重要なのは、DPランク0がGPU2を見えなくし、DPランク1がGPU3を見えなくすることです。DPにとって、存在するのはGPU 0 と 1 のみで、それらの2つのGPUのようにデータを供給します。GPU0はPPを使用してGPU2に一部の負荷を「秘密裏に」オフロードし、GPU1も同様にGPU3を支援に引き入れます。",On,$e,za="各次元には少なくとも2つのGPUが必要ですので、ここでは少なくとも4つのGPUが必要です。",Wn,Se,Fa="実装例:",Yn,Ne,Oa='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',qn,Ie,Wa="🤗 Transformersの状況: まだ実装されていません",Kn,Ee,ti,Qe,Ya="さらに効率的なトレーニングを行うために、3Dパラレリズムを使用し、PPをTPとDPと組み合わせます。これは次の図で示されています。",ei,Be,qa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-deepspeed-3d.png" alt="dp-pp-tp-3d"/>',li,Ze,Ka='この図は<a href="https://www.microsoft.com/en-us/research/blog/deepspeed-extreme-scale-model-training-for-everyone/" rel="nofollow">3Dパラレリズム：兆パラメータモデルへのスケーリング</a>というブログ投稿から取得されたもので、おすすめの読み物です。',si,ke,t1="各次元には少なくとも2つのGPUが必要ですので、ここでは少なくとも8つのGPUが必要です。",ni,Ae,e1="実装例:",ii,Re,l1='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> - DeepSpeedには、さらに効率的なDPであるZeRO-DPと呼ばれるものも含まれています。</li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',pi,Ve,s1="🤗 Transformersの状況: まだ実装されていません。PPとTPがないため。",ai,Xe,Pi,ze,n1="DeepSpeedの主要な機能の1つはZeROで、これはDPの拡張機能です。これについてはすでに「ZeROデータ並列化」で説明されています。通常、これは単独で動作する機能で、PPやTPは必要ありません。しかし、PPとTPと組み合わせることもできます。",fi,Fe,i1="ZeRO-DPがPPと組み合わされる場合、通常はZeROステージ1（オプティマイザーシャーディング）のみが有効になります。",Mi,Oe,p1="ZeROステージ2（勾配シャーディング）をパイプライン並列化と組み合わせて使用する理論的な可能性はありますが、性能に悪影響を及ぼします。各マイクロバッチごとに勾配をシャーディングする前に、勾配を集約するための追加のリダクションスキャッター集計が必要で、通信オーバーヘッドが発生する可能性があります。パイプライン並列化の性質上、小さなマイクロバッチが使用され、計算の集中度（マイクロバッチサイズ）をバランスにかけ、パイプラインバブル（マイクロバッチ数）を最小限に抑えることに焦点が当てられています。したがって、これらの通信コストは影響を及ぼすでしょう。",ui,We,a1="さらに、PPには通常よりも少ない層が含まれており、メモリの節約はそれほど大きくありません。PPは既に勾配サイズを「1/PP」に削減するため、勾配シャーディングの節約は純粋なDPよりもはるかに重要ではありません。",xi,Ye,P1="ZeROステージ3も同様の理由で適していません - より多くのノード間通信が必要です。",ri,qe,f1="そして、ZeROを持っているので、もう一つの利点はZeRO-Offloadです。これはステージ1オプティマイザーステートをCPUにオフロードできます。",Ti,Ke,M1="実装例:",vi,tl,u1='<li><a href="https://github.com/microsoft/Megatron-DeepSpeed" rel="nofollow">Megatron-DeepSpeed</a>と<a href="https://github.com/bigscience-workshop/Megatron-DeepSpeed" rel="nofollow">BigScienceからのMegatron-Deepspeed</a>は、前者のリポジトリのフォークです。</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',Ci,el,x1="重要な論文:",mi,ll,r1='<li><a href="https://arxiv.org/abs/2201.11990" rel="nofollow">DeepSpeedとMegatronを使用したMegatron-Turing NLG 530Bのトレーニング</a></li>',oi,sl,T1="🤗 Transformersの状況: まだ実装されていません。PPとTPがないため。",hi,nl,Ui,il,v1='<a href="https://github.com/flexflow/FlexFlow" rel="nofollow">FlexFlow</a>は、わずかに異なるアプローチで並列化の問題を解決します。',_i,pl,C1='論文: <a href="https://arxiv.org/abs/1807.05358" rel="nofollow">Zhihao Jia、Matei Zaharia、Alex Aikenによる “Deep Neural Networksのデータとモデルの並列化を超えて”</a>',ji,al,m1="FlexFlowは、サンプル-オペレータ-属性-パラメータの4D並列化を行います。",wi,Pl,o1="<li>サンプル = データ並列化（サンプル単位の並列化）</li> <li>オペレータ = 単一の操作をいくつかのサブ操作に並列化</li> <li>属性 = データ並列化（長さ方向の並列化）</li> <li>パラメータ = モデル並列化（次元に関係なく、水平または垂直）</li>",Li,fl,h1="例:",ci,Ml,U1="<li>サンプル</li>",di,ul,_1="シーケンス長512の10バッチを考えてみましょう。これらをサンプル次元で2つのデバイスに並列化すると、10 x 512が5 x 2 x 512になります。",bi,xl,j1="<li>オペレータ</li>",yi,rl,w1="層正規化を行う場合、まずstdを計算し、次にmeanを計算し、データを正規化できます。オペレータの並列化により、stdとmeanを並列に計算できます。したがって、オペレータ次元で2つのデバイス（cuda:0、cuda:1）に並列化すると、最初に入力データを両方のデバイスにコピーし、cuda:0でstdを計算し、cuda:1でmeanを同時に計算します。",Di,Tl,L1="<li>属性</li>",Gi,vl,c1="10バッチの512長があります。これらを属性次元で2つのデバイスに並列化すると、10 x 512が10 x 2 x 256になります。",Ji,Cl,d1="<li>パラメータ</li>",Hi,ml,b1="これはテンソルモデルの並列化または単純な層ごとのモデルの並列化と似ています。",gi,ol,y1="このフレームワークの重要性は、（1）GPU/TPU/CPU対（2）RAM/DRAM対（3）高速内部接続/低速外部接続などのリソースを取り、これらすべてをアルゴリズムによって自動的に最適化することです。どの並列化をどこで使用するかをアルゴリズム的に決定します。",$i,hl,D1="非常に重要な側面の1つは、FlexFlowは静的で固定のワークロードを持つモデルのために設計されており、動的な動作を持つモデルはイテレーションごとに異なる並列化戦略を好む場合があることです。",Si,Ul,G1="したがって、このフレームワークの約束は非常に魅力的です。選択したクラスタで30分間のシミュレーションを実行し、この特定の環境を最適に利用するための最良の戦略を提供します。部分を追加/削除/置換すると、それに対して実行して再最適化プランを作成します。その後、トレーニングできます。異なるセットアップには独自の最適化があります。",Ni,_l,J1='🤗 Transformersの現在の状況: まだ統合されていません。すでに<a href="https://github.com/huggingface/transformers/blob/master/src/transformers/utils/fx.py" rel="nofollow">transformers.utils.fx</a>を使用してモデルがFXトレース可能であるため、FlexFlowを動作させるために必要な手順を誰かが見つける必要があります。',Ii,jl,Ei,wl,H1="ここでは、どの並列化戦略をいつ使用するかの非常におおまかなアウトラインを示します。各リストの最初が通常よりも速いことが一般的です。",Qi,Ll,g1="<strong>⇨ 単一GPU</strong>",Bi,cl,$1='<li><p>モデルが単一GPUに収まる場合：</p> <ol><li>通常の使用</li></ol></li> <li><p>モデルが単一GPUに収まらない場合：</p> <ol><li>ZeRO + CPUをオフロードし、オプションでNVMeをオフロード</li> <li>上記に加えて、最大のレイヤーが単一GPUに収まらない場合、<a href="https://deepspeed.readthedocs.io/en/latest/zero3.html#memory-centric-tiling" rel="nofollow">Memory Centric Tiling</a>（詳細は以下参照）を有効化</li></ol></li> <li><p>最大のレイヤーが単一GPUに収まらない場合：</p> <ol><li>ZeROを使用しない場合 - TPを有効化する必要があります。なぜなら、PPだけでは収めることができないからです。</li> <li>ZeROを使用する場合は、上記の「単一GPU」のエントリと同じものを参照してください</li></ol></li>',Zi,dl,S1="<strong>⇨ 単一ノード/マルチGPU</strong>",ki,bl,N1="<li><p>モデルが単一GPUに収まる場合：</p> <ol><li>DDP - 分散データ並列</li> <li>ZeRO - 状況と使用される構成に依存して速いかどうかが異なることがあります</li></ol></li> <li><p>モデルが単一GPUに収まらない場合：</p> <ol><li><p>PP</p></li> <li><p>ZeRO</p></li> <li><p>TP</p> <p>非常に高速なノード内接続がNVLINKまたはNVSwitchである場合、これらのすべてはほとんど同等の性能です。これらがない場合、PPはTPまたはZeROよりも速くなります。TPの度合いも違いを生じるかもしれません。特定のセットアップで勝者を見つけるために実験するのが最善です。</p> <p>TPはほとんど常に単一ノード内で使用されます。つまり、TPサイズ &lt;= ノードあたりのGPUです。</p></li></ol></li> <li><p>最大のレイヤーが単一GPUに収まらない場合：</p> <ol><li>ZeROを使用しない場合 - TPを使用する必要があります。なぜなら、PPだけでは収めることができないからです。</li> <li>ZeROを使用する場合は、上記の「単一GPU」のエントリと同じものを参照してください</li></ol></li>",Ai,yl,I1="<strong>⇨ マルチノード/マルチGPU</strong>",Ri,Dl,E1="<li><p>高速なノード間接続がある場合：</p> <ol><li>ZeRO - モデルへのほとんどの変更が不要です</li> <li>PP+TP+DP - 通信が少なく、モデルに大規模な変更が必要です</li></ol></li> <li><p>遅いノード間接続があり、GPUメモリが少ない場合：</p> <ol><li>DP+PP+TP+ZeRO-1</li></ol></li>",Vi,Jl,Xi;return U=new C({props:{title:"Efficient Training on Multiple GPUs",local:"efficient-training-on-multiple-gpus",headingTag:"h1"}}),o=new O1({props:{$$slots:{default:[W1]},$$scope:{ctx:gl}}}),w=new C({props:{title:"Concepts",local:"concepts",headingTag:"h2"}}),b=new C({props:{title:"Scalability Strategy",local:"scalability-strategy",headingTag:"h2"}}),H=new C({props:{title:"Data Parallelism",local:"data-parallelism",headingTag:"h2"}}),$=new C({props:{title:"DP vs DDP",local:"dp-vs-ddp",headingTag:"h3"}}),lt=new Hl({props:{code:"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",highlighted:`
<span class="hljs-comment"># DP</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">110</span>.<span class="hljs-string">5948</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">808</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}

<span class="hljs-comment"># DDP w/ NVlink</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">torchrun</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">101</span>.<span class="hljs-string">9003</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">963</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}

<span class="hljs-comment"># DDP w/o NVlink</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">NCCL_P2P_DISABLE</span>=<span class="hljs-string">1</span> <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">torchrun</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">131</span>.<span class="hljs-string">4367</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">522</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),it=new C({props:{title:"ZeRO Data Parallelism",local:"zero-data-parallelism",headingTag:"h2"}}),ft=new Hl({props:{code:"TGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWEwJTIwJTdDJTIwYjAlMjAlN0MlMjBjMCUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQWEyJTIwJTdDJTIwYjIlMjAlN0MlMjBjMg==",highlighted:`La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),xt=new Hl({props:{code:"R1BVMCUzQSUwQUxhJTIwJTdDJTIwTGIlMjAlN0MlMjBMYyUwQS0tLSU3Qy0tLS0lN0MtLS0lMEFhMCUyMCU3QyUyMGIwJTIwJTdDJTIwYzAlMEElMEFHUFUxJTNBJTBBTGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQSUwQUdQVTIlM0ElMEFMYSUyMCU3QyUyMExiJTIwJTdDJTIwTGMlMEEtLS0lN0MtLS0tJTdDLS0tJTBBYTIlMjAlN0MlMjBiMiUyMCU3QyUyMGMy",highlighted:`GPU0:
La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0

GPU1:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1

GPU2:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),vt=new Hl({props:{code:"eDAlMjAlM0QlM0UlMjBHUFUwJTBBeDElMjAlM0QlM0UlMjBHUFUxJTBBeDIlMjAlM0QlM0UlMjBHUFUy",highlighted:`<span class="hljs-attribute">x0</span> <span class="hljs-operator">=</span>&gt; GPU0
<span class="hljs-attribute">x1</span> <span class="hljs-operator">=</span>&gt; GPU1
<span class="hljs-attribute">x2</span> <span class="hljs-operator">=</span>&gt; GPU2`,wrap:!1}}),Jt=new C({props:{title:"Naive Model Parallelism (Vertical) and Pipeline Parallelism",local:"naive-model-parallelism-vertical-and-pipeline-parallelism",headingTag:"h2"}}),$t=new Hl({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwJTIwJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTdDJTIwJTIwMCUyMCU3QyUyMDElMjAlN0MlMjAyJTIwJTdDJTIwMyUyMCUyMCU3QyUyMCUyMCU3QyUyMCUyMDQlMjAlN0MlMjA1JTIwJTdDJTIwNiUyMCU3QyUyMDclMjAlMjAlN0MlMEElM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMjAlMjAlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBncHUwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3B1MQ==",highlighted:`===================  ===================
|<span class="hljs-string">  0 </span>|<span class="hljs-string"> 1 </span>|<span class="hljs-string"> 2 </span>|<span class="hljs-string"> 3  </span>|<span class="hljs-string">  </span>|<span class="hljs-string">  4 </span>|<span class="hljs-string"> 5 </span>|<span class="hljs-string"> 6 </span>|<span class="hljs-string"> 7  </span>|
===================  ===================
        gpu0                 gpu1`,wrap:!1}}),xe=new C({props:{title:"Tensor Parallelism",local:"tensor-parallelism",headingTag:"h2"}}),Ge=new C({props:{title:"DP+PP",local:"dppp",headingTag:"h2"}}),Ee=new C({props:{title:"DP+PP+TP",local:"dppptp",headingTag:"h2"}}),Xe=new C({props:{title:"ZeRO DP+PP+TP",local:"zero-dppptp",headingTag:"h2"}}),nl=new C({props:{title:"FlexFlow",local:"flexflow",headingTag:"h2"}}),jl=new C({props:{title:"Which Strategy To Use When",local:"which-strategy-to-use-when",headingTag:"h2"}}),{c(){v=p("meta"),h=n(),m=p("p"),Gl=n(),f(U.$$.fragment),$l=n(),_=p("p"),_.textContent=zi,Sl=n(),f(o.$$.fragment),Nl=n(),j=p("p"),j.textContent=Fi,Il=n(),f(w.$$.fragment),El=n(),L=p("p"),L.textContent=Oi,Ql=n(),c=p("ol"),c.innerHTML=Wi,Bl=n(),d=p("p"),d.textContent=Yi,Zl=n(),f(b.$$.fragment),kl=n(),y=p("p"),y.innerHTML=qi,Al=n(),D=p("ul"),D.innerHTML=Ki,Rl=n(),G=p("p"),G.innerHTML=tp,Vl=n(),J=p("ul"),J.innerHTML=ep,Xl=n(),f(H.$$.fragment),zl=n(),g=p("p"),g.innerHTML=lp,Fl=n(),f($.$$.fragment),Ol=n(),S=p("p"),S.innerHTML=sp,Wl=n(),N=p("ul"),N.innerHTML=np,Yl=n(),I=p("p"),I.textContent=ip,ql=n(),E=p("p"),E.innerHTML=pp,Kl=n(),Q=p("ul"),Q.innerHTML=ap,ts=n(),B=p("p"),B.innerHTML=Pp,es=n(),Z=p("p"),Z.textContent=fp,ls=n(),k=p("ol"),k.innerHTML=Mp,ss=n(),A=p("p"),A.textContent=up,ns=n(),R=p("p"),R.innerHTML=xp,is=n(),V=p("p"),V.textContent=rp,ps=n(),X=p("p"),X.textContent=Tp,as=n(),z=p("p"),z.textContent=vp,Ps=n(),F=p("p"),F.innerHTML=Cp,fs=n(),O=p("p"),O.textContent=mp,Ms=n(),W=p("table"),W.innerHTML=op,us=n(),Y=p("p"),Y.textContent=hp,xs=n(),q=p("p"),q.textContent=Up,rs=n(),K=p("p"),K.textContent=_p,Ts=n(),tt=p("p"),tt.textContent=jp,vs=n(),et=p("p"),et.innerHTML=wp,Cs=n(),f(lt.$$.fragment),ms=n(),st=p("p"),st.innerHTML=Lp,os=n(),nt=p("p"),nt.innerHTML=cp,hs=n(),f(it.$$.fragment),Us=n(),pt=p("p"),pt.innerHTML=dp,_s=n(),at=p("p"),at.innerHTML=bp,js=n(),Pt=p("p"),Pt.textContent=yp,ws=n(),f(ft.$$.fragment),Ls=n(),Mt=p("p"),Mt.textContent=Dp,cs=n(),ut=p("p"),ut.textContent=Gp,ds=n(),f(xt.$$.fragment),bs=n(),rt=p("p"),rt.textContent=Jp,ys=n(),Tt=p("p"),Tt.textContent=Hp,Ds=n(),f(vt.$$.fragment),Gs=n(),Ct=p("p"),Ct.textContent=gp,Js=n(),mt=p("p"),mt.textContent=$p,Hs=n(),ot=p("p"),ot.textContent=Sp,gs=n(),ht=p("p"),ht.textContent=Np,$s=n(),Ut=p("p"),Ut.textContent=Ip,Ss=n(),_t=p("p"),_t.textContent=Ep,Ns=n(),jt=p("p"),jt.textContent=Qp,Is=n(),wt=p("p"),wt.textContent=Bp,Es=n(),Lt=p("ol"),Lt.innerHTML=Zp,Qs=n(),ct=p("p"),ct.textContent=kp,Bs=n(),dt=p("p"),dt.textContent=Ap,Zs=n(),bt=p("p"),bt.textContent=Rp,ks=n(),yt=p("p"),yt.textContent=Vp,As=n(),Dt=p("p"),Dt.textContent=Xp,Rs=n(),Gt=p("ul"),Gt.innerHTML=zp,Vs=n(),f(Jt.$$.fragment),Xs=n(),Ht=p("p"),Ht.innerHTML=Fp,zs=n(),gt=p("p"),gt.textContent=Op,Fs=n(),f($t.$$.fragment),Os=n(),St=p("p"),St.textContent=Wp,Ws=n(),Nt=p("p"),Nt.textContent=Yp,Ys=n(),It=p("p"),It.textContent=qp,qs=n(),Et=p("p"),Et.textContent=Kp,Ks=n(),Qt=p("ul"),Qt.innerHTML=ta,tn=n(),Bt=p("p"),Bt.textContent=ea,en=n(),Zt=p("p"),Zt.innerHTML=la,ln=n(),kt=p("p"),kt.innerHTML=sa,sn=n(),At=p("p"),At.textContent=na,nn=n(),Rt=p("p"),Rt.textContent=ia,pn=n(),Vt=p("p"),Vt.innerHTML=pa,an=n(),Xt=p("p"),Xt.innerHTML=aa,Pn=n(),zt=p("p"),zt.innerHTML=Pa,fn=n(),Ft=p("p"),Ft.innerHTML=fa,Mn=n(),Ot=p("p"),Ot.textContent=Ma,un=n(),Wt=p("p"),Wt.innerHTML=ua,xn=n(),Yt=p("p"),Yt.textContent=xa,rn=n(),qt=p("p"),qt.textContent=ra,Tn=n(),Kt=p("ul"),Kt.innerHTML=Ta,vn=n(),te=p("p"),te.textContent=va,Cn=n(),ee=p("ul"),ee.innerHTML=Ca,mn=n(),le=p("p"),le.textContent=ma,on=n(),se=p("ul"),se.innerHTML=oa,hn=n(),ne=p("p"),ne.textContent=ha,Un=n(),ie=p("p"),ie.textContent=Ua,_n=n(),pe=p("ul"),pe.innerHTML=_a,jn=n(),ae=p("p"),ae.innerHTML=ja,wn=n(),Pe=p("p"),Pe.textContent=wa,Ln=n(),fe=p("p"),fe.innerHTML=La,cn=n(),Me=p("p"),Me.textContent=ca,dn=n(),ue=p("p"),ue.innerHTML=da,bn=n(),f(xe.$$.fragment),yn=n(),re=p("p"),re.textContent=ba,Dn=n(),Te=p("p"),Te.innerHTML=ya,Gn=n(),ve=p("p"),ve.innerHTML=Da,Jn=n(),Ce=p("p"),Ce.innerHTML=Ga,Hn=n(),me=p("p"),me.innerHTML=Ja,gn=n(),oe=p("p"),oe.innerHTML=Ha,$n=n(),he=p("p"),he.innerHTML=ga,Sn=n(),Ue=p("p"),Ue.innerHTML=$a,Nn=n(),_e=p("p"),_e.textContent=Sa,In=n(),je=p("p"),je.innerHTML=Na,En=n(),we=p("p"),we.textContent=Ia,Qn=n(),Le=p("p"),Le.textContent=Ea,Bn=n(),ce=p("ul"),ce.innerHTML=Qa,Zn=n(),de=p("p"),de.textContent=Ba,kn=n(),be=p("ul"),be.innerHTML=Za,An=n(),ye=p("p"),ye.textContent=ka,Rn=n(),De=p("ul"),De.innerHTML=Aa,Vn=n(),f(Ge.$$.fragment),Xn=n(),Je=p("p"),Je.innerHTML=Ra,zn=n(),He=p("p"),He.innerHTML=Va,Fn=n(),ge=p("p"),ge.textContent=Xa,On=n(),$e=p("p"),$e.textContent=za,Wn=n(),Se=p("p"),Se.textContent=Fa,Yn=n(),Ne=p("ul"),Ne.innerHTML=Oa,qn=n(),Ie=p("p"),Ie.textContent=Wa,Kn=n(),f(Ee.$$.fragment),ti=n(),Qe=p("p"),Qe.textContent=Ya,ei=n(),Be=p("p"),Be.innerHTML=qa,li=n(),Ze=p("p"),Ze.innerHTML=Ka,si=n(),ke=p("p"),ke.textContent=t1,ni=n(),Ae=p("p"),Ae.textContent=e1,ii=n(),Re=p("ul"),Re.innerHTML=l1,pi=n(),Ve=p("p"),Ve.textContent=s1,ai=n(),f(Xe.$$.fragment),Pi=n(),ze=p("p"),ze.textContent=n1,fi=n(),Fe=p("p"),Fe.textContent=i1,Mi=n(),Oe=p("p"),Oe.textContent=p1,ui=n(),We=p("p"),We.textContent=a1,xi=n(),Ye=p("p"),Ye.textContent=P1,ri=n(),qe=p("p"),qe.textContent=f1,Ti=n(),Ke=p("p"),Ke.textContent=M1,vi=n(),tl=p("ul"),tl.innerHTML=u1,Ci=n(),el=p("p"),el.textContent=x1,mi=n(),ll=p("ul"),ll.innerHTML=r1,oi=n(),sl=p("p"),sl.textContent=T1,hi=n(),f(nl.$$.fragment),Ui=n(),il=p("p"),il.innerHTML=v1,_i=n(),pl=p("p"),pl.innerHTML=C1,ji=n(),al=p("p"),al.textContent=m1,wi=n(),Pl=p("ol"),Pl.innerHTML=o1,Li=n(),fl=p("p"),fl.textContent=h1,ci=n(),Ml=p("ul"),Ml.innerHTML=U1,di=n(),ul=p("p"),ul.textContent=_1,bi=n(),xl=p("ul"),xl.innerHTML=j1,yi=n(),rl=p("p"),rl.textContent=w1,Di=n(),Tl=p("ul"),Tl.innerHTML=L1,Gi=n(),vl=p("p"),vl.textContent=c1,Ji=n(),Cl=p("ul"),Cl.innerHTML=d1,Hi=n(),ml=p("p"),ml.textContent=b1,gi=n(),ol=p("p"),ol.textContent=y1,$i=n(),hl=p("p"),hl.textContent=D1,Si=n(),Ul=p("p"),Ul.textContent=G1,Ni=n(),_l=p("p"),_l.innerHTML=J1,Ii=n(),f(jl.$$.fragment),Ei=n(),wl=p("p"),wl.textContent=H1,Qi=n(),Ll=p("p"),Ll.innerHTML=g1,Bi=n(),cl=p("ul"),cl.innerHTML=$1,Zi=n(),dl=p("p"),dl.innerHTML=S1,ki=n(),bl=p("ul"),bl.innerHTML=N1,Ai=n(),yl=p("p"),yl.innerHTML=I1,Ri=n(),Dl=p("ul"),Dl.innerHTML=E1,Vi=n(),Jl=p("p"),this.h()},l(t){const e=z1("svelte-u9bgzb",document.head);v=a(e,"META",{name:!0,content:!0}),e.forEach(l),h=i(t),m=a(t,"P",{}),B1(m).forEach(l),Gl=i(t),M(U.$$.fragment,t),$l=i(t),_=a(t,"P",{"data-svelte-h":!0}),P(_)!=="svelte-p00wl7"&&(_.textContent=zi),Sl=i(t),M(o.$$.fragment,t),Nl=i(t),j=a(t,"P",{"data-svelte-h":!0}),P(j)!=="svelte-1kh3km3"&&(j.textContent=Fi),Il=i(t),M(w.$$.fragment,t),El=i(t),L=a(t,"P",{"data-svelte-h":!0}),P(L)!=="svelte-3k4cjb"&&(L.textContent=Oi),Ql=i(t),c=a(t,"OL",{"data-svelte-h":!0}),P(c)!=="svelte-19i5an3"&&(c.innerHTML=Wi),Bl=i(t),d=a(t,"P",{"data-svelte-h":!0}),P(d)!=="svelte-1axfwuf"&&(d.textContent=Yi),Zl=i(t),M(b.$$.fragment,t),kl=i(t),y=a(t,"P",{"data-svelte-h":!0}),P(y)!=="svelte-i7ves8"&&(y.innerHTML=qi),Al=i(t),D=a(t,"UL",{"data-svelte-h":!0}),P(D)!=="svelte-1xp2u7g"&&(D.innerHTML=Ki),Rl=i(t),G=a(t,"P",{"data-svelte-h":!0}),P(G)!=="svelte-17lwh0r"&&(G.innerHTML=tp),Vl=i(t),J=a(t,"UL",{"data-svelte-h":!0}),P(J)!=="svelte-jug9hc"&&(J.innerHTML=ep),Xl=i(t),M(H.$$.fragment,t),zl=i(t),g=a(t,"P",{"data-svelte-h":!0}),P(g)!=="svelte-5hcykd"&&(g.innerHTML=lp),Fl=i(t),M($.$$.fragment,t),Ol=i(t),S=a(t,"P",{"data-svelte-h":!0}),P(S)!=="svelte-gheqny"&&(S.innerHTML=sp),Wl=i(t),N=a(t,"UL",{"data-svelte-h":!0}),P(N)!=="svelte-1lsfqcs"&&(N.innerHTML=np),Yl=i(t),I=a(t,"P",{"data-svelte-h":!0}),P(I)!=="svelte-1pif46a"&&(I.textContent=ip),ql=i(t),E=a(t,"P",{"data-svelte-h":!0}),P(E)!=="svelte-1v8b0bi"&&(E.innerHTML=pp),Kl=i(t),Q=a(t,"UL",{"data-svelte-h":!0}),P(Q)!=="svelte-uzzpkk"&&(Q.innerHTML=ap),ts=i(t),B=a(t,"P",{"data-svelte-h":!0}),P(B)!=="svelte-2za96j"&&(B.innerHTML=Pp),es=i(t),Z=a(t,"P",{"data-svelte-h":!0}),P(Z)!=="svelte-1v6i5n3"&&(Z.textContent=fp),ls=i(t),k=a(t,"OL",{"data-svelte-h":!0}),P(k)!=="svelte-vfltgt"&&(k.innerHTML=Mp),ss=i(t),A=a(t,"P",{"data-svelte-h":!0}),P(A)!=="svelte-130pc3o"&&(A.textContent=up),ns=i(t),R=a(t,"P",{"data-svelte-h":!0}),P(R)!=="svelte-23i2i2"&&(R.innerHTML=xp),is=i(t),V=a(t,"P",{"data-svelte-h":!0}),P(V)!=="svelte-ufyyk6"&&(V.textContent=rp),ps=i(t),X=a(t,"P",{"data-svelte-h":!0}),P(X)!=="svelte-1gyvr2l"&&(X.textContent=Tp),as=i(t),z=a(t,"P",{"data-svelte-h":!0}),P(z)!=="svelte-1nvxoat"&&(z.textContent=vp),Ps=i(t),F=a(t,"P",{"data-svelte-h":!0}),P(F)!=="svelte-ndepvz"&&(F.innerHTML=Cp),fs=i(t),O=a(t,"P",{"data-svelte-h":!0}),P(O)!=="svelte-hpqigq"&&(O.textContent=mp),Ms=i(t),W=a(t,"TABLE",{"data-svelte-h":!0}),P(W)!=="svelte-1glyygb"&&(W.innerHTML=op),us=i(t),Y=a(t,"P",{"data-svelte-h":!0}),P(Y)!=="svelte-j7a5ab"&&(Y.textContent=hp),xs=i(t),q=a(t,"P",{"data-svelte-h":!0}),P(q)!=="svelte-v4b9q2"&&(q.textContent=Up),rs=i(t),K=a(t,"P",{"data-svelte-h":!0}),P(K)!=="svelte-117kghy"&&(K.textContent=_p),Ts=i(t),tt=a(t,"P",{"data-svelte-h":!0}),P(tt)!=="svelte-188felc"&&(tt.textContent=jp),vs=i(t),et=a(t,"P",{"data-svelte-h":!0}),P(et)!=="svelte-q5i4nx"&&(et.innerHTML=wp),Cs=i(t),M(lt.$$.fragment,t),ms=i(t),st=a(t,"P",{"data-svelte-h":!0}),P(st)!=="svelte-lu79sn"&&(st.innerHTML=Lp),os=i(t),nt=a(t,"P",{"data-svelte-h":!0}),P(nt)!=="svelte-18h87eb"&&(nt.innerHTML=cp),hs=i(t),M(it.$$.fragment,t),Us=i(t),pt=a(t,"P",{"data-svelte-h":!0}),P(pt)!=="svelte-juqsxg"&&(pt.innerHTML=dp),_s=i(t),at=a(t,"P",{"data-svelte-h":!0}),P(at)!=="svelte-1i0mdv7"&&(at.innerHTML=bp),js=i(t),Pt=a(t,"P",{"data-svelte-h":!0}),P(Pt)!=="svelte-1wipobe"&&(Pt.textContent=yp),ws=i(t),M(ft.$$.fragment,t),Ls=i(t),Mt=a(t,"P",{"data-svelte-h":!0}),P(Mt)!=="svelte-3cvmfq"&&(Mt.textContent=Dp),cs=i(t),ut=a(t,"P",{"data-svelte-h":!0}),P(ut)!=="svelte-1yhjowm"&&(ut.textContent=Gp),ds=i(t),M(xt.$$.fragment,t),bs=i(t),rt=a(t,"P",{"data-svelte-h":!0}),P(rt)!=="svelte-103bb0r"&&(rt.textContent=Jp),ys=i(t),Tt=a(t,"P",{"data-svelte-h":!0}),P(Tt)!=="svelte-12w85z6"&&(Tt.textContent=Hp),Ds=i(t),M(vt.$$.fragment,t),Gs=i(t),Ct=a(t,"P",{"data-svelte-h":!0}),P(Ct)!=="svelte-ekaxx1"&&(Ct.textContent=gp),Js=i(t),mt=a(t,"P",{"data-svelte-h":!0}),P(mt)!=="svelte-iccih7"&&(mt.textContent=$p),Hs=i(t),ot=a(t,"P",{"data-svelte-h":!0}),P(ot)!=="svelte-7uyuw7"&&(ot.textContent=Sp),gs=i(t),ht=a(t,"P",{"data-svelte-h":!0}),P(ht)!=="svelte-i9uex1"&&(ht.textContent=Np),$s=i(t),Ut=a(t,"P",{"data-svelte-h":!0}),P(Ut)!=="svelte-19oov4o"&&(Ut.textContent=Ip),Ss=i(t),_t=a(t,"P",{"data-svelte-h":!0}),P(_t)!=="svelte-p97sj8"&&(_t.textContent=Ep),Ns=i(t),jt=a(t,"P",{"data-svelte-h":!0}),P(jt)!=="svelte-5ocmnf"&&(jt.textContent=Qp),Is=i(t),wt=a(t,"P",{"data-svelte-h":!0}),P(wt)!=="svelte-1n2597e"&&(wt.textContent=Bp),Es=i(t),Lt=a(t,"OL",{"data-svelte-h":!0}),P(Lt)!=="svelte-1xfpr0y"&&(Lt.innerHTML=Zp),Qs=i(t),ct=a(t,"P",{"data-svelte-h":!0}),P(ct)!=="svelte-l6mji4"&&(ct.textContent=kp),Bs=i(t),dt=a(t,"P",{"data-svelte-h":!0}),P(dt)!=="svelte-1rje20u"&&(dt.textContent=Ap),Zs=i(t),bt=a(t,"P",{"data-svelte-h":!0}),P(bt)!=="svelte-104xoaf"&&(bt.textContent=Rp),ks=i(t),yt=a(t,"P",{"data-svelte-h":!0}),P(yt)!=="svelte-1rxc69e"&&(yt.textContent=Vp),As=i(t),Dt=a(t,"P",{"data-svelte-h":!0}),P(Dt)!=="svelte-1b2mzqh"&&(Dt.textContent=Xp),Rs=i(t),Gt=a(t,"UL",{"data-svelte-h":!0}),P(Gt)!=="svelte-1kdc4z9"&&(Gt.innerHTML=zp),Vs=i(t),M(Jt.$$.fragment,t),Xs=i(t),Ht=a(t,"P",{"data-svelte-h":!0}),P(Ht)!=="svelte-1knls5m"&&(Ht.innerHTML=Fp),zs=i(t),gt=a(t,"P",{"data-svelte-h":!0}),P(gt)!=="svelte-1tk8x6l"&&(gt.textContent=Op),Fs=i(t),M($t.$$.fragment,t),Os=i(t),St=a(t,"P",{"data-svelte-h":!0}),P(St)!=="svelte-tc8d5e"&&(St.textContent=Wp),Ws=i(t),Nt=a(t,"P",{"data-svelte-h":!0}),P(Nt)!=="svelte-1bhur3f"&&(Nt.textContent=Yp),Ys=i(t),It=a(t,"P",{"data-svelte-h":!0}),P(It)!=="svelte-1phbvvb"&&(It.textContent=qp),qs=i(t),Et=a(t,"P",{"data-svelte-h":!0}),P(Et)!=="svelte-1w5dvkg"&&(Et.textContent=Kp),Ks=i(t),Qt=a(t,"UL",{"data-svelte-h":!0}),P(Qt)!=="svelte-1ks7vrz"&&(Qt.innerHTML=ta),tn=i(t),Bt=a(t,"P",{"data-svelte-h":!0}),P(Bt)!=="svelte-bj9kti"&&(Bt.textContent=ea),en=i(t),Zt=a(t,"P",{"data-svelte-h":!0}),P(Zt)!=="svelte-edjnsa"&&(Zt.innerHTML=la),ln=i(t),kt=a(t,"P",{"data-svelte-h":!0}),P(kt)!=="svelte-1q7hzge"&&(kt.innerHTML=sa),sn=i(t),At=a(t,"P",{"data-svelte-h":!0}),P(At)!=="svelte-8fnl63"&&(At.textContent=na),nn=i(t),Rt=a(t,"P",{"data-svelte-h":!0}),P(Rt)!=="svelte-1v2yyww"&&(Rt.textContent=ia),pn=i(t),Vt=a(t,"P",{"data-svelte-h":!0}),P(Vt)!=="svelte-17bhy87"&&(Vt.innerHTML=pa),an=i(t),Xt=a(t,"P",{"data-svelte-h":!0}),P(Xt)!=="svelte-1n6ze23"&&(Xt.innerHTML=aa),Pn=i(t),zt=a(t,"P",{"data-svelte-h":!0}),P(zt)!=="svelte-2frj83"&&(zt.innerHTML=Pa),fn=i(t),Ft=a(t,"P",{"data-svelte-h":!0}),P(Ft)!=="svelte-155mvto"&&(Ft.innerHTML=fa),Mn=i(t),Ot=a(t,"P",{"data-svelte-h":!0}),P(Ot)!=="svelte-165iud9"&&(Ot.textContent=Ma),un=i(t),Wt=a(t,"P",{"data-svelte-h":!0}),P(Wt)!=="svelte-1r4hea4"&&(Wt.innerHTML=ua),xn=i(t),Yt=a(t,"P",{"data-svelte-h":!0}),P(Yt)!=="svelte-qga8n1"&&(Yt.textContent=xa),rn=i(t),qt=a(t,"P",{"data-svelte-h":!0}),P(qt)!=="svelte-1r8j2il"&&(qt.textContent=ra),Tn=i(t),Kt=a(t,"UL",{"data-svelte-h":!0}),P(Kt)!=="svelte-1m54oo0"&&(Kt.innerHTML=Ta),vn=i(t),te=a(t,"P",{"data-svelte-h":!0}),P(te)!=="svelte-x7onsk"&&(te.textContent=va),Cn=i(t),ee=a(t,"UL",{"data-svelte-h":!0}),P(ee)!=="svelte-n2xihd"&&(ee.innerHTML=Ca),mn=i(t),le=a(t,"P",{"data-svelte-h":!0}),P(le)!=="svelte-1iww0fh"&&(le.textContent=ma),on=i(t),se=a(t,"UL",{"data-svelte-h":!0}),P(se)!=="svelte-1fhhlbg"&&(se.innerHTML=oa),hn=i(t),ne=a(t,"P",{"data-svelte-h":!0}),P(ne)!=="svelte-1by8oug"&&(ne.textContent=ha),Un=i(t),ie=a(t,"P",{"data-svelte-h":!0}),P(ie)!=="svelte-1ddoxaq"&&(ie.textContent=Ua),_n=i(t),pe=a(t,"UL",{"data-svelte-h":!0}),P(pe)!=="svelte-aek6za"&&(pe.innerHTML=_a),jn=i(t),ae=a(t,"P",{"data-svelte-h":!0}),P(ae)!=="svelte-1gyn38w"&&(ae.innerHTML=ja),wn=i(t),Pe=a(t,"P",{"data-svelte-h":!0}),P(Pe)!=="svelte-1oz3i0j"&&(Pe.textContent=wa),Ln=i(t),fe=a(t,"P",{"data-svelte-h":!0}),P(fe)!=="svelte-yyebt8"&&(fe.innerHTML=La),cn=i(t),Me=a(t,"P",{"data-svelte-h":!0}),P(Me)!=="svelte-1so65ff"&&(Me.textContent=ca),dn=i(t),ue=a(t,"P",{"data-svelte-h":!0}),P(ue)!=="svelte-1569xz"&&(ue.innerHTML=da),bn=i(t),M(xe.$$.fragment,t),yn=i(t),re=a(t,"P",{"data-svelte-h":!0}),P(re)!=="svelte-9pb2dz"&&(re.textContent=ba),Dn=i(t),Te=a(t,"P",{"data-svelte-h":!0}),P(Te)!=="svelte-69l0ue"&&(Te.innerHTML=ya),Gn=i(t),ve=a(t,"P",{"data-svelte-h":!0}),P(ve)!=="svelte-12qk9af"&&(ve.innerHTML=Da),Jn=i(t),Ce=a(t,"P",{"data-svelte-h":!0}),P(Ce)!=="svelte-1is9b6u"&&(Ce.innerHTML=Ga),Hn=i(t),me=a(t,"P",{"data-svelte-h":!0}),P(me)!=="svelte-bjqcm4"&&(me.innerHTML=Ja),gn=i(t),oe=a(t,"P",{"data-svelte-h":!0}),P(oe)!=="svelte-wd2okf"&&(oe.innerHTML=Ha),$n=i(t),he=a(t,"P",{"data-svelte-h":!0}),P(he)!=="svelte-17wn2am"&&(he.innerHTML=ga),Sn=i(t),Ue=a(t,"P",{"data-svelte-h":!0}),P(Ue)!=="svelte-v5hz18"&&(Ue.innerHTML=$a),Nn=i(t),_e=a(t,"P",{"data-svelte-h":!0}),P(_e)!=="svelte-1ntqvm3"&&(_e.textContent=Sa),In=i(t),je=a(t,"P",{"data-svelte-h":!0}),P(je)!=="svelte-ii1wqh"&&(je.innerHTML=Na),En=i(t),we=a(t,"P",{"data-svelte-h":!0}),P(we)!=="svelte-1xslm35"&&(we.textContent=Ia),Qn=i(t),Le=a(t,"P",{"data-svelte-h":!0}),P(Le)!=="svelte-sw9zg7"&&(Le.textContent=Ea),Bn=i(t),ce=a(t,"UL",{"data-svelte-h":!0}),P(ce)!=="svelte-16pqr2f"&&(ce.innerHTML=Qa),Zn=i(t),de=a(t,"P",{"data-svelte-h":!0}),P(de)!=="svelte-1t1nzmn"&&(de.textContent=Ba),kn=i(t),be=a(t,"UL",{"data-svelte-h":!0}),P(be)!=="svelte-1o6x54n"&&(be.innerHTML=Za),An=i(t),ye=a(t,"P",{"data-svelte-h":!0}),P(ye)!=="svelte-cztbby"&&(ye.textContent=ka),Rn=i(t),De=a(t,"UL",{"data-svelte-h":!0}),P(De)!=="svelte-e2tlha"&&(De.innerHTML=Aa),Vn=i(t),M(Ge.$$.fragment,t),Xn=i(t),Je=a(t,"P",{"data-svelte-h":!0}),P(Je)!=="svelte-1ft649q"&&(Je.innerHTML=Ra),zn=i(t),He=a(t,"P",{"data-svelte-h":!0}),P(He)!=="svelte-qmcl9c"&&(He.innerHTML=Va),Fn=i(t),ge=a(t,"P",{"data-svelte-h":!0}),P(ge)!=="svelte-1kdddli"&&(ge.textContent=Xa),On=i(t),$e=a(t,"P",{"data-svelte-h":!0}),P($e)!=="svelte-6mun4"&&($e.textContent=za),Wn=i(t),Se=a(t,"P",{"data-svelte-h":!0}),P(Se)!=="svelte-1t1nzmn"&&(Se.textContent=Fa),Yn=i(t),Ne=a(t,"UL",{"data-svelte-h":!0}),P(Ne)!=="svelte-1ry6c7"&&(Ne.innerHTML=Oa),qn=i(t),Ie=a(t,"P",{"data-svelte-h":!0}),P(Ie)!=="svelte-1cmjcnt"&&(Ie.textContent=Wa),Kn=i(t),M(Ee.$$.fragment,t),ti=i(t),Qe=a(t,"P",{"data-svelte-h":!0}),P(Qe)!=="svelte-1qmo80m"&&(Qe.textContent=Ya),ei=i(t),Be=a(t,"P",{"data-svelte-h":!0}),P(Be)!=="svelte-18rdwc7"&&(Be.innerHTML=qa),li=i(t),Ze=a(t,"P",{"data-svelte-h":!0}),P(Ze)!=="svelte-6bvqnr"&&(Ze.innerHTML=Ka),si=i(t),ke=a(t,"P",{"data-svelte-h":!0}),P(ke)!=="svelte-1ctxp2k"&&(ke.textContent=t1),ni=i(t),Ae=a(t,"P",{"data-svelte-h":!0}),P(Ae)!=="svelte-1t1nzmn"&&(Ae.textContent=e1),ii=i(t),Re=a(t,"UL",{"data-svelte-h":!0}),P(Re)!=="svelte-nixdp7"&&(Re.innerHTML=l1),pi=i(t),Ve=a(t,"P",{"data-svelte-h":!0}),P(Ve)!=="svelte-1deyqj7"&&(Ve.textContent=s1),ai=i(t),M(Xe.$$.fragment,t),Pi=i(t),ze=a(t,"P",{"data-svelte-h":!0}),P(ze)!=="svelte-1sixjhq"&&(ze.textContent=n1),fi=i(t),Fe=a(t,"P",{"data-svelte-h":!0}),P(Fe)!=="svelte-dvn5ga"&&(Fe.textContent=i1),Mi=i(t),Oe=a(t,"P",{"data-svelte-h":!0}),P(Oe)!=="svelte-18c9zhu"&&(Oe.textContent=p1),ui=i(t),We=a(t,"P",{"data-svelte-h":!0}),P(We)!=="svelte-hdy6eh"&&(We.textContent=a1),xi=i(t),Ye=a(t,"P",{"data-svelte-h":!0}),P(Ye)!=="svelte-mqrqtn"&&(Ye.textContent=P1),ri=i(t),qe=a(t,"P",{"data-svelte-h":!0}),P(qe)!=="svelte-1b2fyjn"&&(qe.textContent=f1),Ti=i(t),Ke=a(t,"P",{"data-svelte-h":!0}),P(Ke)!=="svelte-1t1nzmn"&&(Ke.textContent=M1),vi=i(t),tl=a(t,"UL",{"data-svelte-h":!0}),P(tl)!=="svelte-1cblhzj"&&(tl.innerHTML=u1),Ci=i(t),el=a(t,"P",{"data-svelte-h":!0}),P(el)!=="svelte-1vvympt"&&(el.textContent=x1),mi=i(t),ll=a(t,"UL",{"data-svelte-h":!0}),P(ll)!=="svelte-1czeqoh"&&(ll.innerHTML=r1),oi=i(t),sl=a(t,"P",{"data-svelte-h":!0}),P(sl)!=="svelte-1deyqj7"&&(sl.textContent=T1),hi=i(t),M(nl.$$.fragment,t),Ui=i(t),il=a(t,"P",{"data-svelte-h":!0}),P(il)!=="svelte-hf9mbc"&&(il.innerHTML=v1),_i=i(t),pl=a(t,"P",{"data-svelte-h":!0}),P(pl)!=="svelte-1ouo6uy"&&(pl.innerHTML=C1),ji=i(t),al=a(t,"P",{"data-svelte-h":!0}),P(al)!=="svelte-1cr6l18"&&(al.textContent=m1),wi=i(t),Pl=a(t,"OL",{"data-svelte-h":!0}),P(Pl)!=="svelte-ipafw6"&&(Pl.innerHTML=o1),Li=i(t),fl=a(t,"P",{"data-svelte-h":!0}),P(fl)!=="svelte-2h3m3n"&&(fl.textContent=h1),ci=i(t),Ml=a(t,"UL",{"data-svelte-h":!0}),P(Ml)!=="svelte-7owhqp"&&(Ml.innerHTML=U1),di=i(t),ul=a(t,"P",{"data-svelte-h":!0}),P(ul)!=="svelte-78y6sq"&&(ul.textContent=_1),bi=i(t),xl=a(t,"UL",{"data-svelte-h":!0}),P(xl)!=="svelte-nr15rw"&&(xl.innerHTML=j1),yi=i(t),rl=a(t,"P",{"data-svelte-h":!0}),P(rl)!=="svelte-yys12u"&&(rl.textContent=w1),Di=i(t),Tl=a(t,"UL",{"data-svelte-h":!0}),P(Tl)!=="svelte-txq006"&&(Tl.innerHTML=L1),Gi=i(t),vl=a(t,"P",{"data-svelte-h":!0}),P(vl)!=="svelte-1i6ea3v"&&(vl.textContent=c1),Ji=i(t),Cl=a(t,"UL",{"data-svelte-h":!0}),P(Cl)!=="svelte-1ruobph"&&(Cl.innerHTML=d1),Hi=i(t),ml=a(t,"P",{"data-svelte-h":!0}),P(ml)!=="svelte-1dun2jw"&&(ml.textContent=b1),gi=i(t),ol=a(t,"P",{"data-svelte-h":!0}),P(ol)!=="svelte-11zcqf6"&&(ol.textContent=y1),$i=i(t),hl=a(t,"P",{"data-svelte-h":!0}),P(hl)!=="svelte-183itn7"&&(hl.textContent=D1),Si=i(t),Ul=a(t,"P",{"data-svelte-h":!0}),P(Ul)!=="svelte-1pl4g43"&&(Ul.textContent=G1),Ni=i(t),_l=a(t,"P",{"data-svelte-h":!0}),P(_l)!=="svelte-1dwdxtf"&&(_l.innerHTML=J1),Ii=i(t),M(jl.$$.fragment,t),Ei=i(t),wl=a(t,"P",{"data-svelte-h":!0}),P(wl)!=="svelte-orwa44"&&(wl.textContent=H1),Qi=i(t),Ll=a(t,"P",{"data-svelte-h":!0}),P(Ll)!=="svelte-x7ybmv"&&(Ll.innerHTML=g1),Bi=i(t),cl=a(t,"UL",{"data-svelte-h":!0}),P(cl)!=="svelte-1cwqz5w"&&(cl.innerHTML=$1),Zi=i(t),dl=a(t,"P",{"data-svelte-h":!0}),P(dl)!=="svelte-6aq26r"&&(dl.innerHTML=S1),ki=i(t),bl=a(t,"UL",{"data-svelte-h":!0}),P(bl)!=="svelte-1vipcvs"&&(bl.innerHTML=N1),Ai=i(t),yl=a(t,"P",{"data-svelte-h":!0}),P(yl)!=="svelte-13kh319"&&(yl.innerHTML=I1),Ri=i(t),Dl=a(t,"UL",{"data-svelte-h":!0}),P(Dl)!=="svelte-1yau8ud"&&(Dl.innerHTML=E1),Vi=i(t),Jl=a(t,"P",{}),B1(Jl).forEach(l),this.h()},h(){Z1(v,"name","hf:doc:metadata"),Z1(v,"content",q1)},m(t,e){F1(document.head,v),s(t,h,e),s(t,m,e),s(t,Gl,e),u(U,t,e),s(t,$l,e),s(t,_,e),s(t,Sl,e),u(o,t,e),s(t,Nl,e),s(t,j,e),s(t,Il,e),u(w,t,e),s(t,El,e),s(t,L,e),s(t,Ql,e),s(t,c,e),s(t,Bl,e),s(t,d,e),s(t,Zl,e),u(b,t,e),s(t,kl,e),s(t,y,e),s(t,Al,e),s(t,D,e),s(t,Rl,e),s(t,G,e),s(t,Vl,e),s(t,J,e),s(t,Xl,e),u(H,t,e),s(t,zl,e),s(t,g,e),s(t,Fl,e),u($,t,e),s(t,Ol,e),s(t,S,e),s(t,Wl,e),s(t,N,e),s(t,Yl,e),s(t,I,e),s(t,ql,e),s(t,E,e),s(t,Kl,e),s(t,Q,e),s(t,ts,e),s(t,B,e),s(t,es,e),s(t,Z,e),s(t,ls,e),s(t,k,e),s(t,ss,e),s(t,A,e),s(t,ns,e),s(t,R,e),s(t,is,e),s(t,V,e),s(t,ps,e),s(t,X,e),s(t,as,e),s(t,z,e),s(t,Ps,e),s(t,F,e),s(t,fs,e),s(t,O,e),s(t,Ms,e),s(t,W,e),s(t,us,e),s(t,Y,e),s(t,xs,e),s(t,q,e),s(t,rs,e),s(t,K,e),s(t,Ts,e),s(t,tt,e),s(t,vs,e),s(t,et,e),s(t,Cs,e),u(lt,t,e),s(t,ms,e),s(t,st,e),s(t,os,e),s(t,nt,e),s(t,hs,e),u(it,t,e),s(t,Us,e),s(t,pt,e),s(t,_s,e),s(t,at,e),s(t,js,e),s(t,Pt,e),s(t,ws,e),u(ft,t,e),s(t,Ls,e),s(t,Mt,e),s(t,cs,e),s(t,ut,e),s(t,ds,e),u(xt,t,e),s(t,bs,e),s(t,rt,e),s(t,ys,e),s(t,Tt,e),s(t,Ds,e),u(vt,t,e),s(t,Gs,e),s(t,Ct,e),s(t,Js,e),s(t,mt,e),s(t,Hs,e),s(t,ot,e),s(t,gs,e),s(t,ht,e),s(t,$s,e),s(t,Ut,e),s(t,Ss,e),s(t,_t,e),s(t,Ns,e),s(t,jt,e),s(t,Is,e),s(t,wt,e),s(t,Es,e),s(t,Lt,e),s(t,Qs,e),s(t,ct,e),s(t,Bs,e),s(t,dt,e),s(t,Zs,e),s(t,bt,e),s(t,ks,e),s(t,yt,e),s(t,As,e),s(t,Dt,e),s(t,Rs,e),s(t,Gt,e),s(t,Vs,e),u(Jt,t,e),s(t,Xs,e),s(t,Ht,e),s(t,zs,e),s(t,gt,e),s(t,Fs,e),u($t,t,e),s(t,Os,e),s(t,St,e),s(t,Ws,e),s(t,Nt,e),s(t,Ys,e),s(t,It,e),s(t,qs,e),s(t,Et,e),s(t,Ks,e),s(t,Qt,e),s(t,tn,e),s(t,Bt,e),s(t,en,e),s(t,Zt,e),s(t,ln,e),s(t,kt,e),s(t,sn,e),s(t,At,e),s(t,nn,e),s(t,Rt,e),s(t,pn,e),s(t,Vt,e),s(t,an,e),s(t,Xt,e),s(t,Pn,e),s(t,zt,e),s(t,fn,e),s(t,Ft,e),s(t,Mn,e),s(t,Ot,e),s(t,un,e),s(t,Wt,e),s(t,xn,e),s(t,Yt,e),s(t,rn,e),s(t,qt,e),s(t,Tn,e),s(t,Kt,e),s(t,vn,e),s(t,te,e),s(t,Cn,e),s(t,ee,e),s(t,mn,e),s(t,le,e),s(t,on,e),s(t,se,e),s(t,hn,e),s(t,ne,e),s(t,Un,e),s(t,ie,e),s(t,_n,e),s(t,pe,e),s(t,jn,e),s(t,ae,e),s(t,wn,e),s(t,Pe,e),s(t,Ln,e),s(t,fe,e),s(t,cn,e),s(t,Me,e),s(t,dn,e),s(t,ue,e),s(t,bn,e),u(xe,t,e),s(t,yn,e),s(t,re,e),s(t,Dn,e),s(t,Te,e),s(t,Gn,e),s(t,ve,e),s(t,Jn,e),s(t,Ce,e),s(t,Hn,e),s(t,me,e),s(t,gn,e),s(t,oe,e),s(t,$n,e),s(t,he,e),s(t,Sn,e),s(t,Ue,e),s(t,Nn,e),s(t,_e,e),s(t,In,e),s(t,je,e),s(t,En,e),s(t,we,e),s(t,Qn,e),s(t,Le,e),s(t,Bn,e),s(t,ce,e),s(t,Zn,e),s(t,de,e),s(t,kn,e),s(t,be,e),s(t,An,e),s(t,ye,e),s(t,Rn,e),s(t,De,e),s(t,Vn,e),u(Ge,t,e),s(t,Xn,e),s(t,Je,e),s(t,zn,e),s(t,He,e),s(t,Fn,e),s(t,ge,e),s(t,On,e),s(t,$e,e),s(t,Wn,e),s(t,Se,e),s(t,Yn,e),s(t,Ne,e),s(t,qn,e),s(t,Ie,e),s(t,Kn,e),u(Ee,t,e),s(t,ti,e),s(t,Qe,e),s(t,ei,e),s(t,Be,e),s(t,li,e),s(t,Ze,e),s(t,si,e),s(t,ke,e),s(t,ni,e),s(t,Ae,e),s(t,ii,e),s(t,Re,e),s(t,pi,e),s(t,Ve,e),s(t,ai,e),u(Xe,t,e),s(t,Pi,e),s(t,ze,e),s(t,fi,e),s(t,Fe,e),s(t,Mi,e),s(t,Oe,e),s(t,ui,e),s(t,We,e),s(t,xi,e),s(t,Ye,e),s(t,ri,e),s(t,qe,e),s(t,Ti,e),s(t,Ke,e),s(t,vi,e),s(t,tl,e),s(t,Ci,e),s(t,el,e),s(t,mi,e),s(t,ll,e),s(t,oi,e),s(t,sl,e),s(t,hi,e),u(nl,t,e),s(t,Ui,e),s(t,il,e),s(t,_i,e),s(t,pl,e),s(t,ji,e),s(t,al,e),s(t,wi,e),s(t,Pl,e),s(t,Li,e),s(t,fl,e),s(t,ci,e),s(t,Ml,e),s(t,di,e),s(t,ul,e),s(t,bi,e),s(t,xl,e),s(t,yi,e),s(t,rl,e),s(t,Di,e),s(t,Tl,e),s(t,Gi,e),s(t,vl,e),s(t,Ji,e),s(t,Cl,e),s(t,Hi,e),s(t,ml,e),s(t,gi,e),s(t,ol,e),s(t,$i,e),s(t,hl,e),s(t,Si,e),s(t,Ul,e),s(t,Ni,e),s(t,_l,e),s(t,Ii,e),u(jl,t,e),s(t,Ei,e),s(t,wl,e),s(t,Qi,e),s(t,Ll,e),s(t,Bi,e),s(t,cl,e),s(t,Zi,e),s(t,dl,e),s(t,ki,e),s(t,bl,e),s(t,Ai,e),s(t,yl,e),s(t,Ri,e),s(t,Dl,e),s(t,Vi,e),s(t,Jl,e),Xi=!0},p(t,[e]){const Q1={};e&2&&(Q1.$$scope={dirty:e,ctx:t}),o.$set(Q1)},i(t){Xi||(x(U.$$.fragment,t),x(o.$$.fragment,t),x(w.$$.fragment,t),x(b.$$.fragment,t),x(H.$$.fragment,t),x($.$$.fragment,t),x(lt.$$.fragment,t),x(it.$$.fragment,t),x(ft.$$.fragment,t),x(xt.$$.fragment,t),x(vt.$$.fragment,t),x(Jt.$$.fragment,t),x($t.$$.fragment,t),x(xe.$$.fragment,t),x(Ge.$$.fragment,t),x(Ee.$$.fragment,t),x(Xe.$$.fragment,t),x(nl.$$.fragment,t),x(jl.$$.fragment,t),Xi=!0)},o(t){r(U.$$.fragment,t),r(o.$$.fragment,t),r(w.$$.fragment,t),r(b.$$.fragment,t),r(H.$$.fragment,t),r($.$$.fragment,t),r(lt.$$.fragment,t),r(it.$$.fragment,t),r(ft.$$.fragment,t),r(xt.$$.fragment,t),r(vt.$$.fragment,t),r(Jt.$$.fragment,t),r($t.$$.fragment,t),r(xe.$$.fragment,t),r(Ge.$$.fragment,t),r(Ee.$$.fragment,t),r(Xe.$$.fragment,t),r(nl.$$.fragment,t),r(jl.$$.fragment,t),Xi=!1},d(t){t&&(l(h),l(m),l(Gl),l($l),l(_),l(Sl),l(Nl),l(j),l(Il),l(El),l(L),l(Ql),l(c),l(Bl),l(d),l(Zl),l(kl),l(y),l(Al),l(D),l(Rl),l(G),l(Vl),l(J),l(Xl),l(zl),l(g),l(Fl),l(Ol),l(S),l(Wl),l(N),l(Yl),l(I),l(ql),l(E),l(Kl),l(Q),l(ts),l(B),l(es),l(Z),l(ls),l(k),l(ss),l(A),l(ns),l(R),l(is),l(V),l(ps),l(X),l(as),l(z),l(Ps),l(F),l(fs),l(O),l(Ms),l(W),l(us),l(Y),l(xs),l(q),l(rs),l(K),l(Ts),l(tt),l(vs),l(et),l(Cs),l(ms),l(st),l(os),l(nt),l(hs),l(Us),l(pt),l(_s),l(at),l(js),l(Pt),l(ws),l(Ls),l(Mt),l(cs),l(ut),l(ds),l(bs),l(rt),l(ys),l(Tt),l(Ds),l(Gs),l(Ct),l(Js),l(mt),l(Hs),l(ot),l(gs),l(ht),l($s),l(Ut),l(Ss),l(_t),l(Ns),l(jt),l(Is),l(wt),l(Es),l(Lt),l(Qs),l(ct),l(Bs),l(dt),l(Zs),l(bt),l(ks),l(yt),l(As),l(Dt),l(Rs),l(Gt),l(Vs),l(Xs),l(Ht),l(zs),l(gt),l(Fs),l(Os),l(St),l(Ws),l(Nt),l(Ys),l(It),l(qs),l(Et),l(Ks),l(Qt),l(tn),l(Bt),l(en),l(Zt),l(ln),l(kt),l(sn),l(At),l(nn),l(Rt),l(pn),l(Vt),l(an),l(Xt),l(Pn),l(zt),l(fn),l(Ft),l(Mn),l(Ot),l(un),l(Wt),l(xn),l(Yt),l(rn),l(qt),l(Tn),l(Kt),l(vn),l(te),l(Cn),l(ee),l(mn),l(le),l(on),l(se),l(hn),l(ne),l(Un),l(ie),l(_n),l(pe),l(jn),l(ae),l(wn),l(Pe),l(Ln),l(fe),l(cn),l(Me),l(dn),l(ue),l(bn),l(yn),l(re),l(Dn),l(Te),l(Gn),l(ve),l(Jn),l(Ce),l(Hn),l(me),l(gn),l(oe),l($n),l(he),l(Sn),l(Ue),l(Nn),l(_e),l(In),l(je),l(En),l(we),l(Qn),l(Le),l(Bn),l(ce),l(Zn),l(de),l(kn),l(be),l(An),l(ye),l(Rn),l(De),l(Vn),l(Xn),l(Je),l(zn),l(He),l(Fn),l(ge),l(On),l($e),l(Wn),l(Se),l(Yn),l(Ne),l(qn),l(Ie),l(Kn),l(ti),l(Qe),l(ei),l(Be),l(li),l(Ze),l(si),l(ke),l(ni),l(Ae),l(ii),l(Re),l(pi),l(Ve),l(ai),l(Pi),l(ze),l(fi),l(Fe),l(Mi),l(Oe),l(ui),l(We),l(xi),l(Ye),l(ri),l(qe),l(Ti),l(Ke),l(vi),l(tl),l(Ci),l(el),l(mi),l(ll),l(oi),l(sl),l(hi),l(Ui),l(il),l(_i),l(pl),l(ji),l(al),l(wi),l(Pl),l(Li),l(fl),l(ci),l(Ml),l(di),l(ul),l(bi),l(xl),l(yi),l(rl),l(Di),l(Tl),l(Gi),l(vl),l(Ji),l(Cl),l(Hi),l(ml),l(gi),l(ol),l($i),l(hl),l(Si),l(Ul),l(Ni),l(_l),l(Ii),l(Ei),l(wl),l(Qi),l(Ll),l(Bi),l(cl),l(Zi),l(dl),l(ki),l(bl),l(Ai),l(yl),l(Ri),l(Dl),l(Vi),l(Jl)),l(v),T(U,t),T(o,t),T(w,t),T(b,t),T(H,t),T($,t),T(lt,t),T(it,t),T(ft,t),T(xt,t),T(vt,t),T(Jt,t),T($t,t),T(xe,t),T(Ge,t),T(Ee,t),T(Xe,t),T(nl,t),T(jl,t)}}}const q1='{"title":"Efficient Training on Multiple GPUs","local":"efficient-training-on-multiple-gpus","sections":[{"title":"Concepts","local":"concepts","sections":[],"depth":2},{"title":"Scalability Strategy","local":"scalability-strategy","sections":[],"depth":2},{"title":"Data Parallelism","local":"data-parallelism","sections":[{"title":"DP vs DDP","local":"dp-vs-ddp","sections":[],"depth":3}],"depth":2},{"title":"ZeRO Data Parallelism","local":"zero-data-parallelism","sections":[],"depth":2},{"title":"Naive Model Parallelism (Vertical) and Pipeline Parallelism","local":"naive-model-parallelism-vertical-and-pipeline-parallelism","sections":[],"depth":2},{"title":"Tensor Parallelism","local":"tensor-parallelism","sections":[],"depth":2},{"title":"DP+PP","local":"dppp","sections":[],"depth":2},{"title":"DP+PP+TP","local":"dppptp","sections":[],"depth":2},{"title":"ZeRO DP+PP+TP","local":"zero-dppptp","sections":[],"depth":2},{"title":"FlexFlow","local":"flexflow","sections":[],"depth":2},{"title":"Which Strategy To Use When","local":"which-strategy-to-use-when","sections":[],"depth":2}],"depth":1}';function K1(gl){return A1(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class iP extends V1{constructor(v){super(),X1(this,v,K1,Y1,k1,{})}}export{iP as component};
