import{s as rs,n as ns,o as is}from"../chunks/scheduler.85c25b89.js";import{S as ls,i as ss,g as a,s as r,r as d,A as ms,h as o,f as i,c as n,j as m,u as c,x as l,k as v,y as t,a as p,v as g,d as u,t as h,w as f}from"../chunks/index.c9837788.js";import{D as b}from"../chunks/Docstring.dc31b5e8.js";import{H as j,E as ps}from"../chunks/getInferenceSnippets.2d2e232c.js";function ds(hi){let Q,fo,to,vo,be,bo,_e,fi="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",_o,ye,yo,xe,xo,_,$e,br,Lt,vi="Create an optimizer instance via timm registry.",_r,Tt,bi=`Creates and configures an optimizer with appropriate parameter groups and settings.
Supports automatic parameter group creation for weight decay and layer-wise learning
rates, as well as custom parameter grouping.`,yr,At,_i="Examples:",xr,ao,oo,we,Ce,$r,zt,yi="optimizer = create_optimizer_v2(model, ‘adamw’, lr=1e-3)",wr,ro,no,Le,Te,Cr,Dt,xi=`optimizer = create_optimizer_v2(
…     model, ‘sgd’, lr=0.1, momentum=0.9, weight_decay=1e-4
… )`,Lr,io,lo,Ae,ze,Tr,Pt,$i=`optimizer = create_optimizer_v2(
…     model, ‘adam’, lr=1e-3, layer_decay=0.7
… )`,Ar,so,mo,De,Pe,zr,It,wi=`def group_fn(model):
…     return [
…         {‘params’: model.backbone.parameters(), ‘lr’: 1e-4},
…         {‘params’: model.head.parameters(), ‘lr’: 1e-3}
…     ]
optimizer = create_optimizer_v2(
…     model, ‘sgd’, param_group_fn=group_fn
… )`,Dr,Mt,Ci=`Note:
Parameter group handling precedence:`,Pr,kt,Li="<li>If param_group_fn is provided, it will be used exclusively</li> <li>If layer_decay is provided, layer-wise groups will be created</li> <li>If weight_decay &gt; 0 and filter_bias_and_bn is True, weight decay groups will be created</li> <li>Otherwise, all parameters will be in a single group</li>",$o,y,Ie,Ir,qt,Ti="List available optimizer names, optionally filtered.",Mr,Et,Ai=`List all registered optimizers, with optional filtering using wildcard patterns.
Optimizers can be filtered using include and exclude patterns, and can optionally
return descriptions with each optimizer name.`,kr,Ot,zi="Examples:",qr,Ft,Di=`<blockquote><blockquote><p>list_optimizers()
[‘adam’, ‘adamw’, ‘sgd’, …]</p></blockquote></blockquote>`,Er,Nt,Pi=`<blockquote><blockquote><p>list_optimizers([‘la<em>’, ‘nla</em>’])  # List lamb &amp; lars
[‘lamb’, ‘lambc’, ‘larc’, ‘lars’, ‘nlarc’, ‘nlars’]</p></blockquote></blockquote>`,Or,Ht,Ii=`<blockquote><blockquote><p>list_optimizers(’<em>adam</em>’, exclude_filters=[‘bnb<em>’, ‘fused</em>’])  # Exclude bnb &amp; apex adam optimizers
[‘adam’, ‘adamax’, ‘adamp’, ‘adamw’, ‘nadam’, ‘nadamw’, ‘radam’]</p></blockquote></blockquote>`,Fr,Bt,Mi=`<blockquote><blockquote><p>list_optimizers(with_description=True)  # Get descriptions
[(‘adabelief’, ‘Adapts learning rate based on gradient prediction error’),
(‘adadelta’, ‘torch.optim Adadelta, Adapts learning rates based on running windows of gradients’),
(‘adafactor’, ‘Memory-efficient implementation of Adam with factored gradients’),
…]</p></blockquote></blockquote>`,wo,L,Me,Nr,Gt,ki="Get optimizer class by name with option to bind default arguments.",Hr,St,qi=`Retrieves the optimizer class or a partial function with default arguments bound.
This allows direct instantiation of optimizers with their default configurations
without going through the full factory.`,Br,Rt,Ei="Examples:",Gr,po,co,ke,qe,Sr,Vt,Oi=`SGD = get_optimizer_class(‘sgd’)  # nesterov=True bound
opt = SGD(model.parameters(), lr=0.1, momentum=0.9)`,Rr,go,uo,Ee,Oe,Vr,Ut,Fi=`SGD = get_optimizer_class(‘sgd’)
opt = SGD(model.parameters(), lr=1e-3, momentum=0.9)`,Co,Fe,Lo,T,Ne,Ur,Wt,Ni="Implements AdaBelief algorithm. Modified from Adam in PyTorch",Wr,jt,Hi="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",jr,Qt,Bi=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,Qr,Kt,Gi='<li>link to train_script: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',Kr,Z,He,Zr,Zt,Si="Performs a single optimization step.",To,w,Be,Xr,Xt,Ri="Implements Adafactor algorithm.",Jr,Jt,Vi=`This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,Yr,Yt,Ui=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,en,ea,Wi=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,tn,ta,ji=`Ags:
params: iterable of parameters to optimize or dicts defining parameter groups
lr: external learning rate
eps: regularization constants for square gradient and parameter scale respectively
eps_scale: regularization constants for parameter scale respectively
clip_threshold: threshold of root-mean-square of final gradient update
decay_rate: coefficient used to compute running averages of square gradient
beta1: coefficient used for computing running averages of gradient
weight_decay: weight decay
scale_parameter: if True, learning rate is scaled by root-mean-square of parameter
warmup_init: time-dependent learning rate computation depends on whether warm-up initialization is being used`,an,X,Ge,on,aa,Qi="Performs a single optimization step.",Ao,S,Se,rn,oa,Ki="PyTorch implementation of BigVision’s Adafactor variant with both single and multi tensor implementations.",nn,ra,Zi='Adapted from <a href="https://github.com/google-research/big_vision" rel="nofollow">https://github.com/google-research/big_vision</a> by Ross Wightman',zo,A,Re,ln,na,Xi="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",sn,J,Ve,mn,ia,Ji="Gets all parameters in all param_groups with gradients",pn,Y,Ue,dn,la,Yi="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",cn,ee,We,gn,sa,el="Performs a single optimization step.",un,te,je,hn,ma,tl="Zeros out the accumulated hessian traces.",Do,Qe,Ke,Po,q,Ze,fn,pa,al="Implements a pytorch variant of Adan.",vn,da,ol=`Adan was proposed in Adan: Adaptive Nesterov Momentum Algorithm for Faster Optimizing Deep Models
<a href="https://arxiv.org/abs/2208.06677" rel="nofollow">https://arxiv.org/abs/2208.06677</a>`,bn,ae,Xe,_n,ca,rl="Performs a single optimization step.",Io,R,Je,yn,ga,nl='ADOPT: Modified Adam Can Converge with Any β2 with the Optimal Rate: <a href="https://arxiv.org/abs/2411.02853" rel="nofollow">https://arxiv.org/abs/2411.02853</a>',xn,oe,Ye,$n,ua,il="Perform a single optimization step.",Mo,I,et,wn,ha,ll=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,Cn,fa,sl="LAMB was proposed in:",Ln,va,ml='<li>Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:  <a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a></li> <li>On the Convergence of Adam and Beyond: <a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a></li>',Tn,re,tt,An,ba,pl="Performs a single optimization step.",ko,E,at,zn,_a,dl="LaProp Optimizer",Dn,ya,cl='Paper: LaProp: Separating Momentum and Adaptivity in Adam, <a href="https://arxiv.org/abs/2002.04839" rel="nofollow">https://arxiv.org/abs/2002.04839</a>',Pn,ne,ot,In,xa,gl="Performs a single optimization step.",qo,O,rt,Mn,$a,ul="LARS for PyTorch",kn,wa,hl='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',qn,ie,nt,En,Ca,fl="Performs a single optimization step.",Eo,V,it,On,La,vl="Implements Lion algorithm.",Fn,le,lt,Nn,Ta,bl="Performs a single optimization step.",Oo,st,mt,Fo,C,pt,Hn,Aa,_l=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,Bn,za,yl='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',Gn,Da,xl=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,Sn,Pa,$l=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,Rn,Ia,wl="On sparse problems both weight_decay and momentum should be set to 0.",Vn,se,dt,Un,Ma,Cl="Performs a single optimization step.",No,F,ct,Wn,ka,Ll="MARS Optimizer",jn,qa,Tl=`Paper: MARS: Unleashing the Power of Variance Reduction for Training Large Models
<a href="https://arxiv.org/abs/2411.10438" rel="nofollow">https://arxiv.org/abs/2411.10438</a>`,Qn,me,gt,Kn,Ea,Al="Performs a single optimization step.",Ho,z,ut,Zn,Oa,zl="Implements NAdamW algorithm.",Xn,Fa,Dl=`See Table 1 in <a href="https://arxiv.org/abs/1910.05446" rel="nofollow">https://arxiv.org/abs/1910.05446</a> for the implementation of
the NAdam algorithm (there is also a comment in the code which highlights
the only difference of NAdamW and AdamW).`,Jn,Na,Pl="For further details regarding the algorithm we refer to",Yn,Ha,Il='<li>Decoupled Weight Decay Regularization: <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a></li> <li>On the Convergence of Adam and Beyond: <a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a></li>',ei,pe,ht,ti,Ba,Ml="Performs a single optimization step.",Bo,U,ft,ai,Ga,kl="Implements Novograd algorithm.",oi,de,vt,ri,Sa,ql="Performs a single optimization step.",Go,x,bt,ni,Ra,El="Implements RMSprop algorithm (TensorFlow style epsilon)",ii,Va,Ol=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,li,Ua,Fl="Noteworthy changes include:",si,Wa,Nl="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",mi,ja,Hl=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,pi,Qa,Bl=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,di,ce,_t,ci,Ka,Gl="Performs a single optimization step.",So,yt,xt,Ro,K,$t,gi,ge,wt,ui,Za,Sl="Performs a single optimization step.",Vo,Ct,Uo,ho,Wo;return be=new j({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),ye=new j({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),xe=new j({props:{title:"Factory functions",local:"timm.optim.create_optimizer_v2",headingTag:"h3"}}),$e=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:": typing.Union[torch.nn.modules.module.Module, collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": typing.Optional[float] = None"},{name:"layer_decay_min_scale",val:": float = 0.0"},{name:"layer_decay_no_opt_scale",val:": typing.Optional[float] = None"},{name:"param_group_fn",val:": typing.Optional[typing.Callable[[torch.nn.modules.module.Module], typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]]] = None"},{name:"**kwargs",val:": typing.Any"}],parametersDescription:[{anchor:"timm.optim.create_optimizer_v2.model_or_params",description:`<strong>model_or_params</strong> &#x2014; A PyTorch model or an iterable of parameters/parameter groups.
If a model is provided, parameters will be automatically extracted and grouped
based on the other arguments.`,name:"model_or_params"},{anchor:"timm.optim.create_optimizer_v2.opt",description:`<strong>opt</strong> &#x2014; Name of the optimizer to create (e.g., &#x2018;adam&#x2019;, &#x2018;adamw&#x2019;, &#x2018;sgd&#x2019;).
Use list_optimizers() to see available options.`,name:"opt"},{anchor:"timm.optim.create_optimizer_v2.lr",description:"<strong>lr</strong> &#x2014; Learning rate. If None, will use the optimizer&#x2019;s default.",name:"lr"},{anchor:"timm.optim.create_optimizer_v2.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Weight decay factor. Will be used to create param groups if model_or_params is a model.",name:"weight_decay"},{anchor:"timm.optim.create_optimizer_v2.momentum",description:`<strong>momentum</strong> &#x2014; Momentum factor for optimizers that support it. Only used if the
chosen optimizer accepts a momentum parameter.`,name:"momentum"},{anchor:"timm.optim.create_optimizer_v2.foreach",description:`<strong>foreach</strong> &#x2014; Enable/disable foreach (multi-tensor) implementation if available.
If None, will use optimizer-specific defaults.`,name:"foreach"},{anchor:"timm.optim.create_optimizer_v2.filter_bias_and_bn",description:`<strong>filter_bias_and_bn</strong> &#x2014; If True, bias, norm layer parameters (all 1d params) will not have
weight decay applied. Only used when model_or_params is a model and
weight_decay &gt; 0.`,name:"filter_bias_and_bn"},{anchor:"timm.optim.create_optimizer_v2.layer_decay",description:`<strong>layer_decay</strong> &#x2014; Optional layer-wise learning rate decay factor. If provided,
learning rates will be scaled by layer_decay^(max_depth - layer_depth).
Only used when model_or_params is a model.`,name:"layer_decay"},{anchor:"timm.optim.create_optimizer_v2.param_group_fn",description:`<strong>param_group_fn</strong> &#x2014; Optional function to create custom parameter groups.
If provided, other parameter grouping options will be ignored.`,name:"param_group_fn"},{anchor:"timm.optim.create_optimizer_v2.*kwargs",description:"*<strong>*kwargs</strong> &#x2014; Additional optimizer-specific arguments (e.g., betas for Adam).",name:"*kwargs"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/_optim_factory.py#L1140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Configured optimizer instance.</p>
`}}),Ce=new j({props:{title:"Basic usage with a model",local:"basic-usage-with-a-model",headingTag:"h1"}}),Te=new j({props:{title:"SGD with momentum and weight decay",local:"sgd-with-momentum-and-weight-decay",headingTag:"h1"}}),ze=new j({props:{title:"Adam with layer-wise learning rate decay",local:"adam-with-layer-wise-learning-rate-decay",headingTag:"h1"}}),Pe=new j({props:{title:"Custom parameter groups",local:"custom-parameter-groups",headingTag:"h1"}}),Ie=new b({props:{name:"timm.optim.list_optimizers",anchor:"timm.optim.list_optimizers",parameters:[{name:"filter",val:": typing.Union[str, typing.List[str]] = ''"},{name:"exclude_filters",val:": typing.Optional[typing.List[str]] = None"},{name:"with_description",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.list_optimizers.filter",description:`<strong>filter</strong> &#x2014; Wildcard style filter string or list of filter strings
(e.g., &#x2018;adam<em>&#x2019; for all Adam variants, or [&#x2018;adam</em>&#x2019;, &#x2018;*8bit&#x2019;] for
Adam variants and 8-bit optimizers). Empty string means no filtering.`,name:"filter"},{anchor:"timm.optim.list_optimizers.exclude_filters",description:`<strong>exclude_filters</strong> &#x2014; Optional list of wildcard patterns to exclude. For example,
[&#x2019;<em>8bit&#x2019;, &#x2018;fused</em>&#x2019;] would exclude 8-bit and fused implementations.`,name:"exclude_filters"},{anchor:"timm.optim.list_optimizers.with_description",description:`<strong>with_description</strong> &#x2014; If True, returns tuples of (name, description) instead of
just names. Descriptions provide brief explanations of optimizer characteristics.`,name:"with_description"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/_optim_factory.py#L1043",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of optimizer names as strings (e.g., [‘adam’, ‘adamw’, …])
If with_description is True:
List of tuples of (name, description) (e.g., [(‘adam’, ‘Adaptive Moment…’), …])</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If with_description is False</p>
`}}),Me=new b({props:{name:"timm.optim.get_optimizer_class",anchor:"timm.optim.get_optimizer_class",parameters:[{name:"name",val:": str"},{name:"bind_defaults",val:": bool = True"}],parametersDescription:[{anchor:"timm.optim.get_optimizer_class.name",description:"<strong>name</strong> &#x2014; Name of the optimizer to retrieve (e.g., &#x2018;adam&#x2019;, &#x2018;sgd&#x2019;)",name:"name"},{anchor:"timm.optim.get_optimizer_class.bind_defaults",description:`<strong>bind_defaults</strong> &#x2014; If True, returns a partial function with default arguments from OptimInfo bound.
If False, returns the raw optimizer class.`,name:"bind_defaults"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/_optim_factory.py#L1103",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The optimizer class (e.g., torch.optim.Adam)
If bind_defaults is True:
A partial function with default arguments bound</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If bind_defaults is False</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If optimizer name is not found in registry</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),qe=new j({props:{title:"Get SGD with nesterov momentum default",local:"get-sgd-with-nesterov-momentum-default",headingTag:"h1"}}),Oe=new j({props:{title:"Get raw optimizer class",local:"get-raw-optimizer-class",headingTag:"h1"}}),Fe=new j({props:{title:"Optimizer Classes",local:"timm.optim.AdaBelief",headingTag:"h3"}}),Ne=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adabelief.py#L6"}}),He=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adabelief.py#L106"}}),Be=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": typing.Optional[float] = None"},{name:"eps",val:": float = 1e-30"},{name:"eps_scale",val:": float = 0.001"},{name:"clip_threshold",val:": float = 1.0"},{name:"decay_rate",val:": float = -0.8"},{name:"betas",val:": typing.Optional[typing.Tuple[float, float]] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"scale_parameter",val:": bool = True"},{name:"warmup_init",val:": bool = False"},{name:"min_dim_size_to_factor",val:": int = 16"},{name:"caution",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adafactor.py#L21"}}),Ge=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adafactor.py#L127"}}),Se=new b({props:{name:"class timm.optim.AdafactorBigVision",anchor:"timm.optim.AdafactorBigVision",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 1.0"},{name:"min_dim_size_to_factor",val:": int = 16"},{name:"decay_rate",val:": float = 0.8"},{name:"decay_offset",val:": int = 0"},{name:"beta2_cap",val:": float = 0.999"},{name:"momentum",val:": typing.Optional[float] = 0.9"},{name:"momentum_dtype",val:": typing.Union[str, torch.dtype] = torch.bfloat16"},{name:"eps",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"clipping_threshold",val:": typing.Optional[float] = None"},{name:"unscaled_wd",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adafactor_bv.py#L53"}}),Re=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adahessian.py#L9"}}),Ve=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adahessian.py#L74"}}),Ue=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adahessian.py#L90"}}),We=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adahessian.py#L118"}}),je=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adahessian.py#L81"}}),Ke=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adamp.py#L43"}}),Ze=new b({props:{name:"class timm.optim.Adan",anchor:"timm.optim.Adan",parameters:[{name:"params",val:""},{name:"lr",val:": float = 0.001"},{name:"betas",val:": typing.Tuple[float, float, float] = (0.98, 0.92, 0.99)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.0"},{name:"no_prox",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"timm.optim.Adan.params",description:"<strong>params</strong> &#x2014; Iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Adan.lr",description:"<strong>lr</strong> &#x2014; Learning rate.",name:"lr"},{anchor:"timm.optim.Adan.betas",description:"<strong>betas</strong> &#x2014; Coefficients used for first- and second-order moments.",name:"betas"},{anchor:"timm.optim.Adan.eps",description:"<strong>eps</strong> &#x2014; Term added to the denominator to improve numerical stability.",name:"eps"},{anchor:"timm.optim.Adan.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Decoupled weight decay (L2 penalty)",name:"weight_decay"},{anchor:"timm.optim.Adan.no_prox",description:"<strong>no_prox</strong> &#x2014; How to perform the weight decay",name:"no_prox"},{anchor:"timm.optim.Adan.caution",description:"<strong>caution</strong> &#x2014; Enable caution from &#x2018;Cautious Optimizers&#x2019;",name:"caution"},{anchor:"timm.optim.Adan.foreach",description:"<strong>foreach</strong> &#x2014; If True would use torch._foreach implementation. Faster but uses slightly more memory.",name:"foreach"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adan.py#L46"}}),Xe=new b({props:{name:"step",anchor:"timm.optim.Adan.step",parameters:[{name:"closure",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adan.py#L117"}}),Je=new b({props:{name:"class timm.optim.Adopt",anchor:"timm.optim.Adopt",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": typing.Union[float, torch.Tensor] = 0.001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.9999)"},{name:"eps",val:": float = 1e-06"},{name:"clip_exp",val:": typing.Optional[float] = 0.333"},{name:"weight_decay",val:": float = 0.0"},{name:"decoupled",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = False"},{name:"maximize",val:": bool = False"},{name:"capturable",val:": bool = False"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adopt.py#L59"}}),Ye=new b({props:{name:"step",anchor:"timm.optim.Adopt.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adopt.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/adopt.py#L188"}}),et=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.001"},{name:"bias_correction",val:": bool = True"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.01"},{name:"grad_averaging",val:": bool = True"},{name:"max_grad_norm",val:": typing.Optional[float] = 1.0"},{name:"trust_clip",val:": bool = False"},{name:"always_adapt",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"decoupled_decay",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> &#x2014; Iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> &#x2014; Learning rate",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:"<strong>betas</strong> &#x2014; Coefficients used for computing running averages of gradient and its norm.",name:"betas"},{anchor:"timm.optim.Lamb.eps",description:"<strong>eps</strong> &#x2014; Term added to the denominator to improve numerical stability.",name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Weight decay",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:"<strong>grad_averaging</strong> &#x2014; Whether apply (1-beta2) to grad when calculating running averages of gradient.",name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> &#x2014; Value used to clip global grad norm.",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> &#x2014; Enable LAMBC trust ratio clipping.",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:"<strong>always_adapt</strong> &#x2014; Apply adaptive learning rate to 0.0 weight decay parameter.",name:"always_adapt"},{anchor:"timm.optim.Lamb.caution",description:"<strong>caution</strong> &#x2014; Apply caution.",name:"caution"},{anchor:"timm.optim.Lamb.decoupled",description:"<strong>decoupled</strong> &#x2014; apply decoupled weight decay",name:"decoupled"},{anchor:"timm.optim.Lamb.corrected_weight_decay",description:"<strong>corrected_weight_decay</strong> &#x2014; apply corrected weight decay (lr**2 / max_lr) when using decoupled_decay",name:"corrected_weight_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/lamb.py#L67"}}),tt=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/lamb.py#L147"}}),at=new b({props:{name:"class timm.optim.LaProp",anchor:"timm.optim.LaProp",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.0004"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-15"},{name:"weight_decay",val:": float = 0.0"},{name:"caution",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/laprop.py#L27"}}),ot=new b({props:{name:"step",anchor:"timm.optim.LaProp.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.LaProp.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/laprop.py#L66"}}),rt=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/lars.py#L17"}}),nt=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/lars.py#L75"}}),it=new b({props:{name:"class timm.optim.Lion",anchor:"timm.optim.Lion",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.0001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.99)"},{name:"weight_decay",val:": float = 0.0"},{name:"caution",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/lion.py#L31"}}),lt=new b({props:{name:"step",anchor:"timm.optim.Lion.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lion.step.closure",description:"<strong>closure</strong> &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/lion.py#L81",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the loss.</p>
`}}),mt=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/lookahead.py#L15"}}),pt=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": typing.Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/madgrad.py#L24"}}),dt=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": typing.Optional[typing.Callable[[], float]] = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/madgrad.py#L90"}}),ct=new b({props:{name:"class timm.optim.Mars",anchor:"timm.optim.Mars",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.003"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.99)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.0"},{name:"gamma",val:": float = 0.025"},{name:"mars_type",val:": str = 'adamw'"},{name:"optimize_1d",val:": bool = False"},{name:"lr_1d_factor",val:": float = 1.0"},{name:"betas_1d",val:": typing.Optional[typing.Tuple[float, float]] = None"},{name:"caution",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/mars.py#L91"}}),gt=new b({props:{name:"step",anchor:"timm.optim.Mars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Mars.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/mars.py#L141"}}),ut=new b({props:{name:"class timm.optim.NAdamW",anchor:"timm.optim.NAdamW",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.01"},{name:"caution",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"capturable",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.NAdamW.params",description:"<strong>params</strong> &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.NAdamW.lr",description:"<strong>lr</strong> &#x2014; learning rate",name:"lr"},{anchor:"timm.optim.NAdamW.betas",description:"<strong>betas</strong> &#x2014; coefficients used for computing running averages of gradient and its square",name:"betas"},{anchor:"timm.optim.NAdamW.eps",description:"<strong>eps</strong> &#x2014; term added to the denominator to improve numerical stability",name:"eps"},{anchor:"timm.optim.NAdamW.weight_decay",description:"<strong>weight_decay</strong> &#x2014; weight decay coefficient",name:"weight_decay"},{anchor:"timm.optim.NAdamW.caution",description:"<strong>caution</strong> &#x2014; enable caution",name:"caution"},{anchor:"timm.optim.NAdamW.corrected_weight_decay",description:"<strong>corrected_weight_decay</strong> &#x2014; apply corrected weight decay (lr**2 / max_lr)",name:"corrected_weight_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/nadamw.py#L21"}}),ht=new b({props:{name:"step",anchor:"timm.optim.NAdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NAdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/nadamw.py#L89"}}),ft=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.grad_averaging",description:"<strong>grad_averaging</strong> &#x2014; gradient averaging",name:"grad_averaging"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/nvnovograd.py#L13"}}),vt=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/nvnovograd.py#L66"}}),bt=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.01"},{name:"alpha",val:": float = 0.9"},{name:"eps",val:": float = 1e-10"},{name:"weight_decay",val:": float = 0"},{name:"momentum",val:": float = 0.0"},{name:"centered",val:": bool = False"},{name:"decoupled_decay",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"lr_in_momentum",val:": bool = True"},{name:"caution",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:"<strong>params</strong> &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> &#x2014; learning rate",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> &#x2014; momentum factor",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> &#x2014; smoothing (decay) constant",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:"<strong>eps</strong> &#x2014; term added to the denominator to improve numerical stability",name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:"<strong>centered</strong> &#x2014; if <code>True</code>, compute the centered RMSProp, the gradient is normalized by an estimation of its variance",name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.corrected_weight_decay",description:"<strong>corrected_weight_decay</strong> &#x2014; apply corrected weight decay (lr**2 / max_lr) when decoupled_decay is True",name:"corrected_weight_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:"<strong>lr_in_momentum</strong> &#x2014; learning rate scaling is included in the momentum buffer update as per defaults in Tensorflow",name:"lr_in_momentum"},{anchor:"timm.optim.RMSpropTF.caution",description:"<strong>caution</strong> &#x2014; apply caution",name:"caution"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/rmsprop_tf.py#L20"}}),_t=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/rmsprop_tf.py#L98"}}),xt=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/sgdp.py#L19"}}),$t=new b({props:{name:"class timm.optim.SGDW",anchor:"timm.optim.SGDW",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.001"},{name:"momentum",val:": float = 0.0"},{name:"dampening",val:": float = 0.0"},{name:"weight_decay",val:": float = 0.0"},{name:"nesterov",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/sgdw.py#L25"}}),wt=new b({props:{name:"step",anchor:"timm.optim.SGDW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.SGDW.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.17/timm/optim/sgdw.py#L94"}}),Ct=new ps({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/optimizers.mdx"}}),{c(){Q=a("meta"),fo=r(),to=a("p"),vo=r(),d(be.$$.fragment),bo=r(),_e=a("p"),_e.innerHTML=fi,_o=r(),d(ye.$$.fragment),yo=r(),d(xe.$$.fragment),xo=r(),_=a("div"),d($e.$$.fragment),br=r(),Lt=a("p"),Lt.textContent=vi,_r=r(),Tt=a("p"),Tt.textContent=bi,yr=r(),At=a("p"),At.textContent=_i,xr=r(),ao=a("blockquote"),oo=a("blockquote"),we=a("blockquote"),d(Ce.$$.fragment),$r=r(),zt=a("p"),zt.textContent=yi,wr=r(),ro=a("blockquote"),no=a("blockquote"),Le=a("blockquote"),d(Te.$$.fragment),Cr=r(),Dt=a("p"),Dt.textContent=xi,Lr=r(),io=a("blockquote"),lo=a("blockquote"),Ae=a("blockquote"),d(ze.$$.fragment),Tr=r(),Pt=a("p"),Pt.textContent=$i,Ar=r(),so=a("blockquote"),mo=a("blockquote"),De=a("blockquote"),d(Pe.$$.fragment),zr=r(),It=a("p"),It.textContent=wi,Dr=r(),Mt=a("p"),Mt.textContent=Ci,Pr=r(),kt=a("ol"),kt.innerHTML=Li,$o=r(),y=a("div"),d(Ie.$$.fragment),Ir=r(),qt=a("p"),qt.textContent=Ti,Mr=r(),Et=a("p"),Et.textContent=Ai,kr=r(),Ot=a("p"),Ot.textContent=zi,qr=r(),Ft=a("blockquote"),Ft.innerHTML=Di,Er=r(),Nt=a("blockquote"),Nt.innerHTML=Pi,Or=r(),Ht=a("blockquote"),Ht.innerHTML=Ii,Fr=r(),Bt=a("blockquote"),Bt.innerHTML=Mi,wo=r(),L=a("div"),d(Me.$$.fragment),Nr=r(),Gt=a("p"),Gt.textContent=ki,Hr=r(),St=a("p"),St.textContent=qi,Br=r(),Rt=a("p"),Rt.textContent=Ei,Gr=r(),po=a("blockquote"),co=a("blockquote"),ke=a("blockquote"),d(qe.$$.fragment),Sr=r(),Vt=a("p"),Vt.textContent=Oi,Rr=r(),go=a("blockquote"),uo=a("blockquote"),Ee=a("blockquote"),d(Oe.$$.fragment),Vr=r(),Ut=a("p"),Ut.textContent=Fi,Co=r(),d(Fe.$$.fragment),Lo=r(),T=a("div"),d(Ne.$$.fragment),Ur=r(),Wt=a("p"),Wt.textContent=Ni,Wr=r(),jt=a("p"),jt.textContent=Hi,jr=r(),Qt=a("p"),Qt.innerHTML=Bi,Qr=r(),Kt=a("ul"),Kt.innerHTML=Gi,Kr=r(),Z=a("div"),d(He.$$.fragment),Zr=r(),Zt=a("p"),Zt.textContent=Si,To=r(),w=a("div"),d(Be.$$.fragment),Xr=r(),Xt=a("p"),Xt.textContent=Ri,Jr=r(),Jt=a("p"),Jt.innerHTML=Vi,Yr=r(),Yt=a("p"),Yt.innerHTML=Ui,en=r(),ea=a("p"),ea.innerHTML=Wi,tn=r(),ta=a("p"),ta.textContent=ji,an=r(),X=a("div"),d(Ge.$$.fragment),on=r(),aa=a("p"),aa.textContent=Qi,Ao=r(),S=a("div"),d(Se.$$.fragment),rn=r(),oa=a("p"),oa.textContent=Ki,nn=r(),ra=a("p"),ra.innerHTML=Zi,zo=r(),A=a("div"),d(Re.$$.fragment),ln=r(),na=a("p"),na.textContent=Xi,sn=r(),J=a("div"),d(Ve.$$.fragment),mn=r(),ia=a("p"),ia.textContent=Ji,pn=r(),Y=a("div"),d(Ue.$$.fragment),dn=r(),la=a("p"),la.textContent=Yi,cn=r(),ee=a("div"),d(We.$$.fragment),gn=r(),sa=a("p"),sa.textContent=el,un=r(),te=a("div"),d(je.$$.fragment),hn=r(),ma=a("p"),ma.textContent=tl,Do=r(),Qe=a("div"),d(Ke.$$.fragment),Po=r(),q=a("div"),d(Ze.$$.fragment),fn=r(),pa=a("p"),pa.textContent=al,vn=r(),da=a("p"),da.innerHTML=ol,bn=r(),ae=a("div"),d(Xe.$$.fragment),_n=r(),ca=a("p"),ca.textContent=rl,Io=r(),R=a("div"),d(Je.$$.fragment),yn=r(),ga=a("p"),ga.innerHTML=nl,xn=r(),oe=a("div"),d(Ye.$$.fragment),$n=r(),ua=a("p"),ua.textContent=il,Mo=r(),I=a("div"),d(et.$$.fragment),wn=r(),ha=a("p"),ha.innerHTML=ll,Cn=r(),fa=a("p"),fa.textContent=sl,Ln=r(),va=a("ul"),va.innerHTML=ml,Tn=r(),re=a("div"),d(tt.$$.fragment),An=r(),ba=a("p"),ba.textContent=pl,ko=r(),E=a("div"),d(at.$$.fragment),zn=r(),_a=a("p"),_a.textContent=dl,Dn=r(),ya=a("p"),ya.innerHTML=cl,Pn=r(),ne=a("div"),d(ot.$$.fragment),In=r(),xa=a("p"),xa.textContent=gl,qo=r(),O=a("div"),d(rt.$$.fragment),Mn=r(),$a=a("p"),$a.textContent=ul,kn=r(),wa=a("p"),wa.innerHTML=hl,qn=r(),ie=a("div"),d(nt.$$.fragment),En=r(),Ca=a("p"),Ca.textContent=fl,Eo=r(),V=a("div"),d(it.$$.fragment),On=r(),La=a("p"),La.textContent=vl,Fn=r(),le=a("div"),d(lt.$$.fragment),Nn=r(),Ta=a("p"),Ta.textContent=bl,Oo=r(),st=a("div"),d(mt.$$.fragment),Fo=r(),C=a("div"),d(pt.$$.fragment),Hn=r(),Aa=a("p"),Aa.textContent=_l,Bn=r(),za=a("p"),za.innerHTML=yl,Gn=r(),Da=a("p"),Da.textContent=xl,Sn=r(),Pa=a("p"),Pa.textContent=$l,Rn=r(),Ia=a("p"),Ia.textContent=wl,Vn=r(),se=a("div"),d(dt.$$.fragment),Un=r(),Ma=a("p"),Ma.textContent=Cl,No=r(),F=a("div"),d(ct.$$.fragment),Wn=r(),ka=a("p"),ka.textContent=Ll,jn=r(),qa=a("p"),qa.innerHTML=Tl,Qn=r(),me=a("div"),d(gt.$$.fragment),Kn=r(),Ea=a("p"),Ea.textContent=Al,Ho=r(),z=a("div"),d(ut.$$.fragment),Zn=r(),Oa=a("p"),Oa.textContent=zl,Xn=r(),Fa=a("p"),Fa.innerHTML=Dl,Jn=r(),Na=a("p"),Na.textContent=Pl,Yn=r(),Ha=a("ul"),Ha.innerHTML=Il,ei=r(),pe=a("div"),d(ht.$$.fragment),ti=r(),Ba=a("p"),Ba.textContent=Ml,Bo=r(),U=a("div"),d(ft.$$.fragment),ai=r(),Ga=a("p"),Ga.textContent=kl,oi=r(),de=a("div"),d(vt.$$.fragment),ri=r(),Sa=a("p"),Sa.textContent=ql,Go=r(),x=a("div"),d(bt.$$.fragment),ni=r(),Ra=a("p"),Ra.textContent=El,ii=r(),Va=a("p"),Va.textContent=Ol,li=r(),Ua=a("p"),Ua.textContent=Fl,si=r(),Wa=a("ol"),Wa.innerHTML=Nl,mi=r(),ja=a("p"),ja.innerHTML=Hl,pi=r(),Qa=a("p"),Qa.innerHTML=Bl,di=r(),ce=a("div"),d(_t.$$.fragment),ci=r(),Ka=a("p"),Ka.textContent=Gl,So=r(),yt=a("div"),d(xt.$$.fragment),Ro=r(),K=a("div"),d($t.$$.fragment),gi=r(),ge=a("div"),d(wt.$$.fragment),ui=r(),Za=a("p"),Za.textContent=Sl,Vo=r(),d(Ct.$$.fragment),Uo=r(),ho=a("p"),this.h()},l(e){const s=ms("svelte-u9bgzb",document.head);Q=o(s,"META",{name:!0,content:!0}),s.forEach(i),fo=n(e),to=o(e,"P",{}),m(to).forEach(i),vo=n(e),c(be.$$.fragment,e),bo=n(e),_e=o(e,"P",{"data-svelte-h":!0}),l(_e)!=="svelte-1c6qm22"&&(_e.innerHTML=fi),_o=n(e),c(ye.$$.fragment,e),yo=n(e),c(xe.$$.fragment,e),xo=n(e),_=o(e,"DIV",{class:!0});var $=m(_);c($e.$$.fragment,$),br=n($),Lt=o($,"P",{"data-svelte-h":!0}),l(Lt)!=="svelte-1330e7"&&(Lt.textContent=vi),_r=n($),Tt=o($,"P",{"data-svelte-h":!0}),l(Tt)!=="svelte-9cjiwr"&&(Tt.textContent=bi),yr=n($),At=o($,"P",{"data-svelte-h":!0}),l(At)!=="svelte-kvfsh7"&&(At.textContent=_i),xr=n($),ao=o($,"BLOCKQUOTE",{});var Rl=m(ao);oo=o(Rl,"BLOCKQUOTE",{});var Vl=m(oo);we=o(Vl,"BLOCKQUOTE",{});var jo=m(we);c(Ce.$$.fragment,jo),$r=n(jo),zt=o(jo,"P",{"data-svelte-h":!0}),l(zt)!=="svelte-180ncmf"&&(zt.textContent=yi),jo.forEach(i),Vl.forEach(i),Rl.forEach(i),wr=n($),ro=o($,"BLOCKQUOTE",{});var Ul=m(ro);no=o(Ul,"BLOCKQUOTE",{});var Wl=m(no);Le=o(Wl,"BLOCKQUOTE",{});var Qo=m(Le);c(Te.$$.fragment,Qo),Cr=n(Qo),Dt=o(Qo,"P",{"data-svelte-h":!0}),l(Dt)!=="svelte-6yrpk7"&&(Dt.textContent=xi),Qo.forEach(i),Wl.forEach(i),Ul.forEach(i),Lr=n($),io=o($,"BLOCKQUOTE",{});var jl=m(io);lo=o(jl,"BLOCKQUOTE",{});var Ql=m(lo);Ae=o(Ql,"BLOCKQUOTE",{});var Ko=m(Ae);c(ze.$$.fragment,Ko),Tr=n(Ko),Pt=o(Ko,"P",{"data-svelte-h":!0}),l(Pt)!=="svelte-1vmtu70"&&(Pt.textContent=$i),Ko.forEach(i),Ql.forEach(i),jl.forEach(i),Ar=n($),so=o($,"BLOCKQUOTE",{});var Kl=m(so);mo=o(Kl,"BLOCKQUOTE",{});var Zl=m(mo);De=o(Zl,"BLOCKQUOTE",{});var Zo=m(De);c(Pe.$$.fragment,Zo),zr=n(Zo),It=o(Zo,"P",{"data-svelte-h":!0}),l(It)!=="svelte-15ovmpe"&&(It.textContent=wi),Zo.forEach(i),Zl.forEach(i),Kl.forEach(i),Dr=n($),Mt=o($,"P",{"data-svelte-h":!0}),l(Mt)!=="svelte-sgpn75"&&(Mt.textContent=Ci),Pr=n($),kt=o($,"OL",{"data-svelte-h":!0}),l(kt)!=="svelte-psaz57"&&(kt.innerHTML=Li),$.forEach(i),$o=n(e),y=o(e,"DIV",{class:!0});var D=m(y);c(Ie.$$.fragment,D),Ir=n(D),qt=o(D,"P",{"data-svelte-h":!0}),l(qt)!=="svelte-1h2sspw"&&(qt.textContent=Ti),Mr=n(D),Et=o(D,"P",{"data-svelte-h":!0}),l(Et)!=="svelte-1tapwxe"&&(Et.textContent=Ai),kr=n(D),Ot=o(D,"P",{"data-svelte-h":!0}),l(Ot)!=="svelte-kvfsh7"&&(Ot.textContent=zi),qr=n(D),Ft=o(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Ft)!=="svelte-m875zf"&&(Ft.innerHTML=Di),Er=n(D),Nt=o(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Nt)!=="svelte-1mioyvo"&&(Nt.innerHTML=Pi),Or=n(D),Ht=o(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Ht)!=="svelte-ji9gfr"&&(Ht.innerHTML=Ii),Fr=n(D),Bt=o(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Bt)!=="svelte-tvmm3x"&&(Bt.innerHTML=Mi),D.forEach(i),wo=n(e),L=o(e,"DIV",{class:!0});var N=m(L);c(Me.$$.fragment,N),Nr=n(N),Gt=o(N,"P",{"data-svelte-h":!0}),l(Gt)!=="svelte-1rcjgrx"&&(Gt.textContent=ki),Hr=n(N),St=o(N,"P",{"data-svelte-h":!0}),l(St)!=="svelte-13jhmtj"&&(St.textContent=qi),Br=n(N),Rt=o(N,"P",{"data-svelte-h":!0}),l(Rt)!=="svelte-kvfsh7"&&(Rt.textContent=Ei),Gr=n(N),po=o(N,"BLOCKQUOTE",{});var Xl=m(po);co=o(Xl,"BLOCKQUOTE",{});var Jl=m(co);ke=o(Jl,"BLOCKQUOTE",{});var Xo=m(ke);c(qe.$$.fragment,Xo),Sr=n(Xo),Vt=o(Xo,"P",{"data-svelte-h":!0}),l(Vt)!=="svelte-1en25gb"&&(Vt.textContent=Oi),Xo.forEach(i),Jl.forEach(i),Xl.forEach(i),Rr=n(N),go=o(N,"BLOCKQUOTE",{});var Yl=m(go);uo=o(Yl,"BLOCKQUOTE",{});var es=m(uo);Ee=o(es,"BLOCKQUOTE",{});var Jo=m(Ee);c(Oe.$$.fragment,Jo),Vr=n(Jo),Ut=o(Jo,"P",{"data-svelte-h":!0}),l(Ut)!=="svelte-gfx8y2"&&(Ut.textContent=Fi),Jo.forEach(i),es.forEach(i),Yl.forEach(i),N.forEach(i),Co=n(e),c(Fe.$$.fragment,e),Lo=n(e),T=o(e,"DIV",{class:!0});var H=m(T);c(Ne.$$.fragment,H),Ur=n(H),Wt=o(H,"P",{"data-svelte-h":!0}),l(Wt)!=="svelte-1hnunr4"&&(Wt.textContent=Ni),Wr=n(H),jt=o(H,"P",{"data-svelte-h":!0}),l(jt)!=="svelte-1cjb7xo"&&(jt.textContent=Hi),jr=n(H),Qt=o(H,"P",{"data-svelte-h":!0}),l(Qt)!=="svelte-1347q2l"&&(Qt.innerHTML=Bi),Qr=n(H),Kt=o(H,"UL",{"data-svelte-h":!0}),l(Kt)!=="svelte-4wdkvs"&&(Kt.innerHTML=Gi),Kr=n(H),Z=o(H,"DIV",{class:!0});var Yo=m(Z);c(He.$$.fragment,Yo),Zr=n(Yo),Zt=o(Yo,"P",{"data-svelte-h":!0}),l(Zt)!=="svelte-1gr03w4"&&(Zt.textContent=Si),Yo.forEach(i),H.forEach(i),To=n(e),w=o(e,"DIV",{class:!0});var M=m(w);c(Be.$$.fragment,M),Xr=n(M),Xt=o(M,"P",{"data-svelte-h":!0}),l(Xt)!=="svelte-1j9mkxe"&&(Xt.textContent=Ri),Jr=n(M),Jt=o(M,"P",{"data-svelte-h":!0}),l(Jt)!=="svelte-1xvyiun"&&(Jt.innerHTML=Vi),Yr=n(M),Yt=o(M,"P",{"data-svelte-h":!0}),l(Yt)!=="svelte-1i7ubkr"&&(Yt.innerHTML=Ui),en=n(M),ea=o(M,"P",{"data-svelte-h":!0}),l(ea)!=="svelte-96f97i"&&(ea.innerHTML=Wi),tn=n(M),ta=o(M,"P",{"data-svelte-h":!0}),l(ta)!=="svelte-1q67fqp"&&(ta.textContent=ji),an=n(M),X=o(M,"DIV",{class:!0});var er=m(X);c(Ge.$$.fragment,er),on=n(er),aa=o(er,"P",{"data-svelte-h":!0}),l(aa)!=="svelte-1gr03w4"&&(aa.textContent=Qi),er.forEach(i),M.forEach(i),Ao=n(e),S=o(e,"DIV",{class:!0});var Xa=m(S);c(Se.$$.fragment,Xa),rn=n(Xa),oa=o(Xa,"P",{"data-svelte-h":!0}),l(oa)!=="svelte-19t8yzj"&&(oa.textContent=Ki),nn=n(Xa),ra=o(Xa,"P",{"data-svelte-h":!0}),l(ra)!=="svelte-aajaln"&&(ra.innerHTML=Zi),Xa.forEach(i),zo=n(e),A=o(e,"DIV",{class:!0});var B=m(A);c(Re.$$.fragment,B),ln=n(B),na=o(B,"P",{"data-svelte-h":!0}),l(na)!=="svelte-1cuo0rh"&&(na.textContent=Xi),sn=n(B),J=o(B,"DIV",{class:!0});var tr=m(J);c(Ve.$$.fragment,tr),mn=n(tr),ia=o(tr,"P",{"data-svelte-h":!0}),l(ia)!=="svelte-1jz1hl7"&&(ia.textContent=Ji),tr.forEach(i),pn=n(B),Y=o(B,"DIV",{class:!0});var ar=m(Y);c(Ue.$$.fragment,ar),dn=n(ar),la=o(ar,"P",{"data-svelte-h":!0}),l(la)!=="svelte-1y1oyzd"&&(la.textContent=Yi),ar.forEach(i),cn=n(B),ee=o(B,"DIV",{class:!0});var or=m(ee);c(We.$$.fragment,or),gn=n(or),sa=o(or,"P",{"data-svelte-h":!0}),l(sa)!=="svelte-1gr03w4"&&(sa.textContent=el),or.forEach(i),un=n(B),te=o(B,"DIV",{class:!0});var rr=m(te);c(je.$$.fragment,rr),hn=n(rr),ma=o(rr,"P",{"data-svelte-h":!0}),l(ma)!=="svelte-1dbbmmp"&&(ma.textContent=tl),rr.forEach(i),B.forEach(i),Do=n(e),Qe=o(e,"DIV",{class:!0});var ts=m(Qe);c(Ke.$$.fragment,ts),ts.forEach(i),Po=n(e),q=o(e,"DIV",{class:!0});var ue=m(q);c(Ze.$$.fragment,ue),fn=n(ue),pa=o(ue,"P",{"data-svelte-h":!0}),l(pa)!=="svelte-1vdc41k"&&(pa.textContent=al),vn=n(ue),da=o(ue,"P",{"data-svelte-h":!0}),l(da)!=="svelte-1vkysjq"&&(da.innerHTML=ol),bn=n(ue),ae=o(ue,"DIV",{class:!0});var nr=m(ae);c(Xe.$$.fragment,nr),_n=n(nr),ca=o(nr,"P",{"data-svelte-h":!0}),l(ca)!=="svelte-1gr03w4"&&(ca.textContent=rl),nr.forEach(i),ue.forEach(i),Io=n(e),R=o(e,"DIV",{class:!0});var Ja=m(R);c(Je.$$.fragment,Ja),yn=n(Ja),ga=o(Ja,"P",{"data-svelte-h":!0}),l(ga)!=="svelte-bxurot"&&(ga.innerHTML=nl),xn=n(Ja),oe=o(Ja,"DIV",{class:!0});var ir=m(oe);c(Ye.$$.fragment,ir),$n=n(ir),ua=o(ir,"P",{"data-svelte-h":!0}),l(ua)!=="svelte-1siu6mf"&&(ua.textContent=il),ir.forEach(i),Ja.forEach(i),Mo=n(e),I=o(e,"DIV",{class:!0});var W=m(I);c(et.$$.fragment,W),wn=n(W),ha=o(W,"P",{"data-svelte-h":!0}),l(ha)!=="svelte-d5zqgn"&&(ha.innerHTML=ll),Cn=n(W),fa=o(W,"P",{"data-svelte-h":!0}),l(fa)!=="svelte-9itjiu"&&(fa.textContent=sl),Ln=n(W),va=o(W,"UL",{"data-svelte-h":!0}),l(va)!=="svelte-ylo4gl"&&(va.innerHTML=ml),Tn=n(W),re=o(W,"DIV",{class:!0});var lr=m(re);c(tt.$$.fragment,lr),An=n(lr),ba=o(lr,"P",{"data-svelte-h":!0}),l(ba)!=="svelte-1gr03w4"&&(ba.textContent=pl),lr.forEach(i),W.forEach(i),ko=n(e),E=o(e,"DIV",{class:!0});var he=m(E);c(at.$$.fragment,he),zn=n(he),_a=o(he,"P",{"data-svelte-h":!0}),l(_a)!=="svelte-1ky75u7"&&(_a.textContent=dl),Dn=n(he),ya=o(he,"P",{"data-svelte-h":!0}),l(ya)!=="svelte-ee3cwp"&&(ya.innerHTML=cl),Pn=n(he),ne=o(he,"DIV",{class:!0});var sr=m(ne);c(ot.$$.fragment,sr),In=n(sr),xa=o(sr,"P",{"data-svelte-h":!0}),l(xa)!=="svelte-1gr03w4"&&(xa.textContent=gl),sr.forEach(i),he.forEach(i),qo=n(e),O=o(e,"DIV",{class:!0});var fe=m(O);c(rt.$$.fragment,fe),Mn=n(fe),$a=o(fe,"P",{"data-svelte-h":!0}),l($a)!=="svelte-vzcsb8"&&($a.textContent=ul),kn=n(fe),wa=o(fe,"P",{"data-svelte-h":!0}),l(wa)!=="svelte-euart9"&&(wa.innerHTML=hl),qn=n(fe),ie=o(fe,"DIV",{class:!0});var mr=m(ie);c(nt.$$.fragment,mr),En=n(mr),Ca=o(mr,"P",{"data-svelte-h":!0}),l(Ca)!=="svelte-1gr03w4"&&(Ca.textContent=fl),mr.forEach(i),fe.forEach(i),Eo=n(e),V=o(e,"DIV",{class:!0});var Ya=m(V);c(it.$$.fragment,Ya),On=n(Ya),La=o(Ya,"P",{"data-svelte-h":!0}),l(La)!=="svelte-pwyp7b"&&(La.textContent=vl),Fn=n(Ya),le=o(Ya,"DIV",{class:!0});var pr=m(le);c(lt.$$.fragment,pr),Nn=n(pr),Ta=o(pr,"P",{"data-svelte-h":!0}),l(Ta)!=="svelte-1gr03w4"&&(Ta.textContent=bl),pr.forEach(i),Ya.forEach(i),Oo=n(e),st=o(e,"DIV",{class:!0});var as=m(st);c(mt.$$.fragment,as),as.forEach(i),Fo=n(e),C=o(e,"DIV",{class:!0});var k=m(C);c(pt.$$.fragment,k),Hn=n(k),Aa=o(k,"P",{"data-svelte-h":!0}),l(Aa)!=="svelte-wmmdpx"&&(Aa.textContent=_l),Bn=n(k),za=o(k,"P",{"data-svelte-h":!0}),l(za)!=="svelte-12dyngi"&&(za.innerHTML=yl),Gn=n(k),Da=o(k,"P",{"data-svelte-h":!0}),l(Da)!=="svelte-qjjdis"&&(Da.textContent=xl),Sn=n(k),Pa=o(k,"P",{"data-svelte-h":!0}),l(Pa)!=="svelte-rosfou"&&(Pa.textContent=$l),Rn=n(k),Ia=o(k,"P",{"data-svelte-h":!0}),l(Ia)!=="svelte-hlwvkn"&&(Ia.textContent=wl),Vn=n(k),se=o(k,"DIV",{class:!0});var dr=m(se);c(dt.$$.fragment,dr),Un=n(dr),Ma=o(dr,"P",{"data-svelte-h":!0}),l(Ma)!=="svelte-1gr03w4"&&(Ma.textContent=Cl),dr.forEach(i),k.forEach(i),No=n(e),F=o(e,"DIV",{class:!0});var ve=m(F);c(ct.$$.fragment,ve),Wn=n(ve),ka=o(ve,"P",{"data-svelte-h":!0}),l(ka)!=="svelte-yn9hq2"&&(ka.textContent=Ll),jn=n(ve),qa=o(ve,"P",{"data-svelte-h":!0}),l(qa)!=="svelte-1l0d0b"&&(qa.innerHTML=Tl),Qn=n(ve),me=o(ve,"DIV",{class:!0});var cr=m(me);c(gt.$$.fragment,cr),Kn=n(cr),Ea=o(cr,"P",{"data-svelte-h":!0}),l(Ea)!=="svelte-1gr03w4"&&(Ea.textContent=Al),cr.forEach(i),ve.forEach(i),Ho=n(e),z=o(e,"DIV",{class:!0});var G=m(z);c(ut.$$.fragment,G),Zn=n(G),Oa=o(G,"P",{"data-svelte-h":!0}),l(Oa)!=="svelte-3mtxcr"&&(Oa.textContent=zl),Xn=n(G),Fa=o(G,"P",{"data-svelte-h":!0}),l(Fa)!=="svelte-1kok3gr"&&(Fa.innerHTML=Dl),Jn=n(G),Na=o(G,"P",{"data-svelte-h":!0}),l(Na)!=="svelte-1usqxsj"&&(Na.textContent=Pl),Yn=n(G),Ha=o(G,"UL",{"data-svelte-h":!0}),l(Ha)!=="svelte-xfb8g2"&&(Ha.innerHTML=Il),ei=n(G),pe=o(G,"DIV",{class:!0});var gr=m(pe);c(ht.$$.fragment,gr),ti=n(gr),Ba=o(gr,"P",{"data-svelte-h":!0}),l(Ba)!=="svelte-1gr03w4"&&(Ba.textContent=Ml),gr.forEach(i),G.forEach(i),Bo=n(e),U=o(e,"DIV",{class:!0});var eo=m(U);c(ft.$$.fragment,eo),ai=n(eo),Ga=o(eo,"P",{"data-svelte-h":!0}),l(Ga)!=="svelte-5vv99d"&&(Ga.textContent=kl),oi=n(eo),de=o(eo,"DIV",{class:!0});var ur=m(de);c(vt.$$.fragment,ur),ri=n(ur),Sa=o(ur,"P",{"data-svelte-h":!0}),l(Sa)!=="svelte-1gr03w4"&&(Sa.textContent=ql),ur.forEach(i),eo.forEach(i),Go=n(e),x=o(e,"DIV",{class:!0});var P=m(x);c(bt.$$.fragment,P),ni=n(P),Ra=o(P,"P",{"data-svelte-h":!0}),l(Ra)!=="svelte-1tqv0s5"&&(Ra.textContent=El),ii=n(P),Va=o(P,"P",{"data-svelte-h":!0}),l(Va)!=="svelte-g10xv4"&&(Va.textContent=Ol),li=n(P),Ua=o(P,"P",{"data-svelte-h":!0}),l(Ua)!=="svelte-1acg3vg"&&(Ua.textContent=Fl),si=n(P),Wa=o(P,"OL",{"data-svelte-h":!0}),l(Wa)!=="svelte-15y6o6y"&&(Wa.innerHTML=Nl),mi=n(P),ja=o(P,"P",{"data-svelte-h":!0}),l(ja)!=="svelte-1yvkj2h"&&(ja.innerHTML=Hl),pi=n(P),Qa=o(P,"P",{"data-svelte-h":!0}),l(Qa)!=="svelte-53x1ow"&&(Qa.innerHTML=Bl),di=n(P),ce=o(P,"DIV",{class:!0});var hr=m(ce);c(_t.$$.fragment,hr),ci=n(hr),Ka=o(hr,"P",{"data-svelte-h":!0}),l(Ka)!=="svelte-1gr03w4"&&(Ka.textContent=Gl),hr.forEach(i),P.forEach(i),So=n(e),yt=o(e,"DIV",{class:!0});var os=m(yt);c(xt.$$.fragment,os),os.forEach(i),Ro=n(e),K=o(e,"DIV",{class:!0});var fr=m(K);c($t.$$.fragment,fr),gi=n(fr),ge=o(fr,"DIV",{class:!0});var vr=m(ge);c(wt.$$.fragment,vr),ui=n(vr),Za=o(vr,"P",{"data-svelte-h":!0}),l(Za)!=="svelte-1gr03w4"&&(Za.textContent=Sl),vr.forEach(i),fr.forEach(i),Vo=n(e),c(Ct.$$.fragment,e),Uo=n(e),ho=o(e,"P",{}),m(ho).forEach(i),this.h()},h(){v(Q,"name","hf:doc:metadata"),v(Q,"content",cs),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,Q),p(e,fo,s),p(e,to,s),p(e,vo,s),g(be,e,s),p(e,bo,s),p(e,_e,s),p(e,_o,s),g(ye,e,s),p(e,yo,s),g(xe,e,s),p(e,xo,s),p(e,_,s),g($e,_,null),t(_,br),t(_,Lt),t(_,_r),t(_,Tt),t(_,yr),t(_,At),t(_,xr),t(_,ao),t(ao,oo),t(oo,we),g(Ce,we,null),t(we,$r),t(we,zt),t(_,wr),t(_,ro),t(ro,no),t(no,Le),g(Te,Le,null),t(Le,Cr),t(Le,Dt),t(_,Lr),t(_,io),t(io,lo),t(lo,Ae),g(ze,Ae,null),t(Ae,Tr),t(Ae,Pt),t(_,Ar),t(_,so),t(so,mo),t(mo,De),g(Pe,De,null),t(De,zr),t(De,It),t(_,Dr),t(_,Mt),t(_,Pr),t(_,kt),p(e,$o,s),p(e,y,s),g(Ie,y,null),t(y,Ir),t(y,qt),t(y,Mr),t(y,Et),t(y,kr),t(y,Ot),t(y,qr),t(y,Ft),t(y,Er),t(y,Nt),t(y,Or),t(y,Ht),t(y,Fr),t(y,Bt),p(e,wo,s),p(e,L,s),g(Me,L,null),t(L,Nr),t(L,Gt),t(L,Hr),t(L,St),t(L,Br),t(L,Rt),t(L,Gr),t(L,po),t(po,co),t(co,ke),g(qe,ke,null),t(ke,Sr),t(ke,Vt),t(L,Rr),t(L,go),t(go,uo),t(uo,Ee),g(Oe,Ee,null),t(Ee,Vr),t(Ee,Ut),p(e,Co,s),g(Fe,e,s),p(e,Lo,s),p(e,T,s),g(Ne,T,null),t(T,Ur),t(T,Wt),t(T,Wr),t(T,jt),t(T,jr),t(T,Qt),t(T,Qr),t(T,Kt),t(T,Kr),t(T,Z),g(He,Z,null),t(Z,Zr),t(Z,Zt),p(e,To,s),p(e,w,s),g(Be,w,null),t(w,Xr),t(w,Xt),t(w,Jr),t(w,Jt),t(w,Yr),t(w,Yt),t(w,en),t(w,ea),t(w,tn),t(w,ta),t(w,an),t(w,X),g(Ge,X,null),t(X,on),t(X,aa),p(e,Ao,s),p(e,S,s),g(Se,S,null),t(S,rn),t(S,oa),t(S,nn),t(S,ra),p(e,zo,s),p(e,A,s),g(Re,A,null),t(A,ln),t(A,na),t(A,sn),t(A,J),g(Ve,J,null),t(J,mn),t(J,ia),t(A,pn),t(A,Y),g(Ue,Y,null),t(Y,dn),t(Y,la),t(A,cn),t(A,ee),g(We,ee,null),t(ee,gn),t(ee,sa),t(A,un),t(A,te),g(je,te,null),t(te,hn),t(te,ma),p(e,Do,s),p(e,Qe,s),g(Ke,Qe,null),p(e,Po,s),p(e,q,s),g(Ze,q,null),t(q,fn),t(q,pa),t(q,vn),t(q,da),t(q,bn),t(q,ae),g(Xe,ae,null),t(ae,_n),t(ae,ca),p(e,Io,s),p(e,R,s),g(Je,R,null),t(R,yn),t(R,ga),t(R,xn),t(R,oe),g(Ye,oe,null),t(oe,$n),t(oe,ua),p(e,Mo,s),p(e,I,s),g(et,I,null),t(I,wn),t(I,ha),t(I,Cn),t(I,fa),t(I,Ln),t(I,va),t(I,Tn),t(I,re),g(tt,re,null),t(re,An),t(re,ba),p(e,ko,s),p(e,E,s),g(at,E,null),t(E,zn),t(E,_a),t(E,Dn),t(E,ya),t(E,Pn),t(E,ne),g(ot,ne,null),t(ne,In),t(ne,xa),p(e,qo,s),p(e,O,s),g(rt,O,null),t(O,Mn),t(O,$a),t(O,kn),t(O,wa),t(O,qn),t(O,ie),g(nt,ie,null),t(ie,En),t(ie,Ca),p(e,Eo,s),p(e,V,s),g(it,V,null),t(V,On),t(V,La),t(V,Fn),t(V,le),g(lt,le,null),t(le,Nn),t(le,Ta),p(e,Oo,s),p(e,st,s),g(mt,st,null),p(e,Fo,s),p(e,C,s),g(pt,C,null),t(C,Hn),t(C,Aa),t(C,Bn),t(C,za),t(C,Gn),t(C,Da),t(C,Sn),t(C,Pa),t(C,Rn),t(C,Ia),t(C,Vn),t(C,se),g(dt,se,null),t(se,Un),t(se,Ma),p(e,No,s),p(e,F,s),g(ct,F,null),t(F,Wn),t(F,ka),t(F,jn),t(F,qa),t(F,Qn),t(F,me),g(gt,me,null),t(me,Kn),t(me,Ea),p(e,Ho,s),p(e,z,s),g(ut,z,null),t(z,Zn),t(z,Oa),t(z,Xn),t(z,Fa),t(z,Jn),t(z,Na),t(z,Yn),t(z,Ha),t(z,ei),t(z,pe),g(ht,pe,null),t(pe,ti),t(pe,Ba),p(e,Bo,s),p(e,U,s),g(ft,U,null),t(U,ai),t(U,Ga),t(U,oi),t(U,de),g(vt,de,null),t(de,ri),t(de,Sa),p(e,Go,s),p(e,x,s),g(bt,x,null),t(x,ni),t(x,Ra),t(x,ii),t(x,Va),t(x,li),t(x,Ua),t(x,si),t(x,Wa),t(x,mi),t(x,ja),t(x,pi),t(x,Qa),t(x,di),t(x,ce),g(_t,ce,null),t(ce,ci),t(ce,Ka),p(e,So,s),p(e,yt,s),g(xt,yt,null),p(e,Ro,s),p(e,K,s),g($t,K,null),t(K,gi),t(K,ge),g(wt,ge,null),t(ge,ui),t(ge,Za),p(e,Vo,s),g(Ct,e,s),p(e,Uo,s),p(e,ho,s),Wo=!0},p:ns,i(e){Wo||(u(be.$$.fragment,e),u(ye.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Ce.$$.fragment,e),u(Te.$$.fragment,e),u(ze.$$.fragment,e),u(Pe.$$.fragment,e),u(Ie.$$.fragment,e),u(Me.$$.fragment,e),u(qe.$$.fragment,e),u(Oe.$$.fragment,e),u(Fe.$$.fragment,e),u(Ne.$$.fragment,e),u(He.$$.fragment,e),u(Be.$$.fragment,e),u(Ge.$$.fragment,e),u(Se.$$.fragment,e),u(Re.$$.fragment,e),u(Ve.$$.fragment,e),u(Ue.$$.fragment,e),u(We.$$.fragment,e),u(je.$$.fragment,e),u(Ke.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Je.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(ot.$$.fragment,e),u(rt.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),u(lt.$$.fragment,e),u(mt.$$.fragment,e),u(pt.$$.fragment,e),u(dt.$$.fragment,e),u(ct.$$.fragment,e),u(gt.$$.fragment,e),u(ut.$$.fragment,e),u(ht.$$.fragment,e),u(ft.$$.fragment,e),u(vt.$$.fragment,e),u(bt.$$.fragment,e),u(_t.$$.fragment,e),u(xt.$$.fragment,e),u($t.$$.fragment,e),u(wt.$$.fragment,e),u(Ct.$$.fragment,e),Wo=!0)},o(e){h(be.$$.fragment,e),h(ye.$$.fragment,e),h(xe.$$.fragment,e),h($e.$$.fragment,e),h(Ce.$$.fragment,e),h(Te.$$.fragment,e),h(ze.$$.fragment,e),h(Pe.$$.fragment,e),h(Ie.$$.fragment,e),h(Me.$$.fragment,e),h(qe.$$.fragment,e),h(Oe.$$.fragment,e),h(Fe.$$.fragment,e),h(Ne.$$.fragment,e),h(He.$$.fragment,e),h(Be.$$.fragment,e),h(Ge.$$.fragment,e),h(Se.$$.fragment,e),h(Re.$$.fragment,e),h(Ve.$$.fragment,e),h(Ue.$$.fragment,e),h(We.$$.fragment,e),h(je.$$.fragment,e),h(Ke.$$.fragment,e),h(Ze.$$.fragment,e),h(Xe.$$.fragment,e),h(Je.$$.fragment,e),h(Ye.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(at.$$.fragment,e),h(ot.$$.fragment,e),h(rt.$$.fragment,e),h(nt.$$.fragment,e),h(it.$$.fragment,e),h(lt.$$.fragment,e),h(mt.$$.fragment,e),h(pt.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(gt.$$.fragment,e),h(ut.$$.fragment,e),h(ht.$$.fragment,e),h(ft.$$.fragment,e),h(vt.$$.fragment,e),h(bt.$$.fragment,e),h(_t.$$.fragment,e),h(xt.$$.fragment,e),h($t.$$.fragment,e),h(wt.$$.fragment,e),h(Ct.$$.fragment,e),Wo=!1},d(e){e&&(i(fo),i(to),i(vo),i(bo),i(_e),i(_o),i(yo),i(xo),i(_),i($o),i(y),i(wo),i(L),i(Co),i(Lo),i(T),i(To),i(w),i(Ao),i(S),i(zo),i(A),i(Do),i(Qe),i(Po),i(q),i(Io),i(R),i(Mo),i(I),i(ko),i(E),i(qo),i(O),i(Eo),i(V),i(Oo),i(st),i(Fo),i(C),i(No),i(F),i(Ho),i(z),i(Bo),i(U),i(Go),i(x),i(So),i(yt),i(Ro),i(K),i(Vo),i(Uo),i(ho)),i(Q),f(be,e),f(ye,e),f(xe,e),f($e),f(Ce),f(Te),f(ze),f(Pe),f(Ie),f(Me),f(qe),f(Oe),f(Fe,e),f(Ne),f(He),f(Be),f(Ge),f(Se),f(Re),f(Ve),f(Ue),f(We),f(je),f(Ke),f(Ze),f(Xe),f(Je),f(Ye),f(et),f(tt),f(at),f(ot),f(rt),f(nt),f(it),f(lt),f(mt),f(pt),f(dt),f(ct),f(gt),f(ut),f(ht),f(ft),f(vt),f(bt),f(_t),f(xt),f($t),f(wt),f(Ct,e)}}}const cs='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizers","local":"optimizers","sections":[{"title":"Factory functions","local":"timm.optim.create_optimizer_v2","sections":[],"depth":3}],"depth":2}],"depth":1}';function gs(hi){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ls{constructor(Q){super(),ss(this,Q,gs,ds,rs,{})}}export{bs as component};
