import{s as Ws,n as $s,o as ks}from"../chunks/scheduler.85c25b89.js";import{S as Cs,i as Zs,g as p,s as e,r as i,A as Ns,h as m,f as l,c as n,j as Us,u as o,x as J,k as Is,y as xs,a as t,v as c,d as r,t as M,w as h}from"../chunks/index.c9837788.js";import{C as v}from"../chunks/CodeBlock.e573519b.js";import{H as Y,E as Gs}from"../chunks/getInferenceSnippets.2d2e232c.js";function Bs(hs){let g,z,S,_,T,X,d,Js="<strong>SelecSLS</strong> uses novel selective long and short range skip connections to improve the information flow allowing for a drastically faster network without compromising accuracy.",H,j,A,y,gs="To load a pretrained model:",F,w,D,u,Ts="To load and preprocess the image:",L,b,P,f,ds="To get the model predictions:",q,U,K,I,js="To get the top-5 predictions class names:",O,W,ss,$,ys="Replace the model name with the variant you want to use, e.g. <code>selecsls42b</code>. You can find the IDs in the model summaries at the top of this page.",as,k,ws='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ls,C,ts,Z,us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",es,N,ns,x,bs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ps,G,ms,B,fs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',is,E,os,Q,cs,R,rs,V,Ms;return T=new Y({props:{title:"SelecSLS",local:"selecsls",headingTag:"h1"}}),j=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),w=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NlbGVjc2xzNDJiJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;selecsls42b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),W=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),C=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2VsZWNzbHM0MmInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;selecsls42b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new v({props:{code:"JTQwYXJ0aWNsZSU3Qk1laHRhXzIwMjAlMkMlMEElMjAlMjAlMjB0aXRsZSUzRCU3QlhOZWN0JTdEJTJDJTBBJTIwJTIwJTIwdm9sdW1lJTNEJTdCMzklN0QlMkMlMEElMjAlMjAlMjBJU1NOJTNEJTdCMTU1Ny03MzY4JTdEJTJDJTBBJTIwJTIwJTIwdXJsJTNEJTdCaHR0cCUzQSUyRiUyRmR4LmRvaS5vcmclMkYxMC4xMTQ1JTJGMzM4NjU2OS4zMzkyNDEwJTdEJTJDJTBBJTIwJTIwJTIwRE9JJTNEJTdCMTAuMTE0NSUyRjMzODY1NjkuMzM5MjQxMCU3RCUyQyUwQSUyMCUyMCUyMG51bWJlciUzRCU3QjQlN0QlMkMlMEElMjAlMjAlMjBqb3VybmFsJTNEJTdCQUNNJTIwVHJhbnNhY3Rpb25zJTIwb24lMjBHcmFwaGljcyU3RCUyQyUwQSUyMCUyMCUyMHB1Ymxpc2hlciUzRCU3QkFzc29jaWF0aW9uJTIwZm9yJTIwQ29tcHV0aW5nJTIwTWFjaGluZXJ5JTIwKEFDTSklN0QlMkMlMEElMjAlMjAlMjBhdXRob3IlM0QlN0JNZWh0YSUyQyUyMER1c2h5YW50JTIwYW5kJTIwU290bnljaGVua28lMkMlMjBPbGVrc2FuZHIlMjBhbmQlMjBNdWVsbGVyJTJDJTIwRnJhbnppc2thJTIwYW5kJTIwWHUlMkMlMjBXZWlwZW5nJTIwYW5kJTIwRWxnaGFyaWIlMkMlMjBNb2hhbWVkJTIwYW5kJTIwRnVhJTJDJTIwUGFzY2FsJTIwYW5kJTIwU2VpZGVsJTJDJTIwSGFucy1QZXRlciUyMGFuZCUyMFJob2RpbiUyQyUyMEhlbGdlJTIwYW5kJTIwUG9ucy1Nb2xsJTJDJTIwR2VyYXJkJTIwYW5kJTIwVGhlb2JhbHQlMkMlMjBDaHJpc3RpYW4lN0QlMkMlMEElMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMG1vbnRoJTNEJTdCSnVsJTdEJTBBJTdE",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{Mehta_2020,
   title={XNect}</span><span class="language-xml">,
   volume=</span><span class="hljs-template-variable">{39}</span><span class="language-xml">,
   ISSN=</span><span class="hljs-template-variable">{1557-7368}</span><span class="language-xml">,
   url=</span><span class="hljs-template-variable">{http://dx.doi.org/10.1145/3386569.3392410}</span><span class="language-xml">,
   DOI=</span><span class="hljs-template-variable">{10.1145/3386569.3392410}</span><span class="language-xml">,
   number=</span><span class="hljs-template-variable">{4}</span><span class="language-xml">,
   journal=</span><span class="hljs-template-variable">{ACM Transactions on Graphics}</span><span class="language-xml">,
   publisher=</span><span class="hljs-template-variable">{Association for Computing Machinery (ACM)}</span><span class="language-xml">,
   author=</span><span class="hljs-template-variable">{Mehta, Dushyant and Sotnychenko, Oleksandr and Mueller, Franziska and Xu, Weipeng and Elgharib, Mohamed and Fua, Pascal and Seidel, Hans-Peter and Rhodin, Helge and Pons-Moll, Gerard and Theobalt, Christian}</span><span class="language-xml">,
   year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
   month=</span><span class="hljs-template-variable">{Jul}</span><span class="language-xml">
}</span>`,wrap:!1}}),R=new Gs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/selecsls.mdx"}}),{c(){g=p("meta"),z=e(),S=p("p"),_=e(),i(T.$$.fragment),X=e(),d=p("p"),d.innerHTML=Js,H=e(),i(j.$$.fragment),A=e(),y=p("p"),y.textContent=gs,F=e(),i(w.$$.fragment),D=e(),u=p("p"),u.textContent=Ts,L=e(),i(b.$$.fragment),P=e(),f=p("p"),f.textContent=ds,q=e(),i(U.$$.fragment),K=e(),I=p("p"),I.textContent=js,O=e(),i(W.$$.fragment),ss=e(),$=p("p"),$.innerHTML=ys,as=e(),k=p("p"),k.innerHTML=ws,ls=e(),i(C.$$.fragment),ts=e(),Z=p("p"),Z.textContent=us,es=e(),i(N.$$.fragment),ns=e(),x=p("p"),x.innerHTML=bs,ps=e(),i(G.$$.fragment),ms=e(),B=p("p"),B.innerHTML=fs,is=e(),i(E.$$.fragment),os=e(),i(Q.$$.fragment),cs=e(),i(R.$$.fragment),rs=e(),V=p("p"),this.h()},l(s){const a=Ns("svelte-u9bgzb",document.head);g=m(a,"META",{name:!0,content:!0}),a.forEach(l),z=n(s),S=m(s,"P",{}),Us(S).forEach(l),_=n(s),o(T.$$.fragment,s),X=n(s),d=m(s,"P",{"data-svelte-h":!0}),J(d)!=="svelte-4n5lf1"&&(d.innerHTML=Js),H=n(s),o(j.$$.fragment,s),A=n(s),y=m(s,"P",{"data-svelte-h":!0}),J(y)!=="svelte-18ywhxh"&&(y.textContent=gs),F=n(s),o(w.$$.fragment,s),D=n(s),u=m(s,"P",{"data-svelte-h":!0}),J(u)!=="svelte-1c2ipa8"&&(u.textContent=Ts),L=n(s),o(b.$$.fragment,s),P=n(s),f=m(s,"P",{"data-svelte-h":!0}),J(f)!=="svelte-1n9qsq1"&&(f.textContent=ds),q=n(s),o(U.$$.fragment,s),K=n(s),I=m(s,"P",{"data-svelte-h":!0}),J(I)!=="svelte-19cnvx1"&&(I.textContent=js),O=n(s),o(W.$$.fragment,s),ss=n(s),$=m(s,"P",{"data-svelte-h":!0}),J($)!=="svelte-1y4pu0a"&&($.innerHTML=ys),as=n(s),k=m(s,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1wmi3ea"&&(k.innerHTML=ws),ls=n(s),o(C.$$.fragment,s),ts=n(s),Z=m(s,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-9sr7nh"&&(Z.textContent=us),es=n(s),o(N.$$.fragment,s),ns=n(s),x=m(s,"P",{"data-svelte-h":!0}),J(x)!=="svelte-1kguc51"&&(x.innerHTML=bs),ps=n(s),o(G.$$.fragment,s),ms=n(s),B=m(s,"P",{"data-svelte-h":!0}),J(B)!=="svelte-xtxxu6"&&(B.innerHTML=fs),is=n(s),o(E.$$.fragment,s),os=n(s),o(Q.$$.fragment,s),cs=n(s),o(R.$$.fragment,s),rs=n(s),V=m(s,"P",{}),Us(V).forEach(l),this.h()},h(){Is(g,"name","hf:doc:metadata"),Is(g,"content",Es)},m(s,a){xs(document.head,g),t(s,z,a),t(s,S,a),t(s,_,a),c(T,s,a),t(s,X,a),t(s,d,a),t(s,H,a),c(j,s,a),t(s,A,a),t(s,y,a),t(s,F,a),c(w,s,a),t(s,D,a),t(s,u,a),t(s,L,a),c(b,s,a),t(s,P,a),t(s,f,a),t(s,q,a),c(U,s,a),t(s,K,a),t(s,I,a),t(s,O,a),c(W,s,a),t(s,ss,a),t(s,$,a),t(s,as,a),t(s,k,a),t(s,ls,a),c(C,s,a),t(s,ts,a),t(s,Z,a),t(s,es,a),c(N,s,a),t(s,ns,a),t(s,x,a),t(s,ps,a),c(G,s,a),t(s,ms,a),t(s,B,a),t(s,is,a),c(E,s,a),t(s,os,a),c(Q,s,a),t(s,cs,a),c(R,s,a),t(s,rs,a),t(s,V,a),Ms=!0},p:$s,i(s){Ms||(r(T.$$.fragment,s),r(j.$$.fragment,s),r(w.$$.fragment,s),r(b.$$.fragment,s),r(U.$$.fragment,s),r(W.$$.fragment,s),r(C.$$.fragment,s),r(N.$$.fragment,s),r(G.$$.fragment,s),r(E.$$.fragment,s),r(Q.$$.fragment,s),r(R.$$.fragment,s),Ms=!0)},o(s){M(T.$$.fragment,s),M(j.$$.fragment,s),M(w.$$.fragment,s),M(b.$$.fragment,s),M(U.$$.fragment,s),M(W.$$.fragment,s),M(C.$$.fragment,s),M(N.$$.fragment,s),M(G.$$.fragment,s),M(E.$$.fragment,s),M(Q.$$.fragment,s),M(R.$$.fragment,s),Ms=!1},d(s){s&&(l(z),l(S),l(_),l(X),l(d),l(H),l(A),l(y),l(F),l(D),l(u),l(L),l(P),l(f),l(q),l(K),l(I),l(O),l(ss),l($),l(as),l(k),l(ls),l(ts),l(Z),l(es),l(ns),l(x),l(ps),l(ms),l(B),l(is),l(os),l(cs),l(rs),l(V)),l(g),h(T,s),h(j,s),h(w,s),h(b,s),h(U,s),h(W,s),h(C,s),h(N,s),h(G,s),h(E,s),h(Q,s),h(R,s)}}}const Es='{"title":"SelecSLS","local":"selecsls","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qs(hs){return ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends Cs{constructor(g){super(),Zs(this,g,Qs,Bs,Ws,{})}}export{Ys as component};
