import{s as kt,n as Zt,o as Wt}from"../chunks/scheduler.85c25b89.js";import{S as Gt,i as Nt,g as p,s as a,r as i,A as Bt,h as m,f as e,c as n,j as It,u as o,x as d,k as xt,y as Et,a as l,v as r,d as c,t as h,w as M}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.e573519b.js";import{H as S,E as Xt}from"../chunks/getInferenceSnippets.2d2e232c.js";function _t(gt){let g,z,R,Y,y,H,w,yt='<strong>SE ResNeXt</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnext" rel="nofollow">ResNext</a> that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',F,u,wt='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',A,J,L,j,ut="To load a pretrained model:",q,f,D,T,Jt="To load and preprocess the image:",P,b,K,U,jt="To get the model predictions:",O,$,tt,C,ft="To get the top-5 predictions class names:",st,I,et,x,Tt="Replace the model name with the variant you want to use, e.g. <code>gluon_seresnext101_32x4d</code>. You can find the IDs in the model summaries at the top of this page.",lt,k,bt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,Z,nt,W,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,G,mt,N,$t=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,B,ot,E,Ct='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,X,ct,_,ht,Q,Mt,v,dt;return y=new S({props:{title:"(Gluon) SE-ResNeXt",local:"gluon-se-resnext",headingTag:"h1"}}),J=new S({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3NlcmVzbmV4dDEwMV8zMng0ZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_seresnext101_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new S({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25fc2VyZXNuZXh0MTAxXzMyeDRkJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_seresnext101_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new S({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),X=new S({props:{title:"Citation",local:"citation",headingTag:"h2"}}),_=new V({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Q=new Xt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/gloun-seresnext.mdx"}}),{c(){g=p("meta"),z=a(),R=p("p"),Y=a(),i(y.$$.fragment),H=a(),w=p("p"),w.innerHTML=yt,F=a(),u=p("p"),u.innerHTML=wt,A=a(),i(J.$$.fragment),L=a(),j=p("p"),j.textContent=ut,q=a(),i(f.$$.fragment),D=a(),T=p("p"),T.textContent=Jt,P=a(),i(b.$$.fragment),K=a(),U=p("p"),U.textContent=jt,O=a(),i($.$$.fragment),tt=a(),C=p("p"),C.textContent=ft,st=a(),i(I.$$.fragment),et=a(),x=p("p"),x.innerHTML=Tt,lt=a(),k=p("p"),k.innerHTML=bt,at=a(),i(Z.$$.fragment),nt=a(),W=p("p"),W.textContent=Ut,pt=a(),i(G.$$.fragment),mt=a(),N=p("p"),N.innerHTML=$t,it=a(),i(B.$$.fragment),ot=a(),E=p("p"),E.innerHTML=Ct,rt=a(),i(X.$$.fragment),ct=a(),i(_.$$.fragment),ht=a(),i(Q.$$.fragment),Mt=a(),v=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);g=m(s,"META",{name:!0,content:!0}),s.forEach(e),z=n(t),R=m(t,"P",{}),It(R).forEach(e),Y=n(t),o(y.$$.fragment,t),H=n(t),w=m(t,"P",{"data-svelte-h":!0}),d(w)!=="svelte-pmif4u"&&(w.innerHTML=yt),F=n(t),u=m(t,"P",{"data-svelte-h":!0}),d(u)!=="svelte-1vag5uc"&&(u.innerHTML=wt),A=n(t),o(J.$$.fragment,t),L=n(t),j=m(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-18ywhxh"&&(j.textContent=ut),q=n(t),o(f.$$.fragment,t),D=n(t),T=m(t,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1c2ipa8"&&(T.textContent=Jt),P=n(t),o(b.$$.fragment,t),K=n(t),U=m(t,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1n9qsq1"&&(U.textContent=jt),O=n(t),o($.$$.fragment,t),tt=n(t),C=m(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-19cnvx1"&&(C.textContent=ft),st=n(t),o(I.$$.fragment,t),et=n(t),x=m(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-1owfshn"&&(x.innerHTML=Tt),lt=n(t),k=m(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1wmi3ea"&&(k.innerHTML=bt),at=n(t),o(Z.$$.fragment,t),nt=n(t),W=m(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-9sr7nh"&&(W.textContent=Ut),pt=n(t),o(G.$$.fragment,t),mt=n(t),N=m(t,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1kguc51"&&(N.innerHTML=$t),it=n(t),o(B.$$.fragment,t),ot=n(t),E=m(t,"P",{"data-svelte-h":!0}),d(E)!=="svelte-xtxxu6"&&(E.innerHTML=Ct),rt=n(t),o(X.$$.fragment,t),ct=n(t),o(_.$$.fragment,t),ht=n(t),o(Q.$$.fragment,t),Mt=n(t),v=m(t,"P",{}),It(v).forEach(e),this.h()},h(){xt(g,"name","hf:doc:metadata"),xt(g,"content",Qt)},m(t,s){Et(document.head,g),l(t,z,s),l(t,R,s),l(t,Y,s),r(y,t,s),l(t,H,s),l(t,w,s),l(t,F,s),l(t,u,s),l(t,A,s),r(J,t,s),l(t,L,s),l(t,j,s),l(t,q,s),r(f,t,s),l(t,D,s),l(t,T,s),l(t,P,s),r(b,t,s),l(t,K,s),l(t,U,s),l(t,O,s),r($,t,s),l(t,tt,s),l(t,C,s),l(t,st,s),r(I,t,s),l(t,et,s),l(t,x,s),l(t,lt,s),l(t,k,s),l(t,at,s),r(Z,t,s),l(t,nt,s),l(t,W,s),l(t,pt,s),r(G,t,s),l(t,mt,s),l(t,N,s),l(t,it,s),r(B,t,s),l(t,ot,s),l(t,E,s),l(t,rt,s),r(X,t,s),l(t,ct,s),r(_,t,s),l(t,ht,s),r(Q,t,s),l(t,Mt,s),l(t,v,s),dt=!0},p:Zt,i(t){dt||(c(y.$$.fragment,t),c(J.$$.fragment,t),c(f.$$.fragment,t),c(b.$$.fragment,t),c($.$$.fragment,t),c(I.$$.fragment,t),c(Z.$$.fragment,t),c(G.$$.fragment,t),c(B.$$.fragment,t),c(X.$$.fragment,t),c(_.$$.fragment,t),c(Q.$$.fragment,t),dt=!0)},o(t){h(y.$$.fragment,t),h(J.$$.fragment,t),h(f.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(I.$$.fragment,t),h(Z.$$.fragment,t),h(G.$$.fragment,t),h(B.$$.fragment,t),h(X.$$.fragment,t),h(_.$$.fragment,t),h(Q.$$.fragment,t),dt=!1},d(t){t&&(e(z),e(R),e(Y),e(H),e(w),e(F),e(u),e(A),e(L),e(j),e(q),e(D),e(T),e(P),e(K),e(U),e(O),e(tt),e(C),e(st),e(et),e(x),e(lt),e(k),e(at),e(nt),e(W),e(pt),e(mt),e(N),e(it),e(ot),e(E),e(rt),e(ct),e(ht),e(Mt),e(v)),e(g),M(y,t),M(J,t),M(f,t),M(b,t),M($,t),M(I,t),M(Z,t),M(G,t),M(B,t),M(X,t),M(_,t),M(Q,t)}}}const Qt='{"title":"(Gluon) SE-ResNeXt","local":"gluon-se-resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Vt(gt){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends Gt{constructor(g){super(),Nt(this,g,Vt,_t,kt,{})}}export{Yt as component};
