import{s as qt,o as Qt,n as _t}from"../chunks/scheduler.f6319a2a.js";import{S as St,i as zt,g as i,s as n,r as M,A as Yt,h as o,f as l,c as a,j as Xt,u as c,x as r,k as Nt,y as Et,a as s,v as m,d as u,t as y,w as d}from"../chunks/index.85aa684c.js";import{T as Ht}from"../chunks/Tip.3d397a88.js";import{C as de}from"../chunks/CodeBlock.3400fc53.js";import{D as Ft}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as j,E as Lt}from"../chunks/getInferenceSnippets.74d2db76.js";function Pt(ye){let p,J='We’re using BM25, a lexical retrieval method, for simplicity and speed. For production systems, you might want to use semantic search with embeddings for better retrieval quality. Check the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a> for high-quality embedding models.';return{c(){p=i("p"),p.innerHTML=J},l(w){p=o(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-15p3erd"&&(p.innerHTML=J)},m(w,g){s(w,p,g)},p:_t,d(w){w&&l(p)}}}function Dt(ye){let p,J='Inference Providers give access to hundreds of models, powered by serverless inference partners. A list of supported providers can be found <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">here</a>.';return{c(){p=i("p"),p.innerHTML=J},l(w){p=o(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-k0ft1t"&&(p.innerHTML=J)},m(w,g){s(w,p,g)},p:_t,d(w){w&&l(p)}}}function Kt(ye){let p,J,w,g,f,je,b,Je,U,ge,I,mt="Retrieval-Augmented Generation (RAG) combines the power of large language models with external knowledge retrieval to produce more accurate, factual, and contextually relevant responses. At its core, RAG is about “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base.”",he,v,Te,C,ut="RAG offers several significant advantages over using vanilla or fine-tuned LLMs:",fe,$,yt="<li><strong>Factual Grounding</strong>: Reduces hallucinations by anchoring responses in retrieved facts</li> <li><strong>Domain Specialization</strong>: Provides domain-specific knowledge without model retraining</li> <li><strong>Knowledge Recency</strong>: Allows access to information beyond the model’s training cutoff</li> <li><strong>Transparency</strong>: Enables citation of sources for generated content</li> <li><strong>Control</strong>: Offers fine-grained control over what information the model can access</li>",be,B,Ue,A,dt="Despite its benefits, traditional RAG approaches face several challenges:",Ie,Z,wt="<li><strong>Single Retrieval Step</strong>: If the initial retrieval results are poor, the final generation will suffer</li> <li><strong>Query-Document Mismatch</strong>: User queries (often questions) may not match well with documents containing answers (often statements)</li> <li><strong>Limited Reasoning</strong>: Simple RAG pipelines don’t allow for multi-step reasoning or query refinement</li> <li><strong>Context Window Constraints</strong>: Retrieved documents must fit within the model’s context window</li>",ve,G,Ce,R,jt="We can overcome these limitations by implementing an <strong>Agentic RAG</strong> system - essentially an agent equipped with retrieval capabilities. This approach transforms RAG from a rigid pipeline into an interactive, reasoning-driven process.",$e,W,Be,k,Jt="An agent with retrieval tools can:",Ae,V,gt="<li>✅ <strong>Formulate optimized queries</strong>: The agent can transform user questions into retrieval-friendly queries</li> <li>✅ <strong>Perform multiple retrievals</strong>: The agent can retrieve information iteratively as needed</li> <li>✅ <strong>Reason over retrieved content</strong>: The agent can analyze, synthesize, and draw conclusions from multiple sources</li> <li>✅ <strong>Self-critique and refine</strong>: The agent can evaluate retrieval results and adjust its approach</li>",Ze,x,ht="This approach naturally implements advanced RAG techniques:",Ge,X,Tt='<li><strong>Hypothetical Document Embedding (HyDE)</strong>: Instead of using the user query directly, the agent formulates retrieval-optimized queries (<a href="https://huggingface.co/papers/2212.10496" rel="nofollow">paper reference</a>)</li> <li><strong>Self-Query Refinement</strong>: The agent can analyze initial results and perform follow-up retrievals with refined queries (<a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">technique reference</a>)</li>',Re,N,We,H,ft="Let’s build a complete Agentic RAG system step by step. We’ll create an agent that can answer questions about the Hugging Face Transformers library by retrieving information from its documentation.",ke,_,bt='You can follow along with the code snippets below, or check out the full example in the smolagents GitHub repository: <a href="https://github.com/huggingface/smolagents/blob/main/examples/rag.py" rel="nofollow">examples/rag.py</a>.',Ve,q,xe,Q,Ut="First, we need to install the necessary packages:",Xe,S,Ne,z,It="If you plan to use Hugging Face’s Inference API, you’ll need to set up your API token:",He,Y,_e,E,qe,F,vt="We’ll use a dataset containing Hugging Face documentation and prepare it for retrieval:",Qe,L,Se,P,ze,D,Ct="Now we’ll create a custom tool that our agent can use to retrieve information from the knowledge base:",Ye,K,Ee,h,Fe,O,Le,ee,$t="Now we’ll create an agent that can use our retriever tool to answer questions:",Pe,te,De,T,Ke,le,Oe,se,Bt="Let’s use our agent to answer a question about Transformers:",et,ne,tt,ae,lt,ie,At="Agentic RAG systems can be applied to various use cases:",st,oe,Zt="<li><strong>Technical Documentation Assistance</strong>: Help users navigate complex technical documentation</li> <li><strong>Research Paper Analysis</strong>: Extract and synthesize information from scientific papers</li> <li><strong>Legal Document Review</strong>: Find relevant precedents and clauses in legal documents</li> <li><strong>Customer Support</strong>: Answer questions based on product documentation and knowledge bases</li> <li><strong>Educational Tutoring</strong>: Provide explanations based on textbooks and learning materials</li>",nt,re,at,pe,Gt="Agentic RAG represents a significant advancement over traditional RAG pipelines. By combining the reasoning capabilities of LLM agents with the factual grounding of retrieval systems, we can build more powerful, flexible, and accurate information systems.",it,Me,Rt="The approach we’ve demonstrated:",ot,ce,Wt="<li>Overcomes the limitations of single-step retrieval</li> <li>Enables more natural interactions with knowledge bases</li> <li>Provides a framework for continuous improvement through self-critique and query refinement</li>",rt,me,kt="As you build your own Agentic RAG systems, consider experimenting with different retrieval methods, agent architectures, and knowledge sources to find the optimal configuration for your specific use case.",pt,ue,Mt,we,ct;return f=new j({props:{title:"Agentic RAG",local:"agentic-rag",headingTag:"h1"}}),b=new Ft({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"}]}}),U=new j({props:{title:"Introduction to Retrieval-Augmented Generation (RAG)",local:"introduction-to-retrieval-augmented-generation-rag",headingTag:"h2"}}),v=new j({props:{title:"Why Use RAG?",local:"why-use-rag",headingTag:"h3"}}),B=new j({props:{title:"Limitations of Traditional RAG",local:"limitations-of-traditional-rag",headingTag:"h3"}}),G=new j({props:{title:"Agentic RAG: A More Powerful Approach",local:"agentic-rag-a-more-powerful-approach",headingTag:"h2"}}),W=new j({props:{title:"Key Benefits of Agentic RAG",local:"key-benefits-of-agentic-rag",headingTag:"h3"}}),N=new j({props:{title:"Building an Agentic RAG System",local:"building-an-agentic-rag-system",headingTag:"h2"}}),q=new j({props:{title:"Step 1: Install Required Dependencies",local:"step-1-install-required-dependencies",headingTag:"h3"}}),S=new de({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjBwYW5kYXMlMjBsYW5nY2hhaW4lMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZGF0YXNldHMlMjBweXRob24tZG90ZW52JTIwcmFua19ibTI1JTIwLS11cGdyYWRl",highlighted:"pip install smolagents pandas langchain langchain-community sentence-transformers datasets python-dotenv rank_bm25 --upgrade",wrap:!1}}),Y=new de({props:{code:"JTIzJTIwTG9hZCUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIwKGluY2x1ZGluZyUyMEhGX1RPS0VOKSUwQWZyb20lMjBkb3RlbnYlMjBpbXBvcnQlMjBsb2FkX2RvdGVudiUwQWxvYWRfZG90ZW52KCk=",highlighted:`<span class="hljs-comment"># Load environment variables (including HF_TOKEN)</span>
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),E=new j({props:{title:"Step 2: Prepare the Knowledge Base",local:"step-2-prepare-the-knowledge-base",headingTag:"h3"}}),L=new de({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

<span class="hljs-comment"># Load the Hugging Face documentation dataset</span>
knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Filter to include only Transformers documentation</span>
knowledge_base = knowledge_base.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> row: row[<span class="hljs-string">&quot;source&quot;</span>].startswith(<span class="hljs-string">&quot;huggingface/transformers&quot;</span>))

<span class="hljs-comment"># Convert dataset entries to Document objects with metadata</span>
source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

<span class="hljs-comment"># Split documents into smaller chunks for better retrieval</span>
text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,  <span class="hljs-comment"># Characters per chunk</span>
    chunk_overlap=<span class="hljs-number">50</span>,  <span class="hljs-comment"># Overlap between chunks to maintain context</span>
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],  <span class="hljs-comment"># Priority order for splitting</span>
)
docs_processed = text_splitter.split_documents(source_docs)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Knowledge base prepared with <span class="hljs-subst">{<span class="hljs-built_in">len</span>(docs_processed)}</span> document chunks&quot;</span>)`,wrap:!1}}),P=new j({props:{title:"Step 3: Create a Retriever Tool",local:"step-3-create-a-retriever-tool",headingTag:"h3"}}),K=new de({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve the parts of transformers documentation that could be most relevant to answer your query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        <span class="hljs-comment"># Initialize the retriever with our processed documents</span>
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">10</span>  <span class="hljs-comment"># Return top 10 most relevant documents</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Execute the retrieval based on the provided query.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        <span class="hljs-comment"># Retrieve relevant documents</span>
        docs = self.retriever.invoke(query)

        <span class="hljs-comment"># Format the retrieved documents for readability</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

<span class="hljs-comment"># Initialize our retriever tool with the processed documents</span>
retriever_tool = RetrieverTool(docs_processed)`,wrap:!1}}),h=new Ht({props:{warning:!1,$$slots:{default:[Pt]},$$scope:{ctx:ye}}}),O=new j({props:{title:"Step 4: Create an Advanced Retrieval Agent",local:"step-4-create-an-advanced-retrieval-agent",headingTag:"h3"}}),te=new de({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBhZ2VudCUyMHdpdGglMjBvdXIlMjByZXRyaWV2ZXIlMjB0b29sJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJyZXRyaWV2ZXJfdG9vbCU1RCUyQyUyMCUyMCUyMyUyMExpc3QlMjBvZiUyMHRvb2xzJTIwYXZhaWxhYmxlJTIwdG8lMjB0aGUlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMCUyMCUyMyUyMERlZmF1bHQlMjBtb2RlbCUyMCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDQlMkMlMjAlMjAlMjMlMjBMaW1pdCUyMHRoZSUyMG51bWJlciUyMG9mJTIwcmVhc29uaW5nJTIwc3RlcHMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QyJTJDJTIwJTIwJTIzJTIwU2hvdyUyMGRldGFpbGVkJTIwYWdlbnQlMjByZWFzb25pbmclMEEpJTBBJTBBJTIzJTIwVG8lMjB1c2UlMjBhJTIwc3BlY2lmaWMlMjBtb2RlbCUyQyUyMHlvdSUyMGNhbiUyMHNwZWNpZnklMjBpdCUyMGxpa2UlMjB0aGlzJTNBJTBBJTIzJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbChtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjMtNzBCLUluc3RydWN0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Initialize the agent with our retriever tool</span>
agent = CodeAgent(
    tools=[retriever_tool],  <span class="hljs-comment"># List of tools available to the agent</span>
    model=InferenceClientModel(),  <span class="hljs-comment"># Default model &quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>
    max_steps=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Limit the number of reasoning steps</span>
    verbosity_level=<span class="hljs-number">2</span>,  <span class="hljs-comment"># Show detailed agent reasoning</span>
)

<span class="hljs-comment"># To use a specific model, you can specify it like this:</span>
<span class="hljs-comment"># model=InferenceClientModel(model_id=&quot;meta-llama/Llama-3.3-70B-Instruct&quot;)</span>`,wrap:!1}}),T=new Ht({props:{warning:!1,$$slots:{default:[Dt]},$$scope:{ctx:ye}}}),le=new j({props:{title:"Step 5: Run the Agent to Answer Questions",local:"step-5-run-the-agent-to-answer-questions",headingTag:"h3"}}),ne=new de({props:{code:"JTIzJTIwQXNrJTIwYSUyMHF1ZXN0aW9uJTIwdGhhdCUyMHJlcXVpcmVzJTIwcmV0cmlldmluZyUyMGluZm9ybWF0aW9uJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJGb3IlMjBhJTIwdHJhbnNmb3JtZXJzJTIwbW9kZWwlMjB0cmFpbmluZyUyQyUyMHdoaWNoJTIwaXMlMjBzbG93ZXIlMkMlMjB0aGUlMjBmb3J3YXJkJTIwb3IlMjB0aGUlMjBiYWNrd2FyZCUyMHBhc3MlM0YlMjIlMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUyMHRvJTIwZ2V0JTIwYW4lMjBhbnN3ZXIlMEFhZ2VudF9vdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4ocXVlc3Rpb24pJTBBJTBBJTIzJTIwRGlzcGxheSUyMHRoZSUyMGZpbmFsJTIwYW5zd2VyJTBBcHJpbnQoJTIyJTVDbkZpbmFsJTIwYW5zd2VyJTNBJTIyKSUwQXByaW50KGFnZW50X291dHB1dCk=",highlighted:`<span class="hljs-comment"># Ask a question that requires retrieving information</span>
question = <span class="hljs-string">&quot;For a transformers model training, which is slower, the forward or the backward pass?&quot;</span>

<span class="hljs-comment"># Run the agent to get an answer</span>
agent_output = agent.run(question)

<span class="hljs-comment"># Display the final answer</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nFinal answer:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),ae=new j({props:{title:"Practical Applications of Agentic RAG",local:"practical-applications-of-agentic-rag",headingTag:"h2"}}),re=new j({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),ue=new Lt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/rag.md"}}),{c(){p=i("meta"),J=n(),w=i("p"),g=n(),M(f.$$.fragment),je=n(),M(b.$$.fragment),Je=n(),M(U.$$.fragment),ge=n(),I=i("p"),I.textContent=mt,he=n(),M(v.$$.fragment),Te=n(),C=i("p"),C.textContent=ut,fe=n(),$=i("ol"),$.innerHTML=yt,be=n(),M(B.$$.fragment),Ue=n(),A=i("p"),A.textContent=dt,Ie=n(),Z=i("ul"),Z.innerHTML=wt,ve=n(),M(G.$$.fragment),Ce=n(),R=i("p"),R.innerHTML=jt,$e=n(),M(W.$$.fragment),Be=n(),k=i("p"),k.textContent=Jt,Ae=n(),V=i("ol"),V.innerHTML=gt,Ze=n(),x=i("p"),x.textContent=ht,Ge=n(),X=i("ul"),X.innerHTML=Tt,Re=n(),M(N.$$.fragment),We=n(),H=i("p"),H.textContent=ft,ke=n(),_=i("p"),_.innerHTML=bt,Ve=n(),M(q.$$.fragment),xe=n(),Q=i("p"),Q.textContent=Ut,Xe=n(),M(S.$$.fragment),Ne=n(),z=i("p"),z.textContent=It,He=n(),M(Y.$$.fragment),_e=n(),M(E.$$.fragment),qe=n(),F=i("p"),F.textContent=vt,Qe=n(),M(L.$$.fragment),Se=n(),M(P.$$.fragment),ze=n(),D=i("p"),D.textContent=Ct,Ye=n(),M(K.$$.fragment),Ee=n(),M(h.$$.fragment),Fe=n(),M(O.$$.fragment),Le=n(),ee=i("p"),ee.textContent=$t,Pe=n(),M(te.$$.fragment),De=n(),M(T.$$.fragment),Ke=n(),M(le.$$.fragment),Oe=n(),se=i("p"),se.textContent=Bt,et=n(),M(ne.$$.fragment),tt=n(),M(ae.$$.fragment),lt=n(),ie=i("p"),ie.textContent=At,st=n(),oe=i("ol"),oe.innerHTML=Zt,nt=n(),M(re.$$.fragment),at=n(),pe=i("p"),pe.textContent=Gt,it=n(),Me=i("p"),Me.textContent=Rt,ot=n(),ce=i("ul"),ce.innerHTML=Wt,rt=n(),me=i("p"),me.textContent=kt,pt=n(),M(ue.$$.fragment),Mt=n(),we=i("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),J=a(e),w=o(e,"P",{}),Xt(w).forEach(l),g=a(e),c(f.$$.fragment,e),je=a(e),c(b.$$.fragment,e),Je=a(e),c(U.$$.fragment,e),ge=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-ahsalp"&&(I.textContent=mt),he=a(e),c(v.$$.fragment,e),Te=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-3b2p9t"&&(C.textContent=ut),fe=a(e),$=o(e,"OL",{"data-svelte-h":!0}),r($)!=="svelte-s9vwtj"&&($.innerHTML=yt),be=a(e),c(B.$$.fragment,e),Ue=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-5ohm8g"&&(A.textContent=dt),Ie=a(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-1b6u5vg"&&(Z.innerHTML=wt),ve=a(e),c(G.$$.fragment,e),Ce=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-nkypap"&&(R.innerHTML=jt),$e=a(e),c(W.$$.fragment,e),Be=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-106qzhl"&&(k.textContent=Jt),Ae=a(e),V=o(e,"OL",{"data-svelte-h":!0}),r(V)!=="svelte-17ov5nb"&&(V.innerHTML=gt),Ze=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1vth8dz"&&(x.textContent=ht),Ge=a(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1kmp0ag"&&(X.innerHTML=Tt),Re=a(e),c(N.$$.fragment,e),We=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-ebtqsa"&&(H.textContent=ft),ke=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-a2onz5"&&(_.innerHTML=bt),Ve=a(e),c(q.$$.fragment,e),xe=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1yz8wyl"&&(Q.textContent=Ut),Xe=a(e),c(S.$$.fragment,e),Ne=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-io6cbu"&&(z.textContent=It),He=a(e),c(Y.$$.fragment,e),_e=a(e),c(E.$$.fragment,e),qe=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1r0dacz"&&(F.textContent=vt),Qe=a(e),c(L.$$.fragment,e),Se=a(e),c(P.$$.fragment,e),ze=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-16ovxir"&&(D.textContent=Ct),Ye=a(e),c(K.$$.fragment,e),Ee=a(e),c(h.$$.fragment,e),Fe=a(e),c(O.$$.fragment,e),Le=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-uyg5h9"&&(ee.textContent=$t),Pe=a(e),c(te.$$.fragment,e),De=a(e),c(T.$$.fragment,e),Ke=a(e),c(le.$$.fragment,e),Oe=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1cnhgyu"&&(se.textContent=Bt),et=a(e),c(ne.$$.fragment,e),tt=a(e),c(ae.$$.fragment,e),lt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1vnmlwn"&&(ie.textContent=At),st=a(e),oe=o(e,"OL",{"data-svelte-h":!0}),r(oe)!=="svelte-u8fd9x"&&(oe.innerHTML=Zt),nt=a(e),c(re.$$.fragment,e),at=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1nscnr8"&&(pe.textContent=Gt),it=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-18cofwx"&&(Me.textContent=Rt),ot=a(e),ce=o(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-12ngelm"&&(ce.innerHTML=Wt),rt=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-izrxrg"&&(me.textContent=kt),pt=a(e),c(ue.$$.fragment,e),Mt=a(e),we=o(e,"P",{}),Xt(we).forEach(l),this.h()},h(){Nt(p,"name","hf:doc:metadata"),Nt(p,"content",Ot)},m(e,t){Et(document.head,p),s(e,J,t),s(e,w,t),s(e,g,t),m(f,e,t),s(e,je,t),m(b,e,t),s(e,Je,t),m(U,e,t),s(e,ge,t),s(e,I,t),s(e,he,t),m(v,e,t),s(e,Te,t),s(e,C,t),s(e,fe,t),s(e,$,t),s(e,be,t),m(B,e,t),s(e,Ue,t),s(e,A,t),s(e,Ie,t),s(e,Z,t),s(e,ve,t),m(G,e,t),s(e,Ce,t),s(e,R,t),s(e,$e,t),m(W,e,t),s(e,Be,t),s(e,k,t),s(e,Ae,t),s(e,V,t),s(e,Ze,t),s(e,x,t),s(e,Ge,t),s(e,X,t),s(e,Re,t),m(N,e,t),s(e,We,t),s(e,H,t),s(e,ke,t),s(e,_,t),s(e,Ve,t),m(q,e,t),s(e,xe,t),s(e,Q,t),s(e,Xe,t),m(S,e,t),s(e,Ne,t),s(e,z,t),s(e,He,t),m(Y,e,t),s(e,_e,t),m(E,e,t),s(e,qe,t),s(e,F,t),s(e,Qe,t),m(L,e,t),s(e,Se,t),m(P,e,t),s(e,ze,t),s(e,D,t),s(e,Ye,t),m(K,e,t),s(e,Ee,t),m(h,e,t),s(e,Fe,t),m(O,e,t),s(e,Le,t),s(e,ee,t),s(e,Pe,t),m(te,e,t),s(e,De,t),m(T,e,t),s(e,Ke,t),m(le,e,t),s(e,Oe,t),s(e,se,t),s(e,et,t),m(ne,e,t),s(e,tt,t),m(ae,e,t),s(e,lt,t),s(e,ie,t),s(e,st,t),s(e,oe,t),s(e,nt,t),m(re,e,t),s(e,at,t),s(e,pe,t),s(e,it,t),s(e,Me,t),s(e,ot,t),s(e,ce,t),s(e,rt,t),s(e,me,t),s(e,pt,t),m(ue,e,t),s(e,Mt,t),s(e,we,t),ct=!0},p(e,[t]){const Vt={};t&2&&(Vt.$$scope={dirty:t,ctx:e}),h.$set(Vt);const xt={};t&2&&(xt.$$scope={dirty:t,ctx:e}),T.$set(xt)},i(e){ct||(u(f.$$.fragment,e),u(b.$$.fragment,e),u(U.$$.fragment,e),u(v.$$.fragment,e),u(B.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(N.$$.fragment,e),u(q.$$.fragment,e),u(S.$$.fragment,e),u(Y.$$.fragment,e),u(E.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(h.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(T.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(ue.$$.fragment,e),ct=!0)},o(e){y(f.$$.fragment,e),y(b.$$.fragment,e),y(U.$$.fragment,e),y(v.$$.fragment,e),y(B.$$.fragment,e),y(G.$$.fragment,e),y(W.$$.fragment,e),y(N.$$.fragment,e),y(q.$$.fragment,e),y(S.$$.fragment,e),y(Y.$$.fragment,e),y(E.$$.fragment,e),y(L.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(h.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(T.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),y(ue.$$.fragment,e),ct=!1},d(e){e&&(l(J),l(w),l(g),l(je),l(Je),l(ge),l(I),l(he),l(Te),l(C),l(fe),l($),l(be),l(Ue),l(A),l(Ie),l(Z),l(ve),l(Ce),l(R),l($e),l(Be),l(k),l(Ae),l(V),l(Ze),l(x),l(Ge),l(X),l(Re),l(We),l(H),l(ke),l(_),l(Ve),l(xe),l(Q),l(Xe),l(Ne),l(z),l(He),l(_e),l(qe),l(F),l(Qe),l(Se),l(ze),l(D),l(Ye),l(Ee),l(Fe),l(Le),l(ee),l(Pe),l(De),l(Ke),l(Oe),l(se),l(et),l(tt),l(lt),l(ie),l(st),l(oe),l(nt),l(at),l(pe),l(it),l(Me),l(ot),l(ce),l(rt),l(me),l(pt),l(Mt),l(we)),l(p),d(f,e),d(b,e),d(U,e),d(v,e),d(B,e),d(G,e),d(W,e),d(N,e),d(q,e),d(S,e),d(Y,e),d(E,e),d(L,e),d(P,e),d(K,e),d(h,e),d(O,e),d(te,e),d(T,e),d(le,e),d(ne,e),d(ae,e),d(re,e),d(ue,e)}}}const Ot='{"title":"Agentic RAG","local":"agentic-rag","sections":[{"title":"Introduction to Retrieval-Augmented Generation (RAG)","local":"introduction-to-retrieval-augmented-generation-rag","sections":[{"title":"Why Use RAG?","local":"why-use-rag","sections":[],"depth":3},{"title":"Limitations of Traditional RAG","local":"limitations-of-traditional-rag","sections":[],"depth":3}],"depth":2},{"title":"Agentic RAG: A More Powerful Approach","local":"agentic-rag-a-more-powerful-approach","sections":[{"title":"Key Benefits of Agentic RAG","local":"key-benefits-of-agentic-rag","sections":[],"depth":3}],"depth":2},{"title":"Building an Agentic RAG System","local":"building-an-agentic-rag-system","sections":[{"title":"Step 1: Install Required Dependencies","local":"step-1-install-required-dependencies","sections":[],"depth":3},{"title":"Step 2: Prepare the Knowledge Base","local":"step-2-prepare-the-knowledge-base","sections":[],"depth":3},{"title":"Step 3: Create a Retriever Tool","local":"step-3-create-a-retriever-tool","sections":[],"depth":3},{"title":"Step 4: Create an Advanced Retrieval Agent","local":"step-4-create-an-advanced-retrieval-agent","sections":[],"depth":3},{"title":"Step 5: Run the Agent to Answer Questions","local":"step-5-run-the-agent-to-answer-questions","sections":[],"depth":3}],"depth":2},{"title":"Practical Applications of Agentic RAG","local":"practical-applications-of-agentic-rag","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function el(ye){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends St{constructor(p){super(),zt(this,p,el,Kt,qt,{})}}export{ol as component};
