import{s as al,n as il,o as ol}from"../chunks/scheduler.85c25b89.js";import{S as pl,i as cl,g as i,s as n,r as c,A as rl,h as o,f as l,c as a,j as sl,u as r,x as p,k as nl,y as Ml,a as s,v as M,d as u,t as h,w as m}from"../chunks/index.c9bcf812.js";import{C as d}from"../chunks/CodeBlock.c004bd26.js";import{H as Ue}from"../chunks/getInferenceSnippets.f73e27a5.js";function ul(gt){let y,Te,ye,fe,j,ge,U,bt='Mixtral 8x7B is an open-source LLM from Mistral AI. It is a Sparse Mixture of Experts and has a similar architecture to Mistral 7B, but comes with a twist: it’s actually 8 “expert” models in one. If you want to learn more about MoEs check out <a href="https://huggingface.co/blog/moe" rel="nofollow">Mixture of Experts Explained</a>.',be,T,Jt='In this tutorial you will learn how to deploy <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">mistralai/Mixtral-8x7B-Instruct-v0.1</a> model on AWS Inferentia2 with Hugging Face Optimum Neuron on Amazon SageMaker. We are going to use the Hugging Face TGI Neuron Container, a purpose-built Inference Container to easily deploy LLMs on AWS Inferentia2 powered by <a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">Text Generation Inference</a> and <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">Optimum Neuron</a>.',Je,f,wt="We will cover how to:",we,g,It='<li><a href="#1-setup-development-environment">Setup a development environment</a></li> <li><a href="#2-retrieve-the-latest-hugging-face-tgi-neuron-dlc">Retrieve the latest Hugging Face TGI Neuron DLC</a></li> <li><a href="#3-deploy-Mixtral-8x7B-to-inferentia2">Deploy Mixtral 8x7B to Inferentia2</a></li> <li><a href="#4-clean-up">Clean up</a></li>',Ie,b,Ct="Lets get started! 🚀",Ce,J,Bt='<a href="https://aws.amazon.com/ec2/instance-types/inf2/" rel="nofollow">AWS inferentia (Inf2)</a> are purpose-built EC2 for deep learning (DL) inference workloads. Here are the different instances of the Inferentia2 family.',Be,w,xt="<thead><tr><th>instance size</th> <th>accelerators</th> <th>Neuron Cores</th> <th>accelerator memory</th> <th>vCPU</th> <th>CPU Memory</th> <th>on-demand price ($/h)</th></tr></thead> <tbody><tr><td>inf2.xlarge</td> <td>1</td> <td>2</td> <td>32</td> <td>4</td> <td>16</td> <td>0.76</td></tr> <tr><td>inf2.8xlarge</td> <td>1</td> <td>2</td> <td>32</td> <td>32</td> <td>128</td> <td>1.97</td></tr> <tr><td>inf2.24xlarge</td> <td>6</td> <td>12</td> <td>192</td> <td>96</td> <td>384</td> <td>6.49</td></tr> <tr><td>inf2.48xlarge</td> <td>12</td> <td>24</td> <td>384</td> <td>192</td> <td>768</td> <td>12.98</td></tr></tbody>",xe,I,We,C,Wt="For this tutorial, we are going to use a Notebook Instance in Amazon SageMaker with the Python 3 (ipykernel) and the <code>sagemaker</code> python SDK to deploy Mixtral 8x7B to a SageMaker inference endpoint.",Ne,B,Nt="Make sur you have the latest version of the SageMaker SDK installed.",Ze,x,ve,W,Zt="Then, instantiate the sagemaker role and session.",Ee,N,_e,Z,Ge,v,vt='The latest Hugging Face TGI Neuron DLCs can be used to run inference on AWS Inferentia2. You can use the <code>get_huggingface_llm_image_uri</code> method of the <code>sagemaker</code> SDK to retrieve the appropriate Hugging Face TGI Neuron DLC URI based on your desired <code>backend</code>, <code>session</code>, <code>region</code>, and <code>version</code>. You can find the latest version of the container <a href="https://huggingface.co/docs/optimum-neuron/containers" rel="nofollow">here</a>, if not yet added to the SageMaker SDK.',ke,E,Se,_,Ve,G,Et=`At the time of writing, <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/v2.6.0/general/arch/neuron-features/dynamic-shapes.html#neuron-dynamic-shapes" rel="nofollow">AWS Inferentia2 does not support dynamic shapes for inference</a>, which means that we need to specify our sequence length and batch size ahead of time.
To make it easier for customers to utilize the full power of Inferentia2, we created a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">neuron model cache</a>, which contains pre-compiled configurations for the most popular LLMs, including Mixtral 8x7B.`,$e,k,_t=`This means we don’t need to compile the model ourselves, but we can use the pre-compiled model from the cache. You can find compiled/cached configurations on the
<a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/tree/main/inference-cache-config" rel="nofollow">Hugging Face Hub</a>. If your desired configuration is not yet cached, you can compile it yourself using the <a href="https://huggingface.co/docs/optimum-neuron/guides/export_model" rel="nofollow">Optimum CLI</a> or open a request at the <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/discussions" rel="nofollow">Cache repository</a>.`,Fe,S,Gt='Let’s check the different configurations that are in the cache. For that you first need to log in the Hugging Face Hub, using a <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">User Access Token</a> with read access.',He,V,kt='Make sure you have the necessary permissions to access the model. You can request access to the model <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">here</a>.',Ae,$,Qe,F,St="Then, we need to install the latest version of Optimum Neuron.",Xe,H,qe,A,Vt="Finally, we can query the cache and retrieve the existing set of configurations for which we maintained a compiled version of the model.",ze,Q,Ye,X,$t="You should retrieve two entries in the cache:",Re,q,Le,z,Ft="<strong>Deploying Mixtral 8x7B to a SageMaker Endpoint</strong>",Pe,Y,Ht="Before deploying the model to Amazon SageMaker, we must define the TGI Neuron endpoint configuration. We need to make sure the following additional parameters are defined:",De,R,At="<li><code>HF_NUM_CORES</code>: Number of Neuron Cores used for the compilation.</li> <li><code>HF_BATCH_SIZE</code>: The batch size that was used to compile the model.</li> <li><code>HF_SEQUENCE_LENGTH</code>: The sequence length that was used to compile the model.</li> <li><code>HF_AUTO_CAST_TYPE</code>: The auto cast type that was used to compile the model.</li>",Oe,L,Qt="We still need to define traditional TGI parameters with:",Ke,P,Xt="<li><code>HF_MODEL_ID</code>: The Hugging Face model ID.</li> <li><code>HF_TOKEN</code>: The Hugging Face API token to access gated models.</li> <li><code>MAX_BATCH_SIZE</code>: The maximum batch size that the model can handle, equal to the batch size used for compilation.</li> <li><code>MAX_INPUT_TOKEN</code>: The maximum input length that the model can handle.</li> <li><code>MAX_TOTAL_TOKENS</code>: The maximum total tokens the model can generate, equal to the sequence length used for compilation.</li>",et,D,qt="Optionnaly, you can configure the endpoint to support chat templates:",tt,O,zt="<li><code>MESSAGES_API_ENABLED</code>: Enable Messages API</li>",lt,K,Yt="<strong>Select the right instance type</strong>",st,ee,Rt="Mixtral 8x7B is a large model and requires a lot of memory. We are going to use the <code>inf2.48xlarge</code> instance type, which has 192 vCPUs and 384 GB of accelerator memory. The <code>inf2.48xlarge</code> instance comes with 12 Inferentia2 accelerators that include 24 Neuron Cores. In our case we will use a batch size of 4 and a sequence length of 4096.",nt,te,Lt="After that we can create our endpoint configuration and deploy the model to Amazon SageMaker. We will deploy the endpoint with the Messages API enabled, so that it is fully compatible with the OpenAI Chat Completion API.",at,le,it,se,Pt="After we have created the <code>HuggingFaceModel</code> we can deploy it to Amazon SageMaker using the <code>deploy</code> method. We will deploy the model with the <code>ml.inf2.48xlarge</code> instance type. TGI will automatically distribute and shard the model across all Inferentia devices.",ot,ne,pt,ae,Dt="SageMaker will now create our endpoint and deploy the model to it. It takes around 15 minutes for deployment.",ct,ie,Ot="After our endpoint is deployed we can run inference on it. We will use the <code>predict</code> method from the <code>predictor</code> to run inference on our endpoint.",rt,oe,Kt="The endpoint supports the Messages API, which is fully compatible with the OpenAI Chat Completion API. The Messages API allows us to interact with the model in a conversational way. We can define the role of the message and the content. The role can be either <code>system</code>,<code>assistant</code> or <code>user</code>. The <code>system</code> role is used to provide context to the model and the <code>user</code> role is used to ask questions or provide input to the model.",Mt,pe,el='Parameters can be defined as in the <code>parameters</code> attribute of the payload. Check out the chat completion <a href="https://platform.openai.com/docs/api-reference/chat/create" rel="nofollow">documentation</a> to find supported parameters.',ut,ce,ht,re,mt,Me,tl="Okay lets test it.",dt,ue,yt,he,jt,me,ll="To clean up, we can delete the model and endpoint.",Ut,de,Tt,je,ft;return j=new Ue({props:{title:"Deploy Mixtral 8x7B on AWS Inferentia2",local:"deploy-mixtral-8x7b-on-aws-inferentia2",headingTag:"h1"}}),I=new Ue({props:{title:"1. Setup development environment",local:"1-setup-development-environment",headingTag:"h2"}}),x=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzYWdlbWFrZXIlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"!pip install sagemaker --upgrade --quiet",wrap:!1}}),N=new d({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyME5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCUyMmlhbSUyMiklMEElMjAlMjAlMjAlMjByb2xlJTIwJTNEJTIwaWFtLmdldF9yb2xlKFJvbGVOYW1lJTNEJTIyc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJTIyKSU1QiUyMlJvbGUlMjIlNUQlNUIlMjJBcm4lMjIlNUQlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oZGVmYXVsdF9idWNrZXQlM0RzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQpJTBBJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMHJvbGUlMjBhcm4lM0ElMjAlN0Jyb2xlJTdEJTIyKSUwQXByaW50KGYlMjJzYWdlbWFrZXIlMjBzZXNzaW9uJTIwcmVnaW9uJTNBJTIwJTdCc2Vzcy5ib3RvX3JlZ2lvbl9uYW1lJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&quot;iam&quot;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&quot;sagemaker_execution_role&quot;</span>)[<span class="hljs-string">&quot;Role&quot;</span>][<span class="hljs-string">&quot;Arn&quot;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),Z=new Ue({props:{title:"2. Retrieve the latest Hugging Face TGI Neuron DLC",local:"2-retrieve-the-latest-hugging-face-tgi-neuron-dlc",headingTag:"h2"}}),E=new d({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMGdldF9odWdnaW5nZmFjZV9sbG1faW1hZ2VfdXJpJTBBJTBBJTIzJTIwcmV0cmlldmUlMjB0aGUlMjBsbG0lMjBpbWFnZSUyMHVyaSUwQWxsbV9pbWFnZSUyMCUzRCUyMGdldF9odWdnaW5nZmFjZV9sbG1faW1hZ2VfdXJpKCUwQSUyMCUyMCUyMCUyMCUyMmh1Z2dpbmdmYWNlLW5ldXJvbnglMjIlMkMlMEEpJTBBJTBBJTIzJTIwcHJpbnQlMjBlY3IlMjBpbWFnZSUyMHVyaSUwQXByaW50KGYlMjJsbG0lMjBpbWFnZSUyMHVyaSUzQSUyMCU3QmxsbV9pbWFnZSU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> get_huggingface_llm_image_uri

<span class="hljs-comment"># retrieve the llm image uri</span>
llm_image = get_huggingface_llm_image_uri(
    <span class="hljs-string">&quot;huggingface-neuronx&quot;</span>,
)

<span class="hljs-comment"># print ecr image uri</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;llm image uri: <span class="hljs-subst">{llm_image}</span>&quot;</span>)`,wrap:!1}}),_=new Ue({props:{title:"3. Deploy Mixtral 8x7B to Inferentia2",local:"3-deploy-mixtral-8x7b-to-inferentia2",headingTag:"h2"}}),$=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),H=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjBvcHRpbXVtLW5ldXJvbiUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:"!pip install optimum-neuron --upgrade --quiet",wrap:!1}}),Q=new d({props:{code:"SEZfTU9ERUxfSUQlMjAlM0QlMjAlMjJtaXN0cmFsYWklMkZNaXh0cmFsLTh4N0ItSW5zdHJ1Y3QtdjAuMSUyMiUwQSUwQSFvcHRpbXVtLWNsaSUyMG5ldXJvbiUyMGNhY2hlJTIwbG9va3VwJTIwJTI0SEZfTU9ERUxfSUQ=",highlighted:`HF_MODEL_ID = <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>

!optimum-cli neuron cache lookup $HF_MODEL_ID`,wrap:!1}}),q=new d({props:{code:"KioqJTIwMiUyMGVudHJpZShzKSUyMGZvdW5kJTIwaW4lMjBjYWNoZSUyMGZvciUyMG1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIwZm9yJTIwaW5mZXJlbmNlLioqKiUwQSUwQWF1dG9fY2FzdF90eXBlJTNBJTIwYmYxNiUwQWJhdGNoX3NpemUlM0ElMjAxJTBBY2hlY2twb2ludF9pZCUzQSUyMG1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTBBY2hlY2twb2ludF9yZXZpc2lvbiUzQSUyMDQxYmQ0YzllN2U0ZmIzMThjYTQwZTcyMTEzMWQ0OTMzOTY2YzJjYzElMEFjb21waWxlcl90eXBlJTNBJTIwbmV1cm9ueC1jYyUwQWNvbXBpbGVyX3ZlcnNpb24lM0ElMjAyLjE2LjM3Mi4wJTJCNGE5YjIzMjYlMEFudW1fY29yZXMlM0ElMjAyNCUwQXNlcXVlbmNlX2xlbmd0aCUzQSUyMDQwOTYlMEF0YXNrJTNBJTIwdGV4dC1nZW5lcmF0aW9uJTBBJTBBYXV0b19jYXN0X3R5cGUlM0ElMjBiZjE2JTBBYmF0Y2hfc2l6ZSUzQSUyMDQlMEFjaGVja3BvaW50X2lkJTNBJTIwbWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMEFjaGVja3BvaW50X3JldmlzaW9uJTNBJTIwNDFiZDRjOWU3ZTRmYjMxOGNhNDBlNzIxMTMxZDQ5MzM5NjZjMmNjMSUwQWNvbXBpbGVyX3R5cGUlM0ElMjBuZXVyb254LWNjJTBBY29tcGlsZXJfdmVyc2lvbiUzQSUyMDIuMTYuMzcyLjAlMkI0YTliMjMyNiUwQW51bV9jb3JlcyUzQSUyMDI0JTBBc2VxdWVuY2VfbGVuZ3RoJTNBJTIwNDA5NiUwQXRhc2slM0ElMjB0ZXh0LWdlbmVyYXRpb24=",highlighted:`<span class="hljs-string">***</span> <span class="hljs-number">2</span> <span class="hljs-string">entrie(s)</span> <span class="hljs-string">found</span> <span class="hljs-string">in</span> <span class="hljs-string">cache</span> <span class="hljs-string">for</span> <span class="hljs-string">mistralai/Mixtral-8x7B-Instruct-v0.1</span> <span class="hljs-string">for</span> <span class="hljs-string">inference.***</span>

<span class="hljs-attr">auto_cast_type:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">batch_size:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">checkpoint_id:</span> <span class="hljs-string">mistralai/Mixtral-8x7B-Instruct-v0.1</span>
<span class="hljs-attr">checkpoint_revision:</span> <span class="hljs-string">41bd4c9e7e4fb318ca40e721131d4933966c2cc1</span>
<span class="hljs-attr">compiler_type:</span> <span class="hljs-string">neuronx-cc</span>
<span class="hljs-attr">compiler_version:</span> <span class="hljs-number">2.16</span><span class="hljs-number">.372</span><span class="hljs-number">.0</span><span class="hljs-string">+4a9b2326</span>
<span class="hljs-attr">num_cores:</span> <span class="hljs-number">24</span>
<span class="hljs-attr">sequence_length:</span> <span class="hljs-number">4096</span>
<span class="hljs-attr">task:</span> <span class="hljs-string">text-generation</span>

<span class="hljs-attr">auto_cast_type:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">batch_size:</span> <span class="hljs-number">4</span>
<span class="hljs-attr">checkpoint_id:</span> <span class="hljs-string">mistralai/Mixtral-8x7B-Instruct-v0.1</span>
<span class="hljs-attr">checkpoint_revision:</span> <span class="hljs-string">41bd4c9e7e4fb318ca40e721131d4933966c2cc1</span>
<span class="hljs-attr">compiler_type:</span> <span class="hljs-string">neuronx-cc</span>
<span class="hljs-attr">compiler_version:</span> <span class="hljs-number">2.16</span><span class="hljs-number">.372</span><span class="hljs-number">.0</span><span class="hljs-string">+4a9b2326</span>
<span class="hljs-attr">num_cores:</span> <span class="hljs-number">24</span>
<span class="hljs-attr">sequence_length:</span> <span class="hljs-number">4096</span>
<span class="hljs-attr">task:</span> <span class="hljs-string">text-generation</span>`,wrap:!1}}),le=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># sagemaker config</span>
instance_type = <span class="hljs-string">&quot;ml.inf2.48xlarge&quot;</span>
health_check_timeout = <span class="hljs-number">2400</span>  <span class="hljs-comment"># additional time to load the model</span>
volume_size = <span class="hljs-number">512</span>  <span class="hljs-comment"># size in GB of the EBS volume</span>

<span class="hljs-comment"># Define Model and Endpoint configuration parameter</span>
config = {
    <span class="hljs-string">&quot;HF_MODEL_ID&quot;</span>: <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
    <span class="hljs-string">&quot;HF_NUM_CORES&quot;</span>: <span class="hljs-string">&quot;24&quot;</span>,  <span class="hljs-comment"># number of neuron cores</span>
    <span class="hljs-string">&quot;HF_AUTO_CAST_TYPE&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>,  <span class="hljs-comment"># dtype of the model</span>
    <span class="hljs-string">&quot;MAX_BATCH_SIZE&quot;</span>: <span class="hljs-string">&quot;4&quot;</span>,  <span class="hljs-comment"># max batch size for the model</span>
    <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;4000&quot;</span>,  <span class="hljs-comment"># max length of input text</span>
    <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,  <span class="hljs-comment"># max length of generated text</span>
    <span class="hljs-string">&quot;MESSAGES_API_ENABLED&quot;</span>: <span class="hljs-string">&quot;true&quot;</span>,  <span class="hljs-comment"># Enable the messages API</span>
    <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: <span class="hljs-string">&quot;&lt;REPLACE WITH YOUR TOKEN&gt;&quot;</span>,
}

<span class="hljs-keyword">assert</span> (
    config[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] != <span class="hljs-string">&quot;&lt;REPLACE WITH YOUR TOKEN&gt;&quot;</span>
), <span class="hljs-string">&quot;Please replace &#x27;&lt;REPLACE WITH YOUR TOKEN&gt;&#x27; with your Hugging Face Hub API token&quot;</span>


<span class="hljs-comment"># create HuggingFaceModel with the image uri</span>
llm_model = HuggingFaceModel(role=role, image_uri=llm_image, env=config)`,wrap:!1}}),ne=new d({props:{code:"JTIzJTIwRGVwbG95JTIwbW9kZWwlMjB0byUyMGFuJTIwZW5kcG9pbnQlMEElMjMlMjBodHRwcyUzQSUyRiUyRnNhZ2VtYWtlci5yZWFkdGhlZG9jcy5pbyUyRmVuJTJGc3RhYmxlJTJGYXBpJTJGaW5mZXJlbmNlJTJGbW9kZWwuaHRtbCUyM3NhZ2VtYWtlci5tb2RlbC5Nb2RlbC5kZXBsb3klMEFsbG1fbW9kZWwuX2lzX2NvbXBpbGVkX21vZGVsJTIwJTNEJTIwVHJ1ZSUwQSUwQWxsbSUyMCUzRCUyMGxsbV9tb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwaW5pdGlhbF9pbnN0YW5jZV9jb3VudCUzRDElMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEaW5zdGFuY2VfdHlwZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRhaW5lcl9zdGFydHVwX2hlYWx0aF9jaGVja190aW1lb3V0JTNEaGVhbHRoX2NoZWNrX3RpbWVvdXQlMkMlMEElMjAlMjAlMjAlMjB2b2x1bWVfc2l6ZSUzRHZvbHVtZV9zaXplJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># Deploy model to an endpoint</span>
<span class="hljs-comment"># https://sagemaker.readthedocs.io/en/stable/api/inference/model.html#sagemaker.model.Model.deploy</span>
llm_model._is_compiled_model = <span class="hljs-literal">True</span>

llm = llm_model.deploy(
    initial_instance_count=<span class="hljs-number">1</span>,
    instance_type=instance_type,
    container_startup_health_check_timeout=health_check_timeout,
    volume_size=volume_size,
)`,wrap:!1}}),ce=new d({props:{code:"JTdCJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUyMCU3RCUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">{</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is deep learning?&quot;</span> <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),re=new d({props:{code:"JTIzJTIwUHJvbXB0JTIwdG8lMjBnZW5lcmF0ZSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclMjBpbiUyMG9uZSUyMHNlbnRlbmNlJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMGFyZ3VtZW50cyUyMGh0dHBzJTNBJTJGJTJGcGxhdGZvcm0ub3BlbmFpLmNvbSUyRmRvY3MlMkZhcGktcmVmZXJlbmNlJTJGY2hhdCUyRmNyZWF0ZSUwQXBhcmFtZXRlcnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMTAwJTJDJTBBJTdE",highlighted:`<span class="hljs-comment"># Prompt to generate</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning in one sentence?&quot;</span>},
]

<span class="hljs-comment"># Generation arguments https://platform.openai.com/docs/api-reference/chat/create</span>
parameters = {
    <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">100</span>,
}`,wrap:!1}}),ue=new d({props:{code:"Y2hhdCUyMCUzRCUyMGxsbS5wcmVkaWN0KCU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwbWVzc2FnZXMlMkMlMjAqKnBhcmFtZXRlcnMlMkMlMjAlMjJzdGVhbSUyMiUzQSUyMFRydWUlN0QpJTBBJTBBcHJpbnQoY2hhdCU1QiUyMmNob2ljZXMlMjIlNUQlNUIwJTVEJTVCJTIybWVzc2FnZSUyMiU1RCU1QiUyMmNvbnRlbnQlMjIlNUQuc3RyaXAoKSk=",highlighted:`chat = llm.predict({<span class="hljs-string">&quot;messages&quot;</span>: messages, **parameters, <span class="hljs-string">&quot;steam&quot;</span>: <span class="hljs-literal">True</span>})

<span class="hljs-built_in">print</span>(chat[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>].strip())`,wrap:!1}}),he=new Ue({props:{title:"4. Clean up",local:"4-clean-up",headingTag:"h2"}}),de=new d({props:{code:"bGxtLmRlbGV0ZV9tb2RlbCgpJTBBbGxtLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`llm.delete_model()
llm.delete_endpoint()`,wrap:!1}}),{c(){y=i("meta"),Te=n(),ye=i("p"),fe=n(),c(j.$$.fragment),ge=n(),U=i("p"),U.innerHTML=bt,be=n(),T=i("p"),T.innerHTML=Jt,Je=n(),f=i("p"),f.textContent=wt,we=n(),g=i("ol"),g.innerHTML=It,Ie=n(),b=i("p"),b.textContent=Ct,Ce=n(),J=i("p"),J.innerHTML=Bt,Be=n(),w=i("table"),w.innerHTML=xt,xe=n(),c(I.$$.fragment),We=n(),C=i("p"),C.innerHTML=Wt,Ne=n(),B=i("p"),B.textContent=Nt,Ze=n(),c(x.$$.fragment),ve=n(),W=i("p"),W.textContent=Zt,Ee=n(),c(N.$$.fragment),_e=n(),c(Z.$$.fragment),Ge=n(),v=i("p"),v.innerHTML=vt,ke=n(),c(E.$$.fragment),Se=n(),c(_.$$.fragment),Ve=n(),G=i("p"),G.innerHTML=Et,$e=n(),k=i("p"),k.innerHTML=_t,Fe=n(),S=i("p"),S.innerHTML=Gt,He=n(),V=i("p"),V.innerHTML=kt,Ae=n(),c($.$$.fragment),Qe=n(),F=i("p"),F.textContent=St,Xe=n(),c(H.$$.fragment),qe=n(),A=i("p"),A.textContent=Vt,ze=n(),c(Q.$$.fragment),Ye=n(),X=i("p"),X.textContent=$t,Re=n(),c(q.$$.fragment),Le=n(),z=i("p"),z.innerHTML=Ft,Pe=n(),Y=i("p"),Y.textContent=Ht,De=n(),R=i("ul"),R.innerHTML=At,Oe=n(),L=i("p"),L.textContent=Qt,Ke=n(),P=i("ul"),P.innerHTML=Xt,et=n(),D=i("p"),D.textContent=qt,tt=n(),O=i("ul"),O.innerHTML=zt,lt=n(),K=i("p"),K.innerHTML=Yt,st=n(),ee=i("p"),ee.innerHTML=Rt,nt=n(),te=i("p"),te.textContent=Lt,at=n(),c(le.$$.fragment),it=n(),se=i("p"),se.innerHTML=Pt,ot=n(),c(ne.$$.fragment),pt=n(),ae=i("p"),ae.textContent=Dt,ct=n(),ie=i("p"),ie.innerHTML=Ot,rt=n(),oe=i("p"),oe.innerHTML=Kt,Mt=n(),pe=i("p"),pe.innerHTML=el,ut=n(),c(ce.$$.fragment),ht=n(),c(re.$$.fragment),mt=n(),Me=i("p"),Me.textContent=tl,dt=n(),c(ue.$$.fragment),yt=n(),c(he.$$.fragment),jt=n(),me=i("p"),me.textContent=ll,Ut=n(),c(de.$$.fragment),Tt=n(),je=i("p"),this.h()},l(e){const t=rl("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),Te=a(e),ye=o(e,"P",{}),sl(ye).forEach(l),fe=a(e),r(j.$$.fragment,e),ge=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-17okc9y"&&(U.innerHTML=bt),be=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-pa9wy4"&&(T.innerHTML=Jt),Je=a(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-df2280"&&(f.textContent=wt),we=a(e),g=o(e,"OL",{"data-svelte-h":!0}),p(g)!=="svelte-4bvj6d"&&(g.innerHTML=It),Ie=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-fedw35"&&(b.textContent=Ct),Ce=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1q2zsrn"&&(J.innerHTML=Bt),Be=a(e),w=o(e,"TABLE",{"data-svelte-h":!0}),p(w)!=="svelte-1tmwmqe"&&(w.innerHTML=xt),xe=a(e),r(I.$$.fragment,e),We=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-3gjk7m"&&(C.innerHTML=Wt),Ne=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-gxxxnf"&&(B.textContent=Nt),Ze=a(e),r(x.$$.fragment,e),ve=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-k2b9z7"&&(W.textContent=Zt),Ee=a(e),r(N.$$.fragment,e),_e=a(e),r(Z.$$.fragment,e),Ge=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-150z9km"&&(v.innerHTML=vt),ke=a(e),r(E.$$.fragment,e),Se=a(e),r(_.$$.fragment,e),Ve=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-4yozv7"&&(G.innerHTML=Et),$e=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-6rv5nu"&&(k.innerHTML=_t),Fe=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1quxa5j"&&(S.innerHTML=Gt),He=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-bda3ge"&&(V.innerHTML=kt),Ae=a(e),r($.$$.fragment,e),Qe=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-gvpj30"&&(F.textContent=St),Xe=a(e),r(H.$$.fragment,e),qe=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-9yxrws"&&(A.textContent=Vt),ze=a(e),r(Q.$$.fragment,e),Ye=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1mgox28"&&(X.textContent=$t),Re=a(e),r(q.$$.fragment,e),Le=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1ay2eoj"&&(z.innerHTML=Ft),Pe=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1lo8mr8"&&(Y.textContent=Ht),De=a(e),R=o(e,"UL",{"data-svelte-h":!0}),p(R)!=="svelte-19xkqok"&&(R.innerHTML=At),Oe=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-7y1w5l"&&(L.textContent=Qt),Ke=a(e),P=o(e,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-21hz0o"&&(P.innerHTML=Xt),et=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-ba46xn"&&(D.textContent=qt),tt=a(e),O=o(e,"UL",{"data-svelte-h":!0}),p(O)!=="svelte-i1wt4y"&&(O.innerHTML=zt),lt=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1qiwbk5"&&(K.innerHTML=Yt),st=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-jofx65"&&(ee.innerHTML=Rt),nt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-dbarld"&&(te.textContent=Lt),at=a(e),r(le.$$.fragment,e),it=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-eb49q4"&&(se.innerHTML=Pt),ot=a(e),r(ne.$$.fragment,e),pt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-qvkvmm"&&(ae.textContent=Dt),ct=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1popn9h"&&(ie.innerHTML=Ot),rt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-7vzs06"&&(oe.innerHTML=Kt),Mt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-gr6587"&&(pe.innerHTML=el),ut=a(e),r(ce.$$.fragment,e),ht=a(e),r(re.$$.fragment,e),mt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1pq3qhh"&&(Me.textContent=tl),dt=a(e),r(ue.$$.fragment,e),yt=a(e),r(he.$$.fragment,e),jt=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-100mxno"&&(me.textContent=ll),Ut=a(e),r(de.$$.fragment,e),Tt=a(e),je=o(e,"P",{}),sl(je).forEach(l),this.h()},h(){nl(y,"name","hf:doc:metadata"),nl(y,"content",hl)},m(e,t){Ml(document.head,y),s(e,Te,t),s(e,ye,t),s(e,fe,t),M(j,e,t),s(e,ge,t),s(e,U,t),s(e,be,t),s(e,T,t),s(e,Je,t),s(e,f,t),s(e,we,t),s(e,g,t),s(e,Ie,t),s(e,b,t),s(e,Ce,t),s(e,J,t),s(e,Be,t),s(e,w,t),s(e,xe,t),M(I,e,t),s(e,We,t),s(e,C,t),s(e,Ne,t),s(e,B,t),s(e,Ze,t),M(x,e,t),s(e,ve,t),s(e,W,t),s(e,Ee,t),M(N,e,t),s(e,_e,t),M(Z,e,t),s(e,Ge,t),s(e,v,t),s(e,ke,t),M(E,e,t),s(e,Se,t),M(_,e,t),s(e,Ve,t),s(e,G,t),s(e,$e,t),s(e,k,t),s(e,Fe,t),s(e,S,t),s(e,He,t),s(e,V,t),s(e,Ae,t),M($,e,t),s(e,Qe,t),s(e,F,t),s(e,Xe,t),M(H,e,t),s(e,qe,t),s(e,A,t),s(e,ze,t),M(Q,e,t),s(e,Ye,t),s(e,X,t),s(e,Re,t),M(q,e,t),s(e,Le,t),s(e,z,t),s(e,Pe,t),s(e,Y,t),s(e,De,t),s(e,R,t),s(e,Oe,t),s(e,L,t),s(e,Ke,t),s(e,P,t),s(e,et,t),s(e,D,t),s(e,tt,t),s(e,O,t),s(e,lt,t),s(e,K,t),s(e,st,t),s(e,ee,t),s(e,nt,t),s(e,te,t),s(e,at,t),M(le,e,t),s(e,it,t),s(e,se,t),s(e,ot,t),M(ne,e,t),s(e,pt,t),s(e,ae,t),s(e,ct,t),s(e,ie,t),s(e,rt,t),s(e,oe,t),s(e,Mt,t),s(e,pe,t),s(e,ut,t),M(ce,e,t),s(e,ht,t),M(re,e,t),s(e,mt,t),s(e,Me,t),s(e,dt,t),M(ue,e,t),s(e,yt,t),M(he,e,t),s(e,jt,t),s(e,me,t),s(e,Ut,t),M(de,e,t),s(e,Tt,t),s(e,je,t),ft=!0},p:il,i(e){ft||(u(j.$$.fragment,e),u(I.$$.fragment,e),u(x.$$.fragment,e),u(N.$$.fragment,e),u(Z.$$.fragment,e),u(E.$$.fragment,e),u(_.$$.fragment,e),u($.$$.fragment,e),u(H.$$.fragment,e),u(Q.$$.fragment,e),u(q.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(ce.$$.fragment,e),u(re.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(de.$$.fragment,e),ft=!0)},o(e){h(j.$$.fragment,e),h(I.$$.fragment,e),h(x.$$.fragment,e),h(N.$$.fragment,e),h(Z.$$.fragment,e),h(E.$$.fragment,e),h(_.$$.fragment,e),h($.$$.fragment,e),h(H.$$.fragment,e),h(Q.$$.fragment,e),h(q.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(ce.$$.fragment,e),h(re.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),ft=!1},d(e){e&&(l(Te),l(ye),l(fe),l(ge),l(U),l(be),l(T),l(Je),l(f),l(we),l(g),l(Ie),l(b),l(Ce),l(J),l(Be),l(w),l(xe),l(We),l(C),l(Ne),l(B),l(Ze),l(ve),l(W),l(Ee),l(_e),l(Ge),l(v),l(ke),l(Se),l(Ve),l(G),l($e),l(k),l(Fe),l(S),l(He),l(V),l(Ae),l(Qe),l(F),l(Xe),l(qe),l(A),l(ze),l(Ye),l(X),l(Re),l(Le),l(z),l(Pe),l(Y),l(De),l(R),l(Oe),l(L),l(Ke),l(P),l(et),l(D),l(tt),l(O),l(lt),l(K),l(st),l(ee),l(nt),l(te),l(at),l(it),l(se),l(ot),l(pt),l(ae),l(ct),l(ie),l(rt),l(oe),l(Mt),l(pe),l(ut),l(ht),l(mt),l(Me),l(dt),l(yt),l(jt),l(me),l(Ut),l(Tt),l(je)),l(y),m(j,e),m(I,e),m(x,e),m(N,e),m(Z,e),m(E,e),m(_,e),m($,e),m(H,e),m(Q,e),m(q,e),m(le,e),m(ne,e),m(ce,e),m(re,e),m(ue,e),m(he,e),m(de,e)}}}const hl='{"title":"Deploy Mixtral 8x7B on AWS Inferentia2","local":"deploy-mixtral-8x7b-on-aws-inferentia2","sections":[{"title":"1. Setup development environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Retrieve the latest Hugging Face TGI Neuron DLC","local":"2-retrieve-the-latest-hugging-face-tgi-neuron-dlc","sections":[],"depth":2},{"title":"3. Deploy Mixtral 8x7B to Inferentia2","local":"3-deploy-mixtral-8x7b-to-inferentia2","sections":[],"depth":2},{"title":"4. Clean up","local":"4-clean-up","sections":[],"depth":2}],"depth":1}';function ml(gt){return ol(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tl extends pl{constructor(y){super(),cl(this,y,ml,ul,al,{})}}export{Tl as component};
