import{s as Fe,o as Ee,n as _e}from"../chunks/scheduler.8c3d61f6.js";import{S as Qe,i as Ne,g as f,s as p,r as b,A as Se,h as g,f as l,c as o,j as Ae,u as h,x as G,k as z,y as He,a as t,v as J,d as w,t as U,w as T}from"../chunks/index.da70eac4.js";import{T as ze}from"../chunks/Tip.6f698f24.js";import{C as x}from"../chunks/CodeBlock.a9c4becf.js";import{H as oe,E as Pe}from"../chunks/getInferenceSnippets.cb466318.js";import{H as qe,a as Ce}from"../chunks/HfOption.6c3b4e77.js";function Le(R){let r,W,m,_='<p>The <code>pag_applied_layers</code> argument allows you to specify which layers PAG is applied to. Additionally, you can use <code>set_pag_applied_layers</code> method to update these layers after the pipeline has been created. Check out the <a href="#pag_applied_layers">pag_applied_layers</a> section to learn more about applying PAG to other layers.</p>',u,M,c='If you already have a pipeline created and loaded, you can enable PAG on it using the <code>from_pipe</code> API with the <code>enable_pag</code> flag. Internally, a PAG pipeline is created based on the pipeline and task you specified. In the example below, since we used <code>AutoPipelineForText2Image</code> and passed a <code>StableDiffusionXLPipeline</code>, a <code>StableDiffusionXLPAGPipeline</code> is created accordingly. Note that this does not require additional memory, and you will have both <code>StableDiffusionXLPipeline</code> and  <code>StableDiffusionXLPAGPipeline</code> loaded and ready to use. You can read more about the <code>from_pipe</code> API and how to reuse pipelines in diffuser <a href="https://huggingface.co/docs/diffusers/using-diffusers/loading#reuse-a-pipeline" rel="nofollow">here</a>.',d,j,C,y,k="To generate an image, you will also need to pass a <code>pag_scale</code>. When <code>pag_scale</code> increases, images gain more semantically coherent structures and exhibit fewer artifacts. However overly large guidance scale can lead to smoother textures and slight saturation in the images, similarly to CFG. <code>pag_scale=3.0</code> is used in the official demo and works well in most of the use cases, but feel free to experiment and select the appropriate value according to your needs! PAG is disabled when <code>pag_scale=0</code>.",I,$,v,Z,Y='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_cfg_7.0_mid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_mid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',n;return r=new x({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfcGFnJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHBhZ19hcHBsaWVkX2xheWVycyUzRCU1QiUyMm1pZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=[<span class="hljs-string">&quot;mid&quot;</span>],
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),j=new x({props:{code:"cGlwZWxpbmVfc2R4bCUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9waXBlKHBpcGVsaW5lX3NkeGwlMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_sdxl = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForText2Image.from_pipe(pipeline_sdxl, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),$=new x({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbnNlY3QlMjByb2JvdCUyMHByZXBhcmluZyUyMGElMjBkZWxpY2lvdXMlMjBtZWFsJTJDJTIwYW5pbWUlMjBzdHlsZSUyMiUwQSUwQWZvciUyMHBhZ19zY2FsZSUyMGluJTIwJTVCMC4wJTJDJTIwMy4wJTVEJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhZ19zY2FsZSUzRHBhZ19zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCkuaW1hZ2Vz",highlighted:`prompt = <span class="hljs-string">&quot;an insect robot preparing a delicious meal, anime style&quot;</span>

<span class="hljs-keyword">for</span> pag_scale <span class="hljs-keyword">in</span> [<span class="hljs-number">0.0</span>, <span class="hljs-number">3.0</span>]:
    generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
    images = pipeline(
        prompt=prompt,
        num_inference_steps=<span class="hljs-number">25</span>,
        guidance_scale=<span class="hljs-number">7.0</span>,
        generator=generator,
        pag_scale=pag_scale,
    ).images`,wrap:!1}}),{c(){b(r.$$.fragment),W=p(),m=f("blockquote"),m.innerHTML=_,u=p(),M=f("p"),M.innerHTML=c,d=p(),b(j.$$.fragment),C=p(),y=f("p"),y.innerHTML=k,I=p(),b($.$$.fragment),v=p(),Z=f("div"),Z.innerHTML=Y,this.h()},l(a){h(r.$$.fragment,a),W=o(a),m=g(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),G(m)!=="svelte-1qub4u5"&&(m.innerHTML=_),u=o(a),M=g(a,"P",{"data-svelte-h":!0}),G(M)!=="svelte-ggenwh"&&(M.innerHTML=c),d=o(a),h(j.$$.fragment,a),C=o(a),y=g(a,"P",{"data-svelte-h":!0}),G(y)!=="svelte-43v4ib"&&(y.innerHTML=k),I=o(a),h($.$$.fragment,a),v=o(a),Z=g(a,"DIV",{class:!0,"data-svelte-h":!0}),G(Z)!=="svelte-1ebso2i"&&(Z.innerHTML=Y),this.h()},h(){z(m,"class","tip"),z(Z,"class","flex flex-row gap-4")},m(a,X){J(r,a,X),t(a,W,X),t(a,m,X),t(a,u,X),t(a,M,X),t(a,d,X),J(j,a,X),t(a,C,X),t(a,y,X),t(a,I,X),J($,a,X),t(a,v,X),t(a,Z,X),n=!0},p:_e,i(a){n||(w(r.$$.fragment,a),w(j.$$.fragment,a),w($.$$.fragment,a),n=!0)},o(a){U(r.$$.fragment,a),U(j.$$.fragment,a),U($.$$.fragment,a),n=!1},d(a){a&&(l(W),l(m),l(u),l(M),l(d),l(C),l(y),l(I),l(v),l(Z)),T(r,a),T(j,a),T($,a)}}}function De(R){let r,W="You can use PAG with image-to-image pipelines.",m,_,u,M,c="If you already have a image-to-image pipeline and would like enable PAG on it, you can run this",d,j,C,y,k="It is also very easy to directly switch from a text-to-image pipeline to PAG enabled image-to-image pipeline",I,$,v,Z,Y="If you have a PAG enabled text-to-image pipeline, you can directly switch to a image-to-image pipeline with PAG still enabled",n,a,X,V,P="Now let’s generate an image!",A,F,E;return _=new x({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGVuYWJsZV9wYWclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX2FwcGxpZWRfbGF5ZXJzJTNEJTVCJTIybWlkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=[<span class="hljs-string">&quot;mid&quot;</span>],
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),j=new x({props:{code:"cGlwZWxpbmVfdDJpJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90MmklMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_t2i = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),$=new x({props:{code:"cGlwZWxpbmVfcGFnJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9waXBlKHBpcGVsaW5lX3QyaSUyQyUyMGVuYWJsZV9wYWclM0RUcnVlKQ==",highlighted:`pipeline_pag = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),a=new x({props:{code:"cGlwZWxpbmVfcGFnJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwZW5hYmxlX3BhZyUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3BpcGUocGlwZWxpbmVfdDJpKQ==",highlighted:`pipeline_pag = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, enable_pag=<span class="hljs-literal">True</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i)`,wrap:!1}}),F=new x({props:{code:"cGFnX3NjYWxlcyUyMCUzRCUyMCUyMDQuMCUwQWd1aWRhbmNlX3NjYWxlcyUyMCUzRCUyMDcuMCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtdGV4dDJpbWcucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBjYXRjaGluZyUyMGElMjBmcmlzYmVlJTIwaW4lMjB0aGUlMjBqdW5nbGUlMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjglMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRGd1aWRhbmNlX3NjYWxlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX3NjYWxlJTNEcGFnX3NjYWxlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVE",highlighted:`pag_scales =  <span class="hljs-number">4.0</span>
guidance_scales = <span class="hljs-number">7.0</span>

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
init_image = load_image(url)
prompt = <span class="hljs-string">&quot;a dog catching a frisbee in the jungle&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(
    prompt,
    image=init_image,
    strength=<span class="hljs-number">0.8</span>,
    guidance_scale=guidance_scale,
    pag_scale=pag_scale,
    generator=generator).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){r=f("p"),r.textContent=W,m=p(),b(_.$$.fragment),u=p(),M=f("p"),M.textContent=c,d=p(),b(j.$$.fragment),C=p(),y=f("p"),y.textContent=k,I=p(),b($.$$.fragment),v=p(),Z=f("p"),Z.textContent=Y,n=p(),b(a.$$.fragment),X=p(),V=f("p"),V.textContent=P,A=p(),b(F.$$.fragment)},l(i){r=g(i,"P",{"data-svelte-h":!0}),G(r)!=="svelte-1xi6cwa"&&(r.textContent=W),m=o(i),h(_.$$.fragment,i),u=o(i),M=g(i,"P",{"data-svelte-h":!0}),G(M)!=="svelte-d1pkk8"&&(M.textContent=c),d=o(i),h(j.$$.fragment,i),C=o(i),y=g(i,"P",{"data-svelte-h":!0}),G(y)!=="svelte-11p19k6"&&(y.textContent=k),I=o(i),h($.$$.fragment,i),v=o(i),Z=g(i,"P",{"data-svelte-h":!0}),G(Z)!=="svelte-nytx5w"&&(Z.textContent=Y),n=o(i),h(a.$$.fragment,i),X=o(i),V=g(i,"P",{"data-svelte-h":!0}),G(V)!=="svelte-3irrs3"&&(V.textContent=P),A=o(i),h(F.$$.fragment,i)},m(i,B){t(i,r,B),t(i,m,B),J(_,i,B),t(i,u,B),t(i,M,B),t(i,d,B),J(j,i,B),t(i,C,B),t(i,y,B),t(i,I,B),J($,i,B),t(i,v,B),t(i,Z,B),t(i,n,B),J(a,i,B),t(i,X,B),t(i,V,B),t(i,A,B),J(F,i,B),E=!0},p:_e,i(i){E||(w(_.$$.fragment,i),w(j.$$.fragment,i),w($.$$.fragment,i),w(a.$$.fragment,i),w(F.$$.fragment,i),E=!0)},o(i){U(_.$$.fragment,i),U(j.$$.fragment,i),U($.$$.fragment,i),U(a.$$.fragment,i),U(F.$$.fragment,i),E=!1},d(i){i&&(l(r),l(m),l(u),l(M),l(d),l(C),l(y),l(I),l(v),l(Z),l(n),l(X),l(V),l(A)),T(_,i),T(j,i),T($,i),T(a,i),T(F,i)}}}function Ke(R){let r,W,m,_="You can enable PAG on an existing inpainting pipeline like this",u,M,c,d,j="This still works when your pipeline has a different task:",C,y,k,I,$="Let’s generate an image!",v,Z,Y;return r=new x({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfcGFnJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),M=new x({props:{code:"cGlwZWxpbmVfaW5wYWludCUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9waXBlKHBpcGVsaW5lX2lucGFpbnQlMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_inpaint = AutoPipelineForInpainting.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForInpainting.from_pipe(pipeline_inpaint, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),y=new x({props:{code:"cGlwZWxpbmVfdDJpJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW5wYWl0aW5nLmZyb21fcGlwZShwaXBlbGluZV90MmklMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_t2i = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForInpaiting.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),Z=new x({props:{code:"aW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW9fbWFzay5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwdGlnZXIlMjBzaXR0aW5nJTIwb24lMjBhJTIwYmVuY2glMjIlMEElMEFwYWdfc2NhbGVzJTIwJTNEJTIwJTIwMy4wJTBBZ3VpZGFuY2Vfc2NhbGVzJTIwJTNEJTIwNy41JTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMSklMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMHN0cmVuZ3RoJTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMHBhZ19zY2FsZSUzRHBhZ19zY2FsZSUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>

pag_scales =  <span class="hljs-number">3.0</span>
guidance_scales = <span class="hljs-number">7.5</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
images = pipeline(
    prompt=prompt,
    image=init_image,
    mask_image=mask_image,
    strength=<span class="hljs-number">0.8</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=guidance_scale,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){b(r.$$.fragment),W=p(),m=f("p"),m.textContent=_,u=p(),b(M.$$.fragment),c=p(),d=f("p"),d.textContent=j,C=p(),b(y.$$.fragment),k=p(),I=f("p"),I.textContent=$,v=p(),b(Z.$$.fragment)},l(n){h(r.$$.fragment,n),W=o(n),m=g(n,"P",{"data-svelte-h":!0}),G(m)!=="svelte-azr2az"&&(m.textContent=_),u=o(n),h(M.$$.fragment,n),c=o(n),d=g(n,"P",{"data-svelte-h":!0}),G(d)!=="svelte-1e8wg3g"&&(d.textContent=j),C=o(n),h(y.$$.fragment,n),k=o(n),I=g(n,"P",{"data-svelte-h":!0}),G(I)!=="svelte-1yhhruz"&&(I.textContent=$),v=o(n),h(Z.$$.fragment,n)},m(n,a){J(r,n,a),t(n,W,a),t(n,m,a),t(n,u,a),J(M,n,a),t(n,c,a),t(n,d,a),t(n,C,a),J(y,n,a),t(n,k,a),t(n,I,a),t(n,v,a),J(Z,n,a),Y=!0},p:_e,i(n){Y||(w(r.$$.fragment,n),w(M.$$.fragment,n),w(y.$$.fragment,n),w(Z.$$.fragment,n),Y=!0)},o(n){U(r.$$.fragment,n),U(M.$$.fragment,n),U(y.$$.fragment,n),U(Z.$$.fragment,n),Y=!1},d(n){n&&(l(W),l(m),l(u),l(c),l(d),l(C),l(k),l(I),l(v)),T(r,n),T(M,n),T(y,n),T(Z,n)}}}function Oe(R){let r,W,m,_,u,M;return r=new Ce({props:{id:"tasks",option:"Text-to-image",$$slots:{default:[Le]},$$scope:{ctx:R}}}),m=new Ce({props:{id:"tasks",option:"Image-to-image",$$slots:{default:[De]},$$scope:{ctx:R}}}),u=new Ce({props:{id:"tasks",option:"Inpainting",$$slots:{default:[Ke]},$$scope:{ctx:R}}}),{c(){b(r.$$.fragment),W=p(),b(m.$$.fragment),_=p(),b(u.$$.fragment)},l(c){h(r.$$.fragment,c),W=o(c),h(m.$$.fragment,c),_=o(c),h(u.$$.fragment,c)},m(c,d){J(r,c,d),t(c,W,d),J(m,c,d),t(c,_,d),J(u,c,d),M=!0},p(c,d){const j={};d&2&&(j.$$scope={dirty:d,ctx:c}),r.$set(j);const C={};d&2&&(C.$$scope={dirty:d,ctx:c}),m.$set(C);const y={};d&2&&(y.$$scope={dirty:d,ctx:c}),u.$set(y)},i(c){M||(w(r.$$.fragment,c),w(m.$$.fragment,c),w(u.$$.fragment,c),M=!0)},o(c){U(r.$$.fragment,c),U(m.$$.fragment,c),U(u.$$.fragment,c),M=!1},d(c){c&&(l(W),l(_)),T(r,c),T(m,c),T(u,c)}}}function el(R){let r,W="If you already have a controlnet pipeline and want to enable PAG, you can use the <code>from_pipe</code> API: <code>AutoPipelineForText2Image.from_pipe(pipeline_controlnet, enable_pag=True)</code>";return{c(){r=f("p"),r.innerHTML=W},l(m){r=g(m,"P",{"data-svelte-h":!0}),G(r)!=="svelte-2vpeo4"&&(r.innerHTML=W)},m(m,_){t(m,r,_)},p:_e,d(m){m&&l(r)}}}function ll(R){let r,W,m,_,u,M,c,d='<a href="https://ku-cvlab.github.io/Perturbed-Attention-Guidance/" rel="nofollow">Perturbed-Attention Guidance (PAG)</a> is a new diffusion sampling guidance that improves sample quality across both unconditional and conditional settings, achieving this without requiring further training or the integration of external modules. PAG is designed to progressively enhance the structure of synthesized samples throughout the denoising process by considering the self-attention mechanisms’ ability to capture structural information. It involves generating intermediate samples with degraded structure by substituting selected self-attention maps in diffusion U-Net with an identity matrix, and guiding the denoising process away from these degraded samples.',j,C,y="This guide will show you how to use PAG for various tasks and use cases.",k,I,$,v,Z='You can apply PAG to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> for tasks such as text-to-image, image-to-image, and inpainting. To enable PAG for a specific task, load the pipeline using the <a href="../api/pipelines/auto_pipeline">AutoPipeline</a> API with the <code>enable_pag=True</code> flag and the <code>pag_applied_layers</code> argument.',Y,n,a='<p>🤗 Diffusers currently only supports using PAG with selected SDXL pipelines and <a href="/docs/diffusers/main/en/api/pipelines/pag#diffusers.PixArtSigmaPAGPipeline">PixArtSigmaPAGPipeline</a>. But feel free to open a <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">feature request</a> if you want to add PAG support to a new pipeline!</p>',X,V,P,A,F,E,i="To use PAG with ControlNet, first create a <code>controlnet</code>. Then, pass the <code>controlnet</code> and other PAG arguments to the <code>from_pretrained</code> method of the AutoPipeline for the specified task.",B,q,ce,Q,me,L,Ie="You can use the pipeline in the same way you normally use ControlNet pipelines, with the added option to specify a <code>pag_scale</code> parameter. Note that PAG works well for unconditional generation. In this example, we will generate an image without a prompt.",Me,D,de,N,Be='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',ue,K,ye,O,$e='<a href="https://hf.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is a popular model that can be plugged into diffusion models to enable image prompting without any changes to the underlying model. You can enable PAG on a pipeline with IP-Adapter loaded.',fe,ee,ge,le,Xe="PAG reduces artifacts and improves the overall compposition.",be,S,ve='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_ipa_0.8.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_5.0_ipa_0.8.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',he,te,Je,ae,we,se,Ve="The <code>pag_applied_layers</code> argument allows you to specify which layers PAG is applied to. By default, it applies only to the mid blocks. Changing this setting will significantly impact the output. You can use the <code>set_pag_applied_layers</code> method to adjust the PAG layers after the pipeline is created, helping you find the optimal layers for your model.",Ue,ne,xe="As an example, here is the images generated with <code>pag_layers = [&quot;down.block_2&quot;]</code> and <code>pag_layers = [&quot;down.block_2&quot;, &quot;up.block_1.attentions_0&quot;]</code>",Te,ie,Ze,H,ke='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_down2_up1a0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">down.block_2 + up.block1.attentions_0</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_down2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">down.block_2</figcaption></div>',je,pe,Ge,re,We;return u=new oe({props:{title:"Perturbed-Attention Guidance",local:"perturbed-attention-guidance",headingTag:"h1"}}),I=new oe({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),V=new qe({props:{id:"tasks",options:["Text-to-image","Image-to-image","Inpainting"],$$slots:{default:[Oe]},$$scope:{ctx:R}}}),A=new oe({props:{title:"PAG with ControlNet",local:"pag-with-controlnet",headingTag:"h2"}}),q=new x({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBDb250cm9sTmV0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyRmNvbnRyb2xuZXQtY2Fubnktc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUwQSUyMCUyMCUyMCUyMGVuYWJsZV9wYWclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX2FwcGxpZWRfbGF5ZXJzJTNEJTIybWlkJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, ControlNetModel
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
)

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    controlnet=controlnet,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=<span class="hljs-string">&quot;mid&quot;</span>,
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Q=new ze({props:{$$slots:{default:[el]},$$scope:{ctx:R}}}),D=new x({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFjYW5ueV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBhZ19jb250cm9sX2lucHV0LnBuZyUyMiUwQSklMEElMEFmb3IlMjBwYWdfc2NhbGUlMjBpbiUyMCU1QjAuMCUyQyUyMDMuMCU1RCUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDEpJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0Rjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTNEY2FubnlfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYWdfc2NhbGUlM0RwYWdfc2NhbGUlMkMlMEElMjAlMjAlMjAlMjApLmltYWdlcyUwQSUyMCUyMCUyMCUyMGltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
canny_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_control_input.png&quot;</span>
)

<span class="hljs-keyword">for</span> pag_scale <span class="hljs-keyword">in</span> [<span class="hljs-number">0.0</span>, <span class="hljs-number">3.0</span>]:
    generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
    images = pipeline(
        prompt=<span class="hljs-string">&quot;&quot;</span>,
        controlnet_conditioning_scale=controlnet_conditioning_scale,
        image=canny_image,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">0</span>,
        generator=generator,
        pag_scale=pag_scale,
    ).images
    images[<span class="hljs-number">0</span>]`,wrap:!1}}),K=new oe({props:{title:"PAG with IP-Adapter",local:"pag-with-ip-adapter",headingTag:"h2"}}),ee=new x({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">import</span> torch

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16
)

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    image_encoder=image_encoder,
    enable_pag=<span class="hljs-literal">True</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.bin&quot;</span>)

pag_scales = <span class="hljs-number">5.0</span>
ip_adapter_scales = <span class="hljs-number">0.8</span>

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)

pipeline.set_ip_adapter_scale(ip_adapter_scale)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    guidance_scale=<span class="hljs-number">3.0</span>,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]
`,wrap:!1}}),te=new oe({props:{title:"Configure parameters",local:"configure-parameters",headingTag:"h2"}}),ae=new oe({props:{title:"pag_applied_layers",local:"pagappliedlayers",headingTag:"h3"}}),ie=new x({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbnNlY3QlMjByb2JvdCUyMHByZXBhcmluZyUyMGElMjBkZWxpY2lvdXMlMjBtZWFsJTJDJTIwYW5pbWUlMjBzdHlsZSUyMiUwQXBpcGVsaW5lLnNldF9wYWdfYXBwbGllZF9sYXllcnMocGFnX2xheWVycyklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEZ3VpZGFuY2Vfc2NhbGUlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBwYWdfc2NhbGUlM0RwYWdfc2NhbGUlMkMlMEEpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQ=",highlighted:`prompt = <span class="hljs-string">&quot;an insect robot preparing a delicious meal, anime style&quot;</span>
pipeline.set_pag_applied_layers(pag_layers)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    guidance_scale=guidance_scale,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),pe=new Pe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/pag.md"}}),{c(){r=f("meta"),W=p(),m=f("p"),_=p(),b(u.$$.fragment),M=p(),c=f("p"),c.innerHTML=d,j=p(),C=f("p"),C.textContent=y,k=p(),b(I.$$.fragment),$=p(),v=f("p"),v.innerHTML=Z,Y=p(),n=f("blockquote"),n.innerHTML=a,X=p(),b(V.$$.fragment),P=p(),b(A.$$.fragment),F=p(),E=f("p"),E.innerHTML=i,B=p(),b(q.$$.fragment),ce=p(),b(Q.$$.fragment),me=p(),L=f("p"),L.innerHTML=Ie,Me=p(),b(D.$$.fragment),de=p(),N=f("div"),N.innerHTML=Be,ue=p(),b(K.$$.fragment),ye=p(),O=f("p"),O.innerHTML=$e,fe=p(),b(ee.$$.fragment),ge=p(),le=f("p"),le.textContent=Xe,be=p(),S=f("div"),S.innerHTML=ve,he=p(),b(te.$$.fragment),Je=p(),b(ae.$$.fragment),we=p(),se=f("p"),se.innerHTML=Ve,Ue=p(),ne=f("p"),ne.innerHTML=xe,Te=p(),b(ie.$$.fragment),Ze=p(),H=f("div"),H.innerHTML=ke,je=p(),b(pe.$$.fragment),Ge=p(),re=f("p"),this.h()},l(e){const s=Se("svelte-u9bgzb",document.head);r=g(s,"META",{name:!0,content:!0}),s.forEach(l),W=o(e),m=g(e,"P",{}),Ae(m).forEach(l),_=o(e),h(u.$$.fragment,e),M=o(e),c=g(e,"P",{"data-svelte-h":!0}),G(c)!=="svelte-1w1c4u2"&&(c.innerHTML=d),j=o(e),C=g(e,"P",{"data-svelte-h":!0}),G(C)!=="svelte-11cdpcr"&&(C.textContent=y),k=o(e),h(I.$$.fragment,e),$=o(e),v=g(e,"P",{"data-svelte-h":!0}),G(v)!=="svelte-dt4tyz"&&(v.innerHTML=Z),Y=o(e),n=g(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),G(n)!=="svelte-7eizy1"&&(n.innerHTML=a),X=o(e),h(V.$$.fragment,e),P=o(e),h(A.$$.fragment,e),F=o(e),E=g(e,"P",{"data-svelte-h":!0}),G(E)!=="svelte-4m1dma"&&(E.innerHTML=i),B=o(e),h(q.$$.fragment,e),ce=o(e),h(Q.$$.fragment,e),me=o(e),L=g(e,"P",{"data-svelte-h":!0}),G(L)!=="svelte-112ukzn"&&(L.innerHTML=Ie),Me=o(e),h(D.$$.fragment,e),de=o(e),N=g(e,"DIV",{class:!0,"data-svelte-h":!0}),G(N)!=="svelte-e2cxkg"&&(N.innerHTML=Be),ue=o(e),h(K.$$.fragment,e),ye=o(e),O=g(e,"P",{"data-svelte-h":!0}),G(O)!=="svelte-rjcwxp"&&(O.innerHTML=$e),fe=o(e),h(ee.$$.fragment,e),ge=o(e),le=g(e,"P",{"data-svelte-h":!0}),G(le)!=="svelte-1n1gw76"&&(le.textContent=Xe),be=o(e),S=g(e,"DIV",{class:!0,"data-svelte-h":!0}),G(S)!=="svelte-j0lguw"&&(S.innerHTML=ve),he=o(e),h(te.$$.fragment,e),Je=o(e),h(ae.$$.fragment,e),we=o(e),se=g(e,"P",{"data-svelte-h":!0}),G(se)!=="svelte-1th38n0"&&(se.innerHTML=Ve),Ue=o(e),ne=g(e,"P",{"data-svelte-h":!0}),G(ne)!=="svelte-1d06cik"&&(ne.innerHTML=xe),Te=o(e),h(ie.$$.fragment,e),Ze=o(e),H=g(e,"DIV",{class:!0,"data-svelte-h":!0}),G(H)!=="svelte-1srsjub"&&(H.innerHTML=ke),je=o(e),h(pe.$$.fragment,e),Ge=o(e),re=g(e,"P",{}),Ae(re).forEach(l),this.h()},h(){z(r,"name","hf:doc:metadata"),z(r,"content",tl),z(n,"class","tip"),z(N,"class","flex flex-row gap-4"),z(S,"class","flex flex-row gap-4"),z(H,"class","flex flex-row gap-4")},m(e,s){He(document.head,r),t(e,W,s),t(e,m,s),t(e,_,s),J(u,e,s),t(e,M,s),t(e,c,s),t(e,j,s),t(e,C,s),t(e,k,s),J(I,e,s),t(e,$,s),t(e,v,s),t(e,Y,s),t(e,n,s),t(e,X,s),J(V,e,s),t(e,P,s),J(A,e,s),t(e,F,s),t(e,E,s),t(e,B,s),J(q,e,s),t(e,ce,s),J(Q,e,s),t(e,me,s),t(e,L,s),t(e,Me,s),J(D,e,s),t(e,de,s),t(e,N,s),t(e,ue,s),J(K,e,s),t(e,ye,s),t(e,O,s),t(e,fe,s),J(ee,e,s),t(e,ge,s),t(e,le,s),t(e,be,s),t(e,S,s),t(e,he,s),J(te,e,s),t(e,Je,s),J(ae,e,s),t(e,we,s),t(e,se,s),t(e,Ue,s),t(e,ne,s),t(e,Te,s),J(ie,e,s),t(e,Ze,s),t(e,H,s),t(e,je,s),J(pe,e,s),t(e,Ge,s),t(e,re,s),We=!0},p(e,[s]){const Ye={};s&2&&(Ye.$$scope={dirty:s,ctx:e}),V.$set(Ye);const Re={};s&2&&(Re.$$scope={dirty:s,ctx:e}),Q.$set(Re)},i(e){We||(w(u.$$.fragment,e),w(I.$$.fragment,e),w(V.$$.fragment,e),w(A.$$.fragment,e),w(q.$$.fragment,e),w(Q.$$.fragment,e),w(D.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(ae.$$.fragment,e),w(ie.$$.fragment,e),w(pe.$$.fragment,e),We=!0)},o(e){U(u.$$.fragment,e),U(I.$$.fragment,e),U(V.$$.fragment,e),U(A.$$.fragment,e),U(q.$$.fragment,e),U(Q.$$.fragment,e),U(D.$$.fragment,e),U(K.$$.fragment,e),U(ee.$$.fragment,e),U(te.$$.fragment,e),U(ae.$$.fragment,e),U(ie.$$.fragment,e),U(pe.$$.fragment,e),We=!1},d(e){e&&(l(W),l(m),l(_),l(M),l(c),l(j),l(C),l(k),l($),l(v),l(Y),l(n),l(X),l(P),l(F),l(E),l(B),l(ce),l(me),l(L),l(Me),l(de),l(N),l(ue),l(ye),l(O),l(fe),l(ge),l(le),l(be),l(S),l(he),l(Je),l(we),l(se),l(Ue),l(ne),l(Te),l(Ze),l(H),l(je),l(Ge),l(re)),l(r),T(u,e),T(I,e),T(V,e),T(A,e),T(q,e),T(Q,e),T(D,e),T(K,e),T(ee,e),T(te,e),T(ae,e),T(ie,e),T(pe,e)}}}const tl='{"title":"Perturbed-Attention Guidance","local":"perturbed-attention-guidance","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"PAG with ControlNet","local":"pag-with-controlnet","sections":[],"depth":2},{"title":"PAG with IP-Adapter","local":"pag-with-ip-adapter","sections":[],"depth":2},{"title":"Configure parameters","local":"configure-parameters","sections":[{"title":"pag_applied_layers","local":"pagappliedlayers","sections":[],"depth":3}],"depth":2}],"depth":1}';function al(R){return Ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cl extends Qe{constructor(r){super(),Ne(this,r,al,ll,Fe,{})}}export{cl as component};
