import{s as $t,n as kt,o as Ct}from"../chunks/scheduler.8c3d61f6.js";import{S as Wt,i as Rt,g as n,s as i,r,A as It,h as o,f as t,c as a,j as xt,u as p,x as f,k as Nl,y as Bt,a as s,v as m,d,t as u,w as c}from"../chunks/index.da70eac4.js";import{C as h}from"../chunks/CodeBlock.a9c4becf.js";import{D as Xt}from"../chunks/DocNotebookDropdown.48852948.js";import{H as y,E as Yt}from"../chunks/getInferenceSnippets.cb466318.js";function Ft(ql){let M,ke,xe,Ce,w,We,J,Re,T,zl="Diffusion models are typically stored in the Diffusers format or single-file format. Model files can be stored in various file types such as safetensors, dduf, or ckpt.",Ie,b,Ql="<p>Format refers to whether the weights are stored in a directory structure and file refers to the file type.</p>",Be,Z,Dl="This guide will show you how to load pipelines and models from these formats and files.",Xe,U,Ye,_,Pl="The Diffusers format stores each model (UNet, transformer, text encoder) in a separate subfolder. There are several benefits to storing models separately.",Fe,j,Al='<li>Faster overall pipeline initialization because you can load the individual model you need or load them all in parallel.</li> <li>Reduced memory usage because you don’t need to load all the pipeline components if you only need one model. <a href="./loading#reusing-models-in-multiple-pipelines">Reuse</a> a model that is shared between multiple pipelines.</li> <li>Lower storage requirements because common models shared between multiple pipelines are only downloaded once.</li> <li>Flexibility to use new or improved models in a pipeline.</li>',Ve,G,Le,v,Kl="A single-file format stores <em>all</em> the model (UNet, transformer, text encoder) weights in a single file. Benefits of single-file formats include the following.",Se,x,Ol='<li>Greater compatibility with <a href="https://github.com/comfyanonymous/ComfyUI" rel="nofollow">ComfyUI</a> or <a href="https://github.com/AUTOMATIC1111/stable-diffusion-webui" rel="nofollow">Automatic1111</a>.</li> <li>Easier to download and share a single file.</li>',Ee,$,et='Use <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> to load a single file.',He,k,Ne,C,lt='The <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> method also supports passing new models or schedulers.',qe,W,ze,R,Qe,I,tt='Diffusers format models have a <code>config.json</code> file in their repositories with important attributes such as the number of layers and attention heads. The <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> method automatically determines the appropriate config to use from <code>config.json</code>. This may fail in a few rare instances though, in which case, you should use the <code>config</code> argument.',De,B,st="You should also use the <code>config</code> argument if the models in a pipeline are different from the original implementation or if it doesn’t have the necessary metadata to determine the correct config.",Pe,X,Ae,Y,it="Diffusers attempts to infer the pipeline components based on the signature types of the pipeline class when using <code>original_config</code> with <code>local_files_only=True</code>. It won’t download the config files from a Hub repository to avoid backward breaking changes when you can’t connect to the internet. This method isn’t as reliable as providing a path to a local model with the <code>config</code> argument and may lead to errors. You should run the pipeline with <code>local_files_only=False</code> to download the config files to the local cache to avoid errors.",Ke,F,at='Override default configs by passing the arguments directly to <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a>. The examples below demonstrate how to override the configs in a pipeline or model.',Oe,V,el,L,ll,S,tl,E,nt='The <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> method attempts to configure a pipeline or model by inferring the model type from the keys in the checkpoint file. For example, any single file checkpoint based on the Stable Diffusion XL base model is configured from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>.',sl,H,ot='If you’re working with local files, download the config files with the <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download" rel="nofollow">snapshot_download</a> method and the model checkpoint with <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download" rel="nofollow">hf_hub_download</a>. These files are downloaded to your <a href="https://huggingface.co/docs/huggingface_hub/en/guides/manage-cache" rel="nofollow">cache directory</a>, but you can download them to a specific directory with the <code>local_dir</code> argument.',il,N,al,q,nl,z,ft="If you’re working with a file system that does not support symlinking, download the checkpoint file to a local directory first with the <code>local_dir</code> parameter. Using the <code>local_dir</code> parameter automatically disables symlinks.",ol,Q,fl,D,rt='Pass these paths to <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a>.',rl,P,pl,A,ml,K,pt="Models can be stored in several file types. Safetensors is the most common file type but you may encounter other file types on the Hub or diffusion community.",dl,O,ul,ee,mt='<a href="https://hf.co/docs/safetensors" rel="nofollow">Safetensors</a> is a safe and fast file type for securely storing and loading tensors. It restricts the header size to limit certain types of attacks, supports lazy loading (useful for distributed setups), and generally loads faster.',cl,le,dt="Diffusers loads safetensors file by default (a required dependency) if they are available and the Safetensors library is installed.",hl,te,ut='Use <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> or <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> to load safetensor files.',yl,se,Ml,ie,ct='If you’re using a checkpoint trained with a Diffusers training script, metadata such as the LoRA configuration, is automatically saved. When the file is loaded, the metadata is parsed to correctly configure the LoRA and avoid missing or incorrect LoRA configs. Inspect the metadata of a safetensors file by clicking on the <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/safetensors/logo.png" alt="safetensors logo" style="vertical-align: middle; display: inline-block; max-height: 0.8em; max-width: 0.8em; margin: 0; padding: 0; line-height: 1;"/> logo next to the file on the Hub.',bl,ae,ht='Save the metadata for LoRAs that aren’t trained with Diffusers with either <code>transformer_lora_adapter_metadata</code> or <code>unet_lora_adapter_metadata</code> depending on your model. For the text encoder, use the <code>text_encoder_lora_adapter_metadata</code> and <code>text_encoder_2_lora_adapter_metadata</code> arguments in <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.FluxLoraLoaderMixin.save_lora_weights">save_lora_weights()</a>. This is only supported for safetensors files.',gl,ne,wl,oe,Jl,fe,yt='Older model weights are commonly saved with Python’s <a href="https://docs.python.org/3/library/pickle.html" rel="nofollow">pickle</a> utility in a ckpt file.',Tl,re,Mt="Pickled files may be unsafe because they can be exploited to execute malicious code. It is recommended to use safetensors files or convert the weights to safetensors files.",Zl,pe,bt='Use <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> to load a ckpt file.',Ul,me,_l,de,jl,g,gt='<p>DDUF is an experimental file type and the API may change. Refer to the DDUF <a href="https://huggingface.co/docs/hub/dduf" rel="nofollow">docs</a> to learn more.</p>',Gl,ue,wt="DDUF is a file type designed to unify different diffusion model distribution methods and weight-saving formats. It is a standardized and flexible method to package all components of a diffusion model into a single file, providing a balance between the Diffusers and single-file formats.",vl,ce,Jt='Use the <code>dduf_file</code> argument in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load a DDUF file. You can also load quantized dduf files as long as they are stored in the Diffusers format.',xl,he,$l,ye,Tt='To save a pipeline as a dduf file, use the <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.export_folder_as_dduf" rel="nofollow">export_folder_as_dduf</a> utility.',kl,Me,Cl,be,Wl,ge,Zt="Diffusers provides scripts and methods to convert format and files to enable broader support across the diffusion ecosystem.",Rl,we,Ut='Take a look at the <a href="https://github.com/huggingface/diffusers/tree/main/scripts" rel="nofollow">diffusers/scripts</a> folder to find a conversion script. Scripts with <code>&quot;to_diffusers</code> appended at the end converts a model to the Diffusers format. Each script has a specific set of arguments for configuring the conversion. Make sure you check what arguments are available.',Il,Je,_t="The example below converts a model stored in Diffusers format to a single-file format. Provide the path to the model to convert and where to save the converted model. You can optionally specify what file type and data type to save the model as.",Bl,Te,Xl,Ze,jt='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a> method also saves a model in Diffusers format and takes care of creating subfolders for each model. It saves the files as safetensor files by default.',Yl,Ue,Fl,_e,Gt='Finally, you can use a Space like <a href="https://hf.co/spaces/diffusers/sd-to-diffusers" rel="nofollow">SD To Diffusers</a> or <a href="https://hf.co/spaces/diffusers/sdxl-to-diffusers" rel="nofollow">SD-XL To Diffusers</a> to convert models to the Diffusers format. It’ll open a PR on your model repository with the converted files. This is the easiest way to convert a model, but it may fail for more complicated models. Using a conversion script is more reliable.',Vl,je,Ll,Ge,vt='<li>Learn more about the design decisions and why safetensor files are preferred for saving and loading model weights in the <a href="https://blog.eleuther.ai/safetensors-security-audit/" rel="nofollow">Safetensors audited as really safe and becoming the default</a> blog post.</li>',Sl,ve,El,$e,Hl;return w=new Xt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/other-formats.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/other-formats.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/other-formats.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/other-formats.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/other-formats.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/other-formats.ipynb"}]}}),J=new y({props:{title:"Model formats",local:"model-formats",headingTag:"h1"}}),U=new y({props:{title:"Diffusers format",local:"diffusers-format",headingTag:"h2"}}),G=new y({props:{title:"Single file format",local:"single-file-format",headingTag:"h2"}}),k=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMkZibG9iJTJGbWFpbiUyRnNkX3hsX2Jhc2VfMS4wLnNhZmV0ZW5zb3JzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0.safetensors&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),W=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTJDJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUwQSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZLaWphaSUyRmZsdXgtZnA4JTJGYmxvYiUyRm1haW4lMkZmbHV4MS1kZXYtZnA4LnNhZmV0ZW5zb3JzJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEFwaXBlbGluZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lciUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, FluxTransformer2DModel

transformer = FluxTransformer2DModel.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/Kijai/flux-fp8/blob/main/flux1-dev-fp8.safetensors&quot;</span>, torch_dtype=torch.bfloat16
)
pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),R=new y({props:{title:"Configuration options",local:"configuration-options",headingTag:"h3"}}),X=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc2VnbWluZCUyRlNTRC0xQiUyRmJsb2IlMkZtYWluJTJGU1NELTFCLnNhZmV0ZW5zb3JzJTIyJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoY2twdF9wYXRoJTJDJTIwY29uZmlnJTNEJTIyc2VnbWluZCUyRlNTRC0xQiUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/segmind/SSD-1B/blob/main/SSD-1B.safetensors&quot;</span>

pipeline = StableDiffusionXLPipeline.from_single_file(ckpt_path, config=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>)`,wrap:!1}}),V=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZjb3N4bCUyRmJsb2IlMkZtYWluJTJGY29zeGxfZWRpdC5zYWZldGVuc29ycyUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExJbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMGNrcHRfcGF0aCUyQyUyMGNvbmZpZyUzRCUyMmRpZmZ1c2VycyUyRnNkeGwtaW5zdHJ1Y3RwaXgycGl4LTc2OCUyMiUyQyUyMGlzX2Nvc3hsX2VkaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLInstructPix2PixPipeline

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/cosxl/blob/main/cosxl_edit.safetensors&quot;</span>
pipeline = StableDiffusionXLInstructPix2PixPipeline.from_single_file(
    ckpt_path, config=<span class="hljs-string">&quot;diffusers/sdxl-instructpix2pix-768&quot;</span>, is_cosxl_edit=<span class="hljs-literal">True</span>
)`,wrap:!1}}),L=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBY2twdF9wYXRoJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyRmJsb2IlMkZtYWluJTJGc2RfeGxfYmFzZV8xLjBfMC45dmFlLnNhZmV0ZW5zb3JzJTIyJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3NpbmdsZV9maWxlKGNrcHRfcGF0aCUyQyUyMHVwY2FzdF9hdHRlbnRpb24lM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0_0.9vae.safetensors&quot;</span>
model = UNet2DConditionModel.from_single_file(ckpt_path, upcast_attention=<span class="hljs-literal">True</span>)`,wrap:!1}}),S=new y({props:{title:"Local files",local:"local-files",headingTag:"h3"}}),N=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUyQyUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFteV9sb2NhbF9jaGVja3BvaW50X3BhdGglMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnNlZ21pbmQlMkZTU0QtMUIlMjIlMkMlMEElMjAlMjAlMjAlMjBmaWxlbmFtZSUzRCUyMlNTRC0xQi5zYWZldGVuc29ycyUyMiUwQSklMEElMEFteV9sb2NhbF9jb25maWdfcGF0aCUyMCUzRCUyMHNuYXBzaG90X2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJzZWdtaW5kJTJGU1NELTFCJTIyJTJDJTBBJTIwJTIwJTIwJTIwYWxsb3dfcGF0dGVybnMlM0QlNUIlMjIqLmpzb24lMjIlMkMlMjAlMjIqKiUyRiouanNvbiUyMiUyQyUyMCUyMioudHh0JTIyJTJDJTIwJTIyKiolMkYqLnR4dCUyMiU1RCUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjBteV9sb2NhbF9jaGVja3BvaW50X3BhdGglMkMlMjBjb25maWclM0RteV9sb2NhbF9jb25maWdfcGF0aCUyQyUyMGxvY2FsX2ZpbGVzX29ubHklM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download, snapshot_download
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

my_local_checkpoint_path = hf_hub_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    filename=<span class="hljs-string">&quot;SSD-1B.safetensors&quot;</span>
)

my_local_config_path = snapshot_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    allow_patterns=[<span class="hljs-string">&quot;*.json&quot;</span>, <span class="hljs-string">&quot;**/*.json&quot;</span>, <span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-string">&quot;**/*.txt&quot;</span>]
)

pipeline = StableDiffusionXLPipeline.from_single_file(
    my_local_checkpoint_path, config=my_local_config_path, local_files_only=<span class="hljs-literal">True</span>
)`,wrap:!1}}),q=new y({props:{title:"Symlink",local:"symlink",headingTag:"h3"}}),Q=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUyQyUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFteV9sb2NhbF9jaGVja3BvaW50X3BhdGglMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnNlZ21pbmQlMkZTU0QtMUIlMjIlMkMlMEElMjAlMjAlMjAlMjBmaWxlbmFtZSUzRCUyMlNTRC0xQi5zYWZldGVuc29ycyUyMiUwQSUyMCUyMCUyMCUyMGxvY2FsX2RpciUzRCUyMm15X2xvY2FsX2NoZWNrcG9pbnRzJTIyJTJDJTBBKSUwQXByaW50KCUyMk15JTIwbG9jYWwlMjBjaGVja3BvaW50JTNBJTIwJTIyJTJDJTIwbXlfbG9jYWxfY2hlY2twb2ludF9wYXRoKSUwQSUwQW15X2xvY2FsX2NvbmZpZ19wYXRoJTIwJTNEJTIwc25hcHNob3RfZG93bmxvYWQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnNlZ21pbmQlMkZTU0QtMUIlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19wYXR0ZXJucyUzRCU1QiUyMiouanNvbiUyMiUyQyUyMCUyMioqJTJGKi5qc29uJTIyJTJDJTIwJTIyKi50eHQlMjIlMkMlMjAlMjIqKiUyRioudHh0JTIyJTVEJTBBKSUwQXByaW50KCUyMk15JTIwbG9jYWwlMjBjb25maWclM0ElMjAlMjIlMkMlMjBteV9sb2NhbF9jb25maWdfcGF0aCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download, snapshot_download
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

my_local_checkpoint_path = hf_hub_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    filename=<span class="hljs-string">&quot;SSD-1B.safetensors&quot;</span>
    local_dir=<span class="hljs-string">&quot;my_local_checkpoints&quot;</span>,
)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;My local checkpoint: &quot;</span>, my_local_checkpoint_path)

my_local_config_path = snapshot_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    allow_patterns=[<span class="hljs-string">&quot;*.json&quot;</span>, <span class="hljs-string">&quot;**/*.json&quot;</span>, <span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-string">&quot;**/*.txt&quot;</span>]
)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;My local config: &quot;</span>, my_local_config_path)`,wrap:!1}}),P=new h({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwbXlfbG9jYWxfY2hlY2twb2ludF9wYXRoJTJDJTIwY29uZmlnJTNEbXlfbG9jYWxfY29uZmlnX3BhdGglMkMlMjBsb2NhbF9maWxlc19vbmx5JTNEVHJ1ZSUwQSk=",highlighted:`pipeline = StableDiffusionXLPipeline.from_single_file(
    my_local_checkpoint_path, config=my_local_config_path, local_files_only=<span class="hljs-literal">True</span>
)`,wrap:!1}}),A=new y({props:{title:"File types",local:"file-types",headingTag:"h2"}}),O=new y({props:{title:"safetensors",local:"safetensors",headingTag:"h3"}}),se=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaC5kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyRmJsb2IlMkZtYWluJTJGc2RfeGxfYmFzZV8xLjAuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch.dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)

pipeline = DiffusionPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0.safetensors&quot;</span>,
    torch_dtype=torch.float16,
)`,wrap:!1}}),ne=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTIybGlub3l0cyUyRnlhcm5fYXJ0X0ZsdXhfTG9SQSUyMiklMEFwaXBlbGluZS5zYXZlX2xvcmFfd2VpZ2h0cyglMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfbG9yYV9hZGFwdGVyX21ldGFkYXRhJTNEJTdCJTIyciUyMiUzQSUyMDglMkMlMjAlMjJsb3JhX2FscGhhJTIyJTNBJTIwOCU3RCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8yX2xvcmFfYWRhcHRlcl9tZXRhZGF0YSUzRCU3QiUyMnIlMjIlM0ElMjA4JTJDJTIwJTIybG9yYV9hbHBoYSUyMiUzQSUyMDglN0QlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;linoyts/yarn_art_Flux_LoRA&quot;</span>)
pipeline.save_lora_weights(
    text_encoder_lora_adapter_metadata={<span class="hljs-string">&quot;r&quot;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&quot;lora_alpha&quot;</span>: <span class="hljs-number">8</span>},
    text_encoder_2_lora_adapter_metadata={<span class="hljs-string">&quot;r&quot;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&quot;lora_alpha&quot;</span>: <span class="hljs-number">8</span>}
)`,wrap:!1}}),oe=new y({props:{title:"ckpt",local:"ckpt",headingTag:"h3"}}),me=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZibG9iJTJGbWFpbiUyRnYxLTUtcHJ1bmVkLmNrcHQlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/blob/main/v1-5-pruned.ckpt&quot;</span>
)`,wrap:!1}}),de=new y({props:{title:"dduf",local:"dduf",headingTag:"h3"}}),he=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJERFVGJTJGRkxVWC4xLWRldi1ERFVGJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGR1Zl9maWxlJTNEJTIyRkxVWC4xLWRldi5kZHVmJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;DDUF/FLUX.1-dev-DDUF&quot;</span>,
    dduf_file=<span class="hljs-string">&quot;FLUX.1-dev.dduf&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),Me=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwZXhwb3J0X2ZvbGRlcl9hc19kZHVmJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEElMEFzYXZlX2ZvbGRlciUyMCUzRCUyMCUyMmZsdXgtZGV2JTIyJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMmZsdXgtZGV2JTIyKSUwQWV4cG9ydF9mb2xkZXJfYXNfZGR1ZiglMjJmbHV4LWRldi5kZHVmJTIyJTJDJTIwZm9sZGVyX3BhdGglM0RzYXZlX2ZvbGRlcik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> export_folder_as_dduf

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16)

save_folder = <span class="hljs-string">&quot;flux-dev&quot;</span>
pipeline.save_pretrained(<span class="hljs-string">&quot;flux-dev&quot;</span>)
export_folder_as_dduf(<span class="hljs-string">&quot;flux-dev.dduf&quot;</span>, folder_path=save_folder)`,wrap:!1}}),be=new y({props:{title:"Converting formats and files",local:"converting-formats-and-files",headingTag:"h2"}}),Te=new h({props:{code:"cHl0aG9uJTIwY29udmVydF9kaWZmdXNlcnNfdG9fb3JpZ2luYWxfc2R4bC5weSUyMC0tbW9kZWxfcGF0aCUyMHBhdGglMkZ0byUyRm1vZGVsJTJGdG8lMkZjb252ZXJ0JTIwLS1jaGVja3BvaW50X3BhdGglMjBwYXRoJTJGdG8lMkZzYXZlJTJGbW9kZWwlMkZ0byUyMC0tdXNlX3NhZmV0ZW5zb3Jz",highlighted:"python convert_diffusers_to_original_sdxl.py --model_path path/to/model/to/convert --checkpoint_path path/to/save/model/to --use_safetensors",wrap:!1}}),Ue=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMkZibG9iJTJGbWFpbiUyRnNkX3hsX2Jhc2VfMS4wLnNhZmV0ZW5zb3JzJTIyJTJDJTBBKSUwQXBpcGVsaW5lLnNhdmVfcHJldHJhaW5lZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0.safetensors&quot;</span>,
)
pipeline.save_pretrained()`,wrap:!1}}),je=new y({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ve=new Yt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/other-formats.md"}}),{c(){M=n("meta"),ke=i(),xe=n("p"),Ce=i(),r(w.$$.fragment),We=i(),r(J.$$.fragment),Re=i(),T=n("p"),T.textContent=zl,Ie=i(),b=n("blockquote"),b.innerHTML=Ql,Be=i(),Z=n("p"),Z.textContent=Dl,Xe=i(),r(U.$$.fragment),Ye=i(),_=n("p"),_.textContent=Pl,Fe=i(),j=n("ul"),j.innerHTML=Al,Ve=i(),r(G.$$.fragment),Le=i(),v=n("p"),v.innerHTML=Kl,Se=i(),x=n("ul"),x.innerHTML=Ol,Ee=i(),$=n("p"),$.innerHTML=et,He=i(),r(k.$$.fragment),Ne=i(),C=n("p"),C.innerHTML=lt,qe=i(),r(W.$$.fragment),ze=i(),r(R.$$.fragment),Qe=i(),I=n("p"),I.innerHTML=tt,De=i(),B=n("p"),B.innerHTML=st,Pe=i(),r(X.$$.fragment),Ae=i(),Y=n("p"),Y.innerHTML=it,Ke=i(),F=n("p"),F.innerHTML=at,Oe=i(),r(V.$$.fragment),el=i(),r(L.$$.fragment),ll=i(),r(S.$$.fragment),tl=i(),E=n("p"),E.innerHTML=nt,sl=i(),H=n("p"),H.innerHTML=ot,il=i(),r(N.$$.fragment),al=i(),r(q.$$.fragment),nl=i(),z=n("p"),z.innerHTML=ft,ol=i(),r(Q.$$.fragment),fl=i(),D=n("p"),D.innerHTML=rt,rl=i(),r(P.$$.fragment),pl=i(),r(A.$$.fragment),ml=i(),K=n("p"),K.textContent=pt,dl=i(),r(O.$$.fragment),ul=i(),ee=n("p"),ee.innerHTML=mt,cl=i(),le=n("p"),le.textContent=dt,hl=i(),te=n("p"),te.innerHTML=ut,yl=i(),r(se.$$.fragment),Ml=i(),ie=n("p"),ie.innerHTML=ct,bl=i(),ae=n("p"),ae.innerHTML=ht,gl=i(),r(ne.$$.fragment),wl=i(),r(oe.$$.fragment),Jl=i(),fe=n("p"),fe.innerHTML=yt,Tl=i(),re=n("p"),re.textContent=Mt,Zl=i(),pe=n("p"),pe.innerHTML=bt,Ul=i(),r(me.$$.fragment),_l=i(),r(de.$$.fragment),jl=i(),g=n("blockquote"),g.innerHTML=gt,Gl=i(),ue=n("p"),ue.textContent=wt,vl=i(),ce=n("p"),ce.innerHTML=Jt,xl=i(),r(he.$$.fragment),$l=i(),ye=n("p"),ye.innerHTML=Tt,kl=i(),r(Me.$$.fragment),Cl=i(),r(be.$$.fragment),Wl=i(),ge=n("p"),ge.textContent=Zt,Rl=i(),we=n("p"),we.innerHTML=Ut,Il=i(),Je=n("p"),Je.textContent=_t,Bl=i(),r(Te.$$.fragment),Xl=i(),Ze=n("p"),Ze.innerHTML=jt,Yl=i(),r(Ue.$$.fragment),Fl=i(),_e=n("p"),_e.innerHTML=Gt,Vl=i(),r(je.$$.fragment),Ll=i(),Ge=n("ul"),Ge.innerHTML=vt,Sl=i(),r(ve.$$.fragment),El=i(),$e=n("p"),this.h()},l(e){const l=It("svelte-u9bgzb",document.head);M=o(l,"META",{name:!0,content:!0}),l.forEach(t),ke=a(e),xe=o(e,"P",{}),xt(xe).forEach(t),Ce=a(e),p(w.$$.fragment,e),We=a(e),p(J.$$.fragment,e),Re=a(e),T=o(e,"P",{"data-svelte-h":!0}),f(T)!=="svelte-c2lxv9"&&(T.textContent=zl),Ie=a(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(b)!=="svelte-1yj6eta"&&(b.innerHTML=Ql),Be=a(e),Z=o(e,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1rmo35c"&&(Z.textContent=Dl),Xe=a(e),p(U.$$.fragment,e),Ye=a(e),_=o(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-mvp8u4"&&(_.textContent=Pl),Fe=a(e),j=o(e,"UL",{"data-svelte-h":!0}),f(j)!=="svelte-9cg8xg"&&(j.innerHTML=Al),Ve=a(e),p(G.$$.fragment,e),Le=a(e),v=o(e,"P",{"data-svelte-h":!0}),f(v)!=="svelte-c5j773"&&(v.innerHTML=Kl),Se=a(e),x=o(e,"UL",{"data-svelte-h":!0}),f(x)!=="svelte-lcd56p"&&(x.innerHTML=Ol),Ee=a(e),$=o(e,"P",{"data-svelte-h":!0}),f($)!=="svelte-1ejmopk"&&($.innerHTML=et),He=a(e),p(k.$$.fragment,e),Ne=a(e),C=o(e,"P",{"data-svelte-h":!0}),f(C)!=="svelte-108tpry"&&(C.innerHTML=lt),qe=a(e),p(W.$$.fragment,e),ze=a(e),p(R.$$.fragment,e),Qe=a(e),I=o(e,"P",{"data-svelte-h":!0}),f(I)!=="svelte-1h9tww5"&&(I.innerHTML=tt),De=a(e),B=o(e,"P",{"data-svelte-h":!0}),f(B)!=="svelte-2c5ng5"&&(B.innerHTML=st),Pe=a(e),p(X.$$.fragment,e),Ae=a(e),Y=o(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-12jgfvr"&&(Y.innerHTML=it),Ke=a(e),F=o(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-1he9eyd"&&(F.innerHTML=at),Oe=a(e),p(V.$$.fragment,e),el=a(e),p(L.$$.fragment,e),ll=a(e),p(S.$$.fragment,e),tl=a(e),E=o(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-16qb8vg"&&(E.innerHTML=nt),sl=a(e),H=o(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-1j6w2cx"&&(H.innerHTML=ot),il=a(e),p(N.$$.fragment,e),al=a(e),p(q.$$.fragment,e),nl=a(e),z=o(e,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1k1yqxp"&&(z.innerHTML=ft),ol=a(e),p(Q.$$.fragment,e),fl=a(e),D=o(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-v6vlim"&&(D.innerHTML=rt),rl=a(e),p(P.$$.fragment,e),pl=a(e),p(A.$$.fragment,e),ml=a(e),K=o(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-ygwhf5"&&(K.textContent=pt),dl=a(e),p(O.$$.fragment,e),ul=a(e),ee=o(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-1r9mxml"&&(ee.innerHTML=mt),cl=a(e),le=o(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-1jn7xod"&&(le.textContent=dt),hl=a(e),te=o(e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-1gmtg4h"&&(te.innerHTML=ut),yl=a(e),p(se.$$.fragment,e),Ml=a(e),ie=o(e,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-ntsiw0"&&(ie.innerHTML=ct),bl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-qdiyno"&&(ae.innerHTML=ht),gl=a(e),p(ne.$$.fragment,e),wl=a(e),p(oe.$$.fragment,e),Jl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-b6vskk"&&(fe.innerHTML=yt),Tl=a(e),re=o(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-f5vld0"&&(re.textContent=Mt),Zl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-1co0wa6"&&(pe.innerHTML=bt),Ul=a(e),p(me.$$.fragment,e),_l=a(e),p(de.$$.fragment,e),jl=a(e),g=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(g)!=="svelte-szjpgm"&&(g.innerHTML=gt),Gl=a(e),ue=o(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-ltxrsq"&&(ue.textContent=wt),vl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-8qrktw"&&(ce.innerHTML=Jt),xl=a(e),p(he.$$.fragment,e),$l=a(e),ye=o(e,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-2pqis3"&&(ye.innerHTML=Tt),kl=a(e),p(Me.$$.fragment,e),Cl=a(e),p(be.$$.fragment,e),Wl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-12tiorg"&&(ge.textContent=Zt),Rl=a(e),we=o(e,"P",{"data-svelte-h":!0}),f(we)!=="svelte-1x85dqm"&&(we.innerHTML=Ut),Il=a(e),Je=o(e,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-xrvaku"&&(Je.textContent=_t),Bl=a(e),p(Te.$$.fragment,e),Xl=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-1suvf50"&&(Ze.innerHTML=jt),Yl=a(e),p(Ue.$$.fragment,e),Fl=a(e),_e=o(e,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-izh25y"&&(_e.innerHTML=Gt),Vl=a(e),p(je.$$.fragment,e),Ll=a(e),Ge=o(e,"UL",{"data-svelte-h":!0}),f(Ge)!=="svelte-38whus"&&(Ge.innerHTML=vt),Sl=a(e),p(ve.$$.fragment,e),El=a(e),$e=o(e,"P",{}),xt($e).forEach(t),this.h()},h(){Nl(M,"name","hf:doc:metadata"),Nl(M,"content",Vt),Nl(b,"class","tip"),Nl(g,"class","tip")},m(e,l){Bt(document.head,M),s(e,ke,l),s(e,xe,l),s(e,Ce,l),m(w,e,l),s(e,We,l),m(J,e,l),s(e,Re,l),s(e,T,l),s(e,Ie,l),s(e,b,l),s(e,Be,l),s(e,Z,l),s(e,Xe,l),m(U,e,l),s(e,Ye,l),s(e,_,l),s(e,Fe,l),s(e,j,l),s(e,Ve,l),m(G,e,l),s(e,Le,l),s(e,v,l),s(e,Se,l),s(e,x,l),s(e,Ee,l),s(e,$,l),s(e,He,l),m(k,e,l),s(e,Ne,l),s(e,C,l),s(e,qe,l),m(W,e,l),s(e,ze,l),m(R,e,l),s(e,Qe,l),s(e,I,l),s(e,De,l),s(e,B,l),s(e,Pe,l),m(X,e,l),s(e,Ae,l),s(e,Y,l),s(e,Ke,l),s(e,F,l),s(e,Oe,l),m(V,e,l),s(e,el,l),m(L,e,l),s(e,ll,l),m(S,e,l),s(e,tl,l),s(e,E,l),s(e,sl,l),s(e,H,l),s(e,il,l),m(N,e,l),s(e,al,l),m(q,e,l),s(e,nl,l),s(e,z,l),s(e,ol,l),m(Q,e,l),s(e,fl,l),s(e,D,l),s(e,rl,l),m(P,e,l),s(e,pl,l),m(A,e,l),s(e,ml,l),s(e,K,l),s(e,dl,l),m(O,e,l),s(e,ul,l),s(e,ee,l),s(e,cl,l),s(e,le,l),s(e,hl,l),s(e,te,l),s(e,yl,l),m(se,e,l),s(e,Ml,l),s(e,ie,l),s(e,bl,l),s(e,ae,l),s(e,gl,l),m(ne,e,l),s(e,wl,l),m(oe,e,l),s(e,Jl,l),s(e,fe,l),s(e,Tl,l),s(e,re,l),s(e,Zl,l),s(e,pe,l),s(e,Ul,l),m(me,e,l),s(e,_l,l),m(de,e,l),s(e,jl,l),s(e,g,l),s(e,Gl,l),s(e,ue,l),s(e,vl,l),s(e,ce,l),s(e,xl,l),m(he,e,l),s(e,$l,l),s(e,ye,l),s(e,kl,l),m(Me,e,l),s(e,Cl,l),m(be,e,l),s(e,Wl,l),s(e,ge,l),s(e,Rl,l),s(e,we,l),s(e,Il,l),s(e,Je,l),s(e,Bl,l),m(Te,e,l),s(e,Xl,l),s(e,Ze,l),s(e,Yl,l),m(Ue,e,l),s(e,Fl,l),s(e,_e,l),s(e,Vl,l),m(je,e,l),s(e,Ll,l),s(e,Ge,l),s(e,Sl,l),m(ve,e,l),s(e,El,l),s(e,$e,l),Hl=!0},p:kt,i(e){Hl||(d(w.$$.fragment,e),d(J.$$.fragment,e),d(U.$$.fragment,e),d(G.$$.fragment,e),d(k.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(V.$$.fragment,e),d(L.$$.fragment,e),d(S.$$.fragment,e),d(N.$$.fragment,e),d(q.$$.fragment,e),d(Q.$$.fragment,e),d(P.$$.fragment,e),d(A.$$.fragment,e),d(O.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(me.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(Me.$$.fragment,e),d(be.$$.fragment,e),d(Te.$$.fragment,e),d(Ue.$$.fragment,e),d(je.$$.fragment,e),d(ve.$$.fragment,e),Hl=!0)},o(e){u(w.$$.fragment,e),u(J.$$.fragment,e),u(U.$$.fragment,e),u(G.$$.fragment,e),u(k.$$.fragment,e),u(W.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(V.$$.fragment,e),u(L.$$.fragment,e),u(S.$$.fragment,e),u(N.$$.fragment,e),u(q.$$.fragment,e),u(Q.$$.fragment,e),u(P.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),u(Me.$$.fragment,e),u(be.$$.fragment,e),u(Te.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(ve.$$.fragment,e),Hl=!1},d(e){e&&(t(ke),t(xe),t(Ce),t(We),t(Re),t(T),t(Ie),t(b),t(Be),t(Z),t(Xe),t(Ye),t(_),t(Fe),t(j),t(Ve),t(Le),t(v),t(Se),t(x),t(Ee),t($),t(He),t(Ne),t(C),t(qe),t(ze),t(Qe),t(I),t(De),t(B),t(Pe),t(Ae),t(Y),t(Ke),t(F),t(Oe),t(el),t(ll),t(tl),t(E),t(sl),t(H),t(il),t(al),t(nl),t(z),t(ol),t(fl),t(D),t(rl),t(pl),t(ml),t(K),t(dl),t(ul),t(ee),t(cl),t(le),t(hl),t(te),t(yl),t(Ml),t(ie),t(bl),t(ae),t(gl),t(wl),t(Jl),t(fe),t(Tl),t(re),t(Zl),t(pe),t(Ul),t(_l),t(jl),t(g),t(Gl),t(ue),t(vl),t(ce),t(xl),t($l),t(ye),t(kl),t(Cl),t(Wl),t(ge),t(Rl),t(we),t(Il),t(Je),t(Bl),t(Xl),t(Ze),t(Yl),t(Fl),t(_e),t(Vl),t(Ll),t(Ge),t(Sl),t(El),t($e)),t(M),c(w,e),c(J,e),c(U,e),c(G,e),c(k,e),c(W,e),c(R,e),c(X,e),c(V,e),c(L,e),c(S,e),c(N,e),c(q,e),c(Q,e),c(P,e),c(A,e),c(O,e),c(se,e),c(ne,e),c(oe,e),c(me,e),c(de,e),c(he,e),c(Me,e),c(be,e),c(Te,e),c(Ue,e),c(je,e),c(ve,e)}}}const Vt='{"title":"Model formats","local":"model-formats","sections":[{"title":"Diffusers format","local":"diffusers-format","sections":[],"depth":2},{"title":"Single file format","local":"single-file-format","sections":[{"title":"Configuration options","local":"configuration-options","sections":[],"depth":3},{"title":"Local files","local":"local-files","sections":[],"depth":3},{"title":"Symlink","local":"symlink","sections":[],"depth":3}],"depth":2},{"title":"File types","local":"file-types","sections":[{"title":"safetensors","local":"safetensors","sections":[],"depth":3},{"title":"ckpt","local":"ckpt","sections":[],"depth":3},{"title":"dduf","local":"dduf","sections":[],"depth":3}],"depth":2},{"title":"Converting formats and files","local":"converting-formats-and-files","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Lt(ql){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Wt{constructor(M){super(),Rt(this,M,Lt,Ft,$t,{})}}export{zt as component};
