import{s as cl,o as ml,n as Y}from"../chunks/scheduler.8c3d61f6.js";import{S as Ml,i as dl,g as u,s as c,r as B,A as ul,h as y,f as s,c as m,j as rl,u as I,x as f,k as Me,y as yl,a,v as _,d as C,t as G,w as W}from"../chunks/index.da70eac4.js";import{C as $}from"../chunks/CodeBlock.a9c4becf.js";import{H as ue,E as hl}from"../chunks/getInferenceSnippets.cb466318.js";import{H as Se,a as R}from"../chunks/HfOption.6c3b4e77.js";function fl(g){let t,d="To apply first block cache on FLUX.1-dev, call <code>apply_cache_on_pipe</code> as shown below. 0.08 is the default residual difference value for FLUX models.",p,r,l,n,J='<thead><tr><th>Optimizations</th> <th>Original</th> <th>FBCache rdt=0.06</th> <th>FBCache rdt=0.08</th> <th>FBCache rdt=0.10</th> <th>FBCache rdt=0.12</th></tr></thead> <tbody><tr><td>Preview</td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-original.png" alt="Original"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-fbc-0.06.png" alt="FBCache rdt=0.06"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-fbc-0.08.png" alt="FBCache rdt=0.08"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-fbc-0.10.png" alt="FBCache rdt=0.10"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-fbc-0.12.png" alt="FBCache rdt=0.12"/></td></tr> <tr><td>Wall Time (s)</td> <td>26.36</td> <td>21.83</td> <td>17.01</td> <td>16.00</td> <td>13.78</td></tr></tbody>',w,M,b="First Block Cache reduced the inference speed to 17.01 seconds compared to the baseline, or 1.55x faster, while maintaining nearly zero quality loss.",U;return r=new $({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZnJvbSUyMHBhcmFfYXR0bi5maXJzdF9ibG9ja19jYWNoZS5kaWZmdXNlcnNfYWRhcHRlcnMlMjBpbXBvcnQlMjBhcHBseV9jYWNoZV9vbl9waXBlJTBBJTBBYXBwbHlfY2FjaGVfb25fcGlwZShwaXBlJTJDJTIwcmVzaWR1YWxfZGlmZl90aHJlc2hvbGQlM0QwLjA4KSUwQSUwQSUyMyUyMEVuYWJsZSUyMG1lbW9yeSUyMHNhdmluZ3MlMEElMjMlMjBwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcGlwZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZCgpJTBBJTBBYmVnaW4lMjAlM0QlMjB0aW1lLnRpbWUoKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBZW5kJTIwJTNEJTIwdGltZS50aW1lKCklMEFwcmludChmJTIyVGltZSUzQSUyMCU3QmVuZCUyMC0lMjBiZWdpbiUzQS4yZiU3RHMlMjIpJTBBJTBBcHJpbnQoJTIyU2F2aW5nJTIwaW1hZ2UlMjB0byUyMGZsdXgucG5nJTIyKSUwQWltYWdlLnNhdmUoJTIyZmx1eC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(pipe, residual_diff_threshold=<span class="hljs-number">0.08</span>)

<span class="hljs-comment"># Enable memory savings</span>
<span class="hljs-comment"># pipe.enable_model_cpu_offload()</span>
<span class="hljs-comment"># pipe.enable_sequential_cpu_offload()</span>

begin = time.time()
image = pipe(
    <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
).images[<span class="hljs-number">0</span>]
end = time.time()
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving image to flux.png&quot;</span>)
image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=d,p=c(),B(r.$$.fragment),l=c(),n=u("table"),n.innerHTML=J,w=c(),M=u("p"),M.textContent=b},l(h){t=y(h,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1gztnit"&&(t.innerHTML=d),p=m(h),I(r.$$.fragment,h),l=m(h),n=y(h,"TABLE",{"data-svelte-h":!0}),f(n)!=="svelte-oatp7r"&&(n.innerHTML=J),w=m(h),M=y(h,"P",{"data-svelte-h":!0}),f(M)!=="svelte-1igi2g7"&&(M.textContent=b)},m(h,Z){a(h,t,Z),a(h,p,Z),_(r,h,Z),a(h,l,Z),a(h,n,Z),a(h,w,Z),a(h,M,Z),U=!0},p:Y,i(h){U||(C(r.$$.fragment,h),U=!0)},o(h){G(r.$$.fragment,h),U=!1},d(h){h&&(s(t),s(p),s(l),s(n),s(w),s(M)),W(r,h)}}}function Jl(g){let t,d="To apply First Block Cache on HunyuanVideo, <code>apply_cache_on_pipe</code> as shown below. 0.06 is the default residual difference value for HunyuanVideo models.",p,r,l,n,J=`<source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/hunyuan-video-original.mp4" type="video/mp4"/>
  Your browser does not support the video tag.`,w,M,b="HunyuanVideo without FBCache",U,h,Z=`<source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/hunyuan-video-fbc.mp4" type="video/mp4"/>
  Your browser does not support the video tag.`,o,T,X="HunyuanVideo with FBCache",N,V,k="First Block Cache reduced the inference speed to 2271.06 seconds compared to the baseline, or 1.62x faster, while maintaining nearly zero quality loss.",z;return r=new $({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEh1bnl1YW5WaWRlb1BpcGVsaW5lJTJDJTIwSHVueXVhblZpZGVvVHJhbnNmb3JtZXIzRE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGVuY2VudCUyRkh1bnl1YW5WaWRlbyUyMiUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwSHVueXVhblZpZGVvVHJhbnNmb3JtZXIzRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEJTIycmVmcyUyRnByJTJGMTglMjIlMkMlMEEpJTBBcGlwZSUyMCUzRCUyMEh1bnl1YW5WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzRCUyMnJlZnMlMkZwciUyRjE4JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWZyb20lMjBwYXJhX2F0dG4uZmlyc3RfYmxvY2tfY2FjaGUuZGlmZnVzZXJzX2FkYXB0ZXJzJTIwaW1wb3J0JTIwYXBwbHlfY2FjaGVfb25fcGlwZSUwQSUwQWFwcGx5X2NhY2hlX29uX3BpcGUocGlwZSUyQyUyMHJlc2lkdWFsX2RpZmZfdGhyZXNob2xkJTNEMC42KSUwQSUwQXBpcGUudmFlLmVuYWJsZV90aWxpbmcoKSUwQSUwQWJlZ2luJTIwJTNEJTIwdGltZS50aW1lKCklMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBjYXQlMjB3YWxrcyUyMG9uJTIwdGhlJTIwZ3Jhc3MlMkMlMjByZWFsaXN0aWMlMjIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3MjAlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEyODAlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTI5JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZW5kJTIwJTNEJTIwdGltZS50aW1lKCklMEFwcmludChmJTIyVGltZSUzQSUyMCU3QmVuZCUyMC0lMjBiZWdpbiUzQS4yZiU3RHMlMjIpJTBBJTBBcHJpbnQoJTIyU2F2aW5nJTIwdmlkZW8lMjB0byUyMGh1bnl1YW5fdmlkZW8ubXA0JTIyKSUwQWV4cG9ydF90b192aWRlbyhvdXRwdXQlMkMlMjAlMjJodW55dWFuX3ZpZGVvLm1wNCUyMiUyQyUyMGZwcyUzRDE1KQ==",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline, HunyuanVideoTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>
transformer = HunyuanVideoTransformer3DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    torch_dtype=torch.bfloat16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
)
pipe = HunyuanVideoPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=torch.float16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(pipe, residual_diff_threshold=<span class="hljs-number">0.6</span>)

pipe.vae.enable_tiling()

begin = time.time()
output = pipe(
    prompt=<span class="hljs-string">&quot;A cat walks on the grass, realistic&quot;</span>,
    height=<span class="hljs-number">720</span>,
    width=<span class="hljs-number">1280</span>,
    num_frames=<span class="hljs-number">129</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
).frames[<span class="hljs-number">0</span>]
end = time.time()
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving video to hunyuan_video.mp4&quot;</span>)
export_to_video(output, <span class="hljs-string">&quot;hunyuan_video.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=d,p=c(),B(r.$$.fragment),l=c(),n=u("video"),n.innerHTML=J,w=c(),M=u("small"),M.textContent=b,U=c(),h=u("video"),h.innerHTML=Z,o=c(),T=u("small"),T.textContent=X,N=c(),V=u("p"),V.textContent=k,this.h()},l(j){t=y(j,"P",{"data-svelte-h":!0}),f(t)!=="svelte-ijrywe"&&(t.innerHTML=d),p=m(j),I(r.$$.fragment,j),l=m(j),n=y(j,"VIDEO",{"data-svelte-h":!0}),f(n)!=="svelte-o0uc7b"&&(n.innerHTML=J),w=m(j),M=y(j,"SMALL",{"data-svelte-h":!0}),f(M)!=="svelte-1m2snav"&&(M.textContent=b),U=m(j),h=y(j,"VIDEO",{"data-svelte-h":!0}),f(h)!=="svelte-1lwel73"&&(h.innerHTML=Z),o=m(j),T=y(j,"SMALL",{"data-svelte-h":!0}),f(T)!=="svelte-8iknyh"&&(T.textContent=X),N=m(j),V=y(j,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1ufkyta"&&(V.textContent=k),this.h()},h(){n.controls="",h.controls=""},m(j,v){a(j,t,v),a(j,p,v),_(r,j,v),a(j,l,v),a(j,n,v),a(j,w,v),a(j,M,v),a(j,U,v),a(j,h,v),a(j,o,v),a(j,T,v),a(j,N,v),a(j,V,v),z=!0},p:Y,i(j){z||(C(r.$$.fragment,j),z=!0)},o(j){G(r.$$.fragment,j),z=!1},d(j){j&&(s(t),s(p),s(l),s(n),s(w),s(M),s(U),s(h),s(o),s(T),s(N),s(V)),W(r,j)}}}function wl(g){let t,d,p,r;return t=new R({props:{id:"first-block-cache",option:"FLUX-1.dev",$$slots:{default:[fl]},$$scope:{ctx:g}}}),p=new R({props:{id:"first-block-cache",option:"HunyuanVideo",$$slots:{default:[Jl]},$$scope:{ctx:g}}}),{c(){B(t.$$.fragment),d=c(),B(p.$$.fragment)},l(l){I(t.$$.fragment,l),d=m(l),I(p.$$.fragment,l)},m(l,n){_(t,l,n),a(l,d,n),_(p,l,n),r=!0},p(l,n){const J={};n&2&&(J.$$scope={dirty:n,ctx:l}),t.$set(J);const w={};n&2&&(w.$$scope={dirty:n,ctx:l}),p.$set(w)},i(l){r||(C(t.$$.fragment,l),C(p.$$.fragment,l),r=!0)},o(l){G(t.$$.fragment,l),G(p.$$.fragment,l),r=!1},d(l){l&&s(d),W(t,l),W(p,l)}}}function jl(g){let t,d,p,r="fp8 dynamic quantization and torch.compile reduced the inference speed to 7.56 seconds compared to the baseline, or 3.48x faster.",l;return t=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(
    pipe,
    residual_diff_threshold=<span class="hljs-number">0.12</span>,  <span class="hljs-comment"># Use a larger value to make the cache take effect</span>
)

<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> quantize_, float8_dynamic_activation_float8_weight, float8_weight_only

quantize_(pipe.text_encoder, float8_weight_only())
quantize_(pipe.transformer, float8_dynamic_activation_float8_weight())
pipe.transformer = torch.<span class="hljs-built_in">compile</span>(
   pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune-no-cudagraphs&quot;</span>,
)

<span class="hljs-comment"># Enable memory savings</span>
<span class="hljs-comment"># pipe.enable_model_cpu_offload()</span>
<span class="hljs-comment"># pipe.enable_sequential_cpu_offload()</span>

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):
    begin = time.time()
    image = pipe(
        <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
        num_inference_steps=<span class="hljs-number">28</span>,
    ).images[<span class="hljs-number">0</span>]
    end = time.time()
    <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Warm up time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving image to flux.png&quot;</span>)
image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)`,wrap:!1}}),{c(){B(t.$$.fragment),d=c(),p=u("p"),p.textContent=r},l(n){I(t.$$.fragment,n),d=m(n),p=y(n,"P",{"data-svelte-h":!0}),f(p)!=="svelte-2k6y70"&&(p.textContent=r)},m(n,J){_(t,n,J),a(n,d,J),a(n,p,J),l=!0},p:Y,i(n){l||(C(t.$$.fragment,n),l=!0)},o(n){G(t.$$.fragment,n),l=!1},d(n){n&&(s(d),s(p)),W(t,n)}}}function Tl(g){let t,d,p,r="A NVIDIA L20 GPU only has 48GB memory and could face out-of-memory (OOM) errors after compilation and if <code>enable_model_cpu_offload</code> isn’t called because HunyuanVideo has very large activation tensors when running with high resolution and large number of frames. For GPUs with less than 80GB of memory, you can try reducing the resolution and number of frames to avoid OOM errors.",l,n,J="Large video generation models are usually bottlenecked by the attention computations rather than the fully connected layers. These models don’t significantly benefit from quantization and torch.compile.",w;return t=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline, HunyuanVideoTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>
transformer = HunyuanVideoTransformer3DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    torch_dtype=torch.bfloat16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
)
pipe = HunyuanVideoPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=torch.float16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(pipe)

<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> quantize_, float8_dynamic_activation_float8_weight, float8_weight_only

quantize_(pipe.text_encoder, float8_weight_only())
quantize_(pipe.transformer, float8_dynamic_activation_float8_weight())
pipe.transformer = torch.<span class="hljs-built_in">compile</span>(
   pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune-no-cudagraphs&quot;</span>,
)

<span class="hljs-comment"># Enable memory savings</span>
pipe.vae.enable_tiling()
<span class="hljs-comment"># pipe.enable_model_cpu_offload()</span>
<span class="hljs-comment"># pipe.enable_sequential_cpu_offload()</span>

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):
    begin = time.time()
    output = pipe(
        prompt=<span class="hljs-string">&quot;A cat walks on the grass, realistic&quot;</span>,
        height=<span class="hljs-number">720</span>,
        width=<span class="hljs-number">1280</span>,
        num_frames=<span class="hljs-number">129</span>,
        num_inference_steps=<span class="hljs-number">1</span> <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">30</span>,
    ).frames[<span class="hljs-number">0</span>]
    end = time.time()
    <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Warm up time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving video to hunyuan_video.mp4&quot;</span>)
export_to_video(output, <span class="hljs-string">&quot;hunyuan_video.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)`,wrap:!1}}),{c(){B(t.$$.fragment),d=c(),p=u("p"),p.innerHTML=r,l=c(),n=u("p"),n.textContent=J},l(M){I(t.$$.fragment,M),d=m(M),p=y(M,"P",{"data-svelte-h":!0}),f(p)!=="svelte-1rkmqqz"&&(p.innerHTML=r),l=m(M),n=y(M,"P",{"data-svelte-h":!0}),f(n)!=="svelte-2mgvjd"&&(n.textContent=J)},m(M,b){_(t,M,b),a(M,d,b),a(M,p,b),a(M,l,b),a(M,n,b),w=!0},p:Y,i(M){w||(C(t.$$.fragment,M),w=!0)},o(M){G(t.$$.fragment,M),w=!1},d(M){M&&(s(d),s(p),s(l),s(n)),W(t,M)}}}function bl(g){let t,d,p,r;return t=new R({props:{id:"fp8-quantization",option:"FLUX-1.dev",$$slots:{default:[jl]},$$scope:{ctx:g}}}),p=new R({props:{id:"fp8-quantization",option:"HunyuanVideo",$$slots:{default:[Tl]},$$scope:{ctx:g}}}),{c(){B(t.$$.fragment),d=c(),B(p.$$.fragment)},l(l){I(t.$$.fragment,l),d=m(l),I(p.$$.fragment,l)},m(l,n){_(t,l,n),a(l,d,n),_(p,l,n),r=!0},p(l,n){const J={};n&2&&(J.$$scope={dirty:n,ctx:l}),t.$set(J);const w={};n&2&&(w.$$scope={dirty:n,ctx:l}),p.$set(w)},i(l){r||(C(t.$$.fragment,l),C(p.$$.fragment,l),r=!0)},o(l){G(t.$$.fragment,l),G(p.$$.fragment,l),r=!1},d(l){l&&s(d),W(t,l),W(p,l)}}}function Ul(g){let t,d="The code sample below combines First Block Cache, fp8 dynamic quantization, torch.compile, and Context Parallelism for the fastest inference speed.",p,r,l,n,J='Save to <code>run_flux.py</code> and launch it with <a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>.',w,M,b,U,h="Inference speed is reduced to 8.20 seconds compared to the baseline, or 3.21x faster, with 2 NVIDIA L20 GPUs. On 4 L20s, inference speed is 3.90 seconds, or 6.75x faster.",Z;return r=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

dist.init_process_group()

torch.cuda.set_device(dist.get_rank())

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.context_parallel <span class="hljs-keyword">import</span> init_context_parallel_mesh
<span class="hljs-keyword">from</span> para_attn.context_parallel.diffusers_adapters <span class="hljs-keyword">import</span> parallelize_pipe
<span class="hljs-keyword">from</span> para_attn.parallel_vae.diffusers_adapters <span class="hljs-keyword">import</span> parallelize_vae

mesh = init_context_parallel_mesh(
    pipe.device.<span class="hljs-built_in">type</span>,
    max_ring_dim_size=<span class="hljs-number">2</span>,
)
parallelize_pipe(
    pipe,
    mesh=mesh,
)
parallelize_vae(pipe.vae, mesh=mesh._flatten())

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(
    pipe,
    residual_diff_threshold=<span class="hljs-number">0.12</span>,  <span class="hljs-comment"># Use a larger value to make the cache take effect</span>
)

<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> quantize_, float8_dynamic_activation_float8_weight, float8_weight_only

quantize_(pipe.text_encoder, float8_weight_only())
quantize_(pipe.transformer, float8_dynamic_activation_float8_weight())
torch._inductor.config.reorder_for_compute_comm_overlap = <span class="hljs-literal">True</span>
pipe.transformer = torch.<span class="hljs-built_in">compile</span>(
   pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune-no-cudagraphs&quot;</span>,
)

<span class="hljs-comment"># Enable memory savings</span>
<span class="hljs-comment"># pipe.enable_model_cpu_offload(gpu_id=dist.get_rank())</span>
<span class="hljs-comment"># pipe.enable_sequential_cpu_offload(gpu_id=dist.get_rank())</span>

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):
    begin = time.time()
    image = pipe(
        <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
        num_inference_steps=<span class="hljs-number">28</span>,
        output_type=<span class="hljs-string">&quot;pil&quot;</span> <span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;pt&quot;</span>,
    ).images[<span class="hljs-number">0</span>]
    end = time.time()
    <span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span>:
        <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Warm up time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving image to flux.png&quot;</span>)
    image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)

dist.destroy_process_group()`,wrap:!1}}),M=new $({props:{code:"JTIzJTIwVXNlJTIwLS1ucHJvY19wZXJfbm9kZSUyMHRvJTIwc3BlY2lmeSUyMHRoZSUyMG51bWJlciUyMG9mJTIwR1BVcyUwQXRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDIlMjBydW5fZmx1eC5weQ==",highlighted:`<span class="hljs-comment"># Use --nproc_per_node to specify the number of GPUs</span>
torchrun --nproc_per_node=2 run_flux.py`,wrap:!1}}),{c(){t=u("p"),t.textContent=d,p=c(),B(r.$$.fragment),l=c(),n=u("p"),n.innerHTML=J,w=c(),B(M.$$.fragment),b=c(),U=u("p"),U.textContent=h},l(o){t=y(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-l7izr3"&&(t.textContent=d),p=m(o),I(r.$$.fragment,o),l=m(o),n=y(o,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1gsxpvn"&&(n.innerHTML=J),w=m(o),I(M.$$.fragment,o),b=m(o),U=y(o,"P",{"data-svelte-h":!0}),f(U)!=="svelte-11xwpjh"&&(U.textContent=h)},m(o,T){a(o,t,T),a(o,p,T),_(r,o,T),a(o,l,T),a(o,n,T),a(o,w,T),_(M,o,T),a(o,b,T),a(o,U,T),Z=!0},p:Y,i(o){Z||(C(r.$$.fragment,o),C(M.$$.fragment,o),Z=!0)},o(o){G(r.$$.fragment,o),G(M.$$.fragment,o),Z=!1},d(o){o&&(s(t),s(p),s(l),s(n),s(w),s(b),s(U)),W(r,o),W(M,o)}}}function Zl(g){let t,d="The code sample below combines First Block Cache and Context Parallelism for the fastest inference speed.",p,r,l,n,J='Save to <code>run_hunyuan_video.py</code> and launch it with <a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>.',w,M,b,U,h="Inference speed is reduced to 649.23 seconds compared to the baseline, or 5.66x faster, with 8 NVIDIA L20 GPUs.",Z;return r=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline, HunyuanVideoTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

dist.init_process_group()

torch.cuda.set_device(dist.get_rank())

model_id = <span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>
transformer = HunyuanVideoTransformer3DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    torch_dtype=torch.bfloat16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
)
pipe = HunyuanVideoPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=torch.float16,
    revision=<span class="hljs-string">&quot;refs/pr/18&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">from</span> para_attn.context_parallel <span class="hljs-keyword">import</span> init_context_parallel_mesh
<span class="hljs-keyword">from</span> para_attn.context_parallel.diffusers_adapters <span class="hljs-keyword">import</span> parallelize_pipe
<span class="hljs-keyword">from</span> para_attn.parallel_vae.diffusers_adapters <span class="hljs-keyword">import</span> parallelize_vae

mesh = init_context_parallel_mesh(
    pipe.device.<span class="hljs-built_in">type</span>,
)
parallelize_pipe(
    pipe,
    mesh=mesh,
)
parallelize_vae(pipe.vae, mesh=mesh._flatten())

<span class="hljs-keyword">from</span> para_attn.first_block_cache.diffusers_adapters <span class="hljs-keyword">import</span> apply_cache_on_pipe

apply_cache_on_pipe(pipe)

<span class="hljs-comment"># from torchao.quantization import quantize_, float8_dynamic_activation_float8_weight, float8_weight_only</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># torch._inductor.config.reorder_for_compute_comm_overlap = True</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># quantize_(pipe.text_encoder, float8_weight_only())</span>
<span class="hljs-comment"># quantize_(pipe.transformer, float8_dynamic_activation_float8_weight())</span>
<span class="hljs-comment"># pipe.transformer = torch.compile(</span>
<span class="hljs-comment">#    pipe.transformer, mode=&quot;max-autotune-no-cudagraphs&quot;,</span>
<span class="hljs-comment"># )</span>

<span class="hljs-comment"># Enable memory savings</span>
pipe.vae.enable_tiling()
<span class="hljs-comment"># pipe.enable_model_cpu_offload(gpu_id=dist.get_rank())</span>
<span class="hljs-comment"># pipe.enable_sequential_cpu_offload(gpu_id=dist.get_rank())</span>

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):
    begin = time.time()
    output = pipe(
        prompt=<span class="hljs-string">&quot;A cat walks on the grass, realistic&quot;</span>,
        height=<span class="hljs-number">720</span>,
        width=<span class="hljs-number">1280</span>,
        num_frames=<span class="hljs-number">129</span>,
        num_inference_steps=<span class="hljs-number">1</span> <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">30</span>,
        output_type=<span class="hljs-string">&quot;pil&quot;</span> <span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;pt&quot;</span>,
    ).frames[<span class="hljs-number">0</span>]
    end = time.time()
    <span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span>:
        <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Warm up time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{end - begin:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)

<span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving video to hunyuan_video.mp4&quot;</span>)
    export_to_video(output, <span class="hljs-string">&quot;hunyuan_video.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)

dist.destroy_process_group()`,wrap:!1}}),M=new $({props:{code:"JTIzJTIwVXNlJTIwLS1ucHJvY19wZXJfbm9kZSUyMHRvJTIwc3BlY2lmeSUyMHRoZSUyMG51bWJlciUyMG9mJTIwR1BVcyUwQXRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDglMjBydW5faHVueXVhbl92aWRlby5weQ==",highlighted:`<span class="hljs-comment"># Use --nproc_per_node to specify the number of GPUs</span>
torchrun --nproc_per_node=8 run_hunyuan_video.py`,wrap:!1}}),{c(){t=u("p"),t.textContent=d,p=c(),B(r.$$.fragment),l=c(),n=u("p"),n.innerHTML=J,w=c(),B(M.$$.fragment),b=c(),U=u("p"),U.textContent=h},l(o){t=y(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-muxsqm"&&(t.textContent=d),p=m(o),I(r.$$.fragment,o),l=m(o),n=y(o,"P",{"data-svelte-h":!0}),f(n)!=="svelte-7sbjia"&&(n.innerHTML=J),w=m(o),I(M.$$.fragment,o),b=m(o),U=y(o,"P",{"data-svelte-h":!0}),f(U)!=="svelte-d28thb"&&(U.textContent=h)},m(o,T){a(o,t,T),a(o,p,T),_(r,o,T),a(o,l,T),a(o,n,T),a(o,w,T),_(M,o,T),a(o,b,T),a(o,U,T),Z=!0},p:Y,i(o){Z||(C(r.$$.fragment,o),C(M.$$.fragment,o),Z=!0)},o(o){G(r.$$.fragment,o),G(M.$$.fragment,o),Z=!1},d(o){o&&(s(t),s(p),s(l),s(n),s(w),s(b),s(U)),W(r,o),W(M,o)}}}function Bl(g){let t,d,p,r;return t=new R({props:{id:"context-parallelism",option:"FLUX-1.dev",$$slots:{default:[Ul]},$$scope:{ctx:g}}}),p=new R({props:{id:"context-parallelism",option:"HunyuanVideo",$$slots:{default:[Zl]},$$scope:{ctx:g}}}),{c(){B(t.$$.fragment),d=c(),B(p.$$.fragment)},l(l){I(t.$$.fragment,l),d=m(l),I(p.$$.fragment,l)},m(l,n){_(t,l,n),a(l,d,n),_(p,l,n),r=!0},p(l,n){const J={};n&2&&(J.$$scope={dirty:n,ctx:l}),t.$set(J);const w={};n&2&&(w.$$scope={dirty:n,ctx:l}),p.$set(w)},i(l){r||(C(t.$$.fragment,l),C(p.$$.fragment,l),r=!0)},o(l){G(t.$$.fragment,l),G(p.$$.fragment,l),r=!1},d(l){l&&s(d),W(t,l),W(p,l)}}}function Il(g){let t,d="<thead><tr><th>GPU Type</th> <th>Number of GPUs</th> <th>Optimizations</th> <th>Wall Time (s)</th> <th>Speedup</th></tr></thead> <tbody><tr><td>NVIDIA L20</td> <td>1</td> <td>Baseline</td> <td>26.36</td> <td>1.00x</td></tr> <tr><td>NVIDIA L20</td> <td>1</td> <td>FBCache (rdt=0.08)</td> <td>17.01</td> <td>1.55x</td></tr> <tr><td>NVIDIA L20</td> <td>1</td> <td>FP8 DQ</td> <td>13.40</td> <td>1.96x</td></tr> <tr><td>NVIDIA L20</td> <td>1</td> <td>FBCache (rdt=0.12) + FP8 DQ</td> <td>7.56</td> <td>3.48x</td></tr> <tr><td>NVIDIA L20</td> <td>2</td> <td>FBCache (rdt=0.12) + FP8 DQ + CP</td> <td>4.92</td> <td>5.35x</td></tr> <tr><td>NVIDIA L20</td> <td>4</td> <td>FBCache (rdt=0.12) + FP8 DQ + CP</td> <td>3.90</td> <td>6.75x</td></tr></tbody>";return{c(){t=u("table"),t.innerHTML=d},l(p){t=y(p,"TABLE",{"data-svelte-h":!0}),f(t)!=="svelte-1eiq4i6"&&(t.innerHTML=d)},m(p,r){a(p,t,r)},p:Y,d(p){p&&s(t)}}}function _l(g){let t,d="<thead><tr><th>GPU Type</th> <th>Number of GPUs</th> <th>Optimizations</th> <th>Wall Time (s)</th> <th>Speedup</th></tr></thead> <tbody><tr><td>NVIDIA L20</td> <td>1</td> <td>Baseline</td> <td>3675.71</td> <td>1.00x</td></tr> <tr><td>NVIDIA L20</td> <td>1</td> <td>FBCache</td> <td>2271.06</td> <td>1.62x</td></tr> <tr><td>NVIDIA L20</td> <td>2</td> <td>FBCache + CP</td> <td>1132.90</td> <td>3.24x</td></tr> <tr><td>NVIDIA L20</td> <td>4</td> <td>FBCache + CP</td> <td>718.15</td> <td>5.12x</td></tr> <tr><td>NVIDIA L20</td> <td>8</td> <td>FBCache + CP</td> <td>649.23</td> <td>5.66x</td></tr></tbody>";return{c(){t=u("table"),t.innerHTML=d},l(p){t=y(p,"TABLE",{"data-svelte-h":!0}),f(t)!=="svelte-1rcid57"&&(t.innerHTML=d)},m(p,r){a(p,t,r)},p:Y,d(p){p&&s(t)}}}function Cl(g){let t,d,p,r;return t=new R({props:{id:"conclusion",option:"FLUX-1.dev",$$slots:{default:[Il]},$$scope:{ctx:g}}}),p=new R({props:{id:"conclusion",option:"HunyuanVideo",$$slots:{default:[_l]},$$scope:{ctx:g}}}),{c(){B(t.$$.fragment),d=c(),B(p.$$.fragment)},l(l){I(t.$$.fragment,l),d=m(l),I(p.$$.fragment,l)},m(l,n){_(t,l,n),a(l,d,n),_(p,l,n),r=!0},p(l,n){const J={};n&2&&(J.$$scope={dirty:n,ctx:l}),t.$set(J);const w={};n&2&&(w.$$scope={dirty:n,ctx:l}),p.$set(w)},i(l){r||(C(t.$$.fragment,l),C(p.$$.fragment,l),r=!0)},o(l){G(t.$$.fragment,l),G(p.$$.fragment,l),r=!1},d(l){l&&s(d),W(t,l),W(p,l)}}}function Gl(g){let t,d,p,r,l,n,J,w='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/flux-performance.png"/>',M,b,U='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/hunyuan-video-performance.png"/>',h,Z,o='Large image and video generation models, such as <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> and <a href="https://huggingface.co/tencent/HunyuanVideo" rel="nofollow">HunyuanVideo</a>, can be an inference challenge for real-time applications and deployment because of their size.',T,X,N='<a href="https://github.com/chengzeyi/ParaAttention" rel="nofollow">ParaAttention</a> is a library that implements <strong>context parallelism</strong> and <strong>first block cache</strong>, and can be combined with other techniques (torch.compile, fp8 dynamic quantization), to accelerate inference.',V,k,z=`This guide will show you how to apply ParaAttention to FLUX.1-dev and HunyuanVideo on NVIDIA L20 GPUs.
No optimizations are applied for our baseline benchmark, except for HunyuanVideo to avoid out-of-memory errors.`,j,v,Ee="Our baseline benchmark shows that FLUX.1-dev is able to generate a 1024x1024 resolution image in 28 steps in 26.36 seconds, and HunyuanVideo is able to generate 129 frames at 720p resolution in 30 steps in 3675.71 seconds.",ye,H,Re="<p>For even faster inference with context parallelism, try using NVIDIA A100 or H100 GPUs (if available) with NVLink support, especially when there is a large number of GPUs.</p>",he,q,fe,L,Ye="Caching the output of the transformers blocks in the model and reusing them in the next inference steps reduces the computation cost and makes inference faster.",Je,K,Ne="However, it is hard to decide when to reuse the cache to ensure quality generated images or videos. ParaAttention directly uses the <strong>residual difference of the first transformer block output</strong> to approximate the difference among model outputs. When the difference is small enough, the residual difference of previous inference steps is reused. In other words, the denoising step is skipped.",we,D,ze="This achieves a 2x speedup on FLUX.1-dev and HunyuanVideo inference with very good quality.",je,P,qe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/para-attn/ada-cache.png" alt="Cache in Diffusion Transformer"/> <figcaption>How AdaCache works, First Block Cache is a variant of it</figcaption>',Te,Q,be,O,Ue,ee,Le='fp8 with dynamic quantization further speeds up inference and reduces memory usage. Both the activations and weights must be quantized in order to use the 8-bit <a href="https://www.nvidia.com/en-us/data-center/tensor-cores/" rel="nofollow">NVIDIA Tensor Cores</a>.',Ze,le,Ke="Use <code>float8_weight_only</code> and <code>float8_dynamic_activation_float8_weight</code> to quantize the text encoder and transformer model.",Be,te,De="The default quantization method is per tensor quantization, but if your GPU supports row-wise quantization, you can also try it for better accuracy.",Ie,se,Pe='Install <a href="https://github.com/pytorch/ao/tree/main" rel="nofollow">torchao</a> with the command below.',_e,ae,Ce,ne,Oe='<a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a> with <code>mode=&quot;max-autotune-no-cudagraphs&quot;</code> or <code>mode=&quot;max-autotune&quot;</code> selects the best kernel for performance. Compilation can take a long time if it’s the first time the model is called, but it is worth it once the model has been compiled.',Ge,pe,el="This example only quantizes the transformer model, but you can also quantize the text encoder to reduce memory usage even more.",We,F,ll="<p>Dynamic quantization can significantly change the distribution of the model output, so you need to change the <code>residual_diff_threshold</code> to a larger value for it to take effect.</p>",ge,A,ve,ie,Ve,oe,tl="Context Parallelism parallelizes inference and scales with multiple GPUs. The ParaAttention compositional design allows you to combine Context Parallelism with First Block Cache and dynamic quantization.",Xe,x,sl='<p>Refer to the <a href="https://github.com/chengzeyi/ParaAttention/tree/main" rel="nofollow">ParaAttention</a> repository for detailed instructions and examples of how to scale inference with multiple GPUs.</p>',ke,re,al='If the inference process needs to be persistent and serviceable, it is suggested to use <a href="https://pytorch.org/docs/stable/multiprocessing.html" rel="nofollow">torch.multiprocessing</a> to write your own inference processor. This can eliminate the overhead of launching the process and loading and recompiling the model.',$e,S,He,ce,Qe,E,Fe,me,Ae,de,xe;return l=new ue({props:{title:"ParaAttention",local:"paraattention",headingTag:"h1"}}),q=new ue({props:{title:"First Block Cache",local:"first-block-cache",headingTag:"h2"}}),Q=new Se({props:{id:"first-block-cache",options:["FLUX-1.dev","HunyuanVideo"],$$slots:{default:[wl]},$$scope:{ctx:g}}}),O=new ue({props:{title:"fp8 quantization",local:"fp8-quantization",headingTag:"h2"}}),ae=new $({props:{code:"cGlwMyUyMGluc3RhbGwlMjAtVSUyMHRvcmNoJTIwdG9yY2hhbw==",highlighted:"pip3 install -U torch torchao",wrap:!1}}),A=new Se({props:{id:"fp8-quantization",options:["FLUX-1.dev","HunyuanVideo"],$$slots:{default:[bl]},$$scope:{ctx:g}}}),ie=new ue({props:{title:"Context Parallelism",local:"context-parallelism",headingTag:"h2"}}),S=new Se({props:{id:"context-parallelism",options:["FLUX-1.dev","HunyuanVideo"],$$slots:{default:[Bl]},$$scope:{ctx:g}}}),ce=new ue({props:{title:"Benchmarks",local:"benchmarks",headingTag:"h2"}}),E=new Se({props:{id:"conclusion",options:["FLUX-1.dev","HunyuanVideo"],$$slots:{default:[Cl]},$$scope:{ctx:g}}}),me=new hl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/para_attn.md"}}),{c(){t=u("meta"),d=c(),p=u("p"),r=c(),B(l.$$.fragment),n=c(),J=u("div"),J.innerHTML=w,M=c(),b=u("div"),b.innerHTML=U,h=c(),Z=u("p"),Z.innerHTML=o,T=c(),X=u("p"),X.innerHTML=N,V=c(),k=u("p"),k.textContent=z,j=c(),v=u("p"),v.textContent=Ee,ye=c(),H=u("blockquote"),H.innerHTML=Re,he=c(),B(q.$$.fragment),fe=c(),L=u("p"),L.textContent=Ye,Je=c(),K=u("p"),K.innerHTML=Ne,we=c(),D=u("p"),D.textContent=ze,je=c(),P=u("figure"),P.innerHTML=qe,Te=c(),B(Q.$$.fragment),be=c(),B(O.$$.fragment),Ue=c(),ee=u("p"),ee.innerHTML=Le,Ze=c(),le=u("p"),le.innerHTML=Ke,Be=c(),te=u("p"),te.textContent=De,Ie=c(),se=u("p"),se.innerHTML=Pe,_e=c(),B(ae.$$.fragment),Ce=c(),ne=u("p"),ne.innerHTML=Oe,Ge=c(),pe=u("p"),pe.textContent=el,We=c(),F=u("blockquote"),F.innerHTML=ll,ge=c(),B(A.$$.fragment),ve=c(),B(ie.$$.fragment),Ve=c(),oe=u("p"),oe.textContent=tl,Xe=c(),x=u("blockquote"),x.innerHTML=sl,ke=c(),re=u("p"),re.innerHTML=al,$e=c(),B(S.$$.fragment),He=c(),B(ce.$$.fragment),Qe=c(),B(E.$$.fragment),Fe=c(),B(me.$$.fragment),Ae=c(),de=u("p"),this.h()},l(e){const i=ul("svelte-u9bgzb",document.head);t=y(i,"META",{name:!0,content:!0}),i.forEach(s),d=m(e),p=y(e,"P",{}),rl(p).forEach(s),r=m(e),I(l.$$.fragment,e),n=m(e),J=y(e,"DIV",{class:!0,"data-svelte-h":!0}),f(J)!=="svelte-1p4slnk"&&(J.innerHTML=w),M=m(e),b=y(e,"DIV",{class:!0,"data-svelte-h":!0}),f(b)!=="svelte-1kqq4mt"&&(b.innerHTML=U),h=m(e),Z=y(e,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-uizfax"&&(Z.innerHTML=o),T=m(e),X=y(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1ufw59x"&&(X.innerHTML=N),V=m(e),k=y(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-y6ktum"&&(k.textContent=z),j=m(e),v=y(e,"P",{"data-svelte-h":!0}),f(v)!=="svelte-12v81em"&&(v.textContent=Ee),ye=m(e),H=y(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(H)!=="svelte-au4ots"&&(H.innerHTML=Re),he=m(e),I(q.$$.fragment,e),fe=m(e),L=y(e,"P",{"data-svelte-h":!0}),f(L)!=="svelte-zipcqj"&&(L.textContent=Ye),Je=m(e),K=y(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-11q05n5"&&(K.innerHTML=Ne),we=m(e),D=y(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-1ecvggt"&&(D.textContent=ze),je=m(e),P=y(e,"FIGURE",{"data-svelte-h":!0}),f(P)!=="svelte-1czvnic"&&(P.innerHTML=qe),Te=m(e),I(Q.$$.fragment,e),be=m(e),I(O.$$.fragment,e),Ue=m(e),ee=y(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-yi5eo1"&&(ee.innerHTML=Le),Ze=m(e),le=y(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-10ndi9a"&&(le.innerHTML=Ke),Be=m(e),te=y(e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-1dzea4g"&&(te.textContent=De),Ie=m(e),se=y(e,"P",{"data-svelte-h":!0}),f(se)!=="svelte-edf8tk"&&(se.innerHTML=Pe),_e=m(e),I(ae.$$.fragment,e),Ce=m(e),ne=y(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-xjm2cj"&&(ne.innerHTML=Oe),Ge=m(e),pe=y(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-1akf52n"&&(pe.textContent=el),We=m(e),F=y(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(F)!=="svelte-6flf2e"&&(F.innerHTML=ll),ge=m(e),I(A.$$.fragment,e),ve=m(e),I(ie.$$.fragment,e),Ve=m(e),oe=y(e,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-vw4vn"&&(oe.textContent=tl),Xe=m(e),x=y(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(x)!=="svelte-1jqb1qc"&&(x.innerHTML=sl),ke=m(e),re=y(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-1vj39hr"&&(re.innerHTML=al),$e=m(e),I(S.$$.fragment,e),He=m(e),I(ce.$$.fragment,e),Qe=m(e),I(E.$$.fragment,e),Fe=m(e),I(me.$$.fragment,e),Ae=m(e),de=y(e,"P",{}),rl(de).forEach(s),this.h()},h(){Me(t,"name","hf:doc:metadata"),Me(t,"content",Wl),Me(J,"class","flex justify-center"),Me(b,"class","flex justify-center"),Me(H,"class","tip"),Me(F,"class","tip"),Me(x,"class","tip")},m(e,i){yl(document.head,t),a(e,d,i),a(e,p,i),a(e,r,i),_(l,e,i),a(e,n,i),a(e,J,i),a(e,M,i),a(e,b,i),a(e,h,i),a(e,Z,i),a(e,T,i),a(e,X,i),a(e,V,i),a(e,k,i),a(e,j,i),a(e,v,i),a(e,ye,i),a(e,H,i),a(e,he,i),_(q,e,i),a(e,fe,i),a(e,L,i),a(e,Je,i),a(e,K,i),a(e,we,i),a(e,D,i),a(e,je,i),a(e,P,i),a(e,Te,i),_(Q,e,i),a(e,be,i),_(O,e,i),a(e,Ue,i),a(e,ee,i),a(e,Ze,i),a(e,le,i),a(e,Be,i),a(e,te,i),a(e,Ie,i),a(e,se,i),a(e,_e,i),_(ae,e,i),a(e,Ce,i),a(e,ne,i),a(e,Ge,i),a(e,pe,i),a(e,We,i),a(e,F,i),a(e,ge,i),_(A,e,i),a(e,ve,i),_(ie,e,i),a(e,Ve,i),a(e,oe,i),a(e,Xe,i),a(e,x,i),a(e,ke,i),a(e,re,i),a(e,$e,i),_(S,e,i),a(e,He,i),_(ce,e,i),a(e,Qe,i),_(E,e,i),a(e,Fe,i),_(me,e,i),a(e,Ae,i),a(e,de,i),xe=!0},p(e,[i]){const nl={};i&2&&(nl.$$scope={dirty:i,ctx:e}),Q.$set(nl);const pl={};i&2&&(pl.$$scope={dirty:i,ctx:e}),A.$set(pl);const il={};i&2&&(il.$$scope={dirty:i,ctx:e}),S.$set(il);const ol={};i&2&&(ol.$$scope={dirty:i,ctx:e}),E.$set(ol)},i(e){xe||(C(l.$$.fragment,e),C(q.$$.fragment,e),C(Q.$$.fragment,e),C(O.$$.fragment,e),C(ae.$$.fragment,e),C(A.$$.fragment,e),C(ie.$$.fragment,e),C(S.$$.fragment,e),C(ce.$$.fragment,e),C(E.$$.fragment,e),C(me.$$.fragment,e),xe=!0)},o(e){G(l.$$.fragment,e),G(q.$$.fragment,e),G(Q.$$.fragment,e),G(O.$$.fragment,e),G(ae.$$.fragment,e),G(A.$$.fragment,e),G(ie.$$.fragment,e),G(S.$$.fragment,e),G(ce.$$.fragment,e),G(E.$$.fragment,e),G(me.$$.fragment,e),xe=!1},d(e){e&&(s(d),s(p),s(r),s(n),s(J),s(M),s(b),s(h),s(Z),s(T),s(X),s(V),s(k),s(j),s(v),s(ye),s(H),s(he),s(fe),s(L),s(Je),s(K),s(we),s(D),s(je),s(P),s(Te),s(be),s(Ue),s(ee),s(Ze),s(le),s(Be),s(te),s(Ie),s(se),s(_e),s(Ce),s(ne),s(Ge),s(pe),s(We),s(F),s(ge),s(ve),s(Ve),s(oe),s(Xe),s(x),s(ke),s(re),s($e),s(He),s(Qe),s(Fe),s(Ae),s(de)),s(t),W(l,e),W(q,e),W(Q,e),W(O,e),W(ae,e),W(A,e),W(ie,e),W(S,e),W(ce,e),W(E,e),W(me,e)}}}const Wl='{"title":"ParaAttention","local":"paraattention","sections":[{"title":"First Block Cache","local":"first-block-cache","sections":[],"depth":2},{"title":"fp8 quantization","local":"fp8-quantization","sections":[],"depth":2},{"title":"Context Parallelism","local":"context-parallelism","sections":[],"depth":2},{"title":"Benchmarks","local":"benchmarks","sections":[],"depth":2}],"depth":1}';function gl(g){return ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hl extends Ml{constructor(t){super(),dl(this,t,gl,Gl,cl,{})}}export{Hl as component};
