import{s as $t,n as jt,o as Bt}from"../chunks/scheduler.8c3d61f6.js";import{S as At,i as It,g as i,s as o,r as m,A as St,h as s,f as n,c as l,j as Ut,u as f,x as d,k as C,y as Zt,a,v as u,d as b,t as w,w as M}from"../chunks/index.da70eac4.js";import{C as ht}from"../chunks/CodeBlock.a9c4becf.js";import{H as ct,E as Pt}from"../chunks/getInferenceSnippets.cb466318.js";function Ft(pt){let r,Q,G,H,y,q,c,mt="<p>The attention dispatcher is an experimental feature. Please open an issue if you have any feedback or encounter any problems.</p>",L,g,ft="Diffusers provides several optimized attention algorithms that are more memory and computationally efficient through it’s <em>attention dispatcher</em>. The dispatcher acts as a router for managing and switching between different attention implementations and provides a unified interface for interacting with them.",Y,_,ut='Refer to the table below for an overview of the available attention families and to the <a href="#available-backends">Available backends</a> section for a more complete list.',X,T,bt='<thead><tr><th>attention family</th> <th>main feature</th></tr></thead> <tbody><tr><td>FlashAttention</td> <td>minimizes memory reads/writes through tiling and recomputation</td></tr> <tr><td>SageAttention</td> <td>quantizes attention to int8</td></tr> <tr><td>PyTorch native</td> <td>built-in PyTorch implementation using <a href="./fp16#scaled-dot-product-attention">scaled_dot_product_attention</a></td></tr> <tr><td>xFormers</td> <td>memory-efficient attention with support for various attention kernels</td></tr></tbody>',E,k,wt="This guide will show you how to set and use the different attention backends.",D,v,V,J,Mt='The <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.set_attention_backend">set_attention_backend()</a> method iterates through all the modules in the model and sets the appropriate attention backend to use. The attention backend setting persists until <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.reset_attention_backend">reset_attention_backend()</a> is called.',N,U,yt='The example below demonstrates how to enable the <code>_flash_3_hub</code> implementation for FlashAttention-3 from the <a href="https://github.com/huggingface/kernels" rel="nofollow">kernel</a> library, which allows you to instantly use optimized compute kernels from the Hub without requiring any setup.',z,h,gt="<p>FlashAttention-3 is not supported for non-Hopper architectures, in which case, use FlashAttention with <code>set_attention_backend(&quot;flash&quot;)</code>.</p>",R,$,K,j,_t='To restore the default attention backend, call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.reset_attention_backend">reset_attention_backend()</a>.',O,B,tt,A,et,I,Tt='The <a href="https://github.com/huggingface/diffusers/blob/5e181eddfe7e44c1444a2511b0d8e21d177850a0/src/diffusers/models/attention_dispatch.py#L225" rel="nofollow">attention_backend</a> context manager temporarily sets an attention backend for a model within the context. Outside the context, the default attention (PyTorch’s native scaled dot product attention) is used. This is useful if you want to use different backends for different parts of a pipeline or if you want to test the different backends.',nt,S,at,p,kt="<p>Most attention backends support <code>torch.compile</code> without graph breaks and can be used to further speed up inference.</p>",ot,Z,lt,P,vt="Refer to the table below for a complete list of available attention backends and their variants.",it,F,Jt='<summary>Expand</summary> <table><thead><tr><th>Backend Name</th> <th>Family</th> <th>Description</th></tr></thead> <tbody><tr><td><code>native</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Default backend using PyTorch’s scaled_dot_product_attention</td></tr> <tr><td><code>flex</code></td> <td><a href="https://docs.pytorch.org/docs/stable/nn.attention.flex_attention.html#module-torch.nn.attention.flex_attention" rel="nofollow">FlexAttention</a></td> <td>PyTorch FlexAttention implementation</td></tr> <tr><td><code>_native_cudnn</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>CuDNN-optimized attention</td></tr> <tr><td><code>_native_efficient</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Memory-efficient attention</td></tr> <tr><td><code>_native_flash</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>PyTorch’s FlashAttention</td></tr> <tr><td><code>_native_math</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Math-based attention (fallback)</td></tr> <tr><td><code>_native_npu</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>NPU-optimized attention</td></tr> <tr><td><code>_native_xla</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>XLA-optimized attention</td></tr> <tr><td><code>flash</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-2</td></tr> <tr><td><code>flash_varlen</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>Variable length FlashAttention</td></tr> <tr><td><code>_flash_3</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-3</td></tr> <tr><td><code>_flash_varlen_3</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>Variable length FlashAttention-3</td></tr> <tr><td><code>_flash_3_hub</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-3 from kernels</td></tr> <tr><td><code>sage</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>Quantized attention (INT8 QK)</td></tr> <tr><td><code>sage_varlen</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>Variable length SageAttention</td></tr> <tr><td><code>_sage_qk_int8_pv_fp8_cuda</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP8 PV (CUDA)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp8_cuda_sm90</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP8 PV (SM90)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp16_cuda</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP16 PV (CUDA)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp16_triton</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP16 PV (Triton)</td></tr> <tr><td><code>xformers</code></td> <td><a href="https://github.com/facebookresearch/xformers" rel="nofollow">xFormers</a></td> <td>Memory-efficient attention</td></tr></tbody></table>',st,x,dt,W,rt;return y=new ct({props:{title:"Attention backends",local:"attention-backends",headingTag:"h1"}}),v=new ct({props:{title:"set_attention_backend",local:"setattentionbackend",headingTag:"h2"}}),$=new ht({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwaXBlbGluZS50cmFuc2Zvcm1lci5zZXRfYXR0ZW50aW9uX2JhY2tlbmQoJTIyX2ZsYXNoXzNfaHViJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUwQWNpbmVtYXRpYyUyMGZpbG0lMjBzdGlsbCUyMG9mJTIwYSUyMGNhdCUyMHNpcHBpbmclMjBhJTIwbWFyZ2FyaXRhJTIwaW4lMjBhJTIwcG9vbCUyMGluJTIwUGFsbSUyMFNwcmluZ3MlMkMlMjBDYWxpZm9ybmlhJTBBaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTBBJTIyJTIyJTIyJTBBcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.transformer.set_attention_backend(<span class="hljs-string">&quot;_flash_3_hub&quot;</span>)

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),B=new ht({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIucmVzZXRfYXR0ZW50aW9uX2JhY2tlbmQoKQ==",highlighted:"pipeline.transformer.reset_attention_backend()",wrap:!1}}),A=new ct({props:{title:"attention_backend context manager",local:"attentionbackend-context-manager",headingTag:"h2"}}),S=new ht({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBzaXBwaW5nJTIwYSUyMG1hcmdhcml0YSUyMGluJTIwYSUyMHBvb2wlMjBpbiUyMFBhbG0lMjBTcHJpbmdzJTJDJTIwQ2FsaWZvcm5pYSUwQWhpZ2hseSUyMGRldGFpbGVkJTJDJTIwaGlnaCUyMGJ1ZGdldCUyMGhvbGx5d29vZCUyMG1vdmllJTJDJTIwY2luZW1hc2NvcGUlMkMlMjBtb29keSUyQyUyMGVwaWMlMkMlMjBnb3JnZW91cyUyQyUyMGZpbG0lMjBncmFpbiUwQSUyMiUyMiUyMiUwQSUwQXdpdGglMjBhdHRlbnRpb25fYmFja2VuZCglMjJfZmxhc2hfM19odWIlMjIpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>

<span class="hljs-keyword">with</span> attention_backend(<span class="hljs-string">&quot;_flash_3_hub&quot;</span>):
    image = pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Z=new ct({props:{title:"Available backends",local:"available-backends",headingTag:"h2"}}),x=new Pt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/attention_backends.md"}}),{c(){r=i("meta"),Q=o(),G=i("p"),H=o(),m(y.$$.fragment),q=o(),c=i("blockquote"),c.innerHTML=mt,L=o(),g=i("p"),g.innerHTML=ft,Y=o(),_=i("p"),_.innerHTML=ut,X=o(),T=i("table"),T.innerHTML=bt,E=o(),k=i("p"),k.textContent=wt,D=o(),m(v.$$.fragment),V=o(),J=i("p"),J.innerHTML=Mt,N=o(),U=i("p"),U.innerHTML=yt,z=o(),h=i("blockquote"),h.innerHTML=gt,R=o(),m($.$$.fragment),K=o(),j=i("p"),j.innerHTML=_t,O=o(),m(B.$$.fragment),tt=o(),m(A.$$.fragment),et=o(),I=i("p"),I.innerHTML=Tt,nt=o(),m(S.$$.fragment),at=o(),p=i("blockquote"),p.innerHTML=kt,ot=o(),m(Z.$$.fragment),lt=o(),P=i("p"),P.textContent=vt,it=o(),F=i("details"),F.innerHTML=Jt,st=o(),m(x.$$.fragment),dt=o(),W=i("p"),this.h()},l(t){const e=St("svelte-u9bgzb",document.head);r=s(e,"META",{name:!0,content:!0}),e.forEach(n),Q=l(t),G=s(t,"P",{}),Ut(G).forEach(n),H=l(t),f(y.$$.fragment,t),q=l(t),c=s(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(c)!=="svelte-7ay7vy"&&(c.innerHTML=mt),L=l(t),g=s(t,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1p5wykf"&&(g.innerHTML=ft),Y=l(t),_=s(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-q2vvjg"&&(_.innerHTML=ut),X=l(t),T=s(t,"TABLE",{"data-svelte-h":!0}),d(T)!=="svelte-1eo6jrm"&&(T.innerHTML=bt),E=l(t),k=s(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1o85kpy"&&(k.textContent=wt),D=l(t),f(v.$$.fragment,t),V=l(t),J=s(t,"P",{"data-svelte-h":!0}),d(J)!=="svelte-k822hv"&&(J.innerHTML=Mt),N=l(t),U=s(t,"P",{"data-svelte-h":!0}),d(U)!=="svelte-142if5b"&&(U.innerHTML=yt),z=l(t),h=s(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(h)!=="svelte-j6ruup"&&(h.innerHTML=gt),R=l(t),f($.$$.fragment,t),K=l(t),j=s(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-41vsbn"&&(j.innerHTML=_t),O=l(t),f(B.$$.fragment,t),tt=l(t),f(A.$$.fragment,t),et=l(t),I=s(t,"P",{"data-svelte-h":!0}),d(I)!=="svelte-g6fiju"&&(I.innerHTML=Tt),nt=l(t),f(S.$$.fragment,t),at=l(t),p=s(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(p)!=="svelte-1mkj6ep"&&(p.innerHTML=kt),ot=l(t),f(Z.$$.fragment,t),lt=l(t),P=s(t,"P",{"data-svelte-h":!0}),d(P)!=="svelte-frsh1o"&&(P.textContent=vt),it=l(t),F=s(t,"DETAILS",{"data-svelte-h":!0}),d(F)!=="svelte-1a11wal"&&(F.innerHTML=Jt),st=l(t),f(x.$$.fragment,t),dt=l(t),W=s(t,"P",{}),Ut(W).forEach(n),this.h()},h(){C(r,"name","hf:doc:metadata"),C(r,"content",xt),C(c,"class","note"),C(h,"class","note"),C(p,"class","tip")},m(t,e){Zt(document.head,r),a(t,Q,e),a(t,G,e),a(t,H,e),u(y,t,e),a(t,q,e),a(t,c,e),a(t,L,e),a(t,g,e),a(t,Y,e),a(t,_,e),a(t,X,e),a(t,T,e),a(t,E,e),a(t,k,e),a(t,D,e),u(v,t,e),a(t,V,e),a(t,J,e),a(t,N,e),a(t,U,e),a(t,z,e),a(t,h,e),a(t,R,e),u($,t,e),a(t,K,e),a(t,j,e),a(t,O,e),u(B,t,e),a(t,tt,e),u(A,t,e),a(t,et,e),a(t,I,e),a(t,nt,e),u(S,t,e),a(t,at,e),a(t,p,e),a(t,ot,e),u(Z,t,e),a(t,lt,e),a(t,P,e),a(t,it,e),a(t,F,e),a(t,st,e),u(x,t,e),a(t,dt,e),a(t,W,e),rt=!0},p:jt,i(t){rt||(b(y.$$.fragment,t),b(v.$$.fragment,t),b($.$$.fragment,t),b(B.$$.fragment,t),b(A.$$.fragment,t),b(S.$$.fragment,t),b(Z.$$.fragment,t),b(x.$$.fragment,t),rt=!0)},o(t){w(y.$$.fragment,t),w(v.$$.fragment,t),w($.$$.fragment,t),w(B.$$.fragment,t),w(A.$$.fragment,t),w(S.$$.fragment,t),w(Z.$$.fragment,t),w(x.$$.fragment,t),rt=!1},d(t){t&&(n(Q),n(G),n(H),n(q),n(c),n(L),n(g),n(Y),n(_),n(X),n(T),n(E),n(k),n(D),n(V),n(J),n(N),n(U),n(z),n(h),n(R),n(K),n(j),n(O),n(tt),n(et),n(I),n(nt),n(at),n(p),n(ot),n(lt),n(P),n(it),n(F),n(st),n(dt),n(W)),n(r),M(y,t),M(v,t),M($,t),M(B,t),M(A,t),M(S,t),M(Z,t),M(x,t)}}}const xt='{"title":"Attention backends","local":"attention-backends","sections":[{"title":"set_attention_backend","local":"setattentionbackend","sections":[],"depth":2},{"title":"attention_backend context manager","local":"attentionbackend-context-manager","sections":[],"depth":2},{"title":"Available backends","local":"available-backends","sections":[],"depth":2}],"depth":1}';function Gt(pt){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends At{constructor(r){super(),It(this,r,Gt,Ft,$t,{})}}export{qt as component};
