import{s as et,n as tt,o as lt}from"../chunks/scheduler.8c3d61f6.js";import{S as st,i as it,g as a,s as i,r,A as nt,h as o,f as l,c as n,j as K,u as c,x as d,k as He,y as p,a as s,v as u,d as f,t as m,w as M}from"../chunks/index.da70eac4.js";import{C as ee}from"../chunks/CodeBlock.a9c4becf.js";import{H as ge,E as at}from"../chunks/getInferenceSnippets.cb466318.js";function ot(Se){let y,se,te,ie,U,ne,j,Re='<a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> is the basic block for building a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>. It defines what components, inputs/outputs, and computation a block should perform for a specific step in a pipeline. A <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> connects with other blocks, using <a href="./modular_diffusers_states">state</a>, to enable the modular construction of workflows.',ae,J,Xe='A <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> on it’s own can’t be executed. It is a blueprint for what a step should do in a pipeline. To actually run and execute a pipeline, the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> needs to be converted into a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>.',oe,k,Pe='This guide will show you how to create a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a>.',pe,g,de,T,Ye='<p>Refer to the <a href="./modular_diffusers_states">States</a> guide if you aren’t familiar with how state works in Modular Diffusers.</p>',re,v,We='A <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> requires <code>inputs</code>, and <code>intermediate_outputs</code>.',ce,h,b,L,Ee='<code>inputs</code> are values provided by a user and retrieved from the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>. This is useful because some workflows resize an image, but the original image is still required. The <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a> maintains the original image.',ve,x,Le="Use <code>InputParam</code> to define <code>inputs</code>.",Be,B,$e,_,z,xe="<code>intermediate_inputs</code> are values typically created from a previous block but it can also be directly provided if no preceding block generates them. Unlike <code>inputs</code>, <code>intermediate_inputs</code> can be modified.",Ce,N,ze="Use <code>InputParam</code> to define <code>intermediate_inputs</code>.",Ie,$,Ge,w,Q,Ne='<code>intermediate_outputs</code> are new values created by a block and added to the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>. The <code>intermediate_outputs</code> are available as <code>intermediate_inputs</code> for subsequent blocks or available as the final output from running the pipeline.',Ve,A,Qe="Use <code>OutputParam</code> to define <code>intermediate_outputs</code>.",Ze,C,ue,I,Ae="The intermediate inputs and outputs share data to connect blocks. They are accessible at any point, allowing you to track the workflow’s progress.",fe,G,me,V,qe="The computation a block performs is defined in the <code>__call__</code> method and it follows a specific structure.",Me,Z,Fe='<li>Retrieve the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a> to get a local view of the <code>inputs</code> and <code>intermediate_inputs</code>.</li> <li>Implement the computation logic on the <code>inputs</code> and <code>intermediate_inputs</code>.</li> <li>Update <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a> to push changes from the local <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a> back to the global <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>.</li> <li>Return the components and state which becomes available to the next block.</li>',he,H,ye,S,be,R,De='The components and pipeline-level configs a block needs are specified in <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.ComponentSpec">ComponentSpec</a> and <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.modular_pipelines.ConfigSpec">ConfigSpec</a>.',_e,X,Oe='<li><a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.ComponentSpec">ComponentSpec</a> contains the expected components used by a block. You need the <code>name</code> of the component and ideally a <code>type_hint</code> that specifies exactly what the component is.</li> <li><a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.modular_pipelines.ConfigSpec">ConfigSpec</a> contains pipeline-level settings that control behavior across all blocks.</li>',we,P,Te,Y,Ke="When the blocks are converted into a pipeline, the components become available to the block as the first argument in <code>__call__</code>.",Ue,W,je,E,Je,le,ke;return U=new ge({props:{title:"ModularPipelineBlocks",local:"modularpipelineblocks",headingTag:"h1"}}),g=new ge({props:{title:"Inputs and outputs",local:"inputs-and-outputs",headingTag:"h2"}}),B=new ee({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMElucHV0UGFyYW0lMEElMEF1c2VyX2lucHV0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMElucHV0UGFyYW0obmFtZSUzRCUyMmltYWdlJTIyJTJDJTIwdHlwZV9oaW50JTNEJTIyUElMLkltYWdlJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJyYXclMjBpbnB1dCUyMGltYWdlJTIwdG8lMjBwcm9jZXNzJTIyKSUwQSU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> InputParam

user_inputs = [
    InputParam(name=<span class="hljs-string">&quot;image&quot;</span>, type_hint=<span class="hljs-string">&quot;PIL.Image&quot;</span>, description=<span class="hljs-string">&quot;raw input image to process&quot;</span>)
]`,wrap:!1}}),$=new ee({props:{code:"dXNlcl9pbnRlcm1lZGlhdGVfaW5wdXRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwSW5wdXRQYXJhbShuYW1lJTNEJTIycHJvY2Vzc2VkX2ltYWdlJTIyJTJDJTIwdHlwZV9oaW50JTNEJTIydG9yY2guVGVuc29yJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJpbWFnZSUyMHRoYXQlMjBoYXMlMjBiZWVuJTIwcHJlcHJvY2Vzc2VkJTIwYW5kJTIwbm9ybWFsaXplZCUyMiklMkMlMEElNUQ=",highlighted:`user_intermediate_inputs = [
    InputParam(name=<span class="hljs-string">&quot;processed_image&quot;</span>, type_hint=<span class="hljs-string">&quot;torch.Tensor&quot;</span>, description=<span class="hljs-string">&quot;image that has been preprocessed and normalized&quot;</span>),
]`,wrap:!1}}),C=new ee({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyME91dHB1dFBhcmFtJTBBJTBBJTIwJTIwJTIwJTIwdXNlcl9pbnRlcm1lZGlhdGVfb3V0cHV0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyME91dHB1dFBhcmFtKG5hbWUlM0QlMjJpbWFnZV9sYXRlbnRzJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJsYXRlbnRzJTIwcmVwcmVzZW50aW5nJTIwdGhlJTIwaW1hZ2UlMjIpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> OutputParam

    user_intermediate_outputs = [
    OutputParam(name=<span class="hljs-string">&quot;image_latents&quot;</span>, description=<span class="hljs-string">&quot;latents representing the image&quot;</span>)
]`,wrap:!1}}),G=new ge({props:{title:"Computation logic",local:"computation-logic",headingTag:"h2"}}),H=new ee({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjBhJTIwbG9jYWwlMjB2aWV3JTIwb2YlMjB0aGUlMjBzdGF0ZSUyMHZhcmlhYmxlcyUyMHRoaXMlMjBibG9jayUyMG5lZWRzJTBBJTIwJTIwJTIwJTIwYmxvY2tfc3RhdGUlMjAlM0QlMjBzZWxmLmdldF9ibG9ja19zdGF0ZShzdGF0ZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBZb3VyJTIwY29tcHV0YXRpb24lMjBsb2dpYyUyMGhlcmUlMEElMjAlMjAlMjAlMjAlMjMlMjBibG9ja19zdGF0ZSUyMGNvbnRhaW5zJTIwYWxsJTIweW91ciUyMGlucHV0cyUyMGFuZCUyMGludGVybWVkaWF0ZV9pbnB1dHMlMEElMjAlMjAlMjAlMjAlMjMlMjBBY2Nlc3MlMjB0aGVtJTIwbGlrZSUzQSUyMGJsb2NrX3N0YXRlLmltYWdlJTJDJTIwYmxvY2tfc3RhdGUucHJvY2Vzc2VkX2ltYWdlJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXBkYXRlJTIwdGhlJTIwcGlwZWxpbmUlMjBzdGF0ZSUyMHdpdGglMjB5b3VyJTIwdXBkYXRlZCUyMGJsb2NrX3N0YXRlcyUwQSUyMCUyMCUyMCUyMHNlbGYuc2V0X2Jsb2NrX3N0YXRlKHN0YXRlJTJDJTIwYmxvY2tfc3RhdGUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwY29tcG9uZW50cyUyQyUyMHN0YXRl",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
    <span class="hljs-comment"># Get a local view of the state variables this block needs</span>
    block_state = self.get_block_state(state)

    <span class="hljs-comment"># Your computation logic here</span>
    <span class="hljs-comment"># block_state contains all your inputs and intermediate_inputs</span>
    <span class="hljs-comment"># Access them like: block_state.image, block_state.processed_image</span>

    <span class="hljs-comment"># Update the pipeline state with your updated block_states</span>
    self.set_block_state(state, block_state)
    <span class="hljs-keyword">return</span> components, state`,wrap:!1}}),S=new ge({props:{title:"Components and configs",local:"components-and-configs",headingTag:"h3"}}),P=new ee({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbXBvbmVudFNwZWMlMkMlMjBDb25maWdTcGVjJTBBJTBBZXhwZWN0ZWRfY29tcG9uZW50cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbXBvbmVudFNwZWMobmFtZSUzRCUyMnVuZXQlMjIlMkMlMjB0eXBlX2hpbnQlM0RVTmV0MkRDb25kaXRpb25Nb2RlbCklMkMlMEElMjAlMjAlMjAlMjBDb21wb25lbnRTcGVjKG5hbWUlM0QlMjJzY2hlZHVsZXIlMjIlMkMlMjB0eXBlX2hpbnQlM0RFdWxlckRpc2NyZXRlU2NoZWR1bGVyKSUwQSU1RCUwQSUwQWV4cGVjdGVkX2NvbmZpZyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbmZpZ1NwZWMoJTIyZm9yY2VfemVyb3NfZm9yX2VtcHR5X3Byb21wdCUyMiUyQyUyMFRydWUpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ComponentSpec, ConfigSpec

expected_components = [
    ComponentSpec(name=<span class="hljs-string">&quot;unet&quot;</span>, type_hint=UNet2DConditionModel),
    ComponentSpec(name=<span class="hljs-string">&quot;scheduler&quot;</span>, type_hint=EulerDiscreteScheduler)
]

expected_config = [
    ConfigSpec(<span class="hljs-string">&quot;force_zeros_for_empty_prompt&quot;</span>, <span class="hljs-literal">True</span>)
]`,wrap:!1}}),W=new ee({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBY2Nlc3MlMjBjb21wb25lbnRzJTIwdXNpbmclMjBkb3QlMjBub3RhdGlvbiUwQSUyMCUyMCUyMCUyMHVuZXQlMjAlM0QlMjBjb21wb25lbnRzLnVuZXQlMEElMjAlMjAlMjAlMjB2YWUlMjAlM0QlMjBjb21wb25lbnRzLnZhZSUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUyMCUzRCUyMGNvbXBvbmVudHMuc2NoZWR1bGVy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
    <span class="hljs-comment"># Access components using dot notation</span>
    unet = components.unet
    vae = components.vae
    scheduler = components.scheduler`,wrap:!1}}),E=new at({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/pipeline_block.md"}}),{c(){y=a("meta"),se=i(),te=a("p"),ie=i(),r(U.$$.fragment),ne=i(),j=a("p"),j.innerHTML=Re,ae=i(),J=a("p"),J.innerHTML=Xe,oe=i(),k=a("p"),k.innerHTML=Pe,pe=i(),r(g.$$.fragment),de=i(),T=a("blockquote"),T.innerHTML=Ye,re=i(),v=a("p"),v.innerHTML=We,ce=i(),h=a("ul"),b=a("li"),L=a("p"),L.innerHTML=Ee,ve=i(),x=a("p"),x.innerHTML=Le,Be=i(),r(B.$$.fragment),$e=i(),_=a("li"),z=a("p"),z.innerHTML=xe,Ce=i(),N=a("p"),N.innerHTML=ze,Ie=i(),r($.$$.fragment),Ge=i(),w=a("li"),Q=a("p"),Q.innerHTML=Ne,Ve=i(),A=a("p"),A.innerHTML=Qe,Ze=i(),r(C.$$.fragment),ue=i(),I=a("p"),I.textContent=Ae,fe=i(),r(G.$$.fragment),me=i(),V=a("p"),V.innerHTML=qe,Me=i(),Z=a("ol"),Z.innerHTML=Fe,he=i(),r(H.$$.fragment),ye=i(),r(S.$$.fragment),be=i(),R=a("p"),R.innerHTML=De,_e=i(),X=a("ul"),X.innerHTML=Oe,we=i(),r(P.$$.fragment),Te=i(),Y=a("p"),Y.innerHTML=Ke,Ue=i(),r(W.$$.fragment),je=i(),r(E.$$.fragment),Je=i(),le=a("p"),this.h()},l(e){const t=nt("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),se=n(e),te=o(e,"P",{}),K(te).forEach(l),ie=n(e),c(U.$$.fragment,e),ne=n(e),j=o(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-cj8g0i"&&(j.innerHTML=Re),ae=n(e),J=o(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-19agiu"&&(J.innerHTML=Xe),oe=n(e),k=o(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-8fu0w1"&&(k.innerHTML=Pe),pe=n(e),c(g.$$.fragment,e),de=n(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(T)!=="svelte-1sgfd79"&&(T.innerHTML=Ye),re=n(e),v=o(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-nui63e"&&(v.innerHTML=We),ce=n(e),h=o(e,"UL",{});var q=K(h);b=o(q,"LI",{});var F=K(b);L=o(F,"P",{"data-svelte-h":!0}),d(L)!=="svelte-wdjc3v"&&(L.innerHTML=Ee),ve=n(F),x=o(F,"P",{"data-svelte-h":!0}),d(x)!=="svelte-yx83i9"&&(x.innerHTML=Le),Be=n(F),c(B.$$.fragment,F),F.forEach(l),$e=n(q),_=o(q,"LI",{});var D=K(_);z=o(D,"P",{"data-svelte-h":!0}),d(z)!=="svelte-sf9h63"&&(z.innerHTML=xe),Ce=n(D),N=o(D,"P",{"data-svelte-h":!0}),d(N)!=="svelte-hw2ewp"&&(N.innerHTML=ze),Ie=n(D),c($.$$.fragment,D),D.forEach(l),Ge=n(q),w=o(q,"LI",{});var O=K(w);Q=o(O,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-smzm5j"&&(Q.innerHTML=Ne),Ve=n(O),A=o(O,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1wredql"&&(A.innerHTML=Qe),Ze=n(O),c(C.$$.fragment,O),O.forEach(l),q.forEach(l),ue=n(e),I=o(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-85xvms"&&(I.textContent=Ae),fe=n(e),c(G.$$.fragment,e),me=n(e),V=o(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-ymvhyd"&&(V.innerHTML=qe),Me=n(e),Z=o(e,"OL",{"data-svelte-h":!0}),d(Z)!=="svelte-15hxcx2"&&(Z.innerHTML=Fe),he=n(e),c(H.$$.fragment,e),ye=n(e),c(S.$$.fragment,e),be=n(e),R=o(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1vve7vj"&&(R.innerHTML=De),_e=n(e),X=o(e,"UL",{"data-svelte-h":!0}),d(X)!=="svelte-1aq4suh"&&(X.innerHTML=Oe),we=n(e),c(P.$$.fragment,e),Te=n(e),Y=o(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1cled56"&&(Y.innerHTML=Ke),Ue=n(e),c(W.$$.fragment,e),je=n(e),c(E.$$.fragment,e),Je=n(e),le=o(e,"P",{}),K(le).forEach(l),this.h()},h(){He(y,"name","hf:doc:metadata"),He(y,"content",pt),He(T,"class","tip")},m(e,t){p(document.head,y),s(e,se,t),s(e,te,t),s(e,ie,t),u(U,e,t),s(e,ne,t),s(e,j,t),s(e,ae,t),s(e,J,t),s(e,oe,t),s(e,k,t),s(e,pe,t),u(g,e,t),s(e,de,t),s(e,T,t),s(e,re,t),s(e,v,t),s(e,ce,t),s(e,h,t),p(h,b),p(b,L),p(b,ve),p(b,x),p(b,Be),u(B,b,null),p(h,$e),p(h,_),p(_,z),p(_,Ce),p(_,N),p(_,Ie),u($,_,null),p(h,Ge),p(h,w),p(w,Q),p(w,Ve),p(w,A),p(w,Ze),u(C,w,null),s(e,ue,t),s(e,I,t),s(e,fe,t),u(G,e,t),s(e,me,t),s(e,V,t),s(e,Me,t),s(e,Z,t),s(e,he,t),u(H,e,t),s(e,ye,t),u(S,e,t),s(e,be,t),s(e,R,t),s(e,_e,t),s(e,X,t),s(e,we,t),u(P,e,t),s(e,Te,t),s(e,Y,t),s(e,Ue,t),u(W,e,t),s(e,je,t),u(E,e,t),s(e,Je,t),s(e,le,t),ke=!0},p:tt,i(e){ke||(f(U.$$.fragment,e),f(g.$$.fragment,e),f(B.$$.fragment,e),f($.$$.fragment,e),f(C.$$.fragment,e),f(G.$$.fragment,e),f(H.$$.fragment,e),f(S.$$.fragment,e),f(P.$$.fragment,e),f(W.$$.fragment,e),f(E.$$.fragment,e),ke=!0)},o(e){m(U.$$.fragment,e),m(g.$$.fragment,e),m(B.$$.fragment,e),m($.$$.fragment,e),m(C.$$.fragment,e),m(G.$$.fragment,e),m(H.$$.fragment,e),m(S.$$.fragment,e),m(P.$$.fragment,e),m(W.$$.fragment,e),m(E.$$.fragment,e),ke=!1},d(e){e&&(l(se),l(te),l(ie),l(ne),l(j),l(ae),l(J),l(oe),l(k),l(pe),l(de),l(T),l(re),l(v),l(ce),l(h),l(ue),l(I),l(fe),l(me),l(V),l(Me),l(Z),l(he),l(ye),l(be),l(R),l(_e),l(X),l(we),l(Te),l(Y),l(Ue),l(je),l(Je),l(le)),l(y),M(U,e),M(g,e),M(B),M($),M(C),M(G,e),M(H,e),M(S,e),M(P,e),M(W,e),M(E,e)}}}const pt='{"title":"ModularPipelineBlocks","local":"modularpipelineblocks","sections":[{"title":"Inputs and outputs","local":"inputs-and-outputs","sections":[],"depth":2},{"title":"Computation logic","local":"computation-logic","sections":[{"title":"Components and configs","local":"components-and-configs","sections":[],"depth":3}],"depth":2}],"depth":1}';function dt(Se){return lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mt extends st{constructor(y){super(),it(this,y,dt,ot,et,{})}}export{mt as component};
