import{s as dl,n as Ml,o as il}from"../chunks/scheduler.8c3d61f6.js";import{S as ol,i as rl,g as d,s as a,r as o,A as pl,h as M,f as l,c as n,j as w,u as r,x as i,k as J,y as u,a as s,v as p,d as y,t as c,w as m}from"../chunks/index.da70eac4.js";import{C as V}from"../chunks/CodeBlock.a9c4becf.js";import{H as Q,E as yl}from"../chunks/getInferenceSnippets.cb466318.js";function cl(Be){let T,It,bt,gt,R,Zt,A,We="VAE decode is an essential component of diffusion models - turning latent representations into images or videos.",Gt,X,Bt,N,ve="These tables demonstrate the VRAM requirements for VAE decode with SD v1 and SD XL on different GPUs.",Wt,H,Ce="For the majority of these GPUs the memory usage % dictates other models (text encoders, UNet/Transformer) must be offloaded, or tiled decoding has to be used which increases time taken and impacts quality.",vt,Y,ke="<summary>SD v1.5</summary> <table><thead><tr><th>GPU</th> <th>Resolution</th> <th>Time (seconds)</th> <th>Memory (%)</th> <th>Tiled Time (secs)</th> <th>Tiled Memory (%)</th></tr></thead> <tbody><tr><td>NVIDIA GeForce RTX 4090</td> <td>512x512</td> <td>0.031</td> <td>5.60%</td> <td>0.031 (0%)</td> <td>5.60%</td></tr> <tr><td>NVIDIA GeForce RTX 4090</td> <td>1024x1024</td> <td>0.148</td> <td>20.00%</td> <td>0.301 (+103%)</td> <td>5.60%</td></tr> <tr><td>NVIDIA GeForce RTX 4080</td> <td>512x512</td> <td>0.05</td> <td>8.40%</td> <td>0.050 (0%)</td> <td>8.40%</td></tr> <tr><td>NVIDIA GeForce RTX 4080</td> <td>1024x1024</td> <td>0.224</td> <td>30.00%</td> <td>0.356 (+59%)</td> <td>8.40%</td></tr> <tr><td>NVIDIA GeForce RTX 4070 Ti</td> <td>512x512</td> <td>0.066</td> <td>11.30%</td> <td>0.066 (0%)</td> <td>11.30%</td></tr> <tr><td>NVIDIA GeForce RTX 4070 Ti</td> <td>1024x1024</td> <td>0.284</td> <td>40.50%</td> <td>0.454 (+60%)</td> <td>11.40%</td></tr> <tr><td>NVIDIA GeForce RTX 3090</td> <td>512x512</td> <td>0.062</td> <td>5.20%</td> <td>0.062 (0%)</td> <td>5.20%</td></tr> <tr><td>NVIDIA GeForce RTX 3090</td> <td>1024x1024</td> <td>0.253</td> <td>18.50%</td> <td>0.464 (+83%)</td> <td>5.20%</td></tr> <tr><td>NVIDIA GeForce RTX 3080</td> <td>512x512</td> <td>0.07</td> <td>12.80%</td> <td>0.070 (0%)</td> <td>12.80%</td></tr> <tr><td>NVIDIA GeForce RTX 3080</td> <td>1024x1024</td> <td>0.286</td> <td>45.30%</td> <td>0.466 (+63%)</td> <td>12.90%</td></tr> <tr><td>NVIDIA GeForce RTX 3070</td> <td>512x512</td> <td>0.102</td> <td>15.90%</td> <td>0.102 (0%)</td> <td>15.90%</td></tr> <tr><td>NVIDIA GeForce RTX 3070</td> <td>1024x1024</td> <td>0.421</td> <td>56.30%</td> <td>0.746 (+77%)</td> <td>16.00%</td></tr></tbody></table>",Ct,F,xe="<summary>SDXL</summary> <table><thead><tr><th>GPU</th> <th>Resolution</th> <th>Time (seconds)</th> <th>Memory Consumed (%)</th> <th>Tiled Time (seconds)</th> <th>Tiled Memory (%)</th></tr></thead> <tbody><tr><td>NVIDIA GeForce RTX 4090</td> <td>512x512</td> <td>0.057</td> <td>10.00%</td> <td>0.057 (0%)</td> <td>10.00%</td></tr> <tr><td>NVIDIA GeForce RTX 4090</td> <td>1024x1024</td> <td>0.256</td> <td>35.50%</td> <td>0.257 (+0.4%)</td> <td>35.50%</td></tr> <tr><td>NVIDIA GeForce RTX 4080</td> <td>512x512</td> <td>0.092</td> <td>15.00%</td> <td>0.092 (0%)</td> <td>15.00%</td></tr> <tr><td>NVIDIA GeForce RTX 4080</td> <td>1024x1024</td> <td>0.406</td> <td>53.30%</td> <td>0.406 (0%)</td> <td>53.30%</td></tr> <tr><td>NVIDIA GeForce RTX 4070 Ti</td> <td>512x512</td> <td>0.121</td> <td>20.20%</td> <td>0.120 (-0.8%)</td> <td>20.20%</td></tr> <tr><td>NVIDIA GeForce RTX 4070 Ti</td> <td>1024x1024</td> <td>0.519</td> <td>72.00%</td> <td>0.519 (0%)</td> <td>72.00%</td></tr> <tr><td>NVIDIA GeForce RTX 3090</td> <td>512x512</td> <td>0.107</td> <td>10.50%</td> <td>0.107 (0%)</td> <td>10.50%</td></tr> <tr><td>NVIDIA GeForce RTX 3090</td> <td>1024x1024</td> <td>0.459</td> <td>38.00%</td> <td>0.460 (+0.2%)</td> <td>38.00%</td></tr> <tr><td>NVIDIA GeForce RTX 3080</td> <td>512x512</td> <td>0.121</td> <td>25.60%</td> <td>0.121 (0%)</td> <td>25.60%</td></tr> <tr><td>NVIDIA GeForce RTX 3080</td> <td>1024x1024</td> <td>0.524</td> <td>93.00%</td> <td>0.524 (0%)</td> <td>93.00%</td></tr> <tr><td>NVIDIA GeForce RTX 3070</td> <td>512x512</td> <td>0.183</td> <td>31.80%</td> <td>0.183 (0%)</td> <td>31.80%</td></tr> <tr><td>NVIDIA GeForce RTX 3070</td> <td>1024x1024</td> <td>0.794</td> <td>96.40%</td> <td>0.794 (0%)</td> <td>96.40%</td></tr></tbody></table>",kt,S,xt,$,Ee='<thead><tr><th align="center"></th> <th align="center"><strong>Endpoint</strong></th> <th align="center"><strong>Model</strong></th></tr></thead> <tbody><tr><td align="center"><strong>Stable Diffusion v1</strong></td> <td align="center"><a href="https://q1bj3bpq6kzilnsu.us-east-1.aws.endpoints.huggingface.cloud" rel="nofollow">https://q1bj3bpq6kzilnsu.us-east-1.aws.endpoints.huggingface.cloud</a></td> <td align="center"><a href="https://hf.co/stabilityai/sd-vae-ft-mse" rel="nofollow"><code>stabilityai/sd-vae-ft-mse</code></a></td></tr> <tr><td align="center"><strong>Stable Diffusion XL</strong></td> <td align="center"><a href="https://x2dmsqunjd6k9prw.us-east-1.aws.endpoints.huggingface.cloud" rel="nofollow">https://x2dmsqunjd6k9prw.us-east-1.aws.endpoints.huggingface.cloud</a></td> <td align="center"><a href="https://hf.co/madebyollin/sdxl-vae-fp16-fix" rel="nofollow"><code>madebyollin/sdxl-vae-fp16-fix</code></a></td></tr> <tr><td align="center"><strong>Flux</strong></td> <td align="center"><a href="https://whhx50ex1aryqvw6.us-east-1.aws.endpoints.huggingface.cloud" rel="nofollow">https://whhx50ex1aryqvw6.us-east-1.aws.endpoints.huggingface.cloud</a></td> <td align="center"><a href="https://hf.co/black-forest-labs/FLUX.1-schnell" rel="nofollow"><code>black-forest-labs/FLUX.1-schnell</code></a></td></tr> <tr><td align="center"><strong>HunyuanVideo</strong></td> <td align="center"><a href="https://o7ywnmrahorts457.us-east-1.aws.endpoints.huggingface.cloud" rel="nofollow">https://o7ywnmrahorts457.us-east-1.aws.endpoints.huggingface.cloud</a></td> <td align="center"><a href="https://hf.co/hunyuanvideo-community/HunyuanVideo" rel="nofollow"><code>hunyuanvideo-community/HunyuanVideo</code></a></td></tr></tbody>',Et,h,Ve='<p>Model support can be requested <a href="https://github.com/huggingface/diffusers/issues/new?template=remote-vae-pilot-feedback.yml" rel="nofollow">here</a>.</p>',Vt,D,Qt,j,Qe="<p>Install <code>diffusers</code> from <code>main</code> to run the code: <code>pip install git+https://github.com/huggingface/diffusers@main</code></p>",Rt,q,Re="A helper method simplifies interacting with Hybrid Inference.",At,_,Xt,z,Nt,L,Ae="Here, we show how to use the remote VAE on random tensors.",Ht,U,ut,Xe="Code",Ue,K,Yt,b,Ne='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/remote_vae/output.png"/>',Ft,P,He="Usage for Flux is slightly different. Flux latents are packed so we need to send the <code>height</code> and <code>width</code>.",St,f,Jt,Ye="Code",be,O,$t,I,Fe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/remote_vae/flux_random_latent.png"/>',Dt,tt,Se="Finally, an example for HunyuanVideo.",qt,g,Tt,$e="Code",fe,et,_t,Z,De='<video alt="queue.mp4" autoplay="" loop="" autobuffer="" muted="" playsinline=""><source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/remote_vae/video_1.mp4" type="video/mp4"/></video>',zt,lt,Lt,st,qe="But we want to use the VAE on an actual pipeline to get an actual image, not random noise. The example below shows how to do it with SD v1.5.",Kt,G,wt,_e="Code",Ie,at,Pt,B,ze='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/remote_vae/test.jpg"/>',Ot,nt,Le="Here’s another example with Flux.",te,W,ht,Ke="Code",ge,dt,ee,v,Pe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/remote_vae/test_1.jpg"/>',le,Mt,Oe="Here’s an example with HunyuanVideo.",se,C,jt,tl="Code",Ze,it,ae,k,el='<video alt="queue.mp4" autoplay="" loop="" autobuffer="" muted="" playsinline=""><source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/remote_vae/video.mp4" type="video/mp4"/></video>',ne,ot,de,rt,ll="One of the great benefits of using a remote VAE is that we can queue multiple generation requests. While the current latent is being processed for decoding, we can already queue another one. This helps improve concurrency.",Me,x,Ut,sl="Code",Ge,pt,ie,E,al='<video alt="queue.mp4" autoplay="" loop="" autobuffer="" muted="" playsinline=""><source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/remote_vae/queue.mp4" type="video/mp4"/></video>',oe,yt,re,ct,nl='<li><strong><a href="https://github.com/vladmandic/sdnext" rel="nofollow">SD.Next</a>:</strong> All-in-one UI with direct supports Hybrid Inference.</li> <li><strong><a href="https://github.com/kijai/ComfyUI-HFRemoteVae" rel="nofollow">ComfyUI-HFRemoteVae</a>:</strong> ComfyUI node for Hybrid Inference.</li>',pe,mt,ye,ft,ce;return R=new Q({props:{title:"Getting Started: VAE Decode with Hybrid Inference",local:"getting-started-vae-decode-with-hybrid-inference",headingTag:"h1"}}),X=new Q({props:{title:"Memory",local:"memory",headingTag:"h2"}}),S=new Q({props:{title:"Available VAEs",local:"available-vaes",headingTag:"h2"}}),D=new Q({props:{title:"Code",local:"code",headingTag:"h2"}}),_=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscy5yZW1vdGVfdXRpbHMlMjBpbXBvcnQlMjByZW1vdGVfZGVjb2Rl",highlighted:'<span class="hljs-keyword">from</span> diffusers.utils.remote_utils <span class="hljs-keyword">import</span> remote_decode',wrap:!1}}),z=new Q({props:{title:"Basic example",local:"basic-example",headingTag:"h3"}}),K=new V({props:{code:"aW1hZ2UlMjAlM0QlMjByZW1vdGVfZGVjb2RlKCUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZxMWJqM2JwcTZremlsbnN1LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGVuc29yJTNEdG9yY2gucmFuZG4oJTVCMSUyQyUyMDQlMkMlMjA2NCUyQyUyMDY0JTVEJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUyQyUwQSUyMCUyMCUyMCUyMHNjYWxpbmdfZmFjdG9yJTNEMC4xODIxNSUyQyUwQSk=",highlighted:`image = remote_decode(
    endpoint=<span class="hljs-string">&quot;https://q1bj3bpq6kzilnsu.us-east-1.aws.endpoints.huggingface.cloud/&quot;</span>,
    tensor=torch.randn([<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>], dtype=torch.float16),
    scaling_factor=<span class="hljs-number">0.18215</span>,
)`,wrap:!1}}),O=new V({props:{code:"aW1hZ2UlMjAlM0QlMjByZW1vdGVfZGVjb2RlKCUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZ3aGh4NTBleDFhcnlxdnc2LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGVuc29yJTNEdG9yY2gucmFuZG4oJTVCMSUyQyUyMDQwOTYlMkMlMjA2NCU1RCUyQyUyMGR0eXBlJTNEdG9yY2guZmxvYXQxNiklMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwc2NhbGluZ19mYWN0b3IlM0QwLjM2MTElMkMlMEElMjAlMjAlMjAlMjBzaGlmdF9mYWN0b3IlM0QwLjExNTklMkMlMEEp",highlighted:`image = remote_decode(
    endpoint=<span class="hljs-string">&quot;https://whhx50ex1aryqvw6.us-east-1.aws.endpoints.huggingface.cloud/&quot;</span>,
    tensor=torch.randn([<span class="hljs-number">1</span>, <span class="hljs-number">4096</span>, <span class="hljs-number">64</span>], dtype=torch.float16),
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    scaling_factor=<span class="hljs-number">0.3611</span>,
    shift_factor=<span class="hljs-number">0.1159</span>,
)`,wrap:!1}}),et=new V({props:{code:"dmlkZW8lMjAlM0QlMjByZW1vdGVfZGVjb2RlKCUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZvN3l3bm1yYWhvcnRzNDU3LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGVuc29yJTNEdG9yY2gucmFuZG4oJTVCMSUyQyUyMDE2JTJDJTIwMyUyQyUyMDQwJTJDJTIwNjQlNUQlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJtcDQlMjIlMkMlMEEpJTBBd2l0aCUyMG9wZW4oJTIydmlkZW8ubXA0JTIyJTJDJTIwJTIyd2IlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSh2aWRlbyk=",highlighted:`video = remote_decode(
    endpoint=<span class="hljs-string">&quot;https://o7ywnmrahorts457.us-east-1.aws.endpoints.huggingface.cloud/&quot;</span>,
    tensor=torch.randn([<span class="hljs-number">1</span>, <span class="hljs-number">16</span>, <span class="hljs-number">3</span>, <span class="hljs-number">40</span>, <span class="hljs-number">64</span>], dtype=torch.float16),
    output_type=<span class="hljs-string">&quot;mp4&quot;</span>,
)
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;video.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
    f.write(video)`,wrap:!1}}),lt=new Q({props:{title:"Generation",local:"generation",headingTag:"h3"}}),at=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMHZhZSUzRE5vbmUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyU3RyYXdiZXJyeSUyMGljZSUyMGNyZWFtJTJDJTIwaW4lMjBhJTIwc3R5bGlzaCUyMG1vZGVybiUyMGdsYXNzJTJDJTIwY29jb251dCUyQyUyMHNwbGFzaGluZyUyMG1pbGslMjBjcmVhbSUyMGFuZCUyMGhvbmV5JTJDJTIwaW4lMjBhJTIwZ3JhZGllbnQlMjBwdXJwbGUlMjBiYWNrZ3JvdW5kJTJDJTIwZmx1aWQlMjBtb3Rpb24lMkMlMjBkeW5hbWljJTIwbW92ZW1lbnQlMkMlMjBjaW5lbWF0aWMlMjBsaWdodGluZyUyQyUyME15c3RlcmlvdXMlMjIlMEElMEFsYXRlbnQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyJTJDJTBBKS5pbWFnZXMlMEFpbWFnZSUyMCUzRCUyMHJlbW90ZV9kZWNvZGUoJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0QlMjJodHRwcyUzQSUyRiUyRnExYmozYnBxNmt6aWxuc3UudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW5zb3IlM0RsYXRlbnQlMkMlMEElMjAlMjAlMjAlMjBzY2FsaW5nX2ZhY3RvciUzRDAuMTgyMTUlMkMlMEEpJTBBaW1hZ2Uuc2F2ZSglMjJ0ZXN0LmpwZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    vae=<span class="hljs-literal">None</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Strawberry ice cream, in a stylish modern glass, coconut, splashing milk cream and honey, in a gradient purple background, fluid motion, dynamic movement, cinematic lighting, Mysterious&quot;</span>

latent = pipe(
    prompt=prompt,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images
image = remote_decode(
    endpoint=<span class="hljs-string">&quot;https://q1bj3bpq6kzilnsu.us-east-1.aws.endpoints.huggingface.cloud/&quot;</span>,
    tensor=latent,
    scaling_factor=<span class="hljs-number">0.18215</span>,
)
image.save(<span class="hljs-string">&quot;test.jpg&quot;</span>)`,wrap:!1}}),dt=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdmFlJTNETm9uZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTdHJhd2JlcnJ5JTIwaWNlJTIwY3JlYW0lMkMlMjBpbiUyMGElMjBzdHlsaXNoJTIwbW9kZXJuJTIwZ2xhc3MlMkMlMjBjb2NvbnV0JTJDJTIwc3BsYXNoaW5nJTIwbWlsayUyMGNyZWFtJTIwYW5kJTIwaG9uZXklMkMlMjBpbiUyMGElMjBncmFkaWVudCUyMHB1cnBsZSUyMGJhY2tncm91bmQlMkMlMjBmbHVpZCUyMG1vdGlvbiUyQyUyMGR5bmFtaWMlMjBtb3ZlbWVudCUyQyUyMGNpbmVtYXRpYyUyMGxpZ2h0aW5nJTJDJTIwTXlzdGVyaW91cyUyMiUwQSUwQWxhdGVudCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwLjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyJTJDJTBBKS5pbWFnZXMlMEFpbWFnZSUyMCUzRCUyMHJlbW90ZV9kZWNvZGUoJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0QlMjJodHRwcyUzQSUyRiUyRndoaHg1MGV4MWFyeXF2dzYudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW5zb3IlM0RsYXRlbnQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwc2NhbGluZ19mYWN0b3IlM0QwLjM2MTElMkMlMEElMjAlMjAlMjAlMjBzaGlmdF9mYWN0b3IlM0QwLjExNTklMkMlMEEpJTBBaW1hZ2Uuc2F2ZSglMjJ0ZXN0LmpwZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    torch_dtype=torch.bfloat16,
    vae=<span class="hljs-literal">None</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Strawberry ice cream, in a stylish modern glass, coconut, splashing milk cream and honey, in a gradient purple background, fluid motion, dynamic movement, cinematic lighting, Mysterious&quot;</span>

latent = pipe(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">0.0</span>,
    num_inference_steps=<span class="hljs-number">4</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images
image = remote_decode(
    endpoint=<span class="hljs-string">&quot;https://whhx50ex1aryqvw6.us-east-1.aws.endpoints.huggingface.cloud/&quot;</span>,
    tensor=latent,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    scaling_factor=<span class="hljs-number">0.3611</span>,
    shift_factor=<span class="hljs-number">0.1159</span>,
)
image.save(<span class="hljs-string">&quot;test.jpg&quot;</span>)`,wrap:!1}}),it=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEh1bnl1YW5WaWRlb1BpcGVsaW5lJTJDJTIwSHVueXVhblZpZGVvVHJhbnNmb3JtZXIzRE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJodW55dWFudmlkZW8tY29tbXVuaXR5JTJGSHVueXVhblZpZGVvJTIyJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBIdW55dWFuVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBIdW55dWFuVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyJTJDJTIwdmFlJTNETm9uZSUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFsYXRlbnQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBjYXQlMjB3YWxrcyUyMG9uJTIwdGhlJTIwZ3Jhc3MlMkMlMjByZWFsaXN0aWMlMjIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QzMjAlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9mcmFtZXMlM0Q2MSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyJTJDJTBBKS5mcmFtZXMlMEElMEF2aWRlbyUyMCUzRCUyMHJlbW90ZV9kZWNvZGUoJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0QlMjJodHRwcyUzQSUyRiUyRm83eXdubXJhaG9ydHM0NTcudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW5zb3IlM0RsYXRlbnQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMm1wNCUyMiUyQyUwQSklMEElMEFpZiUyMGlzaW5zdGFuY2UodmlkZW8lMkMlMjBieXRlcyklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbiglMjJ2aWRlby5tcDQlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmLndyaXRlKHZpZGVvKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline, HunyuanVideoTransformer3DModel

model_id = <span class="hljs-string">&quot;hunyuanvideo-community/HunyuanVideo&quot;</span>
transformer = HunyuanVideoTransformer3DModel.from_pretrained(
    model_id, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16
)
pipe = HunyuanVideoPipeline.from_pretrained(
    model_id, transformer=transformer, vae=<span class="hljs-literal">None</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

latent = pipe(
    prompt=<span class="hljs-string">&quot;A cat walks on the grass, realistic&quot;</span>,
    height=<span class="hljs-number">320</span>,
    width=<span class="hljs-number">512</span>,
    num_frames=<span class="hljs-number">61</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).frames

video = remote_decode(
    endpoint=<span class="hljs-string">&quot;https://o7ywnmrahorts457.us-east-1.aws.endpoints.huggingface.cloud/&quot;</span>,
    tensor=latent,
    output_type=<span class="hljs-string">&quot;mp4&quot;</span>,
)

<span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(video, <span class="hljs-built_in">bytes</span>):
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;video.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
        f.write(video)`,wrap:!1}}),ot=new Q({props:{title:"Queueing",local:"queueing",headingTag:"h3"}}),pt=new V({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> queue
<span class="hljs-keyword">import</span> threading
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> display
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_worker</span>(<span class="hljs-params">q: queue.Queue</span>):
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        item = q.get()
        <span class="hljs-keyword">if</span> item <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">break</span>
        image = remote_decode(
            endpoint=<span class="hljs-string">&quot;https://q1bj3bpq6kzilnsu.us-east-1.aws.endpoints.huggingface.cloud/&quot;</span>,
            tensor=item,
            scaling_factor=<span class="hljs-number">0.18215</span>,
        )
        display(image)
        q.task_done()

q = queue.Queue()
thread = threading.Thread(target=decode_worker, args=(q,), daemon=<span class="hljs-literal">True</span>)
thread.start()

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode</span>(<span class="hljs-params">latent: torch.Tensor</span>):
    q.put(latent)

prompts = [
    <span class="hljs-string">&quot;Blueberry ice cream, in a stylish modern glass , ice cubes, nuts, mint leaves, splashing milk cream, in a gradient purple background, fluid motion, dynamic movement, cinematic lighting, Mysterious&quot;</span>,
    <span class="hljs-string">&quot;Lemonade in a glass, mint leaves, in an aqua and white background, flowers, ice cubes, halo, fluid motion, dynamic movement, soft lighting, digital painting, rule of thirds composition, Art by Greg rutkowski, Coby whitmore&quot;</span>,
    <span class="hljs-string">&quot;Comic book art, beautiful, vintage, pastel neon colors, extremely detailed pupils, delicate features, light on face, slight smile, Artgerm, Mary Blair, Edmund Dulac, long dark locks, bangs, glowing, fashionable style, fairytale ambience, hot pink.&quot;</span>,
    <span class="hljs-string">&quot;Masterpiece, vanilla cone ice cream garnished with chocolate syrup, crushed nuts, choco flakes, in a brown background, gold, cinematic lighting, Art by WLOP&quot;</span>,
    <span class="hljs-string">&quot;A bowl of milk, falling cornflakes, berries, blueberries, in a white background, soft lighting, intricate details, rule of thirds, octane render, volumetric lighting&quot;</span>,
    <span class="hljs-string">&quot;Cold Coffee with cream, crushed almonds, in a glass, choco flakes, ice cubes, wet, in a wooden background, cinematic lighting, hyper realistic painting, art by Carne Griffiths, octane render, volumetric lighting, fluid motion, dynamic movement, muted colors,&quot;</span>,
]

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Lykon/dreamshaper-8&quot;</span>,
    torch_dtype=torch.float16,
    vae=<span class="hljs-literal">None</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.unet = pipe.unet.to(memory_format=torch.channels_last)
pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

_ = pipe(
    prompt=prompts[<span class="hljs-number">0</span>],
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
)

<span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> prompts:
    latent = pipe(
        prompt=prompt,
        output_type=<span class="hljs-string">&quot;latent&quot;</span>,
    ).images
    decode(latent)

q.put(<span class="hljs-literal">None</span>)
thread.join()`,wrap:!1}}),yt=new Q({props:{title:"Integrations",local:"integrations",headingTag:"h2"}}),mt=new yl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/hybrid_inference/vae_decode.md"}}),{c(){T=d("meta"),It=a(),bt=d("p"),gt=a(),o(R.$$.fragment),Zt=a(),A=d("p"),A.textContent=We,Gt=a(),o(X.$$.fragment),Bt=a(),N=d("p"),N.textContent=ve,Wt=a(),H=d("p"),H.textContent=Ce,vt=a(),Y=d("details"),Y.innerHTML=ke,Ct=a(),F=d("details"),F.innerHTML=xe,kt=a(),o(S.$$.fragment),xt=a(),$=d("table"),$.innerHTML=Ee,Et=a(),h=d("blockquote"),h.innerHTML=Ve,Vt=a(),o(D.$$.fragment),Qt=a(),j=d("blockquote"),j.innerHTML=Qe,Rt=a(),q=d("p"),q.textContent=Re,At=a(),o(_.$$.fragment),Xt=a(),o(z.$$.fragment),Nt=a(),L=d("p"),L.textContent=Ae,Ht=a(),U=d("details"),ut=d("summary"),ut.textContent=Xe,Ue=a(),o(K.$$.fragment),Yt=a(),b=d("figure"),b.innerHTML=Ne,Ft=a(),P=d("p"),P.innerHTML=He,St=a(),f=d("details"),Jt=d("summary"),Jt.textContent=Ye,be=a(),o(O.$$.fragment),$t=a(),I=d("figure"),I.innerHTML=Fe,Dt=a(),tt=d("p"),tt.textContent=Se,qt=a(),g=d("details"),Tt=d("summary"),Tt.textContent=$e,fe=a(),o(et.$$.fragment),_t=a(),Z=d("figure"),Z.innerHTML=De,zt=a(),o(lt.$$.fragment),Lt=a(),st=d("p"),st.textContent=qe,Kt=a(),G=d("details"),wt=d("summary"),wt.textContent=_e,Ie=a(),o(at.$$.fragment),Pt=a(),B=d("figure"),B.innerHTML=ze,Ot=a(),nt=d("p"),nt.textContent=Le,te=a(),W=d("details"),ht=d("summary"),ht.textContent=Ke,ge=a(),o(dt.$$.fragment),ee=a(),v=d("figure"),v.innerHTML=Pe,le=a(),Mt=d("p"),Mt.textContent=Oe,se=a(),C=d("details"),jt=d("summary"),jt.textContent=tl,Ze=a(),o(it.$$.fragment),ae=a(),k=d("figure"),k.innerHTML=el,ne=a(),o(ot.$$.fragment),de=a(),rt=d("p"),rt.textContent=ll,Me=a(),x=d("details"),Ut=d("summary"),Ut.textContent=sl,Ge=a(),o(pt.$$.fragment),ie=a(),E=d("figure"),E.innerHTML=al,oe=a(),o(yt.$$.fragment),re=a(),ct=d("ul"),ct.innerHTML=nl,pe=a(),o(mt.$$.fragment),ye=a(),ft=d("p"),this.h()},l(t){const e=pl("svelte-u9bgzb",document.head);T=M(e,"META",{name:!0,content:!0}),e.forEach(l),It=n(t),bt=M(t,"P",{}),w(bt).forEach(l),gt=n(t),r(R.$$.fragment,t),Zt=n(t),A=M(t,"P",{"data-svelte-h":!0}),i(A)!=="svelte-11yet1x"&&(A.textContent=We),Gt=n(t),r(X.$$.fragment,t),Bt=n(t),N=M(t,"P",{"data-svelte-h":!0}),i(N)!=="svelte-yrxpjh"&&(N.textContent=ve),Wt=n(t),H=M(t,"P",{"data-svelte-h":!0}),i(H)!=="svelte-6p6f4c"&&(H.textContent=Ce),vt=n(t),Y=M(t,"DETAILS",{"data-svelte-h":!0}),i(Y)!=="svelte-1b5t2ka"&&(Y.innerHTML=ke),Ct=n(t),F=M(t,"DETAILS",{"data-svelte-h":!0}),i(F)!=="svelte-1565v4j"&&(F.innerHTML=xe),kt=n(t),r(S.$$.fragment,t),xt=n(t),$=M(t,"TABLE",{"data-svelte-h":!0}),i($)!=="svelte-2ec97g"&&($.innerHTML=Ee),Et=n(t),h=M(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(h)!=="svelte-d0r3c5"&&(h.innerHTML=Ve),Vt=n(t),r(D.$$.fragment,t),Qt=n(t),j=M(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(j)!=="svelte-11oojap"&&(j.innerHTML=Qe),Rt=n(t),q=M(t,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1056iw0"&&(q.textContent=Re),At=n(t),r(_.$$.fragment,t),Xt=n(t),r(z.$$.fragment,t),Nt=n(t),L=M(t,"P",{"data-svelte-h":!0}),i(L)!=="svelte-759h8c"&&(L.textContent=Ae),Ht=n(t),U=M(t,"DETAILS",{});var me=w(U);ut=M(me,"SUMMARY",{"data-svelte-h":!0}),i(ut)!=="svelte-14caxiv"&&(ut.textContent=Xe),Ue=n(me),r(K.$$.fragment,me),me.forEach(l),Yt=n(t),b=M(t,"FIGURE",{class:!0,"data-svelte-h":!0}),i(b)!=="svelte-1e4q5du"&&(b.innerHTML=Ne),Ft=n(t),P=M(t,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1iiplqs"&&(P.innerHTML=He),St=n(t),f=M(t,"DETAILS",{});var ue=w(f);Jt=M(ue,"SUMMARY",{"data-svelte-h":!0}),i(Jt)!=="svelte-14caxiv"&&(Jt.textContent=Ye),be=n(ue),r(O.$$.fragment,ue),ue.forEach(l),$t=n(t),I=M(t,"FIGURE",{class:!0,"data-svelte-h":!0}),i(I)!=="svelte-a1t5o1"&&(I.innerHTML=Fe),Dt=n(t),tt=M(t,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-1dy3nc4"&&(tt.textContent=Se),qt=n(t),g=M(t,"DETAILS",{});var Je=w(g);Tt=M(Je,"SUMMARY",{"data-svelte-h":!0}),i(Tt)!=="svelte-14caxiv"&&(Tt.textContent=$e),fe=n(Je),r(et.$$.fragment,Je),Je.forEach(l),_t=n(t),Z=M(t,"FIGURE",{class:!0,"data-svelte-h":!0}),i(Z)!=="svelte-1whz541"&&(Z.innerHTML=De),zt=n(t),r(lt.$$.fragment,t),Lt=n(t),st=M(t,"P",{"data-svelte-h":!0}),i(st)!=="svelte-18xvtm3"&&(st.textContent=qe),Kt=n(t),G=M(t,"DETAILS",{});var Te=w(G);wt=M(Te,"SUMMARY",{"data-svelte-h":!0}),i(wt)!=="svelte-14caxiv"&&(wt.textContent=_e),Ie=n(Te),r(at.$$.fragment,Te),Te.forEach(l),Pt=n(t),B=M(t,"FIGURE",{class:!0,"data-svelte-h":!0}),i(B)!=="svelte-mfhmkn"&&(B.innerHTML=ze),Ot=n(t),nt=M(t,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-osi5i"&&(nt.textContent=Le),te=n(t),W=M(t,"DETAILS",{});var we=w(W);ht=M(we,"SUMMARY",{"data-svelte-h":!0}),i(ht)!=="svelte-14caxiv"&&(ht.textContent=Ke),ge=n(we),r(dt.$$.fragment,we),we.forEach(l),ee=n(t),v=M(t,"FIGURE",{class:!0,"data-svelte-h":!0}),i(v)!=="svelte-df3hbj"&&(v.innerHTML=Pe),le=n(t),Mt=M(t,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-1paijes"&&(Mt.textContent=Oe),se=n(t),C=M(t,"DETAILS",{});var he=w(C);jt=M(he,"SUMMARY",{"data-svelte-h":!0}),i(jt)!=="svelte-14caxiv"&&(jt.textContent=tl),Ze=n(he),r(it.$$.fragment,he),he.forEach(l),ae=n(t),k=M(t,"FIGURE",{class:!0,"data-svelte-h":!0}),i(k)!=="svelte-f15wo1"&&(k.innerHTML=el),ne=n(t),r(ot.$$.fragment,t),de=n(t),rt=M(t,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-1giv276"&&(rt.textContent=ll),Me=n(t),x=M(t,"DETAILS",{});var je=w(x);Ut=M(je,"SUMMARY",{"data-svelte-h":!0}),i(Ut)!=="svelte-14caxiv"&&(Ut.textContent=sl),Ge=n(je),r(pt.$$.fragment,je),je.forEach(l),ie=n(t),E=M(t,"FIGURE",{class:!0,"data-svelte-h":!0}),i(E)!=="svelte-2wd01h"&&(E.innerHTML=al),oe=n(t),r(yt.$$.fragment,t),re=n(t),ct=M(t,"UL",{"data-svelte-h":!0}),i(ct)!=="svelte-1lxpzv1"&&(ct.innerHTML=nl),pe=n(t),r(mt.$$.fragment,t),ye=n(t),ft=M(t,"P",{}),w(ft).forEach(l),this.h()},h(){J(T,"name","hf:doc:metadata"),J(T,"content",ml),J(h,"class","tip"),J(j,"class","tip"),J(b,"class","image flex flex-col items-center justify-center text-center m-0 w-full"),J(I,"class","image flex flex-col items-center justify-center text-center m-0 w-full"),J(Z,"class","image flex flex-col items-center justify-center text-center m-0 w-full"),J(B,"class","image flex flex-col items-center justify-center text-center m-0 w-full"),J(v,"class","image flex flex-col items-center justify-center text-center m-0 w-full"),J(k,"class","image flex flex-col items-center justify-center text-center m-0 w-full"),J(E,"class","image flex flex-col items-center justify-center text-center m-0 w-full")},m(t,e){u(document.head,T),s(t,It,e),s(t,bt,e),s(t,gt,e),p(R,t,e),s(t,Zt,e),s(t,A,e),s(t,Gt,e),p(X,t,e),s(t,Bt,e),s(t,N,e),s(t,Wt,e),s(t,H,e),s(t,vt,e),s(t,Y,e),s(t,Ct,e),s(t,F,e),s(t,kt,e),p(S,t,e),s(t,xt,e),s(t,$,e),s(t,Et,e),s(t,h,e),s(t,Vt,e),p(D,t,e),s(t,Qt,e),s(t,j,e),s(t,Rt,e),s(t,q,e),s(t,At,e),p(_,t,e),s(t,Xt,e),p(z,t,e),s(t,Nt,e),s(t,L,e),s(t,Ht,e),s(t,U,e),u(U,ut),u(U,Ue),p(K,U,null),s(t,Yt,e),s(t,b,e),s(t,Ft,e),s(t,P,e),s(t,St,e),s(t,f,e),u(f,Jt),u(f,be),p(O,f,null),s(t,$t,e),s(t,I,e),s(t,Dt,e),s(t,tt,e),s(t,qt,e),s(t,g,e),u(g,Tt),u(g,fe),p(et,g,null),s(t,_t,e),s(t,Z,e),s(t,zt,e),p(lt,t,e),s(t,Lt,e),s(t,st,e),s(t,Kt,e),s(t,G,e),u(G,wt),u(G,Ie),p(at,G,null),s(t,Pt,e),s(t,B,e),s(t,Ot,e),s(t,nt,e),s(t,te,e),s(t,W,e),u(W,ht),u(W,ge),p(dt,W,null),s(t,ee,e),s(t,v,e),s(t,le,e),s(t,Mt,e),s(t,se,e),s(t,C,e),u(C,jt),u(C,Ze),p(it,C,null),s(t,ae,e),s(t,k,e),s(t,ne,e),p(ot,t,e),s(t,de,e),s(t,rt,e),s(t,Me,e),s(t,x,e),u(x,Ut),u(x,Ge),p(pt,x,null),s(t,ie,e),s(t,E,e),s(t,oe,e),p(yt,t,e),s(t,re,e),s(t,ct,e),s(t,pe,e),p(mt,t,e),s(t,ye,e),s(t,ft,e),ce=!0},p:Ml,i(t){ce||(y(R.$$.fragment,t),y(X.$$.fragment,t),y(S.$$.fragment,t),y(D.$$.fragment,t),y(_.$$.fragment,t),y(z.$$.fragment,t),y(K.$$.fragment,t),y(O.$$.fragment,t),y(et.$$.fragment,t),y(lt.$$.fragment,t),y(at.$$.fragment,t),y(dt.$$.fragment,t),y(it.$$.fragment,t),y(ot.$$.fragment,t),y(pt.$$.fragment,t),y(yt.$$.fragment,t),y(mt.$$.fragment,t),ce=!0)},o(t){c(R.$$.fragment,t),c(X.$$.fragment,t),c(S.$$.fragment,t),c(D.$$.fragment,t),c(_.$$.fragment,t),c(z.$$.fragment,t),c(K.$$.fragment,t),c(O.$$.fragment,t),c(et.$$.fragment,t),c(lt.$$.fragment,t),c(at.$$.fragment,t),c(dt.$$.fragment,t),c(it.$$.fragment,t),c(ot.$$.fragment,t),c(pt.$$.fragment,t),c(yt.$$.fragment,t),c(mt.$$.fragment,t),ce=!1},d(t){t&&(l(It),l(bt),l(gt),l(Zt),l(A),l(Gt),l(Bt),l(N),l(Wt),l(H),l(vt),l(Y),l(Ct),l(F),l(kt),l(xt),l($),l(Et),l(h),l(Vt),l(Qt),l(j),l(Rt),l(q),l(At),l(Xt),l(Nt),l(L),l(Ht),l(U),l(Yt),l(b),l(Ft),l(P),l(St),l(f),l($t),l(I),l(Dt),l(tt),l(qt),l(g),l(_t),l(Z),l(zt),l(Lt),l(st),l(Kt),l(G),l(Pt),l(B),l(Ot),l(nt),l(te),l(W),l(ee),l(v),l(le),l(Mt),l(se),l(C),l(ae),l(k),l(ne),l(de),l(rt),l(Me),l(x),l(ie),l(E),l(oe),l(re),l(ct),l(pe),l(ye),l(ft)),l(T),m(R,t),m(X,t),m(S,t),m(D,t),m(_,t),m(z,t),m(K),m(O),m(et),m(lt,t),m(at),m(dt),m(it),m(ot,t),m(pt),m(yt,t),m(mt,t)}}}const ml='{"title":"Getting Started: VAE Decode with Hybrid Inference","local":"getting-started-vae-decode-with-hybrid-inference","sections":[{"title":"Memory","local":"memory","sections":[],"depth":2},{"title":"Available VAEs","local":"available-vaes","sections":[],"depth":2},{"title":"Code","local":"code","sections":[{"title":"Basic example","local":"basic-example","sections":[],"depth":3},{"title":"Generation","local":"generation","sections":[],"depth":3},{"title":"Queueing","local":"queueing","sections":[],"depth":3}],"depth":2},{"title":"Integrations","local":"integrations","sections":[],"depth":2}],"depth":1}';function ul(Be){return il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends ol{constructor(T){super(),rl(this,T,ul,cl,dl,{})}}export{jl as component};
