import{s as Si,o as Zi,n as he}from"../chunks/scheduler.8c3d61f6.js";import{S as Fi,i as Gi,g as c,s,r as g,A as Di,h as p,f as t,c as o,j as k,x as f,u,k as b,l as Wi,y as l,a as i,v as M,d as y,t as h,w as T}from"../chunks/index.da70eac4.js";import{D as j}from"../chunks/Docstring.367be9ed.js";import{C as P}from"../chunks/CodeBlock.a9c4becf.js";import{E as yt}from"../chunks/ExampleCodeBlock.dd9ee828.js";import{H as z,E as Ai}from"../chunks/getInferenceSnippets.cb466318.js";import{H as Vo,a as bo}from"../chunks/HfOption.6c3b4e77.js";function Pi(V){let a,_='Refer to the <a href="../../optimization/memory">Reduce memory usage</a> guide for more details about the various memory saving techniques.',d,m,U="From the original repo:",r,J,E="<p>You can use —ar_step 5 to enable asynchronous inference. When asynchronous inference, —causal_block_size 5 is recommended while it is not supposed to be set for synchronous generation… Asynchronous inference will take more steps to diffuse the whole sequence which means it will be SLOWER than synchronous mode. In our experiments, asynchronous inference may improve the instruction following and visual consistent performance.</p>",ee,x,Te;return x=new P({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, SkyReelsV2DiffusionForcingPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video


model_id = <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers&quot;</span>
vae = AutoModel.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)

pipeline = SkyReelsV2DiffusionForcingPipeline.from_pretrained(
    model_id,
    vae=vae,
    torch_dtype=torch.bfloat16,
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
flow_shift = <span class="hljs-number">8.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
pipeline.scheduler = UniPCMultistepScheduler.from_config(pipeline.scheduler.config, flow_shift=flow_shift)

prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>

output = pipeline(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">30</span>,
    height=<span class="hljs-number">544</span>,  <span class="hljs-comment"># 720 for 720P</span>
    width=<span class="hljs-number">960</span>,   <span class="hljs-comment"># 1280 for 720P</span>
    num_frames=<span class="hljs-number">97</span>,
    base_num_frames=<span class="hljs-number">97</span>,  <span class="hljs-comment"># 121 for 720P</span>
    ar_step=<span class="hljs-number">5</span>,  <span class="hljs-comment"># Controls asynchronous inference (0 for synchronous mode)</span>
    causal_block_size=<span class="hljs-number">5</span>,  <span class="hljs-comment"># Number of frames in each block for asynchronous processing</span>
    overlap_history=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Number of frames to overlap for smooth transitions in long videos; 17 for long video generations</span>
    addnoise_condition=<span class="hljs-number">20</span>,  <span class="hljs-comment"># Improves consistency in long video generation</span>
).frames[<span class="hljs-number">0</span>]
export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){a=c("p"),a.innerHTML=_,d=s(),m=c("p"),m.textContent=U,r=s(),J=c("blockquote"),J.innerHTML=E,ee=s(),g(x.$$.fragment)},l(w){a=p(w,"P",{"data-svelte-h":!0}),f(a)!=="svelte-iowzkr"&&(a.innerHTML=_),d=o(w),m=p(w,"P",{"data-svelte-h":!0}),f(m)!=="svelte-zf2nuc"&&(m.textContent=U),r=o(w),J=p(w,"BLOCKQUOTE",{"data-svelte-h":!0}),f(J)!=="svelte-1ml0aiz"&&(J.innerHTML=E),ee=o(w),u(x.$$.fragment,w)},m(w,S){i(w,a,S),i(w,d,S),i(w,m,S),i(w,r,S),i(w,J,S),i(w,ee,S),M(x,w,S),Te=!0},p:he,i(w){Te||(y(x.$$.fragment,w),Te=!0)},o(w){h(x.$$.fragment,w),Te=!1},d(w){w&&(t(a),t(d),t(m),t(r),t(J),t(ee)),T(x,w)}}}function Qi(V){let a,_;return a=new bo({props:{id:"T2V usage",option:"T2V memory",$$slots:{default:[Pi]},$$scope:{ctx:V}}}),{c(){g(a.$$.fragment)},l(d){u(a.$$.fragment,d)},m(d,m){M(a,d,m),_=!0},p(d,m){const U={};m&2&&(U.$$scope={dirty:m,ctx:d}),a.$set(U)},i(d){_||(y(a.$$.fragment,d),_=!0)},o(d){h(a.$$.fragment,d),_=!1},d(d){T(a,d)}}}function $i(V){let a,_;return a=new P({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torchvision.transforms.functional <span class="hljs-keyword">as</span> TF
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLWan, SkyReelsV2DiffusionForcingImageToVideoPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image


model_id = <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-1.3B-720P-Diffusers&quot;</span>
vae = AutoencoderKLWan.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)
pipeline = SkyReelsV2DiffusionForcingImageToVideoPipeline.from_pretrained(
    model_id, vae=vae, torch_dtype=torch.bfloat16
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
flow_shift = <span class="hljs-number">5.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
pipeline.scheduler = UniPCMultistepScheduler.from_config(pipeline.scheduler.config, flow_shift=flow_shift)

first_frame = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/flf2v_input_first_frame.png&quot;</span>)
last_frame = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/flf2v_input_last_frame.png&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">aspect_ratio_resize</span>(<span class="hljs-params">image, pipeline, max_area=<span class="hljs-number">720</span> * <span class="hljs-number">1280</span></span>):
    aspect_ratio = image.height / image.width
    mod_value = pipeline.vae_scale_factor_spatial * pipeline.transformer.config.patch_size[<span class="hljs-number">1</span>]
    height = <span class="hljs-built_in">round</span>(np.sqrt(max_area * aspect_ratio)) // mod_value * mod_value
    width = <span class="hljs-built_in">round</span>(np.sqrt(max_area / aspect_ratio)) // mod_value * mod_value
    image = image.resize((width, height))
    <span class="hljs-keyword">return</span> image, height, width

<span class="hljs-keyword">def</span> <span class="hljs-title function_">center_crop_resize</span>(<span class="hljs-params">image, height, width</span>):
    <span class="hljs-comment"># Calculate resize ratio to match first frame dimensions</span>
    resize_ratio = <span class="hljs-built_in">max</span>(width / image.width, height / image.height)

    <span class="hljs-comment"># Resize the image</span>
    width = <span class="hljs-built_in">round</span>(image.width * resize_ratio)
    height = <span class="hljs-built_in">round</span>(image.height * resize_ratio)
    size = [width, height]
    image = TF.center_crop(image, size)

    <span class="hljs-keyword">return</span> image, height, width

first_frame, height, width = aspect_ratio_resize(first_frame, pipeline)
<span class="hljs-keyword">if</span> last_frame.size != first_frame.size:
    last_frame, _, _ = center_crop_resize(last_frame, height, width)

prompt = <span class="hljs-string">&quot;CG animation style, a small blue bird takes off from the ground, flapping its wings. The bird&#x27;s feathers are delicate, with a unique pattern on its chest. The background shows a blue sky with white clouds under bright sunshine. The camera follows the bird upward, capturing its flight and the vastness of the sky from a close-up, low-angle perspective.&quot;</span>

output = pipeline(
    image=first_frame, last_image=last_frame, prompt=prompt, height=height, width=width, guidance_scale=<span class="hljs-number">5.0</span>
).frames[<span class="hljs-number">0</span>]
export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){g(a.$$.fragment)},l(d){u(a.$$.fragment,d)},m(d,m){M(a,d,m),_=!0},p:he,i(d){_||(y(a.$$.fragment,d),_=!0)},o(d){h(a.$$.fragment,d),_=!1},d(d){T(a,d)}}}function zi(V){let a,_;return a=new bo({props:{id:"FLF2V usage",option:"usage",$$slots:{default:[$i]},$$scope:{ctx:V}}}),{c(){g(a.$$.fragment)},l(d){u(a.$$.fragment,d)},m(d,m){M(a,d,m),_=!0},p(d,m){const U={};m&2&&(U.$$scope={dirty:m,ctx:d}),a.$set(U)},i(d){_||(y(a.$$.fragment,d),_=!0)},o(d){h(a.$$.fragment,d),_=!1},d(d){T(a,d)}}}function Ei(V){let a,_="<code>SkyReelsV2DiffusionForcingVideoToVideoPipeline</code> extends a given video.",d,m,U;return m=new P({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torchvision.transforms.functional <span class="hljs-keyword">as</span> TF
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLWan, SkyReelsV2DiffusionForcingVideoToVideoPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video


model_id = <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-1.3B-720P-Diffusers&quot;</span>
vae = AutoencoderKLWan.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)
pipeline = SkyReelsV2DiffusionForcingVideoToVideoPipeline.from_pretrained(
    model_id, vae=vae, torch_dtype=torch.bfloat16
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
flow_shift = <span class="hljs-number">5.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
pipeline.scheduler = UniPCMultistepScheduler.from_config(pipeline.scheduler.config, flow_shift=flow_shift)

video = load_video(<span class="hljs-string">&quot;input_video.mp4&quot;</span>)

prompt = <span class="hljs-string">&quot;CG animation style, a small blue bird takes off from the ground, flapping its wings. The bird&#x27;s feathers are delicate, with a unique pattern on its chest. The background shows a blue sky with white clouds under bright sunshine. The camera follows the bird upward, capturing its flight and the vastness of the sky from a close-up, low-angle perspective.&quot;</span>

output = pipeline(
    video=video, prompt=prompt, height=<span class="hljs-number">720</span>, width=<span class="hljs-number">1280</span>, guidance_scale=<span class="hljs-number">5.0</span>, overlap_history=<span class="hljs-number">17</span>,
    num_inference_steps=<span class="hljs-number">30</span>, num_frames=<span class="hljs-number">257</span>, base_num_frames=<span class="hljs-number">121</span><span class="hljs-comment">#, ar_step=5, causal_block_size=5,</span>
).frames[<span class="hljs-number">0</span>]
export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)
<span class="hljs-comment"># Total frames will be the number of frames of the given video + 257</span>`,wrap:!1}}),{c(){a=c("p"),a.innerHTML=_,d=s(),g(m.$$.fragment)},l(r){a=p(r,"P",{"data-svelte-h":!0}),f(a)!=="svelte-hejicb"&&(a.innerHTML=_),d=o(r),u(m.$$.fragment,r)},m(r,J){i(r,a,J),i(r,d,J),M(m,r,J),U=!0},p:he,i(r){U||(y(m.$$.fragment,r),U=!0)},o(r){h(m.$$.fragment,r),U=!1},d(r){r&&(t(a),t(d)),T(m,r)}}}function Xi(V){let a,_;return a=new bo({props:{id:"V2V usage",option:"usage",$$slots:{default:[Ei]},$$scope:{ctx:V}}}),{c(){g(a.$$.fragment)},l(d){u(a.$$.fragment,d)},m(d,m){M(a,d,m),_=!0},p(d,m){const U={};m&2&&(U.$$scope={dirty:m,ctx:d}),a.$set(U)},i(d){_||(y(a.$$.fragment,d),_=!0)},o(d){h(a.$$.fragment,d),_=!1},d(d){T(a,d)}}}function Li(V){let a,_="Examples:",d,m,U;return m=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SkyReelsV2DiffusionForcingPipeline,
<span class="hljs-meta">... </span>    UniPCMultistepScheduler,
<span class="hljs-meta">... </span>    AutoencoderKLWan,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;vae&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SkyReelsV2DiffusionForcingPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">8.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">544</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">960</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">6.0</span>,  <span class="hljs-comment"># 6.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">97</span>,
<span class="hljs-meta">... </span>    ar_step=<span class="hljs-number">5</span>,  <span class="hljs-comment"># Controls asynchronous inference (0 for synchronous mode)</span>
<span class="hljs-meta">... </span>    causal_block_size=<span class="hljs-number">5</span>,  <span class="hljs-comment"># Number of frames processed together in a causal block</span>
<span class="hljs-meta">... </span>    overlap_history=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Number of frames to overlap for smooth transitions in long videos</span>
<span class="hljs-meta">... </span>    addnoise_condition=<span class="hljs-number">20</span>,  <span class="hljs-comment"># Improves consistency in long video generation</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=_,d=s(),g(m.$$.fragment)},l(r){a=p(r,"P",{"data-svelte-h":!0}),f(a)!=="svelte-kvfsh7"&&(a.textContent=_),d=o(r),u(m.$$.fragment,r)},m(r,J){i(r,a,J),i(r,d,J),M(m,r,J),U=!0},p:he,i(r){U||(y(m.$$.fragment,r),U=!0)},o(r){h(m.$$.fragment,r),U=!1},d(r){r&&(t(a),t(d)),T(m,r)}}}function Yi(V){let a,_="Examples:",d,m,U;return m=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SkyReelsV2DiffusionForcingImageToVideoPipeline,
<span class="hljs-meta">... </span>    UniPCMultistepScheduler,
<span class="hljs-meta">... </span>    AutoencoderKLWan,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;vae&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SkyReelsV2DiffusionForcingImageToVideoPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">5.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;path/to/image.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">544</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">960</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">5.0</span>,  <span class="hljs-comment"># 6.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">97</span>,
<span class="hljs-meta">... </span>    ar_step=<span class="hljs-number">0</span>,  <span class="hljs-comment"># Controls asynchronous inference (0 for synchronous mode)</span>
<span class="hljs-meta">... </span>    overlap_history=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Number of frames to overlap for smooth transitions in long videos</span>
<span class="hljs-meta">... </span>    addnoise_condition=<span class="hljs-number">20</span>,  <span class="hljs-comment"># Improves consistency in long video generation</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=_,d=s(),g(m.$$.fragment)},l(r){a=p(r,"P",{"data-svelte-h":!0}),f(a)!=="svelte-kvfsh7"&&(a.textContent=_),d=o(r),u(m.$$.fragment,r)},m(r,J){i(r,a,J),i(r,d,J),M(m,r,J),U=!0},p:he,i(r){U||(y(m.$$.fragment,r),U=!0)},o(r){h(m.$$.fragment,r),U=!1},d(r){r&&(t(a),t(d)),T(m,r)}}}function Hi(V){let a,_="Examples:",d,m,U;return m=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SkyReelsV2DiffusionForcingVideoToVideoPipeline,
<span class="hljs-meta">... </span>    UniPCMultistepScheduler,
<span class="hljs-meta">... </span>    AutoencoderKLWan,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-DF-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;vae&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SkyReelsV2DiffusionForcingVideoToVideoPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-DF-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">8.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">544</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">960</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">6.0</span>,  <span class="hljs-comment"># 6.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">97</span>,
<span class="hljs-meta">... </span>    ar_step=<span class="hljs-number">0</span>,  <span class="hljs-comment"># Controls asynchronous inference (0 for synchronous mode)</span>
<span class="hljs-meta">... </span>    overlap_history=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Number of frames to overlap for smooth transitions in long videos</span>
<span class="hljs-meta">... </span>    addnoise_condition=<span class="hljs-number">20</span>,  <span class="hljs-comment"># Improves consistency in long video generation</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=_,d=s(),g(m.$$.fragment)},l(r){a=p(r,"P",{"data-svelte-h":!0}),f(a)!=="svelte-kvfsh7"&&(a.textContent=_),d=o(r),u(m.$$.fragment,r)},m(r,J){i(r,a,J),i(r,d,J),M(m,r,J),U=!0},p:he,i(r){U||(y(m.$$.fragment,r),U=!0)},o(r){h(m.$$.fragment,r),U=!1},d(r){r&&(t(a),t(d)),T(m,r)}}}function Oi(V){let a,_="Examples:",d,m,U;return m=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SkyReelsV2Pipeline,
<span class="hljs-meta">... </span>    UniPCMultistepScheduler,
<span class="hljs-meta">... </span>    AutoencoderKLWan,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-T2V-14B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-T2V-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-T2V-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;vae&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SkyReelsV2Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-T2V-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">8.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">544</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">960</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">6.0</span>,  <span class="hljs-comment"># 6.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">97</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=_,d=s(),g(m.$$.fragment)},l(r){a=p(r,"P",{"data-svelte-h":!0}),f(a)!=="svelte-kvfsh7"&&(a.textContent=_),d=o(r),u(m.$$.fragment,r)},m(r,J){i(r,a,J),i(r,d,J),M(m,r,J),U=!0},p:he,i(r){U||(y(m.$$.fragment,r),U=!0)},o(r){h(m.$$.fragment,r),U=!1},d(r){r&&(t(a),t(d)),T(m,r)}}}function qi(V){let a,_="Examples:",d,m,U;return m=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SkyReelsV2ImageToVideoPipeline,
<span class="hljs-meta">... </span>    UniPCMultistepScheduler,
<span class="hljs-meta">... </span>    AutoencoderKLWan,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-I2V-1.3B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-I2V-14B-540P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - Skywork/SkyReels-V2-I2V-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-I2V-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;vae&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SkyReelsV2ImageToVideoPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Skywork/SkyReels-V2-I2V-14B-720P-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">5.0</span>  <span class="hljs-comment"># 8.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;path/to/image.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">544</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">960</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">5.0</span>,  <span class="hljs-comment"># 6.0 for T2V, 5.0 for I2V</span>
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">97</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;video.mp4&quot;</span>, fps=<span class="hljs-number">24</span>, quality=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=_,d=s(),g(m.$$.fragment)},l(r){a=p(r,"P",{"data-svelte-h":!0}),f(a)!=="svelte-kvfsh7"&&(a.textContent=_),d=o(r),u(m.$$.fragment,r)},m(r,J){i(r,a,J),i(r,d,J),M(m,r,J),U=!0},p:he,i(r){U||(y(m.$$.fragment,r),U=!0)},o(r){h(m.$$.fragment,r),U=!1},d(r){r&&(t(a),t(d)),T(m,r)}}}function Ki(V){let a,_,d,m,U,r='<div class="flex flex-wrap space-x-1"><a href="https://huggingface.co/docs/diffusers/main/en/tutorials/using_peft_for_inference" target="_blank" rel="noopener"><img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/></a></div>',J,E,ee,x,Te='<a href="https://huggingface.co/papers/2504.13074" rel="nofollow">SkyReels-V2</a> by the SkyReels Team from Skywork AI.',w,S,ko='<em>Recent advances in video generation have been driven by diffusion models and autoregressive frameworks, yet critical challenges persist in harmonizing prompt adherence, visual quality, motion dynamics, and duration: compromises in motion dynamics to enhance temporal visual quality, constrained video duration (5-10 seconds) to prioritize resolution, and inadequate shot-aware generation stemming from general-purpose MLLMs’ inability to interpret cinematic grammar, such as shot composition, actor expressions, and camera motions. These intertwined limitations hinder realistic long-form synthesis and professional film-style generation. To address these limitations, we propose SkyReels-V2, an Infinite-length Film Generative Model, that synergizes Multi-modal Large Language Model (MLLM), Multi-stage Pretraining, Reinforcement Learning, and Diffusion Forcing Framework. Firstly, we design a comprehensive structural representation of video that combines the general descriptions by the Multi-modal LLM and the detailed shot language by sub-expert models. Aided with human annotation, we then train a unified Video Captioner, named SkyCaptioner-V1, to efficiently label the video data. Secondly, we establish progressive-resolution pretraining for the fundamental video generation, followed by a four-stage post-training enhancement: Initial concept-balanced Supervised Fine-Tuning (SFT) improves baseline quality; Motion-specific Reinforcement Learning (RL) training with human-annotated and synthetic distortion data addresses dynamic artifacts; Our diffusion forcing framework with non-decreasing noise schedules enables long-video synthesis in an efficient search space; Final high-quality SFT refines visual fidelity. All the code and models are available at <a href="https://github.com/SkyworkAI/SkyReels-V2" rel="nofollow">this https URL</a>.</em>',ht,Ue,jo='You can find all the original SkyReels-V2 checkpoints under the <a href="https://huggingface.co/collections/Skywork/skyreels-v2-6801b1b93df627d441d0d0d9" rel="nofollow">Skywork</a> organization.',Tt,_e,Co="The following SkyReels-V2 models are supported in Diffusers:",Ut,Je,Io='<li><a href="https://huggingface.co/Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers" rel="nofollow">SkyReels-V2 DF 1.3B - 540P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-DF-14B-540P-Diffusers" rel="nofollow">SkyReels-V2 DF 14B - 540P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-DF-14B-720P-Diffusers" rel="nofollow">SkyReels-V2 DF 14B - 720P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-T2V-14B-540P-Diffusers" rel="nofollow">SkyReels-V2 T2V 14B - 540P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-T2V-14B-720P-Diffusers" rel="nofollow">SkyReels-V2 T2V 14B - 720P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-I2V-1.3B-540P-Diffusers" rel="nofollow">SkyReels-V2 I2V 1.3B - 540P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-I2V-14B-540P-Diffusers" rel="nofollow">SkyReels-V2 I2V 14B - 540P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-I2V-14B-720P-Diffusers" rel="nofollow">SkyReels-V2 I2V 14B - 720P</a></li> <li><a href="https://huggingface.co/Skywork/SkyReels-V2-FLF2V-1.3B-540P-Diffusers" rel="nofollow">SkyReels-V2 FLF2V 1.3B - 540P</a></li>',_t,oe,vo="<p>Click on the SkyReels-V2 models in the right sidebar for more examples of video generation.</p>",Jt,we,wt,Ve,Bo="The example below has the following parameters:",Vt,be,Ro="<li><code>base_num_frames=97</code></li> <li><code>num_frames=97</code></li> <li><code>num_inference_steps=30</code></li> <li><code>ar_step=5</code></li> <li><code>causal_block_size=5</code></li>",bt,ke,No="With <code>vae_scale_factor_temporal=4</code>, expect <code>5</code> blocks of <code>5</code> frames each as calculated by:",kt,je,xo="<code>num_latent_frames: (97-1)//vae_scale_factor_temporal+1 = 25 frames -&gt; 5 blocks of 5 frames each</code>",jt,Ce,So="And the maximum context length in the latent space is calculated with <code>base_num_latent_frames</code>:",Ct,Ie,Zo="<code>base_num_latent_frames = (97-1)//vae_scale_factor_temporal+1 = 25 -&gt; 25//5 = 5 blocks</code>",It,ve,Fo="Asynchronous Processing Timeline:",vt,Be,Bt,Re,Go=`For Long Videos (<code>num_frames</code> &gt; <code>base_num_frames</code>):
<code>base_num_frames</code> acts as the “sliding window size” for processing long videos.`,Rt,Ne,Do="Example: <code>257</code>-frame video with <code>base_num_frames=97</code>, <code>overlap_history=17</code>",Nt,xe,xt,Se,Wo=`Each iteration independently runs the asynchronous processing with its own <code>5</code> blocks.
<code>base_num_frames</code> controls:`,St,Ze,Ao="<li>Memory usage (larger window = more VRAM)</li> <li>Model context length (must match training constraints)</li> <li>Number of blocks per iteration (<code>base_num_latent_frames // causal_block_size</code>)</li>",Zt,Fe,Po=`Each block takes <code>30</code> steps to complete denoising.
Block N starts at step: <code>1 + (N-1) x ar_step</code>
Total steps: <code>30 + (5-1) x 5 = 50</code> steps`,Ft,Ge,Qo="Synchronous mode (<code>ar_step=0</code>) would process all blocks/frames simultaneously:",Gt,De,Dt,We,$o="Total steps: <code>30</code> steps",Wt,Ae,zo=`An example on how the step matrix is constructed for asynchronous processing:
Given the parameters: (<code>num_inference_steps=30, flow_shift=8, num_frames=97, ar_step=5, causal_block_size=5</code>)`,At,Pe,Pt,Qe,Eo="The algorithm creates a <code>50x25</code> <code>step_matrix</code> where:",Qt,$e,$t,ze,Xo="Detailed Row <code>6</code> Analysis:",zt,Ee,Et,Xe,Lo=`Key Pattern: Block <code>i</code> lags behind Block <code>i-1</code> by exactly <code>ar_step=5</code> timesteps, creating the
staggered “diffusion forcing” effect where later blocks condition on cleaner earlier blocks.`,Xt,Le,Lt,Ye,Yo="The example below demonstrates how to generate a video from text.",Yt,ie,Ht,He,Ot,Oe,Ho="The example below demonstrates how to use the image-to-video pipeline to generate a video using a text description, a starting frame, and an ending frame.",qt,le,Kt,qe,es,ae,ns,Ke,ts,en,Oo='<li>SkyReels-V2 supports LoRAs with <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.SkyReelsV2LoraLoaderMixin.load_lora_weights">load_lora_weights()</a>.</li>',ss,nn,qo="<code>SkyReelsV2Pipeline</code> and <code>SkyReelsV2ImageToVideoPipeline</code> are also available without Diffusion Forcing framework applied.",os,tn,is,C,sn,ws,Bn,Ko="Pipeline for Text-to-Video (t2v) generation using SkyReels-V2 with diffusion forcing.",Vs,Rn,ei=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a specific device, etc.).`,bs,X,on,ks,Nn,ni="The call function to the pipeline for generation.",js,re,Cs,ce,ln,Is,xn,ti="Encodes the prompt into text encoder hidden states.",vs,B,an,Bs,Sn,si=`This function implements the core diffusion forcing algorithm that creates a coordinated denoising schedule
across temporal frames. It supports both synchronous and asynchronous generation modes:`,Rs,Zn,oi="<strong>Synchronous Mode</strong> (ar_step=0, causal_block_size=1):",Ns,Fn,ii="<li>All frames are denoised simultaneously at each timestep</li> <li>Each frame follows the same denoising trajectory: [1000, 800, 600, …, 0]</li> <li>Simpler but may have less temporal consistency for long videos</li>",xs,Gn,li="<strong>Asynchronous Mode</strong> (ar_step&gt;0, causal_block_size&gt;1):",Ss,Dn,ai="<li>Frames are grouped into causal blocks and processed block/chunk-wise</li> <li>Each block is denoised in a staggered pattern creating a “denoising wave”</li> <li>Earlier blocks are more denoised, later blocks lag behind by ar_step timesteps</li> <li>Creates stronger temporal dependencies and better consistency</li>",ls,rn,as,I,cn,Zs,Wn,ri="Pipeline for Image-to-Video (i2v) generation using SkyReels-V2 with diffusion forcing.",Fs,An,ci=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a specific device, etc.).`,Gs,L,pn,Ds,Pn,pi="The call function to the pipeline for generation.",Ws,pe,As,de,dn,Ps,Qn,di="Encodes the prompt into text encoder hidden states.",Qs,R,mn,$s,$n,mi=`This function implements the core diffusion forcing algorithm that creates a coordinated denoising schedule
across temporal frames. It supports both synchronous and asynchronous generation modes:`,zs,zn,fi="<strong>Synchronous Mode</strong> (ar_step=0, causal_block_size=1):",Es,En,gi="<li>All frames are denoised simultaneously at each timestep</li> <li>Each frame follows the same denoising trajectory: [1000, 800, 600, …, 0]</li> <li>Simpler but may have less temporal consistency for long videos</li>",Xs,Xn,ui="<strong>Asynchronous Mode</strong> (ar_step&gt;0, causal_block_size&gt;1):",Ls,Ln,Mi="<li>Frames are grouped into causal blocks and processed block/chunk-wise</li> <li>Each block is denoised in a staggered pattern creating a “denoising wave”</li> <li>Earlier blocks are more denoised, later blocks lag behind by ar_step timesteps</li> <li>Creates stronger temporal dependencies and better consistency</li>",rs,fn,cs,v,gn,Ys,Yn,yi="Pipeline for Video-to-Video (v2v) generation using SkyReels-V2 with diffusion forcing.",Hs,Hn,hi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a specific device, etc.).`,Os,Y,un,qs,On,Ti="The call function to the pipeline for generation.",Ks,me,eo,fe,Mn,no,qn,Ui="Encodes the prompt into text encoder hidden states.",to,N,yn,so,Kn,_i=`This function implements the core diffusion forcing algorithm that creates a coordinated denoising schedule
across temporal frames. It supports both synchronous and asynchronous generation modes:`,oo,et,Ji="<strong>Synchronous Mode</strong> (ar_step=0, causal_block_size=1):",io,nt,wi="<li>All frames are denoised simultaneously at each timestep</li> <li>Each frame follows the same denoising trajectory: [1000, 800, 600, …, 0]</li> <li>Simpler but may have less temporal consistency for long videos</li>",lo,tt,Vi="<strong>Asynchronous Mode</strong> (ar_step&gt;0, causal_block_size&gt;1):",ao,st,bi="<li>Frames are grouped into causal blocks and processed block/chunk-wise</li> <li>Each block is denoised in a staggered pattern creating a “denoising wave”</li> <li>Earlier blocks are more denoised, later blocks lag behind by ar_step timesteps</li> <li>Creates stronger temporal dependencies and better consistency</li>",ps,hn,ds,Z,Tn,ro,ot,ki="Pipeline for Text-to-Video (t2v) generation using SkyReels-V2.",co,it,ji=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,po,H,Un,mo,lt,Ci="The call function to the pipeline for generation.",fo,ge,go,ue,_n,uo,at,Ii="Encodes the prompt into text encoder hidden states.",ms,Jn,fs,F,wn,Mo,rt,vi="Pipeline for Image-to-Video (i2v) generation using SkyReels-V2.",yo,ct,Bi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ho,O,Vn,To,pt,Ri="The call function to the pipeline for generation.",Uo,Me,_o,ye,bn,Jo,dt,Ni="Encodes the prompt into text encoder hidden states.",gs,kn,us,ne,jn,wo,mt,xi="Output class for SkyReelsV2 pipelines.",Ms,Cn,ys,Mt,hs;return E=new z({props:{title:"SkyReels-V2: Infinite-length Film Generative model",local:"skyreels-v2-infinite-length-film-generative-model",headingTag:"h1"}}),we=new z({props:{title:"A Visual Demonstration",local:"a-visual-demonstration",headingTag:"h3"}}),Be=new P({props:{code:"JUUyJTk0JThDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTkwJTBBJUUyJTk0JTgyJTIwU3RlcHMlM0ElMjAlMjAlMjAlMjAxJTIwJTIwJTIwJTIwNiUyMCUyMCUyMDExJTIwJTIwJTIwMTYlMjAlMjAlMjAyMSUyMCUyMCUyMDI2JTIwJTIwJTIwMzElMjAlMjAlMjAzNiUyMCUyMCUyMDQxJTIwJTIwJTIwNDYlMjAlMjAlMjA1MCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMEJsb2NrJTIwMSUzQSUyMCU1QiVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCU1RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMEJsb2NrJTIwMiUzQSUyMCUyMCUyMCUyMCUyMCUyMCU1QiVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCU1RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMEJsb2NrJTIwMyUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCU1RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMEJsb2NrJTIwNCUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCU1RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMEJsb2NrJTIwNSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCVFMiU5NiVBMCU1RCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU5OA==",highlighted:`┌─────────────────────────────────────────────────────────────────┐
│ Steps:    1    6   11   16   21   26   31   36   41   46   50   │
│ Block 1: [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■]                       │
│ Block 2:      [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■]                  │
│ Block 3:           [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■]             │
│ Block 4:                [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■]        │
│ Block 5:                     [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■]   │
└─────────────────────────────────────────────────────────────────┘`,wrap:!1}}),xe=new P({props:{code:"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",highlighted:`┌──── Iteration 1 (frames 1-97) ────┐
│ Processing window: 97 frames      │ → 5 blocks,
│ Generates: frames 1-97            │   async processing
└───────────────────────────────────┘
            ┌────── Iteration 2 (frames 81-177) ──────┐
            │ Processing window: 97 frames            │
            │ Overlap: 17 frames (81-97) from prev    │ → 5 blocks,
            │ Generates: frames 98-177                │   async processing
            └─────────────────────────────────────────┘
                        ┌────── Iteration 3 (frames 161-257) ──────┐
                        │ Processing window: 97 frames             │
                        │ Overlap: 17 frames (161-177) from prev   │ → 5 blocks,
                        │ Generates: frames 178-257                │   async processing
                        └──────────────────────────────────────────┘`,wrap:!1}}),De=new P({props:{code:"JUUyJTk0JThDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTkwJTBBJUUyJTk0JTgyJTIwU3RlcHMlM0ElMjAlMjAlMjAlMjAlMjAlMjAlMjAxJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMzAlMjAlMjAlRTIlOTQlODIlMEElRTIlOTQlODIlMjBBbGwlMjBibG9ja3MlM0ElMjAlNUIlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlRTIlOTYlQTAlNUQlMjAlRTIlOTQlODIlMEElRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlOTg=",highlighted:`┌──────────────────────────────────────────────┐
│ Steps:       1            ...            30  │
│ All blocks: [■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■] │
└──────────────────────────────────────────────┘`,wrap:!1}}),Pe=new P({props:{code:"LSUyMG51bV9sYXRlbnRfZnJhbWVzJTIwJTNEJTIwKDk3JTIwZnJhbWVzJTIwLSUyMDEpJTIwJTJGJTJGJTIwKDQlMjB0ZW1wb3JhbCUyMGRvd25zYW1wbGluZyklMjAlMkIlMjAxJTIwJTNEJTIwMjUlMEEtJTIwc3RlcF90ZW1wbGF0ZSUyMCUzRCUyMCU1Qjk5OSUyQyUyMDk5NSUyQyUyMDk5MSUyQyUyMDk4NiUyQyUyMDk4MCUyQyUyMDk3NSUyQyUyMDk2OSUyQyUyMDk2MyUyQyUyMDk1NiUyQyUyMDk0OCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDk0MSUyQyUyMDkzMiUyQyUyMDkyMiUyQyUyMDkxMiUyQyUyMDkwMSUyQyUyMDg4OCUyQyUyMDg3NCUyQyUyMDg1OSUyQyUyMDg0MSUyQyUyMDgyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDc5OSUyQyUyMDc3MyUyQyUyMDc0MyUyQyUyMDcwOCUyQyUyMDY2NiUyQyUyMDYxNSUyQyUyMDU1MSUyQyUyMDQ3MCUyQyUyMDM2MyUyQyUyMDIxNiU1RA==",highlighted:`<span class="hljs-bullet">- </span>num<span class="hljs-emphasis">_latent_frames = (97 frames - 1) // (4 temporal downsampling) + 1 = 25
- step_</span>template = [999, 995, 991, 986, 980, 975, 969, 963, 956, 948,
<span class="hljs-code">                   941, 932, 922, 912, 901, 888, 874, 859, 841, 822,</span>
<span class="hljs-code">                   799, 773, 743, 708, 666, 615, 551, 470, 363, 216]</span>`,wrap:!1}}),$e=new P({props:{code:"LSUyMFJvdyUyMDElM0ElMjAlMjAlNUI5OTklQzMlOTc1JTJDJTIwOTk5JUMzJTk3NSUyQyUyMDk5OSVDMyU5NzUlMkMlMjA5OTklQzMlOTc1JTJDJTIwOTk5JUMzJTk3NSU1RCUwQS0lMjBSb3clMjAyJTNBJTIwJTIwJTVCOTk1JUMzJTk3NSUyQyUyMDk5OSVDMyU5NzUlMkMlMjA5OTklQzMlOTc1JTJDJTIwOTk5JUMzJTk3NSUyQyUyMDk5OSVDMyU5NzUlNUQlMEEtJTIwUm93JTIwMyUzQSUyMCUyMCU1Qjk5MSVDMyU5NzUlMkMlMjA5OTklQzMlOTc1JTJDJTIwOTk5JUMzJTk3NSUyQyUyMDk5OSVDMyU5NzUlMkMlMjA5OTklQzMlOTc1JTVEJTBBLSUyMC4uLiUwQS0lMjBSb3clMjA3JTNBJTIwJTIwJTVCOTY5JUMzJTk3NSUyQyUyMDk5NSVDMyU5NzUlMkMlMjA5OTklQzMlOTc1JTJDJTIwOTk5JUMzJTk3NSUyQyUyMDk5OSVDMyU5NzUlNUQlMEEtJTIwLi4uJTBBLSUyMFJvdyUyMDIxJTNBJTIwJTVCNzk5JUMzJTk3NSUyQyUyMDg4OCVDMyU5NzUlMkMlMjA5NDElQzMlOTc1JTJDJTIwOTc1JUMzJTk3NSUyQyUyMDk5OSVDMyU5NzUlNUQlMEEtJTIwLi4uJTBBLSUyMFJvdyUyMDM1JTNBJTIwJTVCJTIwJTIwMCVDMyU5NzUlMkMlMjAyMTYlQzMlOTc1JTJDJTIwNjY2JUMzJTk3NSUyQyUyMDgyMiVDMyU5NzUlMkMlMjA5MDElQzMlOTc1JTVEJTBBLSUyMC4uLiUwQS0lMjBSb3clMjA0MiUzQSUyMCU1QiUyMCUyMDAlQzMlOTc1JTJDJTIwJTIwJTIwMCVDMyU5NzUlMkMlMjAlMjAlMjAwJUMzJTk3NSUyQyUyMDU1MSVDMyU5NzUlMkMlMjA3NzMlQzMlOTc1JTVEJTBBLSUyMC4uLiUwQS0lMjBSb3clMjA1MCUzQSUyMCU1QiUyMCUyMDAlQzMlOTc1JTJDJTIwJTIwJTIwMCVDMyU5NzUlMkMlMjAlMjAlMjAwJUMzJTk3NSUyQyUyMCUyMCUyMDAlQzMlOTc1JTJDJTIwMjE2JUMzJTk3NSU1RA==",highlighted:`<span class="hljs-bullet">- </span>Row 1:  [999×5, 999×5, 999×5, 999×5, 999×5]
<span class="hljs-bullet">- </span>Row 2:  [995×5, 999×5, 999×5, 999×5, 999×5]
<span class="hljs-bullet">- </span>Row 3:  [991×5, 999×5, 999×5, 999×5, 999×5]
<span class="hljs-bullet">- </span>...
<span class="hljs-bullet">- </span>Row 7:  [969×5, 995×5, 999×5, 999×5, 999×5]
<span class="hljs-bullet">- </span>...
<span class="hljs-bullet">- </span>Row 21: [799×5, 888×5, 941×5, 975×5, 999×5]
<span class="hljs-bullet">- </span>...
<span class="hljs-bullet">- </span>Row 35: [  0×5, 216×5, 666×5, 822×5, 901×5]
<span class="hljs-bullet">- </span>...
<span class="hljs-bullet">- </span>Row 42: [  0×5,   0×5,   0×5, 551×5, 773×5]
<span class="hljs-bullet">- </span>...
<span class="hljs-bullet">- </span>Row 50: [  0×5,   0×5,   0×5,   0×5, 216×5]`,wrap:!1}}),Ee=new P({props:{code:"LSUyMHN0ZXBfbWF0cml4JTVCNSU1RCUzQSUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMDk3NSVDMyU5NzUlMkMlMjAlMjA5OTklQzMlOTc1JTJDJTIwJTIwJTIwOTk5JUMzJTk3NSUyQyUyMCUyMCUyMDk5OSVDMyU5NzUlMkMlMjAlMjAlMjA5OTklQzMlOTc1JTVEJTBBLSUyMHN0ZXBfaW5kZXglNUI1JTVEJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTIwJTIwJTIwNiVDMyU5NzUlMkMlMjAlMjAlMjAlMjAxJUMzJTk3NSUyQyUyMCUyMCUyMCUyMCUyMDAlQzMlOTc1JTJDJTIwJTIwJTIwJTIwJTIwMCVDMyU5NzUlMkMlMjAlMjAlMjAlMjAlMjAwJUMzJTk3NSU1RCUwQS0lMjBzdGVwX3VwZGF0ZV9tYXNrJTVCNSU1RCUzQSUyMCU1QlRydWUlQzMlOTc1JTJDJTIwVHJ1ZSVDMyU5NzUlMkMlMjBGYWxzZSVDMyU5NzUlMkMlMjBGYWxzZSVDMyU5NzUlMkMlMjBGYWxzZSVDMyU5NzUlNUQlMEEtJTIwdmFsaWRfaW50ZXJ2YWwlNUI1JTVEJTNBJTIwJTIwJTIwKDAlMkMlMjAyNSk=",highlighted:`- step_matrix<span class="hljs-comment">[5]</span>:      <span class="hljs-comment">[ 975×5,  999×5,   999×5,   999×5,   999×5]</span>
- step_index<span class="hljs-comment">[5]</span>:       <span class="hljs-comment">[   6×5,    1×5,     0×5,     0×5,     0×5]</span>
- step_update_mask<span class="hljs-comment">[5]</span>: <span class="hljs-comment">[True×5, True×5, False×5, False×5, False×5]</span>
- valid_interval<span class="hljs-comment">[5]</span>:   (0, 25)`,wrap:!1}}),Le=new z({props:{title:"Text-to-Video Generation",local:"text-to-video-generation",headingTag:"h3"}}),ie=new Vo({props:{id:"T2V usage",options:["T2V memory"],$$slots:{default:[Qi]},$$scope:{ctx:V}}}),He=new z({props:{title:"First-Last-Frame-to-Video Generation",local:"first-last-frame-to-video-generation",headingTag:"h3"}}),le=new Vo({props:{id:"FLF2V usage",options:["usage"],$$slots:{default:[zi]},$$scope:{ctx:V}}}),qe=new z({props:{title:"Video-to-Video Generation",local:"video-to-video-generation",headingTag:"h3"}}),ae=new Vo({props:{id:"V2V usage",options:["usage"],$$slots:{default:[Xi]},$$scope:{ctx:V}}}),Ke=new z({props:{title:"Notes",local:"notes",headingTag:"h2"}}),tn=new z({props:{title:"SkyReelsV2DiffusionForcingPipeline",local:"diffusers.SkyReelsV2DiffusionForcingPipeline",headingTag:"h2"}}),sn=new j({props:{name:"class diffusers.SkyReelsV2DiffusionForcingPipeline",anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"transformer",val:": SkyReelsV2Transformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": UniPCMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>UMT5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/skyreels_v2_transformer_3d#diffusers.SkyReelsV2Transformer3DModel">SkyReelsV2Transformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing.py#L129"}}),on=new j({props:{name:"__call__",anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 544"},{name:"width",val:": int = 960"},{name:"num_frames",val:": int = 97"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 6.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"},{name:"overlap_history",val:": typing.Optional[int] = None"},{name:"addnoise_condition",val:": float = 0"},{name:"base_num_frames",val:": int = 97"},{name:"ar_step",val:": int = 0"},{name:"causal_block_size",val:": typing.Optional[int] = None"},{name:"fps",val:": int = 24"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>544</code>) &#x2014;
The height of the generated video.`,name:"height"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>960</code>) &#x2014;
The width of the generated video.`,name:"width"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>97</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>6.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality. (<strong>6.0 for T2V</strong>, <strong>5.0 for I2V</strong>)`,name:"guidance_scale"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>SkyReelsV2PipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length of the prompt.`,name:"max_sequence_length"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.overlap_history",description:`<strong>overlap_history</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of frames to overlap for smooth transitions in long videos. If <code>None</code>, the pipeline assumes
short video generation mode, and no overlap is applied. 17 and 37 are recommended to set.`,name:"overlap_history"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.addnoise_condition",description:`<strong>addnoise_condition</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
This is used to help smooth the long video generation by adding some noise to the clean condition. Too
large noise can cause the inconsistency as well. 20 is a recommended value, and you may try larger
ones, but it is recommended to not exceed 50.`,name:"addnoise_condition"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.base_num_frames",description:`<strong>base_num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to <code>97</code>) &#x2014;
97 or 121 | Base frame count (<strong>97 for 540P</strong>, <strong>121 for 720P</strong>)`,name:"base_num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.ar_step",description:`<strong>ar_step</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Controls asynchronous inference (0 for synchronous mode) You can set <code>ar_step=5</code> to enable asynchronous
inference. When asynchronous inference, <code>causal_block_size=5</code> is recommended while it is not supposed
to be set for synchronous generation. Asynchronous inference will take more steps to diffuse the whole
sequence which means it will be SLOWER than synchronous mode. In our experiments, asynchronous
inference may improve the instruction following and visual consistent performance.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.causal_block_size",description:`<strong>causal_block_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of frames in each block/chunk. Recommended when using asynchronous inference (when ar_step &gt;
0)`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>24</code>) &#x2014;
Frame rate of the generated video`,name:"fps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing.py#L598",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>SkyReelsV2PipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~SkyReelsV2PipelineOutput</code> or <code>tuple</code></p>
`}}),re=new yt({props:{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.__call__.example",$$slots:{default:[Li]},$$scope:{ctx:V}}}),ln=new j({props:{name:"encode_prompt",anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing.py#L219"}}),an=new j({props:{name:"generate_timestep_matrix",anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix",parameters:[{name:"num_latent_frames",val:": int"},{name:"step_template",val:": Tensor"},{name:"base_num_latent_frames",val:": int"},{name:"ar_step",val:": int = 5"},{name:"num_pre_ready",val:": int = 0"},{name:"causal_block_size",val:": int = 1"},{name:"shrink_interval_with_mask",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.num_latent_frames",description:"<strong>num_latent_frames</strong> (int) &#x2014; Total number of latent frames to generate",name:"num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.step_template",description:"<strong>step_template</strong> (torch.Tensor) &#x2014; Base timestep schedule (e.g., [1000, 800, 600, &#x2026;, 0])",name:"step_template"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.base_num_latent_frames",description:"<strong>base_num_latent_frames</strong> (int) &#x2014; Maximum frames the model can process in one forward pass",name:"base_num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.ar_step",description:`<strong>ar_step</strong> (int, optional) &#x2014; Autoregressive step size for temporal lag.
0 = synchronous, &gt;0 = asynchronous. Defaults to 5.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.num_pre_ready",description:`<strong>num_pre_ready</strong> (int, optional) &#x2014;
Number of frames already denoised (e.g., from prefix in a video2video task).
Defaults to 0.`,name:"num_pre_ready"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.causal_block_size",description:`<strong>causal_block_size</strong> (int, optional) &#x2014; Number of frames processed as a causal block.
Defaults to 1.`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingPipeline.generate_timestep_matrix.shrink_interval_with_mask",description:`<strong>shrink_interval_with_mask</strong> (bool, optional) &#x2014; Whether to optimize processing intervals.
Defaults to False.`,name:"shrink_interval_with_mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing.py#L418",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>step_matrix (torch.Tensor): Matrix of timesteps for each frame at each iteration Shape:
[num_iterations, num_latent_frames]</li>
<li>step_index (torch.Tensor): Index matrix for timestep lookup Shape: [num_iterations,
num_latent_frames]</li>
<li>step_update_mask (torch.Tensor): Boolean mask indicating which frames to update Shape:
[num_iterations, num_latent_frames]</li>
<li>valid_interval (list[tuple]): List of (start, end) intervals for each iteration</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>tuple containing</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If ar_step is too small for the given configuration</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),rn=new z({props:{title:"SkyReelsV2DiffusionForcingImageToVideoPipeline",local:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline",headingTag:"h2"}}),cn=new j({props:{name:"class diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline",anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"transformer",val:": SkyReelsV2Transformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": UniPCMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>UMT5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/skyreels_v2_transformer_3d#diffusers.SkyReelsV2Transformer3DModel">SkyReelsV2Transformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_i2v.py#L134"}}),pn=new j({props:{name:"__call__",anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 544"},{name:"width",val:": int = 960"},{name:"num_frames",val:": int = 97"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"last_image",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"},{name:"overlap_history",val:": typing.Optional[int] = None"},{name:"addnoise_condition",val:": float = 0"},{name:"base_num_frames",val:": int = 97"},{name:"ar_step",val:": int = 0"},{name:"causal_block_size",val:": typing.Optional[int] = None"},{name:"fps",val:": int = 24"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>544</code>) &#x2014;
The height of the generated video.`,name:"height"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>960</code>) &#x2014;
The width of the generated video.`,name:"width"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>97</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>5.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality. (<strong>6.0 for T2V</strong>, <strong>5.0 for I2V</strong>)`,name:"guidance_scale"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings. Can be used to easily tweak image inputs (weighting). If not provided,
image embeddings are generated from the <code>image</code> input argument.`,name:"image_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.last_image",description:`<strong>last_image</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings. Can be used to easily tweak image inputs (weighting). If not provided,
image embeddings are generated from the <code>image</code> input argument.`,name:"last_image"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>SkyReelsV2PipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length of the prompt.`,name:"max_sequence_length"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.overlap_history",description:`<strong>overlap_history</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of frames to overlap for smooth transitions in long videos. If <code>None</code>, the pipeline assumes
short video generation mode, and no overlap is applied. 17 and 37 are recommended to set.`,name:"overlap_history"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.addnoise_condition",description:`<strong>addnoise_condition</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
This is used to help smooth the long video generation by adding some noise to the clean condition. Too
large noise can cause the inconsistency as well. 20 is a recommended value, and you may try larger
ones, but it is recommended to not exceed 50.`,name:"addnoise_condition"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.base_num_frames",description:`<strong>base_num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to <code>97</code>) &#x2014;
97 or 121 | Base frame count (<strong>97 for 540P</strong>, <strong>121 for 720P</strong>)`,name:"base_num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.ar_step",description:`<strong>ar_step</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Controls asynchronous inference (0 for synchronous mode) You can set <code>ar_step=5</code> to enable asynchronous
inference. When asynchronous inference, <code>causal_block_size=5</code> is recommended while it is not supposed
to be set for synchronous generation. Asynchronous inference will take more steps to diffuse the whole
sequence which means it will be SLOWER than synchronous mode. In our experiments, asynchronous
inference may improve the instruction following and visual consistent performance.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.causal_block_size",description:`<strong>causal_block_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of frames in each block/chunk. Recommended when using asynchronous inference (when ar_step &gt;
0)`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>24</code>) &#x2014;
Frame rate of the generated video`,name:"fps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_i2v.py#L644",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>SkyReelsV2PipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~SkyReelsV2PipelineOutput</code> or <code>tuple</code></p>
`}}),pe=new yt({props:{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.__call__.example",$$slots:{default:[Yi]},$$scope:{ctx:V}}}),dn=new j({props:{name:"encode_prompt",anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_i2v.py#L224"}}),mn=new j({props:{name:"generate_timestep_matrix",anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix",parameters:[{name:"num_latent_frames",val:": int"},{name:"step_template",val:": Tensor"},{name:"base_num_latent_frames",val:": int"},{name:"ar_step",val:": int = 5"},{name:"num_pre_ready",val:": int = 0"},{name:"causal_block_size",val:": int = 1"},{name:"shrink_interval_with_mask",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.num_latent_frames",description:"<strong>num_latent_frames</strong> (int) &#x2014; Total number of latent frames to generate",name:"num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.step_template",description:"<strong>step_template</strong> (torch.Tensor) &#x2014; Base timestep schedule (e.g., [1000, 800, 600, &#x2026;, 0])",name:"step_template"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.base_num_latent_frames",description:"<strong>base_num_latent_frames</strong> (int) &#x2014; Maximum frames the model can process in one forward pass",name:"base_num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.ar_step",description:`<strong>ar_step</strong> (int, optional) &#x2014; Autoregressive step size for temporal lag.
0 = synchronous, &gt;0 = asynchronous. Defaults to 5.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.num_pre_ready",description:`<strong>num_pre_ready</strong> (int, optional) &#x2014;
Number of frames already denoised (e.g., from prefix in a video2video task).
Defaults to 0.`,name:"num_pre_ready"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.causal_block_size",description:`<strong>causal_block_size</strong> (int, optional) &#x2014; Number of frames processed as a causal block.
Defaults to 1.`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline.generate_timestep_matrix.shrink_interval_with_mask",description:`<strong>shrink_interval_with_mask</strong> (bool, optional) &#x2014; Whether to optimize processing intervals.
Defaults to False.`,name:"shrink_interval_with_mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_i2v.py#L464",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>step_matrix (torch.Tensor): Matrix of timesteps for each frame at each iteration Shape:
[num_iterations, num_latent_frames]</li>
<li>step_index (torch.Tensor): Index matrix for timestep lookup Shape: [num_iterations,
num_latent_frames]</li>
<li>step_update_mask (torch.Tensor): Boolean mask indicating which frames to update Shape:
[num_iterations, num_latent_frames]</li>
<li>valid_interval (list[tuple]): List of (start, end) intervals for each iteration</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>tuple containing</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If ar_step is too small for the given configuration</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),fn=new z({props:{title:"SkyReelsV2DiffusionForcingVideoToVideoPipeline",local:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline",headingTag:"h2"}}),gn=new j({props:{name:"class diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline",anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"transformer",val:": SkyReelsV2Transformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": UniPCMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>UMT5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/skyreels_v2_transformer_3d#diffusers.SkyReelsV2Transformer3DModel">SkyReelsV2Transformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_v2v.py#L190"}}),un=new j({props:{name:"__call__",anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__",parameters:[{name:"video",val:": typing.List[PIL.Image.Image]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 544"},{name:"width",val:": int = 960"},{name:"num_frames",val:": int = 120"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 6.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"},{name:"overlap_history",val:": typing.Optional[int] = None"},{name:"addnoise_condition",val:": float = 0"},{name:"base_num_frames",val:": int = 97"},{name:"ar_step",val:": int = 0"},{name:"causal_block_size",val:": typing.Optional[int] = None"},{name:"fps",val:": int = 24"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.video",description:`<strong>video</strong> (<code>List[Image.Image]</code>) &#x2014;
The video to guide the video generation.`,name:"video"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the video generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the video generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>544</code>) &#x2014;
The height of the generated video.`,name:"height"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>960</code>) &#x2014;
The width of the generated video.`,name:"width"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>120</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>6.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality. (<strong>6.0 for T2V</strong>, <strong>5.0 for I2V</strong>)`,name:"guidance_scale"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>SkyReelsV2PipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length of the prompt.`,name:"max_sequence_length"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.overlap_history",description:`<strong>overlap_history</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of frames to overlap for smooth transitions in long videos. If <code>None</code>, the pipeline assumes
short video generation mode, and no overlap is applied. 17 and 37 are recommended to set.`,name:"overlap_history"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.addnoise_condition",description:`<strong>addnoise_condition</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
This is used to help smooth the long video generation by adding some noise to the clean condition. Too
large noise can cause the inconsistency as well. 20 is a recommended value, and you may try larger
ones, but it is recommended to not exceed 50.`,name:"addnoise_condition"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.base_num_frames",description:`<strong>base_num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to <code>97</code>) &#x2014;
97 or 121 | Base frame count (<strong>97 for 540P</strong>, <strong>121 for 720P</strong>)`,name:"base_num_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.ar_step",description:`<strong>ar_step</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Controls asynchronous inference (0 for synchronous mode) You can set <code>ar_step=5</code> to enable asynchronous
inference. When asynchronous inference, <code>causal_block_size=5</code> is recommended while it is not supposed
to be set for synchronous generation. Asynchronous inference will take more steps to diffuse the whole
sequence which means it will be SLOWER than synchronous mode. In our experiments, asynchronous
inference may improve the instruction following and visual consistent performance.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.causal_block_size",description:`<strong>causal_block_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of frames in each block/chunk. Recommended when using asynchronous inference (when ar_step &gt;
0)`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.fps",description:`<strong>fps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>24</code>) &#x2014;
Frame rate of the generated video`,name:"fps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_v2v.py#L682",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>SkyReelsV2PipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~SkyReelsV2PipelineOutput</code> or <code>tuple</code></p>
`}}),me=new yt({props:{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.__call__.example",$$slots:{default:[Hi]},$$scope:{ctx:V}}}),Mn=new j({props:{name:"encode_prompt",anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_v2v.py#L280"}}),yn=new j({props:{name:"generate_timestep_matrix",anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix",parameters:[{name:"num_latent_frames",val:": int"},{name:"step_template",val:": Tensor"},{name:"base_num_latent_frames",val:": int"},{name:"ar_step",val:": int = 5"},{name:"num_pre_ready",val:": int = 0"},{name:"causal_block_size",val:": int = 1"},{name:"shrink_interval_with_mask",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.num_latent_frames",description:"<strong>num_latent_frames</strong> (int) &#x2014; Total number of latent frames to generate",name:"num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.step_template",description:"<strong>step_template</strong> (torch.Tensor) &#x2014; Base timestep schedule (e.g., [1000, 800, 600, &#x2026;, 0])",name:"step_template"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.base_num_latent_frames",description:"<strong>base_num_latent_frames</strong> (int) &#x2014; Maximum frames the model can process in one forward pass",name:"base_num_latent_frames"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.ar_step",description:`<strong>ar_step</strong> (int, optional) &#x2014; Autoregressive step size for temporal lag.
0 = synchronous, &gt;0 = asynchronous. Defaults to 5.`,name:"ar_step"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.num_pre_ready",description:`<strong>num_pre_ready</strong> (int, optional) &#x2014;
Number of frames already denoised (e.g., from prefix in a video2video task).
Defaults to 0.`,name:"num_pre_ready"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.causal_block_size",description:`<strong>causal_block_size</strong> (int, optional) &#x2014; Number of frames processed as a causal block.
Defaults to 1.`,name:"causal_block_size"},{anchor:"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline.generate_timestep_matrix.shrink_interval_with_mask",description:`<strong>shrink_interval_with_mask</strong> (bool, optional) &#x2014; Whether to optimize processing intervals.
Defaults to False.`,name:"shrink_interval_with_mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_diffusion_forcing_v2v.py#L502",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>step_matrix (torch.Tensor): Matrix of timesteps for each frame at each iteration Shape:
[num_iterations, num_latent_frames]</li>
<li>step_index (torch.Tensor): Index matrix for timestep lookup Shape: [num_iterations,
num_latent_frames]</li>
<li>step_update_mask (torch.Tensor): Boolean mask indicating which frames to update Shape:
[num_iterations, num_latent_frames]</li>
<li>valid_interval (list[tuple]): List of (start, end) intervals for each iteration</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>tuple containing</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If ar_step is too small for the given configuration</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),hn=new z({props:{title:"SkyReelsV2Pipeline",local:"diffusers.SkyReelsV2Pipeline",headingTag:"h2"}}),Tn=new j({props:{name:"class diffusers.SkyReelsV2Pipeline",anchor:"diffusers.SkyReelsV2Pipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"transformer",val:": SkyReelsV2Transformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": UniPCMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.SkyReelsV2Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.SkyReelsV2Pipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/skyreels_v2_transformer_3d#diffusers.SkyReelsV2Transformer3DModel">SkyReelsV2Transformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the input latents.`,name:"transformer"},{anchor:"diffusers.SkyReelsV2Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.SkyReelsV2Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2.py#L107"}}),Un=new j({props:{name:"__call__",anchor:"diffusers.SkyReelsV2Pipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 544"},{name:"width",val:": int = 960"},{name:"num_frames",val:": int = 97"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 6.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>544</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>960</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>97</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>6.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>SkyReelsV2PipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SkyReelsV2Pipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length for the text encoder.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2.py#L376",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>SkyReelsV2PipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~SkyReelsV2PipelineOutput</code> or <code>tuple</code></p>
`}}),ge=new yt({props:{anchor:"diffusers.SkyReelsV2Pipeline.__call__.example",$$slots:{default:[Oi]},$$scope:{ctx:V}}}),_n=new j({props:{name:"encode_prompt",anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.SkyReelsV2Pipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2.py#L197"}}),Jn=new z({props:{title:"SkyReelsV2ImageToVideoPipeline",local:"diffusers.SkyReelsV2ImageToVideoPipeline",headingTag:"h2"}}),wn=new j({props:{name:"class diffusers.SkyReelsV2ImageToVideoPipeline",anchor:"diffusers.SkyReelsV2ImageToVideoPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_processor",val:": CLIPProcessor"},{name:"transformer",val:": SkyReelsV2Transformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": UniPCMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://github.com/mlfoundations/open_clip/blob/main/docs/PRETRAINED.md#vit-h14-xlm-roberta-large" rel="nofollow">clip-vit-huge-patch14</a>
variant.`,name:"image_encoder"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/skyreels_v2_transformer_3d#diffusers.SkyReelsV2Transformer3DModel">SkyReelsV2Transformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the input latents.`,name:"transformer"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_i2v.py#L127"}}),Vn=new j({props:{name:"__call__",anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 544"},{name:"width",val:": int = 960"},{name:"num_frames",val:": int = 97"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"last_image",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>544</code>) &#x2014;
The height of the generated video.`,name:"height"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>960</code>) &#x2014;
The width of the generated video.`,name:"width"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>97</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>5.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings. Can be used to easily tweak image inputs (weighting). If not provided,
image embeddings are generated from the <code>image</code> input argument.`,name:"image_embeds"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>WanPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length of the prompt.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_i2v.py#L476",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>SkyReelsV2PipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~SkyReelsV2PipelineOutput</code> or <code>tuple</code></p>
`}}),Me=new yt({props:{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.__call__.example",$$slots:{default:[qi]},$$scope:{ctx:V}}}),bn=new j({props:{name:"encode_prompt",anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.SkyReelsV2ImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_skyreels_v2_i2v.py#L238"}}),kn=new z({props:{title:"SkyReelsV2PipelineOutput",local:"diffusers.pipelines.skyreels_v2.pipeline_output.SkyReelsV2PipelineOutput",headingTag:"h2"}}),jn=new j({props:{name:"class diffusers.pipelines.skyreels_v2.pipeline_output.SkyReelsV2PipelineOutput",anchor:"diffusers.pipelines.skyreels_v2.pipeline_output.SkyReelsV2PipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.skyreels_v2.pipeline_output.SkyReelsV2PipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/skyreels_v2/pipeline_output.py#L9"}}),Cn=new Ai({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/skyreels_v2.md"}}),{c(){a=c("meta"),_=s(),d=c("p"),m=s(),U=c("div"),U.innerHTML=r,J=s(),g(E.$$.fragment),ee=s(),x=c("p"),x.innerHTML=Te,w=s(),S=c("p"),S.innerHTML=ko,ht=s(),Ue=c("p"),Ue.innerHTML=jo,Tt=s(),_e=c("p"),_e.textContent=Co,Ut=s(),Je=c("ul"),Je.innerHTML=Io,_t=s(),oe=c("blockquote"),oe.innerHTML=vo,Jt=s(),g(we.$$.fragment),wt=s(),Ve=c("p"),Ve.textContent=Bo,Vt=s(),be=c("ul"),be.innerHTML=Ro,bt=s(),ke=c("p"),ke.innerHTML=No,kt=s(),je=c("p"),je.innerHTML=xo,jt=s(),Ce=c("p"),Ce.innerHTML=So,Ct=s(),Ie=c("p"),Ie.innerHTML=Zo,It=s(),ve=c("p"),ve.textContent=Fo,vt=s(),g(Be.$$.fragment),Bt=s(),Re=c("p"),Re.innerHTML=Go,Rt=s(),Ne=c("p"),Ne.innerHTML=Do,Nt=s(),g(xe.$$.fragment),xt=s(),Se=c("p"),Se.innerHTML=Wo,St=s(),Ze=c("ol"),Ze.innerHTML=Ao,Zt=s(),Fe=c("p"),Fe.innerHTML=Po,Ft=s(),Ge=c("p"),Ge.innerHTML=Qo,Gt=s(),g(De.$$.fragment),Dt=s(),We=c("p"),We.innerHTML=$o,Wt=s(),Ae=c("p"),Ae.innerHTML=zo,At=s(),g(Pe.$$.fragment),Pt=s(),Qe=c("p"),Qe.innerHTML=Eo,Qt=s(),g($e.$$.fragment),$t=s(),ze=c("p"),ze.innerHTML=Xo,zt=s(),g(Ee.$$.fragment),Et=s(),Xe=c("p"),Xe.innerHTML=Lo,Xt=s(),g(Le.$$.fragment),Lt=s(),Ye=c("p"),Ye.textContent=Yo,Yt=s(),g(ie.$$.fragment),Ht=s(),g(He.$$.fragment),Ot=s(),Oe=c("p"),Oe.textContent=Ho,qt=s(),g(le.$$.fragment),Kt=s(),g(qe.$$.fragment),es=s(),g(ae.$$.fragment),ns=s(),g(Ke.$$.fragment),ts=s(),en=c("ul"),en.innerHTML=Oo,ss=s(),nn=c("p"),nn.innerHTML=qo,os=s(),g(tn.$$.fragment),is=s(),C=c("div"),g(sn.$$.fragment),ws=s(),Bn=c("p"),Bn.textContent=Ko,Vs=s(),Rn=c("p"),Rn.innerHTML=ei,bs=s(),X=c("div"),g(on.$$.fragment),ks=s(),Nn=c("p"),Nn.textContent=ni,js=s(),g(re.$$.fragment),Cs=s(),ce=c("div"),g(ln.$$.fragment),Is=s(),xn=c("p"),xn.textContent=ti,vs=s(),B=c("div"),g(an.$$.fragment),Bs=s(),Sn=c("p"),Sn.textContent=si,Rs=s(),Zn=c("p"),Zn.innerHTML=oi,Ns=s(),Fn=c("ul"),Fn.innerHTML=ii,xs=s(),Gn=c("p"),Gn.innerHTML=li,Ss=s(),Dn=c("ul"),Dn.innerHTML=ai,ls=s(),g(rn.$$.fragment),as=s(),I=c("div"),g(cn.$$.fragment),Zs=s(),Wn=c("p"),Wn.textContent=ri,Fs=s(),An=c("p"),An.innerHTML=ci,Gs=s(),L=c("div"),g(pn.$$.fragment),Ds=s(),Pn=c("p"),Pn.textContent=pi,Ws=s(),g(pe.$$.fragment),As=s(),de=c("div"),g(dn.$$.fragment),Ps=s(),Qn=c("p"),Qn.textContent=di,Qs=s(),R=c("div"),g(mn.$$.fragment),$s=s(),$n=c("p"),$n.textContent=mi,zs=s(),zn=c("p"),zn.innerHTML=fi,Es=s(),En=c("ul"),En.innerHTML=gi,Xs=s(),Xn=c("p"),Xn.innerHTML=ui,Ls=s(),Ln=c("ul"),Ln.innerHTML=Mi,rs=s(),g(fn.$$.fragment),cs=s(),v=c("div"),g(gn.$$.fragment),Ys=s(),Yn=c("p"),Yn.textContent=yi,Hs=s(),Hn=c("p"),Hn.innerHTML=hi,Os=s(),Y=c("div"),g(un.$$.fragment),qs=s(),On=c("p"),On.textContent=Ti,Ks=s(),g(me.$$.fragment),eo=s(),fe=c("div"),g(Mn.$$.fragment),no=s(),qn=c("p"),qn.textContent=Ui,to=s(),N=c("div"),g(yn.$$.fragment),so=s(),Kn=c("p"),Kn.textContent=_i,oo=s(),et=c("p"),et.innerHTML=Ji,io=s(),nt=c("ul"),nt.innerHTML=wi,lo=s(),tt=c("p"),tt.innerHTML=Vi,ao=s(),st=c("ul"),st.innerHTML=bi,ps=s(),g(hn.$$.fragment),ds=s(),Z=c("div"),g(Tn.$$.fragment),ro=s(),ot=c("p"),ot.textContent=ki,co=s(),it=c("p"),it.innerHTML=ji,po=s(),H=c("div"),g(Un.$$.fragment),mo=s(),lt=c("p"),lt.textContent=Ci,fo=s(),g(ge.$$.fragment),go=s(),ue=c("div"),g(_n.$$.fragment),uo=s(),at=c("p"),at.textContent=Ii,ms=s(),g(Jn.$$.fragment),fs=s(),F=c("div"),g(wn.$$.fragment),Mo=s(),rt=c("p"),rt.textContent=vi,yo=s(),ct=c("p"),ct.innerHTML=Bi,ho=s(),O=c("div"),g(Vn.$$.fragment),To=s(),pt=c("p"),pt.textContent=Ri,Uo=s(),g(Me.$$.fragment),_o=s(),ye=c("div"),g(bn.$$.fragment),Jo=s(),dt=c("p"),dt.textContent=Ni,gs=s(),g(kn.$$.fragment),us=s(),ne=c("div"),g(jn.$$.fragment),wo=s(),mt=c("p"),mt.textContent=xi,Ms=s(),g(Cn.$$.fragment),ys=s(),Mt=c("p"),this.h()},l(e){const n=Di("svelte-u9bgzb",document.head);a=p(n,"META",{name:!0,content:!0}),n.forEach(t),_=o(e),d=p(e,"P",{}),k(d).forEach(t),m=o(e),U=p(e,"DIV",{style:!0,"data-svelte-h":!0}),f(U)!=="svelte-p206qu"&&(U.innerHTML=r),J=o(e),u(E.$$.fragment,e),ee=o(e),x=p(e,"P",{"data-svelte-h":!0}),f(x)!=="svelte-hhnr6l"&&(x.innerHTML=Te),w=o(e),S=p(e,"P",{"data-svelte-h":!0}),f(S)!=="svelte-1c5qzxt"&&(S.innerHTML=ko),ht=o(e),Ue=p(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-13rq768"&&(Ue.innerHTML=jo),Tt=o(e),_e=p(e,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-1sx0tsf"&&(_e.textContent=Co),Ut=o(e),Je=p(e,"UL",{"data-svelte-h":!0}),f(Je)!=="svelte-1pl0ztn"&&(Je.innerHTML=Io),_t=o(e),oe=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(oe)!=="svelte-p4dosb"&&(oe.innerHTML=vo),Jt=o(e),u(we.$$.fragment,e),wt=o(e),Ve=p(e,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-89a5s6"&&(Ve.textContent=Bo),Vt=o(e),be=p(e,"UL",{"data-svelte-h":!0}),f(be)!=="svelte-1pxziyj"&&(be.innerHTML=Ro),bt=o(e),ke=p(e,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-za8iqa"&&(ke.innerHTML=No),kt=o(e),je=p(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-jaydp3"&&(je.innerHTML=xo),jt=o(e),Ce=p(e,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-1ku25c0"&&(Ce.innerHTML=So),Ct=o(e),Ie=p(e,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-iv3qu2"&&(Ie.innerHTML=Zo),It=o(e),ve=p(e,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-14dbvjk"&&(ve.textContent=Fo),vt=o(e),u(Be.$$.fragment,e),Bt=o(e),Re=p(e,"P",{"data-svelte-h":!0}),f(Re)!=="svelte-s7ojta"&&(Re.innerHTML=Go),Rt=o(e),Ne=p(e,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-15yo7wx"&&(Ne.innerHTML=Do),Nt=o(e),u(xe.$$.fragment,e),xt=o(e),Se=p(e,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-11xr8hl"&&(Se.innerHTML=Wo),St=o(e),Ze=p(e,"OL",{"data-svelte-h":!0}),f(Ze)!=="svelte-k7kohv"&&(Ze.innerHTML=Ao),Zt=o(e),Fe=p(e,"P",{"data-svelte-h":!0}),f(Fe)!=="svelte-ka0mvq"&&(Fe.innerHTML=Po),Ft=o(e),Ge=p(e,"P",{"data-svelte-h":!0}),f(Ge)!=="svelte-1ll9tbz"&&(Ge.innerHTML=Qo),Gt=o(e),u(De.$$.fragment,e),Dt=o(e),We=p(e,"P",{"data-svelte-h":!0}),f(We)!=="svelte-1qkv5lm"&&(We.innerHTML=$o),Wt=o(e),Ae=p(e,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-635rvz"&&(Ae.innerHTML=zo),At=o(e),u(Pe.$$.fragment,e),Pt=o(e),Qe=p(e,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-187v3kf"&&(Qe.innerHTML=Eo),Qt=o(e),u($e.$$.fragment,e),$t=o(e),ze=p(e,"P",{"data-svelte-h":!0}),f(ze)!=="svelte-1h5w8f9"&&(ze.innerHTML=Xo),zt=o(e),u(Ee.$$.fragment,e),Et=o(e),Xe=p(e,"P",{"data-svelte-h":!0}),f(Xe)!=="svelte-1aim5iw"&&(Xe.innerHTML=Lo),Xt=o(e),u(Le.$$.fragment,e),Lt=o(e),Ye=p(e,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-1r97o0s"&&(Ye.textContent=Yo),Yt=o(e),u(ie.$$.fragment,e),Ht=o(e),u(He.$$.fragment,e),Ot=o(e),Oe=p(e,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-1jq7n9p"&&(Oe.textContent=Ho),qt=o(e),u(le.$$.fragment,e),Kt=o(e),u(qe.$$.fragment,e),es=o(e),u(ae.$$.fragment,e),ns=o(e),u(Ke.$$.fragment,e),ts=o(e),en=p(e,"UL",{"data-svelte-h":!0}),f(en)!=="svelte-1imizmo"&&(en.innerHTML=Oo),ss=o(e),nn=p(e,"P",{"data-svelte-h":!0}),f(nn)!=="svelte-ffypgq"&&(nn.innerHTML=qo),os=o(e),u(tn.$$.fragment,e),is=o(e),C=p(e,"DIV",{class:!0});var G=k(C);u(sn.$$.fragment,G),ws=o(G),Bn=p(G,"P",{"data-svelte-h":!0}),f(Bn)!=="svelte-12nzcfd"&&(Bn.textContent=Ko),Vs=o(G),Rn=p(G,"P",{"data-svelte-h":!0}),f(Rn)!=="svelte-6i98ox"&&(Rn.innerHTML=ei),bs=o(G),X=p(G,"DIV",{class:!0});var te=k(X);u(on.$$.fragment,te),ks=o(te),Nn=p(te,"P",{"data-svelte-h":!0}),f(Nn)!=="svelte-50j04k"&&(Nn.textContent=ni),js=o(te),u(re.$$.fragment,te),te.forEach(t),Cs=o(G),ce=p(G,"DIV",{class:!0});var In=k(ce);u(ln.$$.fragment,In),Is=o(In),xn=p(In,"P",{"data-svelte-h":!0}),f(xn)!=="svelte-16q0ax1"&&(xn.textContent=ti),In.forEach(t),vs=o(G),B=p(G,"DIV",{class:!0});var D=k(B);u(an.$$.fragment,D),Bs=o(D),Sn=p(D,"P",{"data-svelte-h":!0}),f(Sn)!=="svelte-z0hkxd"&&(Sn.textContent=si),Rs=o(D),Zn=p(D,"P",{"data-svelte-h":!0}),f(Zn)!=="svelte-786r5s"&&(Zn.innerHTML=oi),Ns=o(D),Fn=p(D,"UL",{"data-svelte-h":!0}),f(Fn)!=="svelte-1vavexb"&&(Fn.innerHTML=ii),xs=o(D),Gn=p(D,"P",{"data-svelte-h":!0}),f(Gn)!=="svelte-1is40lv"&&(Gn.innerHTML=li),Ss=o(D),Dn=p(D,"UL",{"data-svelte-h":!0}),f(Dn)!=="svelte-12cwzsb"&&(Dn.innerHTML=ai),D.forEach(t),G.forEach(t),ls=o(e),u(rn.$$.fragment,e),as=o(e),I=p(e,"DIV",{class:!0});var W=k(I);u(cn.$$.fragment,W),Zs=o(W),Wn=p(W,"P",{"data-svelte-h":!0}),f(Wn)!=="svelte-1db0cne"&&(Wn.textContent=ri),Fs=o(W),An=p(W,"P",{"data-svelte-h":!0}),f(An)!=="svelte-6i98ox"&&(An.innerHTML=ci),Gs=o(W),L=p(W,"DIV",{class:!0});var se=k(L);u(pn.$$.fragment,se),Ds=o(se),Pn=p(se,"P",{"data-svelte-h":!0}),f(Pn)!=="svelte-50j04k"&&(Pn.textContent=pi),Ws=o(se),u(pe.$$.fragment,se),se.forEach(t),As=o(W),de=p(W,"DIV",{class:!0});var vn=k(de);u(dn.$$.fragment,vn),Ps=o(vn),Qn=p(vn,"P",{"data-svelte-h":!0}),f(Qn)!=="svelte-16q0ax1"&&(Qn.textContent=di),vn.forEach(t),Qs=o(W),R=p(W,"DIV",{class:!0});var A=k(R);u(mn.$$.fragment,A),$s=o(A),$n=p(A,"P",{"data-svelte-h":!0}),f($n)!=="svelte-z0hkxd"&&($n.textContent=mi),zs=o(A),zn=p(A,"P",{"data-svelte-h":!0}),f(zn)!=="svelte-786r5s"&&(zn.innerHTML=fi),Es=o(A),En=p(A,"UL",{"data-svelte-h":!0}),f(En)!=="svelte-1vavexb"&&(En.innerHTML=gi),Xs=o(A),Xn=p(A,"P",{"data-svelte-h":!0}),f(Xn)!=="svelte-1is40lv"&&(Xn.innerHTML=ui),Ls=o(A),Ln=p(A,"UL",{"data-svelte-h":!0}),f(Ln)!=="svelte-12cwzsb"&&(Ln.innerHTML=Mi),A.forEach(t),W.forEach(t),rs=o(e),u(fn.$$.fragment,e),cs=o(e),v=p(e,"DIV",{class:!0});var Q=k(v);u(gn.$$.fragment,Q),Ys=o(Q),Yn=p(Q,"P",{"data-svelte-h":!0}),f(Yn)!=="svelte-dtd97b"&&(Yn.textContent=yi),Hs=o(Q),Hn=p(Q,"P",{"data-svelte-h":!0}),f(Hn)!=="svelte-6i98ox"&&(Hn.innerHTML=hi),Os=o(Q),Y=p(Q,"DIV",{class:!0});var ft=k(Y);u(un.$$.fragment,ft),qs=o(ft),On=p(ft,"P",{"data-svelte-h":!0}),f(On)!=="svelte-50j04k"&&(On.textContent=Ti),Ks=o(ft),u(me.$$.fragment,ft),ft.forEach(t),eo=o(Q),fe=p(Q,"DIV",{class:!0});var Ts=k(fe);u(Mn.$$.fragment,Ts),no=o(Ts),qn=p(Ts,"P",{"data-svelte-h":!0}),f(qn)!=="svelte-16q0ax1"&&(qn.textContent=Ui),Ts.forEach(t),to=o(Q),N=p(Q,"DIV",{class:!0});var $=k(N);u(yn.$$.fragment,$),so=o($),Kn=p($,"P",{"data-svelte-h":!0}),f(Kn)!=="svelte-z0hkxd"&&(Kn.textContent=_i),oo=o($),et=p($,"P",{"data-svelte-h":!0}),f(et)!=="svelte-786r5s"&&(et.innerHTML=Ji),io=o($),nt=p($,"UL",{"data-svelte-h":!0}),f(nt)!=="svelte-1vavexb"&&(nt.innerHTML=wi),lo=o($),tt=p($,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-1is40lv"&&(tt.innerHTML=Vi),ao=o($),st=p($,"UL",{"data-svelte-h":!0}),f(st)!=="svelte-12cwzsb"&&(st.innerHTML=bi),$.forEach(t),Q.forEach(t),ps=o(e),u(hn.$$.fragment,e),ds=o(e),Z=p(e,"DIV",{class:!0});var q=k(Z);u(Tn.$$.fragment,q),ro=o(q),ot=p(q,"P",{"data-svelte-h":!0}),f(ot)!=="svelte-ucmptk"&&(ot.textContent=ki),co=o(q),it=p(q,"P",{"data-svelte-h":!0}),f(it)!=="svelte-496sm0"&&(it.innerHTML=ji),po=o(q),H=p(q,"DIV",{class:!0});var gt=k(H);u(Un.$$.fragment,gt),mo=o(gt),lt=p(gt,"P",{"data-svelte-h":!0}),f(lt)!=="svelte-50j04k"&&(lt.textContent=Ci),fo=o(gt),u(ge.$$.fragment,gt),gt.forEach(t),go=o(q),ue=p(q,"DIV",{class:!0});var Us=k(ue);u(_n.$$.fragment,Us),uo=o(Us),at=p(Us,"P",{"data-svelte-h":!0}),f(at)!=="svelte-16q0ax1"&&(at.textContent=Ii),Us.forEach(t),q.forEach(t),ms=o(e),u(Jn.$$.fragment,e),fs=o(e),F=p(e,"DIV",{class:!0});var K=k(F);u(wn.$$.fragment,K),Mo=o(K),rt=p(K,"P",{"data-svelte-h":!0}),f(rt)!=="svelte-1kjb4l1"&&(rt.textContent=vi),yo=o(K),ct=p(K,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-496sm0"&&(ct.innerHTML=Bi),ho=o(K),O=p(K,"DIV",{class:!0});var ut=k(O);u(Vn.$$.fragment,ut),To=o(ut),pt=p(ut,"P",{"data-svelte-h":!0}),f(pt)!=="svelte-50j04k"&&(pt.textContent=Ri),Uo=o(ut),u(Me.$$.fragment,ut),ut.forEach(t),_o=o(K),ye=p(K,"DIV",{class:!0});var _s=k(ye);u(bn.$$.fragment,_s),Jo=o(_s),dt=p(_s,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-16q0ax1"&&(dt.textContent=Ni),_s.forEach(t),K.forEach(t),gs=o(e),u(kn.$$.fragment,e),us=o(e),ne=p(e,"DIV",{class:!0});var Js=k(ne);u(jn.$$.fragment,Js),wo=o(Js),mt=p(Js,"P",{"data-svelte-h":!0}),f(mt)!=="svelte-1gu515t"&&(mt.textContent=xi),Js.forEach(t),Ms=o(e),u(Cn.$$.fragment,e),ys=o(e),Mt=p(e,"P",{}),k(Mt).forEach(t),this.h()},h(){b(a,"name","hf:doc:metadata"),b(a,"content",el),Wi(U,"float","right"),b(oe,"class","tip"),b(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){l(document.head,a),i(e,_,n),i(e,d,n),i(e,m,n),i(e,U,n),i(e,J,n),M(E,e,n),i(e,ee,n),i(e,x,n),i(e,w,n),i(e,S,n),i(e,ht,n),i(e,Ue,n),i(e,Tt,n),i(e,_e,n),i(e,Ut,n),i(e,Je,n),i(e,_t,n),i(e,oe,n),i(e,Jt,n),M(we,e,n),i(e,wt,n),i(e,Ve,n),i(e,Vt,n),i(e,be,n),i(e,bt,n),i(e,ke,n),i(e,kt,n),i(e,je,n),i(e,jt,n),i(e,Ce,n),i(e,Ct,n),i(e,Ie,n),i(e,It,n),i(e,ve,n),i(e,vt,n),M(Be,e,n),i(e,Bt,n),i(e,Re,n),i(e,Rt,n),i(e,Ne,n),i(e,Nt,n),M(xe,e,n),i(e,xt,n),i(e,Se,n),i(e,St,n),i(e,Ze,n),i(e,Zt,n),i(e,Fe,n),i(e,Ft,n),i(e,Ge,n),i(e,Gt,n),M(De,e,n),i(e,Dt,n),i(e,We,n),i(e,Wt,n),i(e,Ae,n),i(e,At,n),M(Pe,e,n),i(e,Pt,n),i(e,Qe,n),i(e,Qt,n),M($e,e,n),i(e,$t,n),i(e,ze,n),i(e,zt,n),M(Ee,e,n),i(e,Et,n),i(e,Xe,n),i(e,Xt,n),M(Le,e,n),i(e,Lt,n),i(e,Ye,n),i(e,Yt,n),M(ie,e,n),i(e,Ht,n),M(He,e,n),i(e,Ot,n),i(e,Oe,n),i(e,qt,n),M(le,e,n),i(e,Kt,n),M(qe,e,n),i(e,es,n),M(ae,e,n),i(e,ns,n),M(Ke,e,n),i(e,ts,n),i(e,en,n),i(e,ss,n),i(e,nn,n),i(e,os,n),M(tn,e,n),i(e,is,n),i(e,C,n),M(sn,C,null),l(C,ws),l(C,Bn),l(C,Vs),l(C,Rn),l(C,bs),l(C,X),M(on,X,null),l(X,ks),l(X,Nn),l(X,js),M(re,X,null),l(C,Cs),l(C,ce),M(ln,ce,null),l(ce,Is),l(ce,xn),l(C,vs),l(C,B),M(an,B,null),l(B,Bs),l(B,Sn),l(B,Rs),l(B,Zn),l(B,Ns),l(B,Fn),l(B,xs),l(B,Gn),l(B,Ss),l(B,Dn),i(e,ls,n),M(rn,e,n),i(e,as,n),i(e,I,n),M(cn,I,null),l(I,Zs),l(I,Wn),l(I,Fs),l(I,An),l(I,Gs),l(I,L),M(pn,L,null),l(L,Ds),l(L,Pn),l(L,Ws),M(pe,L,null),l(I,As),l(I,de),M(dn,de,null),l(de,Ps),l(de,Qn),l(I,Qs),l(I,R),M(mn,R,null),l(R,$s),l(R,$n),l(R,zs),l(R,zn),l(R,Es),l(R,En),l(R,Xs),l(R,Xn),l(R,Ls),l(R,Ln),i(e,rs,n),M(fn,e,n),i(e,cs,n),i(e,v,n),M(gn,v,null),l(v,Ys),l(v,Yn),l(v,Hs),l(v,Hn),l(v,Os),l(v,Y),M(un,Y,null),l(Y,qs),l(Y,On),l(Y,Ks),M(me,Y,null),l(v,eo),l(v,fe),M(Mn,fe,null),l(fe,no),l(fe,qn),l(v,to),l(v,N),M(yn,N,null),l(N,so),l(N,Kn),l(N,oo),l(N,et),l(N,io),l(N,nt),l(N,lo),l(N,tt),l(N,ao),l(N,st),i(e,ps,n),M(hn,e,n),i(e,ds,n),i(e,Z,n),M(Tn,Z,null),l(Z,ro),l(Z,ot),l(Z,co),l(Z,it),l(Z,po),l(Z,H),M(Un,H,null),l(H,mo),l(H,lt),l(H,fo),M(ge,H,null),l(Z,go),l(Z,ue),M(_n,ue,null),l(ue,uo),l(ue,at),i(e,ms,n),M(Jn,e,n),i(e,fs,n),i(e,F,n),M(wn,F,null),l(F,Mo),l(F,rt),l(F,yo),l(F,ct),l(F,ho),l(F,O),M(Vn,O,null),l(O,To),l(O,pt),l(O,Uo),M(Me,O,null),l(F,_o),l(F,ye),M(bn,ye,null),l(ye,Jo),l(ye,dt),i(e,gs,n),M(kn,e,n),i(e,us,n),i(e,ne,n),M(jn,ne,null),l(ne,wo),l(ne,mt),i(e,Ms,n),M(Cn,e,n),i(e,ys,n),i(e,Mt,n),hs=!0},p(e,[n]){const G={};n&2&&(G.$$scope={dirty:n,ctx:e}),ie.$set(G);const te={};n&2&&(te.$$scope={dirty:n,ctx:e}),le.$set(te);const In={};n&2&&(In.$$scope={dirty:n,ctx:e}),ae.$set(In);const D={};n&2&&(D.$$scope={dirty:n,ctx:e}),re.$set(D);const W={};n&2&&(W.$$scope={dirty:n,ctx:e}),pe.$set(W);const se={};n&2&&(se.$$scope={dirty:n,ctx:e}),me.$set(se);const vn={};n&2&&(vn.$$scope={dirty:n,ctx:e}),ge.$set(vn);const A={};n&2&&(A.$$scope={dirty:n,ctx:e}),Me.$set(A)},i(e){hs||(y(E.$$.fragment,e),y(we.$$.fragment,e),y(Be.$$.fragment,e),y(xe.$$.fragment,e),y(De.$$.fragment,e),y(Pe.$$.fragment,e),y($e.$$.fragment,e),y(Ee.$$.fragment,e),y(Le.$$.fragment,e),y(ie.$$.fragment,e),y(He.$$.fragment,e),y(le.$$.fragment,e),y(qe.$$.fragment,e),y(ae.$$.fragment,e),y(Ke.$$.fragment,e),y(tn.$$.fragment,e),y(sn.$$.fragment,e),y(on.$$.fragment,e),y(re.$$.fragment,e),y(ln.$$.fragment,e),y(an.$$.fragment,e),y(rn.$$.fragment,e),y(cn.$$.fragment,e),y(pn.$$.fragment,e),y(pe.$$.fragment,e),y(dn.$$.fragment,e),y(mn.$$.fragment,e),y(fn.$$.fragment,e),y(gn.$$.fragment,e),y(un.$$.fragment,e),y(me.$$.fragment,e),y(Mn.$$.fragment,e),y(yn.$$.fragment,e),y(hn.$$.fragment,e),y(Tn.$$.fragment,e),y(Un.$$.fragment,e),y(ge.$$.fragment,e),y(_n.$$.fragment,e),y(Jn.$$.fragment,e),y(wn.$$.fragment,e),y(Vn.$$.fragment,e),y(Me.$$.fragment,e),y(bn.$$.fragment,e),y(kn.$$.fragment,e),y(jn.$$.fragment,e),y(Cn.$$.fragment,e),hs=!0)},o(e){h(E.$$.fragment,e),h(we.$$.fragment,e),h(Be.$$.fragment,e),h(xe.$$.fragment,e),h(De.$$.fragment,e),h(Pe.$$.fragment,e),h($e.$$.fragment,e),h(Ee.$$.fragment,e),h(Le.$$.fragment,e),h(ie.$$.fragment,e),h(He.$$.fragment,e),h(le.$$.fragment,e),h(qe.$$.fragment,e),h(ae.$$.fragment,e),h(Ke.$$.fragment,e),h(tn.$$.fragment,e),h(sn.$$.fragment,e),h(on.$$.fragment,e),h(re.$$.fragment,e),h(ln.$$.fragment,e),h(an.$$.fragment,e),h(rn.$$.fragment,e),h(cn.$$.fragment,e),h(pn.$$.fragment,e),h(pe.$$.fragment,e),h(dn.$$.fragment,e),h(mn.$$.fragment,e),h(fn.$$.fragment,e),h(gn.$$.fragment,e),h(un.$$.fragment,e),h(me.$$.fragment,e),h(Mn.$$.fragment,e),h(yn.$$.fragment,e),h(hn.$$.fragment,e),h(Tn.$$.fragment,e),h(Un.$$.fragment,e),h(ge.$$.fragment,e),h(_n.$$.fragment,e),h(Jn.$$.fragment,e),h(wn.$$.fragment,e),h(Vn.$$.fragment,e),h(Me.$$.fragment,e),h(bn.$$.fragment,e),h(kn.$$.fragment,e),h(jn.$$.fragment,e),h(Cn.$$.fragment,e),hs=!1},d(e){e&&(t(_),t(d),t(m),t(U),t(J),t(ee),t(x),t(w),t(S),t(ht),t(Ue),t(Tt),t(_e),t(Ut),t(Je),t(_t),t(oe),t(Jt),t(wt),t(Ve),t(Vt),t(be),t(bt),t(ke),t(kt),t(je),t(jt),t(Ce),t(Ct),t(Ie),t(It),t(ve),t(vt),t(Bt),t(Re),t(Rt),t(Ne),t(Nt),t(xt),t(Se),t(St),t(Ze),t(Zt),t(Fe),t(Ft),t(Ge),t(Gt),t(Dt),t(We),t(Wt),t(Ae),t(At),t(Pt),t(Qe),t(Qt),t($t),t(ze),t(zt),t(Et),t(Xe),t(Xt),t(Lt),t(Ye),t(Yt),t(Ht),t(Ot),t(Oe),t(qt),t(Kt),t(es),t(ns),t(ts),t(en),t(ss),t(nn),t(os),t(is),t(C),t(ls),t(as),t(I),t(rs),t(cs),t(v),t(ps),t(ds),t(Z),t(ms),t(fs),t(F),t(gs),t(us),t(ne),t(Ms),t(ys),t(Mt)),t(a),T(E,e),T(we,e),T(Be,e),T(xe,e),T(De,e),T(Pe,e),T($e,e),T(Ee,e),T(Le,e),T(ie,e),T(He,e),T(le,e),T(qe,e),T(ae,e),T(Ke,e),T(tn,e),T(sn),T(on),T(re),T(ln),T(an),T(rn,e),T(cn),T(pn),T(pe),T(dn),T(mn),T(fn,e),T(gn),T(un),T(me),T(Mn),T(yn),T(hn,e),T(Tn),T(Un),T(ge),T(_n),T(Jn,e),T(wn),T(Vn),T(Me),T(bn),T(kn,e),T(jn),T(Cn,e)}}}const el='{"title":"SkyReels-V2: Infinite-length Film Generative model","local":"skyreels-v2-infinite-length-film-generative-model","sections":[{"title":"A Visual Demonstration","local":"a-visual-demonstration","sections":[],"depth":3},{"title":"Text-to-Video Generation","local":"text-to-video-generation","sections":[],"depth":3},{"title":"First-Last-Frame-to-Video Generation","local":"first-last-frame-to-video-generation","sections":[],"depth":3},{"title":"Video-to-Video Generation","local":"video-to-video-generation","sections":[],"depth":3},{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"SkyReelsV2DiffusionForcingPipeline","local":"diffusers.SkyReelsV2DiffusionForcingPipeline","sections":[],"depth":2},{"title":"SkyReelsV2DiffusionForcingImageToVideoPipeline","local":"diffusers.SkyReelsV2DiffusionForcingImageToVideoPipeline","sections":[],"depth":2},{"title":"SkyReelsV2DiffusionForcingVideoToVideoPipeline","local":"diffusers.SkyReelsV2DiffusionForcingVideoToVideoPipeline","sections":[],"depth":2},{"title":"SkyReelsV2Pipeline","local":"diffusers.SkyReelsV2Pipeline","sections":[],"depth":2},{"title":"SkyReelsV2ImageToVideoPipeline","local":"diffusers.SkyReelsV2ImageToVideoPipeline","sections":[],"depth":2},{"title":"SkyReelsV2PipelineOutput","local":"diffusers.pipelines.skyreels_v2.pipeline_output.SkyReelsV2PipelineOutput","sections":[],"depth":2}],"depth":1}';function nl(V){return Zi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cl extends Fi{constructor(a){super(),Gi(this,a,nl,Ki,Si,{})}}export{cl as component};
