import{s as xi,o as Ji,n as S}from"../chunks/scheduler.8c3d61f6.js";import{S as Qi,i as Ui,g as i,s as t,r as p,A as ki,h as r,f as s,c as a,j as y,u as c,x as w,k as I,y as n,a as h,v as m,d as g,t as u,w as f}from"../chunks/index.da70eac4.js";import{T as Ti}from"../chunks/Tip.6f698f24.js";import{D as v}from"../chunks/Docstring.367be9ed.js";import{C as A}from"../chunks/CodeBlock.a9c4becf.js";import{E as zn}from"../chunks/ExampleCodeBlock.dd9ee828.js";import{H as B,E as ji}from"../chunks/getInferenceSnippets.cb466318.js";function $i(P){let d,x='<a href="../../optimization/cache">Caching</a> may also speed up inference by storing and reusing intermediate outputs.';return{c(){d=i("p"),d.innerHTML=x},l(b){d=r(b,"P",{"data-svelte-h":!0}),w(d)!=="svelte-yvhnlz"&&(d.innerHTML=x)},m(b,_){h(b,d,_)},p:S,d(b){b&&s(d)}}}function Pi(P){let d,x="The <code>guidance_scale</code> parameter in the pipeline is there to support future guidance-distilled models when they come up. Note that passing <code>guidance_scale</code> to the pipeline is ineffective. To enable classifier-free guidance, please pass <code>true_cfg_scale</code> and <code>negative_prompt</code> (even an empty negative prompt like ” ”) should enable classifier-free guidance computations.";return{c(){d=i("p"),d.innerHTML=x},l(b){d=r(b,"P",{"data-svelte-h":!0}),w(d)!=="svelte-1ftpam8"&&(d.innerHTML=x)},m(b,_){h(b,d,_)},p:S,d(b){b&&s(d)}}}function Zi(P){let d,x="Examples:",b,_,M;return _=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUwQSUyMyUyMERlcGVuZGluZyUyMG9uJTIwdGhlJTIwdmFyaWFudCUyMGJlaW5nJTIwdXNlZCUyQyUyMHRoZSUyMHBpcGVsaW5lJTIwY2FsbCUyMHdpbGwlMjBzbGlnaHRseSUyMHZhcnkuJTBBJTIzJTIwUmVmZXIlMjB0byUyMHRoZSUyMHBpcGVsaW5lJTIwZG9jdW1lbnRhdGlvbiUyMGZvciUyMG1vcmUlMjBkZXRhaWxzLiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnF3ZW5pbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImagePipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(o){d=r(o,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(o),c(_.$$.fragment,o)},m(o,T){h(o,d,T),h(o,b,T),m(_,o,T),M=!0},p:S,i(o){M||(g(_.$$.fragment,o),M=!0)},o(o){u(_.$$.fragment,o),M=!1},d(o){o&&(s(d),s(b)),f(_,o)}}}function Ci(P){let d,x="Examples:",b,_,M;return _=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCkucmVzaXplKCgxMDI0JTJDJTIwMTAyNCkpJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMCUyMiUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC45NSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlcy5zYXZlKCUyMnF3ZW5pbWFnZV9pbWcyaW1nLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, negative_prompt=<span class="hljs-string">&quot; &quot;</span>, image=init_image, strength=<span class="hljs-number">0.95</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images.save(<span class="hljs-string">&quot;qwenimage_img2img.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(o){d=r(o,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(o),c(_.$$.fragment,o)},m(o,T){h(o,d,T),h(o,b,T),m(_,o,T),M=!0},p:S,i(o){M||(g(_.$$.fragment,o),M=!0)},o(o){u(_.$$.fragment,o),M=!1},d(o){o&&(s(d),s(b)),f(_,o)}}}function Wi(P){let d,x="Examples:",b,_,M;return _=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlSW5wYWludFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkZhY2UlMjBvZiUyMGElMjB5ZWxsb3clMjBjYXQlMkMlMjBoaWdoJTIwcmVzb2x1dGlvbiUyQyUyMHNpdHRpbmclMjBvbiUyMGElMjBwYXJrJTIwYmVuY2glMjIlMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQXNvdXJjZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCklMEFtYXNrJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIwJTIyJTJDJTIwaW1hZ2UlM0Rzb3VyY2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFzayUyQyUyMHN0cmVuZ3RoJTNEMC44NSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIycXdlbmltYWdlX2lucGFpbnRpbmcucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source = load_image(img_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(mask_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, negative_prompt=<span class="hljs-string">&quot; &quot;</span>, image=source, mask_image=mask, strength=<span class="hljs-number">0.85</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_inpainting.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(o){d=r(o,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(o),c(_.$$.fragment,o)},m(o,T){h(o,d,T),h(o,b,T),m(_,o,T),M=!0},p:S,i(o){M||(g(_.$$.fragment,o),M=!0)},o(o){u(_.$$.fragment,o),M=!1},d(o){o&&(s(d),s(b)),f(_,o)}}}function Ei(P){let d,x="Examples:",b,_,M;return _=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlRWRpdFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlRWRpdFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbi1JbWFnZS1FZGl0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnlhcm4tYXJ0LXBpa2FjaHUucG5nJTIyJTBBKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyTWFrZSUyMFBpa2FjaHUlMjBob2xkJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMCdRd2VuJTIwRWRpdCUyMGlzJTIwYXdlc29tZSclMkMlMjB5YXJuJTIwYXJ0JTIwc3R5bGUlMkMlMjBkZXRhaWxlZCUyQyUyMHZpYnJhbnQlMjBjb2xvcnMlMjIlMEEpJTBBJTIzJTIwRGVwZW5kaW5nJTIwb24lMjB0aGUlMjB2YXJpYW50JTIwYmVpbmclMjB1c2VkJTJDJTIwdGhlJTIwcGlwZWxpbmUlMjBjYWxsJTIwd2lsbCUyMHNsaWdodGx5JTIwdmFyeS4lMEElMjMlMjBSZWZlciUyMHRvJTIwdGhlJTIwcGlwZWxpbmUlMjBkb2N1bWVudGF0aW9uJTIwZm9yJTIwbW9yZSUyMGRldGFpbHMuJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJxd2VuaW1hZ2VfZWRpdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageEditPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageEditPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image-Edit&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/yarn-art-pikachu.png&quot;</span>
<span class="hljs-meta">... </span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Make Pikachu hold a sign that says &#x27;Qwen Edit is awesome&#x27;, yarn art style, detailed, vibrant colors&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(image, prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_edit.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(o){d=r(o,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(o),c(_.$$.fragment,o)},m(o,T){h(o,d,T),h(o,b,T),m(_,o,T),M=!0},p:S,i(o){M||(g(_.$$.fragment,o),M=!0)},o(o){u(_.$$.fragment,o),M=!1},d(o){o&&(s(d),s(b)),f(_,o)}}}function Li(P){let d,x="Examples:",b,_,M;return _=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlRWRpdElucGFpbnRQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMFF3ZW5JbWFnZUVkaXRJbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuLUltYWdlLUVkaXQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBJTBBaW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW9fbWFzay5wbmclMjIlMEFzb3VyY2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMCUyMiUyQyUyMGltYWdlJTNEc291cmNlJTJDJTIwbWFza19pbWFnZSUzRG1hc2slMkMlMjBzdHJlbmd0aCUzRDEuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIycXdlbmltYWdlX2lucGFpbnRpbmcucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageEditInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageEditInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image-Edit&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source = load_image(img_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(mask_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=prompt, negative_prompt=<span class="hljs-string">&quot; &quot;</span>, image=source, mask_image=mask, strength=<span class="hljs-number">1.0</span>, num_inference_steps=<span class="hljs-number">50</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_inpainting.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(o){d=r(o,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(o),c(_.$$.fragment,o)},m(o,T){h(o,d,T),h(o,b,T),m(_,o,T),M=!0},p:S,i(o){M||(g(_.$$.fragment,o),M=!0)},o(o){u(_.$$.fragment,o),M=!1},d(o){o&&(s(d),s(b)),f(_,o)}}}function Ni(P){let d,x="Examples:",b,_,M;return _=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBRd2VuSW1hZ2VDb250cm9sTmV0TW9kZWwlMkMlMjBRd2VuSW1hZ2VNdWx0aUNvbnRyb2xOZXRNb2RlbCUyQyUyMFF3ZW5JbWFnZUNvbnRyb2xOZXRQaXBlbGluZSUwQSUwQSUyMyUyMFF3ZW5JbWFnZUNvbnRyb2xOZXRNb2RlbCUwQWNvbnRyb2xuZXQlMjAlM0QlMjBRd2VuSW1hZ2VDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkluc3RhbnRYJTJGUXdlbi1JbWFnZS1Db250cm9sTmV0LVVuaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwUXdlbkltYWdlQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWVzdGhldGljcyUyMGFydCUyQyUyMHRyYWRpdGlvbmFsJTIwYXNpYW4lMjBwYWdvZGElMkMlMjBlbGFib3JhdGUlMjBnb2xkZW4lMjBhY2NlbnRzJTJDJTIwc2t5JTIwYmx1ZSUyMGFuZCUyMHdoaXRlJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwc3dpcmxpbmclMjBjbG91ZCUyMHBhdHRlcm4lMkMlMjBkaWdpdGFsJTIwaWxsdXN0cmF0aW9uJTJDJTIwZWFzdCUyMGFzaWFuJTIwYXJjaGl0ZWN0dXJlJTJDJTIwb3JuYW1lbnRhbCUyMHJvb2Z0b3AlMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxpbmclMjBvbiUyMGJ1aWxkaW5nJTJDJTIwY3VsdHVyYWwlMjByZXByZXNlbnRhdGlvbi4lMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjIlMjAlMjIlMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGSW5zdGFudFglMkZRd2VuLUltYWdlLUNvbnRyb2xOZXQtVW5pb24lMkZyZXNvbHZlJTJGbWFpbiUyRmNvbmRzJTJGY2FubnkucG5nJTIyJTBBKSUwQSUyMyUyMERlcGVuZGluZyUyMG9uJTIwdGhlJTIwdmFyaWFudCUyMGJlaW5nJTIwdXNlZCUyQyUyMHRoZSUyMHBpcGVsaW5lJTIwY2FsbCUyMHdpbGwlMjBzbGlnaHRseSUyMHZhcnkuJTBBJTIzJTIwUmVmZXIlMjB0byUyMHRoZSUyMHBpcGVsaW5lJTIwZG9jdW1lbnRhdGlvbiUyMGZvciUyMG1vcmUlMjBkZXRhaWxzLiUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTNEY29udHJvbF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTNEMS4wJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwdHJ1ZV9jZmdfc2NhbGUlM0Q0LjAlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnF3ZW5pbWFnZV9jbl91bmlvbi5wbmclMjIpJTBBJTBBJTIzJTIwUXdlbkltYWdlTXVsdGlDb250cm9sTmV0TW9kZWwlMEFjb250cm9sbmV0JTIwJTNEJTIwUXdlbkltYWdlQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJJbnN0YW50WCUyRlF3ZW4tSW1hZ2UtQ29udHJvbE5ldC1VbmlvbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBY29udHJvbG5ldCUyMCUzRCUyMFF3ZW5JbWFnZU11bHRpQ29udHJvbE5ldE1vZGVsKCU1QmNvbnRyb2xuZXQlNUQpJTBBcGlwZSUyMCUzRCUyMFF3ZW5JbWFnZUNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyUXdlbiUyRlF3ZW4tSW1hZ2UlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkFlc3RoZXRpY3MlMjBhcnQlMkMlMjB0cmFkaXRpb25hbCUyMGFzaWFuJTIwcGFnb2RhJTJDJTIwZWxhYm9yYXRlJTIwZ29sZGVuJTIwYWNjZW50cyUyQyUyMHNreSUyMGJsdWUlMjBhbmQlMjB3aGl0ZSUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMHN3aXJsaW5nJTIwY2xvdWQlMjBwYXR0ZXJuJTJDJTIwZGlnaXRhbCUyMGlsbHVzdHJhdGlvbiUyQyUyMGVhc3QlMjBhc2lhbiUyMGFyY2hpdGVjdHVyZSUyQyUyMG9ybmFtZW50YWwlMjByb29mdG9wJTJDJTIwaW50cmljYXRlJTIwZGV0YWlsaW5nJTIwb24lMjBidWlsZGluZyUyQyUyMGN1bHR1cmFsJTIwcmVwcmVzZW50YXRpb24uJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyJTIwJTIyJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRkluc3RhbnRYJTJGUXdlbi1JbWFnZS1Db250cm9sTmV0LVVuaW9uJTJGcmVzb2x2ZSUyRm1haW4lMkZjb25kcyUyRmNhbm55LnBuZyUyMiUwQSklMEElMjMlMjBEZXBlbmRpbmclMjBvbiUyMHRoZSUyMHZhcmlhbnQlMjBiZWluZyUyMHVzZWQlMkMlMjB0aGUlMjBwaXBlbGluZSUyMGNhbGwlMjB3aWxsJTIwc2xpZ2h0bHklMjB2YXJ5LiUwQSUyMyUyMFJlZmVyJTIwdG8lMjB0aGUlMjBwaXBlbGluZSUyMGRvY3VtZW50YXRpb24lMjBmb3IlMjBtb3JlJTIwZGV0YWlscy4lMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbF9pbWFnZSUzRCU1QmNvbnRyb2xfaW1hZ2UlMkMlMjBjb250cm9sX2ltYWdlJTVEJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0QlNUIwLjUlMkMlMjAwLjUlNUQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzAlMkMlMEElMjAlMjAlMjAlMjB0cnVlX2NmZ19zY2FsZSUzRDQuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIycXdlbmltYWdlX2NuX3VuaW9uX211bHRpLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageControlNetModel, QwenImageMultiControlNetModel, QwenImageControlNetPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># QwenImageControlNetModel</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = QwenImageControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;InstantX/Qwen-Image-ControlNet-Union&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, controlnet=controlnet, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Aesthetics art, traditional asian pagoda, elaborate golden accents, sky blue and white color palette, swirling cloud pattern, digital illustration, east asian architecture, ornamental rooftop, intricate detailing on building, cultural representation.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot; &quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/InstantX/Qwen-Image-ControlNet-Union/resolve/main/conds/canny.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=<span class="hljs-number">1.0</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    true_cfg_scale=<span class="hljs-number">4.0</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_cn_union.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># QwenImageMultiControlNetModel</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = QwenImageControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;InstantX/Qwen-Image-ControlNet-Union&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = QwenImageMultiControlNetModel([controlnet])
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, controlnet=controlnet, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Aesthetics art, traditional asian pagoda, elaborate golden accents, sky blue and white color palette, swirling cloud pattern, digital illustration, east asian architecture, ornamental rooftop, intricate detailing on building, cultural representation.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot; &quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/InstantX/Qwen-Image-ControlNet-Union/resolve/main/conds/canny.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    control_image=[control_image, control_image],
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=[<span class="hljs-number">0.5</span>, <span class="hljs-number">0.5</span>],
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    true_cfg_scale=<span class="hljs-number">4.0</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_cn_union_multi.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(o){d=r(o,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(o),c(_.$$.fragment,o)},m(o,T){h(o,d,T),h(o,b,T),m(_,o,T),M=!0},p:S,i(o){M||(g(_.$$.fragment,o),M=!0)},o(o){u(_.$$.fragment,o),M=!1},d(o){o&&(s(d),s(b)),f(_,o)}}}function Gi(P){let d,x="Examples:",b,_,M;return _=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlRWRpdFBsdXNQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMFF3ZW5JbWFnZUVkaXRQbHVzUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuLUltYWdlLUVkaXQtMjUwOSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZ5YXJuLWFydC1waWthY2h1LnBuZyUyMiUwQSkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMk1ha2UlMjBQaWthY2h1JTIwaG9sZCUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjAnUXdlbiUyMEVkaXQlMjBpcyUyMGF3ZXNvbWUnJTJDJTIweWFybiUyMGFydCUyMHN0eWxlJTJDJTIwZGV0YWlsZWQlMkMlMjB2aWJyYW50JTIwY29sb3JzJTIyJTBBKSUwQSUyMyUyMERlcGVuZGluZyUyMG9uJTIwdGhlJTIwdmFyaWFudCUyMGJlaW5nJTIwdXNlZCUyQyUyMHRoZSUyMHBpcGVsaW5lJTIwY2FsbCUyMHdpbGwlMjBzbGlnaHRseSUyMHZhcnkuJTBBJTIzJTIwUmVmZXIlMjB0byUyMHRoZSUyMHBpcGVsaW5lJTIwZG9jdW1lbnRhdGlvbiUyMGZvciUyMG1vcmUlMjBkZXRhaWxzLiUwQWltYWdlJTIwJTNEJTIwcGlwZShpbWFnZSUyQyUyMHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIycXdlbmltYWdlX2VkaXRfcGx1cy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImageEditPlusPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = QwenImageEditPlusPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image-Edit-2509&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/yarn-art-pikachu.png&quot;</span>
<span class="hljs-meta">... </span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Make Pikachu hold a sign that says &#x27;Qwen Edit is awesome&#x27;, yarn art style, detailed, vibrant colors&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(image, prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;qwenimage_edit_plus.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,b=t(),p(_.$$.fragment)},l(o){d=r(o,"P",{"data-svelte-h":!0}),w(d)!=="svelte-kvfsh7"&&(d.textContent=x),b=a(o),c(_.$$.fragment,o)},m(o,T){h(o,d,T),h(o,b,T),m(_,o,T),M=!0},p:S,i(o){M||(g(_.$$.fragment,o),M=!0)},o(o){u(_.$$.fragment,o),M=!1},d(o){o&&(s(d),s(b)),f(_,o)}}}function Bi(P){let d,x,b,_,M,o,T,Jo='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',St,Ze,Qo="Qwen-Image from the Qwen team is an image generation foundation model in the Qwen series that achieves significant advances in complex text rendering and precise image editing. Experiments show strong general capabilities in both image generation and editing, with exceptional performance in text rendering, especially for Chinese.",Ot,Ce,Uo="Qwen-Image comes in the following variants:",Kt,We,ko='<thead><tr><th align="center">model type</th> <th align="center">model id</th></tr></thead> <tbody><tr><td align="center">Qwen-Image</td> <td align="center"><a href="https://huggingface.co/Qwen/Qwen-Image" rel="nofollow"><code>Qwen/Qwen-Image</code></a></td></tr> <tr><td align="center">Qwen-Image-Edit</td> <td align="center"><a href="https://huggingface.co/Qwen/Qwen-Image-Edit" rel="nofollow"><code>Qwen/Qwen-Image-Edit</code></a></td></tr> <tr><td align="center">Qwen-Image-Edit Plus</td> <td align="center"><a href="https://huggingface.co/Qwen/Qwen-Image-Edit-2509" rel="nofollow">Qwen/Qwen-Image-Edit-2509</a></td></tr></tbody>',ea,O,na,Ee,ta,Le,jo=`Use a LoRA from <code>lightx2v/Qwen-Image-Lightning</code> to speed up inference by reducing the
number of steps. Refer to the code snippet below:`,aa,K,An,$o="Code",Da,Ne,sa,ee,oa,Ge,ia,Be,Po='With <a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImageEditPlusPipeline">QwenImageEditPlusPipeline</a>, one can provide multiple images as input reference.',ra,Ve,la,qe,da,J,Re,za,Sn,Zo="The QwenImage pipeline for text-to-image generation.",Aa,V,Xe,Sa,On,Co="Function invoked when calling the pipeline for generation.",Oa,ne,Ka,te,Fe,es,Kn,Wo=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ns,ae,He,ts,et,Eo=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,as,se,Ye,ss,nt,Lo=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,os,oe,De,is,tt,No=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,rs,at,ze,pa,Ae,ca,Q,Se,ls,st,Go="The QwenImage pipeline for text-to-image generation.",ds,q,Oe,ps,ot,Bo="Function invoked when calling the pipeline for generation.",cs,ie,ms,re,Ke,gs,it,Vo=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,us,le,en,fs,rt,qo=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,hs,de,nn,_s,lt,Ro=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ws,pe,tn,bs,dt,Xo=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ys,pt,an,ma,sn,ga,U,on,Is,ct,Fo="The QwenImage pipeline for text-to-image generation.",vs,R,rn,Ms,mt,Ho="Function invoked when calling the pipeline for generation.",Ts,ce,xs,me,ln,Js,gt,Yo=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Qs,ge,dn,Us,ut,Do=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,ks,ue,pn,js,ft,zo=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,$s,fe,cn,Ps,ht,Ao=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Zs,_t,mn,ua,gn,fa,k,un,Cs,wt,So="The Qwen-Image-Edit pipeline for image editing.",Ws,X,fn,Es,bt,Oo="Function invoked when calling the pipeline for generation.",Ls,he,Ns,_e,hn,Gs,yt,Ko=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Bs,we,_n,Vs,It,ei=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,qs,be,wn,Rs,vt,ni=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Xs,ye,bn,Fs,Mt,ti=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Hs,Tt,yn,ha,In,_a,j,vn,Ys,xt,ai="The Qwen-Image-Edit pipeline for image editing.",Ds,F,Mn,zs,Jt,si="Function invoked when calling the pipeline for generation.",As,Ie,Ss,ve,Tn,Os,Qt,oi=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ks,Me,xn,eo,Ut,ii=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,no,Te,Jn,to,kt,ri=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ao,xe,Qn,so,jt,li=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,oo,$t,Un,wa,kn,ba,$,jn,io,Pt,di="The QwenImage pipeline for text-to-image generation.",ro,H,$n,lo,Zt,pi="Function invoked when calling the pipeline for generation.",po,Je,co,Qe,Pn,mo,Ct,ci=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,go,Ue,Zn,uo,Wt,mi=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,fo,ke,Cn,ho,Et,gi=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,_o,je,Wn,wo,Lt,ui=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,bo,Nt,En,ya,Ln,Ia,G,Nn,yo,Gt,fi="The Qwen-Image-Edit pipeline for image editing.",Io,Y,Gn,vo,Bt,hi="Function invoked when calling the pipeline for generation.",Mo,$e,To,Vt,Bn,va,Vn,Ma,D,qn,xo,qt,_i="Output class for Stable Diffusion pipelines.",Ta,Rn,xa,zt,Ja;return M=new B({props:{title:"QwenImage",local:"qwenimage",headingTag:"h1"}}),O=new Ti({props:{$$slots:{default:[$i]},$$scope:{ctx:P}}}),Ee=new B({props:{title:"LoRA for faster inference",local:"lora-for-faster-inference",headingTag:"h2"}}),Ne=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, FlowMatchEulerDiscreteScheduler
<span class="hljs-keyword">import</span> torch 
<span class="hljs-keyword">import</span> math

ckpt_id = <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>

<span class="hljs-comment"># From</span>
<span class="hljs-comment"># https://github.com/ModelTC/Qwen-Image-Lightning/blob/342260e8f5468d2f24d084ce04f55e101007118b/generate_with_diffusers.py#L82C9-L97C10</span>
scheduler_config = {
    <span class="hljs-string">&quot;base_image_seq_len&quot;</span>: <span class="hljs-number">256</span>,
    <span class="hljs-string">&quot;base_shift&quot;</span>: math.log(<span class="hljs-number">3</span>),  <span class="hljs-comment"># We use shift=3 in distillation</span>
    <span class="hljs-string">&quot;invert_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;max_image_seq_len&quot;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&quot;max_shift&quot;</span>: math.log(<span class="hljs-number">3</span>),  <span class="hljs-comment"># We use shift=3 in distillation</span>
    <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
    <span class="hljs-string">&quot;shift&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;shift_terminal&quot;</span>: <span class="hljs-literal">None</span>,  <span class="hljs-comment"># set shift_terminal to None</span>
    <span class="hljs-string">&quot;stochastic_sampling&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;time_shift_type&quot;</span>: <span class="hljs-string">&quot;exponential&quot;</span>,
    <span class="hljs-string">&quot;use_beta_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;use_dynamic_shifting&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;use_exponential_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
    <span class="hljs-string">&quot;use_karras_sigmas&quot;</span>: <span class="hljs-literal">False</span>,
}
scheduler = FlowMatchEulerDiscreteScheduler.from_config(scheduler_config)
pipe = DiffusionPipeline.from_pretrained(
    ckpt_id, scheduler=scheduler, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;lightx2v/Qwen-Image-Lightning&quot;</span>, weight_name=<span class="hljs-string">&quot;Qwen-Image-Lightning-8steps-V1.0.safetensors&quot;</span>
)

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon, Ultra HD, 4K, cinematic composition.&quot;</span>
negative_prompt = <span class="hljs-string">&quot; &quot;</span>
image = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">8</span>,
    true_cfg_scale=<span class="hljs-number">1.0</span>,
    generator=torch.manual_seed(<span class="hljs-number">0</span>),
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;qwen_fewsteps.png&quot;</span>)`,wrap:!1}}),ee=new Ti({props:{$$slots:{default:[Pi]},$$scope:{ctx:P}}}),Ge=new B({props:{title:"Multi-image reference with QwenImageEditPlusPipeline",local:"multi-image-reference-with-qwenimageeditpluspipeline",headingTag:"h2"}}),Ve=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlRWRpdFBsdXNQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMFF3ZW5JbWFnZUVkaXRQbHVzUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlF3ZW4lMkZRd2VuLUltYWdlLUVkaXQtMjUwOSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2VfMSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGZ3J1bXB5LmpwZyUyMiklMEFpbWFnZV8yJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZwZW5nLnBuZyUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlNUJpbWFnZV8xJTJDJTIwaW1hZ2VfMiU1RCUyQyUyMCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMnB1dCUyMHRoZSUyMHBlbmd1aW4lMjBhbmQlMjB0aGUlMjBjYXQlMjBhdCUyMGElMjBnYW1lJTIwc2hvdyUyMGNhbGxlZCUyMCUyMlF3ZW4lMjBFZGl0JTIwUGx1cyUyMEdhbWVzJTIyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`import torch
<span class="hljs-keyword">from</span> PIL import Image
<span class="hljs-keyword">from</span> diffusers import QwenImageEditPlusPipeline
<span class="hljs-keyword">from</span> diffusers.utils import load_image

pipe = QwenImageEditPlusPipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image-Edit-2509&quot;</span>, <span class="hljs-attribute">torch_dtype</span>=torch.bfloat16
).<span class="hljs-keyword">to</span>(<span class="hljs-string">&quot;cuda&quot;</span>)

image_1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/grumpy.jpg&quot;</span>)
image_2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/peng.png&quot;</span>)
image = pipe(
    image=[image_1, image_2], 
    <span class="hljs-attribute">prompt</span>=<span class="hljs-string">&quot;put the penguin and the cat at a game show called &quot;</span>Qwen <span class="hljs-built_in">Edit</span> Plus Games<span class="hljs-string">&quot;&quot;</span>, 
    <span class="hljs-attribute">num_inference_steps</span>=50
).images[0]`,wrap:!1}}),qe=new B({props:{title:"QwenImagePipeline",local:"diffusers.QwenImagePipeline",headingTag:"h2"}}),Re=new v({props:{name:"class diffusers.QwenImagePipeline",anchor:"diffusers.QwenImagePipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImagePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImagePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImagePipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImagePipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L132"}}),Xe=new v({props:{name:"__call__",anchor:"diffusers.QwenImagePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is enabled by
setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale encourages to
generate images that are closely linked to the text <code>prompt</code>, usually at the expense of lower image
quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImagePipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImagePipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImagePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImagePipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImagePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImagePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImagePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImagePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImagePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImagePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImagePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImagePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImagePipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImagePipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImagePipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImagePipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L451",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),ne=new zn({props:{anchor:"diffusers.QwenImagePipeline.__call__.example",$$slots:{default:[Zi]},$$scope:{ctx:P}}}),Fe=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImagePipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L359"}}),He=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImagePipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L386"}}),Ye=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImagePipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L346"}}),De=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImagePipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L372"}}),ze=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImagePipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImagePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImagePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage.py#L226"}}),Ae=new B({props:{title:"QwenImageImg2ImgPipeline",local:"diffusers.QwenImageImg2ImgPipeline",headingTag:"h2"}}),Se=new v({props:{name:"class diffusers.QwenImageImg2ImgPipeline",anchor:"diffusers.QwenImageImg2ImgPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L134"}}),Oe=new v({props:{name:"__call__",anchor:"diffusers.QwenImageImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is enabled by
setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale encourages to
generate images that are closely linked to the text <code>prompt</code>, usually at the expense of lower image
quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L525",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),ie=new zn({props:{anchor:"diffusers.QwenImageImg2ImgPipeline.__call__.example",$$slots:{default:[Ci]},$$scope:{ctx:P}}}),Ke=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L408"}}),en=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageImg2ImgPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L435"}}),nn=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L395"}}),tn=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageImg2ImgPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L421"}}),an=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_img2img.py#L269"}}),sn=new B({props:{title:"QwenImageInpaintPipeline",local:"diffusers.QwenImageInpaintPipeline",headingTag:"h2"}}),on=new v({props:{name:"class diffusers.QwenImageInpaintPipeline",anchor:"diffusers.QwenImageInpaintPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L137"}}),rn=new v({props:{name:"__call__",anchor:"diffusers.QwenImageInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is enabled by
setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale encourages to
generate images that are closely linked to the text <code>prompt</code>, usually at the expense of lower image
quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will be generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageInpaintPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L635",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),ce=new zn({props:{anchor:"diffusers.QwenImageInpaintPipeline.__call__.example",$$slots:{default:[Wi]},$$scope:{ctx:P}}}),ln=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L435"}}),dn=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageInpaintPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L462"}}),pn=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L422"}}),cn=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageInpaintPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L448"}}),mn=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_inpaint.py#L280"}}),gn=new B({props:{title:"QwenImageEditPipeline",local:"diffusers.QwenImageEditPipeline",headingTag:"h2"}}),un=new v({props:{name:"class diffusers.QwenImageEditPipeline",anchor:"diffusers.QwenImageEditPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"processor",val:": Qwen2VLProcessor"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageEditPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageEditPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageEditPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageEditPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L165"}}),fn=new v({props:{name:"__call__",anchor:"diffusers.QwenImageEditPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageEditPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageEditPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageEditPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
true_cfg_scale (<code>float</code>, <em>optional</em>, defaults to 1.0): Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free
Diffusion Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of
equation 2. of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is
enabled by setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale
encourages to generate images that are closely linked to the text <code>prompt</code>, usually at the expense of
lower image quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageEditPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageEditPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageEditPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageEditPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageEditPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageEditPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageEditPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageEditPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageEditPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageEditPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageEditPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageEditPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageEditPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageEditPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageEditPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L546",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),he=new zn({props:{anchor:"diffusers.QwenImageEditPipeline.__call__.example",$$slots:{default:[Ei]},$$scope:{ctx:P}}}),hn=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageEditPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L431"}}),_n=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageEditPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L458"}}),wn=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageEditPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L418"}}),bn=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageEditPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L444"}}),yn=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageEditPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": typing.Optional[torch.Tensor] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
image to be encoded`,name:"image"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit.py#L273"}}),In=new B({props:{title:"QwenImageEditInpaintPipeline",local:"diffusers.QwenImageEditInpaintPipeline",headingTag:"h2"}}),vn=new v({props:{name:"class diffusers.QwenImageEditInpaintPipeline",anchor:"diffusers.QwenImageEditInpaintPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"processor",val:": Qwen2VLProcessor"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageEditInpaintPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageEditInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageEditInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageEditInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageEditInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L167"}}),Mn=new v({props:{name:"__call__",anchor:"diffusers.QwenImageEditInpaintPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
true_cfg_scale (<code>float</code>, <em>optional</em>, defaults to 1.0): Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free
Diffusion Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of
equation 2. of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is
enabled by setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale
encourages to generate images that are closely linked to the text <code>prompt</code>, usually at the expense of
lower image quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will ge generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L679",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),Ie=new zn({props:{anchor:"diffusers.QwenImageEditInpaintPipeline.__call__.example",$$slots:{default:[Li]},$$scope:{ctx:P}}}),Tn=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageEditInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L477"}}),xn=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageEditInpaintPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L504"}}),Jn=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageEditInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L464"}}),Qn=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageEditInpaintPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L490"}}),Un=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": typing.Optional[torch.Tensor] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
image to be encoded`,name:"image"},{anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_inpaint.py#L285"}}),kn=new B({props:{title:"QwenImageControlNetPipeline",local:"diffusers.QwenImageControlNetPipeline",headingTag:"h2"}}),jn=new v({props:{name:"class diffusers.QwenImageControlNetPipeline",anchor:"diffusers.QwenImageControlNetPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"transformer",val:": QwenImageTransformer2DModel"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnets.controlnet_qwenimage.QwenImageControlNetModel, diffusers.models.controlnets.controlnet_qwenimage.QwenImageMultiControlNetModel]"}],parametersDescription:[{anchor:"diffusers.QwenImageControlNetPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_controlnet.py#L192"}}),$n=new v({props:{name:"__call__",anchor:"diffusers.QwenImageControlNetPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is enabled by
setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale encourages to
generate images that are closely linked to the text <code>prompt</code>, usually at the expense of lower image
quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageControlNetPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_controlnet.py#L551",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),Je=new zn({props:{anchor:"diffusers.QwenImageControlNetPipeline.__call__.example",$$slots:{default:[Ni]},$$scope:{ctx:P}}}),Pn=new v({props:{name:"disable_vae_slicing",anchor:"diffusers.QwenImageControlNetPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_controlnet.py#L423"}}),Zn=new v({props:{name:"disable_vae_tiling",anchor:"diffusers.QwenImageControlNetPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_controlnet.py#L450"}}),Cn=new v({props:{name:"enable_vae_slicing",anchor:"diffusers.QwenImageControlNetPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_controlnet.py#L410"}}),Wn=new v({props:{name:"enable_vae_tiling",anchor:"diffusers.QwenImageControlNetPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_controlnet.py#L436"}}),En=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageControlNetPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageControlNetPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageControlNetPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageControlNetPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageControlNetPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_controlnet.py#L291"}}),Ln=new B({props:{title:"QwenImageEditPlusPipeline",local:"diffusers.QwenImageEditPlusPipeline",headingTag:"h2"}}),Nn=new v({props:{name:"class diffusers.QwenImageEditPlusPipeline",anchor:"diffusers.QwenImageEditPlusPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLQwenImage"},{name:"text_encoder",val:": Qwen2_5_VLForConditionalGeneration"},{name:"tokenizer",val:": Qwen2Tokenizer"},{name:"processor",val:": Qwen2VLProcessor"},{name:"transformer",val:": QwenImageTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPlusPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/qwenimage_transformer2d#diffusers.QwenImageTransformer2DModel">QwenImageTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.QwenImageEditPlusPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.QwenImageEditPlusPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.QwenImageEditPlusPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>Qwen2.5-VL-7B-Instruct</code>) &#x2014;
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a>, specifically the
<a href="https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct" rel="nofollow">Qwen2.5-VL-7B-Instruct</a> variant.`,name:"text_encoder"},{anchor:"diffusers.QwenImageEditPlusPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>QwenTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_plus.py#L168"}}),Gn=new v({props:{name:"__call__",anchor:"diffusers.QwenImageEditPlusPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"true_cfg_scale",val:": float = 4.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
true_cfg_scale (<code>float</code>, <em>optional</em>, defaults to 1.0): Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free
Diffusion Guidance</a>. <code>true_cfg_scale</code> is defined as <code>w</code> of
equation 2. of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Classifier-free guidance is
enabled by setting <code>true_cfg_scale &gt; 1</code> and a provided <code>negative_prompt</code>. Higher guidance scale
encourages to generate images that are closely linked to the text <code>prompt</code>, usually at the expense of
lower image quality.`,name:"true_cfg_scale"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
A guidance scale value for guidance distilled models. Unlike the traditional classifier-free guidance
where the guidance scale is applied during inference through noise prediction rescaling, guidance
distilled models take the guidance scale directly as an input parameter during forward pass. Guidance
scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images
that are closely linked to the text <code>prompt</code>, usually at the expense of lower image quality. This
parameter in the pipeline is there to support future guidance-distilled models when they come up. It is
ignored when not using guidance distilled models. To enable traditional classifier-free guidance,
please pass <code>true_cfg_scale &gt; 1.0</code> and <code>negative_prompt</code> (even an empty negative prompt like &#x201D; &#x201D; should
enable classifier-free guidance computations).`,name:"guidance_scale"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.qwenimage.QwenImagePipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_plus.py#L515",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.qwenimage.QwenImagePipelineOutput</code> or <code>tuple</code></p>
`}}),$e=new zn({props:{anchor:"diffusers.QwenImageEditPlusPipeline.__call__.example",$$slots:{default:[Gi]},$$scope:{ctx:P}}}),Bn=new v({props:{name:"encode_prompt",anchor:"diffusers.QwenImageEditPlusPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": typing.Optional[torch.Tensor] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.QwenImageEditPlusPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.QwenImageEditPlusPipeline.encode_prompt.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
image to be encoded`,name:"image"},{anchor:"diffusers.QwenImageEditPlusPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.QwenImageEditPlusPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.QwenImageEditPlusPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_qwenimage_edit_plus.py#L287"}}),Vn=new B({props:{title:"QwenImagePipelineOutput",local:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",headingTag:"h2"}}),qn=new v({props:{name:"class diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",anchor:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion pipeline.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/qwenimage/pipeline_output.py#L11"}}),Rn=new ji({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/qwenimage.md"}}),{c(){d=i("meta"),x=t(),b=i("p"),_=t(),p(M.$$.fragment),o=t(),T=i("div"),T.innerHTML=Jo,St=t(),Ze=i("p"),Ze.textContent=Qo,Ot=t(),Ce=i("p"),Ce.textContent=Uo,Kt=t(),We=i("table"),We.innerHTML=ko,ea=t(),p(O.$$.fragment),na=t(),p(Ee.$$.fragment),ta=t(),Le=i("p"),Le.innerHTML=jo,aa=t(),K=i("details"),An=i("summary"),An.textContent=$o,Da=t(),p(Ne.$$.fragment),sa=t(),p(ee.$$.fragment),oa=t(),p(Ge.$$.fragment),ia=t(),Be=i("p"),Be.innerHTML=Po,ra=t(),p(Ve.$$.fragment),la=t(),p(qe.$$.fragment),da=t(),J=i("div"),p(Re.$$.fragment),za=t(),Sn=i("p"),Sn.textContent=Zo,Aa=t(),V=i("div"),p(Xe.$$.fragment),Sa=t(),On=i("p"),On.textContent=Co,Oa=t(),p(ne.$$.fragment),Ka=t(),te=i("div"),p(Fe.$$.fragment),es=t(),Kn=i("p"),Kn.innerHTML=Wo,ns=t(),ae=i("div"),p(He.$$.fragment),ts=t(),et=i("p"),et.innerHTML=Eo,as=t(),se=i("div"),p(Ye.$$.fragment),ss=t(),nt=i("p"),nt.textContent=Lo,os=t(),oe=i("div"),p(De.$$.fragment),is=t(),tt=i("p"),tt.textContent=No,rs=t(),at=i("div"),p(ze.$$.fragment),pa=t(),p(Ae.$$.fragment),ca=t(),Q=i("div"),p(Se.$$.fragment),ls=t(),st=i("p"),st.textContent=Go,ds=t(),q=i("div"),p(Oe.$$.fragment),ps=t(),ot=i("p"),ot.textContent=Bo,cs=t(),p(ie.$$.fragment),ms=t(),re=i("div"),p(Ke.$$.fragment),gs=t(),it=i("p"),it.innerHTML=Vo,us=t(),le=i("div"),p(en.$$.fragment),fs=t(),rt=i("p"),rt.innerHTML=qo,hs=t(),de=i("div"),p(nn.$$.fragment),_s=t(),lt=i("p"),lt.textContent=Ro,ws=t(),pe=i("div"),p(tn.$$.fragment),bs=t(),dt=i("p"),dt.textContent=Xo,ys=t(),pt=i("div"),p(an.$$.fragment),ma=t(),p(sn.$$.fragment),ga=t(),U=i("div"),p(on.$$.fragment),Is=t(),ct=i("p"),ct.textContent=Fo,vs=t(),R=i("div"),p(rn.$$.fragment),Ms=t(),mt=i("p"),mt.textContent=Ho,Ts=t(),p(ce.$$.fragment),xs=t(),me=i("div"),p(ln.$$.fragment),Js=t(),gt=i("p"),gt.innerHTML=Yo,Qs=t(),ge=i("div"),p(dn.$$.fragment),Us=t(),ut=i("p"),ut.innerHTML=Do,ks=t(),ue=i("div"),p(pn.$$.fragment),js=t(),ft=i("p"),ft.textContent=zo,$s=t(),fe=i("div"),p(cn.$$.fragment),Ps=t(),ht=i("p"),ht.textContent=Ao,Zs=t(),_t=i("div"),p(mn.$$.fragment),ua=t(),p(gn.$$.fragment),fa=t(),k=i("div"),p(un.$$.fragment),Cs=t(),wt=i("p"),wt.textContent=So,Ws=t(),X=i("div"),p(fn.$$.fragment),Es=t(),bt=i("p"),bt.textContent=Oo,Ls=t(),p(he.$$.fragment),Ns=t(),_e=i("div"),p(hn.$$.fragment),Gs=t(),yt=i("p"),yt.innerHTML=Ko,Bs=t(),we=i("div"),p(_n.$$.fragment),Vs=t(),It=i("p"),It.innerHTML=ei,qs=t(),be=i("div"),p(wn.$$.fragment),Rs=t(),vt=i("p"),vt.textContent=ni,Xs=t(),ye=i("div"),p(bn.$$.fragment),Fs=t(),Mt=i("p"),Mt.textContent=ti,Hs=t(),Tt=i("div"),p(yn.$$.fragment),ha=t(),p(In.$$.fragment),_a=t(),j=i("div"),p(vn.$$.fragment),Ys=t(),xt=i("p"),xt.textContent=ai,Ds=t(),F=i("div"),p(Mn.$$.fragment),zs=t(),Jt=i("p"),Jt.textContent=si,As=t(),p(Ie.$$.fragment),Ss=t(),ve=i("div"),p(Tn.$$.fragment),Os=t(),Qt=i("p"),Qt.innerHTML=oi,Ks=t(),Me=i("div"),p(xn.$$.fragment),eo=t(),Ut=i("p"),Ut.innerHTML=ii,no=t(),Te=i("div"),p(Jn.$$.fragment),to=t(),kt=i("p"),kt.textContent=ri,ao=t(),xe=i("div"),p(Qn.$$.fragment),so=t(),jt=i("p"),jt.textContent=li,oo=t(),$t=i("div"),p(Un.$$.fragment),wa=t(),p(kn.$$.fragment),ba=t(),$=i("div"),p(jn.$$.fragment),io=t(),Pt=i("p"),Pt.textContent=di,ro=t(),H=i("div"),p($n.$$.fragment),lo=t(),Zt=i("p"),Zt.textContent=pi,po=t(),p(Je.$$.fragment),co=t(),Qe=i("div"),p(Pn.$$.fragment),mo=t(),Ct=i("p"),Ct.innerHTML=ci,go=t(),Ue=i("div"),p(Zn.$$.fragment),uo=t(),Wt=i("p"),Wt.innerHTML=mi,fo=t(),ke=i("div"),p(Cn.$$.fragment),ho=t(),Et=i("p"),Et.textContent=gi,_o=t(),je=i("div"),p(Wn.$$.fragment),wo=t(),Lt=i("p"),Lt.textContent=ui,bo=t(),Nt=i("div"),p(En.$$.fragment),ya=t(),p(Ln.$$.fragment),Ia=t(),G=i("div"),p(Nn.$$.fragment),yo=t(),Gt=i("p"),Gt.textContent=fi,Io=t(),Y=i("div"),p(Gn.$$.fragment),vo=t(),Bt=i("p"),Bt.textContent=hi,Mo=t(),p($e.$$.fragment),To=t(),Vt=i("div"),p(Bn.$$.fragment),va=t(),p(Vn.$$.fragment),Ma=t(),D=i("div"),p(qn.$$.fragment),xo=t(),qt=i("p"),qt.textContent=_i,Ta=t(),p(Rn.$$.fragment),xa=t(),zt=i("p"),this.h()},l(e){const l=ki("svelte-u9bgzb",document.head);d=r(l,"META",{name:!0,content:!0}),l.forEach(s),x=a(e),b=r(e,"P",{}),y(b).forEach(s),_=a(e),c(M.$$.fragment,e),o=a(e),T=r(e,"DIV",{class:!0,"data-svelte-h":!0}),w(T)!=="svelte-si9ct8"&&(T.innerHTML=Jo),St=a(e),Ze=r(e,"P",{"data-svelte-h":!0}),w(Ze)!=="svelte-f9n2hx"&&(Ze.textContent=Qo),Ot=a(e),Ce=r(e,"P",{"data-svelte-h":!0}),w(Ce)!=="svelte-1t9xj8p"&&(Ce.textContent=Uo),Kt=a(e),We=r(e,"TABLE",{"data-svelte-h":!0}),w(We)!=="svelte-rj2irp"&&(We.innerHTML=ko),ea=a(e),c(O.$$.fragment,e),na=a(e),c(Ee.$$.fragment,e),ta=a(e),Le=r(e,"P",{"data-svelte-h":!0}),w(Le)!=="svelte-upho6n"&&(Le.innerHTML=jo),aa=a(e),K=r(e,"DETAILS",{});var Xn=y(K);An=r(Xn,"SUMMARY",{"data-svelte-h":!0}),w(An)!=="svelte-14caxiv"&&(An.textContent=$o),Da=a(Xn),c(Ne.$$.fragment,Xn),Xn.forEach(s),sa=a(e),c(ee.$$.fragment,e),oa=a(e),c(Ge.$$.fragment,e),ia=a(e),Be=r(e,"P",{"data-svelte-h":!0}),w(Be)!=="svelte-zwdk5l"&&(Be.innerHTML=Po),ra=a(e),c(Ve.$$.fragment,e),la=a(e),c(qe.$$.fragment,e),da=a(e),J=r(e,"DIV",{class:!0});var Z=y(J);c(Re.$$.fragment,Z),za=a(Z),Sn=r(Z,"P",{"data-svelte-h":!0}),w(Sn)!=="svelte-1b1rx25"&&(Sn.textContent=Zo),Aa=a(Z),V=r(Z,"DIV",{class:!0});var z=y(V);c(Xe.$$.fragment,z),Sa=a(z),On=r(z,"P",{"data-svelte-h":!0}),w(On)!=="svelte-v78lg8"&&(On.textContent=Co),Oa=a(z),c(ne.$$.fragment,z),z.forEach(s),Ka=a(Z),te=r(Z,"DIV",{class:!0});var Fn=y(te);c(Fe.$$.fragment,Fn),es=a(Fn),Kn=r(Fn,"P",{"data-svelte-h":!0}),w(Kn)!=="svelte-1s3c06i"&&(Kn.innerHTML=Wo),Fn.forEach(s),ns=a(Z),ae=r(Z,"DIV",{class:!0});var Hn=y(ae);c(He.$$.fragment,Hn),ts=a(Hn),et=r(Hn,"P",{"data-svelte-h":!0}),w(et)!=="svelte-pkn4ui"&&(et.innerHTML=Eo),Hn.forEach(s),as=a(Z),se=r(Z,"DIV",{class:!0});var Yn=y(se);c(Ye.$$.fragment,Yn),ss=a(Yn),nt=r(Yn,"P",{"data-svelte-h":!0}),w(nt)!=="svelte-14bnrb6"&&(nt.textContent=Lo),Yn.forEach(s),os=a(Z),oe=r(Z,"DIV",{class:!0});var Dn=y(oe);c(De.$$.fragment,Dn),is=a(Dn),tt=r(Dn,"P",{"data-svelte-h":!0}),w(tt)!=="svelte-1xwrf7t"&&(tt.textContent=No),Dn.forEach(s),rs=a(Z),at=r(Z,"DIV",{class:!0});var At=y(at);c(ze.$$.fragment,At),At.forEach(s),Z.forEach(s),pa=a(e),c(Ae.$$.fragment,e),ca=a(e),Q=r(e,"DIV",{class:!0});var C=y(Q);c(Se.$$.fragment,C),ls=a(C),st=r(C,"P",{"data-svelte-h":!0}),w(st)!=="svelte-1b1rx25"&&(st.textContent=Go),ds=a(C),q=r(C,"DIV",{class:!0});var Rt=y(q);c(Oe.$$.fragment,Rt),ps=a(Rt),ot=r(Rt,"P",{"data-svelte-h":!0}),w(ot)!=="svelte-v78lg8"&&(ot.textContent=Bo),cs=a(Rt),c(ie.$$.fragment,Rt),Rt.forEach(s),ms=a(C),re=r(C,"DIV",{class:!0});var Qa=y(re);c(Ke.$$.fragment,Qa),gs=a(Qa),it=r(Qa,"P",{"data-svelte-h":!0}),w(it)!=="svelte-1s3c06i"&&(it.innerHTML=Vo),Qa.forEach(s),us=a(C),le=r(C,"DIV",{class:!0});var Ua=y(le);c(en.$$.fragment,Ua),fs=a(Ua),rt=r(Ua,"P",{"data-svelte-h":!0}),w(rt)!=="svelte-pkn4ui"&&(rt.innerHTML=qo),Ua.forEach(s),hs=a(C),de=r(C,"DIV",{class:!0});var ka=y(de);c(nn.$$.fragment,ka),_s=a(ka),lt=r(ka,"P",{"data-svelte-h":!0}),w(lt)!=="svelte-14bnrb6"&&(lt.textContent=Ro),ka.forEach(s),ws=a(C),pe=r(C,"DIV",{class:!0});var ja=y(pe);c(tn.$$.fragment,ja),bs=a(ja),dt=r(ja,"P",{"data-svelte-h":!0}),w(dt)!=="svelte-1xwrf7t"&&(dt.textContent=Xo),ja.forEach(s),ys=a(C),pt=r(C,"DIV",{class:!0});var wi=y(pt);c(an.$$.fragment,wi),wi.forEach(s),C.forEach(s),ma=a(e),c(sn.$$.fragment,e),ga=a(e),U=r(e,"DIV",{class:!0});var W=y(U);c(on.$$.fragment,W),Is=a(W),ct=r(W,"P",{"data-svelte-h":!0}),w(ct)!=="svelte-1b1rx25"&&(ct.textContent=Fo),vs=a(W),R=r(W,"DIV",{class:!0});var Xt=y(R);c(rn.$$.fragment,Xt),Ms=a(Xt),mt=r(Xt,"P",{"data-svelte-h":!0}),w(mt)!=="svelte-v78lg8"&&(mt.textContent=Ho),Ts=a(Xt),c(ce.$$.fragment,Xt),Xt.forEach(s),xs=a(W),me=r(W,"DIV",{class:!0});var $a=y(me);c(ln.$$.fragment,$a),Js=a($a),gt=r($a,"P",{"data-svelte-h":!0}),w(gt)!=="svelte-1s3c06i"&&(gt.innerHTML=Yo),$a.forEach(s),Qs=a(W),ge=r(W,"DIV",{class:!0});var Pa=y(ge);c(dn.$$.fragment,Pa),Us=a(Pa),ut=r(Pa,"P",{"data-svelte-h":!0}),w(ut)!=="svelte-pkn4ui"&&(ut.innerHTML=Do),Pa.forEach(s),ks=a(W),ue=r(W,"DIV",{class:!0});var Za=y(ue);c(pn.$$.fragment,Za),js=a(Za),ft=r(Za,"P",{"data-svelte-h":!0}),w(ft)!=="svelte-14bnrb6"&&(ft.textContent=zo),Za.forEach(s),$s=a(W),fe=r(W,"DIV",{class:!0});var Ca=y(fe);c(cn.$$.fragment,Ca),Ps=a(Ca),ht=r(Ca,"P",{"data-svelte-h":!0}),w(ht)!=="svelte-1xwrf7t"&&(ht.textContent=Ao),Ca.forEach(s),Zs=a(W),_t=r(W,"DIV",{class:!0});var bi=y(_t);c(mn.$$.fragment,bi),bi.forEach(s),W.forEach(s),ua=a(e),c(gn.$$.fragment,e),fa=a(e),k=r(e,"DIV",{class:!0});var E=y(k);c(un.$$.fragment,E),Cs=a(E),wt=r(E,"P",{"data-svelte-h":!0}),w(wt)!=="svelte-cjiar3"&&(wt.textContent=So),Ws=a(E),X=r(E,"DIV",{class:!0});var Ft=y(X);c(fn.$$.fragment,Ft),Es=a(Ft),bt=r(Ft,"P",{"data-svelte-h":!0}),w(bt)!=="svelte-v78lg8"&&(bt.textContent=Oo),Ls=a(Ft),c(he.$$.fragment,Ft),Ft.forEach(s),Ns=a(E),_e=r(E,"DIV",{class:!0});var Wa=y(_e);c(hn.$$.fragment,Wa),Gs=a(Wa),yt=r(Wa,"P",{"data-svelte-h":!0}),w(yt)!=="svelte-1s3c06i"&&(yt.innerHTML=Ko),Wa.forEach(s),Bs=a(E),we=r(E,"DIV",{class:!0});var Ea=y(we);c(_n.$$.fragment,Ea),Vs=a(Ea),It=r(Ea,"P",{"data-svelte-h":!0}),w(It)!=="svelte-pkn4ui"&&(It.innerHTML=ei),Ea.forEach(s),qs=a(E),be=r(E,"DIV",{class:!0});var La=y(be);c(wn.$$.fragment,La),Rs=a(La),vt=r(La,"P",{"data-svelte-h":!0}),w(vt)!=="svelte-14bnrb6"&&(vt.textContent=ni),La.forEach(s),Xs=a(E),ye=r(E,"DIV",{class:!0});var Na=y(ye);c(bn.$$.fragment,Na),Fs=a(Na),Mt=r(Na,"P",{"data-svelte-h":!0}),w(Mt)!=="svelte-1xwrf7t"&&(Mt.textContent=ti),Na.forEach(s),Hs=a(E),Tt=r(E,"DIV",{class:!0});var yi=y(Tt);c(yn.$$.fragment,yi),yi.forEach(s),E.forEach(s),ha=a(e),c(In.$$.fragment,e),_a=a(e),j=r(e,"DIV",{class:!0});var L=y(j);c(vn.$$.fragment,L),Ys=a(L),xt=r(L,"P",{"data-svelte-h":!0}),w(xt)!=="svelte-cjiar3"&&(xt.textContent=ai),Ds=a(L),F=r(L,"DIV",{class:!0});var Ht=y(F);c(Mn.$$.fragment,Ht),zs=a(Ht),Jt=r(Ht,"P",{"data-svelte-h":!0}),w(Jt)!=="svelte-v78lg8"&&(Jt.textContent=si),As=a(Ht),c(Ie.$$.fragment,Ht),Ht.forEach(s),Ss=a(L),ve=r(L,"DIV",{class:!0});var Ga=y(ve);c(Tn.$$.fragment,Ga),Os=a(Ga),Qt=r(Ga,"P",{"data-svelte-h":!0}),w(Qt)!=="svelte-1s3c06i"&&(Qt.innerHTML=oi),Ga.forEach(s),Ks=a(L),Me=r(L,"DIV",{class:!0});var Ba=y(Me);c(xn.$$.fragment,Ba),eo=a(Ba),Ut=r(Ba,"P",{"data-svelte-h":!0}),w(Ut)!=="svelte-pkn4ui"&&(Ut.innerHTML=ii),Ba.forEach(s),no=a(L),Te=r(L,"DIV",{class:!0});var Va=y(Te);c(Jn.$$.fragment,Va),to=a(Va),kt=r(Va,"P",{"data-svelte-h":!0}),w(kt)!=="svelte-14bnrb6"&&(kt.textContent=ri),Va.forEach(s),ao=a(L),xe=r(L,"DIV",{class:!0});var qa=y(xe);c(Qn.$$.fragment,qa),so=a(qa),jt=r(qa,"P",{"data-svelte-h":!0}),w(jt)!=="svelte-1xwrf7t"&&(jt.textContent=li),qa.forEach(s),oo=a(L),$t=r(L,"DIV",{class:!0});var Ii=y($t);c(Un.$$.fragment,Ii),Ii.forEach(s),L.forEach(s),wa=a(e),c(kn.$$.fragment,e),ba=a(e),$=r(e,"DIV",{class:!0});var N=y($);c(jn.$$.fragment,N),io=a(N),Pt=r(N,"P",{"data-svelte-h":!0}),w(Pt)!=="svelte-1b1rx25"&&(Pt.textContent=di),ro=a(N),H=r(N,"DIV",{class:!0});var Yt=y(H);c($n.$$.fragment,Yt),lo=a(Yt),Zt=r(Yt,"P",{"data-svelte-h":!0}),w(Zt)!=="svelte-v78lg8"&&(Zt.textContent=pi),po=a(Yt),c(Je.$$.fragment,Yt),Yt.forEach(s),co=a(N),Qe=r(N,"DIV",{class:!0});var Ra=y(Qe);c(Pn.$$.fragment,Ra),mo=a(Ra),Ct=r(Ra,"P",{"data-svelte-h":!0}),w(Ct)!=="svelte-1s3c06i"&&(Ct.innerHTML=ci),Ra.forEach(s),go=a(N),Ue=r(N,"DIV",{class:!0});var Xa=y(Ue);c(Zn.$$.fragment,Xa),uo=a(Xa),Wt=r(Xa,"P",{"data-svelte-h":!0}),w(Wt)!=="svelte-pkn4ui"&&(Wt.innerHTML=mi),Xa.forEach(s),fo=a(N),ke=r(N,"DIV",{class:!0});var Fa=y(ke);c(Cn.$$.fragment,Fa),ho=a(Fa),Et=r(Fa,"P",{"data-svelte-h":!0}),w(Et)!=="svelte-14bnrb6"&&(Et.textContent=gi),Fa.forEach(s),_o=a(N),je=r(N,"DIV",{class:!0});var Ha=y(je);c(Wn.$$.fragment,Ha),wo=a(Ha),Lt=r(Ha,"P",{"data-svelte-h":!0}),w(Lt)!=="svelte-1xwrf7t"&&(Lt.textContent=ui),Ha.forEach(s),bo=a(N),Nt=r(N,"DIV",{class:!0});var vi=y(Nt);c(En.$$.fragment,vi),vi.forEach(s),N.forEach(s),ya=a(e),c(Ln.$$.fragment,e),Ia=a(e),G=r(e,"DIV",{class:!0});var Pe=y(G);c(Nn.$$.fragment,Pe),yo=a(Pe),Gt=r(Pe,"P",{"data-svelte-h":!0}),w(Gt)!=="svelte-cjiar3"&&(Gt.textContent=fi),Io=a(Pe),Y=r(Pe,"DIV",{class:!0});var Dt=y(Y);c(Gn.$$.fragment,Dt),vo=a(Dt),Bt=r(Dt,"P",{"data-svelte-h":!0}),w(Bt)!=="svelte-v78lg8"&&(Bt.textContent=hi),Mo=a(Dt),c($e.$$.fragment,Dt),Dt.forEach(s),To=a(Pe),Vt=r(Pe,"DIV",{class:!0});var Mi=y(Vt);c(Bn.$$.fragment,Mi),Mi.forEach(s),Pe.forEach(s),va=a(e),c(Vn.$$.fragment,e),Ma=a(e),D=r(e,"DIV",{class:!0});var Ya=y(D);c(qn.$$.fragment,Ya),xo=a(Ya),qt=r(Ya,"P",{"data-svelte-h":!0}),w(qt)!=="svelte-1qpjiuf"&&(qt.textContent=_i),Ya.forEach(s),Ta=a(e),c(Rn.$$.fragment,e),xa=a(e),zt=r(e,"P",{}),y(zt).forEach(s),this.h()},h(){I(d,"name","hf:doc:metadata"),I(d,"content",Vi),I(T,"class","flex flex-wrap space-x-1"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){n(document.head,d),h(e,x,l),h(e,b,l),h(e,_,l),m(M,e,l),h(e,o,l),h(e,T,l),h(e,St,l),h(e,Ze,l),h(e,Ot,l),h(e,Ce,l),h(e,Kt,l),h(e,We,l),h(e,ea,l),m(O,e,l),h(e,na,l),m(Ee,e,l),h(e,ta,l),h(e,Le,l),h(e,aa,l),h(e,K,l),n(K,An),n(K,Da),m(Ne,K,null),h(e,sa,l),m(ee,e,l),h(e,oa,l),m(Ge,e,l),h(e,ia,l),h(e,Be,l),h(e,ra,l),m(Ve,e,l),h(e,la,l),m(qe,e,l),h(e,da,l),h(e,J,l),m(Re,J,null),n(J,za),n(J,Sn),n(J,Aa),n(J,V),m(Xe,V,null),n(V,Sa),n(V,On),n(V,Oa),m(ne,V,null),n(J,Ka),n(J,te),m(Fe,te,null),n(te,es),n(te,Kn),n(J,ns),n(J,ae),m(He,ae,null),n(ae,ts),n(ae,et),n(J,as),n(J,se),m(Ye,se,null),n(se,ss),n(se,nt),n(J,os),n(J,oe),m(De,oe,null),n(oe,is),n(oe,tt),n(J,rs),n(J,at),m(ze,at,null),h(e,pa,l),m(Ae,e,l),h(e,ca,l),h(e,Q,l),m(Se,Q,null),n(Q,ls),n(Q,st),n(Q,ds),n(Q,q),m(Oe,q,null),n(q,ps),n(q,ot),n(q,cs),m(ie,q,null),n(Q,ms),n(Q,re),m(Ke,re,null),n(re,gs),n(re,it),n(Q,us),n(Q,le),m(en,le,null),n(le,fs),n(le,rt),n(Q,hs),n(Q,de),m(nn,de,null),n(de,_s),n(de,lt),n(Q,ws),n(Q,pe),m(tn,pe,null),n(pe,bs),n(pe,dt),n(Q,ys),n(Q,pt),m(an,pt,null),h(e,ma,l),m(sn,e,l),h(e,ga,l),h(e,U,l),m(on,U,null),n(U,Is),n(U,ct),n(U,vs),n(U,R),m(rn,R,null),n(R,Ms),n(R,mt),n(R,Ts),m(ce,R,null),n(U,xs),n(U,me),m(ln,me,null),n(me,Js),n(me,gt),n(U,Qs),n(U,ge),m(dn,ge,null),n(ge,Us),n(ge,ut),n(U,ks),n(U,ue),m(pn,ue,null),n(ue,js),n(ue,ft),n(U,$s),n(U,fe),m(cn,fe,null),n(fe,Ps),n(fe,ht),n(U,Zs),n(U,_t),m(mn,_t,null),h(e,ua,l),m(gn,e,l),h(e,fa,l),h(e,k,l),m(un,k,null),n(k,Cs),n(k,wt),n(k,Ws),n(k,X),m(fn,X,null),n(X,Es),n(X,bt),n(X,Ls),m(he,X,null),n(k,Ns),n(k,_e),m(hn,_e,null),n(_e,Gs),n(_e,yt),n(k,Bs),n(k,we),m(_n,we,null),n(we,Vs),n(we,It),n(k,qs),n(k,be),m(wn,be,null),n(be,Rs),n(be,vt),n(k,Xs),n(k,ye),m(bn,ye,null),n(ye,Fs),n(ye,Mt),n(k,Hs),n(k,Tt),m(yn,Tt,null),h(e,ha,l),m(In,e,l),h(e,_a,l),h(e,j,l),m(vn,j,null),n(j,Ys),n(j,xt),n(j,Ds),n(j,F),m(Mn,F,null),n(F,zs),n(F,Jt),n(F,As),m(Ie,F,null),n(j,Ss),n(j,ve),m(Tn,ve,null),n(ve,Os),n(ve,Qt),n(j,Ks),n(j,Me),m(xn,Me,null),n(Me,eo),n(Me,Ut),n(j,no),n(j,Te),m(Jn,Te,null),n(Te,to),n(Te,kt),n(j,ao),n(j,xe),m(Qn,xe,null),n(xe,so),n(xe,jt),n(j,oo),n(j,$t),m(Un,$t,null),h(e,wa,l),m(kn,e,l),h(e,ba,l),h(e,$,l),m(jn,$,null),n($,io),n($,Pt),n($,ro),n($,H),m($n,H,null),n(H,lo),n(H,Zt),n(H,po),m(Je,H,null),n($,co),n($,Qe),m(Pn,Qe,null),n(Qe,mo),n(Qe,Ct),n($,go),n($,Ue),m(Zn,Ue,null),n(Ue,uo),n(Ue,Wt),n($,fo),n($,ke),m(Cn,ke,null),n(ke,ho),n(ke,Et),n($,_o),n($,je),m(Wn,je,null),n(je,wo),n(je,Lt),n($,bo),n($,Nt),m(En,Nt,null),h(e,ya,l),m(Ln,e,l),h(e,Ia,l),h(e,G,l),m(Nn,G,null),n(G,yo),n(G,Gt),n(G,Io),n(G,Y),m(Gn,Y,null),n(Y,vo),n(Y,Bt),n(Y,Mo),m($e,Y,null),n(G,To),n(G,Vt),m(Bn,Vt,null),h(e,va,l),m(Vn,e,l),h(e,Ma,l),h(e,D,l),m(qn,D,null),n(D,xo),n(D,qt),h(e,Ta,l),m(Rn,e,l),h(e,xa,l),h(e,zt,l),Ja=!0},p(e,[l]){const Xn={};l&2&&(Xn.$$scope={dirty:l,ctx:e}),O.$set(Xn);const Z={};l&2&&(Z.$$scope={dirty:l,ctx:e}),ee.$set(Z);const z={};l&2&&(z.$$scope={dirty:l,ctx:e}),ne.$set(z);const Fn={};l&2&&(Fn.$$scope={dirty:l,ctx:e}),ie.$set(Fn);const Hn={};l&2&&(Hn.$$scope={dirty:l,ctx:e}),ce.$set(Hn);const Yn={};l&2&&(Yn.$$scope={dirty:l,ctx:e}),he.$set(Yn);const Dn={};l&2&&(Dn.$$scope={dirty:l,ctx:e}),Ie.$set(Dn);const At={};l&2&&(At.$$scope={dirty:l,ctx:e}),Je.$set(At);const C={};l&2&&(C.$$scope={dirty:l,ctx:e}),$e.$set(C)},i(e){Ja||(g(M.$$.fragment,e),g(O.$$.fragment,e),g(Ee.$$.fragment,e),g(Ne.$$.fragment,e),g(ee.$$.fragment,e),g(Ge.$$.fragment,e),g(Ve.$$.fragment,e),g(qe.$$.fragment,e),g(Re.$$.fragment,e),g(Xe.$$.fragment,e),g(ne.$$.fragment,e),g(Fe.$$.fragment,e),g(He.$$.fragment,e),g(Ye.$$.fragment,e),g(De.$$.fragment,e),g(ze.$$.fragment,e),g(Ae.$$.fragment,e),g(Se.$$.fragment,e),g(Oe.$$.fragment,e),g(ie.$$.fragment,e),g(Ke.$$.fragment,e),g(en.$$.fragment,e),g(nn.$$.fragment,e),g(tn.$$.fragment,e),g(an.$$.fragment,e),g(sn.$$.fragment,e),g(on.$$.fragment,e),g(rn.$$.fragment,e),g(ce.$$.fragment,e),g(ln.$$.fragment,e),g(dn.$$.fragment,e),g(pn.$$.fragment,e),g(cn.$$.fragment,e),g(mn.$$.fragment,e),g(gn.$$.fragment,e),g(un.$$.fragment,e),g(fn.$$.fragment,e),g(he.$$.fragment,e),g(hn.$$.fragment,e),g(_n.$$.fragment,e),g(wn.$$.fragment,e),g(bn.$$.fragment,e),g(yn.$$.fragment,e),g(In.$$.fragment,e),g(vn.$$.fragment,e),g(Mn.$$.fragment,e),g(Ie.$$.fragment,e),g(Tn.$$.fragment,e),g(xn.$$.fragment,e),g(Jn.$$.fragment,e),g(Qn.$$.fragment,e),g(Un.$$.fragment,e),g(kn.$$.fragment,e),g(jn.$$.fragment,e),g($n.$$.fragment,e),g(Je.$$.fragment,e),g(Pn.$$.fragment,e),g(Zn.$$.fragment,e),g(Cn.$$.fragment,e),g(Wn.$$.fragment,e),g(En.$$.fragment,e),g(Ln.$$.fragment,e),g(Nn.$$.fragment,e),g(Gn.$$.fragment,e),g($e.$$.fragment,e),g(Bn.$$.fragment,e),g(Vn.$$.fragment,e),g(qn.$$.fragment,e),g(Rn.$$.fragment,e),Ja=!0)},o(e){u(M.$$.fragment,e),u(O.$$.fragment,e),u(Ee.$$.fragment,e),u(Ne.$$.fragment,e),u(ee.$$.fragment,e),u(Ge.$$.fragment,e),u(Ve.$$.fragment,e),u(qe.$$.fragment,e),u(Re.$$.fragment,e),u(Xe.$$.fragment,e),u(ne.$$.fragment,e),u(Fe.$$.fragment,e),u(He.$$.fragment,e),u(Ye.$$.fragment,e),u(De.$$.fragment,e),u(ze.$$.fragment,e),u(Ae.$$.fragment,e),u(Se.$$.fragment,e),u(Oe.$$.fragment,e),u(ie.$$.fragment,e),u(Ke.$$.fragment,e),u(en.$$.fragment,e),u(nn.$$.fragment,e),u(tn.$$.fragment,e),u(an.$$.fragment,e),u(sn.$$.fragment,e),u(on.$$.fragment,e),u(rn.$$.fragment,e),u(ce.$$.fragment,e),u(ln.$$.fragment,e),u(dn.$$.fragment,e),u(pn.$$.fragment,e),u(cn.$$.fragment,e),u(mn.$$.fragment,e),u(gn.$$.fragment,e),u(un.$$.fragment,e),u(fn.$$.fragment,e),u(he.$$.fragment,e),u(hn.$$.fragment,e),u(_n.$$.fragment,e),u(wn.$$.fragment,e),u(bn.$$.fragment,e),u(yn.$$.fragment,e),u(In.$$.fragment,e),u(vn.$$.fragment,e),u(Mn.$$.fragment,e),u(Ie.$$.fragment,e),u(Tn.$$.fragment,e),u(xn.$$.fragment,e),u(Jn.$$.fragment,e),u(Qn.$$.fragment,e),u(Un.$$.fragment,e),u(kn.$$.fragment,e),u(jn.$$.fragment,e),u($n.$$.fragment,e),u(Je.$$.fragment,e),u(Pn.$$.fragment,e),u(Zn.$$.fragment,e),u(Cn.$$.fragment,e),u(Wn.$$.fragment,e),u(En.$$.fragment,e),u(Ln.$$.fragment,e),u(Nn.$$.fragment,e),u(Gn.$$.fragment,e),u($e.$$.fragment,e),u(Bn.$$.fragment,e),u(Vn.$$.fragment,e),u(qn.$$.fragment,e),u(Rn.$$.fragment,e),Ja=!1},d(e){e&&(s(x),s(b),s(_),s(o),s(T),s(St),s(Ze),s(Ot),s(Ce),s(Kt),s(We),s(ea),s(na),s(ta),s(Le),s(aa),s(K),s(sa),s(oa),s(ia),s(Be),s(ra),s(la),s(da),s(J),s(pa),s(ca),s(Q),s(ma),s(ga),s(U),s(ua),s(fa),s(k),s(ha),s(_a),s(j),s(wa),s(ba),s($),s(ya),s(Ia),s(G),s(va),s(Ma),s(D),s(Ta),s(xa),s(zt)),s(d),f(M,e),f(O,e),f(Ee,e),f(Ne),f(ee,e),f(Ge,e),f(Ve,e),f(qe,e),f(Re),f(Xe),f(ne),f(Fe),f(He),f(Ye),f(De),f(ze),f(Ae,e),f(Se),f(Oe),f(ie),f(Ke),f(en),f(nn),f(tn),f(an),f(sn,e),f(on),f(rn),f(ce),f(ln),f(dn),f(pn),f(cn),f(mn),f(gn,e),f(un),f(fn),f(he),f(hn),f(_n),f(wn),f(bn),f(yn),f(In,e),f(vn),f(Mn),f(Ie),f(Tn),f(xn),f(Jn),f(Qn),f(Un),f(kn,e),f(jn),f($n),f(Je),f(Pn),f(Zn),f(Cn),f(Wn),f(En),f(Ln,e),f(Nn),f(Gn),f($e),f(Bn),f(Vn,e),f(qn),f(Rn,e)}}}const Vi='{"title":"QwenImage","local":"qwenimage","sections":[{"title":"LoRA for faster inference","local":"lora-for-faster-inference","sections":[],"depth":2},{"title":"Multi-image reference with QwenImageEditPlusPipeline","local":"multi-image-reference-with-qwenimageeditpluspipeline","sections":[],"depth":2},{"title":"QwenImagePipeline","local":"diffusers.QwenImagePipeline","sections":[],"depth":2},{"title":"QwenImageImg2ImgPipeline","local":"diffusers.QwenImageImg2ImgPipeline","sections":[],"depth":2},{"title":"QwenImageInpaintPipeline","local":"diffusers.QwenImageInpaintPipeline","sections":[],"depth":2},{"title":"QwenImageEditPipeline","local":"diffusers.QwenImageEditPipeline","sections":[],"depth":2},{"title":"QwenImageEditInpaintPipeline","local":"diffusers.QwenImageEditInpaintPipeline","sections":[],"depth":2},{"title":"QwenImageControlNetPipeline","local":"diffusers.QwenImageControlNetPipeline","sections":[],"depth":2},{"title":"QwenImageEditPlusPipeline","local":"diffusers.QwenImageEditPlusPipeline","sections":[],"depth":2},{"title":"QwenImagePipelineOutput","local":"diffusers.pipelines.qwenimage.pipeline_output.QwenImagePipelineOutput","sections":[],"depth":2}],"depth":1}';function qi(P){return Ji(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ai extends Qi{constructor(d){super(),Ui(this,d,qi,Bi,xi,{})}}export{Ai as component};
