import{s as ht,f as It,n as At,o as ft}from"../chunks/scheduler.65852ee5.js";import{S as Ct,i as gt,g as M,s as a,r as i,A as bt,h as p,f as t,c as n,j as Xs,u as j,x as y,k as d,y as $t,a as e,v as o,d as J,t as T,w as r}from"../chunks/index.aa74147d.js";import{D as Bt,C as c}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as w,E as Zt}from"../chunks/getInferenceSnippets.d34c235c.js";function Gt(Fs){let m,Zl,$l,Gl,I,ql,h,El,A,Hs='<em>作者：<a href="https://huggingface.co/davidberenstein1957" rel="nofollow">David Berenstein</a> 和 <a href="https://huggingface.co/sdiazlor" rel="nofollow">Sara Han Díaz</a></em>',Vl,f,Ss='<li><strong>库</strong>: <a href="https://github.com/argilla-io/argilla" rel="nofollow">argilla</a>, <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">hf-inference-endpoints</a></li> <li><strong>组件</strong>: <a href="https://distilabel.argilla.io/dev/components-gallery/steps/loaddatafromdicts/" rel="nofollow">LoadDataFromDicts</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/tasks/ultrafeedback/" rel="nofollow">UltraFeedback</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/groupcolumns/" rel="nofollow">KeepColumns</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/textgenerationtoargilla/" rel="nofollow">PreferenceToArgilla</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/llms/inferenceendpointsllm/" rel="nofollow">InferenceEndpointsLLM</a>, <a href="https://distilabel.argilla.io/latest/sections/how_to_guides/basic/step/global_step/" rel="nofollow">GlobalStep</a></li>',Wl,C,xs='在本教程中，我们将使用 <strong>distilabel</strong> 清理数据集，利用大型语言模型（LLMs）作为评审者，通过提供 AI 反馈来评估数据的质量。<a href="https://github.com/argilla-io/distilabel" rel="nofollow">distilabel</a> 是一个用于工程师的合成数据和 AI 反馈框架，帮助快速、可靠且可扩展地构建基于经过验证的研究论文的管道。查看文档 <a href="https://distilabel.argilla.io/latest/" rel="nofollow">这里</a>。',kl,g,Ys='为了评估响应，我们将使用与 distilabel 集成的 <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">无服务器 HF 推理 API</a>。该服务免费但有请求限制，允许你通过简单的 HTTP 请求测试和评估超过 150,000 个公开模型，或者使用你自己的私有模型，推理任务在 Hugging Face 共享基础设施上进行。如果需要更多计算能力，您可以使用 <a href="https://huggingface.co/docs/inference-endpoints/guides/create_endpoint" rel="nofollow">Hugging Face 推理端点</a> 部署自己的推理端点。',_l,b,zs='最后，为了进一步整理数据，我们将使用 <a href="https://github.com/argilla-io/argilla" rel="nofollow">Argilla</a>，它允许我们对数据质量提供人工反馈。Argilla 是一个为 AI 工程师和领域专家提供的协作工具，帮助他们为项目构建高质量的数据集。查看文档 <a href="https://docs.argilla.io/latest/" rel="nofollow">这里</a>。',Ql,$,Nl,B,vl,Z,Ls="为了完成本教程，你需要通过 pip 安装 distilabel SDK 和一些第三方库。",Rl,G,Xl,q,Fl,E,Ds="让我们进行必要的导入：",Hl,V,Sl,W,Ps="你需要一个 <code>HF_TOKEN</code> 才能使用 HF 推理端点。在此 Notebook 中直接登录以使用它。",xl,k,Yl,_,zl,Q,Ks='你可以跳过此步骤，或者将其替换为任何其他数据评估工具，但如果缺乏数据质量，模型的性能将受到影响，因此我们建议你查看你的数据。如果你已经部署了 Argilla，可以跳过此步骤。否则，你可以按照 <a href="https://docs.argilla.io/latest/getting_started/quickstart/" rel="nofollow">此指南</a> 快速部署 Argilla。',Ll,N,Os="同时，你需要将 Argilla 作为 distilabel 的附加组件安装。",Dl,v,Pl,R,Kl,X,lt='在这种情况下，我们将清理一个偏好数据集，因此我们将使用 Hugging Face Hub 上的 <a href="https://huggingface.co/datasets/Intel/orca_dpo_pairs" rel="nofollow"><code>Intel/orca_dpo_pairs</code></a> 数据集。',Ol,u,st,ls,F,ss,H,tt="接下来，我们将打乱 <code>chosen</code> 和 <code>rejected</code> 列，以避免数据集中的任何偏差。",ts,S,es,x,as,Y,ns,z,et='步骤是 distilabel 管道中的一个模块，用于操作、生成或评估数据等任务。提供了一组预定义的步骤，但你也可以创建 <a href="https://distilabel.argilla.io/latest/sections/how_to_guides/basic/step/#defining-custom-steps" rel="nofollow">自定义步骤</a>。与之前章节中的数据预处理不同，你可以使用自定义步骤来打乱列。这个步骤应该放在一个单独的模块中，以便导入并在管道中使用。在这种情况下，管道将首先使用 <code>LoadDataFromHub</code> 步骤加载 <code>orca_dpo_pairs</code> 数据集，然后应用 <code>ShuffleStep</code> 步骤。',Ms,L,ps,D,is,P,js,K,at="为了清理一个现有的偏好数据集，我们需要定义一个包含所有必要步骤的 <code>Pipeline</code>。类似的工作流也可以用于清理 SFT（监督微调）数据集。接下来，我们将详细讲解每个步骤。",os,O,Js,ll,nt="我们将使用刚才打乱的数据集作为源数据。",Ts,sl,Mt="<li>组件：<code>LoadDataFromDicts</code></li> <li>输入列：<code>system</code>、<code>question</code>、<code>chosen</code>、<code>rejected</code>、<code>generations</code> 和 <code>order</code>，与加载的字典列表中的键相同。</li> <li>输出列：<code>system</code>、<code>instruction</code>、<code>chosen</code>、<code>rejected</code>、<code>generations</code> 和 <code>order</code>。我们将使用 <code>output_mappings</code> 来重命名列。</li>",rs,tl,ys,el,cs,al,pt='为了评估响应的质量，我们将使用 <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-70B-Instruct" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-70B-Instruct</code></a>，并应用 <code>UltraFeedback</code> 任务，根据不同维度（如有用性、诚实性、遵循指令的能力、真实性）来评判响应。对于 SFT 数据集，您可以改用 <a href="../papers/prometheus.md"><code>PrometheusEval</code></a>。',ws,nl,it="<li>组件：使用 <code>InferenceEndpointsLLM</code> 的 <code>UltraFeedback</code> 任务</li> <li>输入列：<code>instruction</code>、<code>generations</code></li> <li>输出列：<code>ratings</code>、<code>rationales</code>、<code>distilabel_metadata</code>、<code>model_name</code></li>",us,Ml,jt='根据你的使用场景并为了提高结果，你可以使用任何 <a href="https://distilabel.argilla.io/latest/components-gallery/llms/" rel="nofollow">你选择的其他 LLM</a>。',Us,pl,ds,il,ms,jl,ot="我们将去除不需要的列。",Is,ol,Jt="<li>组件：<code>KeepColumns</code></li> <li>输入列：<code>system</code>、<code>instruction</code>、<code>chosen</code>、<code>rejected</code>、<code>generations</code>、<code>ratings</code>、<code>rationales</code>、<code>distilabel_metadata</code> 和 <code>model_name</code></li> <li>输出列：<code>instruction</code>、<code>chosen</code>、<code>rejected</code>、<code>generations</code> 和 <code>order</code></li>",hs,Jl,As,Tl,fs,rl,Tt="你可以使用 Argilla 进一步整理您的数据。",Cs,yl,rt="<li>组件：<code>PreferenceToArgilla</code> 步骤</li> <li>输入列：<code>instruction</code>、<code>generations</code>、<code>generation_models</code>、<code>ratings</code></li> <li>输出列：<code>instruction</code>、<code>generations</code>、<code>generation_models</code>、<code>ratings</code></li>",gs,cl,bs,wl,$s,ul,yt="下面，你可以看到完整管道定义:",Bs,Ul,Zs,dl,ct="现在我们来运行管道，清理我们的偏好数据集。",Gs,ml,qs,Il,wt='让我们检查一下！如果你已经将数据加载到 Argilla 中，你可以在 <a href="https://docs.argilla.io/latest/how_to_guides/annotate/" rel="nofollow">Argilla UI 中开始标注</a>。',Es,hl,ut='你可以将数据集推送到 Hub 以便与社区共享，并 <a href="https://huggingface.co/docs/hub/datasets-viewer-embed" rel="nofollow">嵌入它以探索数据</a>。',Vs,Al,Ws,U,Ut,ks,fl,_s,Cl,dt="在本教程中，我们展示了使用 distilabel 构建清理偏好数据集管道的详细步骤。然而，你可以根据自己的使用场景自定义此管道，例如清理 SFT 数据集或添加自定义步骤。",Qs,gl,mt="我们以一个偏好数据集作为起点，并通过打乱数据来避免任何偏差。接下来，我们使用一个模型通过无服务器的 Hugging Face 推理 API 评估了响应，遵循了 UltraFeedback 标准。最后，我们保留了必要的列，并使用 Argilla 进行了进一步的数据整理。",Ns,bl,vs,Bl,Rs;return I=new Bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/clean_dataset_judges_distilabel.ipynb"}]}}),h=new w({props:{title:"使用大型语言模型作为评审者清理现有的偏好数据集",local:"使用大型语言模型作为评审者清理现有的偏好数据集",headingTag:"h2"}}),$=new w({props:{title:"开始",local:"开始",headingTag:"h2"}}),B=new w({props:{title:"安装依赖",local:"安装依赖",headingTag:"h3"}}),G=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCaGYtaW5mZXJlbmNlLWVuZHBvaW50cyU1RCUyMg==",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[hf-inference-endpoints]&quot;</span>',wrap:!1}}),q=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnN+JTNENC4wJTIyJTIwJTIydG9yY2h+JTNEMi4wJTIy",highlighted:'!pip install <span class="hljs-string">&quot;transformers~=4.0&quot;</span> <span class="hljs-string">&quot;torch~=2.0&quot;</span>',wrap:!1}}),V=new c({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZnJvbSUyMGRpc3RpbGFiZWwubGxtcyUyMGltcG9ydCUyMEluZmVyZW5jZUVuZHBvaW50c0xMTSUwQWZyb20lMjBkaXN0aWxhYmVsLnBpcGVsaW5lJTIwaW1wb3J0JTIwUGlwZWxpbmUlMEFmcm9tJTIwZGlzdGlsYWJlbC5zdGVwcyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBLZWVwQ29sdW1ucyUyQyUwQSUyMCUyMCUyMCUyMExvYWREYXRhRnJvbURpY3RzJTJDJTBBJTIwJTIwJTIwJTIwUHJlZmVyZW5jZVRvQXJnaWxsYSUyQyUwQSklMEFmcm9tJTIwZGlzdGlsYWJlbC5zdGVwcy50YXNrcyUyMGltcG9ydCUyMFVsdHJhRmVlZGJhY2s=",highlighted:`<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-keyword">from</span> distilabel.llms <span class="hljs-keyword">import</span> InferenceEndpointsLLM
<span class="hljs-keyword">from</span> distilabel.pipeline <span class="hljs-keyword">import</span> Pipeline
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> (
    KeepColumns,
    LoadDataFromDicts,
    PreferenceToArgilla,
)
<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> UltraFeedback`,wrap:!1}}),k=new c({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbG9naW4lMEElMEFsb2dpbih0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMkMlMjBhZGRfdG9fZ2l0X2NyZWRlbnRpYWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login(token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>), add_to_git_credential=<span class="hljs-literal">True</span>)`,wrap:!1}}),_=new w({props:{title:"（可选）部署 Argilla",local:"可选部署-argilla",headingTag:"h3"}}),v=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCYXJnaWxsYSUyQyUyMGhmLWluZmVyZW5jZS1lbmRwb2ludHMlNUQlMjI=",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[argilla, hf-inference-endpoints]&quot;</span>',wrap:!1}}),R=new w({props:{title:"数据集",local:"数据集",headingTag:"h2"}}),F=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJJbnRlbCUyRm9yY2FfZHBvX3BhaXJzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTIwJTVEJTIyKQ==",highlighted:'dataset = load_dataset(<span class="hljs-string">&quot;Intel/orca_dpo_pairs&quot;</span>, split=<span class="hljs-string">&quot;train[:20]&quot;</span>)',wrap:!1}}),S=new c({props:{code:"ZGVmJTIwc2h1ZmZsZV9hbmRfdHJhY2soY2hvc2VuJTJDJTIwcmVqZWN0ZWQpJTNBJTBBJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMCU1QmNob3NlbiUyQyUyMHJlamVjdGVkJTVEJTBBJTIwJTIwJTIwJTIwcmFuZG9tLnNodWZmbGUocGFpciklMEElMjAlMjAlMjAlMjBvcmRlciUyMCUzRCUyMCU1QiUyMmNob3NlbiUyMiUyMGlmJTIweCUyMCUzRCUzRCUyMGNob3NlbiUyMGVsc2UlMjAlMjJyZWplY3RlZCUyMiUyMGZvciUyMHglMjBpbiUyMHBhaXIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJnZW5lcmF0aW9ucyUyMiUzQSUyMHBhaXIlMkMlMjAlMjJvcmRlciUyMiUzQSUyMG9yZGVyJTdEJTBBJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjBzaHVmZmxlX2FuZF90cmFjayh4JTVCJTIyY2hvc2VuJTIyJTVEJTJDJTIweCU1QiUyMnJlamVjdGVkJTIyJTVEKSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">shuffle_and_track</span>(<span class="hljs-params">chosen, rejected</span>):
    pair = [chosen, rejected]
    random.shuffle(pair)
    order = [<span class="hljs-string">&quot;chosen&quot;</span> <span class="hljs-keyword">if</span> x == chosen <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;rejected&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> pair]
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;generations&quot;</span>: pair, <span class="hljs-string">&quot;order&quot;</span>: order}


dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: shuffle_and_track(x[<span class="hljs-string">&quot;chosen&quot;</span>], x[<span class="hljs-string">&quot;rejected&quot;</span>]))`,wrap:!1}}),x=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9fbGlzdCgp",highlighted:"dataset = dataset.to_list()",wrap:!1}}),Y=new w({props:{title:"（可选）创建自定义步骤",local:"可选创建自定义步骤",headingTag:"h3"}}),L=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># &quot;shuffle_step.py&quot;</span>
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TYPE_CHECKING, <span class="hljs-type">List</span>
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> GlobalStep, StepInput

<span class="hljs-keyword">if</span> TYPE_CHECKING:
    <span class="hljs-keyword">from</span> distilabel.steps.typing <span class="hljs-keyword">import</span> StepOutput

<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ShuffleStep</span>(<span class="hljs-title class_ inherited__">GlobalStep</span>):
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;instruction&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>]

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">outputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;instruction&quot;</span>, <span class="hljs-string">&quot;generations&quot;</span>, <span class="hljs-string">&quot;order&quot;</span>]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">process</span>(<span class="hljs-params">self, inputs: StepInput</span>) -&gt; <span class="hljs-string">&quot;StepOutput&quot;</span>:
        outputs = []

        <span class="hljs-keyword">for</span> <span class="hljs-built_in">input</span> <span class="hljs-keyword">in</span> inputs:
            chosen = <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;chosen&quot;</span>]
            rejected = <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;rejected&quot;</span>]
            pair = [chosen, rejected]
            random.shuffle(pair)
            order = [<span class="hljs-string">&quot;chosen&quot;</span> <span class="hljs-keyword">if</span> x == chosen <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;rejected&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> pair]

            outputs.append({<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;instruction&quot;</span>], <span class="hljs-string">&quot;generations&quot;</span>: pair, <span class="hljs-string">&quot;order&quot;</span>: order})

        <span class="hljs-keyword">yield</span> outputs`,wrap:!1}}),D=new c({props:{code:"ZnJvbSUyMHNodWZmbGVfc3RlcCUyMGltcG9ydCUyMFNodWZmbGVTdGVw",highlighted:'<span class="hljs-keyword">from</span> shuffle_step <span class="hljs-keyword">import</span> ShuffleStep',wrap:!1}}),P=new w({props:{title:"定义管道",local:"定义管道",headingTag:"h2"}}),O=new w({props:{title:"加载数据集",local:"加载数据集",headingTag:"h3"}}),tl=new c({props:{code:"bG9hZF9kYXRhc2V0JTIwJTNEJTIwTG9hZERhdGFGcm9tRGljdHMoJTBBJTIwJTIwJTIwJTIwZGF0YSUzRGRhdGFzZXQlNUIlM0ExJTVEJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X21hcHBpbmdzJTNEJTdCJTIycXVlc3Rpb24lMjIlM0ElMjAlMjJpbnN0cnVjdGlvbiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSklMEFsb2FkX2RhdGFzZXQubG9hZCgpJTBBbmV4dChsb2FkX2RhdGFzZXQucHJvY2VzcygpKQ==",highlighted:`load_dataset = LoadDataFromDicts(
    data=dataset[:<span class="hljs-number">1</span>],
    output_mappings={<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;instruction&quot;</span>},
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
load_dataset.load()
<span class="hljs-built_in">next</span>(load_dataset.process())`,wrap:!1}}),el=new w({props:{title:"评估响应",local:"评估响应",headingTag:"h3"}}),pl=new c({props:{code:"ZXZhbHVhdGVfcmVzcG9uc2VzJTIwJTNEJTIwVWx0cmFGZWVkYmFjayglMEElMjAlMjAlMjAlMjBhc3BlY3QlM0QlMjJvdmVyYWxsLXJhdGluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzREluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS03MEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbml6ZXJfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLjEtNzBCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9rd2FyZ3MlM0QlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDUxMiUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMC43JTdEJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSklMEFldmFsdWF0ZV9yZXNwb25zZXMubG9hZCgpJTBBbmV4dCglMEElMjAlMjAlMjAlMjBldmFsdWF0ZV9yZXNwb25zZXMucHJvY2VzcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMCUyMldoYXQncyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMFNwYWluJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZ2VuZXJhdGlvbnMlMjIlM0ElMjAlNUIlMjJNYWRyaWQlMjIlMkMlMjAlMjJCYXJjZWxvbmElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`evaluate_responses = UltraFeedback(
    aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
    llm=InferenceEndpointsLLM(
        model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
        tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
        generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
    ),
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
evaluate_responses.load()
<span class="hljs-built_in">next</span>(
    evaluate_responses.process(
        [
            {
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
            }
        ]
    )
)`,wrap:!1}}),il=new w({props:{title:"仅保留必要的列",local:"仅保留必要的列",headingTag:"h3"}}),Jl=new c({props:{code:"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",highlighted:`keep_columns = KeepColumns(
    columns=[
        <span class="hljs-string">&quot;instruction&quot;</span>,
        <span class="hljs-string">&quot;generations&quot;</span>,
        <span class="hljs-string">&quot;order&quot;</span>,
        <span class="hljs-string">&quot;ratings&quot;</span>,
        <span class="hljs-string">&quot;rationales&quot;</span>,
        <span class="hljs-string">&quot;model_name&quot;</span>,
    ],
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
keep_columns.load()
<span class="hljs-built_in">next</span>(
    keep_columns.process(
        [
            {
                <span class="hljs-string">&quot;system&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot;Madrid&quot;</span>,
                <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot;Barcelona&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
                <span class="hljs-string">&quot;order&quot;</span>: [<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>],
                <span class="hljs-string">&quot;ratings&quot;</span>: [<span class="hljs-number">5</span>, <span class="hljs-number">1</span>],
                <span class="hljs-string">&quot;rationales&quot;</span>: [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
                <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            }
        ]
    )
)`,wrap:!1}}),Tl=new w({props:{title:"（可选）进一步的数据整理",local:"可选进一步的数据整理",headingTag:"h3"}}),cl=new c({props:{code:"dG9fYXJnaWxsYSUyMCUzRCUyMFByZWZlcmVuY2VUb0FyZ2lsbGEoJTBBJTIwJTIwJTIwJTIwZGF0YXNldF9uYW1lJTNEJTIyY2xlYW5lZC1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF93b3Jrc3BhY2UlM0QlMjJhcmdpbGxhJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGJTVCeW91ci1vd25lci1uYW1lJTVELSU1QnlvdXItc3BhY2UtbmFtZSU1RC5oZi5zcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjIlNUJ5b3VyLWFwaS1rZXklNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fZ2VuZXJhdGlvbnMlM0QyJTJDJTBBKQ==",highlighted:`to_argilla = PreferenceToArgilla(
    dataset_name=<span class="hljs-string">&quot;cleaned-dataset&quot;</span>,
    dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
    api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
    api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
    num_generations=<span class="hljs-number">2</span>,
)`,wrap:!1}}),wl=new w({props:{title:"运行管道",local:"运行管道",headingTag:"h2"}}),Ul=new c({props:{code:"d2l0aCUyMFBpcGVsaW5lKG5hbWUlM0QlMjJjbGVhbi1kYXRhc2V0JTIyKSUyMGFzJTIwcGlwZWxpbmUlM0ElMEElMEElMjAlMjAlMjAlMjBsb2FkX2RhdGFzZXQlMjAlM0QlMjBMb2FkRGF0YUZyb21EaWN0cyhkYXRhJTNEZGF0YXNldCUyQyUyMG91dHB1dF9tYXBwaW5ncyUzRCU3QiUyMnF1ZXN0aW9uJTIyJTNBJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlN0QpJTBBJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGVfcmVzcG9uc2VzJTIwJTNEJTIwVWx0cmFGZWVkYmFjayglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhc3BlY3QlM0QlMjJvdmVyYWxsLXJhdGluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxsbSUzREluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS03MEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbml6ZXJfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLjEtNzBCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9rd2FyZ3MlM0QlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDUxMiUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMC43JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBrZWVwX2NvbHVtbnMlMjAlM0QlMjBLZWVwQ29sdW1ucyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb2x1bW5zJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJnZW5lcmF0aW9ucyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9yZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmF0aW5ncyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJhdGlvbmFsZXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtb2RlbF9uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMHRvX2FyZ2lsbGElMjAlM0QlMjBQcmVmZXJlbmNlVG9BcmdpbGxhKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCUyMmNsZWFuZWQtZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfd29ya3NwYWNlJTNEJTIyYXJnaWxsYSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFwaV91cmwlM0QlMjJodHRwcyUzQSUyRiUyRiU1QnlvdXItb3duZXItbmFtZSU1RC0lNUJ5b3VyLXNwYWNlLW5hbWUlNUQuaGYuc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyJTVCeW91ci1hcGkta2V5JTVEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2dlbmVyYXRpb25zJTNEMiUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBsb2FkX2RhdGFzZXQuY29ubmVjdChldmFsdWF0ZV9yZXNwb25zZXMpJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGVfcmVzcG9uc2VzLmNvbm5lY3Qoa2VlcF9jb2x1bW5zKSUwQSUyMCUyMCUyMCUyMGtlZXBfY29sdW1ucy5jb25uZWN0KHRvX2FyZ2lsbGEp",highlighted:`<span class="hljs-keyword">with</span> Pipeline(name=<span class="hljs-string">&quot;clean-dataset&quot;</span>) <span class="hljs-keyword">as</span> pipeline:

    load_dataset = LoadDataFromDicts(data=dataset, output_mappings={<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;instruction&quot;</span>})

    evaluate_responses = UltraFeedback(
        aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
        llm=InferenceEndpointsLLM(
            model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
        ),
    )

    keep_columns = KeepColumns(
        columns=[
            <span class="hljs-string">&quot;instruction&quot;</span>,
            <span class="hljs-string">&quot;generations&quot;</span>,
            <span class="hljs-string">&quot;order&quot;</span>,
            <span class="hljs-string">&quot;ratings&quot;</span>,
            <span class="hljs-string">&quot;rationales&quot;</span>,
            <span class="hljs-string">&quot;model_name&quot;</span>,
        ]
    )

    to_argilla = PreferenceToArgilla(
        dataset_name=<span class="hljs-string">&quot;cleaned-dataset&quot;</span>,
        dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
        api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
        api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
        num_generations=<span class="hljs-number">2</span>,
    )

    load_dataset.connect(evaluate_responses)
    evaluate_responses.connect(keep_columns)
    keep_columns.connect(to_argilla)`,wrap:!1}}),ml=new c({props:{code:"ZGlzdGlzZXQlMjAlM0QlMjBwaXBlbGluZS5ydW4oKQ==",highlighted:"distiset = pipeline.run()",wrap:!1}}),Al=new c({props:{code:"ZGlzdGlzZXQucHVzaF90b19odWIoJTIyJTVCeW91ci1vd25lci1uYW1lJTVEJTJGZXhhbXBsZS1jbGVhbmVkLXByZWZlcmVuY2UtZGF0YXNldCUyMik=",highlighted:'distiset.push_to_hub(<span class="hljs-string">&quot;[your-owner-name]/example-cleaned-preference-dataset&quot;</span>)',wrap:!1}}),fl=new w({props:{title:"总结",local:"总结",headingTag:"h2"}}),bl=new Zt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/clean_dataset_judges_distilabel.md"}}),{c(){m=M("meta"),Zl=a(),$l=M("p"),Gl=a(),i(I.$$.fragment),ql=a(),i(h.$$.fragment),El=a(),A=M("p"),A.innerHTML=Hs,Vl=a(),f=M("ul"),f.innerHTML=Ss,Wl=a(),C=M("p"),C.innerHTML=xs,kl=a(),g=M("p"),g.innerHTML=Ys,_l=a(),b=M("p"),b.innerHTML=zs,Ql=a(),i($.$$.fragment),Nl=a(),i(B.$$.fragment),vl=a(),Z=M("p"),Z.textContent=Ls,Rl=a(),i(G.$$.fragment),Xl=a(),i(q.$$.fragment),Fl=a(),E=M("p"),E.textContent=Ds,Hl=a(),i(V.$$.fragment),Sl=a(),W=M("p"),W.innerHTML=Ps,xl=a(),i(k.$$.fragment),Yl=a(),i(_.$$.fragment),zl=a(),Q=M("p"),Q.innerHTML=Ks,Ll=a(),N=M("p"),N.textContent=Os,Dl=a(),i(v.$$.fragment),Pl=a(),i(R.$$.fragment),Kl=a(),X=M("p"),X.innerHTML=lt,Ol=a(),u=M("iframe"),ls=a(),i(F.$$.fragment),ss=a(),H=M("p"),H.innerHTML=tt,ts=a(),i(S.$$.fragment),es=a(),i(x.$$.fragment),as=a(),i(Y.$$.fragment),ns=a(),z=M("p"),z.innerHTML=et,Ms=a(),i(L.$$.fragment),ps=a(),i(D.$$.fragment),is=a(),i(P.$$.fragment),js=a(),K=M("p"),K.innerHTML=at,os=a(),i(O.$$.fragment),Js=a(),ll=M("p"),ll.textContent=nt,Ts=a(),sl=M("ul"),sl.innerHTML=Mt,rs=a(),i(tl.$$.fragment),ys=a(),i(el.$$.fragment),cs=a(),al=M("p"),al.innerHTML=pt,ws=a(),nl=M("ul"),nl.innerHTML=it,us=a(),Ml=M("p"),Ml.innerHTML=jt,Us=a(),i(pl.$$.fragment),ds=a(),i(il.$$.fragment),ms=a(),jl=M("p"),jl.textContent=ot,Is=a(),ol=M("ul"),ol.innerHTML=Jt,hs=a(),i(Jl.$$.fragment),As=a(),i(Tl.$$.fragment),fs=a(),rl=M("p"),rl.textContent=Tt,Cs=a(),yl=M("ul"),yl.innerHTML=rt,gs=a(),i(cl.$$.fragment),bs=a(),i(wl.$$.fragment),$s=a(),ul=M("p"),ul.textContent=yt,Bs=a(),i(Ul.$$.fragment),Zs=a(),dl=M("p"),dl.textContent=ct,Gs=a(),i(ml.$$.fragment),qs=a(),Il=M("p"),Il.innerHTML=wt,Es=a(),hl=M("p"),hl.innerHTML=ut,Vs=a(),i(Al.$$.fragment),Ws=a(),U=M("iframe"),ks=a(),i(fl.$$.fragment),_s=a(),Cl=M("p"),Cl.textContent=dt,Qs=a(),gl=M("p"),gl.textContent=mt,Ns=a(),i(bl.$$.fragment),vs=a(),Bl=M("p"),this.h()},l(l){const s=bt("svelte-u9bgzb",document.head);m=p(s,"META",{name:!0,content:!0}),s.forEach(t),Zl=n(l),$l=p(l,"P",{}),Xs($l).forEach(t),Gl=n(l),j(I.$$.fragment,l),ql=n(l),j(h.$$.fragment,l),El=n(l),A=p(l,"P",{"data-svelte-h":!0}),y(A)!=="svelte-18u8apm"&&(A.innerHTML=Hs),Vl=n(l),f=p(l,"UL",{"data-svelte-h":!0}),y(f)!=="svelte-119nnf8"&&(f.innerHTML=Ss),Wl=n(l),C=p(l,"P",{"data-svelte-h":!0}),y(C)!=="svelte-lad58m"&&(C.innerHTML=xs),kl=n(l),g=p(l,"P",{"data-svelte-h":!0}),y(g)!=="svelte-1i8rsrr"&&(g.innerHTML=Ys),_l=n(l),b=p(l,"P",{"data-svelte-h":!0}),y(b)!=="svelte-6zyc4i"&&(b.innerHTML=zs),Ql=n(l),j($.$$.fragment,l),Nl=n(l),j(B.$$.fragment,l),vl=n(l),Z=p(l,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-h3ae58"&&(Z.textContent=Ls),Rl=n(l),j(G.$$.fragment,l),Xl=n(l),j(q.$$.fragment,l),Fl=n(l),E=p(l,"P",{"data-svelte-h":!0}),y(E)!=="svelte-1g9f284"&&(E.textContent=Ds),Hl=n(l),j(V.$$.fragment,l),Sl=n(l),W=p(l,"P",{"data-svelte-h":!0}),y(W)!=="svelte-3pmo5z"&&(W.innerHTML=Ps),xl=n(l),j(k.$$.fragment,l),Yl=n(l),j(_.$$.fragment,l),zl=n(l),Q=p(l,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-etg8dh"&&(Q.innerHTML=Ks),Ll=n(l),N=p(l,"P",{"data-svelte-h":!0}),y(N)!=="svelte-hpj2rw"&&(N.textContent=Os),Dl=n(l),j(v.$$.fragment,l),Pl=n(l),j(R.$$.fragment,l),Kl=n(l),X=p(l,"P",{"data-svelte-h":!0}),y(X)!=="svelte-12x6420"&&(X.innerHTML=lt),Ol=n(l),u=p(l,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Xs(u).forEach(t),ls=n(l),j(F.$$.fragment,l),ss=n(l),H=p(l,"P",{"data-svelte-h":!0}),y(H)!=="svelte-1m3502q"&&(H.innerHTML=tt),ts=n(l),j(S.$$.fragment,l),es=n(l),j(x.$$.fragment,l),as=n(l),j(Y.$$.fragment,l),ns=n(l),z=p(l,"P",{"data-svelte-h":!0}),y(z)!=="svelte-bw8lrw"&&(z.innerHTML=et),Ms=n(l),j(L.$$.fragment,l),ps=n(l),j(D.$$.fragment,l),is=n(l),j(P.$$.fragment,l),js=n(l),K=p(l,"P",{"data-svelte-h":!0}),y(K)!=="svelte-kjisqd"&&(K.innerHTML=at),os=n(l),j(O.$$.fragment,l),Js=n(l),ll=p(l,"P",{"data-svelte-h":!0}),y(ll)!=="svelte-1lf7wyh"&&(ll.textContent=nt),Ts=n(l),sl=p(l,"UL",{"data-svelte-h":!0}),y(sl)!=="svelte-hnxjjr"&&(sl.innerHTML=Mt),rs=n(l),j(tl.$$.fragment,l),ys=n(l),j(el.$$.fragment,l),cs=n(l),al=p(l,"P",{"data-svelte-h":!0}),y(al)!=="svelte-1uvhabi"&&(al.innerHTML=pt),ws=n(l),nl=p(l,"UL",{"data-svelte-h":!0}),y(nl)!=="svelte-2fairt"&&(nl.innerHTML=it),us=n(l),Ml=p(l,"P",{"data-svelte-h":!0}),y(Ml)!=="svelte-1iehnu5"&&(Ml.innerHTML=jt),Us=n(l),j(pl.$$.fragment,l),ds=n(l),j(il.$$.fragment,l),ms=n(l),jl=p(l,"P",{"data-svelte-h":!0}),y(jl)!=="svelte-vgutsj"&&(jl.textContent=ot),Is=n(l),ol=p(l,"UL",{"data-svelte-h":!0}),y(ol)!=="svelte-1uxreds"&&(ol.innerHTML=Jt),hs=n(l),j(Jl.$$.fragment,l),As=n(l),j(Tl.$$.fragment,l),fs=n(l),rl=p(l,"P",{"data-svelte-h":!0}),y(rl)!=="svelte-1ug6eg9"&&(rl.textContent=Tt),Cs=n(l),yl=p(l,"UL",{"data-svelte-h":!0}),y(yl)!=="svelte-1dtu78m"&&(yl.innerHTML=rt),gs=n(l),j(cl.$$.fragment,l),bs=n(l),j(wl.$$.fragment,l),$s=n(l),ul=p(l,"P",{"data-svelte-h":!0}),y(ul)!=="svelte-uv1p0b"&&(ul.textContent=yt),Bs=n(l),j(Ul.$$.fragment,l),Zs=n(l),dl=p(l,"P",{"data-svelte-h":!0}),y(dl)!=="svelte-1s8zpio"&&(dl.textContent=ct),Gs=n(l),j(ml.$$.fragment,l),qs=n(l),Il=p(l,"P",{"data-svelte-h":!0}),y(Il)!=="svelte-1dc3rsp"&&(Il.innerHTML=wt),Es=n(l),hl=p(l,"P",{"data-svelte-h":!0}),y(hl)!=="svelte-i1p8nu"&&(hl.innerHTML=ut),Vs=n(l),j(Al.$$.fragment,l),Ws=n(l),U=p(l,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Xs(U).forEach(t),ks=n(l),j(fl.$$.fragment,l),_s=n(l),Cl=p(l,"P",{"data-svelte-h":!0}),y(Cl)!=="svelte-7z51hg"&&(Cl.textContent=dt),Qs=n(l),gl=p(l,"P",{"data-svelte-h":!0}),y(gl)!=="svelte-v2wenh"&&(gl.textContent=mt),Ns=n(l),j(bl.$$.fragment,l),vs=n(l),Bl=p(l,"P",{}),Xs(Bl).forEach(t),this.h()},h(){d(m,"name","hf:doc:metadata"),d(m,"content",qt),It(u.src,st="https://huggingface.co/datasets/Intel/orca_dpo_pairs/embed/viewer/default/train")||d(u,"src",st),d(u,"frameborder","0"),d(u,"width","100%"),d(u,"height","560px"),It(U.src,Ut="https://huggingface.co/datasets/distilabel-internal-testing/example-cleaned-preference-dataset/embed/viewer/default/train")||d(U,"src",Ut),d(U,"frameborder","0"),d(U,"width","100%"),d(U,"height","560px")},m(l,s){$t(document.head,m),e(l,Zl,s),e(l,$l,s),e(l,Gl,s),o(I,l,s),e(l,ql,s),o(h,l,s),e(l,El,s),e(l,A,s),e(l,Vl,s),e(l,f,s),e(l,Wl,s),e(l,C,s),e(l,kl,s),e(l,g,s),e(l,_l,s),e(l,b,s),e(l,Ql,s),o($,l,s),e(l,Nl,s),o(B,l,s),e(l,vl,s),e(l,Z,s),e(l,Rl,s),o(G,l,s),e(l,Xl,s),o(q,l,s),e(l,Fl,s),e(l,E,s),e(l,Hl,s),o(V,l,s),e(l,Sl,s),e(l,W,s),e(l,xl,s),o(k,l,s),e(l,Yl,s),o(_,l,s),e(l,zl,s),e(l,Q,s),e(l,Ll,s),e(l,N,s),e(l,Dl,s),o(v,l,s),e(l,Pl,s),o(R,l,s),e(l,Kl,s),e(l,X,s),e(l,Ol,s),e(l,u,s),e(l,ls,s),o(F,l,s),e(l,ss,s),e(l,H,s),e(l,ts,s),o(S,l,s),e(l,es,s),o(x,l,s),e(l,as,s),o(Y,l,s),e(l,ns,s),e(l,z,s),e(l,Ms,s),o(L,l,s),e(l,ps,s),o(D,l,s),e(l,is,s),o(P,l,s),e(l,js,s),e(l,K,s),e(l,os,s),o(O,l,s),e(l,Js,s),e(l,ll,s),e(l,Ts,s),e(l,sl,s),e(l,rs,s),o(tl,l,s),e(l,ys,s),o(el,l,s),e(l,cs,s),e(l,al,s),e(l,ws,s),e(l,nl,s),e(l,us,s),e(l,Ml,s),e(l,Us,s),o(pl,l,s),e(l,ds,s),o(il,l,s),e(l,ms,s),e(l,jl,s),e(l,Is,s),e(l,ol,s),e(l,hs,s),o(Jl,l,s),e(l,As,s),o(Tl,l,s),e(l,fs,s),e(l,rl,s),e(l,Cs,s),e(l,yl,s),e(l,gs,s),o(cl,l,s),e(l,bs,s),o(wl,l,s),e(l,$s,s),e(l,ul,s),e(l,Bs,s),o(Ul,l,s),e(l,Zs,s),e(l,dl,s),e(l,Gs,s),o(ml,l,s),e(l,qs,s),e(l,Il,s),e(l,Es,s),e(l,hl,s),e(l,Vs,s),o(Al,l,s),e(l,Ws,s),e(l,U,s),e(l,ks,s),o(fl,l,s),e(l,_s,s),e(l,Cl,s),e(l,Qs,s),e(l,gl,s),e(l,Ns,s),o(bl,l,s),e(l,vs,s),e(l,Bl,s),Rs=!0},p:At,i(l){Rs||(J(I.$$.fragment,l),J(h.$$.fragment,l),J($.$$.fragment,l),J(B.$$.fragment,l),J(G.$$.fragment,l),J(q.$$.fragment,l),J(V.$$.fragment,l),J(k.$$.fragment,l),J(_.$$.fragment,l),J(v.$$.fragment,l),J(R.$$.fragment,l),J(F.$$.fragment,l),J(S.$$.fragment,l),J(x.$$.fragment,l),J(Y.$$.fragment,l),J(L.$$.fragment,l),J(D.$$.fragment,l),J(P.$$.fragment,l),J(O.$$.fragment,l),J(tl.$$.fragment,l),J(el.$$.fragment,l),J(pl.$$.fragment,l),J(il.$$.fragment,l),J(Jl.$$.fragment,l),J(Tl.$$.fragment,l),J(cl.$$.fragment,l),J(wl.$$.fragment,l),J(Ul.$$.fragment,l),J(ml.$$.fragment,l),J(Al.$$.fragment,l),J(fl.$$.fragment,l),J(bl.$$.fragment,l),Rs=!0)},o(l){T(I.$$.fragment,l),T(h.$$.fragment,l),T($.$$.fragment,l),T(B.$$.fragment,l),T(G.$$.fragment,l),T(q.$$.fragment,l),T(V.$$.fragment,l),T(k.$$.fragment,l),T(_.$$.fragment,l),T(v.$$.fragment,l),T(R.$$.fragment,l),T(F.$$.fragment,l),T(S.$$.fragment,l),T(x.$$.fragment,l),T(Y.$$.fragment,l),T(L.$$.fragment,l),T(D.$$.fragment,l),T(P.$$.fragment,l),T(O.$$.fragment,l),T(tl.$$.fragment,l),T(el.$$.fragment,l),T(pl.$$.fragment,l),T(il.$$.fragment,l),T(Jl.$$.fragment,l),T(Tl.$$.fragment,l),T(cl.$$.fragment,l),T(wl.$$.fragment,l),T(Ul.$$.fragment,l),T(ml.$$.fragment,l),T(Al.$$.fragment,l),T(fl.$$.fragment,l),T(bl.$$.fragment,l),Rs=!1},d(l){l&&(t(Zl),t($l),t(Gl),t(ql),t(El),t(A),t(Vl),t(f),t(Wl),t(C),t(kl),t(g),t(_l),t(b),t(Ql),t(Nl),t(vl),t(Z),t(Rl),t(Xl),t(Fl),t(E),t(Hl),t(Sl),t(W),t(xl),t(Yl),t(zl),t(Q),t(Ll),t(N),t(Dl),t(Pl),t(Kl),t(X),t(Ol),t(u),t(ls),t(ss),t(H),t(ts),t(es),t(as),t(ns),t(z),t(Ms),t(ps),t(is),t(js),t(K),t(os),t(Js),t(ll),t(Ts),t(sl),t(rs),t(ys),t(cs),t(al),t(ws),t(nl),t(us),t(Ml),t(Us),t(ds),t(ms),t(jl),t(Is),t(ol),t(hs),t(As),t(fs),t(rl),t(Cs),t(yl),t(gs),t(bs),t($s),t(ul),t(Bs),t(Zs),t(dl),t(Gs),t(qs),t(Il),t(Es),t(hl),t(Vs),t(Ws),t(U),t(ks),t(_s),t(Cl),t(Qs),t(gl),t(Ns),t(vs),t(Bl)),t(m),r(I,l),r(h,l),r($,l),r(B,l),r(G,l),r(q,l),r(V,l),r(k,l),r(_,l),r(v,l),r(R,l),r(F,l),r(S,l),r(x,l),r(Y,l),r(L,l),r(D,l),r(P,l),r(O,l),r(tl,l),r(el,l),r(pl,l),r(il,l),r(Jl,l),r(Tl,l),r(cl,l),r(wl,l),r(Ul,l),r(ml,l),r(Al,l),r(fl,l),r(bl,l)}}}const qt='{"title":"使用大型语言模型作为评审者清理现有的偏好数据集","local":"使用大型语言模型作为评审者清理现有的偏好数据集","sections":[],"depth":2}';function Et(Fs){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends Ct{constructor(m){super(),gt(this,m,Et,Gt,ht,{})}}export{Qt as component};
