import{s as zt,f as Lt,n as Pt,o as Dt}from"../chunks/scheduler.65852ee5.js";import{S as Kt,i as Ot,g as o,s as a,r as i,A as te,h as r,f as l,c as n,j as vt,u as p,x as d,k as z,y as ee,a as s,v as M,d as m,t as c,w as u}from"../chunks/index.65a1b999.js";import{D as le,C as f}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as L,E as se}from"../chunks/getInferenceSnippets.56942ade.js";function ae(Xt){let j,K,P,O,h,tt,w,et,J,Gt='We will be using the SmolVLM-Instruct model from HuggingFaceTB to extract structured information from documents. We will run the VLM using the Hugging Face Transformers library and the <a href="https://github.com/dottxt-ai/outlines" rel="nofollow">Outlines library</a>, which facilitates structured generation based on limiting token sampling probabilities.',lt,b,Nt='<p>This approach is based on a <a href="https://dottxt-ai.github.io/outlines/latest/cookbook/atomic_caption/" rel="nofollow">Outlines tutorial</a>.</p>',st,g,at,U,Rt="First, let’s install the necessary libraries.",nt,T,ot,$,kt="Let’s continue with importing the necessary libraries.",it,I,rt,Z,pt,B,xt='We will start by initialising our model from <a href="https://huggingface.co/HuggingFaceTB/SmolVLM-Instruct" rel="nofollow">HuggingFaceTB/SmolVLM-Instruct</a>. Outlines expects us to pass in a model class and processor class, so we will make this example a bit more generic by creating a function that returns those. Alternatively, you could look at the model and tokenizer config within the <a href="https://huggingface.co/HuggingFaceTB/SmolVLM-Instruct/tree/main" rel="nofollow">Hub repo files</a>, and import those classes directly.',Mt,C,mt,_,ct,W,At='Now, we are going to define a function that will define how the output of our model will be structured. We will be using the <a href="https://huggingface.co/datasets/openbmb/RLAIF-V-Dataset" rel="nofollow">openbmb/RLAIF-V-Dataset</a>, which contains a set of images along with questions and their chosen and rejected reponses. This is an okay dataset but we want to create additional text-image-to-text data on top of the images to get our own structured dataset, and potentially fine-tune our model on it. We will use the model to generate a caption, a question and a simple quality tag for the image.',ut,v,dt,X,Vt="Now, let’s come up with an extraction prompt.",yt,G,jt,N,Yt="Let’s load our image dataset.",ft,R,ht,k,Qt="Now, let’s define a function that will extract the structured information from the image. We will format the prompt using the <code>apply_chat_template</code> method and pass it to the model along with the image after that.",wt,x,Jt,A,qt="Let’s now push our new dataset to the Hub.",bt,V,gt,y,Ft,Ut,Y,Ht="The results are not perfect, but they are a good starting point to continue exploring with different models and prompts!",Tt,Q,$t,q,Et="We’ve seen how to extract structured information from documents using a vision language model. We can use similar extractive methods to extract structured information from documents, using somehting like <code>pdf2image</code> to convert the document to images and running information extraction on each image pdf of the page.",It,F,Zt,H,Bt,E,St='<li>Take a look at the <a href="https://github.com/outlines-ai/outlines" rel="nofollow">Outlines</a> library for more information on how to use it. Explore the different methods and parameters.</li> <li>Explore extraction on your own usecase with your own model.</li> <li>Use a different method of extracting structured information from documents.</li>',Ct,S,_t,D,Wt;return h=new le({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/structured_generation_vision_language_models.ipynb"}]}}),w=new L({props:{title:"Structured Generation from Images or Documents Using Vision Language Models",local:"structured-generation-from-images-or-documents-using-vision-language-models",headingTag:"h1"}}),g=new L({props:{title:"Dependencies and imports",local:"dependencies-and-imports",headingTag:"h2"}}),T=new f({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMjBvdXRsaW5lcyUyMHRyYW5zZm9ybWVycyUyMHRvcmNoJTIwZmxhc2gtYXR0biUyMGRhdGFzZXRzJTIwc2VudGVuY2VwaWVjZQ==",highlighted:"%pip install accelerate outlines transformers torch flash-attn datasets sentencepiece",wrap:!1}}),I=new f({props:{code:"aW1wb3J0JTIwb3V0bGluZXMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjBvdXRsaW5lcy5tb2RlbHMudHJhbnNmb3JtZXJzX3Zpc2lvbiUyMGltcG9ydCUyMHRyYW5zZm9ybWVyc192aXNpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0JTJDJTIwQXV0b1Byb2Nlc3NvciUwQWZyb20lMjBweWRhbnRpYyUyMGltcG9ydCUyMEJhc2VNb2RlbA==",highlighted:`<span class="hljs-keyword">import</span> outlines
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> outlines.models.transformers_vision <span class="hljs-keyword">import</span> transformers_vision
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText, AutoProcessor
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel`,wrap:!1}}),Z=new L({props:{title:"Initialising our model",local:"initialising-our-model",headingTag:"h2"}}),C=new f({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sVkxNLUluc3RydWN0JTIyJTBBJTBBJTBBZGVmJTIwZ2V0X21vZGVsX2FuZF9wcm9jZXNzb3JfY2xhc3MobW9kZWxfbmFtZSUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dC5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEElMjAlMjAlMjAlMjBwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQSUyMCUyMCUyMCUyMGNsYXNzZXMlMjAlM0QlMjBtb2RlbC5fX2NsYXNzX18lMkMlMjBwcm9jZXNzb3IuX19jbGFzc19fJTBBJTIwJTIwJTIwJTIwZGVsJTIwbW9kZWwlMkMlMjBwcm9jZXNzb3IlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBjbGFzc2VzJTBBJTBBJTBBbW9kZWxfY2xhc3MlMkMlMjBwcm9jZXNzb3JfY2xhc3MlMjAlM0QlMjBnZXRfbW9kZWxfYW5kX3Byb2Nlc3Nvcl9jbGFzcyhtb2RlbF9uYW1lKSUwQSUwQWlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUzQSUwQSUyMCUyMCUyMCUyMGRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFlbGlmJTIwdG9yY2guYmFja2VuZHMubXBzLmlzX2F2YWlsYWJsZSgpJTNBJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTIwJTNEJTIwJTIybXBzJTIyJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMGRldmljZSUyMCUzRCUyMCUyMmNwdSUyMiUwQSUwQW1vZGVsJTIwJTNEJTIwdHJhbnNmb3JtZXJzX3Zpc2lvbiglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfY2xhc3MlM0Rtb2RlbF9jbGFzcyUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRGRldmljZSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2t3YXJncyUzRCU3QiUyMnRvcmNoX2R0eXBlJTIyJTNBJTIwdG9yY2guYmZsb2F0MTYlMkMlMjAlMjJkZXZpY2VfbWFwJTIyJTNBJTIwJTIyYXV0byUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMHByb2Nlc3Nvcl9rd2FyZ3MlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzb3JfY2xhc3MlM0Rwcm9jZXNzb3JfY2xhc3MlMkMlMEEp",highlighted:`model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM-Instruct&quot;</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_model_and_processor_class</span>(<span class="hljs-params">model_name: <span class="hljs-built_in">str</span></span>):
    model = AutoModelForImageTextToText.from_pretrained(model_name)
    processor = AutoProcessor.from_pretrained(model_name)
    classes = model.__class__, processor.__class__
    <span class="hljs-keyword">del</span> model, processor
    <span class="hljs-keyword">return</span> classes


model_class, processor_class = get_model_and_processor_class(model_name)

<span class="hljs-keyword">if</span> torch.cuda.is_available():
    device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-keyword">elif</span> torch.backends.mps.is_available():
    device = <span class="hljs-string">&quot;mps&quot;</span>
<span class="hljs-keyword">else</span>:
    device = <span class="hljs-string">&quot;cpu&quot;</span>

model = transformers_vision(
    model_name,
    model_class=model_class,
    device=device,
    model_kwargs={<span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16, <span class="hljs-string">&quot;device_map&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>},
    processor_kwargs={<span class="hljs-string">&quot;device&quot;</span>: device},
    processor_class=processor_class,
)`,wrap:!1}}),_=new L({props:{title:"Structured Generation",local:"structured-generation",headingTag:"h2"}}),v=new f({props:{code:"Y2xhc3MlMjBJbWFnZURhdGEoQmFzZU1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMHF1YWxpdHklM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwc3RyJTBBJTBBJTBBc3RydWN0dXJlZF9nZW5lcmF0b3IlMjAlM0QlMjBvdXRsaW5lcy5nZW5lcmF0ZS5qc29uKG1vZGVsJTJDJTIwSW1hZ2VEYXRhKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImageData</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    quality: <span class="hljs-built_in">str</span>
    description: <span class="hljs-built_in">str</span>
    question: <span class="hljs-built_in">str</span>


structured_generator = outlines.generate.json(model, ImageData)`,wrap:!1}}),G=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBWW91JTIwYXJlJTIwYW4lMjBpbWFnZSUyMGFuYWx5c2lzJTIwYXNzaXNhbnQuJTBBJTBBUHJvdmlkZSUyMGElMjBxdWFsaXR5JTIwdGFnJTJDJTIwYSUyMGRlc2NyaXB0aW9uJTIwYW5kJTIwYSUyMHF1ZXN0aW9uLiUwQSUwQVRoZSUyMHF1YWxpdHklMjBjYW4lMjBlaXRoZXIlMjBiZSUyMCUyMmdvb2QlMjIlMkMlMjAlMjJva2F5JTIyJTIwb3IlMjAlMjJiYWQlMjIuJTBBVGhlJTIwcXVlc3Rpb24lMjBzaG91bGQlMjBiZSUyMGNvbmNpc2UlMjBhbmQlMjBvYmplY3RpdmUuJTBBJTBBUmV0dXJuJTIweW91ciUyMHJlc3BvbnNlJTIwYXMlMjBhJTIwdmFsaWQlMjBKU09OJTIwb2JqZWN0LiUwQSUyMiUyMiUyMi5zdHJpcCgp",highlighted:`prompt = <span class="hljs-string">&quot;&quot;&quot;
You are an image analysis assisant.

Provide a quality tag, a description and a question.

The quality can either be &quot;good&quot;, &quot;okay&quot; or &quot;bad&quot;.
The question should be concise and objective.

Return your response as a valid JSON object.
&quot;&quot;&quot;</span>.strip()`,wrap:!1}}),R=new f({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJvcGVuYm1iJTJGUkxBSUYtVi1EYXRhc2V0JTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTEwJTVEJTIyKSUwQWRhdGFzZXQ=",highlighted:`dataset = load_dataset(<span class="hljs-string">&quot;openbmb/RLAIF-V-Dataset&quot;</span>, split=<span class="hljs-string">&quot;train[:10]&quot;</span>)
dataset`,wrap:!1}}),x=new f({props:{code:"ZGVmJTIwZXh0cmFjdChyb3cpJTNBJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjBwcm9tcHQlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjBmb3JtYXR0ZWRfcHJvbXB0JTIwJTNEJTIwbW9kZWwucHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMHN0cnVjdHVyZWRfZ2VuZXJhdG9yKGZvcm1hdHRlZF9wcm9tcHQlMkMlMjAlNUJyb3clNUIlMjJpbWFnZSUyMiU1RCU1RCklMEElMjAlMjAlMjAlMjByb3clNUIlMjJzeW50aGV0aWNfcXVlc3Rpb24lMjIlNUQlMjAlM0QlMjByZXN1bHQucXVlc3Rpb24lMEElMjAlMjAlMjAlMjByb3clNUIlMjJzeW50aGV0aWNfZGVzY3JpcHRpb24lMjIlNUQlMjAlM0QlMjByZXN1bHQuZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjByb3clNUIlMjJzeW50aGV0aWNfcXVhbGl0eSUyMiU1RCUyMCUzRCUyMHJlc3VsdC5xdWFsaXR5JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcm93JTBBJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjBleHRyYWN0KHgpKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract</span>(<span class="hljs-params">row</span>):
    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: prompt}],
        },
    ]

    formatted_prompt = model.processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)

    result = structured_generator(formatted_prompt, [row[<span class="hljs-string">&quot;image&quot;</span>]])
    row[<span class="hljs-string">&quot;synthetic_question&quot;</span>] = result.question
    row[<span class="hljs-string">&quot;synthetic_description&quot;</span>] = result.description
    row[<span class="hljs-string">&quot;synthetic_quality&quot;</span>] = result.quality
    <span class="hljs-keyword">return</span> row


dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: extract(x))
dataset`,wrap:!1}}),V=new f({props:{code:"ZGF0YXNldC5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjAlMjJkYXZpZGJlcmVuc3RlaW4xOTU3JTJGc3RydWN0dXJlZC1nZW5lcmF0aW9uLWluZm9ybWF0aW9uLWV4dHJhY3Rpb24tdmxtcy1vcGVuYm1iLVJMQUlGLVYtRGF0YXNldCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMEEp",highlighted:`dataset.push_to_hub(
    <span class="hljs-string">&quot;davidberenstein1957/structured-generation-information-extraction-vlms-openbmb-RLAIF-V-Dataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>
)`,wrap:!1}}),Q=new L({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),F=new f({props:{code:"cGRmX3BhdGglMjAlM0QlMjAlMjJwYXRoJTJGdG8lMkZ5b3VyJTJGcGRmJTJGZmlsZS5wZGYlMjIlMEFwYWdlcyUyMCUzRCUyMGNvbnZlcnRfZnJvbV9wYXRoKHBkZl9wYXRoKSUwQWZvciUyMHBhZ2UlMjBpbiUyMHBhZ2VzJTNBJTBBJTIwJTIwJTIwJTIwZXh0cmFjdF9vYmplY3RzJTIwJTNEJTIwZXh0cmFjdF9vYmplY3RzKHBhZ2UlMkMlMjBwcm9tcHQp",highlighted:`pdf_path = <span class="hljs-string">&quot;path/to/your/pdf/file.pdf&quot;</span>
pages = convert_from_path(pdf_path)
<span class="hljs-keyword">for</span> page <span class="hljs-keyword">in</span> pages:
    extract_objects = extract_objects(page, prompt)`,wrap:!1}}),H=new L({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),S=new se({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/structured_generation_vision_language_models.md"}}),{c(){j=o("meta"),K=a(),P=o("p"),O=a(),i(h.$$.fragment),tt=a(),i(w.$$.fragment),et=a(),J=o("p"),J.innerHTML=Gt,lt=a(),b=o("blockquote"),b.innerHTML=Nt,st=a(),i(g.$$.fragment),at=a(),U=o("p"),U.textContent=Rt,nt=a(),i(T.$$.fragment),ot=a(),$=o("p"),$.textContent=kt,it=a(),i(I.$$.fragment),rt=a(),i(Z.$$.fragment),pt=a(),B=o("p"),B.innerHTML=xt,Mt=a(),i(C.$$.fragment),mt=a(),i(_.$$.fragment),ct=a(),W=o("p"),W.innerHTML=At,ut=a(),i(v.$$.fragment),dt=a(),X=o("p"),X.textContent=Vt,yt=a(),i(G.$$.fragment),jt=a(),N=o("p"),N.textContent=Yt,ft=a(),i(R.$$.fragment),ht=a(),k=o("p"),k.innerHTML=Qt,wt=a(),i(x.$$.fragment),Jt=a(),A=o("p"),A.textContent=qt,bt=a(),i(V.$$.fragment),gt=a(),y=o("iframe"),Ut=a(),Y=o("p"),Y.textContent=Ht,Tt=a(),i(Q.$$.fragment),$t=a(),q=o("p"),q.innerHTML=Et,It=a(),i(F.$$.fragment),Zt=a(),i(H.$$.fragment),Bt=a(),E=o("ul"),E.innerHTML=St,Ct=a(),i(S.$$.fragment),_t=a(),D=o("p"),this.h()},l(t){const e=te("svelte-u9bgzb",document.head);j=r(e,"META",{name:!0,content:!0}),e.forEach(l),K=n(t),P=r(t,"P",{}),vt(P).forEach(l),O=n(t),p(h.$$.fragment,t),tt=n(t),p(w.$$.fragment,t),et=n(t),J=r(t,"P",{"data-svelte-h":!0}),d(J)!=="svelte-84hlf0"&&(J.innerHTML=Gt),lt=n(t),b=r(t,"BLOCKQUOTE",{"data-svelte-h":!0}),d(b)!=="svelte-wbtxpu"&&(b.innerHTML=Nt),st=n(t),p(g.$$.fragment,t),at=n(t),U=r(t,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1vmewof"&&(U.textContent=Rt),nt=n(t),p(T.$$.fragment,t),ot=n(t),$=r(t,"P",{"data-svelte-h":!0}),d($)!=="svelte-1t87pq4"&&($.textContent=kt),it=n(t),p(I.$$.fragment,t),rt=n(t),p(Z.$$.fragment,t),pt=n(t),B=r(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1dcc9xp"&&(B.innerHTML=xt),Mt=n(t),p(C.$$.fragment,t),mt=n(t),p(_.$$.fragment,t),ct=n(t),W=r(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-g2jocn"&&(W.innerHTML=At),ut=n(t),p(v.$$.fragment,t),dt=n(t),X=r(t,"P",{"data-svelte-h":!0}),d(X)!=="svelte-oswmnk"&&(X.textContent=Vt),yt=n(t),p(G.$$.fragment,t),jt=n(t),N=r(t,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1cpu0q"&&(N.textContent=Yt),ft=n(t),p(R.$$.fragment,t),ht=n(t),k=r(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-ju559a"&&(k.innerHTML=Qt),wt=n(t),p(x.$$.fragment,t),Jt=n(t),A=r(t,"P",{"data-svelte-h":!0}),d(A)!=="svelte-9ozoda"&&(A.textContent=qt),bt=n(t),p(V.$$.fragment,t),gt=n(t),y=r(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),vt(y).forEach(l),Ut=n(t),Y=r(t,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-62ujx0"&&(Y.textContent=Ht),Tt=n(t),p(Q.$$.fragment,t),$t=n(t),q=r(t,"P",{"data-svelte-h":!0}),d(q)!=="svelte-a7iz4v"&&(q.innerHTML=Et),It=n(t),p(F.$$.fragment,t),Zt=n(t),p(H.$$.fragment,t),Bt=n(t),E=r(t,"UL",{"data-svelte-h":!0}),d(E)!=="svelte-o8vxx7"&&(E.innerHTML=St),Ct=n(t),p(S.$$.fragment,t),_t=n(t),D=r(t,"P",{}),vt(D).forEach(l),this.h()},h(){z(j,"name","hf:doc:metadata"),z(j,"content",ne),Lt(y.src,Ft="https://huggingface.co/datasets/davidberenstein1957/structured-generation-information-extraction-vlms-openbmb-RLAIF-V-Dataset/embed/viewer/default/train?row=3")||z(y,"src",Ft),z(y,"frameborder","0"),z(y,"width","100%"),z(y,"height","560px")},m(t,e){ee(document.head,j),s(t,K,e),s(t,P,e),s(t,O,e),M(h,t,e),s(t,tt,e),M(w,t,e),s(t,et,e),s(t,J,e),s(t,lt,e),s(t,b,e),s(t,st,e),M(g,t,e),s(t,at,e),s(t,U,e),s(t,nt,e),M(T,t,e),s(t,ot,e),s(t,$,e),s(t,it,e),M(I,t,e),s(t,rt,e),M(Z,t,e),s(t,pt,e),s(t,B,e),s(t,Mt,e),M(C,t,e),s(t,mt,e),M(_,t,e),s(t,ct,e),s(t,W,e),s(t,ut,e),M(v,t,e),s(t,dt,e),s(t,X,e),s(t,yt,e),M(G,t,e),s(t,jt,e),s(t,N,e),s(t,ft,e),M(R,t,e),s(t,ht,e),s(t,k,e),s(t,wt,e),M(x,t,e),s(t,Jt,e),s(t,A,e),s(t,bt,e),M(V,t,e),s(t,gt,e),s(t,y,e),s(t,Ut,e),s(t,Y,e),s(t,Tt,e),M(Q,t,e),s(t,$t,e),s(t,q,e),s(t,It,e),M(F,t,e),s(t,Zt,e),M(H,t,e),s(t,Bt,e),s(t,E,e),s(t,Ct,e),M(S,t,e),s(t,_t,e),s(t,D,e),Wt=!0},p:Pt,i(t){Wt||(m(h.$$.fragment,t),m(w.$$.fragment,t),m(g.$$.fragment,t),m(T.$$.fragment,t),m(I.$$.fragment,t),m(Z.$$.fragment,t),m(C.$$.fragment,t),m(_.$$.fragment,t),m(v.$$.fragment,t),m(G.$$.fragment,t),m(R.$$.fragment,t),m(x.$$.fragment,t),m(V.$$.fragment,t),m(Q.$$.fragment,t),m(F.$$.fragment,t),m(H.$$.fragment,t),m(S.$$.fragment,t),Wt=!0)},o(t){c(h.$$.fragment,t),c(w.$$.fragment,t),c(g.$$.fragment,t),c(T.$$.fragment,t),c(I.$$.fragment,t),c(Z.$$.fragment,t),c(C.$$.fragment,t),c(_.$$.fragment,t),c(v.$$.fragment,t),c(G.$$.fragment,t),c(R.$$.fragment,t),c(x.$$.fragment,t),c(V.$$.fragment,t),c(Q.$$.fragment,t),c(F.$$.fragment,t),c(H.$$.fragment,t),c(S.$$.fragment,t),Wt=!1},d(t){t&&(l(K),l(P),l(O),l(tt),l(et),l(J),l(lt),l(b),l(st),l(at),l(U),l(nt),l(ot),l($),l(it),l(rt),l(pt),l(B),l(Mt),l(mt),l(ct),l(W),l(ut),l(dt),l(X),l(yt),l(jt),l(N),l(ft),l(ht),l(k),l(wt),l(Jt),l(A),l(bt),l(gt),l(y),l(Ut),l(Y),l(Tt),l($t),l(q),l(It),l(Zt),l(Bt),l(E),l(Ct),l(_t),l(D)),l(j),u(h,t),u(w,t),u(g,t),u(T,t),u(I,t),u(Z,t),u(C,t),u(_,t),u(v,t),u(G,t),u(R,t),u(x,t),u(V,t),u(Q,t),u(F,t),u(H,t),u(S,t)}}}const ne='{"title":"Structured Generation from Images or Documents Using Vision Language Models","local":"structured-generation-from-images-or-documents-using-vision-language-models","sections":[{"title":"Dependencies and imports","local":"dependencies-and-imports","sections":[],"depth":2},{"title":"Initialising our model","local":"initialising-our-model","sections":[],"depth":2},{"title":"Structured Generation","local":"structured-generation","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function oe(Xt){return Dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class me extends Kt{constructor(j){super(),Ot(this,j,oe,ae,zt,{})}}export{me as component};
