import{s as dl,n as ml,o as pl}from"../chunks/scheduler.85c25b89.js";import{S as hl,i as ul,g as r,s as l,r as m,A as cl,h as a,f as n,c as o,j as b,u as p,x as d,k as x,l as hs,y as i,a as s,v as h,d as u,t as c,w as g}from"../chunks/index.c142fe32.js";import{D as w}from"../chunks/Docstring.e6639b56.js";import{C as P}from"../chunks/CodeBlock.a5e95a57.js";import{H as M,E as gl}from"../chunks/EditOnGithub.a592e7aa.js";function fl(us){let T,ye,fe,be,R,xe,Z,cs="Text environments provide a learning ground for language agents. It allows a language model to use tools to accomplish a task such as using a Python interpreter to answer math questions or using a search index for trivia questions. Having access to tools allows language models to solve tasks that would be very hard for the models itself but can be trivial for the appropriate tools. A good example is arithmetics of large numbers that become a simple copy-paste task once you have access to a calculator.",$e,_,gs='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/textenv.png"/>',we,G,fs="Let’s dive into how text environments work and start with tools!",Me,Q,Te,W,vs="One of the core building blocks of text environments are tools that the model can use to solve tasks. In general tools can be any Python function that takes a string as input and returns string. The <code>TextEnvironment</code> offers two options for tools: either go with predefined tools from <code>transformers.Tool</code> or define your own function or class with <code>__call__</code> method. Let’s have a look at both!",_e,S,Ce,A,ys="Text environments fully support tools of the class <code>transformers.Tool</code>. The advantage of building tools in that framework is that they can easily be shared",ke,D,Ue,F,bs="These tools are either loaded from the hub or from a local folder. Using the tool is as simple as calling them with a text query:",je,Y,Je,O,xs="Note that both input and return values are strings to enable easy usage with a language model.",He,K,Ee,tt,$s="The following is an example of a tool that adds two integers:",qe,et,ze,nt,ws="We looked at basic examples such as a calculator but the principle holds for more complex tools as well such as a web search tool where you input the query and get the search results in return. Now let’s look at how the model can use the tools with the call syntax.",Le,st,Ie,lt,Ms="In order to have a unified way for the model to call a tool we created a simple syntax that looks as follows:",Ne,ot,Ve,rt,Ts="There are a few special tokens involved so let’s decompose it: First the model can signal that it wants to use a tool by emitting the <code>&lt;request&gt;</code> token. After that we want to know the name of the tool to call which is done by enclosing the tool name with <code>&lt;&gt;</code> brackets. Once we know which tool to call the tool query follows which is in free text form. The <code>&lt;call&gt;</code> tokens signifies the end of the query and stops the model generation. At this point the model output is parsed and the query sent to the tool. The environment appends the tool response to the string followed by the <code>&lt;response&gt;</code> token to show the end the tool output.",Xe,at,_s="Let’s look at the concrete example of the calculator and assume its name is <code>Calculator</code> (more on how the name of a tool is inferred later):",Be,it,Pe,dt,Cs="Finally, the episode is ended and generation stops when the model generates <code>&lt;submit&gt;</code> which marks the interaction as completed.",Re,mt,ks="Now let’s have a look how we can create a new text environment!",Ze,pt,Ge,ht,Qe,ut,Us="Let’s decompose the settings:",We,ct,js='<thead><tr><th align="left">Argument</th> <th align="left">Description</th></tr></thead> <tbody><tr><td align="left"><code>model</code></td> <td align="left">Language model to interact with the environment and generate requests.</td></tr> <tr><td align="left"><code>tokenizer</code></td> <td align="left">Tokenizer of language model handling tokenization of strings.</td></tr> <tr><td align="left"><code>tools</code></td> <td align="left"><code>list</code> of <code>dict</code> of tools. If former the name of the tool is inferred from class name and otherwise it’s the keys of the dictionary.</td></tr> <tr><td align="left"><code>reward_fn</code></td> <td align="left">A function that takes a string as input and returns. Can have extra arguments that are passed to <code>.run()</code> such as ground truth.</td></tr> <tr><td align="left"><code>prompt</code></td> <td align="left">Prompt to prepend to every task. Usually a few examples to demonstrate to the model how to use the tools in a few-shot fashion.</td></tr> <tr><td align="left"><code>max_turns</code></td> <td align="left">Maximum number of interactions between model and tools before episode ends.</td></tr> <tr><td align="left"><code>max_tool_response</code></td> <td align="left">The tool response is truncated to this number to avoid running out of model context.</td></tr> <tr><td align="left"><code>max_length</code></td> <td align="left">The maximum number of tokens to allow in an episode.</td></tr> <tr><td align="left"><code>generation_kwargs</code></td> <td align="left">Generation settings used by the language model.</td></tr></tbody>',Se,gt,Js="You can customize the environment to your needs and add custom tools and settings. Let’s see how you can use the environment to have the model interact with the available tools!",Ae,ft,De,vt,Hs="To run a set of queries through the text environment one can simply use the <code>run</code> method.",Fe,yt,Ye,bt,Es="This will execute the model/tool feedback loop for each query until either no tool is called anymore, the maximum number of turns is reached or to maximum number of tokens in an episode is exceeded. The extra <code>kwargs</code> (e.g. <code>answers=answers</code> above) passed to <code>run</code> will be passed on to the reward function.",Oe,xt,qs="There are five objects that are returned by <code>run</code>:",Ke,$t,zs="<li><code>queries</code>: a list of the tokenized queries</li> <li><code>responses</code>: all tokens that have been generated withing the environment including model and tool tokens</li> <li><code>masks</code>: mask that indicates which tokens have been generated by the model and which tokens are generated by the tool</li> <li><code>rewards</code>: a list of reward for each query/response</li> <li><code>histories</code>: list of <code>TextHistory</code> objects, which are useful objects containing all the above and also the text equivalents</li>",tn,wt,Ls="The masks are crucial for training as we don’t want to optimize tokens that the model has not generated which are tokens produced by the tools.",en,Mt,Is="Next, we’ll train a PPO step with the generated responses!",nn,Tt,sn,_t,Ns="Training on episodes from the <code>TextEnvironment</code> is straight forward and simply requires forwarding all the returned variables except the <code>TextHistory</code> objects to the <code>step</code> method:",ln,Ct,on,kt,rn,Ut,Vs="The <code>TextHistory</code> object stores the interactions between the model and the text environment. It stores tokens and text generated in each turn and their source in each turn (model or system) as well as rewards. Let’s go through the class attributes and methods.",an,jt,dn,Jt,Xs="The following table summarises the available attributes of the <code>TextEnvironment</code> class:",mn,Ht,Bs='<thead><tr><th align="left">Attribute</th> <th align="left">Description</th></tr></thead> <tbody><tr><td align="left"><code>text</code></td> <td align="left">The full string of the text generated in the text environment with both model and system generated text.</td></tr> <tr><td align="left"><code>text_spans</code></td> <td align="left">A list of tuples with the spans for each model or system generated text segment.</td></tr> <tr><td align="left"><code>system_spans</code></td> <td align="left">A list of boolean values indicating if the segment is model or system generated.</td></tr> <tr><td align="left"><code>tokens</code></td> <td align="left">All tokens generated in text environment with both model and system generated tokens.</td></tr> <tr><td align="left"><code>token_spans</code></td> <td align="left">Similar to <code>text_spans</code> the <code>token_spans</code> indicate the boundaries of model andsystem generated tokens.</td></tr> <tr><td align="left"><code>token_masks</code></td> <td align="left">The token masks can be used to ignore system generated tokens by masking them.</td></tr> <tr><td align="left"><code>completed</code></td> <td align="left">Indicates if the interaction with the environment has completed.</td></tr> <tr><td align="left"><code>truncated</code></td> <td align="left">Indicates if the interaction with the environment has completed because max length was reached.</td></tr></tbody>',pn,Et,Ps="With these attributes you can reconstruct every interaction of the model with the <code>TextEnvironment</code>. The <code>TextHistory</code> also lets you visualize the text history. Let’s have a look!",hn,qt,un,zt,Rs='When the model interacts inside the <code>TextEnvironment</code> it can be useful to visualize and separate which parts of the text outputs were generated by the model and which parts come from the system and tools. For that purpose there are the two methods <a href="/docs/trl/v0.11.1/en/text_environments#trl.TextHistory.show_text">TextHistory.show_text()</a> and <a href="/docs/trl/v0.11.1/en/text_environments#trl.TextHistory.show_tokens">TextHistory.show_tokens()</a>. They print the text and tokens respectively and highlight the various segments using the <a href="https://github.com/Textualize/rich" rel="nofollow"><code>rich</code> libray</a> (make sure to install it before using these methods).',cn,Lt,Zs="You can see that the prompt is highlighted in gray, whereas system segments such as query and tool responses are highlighted in green. All segments generated by the model are highlighted in blue and in addition to the pure text output the reward is displayed as additional text in plum. Here an example of <code>show_text</code>:",gn,C,Gs='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/textenv_show_text.png" width="600"/>',fn,It,Qs="Sometimes there can be tricky tokenization related issues that are hidden when showing the decoded text. Thus <code>TextHistory</code> also offers an option to display the same highlighting on the tokens directly with <code>show_tokens</code>:",vn,k,Ws='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/textenv_show_tokens.png" width="800"/>',yn,Nt,Ss="Note that you can turn on the colour legend by passing <code>show_legend=True</code>.",bn,Vt,xn,f,Xt,Vn,ee,As="The TextEnvironment enables interaction of a LLM with an environment using tools.",Xn,U,Bt,Bn,ne,Ds="Compute the reward for a list of histories.",Pn,j,Pt,Rn,se,Fs="Generate responses for a list of histories.",Zn,J,Rt,Gn,le,Ys="Parse request string. Expected format: <request><tool_name>query<call>",Qn,H,Zt,Wn,oe,Os="Run the environment on a list of queries.",Sn,E,Gt,An,re,Ks="Step the environment forward one turn.",Dn,q,Qt,Fn,ae,tl="Check if the current generation sequence has finished.",Yn,z,Wt,On,ie,el="Check if the current generation sequences have finished.",$n,v,St,Kn,de,nl="The TextHistory class keeps track of the history of an interaction between the language model and the environment.",ts,L,At,es,me,sl="Append a new segment to the history.",ns,I,Dt,ss,pe,ll="Mark the history as completed.",ls,N,Ft,os,he,ol="Print the colour legend.",rs,V,Yt,as,ue,rl="Print the text history.",is,X,Ot,ds,ce,al="Print the history tokens.",ms,B,Kt,ps,ge,il="Split the tokens into query and response tokens.",wn,te,Mn,ve,Tn;return R=new M({props:{title:"Text Environments",local:"text-environments",headingTag:"h1"}}),Q=new M({props:{title:"Tools",local:"tools",headingTag:"h2"}}),S=new M({props:{title:"transformers.Tool",local:"transformerstool",headingTag:"h3"}}),D=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUwQSUwQSUyMyUyMHNpbXBsZSUyMGNhbGN1bGF0b3IlMjB0b29sJTIwdGhhdCUyMHJ1bnMlMjAlMkItJTJGKiUyMG9wZXJhdGlvbnMlMEFjYWxjX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIyeWJlbGthZGElMkZzaW1wbGUtY2FsY3VsYXRvciUyMiklMEElMEElMjMlMjBweXRob24lMjBpbnRlcnByZXRlciUyMHRoYXQlMjBleGVjdXRlcyUyMHByb2dyYW0lMjBhbmQlMjByZXR1cm5zJTIwb3V0cHV0cyUwQXB5X3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybHZ3ZXJyYSUyRnB5dGhvbi1pbnRlcnByZXRlciUyMiklMEElMEElMjMlMjB3aWtpcGVkaWElMjBzZWFyY2glMjBpbmRleCUyMHRoYXQlMjByZXR1cm5zJTIwYmVzdCUyMHNlYXJjaCUyMG1hdGNoJTBBd2lraV90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMnZ3eHl6am4lMkZweXNlcmluaS13aWtpcGVkaWEta2lsdC1kb2MlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool

<span class="hljs-comment"># simple calculator tool that runs +-/* operations</span>
calc_tool = load_tool(<span class="hljs-string">&quot;ybelkada/simple-calculator&quot;</span>)

<span class="hljs-comment"># python interpreter that executes program and returns outputs</span>
py_tool = load_tool(<span class="hljs-string">&quot;lvwerra/python-interpreter&quot;</span>)

<span class="hljs-comment"># wikipedia search index that returns best search match</span>
wiki_tool = load_tool(<span class="hljs-string">&quot;vwxyzjn/pyserini-wikipedia-kilt-doc&quot;</span>)`,wrap:!1}}),Y=new P({props:{code:"JTIyMC41JTIy",highlighted:`calc_tool(<span class="hljs-string">&quot;1/2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;0.5&quot;</span>`,wrap:!1}}),K=new M({props:{title:"Custom Tools",local:"custom-tools",headingTag:"h3"}}),et=new P({props:{code:"JTBBJTIyMiUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">text</span>):
    int_1, int_2 = text.split(<span class="hljs-string">&quot;+&quot;</span>)
    result = <span class="hljs-built_in">int</span>(int_1) + <span class="hljs-built_in">int</span>(int_2)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(result)

<span class="hljs-built_in">print</span>(add(<span class="hljs-string">&quot;1+1&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;2&quot;</span>`,wrap:!1}}),st=new M({props:{title:"Call syntax",local:"call-syntax",headingTag:"h3"}}),ot=new P({props:{code:"JTIyJTNDcmVxdWVzdCUzRSUzQ1RPT0xfTkFNRSUzRVFVRVJZJTNDY2FsbCUzRVRPT0xfUkVTUE9OU0UlM0NyZXNwb25zZSUzRSUyMg==",highlighted:'<span class="hljs-string">&quot;&lt;request&gt;&lt;TOOL_NAME&gt;QUERY&lt;call&gt;TOOL_RESPONSE&lt;response&gt;&quot;</span>',wrap:!1}}),it=new P({props:{code:"JTIyJTNDcmVxdWVzdCUzRSUzQ0NhbGN1bGF0b3IlM0UxJTJGMiUzQ2NhbGwlM0UwLjUlM0NyZXNwb25zZSUzRSUyMg==",highlighted:'<span class="hljs-string">&quot;&lt;request&gt;&lt;Calculator&gt;1/2&lt;call&gt;0.5&lt;response&gt;&quot;</span>',wrap:!1}}),pt=new M({props:{title:"Create a TextEnvironment",local:"create-a-textenvironment",headingTag:"h2"}}),ht=new P({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTVDJTBBV2hhdCUyMGlzJTIwMTMtMyUzRiUwQSUzQ3JlcXVlc3QlM0UlM0NTaW1wbGVDYWxjdWxhdG9yVG9vbCUzRTEzLTMlM0NjYWxsJTNFMTAuMCUzQ3Jlc3BvbnNlJTNFJTBBUmVzdWx0JTNEMTAlM0NzdWJtaXQlM0UlMEElMjIlMjIlMjIlMEElMEFkZWYlMjByZXdhcmRfZm4ocmVzdWx0JTJDJTIwYW5zd2VyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlNpbXBsaWZpZWQlMjByZXdhcmQlMjBmdW5jdGlvbiUyMHJldHVybmluZyUyMDElMjBpZiUyMHJlc3VsdCUyMG1hdGNoZXMlMjBhbnN3ZXIlMjBhbmQlMjAwJTIwb3RoZXJ3aXNlLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJlc3VsdF9wYXJzZWQlMjAlM0QlMjByZXN1bHQuc3BsaXQoJTIyJTNEJTIyKSU1QjElNUQuc3BsaXQoJTIyJTNDJTIyKSU1QjAlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnQocmVzdWx0X3BhcnNlZCUzRCUzRGFuc3dlciklMEElMEF0ZXh0X2VudiUyMCUzRCUyMFRleHRFbnZpcm9uZW1udCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlMjAlN0IlMjJTaW1wbGVDYWxjdWxhdG9yVG9vbCUyMiUzQSUyMGxvYWRfdG9vbCglMjJ5YmVsa2FkYSUyRnNpbXBsZS1jYWxjdWxhdG9yJTIyKSU3RCUyQyUwQSUyMCUyMCUyMCUyMHJld2FyZF9mbiUzRGV4YWN0X21hdGNoX3Jld2FyZCUyQyUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMG1heF90dXJucyUzRDElMEElMjAlMjAlMjAlMjBtYXhfdG9vbF9yZXNwb25zZSUzRDEwMCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRpb25fa3dhcmdzJTNEJTdCJTIyZG9fc2FtcGxlJTIyJTNBJTIwJTIydHJ1ZSUyMiU3RCUwQSk=",highlighted:`prompt = <span class="hljs-string">&quot;&quot;&quot;\\
What is 13-3?
&lt;request&gt;&lt;SimpleCalculatorTool&gt;13-3&lt;call&gt;10.0&lt;response&gt;
Result=10&lt;submit&gt;
&quot;&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_fn</span>(<span class="hljs-params">result, answer</span>):
    <span class="hljs-string">&quot;&quot;&quot;Simplified reward function returning 1 if result matches answer and 0 otherwise.&quot;&quot;&quot;</span>
    result_parsed = result.split(<span class="hljs-string">&quot;=&quot;</span>)[<span class="hljs-number">1</span>].split(<span class="hljs-string">&quot;&lt;&quot;</span>)[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">int</span>(result_parsed==answer)

text_env = TextEnvironemnt(
    model=model, 
    tokenizer=tokenizer,
    tools= {<span class="hljs-string">&quot;SimpleCalculatorTool&quot;</span>: load_tool(<span class="hljs-string">&quot;ybelkada/simple-calculator&quot;</span>)},
    reward_fn=exact_match_reward,
    prompt=prompt, 
    max_turns=<span class="hljs-number">1</span>
    max_tool_response=<span class="hljs-number">100</span>
    generation_kwargs={<span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-string">&quot;true&quot;</span>}
)`,wrap:!1}}),ft=new M({props:{title:"Run an Episode",local:"run-an-episode",headingTag:"h2"}}),yt=new P({props:{code:"cXVlcmllcyUyMCUzRCUyMCU1QiUyMldoYXQlMjBpcyUyMDElMkYyJTNGJTIyJTVEJTBBYW5zd2VycyUyMCUzRCUyMCU1QiUyMjAuNSUyMiU1RCUwQSUwQXF1ZXJpZXMlMkMlMjByZXNwb25zZXMlMkMlMjBtYXNrcyUyQyUyMHJld2FyZHMlMkMlMjBoaXN0b3JpZXMlMjAlM0QlMjB0ZXh0X2Vudi5ydW4ocXVlcmllcyUyQyUyMGFuc3dlcnMlM0RhbnN3ZXJzKQ==",highlighted:`queries = [<span class="hljs-string">&quot;What is 1/2?&quot;</span>]
answers = [<span class="hljs-string">&quot;0.5&quot;</span>]

queries, responses, masks, rewards, histories = text_env.run(queries, answers=answers)`,wrap:!1}}),Tt=new M({props:{title:"Train",local:"train",headingTag:"h3"}}),Ct=new P({props:{code:"dHJhaW5fc3RhdHMlMjAlM0QlMjBwcG9fdHJhaW5lci5zdGVwKHF1ZXJpZXMlMkMlMjByZXNwb25zZXMlMkMlMjByZXdhcmRzJTJDJTIwbWFza3Mp",highlighted:"train_stats = ppo_trainer.step(queries, responses, rewards, masks)",wrap:!1}}),kt=new M({props:{title:"TextHistory",local:"texthistory",headingTag:"h2"}}),jt=new M({props:{title:"Attributes",local:"attributes",headingTag:"h3"}}),qt=new M({props:{title:"Visualization",local:"visualization",headingTag:"h3"}}),Vt=new M({props:{title:"API Documentation",local:"trl.TextEnvironment",headingTag:"h2"}}),Xt=new w({props:{name:"class trl.TextEnvironment",anchor:"trl.TextEnvironment",parameters:[{name:"model",val:" = None"},{name:"tokenizer",val:" = None"},{name:"tools",val:" = None"},{name:"reward_fn",val:" = None"},{name:"prompt",val:" = None"},{name:"max_turns",val:" = 4"},{name:"max_tool_reponse",val:" = 100"},{name:"max_length",val:" = None"},{name:"generation_kwargs",val:" = None"}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L209"}}),Bt=new w({props:{name:"compute_reward",anchor:"trl.TextEnvironment.compute_reward",parameters:[{name:"histories",val:""},{name:"**reward_kwargs",val:""}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L359"}}),Pt=new w({props:{name:"generate",anchor:"trl.TextEnvironment.generate",parameters:[{name:"histories",val:""}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L368"}}),Rt=new w({props:{name:"parse_tool_call",anchor:"trl.TextEnvironment.parse_tool_call",parameters:[{name:"text",val:""}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L334"}}),Zt=new w({props:{name:"run",anchor:"trl.TextEnvironment.run",parameters:[{name:"queries",val:""},{name:"**rewards_kwargs",val:""}],parametersDescription:[{anchor:"trl.TextEnvironment.run.queries",description:"<strong>queries</strong> (list[str]) &#x2014; A list of queries to run the model in the environment on.",name:"queries"}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L264"}}),Gt=new w({props:{name:"step",anchor:"trl.TextEnvironment.step",parameters:[{name:"history",val:""}],parametersDescription:[{anchor:"trl.TextEnvironment.step.history",description:"<strong>history</strong> (<code>TextHistory</code>) &#x2014; The history to step forward.",name:"history"}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L297"}}),Qt=new w({props:{name:"task_end_check",anchor:"trl.TextEnvironment.task_end_check",parameters:[{name:"history",val:""},{name:"model_turn",val:" = True"}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L394"}}),Wt=new w({props:{name:"tasks_end_check",anchor:"trl.TextEnvironment.tasks_end_check",parameters:[{name:"histories",val:""},{name:"model_turn",val:" = True"}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L383"}}),St=new w({props:{name:"class trl.TextHistory",anchor:"trl.TextHistory",parameters:[{name:"text",val:""},{name:"tokens",val:""},{name:"system",val:" = True"}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L60"}}),At=new w({props:{name:"append_segment",anchor:"trl.TextHistory.append_segment",parameters:[{name:"text",val:""},{name:"tokens",val:""},{name:"system",val:" = True"}],parametersDescription:[{anchor:"trl.TextHistory.append_segment.text",description:"<strong>text</strong> (<code>str</code>) &#x2014; The text of the new segment.",name:"text"},{anchor:"trl.TextHistory.append_segment.tokens",description:"<strong>tokens</strong> (<code>torch.LongTensor</code>) &#x2014; The tokens of the new segment.",name:"tokens"},{anchor:"trl.TextHistory.append_segment.system",description:"<strong>system</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether the new segment is a system or user segment.",name:"system"}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L89"}}),Dt=new w({props:{name:"complete",anchor:"trl.TextHistory.complete",parameters:[{name:"truncated",val:" = False"}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L117"}}),Ft=new w({props:{name:"show_colour_legend",anchor:"trl.TextHistory.show_colour_legend",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L190"}}),Yt=new w({props:{name:"show_text",anchor:"trl.TextHistory.show_text",parameters:[{name:"show_legend",val:" = False"}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L143"}}),Ot=new w({props:{name:"show_tokens",anchor:"trl.TextHistory.show_tokens",parameters:[{name:"tokenizer",val:""},{name:"show_legend",val:" = False"}],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L165"}}),Kt=new w({props:{name:"split_query_response_tokens",anchor:"trl.TextHistory.split_query_response_tokens",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.11.1/trl/environment/base_environment.py#L132"}}),te=new gl({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/text_environments.md"}}),{c(){T=r("meta"),ye=l(),fe=r("p"),be=l(),m(R.$$.fragment),xe=l(),Z=r("p"),Z.textContent=cs,$e=l(),_=r("div"),_.innerHTML=gs,we=l(),G=r("p"),G.textContent=fs,Me=l(),m(Q.$$.fragment),Te=l(),W=r("p"),W.innerHTML=vs,_e=l(),m(S.$$.fragment),Ce=l(),A=r("p"),A.innerHTML=ys,ke=l(),m(D.$$.fragment),Ue=l(),F=r("p"),F.textContent=bs,je=l(),m(Y.$$.fragment),Je=l(),O=r("p"),O.textContent=xs,He=l(),m(K.$$.fragment),Ee=l(),tt=r("p"),tt.textContent=$s,qe=l(),m(et.$$.fragment),ze=l(),nt=r("p"),nt.textContent=ws,Le=l(),m(st.$$.fragment),Ie=l(),lt=r("p"),lt.textContent=Ms,Ne=l(),m(ot.$$.fragment),Ve=l(),rt=r("p"),rt.innerHTML=Ts,Xe=l(),at=r("p"),at.innerHTML=_s,Be=l(),m(it.$$.fragment),Pe=l(),dt=r("p"),dt.innerHTML=Cs,Re=l(),mt=r("p"),mt.textContent=ks,Ze=l(),m(pt.$$.fragment),Ge=l(),m(ht.$$.fragment),Qe=l(),ut=r("p"),ut.textContent=Us,We=l(),ct=r("table"),ct.innerHTML=js,Se=l(),gt=r("p"),gt.textContent=Js,Ae=l(),m(ft.$$.fragment),De=l(),vt=r("p"),vt.innerHTML=Hs,Fe=l(),m(yt.$$.fragment),Ye=l(),bt=r("p"),bt.innerHTML=Es,Oe=l(),xt=r("p"),xt.innerHTML=qs,Ke=l(),$t=r("ul"),$t.innerHTML=zs,tn=l(),wt=r("p"),wt.textContent=Ls,en=l(),Mt=r("p"),Mt.textContent=Is,nn=l(),m(Tt.$$.fragment),sn=l(),_t=r("p"),_t.innerHTML=Ns,ln=l(),m(Ct.$$.fragment),on=l(),m(kt.$$.fragment),rn=l(),Ut=r("p"),Ut.innerHTML=Vs,an=l(),m(jt.$$.fragment),dn=l(),Jt=r("p"),Jt.innerHTML=Xs,mn=l(),Ht=r("table"),Ht.innerHTML=Bs,pn=l(),Et=r("p"),Et.innerHTML=Ps,hn=l(),m(qt.$$.fragment),un=l(),zt=r("p"),zt.innerHTML=Rs,cn=l(),Lt=r("p"),Lt.innerHTML=Zs,gn=l(),C=r("div"),C.innerHTML=Gs,fn=l(),It=r("p"),It.innerHTML=Qs,vn=l(),k=r("div"),k.innerHTML=Ws,yn=l(),Nt=r("p"),Nt.innerHTML=Ss,bn=l(),m(Vt.$$.fragment),xn=l(),f=r("div"),m(Xt.$$.fragment),Vn=l(),ee=r("p"),ee.textContent=As,Xn=l(),U=r("div"),m(Bt.$$.fragment),Bn=l(),ne=r("p"),ne.textContent=Ds,Pn=l(),j=r("div"),m(Pt.$$.fragment),Rn=l(),se=r("p"),se.textContent=Fs,Zn=l(),J=r("div"),m(Rt.$$.fragment),Gn=l(),le=r("p"),le.textContent=Ys,Qn=l(),H=r("div"),m(Zt.$$.fragment),Wn=l(),oe=r("p"),oe.textContent=Os,Sn=l(),E=r("div"),m(Gt.$$.fragment),An=l(),re=r("p"),re.textContent=Ks,Dn=l(),q=r("div"),m(Qt.$$.fragment),Fn=l(),ae=r("p"),ae.textContent=tl,Yn=l(),z=r("div"),m(Wt.$$.fragment),On=l(),ie=r("p"),ie.textContent=el,$n=l(),v=r("div"),m(St.$$.fragment),Kn=l(),de=r("p"),de.textContent=nl,ts=l(),L=r("div"),m(At.$$.fragment),es=l(),me=r("p"),me.textContent=sl,ns=l(),I=r("div"),m(Dt.$$.fragment),ss=l(),pe=r("p"),pe.textContent=ll,ls=l(),N=r("div"),m(Ft.$$.fragment),os=l(),he=r("p"),he.textContent=ol,rs=l(),V=r("div"),m(Yt.$$.fragment),as=l(),ue=r("p"),ue.textContent=rl,is=l(),X=r("div"),m(Ot.$$.fragment),ds=l(),ce=r("p"),ce.textContent=al,ms=l(),B=r("div"),m(Kt.$$.fragment),ps=l(),ge=r("p"),ge.textContent=il,wn=l(),m(te.$$.fragment),Mn=l(),ve=r("p"),this.h()},l(t){const e=cl("svelte-u9bgzb",document.head);T=a(e,"META",{name:!0,content:!0}),e.forEach(n),ye=o(t),fe=a(t,"P",{}),b(fe).forEach(n),be=o(t),p(R.$$.fragment,t),xe=o(t),Z=a(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1xyqi3j"&&(Z.textContent=cs),$e=o(t),_=a(t,"DIV",{style:!0,"data-svelte-h":!0}),d(_)!=="svelte-1trtrmz"&&(_.innerHTML=gs),we=o(t),G=a(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1fzari6"&&(G.textContent=fs),Me=o(t),p(Q.$$.fragment,t),Te=o(t),W=a(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-tw2sw7"&&(W.innerHTML=vs),_e=o(t),p(S.$$.fragment,t),Ce=o(t),A=a(t,"P",{"data-svelte-h":!0}),d(A)!=="svelte-ooeso0"&&(A.innerHTML=ys),ke=o(t),p(D.$$.fragment,t),Ue=o(t),F=a(t,"P",{"data-svelte-h":!0}),d(F)!=="svelte-n1kfsw"&&(F.textContent=bs),je=o(t),p(Y.$$.fragment,t),Je=o(t),O=a(t,"P",{"data-svelte-h":!0}),d(O)!=="svelte-cvmhd6"&&(O.textContent=xs),He=o(t),p(K.$$.fragment,t),Ee=o(t),tt=a(t,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-16zvcez"&&(tt.textContent=$s),qe=o(t),p(et.$$.fragment,t),ze=o(t),nt=a(t,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1180ir7"&&(nt.textContent=ws),Le=o(t),p(st.$$.fragment,t),Ie=o(t),lt=a(t,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-11yatwq"&&(lt.textContent=Ms),Ne=o(t),p(ot.$$.fragment,t),Ve=o(t),rt=a(t,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1jmhsjt"&&(rt.innerHTML=Ts),Xe=o(t),at=a(t,"P",{"data-svelte-h":!0}),d(at)!=="svelte-1swzwy8"&&(at.innerHTML=_s),Be=o(t),p(it.$$.fragment,t),Pe=o(t),dt=a(t,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1v8f0zk"&&(dt.innerHTML=Cs),Re=o(t),mt=a(t,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-14nr4ad"&&(mt.textContent=ks),Ze=o(t),p(pt.$$.fragment,t),Ge=o(t),p(ht.$$.fragment,t),Qe=o(t),ut=a(t,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1sl46j2"&&(ut.textContent=Us),We=o(t),ct=a(t,"TABLE",{"data-svelte-h":!0}),d(ct)!=="svelte-1ffep7v"&&(ct.innerHTML=js),Se=o(t),gt=a(t,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-yvijza"&&(gt.textContent=Js),Ae=o(t),p(ft.$$.fragment,t),De=o(t),vt=a(t,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-6qt7x3"&&(vt.innerHTML=Hs),Fe=o(t),p(yt.$$.fragment,t),Ye=o(t),bt=a(t,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-uwb7dt"&&(bt.innerHTML=Es),Oe=o(t),xt=a(t,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-a89imt"&&(xt.innerHTML=qs),Ke=o(t),$t=a(t,"UL",{"data-svelte-h":!0}),d($t)!=="svelte-v1659j"&&($t.innerHTML=zs),tn=o(t),wt=a(t,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1fn2ypb"&&(wt.textContent=Ls),en=o(t),Mt=a(t,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-jjlyr5"&&(Mt.textContent=Is),nn=o(t),p(Tt.$$.fragment,t),sn=o(t),_t=a(t,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-1oiocxk"&&(_t.innerHTML=Ns),ln=o(t),p(Ct.$$.fragment,t),on=o(t),p(kt.$$.fragment,t),rn=o(t),Ut=a(t,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-11ulv39"&&(Ut.innerHTML=Vs),an=o(t),p(jt.$$.fragment,t),dn=o(t),Jt=a(t,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-10b1zzx"&&(Jt.innerHTML=Xs),mn=o(t),Ht=a(t,"TABLE",{"data-svelte-h":!0}),d(Ht)!=="svelte-bubgue"&&(Ht.innerHTML=Bs),pn=o(t),Et=a(t,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-idwl5w"&&(Et.innerHTML=Ps),hn=o(t),p(qt.$$.fragment,t),un=o(t),zt=a(t,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1jwh942"&&(zt.innerHTML=Rs),cn=o(t),Lt=a(t,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-129arh1"&&(Lt.innerHTML=Zs),gn=o(t),C=a(t,"DIV",{style:!0,"data-svelte-h":!0}),d(C)!=="svelte-11fs52k"&&(C.innerHTML=Gs),fn=o(t),It=a(t,"P",{"data-svelte-h":!0}),d(It)!=="svelte-r85xss"&&(It.innerHTML=Qs),vn=o(t),k=a(t,"DIV",{style:!0,"data-svelte-h":!0}),d(k)!=="svelte-wolnbf"&&(k.innerHTML=Ws),yn=o(t),Nt=a(t,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-zesxnv"&&(Nt.innerHTML=Ss),bn=o(t),p(Vt.$$.fragment,t),xn=o(t),f=a(t,"DIV",{class:!0});var y=b(f);p(Xt.$$.fragment,y),Vn=o(y),ee=a(y,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-152alil"&&(ee.textContent=As),Xn=o(y),U=a(y,"DIV",{class:!0});var _n=b(U);p(Bt.$$.fragment,_n),Bn=o(_n),ne=a(_n,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-jbudbm"&&(ne.textContent=Ds),_n.forEach(n),Pn=o(y),j=a(y,"DIV",{class:!0});var Cn=b(j);p(Pt.$$.fragment,Cn),Rn=o(Cn),se=a(Cn,"P",{"data-svelte-h":!0}),d(se)!=="svelte-6c4d0o"&&(se.textContent=Fs),Cn.forEach(n),Zn=o(y),J=a(y,"DIV",{class:!0});var kn=b(J);p(Rt.$$.fragment,kn),Gn=o(kn),le=a(kn,"P",{"data-svelte-h":!0}),d(le)!=="svelte-19cl563"&&(le.textContent=Ys),kn.forEach(n),Qn=o(y),H=a(y,"DIV",{class:!0});var Un=b(H);p(Zt.$$.fragment,Un),Wn=o(Un),oe=a(Un,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-qo76c0"&&(oe.textContent=Os),Un.forEach(n),Sn=o(y),E=a(y,"DIV",{class:!0});var jn=b(E);p(Gt.$$.fragment,jn),An=o(jn),re=a(jn,"P",{"data-svelte-h":!0}),d(re)!=="svelte-12fu8ku"&&(re.textContent=Ks),jn.forEach(n),Dn=o(y),q=a(y,"DIV",{class:!0});var Jn=b(q);p(Qt.$$.fragment,Jn),Fn=o(Jn),ae=a(Jn,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-crkk5y"&&(ae.textContent=tl),Jn.forEach(n),Yn=o(y),z=a(y,"DIV",{class:!0});var Hn=b(z);p(Wt.$$.fragment,Hn),On=o(Hn),ie=a(Hn,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-d45cv9"&&(ie.textContent=el),Hn.forEach(n),y.forEach(n),$n=o(t),v=a(t,"DIV",{class:!0});var $=b(v);p(St.$$.fragment,$),Kn=o($),de=a($,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1bq9un6"&&(de.textContent=nl),ts=o($),L=a($,"DIV",{class:!0});var En=b(L);p(At.$$.fragment,En),es=o(En),me=a(En,"P",{"data-svelte-h":!0}),d(me)!=="svelte-ra5f94"&&(me.textContent=sl),En.forEach(n),ns=o($),I=a($,"DIV",{class:!0});var qn=b(I);p(Dt.$$.fragment,qn),ss=o(qn),pe=a(qn,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-mmxwjp"&&(pe.textContent=ll),qn.forEach(n),ls=o($),N=a($,"DIV",{class:!0});var zn=b(N);p(Ft.$$.fragment,zn),os=o(zn),he=a(zn,"P",{"data-svelte-h":!0}),d(he)!=="svelte-8cca1z"&&(he.textContent=ol),zn.forEach(n),rs=o($),V=a($,"DIV",{class:!0});var Ln=b(V);p(Yt.$$.fragment,Ln),as=o(Ln),ue=a(Ln,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-emvawv"&&(ue.textContent=rl),Ln.forEach(n),is=o($),X=a($,"DIV",{class:!0});var In=b(X);p(Ot.$$.fragment,In),ds=o(In),ce=a(In,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-13ama2g"&&(ce.textContent=al),In.forEach(n),ms=o($),B=a($,"DIV",{class:!0});var Nn=b(B);p(Kt.$$.fragment,Nn),ps=o(Nn),ge=a(Nn,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-vyrtkr"&&(ge.textContent=il),Nn.forEach(n),$.forEach(n),wn=o(t),p(te.$$.fragment,t),Mn=o(t),ve=a(t,"P",{}),b(ve).forEach(n),this.h()},h(){x(T,"name","hf:doc:metadata"),x(T,"content",vl),hs(_,"text-align","center"),hs(C,"text-align","center"),hs(k,"text-align","center"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){i(document.head,T),s(t,ye,e),s(t,fe,e),s(t,be,e),h(R,t,e),s(t,xe,e),s(t,Z,e),s(t,$e,e),s(t,_,e),s(t,we,e),s(t,G,e),s(t,Me,e),h(Q,t,e),s(t,Te,e),s(t,W,e),s(t,_e,e),h(S,t,e),s(t,Ce,e),s(t,A,e),s(t,ke,e),h(D,t,e),s(t,Ue,e),s(t,F,e),s(t,je,e),h(Y,t,e),s(t,Je,e),s(t,O,e),s(t,He,e),h(K,t,e),s(t,Ee,e),s(t,tt,e),s(t,qe,e),h(et,t,e),s(t,ze,e),s(t,nt,e),s(t,Le,e),h(st,t,e),s(t,Ie,e),s(t,lt,e),s(t,Ne,e),h(ot,t,e),s(t,Ve,e),s(t,rt,e),s(t,Xe,e),s(t,at,e),s(t,Be,e),h(it,t,e),s(t,Pe,e),s(t,dt,e),s(t,Re,e),s(t,mt,e),s(t,Ze,e),h(pt,t,e),s(t,Ge,e),h(ht,t,e),s(t,Qe,e),s(t,ut,e),s(t,We,e),s(t,ct,e),s(t,Se,e),s(t,gt,e),s(t,Ae,e),h(ft,t,e),s(t,De,e),s(t,vt,e),s(t,Fe,e),h(yt,t,e),s(t,Ye,e),s(t,bt,e),s(t,Oe,e),s(t,xt,e),s(t,Ke,e),s(t,$t,e),s(t,tn,e),s(t,wt,e),s(t,en,e),s(t,Mt,e),s(t,nn,e),h(Tt,t,e),s(t,sn,e),s(t,_t,e),s(t,ln,e),h(Ct,t,e),s(t,on,e),h(kt,t,e),s(t,rn,e),s(t,Ut,e),s(t,an,e),h(jt,t,e),s(t,dn,e),s(t,Jt,e),s(t,mn,e),s(t,Ht,e),s(t,pn,e),s(t,Et,e),s(t,hn,e),h(qt,t,e),s(t,un,e),s(t,zt,e),s(t,cn,e),s(t,Lt,e),s(t,gn,e),s(t,C,e),s(t,fn,e),s(t,It,e),s(t,vn,e),s(t,k,e),s(t,yn,e),s(t,Nt,e),s(t,bn,e),h(Vt,t,e),s(t,xn,e),s(t,f,e),h(Xt,f,null),i(f,Vn),i(f,ee),i(f,Xn),i(f,U),h(Bt,U,null),i(U,Bn),i(U,ne),i(f,Pn),i(f,j),h(Pt,j,null),i(j,Rn),i(j,se),i(f,Zn),i(f,J),h(Rt,J,null),i(J,Gn),i(J,le),i(f,Qn),i(f,H),h(Zt,H,null),i(H,Wn),i(H,oe),i(f,Sn),i(f,E),h(Gt,E,null),i(E,An),i(E,re),i(f,Dn),i(f,q),h(Qt,q,null),i(q,Fn),i(q,ae),i(f,Yn),i(f,z),h(Wt,z,null),i(z,On),i(z,ie),s(t,$n,e),s(t,v,e),h(St,v,null),i(v,Kn),i(v,de),i(v,ts),i(v,L),h(At,L,null),i(L,es),i(L,me),i(v,ns),i(v,I),h(Dt,I,null),i(I,ss),i(I,pe),i(v,ls),i(v,N),h(Ft,N,null),i(N,os),i(N,he),i(v,rs),i(v,V),h(Yt,V,null),i(V,as),i(V,ue),i(v,is),i(v,X),h(Ot,X,null),i(X,ds),i(X,ce),i(v,ms),i(v,B),h(Kt,B,null),i(B,ps),i(B,ge),s(t,wn,e),h(te,t,e),s(t,Mn,e),s(t,ve,e),Tn=!0},p:ml,i(t){Tn||(u(R.$$.fragment,t),u(Q.$$.fragment,t),u(S.$$.fragment,t),u(D.$$.fragment,t),u(Y.$$.fragment,t),u(K.$$.fragment,t),u(et.$$.fragment,t),u(st.$$.fragment,t),u(ot.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(ht.$$.fragment,t),u(ft.$$.fragment,t),u(yt.$$.fragment,t),u(Tt.$$.fragment,t),u(Ct.$$.fragment,t),u(kt.$$.fragment,t),u(jt.$$.fragment,t),u(qt.$$.fragment,t),u(Vt.$$.fragment,t),u(Xt.$$.fragment,t),u(Bt.$$.fragment,t),u(Pt.$$.fragment,t),u(Rt.$$.fragment,t),u(Zt.$$.fragment,t),u(Gt.$$.fragment,t),u(Qt.$$.fragment,t),u(Wt.$$.fragment,t),u(St.$$.fragment,t),u(At.$$.fragment,t),u(Dt.$$.fragment,t),u(Ft.$$.fragment,t),u(Yt.$$.fragment,t),u(Ot.$$.fragment,t),u(Kt.$$.fragment,t),u(te.$$.fragment,t),Tn=!0)},o(t){c(R.$$.fragment,t),c(Q.$$.fragment,t),c(S.$$.fragment,t),c(D.$$.fragment,t),c(Y.$$.fragment,t),c(K.$$.fragment,t),c(et.$$.fragment,t),c(st.$$.fragment,t),c(ot.$$.fragment,t),c(it.$$.fragment,t),c(pt.$$.fragment,t),c(ht.$$.fragment,t),c(ft.$$.fragment,t),c(yt.$$.fragment,t),c(Tt.$$.fragment,t),c(Ct.$$.fragment,t),c(kt.$$.fragment,t),c(jt.$$.fragment,t),c(qt.$$.fragment,t),c(Vt.$$.fragment,t),c(Xt.$$.fragment,t),c(Bt.$$.fragment,t),c(Pt.$$.fragment,t),c(Rt.$$.fragment,t),c(Zt.$$.fragment,t),c(Gt.$$.fragment,t),c(Qt.$$.fragment,t),c(Wt.$$.fragment,t),c(St.$$.fragment,t),c(At.$$.fragment,t),c(Dt.$$.fragment,t),c(Ft.$$.fragment,t),c(Yt.$$.fragment,t),c(Ot.$$.fragment,t),c(Kt.$$.fragment,t),c(te.$$.fragment,t),Tn=!1},d(t){t&&(n(ye),n(fe),n(be),n(xe),n(Z),n($e),n(_),n(we),n(G),n(Me),n(Te),n(W),n(_e),n(Ce),n(A),n(ke),n(Ue),n(F),n(je),n(Je),n(O),n(He),n(Ee),n(tt),n(qe),n(ze),n(nt),n(Le),n(Ie),n(lt),n(Ne),n(Ve),n(rt),n(Xe),n(at),n(Be),n(Pe),n(dt),n(Re),n(mt),n(Ze),n(Ge),n(Qe),n(ut),n(We),n(ct),n(Se),n(gt),n(Ae),n(De),n(vt),n(Fe),n(Ye),n(bt),n(Oe),n(xt),n(Ke),n($t),n(tn),n(wt),n(en),n(Mt),n(nn),n(sn),n(_t),n(ln),n(on),n(rn),n(Ut),n(an),n(dn),n(Jt),n(mn),n(Ht),n(pn),n(Et),n(hn),n(un),n(zt),n(cn),n(Lt),n(gn),n(C),n(fn),n(It),n(vn),n(k),n(yn),n(Nt),n(bn),n(xn),n(f),n($n),n(v),n(wn),n(Mn),n(ve)),n(T),g(R,t),g(Q,t),g(S,t),g(D,t),g(Y,t),g(K,t),g(et,t),g(st,t),g(ot,t),g(it,t),g(pt,t),g(ht,t),g(ft,t),g(yt,t),g(Tt,t),g(Ct,t),g(kt,t),g(jt,t),g(qt,t),g(Vt,t),g(Xt),g(Bt),g(Pt),g(Rt),g(Zt),g(Gt),g(Qt),g(Wt),g(St),g(At),g(Dt),g(Ft),g(Yt),g(Ot),g(Kt),g(te,t)}}}const vl='{"title":"Text Environments","local":"text-environments","sections":[{"title":"Tools","local":"tools","sections":[{"title":"transformers.Tool","local":"transformerstool","sections":[],"depth":3},{"title":"Custom Tools","local":"custom-tools","sections":[],"depth":3},{"title":"Call syntax","local":"call-syntax","sections":[],"depth":3}],"depth":2},{"title":"Create a TextEnvironment","local":"create-a-textenvironment","sections":[],"depth":2},{"title":"Run an Episode","local":"run-an-episode","sections":[{"title":"Train","local":"train","sections":[],"depth":3}],"depth":2},{"title":"TextHistory","local":"texthistory","sections":[{"title":"Attributes","local":"attributes","sections":[],"depth":3},{"title":"Visualization","local":"visualization","sections":[],"depth":3}],"depth":2},{"title":"API Documentation","local":"trl.TextEnvironment","sections":[],"depth":2}],"depth":1}';function yl(us){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tl extends hl{constructor(T){super(),ul(this,T,yl,fl,dl,{})}}export{Tl as component};
