import{s as Ut,n as It,o as Ct}from"../chunks/scheduler.85c25b89.js";import{S as Zt,i as $t,g as p,s as l,r as m,A as Bt,h as i,f as a,c as n,j as ft,u as o,x as g,k as bt,y as vt,a as e,v as c,d as r,t as h,w as M}from"../chunks/index.c9bcf812.js";import{C as Q}from"../chunks/CodeBlock.94efc595.js";import{H as _}from"../chunks/Heading.3c6e5b17.js";function Wt(rt){let y,R,V,Y,d,S,J,ht='<strong>Inception-ResNet-v2</strong> is a convolutional neural architecture that builds on the Inception family of architectures but incorporates <a href="https://paperswithcode.com/method/residual-connection" rel="nofollow">residual connections</a> (replacing the filter concatenation stage of the Inception architecture).',z,j,F,w,Mt="To load a pretrained model:",H,u,A,T,gt="To load and preprocess the image:",L,f,D,b,yt="To get the model predictions:",q,U,P,I,dt="To get the top-5 predictions class names:",K,C,O,Z,Jt="Replace the model name with the variant you want to use, e.g. <code>inception_resnet_v2</code>. You can find the IDs in the model summaries at the top of this page.",tt,$,jt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,B,at,v,wt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",et,W,lt,N,ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,k,pt,G,Tt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',it,x,mt,E,ot,X,ct;return d=new _({props:{title:"Inception ResNet v2",local:"inception-resnet-v2",headingTag:"h1"}}),j=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2luY2VwdGlvbl9yZXNuZXRfdjInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_resnet_v2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),W=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaW5jZXB0aW9uX3Jlc25ldF92MiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_resnet_v2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),k=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),x=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new Q({props:{code:"JTQwbWlzYyU3QnN6ZWdlZHkyMDE2aW5jZXB0aW9udjQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkluY2VwdGlvbi12NCUyQyUyMEluY2VwdGlvbi1SZXNOZXQlMjBhbmQlMjB0aGUlMjBJbXBhY3QlMjBvZiUyMFJlc2lkdWFsJTIwQ29ubmVjdGlvbnMlMjBvbiUyMExlYXJuaW5nJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUyMFNlcmdleSUyMElvZmZlJTIwYW5kJTIwVmluY2VudCUyMFZhbmhvdWNrZSUyMGFuZCUyMEFsZXglMjBBbGVtaSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTYwMi4wNzI2MSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{szegedy2016inceptionv4,
      title={Inception-v4, Inception-ResNet and the Impact of Residual Connections on Learning}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Christian Szegedy and Sergey Ioffe and Vincent Vanhoucke and Alex Alemi}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2016}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1602.07261}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){y=p("meta"),R=l(),V=p("p"),Y=l(),m(d.$$.fragment),S=l(),J=p("p"),J.innerHTML=ht,z=l(),m(j.$$.fragment),F=l(),w=p("p"),w.textContent=Mt,H=l(),m(u.$$.fragment),A=l(),T=p("p"),T.textContent=gt,L=l(),m(f.$$.fragment),D=l(),b=p("p"),b.textContent=yt,q=l(),m(U.$$.fragment),P=l(),I=p("p"),I.textContent=dt,K=l(),m(C.$$.fragment),O=l(),Z=p("p"),Z.innerHTML=Jt,tt=l(),$=p("p"),$.innerHTML=jt,st=l(),m(B.$$.fragment),at=l(),v=p("p"),v.textContent=wt,et=l(),m(W.$$.fragment),lt=l(),N=p("p"),N.innerHTML=ut,nt=l(),m(k.$$.fragment),pt=l(),G=p("p"),G.innerHTML=Tt,it=l(),m(x.$$.fragment),mt=l(),m(E.$$.fragment),ot=l(),X=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);y=i(s,"META",{name:!0,content:!0}),s.forEach(a),R=n(t),V=i(t,"P",{}),ft(V).forEach(a),Y=n(t),o(d.$$.fragment,t),S=n(t),J=i(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-gd1at0"&&(J.innerHTML=ht),z=n(t),o(j.$$.fragment,t),F=n(t),w=i(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-18ywhxh"&&(w.textContent=Mt),H=n(t),o(u.$$.fragment,t),A=n(t),T=i(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=gt),L=n(t),o(f.$$.fragment,t),D=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1n9qsq1"&&(b.textContent=yt),q=n(t),o(U.$$.fragment,t),P=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=dt),K=n(t),o(C.$$.fragment,t),O=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-17lzl0w"&&(Z.innerHTML=Jt),tt=n(t),$=i(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-1wmi3ea"&&($.innerHTML=jt),st=n(t),o(B.$$.fragment,t),at=n(t),v=i(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-9sr7nh"&&(v.textContent=wt),et=n(t),o(W.$$.fragment,t),lt=n(t),N=i(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1kguc51"&&(N.innerHTML=ut),nt=n(t),o(k.$$.fragment,t),pt=n(t),G=i(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1n0coha"&&(G.innerHTML=Tt),it=n(t),o(x.$$.fragment,t),mt=n(t),o(E.$$.fragment,t),ot=n(t),X=i(t,"P",{}),ft(X).forEach(a),this.h()},h(){bt(y,"name","hf:doc:metadata"),bt(y,"content",Nt)},m(t,s){vt(document.head,y),e(t,R,s),e(t,V,s),e(t,Y,s),c(d,t,s),e(t,S,s),e(t,J,s),e(t,z,s),c(j,t,s),e(t,F,s),e(t,w,s),e(t,H,s),c(u,t,s),e(t,A,s),e(t,T,s),e(t,L,s),c(f,t,s),e(t,D,s),e(t,b,s),e(t,q,s),c(U,t,s),e(t,P,s),e(t,I,s),e(t,K,s),c(C,t,s),e(t,O,s),e(t,Z,s),e(t,tt,s),e(t,$,s),e(t,st,s),c(B,t,s),e(t,at,s),e(t,v,s),e(t,et,s),c(W,t,s),e(t,lt,s),e(t,N,s),e(t,nt,s),c(k,t,s),e(t,pt,s),e(t,G,s),e(t,it,s),c(x,t,s),e(t,mt,s),c(E,t,s),e(t,ot,s),e(t,X,s),ct=!0},p:It,i(t){ct||(r(d.$$.fragment,t),r(j.$$.fragment,t),r(u.$$.fragment,t),r(f.$$.fragment,t),r(U.$$.fragment,t),r(C.$$.fragment,t),r(B.$$.fragment,t),r(W.$$.fragment,t),r(k.$$.fragment,t),r(x.$$.fragment,t),r(E.$$.fragment,t),ct=!0)},o(t){h(d.$$.fragment,t),h(j.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(C.$$.fragment,t),h(B.$$.fragment,t),h(W.$$.fragment,t),h(k.$$.fragment,t),h(x.$$.fragment,t),h(E.$$.fragment,t),ct=!1},d(t){t&&(a(R),a(V),a(Y),a(S),a(J),a(z),a(F),a(w),a(H),a(A),a(T),a(L),a(D),a(b),a(q),a(P),a(I),a(K),a(O),a(Z),a(tt),a($),a(st),a(at),a(v),a(et),a(lt),a(N),a(nt),a(pt),a(G),a(it),a(mt),a(ot),a(X)),a(y),M(d,t),M(j,t),M(u,t),M(f,t),M(U,t),M(C,t),M(B,t),M(W,t),M(k,t),M(x,t),M(E,t)}}}const Nt='{"title":"Inception ResNet v2","local":"inception-resnet-v2","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function kt(rt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Zt{constructor(y){super(),$t(this,y,kt,Wt,Ut,{})}}export{Vt as component};
