import{s as we,n as fe,o as Te}from"../chunks/scheduler.8c3d61f6.js";import{S as je,i as Ue,g as i,s as a,r as c,A as Je,h as p,f as s,c as n,j as ye,u as h,x as o,k as de,y as be,a as l,v as M,d as u,t as m,w as y}from"../chunks/index.da70eac4.js";import{C as B}from"../chunks/CodeBlock.a9c4becf.js";import{H as Ie,E as ge}from"../chunks/getInferenceSnippets.4986d68f.js";function Ce(ae){let r,W,X,V,d,H,w,ne="Diffusers’ pipelines can be used as an inference engine for a server. It supports concurrent and multithreaded requests to generate images that may be requested by multiple users at the same time.",R,f,ie='This guide will show you how to use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3Pipeline">StableDiffusion3Pipeline</a> in a server, but feel free to use any pipeline you want.',Y,T,pe="Start by navigating to the <code>examples/server</code> folder and installing all of the dependencies.",E,j,N,U,oe="Launch the server with the following command.",S,J,F,b,re="The server is accessed at http://localhost:8000. You can curl this model with the following command.",Q,I,q,g,ce='If you need to upgrade some dependencies, you can use either <a href="https://github.com/jazzband/pip-tools" rel="nofollow">pip-tools</a> or <a href="https://github.com/astral-sh/uv" rel="nofollow">uv</a>. For example, upgrade the dependencies with <code>uv</code> using the following command.',L,C,z,v,he='The server is built with <a href="https://fastapi.tiangolo.com/async/" rel="nofollow">FastAPI</a>. The endpoint for <code>v1/images/generations</code> is shown below.',P,G,D,Z,Me='The <code>generate_image</code> function is defined as asynchronous with the <a href="https://fastapi.tiangolo.com/async/" rel="nofollow">async</a> keyword so that FastAPI knows that whatever is happening in this function won’t necessarily return a result right away. Once it hits some point in the function that it needs to await some other <a href="https://docs.python.org/3/library/asyncio-task.html#asyncio.Task" rel="nofollow">Task</a>, the main thread goes back to answering other HTTP requests. This is shown in the code below with the <a href="https://fastapi.tiangolo.com/async/#async-and-await" rel="nofollow">await</a> keyword.',K,$,O,k,ue='At this point, the execution of the pipeline function is placed onto a <a href="https://docs.python.org/3/library/asyncio-eventloop.html#asyncio.loop.run_in_executor" rel="nofollow">new thread</a>, and the main thread performs other things until a result is returned from the <code>pipeline</code>.',ee,_,me="Another important aspect of this implementation is creating a <code>pipeline</code> from <code>shared_pipeline</code>. The goal behind this is to avoid loading the underlying model more than once onto the GPU while still allowing for each new request that is running on a separate thread to have its own generator and scheduler. The scheduler, in particular, is not thread-safe, and it will cause errors like: <code>IndexError: index 21 is out of bounds for dimension 0 with size 21</code> if you try to use the same scheduler across multiple threads.",te,A,se,x,le;return d=new Ie({props:{title:"Create a server",local:"create-a-server",headingTag:"h1"}}),j=new B({props:{code:"cGlwJTIwaW5zdGFsbCUyMC4lMEFwaXAlMjBpbnN0YWxsJTIwLWYlMjByZXF1aXJlbWVudHMudHh0",highlighted:`pip install .
pip install -f requirements.txt`,wrap:!1}}),J=new B({props:{code:"cHl0aG9uJTIwc2VydmVyLnB5",highlighted:"python server.py",wrap:!1}}),I=new B({props:{code:"Y3VybCUyMC1YJTIwUE9TVCUyMC1IJTIwJTIyQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTIyJTIwLS1kYXRhJTIwJyU3QiUyMm1vZGVsJTIyJTNBJTIwJTIyc29tZXRoaW5nJTIyJTJDJTIwJTIycHJvbXB0JTIyJTNBJTIwJTIyYSUyMGtpdHRlbiUyMGluJTIwZnJvbnQlMjBvZiUyMGElMjBmaXJlcGxhY2UlMjIlN0QnJTIwaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTgwMDAlMkZ2MSUyRmltYWdlcyUyRmdlbmVyYXRpb25z",highlighted:'curl -X POST -H <span class="hljs-string">&quot;Content-Type: application/json&quot;</span> <span class="hljs-params">--data</span> &#x27;{<span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;something&quot;</span>, <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;a kitten in front of a fireplace&quot;</span>}&#x27; http:<span class="hljs-string">//localhost</span><span class="hljs-function">:8000</span>/v1/images/generations',wrap:!1}}),C=new B({props:{code:"dXYlMjBwaXAlMjBjb21waWxlJTIwcmVxdWlyZW1lbnRzLmluJTIwLW8lMjByZXF1aXJlbWVudHMudHh0",highlighted:'uv pip compile <span class="hljs-keyword">requirements</span>.<span class="hljs-keyword">in</span> -o <span class="hljs-keyword">requirements</span>.txt',wrap:!1}}),G=new B({props:{code:"JTQwYXBwLnBvc3QoJTIyJTJGdjElMkZpbWFnZXMlMkZnZW5lcmF0aW9ucyUyMiklMEFhc3luYyUyMGRlZiUyMGdlbmVyYXRlX2ltYWdlKGltYWdlX2lucHV0JTNBJTIwVGV4dFRvSW1hZ2VJbnB1dCklM0ElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb29wJTIwJTNEJTIwYXN5bmNpby5nZXRfZXZlbnRfbG9vcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyJTIwJTNEJTIwc2hhcmVkX3BpcGVsaW5lLnBpcGVsaW5lLnNjaGVkdWxlci5mcm9tX2NvbmZpZyhzaGFyZWRfcGlwZWxpbmUucGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3BpcGUoc2hhcmVkX3BpcGVsaW5lLnBpcGVsaW5lJTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvci5tYW51YWxfc2VlZChyYW5kb20ucmFuZGludCgwJTJDJTIwMTAwMDAwMDApKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwbG9vcC5ydW5faW5fZXhlY3V0b3IoTm9uZSUyQyUyMGxhbWJkYSUzQSUyMHBpcGVsaW5lKGltYWdlX2lucHV0LnByb21wdCUyQyUyMGdlbmVyYXRvciUyMCUzRCUyMGdlbmVyYXRvcikpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9nZ2VyLmluZm8oZiUyMm91dHB1dCUzQSUyMCU3Qm91dHB1dCU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZV91cmwlMjAlM0QlMjBzYXZlX2ltYWdlKG91dHB1dC5pbWFnZXMlNUIwJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmRhdGElMjIlM0ElMjAlNUIlN0IlMjJ1cmwlMjIlM0ElMjBpbWFnZV91cmwlN0QlNUQlN0QlMEElMjAlMjAlMjAlMjBleGNlcHQlMjBFeGNlcHRpb24lMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGlzaW5zdGFuY2UoZSUyQyUyMEhUVFBFeGNlcHRpb24pJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxpZiUyMGhhc2F0dHIoZSUyQyUyMCdtZXNzYWdlJyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMEhUVFBFeGNlcHRpb24oc3RhdHVzX2NvZGUlM0Q1MDAlMkMlMjBkZXRhaWwlM0RlLm1lc3NhZ2UlMjAlMkIlMjB0cmFjZWJhY2suZm9ybWF0X2V4YygpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwSFRUUEV4Y2VwdGlvbihzdGF0dXNfY29kZSUzRDUwMCUyQyUyMGRldGFpbCUzRHN0cihlKSUyMCUyQiUyMHRyYWNlYmFjay5mb3JtYXRfZXhjKCkp",highlighted:`<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/v1/images/generations&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_image</span>(<span class="hljs-params">image_input: TextToImageInput</span>):
    <span class="hljs-keyword">try</span>:
        loop = asyncio.get_event_loop()
        scheduler = shared_pipeline.pipeline.scheduler.from_config(shared_pipeline.pipeline.scheduler.config)
        pipeline = StableDiffusion3Pipeline.from_pipe(shared_pipeline.pipeline, scheduler=scheduler)
        generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>)
        generator.manual_seed(random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">10000000</span>))
        output = <span class="hljs-keyword">await</span> loop.run_in_executor(<span class="hljs-literal">None</span>, <span class="hljs-keyword">lambda</span>: pipeline(image_input.prompt, generator = generator))
        logger.info(<span class="hljs-string">f&quot;output: <span class="hljs-subst">{output}</span>&quot;</span>)
        image_url = save_image(output.images[<span class="hljs-number">0</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;data&quot;</span>: [{<span class="hljs-string">&quot;url&quot;</span>: image_url}]}
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(e, HTTPException):
            <span class="hljs-keyword">raise</span> e
        <span class="hljs-keyword">elif</span> <span class="hljs-built_in">hasattr</span>(e, <span class="hljs-string">&#x27;message&#x27;</span>):
            <span class="hljs-keyword">raise</span> HTTPException(status_code=<span class="hljs-number">500</span>, detail=e.message + traceback.format_exc())
        <span class="hljs-keyword">raise</span> HTTPException(status_code=<span class="hljs-number">500</span>, detail=<span class="hljs-built_in">str</span>(e) + traceback.format_exc())`,wrap:!1}}),$=new B({props:{code:"b3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBsb29wLnJ1bl9pbl9leGVjdXRvcihOb25lJTJDJTIwbGFtYmRhJTNBJTIwcGlwZWxpbmUoaW1hZ2VfaW5wdXQucHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTIwJTNEJTIwZ2VuZXJhdG9yKSk=",highlighted:'output = <span class="hljs-keyword">await</span> loop.run_in_executor(<span class="hljs-literal">None</span>, <span class="hljs-keyword">lambda</span>: pipeline(image_input.prompt, generator = generator))',wrap:!1}}),A=new ge({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/create_a_server.md"}}),{c(){r=i("meta"),W=a(),X=i("p"),V=a(),c(d.$$.fragment),H=a(),w=i("p"),w.textContent=ne,R=a(),f=i("p"),f.innerHTML=ie,Y=a(),T=i("p"),T.innerHTML=pe,E=a(),c(j.$$.fragment),N=a(),U=i("p"),U.textContent=oe,S=a(),c(J.$$.fragment),F=a(),b=i("p"),b.textContent=re,Q=a(),c(I.$$.fragment),q=a(),g=i("p"),g.innerHTML=ce,L=a(),c(C.$$.fragment),z=a(),v=i("p"),v.innerHTML=he,P=a(),c(G.$$.fragment),D=a(),Z=i("p"),Z.innerHTML=Me,K=a(),c($.$$.fragment),O=a(),k=i("p"),k.innerHTML=ue,ee=a(),_=i("p"),_.innerHTML=me,te=a(),c(A.$$.fragment),se=a(),x=i("p"),this.h()},l(e){const t=Je("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(s),W=n(e),X=p(e,"P",{}),ye(X).forEach(s),V=n(e),h(d.$$.fragment,e),H=n(e),w=p(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1tax1pm"&&(w.textContent=ne),R=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1tktrqi"&&(f.innerHTML=ie),Y=n(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1aiwesf"&&(T.innerHTML=pe),E=n(e),h(j.$$.fragment,e),N=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-c719ce"&&(U.textContent=oe),S=n(e),h(J.$$.fragment,e),F=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1qh6v4"&&(b.textContent=re),Q=n(e),h(I.$$.fragment,e),q=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1j1bynp"&&(g.innerHTML=ce),L=n(e),h(C.$$.fragment,e),z=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1cbt1a"&&(v.innerHTML=he),P=n(e),h(G.$$.fragment,e),D=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-zd8in7"&&(Z.innerHTML=Me),K=n(e),h($.$$.fragment,e),O=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-88w77b"&&(k.innerHTML=ue),ee=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-hjn2ql"&&(_.innerHTML=me),te=n(e),h(A.$$.fragment,e),se=n(e),x=p(e,"P",{}),ye(x).forEach(s),this.h()},h(){de(r,"name","hf:doc:metadata"),de(r,"content",ve)},m(e,t){be(document.head,r),l(e,W,t),l(e,X,t),l(e,V,t),M(d,e,t),l(e,H,t),l(e,w,t),l(e,R,t),l(e,f,t),l(e,Y,t),l(e,T,t),l(e,E,t),M(j,e,t),l(e,N,t),l(e,U,t),l(e,S,t),M(J,e,t),l(e,F,t),l(e,b,t),l(e,Q,t),M(I,e,t),l(e,q,t),l(e,g,t),l(e,L,t),M(C,e,t),l(e,z,t),l(e,v,t),l(e,P,t),M(G,e,t),l(e,D,t),l(e,Z,t),l(e,K,t),M($,e,t),l(e,O,t),l(e,k,t),l(e,ee,t),l(e,_,t),l(e,te,t),M(A,e,t),l(e,se,t),l(e,x,t),le=!0},p:fe,i(e){le||(u(d.$$.fragment,e),u(j.$$.fragment,e),u(J.$$.fragment,e),u(I.$$.fragment,e),u(C.$$.fragment,e),u(G.$$.fragment,e),u($.$$.fragment,e),u(A.$$.fragment,e),le=!0)},o(e){m(d.$$.fragment,e),m(j.$$.fragment,e),m(J.$$.fragment,e),m(I.$$.fragment,e),m(C.$$.fragment,e),m(G.$$.fragment,e),m($.$$.fragment,e),m(A.$$.fragment,e),le=!1},d(e){e&&(s(W),s(X),s(V),s(H),s(w),s(R),s(f),s(Y),s(T),s(E),s(N),s(U),s(S),s(F),s(b),s(Q),s(q),s(g),s(L),s(z),s(v),s(P),s(D),s(Z),s(K),s(O),s(k),s(ee),s(_),s(te),s(se),s(x)),s(r),y(d,e),y(j,e),y(J,e),y(I,e),y(C,e),y(G,e),y($,e),y(A,e)}}}const ve='{"title":"Create a server","local":"create-a-server","sections":[],"depth":1}';function Ge(ae){return Te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ae extends je{constructor(r){super(),Ue(this,r,Ge,Ce,we,{})}}export{Ae as component};
