import{s as St,n as Ft,o as vt}from"../chunks/scheduler.8c3d61f6.js";import{S as Yt,i as $t,g as a,s as i,r as d,A as Nt,h as o,f as t,c as n,j as gt,u as M,x as p,k as Vt,y as Qt,a as s,v as c,d as r,t as f,w as m}from"../chunks/index.da70eac4.js";import{C as u}from"../chunks/CodeBlock.a9c4becf.js";import{H as y,E as Et}from"../chunks/getInferenceSnippets.7d4354d6.js";function Lt(Pl){let J,ge,Xe,Ve,U,Se,T,Kl='Modular Diffusers is a framework for quickly building flexible and customizable pipelines. At the core of Modular Diffusers are <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> that can be combined with other blocks to adapt to new workflows. The blocks are converted into a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>, a friendly user-facing interface developers can use.',Fe,b,Ol='This doc will show you how to implement a <a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a> pipeline with the modular framework.',ve,w,Ye,Z,et='<a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> are <em>definitions</em> that specify the components, inputs, outputs, and computation logic for a single step in a pipeline. There are four types of blocks.',$e,h,lt='<li><a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> is the most basic block for a single step.</li> <li><code>SequentialPipelineBlocks</code> is a multi-block that composes other blocks linearly. The outputs of one block are the inputs to the next block.</li> <li><code>LoopSequentialPipelineBlocks</code> is a multi-block that runs iteratively and is designed for iterative workflows.</li> <li><code>AutoPipelineBlocks</code> is a collection of blocks for different workflows and it selects which block to run based on the input. It is designed to conveniently package multiple workflows into a single pipeline.</li>',Ne,I,tt='<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a> is an image-to-image workflow. Start with the <code>IMAGE2IMAGE_BLOCKS</code> preset, a collection of <code>ModularPipelineBlocks</code> for image-to-image generation.',Qe,j,Ee,C,Le,G,st="Modular Diffusers uses <em>state</em> to communicate data between blocks. There are two types of states.",De,R,it="<li><code>PipelineState</code> is a global state that can be used to track all inputs and outputs across all blocks.</li> <li><code>BlockState</code> is a local view of relevant variables from <code>PipelineState</code> for an individual block.</li>",Ae,k,ze,_,nt='<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a> differs from standard image-to-image in its <code>prepare_latents</code> and <code>denoise</code> blocks. All the other blocks can be reused, but you’ll need to modify these two.',He,W,at="Create placeholder <code>ModularPipelineBlocks</code> for <code>prepare_latents</code> and <code>denoise</code> by copying and modifying the existing ones.",xe,X,ot="Print the <code>denoise</code> block to see that it is composed of <code>LoopSequentialPipelineBlocks</code> with three sub-blocks, <code>before_denoiser</code>, <code>denoiser</code>, and <code>after_denoiser</code>. Only the <code>before_denoiser</code> sub-block needs to be modified to prepare the latent input for the denoiser based on the change map.",qe,B,Pe,g,pt="Replace the <code>StableDiffusionXLLoopBeforeDenoiser</code> sub-block with the new <code>SDXLDiffDiffLoopBeforeDenoiser</code> block.",Ke,V,Oe,S,el,F,dt="The <code>prepare_latents</code> block requires the following changes.",ll,v,Mt="<li>a processor to process the change map</li> <li>a new <code>inputs</code> to accept the user-provided change map, <code>timestep</code> for precomputing all the latents and <code>num_inference_steps</code> to create the mask for updating the image regions</li> <li>update the computation in the <code>__call__</code> method for processing the change map and creating the masks, and storing it in the <code>BlockState</code></li>",tl,Y,sl,$,il,N,ct="The <code>before_denoiser</code> sub-block requires the following changes.",nl,Q,rt="<li>a new <code>inputs</code> to accept a <code>denoising_start</code> parameter,  <code>original_latents</code> and <code>diffdiff_masks</code> from the <code>prepare_latents</code> block</li> <li>update the computation in the <code>__call__</code> method for applying Differential Diffusion</li>",al,E,ol,L,pl,D,ft='You should have all the blocks you need at this point to create a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>.',dl,A,mt="Copy the existing <code>IMAGE2IMAGE_BLOCKS</code> preset and for the <code>set_timesteps</code> block, use the <code>set_timesteps</code> from the <code>TEXT2IMAGE_BLOCKS</code> because Differential Diffusion doesn’t require a <code>strength</code> parameter.",Ml,z,ut="Set the <code>prepare_latents</code> and <code>denoise</code> blocks to the <code>SDXLDiffDiffPrepareLatentsStep</code> and <code>SDXLDiffDiffDenoiseStep</code> blocks you just modified.",cl,H,yt="Call <code>SequentialPipelineBlocks.from_blocks_dict</code> on the blocks to create a <code>SequentialPipelineBlocks</code>.",rl,x,fl,q,ml,P,Jt='Convert the <code>SequentialPipelineBlocks</code> into a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> with the <code>ModularPipeline.init_pipeline</code> method. This initializes the expected components to load from a <code>modular_model_index.json</code> file. Explicitly load the components by calling <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_components">ModularPipeline.load_components()</a>.',ul,K,Ut='It is a good idea to initialize the <code>ComponentManager</code> with the pipeline to help manage the different components. Once you call <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_components">load_components()</a>, the components are registered to the <code>ComponentManager</code> and can be shared between workflows. The example below uses the <code>collection</code> argument to assign the components a <code>&quot;diffdiff&quot;</code> label for better organization.',yl,O,Jl,ee,Ul,le,Tt='Other workflows can be added to the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> to support additional features without rewriting the entire pipeline from scratch.',Tl,te,bt="This section demonstrates how to add an IP-Adapter or ControlNet.",bl,se,wl,ie,wt="Stable Diffusion XL already has a preset IP-Adapter block that you can use and doesn’t require any changes to the existing Differential Diffusion pipeline.",Zl,ne,hl,ae,Zt='Use the <code>sub_blocks.insert</code> method to insert it into the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>. The example below inserts the <code>ip_adapter_block</code> at position <code>0</code>. Print the pipeline to see that the <code>ip_adapter_block</code> is added and it requires an <code>ip_adapter_image</code>. This also added two components to the pipeline, the <code>image_encoder</code> and <code>feature_extractor</code>.',Il,oe,jl,pe,ht='Call <code>~ModularPipeline.init_pipeline</code> to initialize a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> and use <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_components">load_components()</a> to load the model components. Load and set the IP-Adapter to run the pipeline.',Cl,de,Gl,Me,Rl,ce,It="Stable Diffusion XL already has a preset ControlNet block that can readily be used.",kl,re,_l,fe,jt="However, it requires modifying the <code>denoise</code> block because that’s where the ControlNet injects the control information into the UNet.",Wl,me,Ct="Modify the <code>denoise</code> block by replacing the <code>StableDiffusionXLLoopDenoiser</code> sub-block with the <code>StableDiffusionXLControlNetLoopDenoiser</code>.",Xl,ue,Bl,ye,Gt='Insert the <code>controlnet_input</code> block and replace the <code>denoise</code> block with the new <code>controlnet_denoise_block</code>. Initialize a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> and <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_components">load_components()</a> into it.',gl,Je,Vl,Ue,Sl,Te,Rt='The Differential Diffusion, IP-Adapter, and ControlNet workflows can be bundled into a single <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> by using <code>AutoPipelineBlocks</code>. This allows automatically selecting which sub-blocks to run based on the inputs like <code>control_image</code> or <code>ip_adapter_image</code>. If none of these inputs are passed, then it defaults to the Differential Diffusion.',Fl,be,kt="Use <code>block_trigger_inputs</code> to only run the <code>SDXLDiffDiffControlNetDenoiseStep</code> block if a <code>control_image</code> input is provided. Otherwise, the <code>SDXLDiffDiffDenoiseStep</code> is used.",vl,we,Yl,Ze,_t="Add the <code>ip_adapter</code> and <code>controlnet_input</code> blocks.",$l,he,Nl,Ie,Wt='Call <code>SequentialPipelineBlocks.from_blocks_dict</code> to create a <code>SequentialPipelineBlocks</code> and create a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> and load in the model components to run.',Ql,je,El,Ce,Ll,Ge,Xt='Add your <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> to the Hub with <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.save_pretrained">save_pretrained()</a> and set <code>push_to_hub</code> argument to <code>True</code>.',Dl,Re,Al,ke,Bt='Other users can load the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> with <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.from_pretrained">from_pretrained()</a>.',zl,_e,Hl,We,xl,Be,ql;return U=new y({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),w=new y({props:{title:"ModularPipelineBlocks",local:"modularpipelineblocks",headingTag:"h2"}}),j=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwSU1BR0UySU1BR0VfQkxPQ0tTJTBBSU1BR0UySU1BR0VfQkxPQ0tTJTIwJTNEJTIwSW5zZXJ0YWJsZURpY3QoJTVCJTBBJTIwJTIwJTIwJTIwKCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMVGV4dEVuY29kZXJTdGVwKSUyQyUwQSUyMCUyMCUyMCUyMCglMjJpbWFnZV9lbmNvZGVyJTIyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExWYWVFbmNvZGVyU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyaW5wdXQlMjIlMkMlMjBTdGFibGVEaWZmdXNpb25YTElucHV0U3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyc2V0X3RpbWVzdGVwcyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1NldFRpbWVzdGVwc1N0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMnByZXBhcmVfbGF0ZW50cyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIycHJlcGFyZV9hZGRfY29uZCUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVBZGRpdGlvbmFsQ29uZGl0aW9uaW5nU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyZGVub2lzZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZVN0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMmRlY29kZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVjb2RlU3RlcCklMEElNUQp",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> IMAGE2IMAGE_BLOCKS
IMAGE2IMAGE_BLOCKS = InsertableDict([
    (<span class="hljs-string">&quot;text_encoder&quot;</span>, StableDiffusionXLTextEncoderStep),
    (<span class="hljs-string">&quot;image_encoder&quot;</span>, StableDiffusionXLVaeEncoderStep),
    (<span class="hljs-string">&quot;input&quot;</span>, StableDiffusionXLInputStep),
    (<span class="hljs-string">&quot;set_timesteps&quot;</span>, StableDiffusionXLImg2ImgSetTimestepsStep),
    (<span class="hljs-string">&quot;prepare_latents&quot;</span>, StableDiffusionXLImg2ImgPrepareLatentsStep),
    (<span class="hljs-string">&quot;prepare_add_cond&quot;</span>, StableDiffusionXLImg2ImgPrepareAdditionalConditioningStep),
    (<span class="hljs-string">&quot;denoise&quot;</span>, StableDiffusionXLDenoiseStep),
    (<span class="hljs-string">&quot;decode&quot;</span>, StableDiffusionXLDecodeStep)
])`,wrap:!1}}),C=new y({props:{title:"Pipeline and block states",local:"pipeline-and-block-states",headingTag:"h2"}}),k=new y({props:{title:"Customizing blocks",local:"customizing-blocks",headingTag:"h2"}}),B=new u({props:{code:"ZGVub2lzZV9ibG9ja3MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEKCklMEFwcmludChkZW5vaXNlX2Jsb2Nrcyk=",highlighted:`denoise_blocks = IMAGE2IMAGE_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>]()
<span class="hljs-built_in">print</span>(denoise_blocks)`,wrap:!1}}),V=new u({props:{code:"JTIzJTIwQ29weSUyMGV4aXN0aW5nJTIwYmxvY2tzJTIwYXMlMjBwbGFjZWhvbGRlcnMlMEFjbGFzcyUyMFNEWExEaWZmRGlmZlByZXBhcmVMYXRlbnRzU3RlcChNb2R1bGFyUGlwZWxpbmVCbG9ja3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ29waWVkJTIwZnJvbSUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCUyMC0lMjB3aWxsJTIwbW9kaWZ5JTIwbGF0ZXIlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjBzYW1lJTIwaW1wbGVtZW50YXRpb24lMjBhcyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCUwQSUwQWNsYXNzJTIwU0RYTERpZmZEaWZmRGVub2lzZVN0ZXAoU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlTG9vcFdyYXBwZXIpJTNBJTBBJTIwJTIwJTIwJTIwYmxvY2tfY2xhc3NlcyUyMCUzRCUyMCU1QlNEWExEaWZmRGlmZkxvb3BCZWZvcmVEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMTG9vcERlbm9pc2VyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExMb29wQWZ0ZXJEZW5vaXNlciU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX25hbWVzJTIwJTNEJTIwJTVCJTIyYmVmb3JlX2Rlbm9pc2VyJTIyJTJDJTIwJTIyZGVub2lzZXIlMjIlMkMlMjAlMjJhZnRlcl9kZW5vaXNlciUyMiU1RA==",highlighted:`<span class="hljs-comment"># Copy existing blocks as placeholders</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffPrepareLatentsStep</span>(<span class="hljs-title class_ inherited__">ModularPipelineBlocks</span>):
    <span class="hljs-string">&quot;&quot;&quot;Copied from StableDiffusionXLImg2ImgPrepareLatentsStep - will modify later&quot;&quot;&quot;</span>
    <span class="hljs-comment"># ... same implementation as StableDiffusionXLImg2ImgPrepareLatentsStep</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLLoopDenoiser, StableDiffusionXLLoopAfterDenoiser]
    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]`,wrap:!1}}),S=new y({props:{title:"prepare_latents",local:"preparelatents",headingTag:"h3"}}),Y=new u({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAoTW9kdWxhclBpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwZXhwZWN0ZWRfY29tcG9uZW50cyhzZWxmKSUyMC0lM0UlMjBMaXN0JTVCQ29tcG9uZW50U3BlYyU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMENvbXBvbmVudFNwZWMoJTIydmFlJTIyJTJDJTIwQXV0b2VuY29kZXJLTCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb21wb25lbnRTcGVjKCUyMnNjaGVkdWxlciUyMiUyQyUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIpJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQ29tcG9uZW50U3BlYyglMjJtYXNrX3Byb2Nlc3NvciUyMiUyQyUyMFZhZUltYWdlUHJvY2Vzc29yJTJDJTIwY29uZmlnJTNERnJvemVuRGljdCglN0IlMjJkb19ub3JtYWxpemUlMjIlM0ElMjBGYWxzZSUyQyUyMCUyMmRvX2NvbnZlcnRfZ3JheXNjYWxlJTIyJTNBJTIwVHJ1ZSU3RCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBpbnB1dHMoc2VsZiklMjAtJTNFJTIwTGlzdCU1QlR1cGxlJTVCc3RyJTJDJTIwQW55JTVEJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSW5wdXRQYXJhbSglMjJnZW5lcmF0b3IlMjIpJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSW5wdXRQYXJhbSglMjJkaWZmZGlmZl9tYXAlMjIlMkMlMjByZXF1aXJlZCUzRFRydWUpJTJDJTBBLSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMElucHV0UGFyYW0oJTIybGF0ZW50X3RpbWVzdGVwJTIyJTJDJTIwcmVxdWlyZWQlM0RUcnVlJTJDJTIwdHlwZV9oaW50JTNEdG9yY2guVGVuc29yKSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMElucHV0UGFyYW0oJTIydGltZXN0ZXBzJTIyJTJDJTIwdHlwZV9oaW50JTNEdG9yY2guVGVuc29yKSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMElucHV0UGFyYW0oJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUyQyUyMHR5cGVfaGludCUzRGludCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjAlNDBwcm9wZXJ0eSUwQSUyMCUyMCUyMCUyMGRlZiUyMGludGVybWVkaWF0ZV9vdXRwdXRzKHNlbGYpJTIwLSUzRSUyMExpc3QlNUJPdXRwdXRQYXJhbSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME91dHB1dFBhcmFtKCUyMm9yaWdpbmFsX2xhdGVudHMlMjIlMkMlMjB0eXBlX2hpbnQlM0R0b3JjaC5UZW5zb3IpJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwT3V0cHV0UGFyYW0oJTIyZGlmZmRpZmZfbWFza3MlMjIlMkMlMjB0eXBlX2hpbnQlM0R0b3JjaC5UZW5zb3IpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZSUzQSUyMFBpcGVsaW5lU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTIwZXhpc3RpbmclMjBsb2dpYyUyMC4uLiUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBjaGFuZ2UlMjBtYXAlMjBhbmQlMjBjcmVhdGUlMjBtYXNrcyUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpZmZkaWZmX21hcCUyMCUzRCUyMGNvbXBvbmVudHMubWFza19wcm9jZXNzb3IucHJlcHJvY2VzcyhibG9ja19zdGF0ZS5kaWZmZGlmZl9tYXAlMkMlMjBoZWlnaHQlM0RsYXRlbnRfaGVpZ2h0JTJDJTIwd2lkdGglM0RsYXRlbnRfd2lkdGgpJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGhyZXNob2xkcyUyMCUzRCUyMHRvcmNoLmFyYW5nZShibG9ja19zdGF0ZS5udW1faW5mZXJlbmNlX3N0ZXBzJTJDJTIwZHR5cGUlM0RkaWZmZGlmZl9tYXAuZHR5cGUpJTIwJTJGJTIwYmxvY2tfc3RhdGUubnVtX2luZmVyZW5jZV9zdGVwcyUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX3N0YXRlLmRpZmZkaWZmX21hc2tzJTIwJTNEJTIwZGlmZmRpZmZfbWFwJTIwJTNFJTIwKHRocmVzaG9sZHMlMjAlMkIlMjAoYmxvY2tfc3RhdGUuZGVub2lzaW5nX3N0YXJ0JTIwb3IlMjAwKSklMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19zdGF0ZS5vcmlnaW5hbF9sYXRlbnRzJTIwJTNEJTIwYmxvY2tfc3RhdGUubGF0ZW50cw==",highlighted:`class SDXLDiffDiffPrepareLatentsStep(ModularPipelineBlocks):
    @property
    def expected_components(self) -&gt; List[ComponentSpec]:
        return [
            ComponentSpec(&quot;vae&quot;, AutoencoderKL),
            ComponentSpec(&quot;scheduler&quot;, EulerDiscreteScheduler),
<span class="hljs-addition">+           ComponentSpec(&quot;mask_processor&quot;, VaeImageProcessor, config=FrozenDict({&quot;do_normalize&quot;: False, &quot;do_convert_grayscale&quot;: True}))</span>
        ]
    @property
    def inputs(self) -&gt; List[Tuple[str, Any]]:
        return [
            InputParam(&quot;generator&quot;),
<span class="hljs-addition">+           InputParam(&quot;diffdiff_map&quot;, required=True),</span>
<span class="hljs-deletion">-           InputParam(&quot;latent_timestep&quot;, required=True, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;timesteps&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;num_inference_steps&quot;, type_hint=int),</span>
        ]

    @property
    def intermediate_outputs(self) -&gt; List[OutputParam]:
        return [
<span class="hljs-addition">+           OutputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           OutputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]
    def __call__(self, components, state: PipelineState):
        # ... existing logic ...
<span class="hljs-addition">+       # Process change map and create masks</span>
<span class="hljs-addition">+       diffdiff_map = components.mask_processor.preprocess(block_state.diffdiff_map, height=latent_height, width=latent_width)</span>
<span class="hljs-addition">+       thresholds = torch.arange(block_state.num_inference_steps, dtype=diffdiff_map.dtype) / block_state.num_inference_steps</span>
<span class="hljs-addition">+       block_state.diffdiff_masks = diffdiff_map &gt; (thresholds + (block_state.denoising_start or 0))</span>
<span class="hljs-addition">+       block_state.original_latents = block_state.latents</span>`,wrap:!1}}),$=new y({props:{title:"denoise",local:"denoise",headingTag:"h3"}}),E=new u({props:{code:"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",highlighted:`class SDXLDiffDiffLoopBeforeDenoiser(ModularPipelineBlocks):
    @property
    def description(self) -&gt; str:
        return (
            &quot;Step within the denoising loop for differential diffusion that prepare the latent input for the denoiser&quot;
        )

    @property
    def inputs(self) -&gt; List[str]:
        return [
            InputParam(&quot;latents&quot;, required=True, type_hint=torch.Tensor),
<span class="hljs-addition">+           InputParam(&quot;denoising_start&quot;),</span>
<span class="hljs-addition">+           InputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]

    def __call__(self, components, block_state, i, t):
<span class="hljs-addition">+       # Apply differential diffusion logic</span>
<span class="hljs-addition">+       if i == 0 and block_state.denoising_start is None:</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[:1]</span>
<span class="hljs-addition">+       else:</span>
<span class="hljs-addition">+           block_state.mask = block_state.diffdiff_masks[i].unsqueeze(0).unsqueeze(1)</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[i] * block_state.mask + block_state.latents * (1 - block_state.mask)</span>

        # ... rest of existing logic ...`,wrap:!1}}),L=new y({props:{title:"Assembling the blocks",local:"assembling-the-blocks",headingTag:"h2"}}),x=new u({props:{code:"RElGRkRJRkZfQkxPQ0tTJTIwJTNEJTIwSU1BR0UySU1BR0VfQkxPQ0tTLmNvcHkoKSUwQURJRkZESUZGX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEJTIwJTNEJTIwU0RYTERpZmZEaWZmRGVub2lzZVN0ZXAlMEElMEFkZF9ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9CTE9DS1MpJTBBcHJpbnQoZGRfYmxvY2tzKQ==",highlighted:`DIFFDIFF_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffDenoiseStep

dd_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_BLOCKS)
<span class="hljs-built_in">print</span>(dd_blocks)`,wrap:!1}}),q=new y({props:{title:"ModularPipeline",local:"modularpipeline",headingTag:"h2"}}),O=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMENvbXBvbmVudHNNYW5hZ2VyJTBBJTBBY29tcG9uZW50cyUyMCUzRCUyMENvbXBvbmVudE1hbmFnZXIoKSUwQSUwQWRkX3BpcGVsaW5lJTIwJTNEJTIwZGRfYmxvY2tzLmluaXRfcGlwZWxpbmUoJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRfZGVmYXVsdF9jb21wb25lbmV0cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGRfcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> ComponentsManager

components = ComponentManager()

dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, components_manager=components, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_default_componenets(torch_dtype=torch.float16)
dd_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),ee=new y({props:{title:"Adding workflows",local:"adding-workflows",headingTag:"h2"}}),se=new y({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h3"}}),ne=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLmVuY29kZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvSVBBZGFwdGVyU3RlcCUwQSUwQWlwX2FkYXB0ZXJfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9JUEFkYXB0ZXJTdGVwKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.encoders <span class="hljs-keyword">import</span> StableDiffusionXLAutoIPAdapterStep

ip_adapter_block = StableDiffusionXLAutoIPAdapterStep()`,wrap:!1}}),oe=new u({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmlwX2FkYXB0ZXIlMjIlMkMlMjBpcF9hZGFwdGVyX2Jsb2NrJTJDJTIwMCk=",highlighted:'dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, ip_adapter_block, <span class="hljs-number">0</span>)',wrap:!1}}),de=new u({props:{code:"ZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9ibG9ja3MuaW5pdF9waXBlbGluZSglMjJZaVlpWHUlMkZtb2R1bGFyLWRlbW8tYXV0byUyMiUyQyUyMGNvbGxlY3Rpb24lM0QlMjJkaWZmZGlmZiUyMiklMEFkZF9waXBlbGluZS5sb2FkX2NvbXBvbmVudHModG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWRkX3BpcGVsaW5lLmxvYWRlci5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRlci5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYpJTBBZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9waXBlbGluZS50byhkZXZpY2UpJTBBJTBBaXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZkaWZmX29yYW5nZS5qcGVnJTIyKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGMjAyNDAzMjkyMTExMjlfNDAyNDkxMTkzMC5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGT3p6eUdUJTJGdGVzdGluZy1yZXNvdXJjZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZlcmVudGlhbCUyRmdyYWRpZW50X21hc2sucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBncmVlbiUyMHBlYXIlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJibHVycnklMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZCg0MiklMEElMEFpbWFnZSUyMCUzRCUyMGRkX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpcF9hZGFwdGVyX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZGlmZmRpZmZfbWFwJTNEbWFzayUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXQlM0QlMjJpbWFnZXMlMjIlMEEpJTVCMCU1RA==",highlighted:`dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)
dd_pipeline.loader.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
dd_pipeline.loader.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)
dd_pipeline = dd_pipeline.to(device)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_orange.jpeg&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>)

prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

image = dd_pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    ip_adapter_image=ip_adapter_image,
    diffdiff_map=mask,
    image=image,
    output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]`,wrap:!1}}),Me=new y({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),re=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLm1vZHVsYXJfYmxvY2tzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvQ29udHJvbE5ldElucHV0U3RlcCUwQSUwQWNvbnRyb2xfaW5wdXRfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9Db250cm9sTmV0SW5wdXRTdGVwKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.modular_blocks <span class="hljs-keyword">import</span> StableDiffusionXLAutoControlNetInputStep

control_input_block = StableDiffusionXLAutoControlNetInputStep()`,wrap:!1}}),ue=new u({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAoU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlTG9vcFdyYXBwZXIpJTNBJTBBJTIwJTIwJTIwJTIwYmxvY2tfY2xhc3NlcyUyMCUzRCUyMCU1QlNEWExEaWZmRGlmZkxvb3BCZWZvcmVEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldExvb3BEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZUxvb3BBZnRlckRlbm9pc2VyJTVEJTBBJTIwJTIwJTIwJTIwYmxvY2tfbmFtZXMlMjAlM0QlMjAlNUIlMjJiZWZvcmVfZGVub2lzZXIlMjIlMkMlMjAlMjJkZW5vaXNlciUyMiUyQyUyMCUyMmFmdGVyX2Rlbm9pc2VyJTIyJTVEJTBBJTBBY29udHJvbG5ldF9kZW5vaXNlX2Jsb2NrJTIwJTNEJTIwU0RYTERpZmZEaWZmQ29udHJvbE5ldERlbm9pc2VTdGVwKCk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffControlNetDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLControlNetLoopDenoiser, StableDiffusionXLDenoiseLoopAfterDenoiser]
    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]

controlnet_denoise_block = SDXLDiffDiffControlNetDenoiseStep()`,wrap:!1}}),Je=new u({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmNvbnRyb2xuZXRfaW5wdXQlMjIlMkMlMjBjb250cm9sX2lucHV0X2Jsb2NrJTJDJTIwNyklMEFkZF9ibG9ja3Muc3ViX2Jsb2NrcyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBjb250cm9sbmV0X2Rlbm9pc2VfYmxvY2slMEElMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2Jsb2Nrcy5pbml0X3BpcGVsaW5lKCUyMllpWWlYdSUyRm1vZHVsYXItZGVtby1hdXRvJTIyJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9waXBlbGluZS50byhkZXZpY2UpJTBBJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZkaWZmX3RvbWF0b19jYW5ueS5qcGVnJTIyKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGMjAyNDAzMjkyMTExMjlfNDAyNDkxMTkzMC5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGT3p6eUdUJTJGdGVzdGluZy1yZXNvdXJjZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZlcmVudGlhbCUyRmdyYWRpZW50X21hc2sucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBncmVlbiUyMHBlYXIlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJibHVycnklMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZCg0MiklMEElMEFpbWFnZSUyMCUzRCUyMGRkX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBkaWZmZGlmZl9tYXAlM0RtYXNrJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dCUzRCUyMmltYWdlcyUyMiUwQSklNUIwJTVE",highlighted:`dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>, control_input_block, <span class="hljs-number">7</span>)
dd_blocks.sub_blocks[<span class="hljs-string">&quot;denoise&quot;</span>] = controlnet_denoise_block

dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)
dd_pipeline = dd_pipeline.to(device)

control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_tomato_canny.jpeg&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>)

prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

image = dd_pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    control_image=control_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
    diffdiff_map=mask,
    image=image,
    output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]`,wrap:!1}}),Ue=new y({props:{title:"AutoPipelineBlocks",local:"autopipelineblocks",headingTag:"h3"}}),we=new u({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAoQXV0b1BpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMGJsb2NrX2NsYXNzZXMlMjAlM0QlMjAlNUJTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAlMkMlMjBTRFhMRGlmZkRpZmZEZW5vaXNlU3RlcCU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX25hbWVzJTIwJTNEJTIwJTVCJTIyY29udHJvbG5ldF9kZW5vaXNlJTIyJTJDJTIwJTIyZGVub2lzZSUyMiU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX3RyaWdnZXJfaW5wdXRzJTIwJTNEJTIwJTVCJTIyY29udHJvbG5ldF9jb25kJTIyJTJDJTIwTm9uZSU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffAutoDenoiseStep</span>(<span class="hljs-title class_ inherited__">AutoPipelineBlocks</span>):
    block_classes = [SDXLDiffDiffControlNetDenoiseStep, SDXLDiffDiffDenoiseStep]
    block_names = [<span class="hljs-string">&quot;controlnet_denoise&quot;</span>, <span class="hljs-string">&quot;denoise&quot;</span>]
    block_trigger_inputs = [<span class="hljs-string">&quot;controlnet_cond&quot;</span>, <span class="hljs-literal">None</span>]`,wrap:!1}}),he=new u({props:{code:"RElGRkRJRkZfQVVUT19CTE9DS1MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MuY29weSgpJTBBRElGRkRJRkZfQVVUT19CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUy5pbnNlcnQoJTIyaXBfYWRhcHRlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQXV0b0lQQWRhcHRlclN0ZXAlMkMlMjAwKSUwQURJRkZESUZGX0FVVE9fQkxPQ0tTLmluc2VydCglMjJjb250cm9sbmV0X2lucHV0JTIyJTJDU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0QXV0b0lucHV0JTJDJTIwNyk=",highlighted:`DIFFDIFF_AUTO_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffAutoDenoiseStep
DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, StableDiffusionXLAutoIPAdapterStep, <span class="hljs-number">0</span>)
DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>,StableDiffusionXLControlNetAutoInput, <span class="hljs-number">7</span>)`,wrap:!1}}),je=new u({props:{code:"ZGRfYXV0b19ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9BVVRPX0JMT0NLUyklMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2F1dG9fYmxvY2tzLmluaXRfcGlwZWxpbmUoJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMkMlMjBjb2xsZWN0aW9uJTNEJTIyZGlmZmRpZmYlMjIpJTBBZGRfcGlwZWxpbmUubG9hZF9jb21wb25lbnRzKHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNik=",highlighted:`dd_auto_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_AUTO_BLOCKS)
dd_pipeline = dd_auto_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)`,wrap:!1}}),Ce=new y({props:{title:"Share",local:"share",headingTag:"h2"}}),Re=new u({props:{code:"ZGRfcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMllpWWlYdSUyRnRlc3RfbW9kdWxhcl9kb2MlMjIlMkMlMjBwdXNoX3RvX2h1YiUzRFRydWUp",highlighted:'dd_pipeline.save_pretrained(<span class="hljs-string">&quot;YiYiXu/test_modular_doc&quot;</span>, push_to_hub=<span class="hljs-literal">True</span>)',wrap:!1}}),_e=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwTW9kdWxhclBpcGVsaW5lJTJDJTIwQ29tcG9uZW50c01hbmFnZXIlMEElMEFjb21wb25lbnRzJTIwJTNEJTIwQ29tcG9uZW50c01hbmFnZXIoKSUwQSUwQWRpZmZkaWZmX3BpcGVsaW5lJTIwJTNEJTIwTW9kdWxhclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJZaVlpWHUlMkZtb2R1bGFyLWRpZmZkaWZmLTA3MDQlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRpZmZkaWZmX3BpcGVsaW5lLmxvYWRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> ModularPipeline, ComponentsManager

components = ComponentsManager()

diffdiff_pipeline = ModularPipeline.from_pretrained(<span class="hljs-string">&quot;YiYiXu/modular-diffdiff-0704&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, components_manager=components, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
diffdiff_pipeline.load_components(torch_dtype=torch.float16)`,wrap:!1}}),We=new Et({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/quickstart.md"}}),{c(){J=a("meta"),ge=i(),Xe=a("p"),Ve=i(),d(U.$$.fragment),Se=i(),T=a("p"),T.innerHTML=Kl,Fe=i(),b=a("p"),b.innerHTML=Ol,ve=i(),d(w.$$.fragment),Ye=i(),Z=a("p"),Z.innerHTML=et,$e=i(),h=a("ul"),h.innerHTML=lt,Ne=i(),I=a("p"),I.innerHTML=tt,Qe=i(),d(j.$$.fragment),Ee=i(),d(C.$$.fragment),Le=i(),G=a("p"),G.innerHTML=st,De=i(),R=a("ul"),R.innerHTML=it,Ae=i(),d(k.$$.fragment),ze=i(),_=a("p"),_.innerHTML=nt,He=i(),W=a("p"),W.innerHTML=at,xe=i(),X=a("p"),X.innerHTML=ot,qe=i(),d(B.$$.fragment),Pe=i(),g=a("p"),g.innerHTML=pt,Ke=i(),d(V.$$.fragment),Oe=i(),d(S.$$.fragment),el=i(),F=a("p"),F.innerHTML=dt,ll=i(),v=a("ul"),v.innerHTML=Mt,tl=i(),d(Y.$$.fragment),sl=i(),d($.$$.fragment),il=i(),N=a("p"),N.innerHTML=ct,nl=i(),Q=a("ul"),Q.innerHTML=rt,al=i(),d(E.$$.fragment),ol=i(),d(L.$$.fragment),pl=i(),D=a("p"),D.innerHTML=ft,dl=i(),A=a("p"),A.innerHTML=mt,Ml=i(),z=a("p"),z.innerHTML=ut,cl=i(),H=a("p"),H.innerHTML=yt,rl=i(),d(x.$$.fragment),fl=i(),d(q.$$.fragment),ml=i(),P=a("p"),P.innerHTML=Jt,ul=i(),K=a("p"),K.innerHTML=Ut,yl=i(),d(O.$$.fragment),Jl=i(),d(ee.$$.fragment),Ul=i(),le=a("p"),le.innerHTML=Tt,Tl=i(),te=a("p"),te.textContent=bt,bl=i(),d(se.$$.fragment),wl=i(),ie=a("p"),ie.textContent=wt,Zl=i(),d(ne.$$.fragment),hl=i(),ae=a("p"),ae.innerHTML=Zt,Il=i(),d(oe.$$.fragment),jl=i(),pe=a("p"),pe.innerHTML=ht,Cl=i(),d(de.$$.fragment),Gl=i(),d(Me.$$.fragment),Rl=i(),ce=a("p"),ce.textContent=It,kl=i(),d(re.$$.fragment),_l=i(),fe=a("p"),fe.innerHTML=jt,Wl=i(),me=a("p"),me.innerHTML=Ct,Xl=i(),d(ue.$$.fragment),Bl=i(),ye=a("p"),ye.innerHTML=Gt,gl=i(),d(Je.$$.fragment),Vl=i(),d(Ue.$$.fragment),Sl=i(),Te=a("p"),Te.innerHTML=Rt,Fl=i(),be=a("p"),be.innerHTML=kt,vl=i(),d(we.$$.fragment),Yl=i(),Ze=a("p"),Ze.innerHTML=_t,$l=i(),d(he.$$.fragment),Nl=i(),Ie=a("p"),Ie.innerHTML=Wt,Ql=i(),d(je.$$.fragment),El=i(),d(Ce.$$.fragment),Ll=i(),Ge=a("p"),Ge.innerHTML=Xt,Dl=i(),d(Re.$$.fragment),Al=i(),ke=a("p"),ke.innerHTML=Bt,zl=i(),d(_e.$$.fragment),Hl=i(),d(We.$$.fragment),xl=i(),Be=a("p"),this.h()},l(e){const l=Nt("svelte-u9bgzb",document.head);J=o(l,"META",{name:!0,content:!0}),l.forEach(t),ge=n(e),Xe=o(e,"P",{}),gt(Xe).forEach(t),Ve=n(e),M(U.$$.fragment,e),Se=n(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-nfr4qm"&&(T.innerHTML=Kl),Fe=n(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-14bi1ah"&&(b.innerHTML=Ol),ve=n(e),M(w.$$.fragment,e),Ye=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-lxy6vq"&&(Z.innerHTML=et),$e=n(e),h=o(e,"UL",{"data-svelte-h":!0}),p(h)!=="svelte-2w7id0"&&(h.innerHTML=lt),Ne=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-7tdtn5"&&(I.innerHTML=tt),Qe=n(e),M(j.$$.fragment,e),Ee=n(e),M(C.$$.fragment,e),Le=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1hrx77z"&&(G.innerHTML=st),De=n(e),R=o(e,"UL",{"data-svelte-h":!0}),p(R)!=="svelte-hgqjo0"&&(R.innerHTML=it),Ae=n(e),M(k.$$.fragment,e),ze=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-16tz7j4"&&(_.innerHTML=nt),He=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-pmw538"&&(W.innerHTML=at),xe=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1qke84t"&&(X.innerHTML=ot),qe=n(e),M(B.$$.fragment,e),Pe=n(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-g4vtz4"&&(g.innerHTML=pt),Ke=n(e),M(V.$$.fragment,e),Oe=n(e),M(S.$$.fragment,e),el=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1hnij81"&&(F.innerHTML=dt),ll=n(e),v=o(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-wu0sp3"&&(v.innerHTML=Mt),tl=n(e),M(Y.$$.fragment,e),sl=n(e),M($.$$.fragment,e),il=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1lriej4"&&(N.innerHTML=ct),nl=n(e),Q=o(e,"UL",{"data-svelte-h":!0}),p(Q)!=="svelte-k274di"&&(Q.innerHTML=rt),al=n(e),M(E.$$.fragment,e),ol=n(e),M(L.$$.fragment,e),pl=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-rx5cas"&&(D.innerHTML=ft),dl=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-bcrjsa"&&(A.innerHTML=mt),Ml=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1qdwaia"&&(z.innerHTML=ut),cl=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-c6bj14"&&(H.innerHTML=yt),rl=n(e),M(x.$$.fragment,e),fl=n(e),M(q.$$.fragment,e),ml=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1yr6nun"&&(P.innerHTML=Jt),ul=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-wfwts7"&&(K.innerHTML=Ut),yl=n(e),M(O.$$.fragment,e),Jl=n(e),M(ee.$$.fragment,e),Ul=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-rh0ns8"&&(le.innerHTML=Tt),Tl=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-denp3n"&&(te.textContent=bt),bl=n(e),M(se.$$.fragment,e),wl=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1mrw5mx"&&(ie.textContent=wt),Zl=n(e),M(ne.$$.fragment,e),hl=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1lami1t"&&(ae.innerHTML=Zt),Il=n(e),M(oe.$$.fragment,e),jl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1wpybzc"&&(pe.innerHTML=ht),Cl=n(e),M(de.$$.fragment,e),Gl=n(e),M(Me.$$.fragment,e),Rl=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-wr3jw6"&&(ce.textContent=It),kl=n(e),M(re.$$.fragment,e),_l=n(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-czmnsx"&&(fe.innerHTML=jt),Wl=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-mbulqa"&&(me.innerHTML=Ct),Xl=n(e),M(ue.$$.fragment,e),Bl=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-19e8srk"&&(ye.innerHTML=Gt),gl=n(e),M(Je.$$.fragment,e),Vl=n(e),M(Ue.$$.fragment,e),Sl=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-12xk6i1"&&(Te.innerHTML=Rt),Fl=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-rehsh7"&&(be.innerHTML=kt),vl=n(e),M(we.$$.fragment,e),Yl=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-o3hbbv"&&(Ze.innerHTML=_t),$l=n(e),M(he.$$.fragment,e),Nl=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-88pyw4"&&(Ie.innerHTML=Wt),Ql=n(e),M(je.$$.fragment,e),El=n(e),M(Ce.$$.fragment,e),Ll=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-8sp303"&&(Ge.innerHTML=Xt),Dl=n(e),M(Re.$$.fragment,e),Al=n(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1ceh4ne"&&(ke.innerHTML=Bt),zl=n(e),M(_e.$$.fragment,e),Hl=n(e),M(We.$$.fragment,e),xl=n(e),Be=o(e,"P",{}),gt(Be).forEach(t),this.h()},h(){Vt(J,"name","hf:doc:metadata"),Vt(J,"content",Dt)},m(e,l){Qt(document.head,J),s(e,ge,l),s(e,Xe,l),s(e,Ve,l),c(U,e,l),s(e,Se,l),s(e,T,l),s(e,Fe,l),s(e,b,l),s(e,ve,l),c(w,e,l),s(e,Ye,l),s(e,Z,l),s(e,$e,l),s(e,h,l),s(e,Ne,l),s(e,I,l),s(e,Qe,l),c(j,e,l),s(e,Ee,l),c(C,e,l),s(e,Le,l),s(e,G,l),s(e,De,l),s(e,R,l),s(e,Ae,l),c(k,e,l),s(e,ze,l),s(e,_,l),s(e,He,l),s(e,W,l),s(e,xe,l),s(e,X,l),s(e,qe,l),c(B,e,l),s(e,Pe,l),s(e,g,l),s(e,Ke,l),c(V,e,l),s(e,Oe,l),c(S,e,l),s(e,el,l),s(e,F,l),s(e,ll,l),s(e,v,l),s(e,tl,l),c(Y,e,l),s(e,sl,l),c($,e,l),s(e,il,l),s(e,N,l),s(e,nl,l),s(e,Q,l),s(e,al,l),c(E,e,l),s(e,ol,l),c(L,e,l),s(e,pl,l),s(e,D,l),s(e,dl,l),s(e,A,l),s(e,Ml,l),s(e,z,l),s(e,cl,l),s(e,H,l),s(e,rl,l),c(x,e,l),s(e,fl,l),c(q,e,l),s(e,ml,l),s(e,P,l),s(e,ul,l),s(e,K,l),s(e,yl,l),c(O,e,l),s(e,Jl,l),c(ee,e,l),s(e,Ul,l),s(e,le,l),s(e,Tl,l),s(e,te,l),s(e,bl,l),c(se,e,l),s(e,wl,l),s(e,ie,l),s(e,Zl,l),c(ne,e,l),s(e,hl,l),s(e,ae,l),s(e,Il,l),c(oe,e,l),s(e,jl,l),s(e,pe,l),s(e,Cl,l),c(de,e,l),s(e,Gl,l),c(Me,e,l),s(e,Rl,l),s(e,ce,l),s(e,kl,l),c(re,e,l),s(e,_l,l),s(e,fe,l),s(e,Wl,l),s(e,me,l),s(e,Xl,l),c(ue,e,l),s(e,Bl,l),s(e,ye,l),s(e,gl,l),c(Je,e,l),s(e,Vl,l),c(Ue,e,l),s(e,Sl,l),s(e,Te,l),s(e,Fl,l),s(e,be,l),s(e,vl,l),c(we,e,l),s(e,Yl,l),s(e,Ze,l),s(e,$l,l),c(he,e,l),s(e,Nl,l),s(e,Ie,l),s(e,Ql,l),c(je,e,l),s(e,El,l),c(Ce,e,l),s(e,Ll,l),s(e,Ge,l),s(e,Dl,l),c(Re,e,l),s(e,Al,l),s(e,ke,l),s(e,zl,l),c(_e,e,l),s(e,Hl,l),c(We,e,l),s(e,xl,l),s(e,Be,l),ql=!0},p:Ft,i(e){ql||(r(U.$$.fragment,e),r(w.$$.fragment,e),r(j.$$.fragment,e),r(C.$$.fragment,e),r(k.$$.fragment,e),r(B.$$.fragment,e),r(V.$$.fragment,e),r(S.$$.fragment,e),r(Y.$$.fragment,e),r($.$$.fragment,e),r(E.$$.fragment,e),r(L.$$.fragment,e),r(x.$$.fragment,e),r(q.$$.fragment,e),r(O.$$.fragment,e),r(ee.$$.fragment,e),r(se.$$.fragment,e),r(ne.$$.fragment,e),r(oe.$$.fragment,e),r(de.$$.fragment,e),r(Me.$$.fragment,e),r(re.$$.fragment,e),r(ue.$$.fragment,e),r(Je.$$.fragment,e),r(Ue.$$.fragment,e),r(we.$$.fragment,e),r(he.$$.fragment,e),r(je.$$.fragment,e),r(Ce.$$.fragment,e),r(Re.$$.fragment,e),r(_e.$$.fragment,e),r(We.$$.fragment,e),ql=!0)},o(e){f(U.$$.fragment,e),f(w.$$.fragment,e),f(j.$$.fragment,e),f(C.$$.fragment,e),f(k.$$.fragment,e),f(B.$$.fragment,e),f(V.$$.fragment,e),f(S.$$.fragment,e),f(Y.$$.fragment,e),f($.$$.fragment,e),f(E.$$.fragment,e),f(L.$$.fragment,e),f(x.$$.fragment,e),f(q.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(de.$$.fragment,e),f(Me.$$.fragment,e),f(re.$$.fragment,e),f(ue.$$.fragment,e),f(Je.$$.fragment,e),f(Ue.$$.fragment,e),f(we.$$.fragment,e),f(he.$$.fragment,e),f(je.$$.fragment,e),f(Ce.$$.fragment,e),f(Re.$$.fragment,e),f(_e.$$.fragment,e),f(We.$$.fragment,e),ql=!1},d(e){e&&(t(ge),t(Xe),t(Ve),t(Se),t(T),t(Fe),t(b),t(ve),t(Ye),t(Z),t($e),t(h),t(Ne),t(I),t(Qe),t(Ee),t(Le),t(G),t(De),t(R),t(Ae),t(ze),t(_),t(He),t(W),t(xe),t(X),t(qe),t(Pe),t(g),t(Ke),t(Oe),t(el),t(F),t(ll),t(v),t(tl),t(sl),t(il),t(N),t(nl),t(Q),t(al),t(ol),t(pl),t(D),t(dl),t(A),t(Ml),t(z),t(cl),t(H),t(rl),t(fl),t(ml),t(P),t(ul),t(K),t(yl),t(Jl),t(Ul),t(le),t(Tl),t(te),t(bl),t(wl),t(ie),t(Zl),t(hl),t(ae),t(Il),t(jl),t(pe),t(Cl),t(Gl),t(Rl),t(ce),t(kl),t(_l),t(fe),t(Wl),t(me),t(Xl),t(Bl),t(ye),t(gl),t(Vl),t(Sl),t(Te),t(Fl),t(be),t(vl),t(Yl),t(Ze),t($l),t(Nl),t(Ie),t(Ql),t(El),t(Ll),t(Ge),t(Dl),t(Al),t(ke),t(zl),t(Hl),t(xl),t(Be)),t(J),m(U,e),m(w,e),m(j,e),m(C,e),m(k,e),m(B,e),m(V,e),m(S,e),m(Y,e),m($,e),m(E,e),m(L,e),m(x,e),m(q,e),m(O,e),m(ee,e),m(se,e),m(ne,e),m(oe,e),m(de,e),m(Me,e),m(re,e),m(ue,e),m(Je,e),m(Ue,e),m(we,e),m(he,e),m(je,e),m(Ce,e),m(Re,e),m(_e,e),m(We,e)}}}const Dt='{"title":"Quickstart","local":"quickstart","sections":[{"title":"ModularPipelineBlocks","local":"modularpipelineblocks","sections":[],"depth":2},{"title":"Pipeline and block states","local":"pipeline-and-block-states","sections":[],"depth":2},{"title":"Customizing blocks","local":"customizing-blocks","sections":[{"title":"prepare_latents","local":"preparelatents","sections":[],"depth":3},{"title":"denoise","local":"denoise","sections":[],"depth":3}],"depth":2},{"title":"Assembling the blocks","local":"assembling-the-blocks","sections":[],"depth":2},{"title":"ModularPipeline","local":"modularpipeline","sections":[],"depth":2},{"title":"Adding workflows","local":"adding-workflows","sections":[{"title":"IP-Adapter","local":"ip-adapter","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3},{"title":"AutoPipelineBlocks","local":"autopipelineblocks","sections":[],"depth":3}],"depth":2},{"title":"Share","local":"share","sections":[],"depth":2}],"depth":1}';function At(Pl){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends Yt{constructor(J){super(),$t(this,J,At,Lt,St,{})}}export{Pt as component};
