import{s as ul,o as dl,n as St}from"../chunks/scheduler.6062bdaf.js";import{S as ml,i as yl,g as s,s as i,r as u,A as vl,h as l,f as t,c as r,j as f,u as d,x as p,k as o,y as c,a,v as m,d as y,t as v,w as b}from"../chunks/index.4bca734e.js";import{T as Vt}from"../chunks/Tip.b9ac1f03.js";import{I as $}from"../chunks/IconCopyLink.68a13644.js";import{C}from"../chunks/CodeBlock.f213e6a5.js";function bl(M){let h,w=`<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is a Python client making HTTP calls to our APIs. If you want to make the HTTP calls directly using
your preferred tool (curl, postman,…), please refer to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>
or to the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> documentation pages.`,g,_,H=`For web development, a <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS client</a> has been released.
If you are interested in game development, you might have a look at our <a href="https://github.com/huggingface/unity-api" rel="nofollow">C# project</a>.`;return{c(){h=s("p"),h.innerHTML=w,g=i(),_=s("p"),_.innerHTML=H},l(j){h=l(j,"P",{"data-svelte-h":!0}),p(h)!=="svelte-mhdwu1"&&(h.innerHTML=w),g=r(j),_=l(j,"P",{"data-svelte-h":!0}),p(_)!=="svelte-22w7rm"&&(_.innerHTML=H)},m(j,ce){a(j,h,ce),a(j,g,ce),a(j,_,ce)},p:St,d(j){j&&(t(h),t(g),t(_))}}}function _l(M){let h,w=`The API is designed to be simple. Not all parameters and options are available or described for the end user. Check out
<a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">this page</a> if you are interested in learning more about
all the parameters available for each task.`;return{c(){h=s("p"),h.innerHTML=w},l(g){h=l(g,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1o4uc5e"&&(h.innerHTML=w)},m(g,_){a(g,h,_)},p:St,d(g){g&&t(h)}}}function wl(M){let h,w=`There are more than 200k models on the Hugging Face Hub! Each task in the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> comes with a recommended
model. Be aware that the HF recommendation can change over time without prior notice. Therefore it is best to explicitly
set a model once you are decided. Also, in most cases you’ll be interested in finding a model specific to <em>your</em> needs.
Visit the <a href="https://huggingface.co/models" rel="nofollow">Models</a> page on the Hub to explore your possibilities.`;return{c(){h=s("p"),h.innerHTML=w},l(g){h=l(g,"P",{"data-svelte-h":!0}),p(h)!=="svelte-2lg0y8"&&(h.innerHTML=w)},m(g,_){a(g,h,_)},p:St,d(g){g&&t(h)}}}function jl(M){let h,w=`Authentication is NOT mandatory when using the Inference API. However, authenticated users get a higher free-tier to
play with the service. Token is also mandatory if you want to run inference on your private models or on private
endpoints.`;return{c(){h=s("p"),h.textContent=w},l(g){h=l(g,"P",{"data-svelte-h":!0}),p(h)!=="svelte-7vtkgf"&&(h.textContent=w)},m(g,_){a(g,h,_)},p:St,d(g){g&&t(h)}}}function Cl(M){let h,w=`Check out the <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> page to learn more about each task, how to use them, and the
most popular models for each task.`;return{c(){h=s("p"),h.innerHTML=w},l(g){h=l(g,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1u4hr1j"&&(h.innerHTML=w)},m(g,_){a(g,h,_)},p:St,d(g){g&&t(h)}}}function $l(M){let h,w=`This is the recommended way to adapt your code to <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. It lets you benefit from the task-specific
methods like <code>feature_extraction</code>.`;return{c(){h=s("p"),h.innerHTML=w},l(g){h=l(g,"P",{"data-svelte-h":!0}),p(h)!=="svelte-jq6yid"&&(h.innerHTML=w)},m(g,_){a(g,h,_)},p:St,d(g){g&&t(h)}}}function Ml(M){let h,w,g,_,H,j,ce,_t,Xa="Run Inference on servers",an,he,Qa=`Inference is the process of using a trained model to make predictions on new data. As this process can be compute-intensive,
running on a dedicated server can be an interesting option. The <code>huggingface_hub</code> library provides an easy way to call a
service that runs inference for hosted models. There are several services you can connect to:`,sn,pe,Fa=`<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>: a service that allows you to run accelerated inference
on Hugging Face’s infrastructure for free. This service is a fast way to get started, test different models, and
prototype AI products.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production.
Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li>`,ln,fe,Ka=`These services can be called with the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. It acts as a replacement for the legacy
<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client, adding specific support for tasks and handling inference on both
<a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.
Learn how to migrate to the new client in the <a href="#legacy-inferenceapi-client">Legacy InferenceAPI client</a> section.`,rn,B,on,k,z,Et,ge,Wa,wt,Da="Getting started",cn,ue,Oa="Let’s get started with a text-to-image task:",hn,de,pn,me,es=`We initialized an <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> with the default parameters. The only thing you need to know is the <a href="#supported-tasks">task</a> you want
to perform. By default, the client will connect to the Inference API and select a model to complete the task. In our
example, we generated an image from a text prompt. The returned value is a <code>PIL.Image</code> object that can be saved to a
file.`,fn,R,gn,U,Y,qt,ye,Ga,jt,ts="Using a specific model",un,ve,ns="What if you want to use a specific model? You can specify it either as a parameter or directly at an instance level:",dn,be,mn,L,yn,I,P,At,_e,Na,Ct,as="Using a specific URL",vn,we,ss=`The examples we saw above use the free-hosted Inference API. This proves to be very useful for prototyping
and testing things quickly. Once you’re ready to deploy your model to production, you’ll need to use a dedicated infrastructure.
That’s where <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> comes into play. It allows you to deploy
any model and expose it as a private API. Once deployed, you’ll get a URL that you can connect to using exactly the same
code as before, changing only the <code>model</code> parameter:`,bn,je,_n,Z,X,Ht,Ce,Va,$t,ls="Authentication",wn,$e,is=`Calls made with the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> can be authenticated using a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a>.
By default, it will use the token saved on your machine if you are logged in (check out
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#login" rel="nofollow">how to login</a>). If you are not logged in, you can pass
your token as an instance parameter:`,jn,Me,Cn,Q,$n,x,F,Bt,ke,Sa,Mt,rs="Supported tasks",Mn,Ue,os=`<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>’s goal is to provide the easiest interface to run inference on Hugging Face models. It
has a simple API that supports the most common tasks. Here is a list of the currently supported tasks:`,kn,Ie,cs='<thead><tr><th>Domain</th> <th>Task</th> <th>Supported</th> <th>Documentation</th></tr></thead> <tbody><tr><td>Audio</td> <td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_classification">audio_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.automatic_speech_recognition">automatic_speech_recognition()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_speech">text_to_speech()</a></td></tr> <tr><td>Computer Vision</td> <td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_classification">image_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_segmentation">image_segmentation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_image">image_to_image()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_text">image_to_text()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.object_detection">object_detection()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot-Image-Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_image_classification">zero_shot_image_classification()</a></td></tr> <tr><td>Multimodal</td> <td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Documentation Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.document_question_answering">document_question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.visual_question_answering">visual_question_answering()</a></td></tr> <tr><td>NLP</td> <td><a href="https://huggingface.co/tasks/conversational" rel="nofollow">Conversational</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">conversational()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.feature_extraction">feature_extraction()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill Mask</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.fill_mask">fill_mask()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.question_answering">question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.sentence_similarity">sentence_similarity()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.summarization">summarization()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.table_question_answering">table_question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_classification">text_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-generation" rel="nofollow">Text Generation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation">text_generation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.token_classification">token_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.translation">translation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero Shot Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_classification">zero_shot_classification()</a></td></tr> <tr><td>Tabular</td> <td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_classification">tabular_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_regression">tabular_regression()</a></td></tr></tbody>',Un,K,In,T,D,zt,Ze,Ea,kt,hs="Custom requests",Zn,xe,ps=`However, it is not always possible to cover all use cases. For custom requests, the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> method
gives you the flexibility to send any request to the Inference API. For example, you can specify how to parse the inputs
and outputs. In the example below, the generated image is returned as raw bytes instead of parsing it as a <code>PIL Image</code>.
This can be helpful if you don’t have <code>Pillow</code> installed in your setup and just care about the binary content of the
image. <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> is also useful to handle tasks that are not yet officially supported.`,xn,Te,Tn,J,O,Rt,Je,qa,Ut,fs="Async client",Jn,We,gs=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>. You can either install <code>aiohttp</code>
directly or use the <code>[inference]</code> extra:`,Wn,Ge,Gn,Ne,us=`After installation all async API endpoints are available via <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>. Its initialization and APIs are
strictly the same as the sync-only version.`,Nn,Ve,Vn,Se,ds='For more information about the <code>asyncio</code> module, please refer to the <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">official documentation</a>.',Sn,W,ee,Yt,Ee,Aa,It,ms="Advanced tips",En,qe,ys='In the above section, we saw the main aspects of <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. Let’s dive into some more advanced tips.',qn,G,te,Lt,Ae,Ha,Zt,vs="Timeout",An,He,bs="When doing inference, there are two main causes for a timeout:",Hn,Be,_s="<li>The inference process takes a long time to complete.</li> <li>The model is not available, for example when Inference API is loading it for the first time.</li>",Bn,ze,ws=`<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> has a global <code>timeout</code> parameter to handle those two aspects. By default, it is set to <code>None</code>,
meaning that the client will wait indefinitely for the inference to complete. If you want more control in your workflow,
you can set it to a specific value in seconds. If the timeout delay expires, an <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError">InferenceTimeoutError</a> is raised.
You can catch it and handle it in your code:`,zn,Re,Rn,N,ne,Pt,Ye,Ba,xt,js="Binary inputs",Yn,Le,Cs=`Some tasks require binary inputs, for example, when dealing with images or audio files. In this case, <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
tries to be as permissive as possible and accept different types:`,Ln,Pe,$s=`<li>raw <code>bytes</code></li> <li>a file-like object, opened as binary (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>a path (<code>str</code> or <code>Path</code>) pointing to a local file</li> <li>a URL (<code>str</code>) pointing to a remote file (e.g. <code>https://...</code>). In this case, the file will be downloaded locally before
sending it to the Inference API.</li>`,Pn,Xe,Xn,V,ae,Xt,Qe,za,Tt,Ms="Legacy InferenceAPI client",Qn,Fe,ks=`<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> acts as a replacement for the legacy <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client. It adds specific support for tasks and
handles inference on both <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.`,Fn,Ke,Us='Here is a short guide to help you migrate from <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> to <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.',Kn,S,se,Qt,De,Ra,Jt,Is="Initialization",Dn,Oe,Zs="Change from",On,et,ea,tt,xs="to",ta,nt,na,E,le,Ft,at,Ya,Wt,Ts="Run on a specific task",aa,st,Js="Change from",sa,lt,la,it,Ws="to",ia,rt,ra,ie,oa,q,re,Kt,ot,La,Gt,Gs="Run custom request",ca,ct,Ns="Change from",ha,ht,pa,pt,Vs="to",fa,ft,ga,A,oe,Dt,gt,Pa,Nt,Ss="Run with parameters",ua,ut,Es="Change from",da,dt,ma,mt,qs="to",ya,yt,va;return j=new $({}),B=new Vt({props:{$$slots:{default:[bl]},$$scope:{ctx:M}}}),ge=new $({}),de=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`}}),R=new Vt({props:{warning:!0,$$slots:{default:[_l]},$$scope:{ctx:M}}}),ye=new $({}),be=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4pJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Initialize client for a specific model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Or use a generic client but pass your model as an argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)`}}),L=new Vt({props:{$$slots:{default:[wl]},$$scope:{ctx:M}}}),_e=new $({}),je=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># or</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`}}),Ce=new $({}),Me=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0b2tlbiUzRCUyMmhmXyoqKiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(token=<span class="hljs-string">&quot;hf_***&quot;</span>)`}}),Q=new Vt({props:{$$slots:{default:[jl]},$$scope:{ctx:M}}}),ke=new $({}),K=new Vt({props:{$$slots:{default:[Cl]},$$scope:{ctx:M}}}),Ze=new $({}),Te=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTdEJTJDJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyKSUwQXJlc3BvbnNlLmNvbnRlbnQlMjAlMjMlMjByYXclMjBieXRlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>}, model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes</span>
<span class="hljs-string">b&#x27;...&#x27;</span>`}}),Je=new $({}),Ge=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`}}),Ve=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Code must be run in a asyncio concurrent context.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`}}),Ee=new $({}),Ae=new $({}),Re=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`}}),Ye=new $({}),Xe=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`}}),Qe=new $({}),De=new $({}),et=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjB0b2tlbiUzREFQSV9UT0tFTik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`}}),nt=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwdG9rZW4lM0RBUElfVE9LRU4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient(model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`}}),at=new $({}),lt=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIycGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjElMjIlMkMlMjB0YXNrJTNEJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyKSUwQWluZmVyZW5jZSguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(...)`}}),rt=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5mZXJlbmNlLmZlYXR1cmVfZXh0cmFjdGlvbiguLi4lMkMlMjBtb2RlbCUzRCUyMnBhcmFwaHJhc2UteGxtLXItbXVsdGlsaW5ndWFsLXYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inference.feature_extraction(..., model=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>)`}}),ie=new Vt({props:{$$slots:{default:[$l]},$$scope:{ctx:M}}}),ot=new $({}),ht=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBaW5mZXJlbmNlKGlucHV0cyUzRCUyMlRoZSUyMGdvYWwlMjBvZiUyMGxpZmUlMjBpcyUyMCU1Qk1BU0slNUQuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`}}),ft=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlN0QlMkMlMjBtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQXJlc3BvbnNlLmpzb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>}, model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`}}),gt=new $({}),dt=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIydHlwZWZvcm0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQWlucHV0cyUyMCUzRCUyMCUyMkhpJTJDJTIwSSUyMHJlY2VudGx5JTIwYm91Z2h0JTIwYSUyMGRldmljZSUyMGZyb20lMjB5b3VyJTIwY29tcGFueSUyMGJ1dCUyMGl0JTIwaXMlMjBub3QlMjB3b3JraW5nJTIwYXMlMjBhZHZlcnRpc2VkJTIwYW5kJTIwSSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwZ2V0JTIwcmVpbWJ1cnNlZCElMjIlMEFwYXJhbXMlMjAlM0QlMjAlN0IlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlN0QlMEFpbmZlcmVuY2UoaW5wdXRzJTJDJTIwcGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`}}),yt=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5wdXRzJTIwJTNEJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUwQXBhcmFtcyUyMCUzRCUyMCU3QiUyMmNhbmRpZGF0ZV9sYWJlbHMlMjIlM0ElNUIlMjJyZWZ1bmQlMjIlMkMlMjAlMjJsZWdhbCUyMiUyQyUyMCUyMmZhcSUyMiU1RCU3RCUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGlucHV0cyUyQyUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjBwYXJhbXMlN0QlMkMlMjBtb2RlbCUzRCUyMnR5cGVmb3JtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtbW5saSUyMiklMEFyZXNwb25zZS5qc29uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: inputs, <span class="hljs-string">&quot;parameters&quot;</span>: params}, model=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`}}),{c(){h=s("meta"),w=i(),g=s("h1"),_=s("a"),H=s("span"),u(j.$$.fragment),ce=i(),_t=s("span"),_t.textContent=Xa,an=i(),he=s("p"),he.innerHTML=Qa,sn=i(),pe=s("ul"),pe.innerHTML=Fa,ln=i(),fe=s("p"),fe.innerHTML=Ka,rn=i(),u(B.$$.fragment),on=i(),k=s("h2"),z=s("a"),Et=s("span"),u(ge.$$.fragment),Wa=i(),wt=s("span"),wt.textContent=Da,cn=i(),ue=s("p"),ue.textContent=Oa,hn=i(),u(de.$$.fragment),pn=i(),me=s("p"),me.innerHTML=es,fn=i(),u(R.$$.fragment),gn=i(),U=s("h3"),Y=s("a"),qt=s("span"),u(ye.$$.fragment),Ga=i(),jt=s("span"),jt.textContent=ts,un=i(),ve=s("p"),ve.textContent=ns,dn=i(),u(be.$$.fragment),mn=i(),u(L.$$.fragment),yn=i(),I=s("h3"),P=s("a"),At=s("span"),u(_e.$$.fragment),Na=i(),Ct=s("span"),Ct.textContent=as,vn=i(),we=s("p"),we.innerHTML=ss,bn=i(),u(je.$$.fragment),_n=i(),Z=s("h3"),X=s("a"),Ht=s("span"),u(Ce.$$.fragment),Va=i(),$t=s("span"),$t.textContent=ls,wn=i(),$e=s("p"),$e.innerHTML=is,jn=i(),u(Me.$$.fragment),Cn=i(),u(Q.$$.fragment),$n=i(),x=s("h2"),F=s("a"),Bt=s("span"),u(ke.$$.fragment),Sa=i(),Mt=s("span"),Mt.textContent=rs,Mn=i(),Ue=s("p"),Ue.innerHTML=os,kn=i(),Ie=s("table"),Ie.innerHTML=cs,Un=i(),u(K.$$.fragment),In=i(),T=s("h2"),D=s("a"),zt=s("span"),u(Ze.$$.fragment),Ea=i(),kt=s("span"),kt.textContent=hs,Zn=i(),xe=s("p"),xe.innerHTML=ps,xn=i(),u(Te.$$.fragment),Tn=i(),J=s("h2"),O=s("a"),Rt=s("span"),u(Je.$$.fragment),qa=i(),Ut=s("span"),Ut.textContent=fs,Jn=i(),We=s("p"),We.innerHTML=gs,Wn=i(),u(Ge.$$.fragment),Gn=i(),Ne=s("p"),Ne.innerHTML=us,Nn=i(),u(Ve.$$.fragment),Vn=i(),Se=s("p"),Se.innerHTML=ds,Sn=i(),W=s("h2"),ee=s("a"),Yt=s("span"),u(Ee.$$.fragment),Aa=i(),It=s("span"),It.textContent=ms,En=i(),qe=s("p"),qe.innerHTML=ys,qn=i(),G=s("h3"),te=s("a"),Lt=s("span"),u(Ae.$$.fragment),Ha=i(),Zt=s("span"),Zt.textContent=vs,An=i(),He=s("p"),He.textContent=bs,Hn=i(),Be=s("ul"),Be.innerHTML=_s,Bn=i(),ze=s("p"),ze.innerHTML=ws,zn=i(),u(Re.$$.fragment),Rn=i(),N=s("h3"),ne=s("a"),Pt=s("span"),u(Ye.$$.fragment),Ba=i(),xt=s("span"),xt.textContent=js,Yn=i(),Le=s("p"),Le.innerHTML=Cs,Ln=i(),Pe=s("ul"),Pe.innerHTML=$s,Pn=i(),u(Xe.$$.fragment),Xn=i(),V=s("h2"),ae=s("a"),Xt=s("span"),u(Qe.$$.fragment),za=i(),Tt=s("span"),Tt.textContent=Ms,Qn=i(),Fe=s("p"),Fe.innerHTML=ks,Fn=i(),Ke=s("p"),Ke.innerHTML=Us,Kn=i(),S=s("h3"),se=s("a"),Qt=s("span"),u(De.$$.fragment),Ra=i(),Jt=s("span"),Jt.textContent=Is,Dn=i(),Oe=s("p"),Oe.textContent=Zs,On=i(),u(et.$$.fragment),ea=i(),tt=s("p"),tt.textContent=xs,ta=i(),u(nt.$$.fragment),na=i(),E=s("h3"),le=s("a"),Ft=s("span"),u(at.$$.fragment),Ya=i(),Wt=s("span"),Wt.textContent=Ts,aa=i(),st=s("p"),st.textContent=Js,sa=i(),u(lt.$$.fragment),la=i(),it=s("p"),it.textContent=Ws,ia=i(),u(rt.$$.fragment),ra=i(),u(ie.$$.fragment),oa=i(),q=s("h3"),re=s("a"),Kt=s("span"),u(ot.$$.fragment),La=i(),Gt=s("span"),Gt.textContent=Gs,ca=i(),ct=s("p"),ct.textContent=Ns,ha=i(),u(ht.$$.fragment),pa=i(),pt=s("p"),pt.textContent=Vs,fa=i(),u(ft.$$.fragment),ga=i(),A=s("h3"),oe=s("a"),Dt=s("span"),u(gt.$$.fragment),Pa=i(),Nt=s("span"),Nt.textContent=Ss,ua=i(),ut=s("p"),ut.textContent=Es,da=i(),u(dt.$$.fragment),ma=i(),mt=s("p"),mt.textContent=qs,ya=i(),u(yt.$$.fragment),this.h()},l(e){const n=vl("svelte-1phssyn",document.head);h=l(n,"META",{name:!0,content:!0}),n.forEach(t),w=r(e),g=l(e,"H1",{class:!0});var vt=f(g);_=l(vt,"A",{id:!0,class:!0,href:!0});var Ot=f(_);H=l(Ot,"SPAN",{});var en=f(H);d(j.$$.fragment,en),en.forEach(t),Ot.forEach(t),ce=r(vt),_t=l(vt,"SPAN",{"data-svelte-h":!0}),p(_t)!=="svelte-1nxkg5k"&&(_t.textContent=Xa),vt.forEach(t),an=r(e),he=l(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-411gzg"&&(he.innerHTML=Qa),sn=r(e),pe=l(e,"UL",{"data-svelte-h":!0}),p(pe)!=="svelte-lzzf1y"&&(pe.innerHTML=Fa),ln=r(e),fe=l(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-ur4jv9"&&(fe.innerHTML=Ka),rn=r(e),d(B.$$.fragment,e),on=r(e),k=l(e,"H2",{class:!0});var bt=f(k);z=l(bt,"A",{id:!0,class:!0,href:!0});var tn=f(z);Et=l(tn,"SPAN",{});var nn=f(Et);d(ge.$$.fragment,nn),nn.forEach(t),tn.forEach(t),Wa=r(bt),wt=l(bt,"SPAN",{"data-svelte-h":!0}),p(wt)!=="svelte-nr24ba"&&(wt.textContent=Da),bt.forEach(t),cn=r(e),ue=l(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-8lplub"&&(ue.textContent=Oa),hn=r(e),d(de.$$.fragment,e),pn=r(e),me=l(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-c8qcx2"&&(me.innerHTML=es),fn=r(e),d(R.$$.fragment,e),gn=r(e),U=l(e,"H3",{class:!0});var ba=f(U);Y=l(ba,"A",{id:!0,class:!0,href:!0});var As=f(Y);qt=l(As,"SPAN",{});var Hs=f(qt);d(ye.$$.fragment,Hs),Hs.forEach(t),As.forEach(t),Ga=r(ba),jt=l(ba,"SPAN",{"data-svelte-h":!0}),p(jt)!=="svelte-pcrvvp"&&(jt.textContent=ts),ba.forEach(t),un=r(e),ve=l(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1npu22n"&&(ve.textContent=ns),dn=r(e),d(be.$$.fragment,e),mn=r(e),d(L.$$.fragment,e),yn=r(e),I=l(e,"H3",{class:!0});var _a=f(I);P=l(_a,"A",{id:!0,class:!0,href:!0});var Bs=f(P);At=l(Bs,"SPAN",{});var zs=f(At);d(_e.$$.fragment,zs),zs.forEach(t),Bs.forEach(t),Na=r(_a),Ct=l(_a,"SPAN",{"data-svelte-h":!0}),p(Ct)!=="svelte-zh2y5d"&&(Ct.textContent=as),_a.forEach(t),vn=r(e),we=l(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-8ekppr"&&(we.innerHTML=ss),bn=r(e),d(je.$$.fragment,e),_n=r(e),Z=l(e,"H3",{class:!0});var wa=f(Z);X=l(wa,"A",{id:!0,class:!0,href:!0});var Rs=f(X);Ht=l(Rs,"SPAN",{});var Ys=f(Ht);d(Ce.$$.fragment,Ys),Ys.forEach(t),Rs.forEach(t),Va=r(wa),$t=l(wa,"SPAN",{"data-svelte-h":!0}),p($t)!=="svelte-1hjmc5p"&&($t.textContent=ls),wa.forEach(t),wn=r(e),$e=l(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-7irbfr"&&($e.innerHTML=is),jn=r(e),d(Me.$$.fragment,e),Cn=r(e),d(Q.$$.fragment,e),$n=r(e),x=l(e,"H2",{class:!0});var ja=f(x);F=l(ja,"A",{id:!0,class:!0,href:!0});var Ls=f(F);Bt=l(Ls,"SPAN",{});var Ps=f(Bt);d(ke.$$.fragment,Ps),Ps.forEach(t),Ls.forEach(t),Sa=r(ja),Mt=l(ja,"SPAN",{"data-svelte-h":!0}),p(Mt)!=="svelte-1r65ckf"&&(Mt.textContent=rs),ja.forEach(t),Mn=r(e),Ue=l(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-k2z7kc"&&(Ue.innerHTML=os),kn=r(e),Ie=l(e,"TABLE",{"data-svelte-h":!0}),p(Ie)!=="svelte-dyah88"&&(Ie.innerHTML=cs),Un=r(e),d(K.$$.fragment,e),In=r(e),T=l(e,"H2",{class:!0});var Ca=f(T);D=l(Ca,"A",{id:!0,class:!0,href:!0});var Xs=f(D);zt=l(Xs,"SPAN",{});var Qs=f(zt);d(Ze.$$.fragment,Qs),Qs.forEach(t),Xs.forEach(t),Ea=r(Ca),kt=l(Ca,"SPAN",{"data-svelte-h":!0}),p(kt)!=="svelte-1mnnp24"&&(kt.textContent=hs),Ca.forEach(t),Zn=r(e),xe=l(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1fe8kju"&&(xe.innerHTML=ps),xn=r(e),d(Te.$$.fragment,e),Tn=r(e),J=l(e,"H2",{class:!0});var $a=f(J);O=l($a,"A",{id:!0,class:!0,href:!0});var Fs=f(O);Rt=l(Fs,"SPAN",{});var Ks=f(Rt);d(Je.$$.fragment,Ks),Ks.forEach(t),Fs.forEach(t),qa=r($a),Ut=l($a,"SPAN",{"data-svelte-h":!0}),p(Ut)!=="svelte-19nhduc"&&(Ut.textContent=fs),$a.forEach(t),Jn=r(e),We=l(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1gqwj00"&&(We.innerHTML=gs),Wn=r(e),d(Ge.$$.fragment,e),Gn=r(e),Ne=l(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1k5soi6"&&(Ne.innerHTML=us),Nn=r(e),d(Ve.$$.fragment,e),Vn=r(e),Se=l(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-q492az"&&(Se.innerHTML=ds),Sn=r(e),W=l(e,"H2",{class:!0});var Ma=f(W);ee=l(Ma,"A",{id:!0,class:!0,href:!0});var Ds=f(ee);Yt=l(Ds,"SPAN",{});var Os=f(Yt);d(Ee.$$.fragment,Os),Os.forEach(t),Ds.forEach(t),Aa=r(Ma),It=l(Ma,"SPAN",{"data-svelte-h":!0}),p(It)!=="svelte-yim86r"&&(It.textContent=ms),Ma.forEach(t),En=r(e),qe=l(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1lh5yi7"&&(qe.innerHTML=ys),qn=r(e),G=l(e,"H3",{class:!0});var ka=f(G);te=l(ka,"A",{id:!0,class:!0,href:!0});var el=f(te);Lt=l(el,"SPAN",{});var tl=f(Lt);d(Ae.$$.fragment,tl),tl.forEach(t),el.forEach(t),Ha=r(ka),Zt=l(ka,"SPAN",{"data-svelte-h":!0}),p(Zt)!=="svelte-1gbpn4g"&&(Zt.textContent=vs),ka.forEach(t),An=r(e),He=l(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-8gznjs"&&(He.textContent=bs),Hn=r(e),Be=l(e,"UL",{"data-svelte-h":!0}),p(Be)!=="svelte-ovc80h"&&(Be.innerHTML=_s),Bn=r(e),ze=l(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1rov0jg"&&(ze.innerHTML=ws),zn=r(e),d(Re.$$.fragment,e),Rn=r(e),N=l(e,"H3",{class:!0});var Ua=f(N);ne=l(Ua,"A",{id:!0,class:!0,href:!0});var nl=f(ne);Pt=l(nl,"SPAN",{});var al=f(Pt);d(Ye.$$.fragment,al),al.forEach(t),nl.forEach(t),Ba=r(Ua),xt=l(Ua,"SPAN",{"data-svelte-h":!0}),p(xt)!=="svelte-njj6p"&&(xt.textContent=js),Ua.forEach(t),Yn=r(e),Le=l(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-il54r5"&&(Le.innerHTML=Cs),Ln=r(e),Pe=l(e,"UL",{"data-svelte-h":!0}),p(Pe)!=="svelte-vaeuct"&&(Pe.innerHTML=$s),Pn=r(e),d(Xe.$$.fragment,e),Xn=r(e),V=l(e,"H2",{class:!0});var Ia=f(V);ae=l(Ia,"A",{id:!0,class:!0,href:!0});var sl=f(ae);Xt=l(sl,"SPAN",{});var ll=f(Xt);d(Qe.$$.fragment,ll),ll.forEach(t),sl.forEach(t),za=r(Ia),Tt=l(Ia,"SPAN",{"data-svelte-h":!0}),p(Tt)!=="svelte-7px1ys"&&(Tt.textContent=Ms),Ia.forEach(t),Qn=r(e),Fe=l(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-7r95wb"&&(Fe.innerHTML=ks),Fn=r(e),Ke=l(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-qxm8gi"&&(Ke.innerHTML=Us),Kn=r(e),S=l(e,"H3",{class:!0});var Za=f(S);se=l(Za,"A",{id:!0,class:!0,href:!0});var il=f(se);Qt=l(il,"SPAN",{});var rl=f(Qt);d(De.$$.fragment,rl),rl.forEach(t),il.forEach(t),Ra=r(Za),Jt=l(Za,"SPAN",{"data-svelte-h":!0}),p(Jt)!=="svelte-mwesf9"&&(Jt.textContent=Is),Za.forEach(t),Dn=r(e),Oe=l(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-ft9vbs"&&(Oe.textContent=Zs),On=r(e),d(et.$$.fragment,e),ea=r(e),tt=l(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-8wg17z"&&(tt.textContent=xs),ta=r(e),d(nt.$$.fragment,e),na=r(e),E=l(e,"H3",{class:!0});var xa=f(E);le=l(xa,"A",{id:!0,class:!0,href:!0});var ol=f(le);Ft=l(ol,"SPAN",{});var cl=f(Ft);d(at.$$.fragment,cl),cl.forEach(t),ol.forEach(t),Ya=r(xa),Wt=l(xa,"SPAN",{"data-svelte-h":!0}),p(Wt)!=="svelte-5i9nvx"&&(Wt.textContent=Ts),xa.forEach(t),aa=r(e),st=l(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-ft9vbs"&&(st.textContent=Js),sa=r(e),d(lt.$$.fragment,e),la=r(e),it=l(e,"P",{"data-svelte-h":!0}),p(it)!=="svelte-8wg17z"&&(it.textContent=Ws),ia=r(e),d(rt.$$.fragment,e),ra=r(e),d(ie.$$.fragment,e),oa=r(e),q=l(e,"H3",{class:!0});var Ta=f(q);re=l(Ta,"A",{id:!0,class:!0,href:!0});var hl=f(re);Kt=l(hl,"SPAN",{});var pl=f(Kt);d(ot.$$.fragment,pl),pl.forEach(t),hl.forEach(t),La=r(Ta),Gt=l(Ta,"SPAN",{"data-svelte-h":!0}),p(Gt)!=="svelte-12jtx6u"&&(Gt.textContent=Gs),Ta.forEach(t),ca=r(e),ct=l(e,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-ft9vbs"&&(ct.textContent=Ns),ha=r(e),d(ht.$$.fragment,e),pa=r(e),pt=l(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-8wg17z"&&(pt.textContent=Vs),fa=r(e),d(ft.$$.fragment,e),ga=r(e),A=l(e,"H3",{class:!0});var Ja=f(A);oe=l(Ja,"A",{id:!0,class:!0,href:!0});var fl=f(oe);Dt=l(fl,"SPAN",{});var gl=f(Dt);d(gt.$$.fragment,gl),gl.forEach(t),fl.forEach(t),Pa=r(Ja),Nt=l(Ja,"SPAN",{"data-svelte-h":!0}),p(Nt)!=="svelte-dvs60e"&&(Nt.textContent=Ss),Ja.forEach(t),ua=r(e),ut=l(e,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-ft9vbs"&&(ut.textContent=Es),da=r(e),d(dt.$$.fragment,e),ma=r(e),mt=l(e,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-8wg17z"&&(mt.textContent=qs),ya=r(e),d(yt.$$.fragment,e),this.h()},h(){o(h,"name","hf:doc:metadata"),o(h,"content",JSON.stringify(kl)),o(_,"id","run-inference-on-servers"),o(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(_,"href","#run-inference-on-servers"),o(g,"class","relative group"),o(z,"id","getting-started"),o(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(z,"href","#getting-started"),o(k,"class","relative group"),o(Y,"id","using-a-specific-model"),o(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(Y,"href","#using-a-specific-model"),o(U,"class","relative group"),o(P,"id","using-a-specific-url"),o(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(P,"href","#using-a-specific-url"),o(I,"class","relative group"),o(X,"id","authentication"),o(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(X,"href","#authentication"),o(Z,"class","relative group"),o(F,"id","supported-tasks"),o(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(F,"href","#supported-tasks"),o(x,"class","relative group"),o(D,"id","custom-requests"),o(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(D,"href","#custom-requests"),o(T,"class","relative group"),o(O,"id","async-client"),o(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(O,"href","#async-client"),o(J,"class","relative group"),o(ee,"id","advanced-tips"),o(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ee,"href","#advanced-tips"),o(W,"class","relative group"),o(te,"id","timeout"),o(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(te,"href","#timeout"),o(G,"class","relative group"),o(ne,"id","binary-inputs"),o(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ne,"href","#binary-inputs"),o(N,"class","relative group"),o(ae,"id","legacy-inferenceapi-client"),o(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ae,"href","#legacy-inferenceapi-client"),o(V,"class","relative group"),o(se,"id","initialization"),o(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(se,"href","#initialization"),o(S,"class","relative group"),o(le,"id","run-on-a-specific-task"),o(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(le,"href","#run-on-a-specific-task"),o(E,"class","relative group"),o(re,"id","run-custom-request"),o(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(re,"href","#run-custom-request"),o(q,"class","relative group"),o(oe,"id","run-with-parameters"),o(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(oe,"href","#run-with-parameters"),o(A,"class","relative group")},m(e,n){c(document.head,h),a(e,w,n),a(e,g,n),c(g,_),c(_,H),m(j,H,null),c(g,ce),c(g,_t),a(e,an,n),a(e,he,n),a(e,sn,n),a(e,pe,n),a(e,ln,n),a(e,fe,n),a(e,rn,n),m(B,e,n),a(e,on,n),a(e,k,n),c(k,z),c(z,Et),m(ge,Et,null),c(k,Wa),c(k,wt),a(e,cn,n),a(e,ue,n),a(e,hn,n),m(de,e,n),a(e,pn,n),a(e,me,n),a(e,fn,n),m(R,e,n),a(e,gn,n),a(e,U,n),c(U,Y),c(Y,qt),m(ye,qt,null),c(U,Ga),c(U,jt),a(e,un,n),a(e,ve,n),a(e,dn,n),m(be,e,n),a(e,mn,n),m(L,e,n),a(e,yn,n),a(e,I,n),c(I,P),c(P,At),m(_e,At,null),c(I,Na),c(I,Ct),a(e,vn,n),a(e,we,n),a(e,bn,n),m(je,e,n),a(e,_n,n),a(e,Z,n),c(Z,X),c(X,Ht),m(Ce,Ht,null),c(Z,Va),c(Z,$t),a(e,wn,n),a(e,$e,n),a(e,jn,n),m(Me,e,n),a(e,Cn,n),m(Q,e,n),a(e,$n,n),a(e,x,n),c(x,F),c(F,Bt),m(ke,Bt,null),c(x,Sa),c(x,Mt),a(e,Mn,n),a(e,Ue,n),a(e,kn,n),a(e,Ie,n),a(e,Un,n),m(K,e,n),a(e,In,n),a(e,T,n),c(T,D),c(D,zt),m(Ze,zt,null),c(T,Ea),c(T,kt),a(e,Zn,n),a(e,xe,n),a(e,xn,n),m(Te,e,n),a(e,Tn,n),a(e,J,n),c(J,O),c(O,Rt),m(Je,Rt,null),c(J,qa),c(J,Ut),a(e,Jn,n),a(e,We,n),a(e,Wn,n),m(Ge,e,n),a(e,Gn,n),a(e,Ne,n),a(e,Nn,n),m(Ve,e,n),a(e,Vn,n),a(e,Se,n),a(e,Sn,n),a(e,W,n),c(W,ee),c(ee,Yt),m(Ee,Yt,null),c(W,Aa),c(W,It),a(e,En,n),a(e,qe,n),a(e,qn,n),a(e,G,n),c(G,te),c(te,Lt),m(Ae,Lt,null),c(G,Ha),c(G,Zt),a(e,An,n),a(e,He,n),a(e,Hn,n),a(e,Be,n),a(e,Bn,n),a(e,ze,n),a(e,zn,n),m(Re,e,n),a(e,Rn,n),a(e,N,n),c(N,ne),c(ne,Pt),m(Ye,Pt,null),c(N,Ba),c(N,xt),a(e,Yn,n),a(e,Le,n),a(e,Ln,n),a(e,Pe,n),a(e,Pn,n),m(Xe,e,n),a(e,Xn,n),a(e,V,n),c(V,ae),c(ae,Xt),m(Qe,Xt,null),c(V,za),c(V,Tt),a(e,Qn,n),a(e,Fe,n),a(e,Fn,n),a(e,Ke,n),a(e,Kn,n),a(e,S,n),c(S,se),c(se,Qt),m(De,Qt,null),c(S,Ra),c(S,Jt),a(e,Dn,n),a(e,Oe,n),a(e,On,n),m(et,e,n),a(e,ea,n),a(e,tt,n),a(e,ta,n),m(nt,e,n),a(e,na,n),a(e,E,n),c(E,le),c(le,Ft),m(at,Ft,null),c(E,Ya),c(E,Wt),a(e,aa,n),a(e,st,n),a(e,sa,n),m(lt,e,n),a(e,la,n),a(e,it,n),a(e,ia,n),m(rt,e,n),a(e,ra,n),m(ie,e,n),a(e,oa,n),a(e,q,n),c(q,re),c(re,Kt),m(ot,Kt,null),c(q,La),c(q,Gt),a(e,ca,n),a(e,ct,n),a(e,ha,n),m(ht,e,n),a(e,pa,n),a(e,pt,n),a(e,fa,n),m(ft,e,n),a(e,ga,n),a(e,A,n),c(A,oe),c(oe,Dt),m(gt,Dt,null),c(A,Pa),c(A,Nt),a(e,ua,n),a(e,ut,n),a(e,da,n),m(dt,e,n),a(e,ma,n),a(e,mt,n),a(e,ya,n),m(yt,e,n),va=!0},p(e,[n]){const vt={};n&2&&(vt.$$scope={dirty:n,ctx:e}),B.$set(vt);const Ot={};n&2&&(Ot.$$scope={dirty:n,ctx:e}),R.$set(Ot);const en={};n&2&&(en.$$scope={dirty:n,ctx:e}),L.$set(en);const bt={};n&2&&(bt.$$scope={dirty:n,ctx:e}),Q.$set(bt);const tn={};n&2&&(tn.$$scope={dirty:n,ctx:e}),K.$set(tn);const nn={};n&2&&(nn.$$scope={dirty:n,ctx:e}),ie.$set(nn)},i(e){va||(y(j.$$.fragment,e),y(B.$$.fragment,e),y(ge.$$.fragment,e),y(de.$$.fragment,e),y(R.$$.fragment,e),y(ye.$$.fragment,e),y(be.$$.fragment,e),y(L.$$.fragment,e),y(_e.$$.fragment,e),y(je.$$.fragment,e),y(Ce.$$.fragment,e),y(Me.$$.fragment,e),y(Q.$$.fragment,e),y(ke.$$.fragment,e),y(K.$$.fragment,e),y(Ze.$$.fragment,e),y(Te.$$.fragment,e),y(Je.$$.fragment,e),y(Ge.$$.fragment,e),y(Ve.$$.fragment,e),y(Ee.$$.fragment,e),y(Ae.$$.fragment,e),y(Re.$$.fragment,e),y(Ye.$$.fragment,e),y(Xe.$$.fragment,e),y(Qe.$$.fragment,e),y(De.$$.fragment,e),y(et.$$.fragment,e),y(nt.$$.fragment,e),y(at.$$.fragment,e),y(lt.$$.fragment,e),y(rt.$$.fragment,e),y(ie.$$.fragment,e),y(ot.$$.fragment,e),y(ht.$$.fragment,e),y(ft.$$.fragment,e),y(gt.$$.fragment,e),y(dt.$$.fragment,e),y(yt.$$.fragment,e),va=!0)},o(e){v(j.$$.fragment,e),v(B.$$.fragment,e),v(ge.$$.fragment,e),v(de.$$.fragment,e),v(R.$$.fragment,e),v(ye.$$.fragment,e),v(be.$$.fragment,e),v(L.$$.fragment,e),v(_e.$$.fragment,e),v(je.$$.fragment,e),v(Ce.$$.fragment,e),v(Me.$$.fragment,e),v(Q.$$.fragment,e),v(ke.$$.fragment,e),v(K.$$.fragment,e),v(Ze.$$.fragment,e),v(Te.$$.fragment,e),v(Je.$$.fragment,e),v(Ge.$$.fragment,e),v(Ve.$$.fragment,e),v(Ee.$$.fragment,e),v(Ae.$$.fragment,e),v(Re.$$.fragment,e),v(Ye.$$.fragment,e),v(Xe.$$.fragment,e),v(Qe.$$.fragment,e),v(De.$$.fragment,e),v(et.$$.fragment,e),v(nt.$$.fragment,e),v(at.$$.fragment,e),v(lt.$$.fragment,e),v(rt.$$.fragment,e),v(ie.$$.fragment,e),v(ot.$$.fragment,e),v(ht.$$.fragment,e),v(ft.$$.fragment,e),v(gt.$$.fragment,e),v(dt.$$.fragment,e),v(yt.$$.fragment,e),va=!1},d(e){e&&(t(w),t(g),t(an),t(he),t(sn),t(pe),t(ln),t(fe),t(rn),t(on),t(k),t(cn),t(ue),t(hn),t(pn),t(me),t(fn),t(gn),t(U),t(un),t(ve),t(dn),t(mn),t(yn),t(I),t(vn),t(we),t(bn),t(_n),t(Z),t(wn),t($e),t(jn),t(Cn),t($n),t(x),t(Mn),t(Ue),t(kn),t(Ie),t(Un),t(In),t(T),t(Zn),t(xe),t(xn),t(Tn),t(J),t(Jn),t(We),t(Wn),t(Gn),t(Ne),t(Nn),t(Vn),t(Se),t(Sn),t(W),t(En),t(qe),t(qn),t(G),t(An),t(He),t(Hn),t(Be),t(Bn),t(ze),t(zn),t(Rn),t(N),t(Yn),t(Le),t(Ln),t(Pe),t(Pn),t(Xn),t(V),t(Qn),t(Fe),t(Fn),t(Ke),t(Kn),t(S),t(Dn),t(Oe),t(On),t(ea),t(tt),t(ta),t(na),t(E),t(aa),t(st),t(sa),t(la),t(it),t(ia),t(ra),t(oa),t(q),t(ca),t(ct),t(ha),t(pa),t(pt),t(fa),t(ga),t(A),t(ua),t(ut),t(da),t(ma),t(mt),t(ya)),t(h),b(j),b(B,e),b(ge),b(de,e),b(R,e),b(ye),b(be,e),b(L,e),b(_e),b(je,e),b(Ce),b(Me,e),b(Q,e),b(ke),b(K,e),b(Ze),b(Te,e),b(Je),b(Ge,e),b(Ve,e),b(Ee),b(Ae),b(Re,e),b(Ye),b(Xe,e),b(Qe),b(De),b(et,e),b(nt,e),b(at),b(lt,e),b(rt,e),b(ie,e),b(ot),b(ht,e),b(ft,e),b(gt),b(dt,e),b(yt,e)}}}const kl={local:"run-inference-on-servers",sections:[{local:"getting-started",sections:[{local:"using-a-specific-model",title:"Using a specific model"},{local:"using-a-specific-url",title:"Using a specific URL"},{local:"authentication",title:"Authentication"}],title:"Getting started"},{local:"supported-tasks",title:"Supported tasks"},{local:"custom-requests",title:"Custom requests"},{local:"async-client",title:"Async client"},{local:"advanced-tips",sections:[{local:"timeout",title:"Timeout"},{local:"binary-inputs",title:"Binary inputs"}],title:"Advanced tips"},{local:"legacy-inferenceapi-client",sections:[{local:"initialization",title:"Initialization"},{local:"run-on-a-specific-task",title:"Run on a specific task"},{local:"run-custom-request",title:"Run custom request"},{local:"run-with-parameters",title:"Run with parameters"}],title:"Legacy InferenceAPI client"}],title:"Run Inference on servers"};function Ul(M){return dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wl extends ml{constructor(h){super(),yl(this,h,Ul,Ml,ul,{})}}export{Wl as component};
