import{s as os,n as Js,o as hs}from"../chunks/scheduler.23542ac5.js";import{S as Zs,i as js,e as p,s as n,c,h as bs,a as i,d as s,b as a,f as fs,g as r,j as M,k as J,l as Ts,m as t,n as m,t as u,o as d,p as y}from"../chunks/index.9b1f405b.js";import{C as ws,H as we,E as Us}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.5bcbaa63.js";import{C as f}from"../chunks/CodeBlock.e82446dd.js";function gs(Il){let o,Ge,Ue,$e,g,Ce,G,Ve,$,Xl='diffusion 파이프라인은 diffusion 모델, 스케줄러 등의 컴포넌트들로 구성됩니다. 그리고 파이프라인 안의 일부 컴포넌트를 다른 컴포넌트로 교체하는 식의 커스터마이징 역시 가능합니다.  이와 같은 컴포넌트 커스터마이징의 가장 대표적인 예시가 바로 <a href="../api/schedulers/overview">스케줄러</a>를 교체하는 것입니다.',We,C,kl="스케쥴러는 다음과 같이 diffusion 시스템의 전반적인 디노이징 프로세스를 정의합니다.",Be,V,_l="<li>디노이징 스텝을 얼마나 가져가야 할까?</li> <li>확률적으로(stochastic) 혹은 확정적으로(deterministic)?</li> <li>디노이징 된 샘플을 찾아내기 위해 어떤 알고리즘을 사용해야 할까?</li>",xe,W,Nl="이러한 프로세스는 다소 난해하고, 디노이징 속도와 디노이징 퀄리티 사이의 트레이드 오프를 정의해야 하는 문제가 될 수 있습니다. 주어진 파이프라인에 어떤 스케줄러가 가장 적합한지를 정량적으로 판단하는 것은 매우 어려운 일입니다. 이로 인해 일단 해당 스케줄러를 직접 사용하여, 생성되는 이미지를 직접 눈으로 보며, 정성적으로 성능을 판단해보는 것이 추천되곤 합니다.",ve,B,Ie,x,Sl='먼저 스테이블 diffusion 파이프라인을 불러오도록 해보겠습니다. 물론 스테이블 diffusion을 사용하기 위해서는, 허깅페이스 허브에 등록된 사용자여야 하며, 관련 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">라이센스</a>에 동의해야 한다는 점을 잊지 말아주세요.',Xe,v,Rl="<em>역자 주: 다만, 현재 신규로 생성한 허깅페이스 계정에 대해서는 라이센스 동의를 요구하지 않는 것으로 보입니다!</em>",ke,I,_e,X,El="다음으로, GPU로 이동합니다.",Ne,k,Se,_,Re,N,Hl="스케줄러는 언제나 파이프라인의 컴포넌트로서 존재하며, 일반적으로 파이프라인 인스턴스 내에 <code>scheduler</code>라는 이름의 속성(property)으로 정의되어 있습니다.",Ee,S,He,R,Yl="<strong>Output</strong>:",Ye,E,ze,H,zl="출력 결과를 통해, 우리는 해당 스케줄러가 <code>PNDMScheduler</code>의 인스턴스라는 것을 알 수 있습니다. 이제 <code>PNDMScheduler</code>와 다른 스케줄러들의 성능을 비교해보도록 하겠습니다. 먼저 테스트에 사용할 프롬프트를 다음과 같이 정의해보도록 하겠습니다.",Fe,Y,Qe,z,Fl="다음으로 유사한 이미지 생성을 보장하기 위해서, 다음과 같이 랜덤시드를 고정해주도록 하겠습니다.",Ae,F,Le,h,Ql='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_pndm.png" width="400"/> <br/>',De,Q,qe,A,Al="다음으로 파이프라인의 스케줄러를 다른 스케줄러로 교체하는 방법에 대해 알아보겠습니다. 모든 스케줄러는 <code>SchedulerMixin.compatibles</code>라는 속성(property)을 갖고 있습니다. 해당 속성은 <strong>호환 가능한</strong> 스케줄러들에 대한 정보를 담고 있습니다.",Pe,L,Ke,D,Ll="<strong>Output</strong>:",Oe,q,el,P,Dl="호환되는 스케줄러들을 살펴보면 아래와 같습니다.",ll,K,ql="<li><code>LMSDiscreteScheduler</code>,</li> <li><code>DDIMScheduler</code>,</li> <li><code>DPMSolverMultistepScheduler</code>,</li> <li><code>EulerDiscreteScheduler</code>,</li> <li><code>PNDMScheduler</code>,</li> <li><code>DDPMScheduler</code>,</li> <li><code>EulerAncestralDiscreteScheduler</code>.</li>",sl,O,Pl="앞서 정의했던 프롬프트를 사용해서 각각의 스케줄러들을 비교해보도록 하겠습니다.",tl,ee,Kl="먼저 파이프라인 안의 스케줄러를 바꾸기 위해 <code>ConfigMixin.config</code> 속성과 <code>ConfigMixin.from_config()</code> 메서드를 활용해보려고 합니다.",nl,le,al,se,Ol="<strong>Output</strong>:",pl,te,il,ne,es="기존 스케줄러의 config를 호환 가능한 다른 스케줄러에 이식하는 것 역시 가능합니다.",Ml,ae,ls="다음 예시는 기존 스케줄러(<code>pipeline.scheduler</code>)를 다른 종류의 스케줄러(<code>DDIMScheduler</code>)로 바꾸는 코드입니다. 기존 스케줄러가 갖고 있던 config를 <code>.from_config</code> 메서드의 인자로 전달하는 것을 확인할 수 있습니다.",cl,pe,rl,ie,ss="이제 파이프라인을 실행해서 두 스케줄러 사이의 생성된 이미지의 퀄리티를 비교해봅시다.",ml,Me,ul,Z,ts='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_ddim.png" width="400"/> <br/>',dl,ce,yl,re,ns="지금까지는 <code>PNDMScheduler</code>와 <code>DDIMScheduler</code> 스케줄러를 실행해보았습니다. 아직 비교해볼 스케줄러들이 더 많이 남아있으니 계속 비교해보도록 하겠습니다.",fl,me,as="<code>LMSDiscreteScheduler</code>을 일반적으로 더 좋은 결과를 보여줍니다.",ol,ue,Jl,j,ps='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_lms.png" width="400"/> <br/>',hl,de,is="<code>EulerDiscreteScheduler</code>와 <code>EulerAncestralDiscreteScheduler</code> 고작 30번의 inference step만으로도 높은 퀄리티의 이미지를 생성하는 것을 알 수 있습니다.",Zl,ye,jl,b,Ms='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_euler_discrete.png" width="400"/> <br/>',bl,fe,Tl,T,cs='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_euler_ancestral.png" width="400"/> <br/>',wl,oe,rs="지금 이 문서를 작성하는 현시점 기준에선, <code>DPMSolverMultistepScheduler</code>가 시간 대비 가장 좋은 품질의 이미지를 생성하는 것 같습니다. 20번 정도의 스텝만으로도 실행될 수 있습니다.",Ul,Je,gl,w,ms='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_dpm.png" width="400"/> <br/>',Gl,he,us="보시다시피 생성된 이미지들은 매우 비슷하고, 비슷한 퀄리티를 보이는 것 같습니다. 실제로 어떤 스케줄러를 선택할 것인가는 종종 특정 이용 사례에 기반해서 결정되곤 합니다. 결국 여러 종류의 스케줄러를 직접 실행시켜보고 눈으로 직접 비교해서 판단하는 게 좋은 선택일 것 같습니다.",$l,Ze,Cl,je,ds='JAX/Flax 사용자인 경우 기본 파이프라인 스케줄러를 변경할 수도 있습니다. 다음은 Flax Stable Diffusion 파이프라인과 초고속 <a href="../api/schedulers/multistep_dpm_solver">DDPM-Solver++ 스케줄러를</a> 사용하여 추론을 실행하는 방법에 대한 예시입니다 .',Vl,be,Wl,U,ys="<p>다음 Flax 스케줄러는 <em>아직</em> Flax Stable Diffusion 파이프라인과 호환되지 않습니다.</p> <ul><li><code>FlaxLMSDiscreteScheduler</code></li> <li><code>FlaxDDPMScheduler</code></li></ul>",Bl,Te,xl,ge,vl;return g=new ws({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),G=new we({props:{title:"스케줄러",local:"스케줄러",headingTag:"h1"}}),B=new we({props:{title:"파이프라인 불러오기",local:"파이프라인-불러오기",headingTag:"h2"}}),I=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBmaXJzdCUyMHdlJTIwbmVlZCUyMHRvJTIwbG9naW4lMjB3aXRoJTIwb3VyJTIwYWNjZXNzJTIwdG9rZW4lMEFsb2dpbigpJTBBJTBBJTIzJTIwTm93JTIwd2UlMjBjYW4lMjBkb3dubG9hZCUyMHRoZSUyMHBpcGVsaW5lJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># first we need to login with our access token</span>
login()

<span class="hljs-comment"># Now we can download the pipeline</span>
pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)`,wrap:!1}}),k=new f({props:{code:"cGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:'pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),_=new we({props:{title:"스케줄러 액세스",local:"스케줄러-액세스",headingTag:"h2"}}),S=new f({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVy",highlighted:"pipeline.scheduler",wrap:!1}}),E=new f({props:{code:"UE5ETVNjaGVkdWxlciUyMCU3QiUwQSUyMCUyMCUyMl9jbGFzc19uYW1lJTIyJTNBJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuOC4wLmRldjAlMjIlMkMlMEElMjAlMjAlMjJiZXRhX2VuZCUyMiUzQSUyMDAuMDEyJTJDJTBBJTIwJTIwJTIyYmV0YV9zY2hlZHVsZSUyMiUzQSUyMCUyMnNjYWxlZF9saW5lYXIlMjIlMkMlMEElMjAlMjAlMjJiZXRhX3N0YXJ0JTIyJTNBJTIwMC4wMDA4NSUyQyUwQSUyMCUyMCUyMmNsaXBfc2FtcGxlJTIyJTNBJTIwZmFsc2UlMkMlMEElMjAlMjAlMjJudW1fdHJhaW5fdGltZXN0ZXBzJTIyJTNBJTIwMTAwMCUyQyUwQSUyMCUyMCUyMnNldF9hbHBoYV90b19vbmUlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMnNraXBfcHJrX3N0ZXBzJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMnN0ZXBzX29mZnNldCUyMiUzQSUyMDElMkMlMEElMjAlMjAlMjJ0cmFpbmVkX2JldGFzJTIyJTNBJTIwbnVsbCUwQSU3RA==",highlighted:`PNDMScheduler {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;PNDMScheduler&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.8.0.dev0&quot;</span>,
  <span class="hljs-string">&quot;beta_end&quot;</span>: <span class="hljs-number">0.012</span>,
  <span class="hljs-string">&quot;beta_schedule&quot;</span>: <span class="hljs-string">&quot;scaled_linear&quot;</span>,
  <span class="hljs-string">&quot;beta_start&quot;</span>: <span class="hljs-number">0.00085</span>,
  <span class="hljs-string">&quot;clip_sample&quot;</span>: <span class="hljs-literal">false</span>,
  <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
  <span class="hljs-string">&quot;set_alpha_to_one&quot;</span>: <span class="hljs-literal">false</span>,
  <span class="hljs-string">&quot;skip_prk_steps&quot;</span>: <span class="hljs-literal">true</span>,
  <span class="hljs-string">&quot;steps_offset&quot;</span>: <span class="hljs-number">1</span>,
  <span class="hljs-string">&quot;trained_betas&quot;</span>: <span class="hljs-literal">null</span>
}`,wrap:!1}}),Y=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMHBob3RvZ3JhcGglMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBNYXJzJTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBoaWdoJTIwZGVmaW5pdGlvbi4lMjI=",highlighted:'prompt = <span class="hljs-string">&quot;A photograph of an astronaut riding a horse on Mars, high resolution, high definition.&quot;</span>',wrap:!1}}),F=new f({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Q=new we({props:{title:"스케줄러 교체하기",local:"스케줄러-교체하기",headingTag:"h2"}}),L=new f({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVz",highlighted:"pipeline.scheduler.compatibles",wrap:!1}}),q=new f({props:{code:"JTVCZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19sbXNfZGlzY3JldGUuTE1TRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2RkaW0uRERJTVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZHBtc29sdmVyX211bHRpc3RlcC5EUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2V1bGVyX2Rpc2NyZXRlLkV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3BuZG0uUE5ETVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRwbS5ERFBNU2NoZWR1bGVyJTJDJTBBJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9hbmNlc3RyYWxfZGlzY3JldGUuRXVsZXJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciU1RA==",highlighted:`[<span class="hljs-keyword">diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_ddim.DDIMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_pndm.PNDMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler]</span>`,wrap:!1}}),le=new f({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZw==",highlighted:"pipeline.scheduler.config",wrap:!1}}),te=new f({props:{code:"RnJvemVuRGljdCglNUIoJ251bV90cmFpbl90aW1lc3RlcHMnJTJDJTIwMTAwMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2JldGFfc3RhcnQnJTJDJTIwMC4wMDA4NSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2JldGFfZW5kJyUyQyUyMDAuMDEyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnYmV0YV9zY2hlZHVsZSclMkMlMjAnc2NhbGVkX2xpbmVhcicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCd0cmFpbmVkX2JldGFzJyUyQyUyME5vbmUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCdza2lwX3Bya19zdGVwcyclMkMlMjBUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnc2V0X2FscGhhX3RvX29uZSclMkMlMjBGYWxzZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ3N0ZXBzX29mZnNldCclMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnX2NsYXNzX25hbWUnJTJDJTIwJ1BORE1TY2hlZHVsZXInKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnX2RpZmZ1c2Vyc192ZXJzaW9uJyUyQyUyMCcwLjguMC5kZXYwJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2NsaXBfc2FtcGxlJyUyQyUyMEZhbHNlKSU1RCk=",highlighted:`FrozenDict([(&#x27;num_train_timesteps&#x27;, <span class="hljs-number">1000</span>),
            (&#x27;beta_start&#x27;, <span class="hljs-number">0.00085</span>),
            (&#x27;beta_end&#x27;, <span class="hljs-number">0.012</span>),
            (&#x27;beta_schedule&#x27;, &#x27;scaled_linear&#x27;),
            (&#x27;trained_betas&#x27;, None),
            (&#x27;skip_prk_steps&#x27;, True),
            (&#x27;set_alpha_to_one&#x27;, False),
            (&#x27;steps_offset&#x27;, <span class="hljs-number">1</span>),
            (&#x27;_class_name&#x27;, &#x27;PNDMScheduler&#x27;),
            (&#x27;_diffusers_version&#x27;, &#x27;<span class="hljs-number">0.8</span>.<span class="hljs-number">0</span>.dev0&#x27;),
            (&#x27;clip_sample&#x27;, False)])`,wrap:!1}}),pe=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1TY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler

pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),Me=new f({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ce=new we({props:{title:"스케줄러들 비교해보기",local:"스케줄러들-비교해보기",headingTag:"h2"}}),ue=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyJTBBJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwTE1TRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoOCklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

pipeline.scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ye=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerDiscreteScheduler

pipeline.scheduler = EulerDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),fe=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerAncestralDiscreteScheduler

pipeline.scheduler = EulerAncestralDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Je=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg4KSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ze=new we({props:{title:"Flax에서 스케줄러 교체하기",local:"flax에서-스케줄러-교체하기",headingTag:"h2"}}),be=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> jax
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline, FlaxDPMSolverMultistepScheduler

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
scheduler, scheduler_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>
)
pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
    model_id,
    scheduler=scheduler,
    variant=<span class="hljs-string">&quot;bf16&quot;</span>,
    dtype=jax.numpy.bfloat16,
)
params[<span class="hljs-string">&quot;scheduler&quot;</span>] = scheduler_state

<span class="hljs-comment"># Generate 1 image per parallel device (8 on TPUv2-8 or TPUv3-8)</span>
prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
num_samples = jax.device_count()
prompt_ids = pipeline.prepare_inputs([prompt] * num_samples)

prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
num_inference_steps = <span class="hljs-number">25</span>

<span class="hljs-comment"># shard inputs and rng</span>
params = replicate(params)
prng_seed = jax.random.split(prng_seed, jax.device_count())
prompt_ids = shard(prompt_ids)

images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),Te=new Us({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ko/using-diffusers/schedulers.md"}}),{c(){o=p("meta"),Ge=n(),Ue=p("p"),$e=n(),c(g.$$.fragment),Ce=n(),c(G.$$.fragment),Ve=n(),$=p("p"),$.innerHTML=Xl,We=n(),C=p("p"),C.textContent=kl,Be=n(),V=p("ul"),V.innerHTML=_l,xe=n(),W=p("p"),W.textContent=Nl,ve=n(),c(B.$$.fragment),Ie=n(),x=p("p"),x.innerHTML=Sl,Xe=n(),v=p("p"),v.innerHTML=Rl,ke=n(),c(I.$$.fragment),_e=n(),X=p("p"),X.textContent=El,Ne=n(),c(k.$$.fragment),Se=n(),c(_.$$.fragment),Re=n(),N=p("p"),N.innerHTML=Hl,Ee=n(),c(S.$$.fragment),He=n(),R=p("p"),R.innerHTML=Yl,Ye=n(),c(E.$$.fragment),ze=n(),H=p("p"),H.innerHTML=zl,Fe=n(),c(Y.$$.fragment),Qe=n(),z=p("p"),z.textContent=Fl,Ae=n(),c(F.$$.fragment),Le=n(),h=p("p"),h.innerHTML=Ql,De=n(),c(Q.$$.fragment),qe=n(),A=p("p"),A.innerHTML=Al,Pe=n(),c(L.$$.fragment),Ke=n(),D=p("p"),D.innerHTML=Ll,Oe=n(),c(q.$$.fragment),el=n(),P=p("p"),P.textContent=Dl,ll=n(),K=p("ul"),K.innerHTML=ql,sl=n(),O=p("p"),O.textContent=Pl,tl=n(),ee=p("p"),ee.innerHTML=Kl,nl=n(),c(le.$$.fragment),al=n(),se=p("p"),se.innerHTML=Ol,pl=n(),c(te.$$.fragment),il=n(),ne=p("p"),ne.textContent=es,Ml=n(),ae=p("p"),ae.innerHTML=ls,cl=n(),c(pe.$$.fragment),rl=n(),ie=p("p"),ie.textContent=ss,ml=n(),c(Me.$$.fragment),ul=n(),Z=p("p"),Z.innerHTML=ts,dl=n(),c(ce.$$.fragment),yl=n(),re=p("p"),re.innerHTML=ns,fl=n(),me=p("p"),me.innerHTML=as,ol=n(),c(ue.$$.fragment),Jl=n(),j=p("p"),j.innerHTML=ps,hl=n(),de=p("p"),de.innerHTML=is,Zl=n(),c(ye.$$.fragment),jl=n(),b=p("p"),b.innerHTML=Ms,bl=n(),c(fe.$$.fragment),Tl=n(),T=p("p"),T.innerHTML=cs,wl=n(),oe=p("p"),oe.innerHTML=rs,Ul=n(),c(Je.$$.fragment),gl=n(),w=p("p"),w.innerHTML=ms,Gl=n(),he=p("p"),he.textContent=us,$l=n(),c(Ze.$$.fragment),Cl=n(),je=p("p"),je.innerHTML=ds,Vl=n(),c(be.$$.fragment),Wl=n(),U=p("blockquote"),U.innerHTML=ys,Bl=n(),c(Te.$$.fragment),xl=n(),ge=p("p"),this.h()},l(e){const l=bs("svelte-u9bgzb",document.head);o=i(l,"META",{name:!0,content:!0}),l.forEach(s),Ge=a(e),Ue=i(e,"P",{}),fs(Ue).forEach(s),$e=a(e),r(g.$$.fragment,e),Ce=a(e),r(G.$$.fragment,e),Ve=a(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1vk6gc1"&&($.innerHTML=Xl),We=a(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-8r3ka0"&&(C.textContent=kl),Be=a(e),V=i(e,"UL",{"data-svelte-h":!0}),M(V)!=="svelte-2kjv0b"&&(V.innerHTML=_l),xe=a(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1w95z1i"&&(W.textContent=Nl),ve=a(e),r(B.$$.fragment,e),Ie=a(e),x=i(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-9gtqs6"&&(x.innerHTML=Sl),Xe=a(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-ol2kg2"&&(v.innerHTML=Rl),ke=a(e),r(I.$$.fragment,e),_e=a(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-wm86y6"&&(X.textContent=El),Ne=a(e),r(k.$$.fragment,e),Se=a(e),r(_.$$.fragment,e),Re=a(e),N=i(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-d9qn7z"&&(N.innerHTML=Hl),Ee=a(e),r(S.$$.fragment,e),He=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-jl1fz0"&&(R.innerHTML=Yl),Ye=a(e),r(E.$$.fragment,e),ze=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1xlw2ku"&&(H.innerHTML=zl),Fe=a(e),r(Y.$$.fragment,e),Qe=a(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-agxldj"&&(z.textContent=Fl),Ae=a(e),r(F.$$.fragment,e),Le=a(e),h=i(e,"P",{align:!0,"data-svelte-h":!0}),M(h)!=="svelte-4ve60e"&&(h.innerHTML=Ql),De=a(e),r(Q.$$.fragment,e),qe=a(e),A=i(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1dyz9h"&&(A.innerHTML=Al),Pe=a(e),r(L.$$.fragment,e),Ke=a(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-jl1fz0"&&(D.innerHTML=Ll),Oe=a(e),r(q.$$.fragment,e),el=a(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1tggiy0"&&(P.textContent=Dl),ll=a(e),K=i(e,"UL",{"data-svelte-h":!0}),M(K)!=="svelte-11f2ngy"&&(K.innerHTML=ql),sl=a(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1xdydaq"&&(O.textContent=Pl),tl=a(e),ee=i(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-wa1ma"&&(ee.innerHTML=Kl),nl=a(e),r(le.$$.fragment,e),al=a(e),se=i(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-jl1fz0"&&(se.innerHTML=Ol),pl=a(e),r(te.$$.fragment,e),il=a(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-coc34u"&&(ne.textContent=es),Ml=a(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-3vls5z"&&(ae.innerHTML=ls),cl=a(e),r(pe.$$.fragment,e),rl=a(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-1yiz3f0"&&(ie.textContent=ss),ml=a(e),r(Me.$$.fragment,e),ul=a(e),Z=i(e,"P",{align:!0,"data-svelte-h":!0}),M(Z)!=="svelte-cbz2yl"&&(Z.innerHTML=ts),dl=a(e),r(ce.$$.fragment,e),yl=a(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-bm02vj"&&(re.innerHTML=ns),fl=a(e),me=i(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1j73k7u"&&(me.innerHTML=as),ol=a(e),r(ue.$$.fragment,e),Jl=a(e),j=i(e,"P",{align:!0,"data-svelte-h":!0}),M(j)!=="svelte-1grq2s7"&&(j.innerHTML=ps),hl=a(e),de=i(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-1b110pw"&&(de.innerHTML=is),Zl=a(e),r(ye.$$.fragment,e),jl=a(e),b=i(e,"P",{align:!0,"data-svelte-h":!0}),M(b)!=="svelte-49gzme"&&(b.innerHTML=Ms),bl=a(e),r(fe.$$.fragment,e),Tl=a(e),T=i(e,"P",{align:!0,"data-svelte-h":!0}),M(T)!=="svelte-14z2yp4"&&(T.innerHTML=cs),wl=a(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-1aoa7o4"&&(oe.innerHTML=rs),Ul=a(e),r(Je.$$.fragment,e),gl=a(e),w=i(e,"P",{align:!0,"data-svelte-h":!0}),M(w)!=="svelte-y1ydb2"&&(w.innerHTML=ms),Gl=a(e),he=i(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-ii5xbe"&&(he.textContent=us),$l=a(e),r(Ze.$$.fragment,e),Cl=a(e),je=i(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-1jzni78"&&(je.innerHTML=ds),Vl=a(e),r(be.$$.fragment,e),Wl=a(e),U=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(U)!=="svelte-gww57e"&&(U.innerHTML=ys),Bl=a(e),r(Te.$$.fragment,e),xl=a(e),ge=i(e,"P",{}),fs(ge).forEach(s),this.h()},h(){J(o,"name","hf:doc:metadata"),J(o,"content",Gs),J(h,"align","center"),J(Z,"align","center"),J(j,"align","center"),J(b,"align","center"),J(T,"align","center"),J(w,"align","center"),J(U,"class","warning")},m(e,l){Ts(document.head,o),t(e,Ge,l),t(e,Ue,l),t(e,$e,l),m(g,e,l),t(e,Ce,l),m(G,e,l),t(e,Ve,l),t(e,$,l),t(e,We,l),t(e,C,l),t(e,Be,l),t(e,V,l),t(e,xe,l),t(e,W,l),t(e,ve,l),m(B,e,l),t(e,Ie,l),t(e,x,l),t(e,Xe,l),t(e,v,l),t(e,ke,l),m(I,e,l),t(e,_e,l),t(e,X,l),t(e,Ne,l),m(k,e,l),t(e,Se,l),m(_,e,l),t(e,Re,l),t(e,N,l),t(e,Ee,l),m(S,e,l),t(e,He,l),t(e,R,l),t(e,Ye,l),m(E,e,l),t(e,ze,l),t(e,H,l),t(e,Fe,l),m(Y,e,l),t(e,Qe,l),t(e,z,l),t(e,Ae,l),m(F,e,l),t(e,Le,l),t(e,h,l),t(e,De,l),m(Q,e,l),t(e,qe,l),t(e,A,l),t(e,Pe,l),m(L,e,l),t(e,Ke,l),t(e,D,l),t(e,Oe,l),m(q,e,l),t(e,el,l),t(e,P,l),t(e,ll,l),t(e,K,l),t(e,sl,l),t(e,O,l),t(e,tl,l),t(e,ee,l),t(e,nl,l),m(le,e,l),t(e,al,l),t(e,se,l),t(e,pl,l),m(te,e,l),t(e,il,l),t(e,ne,l),t(e,Ml,l),t(e,ae,l),t(e,cl,l),m(pe,e,l),t(e,rl,l),t(e,ie,l),t(e,ml,l),m(Me,e,l),t(e,ul,l),t(e,Z,l),t(e,dl,l),m(ce,e,l),t(e,yl,l),t(e,re,l),t(e,fl,l),t(e,me,l),t(e,ol,l),m(ue,e,l),t(e,Jl,l),t(e,j,l),t(e,hl,l),t(e,de,l),t(e,Zl,l),m(ye,e,l),t(e,jl,l),t(e,b,l),t(e,bl,l),m(fe,e,l),t(e,Tl,l),t(e,T,l),t(e,wl,l),t(e,oe,l),t(e,Ul,l),m(Je,e,l),t(e,gl,l),t(e,w,l),t(e,Gl,l),t(e,he,l),t(e,$l,l),m(Ze,e,l),t(e,Cl,l),t(e,je,l),t(e,Vl,l),m(be,e,l),t(e,Wl,l),t(e,U,l),t(e,Bl,l),m(Te,e,l),t(e,xl,l),t(e,ge,l),vl=!0},p:Js,i(e){vl||(u(g.$$.fragment,e),u(G.$$.fragment,e),u(B.$$.fragment,e),u(I.$$.fragment,e),u(k.$$.fragment,e),u(_.$$.fragment,e),u(S.$$.fragment,e),u(E.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(Q.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(le.$$.fragment,e),u(te.$$.fragment,e),u(pe.$$.fragment,e),u(Me.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(fe.$$.fragment,e),u(Je.$$.fragment,e),u(Ze.$$.fragment,e),u(be.$$.fragment,e),u(Te.$$.fragment,e),vl=!0)},o(e){d(g.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(I.$$.fragment,e),d(k.$$.fragment,e),d(_.$$.fragment,e),d(S.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(le.$$.fragment,e),d(te.$$.fragment,e),d(pe.$$.fragment,e),d(Me.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(ye.$$.fragment,e),d(fe.$$.fragment,e),d(Je.$$.fragment,e),d(Ze.$$.fragment,e),d(be.$$.fragment,e),d(Te.$$.fragment,e),vl=!1},d(e){e&&(s(Ge),s(Ue),s($e),s(Ce),s(Ve),s($),s(We),s(C),s(Be),s(V),s(xe),s(W),s(ve),s(Ie),s(x),s(Xe),s(v),s(ke),s(_e),s(X),s(Ne),s(Se),s(Re),s(N),s(Ee),s(He),s(R),s(Ye),s(ze),s(H),s(Fe),s(Qe),s(z),s(Ae),s(Le),s(h),s(De),s(qe),s(A),s(Pe),s(Ke),s(D),s(Oe),s(el),s(P),s(ll),s(K),s(sl),s(O),s(tl),s(ee),s(nl),s(al),s(se),s(pl),s(il),s(ne),s(Ml),s(ae),s(cl),s(rl),s(ie),s(ml),s(ul),s(Z),s(dl),s(yl),s(re),s(fl),s(me),s(ol),s(Jl),s(j),s(hl),s(de),s(Zl),s(jl),s(b),s(bl),s(Tl),s(T),s(wl),s(oe),s(Ul),s(gl),s(w),s(Gl),s(he),s($l),s(Cl),s(je),s(Vl),s(Wl),s(U),s(Bl),s(xl),s(ge)),s(o),y(g,e),y(G,e),y(B,e),y(I,e),y(k,e),y(_,e),y(S,e),y(E,e),y(Y,e),y(F,e),y(Q,e),y(L,e),y(q,e),y(le,e),y(te,e),y(pe,e),y(Me,e),y(ce,e),y(ue,e),y(ye,e),y(fe,e),y(Je,e),y(Ze,e),y(be,e),y(Te,e)}}}const Gs='{"title":"스케줄러","local":"스케줄러","sections":[{"title":"파이프라인 불러오기","local":"파이프라인-불러오기","sections":[],"depth":2},{"title":"스케줄러 액세스","local":"스케줄러-액세스","sections":[],"depth":2},{"title":"스케줄러 교체하기","local":"스케줄러-교체하기","sections":[],"depth":2},{"title":"스케줄러들 비교해보기","local":"스케줄러들-비교해보기","sections":[],"depth":2},{"title":"Flax에서 스케줄러 교체하기","local":"flax에서-스케줄러-교체하기","sections":[],"depth":2}],"depth":1}';function $s(Il){return hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xs extends Zs{constructor(o){super(),js(this,o,$s,gs,os,{})}}export{xs as component};
