import{s as At,n as Dt,o as Pt}from"../chunks/scheduler.53228c21.js";import{S as Kt,i as Ot,e as s,s as n,c as p,h as el,a as o,d as l,b as i,f as qt,g as u,j as r,k as he,l as tl,m as a,n as c,t as d,o as m,p as f}from"../chunks/index.100fac89.js";import{C as ll}from"../chunks/CopyLLMTxtMenu.999d3d86.js";import{C as h}from"../chunks/CodeBlock.d30a6509.js";import{H as ye,E as al}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d27ae4df.js";function nl(yt){let y,Me,me,be,w,ge,_,we,T,Mt='<a href="https://hf.co/papers/2208.01618" rel="nofollow">Textual Inversion</a> is a training technique for personalizing image generation models with just a few example images of what you want it to learn. This technique works by learning and updating the text embeddings (the new embeddings are tied to a special word you must use in the prompt) to match the example images you provide.',_e,v,bt='If you’re training on a GPU with limited vRAM, you should try enabling the <code>gradient_checkpointing</code> and <code>mixed_precision</code> parameters in the training command. You can also reduce your memory footprint by using memory-efficient attention with <a href="../optimization/xformers">xFormers</a>.',Te,J,gt='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/textual_inversion/textual_inversion.py" rel="nofollow">textual_inversion.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',ve,U,wt="Before running the script, make sure you install the library from source:",Je,Z,Ue,x,_t="Navigate to the example folder with the training script and install the required dependencies for the script you’re using:",Ze,j,xe,M,Tt='<p>🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.</p>',je,$,vt="Initialize an 🤗 Accelerate environment:",$e,C,Ce,X,Jt="To setup a default 🤗 Accelerate environment without choosing any configurations:",Xe,k,ke,R,Ut="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Re,W,We,I,Zt='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Ie,b,xt='<p>The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/textual_inversion/textual_inversion.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.</p>',Ge,G,Le,L,jt='The training script has many parameters to help you tailor the training run to your needs. All of the parameters and their descriptions are listed in the <a href="https://github.com/huggingface/diffusers/blob/839c2a5ece0af4e75530cb520d77bc7ed8acf474/examples/textual_inversion/textual_inversion.py#L176" rel="nofollow"><code>parse_args()</code></a> function. Where applicable, Diffusers provides default values for each parameter such as the training batch size and learning rate, but feel free to change these values in the training command if you’d like.',Fe,F,$t="For example, to increase the number of gradient accumulation steps above the default value of 1:",Be,B,Ve,V,Ct="Some other basic and important parameters to specify include:",Ye,Y,Xt="<li><code>--pretrained_model_name_or_path</code>: the name of the model on the Hub or a local path to the pretrained model</li> <li><code>--train_data_dir</code>: path to a folder containing the training dataset (example images)</li> <li><code>--output_dir</code>: where to save the trained model</li> <li><code>--push_to_hub</code>: whether to push the trained model to the Hub</li> <li><code>--checkpointing_steps</code>: frequency of saving a checkpoint as the model trains; this is useful if for some reason training is interrupted, you can continue training from that checkpoint by adding <code>--resume_from_checkpoint</code> to your training command</li> <li><code>--num_vectors</code>: the number of vectors to learn the embeddings with; increasing this parameter helps the model learn better but it comes with increased training costs</li> <li><code>--placeholder_token</code>: the special word to tie the learned embeddings to (you must use the word in your prompt for inference)</li> <li><code>--initializer_token</code>: a single-word that roughly describes the object or style you’re trying to train on</li> <li><code>--learnable_property</code>: whether you’re training the model to learn a new “style” (for example, Van Gogh’s painting style) or “object” (for example, your dog)</li>",He,H,ze,z,kt='Unlike some of the other training scripts, textual_inversion.py has a custom dataset class, <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L487" rel="nofollow"><code>TextualInversionDataset</code></a> for creating a dataset. You can customize the image size, placeholder token, interpolation method, whether to crop the image, and more. If you need to change how the dataset is created, you can modify <code>TextualInversionDataset</code>.',Ne,N,Rt='Next, you’ll find the dataset preprocessing code and training loop in the <a href="https://github.com/huggingface/diffusers/blob/839c2a5ece0af4e75530cb520d77bc7ed8acf474/examples/textual_inversion/textual_inversion.py#L573" rel="nofollow"><code>main()</code></a> function.',Ee,E,Wt='The script starts by loading the <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L616" rel="nofollow">tokenizer</a>, <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L622" rel="nofollow">scheduler and model</a>:',Qe,Q,Se,S,It='The special <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L632" rel="nofollow">placeholder token</a> is added next to the tokenizer, and the embedding is readjusted to account for the new token.',qe,q,Gt='Then, the script <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L716" rel="nofollow">creates a dataset</a> from the <code>TextualInversionDataset</code>:',Ae,A,De,D,Lt='Finally, the <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L784" rel="nofollow">training loop</a> handles everything else from predicting the noisy residual to updating the embedding weights of the special placeholder token.',Pe,P,Ft='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',Ke,K,Oe,O,Bt="Once you’ve made all your changes or you’re okay with the default configuration, you’re ready to launch the training script! 🚀",et,ee,Vt='For this guide, you’ll download some images of a <a href="https://huggingface.co/datasets/diffusers/cat_toy_example" rel="nofollow">cat toy</a> and store them in a directory. But remember, you can create and use your own dataset if you want (see the <a href="create_dataset">Create a dataset for training</a> guide).',tt,te,lt,le,Yt="Set the environment variable <code>MODEL_NAME</code> to a model id on the Hub or a path to a local model, and <code>DATA_DIR</code>  to the path where you just downloaded the cat images to. The script creates and saves the following files to your repository:",at,ae,Ht="<li><code>learned_embeds.bin</code>: the learned embedding vectors corresponding to your example images</li> <li><code>token_identifier.txt</code>: the special placeholder token</li> <li><code>type_of_concept.txt</code>: the type of concept you’re training on (either “object” or “style”)</li>",nt,g,zt="<p>A full training run takes ~1 hour on a single V100 GPU.</p>",it,ne,Nt="One more thing before you launch the script. If you’re interested in following along with the training process, you can periodically save generated images as training progresses. Add the following parameters to the training command:",st,ie,ot,se,rt,oe,Et="After training is complete, you can use your newly trained model for inference like:",pt,re,ut,pe,ct,ue,Qt="Congratulations on training your own Textual Inversion model! 🎉 To learn more about how to use your new model, the following guides may be helpful:",dt,ce,St='<li>Learn how to <a href="../using-diffusers/textual_inversion_inference">load Textual Inversion embeddings</a> and also use them as negative embeddings.</li>',mt,de,ft,fe,ht;return w=new ll({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),_=new ye({props:{title:"Textual Inversion",local:"textual-inversion",headingTag:"h1"}}),Z=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),j=new h({props:{code:"Y2QlMjBleGFtcGxlcyUyRnRleHR1YWxfaW52ZXJzaW9uJTBBcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`<span class="hljs-built_in">cd</span> examples/textual_inversion
pip install -r requirements.txt`,wrap:!1}}),C=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),k=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),W=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),G=new ye({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),B=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRleHR1YWxfaW52ZXJzaW9uLnB5JTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0",highlighted:`accelerate launch textual_inversion.py \\
  --gradient_accumulation_steps=4`,wrap:!1}}),H=new ye({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),Q=new h({props:{code:"JTIzJTIwTG9hZCUyMHRva2VuaXplciUwQWlmJTIwYXJncy50b2tlbml6ZXJfbmFtZSUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUyMCUzRCUyMENMSVBUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGFyZ3MudG9rZW5pemVyX25hbWUpJTBBZWxpZiUyMGFyZ3MucHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0ElMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlMjAlM0QlMjBDTElQVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChhcmdzLnByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIydG9rZW5pemVyJTIyKSUwQSUwQSUyMyUyMExvYWQlMjBzY2hlZHVsZXIlMjBhbmQlMjBtb2RlbHMlMEFub2lzZV9zY2hlZHVsZXIlMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChhcmdzLnByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMENMSVBUZXh0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIlMkMlMjByZXZpc2lvbiUzRGFyZ3MucmV2aXNpb24lMEEpJTBBdmFlJTIwJTNEJTIwQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoYXJncy5wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMHN1YmZvbGRlciUzRCUyMnZhZSUyMiUyQyUyMHJldmlzaW9uJTNEYXJncy5yZXZpc2lvbiklMEF1bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwcmV2aXNpb24lM0RhcmdzLnJldmlzaW9uJTBBKQ==",highlighted:`<span class="hljs-comment"># Load tokenizer</span>
<span class="hljs-keyword">if</span> args.tokenizer_name:
    tokenizer = CLIPTokenizer.from_pretrained(args.tokenizer_name)
<span class="hljs-keyword">elif</span> args.pretrained_model_name_or_path:
    tokenizer = CLIPTokenizer.from_pretrained(args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)

<span class="hljs-comment"># Load scheduler and models</span>
noise_scheduler = DDPMScheduler.from_pretrained(args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
text_encoder = CLIPTextModel.from_pretrained(
    args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, revision=args.revision
)
vae = AutoencoderKL.from_pretrained(args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, revision=args.revision)
unet = UNet2DConditionModel.from_pretrained(
    args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, revision=args.revision
)`,wrap:!1}}),A=new h({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMFRleHR1YWxJbnZlcnNpb25EYXRhc2V0KCUwQSUyMCUyMCUyMCUyMGRhdGFfcm9vdCUzRGFyZ3MudHJhaW5fZGF0YV9kaXIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBzaXplJTNEYXJncy5yZXNvbHV0aW9uJTJDJTBBJTIwJTIwJTIwJTIwcGxhY2Vob2xkZXJfdG9rZW4lM0QoJTIyJTIwJTIyLmpvaW4odG9rZW5pemVyLmNvbnZlcnRfaWRzX3RvX3Rva2VucyhwbGFjZWhvbGRlcl90b2tlbl9pZHMpKSklMkMlMEElMjAlMjAlMjAlMjByZXBlYXRzJTNEYXJncy5yZXBlYXRzJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5hYmxlX3Byb3BlcnR5JTNEYXJncy5sZWFybmFibGVfcHJvcGVydHklMkMlMEElMjAlMjAlMjAlMjBjZW50ZXJfY3JvcCUzRGFyZ3MuY2VudGVyX2Nyb3AlMkMlMEElMjAlMjAlMjAlMjBzZXQlM0QlMjJ0cmFpbiUyMiUyQyUwQSklMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKCUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEYXJncy50cmFpbl9iYXRjaF9zaXplJTJDJTIwc2h1ZmZsZSUzRFRydWUlMkMlMjBudW1fd29ya2VycyUzRGFyZ3MuZGF0YWxvYWRlcl9udW1fd29ya2VycyUwQSk=",highlighted:`train_dataset = TextualInversionDataset(
    data_root=args.train_data_dir,
    tokenizer=tokenizer,
    size=args.resolution,
    placeholder_token=(<span class="hljs-string">&quot; &quot;</span>.join(tokenizer.convert_ids_to_tokens(placeholder_token_ids))),
    repeats=args.repeats,
    learnable_property=args.learnable_property,
    center_crop=args.center_crop,
    <span class="hljs-built_in">set</span>=<span class="hljs-string">&quot;train&quot;</span>,
)
train_dataloader = torch.utils.data.DataLoader(
    train_dataset, batch_size=args.train_batch_size, shuffle=<span class="hljs-literal">True</span>, num_workers=args.dataloader_num_workers
)`,wrap:!1}}),K=new ye({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),te=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBbG9jYWxfZGlyJTIwJTNEJTIwJTIyLiUyRmNhdCUyMiUwQXNuYXBzaG90X2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyRmNhdF90b3lfZXhhbXBsZSUyMiUyQyUyMGxvY2FsX2RpciUzRGxvY2FsX2RpciUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMjBpZ25vcmVfcGF0dGVybnMlM0QlMjIuZ2l0YXR0cmlidXRlcyUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

local_dir = <span class="hljs-string">&quot;./cat&quot;</span>
snapshot_download(
    <span class="hljs-string">&quot;diffusers/cat_toy_example&quot;</span>, local_dir=local_dir, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, ignore_patterns=<span class="hljs-string">&quot;.gitattributes&quot;</span>
)`,wrap:!1}}),ie=new h({props:{code:"LS12YWxpZGF0aW9uX3Byb21wdCUzRCUyMkElMjAlM0NjYXQtdG95JTNFJTIwdHJhaW4lMjIlMEEtLW51bV92YWxpZGF0aW9uX2ltYWdlcyUzRDQlMEEtLXZhbGlkYXRpb25fc3RlcHMlM0QxMDA=",highlighted:`--validation_prompt=<span class="hljs-string">&quot;A &lt;cat-toy&gt; train&quot;</span>
--num_validation_images=4
--validation_steps=100`,wrap:!1}}),se=new h({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWV4cG9ydCUyMERBVEFfRElSJTNEJTIyLiUyRmNhdCUyMiUwQSUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjB0ZXh0dWFsX2ludmVyc2lvbi5weSUyMCU1QyUwQSUyMCUyMC0tcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjRNT0RFTF9OQU1FJTIwJTVDJTBBJTIwJTIwLS10cmFpbl9kYXRhX2RpciUzRCUyNERBVEFfRElSJTIwJTVDJTBBJTIwJTIwLS1sZWFybmFibGVfcHJvcGVydHklM0QlMjJvYmplY3QlMjIlMjAlNUMlMEElMjAlMjAtLXBsYWNlaG9sZGVyX3Rva2VuJTNEJTIyJTNDY2F0LXRveSUzRSUyMiUyMCU1QyUwQSUyMCUyMC0taW5pdGlhbGl6ZXJfdG9rZW4lM0QlMjJ0b3klMjIlMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlNUMlMEElMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QxJTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTIwJTVDJTBBJTIwJTIwLS1tYXhfdHJhaW5fc3RlcHMlM0QzMDAwJTIwJTVDJTBBJTIwJTIwLS1sZWFybmluZ19yYXRlJTNENS4wZS0wNCUyMCU1QyUwQSUyMCUyMC0tc2NhbGVfbHIlMjAlNUMlMEElMjAlMjAtLWxyX3NjaGVkdWxlciUzRCUyMmNvbnN0YW50JTIyJTIwJTVDJTBBJTIwJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEJTIydGV4dHVhbF9pbnZlcnNpb25fY2F0JTIyJTIwJTVDJTBBJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> DATA_DIR=<span class="hljs-string">&quot;./cat&quot;</span>

accelerate launch textual_inversion.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --train_data_dir=<span class="hljs-variable">$DATA_DIR</span> \\
  --learnable_property=<span class="hljs-string">&quot;object&quot;</span> \\
  --placeholder_token=<span class="hljs-string">&quot;&lt;cat-toy&gt;&quot;</span> \\
  --initializer_token=<span class="hljs-string">&quot;toy&quot;</span> \\
  --resolution=512 \\
  --train_batch_size=1 \\
  --gradient_accumulation_steps=4 \\
  --max_train_steps=3000 \\
  --learning_rate=5.0e-04 \\
  --scale_lr \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --output_dir=<span class="hljs-string">&quot;textual_inversion_cat&quot;</span> \\
  --push_to_hub`,wrap:!1}}),re=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF90ZXh0dWFsX2ludmVyc2lvbiglMjJzZC1jb25jZXB0cy1saWJyYXJ5JTJGY2F0LXRveSUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkElMjAlM0NjYXQtdG95JTNFJTIwdHJhaW4lMjIlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC10cmFpbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)
image = pipeline(<span class="hljs-string">&quot;A &lt;cat-toy&gt; train&quot;</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-train.png&quot;</span>)`,wrap:!1}}),pe=new ye({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),de=new al({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/text_inversion.md"}}),{c(){y=s("meta"),Me=n(),me=s("p"),be=n(),p(w.$$.fragment),ge=n(),p(_.$$.fragment),we=n(),T=s("p"),T.innerHTML=Mt,_e=n(),v=s("p"),v.innerHTML=bt,Te=n(),J=s("p"),J.innerHTML=gt,ve=n(),U=s("p"),U.textContent=wt,Je=n(),p(Z.$$.fragment),Ue=n(),x=s("p"),x.textContent=_t,Ze=n(),p(j.$$.fragment),xe=n(),M=s("blockquote"),M.innerHTML=Tt,je=n(),$=s("p"),$.textContent=vt,$e=n(),p(C.$$.fragment),Ce=n(),X=s("p"),X.textContent=Jt,Xe=n(),p(k.$$.fragment),ke=n(),R=s("p"),R.textContent=Ut,Re=n(),p(W.$$.fragment),We=n(),I=s("p"),I.innerHTML=Zt,Ie=n(),b=s("blockquote"),b.innerHTML=xt,Ge=n(),p(G.$$.fragment),Le=n(),L=s("p"),L.innerHTML=jt,Fe=n(),F=s("p"),F.textContent=$t,Be=n(),p(B.$$.fragment),Ve=n(),V=s("p"),V.textContent=Ct,Ye=n(),Y=s("ul"),Y.innerHTML=Xt,He=n(),p(H.$$.fragment),ze=n(),z=s("p"),z.innerHTML=kt,Ne=n(),N=s("p"),N.innerHTML=Rt,Ee=n(),E=s("p"),E.innerHTML=Wt,Qe=n(),p(Q.$$.fragment),Se=n(),S=s("p"),S.innerHTML=It,qe=n(),q=s("p"),q.innerHTML=Gt,Ae=n(),p(A.$$.fragment),De=n(),D=s("p"),D.innerHTML=Lt,Pe=n(),P=s("p"),P.innerHTML=Ft,Ke=n(),p(K.$$.fragment),Oe=n(),O=s("p"),O.textContent=Bt,et=n(),ee=s("p"),ee.innerHTML=Vt,tt=n(),p(te.$$.fragment),lt=n(),le=s("p"),le.innerHTML=Yt,at=n(),ae=s("ul"),ae.innerHTML=Ht,nt=n(),g=s("blockquote"),g.innerHTML=zt,it=n(),ne=s("p"),ne.textContent=Nt,st=n(),p(ie.$$.fragment),ot=n(),p(se.$$.fragment),rt=n(),oe=s("p"),oe.textContent=Et,pt=n(),p(re.$$.fragment),ut=n(),p(pe.$$.fragment),ct=n(),ue=s("p"),ue.textContent=Qt,dt=n(),ce=s("ul"),ce.innerHTML=St,mt=n(),p(de.$$.fragment),ft=n(),fe=s("p"),this.h()},l(e){const t=el("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),Me=i(e),me=o(e,"P",{}),qt(me).forEach(l),be=i(e),u(w.$$.fragment,e),ge=i(e),u(_.$$.fragment,e),we=i(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-vnm0dn"&&(T.innerHTML=Mt),_e=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1ns9xvu"&&(v.innerHTML=bt),Te=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-vv5nfp"&&(J.innerHTML=gt),ve=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-l7dm2q"&&(U.textContent=wt),Je=i(e),u(Z.$$.fragment,e),Ue=i(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1nancx8"&&(x.textContent=_t),Ze=i(e),u(j.$$.fragment,e),xe=i(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1in84qc"&&(M.innerHTML=Tt),je=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-60q53m"&&($.textContent=vt),$e=i(e),u(C.$$.fragment,e),Ce=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-di6juu"&&(X.textContent=Jt),Xe=i(e),u(k.$$.fragment,e),ke=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-tsz4qp"&&(R.textContent=Ut),Re=i(e),u(W.$$.fragment,e),We=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1fkfdql"&&(I.innerHTML=Zt),Ie=i(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-upgvrc"&&(b.innerHTML=xt),Ge=i(e),u(G.$$.fragment,e),Le=i(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1mhz0qu"&&(L.innerHTML=jt),Fe=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-g9gzy9"&&(F.textContent=$t),Be=i(e),u(B.$$.fragment,e),Ve=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-tgclk5"&&(V.textContent=Ct),Ye=i(e),Y=o(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-eyv1zk"&&(Y.innerHTML=Xt),He=i(e),u(H.$$.fragment,e),ze=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-qs703o"&&(z.innerHTML=kt),Ne=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-k3h2bp"&&(N.innerHTML=Rt),Ee=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-4766ss"&&(E.innerHTML=Wt),Qe=i(e),u(Q.$$.fragment,e),Se=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-16cbi1f"&&(S.innerHTML=It),qe=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-70930c"&&(q.innerHTML=Gt),Ae=i(e),u(A.$$.fragment,e),De=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1mc4ymd"&&(D.innerHTML=Lt),Pe=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-6gmbd2"&&(P.innerHTML=Ft),Ke=i(e),u(K.$$.fragment,e),Oe=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-9dei1q"&&(O.textContent=Bt),et=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1gl7574"&&(ee.innerHTML=Vt),tt=i(e),u(te.$$.fragment,e),lt=i(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-k1bp7z"&&(le.innerHTML=Yt),at=i(e),ae=o(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-17m22mk"&&(ae.innerHTML=Ht),nt=i(e),g=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-mhhy05"&&(g.innerHTML=zt),it=i(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-iowxvh"&&(ne.textContent=Nt),st=i(e),u(ie.$$.fragment,e),ot=i(e),u(se.$$.fragment,e),rt=i(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1pqx2cy"&&(oe.textContent=Et),pt=i(e),u(re.$$.fragment,e),ut=i(e),u(pe.$$.fragment,e),ct=i(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-18p6tri"&&(ue.textContent=Qt),dt=i(e),ce=o(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-gnhmwo"&&(ce.innerHTML=St),mt=i(e),u(de.$$.fragment,e),ft=i(e),fe=o(e,"P",{}),qt(fe).forEach(l),this.h()},h(){he(y,"name","hf:doc:metadata"),he(y,"content",il),he(M,"class","tip"),he(b,"class","tip"),he(g,"class","warning")},m(e,t){tl(document.head,y),a(e,Me,t),a(e,me,t),a(e,be,t),c(w,e,t),a(e,ge,t),c(_,e,t),a(e,we,t),a(e,T,t),a(e,_e,t),a(e,v,t),a(e,Te,t),a(e,J,t),a(e,ve,t),a(e,U,t),a(e,Je,t),c(Z,e,t),a(e,Ue,t),a(e,x,t),a(e,Ze,t),c(j,e,t),a(e,xe,t),a(e,M,t),a(e,je,t),a(e,$,t),a(e,$e,t),c(C,e,t),a(e,Ce,t),a(e,X,t),a(e,Xe,t),c(k,e,t),a(e,ke,t),a(e,R,t),a(e,Re,t),c(W,e,t),a(e,We,t),a(e,I,t),a(e,Ie,t),a(e,b,t),a(e,Ge,t),c(G,e,t),a(e,Le,t),a(e,L,t),a(e,Fe,t),a(e,F,t),a(e,Be,t),c(B,e,t),a(e,Ve,t),a(e,V,t),a(e,Ye,t),a(e,Y,t),a(e,He,t),c(H,e,t),a(e,ze,t),a(e,z,t),a(e,Ne,t),a(e,N,t),a(e,Ee,t),a(e,E,t),a(e,Qe,t),c(Q,e,t),a(e,Se,t),a(e,S,t),a(e,qe,t),a(e,q,t),a(e,Ae,t),c(A,e,t),a(e,De,t),a(e,D,t),a(e,Pe,t),a(e,P,t),a(e,Ke,t),c(K,e,t),a(e,Oe,t),a(e,O,t),a(e,et,t),a(e,ee,t),a(e,tt,t),c(te,e,t),a(e,lt,t),a(e,le,t),a(e,at,t),a(e,ae,t),a(e,nt,t),a(e,g,t),a(e,it,t),a(e,ne,t),a(e,st,t),c(ie,e,t),a(e,ot,t),c(se,e,t),a(e,rt,t),a(e,oe,t),a(e,pt,t),c(re,e,t),a(e,ut,t),c(pe,e,t),a(e,ct,t),a(e,ue,t),a(e,dt,t),a(e,ce,t),a(e,mt,t),c(de,e,t),a(e,ft,t),a(e,fe,t),ht=!0},p:Dt,i(e){ht||(d(w.$$.fragment,e),d(_.$$.fragment,e),d(Z.$$.fragment,e),d(j.$$.fragment,e),d(C.$$.fragment,e),d(k.$$.fragment,e),d(W.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(H.$$.fragment,e),d(Q.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(ie.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),ht=!0)},o(e){m(w.$$.fragment,e),m(_.$$.fragment,e),m(Z.$$.fragment,e),m(j.$$.fragment,e),m(C.$$.fragment,e),m(k.$$.fragment,e),m(W.$$.fragment,e),m(G.$$.fragment,e),m(B.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(A.$$.fragment,e),m(K.$$.fragment,e),m(te.$$.fragment,e),m(ie.$$.fragment,e),m(se.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(de.$$.fragment,e),ht=!1},d(e){e&&(l(Me),l(me),l(be),l(ge),l(we),l(T),l(_e),l(v),l(Te),l(J),l(ve),l(U),l(Je),l(Ue),l(x),l(Ze),l(xe),l(M),l(je),l($),l($e),l(Ce),l(X),l(Xe),l(ke),l(R),l(Re),l(We),l(I),l(Ie),l(b),l(Ge),l(Le),l(L),l(Fe),l(F),l(Be),l(Ve),l(V),l(Ye),l(Y),l(He),l(ze),l(z),l(Ne),l(N),l(Ee),l(E),l(Qe),l(Se),l(S),l(qe),l(q),l(Ae),l(De),l(D),l(Pe),l(P),l(Ke),l(Oe),l(O),l(et),l(ee),l(tt),l(lt),l(le),l(at),l(ae),l(nt),l(g),l(it),l(ne),l(st),l(ot),l(rt),l(oe),l(pt),l(ut),l(ct),l(ue),l(dt),l(ce),l(mt),l(ft),l(fe)),l(y),f(w,e),f(_,e),f(Z,e),f(j,e),f(C,e),f(k,e),f(W,e),f(G,e),f(B,e),f(H,e),f(Q,e),f(A,e),f(K,e),f(te,e),f(ie,e),f(se,e),f(re,e),f(pe,e),f(de,e)}}}const il='{"title":"Textual Inversion","local":"textual-inversion","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function sl(yt){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends Kt{constructor(y){super(),Ot(this,y,sl,nl,At,{})}}export{dl as component};
