import{s as al,n as sl,o as pl}from"../chunks/scheduler.53228c21.js";import{S as rl,i as ol,e as s,s as n,c as o,h as cl,a as p,d as l,b as a,f as nl,g as c,j as r,k as ge,l as ml,m as i,n as m,t as d,o as u,p as M}from"../chunks/index.100fac89.js";import{C as dl}from"../chunks/CopyLLMTxtMenu.999d3d86.js";import{C as h}from"../chunks/CodeBlock.d30a6509.js";import{H as ye,E as ul}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d27ae4df.js";function Ml(Ut){let f,Te,be,Je,g,_e,T,Ue,J,jt='<a href="https://hf.co/papers/2211.09800" rel="nofollow">InstructPix2Pix</a> is a Stable Diffusion model trained to edit images from human-provided instructions. For example, your prompt can be “turn the clouds rainy” and the model will edit the input image accordingly. This model is conditioned on the text prompt (or editing instruction) and the input image.',je,_,xt='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix.py" rel="nofollow">train_instruct_pix2pix.py</a> training script to help you become familiar with it, and how you can adapt it for your own use case.',xe,U,Zt="Before running the script, make sure you install the library from source:",Ze,j,We,x,Wt="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",Ce,Z,Xe,y,Ct='<p>🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.</p>',Ie,W,Xt="Initialize an 🤗 Accelerate environment:",ve,C,$e,X,It="To setup a default 🤗 Accelerate environment without choosing any configurations:",ke,I,Be,v,vt="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Ge,$,Ne,k,$t='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Re,b,kt='<p>The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.</p>',Ve,B,Fe,G,Bt='The training script has many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L65" rel="nofollow"><code>parse_args()</code></a> function. Default values are provided for most parameters that work pretty well, but you can also set your own values in the training command if you’d like.',Ye,N,Gt="For example, to increase the resolution of the input image:",Le,R,Ae,V,Nt='Many of the basic and important parameters are described in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so this guide just focuses on the relevant parameters for InstructPix2Pix:',He,F,Rt="<li><code>--original_image_column</code>: the original image before the edits are made</li> <li><code>--edited_image_column</code>: the image after the edits are made</li> <li><code>--edit_prompt_column</code>: the instructions to edit the image</li> <li><code>--conditioning_dropout_prob</code>: the dropout probability for the edited image and edit prompts during training which enables classifier-free guidance (CFG) for one or both conditioning inputs</li>",Qe,Y,Se,L,Vt='The dataset preprocessing code and training loop are found in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L374" rel="nofollow"><code>main()</code></a> function. This is where you’ll make your changes to the training script to adapt it for your own use-case.',Ee,A,Ft='As with the script parameters, a walkthrough of the training script is provided in the <a href="text2image#training-script">Text-to-image</a> training guide. Instead, this guide takes a look at the InstructPix2Pix relevant parts of the script.',ze,H,Yt='The script begins by modifying the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L445" rel="nofollow">number of input channels</a> in the first convolutional layer of the UNet to account for InstructPix2Pix’s additional conditioning image:',Pe,Q,De,S,Lt='These UNet parameters are <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L545C1-L551C6" rel="nofollow">updated</a> by the optimizer:',qe,E,Ke,z,At='Next, the edited images and edit instructions are <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L624" rel="nofollow">preprocessed</a> and <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L610C24-L610C24" rel="nofollow">tokenized</a>. It is important the same image transformations are applied to the original and edited images.',Oe,P,et,D,Ht='Finally, in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L730" rel="nofollow">training loop</a>, it starts by encoding the edited images into latent space:',tt,q,lt,K,Qt="Then, the script applies dropout to the original image and edit instruction embeddings to support CFG. This is what enables the model to modulate the influence of the edit instruction and original image on the edited image.",it,O,nt,ee,St='That’s pretty much it! Aside from the differences described here, the rest of the script is very similar to the <a href="text2image#training-script">Text-to-image</a> training script, so feel free to check it out for more details. If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',at,te,st,le,Et="Once you’re happy with the changes to your script or if you’re okay with the default configuration, you’re ready to launch the training script! 🚀",pt,ie,zt='This guide uses the <a href="https://huggingface.co/datasets/fusing/instructpix2pix-1000-samples" rel="nofollow">fusing/instructpix2pix-1000-samples</a> dataset, which is a smaller version of the <a href="https://huggingface.co/datasets/timbrooks/instructpix2pix-clip-filtered" rel="nofollow">original dataset</a>. You can also create and use your own dataset if you’d like (see the <a href="create_dataset">Create a dataset for training</a> guide).',rt,ne,Pt="Set the <code>MODEL_NAME</code> environment variable to the name of the model (can be a model id on the Hub or a path to a local model), and the <code>DATASET_ID</code> to the name of the dataset on the Hub. The script creates and saves all the components (feature extractor, scheduler, text encoder, UNet, etc.) to a subfolder in your repository.",ot,w,Dt="<p>For better results, try longer training runs with a larger dataset. We’ve only tested this training script on a smaller-scale dataset.</p> <br/> <p>To monitor training progress with Weights and Biases, add the <code>--report_to=wandb</code> parameter to the training command and specify a validation image with <code>--val_image_url</code> and a validation prompt with <code>--validation_prompt</code>. This can be really useful for debugging the model.</p>",ct,ae,qt="If you’re training on more than one GPU, add the <code>--multi_gpu</code> parameter to the <code>accelerate launch</code> command.",mt,se,dt,pe,Kt="After training is finished, you can use your new InstructPix2Pix for inference:",ut,re,Mt,oe,Ot="You should experiment with different <code>num_inference_steps</code>, <code>image_guidance_scale</code>, and <code>guidance_scale</code> values to see how they affect inference speed and quality. The guidance scale parameters are especially impactful because they control how much the original image and edit instructions affect the edited image.",ht,ce,ft,me,el='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix_sdxl.py" rel="nofollow"><code>train_instruct_pix2pix_sdxl.py</code></a> script to train a SDXL model to follow image editing instructions.',yt,de,tl='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',bt,ue,wt,Me,ll="Congratulations on training your own InstructPix2Pix model! 🥳 To learn more about the model, it may be helpful to:",gt,he,il='<li>Read the <a href="https://huggingface.co/blog/instruction-tuning-sd" rel="nofollow">Instruction-tuning Stable Diffusion with InstructPix2Pix</a> blog post to learn more about some experiments we’ve done with InstructPix2Pix, dataset preparation, and results for different instructions.</li>',Tt,fe,Jt,we,_t;return g=new dl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new ye({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h1"}}),j=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),Z=new h({props:{code:"Y2QlMjBleGFtcGxlcyUyRmluc3RydWN0X3BpeDJwaXglMEFwaXAlMjBpbnN0YWxsJTIwLXIlMjByZXF1aXJlbWVudHMudHh0",highlighted:`<span class="hljs-built_in">cd</span> examples/instruct_pix2pix
pip install -r requirements.txt`,wrap:!1}}),C=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),I=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),$=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),B=new ye({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),R=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2luc3RydWN0X3BpeDJwaXgucHklMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlNUM=",highlighted:`accelerate launch train_instruct_pix2pix.py \\
  --resolution=512 \\`,wrap:!1}}),Y=new ye({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),Q=new h({props:{code:"aW5fY2hhbm5lbHMlMjAlM0QlMjA4JTBBb3V0X2NoYW5uZWxzJTIwJTNEJTIwdW5ldC5jb252X2luLm91dF9jaGFubmVscyUwQXVuZXQucmVnaXN0ZXJfdG9fY29uZmlnKGluX2NoYW5uZWxzJTNEaW5fY2hhbm5lbHMpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG5ld19jb252X2luJTIwJTNEJTIwbm4uQ29udjJkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5uZWxzJTJDJTIwb3V0X2NoYW5uZWxzJTJDJTIwdW5ldC5jb252X2luLmtlcm5lbF9zaXplJTJDJTIwdW5ldC5jb252X2luLnN0cmlkZSUyQyUyMHVuZXQuY29udl9pbi5wYWRkaW5nJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMG5ld19jb252X2luLndlaWdodC56ZXJvXygpJTBBJTIwJTIwJTIwJTIwbmV3X2NvbnZfaW4ud2VpZ2h0JTVCJTNBJTJDJTIwJTNBNCUyQyUyMCUzQSUyQyUyMCUzQSU1RC5jb3B5Xyh1bmV0LmNvbnZfaW4ud2VpZ2h0KSUwQSUyMCUyMCUyMCUyMHVuZXQuY29udl9pbiUyMCUzRCUyMG5ld19jb252X2lu",highlighted:`in_channels = <span class="hljs-number">8</span>
out_channels = unet.conv_in.out_channels
unet.register_to_config(in_channels=in_channels)

<span class="hljs-keyword">with</span> torch.no_grad():
    new_conv_in = nn.Conv2d(
        in_channels, out_channels, unet.conv_in.kernel_size, unet.conv_in.stride, unet.conv_in.padding
    )
    new_conv_in.weight.zero_()
    new_conv_in.weight[:, :<span class="hljs-number">4</span>, :, :].copy_(unet.conv_in.weight)
    unet.conv_in = new_conv_in`,wrap:!1}}),E=new h({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NscyglMEElMjAlMjAlMjAlMjB1bmV0LnBhcmFtZXRlcnMoKSUyQyUwQSUyMCUyMCUyMCUyMGxyJTNEYXJncy5sZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwYmV0YXMlM0QoYXJncy5hZGFtX2JldGExJTJDJTIwYXJncy5hZGFtX2JldGEyKSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRGFyZ3MuYWRhbV93ZWlnaHRfZGVjYXklMkMlMEElMjAlMjAlMjAlMjBlcHMlM0RhcmdzLmFkYW1fZXBzaWxvbiUyQyUwQSk=",highlighted:`optimizer = optimizer_cls(
    unet.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),P=new h({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBwcmVwcm9jZXNzZWRfaW1hZ2VzJTIwJTNEJTIwcHJlcHJvY2Vzc19pbWFnZXMoZXhhbXBsZXMpJTBBJTBBJTIwJTIwJTIwJTIwb3JpZ2luYWxfaW1hZ2VzJTJDJTIwZWRpdGVkX2ltYWdlcyUyMCUzRCUyMHByZXByb2Nlc3NlZF9pbWFnZXMuY2h1bmsoMiklMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZXMlMjAlM0QlMjBvcmlnaW5hbF9pbWFnZXMucmVzaGFwZSgtMSUyQyUyMDMlMkMlMjBhcmdzLnJlc29sdXRpb24lMkMlMjBhcmdzLnJlc29sdXRpb24pJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlcyUyMCUzRCUyMGVkaXRlZF9pbWFnZXMucmVzaGFwZSgtMSUyQyUyMDMlMkMlMjBhcmdzLnJlc29sdXRpb24lMkMlMjBhcmdzLnJlc29sdXRpb24pJTBBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJvcmlnaW5hbF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjBvcmlnaW5hbF9pbWFnZXMlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMmVkaXRlZF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjBlZGl0ZWRfaW1hZ2VzJTBBJTBBJTIwJTIwJTIwJTIwY2FwdGlvbnMlMjAlM0QlMjBsaXN0KGV4YW1wbGVzJTVCZWRpdF9wcm9tcHRfY29sdW1uJTVEKSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTIwJTNEJTIwdG9rZW5pemVfY2FwdGlvbnMoY2FwdGlvbnMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">examples</span>):
    preprocessed_images = preprocess_images(examples)

    original_images, edited_images = preprocessed_images.chunk(<span class="hljs-number">2</span>)
    original_images = original_images.reshape(-<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, args.resolution, args.resolution)
    edited_images = edited_images.reshape(-<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, args.resolution, args.resolution)

    examples[<span class="hljs-string">&quot;original_pixel_values&quot;</span>] = original_images
    examples[<span class="hljs-string">&quot;edited_pixel_values&quot;</span>] = edited_images

    captions = <span class="hljs-built_in">list</span>(examples[edit_prompt_column])
    examples[<span class="hljs-string">&quot;input_ids&quot;</span>] = tokenize_captions(captions)
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),q=new h({props:{code:"bGF0ZW50cyUyMCUzRCUyMHZhZS5lbmNvZGUoYmF0Y2glNUIlMjJlZGl0ZWRfcGl4ZWxfdmFsdWVzJTIyJTVELnRvKHdlaWdodF9kdHlwZSkpLmxhdGVudF9kaXN0LnNhbXBsZSgpJTBBbGF0ZW50cyUyMCUzRCUyMGxhdGVudHMlMjAqJTIwdmFlLmNvbmZpZy5zY2FsaW5nX2ZhY3Rvcg==",highlighted:`latents = vae.encode(batch[<span class="hljs-string">&quot;edited_pixel_values&quot;</span>].to(weight_dtype)).latent_dist.sample()
latents = latents * vae.config.scaling_factor`,wrap:!1}}),O=new h({props:{code:"ZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKGJhdGNoJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSU1QjAlNUQlMEFvcmlnaW5hbF9pbWFnZV9lbWJlZHMlMjAlM0QlMjB2YWUuZW5jb2RlKGJhdGNoJTVCJTIyb3JpZ2luYWxfcGl4ZWxfdmFsdWVzJTIyJTVELnRvKHdlaWdodF9kdHlwZSkpLmxhdGVudF9kaXN0Lm1vZGUoKSUwQSUwQWlmJTIwYXJncy5jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwcmFuZG9tX3AlMjAlM0QlMjB0b3JjaC5yYW5kKGJzeiUyQyUyMGRldmljZSUzRGxhdGVudHMuZGV2aWNlJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKSUwQSUyMCUyMCUyMCUyMHByb21wdF9tYXNrJTIwJTNEJTIwcmFuZG9tX3AlMjAlM0MlMjAyJTIwKiUyMGFyZ3MuY29uZGl0aW9uaW5nX2Ryb3BvdXRfcHJvYiUwQSUyMCUyMCUyMCUyMHByb21wdF9tYXNrJTIwJTNEJTIwcHJvbXB0X21hc2sucmVzaGFwZShic3olMkMlMjAxJTJDJTIwMSklMEElMjAlMjAlMjAlMjBudWxsX2NvbmRpdGlvbmluZyUyMCUzRCUyMHRleHRfZW5jb2Rlcih0b2tlbml6ZV9jYXB0aW9ucyglNUIlMjIlMjIlNUQpLnRvKGFjY2VsZXJhdG9yLmRldmljZSkpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHRvcmNoLndoZXJlKHByb21wdF9tYXNrJTJDJTIwbnVsbF9jb25kaXRpb25pbmclMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTBBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfbWFza19kdHlwZSUyMCUzRCUyMG9yaWdpbmFsX2ltYWdlX2VtYmVkcy5kdHlwZSUwQSUyMCUyMCUyMCUyMGltYWdlX21hc2slMjAlM0QlMjAxJTIwLSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAocmFuZG9tX3AlMjAlM0UlM0QlMjBhcmdzLmNvbmRpdGlvbmluZ19kcm9wb3V0X3Byb2IpLnRvKGltYWdlX21hc2tfZHR5cGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKiUyMChyYW5kb21fcCUyMCUzQyUyMDMlMjAqJTIwYXJncy5jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iKS50byhpbWFnZV9tYXNrX2R0eXBlKSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpbWFnZV9tYXNrJTIwJTNEJTIwaW1hZ2VfbWFzay5yZXNoYXBlKGJzeiUyQyUyMDElMkMlMjAxJTJDJTIwMSklMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZV9lbWJlZHMlMjAlM0QlMjBpbWFnZV9tYXNrJTIwKiUyMG9yaWdpbmFsX2ltYWdlX2VtYmVkcw==",highlighted:`encoder_hidden_states = text_encoder(batch[<span class="hljs-string">&quot;input_ids&quot;</span>])[<span class="hljs-number">0</span>]
original_image_embeds = vae.encode(batch[<span class="hljs-string">&quot;original_pixel_values&quot;</span>].to(weight_dtype)).latent_dist.mode()

<span class="hljs-keyword">if</span> args.conditioning_dropout_prob <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    random_p = torch.rand(bsz, device=latents.device, generator=generator)
    prompt_mask = random_p &lt; <span class="hljs-number">2</span> * args.conditioning_dropout_prob
    prompt_mask = prompt_mask.reshape(bsz, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
    null_conditioning = text_encoder(tokenize_captions([<span class="hljs-string">&quot;&quot;</span>]).to(accelerator.device))[<span class="hljs-number">0</span>]
    encoder_hidden_states = torch.where(prompt_mask, null_conditioning, encoder_hidden_states)

    image_mask_dtype = original_image_embeds.dtype
    image_mask = <span class="hljs-number">1</span> - (
        (random_p &gt;= args.conditioning_dropout_prob).to(image_mask_dtype)
        * (random_p &lt; <span class="hljs-number">3</span> * args.conditioning_dropout_prob).to(image_mask_dtype)
    )
    image_mask = image_mask.reshape(bsz, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
    original_image_embeds = image_mask * original_image_embeds`,wrap:!1}}),te=new ye({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),se=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMHRyYWluX2luc3RydWN0X3BpeDJwaXgucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTNEJTI0REFUQVNFVF9JRCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXNvbHV0aW9uJTNEMjU2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yYW5kb21fZmxpcCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDE1MDAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50aW5nX3N0ZXBzJTNENTAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY2hlY2twb2ludHNfdG90YWxfbGltaXQlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTNENWUtMDUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9ncmFkX25vcm0lM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iJTNEMC4wNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEZnAxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VlZCUzRDQyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> train_instruct_pix2pix.py \\
    --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
    --dataset_name=<span class="hljs-variable">$DATASET_ID</span> \\
    --enable_xformers_memory_efficient_attention \\
    --resolution=256 \\
    --random_flip \\
    --train_batch_size=4 \\
    --gradient_accumulation_steps=4 \\
    --gradient_checkpointing \\
    --max_train_steps=15000 \\
    --checkpointing_steps=5000 \\
    --checkpoints_total_limit=1 \\
    --learning_rate=5e-05 \\
    --max_grad_norm=1 \\
    --lr_warmup_steps=0 \\
    --conditioning_dropout_prob=0.05 \\
    --mixed_precision=fp16 \\
    --seed=42 \\
    --push_to_hub`,wrap:!1}}),re=new h({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyeW91cl9jb29sX21vZGVsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnRlc3RfcGl4MnBpeF80LnBuZyUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhZGQlMjBzb21lJTIwZHVja3MlMjB0byUyMHRoZSUyMGxha2UlMjIlMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwMjAlMEFpbWFnZV9ndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDEuNSUwQWd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwMTAlMEElMEFlZGl0ZWRfaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRG51bV9pbmZlcmVuY2Vfc3RlcHMlMkMlMEElMjAlMjAlMjBpbWFnZV9ndWlkYW5jZV9zY2FsZSUzRGltYWdlX2d1aWRhbmNlX3NjYWxlJTJDJTBBJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWVkaXRlZF9pbWFnZS5zYXZlKCUyMmVkaXRlZF9pbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionInstructPix2PixPipeline.from_pretrained(<span class="hljs-string">&quot;your_cool_model&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/test_pix2pix_4.png&quot;</span>)
prompt = <span class="hljs-string">&quot;add some ducks to the lake&quot;</span>
num_inference_steps = <span class="hljs-number">20</span>
image_guidance_scale = <span class="hljs-number">1.5</span>
guidance_scale = <span class="hljs-number">10</span>

edited_image = pipeline(
   prompt,
   image=image,
   num_inference_steps=num_inference_steps,
   image_guidance_scale=image_guidance_scale,
   guidance_scale=guidance_scale,
   generator=generator,
).images[<span class="hljs-number">0</span>]
edited_image.save(<span class="hljs-string">&quot;edited_image.png&quot;</span>)`,wrap:!1}}),ce=new ye({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),ue=new ye({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),fe=new ul({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/instructpix2pix.md"}}),{c(){f=s("meta"),Te=n(),be=s("p"),Je=n(),o(g.$$.fragment),_e=n(),o(T.$$.fragment),Ue=n(),J=s("p"),J.innerHTML=jt,je=n(),_=s("p"),_.innerHTML=xt,xe=n(),U=s("p"),U.textContent=Zt,Ze=n(),o(j.$$.fragment),We=n(),x=s("p"),x.textContent=Wt,Ce=n(),o(Z.$$.fragment),Xe=n(),y=s("blockquote"),y.innerHTML=Ct,Ie=n(),W=s("p"),W.textContent=Xt,ve=n(),o(C.$$.fragment),$e=n(),X=s("p"),X.textContent=It,ke=n(),o(I.$$.fragment),Be=n(),v=s("p"),v.textContent=vt,Ge=n(),o($.$$.fragment),Ne=n(),k=s("p"),k.innerHTML=$t,Re=n(),b=s("blockquote"),b.innerHTML=kt,Ve=n(),o(B.$$.fragment),Fe=n(),G=s("p"),G.innerHTML=Bt,Ye=n(),N=s("p"),N.textContent=Gt,Le=n(),o(R.$$.fragment),Ae=n(),V=s("p"),V.innerHTML=Nt,He=n(),F=s("ul"),F.innerHTML=Rt,Qe=n(),o(Y.$$.fragment),Se=n(),L=s("p"),L.innerHTML=Vt,Ee=n(),A=s("p"),A.innerHTML=Ft,ze=n(),H=s("p"),H.innerHTML=Yt,Pe=n(),o(Q.$$.fragment),De=n(),S=s("p"),S.innerHTML=Lt,qe=n(),o(E.$$.fragment),Ke=n(),z=s("p"),z.innerHTML=At,Oe=n(),o(P.$$.fragment),et=n(),D=s("p"),D.innerHTML=Ht,tt=n(),o(q.$$.fragment),lt=n(),K=s("p"),K.textContent=Qt,it=n(),o(O.$$.fragment),nt=n(),ee=s("p"),ee.innerHTML=St,at=n(),o(te.$$.fragment),st=n(),le=s("p"),le.textContent=Et,pt=n(),ie=s("p"),ie.innerHTML=zt,rt=n(),ne=s("p"),ne.innerHTML=Pt,ot=n(),w=s("blockquote"),w.innerHTML=Dt,ct=n(),ae=s("p"),ae.innerHTML=qt,mt=n(),o(se.$$.fragment),dt=n(),pe=s("p"),pe.textContent=Kt,ut=n(),o(re.$$.fragment),Mt=n(),oe=s("p"),oe.innerHTML=Ot,ht=n(),o(ce.$$.fragment),ft=n(),me=s("p"),me.innerHTML=el,yt=n(),de=s("p"),de.innerHTML=tl,bt=n(),o(ue.$$.fragment),wt=n(),Me=s("p"),Me.textContent=ll,gt=n(),he=s("ul"),he.innerHTML=il,Tt=n(),o(fe.$$.fragment),Jt=n(),we=s("p"),this.h()},l(e){const t=cl("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(l),Te=a(e),be=p(e,"P",{}),nl(be).forEach(l),Je=a(e),c(g.$$.fragment,e),_e=a(e),c(T.$$.fragment,e),Ue=a(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1wbq6mw"&&(J.innerHTML=jt),je=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-5rcc6r"&&(_.innerHTML=xt),xe=a(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-l7dm2q"&&(U.textContent=Zt),Ze=a(e),c(j.$$.fragment,e),We=a(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-z4z0b9"&&(x.textContent=Wt),Ce=a(e),c(Z.$$.fragment,e),Xe=a(e),y=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1in84qc"&&(y.innerHTML=Ct),Ie=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-60q53m"&&(W.textContent=Xt),ve=a(e),c(C.$$.fragment,e),$e=a(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-di6juu"&&(X.textContent=It),ke=a(e),c(I.$$.fragment,e),Be=a(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-tsz4qp"&&(v.textContent=vt),Ge=a(e),c($.$$.fragment,e),Ne=a(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1fkfdql"&&(k.innerHTML=$t),Re=a(e),b=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-s3rfs5"&&(b.innerHTML=kt),Ve=a(e),c(B.$$.fragment,e),Fe=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1ouxjve"&&(G.innerHTML=Bt),Ye=a(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-10dyj7s"&&(N.textContent=Gt),Le=a(e),c(R.$$.fragment,e),Ae=a(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-4ua73s"&&(V.innerHTML=Nt),He=a(e),F=p(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-xkub9r"&&(F.innerHTML=Rt),Qe=a(e),c(Y.$$.fragment,e),Se=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1opaho7"&&(L.innerHTML=Vt),Ee=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1urxowy"&&(A.innerHTML=Ft),ze=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-8vjj60"&&(H.innerHTML=Yt),Pe=a(e),c(Q.$$.fragment,e),De=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1nq4njr"&&(S.innerHTML=Lt),qe=a(e),c(E.$$.fragment,e),Ke=a(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1mob6kq"&&(z.innerHTML=At),Oe=a(e),c(P.$$.fragment,e),et=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-15k4bki"&&(D.innerHTML=Ht),tt=a(e),c(q.$$.fragment,e),lt=a(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1f46pf0"&&(K.textContent=Qt),it=a(e),c(O.$$.fragment,e),nt=a(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-rm72af"&&(ee.innerHTML=St),at=a(e),c(te.$$.fragment,e),st=a(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-191xcj8"&&(le.textContent=Et),pt=a(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1jl92wm"&&(ie.innerHTML=zt),rt=a(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1pi9kmf"&&(ne.innerHTML=Pt),ot=a(e),w=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-dv5kk9"&&(w.innerHTML=Dt),ct=a(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-mj0rx7"&&(ae.innerHTML=qt),mt=a(e),c(se.$$.fragment,e),dt=a(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-aiofgl"&&(pe.textContent=Kt),ut=a(e),c(re.$$.fragment,e),Mt=a(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-3mecu5"&&(oe.innerHTML=Ot),ht=a(e),c(ce.$$.fragment,e),ft=a(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-tzsz20"&&(me.innerHTML=el),yt=a(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-6dxtva"&&(de.innerHTML=tl),bt=a(e),c(ue.$$.fragment,e),wt=a(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-ldm0c5"&&(Me.textContent=ll),gt=a(e),he=p(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-eqz35e"&&(he.innerHTML=il),Tt=a(e),c(fe.$$.fragment,e),Jt=a(e),we=p(e,"P",{}),nl(we).forEach(l),this.h()},h(){ge(f,"name","hf:doc:metadata"),ge(f,"content",hl),ge(y,"class","tip"),ge(b,"class","tip"),ge(w,"class","tip")},m(e,t){ml(document.head,f),i(e,Te,t),i(e,be,t),i(e,Je,t),m(g,e,t),i(e,_e,t),m(T,e,t),i(e,Ue,t),i(e,J,t),i(e,je,t),i(e,_,t),i(e,xe,t),i(e,U,t),i(e,Ze,t),m(j,e,t),i(e,We,t),i(e,x,t),i(e,Ce,t),m(Z,e,t),i(e,Xe,t),i(e,y,t),i(e,Ie,t),i(e,W,t),i(e,ve,t),m(C,e,t),i(e,$e,t),i(e,X,t),i(e,ke,t),m(I,e,t),i(e,Be,t),i(e,v,t),i(e,Ge,t),m($,e,t),i(e,Ne,t),i(e,k,t),i(e,Re,t),i(e,b,t),i(e,Ve,t),m(B,e,t),i(e,Fe,t),i(e,G,t),i(e,Ye,t),i(e,N,t),i(e,Le,t),m(R,e,t),i(e,Ae,t),i(e,V,t),i(e,He,t),i(e,F,t),i(e,Qe,t),m(Y,e,t),i(e,Se,t),i(e,L,t),i(e,Ee,t),i(e,A,t),i(e,ze,t),i(e,H,t),i(e,Pe,t),m(Q,e,t),i(e,De,t),i(e,S,t),i(e,qe,t),m(E,e,t),i(e,Ke,t),i(e,z,t),i(e,Oe,t),m(P,e,t),i(e,et,t),i(e,D,t),i(e,tt,t),m(q,e,t),i(e,lt,t),i(e,K,t),i(e,it,t),m(O,e,t),i(e,nt,t),i(e,ee,t),i(e,at,t),m(te,e,t),i(e,st,t),i(e,le,t),i(e,pt,t),i(e,ie,t),i(e,rt,t),i(e,ne,t),i(e,ot,t),i(e,w,t),i(e,ct,t),i(e,ae,t),i(e,mt,t),m(se,e,t),i(e,dt,t),i(e,pe,t),i(e,ut,t),m(re,e,t),i(e,Mt,t),i(e,oe,t),i(e,ht,t),m(ce,e,t),i(e,ft,t),i(e,me,t),i(e,yt,t),i(e,de,t),i(e,bt,t),m(ue,e,t),i(e,wt,t),i(e,Me,t),i(e,gt,t),i(e,he,t),i(e,Tt,t),m(fe,e,t),i(e,Jt,t),i(e,we,t),_t=!0},p:sl,i(e){_t||(d(g.$$.fragment,e),d(T.$$.fragment,e),d(j.$$.fragment,e),d(Z.$$.fragment,e),d(C.$$.fragment,e),d(I.$$.fragment,e),d($.$$.fragment,e),d(B.$$.fragment,e),d(R.$$.fragment,e),d(Y.$$.fragment,e),d(Q.$$.fragment,e),d(E.$$.fragment,e),d(P.$$.fragment,e),d(q.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(fe.$$.fragment,e),_t=!0)},o(e){u(g.$$.fragment,e),u(T.$$.fragment,e),u(j.$$.fragment,e),u(Z.$$.fragment,e),u(C.$$.fragment,e),u(I.$$.fragment,e),u($.$$.fragment,e),u(B.$$.fragment,e),u(R.$$.fragment,e),u(Y.$$.fragment,e),u(Q.$$.fragment,e),u(E.$$.fragment,e),u(P.$$.fragment,e),u(q.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),_t=!1},d(e){e&&(l(Te),l(be),l(Je),l(_e),l(Ue),l(J),l(je),l(_),l(xe),l(U),l(Ze),l(We),l(x),l(Ce),l(Xe),l(y),l(Ie),l(W),l(ve),l($e),l(X),l(ke),l(Be),l(v),l(Ge),l(Ne),l(k),l(Re),l(b),l(Ve),l(Fe),l(G),l(Ye),l(N),l(Le),l(Ae),l(V),l(He),l(F),l(Qe),l(Se),l(L),l(Ee),l(A),l(ze),l(H),l(Pe),l(De),l(S),l(qe),l(Ke),l(z),l(Oe),l(et),l(D),l(tt),l(lt),l(K),l(it),l(nt),l(ee),l(at),l(st),l(le),l(pt),l(ie),l(rt),l(ne),l(ot),l(w),l(ct),l(ae),l(mt),l(dt),l(pe),l(ut),l(Mt),l(oe),l(ht),l(ft),l(me),l(yt),l(de),l(bt),l(wt),l(Me),l(gt),l(he),l(Tt),l(Jt),l(we)),l(f),M(g,e),M(T,e),M(j,e),M(Z,e),M(C,e),M(I,e),M($,e),M(B,e),M(R,e),M(Y,e),M(Q,e),M(E,e),M(P,e),M(q,e),M(O,e),M(te,e),M(se,e),M(re,e),M(ce,e),M(ue,e),M(fe,e)}}}const hl='{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function fl(Ut){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jl extends rl{constructor(f){super(),ol(this,f,fl,Ml,al,{})}}export{Jl as component};
