import{s as be,n as Ue,o as ke}from"../chunks/scheduler.53228c21.js";import{S as _e,i as Ie,e as n,s as a,c as o,h as Be,a as p,d as s,b as i,f as he,g as r,j as c,k as Te,l as Ce,m as t,n as M,t as u,o as d,p as f}from"../chunks/index.100fac89.js";import{C as $e}from"../chunks/CopyLLMTxtMenu.999d3d86.js";import{C as pe}from"../chunks/CodeBlock.d30a6509.js";import{H as oe,E as Ae}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d27ae4df.js";function ve(re){let m,g,Z,H,y,q,j,x,w,ce='<a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks">LoopSequentialPipelineBlocks</a> are a multi-block type that composes other <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> together in a loop. Data flows circularly, using <code>inputs</code> and <code>intermediate_outputs</code>, and each block is run iteratively. This is typically used to create a denoising loop which is iterative by default.',R,J,Me='This guide shows you how to create <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks">LoopSequentialPipelineBlocks</a>.',E,h,P,T,ue='<a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks">LoopSequentialPipelineBlocks</a>, is also known as the <em>loop wrapper</em> because it defines the loop structure, iteration variables, and configuration. Within the loop wrapper, you need the following variables.',Q,b,de='<li><code>loop_inputs</code> are user provided values and equivalent to <code>inputs</code>.</li> <li><code>loop_intermediate_outputs</code> are new intermediate variables created by the block and added to the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>. It is equivalent to <code>intermediate_outputs</code>.</li> <li><code>__call__</code> method defines the loop structure and iteration logic.</li>',V,U,N,k,fe="The loop wrapper can pass additional arguments, like current iteration index, to the loop blocks.",W,_,z,I,me='A loop block is a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a>, but the <code>__call__</code> method behaves differently.',F,B,ye='<li>It recieves the iteration variable from the loop wrapper.</li> <li>It works directly with the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a> instead of the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.PipelineState">PipelineState</a>.</li> <li>It doesn’t require retrieving or updating the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a>.</li>',K,C,je='Loop blocks share the same <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_states#diffusers.modular_pipelines.BlockState">BlockState</a> to allow values to accumulate and change for each iteration in the loop.',D,$,O,A,ee,v,we='Use the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks.from_blocks_dict">from_blocks_dict()</a> method to add the loop block to the loop wrapper to create <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks">LoopSequentialPipelineBlocks</a>.',le,G,se,L,Je='Add more loop blocks to run within each iteration with <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.modular_pipelines.LoopSequentialPipelineBlocks.from_blocks_dict">from_blocks_dict()</a>. This allows you to modify the blocks without changing the loop logic itself.',te,S,ae,X,ie,Y,ne;return y=new $e({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new oe({props:{title:"LoopSequentialPipelineBlocks",local:"loopsequentialpipelineblocks",headingTag:"h1"}}),h=new oe({props:{title:"Loop wrapper",local:"loop-wrapper",headingTag:"h2"}}),U=new pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwTG9vcFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyUyQyUyME1vZHVsYXJQaXBlbGluZUJsb2NrcyUyQyUyMElucHV0UGFyYW0lMkMlMjBPdXRwdXRQYXJhbSUwQSUwQWNsYXNzJTIwTG9vcFdyYXBwZXIoTG9vcFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTIwJTNEJTIwJTIydGVzdCUyMiUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwZGVzY3JpcHRpb24oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJJJ20lMjBhJTIwbG9vcCEhJTIyJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBsb29wX2lucHV0cyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QklucHV0UGFyYW0obmFtZSUzRCUyMm51bV9zdGVwcyUyMiklNUQlMEElMjAlMjAlMjAlMjAlNDB0b3JjaC5ub19ncmFkKCklMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwY29tcG9uZW50cyUyQyUyMHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX3N0YXRlJTIwJTNEJTIwc2VsZi5nZXRfYmxvY2tfc3RhdGUoc3RhdGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTG9vcCUyMHN0cnVjdHVyZSUyMC0lMjBjYW4lMjBiZSUyMGN1c3RvbWl6ZWQlMjB0byUyMHlvdXIlMjBuZWVkcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGJsb2NrX3N0YXRlLm51bV9zdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBsb29wX3N0ZXAlMjBleGVjdXRlcyUyMGFsbCUyMHJlZ2lzdGVyZWQlMjBibG9ja3MlMjBpbiUyMHNlcXVlbmNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tcG9uZW50cyUyQyUyMGJsb2NrX3N0YXRlJTIwJTNEJTIwc2VsZi5sb29wX3N0ZXAoY29tcG9uZW50cyUyQyUyMGJsb2NrX3N0YXRlJTJDJTIwaSUzRGkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5zZXRfYmxvY2tfc3RhdGUoc3RhdGUlMkMlMjBibG9ja19zdGF0ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBjb21wb25lbnRzJTJDJTIwc3RhdGU=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> LoopSequentialPipelineBlocks, ModularPipelineBlocks, InputParam, OutputParam

<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopWrapper</span>(<span class="hljs-title class_ inherited__">LoopSequentialPipelineBlocks</span>):
    model_name = <span class="hljs-string">&quot;test&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;I&#x27;m a loop!!&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">loop_inputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> [InputParam(name=<span class="hljs-string">&quot;num_steps&quot;</span>)]
<span class="hljs-meta">    @torch.no_grad()</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
        block_state = self.get_block_state(state)
        <span class="hljs-comment"># Loop structure - can be customized to your needs</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(block_state.num_steps):
            <span class="hljs-comment"># loop_step executes all registered blocks in sequence</span>
            components, block_state = self.loop_step(components, block_state, i=i)
        self.set_block_state(state, block_state)
        <span class="hljs-keyword">return</span> components, state`,wrap:!1}}),_=new oe({props:{title:"Loop blocks",local:"loop-blocks",headingTag:"h2"}}),$=new pe({props:{code:"Y2xhc3MlMjBMb29wQmxvY2soTW9kdWxhclBpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMjAlM0QlMjAlMjJ0ZXN0JTIyJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBpbnB1dHMoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJJbnB1dFBhcmFtKG5hbWUlM0QlMjJ4JTIyKSU1RCUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwaW50ZXJtZWRpYXRlX291dHB1dHMoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBvdXRwdXRzJTIwcHJvZHVjZWQlMjBieSUyMHRoaXMlMjBibG9jayUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1Qk91dHB1dFBhcmFtKG5hbWUlM0QlMjJ4JTIyKSU1RCUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwZGVzY3JpcHRpb24oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJJJ20lMjBhJTIwYmxvY2slMjB1c2VkJTIwaW5zaWRlJTIwdGhlJTIwJTYwTG9vcFdyYXBwZXIlNjAlMjBjbGFzcyUyMiUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjBjb21wb25lbnRzJTJDJTIwYmxvY2tfc3RhdGUlMkMlMjBpJTNBJTIwaW50KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX3N0YXRlLnglMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwY29tcG9uZW50cyUyQyUyMGJsb2NrX3N0YXRl",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopBlock</span>(<span class="hljs-title class_ inherited__">ModularPipelineBlocks</span>):
    model_name = <span class="hljs-string">&quot;test&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> [InputParam(name=<span class="hljs-string">&quot;x&quot;</span>)]
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">intermediate_outputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># outputs produced by this block</span>
        <span class="hljs-keyword">return</span> [OutputParam(name=<span class="hljs-string">&quot;x&quot;</span>)]
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;I&#x27;m a block used inside the \`LoopWrapper\` class&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, block_state, i: <span class="hljs-built_in">int</span></span>):
        block_state.x += <span class="hljs-number">1</span>
        <span class="hljs-keyword">return</span> components, block_state`,wrap:!1}}),A=new oe({props:{title:"LoopSequentialPipelineBlocks",local:"loopsequentialpipelineblocks",headingTag:"h2"}}),G=new pe({props:{code:"bG9vcCUyMCUzRCUyMExvb3BXcmFwcGVyLmZyb21fYmxvY2tzX2RpY3QoJTdCJTIyYmxvY2sxJTIyJTNBJTIwTG9vcEJsb2NrJTdEKQ==",highlighted:'loop = LoopWrapper.from_blocks_dict({<span class="hljs-string">&quot;block1&quot;</span>: LoopBlock})',wrap:!1}}),S=new pe({props:{code:"bG9vcCUyMCUzRCUyMExvb3BXcmFwcGVyLmZyb21fYmxvY2tzX2RpY3QoJTdCJTIyYmxvY2sxJTIyJTNBJTIwTG9vcEJsb2NrKCklMkMlMjAlMjJibG9jazIlMjIlM0ElMjBMb29wQmxvY2slN0Qp",highlighted:'loop = LoopWrapper.from_blocks_dict({<span class="hljs-string">&quot;block1&quot;</span>: LoopBlock(), <span class="hljs-string">&quot;block2&quot;</span>: LoopBlock})',wrap:!1}}),X=new Ae({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/loop_sequential_pipeline_blocks.md"}}),{c(){m=n("meta"),g=a(),Z=n("p"),H=a(),o(y.$$.fragment),q=a(),o(j.$$.fragment),x=a(),w=n("p"),w.innerHTML=ce,R=a(),J=n("p"),J.innerHTML=Me,E=a(),o(h.$$.fragment),P=a(),T=n("p"),T.innerHTML=ue,Q=a(),b=n("ul"),b.innerHTML=de,V=a(),o(U.$$.fragment),N=a(),k=n("p"),k.textContent=fe,W=a(),o(_.$$.fragment),z=a(),I=n("p"),I.innerHTML=me,F=a(),B=n("ul"),B.innerHTML=ye,K=a(),C=n("p"),C.innerHTML=je,D=a(),o($.$$.fragment),O=a(),o(A.$$.fragment),ee=a(),v=n("p"),v.innerHTML=we,le=a(),o(G.$$.fragment),se=a(),L=n("p"),L.innerHTML=Je,te=a(),o(S.$$.fragment),ae=a(),o(X.$$.fragment),ie=a(),Y=n("p"),this.h()},l(e){const l=Be("svelte-u9bgzb",document.head);m=p(l,"META",{name:!0,content:!0}),l.forEach(s),g=i(e),Z=p(e,"P",{}),he(Z).forEach(s),H=i(e),r(y.$$.fragment,e),q=i(e),r(j.$$.fragment,e),x=i(e),w=p(e,"P",{"data-svelte-h":!0}),c(w)!=="svelte-d1er6r"&&(w.innerHTML=ce),R=i(e),J=p(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-1wqgw9f"&&(J.innerHTML=Me),E=i(e),r(h.$$.fragment,e),P=i(e),T=p(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1si1dnb"&&(T.innerHTML=ue),Q=i(e),b=p(e,"UL",{"data-svelte-h":!0}),c(b)!=="svelte-1qqrzhm"&&(b.innerHTML=de),V=i(e),r(U.$$.fragment,e),N=i(e),k=p(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-ldw13v"&&(k.textContent=fe),W=i(e),r(_.$$.fragment,e),z=i(e),I=p(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-joy4ry"&&(I.innerHTML=me),F=i(e),B=p(e,"UL",{"data-svelte-h":!0}),c(B)!=="svelte-gibq50"&&(B.innerHTML=ye),K=i(e),C=p(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-nmx27c"&&(C.innerHTML=je),D=i(e),r($.$$.fragment,e),O=i(e),r(A.$$.fragment,e),ee=i(e),v=p(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-urqqyp"&&(v.innerHTML=we),le=i(e),r(G.$$.fragment,e),se=i(e),L=p(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-b9s2t6"&&(L.innerHTML=Je),te=i(e),r(S.$$.fragment,e),ae=i(e),r(X.$$.fragment,e),ie=i(e),Y=p(e,"P",{}),he(Y).forEach(s),this.h()},h(){Te(m,"name","hf:doc:metadata"),Te(m,"content",Ge)},m(e,l){Ce(document.head,m),t(e,g,l),t(e,Z,l),t(e,H,l),M(y,e,l),t(e,q,l),M(j,e,l),t(e,x,l),t(e,w,l),t(e,R,l),t(e,J,l),t(e,E,l),M(h,e,l),t(e,P,l),t(e,T,l),t(e,Q,l),t(e,b,l),t(e,V,l),M(U,e,l),t(e,N,l),t(e,k,l),t(e,W,l),M(_,e,l),t(e,z,l),t(e,I,l),t(e,F,l),t(e,B,l),t(e,K,l),t(e,C,l),t(e,D,l),M($,e,l),t(e,O,l),M(A,e,l),t(e,ee,l),t(e,v,l),t(e,le,l),M(G,e,l),t(e,se,l),t(e,L,l),t(e,te,l),M(S,e,l),t(e,ae,l),M(X,e,l),t(e,ie,l),t(e,Y,l),ne=!0},p:Ue,i(e){ne||(u(y.$$.fragment,e),u(j.$$.fragment,e),u(h.$$.fragment,e),u(U.$$.fragment,e),u(_.$$.fragment,e),u($.$$.fragment,e),u(A.$$.fragment,e),u(G.$$.fragment,e),u(S.$$.fragment,e),u(X.$$.fragment,e),ne=!0)},o(e){d(y.$$.fragment,e),d(j.$$.fragment,e),d(h.$$.fragment,e),d(U.$$.fragment,e),d(_.$$.fragment,e),d($.$$.fragment,e),d(A.$$.fragment,e),d(G.$$.fragment,e),d(S.$$.fragment,e),d(X.$$.fragment,e),ne=!1},d(e){e&&(s(g),s(Z),s(H),s(q),s(x),s(w),s(R),s(J),s(E),s(P),s(T),s(Q),s(b),s(V),s(N),s(k),s(W),s(z),s(I),s(F),s(B),s(K),s(C),s(D),s(O),s(ee),s(v),s(le),s(se),s(L),s(te),s(ae),s(ie),s(Y)),s(m),f(y,e),f(j,e),f(h,e),f(U,e),f(_,e),f($,e),f(A,e),f(G,e),f(S,e),f(X,e)}}}const Ge='{"title":"LoopSequentialPipelineBlocks","local":"loopsequentialpipelineblocks","sections":[{"title":"Loop wrapper","local":"loop-wrapper","sections":[],"depth":2},{"title":"Loop blocks","local":"loop-blocks","sections":[],"depth":2},{"title":"LoopSequentialPipelineBlocks","local":"loopsequentialpipelineblocks","sections":[],"depth":2}],"depth":1}';function Le(re){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class He extends _e{constructor(m){super(),Ie(this,m,Le,ve,be,{})}}export{He as component};
