import{s as Rt,n as Zt,o as Qt}from"../chunks/scheduler.53228c21.js";import{S as Xt,i as es,e as r,s,c as u,h as ts,a as i,d as n,b as o,f as S,g as m,j as c,k as v,l as t,m as p,n as f,t as h,o as g,p as _}from"../chunks/index.100fac89.js";import{C as ss}from"../chunks/CopyLLMTxtMenu.999d3d86.js";import{D as b}from"../chunks/Docstring.46d0934e.js";import{H as Xe,E as os}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d27ae4df.js";function ns(wt){let y,De,$e,Me,N,Pe,H,we,k,qt='<code>DPMSolverSinglestepScheduler</code> is a single step scheduler from <a href="https://huggingface.co/papers/2206.00927" rel="nofollow">DPM-Solver: A Fast ODE Solver for Diffusion Probabilistic Model Sampling in Around 10 Steps</a> and <a href="https://huggingface.co/papers/2211.01095" rel="nofollow">DPM-Solver++: Fast Solver for Guided Sampling of Diffusion Probabilistic Models</a> by Cheng Lu, Yuhao Zhou, Fan Bao, Jianfei Chen, Chongxuan Li, and Jun Zhu.',qe,z,Ct=`DPMSolver (and the improved version DPMSolver++) is a fast dedicated high-order solver for diffusion ODEs with convergence order guarantee. Empirically, DPMSolver sampling with only 20 steps can generate high-quality
samples, and it can generate quite good samples even in 10 steps.`,Ce,F,Lt='The original implementation can be found at <a href="https://github.com/LuChengTHU/dpm-solver" rel="nofollow">LuChengTHU/dpm-solver</a>.',Le,V,Oe,A,Ot="It is recommended to set <code>solver_order</code> to 2 for guide sampling, and <code>solver_order=3</code> for unconditional sampling.",Ie,U,It=`Dynamic thresholding from <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen</a> is supported, and for pixel-space
diffusion models, you can set both <code>algorithm_type=&quot;dpmsolver++&quot;</code> and <code>thresholding=True</code> to use dynamic
thresholding. This thresholding method is unsuitable for latent-space diffusion models such as
Stable Diffusion.`,Ee,W,Ne,d,j,et,de,Et="<code>DPMSolverSinglestepScheduler</code> is a fast dedicated high-order solver for diffusion ODEs.",tt,le,Nt=`This model inherits from <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> and <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin">ConfigMixin</a>. Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.`,st,T,G,ot,ae,Ht="Add noise to the original samples according to the noise schedule at the specified timesteps.",nt,x,B,rt,pe,kt=`Convert the model output to the corresponding type the DPMSolver/DPMSolver++ algorithm needs. DPM-Solver is
designed to discretize an integral of the noise prediction model, and DPM-Solver++ is designed to discretize an
integral of the data prediction model.`,it,Y,zt=`<p>&gt; The algorithm and model type are decoupled. You can use either DPMSolver or DPMSolver++ for both
noise &gt; prediction and data prediction models.</p>`,dt,D,J,lt,ce,Ft="One step for the first-order DPMSolver (equivalent to DDIM).",at,M,K,pt,ue,Vt="Computes the solver order at each time step.",ct,P,R,ut,me,At="Find the index for a given timestep in the schedule.",mt,w,Z,ft,fe,Ut=`Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.`,ht,q,Q,gt,he,Wt="Sets the begin index for the scheduler. This function should be run from pipeline before the inference.",_t,C,X,vt,ge,jt="Sets the discrete timesteps used for the diffusion chain (to be run before inference).",St,L,ee,bt,_e,Gt=`One step for the second-order singlestep DPMSolver that computes the solution at time <code>prev_timestep</code> from the
time <code>timestep_list[-2]</code>.`,xt,O,te,yt,ve,Bt=`One step for the third-order singlestep DPMSolver that computes the solution at time <code>prev_timestep</code> from the
time <code>timestep_list[-3]</code>.`,$t,I,se,Tt,Se,Yt="One step for the singlestep DPMSolver.",Dt,E,oe,Mt,be,Jt=`Predict the sample from the previous timestep by reversing the SDE. This function propagates the sample with
the singlestep DPMSolver.`,He,ne,ke,$,re,Pt,xe,Kt="Base class for the output of a scheduler’s <code>step</code> function.",ze,ie,Fe,Te,Ve;return N=new ss({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),H=new Xe({props:{title:"DPMSolverSinglestepScheduler",local:"dpmsolversinglestepscheduler",headingTag:"h1"}}),V=new Xe({props:{title:"Tips",local:"tips",headingTag:"h2"}}),W=new Xe({props:{title:"DPMSolverSinglestepScheduler",local:"diffusers.DPMSolverSinglestepScheduler",headingTag:"h2"}}),j=new b({props:{name:"class diffusers.DPMSolverSinglestepScheduler",anchor:"diffusers.DPMSolverSinglestepScheduler",parameters:[{name:"num_train_timesteps",val:": int = 1000"},{name:"beta_start",val:": float = 0.0001"},{name:"beta_end",val:": float = 0.02"},{name:"beta_schedule",val:": typing.Literal['linear', 'scaled_linear', 'squaredcos_cap_v2'] = 'linear'"},{name:"trained_betas",val:": typing.Union[numpy.ndarray, typing.List[float], NoneType] = None"},{name:"solver_order",val:": int = 2"},{name:"prediction_type",val:": typing.Literal['epsilon', 'sample', 'v_prediction', 'flow_prediction'] = 'epsilon'"},{name:"thresholding",val:": bool = False"},{name:"dynamic_thresholding_ratio",val:": float = 0.995"},{name:"sample_max_value",val:": float = 1.0"},{name:"algorithm_type",val:": typing.Literal['dpmsolver', 'dpmsolver++', 'sde-dpmsolver++'] = 'dpmsolver++'"},{name:"solver_type",val:": typing.Literal['midpoint', 'heun'] = 'midpoint'"},{name:"lower_order_final",val:": bool = False"},{name:"use_karras_sigmas",val:": typing.Optional[bool] = False"},{name:"use_exponential_sigmas",val:": typing.Optional[bool] = False"},{name:"use_beta_sigmas",val:": typing.Optional[bool] = False"},{name:"use_flow_sigmas",val:": typing.Optional[bool] = False"},{name:"flow_shift",val:": typing.Optional[float] = 1.0"},{name:"final_sigmas_type",val:": typing.Optional[typing.Literal['zero', 'sigma_min']] = 'zero'"},{name:"lambda_min_clipped",val:": float = -inf"},{name:"variance_type",val:": typing.Optional[typing.Literal['learned', 'learned_range']] = None"},{name:"use_dynamic_shifting",val:": bool = False"},{name:"time_shift_type",val:": typing.Literal['exponential'] = 'exponential'"}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.num_train_timesteps",description:`<strong>num_train_timesteps</strong> (<code>int</code>, defaults to <code>1000</code>) &#x2014;
The number of diffusion steps to train the model.`,name:"num_train_timesteps"},{anchor:"diffusers.DPMSolverSinglestepScheduler.beta_start",description:`<strong>beta_start</strong> (<code>float</code>, defaults to <code>0.0001</code>) &#x2014;
The starting <code>beta</code> value of inference.`,name:"beta_start"},{anchor:"diffusers.DPMSolverSinglestepScheduler.beta_end",description:`<strong>beta_end</strong> (<code>float</code>, defaults to <code>0.02</code>) &#x2014;
The final <code>beta</code> value.`,name:"beta_end"},{anchor:"diffusers.DPMSolverSinglestepScheduler.beta_schedule",description:`<strong>beta_schedule</strong> (<code>&quot;linear&quot;</code>, <code>&quot;scaled_linear&quot;</code>, or <code>&quot;squaredcos_cap_v2&quot;</code>, defaults to <code>&quot;linear&quot;</code>) &#x2014;
The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
<code>linear</code>, <code>scaled_linear</code>, or <code>squaredcos_cap_v2</code>.`,name:"beta_schedule"},{anchor:"diffusers.DPMSolverSinglestepScheduler.trained_betas",description:`<strong>trained_betas</strong> (<code>np.ndarray</code> or <code>List[float]</code>, <em>optional</em>) &#x2014;
Pass an array of betas directly to the constructor to bypass <code>beta_start</code> and <code>beta_end</code>.`,name:"trained_betas"},{anchor:"diffusers.DPMSolverSinglestepScheduler.solver_order",description:`<strong>solver_order</strong> (<code>int</code>, defaults to <code>2</code>) &#x2014;
The DPMSolver order which can be <code>1</code> or <code>2</code> or <code>3</code>. It is recommended to use <code>solver_order=2</code> for guided
sampling, and <code>solver_order=3</code> for unconditional sampling.`,name:"solver_order"},{anchor:"diffusers.DPMSolverSinglestepScheduler.prediction_type",description:`<strong>prediction_type</strong> (<code>&quot;epsilon&quot;</code>, <code>&quot;sample&quot;</code>, <code>&quot;v_prediction&quot;</code>, or <code>&quot;flow_prediction&quot;</code>, defaults to <code>&quot;epsilon&quot;</code>) &#x2014;
Prediction type of the scheduler function; can be <code>epsilon</code> (predicts the noise of the diffusion process),
<code>sample</code> (directly predicts the noisy sample<code>), </code>v_prediction<code>(see section 2.4 of [Imagen Video](https://huggingface.co/papers/2210.02303) paper), or</code>flow_prediction\`.`,name:"prediction_type"},{anchor:"diffusers.DPMSolverSinglestepScheduler.thresholding",description:`<strong>thresholding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the &#x201C;dynamic thresholding&#x201D; method. This is unsuitable for latent-space diffusion models such
as Stable Diffusion.`,name:"thresholding"},{anchor:"diffusers.DPMSolverSinglestepScheduler.dynamic_thresholding_ratio",description:`<strong>dynamic_thresholding_ratio</strong> (<code>float</code>, defaults to <code>0.995</code>) &#x2014;
The ratio for the dynamic thresholding method. Valid only when <code>thresholding=True</code>.`,name:"dynamic_thresholding_ratio"},{anchor:"diffusers.DPMSolverSinglestepScheduler.sample_max_value",description:`<strong>sample_max_value</strong> (<code>float</code>, defaults to <code>1.0</code>) &#x2014;
The threshold value for dynamic thresholding. Valid only when <code>thresholding=True</code> and
<code>algorithm_type=&quot;dpmsolver++&quot;</code>.`,name:"sample_max_value"},{anchor:"diffusers.DPMSolverSinglestepScheduler.algorithm_type",description:`<strong>algorithm_type</strong> (<code>&quot;dpmsolver&quot;</code>, <code>&quot;dpmsolver++&quot;</code>, or <code>&quot;sde-dpmsolver++&quot;</code>, defaults to <code>&quot;dpmsolver++&quot;</code>) &#x2014;
Algorithm type for the solver; can be <code>dpmsolver</code>, <code>dpmsolver++</code>, or <code>sde-dpmsolver++</code>. The <code>dpmsolver</code>
type implements the algorithms in the <a href="https://huggingface.co/papers/2206.00927" rel="nofollow">DPMSolver</a> paper, and the
<code>dpmsolver++</code> type implements the algorithms in the <a href="https://huggingface.co/papers/2211.01095" rel="nofollow">DPMSolver++</a>
paper. It is recommended to use <code>dpmsolver++</code> or <code>sde-dpmsolver++</code> with <code>solver_order=2</code> for guided
sampling like in Stable Diffusion.`,name:"algorithm_type"},{anchor:"diffusers.DPMSolverSinglestepScheduler.solver_type",description:`<strong>solver_type</strong> (<code>&quot;midpoint&quot;</code> or <code>&quot;heun&quot;</code>, defaults to <code>&quot;midpoint&quot;</code>) &#x2014;
Solver type for the second-order solver; can be <code>midpoint</code> or <code>heun</code>. The solver type slightly affects the
sample quality, especially for a small number of steps. It is recommended to use <code>midpoint</code> solvers.`,name:"solver_type"},{anchor:"diffusers.DPMSolverSinglestepScheduler.lower_order_final",description:`<strong>lower_order_final</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use lower-order solvers in the final steps. Only valid for &lt; 15 inference steps. This can
stabilize the sampling of DPMSolver for steps &lt; 15, especially for steps &lt;= 10.`,name:"lower_order_final"},{anchor:"diffusers.DPMSolverSinglestepScheduler.use_karras_sigmas",description:`<strong>use_karras_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Karras sigmas for step sizes in the noise schedule during the sampling process. If <code>True</code>,
the sigmas are determined according to a sequence of noise levels {&#x3C3;i}.`,name:"use_karras_sigmas"},{anchor:"diffusers.DPMSolverSinglestepScheduler.use_exponential_sigmas",description:`<strong>use_exponential_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use exponential sigmas for step sizes in the noise schedule during the sampling process.`,name:"use_exponential_sigmas"},{anchor:"diffusers.DPMSolverSinglestepScheduler.use_beta_sigmas",description:`<strong>use_beta_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use beta sigmas for step sizes in the noise schedule during the sampling process. Refer to <a href="https://huggingface.co/papers/2407.12173" rel="nofollow">Beta
Sampling is All You Need</a> for more information.`,name:"use_beta_sigmas"},{anchor:"diffusers.DPMSolverSinglestepScheduler.use_flow_sigmas",description:`<strong>use_flow_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use flow sigmas for step sizes in the noise schedule during the sampling process.`,name:"use_flow_sigmas"},{anchor:"diffusers.DPMSolverSinglestepScheduler.flow_shift",description:`<strong>flow_shift</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
The flow shift parameter for flow-based models.`,name:"flow_shift"},{anchor:"diffusers.DPMSolverSinglestepScheduler.final_sigmas_type",description:`<strong>final_sigmas_type</strong> (<code>&quot;zero&quot;</code> or <code>&quot;sigma_min&quot;</code>, <em>optional</em>, defaults to <code>&quot;zero&quot;</code>) &#x2014;
The final <code>sigma</code> value for the noise schedule during the sampling process. If <code>&quot;sigma_min&quot;</code>, the final
sigma is the same as the last sigma in the training schedule. If <code>&quot;zero&quot;</code>, the final sigma is set to 0.`,name:"final_sigmas_type"},{anchor:"diffusers.DPMSolverSinglestepScheduler.lambda_min_clipped",description:`<strong>lambda_min_clipped</strong> (<code>float</code>, defaults to <code>-inf</code>) &#x2014;
Clipping threshold for the minimum value of <code>lambda(t)</code> for numerical stability. This is critical for the
cosine (<code>squaredcos_cap_v2</code>) noise schedule.`,name:"lambda_min_clipped"},{anchor:"diffusers.DPMSolverSinglestepScheduler.variance_type",description:`<strong>variance_type</strong> (<code>&quot;learned&quot;</code> or <code>&quot;learned_range&quot;</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;learned&quot;</code> or <code>&quot;learned_range&quot;</code> for diffusion models that predict variance. If set, the model&#x2019;s
output contains the predicted Gaussian variance.`,name:"variance_type"},{anchor:"diffusers.DPMSolverSinglestepScheduler.use_dynamic_shifting",description:`<strong>use_dynamic_shifting</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use dynamic shifting for the noise schedule.`,name:"use_dynamic_shifting"},{anchor:"diffusers.DPMSolverSinglestepScheduler.time_shift_type",description:`<strong>time_shift_type</strong> (<code>&quot;exponential&quot;</code>, defaults to <code>&quot;exponential&quot;</code>) &#x2014;
The type of time shifting to apply.`,name:"time_shift_type"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L81"}}),G=new b({props:{name:"add_noise",anchor:"diffusers.DPMSolverSinglestepScheduler.add_noise",parameters:[{name:"original_samples",val:": Tensor"},{name:"noise",val:": Tensor"},{name:"timesteps",val:": IntTensor"}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.add_noise.original_samples",description:`<strong>original_samples</strong> (<code>torch.Tensor</code>) &#x2014;
The original samples without noise.`,name:"original_samples"},{anchor:"diffusers.DPMSolverSinglestepScheduler.add_noise.noise",description:`<strong>noise</strong> (<code>torch.Tensor</code>) &#x2014;
The noise to add to the samples.`,name:"noise"},{anchor:"diffusers.DPMSolverSinglestepScheduler.add_noise.timesteps",description:`<strong>timesteps</strong> (<code>torch.IntTensor</code>) &#x2014;
The timesteps at which to add noise to the samples.`,name:"timesteps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L1255",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The noisy samples.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),B=new b({props:{name:"convert_model_output",anchor:"diffusers.DPMSolverSinglestepScheduler.convert_model_output",parameters:[{name:"model_output",val:": Tensor"},{name:"*args",val:""},{name:"sample",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.convert_model_output.model_output",description:`<strong>model_output</strong> (<code>torch.Tensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DPMSolverSinglestepScheduler.convert_model_output.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L658",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The converted model output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),J=new b({props:{name:"dpm_solver_first_order_update",anchor:"diffusers.DPMSolverSinglestepScheduler.dpm_solver_first_order_update",parameters:[{name:"model_output",val:": Tensor"},{name:"*args",val:""},{name:"sample",val:": typing.Optional[torch.Tensor] = None"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.dpm_solver_first_order_update.model_output",description:`<strong>model_output</strong> (<code>torch.Tensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DPMSolverSinglestepScheduler.dpm_solver_first_order_update.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DPMSolverSinglestepScheduler.dpm_solver_first_order_update.prev_timestep",description:`<strong>prev_timestep</strong> (<code>int</code>) &#x2014;
The previous discrete timestep in the diffusion chain.`,name:"prev_timestep"},{anchor:"diffusers.DPMSolverSinglestepScheduler.dpm_solver_first_order_update.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L754",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),K=new b({props:{name:"get_order_list",anchor:"diffusers.DPMSolverSinglestepScheduler.get_order_list",parameters:[{name:"num_inference_steps",val:": int"}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.get_order_list.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model.`,name:"num_inference_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L246",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of solver orders for each timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),R=new b({props:{name:"index_for_timestep",anchor:"diffusers.DPMSolverSinglestepScheduler.index_for_timestep",parameters:[{name:"timestep",val:": typing.Union[int, torch.Tensor]"},{name:"schedule_timesteps",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.index_for_timestep.timestep",description:`<strong>timestep</strong> (<code>int</code> or <code>torch.Tensor</code>) &#x2014;
The timestep for which to find the index.`,name:"timestep"},{anchor:"diffusers.DPMSolverSinglestepScheduler.index_for_timestep.schedule_timesteps",description:`<strong>schedule_timesteps</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The timestep schedule to search in. If <code>None</code>, uses <code>self.timesteps</code>.`,name:"schedule_timesteps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L1115",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The index of the timestep in the schedule.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),Z=new b({props:{name:"scale_model_input",anchor:"diffusers.DPMSolverSinglestepScheduler.scale_model_input",parameters:[{name:"sample",val:": Tensor"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.scale_model_input.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
The input sample.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L1239",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A scaled input sample.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Q=new b({props:{name:"set_begin_index",anchor:"diffusers.DPMSolverSinglestepScheduler.set_begin_index",parameters:[{name:"begin_index",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.set_begin_index.begin_index",description:`<strong>begin_index</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The begin index for the scheduler.`,name:"begin_index"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L313"}}),X=new b({props:{name:"set_timesteps",anchor:"diffusers.DPMSolverSinglestepScheduler.set_timesteps",parameters:[{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[str, torch.device, NoneType] = None"},{name:"mu",val:": typing.Optional[float] = None"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.set_timesteps.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model.`,name:"num_inference_steps"},{anchor:"diffusers.DPMSolverSinglestepScheduler.set_timesteps.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device to which the timesteps should be moved to. If <code>None</code>, the timesteps are not moved.`,name:"device"},{anchor:"diffusers.DPMSolverSinglestepScheduler.set_timesteps.mu",description:`<strong>mu</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The mu parameter for dynamic shifting.`,name:"mu"},{anchor:"diffusers.DPMSolverSinglestepScheduler.set_timesteps.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps used to support arbitrary spacing between timesteps. If <code>None</code>, then the default
timestep spacing strategy of equal spacing between timesteps schedule is used. If <code>timesteps</code> is
passed, <code>num_inference_steps</code> must be <code>None</code>.`,name:"timesteps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L323"}}),ee=new b({props:{name:"singlestep_dpm_solver_second_order_update",anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_second_order_update",parameters:[{name:"model_output_list",val:": typing.List[torch.Tensor]"},{name:"*args",val:""},{name:"sample",val:": typing.Optional[torch.Tensor] = None"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_second_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.Tensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_second_order_update.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current and latter discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_second_order_update.prev_timestep",description:`<strong>prev_timestep</strong> (<code>int</code>) &#x2014;
The previous discrete timestep in the diffusion chain.`,name:"prev_timestep"},{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_second_order_update.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L818",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),te=new b({props:{name:"singlestep_dpm_solver_third_order_update",anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_third_order_update",parameters:[{name:"model_output_list",val:": typing.List[torch.Tensor]"},{name:"*args",val:""},{name:"sample",val:": typing.Optional[torch.Tensor] = None"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_third_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.Tensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_third_order_update.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current and latter discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_third_order_update.prev_timestep",description:`<strong>prev_timestep</strong> (<code>int</code>) &#x2014;
The previous discrete timestep in the diffusion chain.`,name:"prev_timestep"},{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_third_order_update.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L929",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),se=new b({props:{name:"singlestep_dpm_solver_update",anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_update",parameters:[{name:"model_output_list",val:": typing.List[torch.Tensor]"},{name:"*args",val:""},{name:"sample",val:": typing.Optional[torch.Tensor] = None"},{name:"order",val:": typing.Optional[int] = None"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.Tensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_update.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current and latter discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_update.prev_timestep",description:`<strong>prev_timestep</strong> (<code>int</code>) &#x2014;
The previous discrete timestep in the diffusion chain.`,name:"prev_timestep"},{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_update.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by diffusion process.`,name:"sample"},{anchor:"diffusers.DPMSolverSinglestepScheduler.singlestep_dpm_solver_update.order",description:`<strong>order</strong> (<code>int</code>) &#x2014;
The solver order at this step.`,name:"order"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L1051",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),oe=new b({props:{name:"step",anchor:"diffusers.DPMSolverSinglestepScheduler.step",parameters:[{name:"model_output",val:": Tensor"},{name:"timestep",val:": typing.Union[int, torch.Tensor]"},{name:"sample",val:": Tensor"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.DPMSolverSinglestepScheduler.step.model_output",description:`<strong>model_output</strong> (<code>torch.Tensor</code>) &#x2014;
The direct output from learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DPMSolverSinglestepScheduler.step.timestep",description:`<strong>timestep</strong> (<code>int</code> or <code>torch.Tensor</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DPMSolverSinglestepScheduler.step.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.DPMSolverSinglestepScheduler.step.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A random number generator for stochastic sampling.`,name:"generator"},{anchor:"diffusers.DPMSolverSinglestepScheduler.step.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput">SchedulerOutput</a> or <code>tuple</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_singlestep.py#L1166",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If return_dict is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> is returned, otherwise a
tuple is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> or <code>tuple</code></p>
`}}),ne=new Xe({props:{title:"SchedulerOutput",local:"diffusers.schedulers.scheduling_utils.SchedulerOutput",headingTag:"h2"}}),re=new b({props:{name:"class diffusers.schedulers.scheduling_utils.SchedulerOutput",anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput",parameters:[{name:"prev_sample",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput.prev_sample",description:`<strong>prev_sample</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
Computed sample <code>(x_{t-1})</code> of previous timestep. <code>prev_sample</code> should be used as next model input in the
denoising loop.`,name:"prev_sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_utils.py#L62"}}),ie=new os({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/singlestep_dpm_solver.md"}}),{c(){y=r("meta"),De=s(),$e=r("p"),Me=s(),u(N.$$.fragment),Pe=s(),u(H.$$.fragment),we=s(),k=r("p"),k.innerHTML=qt,qe=s(),z=r("p"),z.textContent=Ct,Ce=s(),F=r("p"),F.innerHTML=Lt,Le=s(),u(V.$$.fragment),Oe=s(),A=r("p"),A.innerHTML=Ot,Ie=s(),U=r("p"),U.innerHTML=It,Ee=s(),u(W.$$.fragment),Ne=s(),d=r("div"),u(j.$$.fragment),et=s(),de=r("p"),de.innerHTML=Et,tt=s(),le=r("p"),le.innerHTML=Nt,st=s(),T=r("div"),u(G.$$.fragment),ot=s(),ae=r("p"),ae.textContent=Ht,nt=s(),x=r("div"),u(B.$$.fragment),rt=s(),pe=r("p"),pe.textContent=kt,it=s(),Y=r("blockquote"),Y.innerHTML=zt,dt=s(),D=r("div"),u(J.$$.fragment),lt=s(),ce=r("p"),ce.textContent=Ft,at=s(),M=r("div"),u(K.$$.fragment),pt=s(),ue=r("p"),ue.textContent=Vt,ct=s(),P=r("div"),u(R.$$.fragment),ut=s(),me=r("p"),me.textContent=At,mt=s(),w=r("div"),u(Z.$$.fragment),ft=s(),fe=r("p"),fe.textContent=Ut,ht=s(),q=r("div"),u(Q.$$.fragment),gt=s(),he=r("p"),he.textContent=Wt,_t=s(),C=r("div"),u(X.$$.fragment),vt=s(),ge=r("p"),ge.textContent=jt,St=s(),L=r("div"),u(ee.$$.fragment),bt=s(),_e=r("p"),_e.innerHTML=Gt,xt=s(),O=r("div"),u(te.$$.fragment),yt=s(),ve=r("p"),ve.innerHTML=Bt,$t=s(),I=r("div"),u(se.$$.fragment),Tt=s(),Se=r("p"),Se.textContent=Yt,Dt=s(),E=r("div"),u(oe.$$.fragment),Mt=s(),be=r("p"),be.textContent=Jt,He=s(),u(ne.$$.fragment),ke=s(),$=r("div"),u(re.$$.fragment),Pt=s(),xe=r("p"),xe.innerHTML=Kt,ze=s(),u(ie.$$.fragment),Fe=s(),Te=r("p"),this.h()},l(e){const l=ts("svelte-u9bgzb",document.head);y=i(l,"META",{name:!0,content:!0}),l.forEach(n),De=o(e),$e=i(e,"P",{}),S($e).forEach(n),Me=o(e),m(N.$$.fragment,e),Pe=o(e),m(H.$$.fragment,e),we=o(e),k=i(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-zw7rt6"&&(k.innerHTML=qt),qe=o(e),z=i(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-l6rv24"&&(z.textContent=Ct),Ce=o(e),F=i(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1mk5p6f"&&(F.innerHTML=Lt),Le=o(e),m(V.$$.fragment,e),Oe=o(e),A=i(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-pt2glg"&&(A.innerHTML=Ot),Ie=o(e),U=i(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-18sd27c"&&(U.innerHTML=It),Ee=o(e),m(W.$$.fragment,e),Ne=o(e),d=i(e,"DIV",{class:!0});var a=S(d);m(j.$$.fragment,a),et=o(a),de=i(a,"P",{"data-svelte-h":!0}),c(de)!=="svelte-1g2jbmp"&&(de.innerHTML=Et),tt=o(a),le=i(a,"P",{"data-svelte-h":!0}),c(le)!=="svelte-linuuh"&&(le.innerHTML=Nt),st=o(a),T=i(a,"DIV",{class:!0});var Ae=S(T);m(G.$$.fragment,Ae),ot=o(Ae),ae=i(Ae,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-rz9b5o"&&(ae.textContent=Ht),Ae.forEach(n),nt=o(a),x=i(a,"DIV",{class:!0});var ye=S(x);m(B.$$.fragment,ye),rt=o(ye),pe=i(ye,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1st02i8"&&(pe.textContent=kt),it=o(ye),Y=i(ye,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(Y)!=="svelte-lwd2ft"&&(Y.innerHTML=zt),ye.forEach(n),dt=o(a),D=i(a,"DIV",{class:!0});var Ue=S(D);m(J.$$.fragment,Ue),lt=o(Ue),ce=i(Ue,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-4nw43d"&&(ce.textContent=Ft),Ue.forEach(n),at=o(a),M=i(a,"DIV",{class:!0});var We=S(M);m(K.$$.fragment,We),pt=o(We),ue=i(We,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-13tpuy9"&&(ue.textContent=Vt),We.forEach(n),ct=o(a),P=i(a,"DIV",{class:!0});var je=S(P);m(R.$$.fragment,je),ut=o(je),me=i(je,"P",{"data-svelte-h":!0}),c(me)!=="svelte-1c8f4j7"&&(me.textContent=At),je.forEach(n),mt=o(a),w=i(a,"DIV",{class:!0});var Ge=S(w);m(Z.$$.fragment,Ge),ft=o(Ge),fe=i(Ge,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-1rkfgpx"&&(fe.textContent=Ut),Ge.forEach(n),ht=o(a),q=i(a,"DIV",{class:!0});var Be=S(q);m(Q.$$.fragment,Be),gt=o(Be),he=i(Be,"P",{"data-svelte-h":!0}),c(he)!=="svelte-1k141rk"&&(he.textContent=Wt),Be.forEach(n),_t=o(a),C=i(a,"DIV",{class:!0});var Ye=S(C);m(X.$$.fragment,Ye),vt=o(Ye),ge=i(Ye,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1vzm9q"&&(ge.textContent=jt),Ye.forEach(n),St=o(a),L=i(a,"DIV",{class:!0});var Je=S(L);m(ee.$$.fragment,Je),bt=o(Je),_e=i(Je,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-1rmndna"&&(_e.innerHTML=Gt),Je.forEach(n),xt=o(a),O=i(a,"DIV",{class:!0});var Ke=S(O);m(te.$$.fragment,Ke),yt=o(Ke),ve=i(Ke,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-17kajtk"&&(ve.innerHTML=Bt),Ke.forEach(n),$t=o(a),I=i(a,"DIV",{class:!0});var Re=S(I);m(se.$$.fragment,Re),Tt=o(Re),Se=i(Re,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-zgpbva"&&(Se.textContent=Yt),Re.forEach(n),Dt=o(a),E=i(a,"DIV",{class:!0});var Ze=S(E);m(oe.$$.fragment,Ze),Mt=o(Ze),be=i(Ze,"P",{"data-svelte-h":!0}),c(be)!=="svelte-7earhm"&&(be.textContent=Jt),Ze.forEach(n),a.forEach(n),He=o(e),m(ne.$$.fragment,e),ke=o(e),$=i(e,"DIV",{class:!0});var Qe=S($);m(re.$$.fragment,Qe),Pt=o(Qe),xe=i(Qe,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-6ojmkw"&&(xe.innerHTML=Kt),Qe.forEach(n),ze=o(e),m(ie.$$.fragment,e),Fe=o(e),Te=i(e,"P",{}),S(Te).forEach(n),this.h()},h(){v(y,"name","hf:doc:metadata"),v(y,"content",rs),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","tip"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){t(document.head,y),p(e,De,l),p(e,$e,l),p(e,Me,l),f(N,e,l),p(e,Pe,l),f(H,e,l),p(e,we,l),p(e,k,l),p(e,qe,l),p(e,z,l),p(e,Ce,l),p(e,F,l),p(e,Le,l),f(V,e,l),p(e,Oe,l),p(e,A,l),p(e,Ie,l),p(e,U,l),p(e,Ee,l),f(W,e,l),p(e,Ne,l),p(e,d,l),f(j,d,null),t(d,et),t(d,de),t(d,tt),t(d,le),t(d,st),t(d,T),f(G,T,null),t(T,ot),t(T,ae),t(d,nt),t(d,x),f(B,x,null),t(x,rt),t(x,pe),t(x,it),t(x,Y),t(d,dt),t(d,D),f(J,D,null),t(D,lt),t(D,ce),t(d,at),t(d,M),f(K,M,null),t(M,pt),t(M,ue),t(d,ct),t(d,P),f(R,P,null),t(P,ut),t(P,me),t(d,mt),t(d,w),f(Z,w,null),t(w,ft),t(w,fe),t(d,ht),t(d,q),f(Q,q,null),t(q,gt),t(q,he),t(d,_t),t(d,C),f(X,C,null),t(C,vt),t(C,ge),t(d,St),t(d,L),f(ee,L,null),t(L,bt),t(L,_e),t(d,xt),t(d,O),f(te,O,null),t(O,yt),t(O,ve),t(d,$t),t(d,I),f(se,I,null),t(I,Tt),t(I,Se),t(d,Dt),t(d,E),f(oe,E,null),t(E,Mt),t(E,be),p(e,He,l),f(ne,e,l),p(e,ke,l),p(e,$,l),f(re,$,null),t($,Pt),t($,xe),p(e,ze,l),f(ie,e,l),p(e,Fe,l),p(e,Te,l),Ve=!0},p:Zt,i(e){Ve||(h(N.$$.fragment,e),h(H.$$.fragment,e),h(V.$$.fragment,e),h(W.$$.fragment,e),h(j.$$.fragment,e),h(G.$$.fragment,e),h(B.$$.fragment,e),h(J.$$.fragment,e),h(K.$$.fragment,e),h(R.$$.fragment,e),h(Z.$$.fragment,e),h(Q.$$.fragment,e),h(X.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(ie.$$.fragment,e),Ve=!0)},o(e){g(N.$$.fragment,e),g(H.$$.fragment,e),g(V.$$.fragment,e),g(W.$$.fragment,e),g(j.$$.fragment,e),g(G.$$.fragment,e),g(B.$$.fragment,e),g(J.$$.fragment,e),g(K.$$.fragment,e),g(R.$$.fragment,e),g(Z.$$.fragment,e),g(Q.$$.fragment,e),g(X.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(re.$$.fragment,e),g(ie.$$.fragment,e),Ve=!1},d(e){e&&(n(De),n($e),n(Me),n(Pe),n(we),n(k),n(qe),n(z),n(Ce),n(F),n(Le),n(Oe),n(A),n(Ie),n(U),n(Ee),n(Ne),n(d),n(He),n(ke),n($),n(ze),n(Fe),n(Te)),n(y),_(N,e),_(H,e),_(V,e),_(W,e),_(j),_(G),_(B),_(J),_(K),_(R),_(Z),_(Q),_(X),_(ee),_(te),_(se),_(oe),_(ne,e),_(re),_(ie,e)}}}const rs='{"title":"DPMSolverSinglestepScheduler","local":"dpmsolversinglestepscheduler","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"DPMSolverSinglestepScheduler","local":"diffusers.DPMSolverSinglestepScheduler","sections":[],"depth":2},{"title":"SchedulerOutput","local":"diffusers.schedulers.scheduling_utils.SchedulerOutput","sections":[],"depth":2}],"depth":1}';function is(wt){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class us extends Xt{constructor(y){super(),es(this,y,is,ns,Rt,{})}}export{us as component};
