import{s as zt,n as Ft,o as kt}from"../chunks/scheduler.53228c21.js";import{S as Ht,i as At,e as n,s,c as u,h as Vt,a as i,d as o,b as r,f as b,g as m,j as p,k as v,l as t,m as c,n as f,t as h,o as g,p as _}from"../chunks/index.100fac89.js";import{C as Wt}from"../chunks/CopyLLMTxtMenu.999d3d86.js";import{D as S}from"../chunks/Docstring.46d0934e.js";import{H as Ge,E as Ut}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d27ae4df.js";function jt(gt){let x,be,_e,Se,I,Me,E,xe,N,_t='<code>DPMSolverMultistepScheduler</code> is a multistep scheduler from <a href="https://huggingface.co/papers/2206.00927" rel="nofollow">DPM-Solver: A Fast ODE Solver for Diffusion Probabilistic Model Sampling in Around 10 Steps</a> and <a href="https://huggingface.co/papers/2211.01095" rel="nofollow">DPM-Solver++: Fast Solver for Guided Sampling of Diffusion Probabilistic Models</a> by Cheng Lu, Yuhao Zhou, Fan Bao, Jianfei Chen, Chongxuan Li, and Jun Zhu.',ye,z,vt=`DPMSolver (and the improved version DPMSolver++) is a fast dedicated high-order solver for diffusion ODEs with convergence order guarantee. Empirically, DPMSolver sampling with only 20 steps can generate high-quality
samples, and it can generate quite good samples even in 10 steps.`,De,F,$e,k,bt="It is recommended to set <code>solver_order</code> to 2 for guide sampling, and <code>solver_order=3</code> for unconditional sampling.",Te,H,St=`Dynamic thresholding from <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen</a> is supported, and for pixel-space
diffusion models, you can set both <code>algorithm_type=&quot;dpmsolver++&quot;</code> and <code>thresholding=True</code> to use the dynamic
thresholding. This thresholding method is unsuitable for latent-space diffusion models such as
Stable Diffusion.`,Pe,A,Mt="The SDE variant of DPMSolver and DPM-Solver++ is also supported, but only for the first and second-order solvers. This is a fast SDE solver for the reverse diffusion SDE. It is recommended to use the second-order <code>sde-dpmsolver++</code>.",qe,V,we,a,W,Re,se,xt="<code>DPMSolverMultistepScheduler</code> is a fast dedicated high-order solver for diffusion ODEs.",Be,re,yt=`This model inherits from <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> and <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin">ConfigMixin</a>. Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.`,Ye,D,U,Je,ne,Dt="Add noise to the original samples according to the noise schedule at the specified timesteps.",Ke,M,j,Ze,ie,$t=`Convert the model output to the corresponding type the DPMSolver/DPMSolver++ algorithm needs. DPM-Solver is
designed to discretize an integral of the noise prediction model, and DPM-Solver++ is designed to discretize an
integral of the data prediction model.`,Qe,G,Tt=`<p>&gt; The algorithm and model type are decoupled. You can use either DPMSolver or DPMSolver++ for both
noise &gt; prediction and data prediction models.</p>`,Xe,$,R,et,de,Pt="One step for the first-order DPMSolver (equivalent to DDIM).",tt,T,B,ot,ae,qt="Find the index for a given timestep in the schedule.",st,P,Y,rt,le,wt="One step for the second-order multistep DPMSolver.",nt,q,J,it,ce,Ct="One step for the third-order multistep DPMSolver.",dt,w,K,at,pe,Lt=`Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.`,lt,C,Z,ct,ue,Ot="Sets the begin index for the scheduler. This function should be run from pipeline before the inference.",pt,L,Q,ut,me,It="Sets the discrete timesteps used for the diffusion chain (to be run before inference).",mt,O,X,ft,fe,Et=`Predict the sample from the previous timestep by reversing the SDE. This function propagates the sample with
the multistep DPMSolver.`,Ce,ee,Le,y,te,ht,he,Nt="Base class for the output of a scheduler’s <code>step</code> function.",Oe,oe,Ie,ve,Ee;return I=new Wt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),E=new Ge({props:{title:"DPMSolverMultistepScheduler",local:"dpmsolvermultistepscheduler",headingTag:"h1"}}),F=new Ge({props:{title:"Tips",local:"tips",headingTag:"h2"}}),V=new Ge({props:{title:"DPMSolverMultistepScheduler",local:"diffusers.DPMSolverMultistepScheduler",headingTag:"h2"}}),W=new S({props:{name:"class diffusers.DPMSolverMultistepScheduler",anchor:"diffusers.DPMSolverMultistepScheduler",parameters:[{name:"num_train_timesteps",val:": int = 1000"},{name:"beta_start",val:": float = 0.0001"},{name:"beta_end",val:": float = 0.02"},{name:"beta_schedule",val:": typing.Literal['linear', 'scaled_linear', 'squaredcos_cap_v2'] = 'linear'"},{name:"trained_betas",val:": typing.Union[numpy.ndarray, typing.List[float], NoneType] = None"},{name:"solver_order",val:": int = 2"},{name:"prediction_type",val:": typing.Literal['epsilon', 'sample', 'v_prediction', 'flow_prediction'] = 'epsilon'"},{name:"thresholding",val:": bool = False"},{name:"dynamic_thresholding_ratio",val:": float = 0.995"},{name:"sample_max_value",val:": float = 1.0"},{name:"algorithm_type",val:": typing.Literal['dpmsolver', 'dpmsolver++', 'sde-dpmsolver', 'sde-dpmsolver++'] = 'dpmsolver++'"},{name:"solver_type",val:": typing.Literal['midpoint', 'heun'] = 'midpoint'"},{name:"lower_order_final",val:": bool = True"},{name:"euler_at_final",val:": bool = False"},{name:"use_karras_sigmas",val:": typing.Optional[bool] = False"},{name:"use_exponential_sigmas",val:": typing.Optional[bool] = False"},{name:"use_beta_sigmas",val:": typing.Optional[bool] = False"},{name:"use_lu_lambdas",val:": typing.Optional[bool] = False"},{name:"use_flow_sigmas",val:": typing.Optional[bool] = False"},{name:"flow_shift",val:": typing.Optional[float] = 1.0"},{name:"final_sigmas_type",val:": typing.Optional[typing.Literal['zero', 'sigma_min']] = 'zero'"},{name:"lambda_min_clipped",val:": float = -inf"},{name:"variance_type",val:": typing.Optional[typing.Literal['learned', 'learned_range']] = None"},{name:"timestep_spacing",val:": typing.Literal['linspace', 'leading', 'trailing'] = 'linspace'"},{name:"steps_offset",val:": int = 0"},{name:"rescale_betas_zero_snr",val:": bool = False"},{name:"use_dynamic_shifting",val:": bool = False"},{name:"time_shift_type",val:": typing.Literal['exponential'] = 'exponential'"}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.num_train_timesteps",description:`<strong>num_train_timesteps</strong> (<code>int</code>, defaults to 1000) &#x2014;
The number of diffusion steps to train the model.`,name:"num_train_timesteps"},{anchor:"diffusers.DPMSolverMultistepScheduler.beta_start",description:`<strong>beta_start</strong> (<code>float</code>, defaults to 0.0001) &#x2014;
The starting <code>beta</code> value of inference.`,name:"beta_start"},{anchor:"diffusers.DPMSolverMultistepScheduler.beta_end",description:`<strong>beta_end</strong> (<code>float</code>, defaults to 0.02) &#x2014;
The final <code>beta</code> value.`,name:"beta_end"},{anchor:"diffusers.DPMSolverMultistepScheduler.beta_schedule",description:`<strong>beta_schedule</strong> (<code>&quot;linear&quot;</code>, <code>&quot;scaled_linear&quot;</code>, or <code>&quot;squaredcos_cap_v2&quot;</code>, defaults to <code>&quot;linear&quot;</code>) &#x2014;
The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model.`,name:"beta_schedule"},{anchor:"diffusers.DPMSolverMultistepScheduler.trained_betas",description:`<strong>trained_betas</strong> (<code>np.ndarray</code>, <em>optional</em>) &#x2014;
Pass an array of betas directly to the constructor to bypass <code>beta_start</code> and <code>beta_end</code>.`,name:"trained_betas"},{anchor:"diffusers.DPMSolverMultistepScheduler.solver_order",description:`<strong>solver_order</strong> (<code>int</code>, defaults to 2) &#x2014;
The DPMSolver order which can be <code>1</code> or <code>2</code> or <code>3</code>. It is recommended to use <code>solver_order=2</code> for guided
sampling, and <code>solver_order=3</code> for unconditional sampling.`,name:"solver_order"},{anchor:"diffusers.DPMSolverMultistepScheduler.prediction_type",description:`<strong>prediction_type</strong> (<code>&quot;epsilon&quot;</code>, <code>&quot;sample&quot;</code>, <code>&quot;v_prediction&quot;</code>, or <code>&quot;flow_prediction&quot;</code>, defaults to <code>&quot;epsilon&quot;</code>) &#x2014;
Prediction type of the scheduler function. <code>epsilon</code> predicts the noise of the diffusion process, <code>sample</code>
directly predicts the noisy sample, <code>v_prediction</code> predicts the velocity (see section 2.4 of <a href="https://huggingface.co/papers/2210.02303" rel="nofollow">Imagen
Video</a> paper), and <code>flow_prediction</code> predicts the flow.`,name:"prediction_type"},{anchor:"diffusers.DPMSolverMultistepScheduler.thresholding",description:`<strong>thresholding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the &#x201C;dynamic thresholding&#x201D; method. This is unsuitable for latent-space diffusion models such
as Stable Diffusion.`,name:"thresholding"},{anchor:"diffusers.DPMSolverMultistepScheduler.dynamic_thresholding_ratio",description:`<strong>dynamic_thresholding_ratio</strong> (<code>float</code>, defaults to 0.995) &#x2014;
The ratio for the dynamic thresholding method. Valid only when <code>thresholding=True</code>.`,name:"dynamic_thresholding_ratio"},{anchor:"diffusers.DPMSolverMultistepScheduler.sample_max_value",description:`<strong>sample_max_value</strong> (<code>float</code>, defaults to 1.0) &#x2014;
The threshold value for dynamic thresholding. Valid only when <code>thresholding=True</code> and
<code>algorithm_type=&quot;dpmsolver++&quot;</code>.`,name:"sample_max_value"},{anchor:"diffusers.DPMSolverMultistepScheduler.algorithm_type",description:`<strong>algorithm_type</strong> (<code>&quot;dpmsolver&quot;</code>, <code>&quot;dpmsolver++&quot;</code>, <code>&quot;sde-dpmsolver&quot;</code>, or <code>&quot;sde-dpmsolver++&quot;</code>, defaults to <code>&quot;dpmsolver++&quot;</code>) &#x2014;
Algorithm type for the solver. The <code>dpmsolver</code> type implements the algorithms in the
<a href="https://huggingface.co/papers/2206.00927" rel="nofollow">DPMSolver</a> paper, and the <code>dpmsolver++</code> type implements the
algorithms in the <a href="https://huggingface.co/papers/2211.01095" rel="nofollow">DPMSolver++</a> paper. It is recommended to use
<code>dpmsolver++</code> or <code>sde-dpmsolver++</code> with <code>solver_order=2</code> for guided sampling like in Stable Diffusion.`,name:"algorithm_type"},{anchor:"diffusers.DPMSolverMultistepScheduler.solver_type",description:`<strong>solver_type</strong> (<code>&quot;midpoint&quot;</code> or <code>&quot;heun&quot;</code>, defaults to <code>&quot;midpoint&quot;</code>) &#x2014;
Solver type for the second-order solver. The solver type slightly affects the sample quality, especially
for a small number of steps. It is recommended to use <code>midpoint</code> solvers.`,name:"solver_type"},{anchor:"diffusers.DPMSolverMultistepScheduler.lower_order_final",description:`<strong>lower_order_final</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use lower-order solvers in the final steps. Only valid for &lt; 15 inference steps. This can
stabilize the sampling of DPMSolver for steps &lt; 15, especially for steps &lt;= 10.`,name:"lower_order_final"},{anchor:"diffusers.DPMSolverMultistepScheduler.euler_at_final",description:`<strong>euler_at_final</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use Euler&#x2019;s method in the final step. It is a trade-off between numerical stability and detail
richness. This can stabilize the sampling of the SDE variant of DPMSolver for small number of inference
steps, but sometimes may result in blurring.`,name:"euler_at_final"},{anchor:"diffusers.DPMSolverMultistepScheduler.use_karras_sigmas",description:`<strong>use_karras_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Karras sigmas for step sizes in the noise schedule during the sampling process. If <code>True</code>,
the sigmas are determined according to a sequence of noise levels {&#x3C3;i}.`,name:"use_karras_sigmas"},{anchor:"diffusers.DPMSolverMultistepScheduler.use_exponential_sigmas",description:`<strong>use_exponential_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use exponential sigmas for step sizes in the noise schedule during the sampling process.`,name:"use_exponential_sigmas"},{anchor:"diffusers.DPMSolverMultistepScheduler.use_beta_sigmas",description:`<strong>use_beta_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use beta sigmas for step sizes in the noise schedule during the sampling process. Refer to <a href="https://huggingface.co/papers/2407.12173" rel="nofollow">Beta
Sampling is All You Need</a> for more information.`,name:"use_beta_sigmas"},{anchor:"diffusers.DPMSolverMultistepScheduler.use_lu_lambdas",description:`<strong>use_lu_lambdas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the uniform-logSNR for step sizes proposed by Lu&#x2019;s DPM-Solver in the noise schedule during
the sampling process. If <code>True</code>, the sigmas and time steps are determined according to a sequence of
<code>lambda(t)</code>.`,name:"use_lu_lambdas"},{anchor:"diffusers.DPMSolverMultistepScheduler.use_flow_sigmas",description:`<strong>use_flow_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use flow sigmas for step sizes in the noise schedule during the sampling process.`,name:"use_flow_sigmas"},{anchor:"diffusers.DPMSolverMultistepScheduler.flow_shift",description:`<strong>flow_shift</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The shift value for the timestep schedule for flow matching.`,name:"flow_shift"},{anchor:"diffusers.DPMSolverMultistepScheduler.final_sigmas_type",description:`<strong>final_sigmas_type</strong> (<code>&quot;zero&quot;</code> or <code>&quot;sigma_min&quot;</code>, <em>optional</em>, defaults to <code>&quot;zero&quot;</code>) &#x2014;
The final <code>sigma</code> value for the noise schedule during the sampling process. If <code>&quot;sigma_min&quot;</code>, the final
sigma is the same as the last sigma in the training schedule. If <code>&quot;zero&quot;</code>, the final sigma is set to 0.`,name:"final_sigmas_type"},{anchor:"diffusers.DPMSolverMultistepScheduler.lambda_min_clipped",description:`<strong>lambda_min_clipped</strong> (<code>float</code>, defaults to <code>-inf</code>) &#x2014;
Clipping threshold for the minimum value of <code>lambda(t)</code> for numerical stability. This is critical for the
cosine (<code>squaredcos_cap_v2</code>) noise schedule.`,name:"lambda_min_clipped"},{anchor:"diffusers.DPMSolverMultistepScheduler.variance_type",description:`<strong>variance_type</strong> (<code>&quot;learned&quot;</code> or <code>&quot;learned_range&quot;</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;learned&quot;</code> or <code>&quot;learned_range&quot;</code> for diffusion models that predict variance. If set, the model&#x2019;s
output contains the predicted Gaussian variance.`,name:"variance_type"},{anchor:"diffusers.DPMSolverMultistepScheduler.timestep_spacing",description:`<strong>timestep_spacing</strong> (<code>&quot;linspace&quot;</code>, <code>&quot;leading&quot;</code>, or <code>&quot;trailing&quot;</code>, defaults to <code>&quot;linspace&quot;</code>) &#x2014;
The way the timesteps should be scaled. Refer to Table 2 of the <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and
Sample Steps are Flawed</a> for more information.`,name:"timestep_spacing"},{anchor:"diffusers.DPMSolverMultistepScheduler.steps_offset",description:`<strong>steps_offset</strong> (<code>int</code>, defaults to 0) &#x2014;
An offset added to the inference steps, as required by some model families.`,name:"steps_offset"},{anchor:"diffusers.DPMSolverMultistepScheduler.rescale_betas_zero_snr",description:`<strong>rescale_betas_zero_snr</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to rescale the betas to have zero terminal SNR. This enables the model to generate very bright and
dark samples instead of limiting it to samples with medium brightness. Loosely related to
<a href="https://github.com/huggingface/diffusers/blob/74fd735eb073eb1d774b1ab4154a0876eb82f055/examples/dreambooth/train_dreambooth.py#L506" rel="nofollow"><code>--offset_noise</code></a>.`,name:"rescale_betas_zero_snr"},{anchor:"diffusers.DPMSolverMultistepScheduler.use_dynamic_shifting",description:`<strong>use_dynamic_shifting</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use dynamic shifting for the timestep schedule.`,name:"use_dynamic_shifting"},{anchor:"diffusers.DPMSolverMultistepScheduler.time_shift_type",description:`<strong>time_shift_type</strong> (<code>&quot;exponential&quot;</code>, defaults to <code>&quot;exponential&quot;</code>) &#x2014;
The type of time shift to apply when using dynamic shifting.`,name:"time_shift_type"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L116"}}),U=new S({props:{name:"add_noise",anchor:"diffusers.DPMSolverMultistepScheduler.add_noise",parameters:[{name:"original_samples",val:": Tensor"},{name:"noise",val:": Tensor"},{name:"timesteps",val:": IntTensor"}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.add_noise.original_samples",description:`<strong>original_samples</strong> (<code>torch.Tensor</code>) &#x2014;
The original samples without noise.`,name:"original_samples"},{anchor:"diffusers.DPMSolverMultistepScheduler.add_noise.noise",description:`<strong>noise</strong> (<code>torch.Tensor</code>) &#x2014;
The noise to add to the samples.`,name:"noise"},{anchor:"diffusers.DPMSolverMultistepScheduler.add_noise.timesteps",description:`<strong>timesteps</strong> (<code>torch.IntTensor</code>) &#x2014;
The timesteps at which to add noise to the samples.`,name:"timesteps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L1255",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The noisy samples.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),j=new S({props:{name:"convert_model_output",anchor:"diffusers.DPMSolverMultistepScheduler.convert_model_output",parameters:[{name:"model_output",val:": Tensor"},{name:"*args",val:""},{name:"sample",val:": Tensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.convert_model_output.model_output",description:`<strong>model_output</strong> (<code>torch.Tensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DPMSolverMultistepScheduler.convert_model_output.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L716",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The converted model output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),R=new S({props:{name:"dpm_solver_first_order_update",anchor:"diffusers.DPMSolverMultistepScheduler.dpm_solver_first_order_update",parameters:[{name:"model_output",val:": Tensor"},{name:"*args",val:""},{name:"sample",val:": Tensor = None"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.dpm_solver_first_order_update.model_output",description:`<strong>model_output</strong> (<code>torch.Tensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DPMSolverMultistepScheduler.dpm_solver_first_order_update.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L814",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),B=new S({props:{name:"index_for_timestep",anchor:"diffusers.DPMSolverMultistepScheduler.index_for_timestep",parameters:[{name:"timestep",val:": typing.Union[int, torch.Tensor]"},{name:"schedule_timesteps",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.index_for_timestep.timestep",description:`<strong>timestep</strong> (<code>int</code> or <code>torch.Tensor</code>) &#x2014;
The timestep for which to find the index.`,name:"timestep"},{anchor:"diffusers.DPMSolverMultistepScheduler.index_for_timestep.schedule_timesteps",description:`<strong>schedule_timesteps</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The timestep schedule to search in. If <code>None</code>, uses <code>self.timesteps</code>.`,name:"schedule_timesteps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L1101",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The index of the timestep in the schedule.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),Y=new S({props:{name:"multistep_dpm_solver_second_order_update",anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_second_order_update",parameters:[{name:"model_output_list",val:": typing.List[torch.Tensor]"},{name:"*args",val:""},{name:"sample",val:": Tensor = None"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_second_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.Tensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_second_order_update.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L883",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),J=new S({props:{name:"multistep_dpm_solver_third_order_update",anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_third_order_update",parameters:[{name:"model_output_list",val:": typing.List[torch.Tensor]"},{name:"*args",val:""},{name:"sample",val:": Tensor = None"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_third_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.Tensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_third_order_update.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L1006",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),K=new S({props:{name:"scale_model_input",anchor:"diffusers.DPMSolverMultistepScheduler.scale_model_input",parameters:[{name:"sample",val:": Tensor"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.scale_model_input.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
The input sample.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L1240",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A scaled input sample.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Z=new S({props:{name:"set_begin_index",anchor:"diffusers.DPMSolverMultistepScheduler.set_begin_index",parameters:[{name:"begin_index",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.set_begin_index.begin_index",description:`<strong>begin_index</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The begin index for the scheduler.`,name:"begin_index"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L324"}}),Q=new S({props:{name:"set_timesteps",anchor:"diffusers.DPMSolverMultistepScheduler.set_timesteps",parameters:[{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[str, torch.device, NoneType] = None"},{name:"mu",val:": typing.Optional[float] = None"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.set_timesteps.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model.`,name:"num_inference_steps"},{anchor:"diffusers.DPMSolverMultistepScheduler.set_timesteps.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device to which the timesteps should be moved to. If <code>None</code>, the timesteps are not moved.`,name:"device"},{anchor:"diffusers.DPMSolverMultistepScheduler.set_timesteps.mu",description:`<strong>mu</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The mu parameter for dynamic shifting. If provided, requires <code>use_dynamic_shifting=True</code> and
<code>time_shift_type=&quot;exponential&quot;</code>.`,name:"mu"},{anchor:"diffusers.DPMSolverMultistepScheduler.set_timesteps.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps used to support arbitrary timesteps schedule. If <code>None</code>, timesteps will be generated
based on the <code>timestep_spacing</code> attribute. If <code>timesteps</code> is passed, <code>num_inference_steps</code> and <code>sigmas</code>
must be <code>None</code>, and <code>timestep_spacing</code> attribute will be ignored.`,name:"timesteps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L334"}}),X=new S({props:{name:"step",anchor:"diffusers.DPMSolverMultistepScheduler.step",parameters:[{name:"model_output",val:": Tensor"},{name:"timestep",val:": typing.Union[int, torch.Tensor]"},{name:"sample",val:": Tensor"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"variance_noise",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.step.model_output",description:`<strong>model_output</strong> (<code>torch.Tensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DPMSolverMultistepScheduler.step.timestep",description:`<strong>timestep</strong> (<code>int</code> or <code>torch.Tensor</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DPMSolverMultistepScheduler.step.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.DPMSolverMultistepScheduler.step.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A random number generator.`,name:"generator"},{anchor:"diffusers.DPMSolverMultistepScheduler.step.variance_noise",description:`<strong>variance_noise</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Alternative to generating noise with <code>generator</code> by directly providing the noise for the variance
itself. Useful for methods such as <code>LEdits++</code>.`,name:"variance_noise"},{anchor:"diffusers.DPMSolverMultistepScheduler.step.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput">SchedulerOutput</a> or <code>tuple</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L1151",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> is returned, otherwise a
tuple is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> or <code>tuple</code></p>
`}}),ee=new Ge({props:{title:"SchedulerOutput",local:"diffusers.schedulers.scheduling_utils.SchedulerOutput",headingTag:"h2"}}),te=new S({props:{name:"class diffusers.schedulers.scheduling_utils.SchedulerOutput",anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput",parameters:[{name:"prev_sample",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput.prev_sample",description:`<strong>prev_sample</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
Computed sample <code>(x_{t-1})</code> of previous timestep. <code>prev_sample</code> should be used as next model input in the
denoising loop.`,name:"prev_sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_utils.py#L62"}}),oe=new Ut({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/multistep_dpm_solver.md"}}),{c(){x=n("meta"),be=s(),_e=n("p"),Se=s(),u(I.$$.fragment),Me=s(),u(E.$$.fragment),xe=s(),N=n("p"),N.innerHTML=_t,ye=s(),z=n("p"),z.textContent=vt,De=s(),u(F.$$.fragment),$e=s(),k=n("p"),k.innerHTML=bt,Te=s(),H=n("p"),H.innerHTML=St,Pe=s(),A=n("p"),A.innerHTML=Mt,qe=s(),u(V.$$.fragment),we=s(),a=n("div"),u(W.$$.fragment),Re=s(),se=n("p"),se.innerHTML=xt,Be=s(),re=n("p"),re.innerHTML=yt,Ye=s(),D=n("div"),u(U.$$.fragment),Je=s(),ne=n("p"),ne.textContent=Dt,Ke=s(),M=n("div"),u(j.$$.fragment),Ze=s(),ie=n("p"),ie.textContent=$t,Qe=s(),G=n("blockquote"),G.innerHTML=Tt,Xe=s(),$=n("div"),u(R.$$.fragment),et=s(),de=n("p"),de.textContent=Pt,tt=s(),T=n("div"),u(B.$$.fragment),ot=s(),ae=n("p"),ae.textContent=qt,st=s(),P=n("div"),u(Y.$$.fragment),rt=s(),le=n("p"),le.textContent=wt,nt=s(),q=n("div"),u(J.$$.fragment),it=s(),ce=n("p"),ce.textContent=Ct,dt=s(),w=n("div"),u(K.$$.fragment),at=s(),pe=n("p"),pe.textContent=Lt,lt=s(),C=n("div"),u(Z.$$.fragment),ct=s(),ue=n("p"),ue.textContent=Ot,pt=s(),L=n("div"),u(Q.$$.fragment),ut=s(),me=n("p"),me.textContent=It,mt=s(),O=n("div"),u(X.$$.fragment),ft=s(),fe=n("p"),fe.textContent=Et,Ce=s(),u(ee.$$.fragment),Le=s(),y=n("div"),u(te.$$.fragment),ht=s(),he=n("p"),he.innerHTML=Nt,Oe=s(),u(oe.$$.fragment),Ie=s(),ve=n("p"),this.h()},l(e){const d=Vt("svelte-u9bgzb",document.head);x=i(d,"META",{name:!0,content:!0}),d.forEach(o),be=r(e),_e=i(e,"P",{}),b(_e).forEach(o),Se=r(e),m(I.$$.fragment,e),Me=r(e),m(E.$$.fragment,e),xe=r(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-194x5ku"&&(N.innerHTML=_t),ye=r(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-l6rv24"&&(z.textContent=vt),De=r(e),m(F.$$.fragment,e),$e=r(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-pt2glg"&&(k.innerHTML=bt),Te=r(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1ng0gyl"&&(H.innerHTML=St),Pe=r(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-18n28n2"&&(A.innerHTML=Mt),qe=r(e),m(V.$$.fragment,e),we=r(e),a=i(e,"DIV",{class:!0});var l=b(a);m(W.$$.fragment,l),Re=r(l),se=i(l,"P",{"data-svelte-h":!0}),p(se)!=="svelte-12v1qo2"&&(se.innerHTML=xt),Be=r(l),re=i(l,"P",{"data-svelte-h":!0}),p(re)!=="svelte-linuuh"&&(re.innerHTML=yt),Ye=r(l),D=i(l,"DIV",{class:!0});var Ne=b(D);m(U.$$.fragment,Ne),Je=r(Ne),ne=i(Ne,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-rz9b5o"&&(ne.textContent=Dt),Ne.forEach(o),Ke=r(l),M=i(l,"DIV",{class:!0});var ge=b(M);m(j.$$.fragment,ge),Ze=r(ge),ie=i(ge,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1st02i8"&&(ie.textContent=$t),Qe=r(ge),G=i(ge,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-lwd2ft"&&(G.innerHTML=Tt),ge.forEach(o),Xe=r(l),$=i(l,"DIV",{class:!0});var ze=b($);m(R.$$.fragment,ze),et=r(ze),de=i(ze,"P",{"data-svelte-h":!0}),p(de)!=="svelte-4nw43d"&&(de.textContent=Pt),ze.forEach(o),tt=r(l),T=i(l,"DIV",{class:!0});var Fe=b(T);m(B.$$.fragment,Fe),ot=r(Fe),ae=i(Fe,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1c8f4j7"&&(ae.textContent=qt),Fe.forEach(o),st=r(l),P=i(l,"DIV",{class:!0});var ke=b(P);m(Y.$$.fragment,ke),rt=r(ke),le=i(ke,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1d6o6zu"&&(le.textContent=wt),ke.forEach(o),nt=r(l),q=i(l,"DIV",{class:!0});var He=b(q);m(J.$$.fragment,He),it=r(He),ce=i(He,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-17nne8p"&&(ce.textContent=Ct),He.forEach(o),dt=r(l),w=i(l,"DIV",{class:!0});var Ae=b(w);m(K.$$.fragment,Ae),at=r(Ae),pe=i(Ae,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1rkfgpx"&&(pe.textContent=Lt),Ae.forEach(o),lt=r(l),C=i(l,"DIV",{class:!0});var Ve=b(C);m(Z.$$.fragment,Ve),ct=r(Ve),ue=i(Ve,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1k141rk"&&(ue.textContent=Ot),Ve.forEach(o),pt=r(l),L=i(l,"DIV",{class:!0});var We=b(L);m(Q.$$.fragment,We),ut=r(We),me=i(We,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1vzm9q"&&(me.textContent=It),We.forEach(o),mt=r(l),O=i(l,"DIV",{class:!0});var Ue=b(O);m(X.$$.fragment,Ue),ft=r(Ue),fe=i(Ue,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-7jbjgx"&&(fe.textContent=Et),Ue.forEach(o),l.forEach(o),Ce=r(e),m(ee.$$.fragment,e),Le=r(e),y=i(e,"DIV",{class:!0});var je=b(y);m(te.$$.fragment,je),ht=r(je),he=i(je,"P",{"data-svelte-h":!0}),p(he)!=="svelte-6ojmkw"&&(he.innerHTML=Nt),je.forEach(o),Oe=r(e),m(oe.$$.fragment,e),Ie=r(e),ve=i(e,"P",{}),b(ve).forEach(o),this.h()},h(){v(x,"name","hf:doc:metadata"),v(x,"content",Gt),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","tip"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){t(document.head,x),c(e,be,d),c(e,_e,d),c(e,Se,d),f(I,e,d),c(e,Me,d),f(E,e,d),c(e,xe,d),c(e,N,d),c(e,ye,d),c(e,z,d),c(e,De,d),f(F,e,d),c(e,$e,d),c(e,k,d),c(e,Te,d),c(e,H,d),c(e,Pe,d),c(e,A,d),c(e,qe,d),f(V,e,d),c(e,we,d),c(e,a,d),f(W,a,null),t(a,Re),t(a,se),t(a,Be),t(a,re),t(a,Ye),t(a,D),f(U,D,null),t(D,Je),t(D,ne),t(a,Ke),t(a,M),f(j,M,null),t(M,Ze),t(M,ie),t(M,Qe),t(M,G),t(a,Xe),t(a,$),f(R,$,null),t($,et),t($,de),t(a,tt),t(a,T),f(B,T,null),t(T,ot),t(T,ae),t(a,st),t(a,P),f(Y,P,null),t(P,rt),t(P,le),t(a,nt),t(a,q),f(J,q,null),t(q,it),t(q,ce),t(a,dt),t(a,w),f(K,w,null),t(w,at),t(w,pe),t(a,lt),t(a,C),f(Z,C,null),t(C,ct),t(C,ue),t(a,pt),t(a,L),f(Q,L,null),t(L,ut),t(L,me),t(a,mt),t(a,O),f(X,O,null),t(O,ft),t(O,fe),c(e,Ce,d),f(ee,e,d),c(e,Le,d),c(e,y,d),f(te,y,null),t(y,ht),t(y,he),c(e,Oe,d),f(oe,e,d),c(e,Ie,d),c(e,ve,d),Ee=!0},p:Ft,i(e){Ee||(h(I.$$.fragment,e),h(E.$$.fragment,e),h(F.$$.fragment,e),h(V.$$.fragment,e),h(W.$$.fragment,e),h(U.$$.fragment,e),h(j.$$.fragment,e),h(R.$$.fragment,e),h(B.$$.fragment,e),h(Y.$$.fragment,e),h(J.$$.fragment,e),h(K.$$.fragment,e),h(Z.$$.fragment,e),h(Q.$$.fragment,e),h(X.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(oe.$$.fragment,e),Ee=!0)},o(e){g(I.$$.fragment,e),g(E.$$.fragment,e),g(F.$$.fragment,e),g(V.$$.fragment,e),g(W.$$.fragment,e),g(U.$$.fragment,e),g(j.$$.fragment,e),g(R.$$.fragment,e),g(B.$$.fragment,e),g(Y.$$.fragment,e),g(J.$$.fragment,e),g(K.$$.fragment,e),g(Z.$$.fragment,e),g(Q.$$.fragment,e),g(X.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(oe.$$.fragment,e),Ee=!1},d(e){e&&(o(be),o(_e),o(Se),o(Me),o(xe),o(N),o(ye),o(z),o(De),o($e),o(k),o(Te),o(H),o(Pe),o(A),o(qe),o(we),o(a),o(Ce),o(Le),o(y),o(Oe),o(Ie),o(ve)),o(x),_(I,e),_(E,e),_(F,e),_(V,e),_(W),_(U),_(j),_(R),_(B),_(Y),_(J),_(K),_(Z),_(Q),_(X),_(ee,e),_(te),_(oe,e)}}}const Gt='{"title":"DPMSolverMultistepScheduler","local":"dpmsolvermultistepscheduler","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"DPMSolverMultistepScheduler","local":"diffusers.DPMSolverMultistepScheduler","sections":[],"depth":2},{"title":"SchedulerOutput","local":"diffusers.schedulers.scheduling_utils.SchedulerOutput","sections":[],"depth":2}],"depth":1}';function Rt(gt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends Ht{constructor(x){super(),At(this,x,Rt,jt,zt,{})}}export{Qt as component};
