import{s as $l,n as Rl,o as Ql}from"../chunks/scheduler.6062bdaf.js";import{S as Vl,i as Sl,g as i,s,r as M,A as zl,h as o,f as t,c as n,j as Xl,u as c,x as r,k as ol,y as Fl,a,v as p,d,t as h,w as m}from"../chunks/index.4bca734e.js";import{C as Me}from"../chunks/CodeBlock.fa01571c.js";import{H as y}from"../chunks/Heading.723dceba.js";function Ll(rl){let u,de,ce,he,J,me,f,Ml=`The Hugging Face Hub makes hosting and sharing models with the community easy. It supports
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">dozens of libraries</a> in the Open Source ecosystem. We are always
working on expanding this support to push collaborative Machine Learning forward. The <code>huggingface_hub</code> library plays a
key role in this process, allowing any Python script to easily push and load files.`,ye,b,cl="There are four main ways to integrate a library with the Hub:",ue,j,pl=`<li><strong>Push to Hub:</strong> implement a method to upload a model to the Hub. This includes the model weights, as well as
<a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">the model card</a> and any other relevant information
or data necessary to run the model (for example, training logs). This method is often called <code>push_to_hub()</code>.</li> <li><strong>Download from Hub:</strong> implement a method to load a model from the Hub. The method should download the model
configuration/weights and load the model. This method is often called <code>from_pretrained</code> or <code>load_from_hub()</code>.</li> <li><strong>Inference API:</strong> use our servers to run inference on models supported by your library for free.</li> <li><strong>Widgets:</strong> display a widget on the landing page of your models on the Hub. It allows users to quickly try a model
from the browser.</li>`,we,U,dl=`In this guide, we will focus on the first two topics. We will present the two main approaches you can use to integrate
a library, with their advantages and drawbacks. Everything is summarized at the end of the guide to help you choose
between the two. Please keep in mind that these are only guidelines that you are free to adapt to you requirements.`,Te,g,hl=`If you are interested in Inference and Widgets, you can follow <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">this guide</a>.
In both cases, you can reach out to us if you are integrating a library with the Hub and want to be listed
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">in our docs</a>.`,Je,I,fe,C,ml=`The first approach to integrate a library to the Hub is to actually implement the <code>push_to_hub</code> and <code>from_pretrained</code>
methods by yourself. This gives you full flexibility on which files you need to upload/download and how to handle inputs
specific to your framework. You can refer to the two <a href="./upload">upload files</a> and <a href="./download">download files</a> guides
to learn more about how to do that. This is, for example how the FastAI integration is implemented (see <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.push_to_hub_fastai">push_to_hub_fastai()</a>
and <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.from_pretrained_fastai">from_pretrained_fastai()</a>).`,be,_,yl="Implementation can differ between libraries, but the workflow is often similar.",je,v,Ue,k,ul="This is how a <code>from_pretrained</code> method usually look like:",ge,B,Ie,Z,Ce,G,wl=`The <code>push_to_hub</code> method often requires a bit more complexity to handle repo creation, generate the model card and save weights.
A common approach is to save all of these files in a temporary folder, upload it and then delete it.`,_e,A,ve,x,Tl=`This is of course only an example. If you are interested in more complex manipulations (delete remote files, upload
weights on the fly, persist weights locally, etc.) please refer to the <a href="./upload">upload files</a> guide.`,ke,H,Be,E,Jl=`While being flexible, this approach has some drawbacks, especially in terms of maintenance. Hugging Face users are often
used to additional features when working with <code>huggingface_hub</code>. For example, when loading files from the Hub, it is
common to offer parameters like:`,Ze,Y,fl="<li><code>token</code>: to download from a private repo</li> <li><code>revision</code>: to download from a specific branch</li> <li><code>cache_dir</code>: to cache files in a specific directory</li> <li><code>force_download</code>/<code>resume_download</code>/<code>local_files_only</code>: to reuse the cache or not</li> <li><code>proxies</code>: configure HTTP session</li>",Ge,W,bl="When pushing models, similar parameters are supported:",Ae,X,jl="<li><code>commit_message</code>: custom commit message</li> <li><code>private</code>: create a private repo if missing</li> <li><code>create_pr</code>: create a PR instead of pushing to <code>main</code></li> <li><code>branch</code>: push to a branch instead of the <code>main</code> branch</li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filter which files to upload</li> <li><code>token</code></li> <li>…</li>",xe,$,Ul=`All of these parameters can be added to the implementations we saw above and passed to the <code>huggingface_hub</code> methods.
However, if a parameter changes or a new feature is added, you will need to update your package. Supporting those
parameters also means more documentation to maintain on your side. To see how to mitigate these limitations, let’s jump
to our next section <strong>class inheritance</strong>.`,He,R,Ee,Q,gl=`As we saw above, there are two main methods to include in your library to integrate it with the Hub: upload files
(<code>push_to_hub</code>) and download files (<code>from_pretrained</code>). You can implement those methods by yourself but it comes with
caveats. To tackle this, <code>huggingface_hub</code> provides a tool that uses class inheritance. Let’s see how it works!`,Ye,V,Il=`In a lot of cases, a library already implements its model using a Python class. The class contains the properties of
the model and methods to load, run, train, and evaluate it. Our approach is to extend this class to include upload and
download features using mixins. A <a href="https://stackoverflow.com/a/547714" rel="nofollow">Mixin</a> is a class that is meant to extend an
existing class with a set of specific features using multiple inheritance. <code>huggingface_hub</code> provides its own mixin,
the <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>. The key here is to understand its behavior and how to customize it.`,We,S,Cl=`The <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> class implements 3 <em>public</em> methods (<code>push_to_hub</code>, <code>save_pretrained</code> and <code>from_pretrained</code>). Those
are the methods that your users will call to load/save models with your library. <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> also defines 2
<em>private</em> methods (<code>_save_pretrained</code> and <code>_from_pretrained</code>). Those are the ones you must implement. So to integrate
your library, you should:`,Xe,z,_l=`<li>Make your Model class inherit from <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>.</li> <li>Implement the private methods:<ul><li><a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.ModelHubMixin._save_pretrained">_save_pretrained()</a>: method taking as input a path to a directory and saving the model to it.
You must write all the logic to dump your model in this method: model card, model weights, configuration files,
training logs, and figures. Any relevant information for this model must be handled by this method.
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards</a> are particularly important to describe your model. Check
out <a href="./model-cards">our implementation guide</a> for more details.</li> <li><a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a>: <strong>class method</strong> taking as input a <code>model_id</code> and returning an instantiated
model. The method must download the relevant files and load them.</li></ul></li> <li>You are done!</li>`,$e,F,vl=`The advantage of using <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> is that once you take care of the serialization/loading of the files, you
are ready to go. You don’t need to worry about stuff like repo creation, commits, PRs, or revisions. All
of this is handled by the mixin and is available to your users. The Mixin also ensures that public methods are well
documented and type annotated.`,Re,L,kl='As a bonus, <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> handles the model configuration for you. In some cases, you have a <code>config</code> input parameter when initializing your class (dictionary or dataclass containing high-level settings). In such cases, the <code>config</code> value is automatically serialized into a <code>config.json</code> dictionary for you. When re-loading the model from the Hub, the configuration is correctly deserialized. Make sure to use type annotation if you want to deserialize it as a dataclass. The big advantage of having a <code>config.json</code> file in your model repository is that it automatically enables the analytics on the Hub (e.g. the “downloads” count).',Qe,N,Ve,P,Bl='A good example of what we saw above is <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin">PyTorchModelHubMixin</a>, our integration for the PyTorch framework. This is a ready-to-use integration.',Se,q,ze,K,Zl="Here is how any user can load/save a PyTorch model from/to the Hub:",Fe,D,Le,O,Ne,ee,Gl='The implementation is actually very straightforward, and the full implementation can be found <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">here</a>.',Pe,le,Al="<li>First, inherit your class from <code>ModelHubMixin</code>:</li>",qe,te,Ke,w,xl="<li>Implement the <code>_save_pretrained</code> method:</li>",De,ae,Oe,T,Hl="<li>Implement the <code>_from_pretrained</code> method:</li>",el,se,ll,ne,El="And that’s it! Your library now enables users to upload and download files to and from the Hub.",tl,ie,al,oe,Yl=`Let’s quickly sum up the two approaches we saw with their advantages and drawbacks. The table below is only indicative.
Your framework might have some specificities that you need to address. This guide is only here to give guidelines and
ideas on how to handle integration. In any case, feel free to contact us if you have any questions!`,sl,re,Wl='<thead><tr><th align="center">Integration</th> <th align="center">Using helpers</th> <th align="center">Using <a href="/docs/huggingface_hub/v0.21.0.rc0/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a></th></tr></thead> <tbody><tr><td align="center">User experience</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexibility</td> <td align="center">Very flexible.<br/>You fully control the implementation.</td> <td align="center">Less flexible.<br/>Your framework must have a model class.</td></tr> <tr><td align="center">Maintenance</td> <td align="center">More maintenance to add support for configuration, and new features. Might also require fixing issues reported by users.</td> <td align="center">Less maintenance as most of the interactions with the Hub are implemented in <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Documentation / Type annotation</td> <td align="center">To be written manually.</td> <td align="center">Partially handled by <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Download counter</td> <td align="center">To be handled manually.</td> <td align="center">Enabled by default if class has a <code>config</code> attribute.</td></tr></tbody>',nl,pe,il;return J=new y({props:{title:"Integrate any ML framework with the Hub",local:"integrate-any-ml-framework-with-the-hub",headingTag:"h1"}}),I=new y({props:{title:"A flexible approach: helpers",local:"a-flexible-approach-helpers",headingTag:"h2"}}),v=new y({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),B=new Me({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwZnJvbSUyMEh1YiUwQSUyMCUyMCUyMGNhY2hlZF9tb2RlbCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGZpbGVuYW1lJTNEJTIybW9kZWwucGtsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIyZmFzdGFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV92ZXJzaW9uJTNEZ2V0X2Zhc3RhaV92ZXJzaW9uKCklMkMlMEElMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIzJTIwTG9hZCUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9hZF9tb2RlbChjYWNoZWRfbW9kZWwp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Download model from Hub</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Load model</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),Z=new y({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),A=new Me({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwcmVwbyUyMGlmJTIwbm90JTIwZXhpc3RpbmclMjB5ZXQlMjBhbmQlMjBnZXQlMjB0aGUlMjBhc3NvY2lhdGVkJTIwcmVwb19pZCUwQSUyMCUyMCUyMHJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8ocmVwb19uYW1lJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMyUyMFNhdmUlMjBhbGwlMjBmaWxlcyUyMGluJTIwYSUyMHRlbXBvcmFyeSUyMGRpcmVjdG9yeSUyMGFuZCUyMHB1c2glMjB0aGVtJTIwaW4lMjBhJTIwc2luZ2xlJTIwY29tbWl0JTBBJTIwJTIwJTIwd2l0aCUyMFRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjB0bXBkaXIlMjAlM0QlMjBQYXRoKHRtcGRpciklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwd2VpZ2h0cyUwQSUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfbW9kZWwobW9kZWwlMkMlMjB0bXBkaXIlMjAlMkYlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZW5lcmF0ZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQlMjAlM0QlMjBnZW5lcmF0ZV9tb2RlbF9jYXJkKG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCh0bXBkaXIlMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoY2FyZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwbG9ncyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFNhdmUlMjBmaWd1cmVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2F2ZSUyMGV2YWx1YXRpb24lMjBtZXRyaWNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUHVzaCUyMHRvJTIwaHViJTBBJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjBmb2xkZXJfcGF0aCUzRHRtcGRpcik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Create repo if not existing yet and get the associated repo_id</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>)

   <span class="hljs-comment"># Save all files in a temporary directory and push them in a single commit</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Save weights</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Generate model card</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Save logs</span>
      <span class="hljs-comment"># Save figures</span>
      <span class="hljs-comment"># Save evaluation metrics</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Push to hub</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),H=new y({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),R=new y({props:{title:"A more complex approach: class inheritance",local:"a-more-complex-approach-class-inheritance",headingTag:"h2"}}),N=new y({props:{title:"A concrete example: PyTorch",local:"a-concrete-example-pytorch",headingTag:"h3"}}),q=new y({props:{title:"How to use it?",local:"how-to-use-it",headingTag:"h4"}}),D=new Me({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMENvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGhpZGRlbl9zaXplJTNBJTIwaW50JTIwJTNEJTIwNTEyJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDMwMDAwJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3NpemUlM0ElMjBpbnQlMjAlM0QlMjA0JTBBJTBBY2xhc3MlMjBNeU1vZGVsKG5uLk1vZHVsZSUyQyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKSUzQSUyMCUyMyUyMG11bHRpcGxlJTIwaW5oZXJpdGFuY2UlMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTNBJTIwQ29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucGFyYW0lMjAlM0QlMjBubi5QYXJhbWV0ZXIodG9yY2gucmFuZChjb25maWcuaGlkZGVuX3NpemUlMkMlMjBjb25maWcudm9jYWJfc2l6ZSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5saW5lYXIlMjAlM0QlMjBubi5MaW5lYXIoY29uZmlnLm91dHB1dF9zaXplJTJDJTIwY29uZmlnLnZvY2FiX3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLmxpbmVhcih4JTIwJTJCJTIwc2VsZi5wYXJhbSklMEElMEFtb2RlbCUyMCUzRCUyME15TW9kZWwoQ29uZmlnKGhpZGRlbl9zaXplJTNEMTI4KSklMEElMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGbXktYXdlc29tZS1tb2RlbCUyMiklMEElMEFtb2RlbC5wdXNoX3RvX2h1YiglMjJteS1hd2Vzb21lLW1vZGVsJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwTXlNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydXNlcm5hbWUlMkZteS1hd2Vzb21lLW1vZGVsJTIyKSUwQW1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin

<span class="hljs-comment"># 0. (optional) define a config class</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">Config</span>:
<span class="hljs-meta">... </span>    hidden_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>
<span class="hljs-meta">... </span>    vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">30000</span>
<span class="hljs-meta">... </span>    output_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">4</span>

<span class="hljs-comment"># 1. Define your Pytorch model exactly the same way you are used to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin): <span class="hljs-comment"># multiple inheritance</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Config</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(config.hidden_size, config.vocab_size))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(config.output_size, config.vocab_size)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel(Config(hidden_size=<span class="hljs-number">128</span>))

<span class="hljs-comment"># 2. (optional) Save model to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. Initialize model from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config
Config(hidden_size=<span class="hljs-number">128</span>, vocab_size=<span class="hljs-number">30000</span>, output_size=<span class="hljs-number">4</span>)`,wrap:!1}}),O=new y({props:{title:"Implementation",local:"implementation",headingTag:"h4"}}),te=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),ae=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyME1vZGVsQ2FyZERhdGElMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2VuZXJhdGUlMjBNb2RlbCUyMENhcmQlMjBhbmQlMjBzYXZlJTIwd2VpZ2h0cyUyMGZyb20lMjBhJTIwUHl0b3JjaCUyMG1vZGVsJTIwdG8lMjBhJTIwbG9jYWwlMjBkaXJlY3RvcnkuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfY2FyZCUyMCUzRCUyME1vZGVsQ2FyZC5mcm9tX3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRfZGF0YSUzRE1vZGVsQ2FyZERhdGEoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGljZW5zZSUzRCdtaXQnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9zdW1tYXJ5JTNELi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfdHlwZSUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAoc2F2ZV9kaXJlY3RvcnklMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoc3RyKG1vZGVsKSklMEElMjAlMjAlMjAlMjAlMjAlMjB0b3JjaC5zYXZlKG9iaiUzRHNlbGYubW9kdWxlLnN0YXRlX2RpY3QoKSUyQyUyMGYlM0RzYXZlX2RpcmVjdG9yeSUyMCUyRiUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>):
      <span class="hljs-string">&quot;&quot;&quot;Generate Model Card and save weights from a Pytorch model to a local directory.&quot;&quot;&quot;</span>
      model_card = ModelCard.from_template(
         card_data=ModelCardData(
            license=<span class="hljs-string">&#x27;mit&#x27;</span>,
            library_name=<span class="hljs-string">&quot;pytorch&quot;</span>,
            ...
         ),
         model_summary=...,
         model_type=...,
         ...
      )
      (save_directory / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(<span class="hljs-built_in">str</span>(model))
      torch.save(obj=self.module.state_dict(), f=save_directory / <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)`,wrap:!1}}),se=new Me({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Must be a classmethod!</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>],
      resume_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># additional argument</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># additional argument</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Load Pytorch pretrained weights and return the loaded model.&quot;&quot;&quot;</span>
      <span class="hljs-keyword">if</span> os.path.isdir(model_id): <span class="hljs-comment"># Can either be a local directory</span>
         <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
         model_file = os.path.join(model_id, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
      <span class="hljs-keyword">else</span>: <span class="hljs-comment"># Or a model on the Hub</span>
         model_file = hf_hub_download( <span class="hljs-comment"># Download from the hub, passing same input args</span>
            repo_id=model_id,
            filename=<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            proxies=proxies,
            resume_download=resume_download,
            token=token,
            local_files_only=local_files_only,
         )

      <span class="hljs-comment"># Load model and return - custom logic depending on your framework</span>
      model = cls(**model_kwargs)
      state_dict = torch.load(model_file, map_location=torch.device(map_location))
      model.load_state_dict(state_dict, strict=strict)
      model.<span class="hljs-built_in">eval</span>()
      <span class="hljs-keyword">return</span> model`,wrap:!1}}),ie=new y({props:{title:"Quick comparison",local:"quick-comparison",headingTag:"h2"}}),{c(){u=i("meta"),de=s(),ce=i("p"),he=s(),M(J.$$.fragment),me=s(),f=i("p"),f.innerHTML=Ml,ye=s(),b=i("p"),b.textContent=cl,ue=s(),j=i("ol"),j.innerHTML=pl,we=s(),U=i("p"),U.textContent=dl,Te=s(),g=i("p"),g.innerHTML=hl,Je=s(),M(I.$$.fragment),fe=s(),C=i("p"),C.innerHTML=ml,be=s(),_=i("p"),_.textContent=yl,je=s(),M(v.$$.fragment),Ue=s(),k=i("p"),k.innerHTML=ul,ge=s(),M(B.$$.fragment),Ie=s(),M(Z.$$.fragment),Ce=s(),G=i("p"),G.innerHTML=wl,_e=s(),M(A.$$.fragment),ve=s(),x=i("p"),x.innerHTML=Tl,ke=s(),M(H.$$.fragment),Be=s(),E=i("p"),E.innerHTML=Jl,Ze=s(),Y=i("ul"),Y.innerHTML=fl,Ge=s(),W=i("p"),W.textContent=bl,Ae=s(),X=i("ul"),X.innerHTML=jl,xe=s(),$=i("p"),$.innerHTML=Ul,He=s(),M(R.$$.fragment),Ee=s(),Q=i("p"),Q.innerHTML=gl,Ye=s(),V=i("p"),V.innerHTML=Il,We=s(),S=i("p"),S.innerHTML=Cl,Xe=s(),z=i("ol"),z.innerHTML=_l,$e=s(),F=i("p"),F.innerHTML=vl,Re=s(),L=i("p"),L.innerHTML=kl,Qe=s(),M(N.$$.fragment),Ve=s(),P=i("p"),P.innerHTML=Bl,Se=s(),M(q.$$.fragment),ze=s(),K=i("p"),K.textContent=Zl,Fe=s(),M(D.$$.fragment),Le=s(),M(O.$$.fragment),Ne=s(),ee=i("p"),ee.innerHTML=Gl,Pe=s(),le=i("ol"),le.innerHTML=Al,qe=s(),M(te.$$.fragment),Ke=s(),w=i("ol"),w.innerHTML=xl,De=s(),M(ae.$$.fragment),Oe=s(),T=i("ol"),T.innerHTML=Hl,el=s(),M(se.$$.fragment),ll=s(),ne=i("p"),ne.textContent=El,tl=s(),M(ie.$$.fragment),al=s(),oe=i("p"),oe.textContent=Yl,sl=s(),re=i("table"),re.innerHTML=Wl,nl=s(),pe=i("p"),this.h()},l(e){const l=zl("svelte-u9bgzb",document.head);u=o(l,"META",{name:!0,content:!0}),l.forEach(t),de=n(e),ce=o(e,"P",{}),Xl(ce).forEach(t),he=n(e),c(J.$$.fragment,e),me=n(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-uvt37o"&&(f.innerHTML=Ml),ye=n(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-14vdlq5"&&(b.textContent=cl),ue=n(e),j=o(e,"OL",{"data-svelte-h":!0}),r(j)!=="svelte-14btp4x"&&(j.innerHTML=pl),we=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1tx4sul"&&(U.textContent=dl),Te=n(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-10f3yyh"&&(g.innerHTML=hl),Je=n(e),c(I.$$.fragment,e),fe=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1b3uslj"&&(C.innerHTML=ml),be=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1g2giur"&&(_.textContent=yl),je=n(e),c(v.$$.fragment,e),Ue=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-bozc1x"&&(k.innerHTML=ul),ge=n(e),c(B.$$.fragment,e),Ie=n(e),c(Z.$$.fragment,e),Ce=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-7bmo7d"&&(G.innerHTML=wl),_e=n(e),c(A.$$.fragment,e),ve=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-15vgu12"&&(x.innerHTML=Tl),ke=n(e),c(H.$$.fragment,e),Be=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-tzwehq"&&(E.innerHTML=Jl),Ze=n(e),Y=o(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-6gcvoy"&&(Y.innerHTML=fl),Ge=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-3m9y73"&&(W.textContent=bl),Ae=n(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-30swpt"&&(X.innerHTML=jl),xe=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-p8rs76"&&($.innerHTML=Ul),He=n(e),c(R.$$.fragment,e),Ee=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1uvlinw"&&(Q.innerHTML=gl),Ye=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-j0kfbw"&&(V.innerHTML=Il),We=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1tw5h6f"&&(S.innerHTML=Cl),Xe=n(e),z=o(e,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-ktuy57"&&(z.innerHTML=_l),$e=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1kvxi19"&&(F.innerHTML=vl),Re=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1wrn9u0"&&(L.innerHTML=kl),Qe=n(e),c(N.$$.fragment,e),Ve=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-f6uoh8"&&(P.innerHTML=Bl),Se=n(e),c(q.$$.fragment,e),ze=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-l2ktl8"&&(K.textContent=Zl),Fe=n(e),c(D.$$.fragment,e),Le=n(e),c(O.$$.fragment,e),Ne=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-l2iz9k"&&(ee.innerHTML=Gl),Pe=n(e),le=o(e,"OL",{"data-svelte-h":!0}),r(le)!=="svelte-1a9vqht"&&(le.innerHTML=Al),qe=n(e),c(te.$$.fragment,e),Ke=n(e),w=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(w)!=="svelte-mclxy5"&&(w.innerHTML=xl),De=n(e),c(ae.$$.fragment,e),Oe=n(e),T=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(T)!=="svelte-1vfuaub"&&(T.innerHTML=Hl),el=n(e),c(se.$$.fragment,e),ll=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-zuw9zy"&&(ne.textContent=El),tl=n(e),c(ie.$$.fragment,e),al=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1qi11kl"&&(oe.textContent=Yl),sl=n(e),re=o(e,"TABLE",{"data-svelte-h":!0}),r(re)!=="svelte-16ac2na"&&(re.innerHTML=Wl),nl=n(e),pe=o(e,"P",{}),Xl(pe).forEach(t),this.h()},h(){ol(u,"name","hf:doc:metadata"),ol(u,"content",Nl),ol(w,"start","2"),ol(T,"start","3")},m(e,l){Fl(document.head,u),a(e,de,l),a(e,ce,l),a(e,he,l),p(J,e,l),a(e,me,l),a(e,f,l),a(e,ye,l),a(e,b,l),a(e,ue,l),a(e,j,l),a(e,we,l),a(e,U,l),a(e,Te,l),a(e,g,l),a(e,Je,l),p(I,e,l),a(e,fe,l),a(e,C,l),a(e,be,l),a(e,_,l),a(e,je,l),p(v,e,l),a(e,Ue,l),a(e,k,l),a(e,ge,l),p(B,e,l),a(e,Ie,l),p(Z,e,l),a(e,Ce,l),a(e,G,l),a(e,_e,l),p(A,e,l),a(e,ve,l),a(e,x,l),a(e,ke,l),p(H,e,l),a(e,Be,l),a(e,E,l),a(e,Ze,l),a(e,Y,l),a(e,Ge,l),a(e,W,l),a(e,Ae,l),a(e,X,l),a(e,xe,l),a(e,$,l),a(e,He,l),p(R,e,l),a(e,Ee,l),a(e,Q,l),a(e,Ye,l),a(e,V,l),a(e,We,l),a(e,S,l),a(e,Xe,l),a(e,z,l),a(e,$e,l),a(e,F,l),a(e,Re,l),a(e,L,l),a(e,Qe,l),p(N,e,l),a(e,Ve,l),a(e,P,l),a(e,Se,l),p(q,e,l),a(e,ze,l),a(e,K,l),a(e,Fe,l),p(D,e,l),a(e,Le,l),p(O,e,l),a(e,Ne,l),a(e,ee,l),a(e,Pe,l),a(e,le,l),a(e,qe,l),p(te,e,l),a(e,Ke,l),a(e,w,l),a(e,De,l),p(ae,e,l),a(e,Oe,l),a(e,T,l),a(e,el,l),p(se,e,l),a(e,ll,l),a(e,ne,l),a(e,tl,l),p(ie,e,l),a(e,al,l),a(e,oe,l),a(e,sl,l),a(e,re,l),a(e,nl,l),a(e,pe,l),il=!0},p:Rl,i(e){il||(d(J.$$.fragment,e),d(I.$$.fragment,e),d(v.$$.fragment,e),d(B.$$.fragment,e),d(Z.$$.fragment,e),d(A.$$.fragment,e),d(H.$$.fragment,e),d(R.$$.fragment,e),d(N.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),il=!0)},o(e){h(J.$$.fragment,e),h(I.$$.fragment,e),h(v.$$.fragment,e),h(B.$$.fragment,e),h(Z.$$.fragment,e),h(A.$$.fragment,e),h(H.$$.fragment,e),h(R.$$.fragment,e),h(N.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),il=!1},d(e){e&&(t(de),t(ce),t(he),t(me),t(f),t(ye),t(b),t(ue),t(j),t(we),t(U),t(Te),t(g),t(Je),t(fe),t(C),t(be),t(_),t(je),t(Ue),t(k),t(ge),t(Ie),t(Ce),t(G),t(_e),t(ve),t(x),t(ke),t(Be),t(E),t(Ze),t(Y),t(Ge),t(W),t(Ae),t(X),t(xe),t($),t(He),t(Ee),t(Q),t(Ye),t(V),t(We),t(S),t(Xe),t(z),t($e),t(F),t(Re),t(L),t(Qe),t(Ve),t(P),t(Se),t(ze),t(K),t(Fe),t(Le),t(Ne),t(ee),t(Pe),t(le),t(qe),t(Ke),t(w),t(De),t(Oe),t(T),t(el),t(ll),t(ne),t(tl),t(al),t(oe),t(sl),t(re),t(nl),t(pe)),t(u),m(J,e),m(I,e),m(v,e),m(B,e),m(Z,e),m(A,e),m(H,e),m(R,e),m(N,e),m(q,e),m(D,e),m(O,e),m(te,e),m(ae,e),m(se,e),m(ie,e)}}}const Nl='{"title":"Integrate any ML framework with the Hub","local":"integrate-any-ml-framework-with-the-hub","sections":[{"title":"A flexible approach: helpers","local":"a-flexible-approach-helpers","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"A more complex approach: class inheritance","local":"a-more-complex-approach-class-inheritance","sections":[{"title":"A concrete example: PyTorch","local":"a-concrete-example-pytorch","sections":[{"title":"How to use it?","local":"how-to-use-it","sections":[],"depth":4},{"title":"Implementation","local":"implementation","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Quick comparison","local":"quick-comparison","sections":[],"depth":2}],"depth":1}';function Pl(rl){return Ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends Vl{constructor(u){super(),Sl(this,u,Pl,Ll,$l,{})}}export{et as component};
