import{s as Wt,n as vt,o as Et}from"../chunks/scheduler.85c25b89.js";import{S as Gt,i as _t,g as i,s as a,r as o,A as Qt,h as p,f as s,c as n,j as Ct,u as c,x as m,k as Bt,y as Rt,a as l,v as r,d as h,t as M,w as g}from"../chunks/index.c9bcf812.js";import{C as V}from"../chunks/CodeBlock.94efc595.js";import{H as Y}from"../chunks/Heading.3c6e5b17.js";function Vt(jt){let d,z,X,H,f,F,j,wt="<strong>EfficientNet</strong> is a convolutional neural network architecture and scaling method that uniformly scales all dimensions of depth/width/resolution using a <em>compound coefficient</em>. Unlike conventional practice that arbitrary scales  these factors, the EfficientNet scaling method uniformly scales network width, depth, and resolution with a set of fixed scaling coefficients. For example, if we want to use $2^N$ times more computational resources, then we can simply increase the network depth by $\\alpha ^ N$,  width by $\\beta ^ N$, and image size by $\\gamma ^ N$, where $\\alpha, \\beta, \\gamma$ are constant coefficients determined by a small grid search on the original small model. EfficientNet uses a compound coefficient $\\phi$ to uniformly scales network width, depth, and resolution in a  principled way.",S,w,Jt="The compound scaling method is justified by the intuition that if the input image is bigger, then the network needs more layers to increase the receptive field and more channels to capture more fine-grained patterns on the bigger image.",L,J,ut='The base EfficientNet-B0 network is based on the inverted bottleneck residual blocks of <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>, in addition to <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a>.',P,u,Tt='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',q,T,D,b,bt="To load a pretrained model:",K,y,O,$,yt="To load and preprocess the image:",tt,U,et,I,$t="To get the model predictions:",st,k,lt,Z,Ut="To get the top-5 predictions class names:",at,x,nt,N,It="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_b0</code>. You can find the IDs in the model summaries at the top of this page.",it,C,kt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,B,mt,W,Zt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ot,v,ct,E,xt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,rt,G,ht,_,Nt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Mt,Q,gt,R,dt,A,ft;return f=new Y({props:{title:"(Tensorflow) EfficientNet",local:"tensorflow-efficientnet",headingTag:"h1"}}),T=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),y=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9iMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),k=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),v=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2IwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),R=new V({props:{code:"JTQwbWlzYyU3QnRhbjIwMjBlZmZpY2llbnRuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkVmZmljaWVudE5ldCUzQSUyMFJldGhpbmtpbmclMjBNb2RlbCUyMFNjYWxpbmclMjBmb3IlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JNaW5neGluZyUyMFRhbiUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA1LjExOTQ2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2020efficientnet,
      title={EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1905.11946}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){d=i("meta"),z=a(),X=i("p"),H=a(),o(f.$$.fragment),F=a(),j=i("p"),j.innerHTML=wt,S=a(),w=i("p"),w.textContent=Jt,L=a(),J=i("p"),J.innerHTML=ut,P=a(),u=i("p"),u.innerHTML=Tt,q=a(),o(T.$$.fragment),D=a(),b=i("p"),b.textContent=bt,K=a(),o(y.$$.fragment),O=a(),$=i("p"),$.textContent=yt,tt=a(),o(U.$$.fragment),et=a(),I=i("p"),I.textContent=$t,st=a(),o(k.$$.fragment),lt=a(),Z=i("p"),Z.textContent=Ut,at=a(),o(x.$$.fragment),nt=a(),N=i("p"),N.innerHTML=It,it=a(),C=i("p"),C.innerHTML=kt,pt=a(),o(B.$$.fragment),mt=a(),W=i("p"),W.textContent=Zt,ot=a(),o(v.$$.fragment),ct=a(),E=i("p"),E.innerHTML=xt,rt=a(),o(G.$$.fragment),ht=a(),_=i("p"),_.innerHTML=Nt,Mt=a(),o(Q.$$.fragment),gt=a(),o(R.$$.fragment),dt=a(),A=i("p"),this.h()},l(t){const e=Qt("svelte-u9bgzb",document.head);d=p(e,"META",{name:!0,content:!0}),e.forEach(s),z=n(t),X=p(t,"P",{}),Ct(X).forEach(s),H=n(t),c(f.$$.fragment,t),F=n(t),j=p(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1bwkfja"&&(j.innerHTML=wt),S=n(t),w=p(t,"P",{"data-svelte-h":!0}),m(w)!=="svelte-5z334a"&&(w.textContent=Jt),L=n(t),J=p(t,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1j8z7ka"&&(J.innerHTML=ut),P=n(t),u=p(t,"P",{"data-svelte-h":!0}),m(u)!=="svelte-k8hpf1"&&(u.innerHTML=Tt),q=n(t),c(T.$$.fragment,t),D=n(t),b=p(t,"P",{"data-svelte-h":!0}),m(b)!=="svelte-18ywhxh"&&(b.textContent=bt),K=n(t),c(y.$$.fragment,t),O=n(t),$=p(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1c2ipa8"&&($.textContent=yt),tt=n(t),c(U.$$.fragment,t),et=n(t),I=p(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1n9qsq1"&&(I.textContent=$t),st=n(t),c(k.$$.fragment,t),lt=n(t),Z=p(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-19cnvx1"&&(Z.textContent=Ut),at=n(t),c(x.$$.fragment,t),nt=n(t),N=p(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1jdhw10"&&(N.innerHTML=It),it=n(t),C=p(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1wmi3ea"&&(C.innerHTML=kt),pt=n(t),c(B.$$.fragment,t),mt=n(t),W=p(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-9sr7nh"&&(W.textContent=Zt),ot=n(t),c(v.$$.fragment,t),ct=n(t),E=p(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1kguc51"&&(E.innerHTML=xt),rt=n(t),c(G.$$.fragment,t),ht=n(t),_=p(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n0coha"&&(_.innerHTML=Nt),Mt=n(t),c(Q.$$.fragment,t),gt=n(t),c(R.$$.fragment,t),dt=n(t),A=p(t,"P",{}),Ct(A).forEach(s),this.h()},h(){Bt(d,"name","hf:doc:metadata"),Bt(d,"content",Xt)},m(t,e){Rt(document.head,d),l(t,z,e),l(t,X,e),l(t,H,e),r(f,t,e),l(t,F,e),l(t,j,e),l(t,S,e),l(t,w,e),l(t,L,e),l(t,J,e),l(t,P,e),l(t,u,e),l(t,q,e),r(T,t,e),l(t,D,e),l(t,b,e),l(t,K,e),r(y,t,e),l(t,O,e),l(t,$,e),l(t,tt,e),r(U,t,e),l(t,et,e),l(t,I,e),l(t,st,e),r(k,t,e),l(t,lt,e),l(t,Z,e),l(t,at,e),r(x,t,e),l(t,nt,e),l(t,N,e),l(t,it,e),l(t,C,e),l(t,pt,e),r(B,t,e),l(t,mt,e),l(t,W,e),l(t,ot,e),r(v,t,e),l(t,ct,e),l(t,E,e),l(t,rt,e),r(G,t,e),l(t,ht,e),l(t,_,e),l(t,Mt,e),r(Q,t,e),l(t,gt,e),r(R,t,e),l(t,dt,e),l(t,A,e),ft=!0},p:vt,i(t){ft||(h(f.$$.fragment,t),h(T.$$.fragment,t),h(y.$$.fragment,t),h(U.$$.fragment,t),h(k.$$.fragment,t),h(x.$$.fragment,t),h(B.$$.fragment,t),h(v.$$.fragment,t),h(G.$$.fragment,t),h(Q.$$.fragment,t),h(R.$$.fragment,t),ft=!0)},o(t){M(f.$$.fragment,t),M(T.$$.fragment,t),M(y.$$.fragment,t),M(U.$$.fragment,t),M(k.$$.fragment,t),M(x.$$.fragment,t),M(B.$$.fragment,t),M(v.$$.fragment,t),M(G.$$.fragment,t),M(Q.$$.fragment,t),M(R.$$.fragment,t),ft=!1},d(t){t&&(s(z),s(X),s(H),s(F),s(j),s(S),s(w),s(L),s(J),s(P),s(u),s(q),s(D),s(b),s(K),s(O),s($),s(tt),s(et),s(I),s(st),s(lt),s(Z),s(at),s(nt),s(N),s(it),s(C),s(pt),s(mt),s(W),s(ot),s(ct),s(E),s(rt),s(ht),s(_),s(Mt),s(gt),s(dt),s(A)),s(d),g(f,t),g(T,t),g(y,t),g(U,t),g(k,t),g(x,t),g(B,t),g(v,t),g(G,t),g(Q,t),g(R,t)}}}const Xt='{"title":"(Tensorflow) EfficientNet","local":"tensorflow-efficientnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function At(jt){return Et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends Gt{constructor(d){super(),_t(this,d,At,Vt,Wt,{})}}export{St as component};
