import{s as Tt,f as Ut,o as ft,n as gt}from"../chunks/scheduler.f7e1785c.js";import{S as jt,i as bt,g as i,s as n,r as M,A as $t,h as o,f as l,c as a,j as De,u as c,x as p,k as f,y as It,a as s,v as r,d as m,t as d,w as y}from"../chunks/index.d8354395.js";import{T as Gt}from"../chunks/Tip.d2769a7f.js";import{C}from"../chunks/CodeBlock.191e5103.js";import{H as ie,E as vt}from"../chunks/getInferenceSnippets.ce3094f0.js";function Bt(Me){let u,g="Gradio is best suited to the creation of UI clients and MCP servers, but it is also possible to use it as an MCP Client and expose that as a UI.";return{c(){u=i("p"),u.textContent=g},l(w){u=o(w,"P",{"data-svelte-h":!0}),p(u)!=="svelte-1ld6o09"&&(u.textContent=g)},m(w,oe){s(w,u,oe)},p:gt,d(w){w&&l(u)}}}function Wt(Me){let u,g,w,oe,j,ce,b,Ke="In the previous section, we explored how to create an MCP Server using Gradio and connect to it using an MCP Client. In this section, we’re going to explore how to use Gradio as an MCP Client to connect to an MCP Server.",re,J,me,$,Oe="We’ll connect to an MCP server similar to the one we created in the previous section but with additional features, and use it to answer questions.",de,I,ye,G,ue,v,et='Let’s connect to an example MCP Server that is already running on Hugging Face. We’ll use <a href="https://huggingface.co/spaces/abidlabs/mcp-tool-http" rel="nofollow">this one</a> for this example. It’s a space that contains a collection of MCP tools.',we,B,he,W,tt=`<summary>Output</summary> <pre><code>
prime_factors: Compute the prime factorization of a positive integer.
generate_cheetah_image: Generate a cheetah image.
image_orientation: Returns whether image is portrait or landscape.
sepia: Apply a sepia filter to the input image.
</code>
</pre>`,Ce,Q,Je,N,lt="Great, now that you’ve connected to an example MCP Server. Now, you need to use it in an example application.",Te,x,st="First, we need to install the <code>smolagents</code>, Gradio and mcp-client libraries, if we haven’t already:",Ue,k,fe,Z,nt="Now, we can import the necessary libraries and create a simple Gradio interface that uses the MCP Client to connect to the MCP Server.",ge,R,je,H,at="Next, we’ll connect to the MCP Server and get the tools that we can use to answer questions.",be,S,$e,E,it="Now that we have the tools, we can create a simple agent that uses them to answer questions. We’ll just use a simple <code>InferenceClientModel</code> and the default model from <code>smolagents</code> for now.",Ie,V,ot='It is important to pass your api_key to the InferenceClientModel. You can access the token from your huggingface account. <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">check here.</a>, and set the access token with the environment variable  <code>HF_TOKEN</code>.',Ge,_,ve,q,pt="Now, we can create a simple Gradio interface that uses the agent to answer questions.",Be,P,We,A,Mt="And that’s it! We’ve created a simple Gradio interface that uses the MCP Client to connect to the MCP Server and answer questions.",Qe,h,ct,Ne,Y,xe,z,rt="Here’s the complete example of the usage of an MCP Client in Gradio:",ke,X,Ze,F,mt="You’ll notice that we’re closing the MCP Client in the <code>finally</code> block. This is important because the MCP Client is a long-lived object that needs to be closed when the program exits.",Re,L,He,D,dt=`To make your server available to others, you can deploy it to Hugging Face Spaces, just like we did in the previous section.
To deploy your Gradio MCP client to Hugging Face Spaces:`,Se,K,yt="<li><p>Create a new Space on Hugging Face:</p> <ul><li>Go to huggingface.co/spaces</li> <li>Click “Create new Space”</li> <li>Choose “Gradio” as the SDK</li> <li>Name your space (e.g., “mcp-client”)</li></ul></li> <li><p>Update MCP Server URL in the code:</p></li>",Ee,O,Ve,T,ut="<li>Create a <code>requirements.txt</code> file:</li>",_e,ee,qe,U,wt="<li>Push your code to the Space:</li>",Pe,te,Ae,le,ht='Note: While adding remote origin, Refer to <a href="https://huggingface.co/blog/password-git-deprecation" rel="nofollow">password-git-deprecation</a> for adding with AccessToken.',Ye,se,ze,ne,Ct="In this section, we’ve explored how to use Gradio as an MCP Client to connect to an MCP Server. We’ve also seen how to deploy the MCP Client in Hugging Face Spaces.",Xe,ae,Fe,pe,Le;return j=new ie({props:{title:"Gradio as an MCP Client",local:"gradio-as-an-mcp-client",headingTag:"h1"}}),J=new Gt({props:{$$slots:{default:[Bt]},$$scope:{ctx:Me}}}),I=new ie({props:{title:"MCP Client in Gradio",local:"mcp-client-in-gradio",headingTag:"h2"}}),G=new ie({props:{title:"Connect to an example MCP Server",local:"connect-to-an-example-mcp-server",headingTag:"h3"}}),B=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMubWNwX2NsaWVudCUyMGltcG9ydCUyME1DUENsaWVudCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTBBJTIwJTIwJTIwJTIwJTdCJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZhYmlkbGFicy1tY3AtdG9vbC1odHRwLmhmLnNwYWNlJTJGZ3JhZGlvX2FwaSUyRm1jcCUyRnNzZSUyMiU3RCUwQSklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVG9vbHMlMjBmcm9tJTIwdGhlJTIwcmVtb3RlJTIwc2VydmVyJTIwYXJlJTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJTVDbiUyMi5qb2luKGYlMjIlN0J0Lm5hbWUlN0QlM0ElMjAlN0J0LmRlc2NyaXB0aW9uJTdEJTIyJTIwZm9yJTIwdCUyMGluJTIwdG9vbHMpKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents.mcp_client <span class="hljs-keyword">import</span> MCPClient

<span class="hljs-keyword">with</span> MCPClient(
    {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://abidlabs-mcp-tool-http.hf.space/gradio_api/mcp/sse&quot;</span>}
) <span class="hljs-keyword">as</span> tools:
    <span class="hljs-comment"># Tools from the remote server are available</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span>.join(<span class="hljs-string">f&quot;<span class="hljs-subst">{t.name}</span>: <span class="hljs-subst">{t.description}</span>&quot;</span> <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tools))
`,wrap:!1}}),Q=new ie({props:{title:"Connect to the MCP Server from Gradio",local:"connect-to-the-mcp-server-from-gradio",headingTag:"h3"}}),k=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJtY3AlNUQlMjIlMjAlMjJncmFkaW8lNUJtY3AlNUQlMjIlMjBtY3AlMjBmYXN0bWNw",highlighted:'pip install <span class="hljs-string">&quot;smolagents[mcp]&quot;</span> <span class="hljs-string">&quot;gradio[mcp]&quot;</span> mcp fastmcp',wrap:!1}}),R=new C({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWltcG9ydCUyMG9zJTBBJTBBZnJvbSUyMG1jcCUyMGltcG9ydCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMkMlMjBDb2RlQWdlbnQlMkMlMjBUb29sQ29sbGVjdGlvbiUyQyUyME1DUENsaWVudA==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent, ToolCollection, MCPClient`,wrap:!1}}),S=new C({props:{code:"bWNwX2NsaWVudCUyMCUzRCUyME1DUENsaWVudCglMEElMjAlMjAlMjAlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmFiaWRsYWJzLW1jcC10b29sLWh0dHAuaGYuc3BhY2UlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTdEJTIwJTIzJTIwVGhpcyUyMGlzJTIwdGhlJTIwTUNQJTIwQ2xpZW50JTIwd2UlMjBjcmVhdGVkJTIwaW4lMjB0aGUlMjBwcmV2aW91cyUyMHNlY3Rpb24lMEEpJTBBdG9vbHMlMjAlM0QlMjBtY3BfY2xpZW50LmdldF90b29scygp",highlighted:`mcp_client = MCPClient(
    {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://abidlabs-mcp-tool-http.hf.space/gradio_api/mcp/sse&quot;</span>} <span class="hljs-comment"># This is the MCP Client we created in the previous section</span>
)
tools = mcp_client.get_tools()`,wrap:!1}}),_=new C({props:{code:"bW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCh0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMikpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbHMlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKQ==",highlighted:`model = InferenceClientModel(token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>))
agent = CodeAgent(tools=[*tools], model=model)`,wrap:!1}}),P=new C({props:{code:"ZGVtbyUyMCUzRCUyMGdyLkNoYXRJbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RsYW1iZGElMjBtZXNzYWdlJTJDJTIwaGlzdG9yeSUzQSUyMHN0cihhZ2VudC5ydW4obWVzc2FnZSkpJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMm1lc3NhZ2VzJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0QlNUIlMjJQcmltZSUyMGZhY3Rvcml6YXRpb24lMjBvZiUyMDY4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJBZ2VudCUyMHdpdGglMjBNQ1AlMjBUb29scyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMGFnZW50JTIwdGhhdCUyMHVzZXMlMjBNQ1AlMjB0b29scyUyMHRvJTIwYW5zd2VyJTIwcXVlc3Rpb25zLiUyMiUwQSklMEElMEFkZW1vLmxhdW5jaCgp",highlighted:`demo = gr.ChatInterface(
    fn=<span class="hljs-keyword">lambda</span> message, history: <span class="hljs-built_in">str</span>(agent.run(message)),
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
    examples=[<span class="hljs-string">&quot;Prime factorization of 68&quot;</span>],
    title=<span class="hljs-string">&quot;Agent with MCP Tools&quot;</span>,
    description=<span class="hljs-string">&quot;This is a simple agent that uses MCP tools to answer questions.&quot;</span>
)

demo.launch()`,wrap:!1}}),Y=new ie({props:{title:"Complete Example",local:"complete-example",headingTag:"h2"}}),X=new C({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWltcG9ydCUyMG9zJTBBJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUyQyUyME1DUENsaWVudCUwQSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMG1jcF9jbGllbnQlMjAlM0QlMjBNQ1BDbGllbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZhYmlkbGFicy1tY3AtdG9vbC1odHRwLmhmLnNwYWNlJTJGZ3JhZGlvX2FwaSUyRm1jcCUyRnNzZSUyMiU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjB0b29scyUyMCUzRCUyMG1jcF9jbGllbnQuZ2V0X3Rvb2xzKCklMEElMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKHRva2VuJTNEb3MuZ2V0ZW52KCUyMkhVR0dJTkdGQUNFX0FQSV9UT0tFTiUyMikpJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbHMlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJqc29uJTIyJTJDJTIwJTIyYXN0JTIyJTJDJTIwJTIydXJsbGliJTIyJTJDJTIwJTIyYmFzZTY0JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMGRlbW8lMjAlM0QlMjBnci5DaGF0SW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZuJTNEbGFtYmRhJTIwbWVzc2FnZSUyQyUyMGhpc3RvcnklM0ElMjBzdHIoYWdlbnQucnVuKG1lc3NhZ2UpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0QlMjJtZXNzYWdlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEJTVCJTIyQW5hbHl6ZSUyMHRoZSUyMHNlbnRpbWVudCUyMG9mJTIwdGhlJTIwZm9sbG93aW5nJTIwdGV4dCUyMCdUaGlzJTIwaXMlMjBhd2Vzb21lJyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyQWdlbnQlMjB3aXRoJTIwTUNQJTIwVG9vbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlRoaXMlMjBpcyUyMGElMjBzaW1wbGUlMjBhZ2VudCUyMHRoYXQlMjB1c2VzJTIwTUNQJTIwdG9vbHMlMjB0byUyMGFuc3dlciUyMHF1ZXN0aW9ucy4lMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVtby5sYXVuY2goKSUwQWZpbmFsbHklM0ElMEElMjAlMjAlMjAlMjBtY3BfY2xpZW50LmRpc2Nvbm5lY3QoKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent, MCPClient


<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(
        {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://abidlabs-mcp-tool-http.hf.space/gradio_api/mcp/sse&quot;</span>}
    )
    tools = mcp_client.get_tools()

    model = InferenceClientModel(token=os.getenv(<span class="hljs-string">&quot;HUGGINGFACE_API_TOKEN&quot;</span>))
    agent = CodeAgent(tools=[*tools], model=model, additional_authorized_imports=[<span class="hljs-string">&quot;json&quot;</span>, <span class="hljs-string">&quot;ast&quot;</span>, <span class="hljs-string">&quot;urllib&quot;</span>, <span class="hljs-string">&quot;base64&quot;</span>])

    demo = gr.ChatInterface(
        fn=<span class="hljs-keyword">lambda</span> message, history: <span class="hljs-built_in">str</span>(agent.run(message)),
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
        examples=[<span class="hljs-string">&quot;Analyze the sentiment of the following text &#x27;This is awesome&#x27;&quot;</span>],
        title=<span class="hljs-string">&quot;Agent with MCP Tools&quot;</span>,
        description=<span class="hljs-string">&quot;This is a simple agent that uses MCP tools to answer questions.&quot;</span>,
    )

    demo.launch()
<span class="hljs-keyword">finally</span>:
    mcp_client.disconnect()`,wrap:!1}}),L=new ie({props:{title:"Deploying to Hugging Face Spaces",local:"deploying-to-hugging-face-spaces",headingTag:"h2"}}),O=new C({props:{code:"bWNwX2NsaWVudCUyMCUzRCUyME1DUENsaWVudCglMEElMjAlMjAlMjAlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmFiaWRsYWJzLW1jcC10b29sLWh0dHAuaGYuc3BhY2UlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTdEJTBBKQ==",highlighted:`mcp_client = MCPClient(
    {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://abidlabs-mcp-tool-http.hf.space/gradio_api/mcp/sse&quot;</span>}
)`,wrap:!1}}),ee=new C({props:{code:"Z3JhZGlvJTVCbWNwJTVEJTBBc21vbGFnZW50cyU1Qm1jcCU1RA==",highlighted:`gradio[mcp]
smolagents[mcp]`,wrap:!1}}),te=new C({props:{code:"Z2l0JTIwaW5pdCUwQWdpdCUyMGFkZCUyMGFwcC5weSUyMHJlcXVpcmVtZW50cy50eHQlMEFnaXQlMjBjb21taXQlMjAtbSUyMCUyMkluaXRpYWwlMjBjb21taXQlMjIlMEFnaXQlMjByZW1vdGUlMjBhZGQlMjBvcmlnaW4lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGWU9VUl9VU0VSTkFNRSUyRm1jcC1jbGllbnQlMEFnaXQlMjBwdXNoJTIwLXUlMjBvcmlnaW4lMjBtYWlu",highlighted:`git init
git add app.py requirements.txt
git commit -m <span class="hljs-string">&quot;Initial commit&quot;</span>
git remote add origin https://huggingface.co/spaces/YOUR_USERNAME/mcp-client
git push -u origin main`,wrap:!1}}),se=new ie({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),ae=new vt({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit2/gradio-client.mdx"}}),{c(){u=i("meta"),g=n(),w=i("p"),oe=n(),M(j.$$.fragment),ce=n(),b=i("p"),b.textContent=Ke,re=n(),M(J.$$.fragment),me=n(),$=i("p"),$.textContent=Oe,de=n(),M(I.$$.fragment),ye=n(),M(G.$$.fragment),ue=n(),v=i("p"),v.innerHTML=et,we=n(),M(B.$$.fragment),he=n(),W=i("details"),W.innerHTML=tt,Ce=n(),M(Q.$$.fragment),Je=n(),N=i("p"),N.textContent=lt,Te=n(),x=i("p"),x.innerHTML=st,Ue=n(),M(k.$$.fragment),fe=n(),Z=i("p"),Z.textContent=nt,ge=n(),M(R.$$.fragment),je=n(),H=i("p"),H.textContent=at,be=n(),M(S.$$.fragment),$e=n(),E=i("p"),E.innerHTML=it,Ie=n(),V=i("p"),V.innerHTML=ot,Ge=n(),M(_.$$.fragment),ve=n(),q=i("p"),q.textContent=pt,Be=n(),M(P.$$.fragment),We=n(),A=i("p"),A.textContent=Mt,Qe=n(),h=i("iframe"),Ne=n(),M(Y.$$.fragment),xe=n(),z=i("p"),z.textContent=rt,ke=n(),M(X.$$.fragment),Ze=n(),F=i("p"),F.innerHTML=mt,Re=n(),M(L.$$.fragment),He=n(),D=i("p"),D.textContent=dt,Se=n(),K=i("ol"),K.innerHTML=yt,Ee=n(),M(O.$$.fragment),Ve=n(),T=i("ol"),T.innerHTML=ut,_e=n(),M(ee.$$.fragment),qe=n(),U=i("ol"),U.innerHTML=wt,Pe=n(),M(te.$$.fragment),Ae=n(),le=i("p"),le.innerHTML=ht,Ye=n(),M(se.$$.fragment),ze=n(),ne=i("p"),ne.textContent=Ct,Xe=n(),M(ae.$$.fragment),Fe=n(),pe=i("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),g=a(e),w=o(e,"P",{}),De(w).forEach(l),oe=a(e),c(j.$$.fragment,e),ce=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-dztswv"&&(b.textContent=Ke),re=a(e),c(J.$$.fragment,e),me=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1kac943"&&($.textContent=Oe),de=a(e),c(I.$$.fragment,e),ye=a(e),c(G.$$.fragment,e),ue=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1p6tga3"&&(v.innerHTML=et),we=a(e),c(B.$$.fragment,e),he=a(e),W=o(e,"DETAILS",{"data-svelte-h":!0}),p(W)!=="svelte-gt14si"&&(W.innerHTML=tt),Ce=a(e),c(Q.$$.fragment,e),Je=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1fjnzdl"&&(N.textContent=lt),Te=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1pg66mb"&&(x.innerHTML=st),Ue=a(e),c(k.$$.fragment,e),fe=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-2tsitc"&&(Z.textContent=nt),ge=a(e),c(R.$$.fragment,e),je=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-d4u1me"&&(H.textContent=at),be=a(e),c(S.$$.fragment,e),$e=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-jz01ce"&&(E.innerHTML=it),Ie=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-c7bqxg"&&(V.innerHTML=ot),Ge=a(e),c(_.$$.fragment,e),ve=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-ysi4z1"&&(q.textContent=pt),Be=a(e),c(P.$$.fragment,e),We=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1sa2kw9"&&(A.textContent=Mt),Qe=a(e),h=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),De(h).forEach(l),Ne=a(e),c(Y.$$.fragment,e),xe=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1x4853p"&&(z.textContent=rt),ke=a(e),c(X.$$.fragment,e),Ze=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1y1vlqe"&&(F.innerHTML=mt),Re=a(e),c(L.$$.fragment,e),He=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1kft0up"&&(D.textContent=dt),Se=a(e),K=o(e,"OL",{"data-svelte-h":!0}),p(K)!=="svelte-39e5uy"&&(K.innerHTML=yt),Ee=a(e),c(O.$$.fragment,e),Ve=a(e),T=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(T)!=="svelte-4egqr5"&&(T.innerHTML=ut),_e=a(e),c(ee.$$.fragment,e),qe=a(e),U=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(U)!=="svelte-1x5eyx6"&&(U.innerHTML=wt),Pe=a(e),c(te.$$.fragment,e),Ae=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-14w0gvi"&&(le.innerHTML=ht),Ye=a(e),c(se.$$.fragment,e),ze=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-b18oph"&&(ne.textContent=Ct),Xe=a(e),c(ae.$$.fragment,e),Fe=a(e),pe=o(e,"P",{}),De(pe).forEach(l),this.h()},h(){f(u,"name","hf:doc:metadata"),f(u,"content",Qt),Ut(h.src,ct="https://mcp-course-unit2-gradio-client.hf.space")||f(h,"src",ct),f(h,"frameborder","0"),f(h,"width","850"),f(h,"height","450"),f(T,"start","3"),f(U,"start","4")},m(e,t){It(document.head,u),s(e,g,t),s(e,w,t),s(e,oe,t),r(j,e,t),s(e,ce,t),s(e,b,t),s(e,re,t),r(J,e,t),s(e,me,t),s(e,$,t),s(e,de,t),r(I,e,t),s(e,ye,t),r(G,e,t),s(e,ue,t),s(e,v,t),s(e,we,t),r(B,e,t),s(e,he,t),s(e,W,t),s(e,Ce,t),r(Q,e,t),s(e,Je,t),s(e,N,t),s(e,Te,t),s(e,x,t),s(e,Ue,t),r(k,e,t),s(e,fe,t),s(e,Z,t),s(e,ge,t),r(R,e,t),s(e,je,t),s(e,H,t),s(e,be,t),r(S,e,t),s(e,$e,t),s(e,E,t),s(e,Ie,t),s(e,V,t),s(e,Ge,t),r(_,e,t),s(e,ve,t),s(e,q,t),s(e,Be,t),r(P,e,t),s(e,We,t),s(e,A,t),s(e,Qe,t),s(e,h,t),s(e,Ne,t),r(Y,e,t),s(e,xe,t),s(e,z,t),s(e,ke,t),r(X,e,t),s(e,Ze,t),s(e,F,t),s(e,Re,t),r(L,e,t),s(e,He,t),s(e,D,t),s(e,Se,t),s(e,K,t),s(e,Ee,t),r(O,e,t),s(e,Ve,t),s(e,T,t),s(e,_e,t),r(ee,e,t),s(e,qe,t),s(e,U,t),s(e,Pe,t),r(te,e,t),s(e,Ae,t),s(e,le,t),s(e,Ye,t),r(se,e,t),s(e,ze,t),s(e,ne,t),s(e,Xe,t),r(ae,e,t),s(e,Fe,t),s(e,pe,t),Le=!0},p(e,[t]){const Jt={};t&2&&(Jt.$$scope={dirty:t,ctx:e}),J.$set(Jt)},i(e){Le||(m(j.$$.fragment,e),m(J.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(B.$$.fragment,e),m(Q.$$.fragment,e),m(k.$$.fragment,e),m(R.$$.fragment,e),m(S.$$.fragment,e),m(_.$$.fragment,e),m(P.$$.fragment,e),m(Y.$$.fragment,e),m(X.$$.fragment,e),m(L.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),Le=!0)},o(e){d(j.$$.fragment,e),d(J.$$.fragment,e),d(I.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(Q.$$.fragment,e),d(k.$$.fragment,e),d(R.$$.fragment,e),d(S.$$.fragment,e),d(_.$$.fragment,e),d(P.$$.fragment,e),d(Y.$$.fragment,e),d(X.$$.fragment,e),d(L.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),Le=!1},d(e){e&&(l(g),l(w),l(oe),l(ce),l(b),l(re),l(me),l($),l(de),l(ye),l(ue),l(v),l(we),l(he),l(W),l(Ce),l(Je),l(N),l(Te),l(x),l(Ue),l(fe),l(Z),l(ge),l(je),l(H),l(be),l($e),l(E),l(Ie),l(V),l(Ge),l(ve),l(q),l(Be),l(We),l(A),l(Qe),l(h),l(Ne),l(xe),l(z),l(ke),l(Ze),l(F),l(Re),l(He),l(D),l(Se),l(K),l(Ee),l(Ve),l(T),l(_e),l(qe),l(U),l(Pe),l(Ae),l(le),l(Ye),l(ze),l(ne),l(Xe),l(Fe),l(pe)),l(u),y(j,e),y(J,e),y(I,e),y(G,e),y(B,e),y(Q,e),y(k,e),y(R,e),y(S,e),y(_,e),y(P,e),y(Y,e),y(X,e),y(L,e),y(O,e),y(ee,e),y(te,e),y(se,e),y(ae,e)}}}const Qt='{"title":"Gradio as an MCP Client","local":"gradio-as-an-mcp-client","sections":[{"title":"MCP Client in Gradio","local":"mcp-client-in-gradio","sections":[{"title":"Connect to an example MCP Server","local":"connect-to-an-example-mcp-server","sections":[],"depth":3},{"title":"Connect to the MCP Server from Gradio","local":"connect-to-the-mcp-server-from-gradio","sections":[],"depth":3}],"depth":2},{"title":"Complete Example","local":"complete-example","sections":[],"depth":2},{"title":"Deploying to Hugging Face Spaces","local":"deploying-to-hugging-face-spaces","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Nt(Me){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends jt{constructor(u){super(),bt(this,u,Nt,Wt,Tt,{})}}export{St as component};
