import{s as Te,n as _e,o as ke}from"../chunks/scheduler.9039eef2.js";import{S as xe,i as Pe,g as a,s as l,r as V,A as Ce,h as r,f as o,c as n,j as we,u as X,x as s,k as ye,y as Le,a as i,v as Y,d as ee,t as te,w as oe}from"../chunks/index.ded8f90d.js";import{C as $e}from"../chunks/CodeBlock.8580f3e8.js";import{H as ie}from"../chunks/Heading.f027f30d.js";function je(le){let c,M,$,H,d,O,p,ne=`As reinforcement learning algorithms are historically challenging to debug, it’s important to pay careful attention to logging.
By default, the TRL <a href="/docs/trl/v0.7.10/en/trainer#trl.PPOTrainer">PPOTrainer</a> saves a lot of relevant information to <code>wandb</code> or <code>tensorboard</code>.`,q,h,ae='Upon initialization, pass one of these two options to the <a href="/docs/trl/v0.7.10/en/trainer#trl.PPOConfig">PPOConfig</a>:',z,m,U,f,re="If you want to log with tensorboard, add the kwarg <code>project_kwargs={&quot;logging_dir&quot;: PATH_TO_LOGS}</code> to the PPOConfig.",A,u,K,g,se="Here’s a brief explanation for the logged metrics provided in the data:",I,v,ce="Key metrics to monitor. We want to maximize the reward, maintain a low KL divergence, and maximize entropy:",J,b,de="<li><code>env/reward_mean</code>: The average reward obtained from the environment. Alias <code>ppo/mean_scores</code>, which is sed to specifically monitor the reward model.</li> <li><code>env/reward_std</code>: The standard deviation of the reward obtained from the environment. Alias `<code>ppo/std_scores</code>, which is sed to specifically monitor the reward model.</li> <li><code>env/reward_dist</code>: The histogram distribution of the reward obtained from the environment.</li> <li><code>objective/kl</code>: The mean Kullback-Leibler (KL) divergence between the old and new policies. It measures how much the new policy deviates from the old policy. The KL divergence is used to compute the KL penalty in the objective function.</li> <li><code>objective/kl_dist</code>: The histogram distribution of the <code>objective/kl</code>.</li> <li><code>objective/kl_coef</code>: The coefficient for Kullback-Leibler (KL) divergence in the objective function.</li> <li><code>ppo/mean_non_score_reward</code>: The <strong>KL penalty</strong> calculated by <code>objective/kl * objective/kl_coef</code> as the total reward for optimization to prevent the new policy from deviating too far from the old policy.</li> <li><code>objective/entropy</code>: The entropy of the model’s policy, calculated by <code>-logprobs.sum(-1).mean()</code>. High entropy means the model’s actions are more random, which can be beneficial for exploration.</li>",E,w,pe="Training stats:",S,y,he='<li><code>ppo/learning_rate</code>: The learning rate for the PPO algorithm.</li> <li><code>ppo/policy/entropy</code>: The entropy of the model’s policy, calculated by <code>pd = torch.nn.functional.softmax(logits, dim=-1); entropy = torch.logsumexp(logits, dim=-1) - torch.sum(pd * logits, dim=-1)</code>. It measures the randomness of the policy.</li> <li><code>ppo/policy/clipfrac</code>: The fraction of probability ratios (old policy / new policy) that fell outside the clipping range in the PPO objective. This can be used to monitor the optimization process.</li> <li><code>ppo/policy/approxkl</code>: The approximate KL divergence between the old and new policies, measured by <code>0.5 * masked_mean((logprobs - old_logprobs) ** 2, mask)</code>, corresponding to the <code>k2</code> estimator in <a href="http://joschu.net/blog/kl-approx.html" rel="nofollow">http://joschu.net/blog/kl-approx.html</a></li> <li><code>ppo/policy/policykl</code>: Similar to <code>ppo/policy/approxkl</code>, but measured by <code>masked_mean(old_logprobs - logprobs, mask)</code>, corresponding to the <code>k1</code> estimator in <a href="http://joschu.net/blog/kl-approx.html" rel="nofollow">http://joschu.net/blog/kl-approx.html</a></li> <li><code>ppo/policy/ratio</code>:  The histogram distribution of the ratio between the new and old policies, used to compute the PPO objective.</li> <li><code>ppo/policy/advantages_mean</code>: The average of the GAE (Generalized Advantage Estimation) advantage estimates. The advantage function measures how much better an action is compared to the average action at a state.</li> <li><code>ppo/policy/advantages</code>: The histogram distribution of <code>ppo/policy/advantages_mean</code>.</li> <li><code>ppo/returns/mean</code>: The mean of the TD(λ) returns, calculated by <code>returns = advantage + values</code>, another indicator of model performance. See <a href="https://iclr-blog-track.github.io/2022/03/25/ppo-implementation-details/" rel="nofollow">https://iclr-blog-track.github.io/2022/03/25/ppo-implementation-details/</a> for more details.</li> <li><code>ppo/returns/var</code>: The variance of the TD(λ) returns, calculated by <code>returns = advantage + values</code>, another indicator of model performance.</li> <li><code>ppo/val/mean</code>: The mean of the values, used to monitor the value function’s performance.</li> <li><code>ppo/val/var</code> : The variance of the values, used to monitor the value function’s performance.</li> <li><code>ppo/val/var_explained</code>: The explained variance for the value function, used to monitor the value function’s performance.</li> <li><code>ppo/val/clipfrac</code>: The fraction of the value function’s predicted values that are clipped.</li> <li><code>ppo/val/vpred</code>: The predicted values from the value function.</li> <li><code>ppo/val/error</code>: The mean squared error between the <code>ppo/val/vpred</code> and returns, used to monitor the value function’s performance.</li> <li><code>ppo/loss/policy</code>: The policy loss for the Proximal Policy Optimization (PPO) algorithm.</li> <li><code>ppo/loss/value</code>: The loss for the value function in the PPO algorithm. This value quantifies how well the function estimates the expected future rewards.</li> <li><code>ppo/loss/total</code>: The total loss for the PPO algorithm. It is the sum of the policy loss and the value function loss.</li>',G,T,me="Stats on queries, responses, and logprobs:",Z,_,fe="<li><code>tokens/queries_len_mean</code>: The average length of the queries tokens.</li> <li><code>tokens/queries_len_std</code>: The standard deviation of the length of the queries tokens.</li> <li><code>tokens/queries_dist</code>: The histogram distribution of the length of the queries tokens.</li> <li><code>tokens/responses_len_mean</code>: The average length of the responses tokens.</li> <li><code>tokens/responses_len_std</code>: The standard deviation of the length of the responses tokens.</li> <li><code>tokens/responses_dist</code>: The histogram distribution of the length of the responses tokens. (Costa: inconsistent naming, should be <code>tokens/responses_len_dist</code>)</li> <li><code>objective/logprobs</code>: The histogram distribution of the log probabilities of the actions taken by the model.</li> <li><code>objective/ref_logprobs</code>: The histogram distribution of the log probabilities of the actions taken by the reference model.</li>",B,k,R,x,ue="During training, many values are logged, here are the most important ones:",D,P,ge="<li><code>env/reward_mean</code>,<code>env/reward_std</code>, <code>env/reward_dist</code>: the properties of the reward distribution from the “environment” /  reward model</li> <li><code>ppo/mean_non_score_reward</code>: The mean negated KL penalty during training (shows the delta between the reference model and the new policy over the batch in the step)</li>",N,C,ve="Here are some parameters that are useful to monitor for stability (when these diverge or collapse to 0, try tuning variables):",W,L,be="<li><code>ppo/loss/value</code>: it will spike / NaN when not going well.</li> <li><code>ppo/policy/ratio</code>: <code>ratio</code> being 1 is a baseline value, meaning that the probability of sampling a token is the same under the new and old policy. If the ratio is too high like 200, it means the probability of sampling a token is 200 times higher under the new policy than the old policy. This is a sign that the new policy is too different from the old policy, which will likely cause overoptimization and collapse training later on.</li> <li><code>ppo/policy/clipfrac</code> and <code>ppo/policy/approxkl</code>: if <code>ratio</code> is too high, the <code>ratio</code> is going to get clipped, resulting in high <code>clipfrac</code> and high <code>approxkl</code> as well.</li> <li><code>objective/kl</code>: it should stay positive so that the policy is not too far away from the reference policy.</li> <li><code>objective/kl_coef</code>: The target coefficient with <code>AdaptiveKLController</code>. Often increases before numerical instabilities.</li>",Q,j,F;return d=new ie({props:{title:"Logging",local:"logging",headingTag:"h1"}}),m=new $e({props:{code:"Y29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RhcmdzLm1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBsb2dfd2l0aCUzRCU2MHdhbmRiJTYwJTJDJTIwJTIzJTIwb3IlMjAlNjB0ZW5zb3Jib2FyZCU2MCUwQSk=",highlighted:'config = PPOConfig(\n    model_name=args.model_name,\n    log_with=`wandb`, # <span class="hljs-literal">or</span> `tensorboard`\n)',wrap:!1}}),u=new ie({props:{title:"PPO Logging",local:"ppo-logging",headingTag:"h2"}}),k=new ie({props:{title:"Crucial values",local:"crucial-values",headingTag:"h3"}}),{c(){c=a("meta"),M=l(),$=a("p"),H=l(),V(d.$$.fragment),O=l(),p=a("p"),p.innerHTML=ne,q=l(),h=a("p"),h.innerHTML=ae,z=l(),V(m.$$.fragment),U=l(),f=a("p"),f.innerHTML=re,A=l(),V(u.$$.fragment),K=l(),g=a("p"),g.textContent=se,I=l(),v=a("p"),v.textContent=ce,J=l(),b=a("ol"),b.innerHTML=de,E=l(),w=a("p"),w.textContent=pe,S=l(),y=a("ol"),y.innerHTML=he,G=l(),T=a("p"),T.textContent=me,Z=l(),_=a("ol"),_.innerHTML=fe,B=l(),V(k.$$.fragment),R=l(),x=a("p"),x.textContent=ue,D=l(),P=a("ol"),P.innerHTML=ge,N=l(),C=a("p"),C.textContent=ve,W=l(),L=a("ol"),L.innerHTML=be,Q=l(),j=a("p"),this.h()},l(e){const t=Ce("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(o),M=n(e),$=r(e,"P",{}),we($).forEach(o),H=n(e),X(d.$$.fragment,e),O=n(e),p=r(e,"P",{"data-svelte-h":!0}),s(p)!=="svelte-j9589o"&&(p.innerHTML=ne),q=n(e),h=r(e,"P",{"data-svelte-h":!0}),s(h)!=="svelte-2tftq9"&&(h.innerHTML=ae),z=n(e),X(m.$$.fragment,e),U=n(e),f=r(e,"P",{"data-svelte-h":!0}),s(f)!=="svelte-9gqjy4"&&(f.innerHTML=re),A=n(e),X(u.$$.fragment,e),K=n(e),g=r(e,"P",{"data-svelte-h":!0}),s(g)!=="svelte-50qxhy"&&(g.textContent=se),I=n(e),v=r(e,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1oysg7j"&&(v.textContent=ce),J=n(e),b=r(e,"OL",{"data-svelte-h":!0}),s(b)!=="svelte-1c10na6"&&(b.innerHTML=de),E=n(e),w=r(e,"P",{"data-svelte-h":!0}),s(w)!=="svelte-ma4ajt"&&(w.textContent=pe),S=n(e),y=r(e,"OL",{"data-svelte-h":!0}),s(y)!=="svelte-1eo0hbb"&&(y.innerHTML=he),G=n(e),T=r(e,"P",{"data-svelte-h":!0}),s(T)!=="svelte-1csidm3"&&(T.textContent=me),Z=n(e),_=r(e,"OL",{"data-svelte-h":!0}),s(_)!=="svelte-pvawsw"&&(_.innerHTML=fe),B=n(e),X(k.$$.fragment,e),R=n(e),x=r(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-189bxez"&&(x.textContent=ue),D=n(e),P=r(e,"OL",{"data-svelte-h":!0}),s(P)!=="svelte-wjaroo"&&(P.innerHTML=ge),N=n(e),C=r(e,"P",{"data-svelte-h":!0}),s(C)!=="svelte-1yomxw6"&&(C.textContent=ve),W=n(e),L=r(e,"OL",{"data-svelte-h":!0}),s(L)!=="svelte-zapvl9"&&(L.innerHTML=be),Q=n(e),j=r(e,"P",{}),we(j).forEach(o),this.h()},h(){ye(c,"name","hf:doc:metadata"),ye(c,"content",Me)},m(e,t){Le(document.head,c),i(e,M,t),i(e,$,t),i(e,H,t),Y(d,e,t),i(e,O,t),i(e,p,t),i(e,q,t),i(e,h,t),i(e,z,t),Y(m,e,t),i(e,U,t),i(e,f,t),i(e,A,t),Y(u,e,t),i(e,K,t),i(e,g,t),i(e,I,t),i(e,v,t),i(e,J,t),i(e,b,t),i(e,E,t),i(e,w,t),i(e,S,t),i(e,y,t),i(e,G,t),i(e,T,t),i(e,Z,t),i(e,_,t),i(e,B,t),Y(k,e,t),i(e,R,t),i(e,x,t),i(e,D,t),i(e,P,t),i(e,N,t),i(e,C,t),i(e,W,t),i(e,L,t),i(e,Q,t),i(e,j,t),F=!0},p:_e,i(e){F||(ee(d.$$.fragment,e),ee(m.$$.fragment,e),ee(u.$$.fragment,e),ee(k.$$.fragment,e),F=!0)},o(e){te(d.$$.fragment,e),te(m.$$.fragment,e),te(u.$$.fragment,e),te(k.$$.fragment,e),F=!1},d(e){e&&(o(M),o($),o(H),o(O),o(p),o(q),o(h),o(z),o(U),o(f),o(A),o(K),o(g),o(I),o(v),o(J),o(b),o(E),o(w),o(S),o(y),o(G),o(T),o(Z),o(_),o(B),o(R),o(x),o(D),o(P),o(N),o(C),o(W),o(L),o(Q),o(j)),o(c),oe(d,e),oe(m,e),oe(u,e),oe(k,e)}}}const Me='{"title":"Logging","local":"logging","sections":[{"title":"PPO Logging","local":"ppo-logging","sections":[{"title":"Crucial values","local":"crucial-values","sections":[],"depth":3}],"depth":2}],"depth":1}';function He(le){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ae extends xe{constructor(c){super(),Pe(this,c,He,je,Te,{})}}export{Ae as component};
