import{s as la,f as da,o as ca,n as I}from"../chunks/scheduler.9bc65507.js";import{S as ma,i as pa,g as d,s as a,r as f,A as ha,h as c,f as n,c as r,j as $,u as g,x as h,k as x,y as i,a as l,v as u,d as _,t as b,w as y}from"../chunks/index.707bf1b6.js";import{H as U,g as fa}from"../chunks/Heading.98cce615.js";import{T as kt}from"../chunks/Tip.c2ecdbf4.js";import{D as B}from"../chunks/Docstring.d5156d74.js";import{C as ke}from"../chunks/CodeBlock.54a9f38d.js";import{E as Ie}from"../chunks/ExampleCodeBlock.35e257ed.js";import{P as ga}from"../chunks/PipelineTag.44585822.js";function ua(w){let t,v="Example:",m,p,M;return p=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlaXRDb25maWclMkMlMjBCZWl0TW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQkVpVCUyMGJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBCZWl0Q29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQmVpdE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BeitConfig, BeitModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BEiT beit-base-patch16-224-pt22k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = BeitConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the beit-base-patch16-224-pt22k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=d("p"),t.textContent=v,m=a(),f(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=v),m=r(o),g(p.$$.fragment,o)},m(o,T){l(o,t,T),l(o,m,T),u(p,o,T),M=!0},p:I,i(o){M||(_(p.$$.fragment,o),M=!0)},o(o){b(p.$$.fragment,o),M=!1},d(o){o&&(n(t),n(m)),y(p,o)}}}function _a(w){let t,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=v},l(m){t=c(m,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=v)},m(m,p){l(m,t,p)},p:I,d(m){m&&n(t)}}}function ba(w){let t,v="Example:",m,p,M;return p=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0LXB0MjJrJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmVpdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitModel.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">197</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){t=d("p"),t.textContent=v,m=a(),f(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=v),m=r(o),g(p.$$.fragment,o)},m(o,T){l(o,t,T),l(o,m,T),u(p,o,T),M=!0},p:I,i(o){M||(_(p.$$.fragment,o),M=!0)},o(o){b(p.$$.fragment,o),M=!1},d(o){o&&(n(t),n(m)),y(p,o)}}}function ya(w){let t,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=v},l(m){t=c(m,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=v)},m(m,p){l(m,t,p)},p:I,d(m){m&&n(t)}}}function va(w){let t,v="Examples:",m,p,M;return p=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMiklMEFtb2RlbCUyMCUzRCUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBJTBBbnVtX3BhdGNoZXMlMjAlM0QlMjAobW9kZWwuY29uZmlnLmltYWdlX3NpemUlMjAlMkYlMkYlMjBtb2RlbC5jb25maWcucGF0Y2hfc2l6ZSklMjAqKiUyMDIlMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEElMjMlMjBjcmVhdGUlMjByYW5kb20lMjBib29sZWFuJTIwbWFzayUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9wYXRjaGVzKSUwQWJvb2xfbWFza2VkX3BvcyUyMCUzRCUyMHRvcmNoLnJhbmRpbnQobG93JTNEMCUyQyUyMGhpZ2glM0QyJTJDJTIwc2l6ZSUzRCgxJTJDJTIwbnVtX3BhdGNoZXMpKS5ib29sKCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwocGl4ZWxfdmFsdWVzJTJDJTIwYm9vbF9tYXNrZWRfcG9zJTNEYm9vbF9tYXNrZWRfcG9zKSUwQWxvc3MlMkMlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMkMlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(low=<span class="hljs-number">0</span>, high=<span class="hljs-number">2</span>, size=(<span class="hljs-number">1</span>, num_patches)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, logits = outputs.loss, outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">196</span>, <span class="hljs-number">8192</span>]`,wrap:!1}}),{c(){t=d("p"),t.textContent=v,m=a(),f(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=v),m=r(o),g(p.$$.fragment,o)},m(o,T){l(o,t,T),l(o,m,T),u(p,o,T),M=!0},p:I,i(o){M||(_(p.$$.fragment,o),M=!0)},o(o){b(p.$$.fragment,o),M=!1},d(o){o&&(n(t),n(m)),y(p,o)}}}function Ma(w){let t,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=v},l(m){t=c(m,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=v)},m(m,p){l(m,t,p)},p:I,d(m){m&&n(t)}}}function Ta(w){let t,v="Example:",m,p,M;return p=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCZWl0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=d("p"),t.textContent=v,m=a(),f(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=v),m=r(o),g(p.$$.fragment,o)},m(o,T){l(o,t,T),l(o,m,T),u(p,o,T),M=!0},p:I,i(o){M||(_(p.$$.fragment,o),M=!0)},o(o){b(p.$$.fragment,o),M=!1},d(o){o&&(n(t),n(m)),y(p,o)}}}function wa(w){let t,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=v},l(m){t=c(m,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=v)},m(m,p){l(m,t,p)},p:I,d(m){m&&n(t)}}}function xa(w){let t,v="Examples:",m,p,M;return p=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLWZpbmV0dW5lZC1hZGUtNjQwLTY0MCUyMiklMEFtb2RlbCUyMCUzRCUyMEJlaXRGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLWZpbmV0dW5lZC1hZGUtNjQwLTY0MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjMlMjBsb2dpdHMlMjBhcmUlMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fbGFiZWxzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGgpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-finetuned-ade-640-640&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-finetuned-ade-640-640&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># logits are of shape (batch_size, num_labels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=d("p"),t.textContent=v,m=a(),f(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=v),m=r(o),g(p.$$.fragment,o)},m(o,T){l(o,t,T),l(o,m,T),u(p,o,T),M=!0},p:I,i(o){M||(_(p.$$.fragment,o),M=!0)},o(o){b(p.$$.fragment,o),M=!1},d(o){o&&(n(t),n(m)),y(p,o)}}}function $a(w){let t,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=v},l(m){t=c(m,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=v)},m(m,p){l(m,t,p)},p:I,d(m){m&&n(t)}}}function Ba(w){let t,v="Examples:",m,p,M;return p=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhCZWl0TW9kZWwlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyay1mdDIyayUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhCZWl0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyay1mdDIyayUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxBeitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k-ft22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxBeitModel.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k-ft22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=d("p"),t.textContent=v,m=a(),f(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=v),m=r(o),g(p.$$.fragment,o)},m(o,T){l(o,t,T),l(o,m,T),u(p,o,T),M=!0},p:I,i(o){M||(_(p.$$.fragment,o),M=!0)},o(o){b(p.$$.fragment,o),M=!1},d(o){o&&(n(t),n(m)),y(p,o)}}}function ja(w){let t,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=v},l(m){t=c(m,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=v)},m(m,p){l(m,t,p)},p:I,d(m){m&&n(t)}}}function Ca(w){let t,v="Examples:",m,p,M;return p=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBbW9kZWwlMjAlM0QlMjBCZWl0Rm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0LXB0MjJrJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=d("p"),t.textContent=v,m=a(),f(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=v),m=r(o),g(p.$$.fragment,o)},m(o,T){l(o,t,T),l(o,m,T),u(p,o,T),M=!0},p:I,i(o){M||(_(p.$$.fragment,o),M=!0)},o(o){b(p.$$.fragment,o),M=!1},d(o){o&&(n(t),n(m)),y(p,o)}}}function Fa(w){let t,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=v},l(m){t=c(m,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=v)},m(m,p){l(m,t,p)},p:I,d(m){m&&n(t)}}}function Ia(w){let t,v="Example:",m,p,M;return p=new ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhCZWl0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEJlaXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxBeitForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxBeitForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`,wrap:!1}}),{c(){t=d("p"),t.textContent=v,m=a(),f(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=v),m=r(o),g(p.$$.fragment,o)},m(o,T){l(o,t,T),l(o,m,T),u(p,o,T),M=!0},p:I,i(o){M||(_(p.$$.fragment,o),M=!0)},o(o){b(p.$$.fragment,o),M=!1},d(o){o&&(n(t),n(m)),y(p,o)}}}function ka(w){let t,v,m,p,M,o,T,bo,Je,hs=`The BEiT model was proposed in <a href="https://arxiv.org/abs/2106.08254" rel="nofollow">BEiT: BERT Pre-Training of Image Transformers</a> by
Hangbo Bao, Li Dong and Furu Wei. Inspired by BERT, BEiT is the first paper that makes self-supervised pre-training of
Vision Transformers (ViTs) outperform supervised pre-training. Rather than pre-training the model to predict the class
of an image (as done in the <a href="https://arxiv.org/abs/2010.11929" rel="nofollow">original ViT paper</a>), BEiT models are pre-trained to
predict visual tokens from the codebook of OpenAI’s <a href="https://arxiv.org/abs/2102.12092" rel="nofollow">DALL-E model</a> given masked
patches.`,yo,ze,fs="The abstract from the paper is the following:",vo,We,gs=`<em>We introduce a self-supervised vision representation model BEiT, which stands for Bidirectional Encoder representation
from Image Transformers. Following BERT developed in the natural language processing area, we propose a masked image
modeling task to pretrain vision Transformers. Specifically, each image has two views in our pre-training, i.e, image
patches (such as 16x16 pixels), and visual tokens (i.e., discrete tokens). We first “tokenize” the original image into
visual tokens. Then we randomly mask some image patches and fed them into the backbone Transformer. The pre-training
objective is to recover the original visual tokens based on the corrupted image patches. After pre-training BEiT, we
directly fine-tune the model parameters on downstream tasks by appending task layers upon the pretrained encoder.
Experimental results on image classification and semantic segmentation show that our model achieves competitive results
with previous pre-training methods. For example, base-size BEiT achieves 83.2% top-1 accuracy on ImageNet-1K,
significantly outperforming from-scratch DeiT training (81.8%) with the same setup. Moreover, large-size BEiT obtains
86.3% only using ImageNet-1K, even outperforming ViT-L with supervised pre-training on ImageNet-22K (85.2%).</em>`,Mo,Ue,us="Tips:",To,Ze,_s=`<li>BEiT models are regular Vision Transformers, but pre-trained in a self-supervised way rather than supervised. They
outperform both the <a href="vit">original model (ViT)</a> as well as <a href="deit">Data-efficient Image Transformers (DeiT)</a> when fine-tuned on ImageNet-1K and CIFAR-100. You can check out demo notebooks regarding inference as well as
fine-tuning on custom data <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/VisionTransformer" rel="nofollow">here</a> (you can just replace
<a href="/docs/transformers/v4.35.1/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> by <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> and
<a href="/docs/transformers/v4.35.1/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a> by <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a>).</li> <li>There’s also a demo notebook available which showcases how to combine DALL-E’s image tokenizer with BEiT for
performing masked image modeling. You can find it <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/BEiT" rel="nofollow">here</a>.</li> <li>As the BEiT models expect each image to be of the same size (resolution), one can use
<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> to resize (or rescale) and normalize images for the model.</li> <li>Both the patch resolution and image resolution used during pre-training or fine-tuning are reflected in the name of
each checkpoint. For example, <code>microsoft/beit-base-patch16-224</code> refers to a base-sized architecture with patch
resolution of 16x16 and fine-tuning resolution of 224x224. All checkpoints can be found on the <a href="https://huggingface.co/models?search=microsoft/beit" rel="nofollow">hub</a>.</li> <li>The available checkpoints are either (1) pre-trained on <a href="http://www.image-net.org/" rel="nofollow">ImageNet-22k</a> (a collection of
14 million images and 22k classes) only, (2) also fine-tuned on ImageNet-22k or (3) also fine-tuned on <a href="http://www.image-net.org/challenges/LSVRC/2012/" rel="nofollow">ImageNet-1k</a> (also referred to as ILSVRC 2012, a collection of 1.3 million
images and 1,000 classes).</li> <li>BEiT uses relative position embeddings, inspired by the T5 model. During pre-training, the authors shared the
relative position bias among the several self-attention layers. During fine-tuning, each layer’s relative position
bias is initialized with the shared relative position bias obtained after pre-training. Note that, if one wants to
pre-train a model from scratch, one needs to either set the <code>use_relative_position_bias</code> or the
<code>use_relative_position_bias</code> attribute of <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> to <code>True</code> in order to add
position embeddings.</li>`,wo,ie,bs,xo,Ne,ys='BEiT pre-training. Taken from the <a href="https://arxiv.org/abs/2106.08254">original paper.</a>',$o,Pe,vs=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The JAX/FLAX version of this model was
contributed by <a href="https://huggingface.co/kamalkraj" rel="nofollow">kamalkraj</a>. The original code can be found <a href="https://github.com/microsoft/unilm/tree/master/beit" rel="nofollow">here</a>.`,Bo,Le,jo,Ee,Ms="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with BEiT.",Co,Re,Fo,Se,Ts='<li><a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',Io,Ve,ws="<strong>Semantic segmentation</strong>",ko,Xe,xs='<li><a href="../tasks/semantic_segmentation">Semantic segmentation task guide</a></li>',Jo,Ge,$s="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",zo,He,Wo,te,qe,sn,Jt,Bs='Class for outputs of <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitModel">BeitModel</a>.',Uo,oe,Ye,an,zt,js='Class for outputs of <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a>.',Zo,De,No,G,Ae,rn,Wt,Cs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitModel">BeitModel</a>. It is used to instantiate an BEiT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the BEiT
<a href="https://huggingface.co/microsoft/beit-base-patch16-224-pt22k" rel="nofollow">microsoft/beit-base-patch16-224-pt22k</a> architecture.`,ln,le,Po,Qe,Lo,H,Oe,dn,Ut,Ke,cn,de,et,mn,Zt,Fs='Converts the output of <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',Eo,tt,Ro,Z,ot,pn,Nt,Is="Constructs a BEiT image processor.",hn,ce,nt,fn,Pt,ks="Preprocess an image or batch of images.",gn,me,st,un,Lt,Js='Converts the output of <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',So,at,Vo,q,rt,_n,Et,zs=`The bare Beit Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,bn,L,it,yn,Rt,Ws='The <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitModel">BeitModel</a> forward method, overrides the <code>__call__</code> special method.',vn,pe,Mn,he,Xo,lt,Go,Y,dt,Tn,St,Us=`Beit Model transformer with a ‘language’ modeling head on top. BEiT does masked image modeling by predicting
visual tokens of a Vector-Quantize Variational Autoencoder (VQ-VAE), whereas other vision models like ViT and DeiT
predict RGB pixel values. As a result, this class is incompatible with <a href="/docs/transformers/v4.35.1/en/model_doc/auto#transformers.AutoModelForMaskedImageModeling">AutoModelForMaskedImageModeling</a>, so you
will need to use <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitForMaskedImageModeling">BeitForMaskedImageModeling</a> directly if you wish to do masked image modeling with BEiT.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,wn,E,ct,xn,Vt,Zs='The <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitForMaskedImageModeling">BeitForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',$n,fe,Bn,ge,Ho,mt,qo,N,pt,jn,Xt,Ns=`Beit Model transformer with an image classification head on top (a linear layer on top of the average of the final
hidden states of the patch tokens) e.g. for ImageNet.`,Cn,Gt,Ps=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Fn,R,ht,In,Ht,Ls='The <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',kn,ue,Jn,_e,Yo,ft,Do,P,gt,zn,qt,Es="Beit Model transformer with a semantic segmentation head on top e.g. for ADE20k, CityScapes.",Wn,Yt,Rs=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Un,S,ut,Zn,Dt,Ss='The <a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Nn,be,Pn,ye,Ao,_t,Qo,j,bt,Ln,At,Vs="The bare Beit Model transformer outputting raw hidden-states without any specific head on top.",En,Qt,Xs=`This model inherits from <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Rn,Ot,Gs=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,Sn,Kt,Hs="Finally, this model supports inherent JAX features such as:",Vn,eo,qs='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Xn,V,yt,Gn,to,Ys="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Hn,ve,qn,Me,Oo,vt,Ko,C,Mt,Yn,oo,Ds="Beit Model transformer with a ‘language’ modeling head on top (to predict visual tokens).",Dn,no,As=`This model inherits from <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,An,so,Qs=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,Qn,ao,Os="Finally, this model supports inherent JAX features such as:",On,ro,Ks='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Kn,k,Tt,es,io,ea="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",ts,Te,os,lo,ta=`bool_masked_pos (<code>numpy.ndarray</code> of shape <code>(batch_size, num_patches)</code>):
Boolean masked positions. Indicates which patches are masked (1) and which aren’t (0).`,ns,we,en,wt,tn,F,xt,ss,co,oa=`Beit Model transformer with an image classification head on top (a linear layer on top of the average of the final
hidden states of the patch tokens) e.g. for ImageNet.`,as,mo,na=`This model inherits from <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,rs,po,sa=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,is,ho,aa="Finally, this model supports inherent JAX features such as:",ls,fo,ra='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',ds,X,$t,cs,go,ia="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",ms,xe,ps,$e,on,uo,nn;return M=new U({props:{title:"BEiT",local:"beit",headingTag:"h1"}}),T=new U({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Le=new U({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Re=new ga({props:{pipeline:"image-classification"}}),He=new U({props:{title:"BEiT specific outputs",local:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",headingTag:"h2"}}),qe=new B({props:{name:"class transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"pooler_output",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.`,name:"pooler_output"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_beit.py#L68"}}),Ye=new B({props:{name:"class transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling",anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"pooler_output",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.`,name:"pooler_output"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_flax_beit.py#L45"}}),De=new U({props:{title:"BeitConfig",local:"transformers.BeitConfig",headingTag:"h2"}}),Ae=new B({props:{name:"class transformers.BeitConfig",anchor:"transformers.BeitConfig",parameters:[{name:"vocab_size",val:" = 8192"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"use_mask_token",val:" = False"},{name:"use_absolute_position_embeddings",val:" = False"},{name:"use_relative_position_bias",val:" = False"},{name:"use_shared_relative_position_bias",val:" = False"},{name:"layer_scale_init_value",val:" = 0.1"},{name:"drop_path_rate",val:" = 0.1"},{name:"use_mean_pooling",val:" = True"},{name:"out_indices",val:" = [3, 5, 7, 11]"},{name:"pool_scales",val:" = [1, 2, 3, 6]"},{name:"use_auxiliary_head",val:" = True"},{name:"auxiliary_loss_weight",val:" = 0.4"},{name:"auxiliary_channels",val:" = 256"},{name:"auxiliary_num_convs",val:" = 1"},{name:"auxiliary_concat_input",val:" = False"},{name:"semantic_loss_ignore_index",val:" = 255"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeitConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Vocabulary size of the BEiT model. Defines the number of different image tokens that can be used during
pre-training.`,name:"vocab_size"},{anchor:"transformers.BeitConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.BeitConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.BeitConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.BeitConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.BeitConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.BeitConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.BeitConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.BeitConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.BeitConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.BeitConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.BeitConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.BeitConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.BeitConfig.use_mask_token",description:`<strong>use_mask_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a mask token for masked image modeling.`,name:"use_mask_token"},{anchor:"transformers.BeitConfig.use_absolute_position_embeddings",description:`<strong>use_absolute_position_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use BERT-style absolute position embeddings.`,name:"use_absolute_position_embeddings"},{anchor:"transformers.BeitConfig.use_relative_position_bias",description:`<strong>use_relative_position_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use T5-style relative position embeddings in the self-attention layers.`,name:"use_relative_position_bias"},{anchor:"transformers.BeitConfig.use_shared_relative_position_bias",description:`<strong>use_shared_relative_position_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the same relative position embeddings across all self-attention layers of the Transformer.`,name:"use_shared_relative_position_bias"},{anchor:"transformers.BeitConfig.layer_scale_init_value",description:`<strong>layer_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Scale to use in the self-attention layers. 0.1 for base, 1e-5 for large. Set 0 to disable layer scale.`,name:"layer_scale_init_value"},{anchor:"transformers.BeitConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate per sample (when applied in the main path of residual layers).`,name:"drop_path_rate"},{anchor:"transformers.BeitConfig.use_mean_pooling",description:`<strong>use_mean_pooling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to mean pool the final hidden states of the patches instead of using the final hidden state of the
CLS token, before applying the classification head.`,name:"use_mean_pooling"},{anchor:"transformers.BeitConfig.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 5, 7, 11]</code>) &#x2014;
Indices of the feature maps to use for semantic segmentation.`,name:"out_indices"},{anchor:"transformers.BeitConfig.pool_scales",description:`<strong>pool_scales</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 3, 6]</code>) &#x2014;
Pooling scales used in Pooling Pyramid Module applied on the last feature map.`,name:"pool_scales"},{anchor:"transformers.BeitConfig.use_auxiliary_head",description:`<strong>use_auxiliary_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use an auxiliary head during training.`,name:"use_auxiliary_head"},{anchor:"transformers.BeitConfig.auxiliary_loss_weight",description:`<strong>auxiliary_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.4) &#x2014;
Weight of the cross-entropy loss of the auxiliary head.`,name:"auxiliary_loss_weight"},{anchor:"transformers.BeitConfig.auxiliary_channels",description:`<strong>auxiliary_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Number of channels to use in the auxiliary head.`,name:"auxiliary_channels"},{anchor:"transformers.BeitConfig.auxiliary_num_convs",description:`<strong>auxiliary_num_convs</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of convolutional layers to use in the auxiliary head.`,name:"auxiliary_num_convs"},{anchor:"transformers.BeitConfig.auxiliary_concat_input",description:`<strong>auxiliary_concat_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the output of the auxiliary head with the input before the classification layer.`,name:"auxiliary_concat_input"},{anchor:"transformers.BeitConfig.semantic_loss_ignore_index",description:`<strong>semantic_loss_ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
The index that is ignored by the loss function of the semantic segmentation model.`,name:"semantic_loss_ignore_index"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/configuration_beit.py#L36"}}),le=new Ie({props:{anchor:"transformers.BeitConfig.example",$$slots:{default:[ua]},$$scope:{ctx:w}}}),Qe=new U({props:{title:"BeitFeatureExtractor",local:"transformers.BeitFeatureExtractor",headingTag:"h2"}}),Oe=new B({props:{name:"class transformers.BeitFeatureExtractor",anchor:"transformers.BeitFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/feature_extraction_beit.py#L26"}}),Ke=new B({props:{name:"__call__",anchor:"transformers.BeitFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/image_processing_beit.py#L307"}}),et=new B({props:{name:"post_process_semantic_segmentation",anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple] = None"}],parametersDescription:[{anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/image_processing_beit.py#L464",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),tt=new U({props:{title:"BeitImageProcessor",local:"transformers.BeitImageProcessor",headingTag:"h2"}}),ot=new B({props:{name:"class transformers.BeitImageProcessor",anchor:"transformers.BeitImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_rescale",val:": bool = True"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.BeitImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.BeitImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.BeitImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image. If the input size is smaller than <code>crop_size</code> along any edge, the image
is padded with 0&#x2019;s and then center cropped. Can be overridden by the <code>do_center_crop</code> parameter in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.BeitImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Desired output size when applying center-cropping. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.
Can be overridden by the <code>crop_size</code> parameter in the <code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.BeitImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.BeitImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.BeitImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.BeitImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
The mean to use if normalizing the image. This is a float or list of floats of length of the number of
channels of the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.BeitImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
The standard deviation to use if normalizing the image. This is a float or list of floats of length of the
number of channels of the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.BeitImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to reduce all label values of segmentation maps by 1. Usually used for datasets where 0 is
used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k). The
background label will be replaced by 255. Can be overridden by the <code>do_reduce_labels</code> parameter in the
<code>preprocess</code> method.`,name:"do_reduce_labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/image_processing_beit.py#L49"}}),nt=new B({props:{name:"preprocess",anchor:"transformers.BeitImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')], NoneType] = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.BeitImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.BeitImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.BeitImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.BeitImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.BeitImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after center crop. If one edge the image is smaller than <code>crop_size</code>, it will be
padded with zeros and then cropped`,name:"crop_size"},{anchor:"transformers.BeitImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.BeitImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.BeitImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.BeitImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.BeitImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.BeitImageProcessor.preprocess.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_reduce_labels</code>) &#x2014;
Whether or not to reduce all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g.
ADE20k). The background label will be replaced by 255.`,name:"do_reduce_labels"},{anchor:"transformers.BeitImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.BeitImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.BeitImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/image_processing_beit.py#L312"}}),st=new B({props:{name:"post_process_semantic_segmentation",anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple] = None"}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/image_processing_beit.py#L464",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),at=new U({props:{title:"BeitModel",local:"transformers.BeitModel",headingTag:"h2"}}),rt=new B({props:{name:"class transformers.BeitModel",anchor:"transformers.BeitModel",parameters:[{name:"config",val:": BeitConfig"},{name:"add_pooling_layer",val:": bool = True"}],parametersDescription:[{anchor:"transformers.BeitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_beit.py#L608"}}),it=new B({props:{name:"forward",anchor:"transformers.BeitModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.1/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_beit.py#L635",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.models.beit.modeling_beit.BeitModelOutputWithPooling"
>transformers.models.beit.modeling_beit.BeitModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.models.beit.modeling_beit.BeitModelOutputWithPooling"
>transformers.models.beit.modeling_beit.BeitModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pe=new kt({props:{$$slots:{default:[_a]},$$scope:{ctx:w}}}),he=new Ie({props:{anchor:"transformers.BeitModel.forward.example",$$slots:{default:[ba]},$$scope:{ctx:w}}}),lt=new U({props:{title:"BeitForMaskedImageModeling",local:"transformers.BeitForMaskedImageModeling",headingTag:"h2"}}),dt=new B({props:{name:"class transformers.BeitForMaskedImageModeling",anchor:"transformers.BeitForMaskedImageModeling",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_beit.py#L723"}}),ct=new B({props:{name:"forward",anchor:"transformers.BeitForMaskedImageModeling.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitForMaskedImageModeling.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.1/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForMaskedImageModeling.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForMaskedImageModeling.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForMaskedImageModeling.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForMaskedImageModeling.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForMaskedImageModeling.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"},{anchor:"transformers.BeitForMaskedImageModeling.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_beit.py#L737",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new kt({props:{$$slots:{default:[ya]},$$scope:{ctx:w}}}),ge=new Ie({props:{anchor:"transformers.BeitForMaskedImageModeling.forward.example",$$slots:{default:[va]},$$scope:{ctx:w}}}),mt=new U({props:{title:"BeitForImageClassification",local:"transformers.BeitForImageClassification",headingTag:"h2"}}),pt=new B({props:{name:"class transformers.BeitForImageClassification",anchor:"transformers.BeitForImageClassification",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_beit.py#L823"}}),ht=new B({props:{name:"forward",anchor:"transformers.BeitForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.1/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_beit.py#L836",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ue=new kt({props:{$$slots:{default:[Ma]},$$scope:{ctx:w}}}),_e=new Ie({props:{anchor:"transformers.BeitForImageClassification.forward.example",$$slots:{default:[Ta]},$$scope:{ctx:w}}}),ft=new U({props:{title:"BeitForSemanticSegmentation",local:"transformers.BeitForSemanticSegmentation",headingTag:"h2"}}),gt=new B({props:{name:"class transformers.BeitForSemanticSegmentation",anchor:"transformers.BeitForSemanticSegmentation",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForSemanticSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_beit.py#L1146"}}),ut=new B({props:{name:"forward",anchor:"transformers.BeitForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.1/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForSemanticSegmentation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForSemanticSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForSemanticSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForSemanticSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForSemanticSegmentation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth semantic segmentation maps for computing the loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code>, a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_beit.py#L1192",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels, logits_height, logits_width)</code>) — Classification scores for each pixel.</p>
<Tip warning={true}>
<p>The logits returned do not necessarily have the same size as the <code>pixel_values</code> passed as inputs. This is
to avoid doing two interpolations and lose some quality when a user needs to resize the logits to the
original image size as post-processing. You should always check your logits shape and resize as needed.</p>
</Tip>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, patch_size, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),be=new kt({props:{$$slots:{default:[wa]},$$scope:{ctx:w}}}),ye=new Ie({props:{anchor:"transformers.BeitForSemanticSegmentation.forward.example",$$slots:{default:[xa]},$$scope:{ctx:w}}}),_t=new U({props:{title:"FlaxBeitModel",local:"transformers.FlaxBeitModel",headingTag:"h2"}}),bt=new B({props:{name:"class transformers.FlaxBeitModel",anchor:"transformers.FlaxBeitModel",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_flax_beit.py#L744"}}),yt=new B({props:{name:"__call__",anchor:"transformers.FlaxBeitModel.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_flax_beit.py#L631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling"
>transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) — Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.</li>
<li><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling"
>transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ve=new kt({props:{$$slots:{default:[$a]},$$scope:{ctx:w}}}),Me=new Ie({props:{anchor:"transformers.FlaxBeitModel.__call__.example",$$slots:{default:[Ba]},$$scope:{ctx:w}}}),vt=new U({props:{title:"FlaxBeitForMaskedImageModeling",local:"transformers.FlaxBeitForMaskedImageModeling",headingTag:"h2"}}),Mt=new B({props:{name:"class transformers.FlaxBeitForMaskedImageModeling",anchor:"transformers.FlaxBeitForMaskedImageModeling",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitForMaskedImageModeling.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_flax_beit.py#L828"}}),Tt=new B({props:{name:"__call__",anchor:"transformers.FlaxBeitForMaskedImageModeling.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_flax_beit.py#L631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Te=new kt({props:{$$slots:{default:[ja]},$$scope:{ctx:w}}}),we=new Ie({props:{anchor:"transformers.FlaxBeitForMaskedImageModeling.__call__.example",$$slots:{default:[Ca]},$$scope:{ctx:w}}}),wt=new U({props:{title:"FlaxBeitForImageClassification",local:"transformers.FlaxBeitForImageClassification",headingTag:"h2"}}),xt=new B({props:{name:"class transformers.FlaxBeitForImageClassification",anchor:"transformers.FlaxBeitForImageClassification",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitForImageClassification.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_flax_beit.py#L915"}}),$t=new B({props:{name:"__call__",anchor:"transformers.FlaxBeitForImageClassification.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/beit/modeling_flax_beit.py#L631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"
>transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"
>transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),xe=new kt({props:{$$slots:{default:[Fa]},$$scope:{ctx:w}}}),$e=new Ie({props:{anchor:"transformers.FlaxBeitForImageClassification.__call__.example",$$slots:{default:[Ia]},$$scope:{ctx:w}}}),{c(){t=d("meta"),v=a(),m=d("p"),p=a(),f(M.$$.fragment),o=a(),f(T.$$.fragment),bo=a(),Je=d("p"),Je.innerHTML=hs,yo=a(),ze=d("p"),ze.textContent=fs,vo=a(),We=d("p"),We.innerHTML=gs,Mo=a(),Ue=d("p"),Ue.textContent=us,To=a(),Ze=d("ul"),Ze.innerHTML=_s,wo=a(),ie=d("img"),xo=a(),Ne=d("small"),Ne.innerHTML=ys,$o=a(),Pe=d("p"),Pe.innerHTML=vs,Bo=a(),f(Le.$$.fragment),jo=a(),Ee=d("p"),Ee.textContent=Ms,Co=a(),f(Re.$$.fragment),Fo=a(),Se=d("ul"),Se.innerHTML=Ts,Io=a(),Ve=d("p"),Ve.innerHTML=ws,ko=a(),Xe=d("ul"),Xe.innerHTML=xs,Jo=a(),Ge=d("p"),Ge.textContent=$s,zo=a(),f(He.$$.fragment),Wo=a(),te=d("div"),f(qe.$$.fragment),sn=a(),Jt=d("p"),Jt.innerHTML=Bs,Uo=a(),oe=d("div"),f(Ye.$$.fragment),an=a(),zt=d("p"),zt.innerHTML=js,Zo=a(),f(De.$$.fragment),No=a(),G=d("div"),f(Ae.$$.fragment),rn=a(),Wt=d("p"),Wt.innerHTML=Cs,ln=a(),f(le.$$.fragment),Po=a(),f(Qe.$$.fragment),Lo=a(),H=d("div"),f(Oe.$$.fragment),dn=a(),Ut=d("div"),f(Ke.$$.fragment),cn=a(),de=d("div"),f(et.$$.fragment),mn=a(),Zt=d("p"),Zt.innerHTML=Fs,Eo=a(),f(tt.$$.fragment),Ro=a(),Z=d("div"),f(ot.$$.fragment),pn=a(),Nt=d("p"),Nt.textContent=Is,hn=a(),ce=d("div"),f(nt.$$.fragment),fn=a(),Pt=d("p"),Pt.textContent=ks,gn=a(),me=d("div"),f(st.$$.fragment),un=a(),Lt=d("p"),Lt.innerHTML=Js,So=a(),f(at.$$.fragment),Vo=a(),q=d("div"),f(rt.$$.fragment),_n=a(),Et=d("p"),Et.innerHTML=zs,bn=a(),L=d("div"),f(it.$$.fragment),yn=a(),Rt=d("p"),Rt.innerHTML=Ws,vn=a(),f(pe.$$.fragment),Mn=a(),f(he.$$.fragment),Xo=a(),f(lt.$$.fragment),Go=a(),Y=d("div"),f(dt.$$.fragment),Tn=a(),St=d("p"),St.innerHTML=Us,wn=a(),E=d("div"),f(ct.$$.fragment),xn=a(),Vt=d("p"),Vt.innerHTML=Zs,$n=a(),f(fe.$$.fragment),Bn=a(),f(ge.$$.fragment),Ho=a(),f(mt.$$.fragment),qo=a(),N=d("div"),f(pt.$$.fragment),jn=a(),Xt=d("p"),Xt.textContent=Ns,Cn=a(),Gt=d("p"),Gt.innerHTML=Ps,Fn=a(),R=d("div"),f(ht.$$.fragment),In=a(),Ht=d("p"),Ht.innerHTML=Ls,kn=a(),f(ue.$$.fragment),Jn=a(),f(_e.$$.fragment),Yo=a(),f(ft.$$.fragment),Do=a(),P=d("div"),f(gt.$$.fragment),zn=a(),qt=d("p"),qt.textContent=Es,Wn=a(),Yt=d("p"),Yt.innerHTML=Rs,Un=a(),S=d("div"),f(ut.$$.fragment),Zn=a(),Dt=d("p"),Dt.innerHTML=Ss,Nn=a(),f(be.$$.fragment),Pn=a(),f(ye.$$.fragment),Ao=a(),f(_t.$$.fragment),Qo=a(),j=d("div"),f(bt.$$.fragment),Ln=a(),At=d("p"),At.textContent=Vs,En=a(),Qt=d("p"),Qt.innerHTML=Xs,Rn=a(),Ot=d("p"),Ot.innerHTML=Gs,Sn=a(),Kt=d("p"),Kt.textContent=Hs,Vn=a(),eo=d("ul"),eo.innerHTML=qs,Xn=a(),V=d("div"),f(yt.$$.fragment),Gn=a(),to=d("p"),to.innerHTML=Ys,Hn=a(),f(ve.$$.fragment),qn=a(),f(Me.$$.fragment),Oo=a(),f(vt.$$.fragment),Ko=a(),C=d("div"),f(Mt.$$.fragment),Yn=a(),oo=d("p"),oo.textContent=Ds,Dn=a(),no=d("p"),no.innerHTML=As,An=a(),so=d("p"),so.innerHTML=Qs,Qn=a(),ao=d("p"),ao.textContent=Os,On=a(),ro=d("ul"),ro.innerHTML=Ks,Kn=a(),k=d("div"),f(Tt.$$.fragment),es=a(),io=d("p"),io.innerHTML=ea,ts=a(),f(Te.$$.fragment),os=a(),lo=d("p"),lo.innerHTML=ta,ns=a(),f(we.$$.fragment),en=a(),f(wt.$$.fragment),tn=a(),F=d("div"),f(xt.$$.fragment),ss=a(),co=d("p"),co.textContent=oa,as=a(),mo=d("p"),mo.innerHTML=na,rs=a(),po=d("p"),po.innerHTML=sa,is=a(),ho=d("p"),ho.textContent=aa,ls=a(),fo=d("ul"),fo.innerHTML=ra,ds=a(),X=d("div"),f($t.$$.fragment),cs=a(),go=d("p"),go.innerHTML=ia,ms=a(),f(xe.$$.fragment),ps=a(),f($e.$$.fragment),on=a(),uo=d("p"),this.h()},l(e){const s=ha("svelte-u9bgzb",document.head);t=c(s,"META",{name:!0,content:!0}),s.forEach(n),v=r(e),m=c(e,"P",{}),$(m).forEach(n),p=r(e),g(M.$$.fragment,e),o=r(e),g(T.$$.fragment,e),bo=r(e),Je=c(e,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-82fvis"&&(Je.innerHTML=hs),yo=r(e),ze=c(e,"P",{"data-svelte-h":!0}),h(ze)!=="svelte-vfdo9a"&&(ze.textContent=fs),vo=r(e),We=c(e,"P",{"data-svelte-h":!0}),h(We)!=="svelte-s10fc1"&&(We.innerHTML=gs),Mo=r(e),Ue=c(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-axv494"&&(Ue.textContent=us),To=r(e),Ze=c(e,"UL",{"data-svelte-h":!0}),h(Ze)!=="svelte-10irpr1"&&(Ze.innerHTML=_s),wo=r(e),ie=c(e,"IMG",{src:!0,alt:!0,width:!0}),xo=r(e),Ne=c(e,"SMALL",{"data-svelte-h":!0}),h(Ne)!=="svelte-11iyjyp"&&(Ne.innerHTML=ys),$o=r(e),Pe=c(e,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-29336p"&&(Pe.innerHTML=vs),Bo=r(e),g(Le.$$.fragment,e),jo=r(e),Ee=c(e,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-1bkfbxv"&&(Ee.textContent=Ms),Co=r(e),g(Re.$$.fragment,e),Fo=r(e),Se=c(e,"UL",{"data-svelte-h":!0}),h(Se)!=="svelte-19vfo45"&&(Se.innerHTML=Ts),Io=r(e),Ve=c(e,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-1qspi63"&&(Ve.innerHTML=ws),ko=r(e),Xe=c(e,"UL",{"data-svelte-h":!0}),h(Xe)!=="svelte-bnel3y"&&(Xe.innerHTML=xs),Jo=r(e),Ge=c(e,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-1xesile"&&(Ge.textContent=$s),zo=r(e),g(He.$$.fragment,e),Wo=r(e),te=c(e,"DIV",{class:!0});var Bt=$(te);g(qe.$$.fragment,Bt),sn=r(Bt),Jt=c(Bt,"P",{"data-svelte-h":!0}),h(Jt)!=="svelte-12alq5x"&&(Jt.innerHTML=Bs),Bt.forEach(n),Uo=r(e),oe=c(e,"DIV",{class:!0});var jt=$(oe);g(Ye.$$.fragment,jt),an=r(jt),zt=c(jt,"P",{"data-svelte-h":!0}),h(zt)!=="svelte-rwiasp"&&(zt.innerHTML=js),jt.forEach(n),Zo=r(e),g(De.$$.fragment,e),No=r(e),G=c(e,"DIV",{class:!0});var ne=$(G);g(Ae.$$.fragment,ne),rn=r(ne),Wt=c(ne,"P",{"data-svelte-h":!0}),h(Wt)!=="svelte-5yubm3"&&(Wt.innerHTML=Cs),ln=r(ne),g(le.$$.fragment,ne),ne.forEach(n),Po=r(e),g(Qe.$$.fragment,e),Lo=r(e),H=c(e,"DIV",{class:!0});var se=$(H);g(Oe.$$.fragment,se),dn=r(se),Ut=c(se,"DIV",{class:!0});var _o=$(Ut);g(Ke.$$.fragment,_o),_o.forEach(n),cn=r(se),de=c(se,"DIV",{class:!0});var Ct=$(de);g(et.$$.fragment,Ct),mn=r(Ct),Zt=c(Ct,"P",{"data-svelte-h":!0}),h(Zt)!=="svelte-78dg42"&&(Zt.innerHTML=Fs),Ct.forEach(n),se.forEach(n),Eo=r(e),g(tt.$$.fragment,e),Ro=r(e),Z=c(e,"DIV",{class:!0});var D=$(Z);g(ot.$$.fragment,D),pn=r(D),Nt=c(D,"P",{"data-svelte-h":!0}),h(Nt)!=="svelte-ky7k50"&&(Nt.textContent=Is),hn=r(D),ce=c(D,"DIV",{class:!0});var Ft=$(ce);g(nt.$$.fragment,Ft),fn=r(Ft),Pt=c(Ft,"P",{"data-svelte-h":!0}),h(Pt)!=="svelte-1x3yxsa"&&(Pt.textContent=ks),Ft.forEach(n),gn=r(D),me=c(D,"DIV",{class:!0});var It=$(me);g(st.$$.fragment,It),un=r(It),Lt=c(It,"P",{"data-svelte-h":!0}),h(Lt)!=="svelte-78dg42"&&(Lt.innerHTML=Js),It.forEach(n),D.forEach(n),So=r(e),g(at.$$.fragment,e),Vo=r(e),q=c(e,"DIV",{class:!0});var ae=$(q);g(rt.$$.fragment,ae),_n=r(ae),Et=c(ae,"P",{"data-svelte-h":!0}),h(Et)!=="svelte-1wah8ut"&&(Et.innerHTML=zs),bn=r(ae),L=c(ae,"DIV",{class:!0});var A=$(L);g(it.$$.fragment,A),yn=r(A),Rt=c(A,"P",{"data-svelte-h":!0}),h(Rt)!=="svelte-1job5vp"&&(Rt.innerHTML=Ws),vn=r(A),g(pe.$$.fragment,A),Mn=r(A),g(he.$$.fragment,A),A.forEach(n),ae.forEach(n),Xo=r(e),g(lt.$$.fragment,e),Go=r(e),Y=c(e,"DIV",{class:!0});var re=$(Y);g(dt.$$.fragment,re),Tn=r(re),St=c(re,"P",{"data-svelte-h":!0}),h(St)!=="svelte-1ikotkp"&&(St.innerHTML=Us),wn=r(re),E=c(re,"DIV",{class:!0});var Q=$(E);g(ct.$$.fragment,Q),xn=r(Q),Vt=c(Q,"P",{"data-svelte-h":!0}),h(Vt)!=="svelte-1xlfivh"&&(Vt.innerHTML=Zs),$n=r(Q),g(fe.$$.fragment,Q),Bn=r(Q),g(ge.$$.fragment,Q),Q.forEach(n),re.forEach(n),Ho=r(e),g(mt.$$.fragment,e),qo=r(e),N=c(e,"DIV",{class:!0});var O=$(N);g(pt.$$.fragment,O),jn=r(O),Xt=c(O,"P",{"data-svelte-h":!0}),h(Xt)!=="svelte-83lcss"&&(Xt.textContent=Ns),Cn=r(O),Gt=c(O,"P",{"data-svelte-h":!0}),h(Gt)!=="svelte-1gjh92c"&&(Gt.innerHTML=Ps),Fn=r(O),R=c(O,"DIV",{class:!0});var K=$(R);g(ht.$$.fragment,K),In=r(K),Ht=c(K,"P",{"data-svelte-h":!0}),h(Ht)!=="svelte-mpd08l"&&(Ht.innerHTML=Ls),kn=r(K),g(ue.$$.fragment,K),Jn=r(K),g(_e.$$.fragment,K),K.forEach(n),O.forEach(n),Yo=r(e),g(ft.$$.fragment,e),Do=r(e),P=c(e,"DIV",{class:!0});var Be=$(P);g(gt.$$.fragment,Be),zn=r(Be),qt=c(Be,"P",{"data-svelte-h":!0}),h(qt)!=="svelte-olwnwh"&&(qt.textContent=Es),Wn=r(Be),Yt=c(Be,"P",{"data-svelte-h":!0}),h(Yt)!=="svelte-1gjh92c"&&(Yt.innerHTML=Rs),Un=r(Be),S=c(Be,"DIV",{class:!0});var je=$(S);g(ut.$$.fragment,je),Zn=r(je),Dt=c(je,"P",{"data-svelte-h":!0}),h(Dt)!=="svelte-zdy5jd"&&(Dt.innerHTML=Ss),Nn=r(je),g(be.$$.fragment,je),Pn=r(je),g(ye.$$.fragment,je),je.forEach(n),Be.forEach(n),Ao=r(e),g(_t.$$.fragment,e),Qo=r(e),j=c(e,"DIV",{class:!0});var J=$(j);g(bt.$$.fragment,J),Ln=r(J),At=c(J,"P",{"data-svelte-h":!0}),h(At)!=="svelte-yakhoj"&&(At.textContent=Vs),En=r(J),Qt=c(J,"P",{"data-svelte-h":!0}),h(Qt)!=="svelte-ox217z"&&(Qt.innerHTML=Xs),Rn=r(J),Ot=c(J,"P",{"data-svelte-h":!0}),h(Ot)!=="svelte-9ybkh"&&(Ot.innerHTML=Gs),Sn=r(J),Kt=c(J,"P",{"data-svelte-h":!0}),h(Kt)!=="svelte-1pplc4a"&&(Kt.textContent=Hs),Vn=r(J),eo=c(J,"UL",{"data-svelte-h":!0}),h(eo)!=="svelte-1w7z84m"&&(eo.innerHTML=qs),Xn=r(J),V=c(J,"DIV",{class:!0});var Ce=$(V);g(yt.$$.fragment,Ce),Gn=r(Ce),to=c(Ce,"P",{"data-svelte-h":!0}),h(to)!=="svelte-15yd1qb"&&(to.innerHTML=Ys),Hn=r(Ce),g(ve.$$.fragment,Ce),qn=r(Ce),g(Me.$$.fragment,Ce),Ce.forEach(n),J.forEach(n),Oo=r(e),g(vt.$$.fragment,e),Ko=r(e),C=c(e,"DIV",{class:!0});var z=$(C);g(Mt.$$.fragment,z),Yn=r(z),oo=c(z,"P",{"data-svelte-h":!0}),h(oo)!=="svelte-1xpbgj8"&&(oo.textContent=Ds),Dn=r(z),no=c(z,"P",{"data-svelte-h":!0}),h(no)!=="svelte-ox217z"&&(no.innerHTML=As),An=r(z),so=c(z,"P",{"data-svelte-h":!0}),h(so)!=="svelte-9ybkh"&&(so.innerHTML=Qs),Qn=r(z),ao=c(z,"P",{"data-svelte-h":!0}),h(ao)!=="svelte-1pplc4a"&&(ao.textContent=Os),On=r(z),ro=c(z,"UL",{"data-svelte-h":!0}),h(ro)!=="svelte-1w7z84m"&&(ro.innerHTML=Ks),Kn=r(z),k=c(z,"DIV",{class:!0});var ee=$(k);g(Tt.$$.fragment,ee),es=r(ee),io=c(ee,"P",{"data-svelte-h":!0}),h(io)!=="svelte-15yd1qb"&&(io.innerHTML=ea),ts=r(ee),g(Te.$$.fragment,ee),os=r(ee),lo=c(ee,"P",{"data-svelte-h":!0}),h(lo)!=="svelte-1rn5vq7"&&(lo.innerHTML=ta),ns=r(ee),g(we.$$.fragment,ee),ee.forEach(n),z.forEach(n),en=r(e),g(wt.$$.fragment,e),tn=r(e),F=c(e,"DIV",{class:!0});var W=$(F);g(xt.$$.fragment,W),ss=r(W),co=c(W,"P",{"data-svelte-h":!0}),h(co)!=="svelte-83lcss"&&(co.textContent=oa),as=r(W),mo=c(W,"P",{"data-svelte-h":!0}),h(mo)!=="svelte-ox217z"&&(mo.innerHTML=na),rs=r(W),po=c(W,"P",{"data-svelte-h":!0}),h(po)!=="svelte-9ybkh"&&(po.innerHTML=sa),is=r(W),ho=c(W,"P",{"data-svelte-h":!0}),h(ho)!=="svelte-1pplc4a"&&(ho.textContent=aa),ls=r(W),fo=c(W,"UL",{"data-svelte-h":!0}),h(fo)!=="svelte-1w7z84m"&&(fo.innerHTML=ra),ds=r(W),X=c(W,"DIV",{class:!0});var Fe=$(X);g($t.$$.fragment,Fe),cs=r(Fe),go=c(Fe,"P",{"data-svelte-h":!0}),h(go)!=="svelte-15yd1qb"&&(go.innerHTML=ia),ms=r(Fe),g(xe.$$.fragment,Fe),ps=r(Fe),g($e.$$.fragment,Fe),Fe.forEach(n),W.forEach(n),on=r(e),uo=c(e,"P",{}),$(uo).forEach(n),this.h()},h(){x(t,"name","hf:doc:metadata"),x(t,"content",Ja),da(ie.src,bs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/beit_architecture.jpg")||x(ie,"src",bs),x(ie,"alt","drawing"),x(ie,"width","600"),x(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){i(document.head,t),l(e,v,s),l(e,m,s),l(e,p,s),u(M,e,s),l(e,o,s),u(T,e,s),l(e,bo,s),l(e,Je,s),l(e,yo,s),l(e,ze,s),l(e,vo,s),l(e,We,s),l(e,Mo,s),l(e,Ue,s),l(e,To,s),l(e,Ze,s),l(e,wo,s),l(e,ie,s),l(e,xo,s),l(e,Ne,s),l(e,$o,s),l(e,Pe,s),l(e,Bo,s),u(Le,e,s),l(e,jo,s),l(e,Ee,s),l(e,Co,s),u(Re,e,s),l(e,Fo,s),l(e,Se,s),l(e,Io,s),l(e,Ve,s),l(e,ko,s),l(e,Xe,s),l(e,Jo,s),l(e,Ge,s),l(e,zo,s),u(He,e,s),l(e,Wo,s),l(e,te,s),u(qe,te,null),i(te,sn),i(te,Jt),l(e,Uo,s),l(e,oe,s),u(Ye,oe,null),i(oe,an),i(oe,zt),l(e,Zo,s),u(De,e,s),l(e,No,s),l(e,G,s),u(Ae,G,null),i(G,rn),i(G,Wt),i(G,ln),u(le,G,null),l(e,Po,s),u(Qe,e,s),l(e,Lo,s),l(e,H,s),u(Oe,H,null),i(H,dn),i(H,Ut),u(Ke,Ut,null),i(H,cn),i(H,de),u(et,de,null),i(de,mn),i(de,Zt),l(e,Eo,s),u(tt,e,s),l(e,Ro,s),l(e,Z,s),u(ot,Z,null),i(Z,pn),i(Z,Nt),i(Z,hn),i(Z,ce),u(nt,ce,null),i(ce,fn),i(ce,Pt),i(Z,gn),i(Z,me),u(st,me,null),i(me,un),i(me,Lt),l(e,So,s),u(at,e,s),l(e,Vo,s),l(e,q,s),u(rt,q,null),i(q,_n),i(q,Et),i(q,bn),i(q,L),u(it,L,null),i(L,yn),i(L,Rt),i(L,vn),u(pe,L,null),i(L,Mn),u(he,L,null),l(e,Xo,s),u(lt,e,s),l(e,Go,s),l(e,Y,s),u(dt,Y,null),i(Y,Tn),i(Y,St),i(Y,wn),i(Y,E),u(ct,E,null),i(E,xn),i(E,Vt),i(E,$n),u(fe,E,null),i(E,Bn),u(ge,E,null),l(e,Ho,s),u(mt,e,s),l(e,qo,s),l(e,N,s),u(pt,N,null),i(N,jn),i(N,Xt),i(N,Cn),i(N,Gt),i(N,Fn),i(N,R),u(ht,R,null),i(R,In),i(R,Ht),i(R,kn),u(ue,R,null),i(R,Jn),u(_e,R,null),l(e,Yo,s),u(ft,e,s),l(e,Do,s),l(e,P,s),u(gt,P,null),i(P,zn),i(P,qt),i(P,Wn),i(P,Yt),i(P,Un),i(P,S),u(ut,S,null),i(S,Zn),i(S,Dt),i(S,Nn),u(be,S,null),i(S,Pn),u(ye,S,null),l(e,Ao,s),u(_t,e,s),l(e,Qo,s),l(e,j,s),u(bt,j,null),i(j,Ln),i(j,At),i(j,En),i(j,Qt),i(j,Rn),i(j,Ot),i(j,Sn),i(j,Kt),i(j,Vn),i(j,eo),i(j,Xn),i(j,V),u(yt,V,null),i(V,Gn),i(V,to),i(V,Hn),u(ve,V,null),i(V,qn),u(Me,V,null),l(e,Oo,s),u(vt,e,s),l(e,Ko,s),l(e,C,s),u(Mt,C,null),i(C,Yn),i(C,oo),i(C,Dn),i(C,no),i(C,An),i(C,so),i(C,Qn),i(C,ao),i(C,On),i(C,ro),i(C,Kn),i(C,k),u(Tt,k,null),i(k,es),i(k,io),i(k,ts),u(Te,k,null),i(k,os),i(k,lo),i(k,ns),u(we,k,null),l(e,en,s),u(wt,e,s),l(e,tn,s),l(e,F,s),u(xt,F,null),i(F,ss),i(F,co),i(F,as),i(F,mo),i(F,rs),i(F,po),i(F,is),i(F,ho),i(F,ls),i(F,fo),i(F,ds),i(F,X),u($t,X,null),i(X,cs),i(X,go),i(X,ms),u(xe,X,null),i(X,ps),u($e,X,null),l(e,on,s),l(e,uo,s),nn=!0},p(e,[s]){const Bt={};s&2&&(Bt.$$scope={dirty:s,ctx:e}),le.$set(Bt);const jt={};s&2&&(jt.$$scope={dirty:s,ctx:e}),pe.$set(jt);const ne={};s&2&&(ne.$$scope={dirty:s,ctx:e}),he.$set(ne);const se={};s&2&&(se.$$scope={dirty:s,ctx:e}),fe.$set(se);const _o={};s&2&&(_o.$$scope={dirty:s,ctx:e}),ge.$set(_o);const Ct={};s&2&&(Ct.$$scope={dirty:s,ctx:e}),ue.$set(Ct);const D={};s&2&&(D.$$scope={dirty:s,ctx:e}),_e.$set(D);const Ft={};s&2&&(Ft.$$scope={dirty:s,ctx:e}),be.$set(Ft);const It={};s&2&&(It.$$scope={dirty:s,ctx:e}),ye.$set(It);const ae={};s&2&&(ae.$$scope={dirty:s,ctx:e}),ve.$set(ae);const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),Me.$set(A);const re={};s&2&&(re.$$scope={dirty:s,ctx:e}),Te.$set(re);const Q={};s&2&&(Q.$$scope={dirty:s,ctx:e}),we.$set(Q);const O={};s&2&&(O.$$scope={dirty:s,ctx:e}),xe.$set(O);const K={};s&2&&(K.$$scope={dirty:s,ctx:e}),$e.$set(K)},i(e){nn||(_(M.$$.fragment,e),_(T.$$.fragment,e),_(Le.$$.fragment,e),_(Re.$$.fragment,e),_(He.$$.fragment,e),_(qe.$$.fragment,e),_(Ye.$$.fragment,e),_(De.$$.fragment,e),_(Ae.$$.fragment,e),_(le.$$.fragment,e),_(Qe.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(ot.$$.fragment,e),_(nt.$$.fragment,e),_(st.$$.fragment,e),_(at.$$.fragment,e),_(rt.$$.fragment,e),_(it.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(lt.$$.fragment,e),_(dt.$$.fragment,e),_(ct.$$.fragment,e),_(fe.$$.fragment,e),_(ge.$$.fragment,e),_(mt.$$.fragment,e),_(pt.$$.fragment,e),_(ht.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(ft.$$.fragment,e),_(gt.$$.fragment,e),_(ut.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(_t.$$.fragment,e),_(bt.$$.fragment,e),_(yt.$$.fragment,e),_(ve.$$.fragment,e),_(Me.$$.fragment,e),_(vt.$$.fragment,e),_(Mt.$$.fragment,e),_(Tt.$$.fragment,e),_(Te.$$.fragment,e),_(we.$$.fragment,e),_(wt.$$.fragment,e),_(xt.$$.fragment,e),_($t.$$.fragment,e),_(xe.$$.fragment,e),_($e.$$.fragment,e),nn=!0)},o(e){b(M.$$.fragment,e),b(T.$$.fragment,e),b(Le.$$.fragment,e),b(Re.$$.fragment,e),b(He.$$.fragment,e),b(qe.$$.fragment,e),b(Ye.$$.fragment,e),b(De.$$.fragment,e),b(Ae.$$.fragment,e),b(le.$$.fragment,e),b(Qe.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(ot.$$.fragment,e),b(nt.$$.fragment,e),b(st.$$.fragment,e),b(at.$$.fragment,e),b(rt.$$.fragment,e),b(it.$$.fragment,e),b(pe.$$.fragment,e),b(he.$$.fragment,e),b(lt.$$.fragment,e),b(dt.$$.fragment,e),b(ct.$$.fragment,e),b(fe.$$.fragment,e),b(ge.$$.fragment,e),b(mt.$$.fragment,e),b(pt.$$.fragment,e),b(ht.$$.fragment,e),b(ue.$$.fragment,e),b(_e.$$.fragment,e),b(ft.$$.fragment,e),b(gt.$$.fragment,e),b(ut.$$.fragment,e),b(be.$$.fragment,e),b(ye.$$.fragment,e),b(_t.$$.fragment,e),b(bt.$$.fragment,e),b(yt.$$.fragment,e),b(ve.$$.fragment,e),b(Me.$$.fragment,e),b(vt.$$.fragment,e),b(Mt.$$.fragment,e),b(Tt.$$.fragment,e),b(Te.$$.fragment,e),b(we.$$.fragment,e),b(wt.$$.fragment,e),b(xt.$$.fragment,e),b($t.$$.fragment,e),b(xe.$$.fragment,e),b($e.$$.fragment,e),nn=!1},d(e){e&&(n(v),n(m),n(p),n(o),n(bo),n(Je),n(yo),n(ze),n(vo),n(We),n(Mo),n(Ue),n(To),n(Ze),n(wo),n(ie),n(xo),n(Ne),n($o),n(Pe),n(Bo),n(jo),n(Ee),n(Co),n(Fo),n(Se),n(Io),n(Ve),n(ko),n(Xe),n(Jo),n(Ge),n(zo),n(Wo),n(te),n(Uo),n(oe),n(Zo),n(No),n(G),n(Po),n(Lo),n(H),n(Eo),n(Ro),n(Z),n(So),n(Vo),n(q),n(Xo),n(Go),n(Y),n(Ho),n(qo),n(N),n(Yo),n(Do),n(P),n(Ao),n(Qo),n(j),n(Oo),n(Ko),n(C),n(en),n(tn),n(F),n(on),n(uo)),n(t),y(M,e),y(T,e),y(Le,e),y(Re,e),y(He,e),y(qe),y(Ye),y(De,e),y(Ae),y(le),y(Qe,e),y(Oe),y(Ke),y(et),y(tt,e),y(ot),y(nt),y(st),y(at,e),y(rt),y(it),y(pe),y(he),y(lt,e),y(dt),y(ct),y(fe),y(ge),y(mt,e),y(pt),y(ht),y(ue),y(_e),y(ft,e),y(gt),y(ut),y(be),y(ye),y(_t,e),y(bt),y(yt),y(ve),y(Me),y(vt,e),y(Mt),y(Tt),y(Te),y(we),y(wt,e),y(xt),y($t),y(xe),y($e)}}}const Ja='{"title":"BEiT","local":"beit","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"BEiT specific outputs","local":"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling","sections":[],"depth":2},{"title":"BeitConfig","local":"transformers.BeitConfig","sections":[],"depth":2},{"title":"BeitFeatureExtractor","local":"transformers.BeitFeatureExtractor","sections":[],"depth":2},{"title":"BeitImageProcessor","local":"transformers.BeitImageProcessor","sections":[],"depth":2},{"title":"BeitModel","local":"transformers.BeitModel","sections":[],"depth":2},{"title":"BeitForMaskedImageModeling","local":"transformers.BeitForMaskedImageModeling","sections":[],"depth":2},{"title":"BeitForImageClassification","local":"transformers.BeitForImageClassification","sections":[],"depth":2},{"title":"BeitForSemanticSegmentation","local":"transformers.BeitForSemanticSegmentation","sections":[],"depth":2},{"title":"FlaxBeitModel","local":"transformers.FlaxBeitModel","sections":[],"depth":2},{"title":"FlaxBeitForMaskedImageModeling","local":"transformers.FlaxBeitForMaskedImageModeling","sections":[],"depth":2},{"title":"FlaxBeitForImageClassification","local":"transformers.FlaxBeitForImageClassification","sections":[],"depth":2}],"depth":1}';function za(w){return ca(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=fa}),[]}class Sa extends ma{constructor(t){super(),pa(this,t,za,ka,la,{})}}export{Sa as component};
