import{s as Xt,o as kt,n as ze}from"../chunks/scheduler.8c3d61f6.js";import{S as zt,i as Et,g as d,s as i,r as y,A as Vt,h as m,f as s,c as o,j as Rt,u as c,x as f,k as ut,y as Qt,a as l,v as b,d as J,t as h,w as T}from"../chunks/index.da70eac4.js";import{T as ke}from"../chunks/Tip.1d9b8c37.js";import{C as q}from"../chunks/CodeBlock.a9c4becf.js";import{H as ee,E as qt}from"../chunks/getInferenceSnippets.39110341.js";import{H as Wt,a as Gt}from"../chunks/HfOption.6ab18950.js";function Ft(R){let a,U='The <code>CLIPTextModel</code> and <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> aren’t quantized because they’re already small in size and because <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> only has a few <code>torch.nn.Linear</code> layers.';return{c(){a=d("p"),a.innerHTML=U},l(p){a=m(p,"P",{"data-svelte-h":!0}),f(a)!=="svelte-1bd21r0"&&(a.innerHTML=U)},m(p,M){l(p,a,M)},p:ze,d(p){p&&s(a)}}}function It(R){let a,U="Quantizing a model in 8-bit halves the memory-usage:",p,M,u=`bitsandbytes is supported in both Transformers and Diffusers, so you can quantize both the
<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,C,w,S="For Ada and higher-series GPUs. we recommend changing <code>torch_dtype</code> to <code>torch.bfloat16</code>.",W,j,x,_,E,G,D="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",V,X,F,g,te="Let’s generate an image using our quantized models.",I,B,P=`Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the
CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.`,Q,k,A,Z,K='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/8bit.png"/>',z,$,H='When there is enough memory, you can also directly move the pipeline to the GPU with <code>.to(&quot;cuda&quot;)</code> and apply <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> to optimize GPU memory usage.',L,v,Y='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 8-bit models locally with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',N;return j=new ke({props:{warning:!1,$$slots:{default:[Ft]},$$scope:{ctx:R}}}),_=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUlMkMpJTBBJTBBdGV4dF9lbmNvZGVyXzJfOGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUlMkMpJTBBJTBBdHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>,)

text_encoder_2_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>,)

transformer_8bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),X=new q({props:{code:"dHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTJCJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTBBKQ==",highlighted:`transformer_8bit = AutoModel.from_pretrained(
    &quot;black-forest-labs/FLUX.1-dev&quot;,
    subfolder=&quot;transformer&quot;,
    quantization_config=quant_config,
<span class="hljs-addition">+   torch_dtype=torch.float32,</span>
)`,wrap:!1}}),k=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXJfOGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8yJTNEdGV4dF9lbmNvZGVyXzJfOGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKSUwQSUwQXBpcGVfa3dhcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmhlaWdodCUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjJ3aWR0aCUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjJndWlkYW5jZV9zY2FsZSUyMiUzQSUyMDMuNSUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV9pbmZlcmVuY2Vfc3RlcHMlMjIlM0ElMjA1MCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF9zZXF1ZW5jZV9sZW5ndGglMjIlM0ElMjA1MTIlMkMlMEElN0QlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoKipwaXBlX2t3YXJncyUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDApJTJDKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_8bit,
    text_encoder_2=text_encoder_2_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(**pipe_kwargs, generator=torch.manual_seed(<span class="hljs-number">0</span>),).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=d("p"),a.textContent=U,p=i(),M=d("p"),M.innerHTML=u,C=i(),w=d("p"),w.innerHTML=S,W=i(),y(j.$$.fragment),x=i(),y(_.$$.fragment),E=i(),G=d("p"),G.innerHTML=D,V=i(),y(X.$$.fragment),F=i(),g=d("p"),g.textContent=te,I=i(),B=d("p"),B.innerHTML=P,Q=i(),y(k.$$.fragment),A=i(),Z=d("div"),Z.innerHTML=K,z=i(),$=d("p"),$.innerHTML=H,L=i(),v=d("p"),v.innerHTML=Y,this.h()},l(t){a=m(t,"P",{"data-svelte-h":!0}),f(a)!=="svelte-4djpqq"&&(a.textContent=U),p=o(t),M=m(t,"P",{"data-svelte-h":!0}),f(M)!=="svelte-8t0085"&&(M.innerHTML=u),C=o(t),w=m(t,"P",{"data-svelte-h":!0}),f(w)!=="svelte-mdqrzc"&&(w.innerHTML=S),W=o(t),c(j.$$.fragment,t),x=o(t),c(_.$$.fragment,t),E=o(t),G=m(t,"P",{"data-svelte-h":!0}),f(G)!=="svelte-1qozsrk"&&(G.innerHTML=D),V=o(t),c(X.$$.fragment,t),F=o(t),g=m(t,"P",{"data-svelte-h":!0}),f(g)!=="svelte-2bde4h"&&(g.textContent=te),I=o(t),B=m(t,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1eyrcy7"&&(B.innerHTML=P),Q=o(t),c(k.$$.fragment,t),A=o(t),Z=m(t,"DIV",{class:!0,"data-svelte-h":!0}),f(Z)!=="svelte-14afenp"&&(Z.innerHTML=K),z=o(t),$=m(t,"P",{"data-svelte-h":!0}),f($)!=="svelte-uz8m1k"&&($.innerHTML=H),L=o(t),v=m(t,"P",{"data-svelte-h":!0}),f(v)!=="svelte-yt11ie"&&(v.innerHTML=Y),this.h()},h(){ut(Z,"class","flex justify-center")},m(t,r){l(t,a,r),l(t,p,r),l(t,M,r),l(t,C,r),l(t,w,r),l(t,W,r),b(j,t,r),l(t,x,r),b(_,t,r),l(t,E,r),l(t,G,r),l(t,V,r),b(X,t,r),l(t,F,r),l(t,g,r),l(t,I,r),l(t,B,r),l(t,Q,r),b(k,t,r),l(t,A,r),l(t,Z,r),l(t,z,r),l(t,$,r),l(t,L,r),l(t,v,r),N=!0},p(t,r){const O={};r&2&&(O.$$scope={dirty:r,ctx:t}),j.$set(O)},i(t){N||(J(j.$$.fragment,t),J(_.$$.fragment,t),J(X.$$.fragment,t),J(k.$$.fragment,t),N=!0)},o(t){h(j.$$.fragment,t),h(_.$$.fragment,t),h(X.$$.fragment,t),h(k.$$.fragment,t),N=!1},d(t){t&&(s(a),s(p),s(M),s(C),s(w),s(W),s(x),s(E),s(G),s(V),s(F),s(g),s(I),s(B),s(Q),s(A),s(Z),s(z),s($),s(L),s(v)),T(j,t),T(_,t),T(X,t),T(k,t)}}}function At(R){let a,U='The <code>CLIPTextModel</code> and <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> aren’t quantized because they’re already small in size and because <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> only has a few <code>torch.nn.Linear</code> layers.';return{c(){a=d("p"),a.innerHTML=U},l(p){a=m(p,"P",{"data-svelte-h":!0}),f(a)!=="svelte-1bd21r0"&&(a.innerHTML=U)},m(p,M){l(p,a,M)},p:ze,d(p){p&&s(a)}}}function Nt(R){let a,U="Quantizing a model in 4-bit reduces your memory-usage by 4x:",p,M,u=`bitsandbytes is supported in both Transformers and Diffusers, so you can can quantize both the
<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,C,w,S="For Ada and higher-series GPUs. we recommend changing <code>torch_dtype</code> to <code>torch.bfloat16</code>.",W,j,x,_,E,G,D="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",V,X,F,g,te="Let’s generate an image using our quantized models.",I,B,P="Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.",Q,k,A,Z,K='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/4bit.png"/>',z,$,H='When there is enough memory, you can also directly move the pipeline to the GPU with <code>.to(&quot;cuda&quot;)</code> and apply <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> to optimize GPU memory usage.',L,v,Y='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 4-bit models locally with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',N;return j=new ke({props:{warning:!1,$$slots:{default:[At]},$$scope:{ctx:R}}}),_=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>,)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>,)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),X=new q({props:{code:"dHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTJCJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTBBKQ==",highlighted:`transformer_4bit = AutoModel.from_pretrained(
    &quot;black-forest-labs/FLUX.1-dev&quot;,
    subfolder=&quot;transformer&quot;,
    quantization_config=quant_config,
<span class="hljs-addition">+   torch_dtype=torch.float32,</span>
)`,wrap:!1}}),k=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXJfNGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8yJTNEdGV4dF9lbmNvZGVyXzJfNGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKSUwQSUwQXBpcGVfa3dhcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmhlaWdodCUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjJ3aWR0aCUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjJndWlkYW5jZV9zY2FsZSUyMiUzQSUyMDMuNSUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV9pbmZlcmVuY2Vfc3RlcHMlMjIlM0ElMjA1MCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF9zZXF1ZW5jZV9sZW5ndGglMjIlM0ElMjA1MTIlMkMlMEElN0QlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoKipwaXBlX2t3YXJncyUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDApJTJDKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_4bit,
    text_encoder_2=text_encoder_2_4bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(**pipe_kwargs, generator=torch.manual_seed(<span class="hljs-number">0</span>),).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=d("p"),a.textContent=U,p=i(),M=d("p"),M.innerHTML=u,C=i(),w=d("p"),w.innerHTML=S,W=i(),y(j.$$.fragment),x=i(),y(_.$$.fragment),E=i(),G=d("p"),G.innerHTML=D,V=i(),y(X.$$.fragment),F=i(),g=d("p"),g.textContent=te,I=i(),B=d("p"),B.innerHTML=P,Q=i(),y(k.$$.fragment),A=i(),Z=d("div"),Z.innerHTML=K,z=i(),$=d("p"),$.innerHTML=H,L=i(),v=d("p"),v.innerHTML=Y,this.h()},l(t){a=m(t,"P",{"data-svelte-h":!0}),f(a)!=="svelte-i07c71"&&(a.textContent=U),p=o(t),M=m(t,"P",{"data-svelte-h":!0}),f(M)!=="svelte-q3mf8r"&&(M.innerHTML=u),C=o(t),w=m(t,"P",{"data-svelte-h":!0}),f(w)!=="svelte-mdqrzc"&&(w.innerHTML=S),W=o(t),c(j.$$.fragment,t),x=o(t),c(_.$$.fragment,t),E=o(t),G=m(t,"P",{"data-svelte-h":!0}),f(G)!=="svelte-1qozsrk"&&(G.innerHTML=D),V=o(t),c(X.$$.fragment,t),F=o(t),g=m(t,"P",{"data-svelte-h":!0}),f(g)!=="svelte-2bde4h"&&(g.textContent=te),I=o(t),B=m(t,"P",{"data-svelte-h":!0}),f(B)!=="svelte-6ilppp"&&(B.innerHTML=P),Q=o(t),c(k.$$.fragment,t),A=o(t),Z=m(t,"DIV",{class:!0,"data-svelte-h":!0}),f(Z)!=="svelte-qev6y1"&&(Z.innerHTML=K),z=o(t),$=m(t,"P",{"data-svelte-h":!0}),f($)!=="svelte-uz8m1k"&&($.innerHTML=H),L=o(t),v=m(t,"P",{"data-svelte-h":!0}),f(v)!=="svelte-hk0phu"&&(v.innerHTML=Y),this.h()},h(){ut(Z,"class","flex justify-center")},m(t,r){l(t,a,r),l(t,p,r),l(t,M,r),l(t,C,r),l(t,w,r),l(t,W,r),b(j,t,r),l(t,x,r),b(_,t,r),l(t,E,r),l(t,G,r),l(t,V,r),b(X,t,r),l(t,F,r),l(t,g,r),l(t,I,r),l(t,B,r),l(t,Q,r),b(k,t,r),l(t,A,r),l(t,Z,r),l(t,z,r),l(t,$,r),l(t,L,r),l(t,v,r),N=!0},p(t,r){const O={};r&2&&(O.$$scope={dirty:r,ctx:t}),j.$set(O)},i(t){N||(J(j.$$.fragment,t),J(_.$$.fragment,t),J(X.$$.fragment,t),J(k.$$.fragment,t),N=!0)},o(t){h(j.$$.fragment,t),h(_.$$.fragment,t),h(X.$$.fragment,t),h(k.$$.fragment,t),N=!1},d(t){t&&(s(a),s(p),s(M),s(C),s(w),s(W),s(x),s(E),s(G),s(V),s(F),s(g),s(I),s(B),s(Q),s(A),s(Z),s(z),s($),s(L),s(v)),T(j,t),T(_,t),T(X,t),T(k,t)}}}function Ht(R){let a,U,p,M;return a=new Gt({props:{id:"bnb",option:"8-bit",$$slots:{default:[It]},$$scope:{ctx:R}}}),p=new Gt({props:{id:"bnb",option:"4-bit",$$slots:{default:[Nt]},$$scope:{ctx:R}}}),{c(){y(a.$$.fragment),U=i(),y(p.$$.fragment)},l(u){c(a.$$.fragment,u),U=o(u),c(p.$$.fragment,u)},m(u,C){b(a,u,C),l(u,U,C),b(p,u,C),M=!0},p(u,C){const w={};C&2&&(w.$$scope={dirty:C,ctx:u}),a.$set(w);const S={};C&2&&(S.$$scope={dirty:C,ctx:u}),p.$set(S)},i(u){M||(J(a.$$.fragment,u),J(p.$$.fragment,u),M=!0)},o(u){h(a.$$.fragment,u),h(p.$$.fragment,u),M=!1},d(u){u&&s(U),T(a,u),T(p,u)}}}function Yt(R){let a,U="Training with 8-bit and 4-bit weights are only supported for training <em>extra</em> parameters.";return{c(){a=d("p"),a.innerHTML=U},l(p){a=m(p,"P",{"data-svelte-h":!0}),f(a)!=="svelte-of9sym"&&(a.innerHTML=U)},m(p,M){l(p,a,M)},p:ze,d(p){p&&s(a)}}}function xt(R){let a,U='Learn more about the details of 8-bit quantization in this <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blog post</a>!';return{c(){a=d("p"),a.innerHTML=U},l(p){a=m(p,"P",{"data-svelte-h":!0}),f(a)!=="svelte-1bb05fp"&&(a.innerHTML=U)},m(p,M){l(p,a,M)},p:ze,d(p){p&&s(a)}}}function Lt(R){let a,U='Learn more about its details in this <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">blog post</a>.';return{c(){a=d("p"),a.innerHTML=U},l(p){a=m(p,"P",{"data-svelte-h":!0}),f(a)!=="svelte-kpdzjq"&&(a.innerHTML=U)},m(p,M){l(p,a,M)},p:ze,d(p){p&&s(a)}}}function St(R){let a,U,p,M,u,C,w,S='<a href="https://huggingface.co/docs/bitsandbytes/index" rel="nofollow">bitsandbytes</a> is the easiest option for quantizing a model to 8 and 4-bit. 8-bit quantization multiplies outliers in fp16 with non-outliers in int8, converts the non-outlier values back to fp16, and then adds them together to return the weights in fp16. This reduces the degradative effect outlier values have on a model’s performance.',W,j,x='4-bit quantization compresses a model even further, and it is commonly used with <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> to finetune quantized LLMs.',_,E,G=`This guide demonstrates how quantization can enable running
<a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a>
on less than 16GB of VRAM and even on a free Google
Colab instance.`,D,V,X='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/comparison.png" alt="comparison image"/>',F,g,te="To use bitsandbytes, make sure you have the following libraries installed:",I,B,P,Q,k='Now you can quantize a model by passing a <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a> to <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a>. This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',A,Z,K,z,$,H,L="Check your memory footprint with the <code>get_memory_footprint</code> method:",v,Y,N,t,r="Note that this only tells you the memory footprint of the model params and does <em>not</em> estimate the inference memory requirements.",O,ne,yt='Quantized models can be loaded from the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method without needing to specify the <code>quantization_config</code> parameters:',Ee,ae,Ve,ie,Qe,se,qe,oe,ct="This section explores some of the specific features of 8-bit models, such as outlier thresholds and skipping module conversion.",We,re,Fe,pe,bt="An “outlier” is a hidden state value greater than a certain threshold, and these values are computed in fp16. While the values are usually normally distributed ([-3.5, 3.5]), this distribution can be very different for large models ([-60, 6] or [6, 60]). 8-bit quantization works well for values ~5, but beyond that, there is a significant performance penalty. A good default threshold value is 6, but a lower threshold may be needed for more unstable models (small models or finetuning).",Ie,de,Jt='To find the best threshold for your model, we recommend experimenting with the <code>llm_int8_threshold</code> parameter in <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Ae,me,Ne,fe,He,Me,ht='For some models, you don’t need to quantize every module to 8-bit which can actually cause instability. For example, for diffusion models like <a href="../api/pipelines/stable_diffusion/stable_diffusion_3">Stable Diffusion 3</a>, the <code>proj_out</code> module can be skipped using the <code>llm_int8_skip_modules</code> parameter in <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Ye,ue,xe,ye,Le,le,Se,ce,Tt="This section explores some of the specific features of 4-bit models, such as changing the compute data type, using the Normal Float 4 (NF4) data type, and using nested quantization.",De,be,Pe,Je,Ut='To speedup computation, you can change the data type from float32 (the default value) to bf16 using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Ke,he,Oe,Te,et,Ue,wt='NF4 is a 4-bit data type from the <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> paper, adapted for weights initialized from a normal distribution. You should use NF4 for training 4-bit base models. This can be configured with the <code>bnb_4bit_quant_type</code> parameter in the <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',tt,we,st,Ze,Zt="For inference, the <code>bnb_4bit_quant_type</code> does not have a huge impact on performance. However, to remain consistent with the model weights, you should use the <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> values.",lt,je,nt,Ce,jt="Nested quantization is a technique that can save additional memory at no additional performance cost. This feature performs a second quantization of the already quantized weights to save an additional 0.4 bits/parameter.",at,ge,it,Be,ot,_e,Ct="Once quantized, you can dequantize a model to its original precision, but this might result in a small loss of quality. Make sure you have enough GPU RAM to fit the dequantized model.",rt,$e,pt,ve,dt,Re,gt='<li><a href="https://gist.github.com/sayakpaul/c76bd845b48759e11687ac550b99d8b4" rel="nofollow">End-to-end notebook showing Flux.1 Dev inference in a free-tier Colab</a></li> <li><a href="https://github.com/huggingface/diffusers/blob/8c661ea586bf11cb2440da740dd3c4cf84679b85/examples/dreambooth/README_hidream.md#using-quantization" rel="nofollow">Training</a></li>',mt,Ge,ft,Xe,Mt;return u=new ee({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h1"}}),B=new q({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMjAtVQ==",highlighted:"pip install diffusers transformers accelerate bitsandbytes -U",wrap:!1}}),Z=new Wt({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[Ht]},$$scope:{ctx:R}}}),z=new ke({props:{warning:!0,$$slots:{default:[Yt]},$$scope:{ctx:R}}}),Y=new q({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),ae=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl80Yml0JTNEVHJ1ZSklMEElMEFtb2RlbF80Yml0JTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZmx1eC4xLWRldi1uZjQtcGtnJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;hf-internal-testing/flux.1-dev-nf4-pkg&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>
)`,wrap:!1}}),ie=new ee({props:{title:"8-bit (LLM.int8() algorithm)",local:"8-bit-llmint8-algorithm",headingTag:"h2"}}),se=new ke({props:{$$slots:{default:[xt]},$$scope:{ctx:R}}}),re=new ee({props:{title:"Outlier threshold",local:"outlier-threshold",headingTag:"h3"}}),me=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUyMGxsbV9pbnQ4X3RocmVzaG9sZCUzRDEwJTJDJTBBKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_threshold=<span class="hljs-number">10</span>,
)

model_8bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),fe=new ee({props:{title:"Skip module conversion",local:"skip-module-conversion",headingTag:"h3"}}),ue=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUyMGxsbV9pbnQ4X3NraXBfbW9kdWxlcyUzRCU1QiUyMnByb2pfb3V0JTIyJTVEJTJDJTBBKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBTRDNUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bS1kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_skip_modules=[<span class="hljs-string">&quot;proj_out&quot;</span>],
)

model_8bit = SD3Transformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),ye=new ee({props:{title:"4-bit (QLoRA algorithm)",local:"4-bit-qlora-algorithm",headingTag:"h2"}}),le=new ke({props:{$$slots:{default:[Lt]},$$scope:{ctx:R}}}),be=new ee({props:{title:"Compute data type",local:"compute-data-type",headingTag:"h3"}}),he=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),Te=new ee({props:{title:"Normal Float 4 (NF4)",local:"normal-float-4-nf4",headingTag:"h3"}}),we=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),je=new ee({props:{title:"Nested quantization",local:"nested-quantization",headingTag:"h3"}}),ge=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl80Yml0JTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),Be=new ee({props:{title:"Dequantizing bitsandbytes models",local:"dequantizing-bitsandbytes-models",headingTag:"h2"}}),$e=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl80Yml0JTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdC5kZXF1YW50aXplKCklMEF0cmFuc2Zvcm1lcl80Yml0LmRlcXVhbnRpemUoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

text_encoder_2_4bit.dequantize()
transformer_4bit.dequantize()`,wrap:!1}}),ve=new ee({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ge=new qt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/bitsandbytes.md"}}),{c(){a=d("meta"),U=i(),p=d("p"),M=i(),y(u.$$.fragment),C=i(),w=d("p"),w.innerHTML=S,W=i(),j=d("p"),j.innerHTML=x,_=i(),E=d("p"),E.innerHTML=G,D=i(),V=d("p"),V.innerHTML=X,F=i(),g=d("p"),g.textContent=te,I=i(),y(B.$$.fragment),P=i(),Q=d("p"),Q.innerHTML=k,A=i(),y(Z.$$.fragment),K=i(),y(z.$$.fragment),$=i(),H=d("p"),H.innerHTML=L,v=i(),y(Y.$$.fragment),N=i(),t=d("p"),t.innerHTML=r,O=i(),ne=d("p"),ne.innerHTML=yt,Ee=i(),y(ae.$$.fragment),Ve=i(),y(ie.$$.fragment),Qe=i(),y(se.$$.fragment),qe=i(),oe=d("p"),oe.textContent=ct,We=i(),y(re.$$.fragment),Fe=i(),pe=d("p"),pe.textContent=bt,Ie=i(),de=d("p"),de.innerHTML=Jt,Ae=i(),y(me.$$.fragment),Ne=i(),y(fe.$$.fragment),He=i(),Me=d("p"),Me.innerHTML=ht,Ye=i(),y(ue.$$.fragment),xe=i(),y(ye.$$.fragment),Le=i(),y(le.$$.fragment),Se=i(),ce=d("p"),ce.textContent=Tt,De=i(),y(be.$$.fragment),Pe=i(),Je=d("p"),Je.innerHTML=Ut,Ke=i(),y(he.$$.fragment),Oe=i(),y(Te.$$.fragment),et=i(),Ue=d("p"),Ue.innerHTML=wt,tt=i(),y(we.$$.fragment),st=i(),Ze=d("p"),Ze.innerHTML=Zt,lt=i(),y(je.$$.fragment),nt=i(),Ce=d("p"),Ce.textContent=jt,at=i(),y(ge.$$.fragment),it=i(),y(Be.$$.fragment),ot=i(),_e=d("p"),_e.textContent=Ct,rt=i(),y($e.$$.fragment),pt=i(),y(ve.$$.fragment),dt=i(),Re=d("ul"),Re.innerHTML=gt,mt=i(),y(Ge.$$.fragment),ft=i(),Xe=d("p"),this.h()},l(e){const n=Vt("svelte-u9bgzb",document.head);a=m(n,"META",{name:!0,content:!0}),n.forEach(s),U=o(e),p=m(e,"P",{}),Rt(p).forEach(s),M=o(e),c(u.$$.fragment,e),C=o(e),w=m(e,"P",{"data-svelte-h":!0}),f(w)!=="svelte-1m50ob7"&&(w.innerHTML=S),W=o(e),j=m(e,"P",{"data-svelte-h":!0}),f(j)!=="svelte-11pyf03"&&(j.innerHTML=x),_=o(e),E=m(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-1erhi5i"&&(E.innerHTML=G),D=o(e),V=m(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-ryfe7d"&&(V.innerHTML=X),F=o(e),g=m(e,"P",{"data-svelte-h":!0}),f(g)!=="svelte-gf36q7"&&(g.textContent=te),I=o(e),c(B.$$.fragment,e),P=o(e),Q=m(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-17fqaf"&&(Q.innerHTML=k),A=o(e),c(Z.$$.fragment,e),K=o(e),c(z.$$.fragment,e),$=o(e),H=m(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-139tok6"&&(H.innerHTML=L),v=o(e),c(Y.$$.fragment,e),N=o(e),t=m(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-18sn6ad"&&(t.innerHTML=r),O=o(e),ne=m(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-10wvd51"&&(ne.innerHTML=yt),Ee=o(e),c(ae.$$.fragment,e),Ve=o(e),c(ie.$$.fragment,e),Qe=o(e),c(se.$$.fragment,e),qe=o(e),oe=m(e,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-1myadau"&&(oe.textContent=ct),We=o(e),c(re.$$.fragment,e),Fe=o(e),pe=m(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-ur5rgd"&&(pe.textContent=bt),Ie=o(e),de=m(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-1pta66b"&&(de.innerHTML=Jt),Ae=o(e),c(me.$$.fragment,e),Ne=o(e),c(fe.$$.fragment,e),He=o(e),Me=m(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-1rff4ou"&&(Me.innerHTML=ht),Ye=o(e),c(ue.$$.fragment,e),xe=o(e),c(ye.$$.fragment,e),Le=o(e),c(le.$$.fragment,e),Se=o(e),ce=m(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-7ob7j"&&(ce.textContent=Tt),De=o(e),c(be.$$.fragment,e),Pe=o(e),Je=m(e,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-19knmj2"&&(Je.innerHTML=Ut),Ke=o(e),c(he.$$.fragment,e),Oe=o(e),c(Te.$$.fragment,e),et=o(e),Ue=m(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-6pxdrm"&&(Ue.innerHTML=wt),tt=o(e),c(we.$$.fragment,e),st=o(e),Ze=m(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-1qoc2ct"&&(Ze.innerHTML=Zt),lt=o(e),c(je.$$.fragment,e),nt=o(e),Ce=m(e,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-ep1hhf"&&(Ce.textContent=jt),at=o(e),c(ge.$$.fragment,e),it=o(e),c(Be.$$.fragment,e),ot=o(e),_e=m(e,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-lubruw"&&(_e.textContent=Ct),rt=o(e),c($e.$$.fragment,e),pt=o(e),c(ve.$$.fragment,e),dt=o(e),Re=m(e,"UL",{"data-svelte-h":!0}),f(Re)!=="svelte-1pkgul5"&&(Re.innerHTML=gt),mt=o(e),c(Ge.$$.fragment,e),ft=o(e),Xe=m(e,"P",{}),Rt(Xe).forEach(s),this.h()},h(){ut(a,"name","hf:doc:metadata"),ut(a,"content",Dt)},m(e,n){Qt(document.head,a),l(e,U,n),l(e,p,n),l(e,M,n),b(u,e,n),l(e,C,n),l(e,w,n),l(e,W,n),l(e,j,n),l(e,_,n),l(e,E,n),l(e,D,n),l(e,V,n),l(e,F,n),l(e,g,n),l(e,I,n),b(B,e,n),l(e,P,n),l(e,Q,n),l(e,A,n),b(Z,e,n),l(e,K,n),b(z,e,n),l(e,$,n),l(e,H,n),l(e,v,n),b(Y,e,n),l(e,N,n),l(e,t,n),l(e,O,n),l(e,ne,n),l(e,Ee,n),b(ae,e,n),l(e,Ve,n),b(ie,e,n),l(e,Qe,n),b(se,e,n),l(e,qe,n),l(e,oe,n),l(e,We,n),b(re,e,n),l(e,Fe,n),l(e,pe,n),l(e,Ie,n),l(e,de,n),l(e,Ae,n),b(me,e,n),l(e,Ne,n),b(fe,e,n),l(e,He,n),l(e,Me,n),l(e,Ye,n),b(ue,e,n),l(e,xe,n),b(ye,e,n),l(e,Le,n),b(le,e,n),l(e,Se,n),l(e,ce,n),l(e,De,n),b(be,e,n),l(e,Pe,n),l(e,Je,n),l(e,Ke,n),b(he,e,n),l(e,Oe,n),b(Te,e,n),l(e,et,n),l(e,Ue,n),l(e,tt,n),b(we,e,n),l(e,st,n),l(e,Ze,n),l(e,lt,n),b(je,e,n),l(e,nt,n),l(e,Ce,n),l(e,at,n),b(ge,e,n),l(e,it,n),b(Be,e,n),l(e,ot,n),l(e,_e,n),l(e,rt,n),b($e,e,n),l(e,pt,n),b(ve,e,n),l(e,dt,n),l(e,Re,n),l(e,mt,n),b(Ge,e,n),l(e,ft,n),l(e,Xe,n),Mt=!0},p(e,[n]){const Bt={};n&2&&(Bt.$$scope={dirty:n,ctx:e}),Z.$set(Bt);const _t={};n&2&&(_t.$$scope={dirty:n,ctx:e}),z.$set(_t);const $t={};n&2&&($t.$$scope={dirty:n,ctx:e}),se.$set($t);const vt={};n&2&&(vt.$$scope={dirty:n,ctx:e}),le.$set(vt)},i(e){Mt||(J(u.$$.fragment,e),J(B.$$.fragment,e),J(Z.$$.fragment,e),J(z.$$.fragment,e),J(Y.$$.fragment,e),J(ae.$$.fragment,e),J(ie.$$.fragment,e),J(se.$$.fragment,e),J(re.$$.fragment,e),J(me.$$.fragment,e),J(fe.$$.fragment,e),J(ue.$$.fragment,e),J(ye.$$.fragment,e),J(le.$$.fragment,e),J(be.$$.fragment,e),J(he.$$.fragment,e),J(Te.$$.fragment,e),J(we.$$.fragment,e),J(je.$$.fragment,e),J(ge.$$.fragment,e),J(Be.$$.fragment,e),J($e.$$.fragment,e),J(ve.$$.fragment,e),J(Ge.$$.fragment,e),Mt=!0)},o(e){h(u.$$.fragment,e),h(B.$$.fragment,e),h(Z.$$.fragment,e),h(z.$$.fragment,e),h(Y.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(me.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(ye.$$.fragment,e),h(le.$$.fragment,e),h(be.$$.fragment,e),h(he.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(je.$$.fragment,e),h(ge.$$.fragment,e),h(Be.$$.fragment,e),h($e.$$.fragment,e),h(ve.$$.fragment,e),h(Ge.$$.fragment,e),Mt=!1},d(e){e&&(s(U),s(p),s(M),s(C),s(w),s(W),s(j),s(_),s(E),s(D),s(V),s(F),s(g),s(I),s(P),s(Q),s(A),s(K),s($),s(H),s(v),s(N),s(t),s(O),s(ne),s(Ee),s(Ve),s(Qe),s(qe),s(oe),s(We),s(Fe),s(pe),s(Ie),s(de),s(Ae),s(Ne),s(He),s(Me),s(Ye),s(xe),s(Le),s(Se),s(ce),s(De),s(Pe),s(Je),s(Ke),s(Oe),s(et),s(Ue),s(tt),s(st),s(Ze),s(lt),s(nt),s(Ce),s(at),s(it),s(ot),s(_e),s(rt),s(pt),s(dt),s(Re),s(mt),s(ft),s(Xe)),s(a),T(u,e),T(B,e),T(Z,e),T(z,e),T(Y,e),T(ae,e),T(ie,e),T(se,e),T(re,e),T(me,e),T(fe,e),T(ue,e),T(ye,e),T(le,e),T(be,e),T(he,e),T(Te,e),T(we,e),T(je,e),T(ge,e),T(Be,e),T($e,e),T(ve,e),T(Ge,e)}}}const Dt='{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"8-bit (LLM.int8() algorithm)","local":"8-bit-llmint8-algorithm","sections":[{"title":"Outlier threshold","local":"outlier-threshold","sections":[],"depth":3},{"title":"Skip module conversion","local":"skip-module-conversion","sections":[],"depth":3}],"depth":2},{"title":"4-bit (QLoRA algorithm)","local":"4-bit-qlora-algorithm","sections":[{"title":"Compute data type","local":"compute-data-type","sections":[],"depth":3},{"title":"Normal Float 4 (NF4)","local":"normal-float-4-nf4","sections":[],"depth":3},{"title":"Nested quantization","local":"nested-quantization","sections":[],"depth":3}],"depth":2},{"title":"Dequantizing bitsandbytes models","local":"dequantizing-bitsandbytes-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Pt(R){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends zt{constructor(a){super(),Et(this,a,Pt,St,Xt,{})}}export{ns as component};
