import{s as Ge,o as Re,n as ge}from"../chunks/scheduler.25b97de1.js";import{S as De,i as He,g as p,s as l,r as y,A as Xe,h as u,f as m,c as i,j as K,u as b,x as f,k as ee,y as a,a as T,v,d as x,t as w,w as j}from"../chunks/index.d9030fc9.js";import{T as Ze}from"../chunks/Tip.baa67368.js";import{D as ae}from"../chunks/Docstring.ffac8efa.js";import{C as Ue}from"../chunks/CodeBlock.e6cd0d95.js";import{F as Ne,M as ze}from"../chunks/Markdown.7217f838.js";import{E as Ve}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as he,E as Pe}from"../chunks/EditOnGithub.91d95064.js";function Ye(W){let t,d="Examples:",e,o,h;return o=new Ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpVENvbmZpZyUyQyUyMEJlcnRDb25maWclMkMlMjBWaXNpb25UZXh0RHVhbEVuY29kZXJDb25maWclMkMlMjBWaXNpb25UZXh0RHVhbEVuY29kZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBCRVJUJTIwYW5kJTIwVmlUJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ192aXNpb24lMjAlM0QlMjBWaVRDb25maWcoKSUwQWNvbmZpZ190ZXh0JTIwJTNEJTIwQmVydENvbmZpZygpJTBBJTBBY29uZmlnJTIwJTNEJTIwVmlzaW9uVGV4dER1YWxFbmNvZGVyQ29uZmlnLmZyb21fdmlzaW9uX3RleHRfY29uZmlncyhjb25maWdfdmlzaW9uJTJDJTIwY29uZmlnX3RleHQlMkMlMjBwcm9qZWN0aW9uX2RpbSUzRDUxMiklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQkVSVCUyMGFuZCUyMFZpVCUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUwQW1vZGVsJTIwJTNEJTIwVmlzaW9uVGV4dER1YWxFbmNvZGVyTW9kZWwoY29uZmlnJTNEY29uZmlnKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ192aXNpb24lMjAlM0QlMjBtb2RlbC5jb25maWcudmlzaW9uX2NvbmZpZyUwQWNvbmZpZ190ZXh0JTIwJTNEJTIwbW9kZWwuY29uZmlnLnRleHRfY29uZmlnJTBBJTBBJTIzJTIwU2F2aW5nJTIwdGhlJTIwbW9kZWwlMkMlMjBpbmNsdWRpbmclMjBpdHMlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnZpdC1iZXJ0JTIyKSUwQSUwQSUyMyUyMGxvYWRpbmclMjBtb2RlbCUyMGFuZCUyMGNvbmZpZyUyMGZyb20lMjBwcmV0cmFpbmVkJTIwZm9sZGVyJTBBdmlzaW9uX3RleHRfY29uZmlnJTIwJTNEJTIwVmlzaW9uVGV4dER1YWxFbmNvZGVyQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJ2aXQtYmVydCUyMiklMEFtb2RlbCUyMCUzRCUyMFZpc2lvblRleHREdWFsRW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ2aXQtYmVydCUyMiUyQyUyMGNvbmZpZyUzRHZpc2lvbl90ZXh0X2NvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViTConfig, BertConfig, VisionTextDualEncoderConfig, VisionTextDualEncoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BERT and ViT configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_vision = ViTConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text = BertConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>config = VisionTextDualEncoderConfig.from_vision_text_configs(config_vision, config_text, projection_dim=<span class="hljs-number">512</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BERT and ViT model (with random weights)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel(config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_vision = model.config.vision_config
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text = model.config.text_config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_text_config = VisionTextDualEncoderConfig.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>, config=vision_text_config)`,wrap:!1}}),{c(){t=p("p"),t.textContent=d,e=l(),y(o.$$.fragment)},l(n){t=u(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=d),e=i(n),b(o.$$.fragment,n)},m(n,U){T(n,t,U),T(n,e,U),v(o,n,U),h=!0},p:ge,i(n){h||(x(o.$$.fragment,n),h=!0)},o(n){w(o.$$.fragment,n),h=!1},d(n){n&&(m(t),m(e)),j(o,n)}}}function Le(W){let t,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=d},l(e){t=u(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=d)},m(e,o){T(e,t,o)},p:ge,d(e){e&&m(t)}}}function Qe(W){let t,d="Examples:",e,o,h;return o=new Ue({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    VisionTextDualEncoderModel,
<span class="hljs-meta">... </span>    VisionTextDualEncoderProcessor,
<span class="hljs-meta">... </span>    AutoImageProcessor,
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VisionTextDualEncoderProcessor(image_processor, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel.from_vision_text_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># contrastive training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>urls = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://farm3.staticflickr.com/2674/5850229113_4fe05d5265_z.jpg&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw) <span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> urls]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    input_ids=inputs.input_ids,
<span class="hljs-meta">... </span>    attention_mask=inputs.attention_mask,
<span class="hljs-meta">... </span>    pixel_values=inputs.pixel_values,
<span class="hljs-meta">... </span>    return_loss=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, logits_per_image = outputs.loss, outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save and load from pretrained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=d,e=l(),y(o.$$.fragment)},l(n){t=u(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=d),e=i(n),b(o.$$.fragment,n)},m(n,U){T(n,t,U),T(n,e,U),v(o,n,U),h=!0},p:ge,i(n){h||(x(o.$$.fragment,n),h=!0)},o(n){w(o.$$.fragment,n),h=!1},d(n){n&&(m(t),m(e)),j(o,n)}}}function Se(W){let t,d,e,o,h,n,U=`This class can be used to initialize a vision-text dual encoder model with any pretrained vision autoencoding model
as the vision encoder and any pretrained text model as the text encoder. The vision and text encoders are loaded
via the <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> method. The projection layers are automatically added to the model and
should be fine-tuned on a downstream task, like contrastive image-text modeling.`,L,E,ne=`In <a href="https://arxiv.org/abs/2111.07991" rel="nofollow">LiT: Zero-Shot Transfer with Locked-image Text Tuning</a> it is shown how
leveraging pre-trained (locked/frozen) image and text model for contrastive learning yields significant improvment
on new zero-shot vision tasks such as image classification or retrieval.`,Q,k,oe=`After such a Vision-Text-Dual-Encoder model has been trained/fine-tuned, it can be saved/loaded just like any other
models (see the examples for more information).`,S,C,A=`This model inherits from <a href="/docs/transformers/v4.41.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,z,Z,te=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,X,M,G,N,B,se='The <a href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',R,_,F,I,D;return t=new he({props:{title:"VisionTextDualEncoderModel",local:"transformers.VisionTextDualEncoderModel",headingTag:"h2"}}),o=new ae({props:{name:"class transformers.VisionTextDualEncoderModel",anchor:"transformers.VisionTextDualEncoderModel",parameters:[{name:"config",val:": Optional = None"},{name:"vision_model",val:": Optional = None"},{name:"text_model",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.0/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderConfig">VisionEncoderDecoderConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.41.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/vision_text_dual_encoder/modeling_vision_text_dual_encoder.py#L161"}}),G=new ae({props:{name:"forward",anchor:"transformers.VisionTextDualEncoderModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"return_loss",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.VisionTextDualEncoderModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.VisionTextDualEncoderModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.VisionTextDualEncoderModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
an image processor (e.g. if you use ViT as the encoder, you should use <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>). See
<a href="/docs/transformers/v4.41.0/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VisionTextDualEncoderModel.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.VisionTextDualEncoderModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VisionTextDualEncoderModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VisionTextDualEncoderModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/vision_text_dual_encoder/modeling_vision_text_dual_encoder.py#L295",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clip.modeling_clip.CLIPOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image:(<code>torch.FloatTensor</code></strong> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text:(<code>torch.FloatTensor</code></strong> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds(<code>torch.FloatTensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.CLIPTextModel"
>CLIPTextModel</a>.</li>
<li><strong>image_embeds(<code>torch.FloatTensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.CLIPVisionModel"
>CLIPVisionModel</a>.</li>
<li><strong>text_model_output(<code>BaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.CLIPTextModel"
>CLIPTextModel</a>.</li>
<li><strong>vision_model_output(<code>BaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.CLIPVisionModel"
>CLIPVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clip.modeling_clip.CLIPOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),_=new Ze({props:{$$slots:{default:[Le]},$$scope:{ctx:W}}}),I=new Ve({props:{anchor:"transformers.VisionTextDualEncoderModel.forward.example",$$slots:{default:[Qe]},$$scope:{ctx:W}}}),{c(){y(t.$$.fragment),d=l(),e=p("div"),y(o.$$.fragment),h=l(),n=p("p"),n.innerHTML=U,L=l(),E=p("p"),E.innerHTML=ne,Q=l(),k=p("p"),k.textContent=oe,S=l(),C=p("p"),C.innerHTML=A,z=l(),Z=p("p"),Z.innerHTML=te,X=l(),M=p("div"),y(G.$$.fragment),N=l(),B=p("p"),B.innerHTML=se,R=l(),y(_.$$.fragment),F=l(),y(I.$$.fragment),this.h()},l(r){b(t.$$.fragment,r),d=i(r),e=u(r,"DIV",{class:!0});var c=K(e);b(o.$$.fragment,c),h=i(c),n=u(c,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1lrzedw"&&(n.innerHTML=U),L=i(c),E=u(c,"P",{"data-svelte-h":!0}),f(E)!=="svelte-98iof6"&&(E.innerHTML=ne),Q=i(c),k=u(c,"P",{"data-svelte-h":!0}),f(k)!=="svelte-c2j1l6"&&(k.textContent=oe),S=i(c),C=u(c,"P",{"data-svelte-h":!0}),f(C)!=="svelte-x59fzs"&&(C.innerHTML=A),z=i(c),Z=u(c,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-hswkmf"&&(Z.innerHTML=te),X=i(c),M=u(c,"DIV",{class:!0});var g=K(M);b(G.$$.fragment,g),N=i(g),B=u(g,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1fjh9rl"&&(B.innerHTML=se),R=i(g),b(_.$$.fragment,g),F=i(g),b(I.$$.fragment,g),g.forEach(m),c.forEach(m),this.h()},h(){ee(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(r,c){v(t,r,c),T(r,d,c),T(r,e,c),v(o,e,null),a(e,h),a(e,n),a(e,L),a(e,E),a(e,Q),a(e,k),a(e,S),a(e,C),a(e,z),a(e,Z),a(e,X),a(e,M),v(G,M,null),a(M,N),a(M,B),a(M,R),v(_,M,null),a(M,F),v(I,M,null),D=!0},p(r,c){const g={};c&2&&(g.$$scope={dirty:c,ctx:r}),_.$set(g);const Y={};c&2&&(Y.$$scope={dirty:c,ctx:r}),I.$set(Y)},i(r){D||(x(t.$$.fragment,r),x(o.$$.fragment,r),x(G.$$.fragment,r),x(_.$$.fragment,r),x(I.$$.fragment,r),D=!0)},o(r){w(t.$$.fragment,r),w(o.$$.fragment,r),w(G.$$.fragment,r),w(_.$$.fragment,r),w(I.$$.fragment,r),D=!1},d(r){r&&(m(d),m(e)),j(t,r),j(o),j(G),j(_),j(I)}}}function Ae(W){let t,d;return t=new ze({props:{$$slots:{default:[Se]},$$scope:{ctx:W}}}),{c(){y(t.$$.fragment)},l(e){b(t.$$.fragment,e)},m(e,o){v(t,e,o),d=!0},p(e,o){const h={};o&2&&(h.$$scope={dirty:o,ctx:e}),t.$set(h)},i(e){d||(x(t.$$.fragment,e),d=!0)},o(e){w(t.$$.fragment,e),d=!1},d(e){j(t,e)}}}function qe(W){let t,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=d},l(e){t=u(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=d)},m(e,o){T(e,t,o)},p:ge,d(e){e&&m(t)}}}function Oe(W){let t,d="Examples:",e,o,h;return o=new Ue({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    FlaxVisionTextDualEncoderModel,
<span class="hljs-meta">... </span>    VisionTextDualEncoderProcessor,
<span class="hljs-meta">... </span>    AutoImageProcessor,
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcesor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VisionTextDualEncoderProcessor(image_processor, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxVisionTextDualEncoderModel.from_vision_text_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># contrastive training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>urls = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://farm3.staticflickr.com/2674/5850229113_4fe05d5265_z.jpg&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw) <span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> urls]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=images, return_tensors=<span class="hljs-string">&quot;np&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    input_ids=inputs.input_ids,
<span class="hljs-meta">... </span>    attention_mask=inputs.attention_mask,
<span class="hljs-meta">... </span>    pixel_values=inputs.pixel_values,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save and load from pretrained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxVisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = jax.nn.softmax(logits_per_image, axis=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=d,e=l(),y(o.$$.fragment)},l(n){t=u(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=d),e=i(n),b(o.$$.fragment,n)},m(n,U){T(n,t,U),T(n,e,U),v(o,n,U),h=!0},p:ge,i(n){h||(x(o.$$.fragment,n),h=!0)},o(n){w(o.$$.fragment,n),h=!1},d(n){n&&(m(t),m(e)),j(o,n)}}}function Ke(W){let t,d,e,o,h,n,U=`This class can be used to initialize a vision-text dual encoder model with any pretrained vision autoencoding model
as the vision encoder and any pretrained text model as the text encoder. The vision and text encoders are loaded
via the <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> method. The projection layers are automatically added to the model and
should be fine-tuned on a downstream task, like contrastive image-text modeling.`,L,E,ne=`In <a href="https://arxiv.org/abs/2111.07991" rel="nofollow">LiT: Zero-Shot Transfer with Locked-image Text Tuning</a> it is shown how
leveraging pre-trained (locked/frozen) image and text model for contrastive learning yields significant improvment
on new zero-shot vision tasks such as image classification or retrieval.`,Q,k,oe=`After such a Vision-Text-Dual-Encoder model has been trained/fine-tuned, it can be saved/loaded just like any other
models (see the examples for more information).`,S,C,A=`This model inherits from <a href="/docs/transformers/v4.41.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,z,Z,te=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it
as a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,X,M,G="Finally, this model supports inherent JAX features such as:",N,B,se='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',R,_,F,I,D,r='The <a href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.FlaxVisionTextDualEncoderModel">FlaxVisionTextDualEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',c,g,Y,q,H;return t=new he({props:{title:"FlaxVisionTextDualEncoderModel",local:"transformers.FlaxVisionTextDualEncoderModel",headingTag:"h2"}}),o=new ae({props:{name:"class transformers.FlaxVisionTextDualEncoderModel",anchor:"transformers.FlaxVisionTextDualEncoderModel",parameters:[{name:"config",val:": VisionTextDualEncoderConfig"},{name:"input_shape",val:": Optional = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxVisionTextDualEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.41.0/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.41.0/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.41.0/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/vision_text_dual_encoder/modeling_flax_vision_text_dual_encoder.py#L219"}}),F=new ae({props:{name:"__call__",anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__",parameters:[{name:"input_ids",val:""},{name:"pixel_values",val:""},{name:"attention_mask",val:" = None"},{name:"position_ids",val:" = None"},{name:"token_type_ids",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.input_ids",description:`<strong>input_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
an image processor (e.g. if you use ViT as the encoder, you should use <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>). See
<a href="/docs/transformers/v4.41.0/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/vision_text_dual_encoder/modeling_flax_vision_text_dual_encoder.py#L270",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clip.modeling_flax_clip.FlaxCLIPOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a>) and inputs.</p>
<ul>
<li><strong>logits_per_image:(<code>jnp.ndarray</code></strong> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text:(<code>jnp.ndarray</code></strong> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds(<code>jnp.ndarray</code></strong> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.FlaxCLIPTextModel"
>FlaxCLIPTextModel</a>.</li>
<li><strong>image_embeds(<code>jnp.ndarray</code></strong> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.FlaxCLIPVisionModel"
>FlaxCLIPVisionModel</a>.</li>
<li><strong>text_model_output(<code>FlaxBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.FlaxCLIPTextModel"
>FlaxCLIPTextModel</a>.</li>
<li><strong>vision_model_output(<code>FlaxBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.FlaxCLIPVisionModel"
>FlaxCLIPVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clip.modeling_flax_clip.FlaxCLIPOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),g=new Ze({props:{$$slots:{default:[qe]},$$scope:{ctx:W}}}),q=new Ve({props:{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.example",$$slots:{default:[Oe]},$$scope:{ctx:W}}}),{c(){y(t.$$.fragment),d=l(),e=p("div"),y(o.$$.fragment),h=l(),n=p("p"),n.innerHTML=U,L=l(),E=p("p"),E.innerHTML=ne,Q=l(),k=p("p"),k.textContent=oe,S=l(),C=p("p"),C.innerHTML=A,z=l(),Z=p("p"),Z.innerHTML=te,X=l(),M=p("p"),M.textContent=G,N=l(),B=p("ul"),B.innerHTML=se,R=l(),_=p("div"),y(F.$$.fragment),I=l(),D=p("p"),D.innerHTML=r,c=l(),y(g.$$.fragment),Y=l(),y(q.$$.fragment),this.h()},l(J){b(t.$$.fragment,J),d=i(J),e=u(J,"DIV",{class:!0});var $=K(e);b(o.$$.fragment,$),h=i($),n=u($,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1lrzedw"&&(n.innerHTML=U),L=i($),E=u($,"P",{"data-svelte-h":!0}),f(E)!=="svelte-98iof6"&&(E.innerHTML=ne),Q=i($),k=u($,"P",{"data-svelte-h":!0}),f(k)!=="svelte-c2j1l6"&&(k.textContent=oe),S=i($),C=u($,"P",{"data-svelte-h":!0}),f(C)!=="svelte-x59fzs"&&(C.innerHTML=A),z=i($),Z=u($,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1c8n49f"&&(Z.innerHTML=te),X=i($),M=u($,"P",{"data-svelte-h":!0}),f(M)!=="svelte-1pplc4a"&&(M.textContent=G),N=i($),B=u($,"UL",{"data-svelte-h":!0}),f(B)!=="svelte-1w7z84m"&&(B.innerHTML=se),R=i($),_=u($,"DIV",{class:!0});var P=K(_);b(F.$$.fragment,P),I=i(P),D=u(P,"P",{"data-svelte-h":!0}),f(D)!=="svelte-4ph2jr"&&(D.innerHTML=r),c=i(P),b(g.$$.fragment,P),Y=i(P),b(q.$$.fragment,P),P.forEach(m),$.forEach(m),this.h()},h(){ee(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(J,$){v(t,J,$),T(J,d,$),T(J,e,$),v(o,e,null),a(e,h),a(e,n),a(e,L),a(e,E),a(e,Q),a(e,k),a(e,S),a(e,C),a(e,z),a(e,Z),a(e,X),a(e,M),a(e,N),a(e,B),a(e,R),a(e,_),v(F,_,null),a(_,I),a(_,D),a(_,c),v(g,_,null),a(_,Y),v(q,_,null),H=!0},p(J,$){const P={};$&2&&(P.$$scope={dirty:$,ctx:J}),g.$set(P);const _e={};$&2&&(_e.$$scope={dirty:$,ctx:J}),q.$set(_e)},i(J){H||(x(t.$$.fragment,J),x(o.$$.fragment,J),x(F.$$.fragment,J),x(g.$$.fragment,J),x(q.$$.fragment,J),H=!0)},o(J){w(t.$$.fragment,J),w(o.$$.fragment,J),w(F.$$.fragment,J),w(g.$$.fragment,J),w(q.$$.fragment,J),H=!1},d(J){J&&(m(d),m(e)),j(t,J),j(o),j(F),j(g),j(q)}}}function et(W){let t,d;return t=new ze({props:{$$slots:{default:[Ke]},$$scope:{ctx:W}}}),{c(){y(t.$$.fragment)},l(e){b(t.$$.fragment,e)},m(e,o){v(t,e,o),d=!0},p(e,o){const h={};o&2&&(h.$$scope={dirty:o,ctx:e}),t.$set(h)},i(e){d||(x(t.$$.fragment,e),d=!0)},o(e){w(t.$$.fragment,e),d=!1},d(e){j(t,e)}}}function tt(W){let t,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=d},l(e){t=u(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=d)},m(e,o){T(e,t,o)},p:ge,d(e){e&&m(t)}}}function st(W){let t,d="Examples:",e,o,h;return o=new Ue({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    TFVisionTextDualEncoderModel,
<span class="hljs-meta">... </span>    VisionTextDualEncoderProcessor,
<span class="hljs-meta">... </span>    AutoImageProcessor,
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VisionTextDualEncoderProcessor(image_processor, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFVisionTextDualEncoderModel.from_vision_text_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># contrastive training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>urls = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://farm3.staticflickr.com/2674/5850229113_4fe05d5265_z.jpg&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw) <span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> urls]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=images, return_tensors=<span class="hljs-string">&quot;np&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    input_ids=inputs.input_ids,
<span class="hljs-meta">... </span>    attention_mask=inputs.attention_mask,
<span class="hljs-meta">... </span>    pixel_values=inputs.pixel_values,
<span class="hljs-meta">... </span>    return_loss=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, logits_per_image = outputs.loss, outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save and load from pretrained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFVisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = tf.nn.softmax(logits_per_image, axis=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=d,e=l(),y(o.$$.fragment)},l(n){t=u(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=d),e=i(n),b(o.$$.fragment,n)},m(n,U){T(n,t,U),T(n,e,U),v(o,n,U),h=!0},p:ge,i(n){h||(x(o.$$.fragment,n),h=!0)},o(n){w(o.$$.fragment,n),h=!1},d(n){n&&(m(t),m(e)),j(o,n)}}}function nt(W){let t,d,e,o,h,n,U=`This class can be used to initialize a vision-text dual encoder model with any pretrained vision autoencoding model
as the vision encoder and any pretrained text model as the text encoder. The vision and text encoders are loaded
via the <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> method. The projection layers are automatically added to the model and
should be fine-tuned on a downstream task, like contrastive image-text modeling.`,L,E,ne=`In <a href="https://arxiv.org/abs/2111.07991" rel="nofollow">LiT: Zero-Shot Transfer with Locked-image Text Tuning</a> it is shown how
leveraging pre-trained (locked/frozen) image and text model for contrastive learning yields significant improvment
on new zero-shot vision tasks such as image classification or retrieval.`,Q,k,oe=`After such a Vision-Text-Dual-Encoder model has been trained/fine-tuned, it can be saved/loaded just like any other
models (see the examples for more information).`,S,C,A=`This model inherits from <a href="/docs/transformers/v4.41.0/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,z,Z,te=`This model is also a Keras <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">Model</a> subclass. Use it as a
regular Keras Model and refer to the TF documentation for all matter related to general usage and behavior.`,X,M,G,N,B,se='The <a href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.TFVisionTextDualEncoderModel">TFVisionTextDualEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',R,_,F,I,D;return t=new he({props:{title:"TFVisionTextDualEncoderModel",local:"transformers.TFVisionTextDualEncoderModel",headingTag:"h2"}}),o=new ae({props:{name:"class transformers.TFVisionTextDualEncoderModel",anchor:"transformers.TFVisionTextDualEncoderModel",parameters:[{name:"config",val:": Optional[VisionTextDualEncoderConfig] = None"},{name:"vision_model",val:": Optional[TFPreTrainedModel] = None"},{name:"text_model",val:": Optional[TFPreTrainedModel] = None"}],parametersDescription:[{anchor:"transformers.TFVisionTextDualEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.0/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderConfig">VisionEncoderDecoderConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.41.0/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/vision_text_dual_encoder/modeling_tf_vision_text_dual_encoder.py#L174"}}),G=new ae({props:{name:"call",anchor:"transformers.TFVisionTextDualEncoderModel.call",parameters:[{name:"input_ids",val:": tf.Tensor | None = None"},{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"position_ids",val:": tf.Tensor | None = None"},{name:"return_loss",val:": Optional[bool] = None"},{name:"token_type_ids",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFVisionTextDualEncoderModel.call.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
an image processor (e.g. if you use ViT as the encoder, you should use <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>). See
<a href="/docs/transformers/v4.41.0/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/vision_text_dual_encoder/modeling_tf_vision_text_dual_encoder.py#L346",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clip.modeling_tf_clip.TFCLIPOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image:(<code>tf.Tensor</code></strong> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text:(<code>tf.Tensor</code></strong> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds(<code>tf.Tensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.TFCLIPTextModel"
>TFCLIPTextModel</a>.</li>
<li><strong>image_embeds(<code>tf.Tensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.TFCLIPVisionModel"
>TFCLIPVisionModel</a>.</li>
<li><strong>text_model_output(<code>~modeling_tf_utils.TFBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.TFCLIPTextModel"
>TFCLIPTextModel</a>.</li>
<li><strong>vision_model_output(<code>~modeling_tf_utils.TFBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/v4.41.0/en/model_doc/clip#transformers.TFCLIPVisionModel"
>TFCLIPVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clip.modeling_tf_clip.TFCLIPOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),_=new Ze({props:{$$slots:{default:[tt]},$$scope:{ctx:W}}}),I=new Ve({props:{anchor:"transformers.TFVisionTextDualEncoderModel.call.example",$$slots:{default:[st]},$$scope:{ctx:W}}}),{c(){y(t.$$.fragment),d=l(),e=p("div"),y(o.$$.fragment),h=l(),n=p("p"),n.innerHTML=U,L=l(),E=p("p"),E.innerHTML=ne,Q=l(),k=p("p"),k.textContent=oe,S=l(),C=p("p"),C.innerHTML=A,z=l(),Z=p("p"),Z.innerHTML=te,X=l(),M=p("div"),y(G.$$.fragment),N=l(),B=p("p"),B.innerHTML=se,R=l(),y(_.$$.fragment),F=l(),y(I.$$.fragment),this.h()},l(r){b(t.$$.fragment,r),d=i(r),e=u(r,"DIV",{class:!0});var c=K(e);b(o.$$.fragment,c),h=i(c),n=u(c,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1lrzedw"&&(n.innerHTML=U),L=i(c),E=u(c,"P",{"data-svelte-h":!0}),f(E)!=="svelte-98iof6"&&(E.innerHTML=ne),Q=i(c),k=u(c,"P",{"data-svelte-h":!0}),f(k)!=="svelte-c2j1l6"&&(k.textContent=oe),S=i(c),C=u(c,"P",{"data-svelte-h":!0}),f(C)!=="svelte-1lrnopk"&&(C.innerHTML=A),z=i(c),Z=u(c,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-y4ylu0"&&(Z.innerHTML=te),X=i(c),M=u(c,"DIV",{class:!0});var g=K(M);b(G.$$.fragment,g),N=i(g),B=u(g,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1aw07vh"&&(B.innerHTML=se),R=i(g),b(_.$$.fragment,g),F=i(g),b(I.$$.fragment,g),g.forEach(m),c.forEach(m),this.h()},h(){ee(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(r,c){v(t,r,c),T(r,d,c),T(r,e,c),v(o,e,null),a(e,h),a(e,n),a(e,L),a(e,E),a(e,Q),a(e,k),a(e,S),a(e,C),a(e,z),a(e,Z),a(e,X),a(e,M),v(G,M,null),a(M,N),a(M,B),a(M,R),v(_,M,null),a(M,F),v(I,M,null),D=!0},p(r,c){const g={};c&2&&(g.$$scope={dirty:c,ctx:r}),_.$set(g);const Y={};c&2&&(Y.$$scope={dirty:c,ctx:r}),I.$set(Y)},i(r){D||(x(t.$$.fragment,r),x(o.$$.fragment,r),x(G.$$.fragment,r),x(_.$$.fragment,r),x(I.$$.fragment,r),D=!0)},o(r){w(t.$$.fragment,r),w(o.$$.fragment,r),w(G.$$.fragment,r),w(_.$$.fragment,r),w(I.$$.fragment,r),D=!1},d(r){r&&(m(d),m(e)),j(t,r),j(o),j(G),j(_),j(I)}}}function ot(W){let t,d;return t=new ze({props:{$$slots:{default:[nt]},$$scope:{ctx:W}}}),{c(){y(t.$$.fragment)},l(e){b(t.$$.fragment,e)},m(e,o){v(t,e,o),d=!0},p(e,o){const h={};o&2&&(h.$$scope={dirty:o,ctx:e}),t.$set(h)},i(e){d||(x(t.$$.fragment,e),d=!0)},o(e){w(t.$$.fragment,e),d=!1},d(e){j(t,e)}}}function at(W){let t,d,e,o,h,n,U,L,E,ne=`The <a href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> can be used to initialize a vision-text dual encoder model with
any pretrained vision autoencoding model as the vision encoder (<em>e.g.</em> <a href="vit">ViT</a>, <a href="beit">BEiT</a>, <a href="deit">DeiT</a>) and any pretrained text autoencoding model as the text encoder (<em>e.g.</em> <a href="roberta">RoBERTa</a>, <a href="bert">BERT</a>). Two projection layers are added on top of both the vision and text encoder to project the output embeddings
to a shared latent space. The projection layers are randomly initialized so the model should be fine-tuned on a
downstream task. This model can be used to align the vision-text embeddings using CLIP like contrastive image-text
training and then can be used for zero-shot vision tasks such image-classification or retrieval.`,Q,k,oe=`In <a href="https://arxiv.org/abs/2111.07991" rel="nofollow">LiT: Zero-Shot Transfer with Locked-image Text Tuning</a> it is shown how
leveraging pre-trained (locked/frozen) image and text model for contrastive learning yields significant improvement on
new zero-shot vision tasks such as image classification or retrieval.`,S,C,A,z,Z,te,X,M=`<a href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> is the configuration class to store the configuration of a
<a href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a>. It is used to instantiate <a href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> model according to the
specified arguments, defining the text model and vision model configs.`,G,N,B=`Configuration objects inherit from <a href="/docs/transformers/v4.41.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.41.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,se,R,_,F,I,D,r,c=`Instantiate a <a href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> (or a derived class) from text model configuration and vision
model configuration.`,g,Y,q,H,J,$,P,_e=`Constructs a VisionTextDualEncoder processor which wraps an image processor and a tokenizer into a single
processor.`,$e,fe,We=`<a href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderProcessor">VisionTextDualEncoderProcessor</a> offers all the functionalities of <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> and <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>.
See the <code>__call__()</code> and <a href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderProcessor.decode">decode()</a> for more
information.`,Ie,le,ce,Ee,Me,Fe=`This method forwards all its arguments to VisionTextDualEncoderTokenizer’s
<a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please refer to the docstring of this method for more information.`,ke,ie,me,Ce,Te,Be=`This method forwards all its arguments to VisionTextDualEncoderTokenizer’s <a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>.
Please refer to the docstring of this method for more information.`,be,de,ve,pe,xe,ye,we;return h=new he({props:{title:"VisionTextDualEncoder",local:"visiontextdualencoder",headingTag:"h1"}}),U=new he({props:{title:"Overview",local:"overview",headingTag:"h2"}}),C=new he({props:{title:"VisionTextDualEncoderConfig",local:"transformers.VisionTextDualEncoderConfig",headingTag:"h2"}}),Z=new ae({props:{name:"class transformers.VisionTextDualEncoderConfig",anchor:"transformers.VisionTextDualEncoderConfig",parameters:[{name:"projection_dim",val:" = 512"},{name:"logit_scale_init_value",val:" = 2.6592"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderConfig.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimentionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.VisionTextDualEncoderConfig.logit_scale_init_value",description:`<strong>logit_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 2.6592) &#x2014;
The inital value of the <em>logit_scale</em> paramter. Default is used as per the original CLIP implementation.`,name:"logit_scale_init_value"},{anchor:"transformers.VisionTextDualEncoderConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/vision_text_dual_encoder/configuration_vision_text_dual_encoder.py#L35"}}),R=new Ve({props:{anchor:"transformers.VisionTextDualEncoderConfig.example",$$slots:{default:[Ye]},$$scope:{ctx:W}}}),I=new ae({props:{name:"from_vision_text_configs",anchor:"transformers.VisionTextDualEncoderConfig.from_vision_text_configs",parameters:[{name:"vision_config",val:": PretrainedConfig"},{name:"text_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/vision_text_dual_encoder/configuration_vision_text_dual_encoder.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a></p>
`}}),Y=new he({props:{title:"VisionTextDualEncoderProcessor",local:"transformers.VisionTextDualEncoderProcessor",headingTag:"h2"}}),J=new ae({props:{name:"class transformers.VisionTextDualEncoderProcessor",anchor:"transformers.VisionTextDualEncoderProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.VisionTextDualEncoderProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/v4.41.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/vision_text_dual_encoder/processing_vision_text_dual_encoder.py#L25"}}),ce=new ae({props:{name:"batch_decode",anchor:"transformers.VisionTextDualEncoderProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/vision_text_dual_encoder/processing_vision_text_dual_encoder.py#L116"}}),me=new ae({props:{name:"decode",anchor:"transformers.VisionTextDualEncoderProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/vision_text_dual_encoder/processing_vision_text_dual_encoder.py#L123"}}),de=new Ne({props:{pytorch:!0,tensorflow:!0,jax:!0,$$slots:{jax:[ot],tensorflow:[et],pytorch:[Ae]},$$scope:{ctx:W}}}),pe=new Pe({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/vision-text-dual-encoder.md"}}),{c(){t=p("meta"),d=l(),e=p("p"),o=l(),y(h.$$.fragment),n=l(),y(U.$$.fragment),L=l(),E=p("p"),E.innerHTML=ne,Q=l(),k=p("p"),k.innerHTML=oe,S=l(),y(C.$$.fragment),A=l(),z=p("div"),y(Z.$$.fragment),te=l(),X=p("p"),X.innerHTML=M,G=l(),N=p("p"),N.innerHTML=B,se=l(),y(R.$$.fragment),_=l(),F=p("div"),y(I.$$.fragment),D=l(),r=p("p"),r.innerHTML=c,g=l(),y(Y.$$.fragment),q=l(),H=p("div"),y(J.$$.fragment),$=l(),P=p("p"),P.textContent=_e,$e=l(),fe=p("p"),fe.innerHTML=We,Ie=l(),le=p("div"),y(ce.$$.fragment),Ee=l(),Me=p("p"),Me.innerHTML=Fe,ke=l(),ie=p("div"),y(me.$$.fragment),Ce=l(),Te=p("p"),Te.innerHTML=Be,be=l(),y(de.$$.fragment),ve=l(),y(pe.$$.fragment),xe=l(),ye=p("p"),this.h()},l(s){const V=Xe("svelte-u9bgzb",document.head);t=u(V,"META",{name:!0,content:!0}),V.forEach(m),d=i(s),e=u(s,"P",{}),K(e).forEach(m),o=i(s),b(h.$$.fragment,s),n=i(s),b(U.$$.fragment,s),L=i(s),E=u(s,"P",{"data-svelte-h":!0}),f(E)!=="svelte-17096ea"&&(E.innerHTML=ne),Q=i(s),k=u(s,"P",{"data-svelte-h":!0}),f(k)!=="svelte-8axln3"&&(k.innerHTML=oe),S=i(s),b(C.$$.fragment,s),A=i(s),z=u(s,"DIV",{class:!0});var O=K(z);b(Z.$$.fragment,O),te=i(O),X=u(O,"P",{"data-svelte-h":!0}),f(X)!=="svelte-bprmj9"&&(X.innerHTML=M),G=i(O),N=u(O,"P",{"data-svelte-h":!0}),f(N)!=="svelte-1j16s4x"&&(N.innerHTML=B),se=i(O),b(R.$$.fragment,O),_=i(O),F=u(O,"DIV",{class:!0});var ue=K(F);b(I.$$.fragment,ue),D=i(ue),r=u(ue,"P",{"data-svelte-h":!0}),f(r)!=="svelte-12f4f42"&&(r.innerHTML=c),ue.forEach(m),O.forEach(m),g=i(s),b(Y.$$.fragment,s),q=i(s),H=u(s,"DIV",{class:!0});var re=K(H);b(J.$$.fragment,re),$=i(re),P=u(re,"P",{"data-svelte-h":!0}),f(P)!=="svelte-c5g5w0"&&(P.textContent=_e),$e=i(re),fe=u(re,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-m2s5a3"&&(fe.innerHTML=We),Ie=i(re),le=u(re,"DIV",{class:!0});var je=K(le);b(ce.$$.fragment,je),Ee=i(je),Me=u(je,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-s3kfra"&&(Me.innerHTML=Fe),je.forEach(m),ke=i(re),ie=u(re,"DIV",{class:!0});var Je=K(ie);b(me.$$.fragment,Je),Ce=i(Je),Te=u(Je,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-1o2v7fo"&&(Te.innerHTML=Be),Je.forEach(m),re.forEach(m),be=i(s),b(de.$$.fragment,s),ve=i(s),b(pe.$$.fragment,s),xe=i(s),ye=u(s,"P",{}),K(ye).forEach(m),this.h()},h(){ee(t,"name","hf:doc:metadata"),ee(t,"content",rt),ee(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,V){a(document.head,t),T(s,d,V),T(s,e,V),T(s,o,V),v(h,s,V),T(s,n,V),v(U,s,V),T(s,L,V),T(s,E,V),T(s,Q,V),T(s,k,V),T(s,S,V),v(C,s,V),T(s,A,V),T(s,z,V),v(Z,z,null),a(z,te),a(z,X),a(z,G),a(z,N),a(z,se),v(R,z,null),a(z,_),a(z,F),v(I,F,null),a(F,D),a(F,r),T(s,g,V),v(Y,s,V),T(s,q,V),T(s,H,V),v(J,H,null),a(H,$),a(H,P),a(H,$e),a(H,fe),a(H,Ie),a(H,le),v(ce,le,null),a(le,Ee),a(le,Me),a(H,ke),a(H,ie),v(me,ie,null),a(ie,Ce),a(ie,Te),T(s,be,V),v(de,s,V),T(s,ve,V),v(pe,s,V),T(s,xe,V),T(s,ye,V),we=!0},p(s,[V]){const O={};V&2&&(O.$$scope={dirty:V,ctx:s}),R.$set(O);const ue={};V&2&&(ue.$$scope={dirty:V,ctx:s}),de.$set(ue)},i(s){we||(x(h.$$.fragment,s),x(U.$$.fragment,s),x(C.$$.fragment,s),x(Z.$$.fragment,s),x(R.$$.fragment,s),x(I.$$.fragment,s),x(Y.$$.fragment,s),x(J.$$.fragment,s),x(ce.$$.fragment,s),x(me.$$.fragment,s),x(de.$$.fragment,s),x(pe.$$.fragment,s),we=!0)},o(s){w(h.$$.fragment,s),w(U.$$.fragment,s),w(C.$$.fragment,s),w(Z.$$.fragment,s),w(R.$$.fragment,s),w(I.$$.fragment,s),w(Y.$$.fragment,s),w(J.$$.fragment,s),w(ce.$$.fragment,s),w(me.$$.fragment,s),w(de.$$.fragment,s),w(pe.$$.fragment,s),we=!1},d(s){s&&(m(d),m(e),m(o),m(n),m(L),m(E),m(Q),m(k),m(S),m(A),m(z),m(g),m(q),m(H),m(be),m(ve),m(xe),m(ye)),m(t),j(h,s),j(U,s),j(C,s),j(Z),j(R),j(I),j(Y,s),j(J),j(ce),j(me),j(de,s),j(pe,s)}}}const rt='{"title":"VisionTextDualEncoder","local":"visiontextdualencoder","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"VisionTextDualEncoderConfig","local":"transformers.VisionTextDualEncoderConfig","sections":[],"depth":2},{"title":"VisionTextDualEncoderProcessor","local":"transformers.VisionTextDualEncoderProcessor","sections":[],"depth":2},{"title":"VisionTextDualEncoderModel","local":"transformers.VisionTextDualEncoderModel","sections":[],"depth":2},{"title":"FlaxVisionTextDualEncoderModel","local":"transformers.FlaxVisionTextDualEncoderModel","sections":[],"depth":2},{"title":"TFVisionTextDualEncoderModel","local":"transformers.TFVisionTextDualEncoderModel","sections":[],"depth":2}],"depth":1}';function lt(W){return Re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ft extends De{constructor(t){super(),He(this,t,lt,at,Ge,{})}}export{ft as component};
