import{s as Ke,n as Oe,o as es}from"../chunks/scheduler.182ea377.js";import{S as ss,i as ls,g as a,s as n,r as p,A as ts,h as i,f as l,c as o,j as Fe,u,x as r,k as Le,y as ns,a as t,v as h,d as M,t as c,w as b}from"../chunks/index.abf12888.js";import{C as J}from"../chunks/CodeBlock.57fe6e13.js";import{D as os}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as L}from"../chunks/Heading.16916d63.js";function as(Ge){let T,K,P,O,m,ee,f,se,d,Ve='🤗 Diffusers provides a <a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a> for uploading your model, scheduler, or pipeline to the Hub. It is an easy way to store your files on the Hub, and also allows you to share your work with others. Under the hood, the <a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a>:',le,y,De="<li>creates a repository on the Hub</li> <li>saves your model, scheduler, or pipeline files so they can be reloaded later</li> <li>uploads folder containing these files to the Hub</li>",te,w,Ee='This guide will show you how to use the <a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a> to upload your files to the Hub.',ne,j,Xe='You’ll need to log in to your Hub account with your access <a href="https://huggingface.co/settings/tokens" rel="nofollow">token</a> first:',oe,I,ae,U,ie,_,Ne='To push a model to the Hub, call <a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> and specify the repository id of the model to be stored on the Hub:',pe,v,ue,k,Re='For models, you can also specify the <a href="loading#checkpoint-variants"><em>variant</em></a> of the weights to push to the Hub. For example, to push <code>fp16</code> weights:',re,B,he,Z,We='The <a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves the model’s <code>config.json</code> file and the weights are automatically saved in the <code>safetensors</code> format.',Me,g,xe="Now you can reload the model from your repository on the Hub:",ce,$,be,C,Je,G,He='To push a scheduler to the Hub, call <a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> and specify the repository id of the scheduler to be stored on the Hub:',Te,V,me,D,Ye='The <a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves the scheduler’s <code>scheduler_config.json</code> file to the specified repository.',fe,E,ze="Now you can reload the scheduler from your repository on the Hub:",de,X,ye,N,we,R,Qe='You can also push an entire pipeline with all it’s components to the Hub. For example, initialize the components of a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> with the parameters you want:',je,W,Ie,x,Se='Pass all of the components to the <a href="/docs/diffusers/v0.26.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and call <a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to push the pipeline to the Hub:',Ue,H,_e,Y,qe='The <a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves each component to a subfolder in the repository. Now you can reload the pipeline from your repository on the Hub:',ve,z,ke,Q,Be,S,Ae='Set <code>private=True</code> in the <a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function to keep your model, scheduler, or pipeline files private:',Ze,q,ge,A,Pe='Private repositories are only visible to you, and other users won’t be able to clone the repository and your repository won’t appear in search results. Even if a user has the URL to your private repository, they’ll receive a <code>404 - Sorry, we can&#39;t find the page you are looking for</code>. You must be <a href="https://huggingface.co/docs/huggingface_hub/quick-start#login" rel="nofollow">logged in</a> to load a model from a private repository.',$e,F,Ce;return m=new L({props:{title:"Push files to the Hub",local:"push-files-to-the-hub",headingTag:"h1"}}),f=new os({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/push_to_hub.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/push_to_hub.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/push_to_hub.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/push_to_hub.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/push_to_hub.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/push_to_hub.ipynb"}]}}),I=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),U=new L({props:{title:"Models",local:"models",headingTag:"h2"}}),v=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwoJTBBJTIwJTIwJTIwJTIwYmxvY2tfb3V0X2NoYW5uZWxzJTNEKDMyJTJDJTIwNjQpJTJDJTBBJTIwJTIwJTIwJTIwbGF5ZXJzX3Blcl9ibG9jayUzRDIlMkMlMEElMjAlMjAlMjAlMjBpbl9jaGFubmVscyUzRDQlMkMlMEElMjAlMjAlMjAlMjBkb3duX2Jsb2NrX3R5cGVzJTNEKCUyMkRvd25CbG9jazJEJTIyJTJDJTIwJTIyQ3Jvc3NBdHRuRG93bkJsb2NrMkQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwY3Jvc3NfYXR0ZW50aW9uX2RpbSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwY29uZGl0aW9uaW5nX2VtYmVkZGluZ19vdXRfY2hhbm5lbHMlM0QoMTYlMkMlMjAzMiklMkMlMEEpJTBBY29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel

controlnet = ControlNetModel(
    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>),
    layers_per_block=<span class="hljs-number">2</span>,
    in_channels=<span class="hljs-number">4</span>,
    down_block_types=(<span class="hljs-string">&quot;DownBlock2D&quot;</span>, <span class="hljs-string">&quot;CrossAttnDownBlock2D&quot;</span>),
    cross_attention_dim=<span class="hljs-number">32</span>,
    conditioning_embedding_out_channels=(<span class="hljs-number">16</span>, <span class="hljs-number">32</span>),
)
controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model&quot;</span>)`,wrap:!1}}),B=new J({props:{code:"Y29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIp",highlighted:'controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)',wrap:!1}}),$=new J({props:{code:"bW9kZWwlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnlvdXItbmFtZXNwYWNlJTJGbXktY29udHJvbG5ldC1tb2RlbCUyMik=",highlighted:'model = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-controlnet-model&quot;</span>)',wrap:!1}}),C=new L({props:{title:"Scheduler",local:"scheduler",headingTag:"h2"}}),V=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1TY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMGJldGFfc3RhcnQlM0QwLjAwMDg1JTJDJTBBJTIwJTIwJTIwJTIwYmV0YV9lbmQlM0QwLjAxMiUyQyUwQSUyMCUyMCUyMCUyMGJldGFfc2NoZWR1bGUlM0QlMjJzY2FsZWRfbGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHNldF9hbHBoYV90b19vbmUlM0RGYWxzZSUyQyUwQSklMEFzY2hlZHVsZXIucHVzaF90b19odWIoJTIybXktY29udHJvbG5ldC1zY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler

scheduler = DDIMScheduler(
    beta_start=<span class="hljs-number">0.00085</span>,
    beta_end=<span class="hljs-number">0.012</span>,
    beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    set_alpha_to_one=<span class="hljs-literal">False</span>,
)
scheduler.push_to_hub(<span class="hljs-string">&quot;my-controlnet-scheduler&quot;</span>)`,wrap:!1}}),X=new J({props:{code:"c2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci1uYW1lcHNhY2UlMkZteS1jb250cm9sbmV0LXNjaGVkdWxlciUyMik=",highlighted:'scheduler = DDIMScheduler.from_pretrained(<span class="hljs-string">&quot;your-namepsace/my-controlnet-scheduler&quot;</span>)',wrap:!1}}),N=new L({props:{title:"Pipeline",local:"pipeline",headingTag:"h2"}}),W=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    UNet2DConditionModel,
    AutoencoderKL,
    DDIMScheduler,
    StableDiffusionPipeline,
)
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTextConfig, CLIPTokenizer

unet = UNet2DConditionModel(
    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>),
    layers_per_block=<span class="hljs-number">2</span>,
    sample_size=<span class="hljs-number">32</span>,
    in_channels=<span class="hljs-number">4</span>,
    out_channels=<span class="hljs-number">4</span>,
    down_block_types=(<span class="hljs-string">&quot;DownBlock2D&quot;</span>, <span class="hljs-string">&quot;CrossAttnDownBlock2D&quot;</span>),
    up_block_types=(<span class="hljs-string">&quot;CrossAttnUpBlock2D&quot;</span>, <span class="hljs-string">&quot;UpBlock2D&quot;</span>),
    cross_attention_dim=<span class="hljs-number">32</span>,
)

scheduler = DDIMScheduler(
    beta_start=<span class="hljs-number">0.00085</span>,
    beta_end=<span class="hljs-number">0.012</span>,
    beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    set_alpha_to_one=<span class="hljs-literal">False</span>,
)

vae = AutoencoderKL(
    block_out_channels=[<span class="hljs-number">32</span>, <span class="hljs-number">64</span>],
    in_channels=<span class="hljs-number">3</span>,
    out_channels=<span class="hljs-number">3</span>,
    down_block_types=[<span class="hljs-string">&quot;DownEncoderBlock2D&quot;</span>, <span class="hljs-string">&quot;DownEncoderBlock2D&quot;</span>],
    up_block_types=[<span class="hljs-string">&quot;UpDecoderBlock2D&quot;</span>, <span class="hljs-string">&quot;UpDecoderBlock2D&quot;</span>],
    latent_channels=<span class="hljs-number">4</span>,
)

text_encoder_config = CLIPTextConfig(
    bos_token_id=<span class="hljs-number">0</span>,
    eos_token_id=<span class="hljs-number">2</span>,
    hidden_size=<span class="hljs-number">32</span>,
    intermediate_size=<span class="hljs-number">37</span>,
    layer_norm_eps=<span class="hljs-number">1e-05</span>,
    num_attention_heads=<span class="hljs-number">4</span>,
    num_hidden_layers=<span class="hljs-number">5</span>,
    pad_token_id=<span class="hljs-number">1</span>,
    vocab_size=<span class="hljs-number">1000</span>,
)
text_encoder = CLIPTextModel(text_encoder_config)
tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/tiny-random-clip&quot;</span>)`,wrap:!1}}),H=new J({props:{code:"Y29tcG9uZW50cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnVuZXQlMjIlM0ElMjB1bmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwc2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIydmFlJTIyJTNBJTIwdmFlJTJDJTBBJTIwJTIwJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwdGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIydG9rZW5pemVyJTIyJTNBJTIwdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc2FmZXR5X2NoZWNrZXIlMjIlM0ElMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjBOb25lJTJDJTBBJTdEJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSgqKmNvbXBvbmVudHMpJTBBcGlwZWxpbmUucHVzaF90b19odWIoJTIybXktcGlwZWxpbmUlMjIp",highlighted:`components = {
    <span class="hljs-string">&quot;unet&quot;</span>: unet,
    <span class="hljs-string">&quot;scheduler&quot;</span>: scheduler,
    <span class="hljs-string">&quot;vae&quot;</span>: vae,
    <span class="hljs-string">&quot;text_encoder&quot;</span>: text_encoder,
    <span class="hljs-string">&quot;tokenizer&quot;</span>: tokenizer,
    <span class="hljs-string">&quot;safety_checker&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;feature_extractor&quot;</span>: <span class="hljs-literal">None</span>,
}

pipeline = StableDiffusionPipeline(**components)
pipeline.push_to_hub(<span class="hljs-string">&quot;my-pipeline&quot;</span>)`,wrap:!1}}),z=new J({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci1uYW1lc3BhY2UlMkZteS1waXBlbGluZSUyMik=",highlighted:'pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-pipeline&quot;</span>)',wrap:!1}}),Q=new L({props:{title:"Privacy",local:"privacy",headingTag:"h2"}}),q=new J({props:{code:"Y29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsLXByaXZhdGUlMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:'controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model-private&quot;</span>, private=<span class="hljs-literal">True</span>)',wrap:!1}}),{c(){T=a("meta"),K=n(),P=a("p"),O=n(),p(m.$$.fragment),ee=n(),p(f.$$.fragment),se=n(),d=a("p"),d.innerHTML=Ve,le=n(),y=a("ol"),y.innerHTML=De,te=n(),w=a("p"),w.innerHTML=Ee,ne=n(),j=a("p"),j.innerHTML=Xe,oe=n(),p(I.$$.fragment),ae=n(),p(U.$$.fragment),ie=n(),_=a("p"),_.innerHTML=Ne,pe=n(),p(v.$$.fragment),ue=n(),k=a("p"),k.innerHTML=Re,re=n(),p(B.$$.fragment),he=n(),Z=a("p"),Z.innerHTML=We,Me=n(),g=a("p"),g.textContent=xe,ce=n(),p($.$$.fragment),be=n(),p(C.$$.fragment),Je=n(),G=a("p"),G.innerHTML=He,Te=n(),p(V.$$.fragment),me=n(),D=a("p"),D.innerHTML=Ye,fe=n(),E=a("p"),E.textContent=ze,de=n(),p(X.$$.fragment),ye=n(),p(N.$$.fragment),we=n(),R=a("p"),R.innerHTML=Qe,je=n(),p(W.$$.fragment),Ie=n(),x=a("p"),x.innerHTML=Se,Ue=n(),p(H.$$.fragment),_e=n(),Y=a("p"),Y.innerHTML=qe,ve=n(),p(z.$$.fragment),ke=n(),p(Q.$$.fragment),Be=n(),S=a("p"),S.innerHTML=Ae,Ze=n(),p(q.$$.fragment),ge=n(),A=a("p"),A.innerHTML=Pe,$e=n(),F=a("p"),this.h()},l(e){const s=ts("svelte-u9bgzb",document.head);T=i(s,"META",{name:!0,content:!0}),s.forEach(l),K=o(e),P=i(e,"P",{}),Fe(P).forEach(l),O=o(e),u(m.$$.fragment,e),ee=o(e),u(f.$$.fragment,e),se=o(e),d=i(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-rhe18k"&&(d.innerHTML=Ve),le=o(e),y=i(e,"OL",{"data-svelte-h":!0}),r(y)!=="svelte-11ocvlf"&&(y.innerHTML=De),te=o(e),w=i(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-yiy5rx"&&(w.innerHTML=Ee),ne=o(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1bojsgz"&&(j.innerHTML=Xe),oe=o(e),u(I.$$.fragment,e),ae=o(e),u(U.$$.fragment,e),ie=o(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1eutzny"&&(_.innerHTML=Ne),pe=o(e),u(v.$$.fragment,e),ue=o(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1eiubrc"&&(k.innerHTML=Re),re=o(e),u(B.$$.fragment,e),he=o(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-f8uzdd"&&(Z.innerHTML=We),Me=o(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1bcc50k"&&(g.textContent=xe),ce=o(e),u($.$$.fragment,e),be=o(e),u(C.$$.fragment,e),Je=o(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1jd67o6"&&(G.innerHTML=He),Te=o(e),u(V.$$.fragment,e),me=o(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1chacdx"&&(D.innerHTML=Ye),fe=o(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-rpu5q4"&&(E.textContent=ze),de=o(e),u(X.$$.fragment,e),ye=o(e),u(N.$$.fragment,e),we=o(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-kwqe85"&&(R.innerHTML=Qe),je=o(e),u(W.$$.fragment,e),Ie=o(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-mz8ol5"&&(x.innerHTML=Se),Ue=o(e),u(H.$$.fragment,e),_e=o(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-x78xl5"&&(Y.innerHTML=qe),ve=o(e),u(z.$$.fragment,e),ke=o(e),u(Q.$$.fragment,e),Be=o(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-fqa5be"&&(S.innerHTML=Ae),Ze=o(e),u(q.$$.fragment,e),ge=o(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ckklvi"&&(A.innerHTML=Pe),$e=o(e),F=i(e,"P",{}),Fe(F).forEach(l),this.h()},h(){Le(T,"name","hf:doc:metadata"),Le(T,"content",is)},m(e,s){ns(document.head,T),t(e,K,s),t(e,P,s),t(e,O,s),h(m,e,s),t(e,ee,s),h(f,e,s),t(e,se,s),t(e,d,s),t(e,le,s),t(e,y,s),t(e,te,s),t(e,w,s),t(e,ne,s),t(e,j,s),t(e,oe,s),h(I,e,s),t(e,ae,s),h(U,e,s),t(e,ie,s),t(e,_,s),t(e,pe,s),h(v,e,s),t(e,ue,s),t(e,k,s),t(e,re,s),h(B,e,s),t(e,he,s),t(e,Z,s),t(e,Me,s),t(e,g,s),t(e,ce,s),h($,e,s),t(e,be,s),h(C,e,s),t(e,Je,s),t(e,G,s),t(e,Te,s),h(V,e,s),t(e,me,s),t(e,D,s),t(e,fe,s),t(e,E,s),t(e,de,s),h(X,e,s),t(e,ye,s),h(N,e,s),t(e,we,s),t(e,R,s),t(e,je,s),h(W,e,s),t(e,Ie,s),t(e,x,s),t(e,Ue,s),h(H,e,s),t(e,_e,s),t(e,Y,s),t(e,ve,s),h(z,e,s),t(e,ke,s),h(Q,e,s),t(e,Be,s),t(e,S,s),t(e,Ze,s),h(q,e,s),t(e,ge,s),t(e,A,s),t(e,$e,s),t(e,F,s),Ce=!0},p:Oe,i(e){Ce||(M(m.$$.fragment,e),M(f.$$.fragment,e),M(I.$$.fragment,e),M(U.$$.fragment,e),M(v.$$.fragment,e),M(B.$$.fragment,e),M($.$$.fragment,e),M(C.$$.fragment,e),M(V.$$.fragment,e),M(X.$$.fragment,e),M(N.$$.fragment,e),M(W.$$.fragment,e),M(H.$$.fragment,e),M(z.$$.fragment,e),M(Q.$$.fragment,e),M(q.$$.fragment,e),Ce=!0)},o(e){c(m.$$.fragment,e),c(f.$$.fragment,e),c(I.$$.fragment,e),c(U.$$.fragment,e),c(v.$$.fragment,e),c(B.$$.fragment,e),c($.$$.fragment,e),c(C.$$.fragment,e),c(V.$$.fragment,e),c(X.$$.fragment,e),c(N.$$.fragment,e),c(W.$$.fragment,e),c(H.$$.fragment,e),c(z.$$.fragment,e),c(Q.$$.fragment,e),c(q.$$.fragment,e),Ce=!1},d(e){e&&(l(K),l(P),l(O),l(ee),l(se),l(d),l(le),l(y),l(te),l(w),l(ne),l(j),l(oe),l(ae),l(ie),l(_),l(pe),l(ue),l(k),l(re),l(he),l(Z),l(Me),l(g),l(ce),l(be),l(Je),l(G),l(Te),l(me),l(D),l(fe),l(E),l(de),l(ye),l(we),l(R),l(je),l(Ie),l(x),l(Ue),l(_e),l(Y),l(ve),l(ke),l(Be),l(S),l(Ze),l(ge),l(A),l($e),l(F)),l(T),b(m,e),b(f,e),b(I,e),b(U,e),b(v,e),b(B,e),b($,e),b(C,e),b(V,e),b(X,e),b(N,e),b(W,e),b(H,e),b(z,e),b(Q,e),b(q,e)}}}const is='{"title":"Push files to the Hub","local":"push-files-to-the-hub","sections":[{"title":"Models","local":"models","sections":[],"depth":2},{"title":"Scheduler","local":"scheduler","sections":[],"depth":2},{"title":"Pipeline","local":"pipeline","sections":[],"depth":2},{"title":"Privacy","local":"privacy","sections":[],"depth":2}],"depth":1}';function ps(Ge){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ss{constructor(T){super(),ls(this,T,ps,as,Ke,{})}}export{bs as component};
