import{s as ke,n as Qe,o as ve}from"../chunks/scheduler.23542ac5.js";import{S as Ee,i as Ye,e as p,s as a,c as o,h as He,a as i,d as t,b as n,f as Ce,g as M,j as m,k as cl,l as $e,m as s,n as c,t as r,o as J,p as d}from"../chunks/index.9b1f405b.js";import{C as Ne,H as ie,E as Fe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ee52513e.js";import{C as y}from"../chunks/CodeBlock.94dab919.js";import{D as xe}from"../chunks/DocNotebookDropdown.68a629d2.js";function ze(me){let T,rl,ol,Jl,U,dl,f,yl,j,Tl,Z,oe="이미지 편집을 하려면 일반적으로 편집할 영역의 마스크를 제공해야 합니다. DiffEdit는 텍스트 쿼리를 기반으로 마스크를 자동으로 생성하므로 이미지 편집 소프트웨어 없이도 마스크를 만들기가 전반적으로 더 쉬워집니다. DiffEdit 알고리즘은 세 단계로 작동합니다:",ul,g,Me="<li>Diffusion 모델이 일부 쿼리 텍스트와 참조 텍스트를 조건부로 이미지의 노이즈를 제거하여 이미지의 여러 영역에 대해 서로 다른 노이즈 추정치를 생성하고, 그 차이를 사용하여 쿼리 텍스트와 일치하도록 이미지의 어느 영역을 변경해야 하는지 식별하기 위한 마스크를 추론합니다.</li> <li>입력 이미지가 DDIM을 사용하여 잠재 공간으로 인코딩됩니다.</li> <li>마스크 외부의 픽셀이 입력 이미지와 동일하게 유지되도록 마스크를 가이드로 사용하여 텍스트 쿼리에 조건이 지정된 diffusion 모델로 latents를 디코딩합니다.</li>",wl,I,ce="이 가이드에서는 마스크를 수동으로 만들지 않고 DiffEdit를 사용하여 이미지를 편집하는 방법을 설명합니다.",bl,h,re="시작하기 전에 다음 라이브러리가 설치되어 있는지 확인하세요:",Ul,W,fl,_,Je="<code>StableDiffusionDiffEditPipeline</code>에는 이미지 마스크와 부분적으로 반전된 latents 집합이 필요합니다. 이미지 마스크는 <code>generate_mask()</code> 함수에서 생성되며, 두 개의 파라미터인 <code>source_prompt</code>와 <code>target_prompt</code>가 포함됩니다. 이 매개변수는 이미지에서 무엇을 편집할지 결정합니다. 예를 들어, <em>과일</em> 한 그릇을 <em>배</em> 한 그릇으로 변경하려면 다음과 같이 하세요:",jl,B,Zl,G,de="부분적으로 반전된 latents는 <code>invert()</code> 함수에서 생성되며, 일반적으로 이미지를 설명하는 <code>prompt</code> 또는 <em>캡션</em>을 포함하는 것이 inverse latent sampling 프로세스를 가이드하는 데 도움이 됩니다. 캡션은 종종 <code>source_prompt</code>가 될 수 있지만, 다른 텍스트 설명으로 자유롭게 실험해 보세요!",gl,R,ye="파이프라인, 스케줄러, 역 스케줄러를 불러오고 메모리 사용량을 줄이기 위해 몇 가지 최적화를 활성화해 보겠습니다:",Il,X,hl,V,Te="수정하기 위한 이미지를 불러옵니다:",Wl,C,_l,k,ue="이미지 마스크를 생성하기 위해 <code>generate_mask()</code> 함수를 사용합니다. 이미지에서 편집할 내용을 지정하기 위해 <code>source_prompt</code>와 <code>target_prompt</code>를 전달해야 합니다:",Bl,Q,Gl,v,we="다음으로, 반전된 latents를 생성하고 이미지를 묘사하는 캡션에 전달합니다:",Rl,E,Xl,Y,be="마지막으로, 이미지 마스크와 반전된 latents를 파이프라인에 전달합니다. <code>target_prompt</code>는 이제 <code>prompt</code>가 되며, <code>source_prompt</code>는 <code>negative_prompt</code>로 사용됩니다.",Vl,H,Cl,u,Ue='<div><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/blob/main/assets/target.png?raw=true"/> <figcaption class="mt-2 text-center text-sm text-gray-500">edited image</figcaption></div>',kl,$,Ql,N,fe='Source와 target 임베딩은 수동으로 생성하는 대신 <a href="https://huggingface.co/docs/transformers/model_doc/flan-t5" rel="nofollow">Flan-T5</a> 모델을 사용하여 자동으로 생성할 수 있습니다.',vl,F,je="Flan-T5 모델과 토크나이저를 🤗 Transformers 라이브러리에서 불러옵니다:",El,x,Yl,z,Ze="모델에 프롬프트할 source와 target 프롬프트를 생성하기 위해 초기 텍스트들을 제공합니다.",Hl,S,$l,A,ge="다음으로, 프롬프트들을 생성하기 위해 유틸리티 함수를 생성합니다.",Nl,D,Fl,w,Ie='<p>다양한 품질의 텍스트를 생성하는 전략에 대해 자세히 알아보려면 <a href="https://huggingface.co/docs/transformers/main/en/generation_strategies" rel="nofollow">생성 전략</a> 가이드를 참조하세요.</p>',xl,q,he="텍스트 인코딩을 위해 <code>StableDiffusionDiffEditPipeline</code>에서 사용하는 텍스트 인코더 모델을 불러옵니다. 텍스트 인코더를 사용하여 텍스트 임베딩을 계산합니다:",zl,L,Sl,K,We="마지막으로, 임베딩을 <code>generate_mask()</code> 및 <code>invert()</code> 함수와 파이프라인에 전달하여 이미지를 생성합니다:",Al,P,Dl,O,ql,ll,_e='<code>source_prompt</code>를 캡션으로 사용하여 부분적으로 반전된 latents를 생성할 수 있지만, <a href="https://huggingface.co/docs/transformers/model_doc/blip" rel="nofollow">BLIP</a> 모델을 사용하여 캡션을 자동으로 생성할 수도 있습니다.',Ll,el,Be="🤗 Transformers 라이브러리에서 BLIP 모델과 프로세서를 불러옵니다:",Kl,tl,Pl,sl,Ge="입력 이미지에서 캡션을 생성하는 유틸리티 함수를 만듭니다:",Ol,al,le,nl,Re="입력 이미지를 불러오고 <code>generate_caption</code> 함수를 사용하여 해당 이미지에 대한 캡션을 생성합니다:",ee,pl,te,b,Xe='<figure><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png"/> <figcaption class="text-center">generated caption: &quot;a photograph of a bowl of fruit on a table&quot;</figcaption></figure>',se,il,Ve="이제 캡션을 <code>invert()</code> 함수에 놓아 부분적으로 반전된 latents를 생성할 수 있습니다!",ae,ml,ne,Ml,pe;return U=new Ne({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new xe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/diffedit.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/diffedit.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/diffedit.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/diffedit.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/diffedit.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/diffedit.ipynb"}]}}),j=new ie({props:{title:"DiffEdit",local:"diffedit",headingTag:"h1"}}),W=new y({props:{code:"JTIzJTIwQ29sYWIlRUMlOTclOTAlRUMlODQlOUMlMjAlRUQlOTUlODQlRUMlOUElOTQlRUQlOTUlOUMlMjAlRUIlOUQlQkMlRUMlOUQlQjQlRUIlQjglOEMlRUIlOUYlQUMlRUIlQTYlQUMlRUIlQTUlQkMlMjAlRUMlODQlQTQlRUMlQjklOTglRUQlOTUlOTglRUElQjglQjAlMjAlRUMlOUMlODQlRUQlOTUlQjQlMjAlRUMlQTMlQkMlRUMlODQlOUQlRUMlOUQlODQlMjAlRUMlQTAlOUMlRUMlOTklQjglRUQlOTUlOTglRUMlODQlQjglRUMlOUElOTQlMEElMjMhcGlwJTIwaW5zdGFsbCUyMC1xJTIwZGlmZnVzZXJzJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZQ==",highlighted:`<span class="hljs-comment"># Colab에서 필요한 라이브러리를 설치하기 위해 주석을 제외하세요</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate</span>`,wrap:!1}}),B=new y({props:{code:"c291cmNlX3Byb21wdCUyMCUzRCUyMCUyMmElMjBib3dsJTIwb2YlMjBmcnVpdHMlMjIlMEF0YXJnZXRfcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJvd2wlMjBvZiUyMHBlYXJzJTIy",highlighted:`source_prompt = <span class="hljs-string">&quot;a bowl of fruits&quot;</span>
target_prompt = <span class="hljs-string">&quot;a bowl of pears&quot;</span>`,wrap:!1}}),X=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMERESU1JbnZlcnNlU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uRGlmZkVkaXRQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uRGlmZkVkaXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHNhZmV0eV9jaGVja2VyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmludmVyc2Vfc2NoZWR1bGVyJTIwJTNEJTIwRERJTUludmVyc2VTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGVsaW5lLmVuYWJsZV92YWVfc2xpY2luZygp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, DDIMInverseScheduler, StableDiffusionDiffEditPipeline

pipeline = StableDiffusionDiffEditPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()
pipeline.enable_vae_slicing()`,wrap:!1}}),C=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGWGlhbmctY2QlMkZEaWZmRWRpdC1zdGFibGUtZGlmZnVzaW9uJTJGcmF3JTJGbWFpbiUyRmFzc2V0cyUyRm9yaWdpbi5wbmclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFyYXdfaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

img_url = <span class="hljs-string">&quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;</span>
raw_image = load_image(img_url).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
raw_image`,wrap:!1}}),Q=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBc291cmNlX3Byb21wdCUyMCUzRCUyMCUyMmElMjBib3dsJTIwb2YlMjBmcnVpdHMlMjIlMEF0YXJnZXRfcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJhc2tldCUyMG9mJTIwcGVhcnMlMjIlMEFtYXNrX2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUuZ2VuZXJhdGVfbWFzayglMEElMjAlMjAlMjAlMjBpbWFnZSUzRHJhd19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMHNvdXJjZV9wcm9tcHQlM0Rzb3VyY2VfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3Byb21wdCUzRHRhcmdldF9wcm9tcHQlMkMlMEEpJTBBSW1hZ2UuZnJvbWFycmF5KChtYXNrX2ltYWdlLnNxdWVlemUoKSoyNTUpLmFzdHlwZSglMjJ1aW50OCUyMiklMkMlMjAlMjJMJTIyKS5yZXNpemUoKDc2OCUyQyUyMDc2OCkp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

source_prompt = <span class="hljs-string">&quot;a bowl of fruits&quot;</span>
target_prompt = <span class="hljs-string">&quot;a basket of pears&quot;</span>
mask_image = pipeline.generate_mask(
    image=raw_image,
    source_prompt=source_prompt,
    target_prompt=target_prompt,
)
Image.fromarray((mask_image.squeeze()*<span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>), <span class="hljs-string">&quot;L&quot;</span>).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))`,wrap:!1}}),E=new y({props:{code:"aW52X2xhdGVudHMlMjAlM0QlMjBwaXBlbGluZS5pbnZlcnQocHJvbXB0JTNEc291cmNlX3Byb21wdCUyQyUyMGltYWdlJTNEcmF3X2ltYWdlKS5sYXRlbnRz",highlighted:"inv_latents = pipeline.invert(prompt=source_prompt, image=raw_image).latents",wrap:!1}}),H=new y({props:{code:"b3V0cHV0X2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEdGFyZ2V0X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfbGF0ZW50cyUzRGludl9sYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEc291cmNlX3Byb21wdCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoKG1hc2tfaW1hZ2Uuc3F1ZWV6ZSgpKjI1NSkuYXN0eXBlKCUyMnVpbnQ4JTIyKSUyQyUyMCUyMkwlMjIpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFtYWtlX2ltYWdlX2dyaWQoJTVCcmF3X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMG91dHB1dF9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`output_image = pipeline(
    prompt=target_prompt,
    mask_image=mask_image,
    image_latents=inv_latents,
    negative_prompt=source_prompt,
).images[<span class="hljs-number">0</span>]
mask_image = Image.fromarray((mask_image.squeeze()*<span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>), <span class="hljs-string">&quot;L&quot;</span>).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
make_image_grid([raw_image, mask_image, output_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),$=new ie({props:{title:"Source와 target 임베딩 생성하기",local:"source와-target-임베딩-생성하기",headingTag:"h2"}}),x=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1sYXJnZSUyMiklMEFtb2RlbCUyMCUzRCUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LWxhcmdlJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, T5ForConditionalGeneration

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-large&quot;</span>)
model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-large&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.float16)`,wrap:!1}}),S=new y({props:{code:"c291cmNlX2NvbmNlcHQlMjAlM0QlMjAlMjJib3dsJTIyJTBBdGFyZ2V0X2NvbmNlcHQlMjAlM0QlMjAlMjJiYXNrZXQlMjIlMEElMEFzb3VyY2VfdGV4dCUyMCUzRCUyMGYlMjJQcm92aWRlJTIwYSUyMGNhcHRpb24lMjBmb3IlMjBpbWFnZXMlMjBjb250YWluaW5nJTIwYSUyMCU3QnNvdXJjZV9jb25jZXB0JTdELiUyMCUyMiUwQSUyMlRoZSUyMGNhcHRpb25zJTIwc2hvdWxkJTIwYmUlMjBpbiUyMEVuZ2xpc2glMjBhbmQlMjBzaG91bGQlMjBiZSUyMG5vJTIwbG9uZ2VyJTIwdGhhbiUyMDE1MCUyMGNoYXJhY3RlcnMuJTIyJTBBJTBBdGFyZ2V0X3RleHQlMjAlM0QlMjBmJTIyUHJvdmlkZSUyMGElMjBjYXB0aW9uJTIwZm9yJTIwaW1hZ2VzJTIwY29udGFpbmluZyUyMGElMjAlN0J0YXJnZXRfY29uY2VwdCU3RC4lMjAlMjIlMEElMjJUaGUlMjBjYXB0aW9ucyUyMHNob3VsZCUyMGJlJTIwaW4lMjBFbmdsaXNoJTIwYW5kJTIwc2hvdWxkJTIwYmUlMjBubyUyMGxvbmdlciUyMHRoYW4lMjAxNTAlMjBjaGFyYWN0ZXJzLiUyMg==",highlighted:`source_concept = <span class="hljs-string">&quot;bowl&quot;</span>
target_concept = <span class="hljs-string">&quot;basket&quot;</span>

source_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{source_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>

target_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{target_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>`,wrap:!1}}),D=new y({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwZ2VuZXJhdGVfcHJvbXB0cyhpbnB1dF9wcm9tcHQpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3Byb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcy50byglMjJjdWRhJTIyKSUwQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuOCUyQyUyMG51bV9yZXR1cm5fc2VxdWVuY2VzJTNEMTYlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjglMkMlMjB0b3BfayUzRDEwJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQXNvdXJjZV9wcm9tcHRzJTIwJTNEJTIwZ2VuZXJhdGVfcHJvbXB0cyhzb3VyY2VfdGV4dCklMEF0YXJnZXRfcHJvbXB0cyUyMCUzRCUyMGdlbmVyYXRlX3Byb21wdHModGFyZ2V0X3RleHQpJTBBcHJpbnQoc291cmNlX3Byb21wdHMpJTBBcHJpbnQodGFyZ2V0X3Byb21wdHMp",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_prompts</span>(<span class="hljs-params">input_prompt</span>):
    input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids.to(<span class="hljs-string">&quot;cuda&quot;</span>)

    outputs = model.generate(
        input_ids, temperature=<span class="hljs-number">0.8</span>, num_return_sequences=<span class="hljs-number">16</span>, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">128</span>, top_k=<span class="hljs-number">10</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)

source_prompts = generate_prompts(source_text)
target_prompts = generate_prompts(target_text)
<span class="hljs-built_in">print</span>(source_prompts)
<span class="hljs-built_in">print</span>(target_prompts)`,wrap:!1}}),L=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionDiffEditPipeline

pipeline = StableDiffusionDiffEditPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
pipeline.enable_vae_slicing()

<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">embed_prompts</span>(<span class="hljs-params">sentences, tokenizer, text_encoder, device=<span class="hljs-string">&quot;cuda&quot;</span></span>):
    embeddings = []
    <span class="hljs-keyword">for</span> sent <span class="hljs-keyword">in</span> sentences:
        text_inputs = tokenizer(
            sent,
            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
            max_length=tokenizer.model_max_length,
            truncation=<span class="hljs-literal">True</span>,
            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
        )
        text_input_ids = text_inputs.input_ids
        prompt_embeds = text_encoder(text_input_ids.to(device), attention_mask=<span class="hljs-literal">None</span>)[<span class="hljs-number">0</span>]
        embeddings.append(prompt_embeds)
    <span class="hljs-keyword">return</span> torch.concatenate(embeddings, dim=<span class="hljs-number">0</span>).mean(dim=<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)

source_embeds = embed_prompts(source_prompts, pipeline.tokenizer, pipeline.text_encoder)
target_embeds = embed_prompts(target_prompts, pipeline.tokenizer, pipeline.text_encoder)`,wrap:!1}}),P=new y({props:{code:"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",highlighted:`  from diffusers import DDIMInverseScheduler, DDIMScheduler
  from diffusers.utils import load_image, make_image_grid
  from PIL import Image

  pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
  pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)

  img_url = &quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;
  raw_image = load_image(img_url).resize((768, 768))

  mask_image = pipeline.generate_mask(
      image=raw_image,
<span class="hljs-deletion">-     source_prompt=source_prompt,</span>
<span class="hljs-deletion">-     target_prompt=target_prompt,</span>
<span class="hljs-addition">+     source_prompt_embeds=source_embeds,</span>
<span class="hljs-addition">+     target_prompt_embeds=target_embeds,</span>
  )

  inv_latents = pipeline.invert(
<span class="hljs-deletion">-     prompt=source_prompt,</span>
<span class="hljs-addition">+     prompt_embeds=source_embeds,</span>
      image=raw_image,
  ).latents

  output_image = pipeline(
      mask_image=mask_image,
      image_latents=inv_latents,
<span class="hljs-deletion">-     prompt=target_prompt,</span>
<span class="hljs-deletion">-     negative_prompt=source_prompt,</span>
<span class="hljs-addition">+     prompt_embeds=target_embeds,</span>
<span class="hljs-addition">+     negative_prompt_embeds=source_embeds,</span>
  ).images[0]
  mask_image = Image.fromarray((mask_image.squeeze()*255).astype(&quot;uint8&quot;), &quot;L&quot;)
  make_image_grid([raw_image, mask_image, output_image], rows=1, cols=3)`,wrap:!1}}),O=new ie({props:{title:"반전을 위한 캡션 생성하기",local:"반전을-위한-캡션-생성하기",headingTag:"h2"}}),tl=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQmxpcEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMEJsaXBQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBCbGlwUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGYmxpcC1pbWFnZS1jYXB0aW9uaW5nLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBCbGlwRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGYmxpcC1pbWFnZS1jYXB0aW9uaW5nLWJhc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BlipForConditionalGeneration, BlipProcessor

processor = BlipProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>)
model = BlipForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>)`,wrap:!1}}),al=new y({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwZ2VuZXJhdGVfY2FwdGlvbihpbWFnZXMlMkMlMjBjYXB0aW9uX2dlbmVyYXRvciUyQyUyMGNhcHRpb25fcHJvY2Vzc29yKSUzQSUwQSUyMCUyMCUyMCUyMHRleHQlMjAlM0QlMjAlMjJhJTIwcGhvdG9ncmFwaCUyMG9mJTIyJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwY2FwdGlvbl9wcm9jZXNzb3IoaW1hZ2VzJTJDJTIwdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRGNhcHRpb25fZ2VuZXJhdG9yLmR0eXBlKSUwQSUyMCUyMCUyMCUyMGNhcHRpb25fZ2VuZXJhdG9yLnRvKCUyMmN1ZGElMjIpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMGNhcHRpb25fZ2VuZXJhdG9yLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUVDJUJBJUExJUVDJTg1JTk4JTIwZ2VuZXJhdG9yJTIwJUVDJTk4JUE0JUVEJTk0JTg0JUVCJUExJTlDJUVCJTkzJTlDJTBBJTIwJTIwJTIwJTIwY2FwdGlvbl9nZW5lcmF0b3IudG8oJTIyY3B1JTIyKSUwQSUwQSUyMCUyMCUyMCUyMGNhcHRpb24lMjAlM0QlMjBjYXB0aW9uX3Byb2Nlc3Nvci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBjYXB0aW9u",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_caption</span>(<span class="hljs-params">images, caption_generator, caption_processor</span>):
    text = <span class="hljs-string">&quot;a photograph of&quot;</span>

    inputs = caption_processor(images, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=caption_generator.dtype)
    caption_generator.to(<span class="hljs-string">&quot;cuda&quot;</span>)
    outputs = caption_generator.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)

    <span class="hljs-comment"># 캡션 generator 오프로드</span>
    caption_generator.to(<span class="hljs-string">&quot;cpu&quot;</span>)

    caption = caption_processor.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> caption`,wrap:!1}}),pl=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGWGlhbmctY2QlMkZEaWZmRWRpdC1zdGFibGUtZGlmZnVzaW9uJTJGcmF3JTJGbWFpbiUyRmFzc2V0cyUyRm9yaWdpbi5wbmclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFjYXB0aW9uJTIwJTNEJTIwZ2VuZXJhdGVfY2FwdGlvbihyYXdfaW1hZ2UlMkMlMjBtb2RlbCUyQyUyMHByb2Nlc3Nvcik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;</span>
raw_image = load_image(img_url).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
caption = generate_caption(raw_image, model, processor)`,wrap:!1}}),ml=new Fe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ko/using-diffusers/diffedit.md"}}),{c(){T=p("meta"),rl=a(),ol=p("p"),Jl=a(),o(U.$$.fragment),dl=a(),o(f.$$.fragment),yl=a(),o(j.$$.fragment),Tl=a(),Z=p("p"),Z.textContent=oe,ul=a(),g=p("ol"),g.innerHTML=Me,wl=a(),I=p("p"),I.textContent=ce,bl=a(),h=p("p"),h.textContent=re,Ul=a(),o(W.$$.fragment),fl=a(),_=p("p"),_.innerHTML=Je,jl=a(),o(B.$$.fragment),Zl=a(),G=p("p"),G.innerHTML=de,gl=a(),R=p("p"),R.textContent=ye,Il=a(),o(X.$$.fragment),hl=a(),V=p("p"),V.textContent=Te,Wl=a(),o(C.$$.fragment),_l=a(),k=p("p"),k.innerHTML=ue,Bl=a(),o(Q.$$.fragment),Gl=a(),v=p("p"),v.textContent=we,Rl=a(),o(E.$$.fragment),Xl=a(),Y=p("p"),Y.innerHTML=be,Vl=a(),o(H.$$.fragment),Cl=a(),u=p("div"),u.innerHTML=Ue,kl=a(),o($.$$.fragment),Ql=a(),N=p("p"),N.innerHTML=fe,vl=a(),F=p("p"),F.textContent=je,El=a(),o(x.$$.fragment),Yl=a(),z=p("p"),z.textContent=Ze,Hl=a(),o(S.$$.fragment),$l=a(),A=p("p"),A.textContent=ge,Nl=a(),o(D.$$.fragment),Fl=a(),w=p("blockquote"),w.innerHTML=Ie,xl=a(),q=p("p"),q.innerHTML=he,zl=a(),o(L.$$.fragment),Sl=a(),K=p("p"),K.innerHTML=We,Al=a(),o(P.$$.fragment),Dl=a(),o(O.$$.fragment),ql=a(),ll=p("p"),ll.innerHTML=_e,Ll=a(),el=p("p"),el.textContent=Be,Kl=a(),o(tl.$$.fragment),Pl=a(),sl=p("p"),sl.textContent=Ge,Ol=a(),o(al.$$.fragment),le=a(),nl=p("p"),nl.innerHTML=Re,ee=a(),o(pl.$$.fragment),te=a(),b=p("div"),b.innerHTML=Xe,se=a(),il=p("p"),il.innerHTML=Ve,ae=a(),o(ml.$$.fragment),ne=a(),Ml=p("p"),this.h()},l(l){const e=He("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(t),rl=n(l),ol=i(l,"P",{}),Ce(ol).forEach(t),Jl=n(l),M(U.$$.fragment,l),dl=n(l),M(f.$$.fragment,l),yl=n(l),M(j.$$.fragment,l),Tl=n(l),Z=i(l,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-2mpbmd"&&(Z.textContent=oe),ul=n(l),g=i(l,"OL",{"data-svelte-h":!0}),m(g)!=="svelte-pey9sj"&&(g.innerHTML=Me),wl=n(l),I=i(l,"P",{"data-svelte-h":!0}),m(I)!=="svelte-kuwfj4"&&(I.textContent=ce),bl=n(l),h=i(l,"P",{"data-svelte-h":!0}),m(h)!=="svelte-1dydg7a"&&(h.textContent=re),Ul=n(l),M(W.$$.fragment,l),fl=n(l),_=i(l,"P",{"data-svelte-h":!0}),m(_)!=="svelte-xrqotw"&&(_.innerHTML=Je),jl=n(l),M(B.$$.fragment,l),Zl=n(l),G=i(l,"P",{"data-svelte-h":!0}),m(G)!=="svelte-e4y31s"&&(G.innerHTML=de),gl=n(l),R=i(l,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1rujngr"&&(R.textContent=ye),Il=n(l),M(X.$$.fragment,l),hl=n(l),V=i(l,"P",{"data-svelte-h":!0}),m(V)!=="svelte-w1crpy"&&(V.textContent=Te),Wl=n(l),M(C.$$.fragment,l),_l=n(l),k=i(l,"P",{"data-svelte-h":!0}),m(k)!=="svelte-pmxeaq"&&(k.innerHTML=ue),Bl=n(l),M(Q.$$.fragment,l),Gl=n(l),v=i(l,"P",{"data-svelte-h":!0}),m(v)!=="svelte-nvc4r3"&&(v.textContent=we),Rl=n(l),M(E.$$.fragment,l),Xl=n(l),Y=i(l,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-rr1tl7"&&(Y.innerHTML=be),Vl=n(l),M(H.$$.fragment,l),Cl=n(l),u=i(l,"DIV",{class:!0,"data-svelte-h":!0}),m(u)!=="svelte-6s9t77"&&(u.innerHTML=Ue),kl=n(l),M($.$$.fragment,l),Ql=n(l),N=i(l,"P",{"data-svelte-h":!0}),m(N)!=="svelte-9hjii0"&&(N.innerHTML=fe),vl=n(l),F=i(l,"P",{"data-svelte-h":!0}),m(F)!=="svelte-nlvmrb"&&(F.textContent=je),El=n(l),M(x.$$.fragment,l),Yl=n(l),z=i(l,"P",{"data-svelte-h":!0}),m(z)!=="svelte-n8m7wd"&&(z.textContent=Ze),Hl=n(l),M(S.$$.fragment,l),$l=n(l),A=i(l,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1yqnb1t"&&(A.textContent=ge),Nl=n(l),M(D.$$.fragment,l),Fl=n(l),w=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(w)!=="svelte-ucjm7d"&&(w.innerHTML=Ie),xl=n(l),q=i(l,"P",{"data-svelte-h":!0}),m(q)!=="svelte-n2xyim"&&(q.innerHTML=he),zl=n(l),M(L.$$.fragment,l),Sl=n(l),K=i(l,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1x8m5so"&&(K.innerHTML=We),Al=n(l),M(P.$$.fragment,l),Dl=n(l),M(O.$$.fragment,l),ql=n(l),ll=i(l,"P",{"data-svelte-h":!0}),m(ll)!=="svelte-13u0kl2"&&(ll.innerHTML=_e),Ll=n(l),el=i(l,"P",{"data-svelte-h":!0}),m(el)!=="svelte-t95mcn"&&(el.textContent=Be),Kl=n(l),M(tl.$$.fragment,l),Pl=n(l),sl=i(l,"P",{"data-svelte-h":!0}),m(sl)!=="svelte-lp3q9g"&&(sl.textContent=Ge),Ol=n(l),M(al.$$.fragment,l),le=n(l),nl=i(l,"P",{"data-svelte-h":!0}),m(nl)!=="svelte-1y7rdgp"&&(nl.innerHTML=Re),ee=n(l),M(pl.$$.fragment,l),te=n(l),b=i(l,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-1jq3ee2"&&(b.innerHTML=Xe),se=n(l),il=i(l,"P",{"data-svelte-h":!0}),m(il)!=="svelte-1lrhtv2"&&(il.innerHTML=Ve),ae=n(l),M(ml.$$.fragment,l),ne=n(l),Ml=i(l,"P",{}),Ce(Ml).forEach(t),this.h()},h(){cl(T,"name","hf:doc:metadata"),cl(T,"content",Se),cl(u,"class","flex gap-4"),cl(w,"class","tip"),cl(b,"class","flex justify-center")},m(l,e){$e(document.head,T),s(l,rl,e),s(l,ol,e),s(l,Jl,e),c(U,l,e),s(l,dl,e),c(f,l,e),s(l,yl,e),c(j,l,e),s(l,Tl,e),s(l,Z,e),s(l,ul,e),s(l,g,e),s(l,wl,e),s(l,I,e),s(l,bl,e),s(l,h,e),s(l,Ul,e),c(W,l,e),s(l,fl,e),s(l,_,e),s(l,jl,e),c(B,l,e),s(l,Zl,e),s(l,G,e),s(l,gl,e),s(l,R,e),s(l,Il,e),c(X,l,e),s(l,hl,e),s(l,V,e),s(l,Wl,e),c(C,l,e),s(l,_l,e),s(l,k,e),s(l,Bl,e),c(Q,l,e),s(l,Gl,e),s(l,v,e),s(l,Rl,e),c(E,l,e),s(l,Xl,e),s(l,Y,e),s(l,Vl,e),c(H,l,e),s(l,Cl,e),s(l,u,e),s(l,kl,e),c($,l,e),s(l,Ql,e),s(l,N,e),s(l,vl,e),s(l,F,e),s(l,El,e),c(x,l,e),s(l,Yl,e),s(l,z,e),s(l,Hl,e),c(S,l,e),s(l,$l,e),s(l,A,e),s(l,Nl,e),c(D,l,e),s(l,Fl,e),s(l,w,e),s(l,xl,e),s(l,q,e),s(l,zl,e),c(L,l,e),s(l,Sl,e),s(l,K,e),s(l,Al,e),c(P,l,e),s(l,Dl,e),c(O,l,e),s(l,ql,e),s(l,ll,e),s(l,Ll,e),s(l,el,e),s(l,Kl,e),c(tl,l,e),s(l,Pl,e),s(l,sl,e),s(l,Ol,e),c(al,l,e),s(l,le,e),s(l,nl,e),s(l,ee,e),c(pl,l,e),s(l,te,e),s(l,b,e),s(l,se,e),s(l,il,e),s(l,ae,e),c(ml,l,e),s(l,ne,e),s(l,Ml,e),pe=!0},p:Qe,i(l){pe||(r(U.$$.fragment,l),r(f.$$.fragment,l),r(j.$$.fragment,l),r(W.$$.fragment,l),r(B.$$.fragment,l),r(X.$$.fragment,l),r(C.$$.fragment,l),r(Q.$$.fragment,l),r(E.$$.fragment,l),r(H.$$.fragment,l),r($.$$.fragment,l),r(x.$$.fragment,l),r(S.$$.fragment,l),r(D.$$.fragment,l),r(L.$$.fragment,l),r(P.$$.fragment,l),r(O.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(pl.$$.fragment,l),r(ml.$$.fragment,l),pe=!0)},o(l){J(U.$$.fragment,l),J(f.$$.fragment,l),J(j.$$.fragment,l),J(W.$$.fragment,l),J(B.$$.fragment,l),J(X.$$.fragment,l),J(C.$$.fragment,l),J(Q.$$.fragment,l),J(E.$$.fragment,l),J(H.$$.fragment,l),J($.$$.fragment,l),J(x.$$.fragment,l),J(S.$$.fragment,l),J(D.$$.fragment,l),J(L.$$.fragment,l),J(P.$$.fragment,l),J(O.$$.fragment,l),J(tl.$$.fragment,l),J(al.$$.fragment,l),J(pl.$$.fragment,l),J(ml.$$.fragment,l),pe=!1},d(l){l&&(t(rl),t(ol),t(Jl),t(dl),t(yl),t(Tl),t(Z),t(ul),t(g),t(wl),t(I),t(bl),t(h),t(Ul),t(fl),t(_),t(jl),t(Zl),t(G),t(gl),t(R),t(Il),t(hl),t(V),t(Wl),t(_l),t(k),t(Bl),t(Gl),t(v),t(Rl),t(Xl),t(Y),t(Vl),t(Cl),t(u),t(kl),t(Ql),t(N),t(vl),t(F),t(El),t(Yl),t(z),t(Hl),t($l),t(A),t(Nl),t(Fl),t(w),t(xl),t(q),t(zl),t(Sl),t(K),t(Al),t(Dl),t(ql),t(ll),t(Ll),t(el),t(Kl),t(Pl),t(sl),t(Ol),t(le),t(nl),t(ee),t(te),t(b),t(se),t(il),t(ae),t(ne),t(Ml)),t(T),d(U,l),d(f,l),d(j,l),d(W,l),d(B,l),d(X,l),d(C,l),d(Q,l),d(E,l),d(H,l),d($,l),d(x,l),d(S,l),d(D,l),d(L,l),d(P,l),d(O,l),d(tl,l),d(al,l),d(pl,l),d(ml,l)}}}const Se='{"title":"DiffEdit","local":"diffedit","sections":[{"title":"Source와 target 임베딩 생성하기","local":"source와-target-임베딩-생성하기","sections":[],"depth":2},{"title":"반전을 위한 캡션 생성하기","local":"반전을-위한-캡션-생성하기","sections":[],"depth":2}],"depth":1}';function Ae(me){return ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Ee{constructor(T){super(),Ye(this,T,Ae,ze,ke,{})}}export{Oe as component};
