import{s as St,n as Qt,o as Ft}from"../chunks/scheduler.32f3c0d7.js";import{S as Yt,i as Dt,e as a,s as i,c as m,h as Et,a as p,d as t,b as n,f as Nt,j as c,g as r,k as y,l as Pt,m as s,n as u,t as f,o as M,p as o}from"../chunks/index.a3055d2a.js";import{C as At,H as $,E as qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6b532bee.js";import{C as d}from"../chunks/CodeBlock.f0d1675e.js";import{D as Kt}from"../chunks/DocNotebookDropdown.03988dd0.js";function Ot(et){let b,Be,ke,xe,v,Re,W,Xe,_,Le,V,lt="<code>DiffusionPipeline</code>を使って特定のスタイルで画像を生成したり、希望する画像を生成したりするのは難しいことです。多くの場合、<code>DiffusionPipeline</code>を何度か実行してからでないと満足のいく画像は得られません。しかし、何もないところから何かを生成するにはたくさんの計算が必要です。生成を何度も何度も実行する場合、特にたくさんの計算量が必要になります。",ze,C,tt="そのため、パイプラインから<em>計算</em>（速度）と<em>メモリ</em>（GPU RAM）の効率を最大限に引き出し、生成サイクル間の時間を短縮することで、より高速な反復処理を行えるようにすることが重要です。",Ne,H,st="このチュートリアルでは、<code>DiffusionPipeline</code>を用いて、より速く、より良い計算を行う方法を説明します。",Se,k,it='まず、<a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a>モデルをロードします：',Qe,I,Fe,B,nt="ここで使用するプロンプトの例は年老いた戦士の長の肖像画ですが、ご自由に変更してください：",Ye,x,De,R,Ee,h,at='<p>💡 GPUを利用できない場合は、<a href="https://colab.research.google.com/" rel="nofollow">Colab</a>のようなGPUプロバイダーから無料で利用できます！</p>',Pe,X,pt="画像生成を高速化する最も簡単な方法の1つは、PyTorchモジュールと同じようにGPU上にパイプラインを配置することです：",Ae,L,qe,z,rt='同じイメージを使って改良できるようにするには、<a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>Generator</code></a>を使い、<a href="./using-diffusers/reusing_seeds">reproducibility</a>の種を設定します：',Ke,N,Oe,S,mt="これで画像を生成できます：",el,Q,ll,J,ct='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_1.png"/>',tl,F,ut="この処理にはT4 GPUで~30秒かかりました（割り当てられているGPUがT4より優れている場合はもっと速いかもしれません）。デフォルトでは、<code>DiffusionPipeline</code>は完全な<code>float32</code>精度で生成を50ステップ実行します。float16`のような低い精度に変更するか、推論ステップ数を減らすことで高速化することができます。",sl,Y,ft="まずは <code>float16</code> でモデルをロードして画像を生成してみましょう：",il,D,nl,w,Mt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_2.png"/>',al,E,ot="今回、画像生成にかかった時間はわずか11秒で、以前より3倍近く速くなりました！",pl,T,dt="<p>💡 パイプラインは常に <code>float16</code> で実行することを強くお勧めします。</p>",rl,P,yt="生成ステップ数を減らすという方法もあります。より効率的なスケジューラを選択することで、出力品質を犠牲にすることなくステップ数を減らすことができます。<code>compatibles</code>メソッドを呼び出すことで、<code>DiffusionPipeline</code>の現在のモデルと互換性のあるスケジューラを見つけることができます：",ml,A,cl,q,bt="Stable Diffusionモデルはデフォルトで<code>PNDMScheduler</code>を使用します。このスケジューラは通常~50の推論ステップを必要としますが、<code>DPMSolverMultistepScheduler</code>のような高性能なスケジューラでは~20または25の推論ステップで済みます。<code>ConfigMixin.from_config()</code>メソッドを使用すると、新しいスケジューラをロードすることができます：",ul,K,fl,O,ht="ここで <code>num_inference_steps</code> を20に設定します：",Ml,ee,ol,U,Jt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_3.png"/>',dl,le,wt="推論時間をわずか4秒に短縮することに成功した！⚡️",yl,te,bl,se,Tt="パイプラインのパフォーマンスを向上させるもう1つの鍵は、消費メモリを少なくすることです。一度に生成できる画像の数を確認する最も簡単な方法は、<code>OutOfMemoryError</code>（OOM）が発生するまで、さまざまなバッチサイズを試してみることです。",hl,ie,Ut="文章と <code>Generators</code> のリストから画像のバッチを生成する関数を作成します。各 <code>Generator</code> にシードを割り当てて、良い結果が得られた場合に再利用できるようにします。",Jl,ne,wl,ae,Zt="<code>batch_size=4</code>で開始し、どれだけメモリを消費したかを確認します：",Tl,pe,Ul,re,gt="大容量のRAMを搭載したGPUでない限り、上記のコードはおそらく<code>OOM</code>エラーを返したはずです！メモリの大半はクロスアテンションレイヤーが占めています。この処理をバッチで実行する代わりに、逐次実行することでメモリを大幅に節約できます。必要なのは、<code>enable_attention_slicing()</code>関数を使用することだけです：",Zl,me,gl,ce,jt="今度は<code>batch_size</code>を8にしてみてください！",jl,ue,Gl,Z,Gt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_5.png"/>',$l,fe,$t="以前は4枚の画像のバッチを生成することさえできませんでしたが、今では8枚の画像のバッチを1枚あたり～3.5秒で生成できます！これはおそらく、品質を犠牲にすることなくT4 GPUでできる最速の処理速度です。",vl,Me,Wl,oe,vt="前の2つのセクションでは、<code>fp16</code> を使ってパイプラインの速度を最適化する方法、よりパフォーマン スなスケジューラーを使って生成ステップ数を減らす方法、アテンションスライスを有効 にしてメモリ消費量を減らす方法について学びました。今度は、生成される画像の品質を向上させる方法に焦点を当てます。",_l,de,Vl,ye,Wt='最も単純なステップは、より良いチェックポイントを使うことです。Stable Diffusionモデルは良い出発点であり、公式発表以来、いくつかの改良版もリリースされています。しかし、新しいバージョンを使ったからといって、自動的に良い結果が得られるわけではありません。最良の結果を得るためには、自分でさまざまなチェックポイントを試してみたり、ちょっとした研究（<a href="https://minimaxir.com/2022/11/stable-diffusion-negative-prompt/" rel="nofollow">ネガティブプロンプト</a>の使用など）をしたりする必要があります。',Cl,be,_t='この分野が成長するにつれて、特定のスタイルを生み出すために微調整された、より質の高いチェックポイントが増えています。<a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">Hub</a>や<a href="https://huggingface.co/spaces/huggingface-projects/diffusers-gallery" rel="nofollow">Diffusers Gallery</a>を探索して、興味のあるものを見つけてみてください！',Hl,he,kl,Je,Vt='現在のパイプラインコンポーネントを新しいバージョンに置き換えてみることもできます。Stability AIが提供する最新の<a href="https://huggingface.co/stabilityai/stable-diffusion-2-1/tree/main/vae" rel="nofollow">autodecoder</a>をパイプラインにロードし、画像を生成してみましょう：',Il,we,Bl,g,Ct='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_6.png"/>',xl,Te,Rl,Ue,Ht="画像を生成するために使用する文章は、<em>プロンプトエンジニアリング</em>と呼ばれる分野を作られるほど、非常に重要です。プロンプト・エンジニアリングで考慮すべき点は以下の通りです：",Xl,Ze,kt="<li>生成したい画像やその類似画像は、インターネット上にどのように保存されているか？</li> <li>私が望むスタイルにモデルを誘導するために、どのような追加詳細を与えるべきか？</li>",Ll,ge,It="このことを念頭に置いて、プロンプトに色やより質の高いディテールを含めるように改良してみましょう：",zl,je,Nl,Ge,Bt="新しいプロンプトで画像のバッチを生成しましょう：",Sl,$e,Ql,j,xt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_7.png"/>',Fl,ve,Rt="かなりいいです！種が<code>1</code>の<code>Generator</code>に対応する2番目の画像に、被写体の年齢に関するテキストを追加して、もう少し手を加えてみましょう：",Yl,We,Dl,G,Xt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_8.png"/>',El,_e,Pl,Ve,Lt="このチュートリアルでは、<code>DiffusionPipeline</code>を最適化して計算効率とメモリ効率を向上させ、生成される出力の品質を向上させる方法を学びました。パイプラインをさらに高速化することに興味があれば、以下のリソースを参照してください：",Al,Ce,zt='<li><a href="./optimization/torch2.0">PyTorch 2.0</a>と<a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a>がどのように生成速度を5-300%高速化できるかを学んでください。A100 GPUの場合、画像生成は最大50%速くなります！</li> <li>PyTorch 2が使えない場合は、<a href="./optimization/xformers">xFormers</a>をインストールすることをお勧めします。このライブラリのメモリ効率の良いアテンションメカニズムは PyTorch 1.13.1 と相性が良く、高速化とメモリ消費量の削減を同時に実現します。</li> <li>モデルのオフロードなど、その他の最適化テクニックは <a href="./optimization/fp16">this guide</a> でカバーされています。</li>',ql,He,Kl,Ie,Ol;return v=new At({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),W=new Kt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/tensorflow/stable_diffusion.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/tensorflow/stable_diffusion.ipynb"}]}}),_=new $({props:{title:"効果的で効率的な拡散モデル",local:"効果的で効率的な拡散モデル",headingTag:"h1"}}),I=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),x=new d({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMG9sZCUyMHdhcnJpb3IlMjBjaGllZiUyMg==",highlighted:'prompt = <span class="hljs-string">&quot;portrait photo of a old warrior chief&quot;</span>',wrap:!1}}),R=new $({props:{title:"Speed",local:"speed",headingTag:"h2"}}),L=new d({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:'pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),N=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCk=",highlighted:`<span class="hljs-keyword">import</span> torch

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)`,wrap:!1}}),Q=new d({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),D=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),A=new d({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVzJTBBJTVCJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19sbXNfZGlzY3JldGUuTE1TRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3VuaXBjX211bHRpc3RlcC5VbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfa19kcG1fMl9kaXNjcmV0ZS5LRFBNMkRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZWlzX211bHRpc3RlcC5ERUlTTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9kaXNjcmV0ZS5FdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfbXVsdGlzdGVwLkRQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRwbS5ERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfc2luZ2xlc3RlcC5EUE1Tb2x2ZXJTaW5nbGVzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19rX2RwbV8yX2FuY2VzdHJhbF9kaXNjcmV0ZS5LRFBNMkFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19oZXVuX2Rpc2NyZXRlLkhldW5EaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfcG5kbS5QTkRNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9hbmNlc3RyYWxfZGlzY3JldGUuRXVsZXJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRpbS5ERElNU2NoZWR1bGVyJTJDJTBBJTVE",highlighted:`pipeline.scheduler.compatibles
[
    diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
    diffusers.schedulers.scheduling_unipc_multistep.UniPCMultistepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_discrete.KDPM2DiscreteScheduler,
    diffusers.schedulers.scheduling_deis_multistep.DEISMultistepScheduler,
    diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
    diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
    diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
    diffusers.schedulers.scheduling_dpmsolver_singlestep.DPMSolverSinglestepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_ancestral_discrete.KDPM2AncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_heun_discrete.HeunDiscreteScheduler,
    diffusers.schedulers.scheduling_pndm.PNDMScheduler,
    diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_ddim.DDIMScheduler,
]`,wrap:!1}}),K=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),ee=new d({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),te=new $({props:{title:"メモリー",local:"メモリー",headingTag:"h2"}}),ne=new d({props:{code:"ZGVmJTIwZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNEMSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlMjAlM0QlMjAlNUJ0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoaSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShiYXRjaF9zaXplKSU1RCUwQSUyMCUyMCUyMCUyMHByb21wdHMlMjAlM0QlMjBiYXRjaF9zaXplJTIwKiUyMCU1QnByb21wdCU1RCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyMCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnByb21wdCUyMiUzQSUyMHByb21wdHMlMkMlMjAlMjJnZW5lcmF0b3IlMjIlM0ElMjBnZW5lcmF0b3IlMkMlMjAlMjJudW1faW5mZXJlbmNlX3N0ZXBzJTIyJTNBJTIwbnVtX2luZmVyZW5jZV9zdGVwcyU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_inputs</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1</span></span>):
    generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(i) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size)]
    prompts = batch_size * [prompt]
    num_inference_steps = <span class="hljs-number">20</span>

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: prompts, <span class="hljs-string">&quot;generator&quot;</span>: generator, <span class="hljs-string">&quot;num_inference_steps&quot;</span>: num_inference_steps}`,wrap:!1}}),pe=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCoqZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNENCkpLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjAyJTJDJTIwMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

images = pipeline(**get_inputs(batch_size=<span class="hljs-number">4</span>)).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),me=new d({props:{code:"cGlwZWxpbmUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCk=",highlighted:"pipeline.enable_attention_slicing()",wrap:!1}}),ue=new d({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),Me=new $({props:{title:"品質",local:"品質",headingTag:"h2"}}),de=new $({props:{title:"より良いチェックポイント",local:"より良いチェックポイント",headingTag:"h3"}}),he=new $({props:{title:"より良いパイプラインコンポーネント",local:"より良いパイプラインコンポーネント",headingTag:"h3"}}),we=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkLXZhZS1mdC1tc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudmFlJTIwJTNEJTIwdmFlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.vae = vae
images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),Te=new $({props:{title:"より良いプロンプト・エンジニアリング",local:"より良いプロンプトエンジニアリング",headingTag:"h3"}}),je=new d({props:{code:"cHJvbXB0JTIwJTJCJTNEJTIwJTIyJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMiUwQXByb21wdCUyMCUyQiUzRCUyMCUyMiUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMg==",highlighted:`prompt += <span class="hljs-string">&quot;, tribal panther make up, blue on red, side profile, looking away, serious eyes&quot;</span>
prompt += <span class="hljs-string">&quot; 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>`,wrap:!1}}),$e=new d({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),We=new d({props:{code:"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",highlighted:`prompts = [
    <span class="hljs-string">&quot;portrait photo of the oldest warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a old warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a young warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
]

generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(prompts))]
images = pipeline(prompt=prompts, generator=generator, num_inference_steps=<span class="hljs-number">25</span>).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),_e=new $({props:{title:"次のステップ",local:"次のステップ",headingTag:"h2"}}),He=new qt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ja/stable_diffusion.md"}}),{c(){b=a("meta"),Be=i(),ke=a("p"),xe=i(),m(v.$$.fragment),Re=i(),m(W.$$.fragment),Xe=i(),m(_.$$.fragment),Le=i(),V=a("p"),V.innerHTML=lt,ze=i(),C=a("p"),C.innerHTML=tt,Ne=i(),H=a("p"),H.innerHTML=st,Se=i(),k=a("p"),k.innerHTML=it,Qe=i(),m(I.$$.fragment),Fe=i(),B=a("p"),B.textContent=nt,Ye=i(),m(x.$$.fragment),De=i(),m(R.$$.fragment),Ee=i(),h=a("blockquote"),h.innerHTML=at,Pe=i(),X=a("p"),X.textContent=pt,Ae=i(),m(L.$$.fragment),qe=i(),z=a("p"),z.innerHTML=rt,Ke=i(),m(N.$$.fragment),Oe=i(),S=a("p"),S.textContent=mt,el=i(),m(Q.$$.fragment),ll=i(),J=a("div"),J.innerHTML=ct,tl=i(),F=a("p"),F.innerHTML=ut,sl=i(),Y=a("p"),Y.innerHTML=ft,il=i(),m(D.$$.fragment),nl=i(),w=a("div"),w.innerHTML=Mt,al=i(),E=a("p"),E.textContent=ot,pl=i(),T=a("blockquote"),T.innerHTML=dt,rl=i(),P=a("p"),P.innerHTML=yt,ml=i(),m(A.$$.fragment),cl=i(),q=a("p"),q.innerHTML=bt,ul=i(),m(K.$$.fragment),fl=i(),O=a("p"),O.innerHTML=ht,Ml=i(),m(ee.$$.fragment),ol=i(),U=a("div"),U.innerHTML=Jt,dl=i(),le=a("p"),le.textContent=wt,yl=i(),m(te.$$.fragment),bl=i(),se=a("p"),se.innerHTML=Tt,hl=i(),ie=a("p"),ie.innerHTML=Ut,Jl=i(),m(ne.$$.fragment),wl=i(),ae=a("p"),ae.innerHTML=Zt,Tl=i(),m(pe.$$.fragment),Ul=i(),re=a("p"),re.innerHTML=gt,Zl=i(),m(me.$$.fragment),gl=i(),ce=a("p"),ce.innerHTML=jt,jl=i(),m(ue.$$.fragment),Gl=i(),Z=a("div"),Z.innerHTML=Gt,$l=i(),fe=a("p"),fe.textContent=$t,vl=i(),m(Me.$$.fragment),Wl=i(),oe=a("p"),oe.innerHTML=vt,_l=i(),m(de.$$.fragment),Vl=i(),ye=a("p"),ye.innerHTML=Wt,Cl=i(),be=a("p"),be.innerHTML=_t,Hl=i(),m(he.$$.fragment),kl=i(),Je=a("p"),Je.innerHTML=Vt,Il=i(),m(we.$$.fragment),Bl=i(),g=a("div"),g.innerHTML=Ct,xl=i(),m(Te.$$.fragment),Rl=i(),Ue=a("p"),Ue.innerHTML=Ht,Xl=i(),Ze=a("ul"),Ze.innerHTML=kt,Ll=i(),ge=a("p"),ge.textContent=It,zl=i(),m(je.$$.fragment),Nl=i(),Ge=a("p"),Ge.textContent=Bt,Sl=i(),m($e.$$.fragment),Ql=i(),j=a("div"),j.innerHTML=xt,Fl=i(),ve=a("p"),ve.innerHTML=Rt,Yl=i(),m(We.$$.fragment),Dl=i(),G=a("div"),G.innerHTML=Xt,El=i(),m(_e.$$.fragment),Pl=i(),Ve=a("p"),Ve.innerHTML=Lt,Al=i(),Ce=a("ul"),Ce.innerHTML=zt,ql=i(),m(He.$$.fragment),Kl=i(),Ie=a("p"),this.h()},l(e){const l=Et("svelte-u9bgzb",document.head);b=p(l,"META",{name:!0,content:!0}),l.forEach(t),Be=n(e),ke=p(e,"P",{}),Nt(ke).forEach(t),xe=n(e),c(v.$$.fragment,e),Re=n(e),c(W.$$.fragment,e),Xe=n(e),c(_.$$.fragment,e),Le=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-110xkzt"&&(V.innerHTML=lt),ze=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-110m145"&&(C.innerHTML=tt),Ne=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-4juhq1"&&(H.innerHTML=st),Se=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-9bt3dz"&&(k.innerHTML=it),Qe=n(e),c(I.$$.fragment,e),Fe=n(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1p8bqyv"&&(B.textContent=nt),Ye=n(e),c(x.$$.fragment,e),De=n(e),c(R.$$.fragment,e),Ee=n(e),h=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-ng7pew"&&(h.innerHTML=at),Pe=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-10gtbbd"&&(X.textContent=pt),Ae=n(e),c(L.$$.fragment,e),qe=n(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-jq2u2i"&&(z.innerHTML=rt),Ke=n(e),c(N.$$.fragment,e),Oe=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1d3ggr0"&&(S.textContent=mt),el=n(e),c(Q.$$.fragment,e),ll=n(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1of5nwm"&&(J.innerHTML=ct),tl=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1g8ad1q"&&(F.innerHTML=ut),sl=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1li8qua"&&(Y.innerHTML=ft),il=n(e),c(D.$$.fragment,e),nl=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1why3l7"&&(w.innerHTML=Mt),al=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1ou4bc2"&&(E.textContent=ot),pl=n(e),T=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1s3r878"&&(T.innerHTML=dt),rl=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1w5obo7"&&(P.innerHTML=yt),ml=n(e),c(A.$$.fragment,e),cl=n(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1wi1jv0"&&(q.innerHTML=bt),ul=n(e),c(K.$$.fragment,e),fl=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1sfqrua"&&(O.innerHTML=ht),Ml=n(e),c(ee.$$.fragment,e),ol=n(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-19w49w4"&&(U.innerHTML=Jt),dl=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-76wtm1"&&(le.textContent=wt),yl=n(e),c(te.$$.fragment,e),bl=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-mvbq4l"&&(se.innerHTML=Tt),hl=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1hr0mha"&&(ie.innerHTML=Ut),Jl=n(e),c(ne.$$.fragment,e),wl=n(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1o7tisn"&&(ae.innerHTML=Zt),Tl=n(e),c(pe.$$.fragment,e),Ul=n(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1vhu601"&&(re.innerHTML=gt),Zl=n(e),c(me.$$.fragment,e),gl=n(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-fxkzqi"&&(ce.innerHTML=jt),jl=n(e),c(ue.$$.fragment,e),Gl=n(e),Z=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-vxa9bu"&&(Z.innerHTML=Gt),$l=n(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-16an5na"&&(fe.textContent=$t),vl=n(e),c(Me.$$.fragment,e),Wl=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-t5m3mc"&&(oe.innerHTML=vt),_l=n(e),c(de.$$.fragment,e),Vl=n(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1on671o"&&(ye.innerHTML=Wt),Cl=n(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-94e2nw"&&(be.innerHTML=_t),Hl=n(e),c(he.$$.fragment,e),kl=n(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-4hs92t"&&(Je.innerHTML=Vt),Il=n(e),c(we.$$.fragment,e),Bl=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-610rhb"&&(g.innerHTML=Ct),xl=n(e),c(Te.$$.fragment,e),Rl=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1mzftxu"&&(Ue.innerHTML=Ht),Xl=n(e),Ze=p(e,"UL",{"data-svelte-h":!0}),r(Ze)!=="svelte-rjnows"&&(Ze.innerHTML=kt),Ll=n(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-147l7so"&&(ge.textContent=It),zl=n(e),c(je.$$.fragment,e),Nl=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-175521y"&&(Ge.textContent=Bt),Sl=n(e),c($e.$$.fragment,e),Ql=n(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-n1o5lk"&&(j.innerHTML=xt),Fl=n(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-saeyf2"&&(ve.innerHTML=Rt),Yl=n(e),c(We.$$.fragment,e),Dl=n(e),G=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(G)!=="svelte-1lkw2bx"&&(G.innerHTML=Xt),El=n(e),c(_e.$$.fragment,e),Pl=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1uv4l8d"&&(Ve.innerHTML=Lt),Al=n(e),Ce=p(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-j2u29p"&&(Ce.innerHTML=zt),ql=n(e),c(He.$$.fragment,e),Kl=n(e),Ie=p(e,"P",{}),Nt(Ie).forEach(t),this.h()},h(){y(b,"name","hf:doc:metadata"),y(b,"content",es),y(h,"class","tip"),y(J,"class","flex justify-center"),y(w,"class","flex justify-center"),y(T,"class","tip"),y(U,"class","flex justify-center"),y(Z,"class","flex justify-center"),y(g,"class","flex justify-center"),y(j,"class","flex justify-center"),y(G,"class","flex justify-center")},m(e,l){Pt(document.head,b),s(e,Be,l),s(e,ke,l),s(e,xe,l),u(v,e,l),s(e,Re,l),u(W,e,l),s(e,Xe,l),u(_,e,l),s(e,Le,l),s(e,V,l),s(e,ze,l),s(e,C,l),s(e,Ne,l),s(e,H,l),s(e,Se,l),s(e,k,l),s(e,Qe,l),u(I,e,l),s(e,Fe,l),s(e,B,l),s(e,Ye,l),u(x,e,l),s(e,De,l),u(R,e,l),s(e,Ee,l),s(e,h,l),s(e,Pe,l),s(e,X,l),s(e,Ae,l),u(L,e,l),s(e,qe,l),s(e,z,l),s(e,Ke,l),u(N,e,l),s(e,Oe,l),s(e,S,l),s(e,el,l),u(Q,e,l),s(e,ll,l),s(e,J,l),s(e,tl,l),s(e,F,l),s(e,sl,l),s(e,Y,l),s(e,il,l),u(D,e,l),s(e,nl,l),s(e,w,l),s(e,al,l),s(e,E,l),s(e,pl,l),s(e,T,l),s(e,rl,l),s(e,P,l),s(e,ml,l),u(A,e,l),s(e,cl,l),s(e,q,l),s(e,ul,l),u(K,e,l),s(e,fl,l),s(e,O,l),s(e,Ml,l),u(ee,e,l),s(e,ol,l),s(e,U,l),s(e,dl,l),s(e,le,l),s(e,yl,l),u(te,e,l),s(e,bl,l),s(e,se,l),s(e,hl,l),s(e,ie,l),s(e,Jl,l),u(ne,e,l),s(e,wl,l),s(e,ae,l),s(e,Tl,l),u(pe,e,l),s(e,Ul,l),s(e,re,l),s(e,Zl,l),u(me,e,l),s(e,gl,l),s(e,ce,l),s(e,jl,l),u(ue,e,l),s(e,Gl,l),s(e,Z,l),s(e,$l,l),s(e,fe,l),s(e,vl,l),u(Me,e,l),s(e,Wl,l),s(e,oe,l),s(e,_l,l),u(de,e,l),s(e,Vl,l),s(e,ye,l),s(e,Cl,l),s(e,be,l),s(e,Hl,l),u(he,e,l),s(e,kl,l),s(e,Je,l),s(e,Il,l),u(we,e,l),s(e,Bl,l),s(e,g,l),s(e,xl,l),u(Te,e,l),s(e,Rl,l),s(e,Ue,l),s(e,Xl,l),s(e,Ze,l),s(e,Ll,l),s(e,ge,l),s(e,zl,l),u(je,e,l),s(e,Nl,l),s(e,Ge,l),s(e,Sl,l),u($e,e,l),s(e,Ql,l),s(e,j,l),s(e,Fl,l),s(e,ve,l),s(e,Yl,l),u(We,e,l),s(e,Dl,l),s(e,G,l),s(e,El,l),u(_e,e,l),s(e,Pl,l),s(e,Ve,l),s(e,Al,l),s(e,Ce,l),s(e,ql,l),u(He,e,l),s(e,Kl,l),s(e,Ie,l),Ol=!0},p:Qt,i(e){Ol||(f(v.$$.fragment,e),f(W.$$.fragment,e),f(_.$$.fragment,e),f(I.$$.fragment,e),f(x.$$.fragment,e),f(R.$$.fragment,e),f(L.$$.fragment,e),f(N.$$.fragment,e),f(Q.$$.fragment,e),f(D.$$.fragment,e),f(A.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(Me.$$.fragment,e),f(de.$$.fragment,e),f(he.$$.fragment,e),f(we.$$.fragment,e),f(Te.$$.fragment,e),f(je.$$.fragment,e),f($e.$$.fragment,e),f(We.$$.fragment,e),f(_e.$$.fragment,e),f(He.$$.fragment,e),Ol=!0)},o(e){M(v.$$.fragment,e),M(W.$$.fragment,e),M(_.$$.fragment,e),M(I.$$.fragment,e),M(x.$$.fragment,e),M(R.$$.fragment,e),M(L.$$.fragment,e),M(N.$$.fragment,e),M(Q.$$.fragment,e),M(D.$$.fragment,e),M(A.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(ue.$$.fragment,e),M(Me.$$.fragment,e),M(de.$$.fragment,e),M(he.$$.fragment,e),M(we.$$.fragment,e),M(Te.$$.fragment,e),M(je.$$.fragment,e),M($e.$$.fragment,e),M(We.$$.fragment,e),M(_e.$$.fragment,e),M(He.$$.fragment,e),Ol=!1},d(e){e&&(t(Be),t(ke),t(xe),t(Re),t(Xe),t(Le),t(V),t(ze),t(C),t(Ne),t(H),t(Se),t(k),t(Qe),t(Fe),t(B),t(Ye),t(De),t(Ee),t(h),t(Pe),t(X),t(Ae),t(qe),t(z),t(Ke),t(Oe),t(S),t(el),t(ll),t(J),t(tl),t(F),t(sl),t(Y),t(il),t(nl),t(w),t(al),t(E),t(pl),t(T),t(rl),t(P),t(ml),t(cl),t(q),t(ul),t(fl),t(O),t(Ml),t(ol),t(U),t(dl),t(le),t(yl),t(bl),t(se),t(hl),t(ie),t(Jl),t(wl),t(ae),t(Tl),t(Ul),t(re),t(Zl),t(gl),t(ce),t(jl),t(Gl),t(Z),t($l),t(fe),t(vl),t(Wl),t(oe),t(_l),t(Vl),t(ye),t(Cl),t(be),t(Hl),t(kl),t(Je),t(Il),t(Bl),t(g),t(xl),t(Rl),t(Ue),t(Xl),t(Ze),t(Ll),t(ge),t(zl),t(Nl),t(Ge),t(Sl),t(Ql),t(j),t(Fl),t(ve),t(Yl),t(Dl),t(G),t(El),t(Pl),t(Ve),t(Al),t(Ce),t(ql),t(Kl),t(Ie)),t(b),o(v,e),o(W,e),o(_,e),o(I,e),o(x,e),o(R,e),o(L,e),o(N,e),o(Q,e),o(D,e),o(A,e),o(K,e),o(ee,e),o(te,e),o(ne,e),o(pe,e),o(me,e),o(ue,e),o(Me,e),o(de,e),o(he,e),o(we,e),o(Te,e),o(je,e),o($e,e),o(We,e),o(_e,e),o(He,e)}}}const es='{"title":"効果的で効率的な拡散モデル","local":"効果的で効率的な拡散モデル","sections":[{"title":"Speed","local":"speed","sections":[],"depth":2},{"title":"メモリー","local":"メモリー","sections":[],"depth":2},{"title":"品質","local":"品質","sections":[{"title":"より良いチェックポイント","local":"より良いチェックポイント","sections":[],"depth":3},{"title":"より良いパイプラインコンポーネント","local":"より良いパイプラインコンポーネント","sections":[],"depth":3},{"title":"より良いプロンプト・エンジニアリング","local":"より良いプロンプトエンジニアリング","sections":[],"depth":3}],"depth":2},{"title":"次のステップ","local":"次のステップ","sections":[],"depth":2}],"depth":1}';function ls(et){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ps extends Yt{constructor(b){super(),Dt(this,b,ls,Ot,St,{})}}export{ps as component};
