import{s as ol,n as pl,o as cl}from"../chunks/scheduler.53228c21.js";import{S as dl,i as ml,e as n,s,c as p,h as fl,a as r,d as l,b as i,f as rl,g as c,j as o,k as Zt,l as ul,m as a,n as d,t as m,o as f,p as u}from"../chunks/index.100fac89.js";import{C as Ml}from"../chunks/CopyLLMTxtMenu.0ee1b69b.js";import{C as M}from"../chunks/CodeBlock.d30a6509.js";import{H as be,E as hl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.136ef3fd.js";function yl(It){let h,ge,Te,Ue,b,_e,T,je,J,$t='<a href="https://hf.co/papers/2310.04378" rel="nofollow">Latent Consistency Models (LCMs)</a> are able to generate high-quality images in just a few steps, representing a big leap forward because many pipelines require at least 25+ steps. LCMs are produced by applying the latent consistency distillation method to any Stable Diffusion model. This method works by applying <em>one-stage guided distillation</em> to the latent space, and incorporating a <em>skipping-step</em> method to consistently skip timesteps to accelerate the distillation process (refer to section 4.1, 4.2, and 4.3 of the paper for more details).',Ce,g,xt='If you’re training on a GPU with limited vRAM, try enabling <code>gradient_checkpointing</code>, <code>gradient_accumulation_steps</code>, and <code>mixed_precision</code> to reduce memory-usage and speedup training. You can reduce your memory-usage even more by enabling memory-efficient attention with <a href="../optimization/xformers">xFormers</a> and <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes’</a> 8-bit optimizer.',Ze,U,Wt='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">train_lcm_distill_sd_wds.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',Ie,_,Rt="Before running the script, make sure you install the library from source:",$e,j,xe,C,Xt="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",We,Z,Re,y,vt='<p>🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.</p>',Xe,I,Gt="Initialize an 🤗 Accelerate environment (try enabling <code>torch.compile</code> to significantly speedup training):",ve,$,Ge,x,Nt="To setup a default 🤗 Accelerate environment without choosing any configurations:",Ne,W,Le,R,Lt="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",ke,X,Ve,v,kt='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Be,G,He,w,Vt='<p>The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.</p>',Qe,N,Bt='The training script provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L419" rel="nofollow"><code>parse_args()</code></a> function. This function provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',Fe,L,Ht="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",Ye,k,Se,V,Qt='Most of the parameters are identical to the parameters in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so you’ll focus on the parameters that are relevant to latent consistency distillation in this guide.',Ee,B,Ft='<li><code>--pretrained_teacher_model</code>: the path to a pretrained latent diffusion model to use as the teacher model</li> <li><code>--pretrained_vae_model_name_or_path</code>: path to a pretrained VAE; the SDXL VAE is known to suffer from numerical instability, so this parameter allows you to specify an alternative VAE (like this <a href="(https://huggingface.co/madebyollin/sdxl-vae-fp16-fix)">VAE</a> by madebyollin which works in fp16)</li> <li><code>--w_min</code> and <code>--w_max</code>: the minimum and maximum guidance scale values for guidance scale sampling</li> <li><code>--num_ddim_timesteps</code>: the number of timesteps for DDIM sampling</li> <li><code>--loss_type</code>: the type of loss (L2 or Huber) to calculate for latent consistency distillation; Huber loss is generally preferred because it’s more robust to outliers</li> <li><code>--huber_c</code>: the Huber loss parameter</li>',ze,H,Ae,Q,Yt='The training script starts by creating a dataset class - <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L141" rel="nofollow"><code>Text2ImageDataset</code></a> - for preprocessing the images and creating a training dataset.',De,F,qe,Y,St='For improved performance on reading and writing large datasets stored in the cloud, this script uses the <a href="https://github.com/webdataset/webdataset" rel="nofollow">WebDataset</a> format to create a preprocessing pipeline to apply transforms and create a dataset and dataloader for training. Images are processed and fed to the training loop without having to download the full dataset first.',Pe,S,Ke,E,Et='In the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L768" rel="nofollow"><code>main()</code></a> function, all the necessary components like the noise scheduler, tokenizers, text encoders, and VAE are loaded. The teacher UNet is also loaded here and then you can create a student UNet from the teacher UNet. The student UNet is updated by the optimizer during training.',Oe,z,et,A,zt='Now you can create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L979" rel="nofollow">optimizer</a> to update the UNet parameters:',tt,D,lt,q,At='Create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L994" rel="nofollow">dataset</a>:',at,P,st,K,Dt='Next, you’re ready to setup the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1049" rel="nofollow">training loop</a> and implement the latent consistency distillation method (see Algorithm 1 in the paper for more details). This section of the script takes care of adding noise to the latents, sampling and creating a guidance scale embedding, and predicting the original image from the noise.',it,O,nt,ee,qt='It gets the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1172" rel="nofollow">teacher model predictions</a> and the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1209" rel="nofollow">LCM predictions</a> next, calculates the loss, and then backpropagates it to the LCM.',rt,te,ot,le,Pt='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers tutorial</a> which breaks down the basic pattern of the denoising process.',pt,ae,ct,se,Kt="Now you’re ready to launch the training script and start distilling!",dt,ie,Ot='For this guide, you’ll use the <code>--train_shards_path_or_url</code> to specify the path to the <a href="https://github.com/google-research-datasets/conceptual-12m" rel="nofollow">Conceptual Captions 12M</a> dataset stored on the Hub <a href="https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset" rel="nofollow">here</a>. Set the <code>MODEL_DIR</code> environment variable to the name of the teacher model and <code>OUTPUT_DIR</code> to where you want to save the model.',mt,ne,ft,re,el="Once training is complete, you can use your new LCM for inference.",ut,oe,Mt,pe,ht,ce,tl='LoRA is a training technique for significantly reducing the number of trainable parameters. As a result, training is faster and it is easier to store the resulting weights because they are a lot smaller (~100MBs). Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sd_wds.py" rel="nofollow">train_lcm_distill_lora_sd_wds.py</a> or <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sdxl_wds.py" rel="nofollow">train_lcm_distill_lora_sdxl.wds.py</a> script to train with LoRA.',yt,de,ll='The LoRA training script is discussed in more detail in the <a href="lora">LoRA training</a> guide.',wt,me,bt,fe,al='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sdxl_wds.py" rel="nofollow">train_lcm_distill_sdxl_wds.py</a> script to train a SDXL model with LoRA.',Tt,ue,sl='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',Jt,Me,gt,he,il="Congratulations on distilling a LCM model! To learn more about LCM, the following may be helpful:",Ut,ye,nl='<li>Learn how to use <a href="../using-diffusers/lcm">LCMs for inference</a> for text-to-image, image-to-image, and with LoRA checkpoints.</li> <li>Read the <a href="https://huggingface.co/blog/lcm_lora" rel="nofollow">SDXL in 4 steps with Latent Consistency LoRAs</a> blog post to learn more about SDXL LCM-LoRA’s for super fast inference, quality comparisons, benchmarks, and more.</li>',_t,we,jt,Je,Ct;return b=new Ml({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new be({props:{title:"Latent Consistency Distillation",local:"latent-consistency-distillation",headingTag:"h1"}}),j=new M({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),Z=new M({props:{code:"Y2QlMjBleGFtcGxlcyUyRmNvbnNpc3RlbmN5X2Rpc3RpbGxhdGlvbiUwQXBpcCUyMGluc3RhbGwlMjAtciUyMHJlcXVpcmVtZW50cy50eHQ=",highlighted:`<span class="hljs-built_in">cd</span> examples/consistency_distillation
pip install -r requirements.txt`,wrap:!1}}),$=new M({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),W=new M({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),X=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),G=new be({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),k=new M({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2xjbV9kaXN0aWxsX3NkX3dkcy5weSUyMCU1QyUwQSUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMg==",highlighted:`accelerate launch train_lcm_distill_sd_wds.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`,wrap:!1}}),H=new be({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),F=new M({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnJlc2l6ZShpbWFnZSUyQyUyMHJlc29sdXRpb24lMkMlMjBpbnRlcnBvbGF0aW9uJTNEdHJhbnNmb3Jtcy5JbnRlcnBvbGF0aW9uTW9kZS5CSUxJTkVBUiklMEElMEElMjAlMjAlMjAlMjBjX3RvcCUyQyUyMGNfbGVmdCUyQyUyMF8lMkMlMjBfJTIwJTNEJTIwdHJhbnNmb3Jtcy5SYW5kb21Dcm9wLmdldF9wYXJhbXMoaW1hZ2UlMkMlMjBvdXRwdXRfc2l6ZSUzRChyZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbikpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBURi5jcm9wKGltYWdlJTJDJTIwY190b3AlMkMlMjBjX2xlZnQlMkMlMjByZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbiklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnRvX3RlbnNvcihpbWFnZSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLm5vcm1hbGl6ZShpbWFnZSUyQyUyMCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMjAlM0QlMjBpbWFnZSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">example</span>):
    image = example[<span class="hljs-string">&quot;image&quot;</span>]
    image = TF.resize(image, resolution, interpolation=transforms.InterpolationMode.BILINEAR)

    c_top, c_left, _, _ = transforms.RandomCrop.get_params(image, output_size=(resolution, resolution))
    image = TF.crop(image, c_top, c_left, resolution, resolution)
    image = TF.to_tensor(image)
    image = TF.normalize(image, [<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>])

    example[<span class="hljs-string">&quot;image&quot;</span>] = image
    <span class="hljs-keyword">return</span> example`,wrap:!1}}),S=new M({props:{code:"cHJvY2Vzc2luZ19waXBlbGluZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMHdkcy5kZWNvZGUoJTIycGlsJTIyJTJDJTIwaGFuZGxlciUzRHdkcy5pZ25vcmVfYW5kX2NvbnRpbnVlKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5yZW5hbWUoaW1hZ2UlM0QlMjJqcGclM0JwbmclM0JqcGVnJTNCd2VicCUyMiUyQyUyMHRleHQlM0QlMjJ0ZXh0JTNCdHh0JTNCY2FwdGlvbiUyMiUyQyUyMGhhbmRsZXIlM0R3ZHMud2Fybl9hbmRfY29udGludWUpJTJDJTBBJTIwJTIwJTIwJTIwd2RzLm1hcChmaWx0ZXJfa2V5cyglN0IlMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIlN0QpKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5tYXAodHJhbnNmb3JtKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy50b190dXBsZSglMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIpJTJDJTBBJTVE",highlighted:`processing_pipeline = [
    wds.decode(<span class="hljs-string">&quot;pil&quot;</span>, handler=wds.ignore_and_continue),
    wds.rename(image=<span class="hljs-string">&quot;jpg;png;jpeg;webp&quot;</span>, text=<span class="hljs-string">&quot;text;txt;caption&quot;</span>, handler=wds.warn_and_continue),
    wds.<span class="hljs-built_in">map</span>(filter_keys({<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>})),
    wds.<span class="hljs-built_in">map</span>(transform),
    wds.to_tuple(<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>),
]`,wrap:!1}}),z=new M({props:{code:"dGVhY2hlcl91bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF90ZWFjaGVyX21vZGVsJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHJldmlzaW9uJTNEYXJncy50ZWFjaGVyX3JldmlzaW9uJTBBKSUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCgqKnRlYWNoZXJfdW5ldC5jb25maWcpJTBBdW5ldC5sb2FkX3N0YXRlX2RpY3QodGVhY2hlcl91bmV0LnN0YXRlX2RpY3QoKSUyQyUyMHN0cmljdCUzREZhbHNlKSUwQXVuZXQudHJhaW4oKQ==",highlighted:`teacher_unet = UNet2DConditionModel.from_pretrained(
    args.pretrained_teacher_model, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, revision=args.teacher_revision
)

unet = UNet2DConditionModel(**teacher_unet.config)
unet.load_state_dict(teacher_unet.state_dict(), strict=<span class="hljs-literal">False</span>)
unet.train()`,wrap:!1}}),D=new M({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NsYXNzKCUwQSUyMCUyMCUyMCUyMHVuZXQucGFyYW1ldGVycygpJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0RhcmdzLmxlYXJuaW5nX3JhdGUlMkMlMEElMjAlMjAlMjAlMjBiZXRhcyUzRChhcmdzLmFkYW1fYmV0YTElMkMlMjBhcmdzLmFkYW1fYmV0YTIpJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEYXJncy5hZGFtX3dlaWdodF9kZWNheSUyQyUwQSUyMCUyMCUyMCUyMGVwcyUzRGFyZ3MuYWRhbV9lcHNpbG9uJTJDJTBBKQ==",highlighted:`optimizer = optimizer_class(
    unet.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),P=new M({props:{code:"ZGF0YXNldCUyMCUzRCUyMFRleHQySW1hZ2VEYXRhc2V0KCUwQSUyMCUyMCUyMCUyMHRyYWluX3NoYXJkc19wYXRoX29yX3VybCUzRGFyZ3MudHJhaW5fc2hhcmRzX3BhdGhfb3JfdXJsJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2V4YW1wbGVzJTNEYXJncy5tYXhfdHJhaW5fc2FtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHBlcl9ncHVfYmF0Y2hfc2l6ZSUzRGFyZ3MudHJhaW5fYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdsb2JhbF9iYXRjaF9zaXplJTNEYXJncy50cmFpbl9iYXRjaF9zaXplJTIwKiUyMGFjY2VsZXJhdG9yLm51bV9wcm9jZXNzZXMlMkMlMEElMjAlMjAlMjAlMjBudW1fd29ya2VycyUzRGFyZ3MuZGF0YWxvYWRlcl9udW1fd29ya2VycyUyQyUwQSUyMCUyMCUyMCUyMHJlc29sdXRpb24lM0RhcmdzLnJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlX2J1ZmZlcl9zaXplJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMHBpbl9tZW1vcnklM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVyc2lzdGVudF93b3JrZXJzJTNEVHJ1ZSUyQyUwQSklMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwZGF0YXNldC50cmFpbl9kYXRhbG9hZGVy",highlighted:`dataset = Text2ImageDataset(
    train_shards_path_or_url=args.train_shards_path_or_url,
    num_train_examples=args.max_train_samples,
    per_gpu_batch_size=args.train_batch_size,
    global_batch_size=args.train_batch_size * accelerator.num_processes,
    num_workers=args.dataloader_num_workers,
    resolution=args.resolution,
    shuffle_buffer_size=<span class="hljs-number">1000</span>,
    pin_memory=<span class="hljs-literal">True</span>,
    persistent_workers=<span class="hljs-literal">True</span>,
)
train_dataloader = dataset.train_dataloader`,wrap:!1}}),O=new M({props:{code:"cHJlZF94XzAlMjAlM0QlMjBwcmVkaWN0ZWRfb3JpZ2luKCUwQSUyMCUyMCUyMCUyMG5vaXNlX3ByZWQlMkMlMEElMjAlMjAlMjAlMjBzdGFydF90aW1lc3RlcHMlMkMlMEElMjAlMjAlMjAlMjBub2lzeV9tb2RlbF9pbnB1dCUyQyUwQSUyMCUyMCUyMCUyMG5vaXNlX3NjaGVkdWxlci5jb25maWcucHJlZGljdGlvbl90eXBlJTJDJTBBJTIwJTIwJTIwJTIwYWxwaGFfc2NoZWR1bGUlMkMlMEElMjAlMjAlMjAlMjBzaWdtYV9zY2hlZHVsZSUyQyUwQSklMEElMEFtb2RlbF9wcmVkJTIwJTNEJTIwY19za2lwX3N0YXJ0JTIwKiUyMG5vaXN5X21vZGVsX2lucHV0JTIwJTJCJTIwY19vdXRfc3RhcnQlMjAqJTIwcHJlZF94XzA=",highlighted:`pred_x_0 = predicted_origin(
    noise_pred,
    start_timesteps,
    noisy_model_input,
    noise_scheduler.config.prediction_type,
    alpha_schedule,
    sigma_schedule,
)

model_pred = c_skip_start * noisy_model_input + c_out_start * pred_x_0`,wrap:!1}}),te=new M({props:{code:"aWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmwyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMEYubXNlX2xvc3MobW9kZWxfcHJlZC5mbG9hdCgpJTJDJTIwdGFyZ2V0LmZsb2F0KCklMkMlMjByZWR1Y3Rpb24lM0QlMjJtZWFuJTIyKSUwQWVsaWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmh1YmVyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMHRvcmNoLm1lYW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guc3FydCgobW9kZWxfcHJlZC5mbG9hdCgpJTIwLSUyMHRhcmdldC5mbG9hdCgpKSUyMCoqJTIwMiUyMCUyQiUyMGFyZ3MuaHViZXJfYyoqMiklMjAtJTIwYXJncy5odWJlcl9jJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">if</span> args.loss_type == <span class="hljs-string">&quot;l2&quot;</span>:
    loss = F.mse_loss(model_pred.<span class="hljs-built_in">float</span>(), target.<span class="hljs-built_in">float</span>(), reduction=<span class="hljs-string">&quot;mean&quot;</span>)
<span class="hljs-keyword">elif</span> args.loss_type == <span class="hljs-string">&quot;huber&quot;</span>:
    loss = torch.mean(
        torch.sqrt((model_pred.<span class="hljs-built_in">float</span>() - target.<span class="hljs-built_in">float</span>()) ** <span class="hljs-number">2</span> + args.huber_c**<span class="hljs-number">2</span>) - args.huber_c
    )`,wrap:!1}}),ae=new be({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),ne=new M({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZXhwb3J0JTIwT1VUUFVUX0RJUiUzRCUyMnBhdGglMkZ0byUyRnNhdmVkJTJGbW9kZWwlMjIlMEElMEFhY2NlbGVyYXRlJTIwbGF1bmNoJTIwdHJhaW5fbGNtX2Rpc3RpbGxfc2Rfd2RzLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wcmV0cmFpbmVkX3RlYWNoZXJfbW9kZWwlM0QlMjRNT0RFTF9ESVIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlM0QlMjRPVVRQVVRfRElSJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1taXhlZF9wcmVjaXNpb24lM0RmcDE2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXNvbHV0aW9uJTNENTEyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtNiUyMC0tbG9zc190eXBlJTNEJTIyaHViZXIlMjIlMjAtLWVtYV9kZWNheSUzRDAuOTUlMjAtLWFkYW1fd2VpZ2h0X2RlY2F5JTNEMC4wJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXhfdHJhaW5fc3RlcHMlM0QxMDAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXhfdHJhaW5fc2FtcGxlcyUzRDQwMDAwMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFsb2FkZXJfbnVtX3dvcmtlcnMlM0Q4JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10cmFpbl9zaGFyZHNfcGF0aF9vcl91cmwlM0QlMjJwaXBlJTNBY3VybCUyMC1MJTIwLXMlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZsYWlvbiUyRmNvbmNlcHR1YWwtY2FwdGlvbnMtMTJtLXdlYmRhdGFzZXQlMkZyZXNvbHZlJTJGbWFpbiUyRmRhdGElMkYlN0IwMDAwMC4uMDEwOTklN0QudGFyJTNGZG93bmxvYWQlM0R0cnVlJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS12YWxpZGF0aW9uX3N0ZXBzJTNEMjAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50aW5nX3N0ZXBzJTNEMjAwJTIwLS1jaGVja3BvaW50c190b3RhbF9saW1pdCUzRDEwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10cmFpbl9iYXRjaF9zaXplJTNEMTIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAtLWVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdXNlXzhiaXRfYWRhbSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVzdW1lX2Zyb21fY2hlY2twb2ludCUzRGxhdGVzdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVwb3J0X3RvJTNEd2FuZGIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNlZWQlM0Q0NTM2NDU2MzQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path/to/saved/model&quot;</span>

accelerate launch train_lcm_distill_sd_wds.py \\
    --pretrained_teacher_model=<span class="hljs-variable">$MODEL_DIR</span> \\
    --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
    --mixed_precision=fp16 \\
    --resolution=512 \\
    --learning_rate=1e-6 --loss_type=<span class="hljs-string">&quot;huber&quot;</span> --ema_decay=0.95 --adam_weight_decay=0.0 \\
    --max_train_steps=1000 \\
    --max_train_samples=4000000 \\
    --dataloader_num_workers=8 \\
    --train_shards_path_or_url=<span class="hljs-string">&quot;pipe:curl -L -s https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset/resolve/main/data/{00000..01099}.tar?download=true&quot;</span> \\
    --validation_steps=200 \\
    --checkpointing_steps=200 --checkpoints_total_limit=10 \\
    --train_batch_size=12 \\
    --gradient_checkpointing --enable_xformers_memory_efficient_attention \\
    --gradient_accumulation_steps=1 \\
    --use_8bit_adam \\
    --resume_from_checkpoint=latest \\
    --report_to=wandb \\
    --seed=453645634 \\
    --push_to_hub`,wrap:!1}}),oe=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci11c2VybmFtZSUyRnlvdXItbW9kZWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1bmV0JTNEdW5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJzdXNoaSUyMHJvbGxzJTIwaW4lMjB0aGUlMjBmb3JtJTIwb2YlMjBwYW5kYSUyMGhlYWRzJTJDJTIwc3VzaGklMjBwbGF0dGVyJTIyJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMS4wKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel, DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;your-username/your-model&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, unet=unet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

pipeline.scheduler = LCMScheduler.from_config(pipe.scheduler.config)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;sushi rolls in the form of panda heads, sushi platter&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">1.0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),pe=new be({props:{title:"LoRA",local:"lora",headingTag:"h2"}}),me=new be({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),Me=new be({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),we=new hl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/lcm_distill.md"}}),{c(){h=n("meta"),ge=s(),Te=n("p"),Ue=s(),p(b.$$.fragment),_e=s(),p(T.$$.fragment),je=s(),J=n("p"),J.innerHTML=$t,Ce=s(),g=n("p"),g.innerHTML=xt,Ze=s(),U=n("p"),U.innerHTML=Wt,Ie=s(),_=n("p"),_.textContent=Rt,$e=s(),p(j.$$.fragment),xe=s(),C=n("p"),C.textContent=Xt,We=s(),p(Z.$$.fragment),Re=s(),y=n("blockquote"),y.innerHTML=vt,Xe=s(),I=n("p"),I.innerHTML=Gt,ve=s(),p($.$$.fragment),Ge=s(),x=n("p"),x.textContent=Nt,Ne=s(),p(W.$$.fragment),Le=s(),R=n("p"),R.textContent=Lt,ke=s(),p(X.$$.fragment),Ve=s(),v=n("p"),v.innerHTML=kt,Be=s(),p(G.$$.fragment),He=s(),w=n("blockquote"),w.innerHTML=Vt,Qe=s(),N=n("p"),N.innerHTML=Bt,Fe=s(),L=n("p"),L.innerHTML=Ht,Ye=s(),p(k.$$.fragment),Se=s(),V=n("p"),V.innerHTML=Qt,Ee=s(),B=n("ul"),B.innerHTML=Ft,ze=s(),p(H.$$.fragment),Ae=s(),Q=n("p"),Q.innerHTML=Yt,De=s(),p(F.$$.fragment),qe=s(),Y=n("p"),Y.innerHTML=St,Pe=s(),p(S.$$.fragment),Ke=s(),E=n("p"),E.innerHTML=Et,Oe=s(),p(z.$$.fragment),et=s(),A=n("p"),A.innerHTML=zt,tt=s(),p(D.$$.fragment),lt=s(),q=n("p"),q.innerHTML=At,at=s(),p(P.$$.fragment),st=s(),K=n("p"),K.innerHTML=Dt,it=s(),p(O.$$.fragment),nt=s(),ee=n("p"),ee.innerHTML=qt,rt=s(),p(te.$$.fragment),ot=s(),le=n("p"),le.innerHTML=Pt,pt=s(),p(ae.$$.fragment),ct=s(),se=n("p"),se.textContent=Kt,dt=s(),ie=n("p"),ie.innerHTML=Ot,mt=s(),p(ne.$$.fragment),ft=s(),re=n("p"),re.textContent=el,ut=s(),p(oe.$$.fragment),Mt=s(),p(pe.$$.fragment),ht=s(),ce=n("p"),ce.innerHTML=tl,yt=s(),de=n("p"),de.innerHTML=ll,wt=s(),p(me.$$.fragment),bt=s(),fe=n("p"),fe.innerHTML=al,Tt=s(),ue=n("p"),ue.innerHTML=sl,Jt=s(),p(Me.$$.fragment),gt=s(),he=n("p"),he.textContent=il,Ut=s(),ye=n("ul"),ye.innerHTML=nl,_t=s(),p(we.$$.fragment),jt=s(),Je=n("p"),this.h()},l(e){const t=fl("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(l),ge=i(e),Te=r(e,"P",{}),rl(Te).forEach(l),Ue=i(e),c(b.$$.fragment,e),_e=i(e),c(T.$$.fragment,e),je=i(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1oefohu"&&(J.innerHTML=$t),Ce=i(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-w1dbtu"&&(g.innerHTML=xt),Ze=i(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1izwzxl"&&(U.innerHTML=Wt),Ie=i(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-l7dm2q"&&(_.textContent=Rt),$e=i(e),c(j.$$.fragment,e),xe=i(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-z4z0b9"&&(C.textContent=Xt),We=i(e),c(Z.$$.fragment,e),Re=i(e),y=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-1in84qc"&&(y.innerHTML=vt),Xe=i(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-h7f7kz"&&(I.innerHTML=Gt),ve=i(e),c($.$$.fragment,e),Ge=i(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-di6juu"&&(x.textContent=Nt),Ne=i(e),c(W.$$.fragment,e),Le=i(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-tsz4qp"&&(R.textContent=Lt),ke=i(e),c(X.$$.fragment,e),Ve=i(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1fkfdql"&&(v.innerHTML=kt),Be=i(e),c(G.$$.fragment,e),He=i(e),w=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-sd7gud"&&(w.innerHTML=Vt),Qe=i(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-z8r4ny"&&(N.innerHTML=Bt),Fe=i(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1r0bv1x"&&(L.innerHTML=Ht),Ye=i(e),c(k.$$.fragment,e),Se=i(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-opb00x"&&(V.innerHTML=Qt),Ee=i(e),B=r(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-q5d022"&&(B.innerHTML=Ft),ze=i(e),c(H.$$.fragment,e),Ae=i(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-xygc62"&&(Q.innerHTML=Yt),De=i(e),c(F.$$.fragment,e),qe=i(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1fe8qlp"&&(Y.innerHTML=St),Pe=i(e),c(S.$$.fragment,e),Ke=i(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-184frii"&&(E.innerHTML=Et),Oe=i(e),c(z.$$.fragment,e),et=i(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-he12t1"&&(A.innerHTML=zt),tt=i(e),c(D.$$.fragment,e),lt=i(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1c3frfx"&&(q.innerHTML=At),at=i(e),c(P.$$.fragment,e),st=i(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-4kbgth"&&(K.innerHTML=Dt),it=i(e),c(O.$$.fragment,e),nt=i(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1g18b9r"&&(ee.innerHTML=qt),rt=i(e),c(te.$$.fragment,e),ot=i(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1pefyrm"&&(le.innerHTML=Pt),pt=i(e),c(ae.$$.fragment,e),ct=i(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-5c8ldp"&&(se.textContent=Kt),dt=i(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-14rdptq"&&(ie.innerHTML=Ot),mt=i(e),c(ne.$$.fragment,e),ft=i(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-2n690z"&&(re.textContent=el),ut=i(e),c(oe.$$.fragment,e),Mt=i(e),c(pe.$$.fragment,e),ht=i(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-21u499"&&(ce.innerHTML=tl),yt=i(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1sxi0tl"&&(de.innerHTML=ll),wt=i(e),c(me.$$.fragment,e),bt=i(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-swritx"&&(fe.innerHTML=al),Tt=i(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-6dxtva"&&(ue.innerHTML=sl),Jt=i(e),c(Me.$$.fragment,e),gt=i(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1bflftn"&&(he.textContent=il),Ut=i(e),ye=r(e,"UL",{"data-svelte-h":!0}),o(ye)!=="svelte-e624yw"&&(ye.innerHTML=nl),_t=i(e),c(we.$$.fragment,e),jt=i(e),Je=r(e,"P",{}),rl(Je).forEach(l),this.h()},h(){Zt(h,"name","hf:doc:metadata"),Zt(h,"content",wl),Zt(y,"class","tip"),Zt(w,"class","tip")},m(e,t){ul(document.head,h),a(e,ge,t),a(e,Te,t),a(e,Ue,t),d(b,e,t),a(e,_e,t),d(T,e,t),a(e,je,t),a(e,J,t),a(e,Ce,t),a(e,g,t),a(e,Ze,t),a(e,U,t),a(e,Ie,t),a(e,_,t),a(e,$e,t),d(j,e,t),a(e,xe,t),a(e,C,t),a(e,We,t),d(Z,e,t),a(e,Re,t),a(e,y,t),a(e,Xe,t),a(e,I,t),a(e,ve,t),d($,e,t),a(e,Ge,t),a(e,x,t),a(e,Ne,t),d(W,e,t),a(e,Le,t),a(e,R,t),a(e,ke,t),d(X,e,t),a(e,Ve,t),a(e,v,t),a(e,Be,t),d(G,e,t),a(e,He,t),a(e,w,t),a(e,Qe,t),a(e,N,t),a(e,Fe,t),a(e,L,t),a(e,Ye,t),d(k,e,t),a(e,Se,t),a(e,V,t),a(e,Ee,t),a(e,B,t),a(e,ze,t),d(H,e,t),a(e,Ae,t),a(e,Q,t),a(e,De,t),d(F,e,t),a(e,qe,t),a(e,Y,t),a(e,Pe,t),d(S,e,t),a(e,Ke,t),a(e,E,t),a(e,Oe,t),d(z,e,t),a(e,et,t),a(e,A,t),a(e,tt,t),d(D,e,t),a(e,lt,t),a(e,q,t),a(e,at,t),d(P,e,t),a(e,st,t),a(e,K,t),a(e,it,t),d(O,e,t),a(e,nt,t),a(e,ee,t),a(e,rt,t),d(te,e,t),a(e,ot,t),a(e,le,t),a(e,pt,t),d(ae,e,t),a(e,ct,t),a(e,se,t),a(e,dt,t),a(e,ie,t),a(e,mt,t),d(ne,e,t),a(e,ft,t),a(e,re,t),a(e,ut,t),d(oe,e,t),a(e,Mt,t),d(pe,e,t),a(e,ht,t),a(e,ce,t),a(e,yt,t),a(e,de,t),a(e,wt,t),d(me,e,t),a(e,bt,t),a(e,fe,t),a(e,Tt,t),a(e,ue,t),a(e,Jt,t),d(Me,e,t),a(e,gt,t),a(e,he,t),a(e,Ut,t),a(e,ye,t),a(e,_t,t),d(we,e,t),a(e,jt,t),a(e,Je,t),Ct=!0},p:pl,i(e){Ct||(m(b.$$.fragment,e),m(T.$$.fragment,e),m(j.$$.fragment,e),m(Z.$$.fragment,e),m($.$$.fragment,e),m(W.$$.fragment,e),m(X.$$.fragment,e),m(G.$$.fragment,e),m(k.$$.fragment,e),m(H.$$.fragment,e),m(F.$$.fragment,e),m(S.$$.fragment,e),m(z.$$.fragment,e),m(D.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(Me.$$.fragment,e),m(we.$$.fragment,e),Ct=!0)},o(e){f(b.$$.fragment,e),f(T.$$.fragment,e),f(j.$$.fragment,e),f(Z.$$.fragment,e),f($.$$.fragment,e),f(W.$$.fragment,e),f(X.$$.fragment,e),f(G.$$.fragment,e),f(k.$$.fragment,e),f(H.$$.fragment,e),f(F.$$.fragment,e),f(S.$$.fragment,e),f(z.$$.fragment,e),f(D.$$.fragment,e),f(P.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(Me.$$.fragment,e),f(we.$$.fragment,e),Ct=!1},d(e){e&&(l(ge),l(Te),l(Ue),l(_e),l(je),l(J),l(Ce),l(g),l(Ze),l(U),l(Ie),l(_),l($e),l(xe),l(C),l(We),l(Re),l(y),l(Xe),l(I),l(ve),l(Ge),l(x),l(Ne),l(Le),l(R),l(ke),l(Ve),l(v),l(Be),l(He),l(w),l(Qe),l(N),l(Fe),l(L),l(Ye),l(Se),l(V),l(Ee),l(B),l(ze),l(Ae),l(Q),l(De),l(qe),l(Y),l(Pe),l(Ke),l(E),l(Oe),l(et),l(A),l(tt),l(lt),l(q),l(at),l(st),l(K),l(it),l(nt),l(ee),l(rt),l(ot),l(le),l(pt),l(ct),l(se),l(dt),l(ie),l(mt),l(ft),l(re),l(ut),l(Mt),l(ht),l(ce),l(yt),l(de),l(wt),l(bt),l(fe),l(Tt),l(ue),l(Jt),l(gt),l(he),l(Ut),l(ye),l(_t),l(jt),l(Je)),l(h),u(b,e),u(T,e),u(j,e),u(Z,e),u($,e),u(W,e),u(X,e),u(G,e),u(k,e),u(H,e),u(F,e),u(S,e),u(z,e),u(D,e),u(P,e),u(O,e),u(te,e),u(ae,e),u(ne,e),u(oe,e),u(pe,e),u(me,e),u(Me,e),u(we,e)}}}const wl='{"title":"Latent Consistency Distillation","local":"latent-consistency-distillation","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"LoRA","local":"lora","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function bl(It){return cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends dl{constructor(h){super(),ml(this,h,bl,yl,ol,{})}}export{jl as component};
