import{s as rl,a as ol,n as ml,o as yl}from"../chunks/scheduler.53228c21.js";import{S as ul,i as cl,e as i,s,c as r,h as dl,a as p,d as t,b as n,f as Ee,g as o,j as M,k as d,l as Se,m as a,n as m,t as y,o as u,p as c}from"../chunks/index.100fac89.js";import{C as wl}from"../chunks/CopyLLMTxtMenu.0ee1b69b.js";import{C as J}from"../chunks/CodeBlock.d30a6509.js";import{H as xe,E as hl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.136ef3fd.js";function Ul(Fe){let h,le,O,te,C,ae,Z,se,I,Ne='Outpainting extends an image beyond its original boundaries, allowing you to add, replace, or modify visual elements in an image while preserving the original image. Like <a href="../using-diffusers/inpaint">inpainting</a>, you want to fill the white area (in this case, the area outside of the original image) with new visual elements while keeping the original image (represented by a mask of black pixels). There are a couple of ways to outpaint, such as with a <a href="https://hf.co/blog/OzzyGT/outpainting-controlnet" rel="nofollow">ControlNet</a> or with <a href="https://hf.co/blog/OzzyGT/outpainting-differential-diffusion" rel="nofollow">Differential Diffusion</a>.',ne,W,$e="This guide will show you how to outpaint with an inpainting model, ControlNet, and a ZoeDepth estimator.",ie,k,ze='Before you begin, make sure you have the <a href="https://github.com/huggingface/controlnet_aux" rel="nofollow">controlnet_aux</a> library installed so you can use the ZoeDepth estimator.',pe,B,Me,v,re,_,He='Start by picking an image to outpaint with and remove the background with a Space like <a href="https://hf.co/spaces/briaai/BRIA-RMBG-1.4" rel="nofollow">BRIA-RMBG-1.4</a>.',oe,w,Ye,me,X,De="For example, remove the background from this image of a pair of shoes.",ye,j,Le='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/original-jordan.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/no-background-jordan.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">background removed</figcaption></div>',ue,A,qe='<a href="../using-diffusers/sdxl">Stable Diffusion XL (SDXL)</a> models work best with 1024x1024 images, but you can resize the image to any size as long as your hardware has enough memory to support it. The transparent background in the image should also be replaced with a white background. Create a function (like the one below) that scales and pastes the image onto a white background.',ce,G,de,R,Ke="To avoid adding unwanted extra details, use the ZoeDepth estimator to provide additional guidance during generation and to ensure the shoes remain consistent with the original image.",we,V,he,T,Pe='<img src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/zoedepth-jordan.png"/>',Ue,E,Je,Q,Oe='Once your image is ready, you can generate content in the white area around the shoes with <a href="https://hf.co/destitech/controlnet-inpaint-dreamer-sdxl" rel="nofollow">controlnet-inpaint-dreamer-sdxl</a>, a SDXL ControlNet trained for inpainting.',je,S,el='Load the inpainting ControlNet, ZoeDepth model, VAE and pass them to the <a href="/docs/diffusers/main/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a>. Then you can create an optional <code>generate_image</code> function (for convenience) to outpaint an initial image.',Te,x,be,F,ll="Paste the original image over the initial outpainted image. You’ll improve the outpainted background in a later step.",ge,N,fe,b,tl='<img src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/initial-outpaint.png"/>',Ce,U,P,al="Now is a good time to free up some memory if you’re running low!",Qe,$,Ze,z,sl='Now that you have an initial outpainted image, load the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline">StableDiffusionXLInpaintPipeline</a> with the <a href="https://hf.co/SG161222/RealVisXL_V4.0" rel="nofollow">RealVisXL</a> model to generate the final outpainted image with better quality.',Ie,H,We,Y,nl="Prepare a mask for the final outpainted image. To create a more natural transition between the original image and the outpainted background, blur the mask to help it blend better.",ke,D,Be,g,il='<img src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/blurred-mask.png"/>',ve,L,pl="Create a better prompt and pass it to the <code>generate_outpaint</code> function to generate the final outpainted image. Again, paste the original image over the final outpainted background.",_e,q,Xe,f,Ml='<img src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/final-outpaint.png"/>',Ae,K,Ge,ee,Re;return C=new wl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),Z=new xe({props:{title:"Outpainting",local:"outpainting",headingTag:"h1"}}),B=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGNvbnRyb2xuZXRfYXV4",highlighted:"!pip install -q controlnet_aux",wrap:!1}}),v=new xe({props:{title:"Image preparation",local:"image-preparation",headingTag:"h2"}}),G=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> ZoeDetector
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageOps

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    AutoencoderKL,
    ControlNetModel,
    StableDiffusionXLControlNetPipeline,
    StableDiffusionXLInpaintPipeline,
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">scale_and_paste</span>(<span class="hljs-params">original_image</span>):
    aspect_ratio = original_image.width / original_image.height

    <span class="hljs-keyword">if</span> original_image.width &gt; original_image.height:
        new_width = <span class="hljs-number">1024</span>
        new_height = <span class="hljs-built_in">round</span>(new_width / aspect_ratio)
    <span class="hljs-keyword">else</span>:
        new_height = <span class="hljs-number">1024</span>
        new_width = <span class="hljs-built_in">round</span>(new_height * aspect_ratio)

    resized_original = original_image.resize((new_width, new_height), Image.LANCZOS)
    white_background = Image.new(<span class="hljs-string">&quot;RGBA&quot;</span>, (<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>), <span class="hljs-string">&quot;white&quot;</span>)
    x = (<span class="hljs-number">1024</span> - new_width) // <span class="hljs-number">2</span>
    y = (<span class="hljs-number">1024</span> - new_height) // <span class="hljs-number">2</span>
    white_background.paste(resized_original, (x, y), resized_original)

    <span class="hljs-keyword">return</span> resized_original, white_background

original_image = Image.<span class="hljs-built_in">open</span>(
    requests.get(
        <span class="hljs-string">&quot;https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/no-background-jordan.png&quot;</span>,
        stream=<span class="hljs-literal">True</span>,
    ).raw
).convert(<span class="hljs-string">&quot;RGBA&quot;</span>)
resized_img, white_bg_image = scale_and_paste(original_image)`,wrap:!1}}),V=new J({props:{code:"em9lJTIwJTNEJTIwWm9lRGV0ZWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZBbm5vdGF0b3JzJTIyKSUwQWltYWdlX3pvZSUyMCUzRCUyMHpvZSh3aGl0ZV9iZ19pbWFnZSUyQyUyMGRldGVjdF9yZXNvbHV0aW9uJTNENTEyJTJDJTIwaW1hZ2VfcmVzb2x1dGlvbiUzRDEwMjQpJTBBaW1hZ2Vfem9l",highlighted:`zoe = ZoeDetector.from_pretrained(<span class="hljs-string">&quot;lllyasviel/Annotators&quot;</span>)
image_zoe = zoe(white_bg_image, detect_resolution=<span class="hljs-number">512</span>, image_resolution=<span class="hljs-number">1024</span>)
image_zoe`,wrap:!1}}),E=new xe({props:{title:"Outpaint",local:"outpaint",headingTag:"h2"}}),x=new J({props:{code:"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",highlighted:`controlnets = [
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;destitech/controlnet-inpaint-dreamer-sdxl&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
    ),
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;diffusers/controlnet-zoe-depth-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
    ),
]
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/RealVisXL_V4.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, controlnet=controlnets, vae=vae
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_image</span>(<span class="hljs-params">prompt, negative_prompt, inpaint_image, zoe_image, seed: <span class="hljs-built_in">int</span> = <span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> seed <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        seed = random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>**<span class="hljs-number">32</span> - <span class="hljs-number">1</span>)

    generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(seed)

    image = pipeline(
        prompt,
        negative_prompt=negative_prompt,
        image=[inpaint_image, zoe_image],
        guidance_scale=<span class="hljs-number">6.5</span>,
        num_inference_steps=<span class="hljs-number">25</span>,
        generator=generator,
        controlnet_conditioning_scale=[<span class="hljs-number">0.5</span>, <span class="hljs-number">0.8</span>],
        control_guidance_end=[<span class="hljs-number">0.9</span>, <span class="hljs-number">0.6</span>],
    ).images[<span class="hljs-number">0</span>]

    <span class="hljs-keyword">return</span> image

prompt = <span class="hljs-string">&quot;nike air jordans on a basketball court&quot;</span>
negative_prompt = <span class="hljs-string">&quot;&quot;</span>

temp_image = generate_image(prompt, negative_prompt, white_bg_image, image_zoe, <span class="hljs-number">908097</span>)`,wrap:!1}}),N=new J({props:{code:"eCUyMCUzRCUyMCgxMDI0JTIwLSUyMHJlc2l6ZWRfaW1nLndpZHRoKSUyMCUyRiUyRiUyMDIlMEF5JTIwJTNEJTIwKDEwMjQlMjAtJTIwcmVzaXplZF9pbWcuaGVpZ2h0KSUyMCUyRiUyRiUyMDIlMEF0ZW1wX2ltYWdlLnBhc3RlKHJlc2l6ZWRfaW1nJTJDJTIwKHglMkMlMjB5KSUyQyUyMHJlc2l6ZWRfaW1nKSUwQXRlbXBfaW1hZ2U=",highlighted:`x = (<span class="hljs-number">1024</span> - resized_img.width) // <span class="hljs-number">2</span>
y = (<span class="hljs-number">1024</span> - resized_img.height) // <span class="hljs-number">2</span>
temp_image.paste(resized_img, (x, y), resized_img)
temp_image`,wrap:!1}}),$=new J({props:{code:"cGlwZWxpbmUlM0ROb25lJTBBdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgp",highlighted:`pipeline=<span class="hljs-literal">None</span>
torch.cuda.empty_cache()`,wrap:!1}}),H=new J({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTElucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyT3p6eUdUJTJGUmVhbFZpc1hMX1Y0LjBfaW5wYWludGluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdmFlJTNEdmFlJTJDJTBBKS50byglMjJjdWRhJTIyKQ==",highlighted:`pipeline = StableDiffusionXLInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;OzzyGT/RealVisXL_V4.0_inpainting&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    vae=vae,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),D=new J({props:{code:"bWFzayUyMCUzRCUyMEltYWdlLm5ldyglMjJMJTIyJTJDJTIwdGVtcF9pbWFnZS5zaXplKSUwQW1hc2sucGFzdGUocmVzaXplZF9pbWcuc3BsaXQoKSU1QjMlNUQlMkMlMjAoeCUyQyUyMHkpKSUwQW1hc2slMjAlM0QlMjBJbWFnZU9wcy5pbnZlcnQobWFzayklMEFmaW5hbF9tYXNrJTIwJTNEJTIwbWFzay5wb2ludChsYW1iZGElMjBwJTNBJTIwcCUyMCUzRSUyMDEyOCUyMGFuZCUyMDI1NSklMEFtYXNrX2JsdXJyZWQlMjAlM0QlMjBwaXBlbGluZS5tYXNrX3Byb2Nlc3Nvci5ibHVyKGZpbmFsX21hc2slMkMlMjBibHVyX2ZhY3RvciUzRDIwKSUwQW1hc2tfYmx1cnJlZA==",highlighted:`mask = Image.new(<span class="hljs-string">&quot;L&quot;</span>, temp_image.size)
mask.paste(resized_img.split()[<span class="hljs-number">3</span>], (x, y))
mask = ImageOps.invert(mask)
final_mask = mask.point(<span class="hljs-keyword">lambda</span> p: p &gt; <span class="hljs-number">128</span> <span class="hljs-keyword">and</span> <span class="hljs-number">255</span>)
mask_blurred = pipeline.mask_processor.blur(final_mask, blur_factor=<span class="hljs-number">20</span>)
mask_blurred`,wrap:!1}}),q=new J({props:{code:"ZGVmJTIwZ2VuZXJhdGVfb3V0cGFpbnQocHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTJDJTIwaW1hZ2UlMkMlMjBtYXNrJTJDJTIwc2VlZCUzQSUyMGludCUyMCUzRCUyME5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBzZWVkJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VlZCUyMCUzRCUyMHJhbmRvbS5yYW5kaW50KDAlMkMlMjAyKiozMiUyMC0lMjAxKSUwQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKHNlZWQpJTBBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWFza19pbWFnZSUzRG1hc2slMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDEwLjAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCkuaW1hZ2VzJTVCMCU1RCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltYWdlJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyaGlnaCUyMHF1YWxpdHklMjBwaG90byUyMG9mJTIwbmlrZSUyMGFpciUyMGpvcmRhbnMlMjBvbiUyMGElMjBiYXNrZXRiYWxsJTIwY291cnQlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMiUyMiUwQSUwQWZpbmFsX2ltYWdlJTIwJTNEJTIwZ2VuZXJhdGVfb3V0cGFpbnQocHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTJDJTIwdGVtcF9pbWFnZSUyQyUyMG1hc2tfYmx1cnJlZCUyQyUyMDc2ODg3NzgpJTBBeCUyMCUzRCUyMCgxMDI0JTIwLSUyMHJlc2l6ZWRfaW1nLndpZHRoKSUyMCUyRiUyRiUyMDIlMEF5JTIwJTNEJTIwKDEwMjQlMjAtJTIwcmVzaXplZF9pbWcuaGVpZ2h0KSUyMCUyRiUyRiUyMDIlMEFmaW5hbF9pbWFnZS5wYXN0ZShyZXNpemVkX2ltZyUyQyUyMCh4JTJDJTIweSklMkMlMjByZXNpemVkX2ltZyklMEFmaW5hbF9pbWFnZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_outpaint</span>(<span class="hljs-params">prompt, negative_prompt, image, mask, seed: <span class="hljs-built_in">int</span> = <span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> seed <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        seed = random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>**<span class="hljs-number">32</span> - <span class="hljs-number">1</span>)

    generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(seed)

    image = pipeline(
        prompt,
        negative_prompt=negative_prompt,
        image=image,
        mask_image=mask,
        guidance_scale=<span class="hljs-number">10.0</span>,
        strength=<span class="hljs-number">0.8</span>,
        num_inference_steps=<span class="hljs-number">30</span>,
        generator=generator,
    ).images[<span class="hljs-number">0</span>]

    <span class="hljs-keyword">return</span> image

prompt = <span class="hljs-string">&quot;high quality photo of nike air jordans on a basketball court, highly detailed&quot;</span>
negative_prompt = <span class="hljs-string">&quot;&quot;</span>

final_image = generate_outpaint(prompt, negative_prompt, temp_image, mask_blurred, <span class="hljs-number">7688778</span>)
x = (<span class="hljs-number">1024</span> - resized_img.width) // <span class="hljs-number">2</span>
y = (<span class="hljs-number">1024</span> - resized_img.height) // <span class="hljs-number">2</span>
final_image.paste(resized_img, (x, y), resized_img)
final_image`,wrap:!1}}),K=new hl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/advanced_inference/outpaint.md"}}),{c(){h=i("meta"),le=s(),O=i("p"),te=s(),r(C.$$.fragment),ae=s(),r(Z.$$.fragment),se=s(),I=i("p"),I.innerHTML=Ne,ne=s(),W=i("p"),W.textContent=$e,ie=s(),k=i("p"),k.innerHTML=ze,pe=s(),r(B.$$.fragment),Me=s(),r(v.$$.fragment),re=s(),_=i("p"),_.innerHTML=He,oe=s(),w=i("iframe"),me=s(),X=i("p"),X.textContent=De,ye=s(),j=i("div"),j.innerHTML=Le,ue=s(),A=i("p"),A.innerHTML=qe,ce=s(),r(G.$$.fragment),de=s(),R=i("p"),R.textContent=Ke,we=s(),r(V.$$.fragment),he=s(),T=i("div"),T.innerHTML=Pe,Ue=s(),r(E.$$.fragment),Je=s(),Q=i("p"),Q.innerHTML=Oe,je=s(),S=i("p"),S.innerHTML=el,Te=s(),r(x.$$.fragment),be=s(),F=i("p"),F.textContent=ll,ge=s(),r(N.$$.fragment),fe=s(),b=i("div"),b.innerHTML=tl,Ce=s(),U=i("blockquote"),P=i("p"),P.textContent=al,Qe=s(),r($.$$.fragment),Ze=s(),z=i("p"),z.innerHTML=sl,Ie=s(),r(H.$$.fragment),We=s(),Y=i("p"),Y.textContent=nl,ke=s(),r(D.$$.fragment),Be=s(),g=i("div"),g.innerHTML=il,ve=s(),L=i("p"),L.innerHTML=pl,_e=s(),r(q.$$.fragment),Xe=s(),f=i("div"),f.innerHTML=Ml,Ae=s(),r(K.$$.fragment),Ge=s(),ee=i("p"),this.h()},l(e){const l=dl("svelte-u9bgzb",document.head);h=p(l,"META",{name:!0,content:!0}),l.forEach(t),le=n(e),O=p(e,"P",{}),Ee(O).forEach(t),te=n(e),o(C.$$.fragment,e),ae=n(e),o(Z.$$.fragment,e),se=n(e),I=p(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-16ua5v0"&&(I.innerHTML=Ne),ne=n(e),W=p(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-6ts35n"&&(W.textContent=$e),ie=n(e),k=p(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-ftdr0t"&&(k.innerHTML=ze),pe=n(e),o(B.$$.fragment,e),Me=n(e),o(v.$$.fragment,e),re=n(e),_=p(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1qxxpsh"&&(_.innerHTML=He),oe=n(e),w=p(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Ee(w).forEach(t),me=n(e),X=p(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1mizknk"&&(X.textContent=De),ye=n(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(j)!=="svelte-1jvhkj8"&&(j.innerHTML=Le),ue=n(e),A=p(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1jea20f"&&(A.innerHTML=qe),ce=n(e),o(G.$$.fragment,e),de=n(e),R=p(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-ksi0ug"&&(R.textContent=Ke),we=n(e),o(V.$$.fragment,e),he=n(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(T)!=="svelte-rp0vpr"&&(T.innerHTML=Pe),Ue=n(e),o(E.$$.fragment,e),Je=n(e),Q=p(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1p8ap7h"&&(Q.innerHTML=Oe),je=n(e),S=p(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-xaw95o"&&(S.innerHTML=el),Te=n(e),o(x.$$.fragment,e),be=n(e),F=p(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-13kbyjh"&&(F.textContent=ll),ge=n(e),o(N.$$.fragment,e),fe=n(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(b)!=="svelte-1f58coy"&&(b.innerHTML=tl),Ce=n(e),U=p(e,"BLOCKQUOTE",{class:!0});var Ve=Ee(U);P=p(Ve,"P",{"data-svelte-h":!0}),M(P)!=="svelte-pgpkis"&&(P.textContent=al),Qe=n(Ve),o($.$$.fragment,Ve),Ve.forEach(t),Ze=n(e),z=p(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-srw55e"&&(z.innerHTML=sl),Ie=n(e),o(H.$$.fragment,e),We=n(e),Y=p(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-n4298l"&&(Y.textContent=nl),ke=n(e),o(D.$$.fragment,e),Be=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(g)!=="svelte-1anr4fy"&&(g.innerHTML=il),ve=n(e),L=p(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-ktwg6k"&&(L.innerHTML=pl),_e=n(e),o(q.$$.fragment,e),Xe=n(e),f=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(f)!=="svelte-1r64xky"&&(f.innerHTML=Ml),Ae=n(e),o(K.$$.fragment,e),Ge=n(e),ee=p(e,"P",{}),Ee(ee).forEach(t),this.h()},h(){d(h,"name","hf:doc:metadata"),d(h,"content",Jl),ol(w.src,Ye="https://briaai-bria-rmbg-1-4.hf.space")||d(w,"src",Ye),d(w,"frameborder","0"),d(w,"width","850"),d(w,"height","450"),d(j,"class","flex flex-row gap-4"),d(T,"class","flex justify-center"),d(b,"class","flex justify-center"),d(U,"class","tip"),d(g,"class","flex justify-center"),d(f,"class","flex justify-center")},m(e,l){Se(document.head,h),a(e,le,l),a(e,O,l),a(e,te,l),m(C,e,l),a(e,ae,l),m(Z,e,l),a(e,se,l),a(e,I,l),a(e,ne,l),a(e,W,l),a(e,ie,l),a(e,k,l),a(e,pe,l),m(B,e,l),a(e,Me,l),m(v,e,l),a(e,re,l),a(e,_,l),a(e,oe,l),a(e,w,l),a(e,me,l),a(e,X,l),a(e,ye,l),a(e,j,l),a(e,ue,l),a(e,A,l),a(e,ce,l),m(G,e,l),a(e,de,l),a(e,R,l),a(e,we,l),m(V,e,l),a(e,he,l),a(e,T,l),a(e,Ue,l),m(E,e,l),a(e,Je,l),a(e,Q,l),a(e,je,l),a(e,S,l),a(e,Te,l),m(x,e,l),a(e,be,l),a(e,F,l),a(e,ge,l),m(N,e,l),a(e,fe,l),a(e,b,l),a(e,Ce,l),a(e,U,l),Se(U,P),Se(U,Qe),m($,U,null),a(e,Ze,l),a(e,z,l),a(e,Ie,l),m(H,e,l),a(e,We,l),a(e,Y,l),a(e,ke,l),m(D,e,l),a(e,Be,l),a(e,g,l),a(e,ve,l),a(e,L,l),a(e,_e,l),m(q,e,l),a(e,Xe,l),a(e,f,l),a(e,Ae,l),m(K,e,l),a(e,Ge,l),a(e,ee,l),Re=!0},p:ml,i(e){Re||(y(C.$$.fragment,e),y(Z.$$.fragment,e),y(B.$$.fragment,e),y(v.$$.fragment,e),y(G.$$.fragment,e),y(V.$$.fragment,e),y(E.$$.fragment,e),y(x.$$.fragment,e),y(N.$$.fragment,e),y($.$$.fragment,e),y(H.$$.fragment,e),y(D.$$.fragment,e),y(q.$$.fragment,e),y(K.$$.fragment,e),Re=!0)},o(e){u(C.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(v.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(E.$$.fragment,e),u(x.$$.fragment,e),u(N.$$.fragment,e),u($.$$.fragment,e),u(H.$$.fragment,e),u(D.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),Re=!1},d(e){e&&(t(le),t(O),t(te),t(ae),t(se),t(I),t(ne),t(W),t(ie),t(k),t(pe),t(Me),t(re),t(_),t(oe),t(w),t(me),t(X),t(ye),t(j),t(ue),t(A),t(ce),t(de),t(R),t(we),t(he),t(T),t(Ue),t(Je),t(Q),t(je),t(S),t(Te),t(be),t(F),t(ge),t(fe),t(b),t(Ce),t(U),t(Ze),t(z),t(Ie),t(We),t(Y),t(ke),t(Be),t(g),t(ve),t(L),t(_e),t(Xe),t(f),t(Ae),t(Ge),t(ee)),t(h),c(C,e),c(Z,e),c(B,e),c(v,e),c(G,e),c(V,e),c(E,e),c(x,e),c(N,e),c($),c(H,e),c(D,e),c(q,e),c(K,e)}}}const Jl='{"title":"Outpainting","local":"outpainting","sections":[{"title":"Image preparation","local":"image-preparation","sections":[],"depth":2},{"title":"Outpaint","local":"outpaint","sections":[],"depth":2}],"depth":1}';function jl(Fe){return yl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends ul{constructor(h){super(),cl(this,h,jl,Ul,rl,{})}}export{Zl as component};
