import{s as km,n as Dm,o as Nm}from"../chunks/scheduler.9039eef2.js";import{S as Fm,i as Lm,g as o,s as a,r as s,A as zm,h as r,f as l,c as n,j as _,u as d,x as i,k as h,y as t,a as v,v as c,d as m,t as p,w as g}from"../chunks/index.ded8f90d.js";import{D as u}from"../chunks/Docstring.a2ba2b54.js";import{H as N}from"../chunks/Heading.f027f30d.js";function Im(Ld){let ee,er,Qo,tr,et,ar,tt,zd=`At TRL we support PPO (Proximal Policy Optimisation) with an implementation that largely follows  the structure introduced in the paper “Fine-Tuning Language Models from Human Preferences” by D. Ziegler et al. [<a href="https://arxiv.org/pdf/1909.08593.pdf" rel="nofollow">paper</a>, <a href="https://github.com/openai/lm-human-preferences" rel="nofollow">code</a>].
The Trainer and model classes are largely inspired from <code>transformers.Trainer</code> and <code>transformers.AutoModel</code> classes and adapted for RL.
We also support a <code>RewardTrainer</code> that can be used to train a reward model.`,nr,at,or,E,nt,Ll,Ha,Id='CPOConfig collects all training arguments related to the <a href="/docs/trl/main/en/trainer#trl.CPOTrainer">CPOTrainer</a> class.',zl,Sa,qd=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,rr,ot,lr,x,rt,Il,Aa,Md="Initialize CPOTrainer.",ql,re,lt,Ml,Va,Ed=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,El,A,it,Rl,ja,Rd="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Ul,Ka,Ud="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Hl,le,st,Sl,Wa,Hd="Concatenate the chosen and rejected inputs into a single tensor.",Al,ie,dt,Vl,Ga,Sd="Compute the CPO loss for a batch of policy and reference model log probabilities.",jl,V,ct,Kl,Ba,Ad=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Wl,Ya,Vd="Works both with or without labels.",Gl,se,mt,Bl,Za,jd="Compute the log probabilities of the given labels under the given logits.",Yl,de,pt,Zl,Ja,Kd="Compute the CPO loss and other metrics for the given batch of inputs for train or test.",Jl,ce,gt,Ql,Qa,Wd="Generate samples from the model and reference model for the given batch of inputs.",Xl,me,_t,ei,Xa,Gd="Log <code>logs</code> on the various objects watching training, including stored metrics.",ti,L,ht,ai,en,Bd="Tokenize a single row from a CPO specific dataset.",ni,tn,Yd=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,oi,an,Zd=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,ir,ut,sr,te,ft,ri,nn,Jd="Configuration class for DDPOTrainer",dr,vt,cr,D,bt,li,on,Qd=`The DDPOTrainer uses Deep Diffusion Policy Optimization to optimise diffusion models.
Note, this trainer is heavily inspired by the work here: <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">https://github.com/kvablack/ddpo-pytorch</a>
As of now only Stable Diffusion based pipelines are supported`,ii,pe,Tt,si,rn,Xd="Calculate the loss for a batch of an unpacked sample",di,ge,Ot,ci,ln,ec="Creates and saves a model card for a TRL model.",mi,z,xt,pi,sn,tc="Perform a single step of training.",gi,dn,ac="Side Effects:",_i,cn,nc="<li>Model weights are updated</li> <li>Logs the statistics to the accelerator trackers.</li> <li>If <code>self.image_samples_callback</code> is not None, it will be called with the prompt_image_pairs, global_step, and the accelerator tracker.</li>",hi,_e,$t,ui,mn,oc="Train the model for a given number of epochs",mr,Pt,pr,b,wt,fi,pn,rc="Initialize DPOTrainer.",vi,he,yt,bi,gn,lc=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Ti,ue,Ct,Oi,_n,ic="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",xi,j,kt,$i,hn,sc="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Pi,un,dc="We do this to avoid doing two forward passes, because it’s faster for FSDP.",wi,fe,Dt,yi,fn,cc="Concatenate the chosen and rejected inputs into a single tensor.",Ci,ve,Nt,ki,vn,mc="Compute the DPO loss for a batch of policy and reference model log probabilities.",Di,K,Ft,Ni,bn,pc=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Fi,Tn,gc="Works both with or without labels.",Li,be,Lt,zi,On,_c="Compute the log probabilities of the given labels under the given logits.",Ii,Te,zt,qi,xn,hc="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",Mi,Oe,It,Ei,$n,uc="Generate samples from the model and reference model for the given batch of inputs.",Ri,W,qt,Ui,Pn,fc="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Hi,wn,vc="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Si,G,Mt,Ai,yn,bc="Returns the training <code>~torch.utils.data.DataLoader</code>.",Vi,Cn,Tc="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",ji,xe,Et,Ki,kn,Oc="Log <code>logs</code> on the various objects watching training, including stored metrics.",Wi,$e,Rt,Gi,Dn,xc="Context manager for handling null reference model (that is, peft adapter manipulation).",Bi,I,Ut,Yi,Nn,$c="Tokenize a single row from a DPO specific dataset.",Zi,Fn,Pc=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Ji,Ln,wc=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,gr,Ht,_r,R,St,Qi,zn,yc="The IterativeSFTTrainer can be used to finetune models with methods that requires some steps between optimization.",Xi,Pe,At,es,In,Cc="Run an optimisation step given a list of input_ids, attention_mask, and labels or a list of text and text_labels.",hr,Vt,ur,U,jt,ts,qn,kc='KTOConfig collects all training arguments related to the <a href="/docs/trl/main/en/trainer#trl.KTOTrainer">KTOTrainer</a> class.',as,Mn,Dc=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,fr,Kt,vr,$,Wt,ns,En,Nc="Initialize KTOTrainer.",os,we,Gt,rs,Rn,Fc="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",ls,B,Bt,is,Un,Lc=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,ss,Hn,zc="Works both with or without labels.",ds,ye,Yt,cs,Sn,Ic="Compute the log probabilities of the given labels under the given logits.",ms,Ce,Zt,ps,An,qc="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",gs,ke,Jt,_s,Vn,Mc="Generate samples from the model and reference model for the given batch of inputs.",hs,Y,Qt,us,jn,Ec="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",fs,Kn,Rc="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",vs,Z,Xt,bs,Wn,Uc="Returns the training <code>~torch.utils.data.DataLoader</code>.",Ts,Gn,Hc="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Os,De,ea,xs,Bn,Sc="Compute the KTO loss for a batch of policy and reference model log probabilities.",$s,Ne,ta,Ps,Yn,Ac="Log <code>logs</code> on the various objects watching training, including stored metrics.",ws,Fe,aa,ys,Zn,Vc="Context manager for handling null reference model (that is, peft adapter manipulation).",br,na,Tr,H,oa,Cs,Jn,jc='ORPOConfig collects all training arguments related to the <a href="/docs/trl/main/en/orpo_trainer#trl.ORPOTrainer">ORPOTrainer</a> class.',ks,Qn,Kc=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Or,ra,xr,P,la,Ds,Xn,Wc="Initialize ORPOTrainer.",Ns,Le,ia,Fs,eo,Gc=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Ls,J,sa,zs,to,Bc="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Is,ao,Yc="We do this to avoid doing two forward passes, because it’s faster for FSDP.",qs,ze,da,Ms,no,Zc="Concatenate the chosen and rejected inputs into a single tensor.",Es,Q,ca,Rs,oo,Jc=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Us,ro,Qc="Works both with or without labels.",Hs,Ie,ma,Ss,lo,Xc="Compute the log probabilities of the given labels under the given logits.",As,qe,pa,Vs,io,em="Compute the ORPO loss and other metrics for the given batch of inputs for train or test.",js,Me,ga,Ks,so,tm="Generate samples from the model and reference model for the given batch of inputs.",Ws,Ee,_a,Gs,co,am="Log <code>logs</code> on the various objects watching training, including stored metrics.",Bs,Re,ha,Ys,mo,nm="Compute ORPO’s odds ratio (OR) loss for a batch of policy and reference model log probabilities.",Zs,q,ua,Js,po,om="Tokenize a single row from a ORPO specific dataset.",Qs,go,rm=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Xs,_o,lm=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,$r,fa,Pr,ae,va,ed,ho,im="Configuration class for PPOTrainer",wr,ba,yr,O,Ta,td,uo,sm=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,ad,Ue,Oa,nd,fo,dm="Calculate model outputs in multiple batches.",od,He,xa,rd,vo,cm="Compute per token rewards from scores and KL-penalty.",ld,Se,$a,id,bo,mm="Creates and saves a model card for a TRL model.",sd,Ae,Pa,dd,To,pm="Gather stats from all processes. Useful in the context of distributed training.",cd,Ve,wa,md,Oo,gm=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,pd,je,ya,gd,xo,_m="A function that logs all the training stats. Call it at the end of each epoch.",_d,Ke,Ca,hd,$o,hm="Calculate policy and value losses.",ud,We,ka,fd,Po,um="Prepare the dataloader for training.",vd,Ge,Da,bd,wo,fm="Record training step statistics.",Td,Be,Na,Od,yo,vm="Run a PPO optimisation step given a list of queries, model responses, and rewards.",xd,Ye,Fa,$d,Co,bm="Train one PPO minibatch",Cr,La,kr,S,za,Pd,ko,Tm='RewardConfig collects all training arguments related to the <a href="/docs/trl/main/en/trainer#trl.RewardTrainer">RewardTrainer</a> class.',wd,Do,Om=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Dr,Ia,Nr,F,qa,yd,No,xm=`The RewardTrainer can be used to train your custom Reward Model. It is a subclass of the
<code>transformers.Trainer</code> class and inherits all of its attributes and methods. It is recommended to use
an <code>AutoModelForSequenceClassification</code> as the reward model. The reward model should be trained on a dataset
of paired examples, where each example is a tuple of two sequences. The reward model should be trained to
predict which example in the pair is more relevant to the task at hand.`,Cd,Fo,$m=`The reward trainer expects a very specific format for the dataset. The dataset should contain two 4 entries at least
if you don’t use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named`,kd,Lo,Pm="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",Dd,zo,wm=`Optionally, you can also pass a <code>margin</code> entry to the dataset. This entry should contain the margin used to modulate the
loss of the reward model as outlined in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/</a>.
If you don’t pass a margin, no margin will be used.`,Fr,Ma,Lr,ne,Ea,Nd,Io,ym=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,zr,Ra,Ir,oe,Ua,Fd,qo,Cm="Helper function for reproducible behavior to set the seed in <code>random</code>, <code>numpy</code>, and <code>torch</code>.",qr,Xo,Mr;return et=new N({props:{title:"Trainer",local:"trainer",headingTag:"h1"}}),at=new N({props:{title:"CPOConfig",local:"trl.CPOConfig",headingTag:"h2"}}),nt=new u({props:{name:"class trl.CPOConfig",anchor:"trl.CPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"disable_dropout",val:": bool = True"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.CPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.CPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.CPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in CPO loss.`,name:"beta"},{anchor:"trl.CPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The label smoothing factor. This argument is required if you want to use the default data collator.`,name:"label_smoothing"},{anchor:"trl.CPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>sigmoid</code>) &#x2014;
The type of loss to use. This argument is required if you want to use the default data collator.`,name:"loss_type"},{anchor:"trl.CPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.CPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.CPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.CPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.CPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.CPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.CPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.CPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_config.py#L20"}}),ot=new N({props:{title:"CPOTrainer",local:"trl.CPOTrainer",headingTag:"h2"}}),rt=new u({props:{name:"class trl.CPOTrainer",anchor:"trl.CPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.CPOTrainer.args",description:`<strong>args</strong> (<code>CPOConfig</code>) &#x2014;
The CPO config arguments to use for training.`,name:"args"},{anchor:"trl.CPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.CPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.CPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.CPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.CPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.CPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.CPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.CPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.CPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.CPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L55"}}),lt=new u({props:{name:"build_tokenized_answer",anchor:"trl.CPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L304"}}),it=new u({props:{name:"concatenated_forward",anchor:"trl.CPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L642"}}),st=new u({props:{name:"concatenated_inputs",anchor:"trl.CPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L500",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),dt=new u({props:{name:"cpo_loss",anchor:"trl.CPOTrainer.cpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L562",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the CPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),ct=new u({props:{name:"evaluation_loop",anchor:"trl.CPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L834"}}),mt=new u({props:{name:"get_batch_logps",anchor:"trl.CPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L604",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),pt=new u({props:{name:"get_batch_loss_metrics",anchor:"trl.CPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L707"}}),gt=new u({props:{name:"get_batch_samples",anchor:"trl.CPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L769"}}),_t=new u({props:{name:"log",anchor:"trl.CPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.CPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L882"}}),ht=new u({props:{name:"tokenize_row",anchor:"trl.CPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L354"}}),ut=new N({props:{title:"DDPOConfig",local:"trl.DDPOConfig",headingTag:"h2"}}),ft=new u({props:{name:"class trl.DDPOConfig",anchor:"trl.DDPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"run_name",val:": Optional = ''"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"tracker_kwargs",val:": dict = <factory>"},{name:"accelerator_kwargs",val:": dict = <factory>"},{name:"project_kwargs",val:": dict = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"logdir",val:": str = 'logs'"},{name:"num_epochs",val:": int = 100"},{name:"save_freq",val:": int = 1"},{name:"num_checkpoint_limit",val:": int = 5"},{name:"mixed_precision",val:": str = 'fp16'"},{name:"allow_tf32",val:": bool = True"},{name:"resume_from",val:": Optional = ''"},{name:"sample_num_steps",val:": int = 50"},{name:"sample_eta",val:": float = 1.0"},{name:"sample_guidance_scale",val:": float = 5.0"},{name:"sample_batch_size",val:": int = 1"},{name:"sample_num_batches_per_epoch",val:": int = 2"},{name:"train_batch_size",val:": int = 1"},{name:"train_use_8bit_adam",val:": bool = False"},{name:"train_learning_rate",val:": float = 0.0003"},{name:"train_adam_beta1",val:": float = 0.9"},{name:"train_adam_beta2",val:": float = 0.999"},{name:"train_adam_weight_decay",val:": float = 0.0001"},{name:"train_adam_epsilon",val:": float = 1e-08"},{name:"train_gradient_accumulation_steps",val:": int = 1"},{name:"train_max_grad_norm",val:": float = 1.0"},{name:"train_num_inner_epochs",val:": int = 1"},{name:"train_cfg",val:": bool = True"},{name:"train_adv_clip_max",val:": float = 5"},{name:"train_clip_range",val:": float = 0.0001"},{name:"train_timestep_fraction",val:": float = 1.0"},{name:"per_prompt_stat_tracking",val:": bool = False"},{name:"per_prompt_stat_tracking_buffer_size",val:": int = 16"},{name:"per_prompt_stat_tracking_min_count",val:": int = 16"},{name:"async_reward_computation",val:": bool = False"},{name:"max_workers",val:": int = 2"},{name:"negative_prompts",val:": Optional = ''"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_config.py#L11"}}),vt=new N({props:{title:"DDPOTrainer",local:"trl.DDPOTrainer",headingTag:"h2"}}),bt=new u({props:{name:"class trl.DDPOTrainer",anchor:"trl.DDPOTrainer",parameters:[{name:"config",val:": DDPOConfig"},{name:"reward_function",val:": Callable"},{name:"prompt_function",val:": Callable"},{name:"sd_pipeline",val:": DDPOStableDiffusionPipeline"},{name:"image_samples_hook",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DDPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>DDPOConfig</code>) &#x2014; Configuration object for DDPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.DDPOTrainer.*reward_function**",description:"*<strong>*reward_function**</strong> (Callable[[torch.Tensor, Tuple[str], Tuple[Any]], torch.Tensor]) &#x2014; Reward function to be used &#x2014;",name:"*reward_function**"},{anchor:"trl.DDPOTrainer.*prompt_function**",description:"*<strong>*prompt_function**</strong> (Callable[[], Tuple[str, Any]]) &#x2014; Function to generate prompts to guide model &#x2014;",name:"*prompt_function**"},{anchor:"trl.DDPOTrainer.*sd_pipeline**",description:"*<strong>*sd_pipeline**</strong> (<code>DDPOStableDiffusionPipeline</code>) &#x2014; Stable Diffusion pipeline to be used for training. &#x2014;",name:"*sd_pipeline**"},{anchor:"trl.DDPOTrainer.*image_samples_hook**",description:"*<strong>*image_samples_hook**</strong> (Optional[Callable[[Any, Any, Any], Any]]) &#x2014; Hook to be called to log images &#x2014;",name:"*image_samples_hook**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L55"}}),Tt=new u({props:{name:"calculate_loss",anchor:"trl.DDPOTrainer.calculate_loss",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"next_latents",val:""},{name:"log_probs",val:""},{name:"advantages",val:""},{name:"embeds",val:""}],parametersDescription:[{anchor:"trl.DDPOTrainer.calculate_loss.latents",description:`<strong>latents</strong> (torch.Tensor) &#x2014;
The latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"latents"},{anchor:"trl.DDPOTrainer.calculate_loss.timesteps",description:`<strong>timesteps</strong> (torch.Tensor) &#x2014;
The timesteps sampled from the diffusion model, shape: [batch_size]`,name:"timesteps"},{anchor:"trl.DDPOTrainer.calculate_loss.next_latents",description:`<strong>next_latents</strong> (torch.Tensor) &#x2014;
The next latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"next_latents"},{anchor:"trl.DDPOTrainer.calculate_loss.log_probs",description:`<strong>log_probs</strong> (torch.Tensor) &#x2014;
The log probabilities of the latents, shape: [batch_size]`,name:"log_probs"},{anchor:"trl.DDPOTrainer.calculate_loss.advantages",description:`<strong>advantages</strong> (torch.Tensor) &#x2014;
The advantages of the latents, shape: [batch_size]`,name:"advantages"},{anchor:"trl.DDPOTrainer.calculate_loss.embeds",description:`<strong>embeds</strong> (torch.Tensor) &#x2014;
The embeddings of the prompts, shape: [2*batch_size or batch_size, &#x2026;]
Note: the &#x201C;or&#x201D; is because if train_cfg is True, the expectation is that negative prompts are concatenated to the embeds`,name:"embeds"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L340",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>loss (torch.Tensor), approx_kl (torch.Tensor), clipfrac (torch.Tensor)
(all of these are of shape (1,))</p>
`}}),Ot=new u({props:{name:"create_model_card",anchor:"trl.DDPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL DDPO Model'"}],parametersDescription:[{anchor:"trl.DDPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.DDPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL DDPO Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L606"}}),xt=new u({props:{name:"step",anchor:"trl.DDPOTrainer.step",parameters:[{name:"epoch",val:": int"},{name:"global_step",val:": int"}],parametersDescription:[{anchor:"trl.DDPOTrainer.step.epoch",description:"<strong>epoch</strong> (int) &#x2014; The current epoch.",name:"epoch"},{anchor:"trl.DDPOTrainer.step.global_step",description:"<strong>global_step</strong> (int) &#x2014; The current global step.",name:"global_step"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L234",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The updated global step.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>global_step (int)</p>
`}}),$t=new u({props:{name:"train",anchor:"trl.DDPOTrainer.train",parameters:[{name:"epochs",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L596"}}),Pt=new N({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),wt=new u({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOTrainer.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper, or <code>&quot;kto&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.DPOTrainer.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.DPOTrainer.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.DPOTrainer.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOTrainer.reference_free",description:`<strong>reference_free</strong> (<code>bool</code>) &#x2014;
If True, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOTrainer.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L65"}}),yt=new u({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L550"}}),Ct=new u({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L758"}}),kt=new u({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L961"}}),Dt=new u({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L782",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Nt=new u({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L844",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Ft=new u({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1182"}}),Lt=new u({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L923",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),zt=new u({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1008"}}),It=new u({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1092"}}),qt=new u({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L498"}}),Mt=new u({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L455"}}),Et=new u({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1232"}}),Rt=new u({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L746"}}),Ut=new u({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L600"}}),Ht=new N({props:{title:"IterativeSFTTrainer",local:"trl.IterativeSFTTrainer",headingTag:"h2"}}),St=new u({props:{name:"class trl.IterativeSFTTrainer",anchor:"trl.IterativeSFTTrainer",parameters:[{name:"model",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"data_collator",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"truncation_mode",val:": Optional = 'keep_end'"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModel</code>) &#x2014; Model to be optimized, either an &#x2018;AutoModelForCausalLM&#x2019; or an &#x2018;AutoModelForSeq2SeqLM&#x2019;. &#x2014;
Check the documentation of <code>PreTrainedModel</code> for more details.`,name:"*model**"},{anchor:"trl.IterativeSFTTrainer.*args**",description:"*<strong>*args**</strong> (<code>transformers.TrainingArguments</code>) &#x2014; &#x2014; The arguments to use for training.",name:"*args**"},{anchor:"trl.IterativeSFTTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.IterativeSFTTrainer.*optimizers**",description:"*<strong>*optimizers**</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014; &#x2014; The optimizer and scheduler to use for training.",name:"*optimizers**"},{anchor:"trl.IterativeSFTTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (Union[DataCollatorForLanguageModeling, DataCollatorForSeq2Seq], <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader.`,name:"*data_collator**"},{anchor:"trl.IterativeSFTTrainer.*eval_dataset**",description:"*<strong>*eval_dataset**</strong> (<code>datasets.Dataset</code>) &#x2014; The dataset to use for evaluation.",name:"*eval_dataset**"},{anchor:"trl.IterativeSFTTrainer.*max_length**",description:"*<strong>*max_length**</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014; &#x2014; The maximum length of the input.",name:"*max_length**"},{anchor:"trl.IterativeSFTTrainer.*truncation_mode**",description:"*<strong>*truncation_mode**</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014; &#x2014; The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>.",name:"*truncation_mode**"},{anchor:"trl.IterativeSFTTrainer.*preprocess_logits_for_metrics**",description:"*<strong>*preprocess_logits_for_metrics**</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014; &#x2014; The function to use to preprocess the logits before computing the metrics.",name:"*preprocess_logits_for_metrics**"},{anchor:"trl.IterativeSFTTrainer.*compute_metrics**",description:"*<strong>*compute_metrics**</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014; &#x2014; The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return a dictionary string to metric values.",name:"*compute_metrics**"},{anchor:"trl.IterativeSFTTrainer.*optimize_device_cache",description:"*<strong>*optimize_device_cache</strong> *<em> (<code>bool</code>, </em>optional*, defaults to <code>False</code>) &#x2014; Optimize CUDA cache for slightly more memory-efficient training. &#x2014;",name:"*optimize_device_cache"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L39"}}),At=new u({props:{name:"step",anchor:"trl.IterativeSFTTrainer.step",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"texts",val:": Optional = None"},{name:"texts_labels",val:": Optional = None"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.step.input_ids",description:`<strong>input_ids</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the input_ids (if not provided, text will be used)`,name:"input_ids"},{anchor:"trl.IterativeSFTTrainer.step.attention_mask",description:`<strong>attention_mask</strong> (List<code>torch.LongTensor</code>, , <em>optional</em>) &#x2014;
List of tensors containing the attention_mask`,name:"attention_mask"},{anchor:"trl.IterativeSFTTrainer.step.labels",description:`<strong>labels</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of tensors containing the labels (if set to None, will default to input_ids)`,name:"labels"},{anchor:"trl.IterativeSFTTrainer.step.texts",description:`<strong>texts</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text input (if not provided, input_ids will directly be used)`,name:"texts"},{anchor:"trl.IterativeSFTTrainer.step.texts_labels",description:`<strong>texts_labels</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text labels (if set to None, will default to text)`,name:"texts_labels"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Vt=new N({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),jt=new u({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"desirable_weight",val:": Optional = 1.0"},{name:"undesirable_weight",val:": Optional = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in KTO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.
dataset_num_proc &#x2014; (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>):
Number of processes to use for processing the datasets.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_config.py#L20"}}),Kt=new N({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),Wt=new u({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.KTOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.KTOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L224"}}),Gt=new u({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L794"}}),Bt=new u({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1217"}}),Yt=new u({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L866",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),Zt=new u({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1022"}}),Jt=new u({props:{name:"get_batch_samples",anchor:"trl.KTOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1131"}}),Qt=new u({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L741"}}),Xt=new u({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L700"}}),ea=new u({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L969",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),ta=new u({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1273"}}),aa=new u({props:{name:"null_ref_context",anchor:"trl.KTOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L688"}}),na=new N({props:{title:"ORPOConfig",local:"trl.ORPOConfig",headingTag:"h2"}}),oa=new u({props:{name:"class trl.ORPOConfig",anchor:"trl.ORPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"disable_dropout",val:": bool = True"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.ORPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.ORPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.ORPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the completions. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.ORPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in ORPO loss (lambda/alpha in paper/code) that is the weight of the relative loss ratio in the SFT loss.`,name:"beta"},{anchor:"trl.ORPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.ORPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.ORPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.ORPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.ORPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.ORPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.ORPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.ORPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_config.py#L20"}}),ra=new N({props:{title:"ORPOTrainer",local:"trl.ORPOTrainer",headingTag:"h2"}}),la=new u({props:{name:"class trl.ORPOTrainer",anchor:"trl.ORPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.ORPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.ORPOTrainer.args",description:`<strong>args</strong> (<code>ORPOConfig</code>) &#x2014;
The ORPO config arguments to use for training.`,name:"args"},{anchor:"trl.ORPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.ORPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.ORPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.ORPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.ORPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.ORPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.ORPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.ORPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.ORPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.ORPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L62"}}),ia=new u({props:{name:"build_tokenized_answer",anchor:"trl.ORPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L334"}}),sa=new u({props:{name:"concatenated_forward",anchor:"trl.ORPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L662"}}),da=new u({props:{name:"concatenated_inputs",anchor:"trl.ORPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L530",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),ca=new u({props:{name:"evaluation_loop",anchor:"trl.ORPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L860"}}),ma=new u({props:{name:"get_batch_logps",anchor:"trl.ORPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L624",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),pa=new u({props:{name:"get_batch_loss_metrics",anchor:"trl.ORPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L731"}}),ga=new u({props:{name:"get_batch_samples",anchor:"trl.ORPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L795"}}),_a=new u({props:{name:"log",anchor:"trl.ORPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.ORPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L908"}}),ha=new u({props:{name:"odds_ratio_loss",anchor:"trl.ORPOTrainer.odds_ratio_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L592",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the ORPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The log odds ratio of the chosen responses over the rejected responses ratio for logging purposes.
The <code>log(sigmoid(log_odds_chosen))</code> for logging purposes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),ua=new u({props:{name:"tokenize_row",anchor:"trl.ORPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L384"}}),fa=new N({props:{title:"PPOConfig",local:"trl.PPOConfig",headingTag:"h2"}}),va=new u({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"task_name",val:": Optional = None"},{name:"model_name",val:": Optional = 'gpt2'"},{name:"query_dataset",val:": Optional = 'imdb'"},{name:"reward_model",val:": Optional = 'sentiment-analysis:lvwerra/distilbert-imdb'"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": Annotated = <factory>"},{name:"accelerator_kwargs",val:": Annotated = <factory>"},{name:"project_kwargs",val:": Annotated = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": Annotated = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1.41e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": Optional = 0.2"},{name:"kl_penalty",val:": Literal = 'kl'"},{name:"target",val:": Optional = 6"},{name:"horizon",val:": Optional = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 128"},{name:"forward_batch_size",val:": Optional = None"},{name:"mini_batch_size",val:": int = 128"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": Annotated = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": Optional = None"},{name:"optimize_cuda_cache",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": Optional = None"},{name:"whiten_rewards",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"is_peft_model",val:": Optional = None"},{name:"backward_batch_size",val:": Annotated = None"},{name:"global_backward_batch_size",val:": Annotated = None"},{name:"global_batch_size",val:": Annotated = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_config.py#L34"}}),ba=new N({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),Ta=new u({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"ref_model",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"dataset",val:": Union = None"},{name:"optimizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"num_shared_layers",val:": Optional = None"},{name:"lr_scheduler",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L114"}}),Oa=new u({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L951",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),xa=new u({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1088",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Per token rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: Non score rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: KL penalty, shape (<code>batch_size</code>, <code>response_length</code>)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),$a=new u({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1396"}}),Pa=new u({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L907",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),wa=new u({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": Union"},{name:"length_sampler",val:": Optional = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L436",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),ya=new u({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": List"},{name:"columns_to_log",val:": Iterable = ('query', 'response')"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1323"}}),Ca=new u({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1170"}}),ka=new u({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": Union"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L381",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),Da=new u({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1259",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),Na=new u({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": List"},{name:"responses",val:": List"},{name:"scores",val:": List"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L627",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Fa=new u({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [mini_batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [mini_batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [mini_batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [mini_batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [mini_batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1042",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),La=new N({props:{title:"RewardConfig",local:"trl.RewardConfig",headingTag:"h2"}}),za=new u({props:{name:"class trl.RewardConfig",anchor:"trl.RewardConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"trl.RewardConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.RewardConfig.gradient_checkpointing",description:`<strong>gradient_checkpointing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, use gradient checkpointing to save memory at the expense of slower backward pass.`,name:"gradient_checkpointing"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/reward_config.py#L21"}}),Ia=new N({props:{title:"RewardTrainer",local:"trl.RewardTrainer",headingTag:"h2"}}),qa=new u({props:{name:"class trl.RewardTrainer",anchor:"trl.RewardTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/reward_trainer.py#L36"}}),Ma=new N({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),Ea=new u({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"formatting_func",val:": Optional = None"},{name:"max_seq_length",val:": Optional = None"},{name:"infinite",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = 1024"},{name:"chars_per_token",val:": Optional = 3.6"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"},{name:"eval_packing",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automatically creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instruction
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets
eval_packing &#x2014; (<code>Optional[bool]</code>, <em>optional</em>):
Whether to pack the eval dataset as well. Defaults to <code>packing</code> if <code>None</code> is passed.`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L57"}}),Ra=new N({props:{title:"set_seed",local:"trl.set_seed",headingTag:"h2"}}),Ua=new u({props:{name:"trl.set_seed",anchor:"trl.set_seed",parameters:[{name:"seed",val:": int"}],parametersDescription:[{anchor:"trl.set_seed.seed",description:"<strong>seed</strong> (<code>int</code>) &#x2014; The seed to set.",name:"seed"}],source:"https://github.com/huggingface/trl/blob/main/trl/core.py#L245"}}),{c(){ee=o("meta"),er=a(),Qo=o("p"),tr=a(),s(et.$$.fragment),ar=a(),tt=o("p"),tt.innerHTML=zd,nr=a(),s(at.$$.fragment),or=a(),E=o("div"),s(nt.$$.fragment),Ll=a(),Ha=o("p"),Ha.innerHTML=Id,zl=a(),Sa=o("p"),Sa.innerHTML=qd,rr=a(),s(ot.$$.fragment),lr=a(),x=o("div"),s(rt.$$.fragment),Il=a(),Aa=o("p"),Aa.textContent=Md,ql=a(),re=o("div"),s(lt.$$.fragment),Ml=a(),Va=o("p"),Va.innerHTML=Ed,El=a(),A=o("div"),s(it.$$.fragment),Rl=a(),ja=o("p"),ja.textContent=Rd,Ul=a(),Ka=o("p"),Ka.textContent=Ud,Hl=a(),le=o("div"),s(st.$$.fragment),Sl=a(),Wa=o("p"),Wa.textContent=Hd,Al=a(),ie=o("div"),s(dt.$$.fragment),Vl=a(),Ga=o("p"),Ga.textContent=Sd,jl=a(),V=o("div"),s(ct.$$.fragment),Kl=a(),Ba=o("p"),Ba.innerHTML=Ad,Wl=a(),Ya=o("p"),Ya.textContent=Vd,Gl=a(),se=o("div"),s(mt.$$.fragment),Bl=a(),Za=o("p"),Za.textContent=jd,Yl=a(),de=o("div"),s(pt.$$.fragment),Zl=a(),Ja=o("p"),Ja.textContent=Kd,Jl=a(),ce=o("div"),s(gt.$$.fragment),Ql=a(),Qa=o("p"),Qa.textContent=Wd,Xl=a(),me=o("div"),s(_t.$$.fragment),ei=a(),Xa=o("p"),Xa.innerHTML=Gd,ti=a(),L=o("div"),s(ht.$$.fragment),ai=a(),en=o("p"),en.textContent=Bd,ni=a(),tn=o("p"),tn.textContent=Yd,oi=a(),an=o("p"),an.textContent=Zd,ir=a(),s(ut.$$.fragment),sr=a(),te=o("div"),s(ft.$$.fragment),ri=a(),nn=o("p"),nn.textContent=Jd,dr=a(),s(vt.$$.fragment),cr=a(),D=o("div"),s(bt.$$.fragment),li=a(),on=o("p"),on.innerHTML=Qd,ii=a(),pe=o("div"),s(Tt.$$.fragment),si=a(),rn=o("p"),rn.textContent=Xd,di=a(),ge=o("div"),s(Ot.$$.fragment),ci=a(),ln=o("p"),ln.textContent=ec,mi=a(),z=o("div"),s(xt.$$.fragment),pi=a(),sn=o("p"),sn.textContent=tc,gi=a(),dn=o("p"),dn.textContent=ac,_i=a(),cn=o("ul"),cn.innerHTML=nc,hi=a(),_e=o("div"),s($t.$$.fragment),ui=a(),mn=o("p"),mn.textContent=oc,mr=a(),s(Pt.$$.fragment),pr=a(),b=o("div"),s(wt.$$.fragment),fi=a(),pn=o("p"),pn.textContent=rc,vi=a(),he=o("div"),s(yt.$$.fragment),bi=a(),gn=o("p"),gn.innerHTML=lc,Ti=a(),ue=o("div"),s(Ct.$$.fragment),Oi=a(),_n=o("p"),_n.textContent=ic,xi=a(),j=o("div"),s(kt.$$.fragment),$i=a(),hn=o("p"),hn.textContent=sc,Pi=a(),un=o("p"),un.textContent=dc,wi=a(),fe=o("div"),s(Dt.$$.fragment),yi=a(),fn=o("p"),fn.textContent=cc,Ci=a(),ve=o("div"),s(Nt.$$.fragment),ki=a(),vn=o("p"),vn.textContent=mc,Di=a(),K=o("div"),s(Ft.$$.fragment),Ni=a(),bn=o("p"),bn.innerHTML=pc,Fi=a(),Tn=o("p"),Tn.textContent=gc,Li=a(),be=o("div"),s(Lt.$$.fragment),zi=a(),On=o("p"),On.textContent=_c,Ii=a(),Te=o("div"),s(zt.$$.fragment),qi=a(),xn=o("p"),xn.textContent=hc,Mi=a(),Oe=o("div"),s(It.$$.fragment),Ei=a(),$n=o("p"),$n.textContent=uc,Ri=a(),W=o("div"),s(qt.$$.fragment),Ui=a(),Pn=o("p"),Pn.innerHTML=fc,Hi=a(),wn=o("p"),wn.innerHTML=vc,Si=a(),G=o("div"),s(Mt.$$.fragment),Ai=a(),yn=o("p"),yn.innerHTML=bc,Vi=a(),Cn=o("p"),Cn.innerHTML=Tc,ji=a(),xe=o("div"),s(Et.$$.fragment),Ki=a(),kn=o("p"),kn.innerHTML=Oc,Wi=a(),$e=o("div"),s(Rt.$$.fragment),Gi=a(),Dn=o("p"),Dn.textContent=xc,Bi=a(),I=o("div"),s(Ut.$$.fragment),Yi=a(),Nn=o("p"),Nn.textContent=$c,Zi=a(),Fn=o("p"),Fn.textContent=Pc,Ji=a(),Ln=o("p"),Ln.textContent=wc,gr=a(),s(Ht.$$.fragment),_r=a(),R=o("div"),s(St.$$.fragment),Qi=a(),zn=o("p"),zn.textContent=yc,Xi=a(),Pe=o("div"),s(At.$$.fragment),es=a(),In=o("p"),In.textContent=Cc,hr=a(),s(Vt.$$.fragment),ur=a(),U=o("div"),s(jt.$$.fragment),ts=a(),qn=o("p"),qn.innerHTML=kc,as=a(),Mn=o("p"),Mn.innerHTML=Dc,fr=a(),s(Kt.$$.fragment),vr=a(),$=o("div"),s(Wt.$$.fragment),ns=a(),En=o("p"),En.textContent=Nc,os=a(),we=o("div"),s(Gt.$$.fragment),rs=a(),Rn=o("p"),Rn.textContent=Fc,ls=a(),B=o("div"),s(Bt.$$.fragment),is=a(),Un=o("p"),Un.innerHTML=Lc,ss=a(),Hn=o("p"),Hn.textContent=zc,ds=a(),ye=o("div"),s(Yt.$$.fragment),cs=a(),Sn=o("p"),Sn.textContent=Ic,ms=a(),Ce=o("div"),s(Zt.$$.fragment),ps=a(),An=o("p"),An.textContent=qc,gs=a(),ke=o("div"),s(Jt.$$.fragment),_s=a(),Vn=o("p"),Vn.textContent=Mc,hs=a(),Y=o("div"),s(Qt.$$.fragment),us=a(),jn=o("p"),jn.innerHTML=Ec,fs=a(),Kn=o("p"),Kn.innerHTML=Rc,vs=a(),Z=o("div"),s(Xt.$$.fragment),bs=a(),Wn=o("p"),Wn.innerHTML=Uc,Ts=a(),Gn=o("p"),Gn.innerHTML=Hc,Os=a(),De=o("div"),s(ea.$$.fragment),xs=a(),Bn=o("p"),Bn.textContent=Sc,$s=a(),Ne=o("div"),s(ta.$$.fragment),Ps=a(),Yn=o("p"),Yn.innerHTML=Ac,ws=a(),Fe=o("div"),s(aa.$$.fragment),ys=a(),Zn=o("p"),Zn.textContent=Vc,br=a(),s(na.$$.fragment),Tr=a(),H=o("div"),s(oa.$$.fragment),Cs=a(),Jn=o("p"),Jn.innerHTML=jc,ks=a(),Qn=o("p"),Qn.innerHTML=Kc,Or=a(),s(ra.$$.fragment),xr=a(),P=o("div"),s(la.$$.fragment),Ds=a(),Xn=o("p"),Xn.textContent=Wc,Ns=a(),Le=o("div"),s(ia.$$.fragment),Fs=a(),eo=o("p"),eo.innerHTML=Gc,Ls=a(),J=o("div"),s(sa.$$.fragment),zs=a(),to=o("p"),to.textContent=Bc,Is=a(),ao=o("p"),ao.textContent=Yc,qs=a(),ze=o("div"),s(da.$$.fragment),Ms=a(),no=o("p"),no.textContent=Zc,Es=a(),Q=o("div"),s(ca.$$.fragment),Rs=a(),oo=o("p"),oo.innerHTML=Jc,Us=a(),ro=o("p"),ro.textContent=Qc,Hs=a(),Ie=o("div"),s(ma.$$.fragment),Ss=a(),lo=o("p"),lo.textContent=Xc,As=a(),qe=o("div"),s(pa.$$.fragment),Vs=a(),io=o("p"),io.textContent=em,js=a(),Me=o("div"),s(ga.$$.fragment),Ks=a(),so=o("p"),so.textContent=tm,Ws=a(),Ee=o("div"),s(_a.$$.fragment),Gs=a(),co=o("p"),co.innerHTML=am,Bs=a(),Re=o("div"),s(ha.$$.fragment),Ys=a(),mo=o("p"),mo.textContent=nm,Zs=a(),q=o("div"),s(ua.$$.fragment),Js=a(),po=o("p"),po.textContent=om,Qs=a(),go=o("p"),go.textContent=rm,Xs=a(),_o=o("p"),_o.textContent=lm,$r=a(),s(fa.$$.fragment),Pr=a(),ae=o("div"),s(va.$$.fragment),ed=a(),ho=o("p"),ho.textContent=im,wr=a(),s(ba.$$.fragment),yr=a(),O=o("div"),s(Ta.$$.fragment),td=a(),uo=o("p"),uo.innerHTML=sm,ad=a(),Ue=o("div"),s(Oa.$$.fragment),nd=a(),fo=o("p"),fo.textContent=dm,od=a(),He=o("div"),s(xa.$$.fragment),rd=a(),vo=o("p"),vo.textContent=cm,ld=a(),Se=o("div"),s($a.$$.fragment),id=a(),bo=o("p"),bo.textContent=mm,sd=a(),Ae=o("div"),s(Pa.$$.fragment),dd=a(),To=o("p"),To.textContent=pm,cd=a(),Ve=o("div"),s(wa.$$.fragment),md=a(),Oo=o("p"),Oo.innerHTML=gm,pd=a(),je=o("div"),s(ya.$$.fragment),gd=a(),xo=o("p"),xo.textContent=_m,_d=a(),Ke=o("div"),s(Ca.$$.fragment),hd=a(),$o=o("p"),$o.textContent=hm,ud=a(),We=o("div"),s(ka.$$.fragment),fd=a(),Po=o("p"),Po.textContent=um,vd=a(),Ge=o("div"),s(Da.$$.fragment),bd=a(),wo=o("p"),wo.textContent=fm,Td=a(),Be=o("div"),s(Na.$$.fragment),Od=a(),yo=o("p"),yo.textContent=vm,xd=a(),Ye=o("div"),s(Fa.$$.fragment),$d=a(),Co=o("p"),Co.textContent=bm,Cr=a(),s(La.$$.fragment),kr=a(),S=o("div"),s(za.$$.fragment),Pd=a(),ko=o("p"),ko.innerHTML=Tm,wd=a(),Do=o("p"),Do.innerHTML=Om,Dr=a(),s(Ia.$$.fragment),Nr=a(),F=o("div"),s(qa.$$.fragment),yd=a(),No=o("p"),No.innerHTML=xm,Cd=a(),Fo=o("p"),Fo.innerHTML=$m,kd=a(),Lo=o("ul"),Lo.innerHTML=Pm,Dd=a(),zo=o("p"),zo.innerHTML=wm,Fr=a(),s(Ma.$$.fragment),Lr=a(),ne=o("div"),s(Ea.$$.fragment),Nd=a(),Io=o("p"),Io.innerHTML=ym,zr=a(),s(Ra.$$.fragment),Ir=a(),oe=o("div"),s(Ua.$$.fragment),Fd=a(),qo=o("p"),qo.innerHTML=Cm,qr=a(),Xo=o("p"),this.h()},l(e){const f=zm("svelte-u9bgzb",document.head);ee=r(f,"META",{name:!0,content:!0}),f.forEach(l),er=n(e),Qo=r(e,"P",{}),_(Qo).forEach(l),tr=n(e),d(et.$$.fragment,e),ar=n(e),tt=r(e,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-dxrcnp"&&(tt.innerHTML=zd),nr=n(e),d(at.$$.fragment,e),or=n(e),E=r(e,"DIV",{class:!0});var Mo=_(E);d(nt.$$.fragment,Mo),Ll=n(Mo),Ha=r(Mo,"P",{"data-svelte-h":!0}),i(Ha)!=="svelte-1w6qkim"&&(Ha.innerHTML=Id),zl=n(Mo),Sa=r(Mo,"P",{"data-svelte-h":!0}),i(Sa)!=="svelte-1xl7jqc"&&(Sa.innerHTML=qd),Mo.forEach(l),rr=n(e),d(ot.$$.fragment,e),lr=n(e),x=r(e,"DIV",{class:!0});var y=_(x);d(rt.$$.fragment,y),Il=n(y),Aa=r(y,"P",{"data-svelte-h":!0}),i(Aa)!=="svelte-1qqtmoh"&&(Aa.textContent=Md),ql=n(y),re=r(y,"DIV",{class:!0});var Er=_(re);d(lt.$$.fragment,Er),Ml=n(Er),Va=r(Er,"P",{"data-svelte-h":!0}),i(Va)!=="svelte-mcz8nm"&&(Va.innerHTML=Ed),Er.forEach(l),El=n(y),A=r(y,"DIV",{class:!0});var Eo=_(A);d(it.$$.fragment,Eo),Rl=n(Eo),ja=r(Eo,"P",{"data-svelte-h":!0}),i(ja)!=="svelte-16i1nac"&&(ja.textContent=Rd),Ul=n(Eo),Ka=r(Eo,"P",{"data-svelte-h":!0}),i(Ka)!=="svelte-tgti68"&&(Ka.textContent=Ud),Eo.forEach(l),Hl=n(y),le=r(y,"DIV",{class:!0});var Rr=_(le);d(st.$$.fragment,Rr),Sl=n(Rr),Wa=r(Rr,"P",{"data-svelte-h":!0}),i(Wa)!=="svelte-1cvsgkk"&&(Wa.textContent=Hd),Rr.forEach(l),Al=n(y),ie=r(y,"DIV",{class:!0});var Ur=_(ie);d(dt.$$.fragment,Ur),Vl=n(Ur),Ga=r(Ur,"P",{"data-svelte-h":!0}),i(Ga)!=="svelte-1l2rxe2"&&(Ga.textContent=Sd),Ur.forEach(l),jl=n(y),V=r(y,"DIV",{class:!0});var Ro=_(V);d(ct.$$.fragment,Ro),Kl=n(Ro),Ba=r(Ro,"P",{"data-svelte-h":!0}),i(Ba)!=="svelte-8qlty5"&&(Ba.innerHTML=Ad),Wl=n(Ro),Ya=r(Ro,"P",{"data-svelte-h":!0}),i(Ya)!=="svelte-1tyo99t"&&(Ya.textContent=Vd),Ro.forEach(l),Gl=n(y),se=r(y,"DIV",{class:!0});var Hr=_(se);d(mt.$$.fragment,Hr),Bl=n(Hr),Za=r(Hr,"P",{"data-svelte-h":!0}),i(Za)!=="svelte-4nmimv"&&(Za.textContent=jd),Hr.forEach(l),Yl=n(y),de=r(y,"DIV",{class:!0});var Sr=_(de);d(pt.$$.fragment,Sr),Zl=n(Sr),Ja=r(Sr,"P",{"data-svelte-h":!0}),i(Ja)!=="svelte-4kzfyw"&&(Ja.textContent=Kd),Sr.forEach(l),Jl=n(y),ce=r(y,"DIV",{class:!0});var Ar=_(ce);d(gt.$$.fragment,Ar),Ql=n(Ar),Qa=r(Ar,"P",{"data-svelte-h":!0}),i(Qa)!=="svelte-18uwvbi"&&(Qa.textContent=Wd),Ar.forEach(l),Xl=n(y),me=r(y,"DIV",{class:!0});var Vr=_(me);d(_t.$$.fragment,Vr),ei=n(Vr),Xa=r(Vr,"P",{"data-svelte-h":!0}),i(Xa)!=="svelte-nqksfz"&&(Xa.innerHTML=Gd),Vr.forEach(l),ti=n(y),L=r(y,"DIV",{class:!0});var Ze=_(L);d(ht.$$.fragment,Ze),ai=n(Ze),en=r(Ze,"P",{"data-svelte-h":!0}),i(en)!=="svelte-1a53vwp"&&(en.textContent=Bd),ni=n(Ze),tn=r(Ze,"P",{"data-svelte-h":!0}),i(tn)!=="svelte-1mn1gnw"&&(tn.textContent=Yd),oi=n(Ze),an=r(Ze,"P",{"data-svelte-h":!0}),i(an)!=="svelte-1xvpyih"&&(an.textContent=Zd),Ze.forEach(l),y.forEach(l),ir=n(e),d(ut.$$.fragment,e),sr=n(e),te=r(e,"DIV",{class:!0});var jr=_(te);d(ft.$$.fragment,jr),ri=n(jr),nn=r(jr,"P",{"data-svelte-h":!0}),i(nn)!=="svelte-2zpx1f"&&(nn.textContent=Jd),jr.forEach(l),dr=n(e),d(vt.$$.fragment,e),cr=n(e),D=r(e,"DIV",{class:!0});var M=_(D);d(bt.$$.fragment,M),li=n(M),on=r(M,"P",{"data-svelte-h":!0}),i(on)!=="svelte-8q861t"&&(on.innerHTML=Qd),ii=n(M),pe=r(M,"DIV",{class:!0});var Kr=_(pe);d(Tt.$$.fragment,Kr),si=n(Kr),rn=r(Kr,"P",{"data-svelte-h":!0}),i(rn)!=="svelte-1ag17u3"&&(rn.textContent=Xd),Kr.forEach(l),di=n(M),ge=r(M,"DIV",{class:!0});var Wr=_(ge);d(Ot.$$.fragment,Wr),ci=n(Wr),ln=r(Wr,"P",{"data-svelte-h":!0}),i(ln)!=="svelte-3jfrz9"&&(ln.textContent=ec),Wr.forEach(l),mi=n(M),z=r(M,"DIV",{class:!0});var Je=_(z);d(xt.$$.fragment,Je),pi=n(Je),sn=r(Je,"P",{"data-svelte-h":!0}),i(sn)!=="svelte-r6y15n"&&(sn.textContent=tc),gi=n(Je),dn=r(Je,"P",{"data-svelte-h":!0}),i(dn)!=="svelte-imqqfp"&&(dn.textContent=ac),_i=n(Je),cn=r(Je,"UL",{"data-svelte-h":!0}),i(cn)!=="svelte-105j238"&&(cn.innerHTML=nc),Je.forEach(l),hi=n(M),_e=r(M,"DIV",{class:!0});var Gr=_(_e);d($t.$$.fragment,Gr),ui=n(Gr),mn=r(Gr,"P",{"data-svelte-h":!0}),i(mn)!=="svelte-1an944l"&&(mn.textContent=oc),Gr.forEach(l),M.forEach(l),mr=n(e),d(Pt.$$.fragment,e),pr=n(e),b=r(e,"DIV",{class:!0});var T=_(b);d(wt.$$.fragment,T),fi=n(T),pn=r(T,"P",{"data-svelte-h":!0}),i(pn)!=="svelte-n6cc8y"&&(pn.textContent=rc),vi=n(T),he=r(T,"DIV",{class:!0});var Br=_(he);d(yt.$$.fragment,Br),bi=n(Br),gn=r(Br,"P",{"data-svelte-h":!0}),i(gn)!=="svelte-mcz8nm"&&(gn.innerHTML=lc),Br.forEach(l),Ti=n(T),ue=r(T,"DIV",{class:!0});var Yr=_(ue);d(Ct.$$.fragment,Yr),Oi=n(Yr),_n=r(Yr,"P",{"data-svelte-h":!0}),i(_n)!=="svelte-10t1062"&&(_n.textContent=ic),Yr.forEach(l),xi=n(T),j=r(T,"DIV",{class:!0});var Uo=_(j);d(kt.$$.fragment,Uo),$i=n(Uo),hn=r(Uo,"P",{"data-svelte-h":!0}),i(hn)!=="svelte-16i1nac"&&(hn.textContent=sc),Pi=n(Uo),un=r(Uo,"P",{"data-svelte-h":!0}),i(un)!=="svelte-tgti68"&&(un.textContent=dc),Uo.forEach(l),wi=n(T),fe=r(T,"DIV",{class:!0});var Zr=_(fe);d(Dt.$$.fragment,Zr),yi=n(Zr),fn=r(Zr,"P",{"data-svelte-h":!0}),i(fn)!=="svelte-1cvsgkk"&&(fn.textContent=cc),Zr.forEach(l),Ci=n(T),ve=r(T,"DIV",{class:!0});var Jr=_(ve);d(Nt.$$.fragment,Jr),ki=n(Jr),vn=r(Jr,"P",{"data-svelte-h":!0}),i(vn)!=="svelte-ymgxq7"&&(vn.textContent=mc),Jr.forEach(l),Di=n(T),K=r(T,"DIV",{class:!0});var Ho=_(K);d(Ft.$$.fragment,Ho),Ni=n(Ho),bn=r(Ho,"P",{"data-svelte-h":!0}),i(bn)!=="svelte-8qlty5"&&(bn.innerHTML=pc),Fi=n(Ho),Tn=r(Ho,"P",{"data-svelte-h":!0}),i(Tn)!=="svelte-1tyo99t"&&(Tn.textContent=gc),Ho.forEach(l),Li=n(T),be=r(T,"DIV",{class:!0});var Qr=_(be);d(Lt.$$.fragment,Qr),zi=n(Qr),On=r(Qr,"P",{"data-svelte-h":!0}),i(On)!=="svelte-4nmimv"&&(On.textContent=_c),Qr.forEach(l),Ii=n(T),Te=r(T,"DIV",{class:!0});var Xr=_(Te);d(zt.$$.fragment,Xr),qi=n(Xr),xn=r(Xr,"P",{"data-svelte-h":!0}),i(xn)!=="svelte-11q8u7l"&&(xn.textContent=hc),Xr.forEach(l),Mi=n(T),Oe=r(T,"DIV",{class:!0});var el=_(Oe);d(It.$$.fragment,el),Ei=n(el),$n=r(el,"P",{"data-svelte-h":!0}),i($n)!=="svelte-18uwvbi"&&($n.textContent=uc),el.forEach(l),Ri=n(T),W=r(T,"DIV",{class:!0});var So=_(W);d(qt.$$.fragment,So),Ui=n(So),Pn=r(So,"P",{"data-svelte-h":!0}),i(Pn)!=="svelte-xesobz"&&(Pn.innerHTML=fc),Hi=n(So),wn=r(So,"P",{"data-svelte-h":!0}),i(wn)!=="svelte-qg43tm"&&(wn.innerHTML=vc),So.forEach(l),Si=n(T),G=r(T,"DIV",{class:!0});var Ao=_(G);d(Mt.$$.fragment,Ao),Ai=n(Ao),yn=r(Ao,"P",{"data-svelte-h":!0}),i(yn)!=="svelte-dkae9b"&&(yn.innerHTML=bc),Vi=n(Ao),Cn=r(Ao,"P",{"data-svelte-h":!0}),i(Cn)!=="svelte-hmd5cw"&&(Cn.innerHTML=Tc),Ao.forEach(l),ji=n(T),xe=r(T,"DIV",{class:!0});var tl=_(xe);d(Et.$$.fragment,tl),Ki=n(tl),kn=r(tl,"P",{"data-svelte-h":!0}),i(kn)!=="svelte-nqksfz"&&(kn.innerHTML=Oc),tl.forEach(l),Wi=n(T),$e=r(T,"DIV",{class:!0});var al=_($e);d(Rt.$$.fragment,al),Gi=n(al),Dn=r(al,"P",{"data-svelte-h":!0}),i(Dn)!=="svelte-17kjsy4"&&(Dn.textContent=xc),al.forEach(l),Bi=n(T),I=r(T,"DIV",{class:!0});var Qe=_(I);d(Ut.$$.fragment,Qe),Yi=n(Qe),Nn=r(Qe,"P",{"data-svelte-h":!0}),i(Nn)!=="svelte-1861yti"&&(Nn.textContent=$c),Zi=n(Qe),Fn=r(Qe,"P",{"data-svelte-h":!0}),i(Fn)!=="svelte-1mn1gnw"&&(Fn.textContent=Pc),Ji=n(Qe),Ln=r(Qe,"P",{"data-svelte-h":!0}),i(Ln)!=="svelte-1xvpyih"&&(Ln.textContent=wc),Qe.forEach(l),T.forEach(l),gr=n(e),d(Ht.$$.fragment,e),_r=n(e),R=r(e,"DIV",{class:!0});var Vo=_(R);d(St.$$.fragment,Vo),Qi=n(Vo),zn=r(Vo,"P",{"data-svelte-h":!0}),i(zn)!=="svelte-xqyw6w"&&(zn.textContent=yc),Xi=n(Vo),Pe=r(Vo,"DIV",{class:!0});var nl=_(Pe);d(At.$$.fragment,nl),es=n(nl),In=r(nl,"P",{"data-svelte-h":!0}),i(In)!=="svelte-v7dhdf"&&(In.textContent=Cc),nl.forEach(l),Vo.forEach(l),hr=n(e),d(Vt.$$.fragment,e),ur=n(e),U=r(e,"DIV",{class:!0});var jo=_(U);d(jt.$$.fragment,jo),ts=n(jo),qn=r(jo,"P",{"data-svelte-h":!0}),i(qn)!=="svelte-1anbnaa"&&(qn.innerHTML=kc),as=n(jo),Mn=r(jo,"P",{"data-svelte-h":!0}),i(Mn)!=="svelte-1xl7jqc"&&(Mn.innerHTML=Dc),jo.forEach(l),fr=n(e),d(Kt.$$.fragment,e),vr=n(e),$=r(e,"DIV",{class:!0});var C=_($);d(Wt.$$.fragment,C),ns=n(C),En=r(C,"P",{"data-svelte-h":!0}),i(En)!=="svelte-hyhzxp"&&(En.textContent=Nc),os=n(C),we=r(C,"DIV",{class:!0});var ol=_(we);d(Gt.$$.fragment,ol),rs=n(ol),Rn=r(ol,"P",{"data-svelte-h":!0}),i(Rn)!=="svelte-pt6g01"&&(Rn.textContent=Fc),ol.forEach(l),ls=n(C),B=r(C,"DIV",{class:!0});var Ko=_(B);d(Bt.$$.fragment,Ko),is=n(Ko),Un=r(Ko,"P",{"data-svelte-h":!0}),i(Un)!=="svelte-8qlty5"&&(Un.innerHTML=Lc),ss=n(Ko),Hn=r(Ko,"P",{"data-svelte-h":!0}),i(Hn)!=="svelte-1tyo99t"&&(Hn.textContent=zc),Ko.forEach(l),ds=n(C),ye=r(C,"DIV",{class:!0});var rl=_(ye);d(Yt.$$.fragment,rl),cs=n(rl),Sn=r(rl,"P",{"data-svelte-h":!0}),i(Sn)!=="svelte-4nmimv"&&(Sn.textContent=Ic),rl.forEach(l),ms=n(C),Ce=r(C,"DIV",{class:!0});var ll=_(Ce);d(Zt.$$.fragment,ll),ps=n(ll),An=r(ll,"P",{"data-svelte-h":!0}),i(An)!=="svelte-db7iek"&&(An.textContent=qc),ll.forEach(l),gs=n(C),ke=r(C,"DIV",{class:!0});var il=_(ke);d(Jt.$$.fragment,il),_s=n(il),Vn=r(il,"P",{"data-svelte-h":!0}),i(Vn)!=="svelte-18uwvbi"&&(Vn.textContent=Mc),il.forEach(l),hs=n(C),Y=r(C,"DIV",{class:!0});var Wo=_(Y);d(Qt.$$.fragment,Wo),us=n(Wo),jn=r(Wo,"P",{"data-svelte-h":!0}),i(jn)!=="svelte-xesobz"&&(jn.innerHTML=Ec),fs=n(Wo),Kn=r(Wo,"P",{"data-svelte-h":!0}),i(Kn)!=="svelte-qg43tm"&&(Kn.innerHTML=Rc),Wo.forEach(l),vs=n(C),Z=r(C,"DIV",{class:!0});var Go=_(Z);d(Xt.$$.fragment,Go),bs=n(Go),Wn=r(Go,"P",{"data-svelte-h":!0}),i(Wn)!=="svelte-dkae9b"&&(Wn.innerHTML=Uc),Ts=n(Go),Gn=r(Go,"P",{"data-svelte-h":!0}),i(Gn)!=="svelte-hmd5cw"&&(Gn.innerHTML=Hc),Go.forEach(l),Os=n(C),De=r(C,"DIV",{class:!0});var sl=_(De);d(ea.$$.fragment,sl),xs=n(sl),Bn=r(sl,"P",{"data-svelte-h":!0}),i(Bn)!=="svelte-svckwe"&&(Bn.textContent=Sc),sl.forEach(l),$s=n(C),Ne=r(C,"DIV",{class:!0});var dl=_(Ne);d(ta.$$.fragment,dl),Ps=n(dl),Yn=r(dl,"P",{"data-svelte-h":!0}),i(Yn)!=="svelte-nqksfz"&&(Yn.innerHTML=Ac),dl.forEach(l),ws=n(C),Fe=r(C,"DIV",{class:!0});var cl=_(Fe);d(aa.$$.fragment,cl),ys=n(cl),Zn=r(cl,"P",{"data-svelte-h":!0}),i(Zn)!=="svelte-17kjsy4"&&(Zn.textContent=Vc),cl.forEach(l),C.forEach(l),br=n(e),d(na.$$.fragment,e),Tr=n(e),H=r(e,"DIV",{class:!0});var Bo=_(H);d(oa.$$.fragment,Bo),Cs=n(Bo),Jn=r(Bo,"P",{"data-svelte-h":!0}),i(Jn)!=="svelte-t2n6nv"&&(Jn.innerHTML=jc),ks=n(Bo),Qn=r(Bo,"P",{"data-svelte-h":!0}),i(Qn)!=="svelte-1xl7jqc"&&(Qn.innerHTML=Kc),Bo.forEach(l),Or=n(e),d(ra.$$.fragment,e),xr=n(e),P=r(e,"DIV",{class:!0});var k=_(P);d(la.$$.fragment,k),Ds=n(k),Xn=r(k,"P",{"data-svelte-h":!0}),i(Xn)!=="svelte-1ggwo37"&&(Xn.textContent=Wc),Ns=n(k),Le=r(k,"DIV",{class:!0});var ml=_(Le);d(ia.$$.fragment,ml),Fs=n(ml),eo=r(ml,"P",{"data-svelte-h":!0}),i(eo)!=="svelte-mcz8nm"&&(eo.innerHTML=Gc),ml.forEach(l),Ls=n(k),J=r(k,"DIV",{class:!0});var Yo=_(J);d(sa.$$.fragment,Yo),zs=n(Yo),to=r(Yo,"P",{"data-svelte-h":!0}),i(to)!=="svelte-16i1nac"&&(to.textContent=Bc),Is=n(Yo),ao=r(Yo,"P",{"data-svelte-h":!0}),i(ao)!=="svelte-tgti68"&&(ao.textContent=Yc),Yo.forEach(l),qs=n(k),ze=r(k,"DIV",{class:!0});var pl=_(ze);d(da.$$.fragment,pl),Ms=n(pl),no=r(pl,"P",{"data-svelte-h":!0}),i(no)!=="svelte-1cvsgkk"&&(no.textContent=Zc),pl.forEach(l),Es=n(k),Q=r(k,"DIV",{class:!0});var Zo=_(Q);d(ca.$$.fragment,Zo),Rs=n(Zo),oo=r(Zo,"P",{"data-svelte-h":!0}),i(oo)!=="svelte-8qlty5"&&(oo.innerHTML=Jc),Us=n(Zo),ro=r(Zo,"P",{"data-svelte-h":!0}),i(ro)!=="svelte-1tyo99t"&&(ro.textContent=Qc),Zo.forEach(l),Hs=n(k),Ie=r(k,"DIV",{class:!0});var gl=_(Ie);d(ma.$$.fragment,gl),Ss=n(gl),lo=r(gl,"P",{"data-svelte-h":!0}),i(lo)!=="svelte-4nmimv"&&(lo.textContent=Xc),gl.forEach(l),As=n(k),qe=r(k,"DIV",{class:!0});var _l=_(qe);d(pa.$$.fragment,_l),Vs=n(_l),io=r(_l,"P",{"data-svelte-h":!0}),i(io)!=="svelte-ndgk7s"&&(io.textContent=em),_l.forEach(l),js=n(k),Me=r(k,"DIV",{class:!0});var hl=_(Me);d(ga.$$.fragment,hl),Ks=n(hl),so=r(hl,"P",{"data-svelte-h":!0}),i(so)!=="svelte-18uwvbi"&&(so.textContent=tm),hl.forEach(l),Ws=n(k),Ee=r(k,"DIV",{class:!0});var ul=_(Ee);d(_a.$$.fragment,ul),Gs=n(ul),co=r(ul,"P",{"data-svelte-h":!0}),i(co)!=="svelte-nqksfz"&&(co.innerHTML=am),ul.forEach(l),Bs=n(k),Re=r(k,"DIV",{class:!0});var fl=_(Re);d(ha.$$.fragment,fl),Ys=n(fl),mo=r(fl,"P",{"data-svelte-h":!0}),i(mo)!=="svelte-y2dr0o"&&(mo.textContent=nm),fl.forEach(l),Zs=n(k),q=r(k,"DIV",{class:!0});var Xe=_(q);d(ua.$$.fragment,Xe),Js=n(Xe),po=r(Xe,"P",{"data-svelte-h":!0}),i(po)!=="svelte-xlsvih"&&(po.textContent=om),Qs=n(Xe),go=r(Xe,"P",{"data-svelte-h":!0}),i(go)!=="svelte-1mn1gnw"&&(go.textContent=rm),Xs=n(Xe),_o=r(Xe,"P",{"data-svelte-h":!0}),i(_o)!=="svelte-1xvpyih"&&(_o.textContent=lm),Xe.forEach(l),k.forEach(l),$r=n(e),d(fa.$$.fragment,e),Pr=n(e),ae=r(e,"DIV",{class:!0});var vl=_(ae);d(va.$$.fragment,vl),ed=n(vl),ho=r(vl,"P",{"data-svelte-h":!0}),i(ho)!=="svelte-aondqr"&&(ho.textContent=im),vl.forEach(l),wr=n(e),d(ba.$$.fragment,e),yr=n(e),O=r(e,"DIV",{class:!0});var w=_(O);d(Ta.$$.fragment,w),td=n(w),uo=r(w,"P",{"data-svelte-h":!0}),i(uo)!=="svelte-hys9rl"&&(uo.innerHTML=sm),ad=n(w),Ue=r(w,"DIV",{class:!0});var bl=_(Ue);d(Oa.$$.fragment,bl),nd=n(bl),fo=r(bl,"P",{"data-svelte-h":!0}),i(fo)!=="svelte-185nst0"&&(fo.textContent=dm),bl.forEach(l),od=n(w),He=r(w,"DIV",{class:!0});var Tl=_(He);d(xa.$$.fragment,Tl),rd=n(Tl),vo=r(Tl,"P",{"data-svelte-h":!0}),i(vo)!=="svelte-3nt516"&&(vo.textContent=cm),Tl.forEach(l),ld=n(w),Se=r(w,"DIV",{class:!0});var Ol=_(Se);d($a.$$.fragment,Ol),id=n(Ol),bo=r(Ol,"P",{"data-svelte-h":!0}),i(bo)!=="svelte-3jfrz9"&&(bo.textContent=mm),Ol.forEach(l),sd=n(w),Ae=r(w,"DIV",{class:!0});var xl=_(Ae);d(Pa.$$.fragment,xl),dd=n(xl),To=r(xl,"P",{"data-svelte-h":!0}),i(To)!=="svelte-lcc1u3"&&(To.textContent=pm),xl.forEach(l),cd=n(w),Ve=r(w,"DIV",{class:!0});var $l=_(Ve);d(wa.$$.fragment,$l),md=n($l),Oo=r($l,"P",{"data-svelte-h":!0}),i(Oo)!=="svelte-1gqqzmu"&&(Oo.innerHTML=gm),$l.forEach(l),pd=n(w),je=r(w,"DIV",{class:!0});var Pl=_(je);d(ya.$$.fragment,Pl),gd=n(Pl),xo=r(Pl,"P",{"data-svelte-h":!0}),i(xo)!=="svelte-ffqz5"&&(xo.textContent=_m),Pl.forEach(l),_d=n(w),Ke=r(w,"DIV",{class:!0});var wl=_(Ke);d(Ca.$$.fragment,wl),hd=n(wl),$o=r(wl,"P",{"data-svelte-h":!0}),i($o)!=="svelte-febvhf"&&($o.textContent=hm),wl.forEach(l),ud=n(w),We=r(w,"DIV",{class:!0});var yl=_(We);d(ka.$$.fragment,yl),fd=n(yl),Po=r(yl,"P",{"data-svelte-h":!0}),i(Po)!=="svelte-1hbodkw"&&(Po.textContent=um),yl.forEach(l),vd=n(w),Ge=r(w,"DIV",{class:!0});var Cl=_(Ge);d(Da.$$.fragment,Cl),bd=n(Cl),wo=r(Cl,"P",{"data-svelte-h":!0}),i(wo)!=="svelte-1hfgx92"&&(wo.textContent=fm),Cl.forEach(l),Td=n(w),Be=r(w,"DIV",{class:!0});var kl=_(Be);d(Na.$$.fragment,kl),Od=n(kl),yo=r(kl,"P",{"data-svelte-h":!0}),i(yo)!=="svelte-yrsdu6"&&(yo.textContent=vm),kl.forEach(l),xd=n(w),Ye=r(w,"DIV",{class:!0});var Dl=_(Ye);d(Fa.$$.fragment,Dl),$d=n(Dl),Co=r(Dl,"P",{"data-svelte-h":!0}),i(Co)!=="svelte-3k7k5e"&&(Co.textContent=bm),Dl.forEach(l),w.forEach(l),Cr=n(e),d(La.$$.fragment,e),kr=n(e),S=r(e,"DIV",{class:!0});var Jo=_(S);d(za.$$.fragment,Jo),Pd=n(Jo),ko=r(Jo,"P",{"data-svelte-h":!0}),i(ko)!=="svelte-u4tkv1"&&(ko.innerHTML=Tm),wd=n(Jo),Do=r(Jo,"P",{"data-svelte-h":!0}),i(Do)!=="svelte-1xl7jqc"&&(Do.innerHTML=Om),Jo.forEach(l),Dr=n(e),d(Ia.$$.fragment,e),Nr=n(e),F=r(e,"DIV",{class:!0});var X=_(F);d(qa.$$.fragment,X),yd=n(X),No=r(X,"P",{"data-svelte-h":!0}),i(No)!=="svelte-qafafj"&&(No.innerHTML=xm),Cd=n(X),Fo=r(X,"P",{"data-svelte-h":!0}),i(Fo)!=="svelte-bkmbwh"&&(Fo.innerHTML=$m),kd=n(X),Lo=r(X,"UL",{"data-svelte-h":!0}),i(Lo)!=="svelte-1ytuxgw"&&(Lo.innerHTML=Pm),Dd=n(X),zo=r(X,"P",{"data-svelte-h":!0}),i(zo)!=="svelte-18tbp4c"&&(zo.innerHTML=wm),X.forEach(l),Fr=n(e),d(Ma.$$.fragment,e),Lr=n(e),ne=r(e,"DIV",{class:!0});var Nl=_(ne);d(Ea.$$.fragment,Nl),Nd=n(Nl),Io=r(Nl,"P",{"data-svelte-h":!0}),i(Io)!=="svelte-14oyph8"&&(Io.innerHTML=ym),Nl.forEach(l),zr=n(e),d(Ra.$$.fragment,e),Ir=n(e),oe=r(e,"DIV",{class:!0});var Fl=_(oe);d(Ua.$$.fragment,Fl),Fd=n(Fl),qo=r(Fl,"P",{"data-svelte-h":!0}),i(qo)!=="svelte-1aeuhep"&&(qo.innerHTML=Cm),Fl.forEach(l),qr=n(e),Xo=r(e,"P",{}),_(Xo).forEach(l),this.h()},h(){h(ee,"name","hf:doc:metadata"),h(ee,"content",qm),h(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){t(document.head,ee),v(e,er,f),v(e,Qo,f),v(e,tr,f),c(et,e,f),v(e,ar,f),v(e,tt,f),v(e,nr,f),c(at,e,f),v(e,or,f),v(e,E,f),c(nt,E,null),t(E,Ll),t(E,Ha),t(E,zl),t(E,Sa),v(e,rr,f),c(ot,e,f),v(e,lr,f),v(e,x,f),c(rt,x,null),t(x,Il),t(x,Aa),t(x,ql),t(x,re),c(lt,re,null),t(re,Ml),t(re,Va),t(x,El),t(x,A),c(it,A,null),t(A,Rl),t(A,ja),t(A,Ul),t(A,Ka),t(x,Hl),t(x,le),c(st,le,null),t(le,Sl),t(le,Wa),t(x,Al),t(x,ie),c(dt,ie,null),t(ie,Vl),t(ie,Ga),t(x,jl),t(x,V),c(ct,V,null),t(V,Kl),t(V,Ba),t(V,Wl),t(V,Ya),t(x,Gl),t(x,se),c(mt,se,null),t(se,Bl),t(se,Za),t(x,Yl),t(x,de),c(pt,de,null),t(de,Zl),t(de,Ja),t(x,Jl),t(x,ce),c(gt,ce,null),t(ce,Ql),t(ce,Qa),t(x,Xl),t(x,me),c(_t,me,null),t(me,ei),t(me,Xa),t(x,ti),t(x,L),c(ht,L,null),t(L,ai),t(L,en),t(L,ni),t(L,tn),t(L,oi),t(L,an),v(e,ir,f),c(ut,e,f),v(e,sr,f),v(e,te,f),c(ft,te,null),t(te,ri),t(te,nn),v(e,dr,f),c(vt,e,f),v(e,cr,f),v(e,D,f),c(bt,D,null),t(D,li),t(D,on),t(D,ii),t(D,pe),c(Tt,pe,null),t(pe,si),t(pe,rn),t(D,di),t(D,ge),c(Ot,ge,null),t(ge,ci),t(ge,ln),t(D,mi),t(D,z),c(xt,z,null),t(z,pi),t(z,sn),t(z,gi),t(z,dn),t(z,_i),t(z,cn),t(D,hi),t(D,_e),c($t,_e,null),t(_e,ui),t(_e,mn),v(e,mr,f),c(Pt,e,f),v(e,pr,f),v(e,b,f),c(wt,b,null),t(b,fi),t(b,pn),t(b,vi),t(b,he),c(yt,he,null),t(he,bi),t(he,gn),t(b,Ti),t(b,ue),c(Ct,ue,null),t(ue,Oi),t(ue,_n),t(b,xi),t(b,j),c(kt,j,null),t(j,$i),t(j,hn),t(j,Pi),t(j,un),t(b,wi),t(b,fe),c(Dt,fe,null),t(fe,yi),t(fe,fn),t(b,Ci),t(b,ve),c(Nt,ve,null),t(ve,ki),t(ve,vn),t(b,Di),t(b,K),c(Ft,K,null),t(K,Ni),t(K,bn),t(K,Fi),t(K,Tn),t(b,Li),t(b,be),c(Lt,be,null),t(be,zi),t(be,On),t(b,Ii),t(b,Te),c(zt,Te,null),t(Te,qi),t(Te,xn),t(b,Mi),t(b,Oe),c(It,Oe,null),t(Oe,Ei),t(Oe,$n),t(b,Ri),t(b,W),c(qt,W,null),t(W,Ui),t(W,Pn),t(W,Hi),t(W,wn),t(b,Si),t(b,G),c(Mt,G,null),t(G,Ai),t(G,yn),t(G,Vi),t(G,Cn),t(b,ji),t(b,xe),c(Et,xe,null),t(xe,Ki),t(xe,kn),t(b,Wi),t(b,$e),c(Rt,$e,null),t($e,Gi),t($e,Dn),t(b,Bi),t(b,I),c(Ut,I,null),t(I,Yi),t(I,Nn),t(I,Zi),t(I,Fn),t(I,Ji),t(I,Ln),v(e,gr,f),c(Ht,e,f),v(e,_r,f),v(e,R,f),c(St,R,null),t(R,Qi),t(R,zn),t(R,Xi),t(R,Pe),c(At,Pe,null),t(Pe,es),t(Pe,In),v(e,hr,f),c(Vt,e,f),v(e,ur,f),v(e,U,f),c(jt,U,null),t(U,ts),t(U,qn),t(U,as),t(U,Mn),v(e,fr,f),c(Kt,e,f),v(e,vr,f),v(e,$,f),c(Wt,$,null),t($,ns),t($,En),t($,os),t($,we),c(Gt,we,null),t(we,rs),t(we,Rn),t($,ls),t($,B),c(Bt,B,null),t(B,is),t(B,Un),t(B,ss),t(B,Hn),t($,ds),t($,ye),c(Yt,ye,null),t(ye,cs),t(ye,Sn),t($,ms),t($,Ce),c(Zt,Ce,null),t(Ce,ps),t(Ce,An),t($,gs),t($,ke),c(Jt,ke,null),t(ke,_s),t(ke,Vn),t($,hs),t($,Y),c(Qt,Y,null),t(Y,us),t(Y,jn),t(Y,fs),t(Y,Kn),t($,vs),t($,Z),c(Xt,Z,null),t(Z,bs),t(Z,Wn),t(Z,Ts),t(Z,Gn),t($,Os),t($,De),c(ea,De,null),t(De,xs),t(De,Bn),t($,$s),t($,Ne),c(ta,Ne,null),t(Ne,Ps),t(Ne,Yn),t($,ws),t($,Fe),c(aa,Fe,null),t(Fe,ys),t(Fe,Zn),v(e,br,f),c(na,e,f),v(e,Tr,f),v(e,H,f),c(oa,H,null),t(H,Cs),t(H,Jn),t(H,ks),t(H,Qn),v(e,Or,f),c(ra,e,f),v(e,xr,f),v(e,P,f),c(la,P,null),t(P,Ds),t(P,Xn),t(P,Ns),t(P,Le),c(ia,Le,null),t(Le,Fs),t(Le,eo),t(P,Ls),t(P,J),c(sa,J,null),t(J,zs),t(J,to),t(J,Is),t(J,ao),t(P,qs),t(P,ze),c(da,ze,null),t(ze,Ms),t(ze,no),t(P,Es),t(P,Q),c(ca,Q,null),t(Q,Rs),t(Q,oo),t(Q,Us),t(Q,ro),t(P,Hs),t(P,Ie),c(ma,Ie,null),t(Ie,Ss),t(Ie,lo),t(P,As),t(P,qe),c(pa,qe,null),t(qe,Vs),t(qe,io),t(P,js),t(P,Me),c(ga,Me,null),t(Me,Ks),t(Me,so),t(P,Ws),t(P,Ee),c(_a,Ee,null),t(Ee,Gs),t(Ee,co),t(P,Bs),t(P,Re),c(ha,Re,null),t(Re,Ys),t(Re,mo),t(P,Zs),t(P,q),c(ua,q,null),t(q,Js),t(q,po),t(q,Qs),t(q,go),t(q,Xs),t(q,_o),v(e,$r,f),c(fa,e,f),v(e,Pr,f),v(e,ae,f),c(va,ae,null),t(ae,ed),t(ae,ho),v(e,wr,f),c(ba,e,f),v(e,yr,f),v(e,O,f),c(Ta,O,null),t(O,td),t(O,uo),t(O,ad),t(O,Ue),c(Oa,Ue,null),t(Ue,nd),t(Ue,fo),t(O,od),t(O,He),c(xa,He,null),t(He,rd),t(He,vo),t(O,ld),t(O,Se),c($a,Se,null),t(Se,id),t(Se,bo),t(O,sd),t(O,Ae),c(Pa,Ae,null),t(Ae,dd),t(Ae,To),t(O,cd),t(O,Ve),c(wa,Ve,null),t(Ve,md),t(Ve,Oo),t(O,pd),t(O,je),c(ya,je,null),t(je,gd),t(je,xo),t(O,_d),t(O,Ke),c(Ca,Ke,null),t(Ke,hd),t(Ke,$o),t(O,ud),t(O,We),c(ka,We,null),t(We,fd),t(We,Po),t(O,vd),t(O,Ge),c(Da,Ge,null),t(Ge,bd),t(Ge,wo),t(O,Td),t(O,Be),c(Na,Be,null),t(Be,Od),t(Be,yo),t(O,xd),t(O,Ye),c(Fa,Ye,null),t(Ye,$d),t(Ye,Co),v(e,Cr,f),c(La,e,f),v(e,kr,f),v(e,S,f),c(za,S,null),t(S,Pd),t(S,ko),t(S,wd),t(S,Do),v(e,Dr,f),c(Ia,e,f),v(e,Nr,f),v(e,F,f),c(qa,F,null),t(F,yd),t(F,No),t(F,Cd),t(F,Fo),t(F,kd),t(F,Lo),t(F,Dd),t(F,zo),v(e,Fr,f),c(Ma,e,f),v(e,Lr,f),v(e,ne,f),c(Ea,ne,null),t(ne,Nd),t(ne,Io),v(e,zr,f),c(Ra,e,f),v(e,Ir,f),v(e,oe,f),c(Ua,oe,null),t(oe,Fd),t(oe,qo),v(e,qr,f),v(e,Xo,f),Mr=!0},p:Dm,i(e){Mr||(m(et.$$.fragment,e),m(at.$$.fragment,e),m(nt.$$.fragment,e),m(ot.$$.fragment,e),m(rt.$$.fragment,e),m(lt.$$.fragment,e),m(it.$$.fragment,e),m(st.$$.fragment,e),m(dt.$$.fragment,e),m(ct.$$.fragment,e),m(mt.$$.fragment,e),m(pt.$$.fragment,e),m(gt.$$.fragment,e),m(_t.$$.fragment,e),m(ht.$$.fragment,e),m(ut.$$.fragment,e),m(ft.$$.fragment,e),m(vt.$$.fragment,e),m(bt.$$.fragment,e),m(Tt.$$.fragment,e),m(Ot.$$.fragment,e),m(xt.$$.fragment,e),m($t.$$.fragment,e),m(Pt.$$.fragment,e),m(wt.$$.fragment,e),m(yt.$$.fragment,e),m(Ct.$$.fragment,e),m(kt.$$.fragment,e),m(Dt.$$.fragment,e),m(Nt.$$.fragment,e),m(Ft.$$.fragment,e),m(Lt.$$.fragment,e),m(zt.$$.fragment,e),m(It.$$.fragment,e),m(qt.$$.fragment,e),m(Mt.$$.fragment,e),m(Et.$$.fragment,e),m(Rt.$$.fragment,e),m(Ut.$$.fragment,e),m(Ht.$$.fragment,e),m(St.$$.fragment,e),m(At.$$.fragment,e),m(Vt.$$.fragment,e),m(jt.$$.fragment,e),m(Kt.$$.fragment,e),m(Wt.$$.fragment,e),m(Gt.$$.fragment,e),m(Bt.$$.fragment,e),m(Yt.$$.fragment,e),m(Zt.$$.fragment,e),m(Jt.$$.fragment,e),m(Qt.$$.fragment,e),m(Xt.$$.fragment,e),m(ea.$$.fragment,e),m(ta.$$.fragment,e),m(aa.$$.fragment,e),m(na.$$.fragment,e),m(oa.$$.fragment,e),m(ra.$$.fragment,e),m(la.$$.fragment,e),m(ia.$$.fragment,e),m(sa.$$.fragment,e),m(da.$$.fragment,e),m(ca.$$.fragment,e),m(ma.$$.fragment,e),m(pa.$$.fragment,e),m(ga.$$.fragment,e),m(_a.$$.fragment,e),m(ha.$$.fragment,e),m(ua.$$.fragment,e),m(fa.$$.fragment,e),m(va.$$.fragment,e),m(ba.$$.fragment,e),m(Ta.$$.fragment,e),m(Oa.$$.fragment,e),m(xa.$$.fragment,e),m($a.$$.fragment,e),m(Pa.$$.fragment,e),m(wa.$$.fragment,e),m(ya.$$.fragment,e),m(Ca.$$.fragment,e),m(ka.$$.fragment,e),m(Da.$$.fragment,e),m(Na.$$.fragment,e),m(Fa.$$.fragment,e),m(La.$$.fragment,e),m(za.$$.fragment,e),m(Ia.$$.fragment,e),m(qa.$$.fragment,e),m(Ma.$$.fragment,e),m(Ea.$$.fragment,e),m(Ra.$$.fragment,e),m(Ua.$$.fragment,e),Mr=!0)},o(e){p(et.$$.fragment,e),p(at.$$.fragment,e),p(nt.$$.fragment,e),p(ot.$$.fragment,e),p(rt.$$.fragment,e),p(lt.$$.fragment,e),p(it.$$.fragment,e),p(st.$$.fragment,e),p(dt.$$.fragment,e),p(ct.$$.fragment,e),p(mt.$$.fragment,e),p(pt.$$.fragment,e),p(gt.$$.fragment,e),p(_t.$$.fragment,e),p(ht.$$.fragment,e),p(ut.$$.fragment,e),p(ft.$$.fragment,e),p(vt.$$.fragment,e),p(bt.$$.fragment,e),p(Tt.$$.fragment,e),p(Ot.$$.fragment,e),p(xt.$$.fragment,e),p($t.$$.fragment,e),p(Pt.$$.fragment,e),p(wt.$$.fragment,e),p(yt.$$.fragment,e),p(Ct.$$.fragment,e),p(kt.$$.fragment,e),p(Dt.$$.fragment,e),p(Nt.$$.fragment,e),p(Ft.$$.fragment,e),p(Lt.$$.fragment,e),p(zt.$$.fragment,e),p(It.$$.fragment,e),p(qt.$$.fragment,e),p(Mt.$$.fragment,e),p(Et.$$.fragment,e),p(Rt.$$.fragment,e),p(Ut.$$.fragment,e),p(Ht.$$.fragment,e),p(St.$$.fragment,e),p(At.$$.fragment,e),p(Vt.$$.fragment,e),p(jt.$$.fragment,e),p(Kt.$$.fragment,e),p(Wt.$$.fragment,e),p(Gt.$$.fragment,e),p(Bt.$$.fragment,e),p(Yt.$$.fragment,e),p(Zt.$$.fragment,e),p(Jt.$$.fragment,e),p(Qt.$$.fragment,e),p(Xt.$$.fragment,e),p(ea.$$.fragment,e),p(ta.$$.fragment,e),p(aa.$$.fragment,e),p(na.$$.fragment,e),p(oa.$$.fragment,e),p(ra.$$.fragment,e),p(la.$$.fragment,e),p(ia.$$.fragment,e),p(sa.$$.fragment,e),p(da.$$.fragment,e),p(ca.$$.fragment,e),p(ma.$$.fragment,e),p(pa.$$.fragment,e),p(ga.$$.fragment,e),p(_a.$$.fragment,e),p(ha.$$.fragment,e),p(ua.$$.fragment,e),p(fa.$$.fragment,e),p(va.$$.fragment,e),p(ba.$$.fragment,e),p(Ta.$$.fragment,e),p(Oa.$$.fragment,e),p(xa.$$.fragment,e),p($a.$$.fragment,e),p(Pa.$$.fragment,e),p(wa.$$.fragment,e),p(ya.$$.fragment,e),p(Ca.$$.fragment,e),p(ka.$$.fragment,e),p(Da.$$.fragment,e),p(Na.$$.fragment,e),p(Fa.$$.fragment,e),p(La.$$.fragment,e),p(za.$$.fragment,e),p(Ia.$$.fragment,e),p(qa.$$.fragment,e),p(Ma.$$.fragment,e),p(Ea.$$.fragment,e),p(Ra.$$.fragment,e),p(Ua.$$.fragment,e),Mr=!1},d(e){e&&(l(er),l(Qo),l(tr),l(ar),l(tt),l(nr),l(or),l(E),l(rr),l(lr),l(x),l(ir),l(sr),l(te),l(dr),l(cr),l(D),l(mr),l(pr),l(b),l(gr),l(_r),l(R),l(hr),l(ur),l(U),l(fr),l(vr),l($),l(br),l(Tr),l(H),l(Or),l(xr),l(P),l($r),l(Pr),l(ae),l(wr),l(yr),l(O),l(Cr),l(kr),l(S),l(Dr),l(Nr),l(F),l(Fr),l(Lr),l(ne),l(zr),l(Ir),l(oe),l(qr),l(Xo)),l(ee),g(et,e),g(at,e),g(nt),g(ot,e),g(rt),g(lt),g(it),g(st),g(dt),g(ct),g(mt),g(pt),g(gt),g(_t),g(ht),g(ut,e),g(ft),g(vt,e),g(bt),g(Tt),g(Ot),g(xt),g($t),g(Pt,e),g(wt),g(yt),g(Ct),g(kt),g(Dt),g(Nt),g(Ft),g(Lt),g(zt),g(It),g(qt),g(Mt),g(Et),g(Rt),g(Ut),g(Ht,e),g(St),g(At),g(Vt,e),g(jt),g(Kt,e),g(Wt),g(Gt),g(Bt),g(Yt),g(Zt),g(Jt),g(Qt),g(Xt),g(ea),g(ta),g(aa),g(na,e),g(oa),g(ra,e),g(la),g(ia),g(sa),g(da),g(ca),g(ma),g(pa),g(ga),g(_a),g(ha),g(ua),g(fa,e),g(va),g(ba,e),g(Ta),g(Oa),g(xa),g($a),g(Pa),g(wa),g(ya),g(Ca),g(ka),g(Da),g(Na),g(Fa),g(La,e),g(za),g(Ia,e),g(qa),g(Ma,e),g(Ea),g(Ra,e),g(Ua)}}}const qm='{"title":"Trainer","local":"trainer","sections":[{"title":"CPOConfig","local":"trl.CPOConfig","sections":[],"depth":2},{"title":"CPOTrainer","local":"trl.CPOTrainer","sections":[],"depth":2},{"title":"DDPOConfig","local":"trl.DDPOConfig","sections":[],"depth":2},{"title":"DDPOTrainer","local":"trl.DDPOTrainer","sections":[],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"IterativeSFTTrainer","local":"trl.IterativeSFTTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"ORPOConfig","local":"trl.ORPOConfig","sections":[],"depth":2},{"title":"ORPOTrainer","local":"trl.ORPOTrainer","sections":[],"depth":2},{"title":"PPOConfig","local":"trl.PPOConfig","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2},{"title":"RewardConfig","local":"trl.RewardConfig","sections":[],"depth":2},{"title":"RewardTrainer","local":"trl.RewardTrainer","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"set_seed","local":"trl.set_seed","sections":[],"depth":2}],"depth":1}';function Mm(Ld){return Nm(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sm extends Fm{constructor(ee){super(),Lm(this,ee,Mm,Im,km,{})}}export{Sm as component};
