import{s as Is,n as Us,o as $s}from"../chunks/scheduler.85c25b89.js";import{S as Zs,i as ks,g as p,s as e,r as m,A as Ws,h as i,f as a,c as n,j as bs,u as o,x as J,k as fs,y as Bs,a as l,v as r,d as h,t as c,w as g}from"../chunks/index.c9bcf812.js";import{C as R}from"../chunks/CodeBlock.94efc595.js";import{H as X}from"../chunks/Heading.3c6e5b17.js";function Cs(hs){let M,Y,Q,_,d,H,w,cs="<strong>HRNet</strong>, or <strong>High-Resolution Net</strong>, is a general purpose convolutional neural network for tasks like semantic segmentation, object detection and image classification. It is able to maintain high resolution representations through the whole process. We start from a high-resolution convolution stream, gradually add high-to-low resolution convolution streams one by one, and connect the multi-resolution streams in parallel. The resulting network consists of several ($4$ in the paper) stages and the $n$th stage contains $n$ streams corresponding to $n$ resolutions. The authors conduct repeated multi-resolution fusions by exchanging the information across the parallel streams over and over.",S,j,z,y,gs="To load a pretrained model:",F,T,A,u,Js="To load and preprocess the image:",L,b,D,f,Ms="To get the model predictions:",P,I,q,U,ds="To get the top-5 predictions class names:",K,$,O,Z,ws="Replace the model name with the variant you want to use, e.g. <code>hrnet_w18</code>. You can find the IDs in the model summaries at the top of this page.",ss,k,js='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ts,W,as,B,ys="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ls,C,es,G,Ts=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,N,ps,x,us='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',is,v,ms,E,os,V,rs;return d=new X({props:{title:"HRNet",local:"hrnet",headingTag:"h1"}}),j=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2hybmV0X3cxOCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;hrnet_w18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),C=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaHJuZXRfdzE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;hrnet_w18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new R({props:{code:"JTQwbWlzYyU3QnN1bjIwMTloaWdocmVzb2x1dGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCSGlnaC1SZXNvbHV0aW9uJTIwUmVwcmVzZW50YXRpb25zJTIwZm9yJTIwTGFiZWxpbmclMjBQaXhlbHMlMjBhbmQlMjBSZWdpb25zJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCS2UlMjBTdW4lMjBhbmQlMjBZYW5nJTIwWmhhbyUyMGFuZCUyMEJvcnVpJTIwSmlhbmclMjBhbmQlMjBUaWFuaGVuZyUyMENoZW5nJTIwYW5kJTIwQmluJTIwWGlhbyUyMGFuZCUyMERvbmclMjBMaXUlMjBhbmQlMjBZYWRvbmclMjBNdSUyMGFuZCUyMFhpbmdnYW5nJTIwV2FuZyUyMGFuZCUyMFdlbnl1JTIwTGl1JTIwYW5kJTIwSmluZ2RvbmclMjBXYW5nJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA0LjA0NTE0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{sun2019highresolution,
      title={High-Resolution Representations for Labeling Pixels <span class="hljs-keyword">and </span>Regions}, 
      author={Ke Sun <span class="hljs-keyword">and </span>Yang Zhao <span class="hljs-keyword">and </span><span class="hljs-keyword">Borui </span><span class="hljs-keyword">Jiang </span><span class="hljs-keyword">and </span>Tianheng Cheng <span class="hljs-keyword">and </span><span class="hljs-keyword">Bin </span>Xiao <span class="hljs-keyword">and </span>Dong Liu <span class="hljs-keyword">and </span>Yadong Mu <span class="hljs-keyword">and </span>Xinggang Wang <span class="hljs-keyword">and </span>Wenyu Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Jingdong </span>Wang},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1904</span>.<span class="hljs-number">04514</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){M=p("meta"),Y=e(),Q=p("p"),_=e(),m(d.$$.fragment),H=e(),w=p("p"),w.innerHTML=cs,S=e(),m(j.$$.fragment),z=e(),y=p("p"),y.textContent=gs,F=e(),m(T.$$.fragment),A=e(),u=p("p"),u.textContent=Js,L=e(),m(b.$$.fragment),D=e(),f=p("p"),f.textContent=Ms,P=e(),m(I.$$.fragment),q=e(),U=p("p"),U.textContent=ds,K=e(),m($.$$.fragment),O=e(),Z=p("p"),Z.innerHTML=ws,ss=e(),k=p("p"),k.innerHTML=js,ts=e(),m(W.$$.fragment),as=e(),B=p("p"),B.textContent=ys,ls=e(),m(C.$$.fragment),es=e(),G=p("p"),G.innerHTML=Ts,ns=e(),m(N.$$.fragment),ps=e(),x=p("p"),x.innerHTML=us,is=e(),m(v.$$.fragment),ms=e(),m(E.$$.fragment),os=e(),V=p("p"),this.h()},l(s){const t=Ws("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(a),Y=n(s),Q=i(s,"P",{}),bs(Q).forEach(a),_=n(s),o(d.$$.fragment,s),H=n(s),w=i(s,"P",{"data-svelte-h":!0}),J(w)!=="svelte-yej87l"&&(w.innerHTML=cs),S=n(s),o(j.$$.fragment,s),z=n(s),y=i(s,"P",{"data-svelte-h":!0}),J(y)!=="svelte-18ywhxh"&&(y.textContent=gs),F=n(s),o(T.$$.fragment,s),A=n(s),u=i(s,"P",{"data-svelte-h":!0}),J(u)!=="svelte-1c2ipa8"&&(u.textContent=Js),L=n(s),o(b.$$.fragment,s),D=n(s),f=i(s,"P",{"data-svelte-h":!0}),J(f)!=="svelte-1n9qsq1"&&(f.textContent=Ms),P=n(s),o(I.$$.fragment,s),q=n(s),U=i(s,"P",{"data-svelte-h":!0}),J(U)!=="svelte-19cnvx1"&&(U.textContent=ds),K=n(s),o($.$$.fragment,s),O=n(s),Z=i(s,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-17maku0"&&(Z.innerHTML=ws),ss=n(s),k=i(s,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1wmi3ea"&&(k.innerHTML=js),ts=n(s),o(W.$$.fragment,s),as=n(s),B=i(s,"P",{"data-svelte-h":!0}),J(B)!=="svelte-9sr7nh"&&(B.textContent=ys),ls=n(s),o(C.$$.fragment,s),es=n(s),G=i(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-1kguc51"&&(G.innerHTML=Ts),ns=n(s),o(N.$$.fragment,s),ps=n(s),x=i(s,"P",{"data-svelte-h":!0}),J(x)!=="svelte-1n0coha"&&(x.innerHTML=us),is=n(s),o(v.$$.fragment,s),ms=n(s),o(E.$$.fragment,s),os=n(s),V=i(s,"P",{}),bs(V).forEach(a),this.h()},h(){fs(M,"name","hf:doc:metadata"),fs(M,"content",Gs)},m(s,t){Bs(document.head,M),l(s,Y,t),l(s,Q,t),l(s,_,t),r(d,s,t),l(s,H,t),l(s,w,t),l(s,S,t),r(j,s,t),l(s,z,t),l(s,y,t),l(s,F,t),r(T,s,t),l(s,A,t),l(s,u,t),l(s,L,t),r(b,s,t),l(s,D,t),l(s,f,t),l(s,P,t),r(I,s,t),l(s,q,t),l(s,U,t),l(s,K,t),r($,s,t),l(s,O,t),l(s,Z,t),l(s,ss,t),l(s,k,t),l(s,ts,t),r(W,s,t),l(s,as,t),l(s,B,t),l(s,ls,t),r(C,s,t),l(s,es,t),l(s,G,t),l(s,ns,t),r(N,s,t),l(s,ps,t),l(s,x,t),l(s,is,t),r(v,s,t),l(s,ms,t),r(E,s,t),l(s,os,t),l(s,V,t),rs=!0},p:Us,i(s){rs||(h(d.$$.fragment,s),h(j.$$.fragment,s),h(T.$$.fragment,s),h(b.$$.fragment,s),h(I.$$.fragment,s),h($.$$.fragment,s),h(W.$$.fragment,s),h(C.$$.fragment,s),h(N.$$.fragment,s),h(v.$$.fragment,s),h(E.$$.fragment,s),rs=!0)},o(s){c(d.$$.fragment,s),c(j.$$.fragment,s),c(T.$$.fragment,s),c(b.$$.fragment,s),c(I.$$.fragment,s),c($.$$.fragment,s),c(W.$$.fragment,s),c(C.$$.fragment,s),c(N.$$.fragment,s),c(v.$$.fragment,s),c(E.$$.fragment,s),rs=!1},d(s){s&&(a(Y),a(Q),a(_),a(H),a(w),a(S),a(z),a(y),a(F),a(A),a(u),a(L),a(D),a(f),a(P),a(q),a(U),a(K),a(O),a(Z),a(ss),a(k),a(ts),a(as),a(B),a(ls),a(es),a(G),a(ns),a(ps),a(x),a(is),a(ms),a(os),a(V)),a(M),g(d,s),g(j,s),g(T,s),g(b,s),g(I,s),g($,s),g(W,s),g(C,s),g(N,s),g(v,s),g(E,s)}}}const Gs='{"title":"HRNet","local":"hrnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Ns(hs){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qs extends Zs{constructor(M){super(),ks(this,M,Ns,Cs,Is,{})}}export{Qs as component};
