import{s as Zs,n as Bs,o as $s}from"../chunks/scheduler.85c25b89.js";import{S as As,i as Ws,g as p,s as e,r as M,A as vs,h as i,f as t,c as n,j as ks,u as o,x as m,k as xs,y as Gs,a,v as c,d as r,t as h,w as y}from"../chunks/index.c9837788.js";import{C as E}from"../chunks/CodeBlock.52fa569e.js";import{H as V}from"../chunks/Heading.3097d2ed.js";function Rs(js){let j,S,Y,_,J,z,g,Js='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',F,d,gs="The models in this collection utilise semi-weakly supervised learning to improve the performance of the model. The approach brings important gains to standard architectures for image, video and fine-grained classification.",H,w,ds="Please note the CC-BY-NC 4.0 license on theses weights, non-commercial use only.",L,T,D,U,ws="To load a pretrained model:",P,u,q,b,Ts="To load and preprocess the image:",K,f,O,C,Us="To get the model predictions:",ss,I,ls,N,us="To get the top-5 predictions class names:",ts,k,as,x,bs="Replace the model name with the variant you want to use, e.g. <code>swsl_resnet18</code>. You can find the IDs in the model summaries at the top of this page.",es,Z,fs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ns,B,ps,$,Cs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",is,A,ms,W,Is=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Ms,v,os,G,Ns='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',cs,R,rs,Q,hs,X,ys;return J=new V({props:{title:"SWSL ResNet",local:"swsl-resnet",headingTag:"h1"}}),T=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new E({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3N3c2xfcmVzbmV0MTgnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;swsl_resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new E({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new E({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),A=new E({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc3dzbF9yZXNuZXQxOCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;swsl_resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),v=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),R=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new E({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTkwNS0wMDU0NiUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3QkkuJTIwWmVraSUyMFlhbG5peiUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEhlcnYlN0IlNUMnJTdCZSU3RCU3RCUyMEolN0IlNUMnJTdCZSU3RCU3RGdvdSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEthbiUyMENoZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNYW5vaGFyJTIwUGFsdXJpJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGhydXYlMjBNYWhhamFuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JCaWxsaW9uLXNjYWxlJTIwc2VtaS1zdXBlcnZpc2VkJTIwbGVhcm5pbmclMjBmb3IlMjBpbWFnZSUyMGNsYXNzaWZpY2F0aW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxOTA1LjAwNTQ2JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTklN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTkwNS4wMDU0NiU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE5MDUuMDA1NDYlN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAyOCUyMFNlcCUyMDIwMjAlMjAwOCUzQTE5JTNBMzclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRmFicy0xOTA1LTAwNTQ2LmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{DBLP:journals/corr/abs-1905-00546,
  author    = {I. Zeki Yalniz and
               Herv{\\&#x27;{e}</span><span class="language-xml">} J</span><span class="hljs-template-variable">{\\&#x27;{e}</span><span class="language-xml">}gou and
               Kan Chen and
               Manohar Paluri and
               Dhruv Mahajan},
  title     = </span><span class="hljs-template-variable">{Billion-scale semi-supervised learning for image classification}</span><span class="language-xml">,
  journal   = </span><span class="hljs-template-variable">{CoRR}</span><span class="language-xml">,
  volume    = </span><span class="hljs-template-variable">{abs/1905.00546}</span><span class="language-xml">,
  year      = </span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
  url       = </span><span class="hljs-template-variable">{http://arxiv.org/abs/1905.00546}</span><span class="language-xml">,
  archivePrefix = </span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
  eprint    = </span><span class="hljs-template-variable">{1905.00546}</span><span class="language-xml">,
  timestamp = </span><span class="hljs-template-variable">{Mon, 28 <span class="hljs-keyword">Sep</span> 2020 08:19:37 +0200}</span><span class="language-xml">,
  biburl    = </span><span class="hljs-template-variable">{https://dblp.org/rec/journals/corr/abs-1905-00546.bib}</span><span class="language-xml">,
  bibsource = </span><span class="hljs-template-variable">{dblp computer science bibliography, https://dblp.org}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){j=p("meta"),S=e(),Y=p("p"),_=e(),M(J.$$.fragment),z=e(),g=p("p"),g.innerHTML=Js,F=e(),d=p("p"),d.textContent=gs,H=e(),w=p("p"),w.textContent=ds,L=e(),M(T.$$.fragment),D=e(),U=p("p"),U.textContent=ws,P=e(),M(u.$$.fragment),q=e(),b=p("p"),b.textContent=Ts,K=e(),M(f.$$.fragment),O=e(),C=p("p"),C.textContent=Us,ss=e(),M(I.$$.fragment),ls=e(),N=p("p"),N.textContent=us,ts=e(),M(k.$$.fragment),as=e(),x=p("p"),x.innerHTML=bs,es=e(),Z=p("p"),Z.innerHTML=fs,ns=e(),M(B.$$.fragment),ps=e(),$=p("p"),$.textContent=Cs,is=e(),M(A.$$.fragment),ms=e(),W=p("p"),W.innerHTML=Is,Ms=e(),M(v.$$.fragment),os=e(),G=p("p"),G.innerHTML=Ns,cs=e(),M(R.$$.fragment),rs=e(),M(Q.$$.fragment),hs=e(),X=p("p"),this.h()},l(s){const l=vs("svelte-u9bgzb",document.head);j=i(l,"META",{name:!0,content:!0}),l.forEach(t),S=n(s),Y=i(s,"P",{}),ks(Y).forEach(t),_=n(s),o(J.$$.fragment,s),z=n(s),g=i(s,"P",{"data-svelte-h":!0}),m(g)!=="svelte-p6ybkz"&&(g.innerHTML=Js),F=n(s),d=i(s,"P",{"data-svelte-h":!0}),m(d)!=="svelte-ya6jib"&&(d.textContent=gs),H=n(s),w=i(s,"P",{"data-svelte-h":!0}),m(w)!=="svelte-ye38bd"&&(w.textContent=ds),L=n(s),o(T.$$.fragment,s),D=n(s),U=i(s,"P",{"data-svelte-h":!0}),m(U)!=="svelte-18ywhxh"&&(U.textContent=ws),P=n(s),o(u.$$.fragment,s),q=n(s),b=i(s,"P",{"data-svelte-h":!0}),m(b)!=="svelte-1c2ipa8"&&(b.textContent=Ts),K=n(s),o(f.$$.fragment,s),O=n(s),C=i(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1n9qsq1"&&(C.textContent=Us),ss=n(s),o(I.$$.fragment,s),ls=n(s),N=i(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-19cnvx1"&&(N.textContent=us),ts=n(s),o(k.$$.fragment,s),as=n(s),x=i(s,"P",{"data-svelte-h":!0}),m(x)!=="svelte-6if2n8"&&(x.innerHTML=bs),es=n(s),Z=i(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=fs),ns=n(s),o(B.$$.fragment,s),ps=n(s),$=i(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-9sr7nh"&&($.textContent=Cs),is=n(s),o(A.$$.fragment,s),ms=n(s),W=i(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1kguc51"&&(W.innerHTML=Is),Ms=n(s),o(v.$$.fragment,s),os=n(s),G=i(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n0coha"&&(G.innerHTML=Ns),cs=n(s),o(R.$$.fragment,s),rs=n(s),o(Q.$$.fragment,s),hs=n(s),X=i(s,"P",{}),ks(X).forEach(t),this.h()},h(){xs(j,"name","hf:doc:metadata"),xs(j,"content",Qs)},m(s,l){Gs(document.head,j),a(s,S,l),a(s,Y,l),a(s,_,l),c(J,s,l),a(s,z,l),a(s,g,l),a(s,F,l),a(s,d,l),a(s,H,l),a(s,w,l),a(s,L,l),c(T,s,l),a(s,D,l),a(s,U,l),a(s,P,l),c(u,s,l),a(s,q,l),a(s,b,l),a(s,K,l),c(f,s,l),a(s,O,l),a(s,C,l),a(s,ss,l),c(I,s,l),a(s,ls,l),a(s,N,l),a(s,ts,l),c(k,s,l),a(s,as,l),a(s,x,l),a(s,es,l),a(s,Z,l),a(s,ns,l),c(B,s,l),a(s,ps,l),a(s,$,l),a(s,is,l),c(A,s,l),a(s,ms,l),a(s,W,l),a(s,Ms,l),c(v,s,l),a(s,os,l),a(s,G,l),a(s,cs,l),c(R,s,l),a(s,rs,l),c(Q,s,l),a(s,hs,l),a(s,X,l),ys=!0},p:Bs,i(s){ys||(r(J.$$.fragment,s),r(T.$$.fragment,s),r(u.$$.fragment,s),r(f.$$.fragment,s),r(I.$$.fragment,s),r(k.$$.fragment,s),r(B.$$.fragment,s),r(A.$$.fragment,s),r(v.$$.fragment,s),r(R.$$.fragment,s),r(Q.$$.fragment,s),ys=!0)},o(s){h(J.$$.fragment,s),h(T.$$.fragment,s),h(u.$$.fragment,s),h(f.$$.fragment,s),h(I.$$.fragment,s),h(k.$$.fragment,s),h(B.$$.fragment,s),h(A.$$.fragment,s),h(v.$$.fragment,s),h(R.$$.fragment,s),h(Q.$$.fragment,s),ys=!1},d(s){s&&(t(S),t(Y),t(_),t(z),t(g),t(F),t(d),t(H),t(w),t(L),t(D),t(U),t(P),t(q),t(b),t(K),t(O),t(C),t(ss),t(ls),t(N),t(ts),t(as),t(x),t(es),t(Z),t(ns),t(ps),t($),t(is),t(ms),t(W),t(Ms),t(os),t(G),t(cs),t(rs),t(hs),t(X)),t(j),y(J,s),y(T,s),y(u,s),y(f,s),y(I,s),y(k,s),y(B,s),y(A,s),y(v,s),y(R,s),y(Q,s)}}}const Qs='{"title":"SWSL ResNet","local":"swsl-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Es(js){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends As{constructor(j){super(),Ws(this,j,Es,Rs,Zs,{})}}export{_s as component};
