import{s as ks,n as $s,o as Ws}from"../chunks/scheduler.85c25b89.js";import{S as Cs,i as Bs,g as p,s as e,r as i,A as Ns,h as m,f as l,c as n,j as Is,u as o,x as c,k as Zs,y as Gs,a,v as r,d as h,t as M,w as d}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.52fa569e.js";import{H as _}from"../chunks/Heading.3097d2ed.js";function xs(Ms){let j,A,X,R,J,F,w,ds='<strong>FBNet</strong> is a type of convolutional neural architectures discovered through <a href="https://paperswithcode.com/method/dnas" rel="nofollow">DNAS</a> neural architecture search. It utilises a basic type of image model block inspired by <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetv2</a> that utilises depthwise convolutions and an inverted residual structure (see components).',S,g,js='The principal building block is the <a href="https://paperswithcode.com/method/fbnet-block" rel="nofollow">FBNet Block</a>.',H,y,z,u,Js="To load a pretrained model:",D,T,L,b,ws="To load and preprocess the image:",q,f,P,U,gs="To get the model predictions:",K,I,O,Z,ys="To get the top-5 predictions class names:",ss,k,ts,$,us="Replace the model name with the variant you want to use, e.g. <code>fbnetc_100</code>. You can find the IDs in the model summaries at the top of this page.",ls,W,Ts='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,C,es,B,bs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ns,N,ps,G,fs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ms,x,is,E,Us='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',os,v,cs,V,rs,Y,hs;return J=new _({props:{title:"FBNet",local:"fbnet",headingTag:"h1"}}),y=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2ZibmV0Y18xMDAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;fbnetc_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),C=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZmJuZXRjXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;fbnetc_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new Q({props:{code:"JTQwbWlzYyU3Qnd1MjAxOWZibmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JGQk5ldCUzQSUyMEhhcmR3YXJlLUF3YXJlJTIwRWZmaWNpZW50JTIwQ29udk5ldCUyMERlc2lnbiUyMHZpYSUyMERpZmZlcmVudGlhYmxlJTIwTmV1cmFsJTIwQXJjaGl0ZWN0dXJlJTIwU2VhcmNoJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQmljaGVuJTIwV3UlMjBhbmQlMjBYaWFvbGlhbmclMjBEYWklMjBhbmQlMjBQZWl6aGFvJTIwWmhhbmclMjBhbmQlMjBZYW5naGFuJTIwV2FuZyUyMGFuZCUyMEZlaSUyMFN1biUyMGFuZCUyMFlpbWluZyUyMFd1JTIwYW5kJTIwWXVhbmRvbmclMjBUaWFuJTIwYW5kJTIwUGV0ZXIlMjBWYWpkYSUyMGFuZCUyMFlhbmdxaW5nJTIwSmlhJTIwYW5kJTIwS3VydCUyMEtldXR6ZXIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE4MTIuMDM0NDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{wu<span class="hljs-symbol">2019f</span>bnet,
      title={FBNet: Hardware-Aware Efficient ConvNet Design via <span class="hljs-keyword">Differentiable </span>Neural Architecture Search}, 
      author={<span class="hljs-keyword">Bichen </span>Wu <span class="hljs-keyword">and </span>Xiaoliang Dai <span class="hljs-keyword">and </span>Peizhao Zhang <span class="hljs-keyword">and </span>Yanghan Wang <span class="hljs-keyword">and </span>Fei Sun <span class="hljs-keyword">and </span>Yiming Wu <span class="hljs-keyword">and </span>Yuandong Tian <span class="hljs-keyword">and </span>Peter Vajda <span class="hljs-keyword">and </span>Yangqing <span class="hljs-keyword">Jia </span><span class="hljs-keyword">and </span>Kurt Keutzer},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1812</span>.<span class="hljs-number">03443</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){j=p("meta"),A=e(),X=p("p"),R=e(),i(J.$$.fragment),F=e(),w=p("p"),w.innerHTML=ds,S=e(),g=p("p"),g.innerHTML=js,H=e(),i(y.$$.fragment),z=e(),u=p("p"),u.textContent=Js,D=e(),i(T.$$.fragment),L=e(),b=p("p"),b.textContent=ws,q=e(),i(f.$$.fragment),P=e(),U=p("p"),U.textContent=gs,K=e(),i(I.$$.fragment),O=e(),Z=p("p"),Z.textContent=ys,ss=e(),i(k.$$.fragment),ts=e(),$=p("p"),$.innerHTML=us,ls=e(),W=p("p"),W.innerHTML=Ts,as=e(),i(C.$$.fragment),es=e(),B=p("p"),B.textContent=bs,ns=e(),i(N.$$.fragment),ps=e(),G=p("p"),G.innerHTML=fs,ms=e(),i(x.$$.fragment),is=e(),E=p("p"),E.innerHTML=Us,os=e(),i(v.$$.fragment),cs=e(),i(V.$$.fragment),rs=e(),Y=p("p"),this.h()},l(s){const t=Ns("svelte-u9bgzb",document.head);j=m(t,"META",{name:!0,content:!0}),t.forEach(l),A=n(s),X=m(s,"P",{}),Is(X).forEach(l),R=n(s),o(J.$$.fragment,s),F=n(s),w=m(s,"P",{"data-svelte-h":!0}),c(w)!=="svelte-112qqgm"&&(w.innerHTML=ds),S=n(s),g=m(s,"P",{"data-svelte-h":!0}),c(g)!=="svelte-u55bao"&&(g.innerHTML=js),H=n(s),o(y.$$.fragment,s),z=n(s),u=m(s,"P",{"data-svelte-h":!0}),c(u)!=="svelte-18ywhxh"&&(u.textContent=Js),D=n(s),o(T.$$.fragment,s),L=n(s),b=m(s,"P",{"data-svelte-h":!0}),c(b)!=="svelte-1c2ipa8"&&(b.textContent=ws),q=n(s),o(f.$$.fragment,s),P=n(s),U=m(s,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1n9qsq1"&&(U.textContent=gs),K=n(s),o(I.$$.fragment,s),O=n(s),Z=m(s,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-19cnvx1"&&(Z.textContent=ys),ss=n(s),o(k.$$.fragment,s),ts=n(s),$=m(s,"P",{"data-svelte-h":!0}),c($)!=="svelte-18ctdhs"&&($.innerHTML=us),ls=n(s),W=m(s,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1wmi3ea"&&(W.innerHTML=Ts),as=n(s),o(C.$$.fragment,s),es=n(s),B=m(s,"P",{"data-svelte-h":!0}),c(B)!=="svelte-9sr7nh"&&(B.textContent=bs),ns=n(s),o(N.$$.fragment,s),ps=n(s),G=m(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1kguc51"&&(G.innerHTML=fs),ms=n(s),o(x.$$.fragment,s),is=n(s),E=m(s,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1n0coha"&&(E.innerHTML=Us),os=n(s),o(v.$$.fragment,s),cs=n(s),o(V.$$.fragment,s),rs=n(s),Y=m(s,"P",{}),Is(Y).forEach(l),this.h()},h(){Zs(j,"name","hf:doc:metadata"),Zs(j,"content",Es)},m(s,t){Gs(document.head,j),a(s,A,t),a(s,X,t),a(s,R,t),r(J,s,t),a(s,F,t),a(s,w,t),a(s,S,t),a(s,g,t),a(s,H,t),r(y,s,t),a(s,z,t),a(s,u,t),a(s,D,t),r(T,s,t),a(s,L,t),a(s,b,t),a(s,q,t),r(f,s,t),a(s,P,t),a(s,U,t),a(s,K,t),r(I,s,t),a(s,O,t),a(s,Z,t),a(s,ss,t),r(k,s,t),a(s,ts,t),a(s,$,t),a(s,ls,t),a(s,W,t),a(s,as,t),r(C,s,t),a(s,es,t),a(s,B,t),a(s,ns,t),r(N,s,t),a(s,ps,t),a(s,G,t),a(s,ms,t),r(x,s,t),a(s,is,t),a(s,E,t),a(s,os,t),r(v,s,t),a(s,cs,t),r(V,s,t),a(s,rs,t),a(s,Y,t),hs=!0},p:$s,i(s){hs||(h(J.$$.fragment,s),h(y.$$.fragment,s),h(T.$$.fragment,s),h(f.$$.fragment,s),h(I.$$.fragment,s),h(k.$$.fragment,s),h(C.$$.fragment,s),h(N.$$.fragment,s),h(x.$$.fragment,s),h(v.$$.fragment,s),h(V.$$.fragment,s),hs=!0)},o(s){M(J.$$.fragment,s),M(y.$$.fragment,s),M(T.$$.fragment,s),M(f.$$.fragment,s),M(I.$$.fragment,s),M(k.$$.fragment,s),M(C.$$.fragment,s),M(N.$$.fragment,s),M(x.$$.fragment,s),M(v.$$.fragment,s),M(V.$$.fragment,s),hs=!1},d(s){s&&(l(A),l(X),l(R),l(F),l(w),l(S),l(g),l(H),l(z),l(u),l(D),l(L),l(b),l(q),l(P),l(U),l(K),l(O),l(Z),l(ss),l(ts),l($),l(ls),l(W),l(as),l(es),l(B),l(ns),l(ps),l(G),l(ms),l(is),l(E),l(os),l(cs),l(rs),l(Y)),l(j),d(J,s),d(y,s),d(T,s),d(f,s),d(I,s),d(k,s),d(C,s),d(N,s),d(x,s),d(v,s),d(V,s)}}}const Es='{"title":"FBNet","local":"fbnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function vs(Ms){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends Cs{constructor(j){super(),Bs(this,j,vs,xs,ks,{})}}export{_s as component};
